/***********************************************************************
*
* Copyright (c) 2012-2026 Barbara Geller
* Copyright (c) 2012-2026 Ansel Sermersheim
*
* Copyright (c) 2015 The Qt Company Ltd.
* Copyright (c) 2012-2016 Digia Plc and/or its subsidiary(-ies).
* Copyright (c) 2008-2012 Nokia Corporation and/or its subsidiary(-ies).
*
* This file is part of CopperSpice.
*
* CopperSpice is free software. You can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* version 2.1 as published by the Free Software Foundation.
*
* CopperSpice is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://www.gnu.org/licenses/
*
***********************************************************************/

// Generated code, do not edit! Use generator at tools/qtconcurrent/generaterun/

#ifndef QTCONCURRENTSTOREDFUNCTIONCALL_H
#define QTCONCURRENTSTOREDFUNCTIONCALL_H

#include <qglobal.h>
#include <qtconcurrentrunbase.h>

namespace QtConcurrent {

template <typename T, typename FunctionPointer>
struct StoredFunctorCall0 : public RunFunctionTask<T>
{
   StoredFunctorCall0(FunctionPointer _function)
      : function(_function)
   { }

   void runFunctor() override {
      this->result = function();
   }

   FunctionPointer function;
};

template <typename FunctionPointer>
struct StoredFunctorCall0<void, FunctionPointer> : public RunFunctionTask<void>
{
   StoredFunctorCall0(FunctionPointer _function)
      : function(_function)
   { }

   void runFunctor() override {
      function();
   }

   FunctionPointer function;
};

template <typename T, typename FunctionPointer>
struct StoredFunctorPointerCall0: public RunFunctionTask<T>
{
   StoredFunctorPointerCall0(FunctionPointer *_function)
      : function(_function)
   { }

   void runFunctor() override {
      this->result = (*function)();
   }

   FunctionPointer *function;
};

template <typename T, typename FunctionPointer>
struct VoidStoredFunctorPointerCall0: public RunFunctionTask<T>
{
   VoidStoredFunctorPointerCall0(FunctionPointer *_function)
      : function(_function)
   { }

   void runFunctor() override {
      (*function)();
   }

   FunctionPointer *function;
};

template <typename T, typename FunctionPointer>
struct SelectStoredFunctorPointerCall0
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredFunctorPointerCall0<T, FunctionPointer>,
         VoidStoredFunctorPointerCall0<T, FunctionPointer> >::type;
};

template <typename T, typename Class>
class StoredMemberFunctionCall0 : public RunFunctionTask<T>
{
 public:
   StoredMemberFunctionCall0(T (Class::*_fn)(), const Class &_object)
      : fn(_fn), object(_object)
   { }

   void runFunctor() override {
      this->result = (object.*fn)();
   }

 private:
   T (Class::*fn)();
   Class object;
};

template <typename T, typename Class>
class VoidStoredMemberFunctionCall0 : public RunFunctionTask<T>
{
 public:
   VoidStoredMemberFunctionCall0(T (Class::*_fn)(), const Class &_object)
      : fn(_fn), object(_object)
   { }

   void runFunctor() override {
      (object.*fn)();
   }

 private:
   T (Class::*fn)();
   Class object;
};

template <typename T, typename Class>
struct SelectStoredMemberFunctionCall0 {
   using type = typename SelectSpecialization<T>::template
         Type<StoredMemberFunctionCall0<T, Class>,
         VoidStoredMemberFunctionCall0<T, Class>>::type;
};

template <typename T, typename Class>
class StoredConstMemberFunctionCall0 : public RunFunctionTask<T>
{
 public:
   StoredConstMemberFunctionCall0(T (Class::*_fn)() const, const Class &_object)
      : fn(_fn), object(_object)
   { }

   void runFunctor() override {
      this->result = (object.*fn)();
   }

 private:
   T (Class::*fn)()const;
   const Class object;
};

template <typename T, typename Class>
class VoidStoredConstMemberFunctionCall0 : public RunFunctionTask<T>
{
 public:
   VoidStoredConstMemberFunctionCall0(T (Class::*_fn)() const, const Class &_object)
      : fn(_fn), object(_object)
   { }

   void runFunctor() override {
      (object.*fn)();
   }

 private:
   T (Class::*fn)()const;
   const Class object;
};

template <typename T, typename Class>
struct SelectStoredConstMemberFunctionCall0
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredConstMemberFunctionCall0<T, Class>,
         VoidStoredConstMemberFunctionCall0<T, Class>>::type;
};

template <typename T, typename Class>
class StoredMemberFunctionPointerCall0 : public RunFunctionTask<T>
{
 public:
   StoredMemberFunctionPointerCall0(T (Class::*_fn)(), Class *_object)
      : fn(_fn), object(_object)
   { }

   void runFunctor() override {
      this->result = (object->*fn)();
   }

 private:
   T (Class::*fn)();
   Class *object;

};
template <typename T, typename Class>
class VoidStoredMemberFunctionPointerCall0 : public RunFunctionTask<T>
{
 public:
   VoidStoredMemberFunctionPointerCall0(T (Class::*_fn)(), Class *_object)
      : fn(_fn), object(_object)
   { }

   void runFunctor() override {
      (object->*fn)();
   }

 private:
   T (Class::*fn)();
   Class *object;

};

template <typename T, typename Class>
struct SelectStoredMemberFunctionPointerCall0
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredMemberFunctionPointerCall0<T, Class>,
         VoidStoredMemberFunctionPointerCall0<T, Class>>::type;
};

template <typename T, typename Class>
class StoredConstMemberFunctionPointerCall0 : public RunFunctionTask<T>
{
 public:
   StoredConstMemberFunctionPointerCall0(T (Class::*_fn)() const, Class const *_object)
      : fn(_fn), object(_object)
   { }

   void runFunctor() override {
      this->result = (object->*fn)();
   }

 private:
   T (Class::*fn)()const;
   Class const *object;
};

template <typename T, typename Class>
class VoidStoredConstMemberFunctionPointerCall0 : public RunFunctionTask<T>
{
 public:
   VoidStoredConstMemberFunctionPointerCall0(T (Class::*_fn)() const, Class const *_object)
      : fn(_fn), object(_object)
   { }

   void runFunctor() override {
      (object->*fn)();
   }

 private:
   T (Class::*fn)()const;
   Class const *object;
};

template <typename T, typename Class>
struct SelectStoredConstMemberFunctionPointerCall0
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredConstMemberFunctionPointerCall0<T, Class>,
         VoidStoredConstMemberFunctionPointerCall0<T, Class>>::type;
};

template <typename T, typename FunctionPointer, typename Arg1>
struct StoredFunctorCall1: public RunFunctionTask<T>
{
   StoredFunctorCall1(FunctionPointer _function, const Arg1 &_arg1)
      : function(_function), arg1(_arg1)
   { }

   void runFunctor() override {
      this->result = function(arg1);
   }

   FunctionPointer function;
   Arg1 arg1;
};

template <typename FunctionPointer, typename Arg1>
struct StoredFunctorCall1<void, FunctionPointer, Arg1>: public RunFunctionTask<void>
{
   StoredFunctorCall1(FunctionPointer _function, const Arg1 &_arg1)
      : function(_function), arg1(_arg1)
   { }

   void runFunctor() override {
      function(arg1);
   }

   FunctionPointer function;
   Arg1 arg1;
};

template <typename T, typename FunctionPointer, typename Arg1>
struct StoredFunctorPointerCall1: public RunFunctionTask<T>
{
   StoredFunctorPointerCall1(FunctionPointer *_function, const Arg1 &_arg1)
      : function(_function), arg1(_arg1)
    { }

   void runFunctor() override {
      this->result = (*function)(arg1);
   }

   FunctionPointer *function;
   Arg1 arg1;
};

template <typename T, typename FunctionPointer, typename Arg1>
struct VoidStoredFunctorPointerCall1: public RunFunctionTask<T>
{
   VoidStoredFunctorPointerCall1(FunctionPointer *_function, const Arg1 &_arg1)
      : function(_function), arg1(_arg1)
   { }

   void runFunctor() override {
      (*function)(arg1);
   }

   FunctionPointer *function;
   Arg1 arg1;
};

template <typename T, typename FunctionPointer, typename Arg1>
struct SelectStoredFunctorPointerCall1
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredFunctorPointerCall1<T, FunctionPointer, Arg1>,
         VoidStoredFunctorPointerCall1<T, FunctionPointer, Arg1>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1>
class StoredMemberFunctionCall1 : public RunFunctionTask<T>
{
 public:
   StoredMemberFunctionCall1(T (Class::*_fn)(Param1), const Class &_object, const Arg1 &_arg1)
      : fn(_fn), object(_object), arg1(_arg1)
   { }

   void runFunctor() override {
      this->result = (object.*fn)(arg1);
   }

 private:
   T (Class::*fn)(Param1);
   Class object;
   Arg1 arg1;
};

template <typename T, typename Class, typename Param1, typename Arg1>
class VoidStoredMemberFunctionCall1 : public RunFunctionTask<T>
{
 public:
   VoidStoredMemberFunctionCall1(T (Class::*_fn)(Param1), const Class &_object, const Arg1 &_arg1)
      : fn(_fn), object(_object), arg1(_arg1)
   { }

   void runFunctor() override {
      (object.*fn)(arg1);
   }

 private:
   T (Class::*fn)(Param1);
   Class object;
   Arg1 arg1;
};

template <typename T, typename Class, typename Param1, typename Arg1>
struct SelectStoredMemberFunctionCall1 {
   using type = typename SelectSpecialization<T>::template
         Type<StoredMemberFunctionCall1<T, Class, Param1, Arg1>,
         VoidStoredMemberFunctionCall1<T, Class, Param1, Arg1>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1>
class StoredConstMemberFunctionCall1 : public RunFunctionTask<T>
{
 public:
   StoredConstMemberFunctionCall1(T (Class::*_fn)(Param1) const, const Class &_object, const Arg1 &_arg1)
      : fn(_fn), object(_object), arg1(_arg1)
    { }

   void runFunctor() override {
      this->result = (object.*fn)(arg1);
   }

 private:
   T (Class::*fn)(Param1)const;
   const Class object;
   Arg1 arg1;
};

template <typename T, typename Class, typename Param1, typename Arg1>
class VoidStoredConstMemberFunctionCall1 : public RunFunctionTask<T>
{
 public:
   VoidStoredConstMemberFunctionCall1(T (Class::*_fn)(Param1) const, const Class &_object, const Arg1 &_arg1)
      : fn(_fn), object(_object), arg1(_arg1)
   { }

   void runFunctor() override {
      (object.*fn)(arg1);
   }

 private:
   T (Class::*fn)(Param1)const;
   const Class object;
   Arg1 arg1;
};

template <typename T, typename Class, typename Param1, typename Arg1>
struct SelectStoredConstMemberFunctionCall1 {
   using type = typename SelectSpecialization<T>::template
         Type<StoredConstMemberFunctionCall1<T, Class, Param1, Arg1>,
         VoidStoredConstMemberFunctionCall1<T, Class, Param1, Arg1>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1>
class StoredMemberFunctionPointerCall1 : public RunFunctionTask<T>
{
 public:
   StoredMemberFunctionPointerCall1(T (Class::*_fn)(Param1), Class *_object, const Arg1 &_arg1)
      : fn(_fn), object(_object), arg1(_arg1)
   { }

   void runFunctor() override {
      this->result = (object->*fn)(arg1);
   }

 private:
   T (Class::*fn)(Param1);
   Class *object;
   Arg1 arg1;
};

template <typename T, typename Class, typename Param1, typename Arg1>
class VoidStoredMemberFunctionPointerCall1 : public RunFunctionTask<T>
{
 public:
   VoidStoredMemberFunctionPointerCall1(T (Class::*_fn)(Param1), Class *_object, const Arg1 &_arg1)
      : fn(_fn), object(_object), arg1(_arg1)
   { }

   void runFunctor() override {
      (object->*fn)(arg1);
   }

 private:
   T (Class::*fn)(Param1);
   Class *object;
   Arg1 arg1;
};

template <typename T, typename Class, typename Param1, typename Arg1>
struct SelectStoredMemberFunctionPointerCall1
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredMemberFunctionPointerCall1<T, Class, Param1, Arg1>,
         VoidStoredMemberFunctionPointerCall1<T, Class, Param1, Arg1>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1>
class StoredConstMemberFunctionPointerCall1 : public RunFunctionTask<T>
{
 public:
   StoredConstMemberFunctionPointerCall1(T (Class::*_fn)(Param1) const, Class const *_object, const Arg1 &_arg1)
      : fn(_fn), object(_object), arg1(_arg1)
   { }

   void runFunctor() override {
      this->result = (object->*fn)(arg1);
   }

 private:
   T (Class::*fn)(Param1)const;
   Class const *object;
   Arg1 arg1;
};

template <typename T, typename Class, typename Param1, typename Arg1>
class VoidStoredConstMemberFunctionPointerCall1 : public RunFunctionTask<T>
{
 public:
   VoidStoredConstMemberFunctionPointerCall1(T (Class::*_fn)(Param1) const, Class const *_object, const Arg1 &_arg1)
      : fn(_fn), object(_object), arg1(_arg1)
   { }

   void runFunctor() override {
      (object->*fn)(arg1);
   }

 private:
   T (Class::*fn)(Param1)const;
   Class const *object;
   Arg1 arg1;
};

template <typename T, typename Class, typename Param1, typename Arg1>
struct SelectStoredConstMemberFunctionPointerCall1
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredConstMemberFunctionPointerCall1<T, Class, Param1, Arg1>,
         VoidStoredConstMemberFunctionPointerCall1<T, Class, Param1, Arg1>>::type;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2>
struct StoredFunctorCall2: public RunFunctionTask<T>
{
   StoredFunctorCall2(FunctionPointer _function, const Arg1 &_arg1, const Arg2 &_arg2)
      : function(_function), arg1(_arg1), arg2(_arg2)
   { }

   void runFunctor() override {
      this->result = function(arg1, arg2);
   }

   FunctionPointer function;
   Arg1 arg1;
   Arg2 arg2;
};

template <typename FunctionPointer, typename Arg1, typename Arg2>
struct StoredFunctorCall2<void, FunctionPointer, Arg1, Arg2>: public RunFunctionTask<void>
{
   StoredFunctorCall2(FunctionPointer _function, const Arg1 &_arg1, const Arg2 &_arg2)
      : function(_function), arg1(_arg1), arg2(_arg2)
   { }

   void runFunctor() override  {
      function(arg1, arg2);
   }

   FunctionPointer function;
   Arg1 arg1;
   Arg2 arg2;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2>
struct StoredFunctorPointerCall2: public RunFunctionTask<T>
{
   StoredFunctorPointerCall2(FunctionPointer *_function, const Arg1 &_arg1, const Arg2 &_arg2)
      : function(_function), arg1(_arg1), arg2(_arg2)
   { }

   void runFunctor() override {
      this->result = (*function)(arg1, arg2);
   }

   FunctionPointer *function;
   Arg1 arg1;
   Arg2 arg2;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2>
struct VoidStoredFunctorPointerCall2: public RunFunctionTask<T>
{
   VoidStoredFunctorPointerCall2(FunctionPointer *_function, const Arg1 &_arg1, const Arg2 &_arg2)
      : function(_function), arg1(_arg1), arg2(_arg2)
   { }

   void runFunctor() override {
      (*function)(arg1, arg2);
   }

   FunctionPointer *function;
   Arg1 arg1;
   Arg2 arg2;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2>
struct SelectStoredFunctorPointerCall2 {
   using type = typename SelectSpecialization<T>::template
         Type<StoredFunctorPointerCall2<T, FunctionPointer, Arg1, Arg2>,
         VoidStoredFunctorPointerCall2<T, FunctionPointer, Arg1, Arg2>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2>
class StoredMemberFunctionCall2 : public RunFunctionTask<T>
{
 public:
   StoredMemberFunctionCall2(T (Class::*_fn)(Param1, Param2), const Class &_object, const Arg1 &_arg1, const Arg2 &_arg2)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2)
   { }

   void runFunctor() override {
      this->result = (object.*fn)(arg1, arg2);
   }

 private:
   T (Class::*fn)(Param1, Param2);
   Class object;
   Arg1 arg1;
   Arg2 arg2;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2>
class VoidStoredMemberFunctionCall2 : public RunFunctionTask<T>
{
 public:
   VoidStoredMemberFunctionCall2(T (Class::*_fn)(Param1, Param2), const Class &_object, const Arg1 &_arg1, const Arg2 &_arg2)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2)
    { }

   void runFunctor() override {
      (object.*fn)(arg1, arg2);
   }

 private:
   T (Class::*fn)(Param1, Param2);
   Class object;
   Arg1 arg1;
   Arg2 arg2;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2>
struct SelectStoredMemberFunctionCall2 {
   using type = typename SelectSpecialization<T>::template
         Type<StoredMemberFunctionCall2<T, Class, Param1, Arg1, Param2, Arg2>,
         VoidStoredMemberFunctionCall2<T, Class, Param1, Arg1, Param2, Arg2>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2>
class StoredConstMemberFunctionCall2 : public RunFunctionTask<T>
{
 public:
   StoredConstMemberFunctionCall2(T (Class::*_fn)(Param1, Param2) const, const Class &_object, const Arg1 &_arg1,
         const Arg2 &_arg2)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2)
   { }

   void runFunctor() override {
      this->result = (object.*fn)(arg1, arg2);
   }

 private:
   T (Class::*fn)(Param1, Param2)const;
   const Class object;
   Arg1 arg1;
   Arg2 arg2;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2>
class VoidStoredConstMemberFunctionCall2 : public RunFunctionTask<T>
{
 public:
   VoidStoredConstMemberFunctionCall2(T (Class::*_fn)(Param1, Param2) const, const Class &_object, const Arg1 &_arg1,
         const Arg2 &_arg2)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2)
   { }

   void runFunctor() override {
      (object.*fn)(arg1, arg2);
   }

 private:
   T (Class::*fn)(Param1, Param2)const;
   const Class object;
   Arg1 arg1;
   Arg2 arg2;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2>
struct SelectStoredConstMemberFunctionCall2 {
   using type = typename SelectSpecialization<T>::template
         Type<StoredConstMemberFunctionCall2<T, Class, Param1, Arg1, Param2, Arg2>,
         VoidStoredConstMemberFunctionCall2<T, Class, Param1, Arg1, Param2, Arg2>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2>
class StoredMemberFunctionPointerCall2 : public RunFunctionTask<T>
{
 public:
   StoredMemberFunctionPointerCall2(T (Class::*_fn)(Param1, Param2), Class *_object, const Arg1 &_arg1, const Arg2 &_arg2)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2)
   { }

   void runFunctor() override {
      this->result = (object->*fn)(arg1, arg2);
   }

 private:
   T (Class::*fn)(Param1, Param2);
   Class *object;
   Arg1 arg1;
   Arg2 arg2;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2>
class VoidStoredMemberFunctionPointerCall2 : public RunFunctionTask<T>
{
 public:
   VoidStoredMemberFunctionPointerCall2(T (Class::*_fn)(Param1, Param2), Class *_object, const Arg1 &_arg1,
         const Arg2 &_arg2)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2)
   { }

   void runFunctor() override {
      (object->*fn)(arg1, arg2);
   }

 private:
   T (Class::*fn)(Param1, Param2);
   Class *object;
   Arg1 arg1;
   Arg2 arg2;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2>
struct SelectStoredMemberFunctionPointerCall2 {
   using type = typename SelectSpecialization<T>::template
         Type<StoredMemberFunctionPointerCall2<T, Class, Param1, Arg1, Param2, Arg2>,
         VoidStoredMemberFunctionPointerCall2<T, Class, Param1, Arg1, Param2, Arg2>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2>
class StoredConstMemberFunctionPointerCall2 : public RunFunctionTask<T>
{
 public:
   StoredConstMemberFunctionPointerCall2(T (Class::*_fn)(Param1, Param2) const, Class const *_object, const Arg1 &_arg1,
         const Arg2 &_arg2)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2)
   { }

   void runFunctor() override  {
      this->result = (object->*fn)(arg1, arg2);
   }

 private:
   T (Class::*fn)(Param1, Param2)const;
   Class const *object;
   Arg1 arg1;
   Arg2 arg2;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2>
class VoidStoredConstMemberFunctionPointerCall2 : public RunFunctionTask<T>
{
 public:
   VoidStoredConstMemberFunctionPointerCall2(T (Class::*_fn)(Param1, Param2) const, Class const *_object,
         const Arg1 &_arg1, const Arg2 &_arg2)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2)
   { }

   void runFunctor() override {
      (object->*fn)(arg1, arg2);
   }

 private:
   T (Class::*fn)(Param1, Param2)const;
   Class const *object;
   Arg1 arg1;
   Arg2 arg2;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2>
struct SelectStoredConstMemberFunctionPointerCall2 {
   using type = typename SelectSpecialization<T>::template
         Type<StoredConstMemberFunctionPointerCall2<T, Class, Param1, Arg1, Param2, Arg2>,
         VoidStoredConstMemberFunctionPointerCall2<T, Class, Param1, Arg1, Param2, Arg2>>::type;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3>
struct StoredFunctorCall3: public RunFunctionTask<T> {
   StoredFunctorCall3(FunctionPointer _function, const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3)
      : function(_function), arg1(_arg1), arg2(_arg2), arg3(_arg3)
   { }

   void runFunctor() override {
      this->result = function(arg1, arg2, arg3);
   }

   FunctionPointer function;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
};

template <typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3>
struct StoredFunctorCall3<void, FunctionPointer, Arg1, Arg2, Arg3>: public RunFunctionTask<void> {
   StoredFunctorCall3(FunctionPointer _function, const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3)
      : function(_function), arg1(_arg1), arg2(_arg2), arg3(_arg3)
   { }

   void runFunctor() override {
      function(arg1, arg2, arg3);
   }

   FunctionPointer function;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3>
struct StoredFunctorPointerCall3: public RunFunctionTask<T>
{
   StoredFunctorPointerCall3(FunctionPointer *_function, const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3)
      : function(_function), arg1(_arg1), arg2(_arg2), arg3(_arg3)
   { }

   void runFunctor() override {
      this->result = (*function)(arg1, arg2, arg3);
   }

   FunctionPointer *function;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3>
struct VoidStoredFunctorPointerCall3: public RunFunctionTask<T>
{
   VoidStoredFunctorPointerCall3(FunctionPointer *_function, const Arg1 &_arg1, const Arg2 &_arg2,
         const Arg3 &_arg3)
      : function(_function), arg1(_arg1), arg2(_arg2), arg3(_arg3)
   { }

   void runFunctor() override {
      (*function)(arg1, arg2, arg3);
   }

   FunctionPointer *function;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3>
struct SelectStoredFunctorPointerCall3
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredFunctorPointerCall3    <T, FunctionPointer, Arg1, Arg2, Arg3>,
         VoidStoredFunctorPointerCall3<T, FunctionPointer, Arg1, Arg2, Arg3>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3>
class StoredMemberFunctionCall3 : public RunFunctionTask<T>
{
 public:
   StoredMemberFunctionCall3(T (Class::*_fn)(Param1, Param2, Param3), const Class &_object, const Arg1 &_arg1,
         const Arg2 &_arg2, const Arg3 &_arg3)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3)
   { }

   void runFunctor() override {
      this->result = (object.*fn)(arg1, arg2, arg3);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3);
   Class object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3>
class VoidStoredMemberFunctionCall3 : public RunFunctionTask<T>
{
 public:
   VoidStoredMemberFunctionCall3(T (Class::*_fn)(Param1, Param2, Param3), const Class &_object, const Arg1 &_arg1,
         const Arg2 &_arg2, const Arg3 &_arg3)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3)
   { }

   void runFunctor() override {
      (object.*fn)(arg1, arg2, arg3);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3);
   Class object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3>
struct SelectStoredMemberFunctionCall3
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredMemberFunctionCall3<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3>,
         VoidStoredMemberFunctionCall3<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3>
class StoredConstMemberFunctionCall3 : public RunFunctionTask<T>
{
 public:
   StoredConstMemberFunctionCall3(T (Class::*_fn)(Param1, Param2, Param3) const, const Class &_object, const Arg1 &_arg1,
         const Arg2 &_arg2, const Arg3 &_arg3)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3)
   { }

   void runFunctor() override {
      this->result = (object.*fn)(arg1, arg2, arg3);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3)const;
   const Class object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3>
class VoidStoredConstMemberFunctionCall3 : public RunFunctionTask<T>
{
 public:
   VoidStoredConstMemberFunctionCall3(T (Class::*_fn)(Param1, Param2, Param3) const, const Class &_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3)
   { }

   void runFunctor() override {
      (object.*fn)(arg1, arg2, arg3);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3)const;
   const Class object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3>
struct SelectStoredConstMemberFunctionCall3
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredConstMemberFunctionCall3<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3>,
         VoidStoredConstMemberFunctionCall3<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2, typename Param3, typename Arg3>
class StoredMemberFunctionPointerCall3 : public RunFunctionTask<T>
{
 public:
   StoredMemberFunctionPointerCall3(T (Class::*_fn)(Param1, Param2, Param3), Class *_object, const Arg1 &_arg1,
         const Arg2 &_arg2, const Arg3 &_arg3)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3)
   { }

   void runFunctor() override {
      this->result = (object->*fn)(arg1, arg2, arg3);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3);
   Class *object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3>
class VoidStoredMemberFunctionPointerCall3 : public RunFunctionTask<T>
{
 public:
   VoidStoredMemberFunctionPointerCall3(T (Class::*_fn)(Param1, Param2, Param3), Class *_object, const Arg1 &_arg1,
         const Arg2 &_arg2, const Arg3 &_arg3)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3)
   { }

   void runFunctor() override {
      (object->*fn)(arg1, arg2, arg3);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3);
   Class *object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3>
struct SelectStoredMemberFunctionPointerCall3
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredMemberFunctionPointerCall3<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3>,
         VoidStoredMemberFunctionPointerCall3<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3>
class StoredConstMemberFunctionPointerCall3 : public RunFunctionTask<T>
{
 public:
   StoredConstMemberFunctionPointerCall3(T (Class::*_fn)(Param1, Param2, Param3) const, Class const *_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3)
    { }

   void runFunctor() override {
      this->result = (object->*fn)(arg1, arg2, arg3);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3)const;
   Class const *object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3>
class VoidStoredConstMemberFunctionPointerCall3 : public RunFunctionTask<T>
{
 public:
   VoidStoredConstMemberFunctionPointerCall3(T (Class::*_fn)(Param1, Param2, Param3) const, Class const *_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3)
    { }

   void runFunctor() override {
      (object->*fn)(arg1, arg2, arg3);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3)const;
   Class const *object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3>
struct SelectStoredConstMemberFunctionPointerCall3
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredConstMemberFunctionPointerCall3<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3>,
         VoidStoredConstMemberFunctionPointerCall3<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3>>::type;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2,
      typename Arg3, typename Arg4>
struct StoredFunctorCall4: public RunFunctionTask<T>
{
   StoredFunctorCall4(FunctionPointer _function, const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3,
         const Arg4 &_arg4)
      : function(_function), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4)
   { }

   void runFunctor() override {
      this->result = function(arg1, arg2, arg3, arg4);
   }

   FunctionPointer function;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
};

template <typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
struct StoredFunctorCall4<void, FunctionPointer, Arg1, Arg2, Arg3, Arg4>: public RunFunctionTask<void> {
   StoredFunctorCall4(FunctionPointer _function, const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3,
         const Arg4 &_arg4)
      : function(_function), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4)
   { }

   void runFunctor() override {
      function(arg1, arg2, arg3, arg4);
   }

   FunctionPointer function;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
struct StoredFunctorPointerCall4: public RunFunctionTask<T> {
   StoredFunctorPointerCall4(FunctionPointer *_function, const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3,
         const Arg4 &_arg4)
      : function(_function), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4)
    { }

   void runFunctor() override {
      this->result = (*function)(arg1, arg2, arg3, arg4);
   }

   FunctionPointer *function;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
struct VoidStoredFunctorPointerCall4: public RunFunctionTask<T>
{
   VoidStoredFunctorPointerCall4(FunctionPointer *_function, const Arg1 &_arg1, const Arg2 &_arg2,
         const Arg3 &_arg3, const Arg4 &_arg4)
      : function(_function), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4)
    { }

   void runFunctor() override {
      (*function)(arg1, arg2, arg3, arg4);
   }

   FunctionPointer *function;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
struct SelectStoredFunctorPointerCall4
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredFunctorPointerCall4    <T, FunctionPointer, Arg1, Arg2, Arg3, Arg4>,
         VoidStoredFunctorPointerCall4<T, FunctionPointer, Arg1, Arg2, Arg3, Arg4>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4>
class StoredMemberFunctionCall4 : public RunFunctionTask<T>
{
 public:
   StoredMemberFunctionCall4(T (Class::*_fn)(Param1, Param2, Param3, Param4), const Class &_object, const Arg1 &_arg1,
         const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4)
    { }

   void runFunctor() override {
      this->result = (object.*fn)(arg1, arg2, arg3, arg4);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4);
   Class object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4>
class VoidStoredMemberFunctionCall4 : public RunFunctionTask<T>
{
 public:
   VoidStoredMemberFunctionCall4(T (Class::*_fn)(Param1, Param2, Param3, Param4), const Class &_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4)
   { }

   void runFunctor() override {
      (object.*fn)(arg1, arg2, arg3, arg4);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4);
   Class object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4>
struct SelectStoredMemberFunctionCall4
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredMemberFunctionCall4<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3, Param4, Arg4>,
         VoidStoredMemberFunctionCall4<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3, Param4, Arg4>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4>
class StoredConstMemberFunctionCall4 : public RunFunctionTask<T>
{
 public:
   StoredConstMemberFunctionCall4(T (Class::*_fn)(Param1, Param2, Param3, Param4) const, const Class &_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4)
   { }

   void runFunctor() override {
      this->result = (object.*fn)(arg1, arg2, arg3, arg4);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4)const;
   const Class object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4>
class VoidStoredConstMemberFunctionCall4 : public RunFunctionTask<T>
{
 public:
   VoidStoredConstMemberFunctionCall4(T (Class::*_fn)(Param1, Param2, Param3, Param4) const, const Class &_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4)
   { }

   void runFunctor() override {
      (object.*fn)(arg1, arg2, arg3, arg4);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4)const;
   const Class object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4>
struct SelectStoredConstMemberFunctionCall4 {
  using type = typename SelectSpecialization<T>::template
         Type<StoredConstMemberFunctionCall4<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3, Param4, Arg4>,
         VoidStoredConstMemberFunctionCall4<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3, Param4, Arg4>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4>
class StoredMemberFunctionPointerCall4 : public RunFunctionTask<T>
{
 public:
   StoredMemberFunctionPointerCall4(T (Class::*_fn)(Param1, Param2, Param3, Param4), Class *_object, const Arg1 &_arg1,
         const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4)
    { }

   void runFunctor() override {
      this->result = (object->*fn)(arg1, arg2, arg3, arg4);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4);
   Class *object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4>
class VoidStoredMemberFunctionPointerCall4 : public RunFunctionTask<T>
{
 public:
   VoidStoredMemberFunctionPointerCall4(T (Class::*_fn)(Param1, Param2, Param3, Param4), Class *_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4)
    { }

   void runFunctor() override {
      (object->*fn)(arg1, arg2, arg3, arg4);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4);
   Class *object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4>
struct SelectStoredMemberFunctionPointerCall4
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredMemberFunctionPointerCall4<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3, Param4, Arg4>,
         VoidStoredMemberFunctionPointerCall4<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3, Param4, Arg4>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4>
class StoredConstMemberFunctionPointerCall4 : public RunFunctionTask<T>
{
 public:
   StoredConstMemberFunctionPointerCall4(T (Class::*_fn)(Param1, Param2, Param3, Param4) const, Class const *_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4)
   { }

   void runFunctor() override {
      this->result = (object->*fn)(arg1, arg2, arg3, arg4);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4)const;
   Class const *object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4>
class VoidStoredConstMemberFunctionPointerCall4 : public RunFunctionTask<T>
{
 public:
   VoidStoredConstMemberFunctionPointerCall4(T (Class::*_fn)(Param1, Param2, Param3, Param4) const, Class const *_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4)
   { }

   void runFunctor() override {
      (object->*fn)(arg1, arg2, arg3, arg4);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4)const;
   Class const *object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4>
struct SelectStoredConstMemberFunctionPointerCall4
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredConstMemberFunctionPointerCall4<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3, Param4, Arg4>,
         VoidStoredConstMemberFunctionPointerCall4<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3, Param4, Arg4>>::type;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3,
      typename Arg4, typename Arg5>
struct StoredFunctorCall5: public RunFunctionTask<T> {
   StoredFunctorCall5(FunctionPointer _function, const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3,
         const Arg4 &_arg4, const Arg5 &_arg5)
      : function(_function), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5)
   { }

   void runFunctor() override {
      this->result = function(arg1, arg2, arg3, arg4, arg5);
   }

   FunctionPointer function;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
   Arg5 arg5;
};

template <typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3, typename Arg4, typename Arg5>
struct StoredFunctorCall5<void, FunctionPointer, Arg1, Arg2, Arg3, Arg4, Arg5>: public RunFunctionTask<void>
{
   StoredFunctorCall5(FunctionPointer _function, const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3,
         const Arg4 &_arg4, const Arg5 &_arg5)
      : function(_function), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5)
   { }

   void runFunctor() override {
      function(arg1, arg2, arg3, arg4, arg5);
   }

   FunctionPointer function;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
   Arg5 arg5;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3,
      typename Arg4, typename Arg5>
struct StoredFunctorPointerCall5: public RunFunctionTask<T>
{
   StoredFunctorPointerCall5(FunctionPointer *_function, const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3,
         const Arg4 &_arg4, const Arg5 &_arg5)
      : function(_function), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5)
   { }

   void runFunctor() override {
      this->result = (*function)(arg1, arg2, arg3, arg4, arg5);
   }

   FunctionPointer *function;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
   Arg5 arg5;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3,
      typename Arg4, typename Arg5>
struct VoidStoredFunctorPointerCall5: public RunFunctionTask<T> {
   VoidStoredFunctorPointerCall5(FunctionPointer *_function, const Arg1 &_arg1, const Arg2 &_arg2,
         const Arg3 &_arg3, const Arg4 &_arg4, const Arg5 &_arg5)
      : function(_function), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5)
   { }

   void runFunctor() override {
      (*function)(arg1, arg2, arg3, arg4, arg5);
   }

   FunctionPointer *function;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
   Arg5 arg5;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3,
      typename Arg4, typename Arg5>
struct SelectStoredFunctorPointerCall5
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredFunctorPointerCall5    <T, FunctionPointer, Arg1, Arg2, Arg3, Arg4, Arg5>,
         VoidStoredFunctorPointerCall5<T, FunctionPointer, Arg1, Arg2, Arg3, Arg4, Arg5>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4, typename Param5, typename Arg5>
class StoredMemberFunctionCall5 : public RunFunctionTask<T>
{
 public:
   StoredMemberFunctionCall5(T (Class::*_fn)(Param1, Param2, Param3, Param4, Param5), const Class &_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4, const Arg5 &_arg5)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5)
   { }

   void runFunctor() override {
      this->result = (object.*fn)(arg1, arg2, arg3, arg4, arg5);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4, Param5);
   Class object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
   Arg5 arg5;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4, typename Param5, typename Arg5>
class VoidStoredMemberFunctionCall5 : public RunFunctionTask<T>
{
 public:
   VoidStoredMemberFunctionCall5(T (Class::*_fn)(Param1, Param2, Param3, Param4, Param5), const Class &_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4, const Arg5 &_arg5)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5)
   { }

   void runFunctor() override {
      (object.*fn)(arg1, arg2, arg3, arg4, arg5);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4, Param5);
   Class object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
   Arg5 arg5;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4, typename Param5, typename Arg5>
struct SelectStoredMemberFunctionCall5
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredMemberFunctionCall5<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3, Param4, Arg4, Param5, Arg5>,
         VoidStoredMemberFunctionCall5<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3, Param4, Arg4, Param5, Arg5>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4, typename Param5, typename Arg5>
class StoredConstMemberFunctionCall5 : public RunFunctionTask<T>
{
 public:
   StoredConstMemberFunctionCall5(T (Class::*_fn)(Param1, Param2, Param3, Param4, Param5) const, const Class &_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4, const Arg5 &_arg5)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5)
   { }

   void runFunctor() override {
      this->result = (object.*fn)(arg1, arg2, arg3, arg4, arg5);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4, Param5)const;
   const Class object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
   Arg5 arg5;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4, typename Param5, typename Arg5>
class VoidStoredConstMemberFunctionCall5 : public RunFunctionTask<T>
{
 public:
   VoidStoredConstMemberFunctionCall5(T (Class::*_fn)(Param1, Param2, Param3, Param4, Param5) const, const Class &_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4, const Arg5 &_arg5)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5)
   { }

   void runFunctor() override {
      (object.*fn)(arg1, arg2, arg3, arg4, arg5);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4, Param5)const;
   const Class object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
   Arg5 arg5;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4, typename Param5, typename Arg5>
struct SelectStoredConstMemberFunctionCall5
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredConstMemberFunctionCall5<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3, Param4, Arg4,
         Param5, Arg5>,
         VoidStoredConstMemberFunctionCall5<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3, Param4, Arg4,
         Param5, Arg5>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4, typename Param5, typename Arg5>
class StoredMemberFunctionPointerCall5 : public RunFunctionTask<T>
{
 public:
   StoredMemberFunctionPointerCall5(T (Class::*_fn)(Param1, Param2, Param3, Param4, Param5), Class *_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4, const Arg5 &_arg5)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5)
   { }

   void runFunctor() override {
      this->result = (object->*fn)(arg1, arg2, arg3, arg4, arg5);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4, Param5);
   Class *object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
   Arg5 arg5;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4, typename Param5, typename Arg5>
class VoidStoredMemberFunctionPointerCall5 : public RunFunctionTask<T>
{
 public:
   VoidStoredMemberFunctionPointerCall5(T (Class::*_fn)(Param1, Param2, Param3, Param4, Param5), Class *_object,
         const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4, const Arg5 &_arg5)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5)
   { }

   void runFunctor() override {
      (object->*fn)(arg1, arg2, arg3, arg4, arg5);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4, Param5);
   Class *object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
   Arg5 arg5;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4, typename Param5, typename Arg5>
struct SelectStoredMemberFunctionPointerCall5
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredMemberFunctionPointerCall5<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3, Param4,
         Arg4, Param5, Arg5>,
         VoidStoredMemberFunctionPointerCall5<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3, Param4,
         Arg4, Param5, Arg5>>::type;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4, typename Param5, typename Arg5>
class StoredConstMemberFunctionPointerCall5 : public RunFunctionTask<T>
{
 public:
   StoredConstMemberFunctionPointerCall5(T (Class::*_fn)(Param1, Param2, Param3, Param4, Param5) const,
         Class const *_object, const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4, const Arg5 &_arg5)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5)
   { }

   void runFunctor() override {
      this->result = (object->*fn)(arg1, arg2, arg3, arg4, arg5);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4, Param5)const;
   Class const *object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
   Arg5 arg5;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4, typename Param5, typename Arg5>
class VoidStoredConstMemberFunctionPointerCall5 : public RunFunctionTask<T>
{
 public:
   VoidStoredConstMemberFunctionPointerCall5(T (Class::*_fn)(Param1, Param2, Param3, Param4, Param5) const,
         Class const *_object, const Arg1 &_arg1, const Arg2 &_arg2, const Arg3 &_arg3, const Arg4 &_arg4, const Arg5 &_arg5)
      : fn(_fn), object(_object), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5)
   { }

   void runFunctor() override {
      (object->*fn)(arg1, arg2, arg3, arg4, arg5);
   }

 private:
   T (Class::*fn)(Param1, Param2, Param3, Param4, Param5)const;
   Class const *object;
   Arg1 arg1;
   Arg2 arg2;
   Arg3 arg3;
   Arg4 arg4;
   Arg5 arg5;
};

template <typename T, typename Class, typename Param1, typename Arg1, typename Param2, typename Arg2,
      typename Param3, typename Arg3, typename Param4, typename Arg4, typename Param5, typename Arg5>
struct SelectStoredConstMemberFunctionPointerCall5
{
   using type = typename SelectSpecialization<T>::template
         Type<StoredConstMemberFunctionPointerCall5<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3,
         Param4, Arg4, Param5, Arg5>,
         VoidStoredConstMemberFunctionPointerCall5<T, Class, Param1, Arg1, Param2, Arg2, Param3, Arg3,
         Param4, Arg4, Param5, Arg5>>::type;
};

template <typename T, typename Functor>
class StoredFunctorCall : public RunFunctionTask<T>
{
 public:
   StoredFunctorCall(const Functor &f)
      : functor(f)
   { }

   void runFunctor() override {
      this->result = functor();
   }

 private:
   Functor functor;
};

template <typename Functor>
class StoredFunctorCall<void, Functor> : public RunFunctionTask<void>
{
 public:
   StoredFunctorCall(const Functor &f)
      : functor(f)
   { }

   void runFunctor() override {
      functor();
   }

 private:
   Functor functor;
};

} //namespace QtConcurrent

#endif
