/***********************************************************************
*
* Copyright (c) 2017-2026 Barbara Geller
* Copyright (c) 2017-2026 Ansel Sermersheim
*
* Copyright (c) 1998-2009 John Maddock
*
* This file is part of CopperSpice.
*
* CopperSpice is free software, released under the BSD 2-Clause license.
* For license details refer to LICENSE provided with this project.
*
* CopperSpice is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://opensource.org/licenses/BSD-2-Clause
*
***********************************************************************/

/*
 * Use, modification and distribution are subject to the
 * Boost Software License, Version 1.0. (See accompanying file
 * LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
*/

#ifndef CS_REGEX_H
#define CS_REGEX_H

#include <regex/r_config.h>
#include <regex/r_states.h>
#include <regex/r_pattern_except.h>
#include <regex/r_protected_call.h>

#include <regex/regex_fwd.h>
#include <regex/regex_traits.h>

#include <regex/basic_regex.h>
#include <regex/basic_regex_creator.h>
#include <regex/basic_regex_parser.h>
#include <regex/match_flags.h>
#include <regex/match_results.h>
#include <regex/regex_iterator.h>
#include <regex/regex_match.h>
#include <regex/regex_merge.h>
#include <regex/regex_split.h>
#include <regex/regex_raw_buffer.h>
#include <regex/regex_search.h>
#include <regex/regex_token_iterator.h>
#include <regex/regex_sub_match.h>
#include <regex/perl_matcher.h>

#endif
