/***********************************************************************
*
* Copyright (c) 2012-2026 Barbara Geller
* Copyright (c) 2012-2026 Ansel Sermersheim
*
* Copyright (c) 2015 The Qt Company Ltd.
* Copyright (c) 2012-2016 Digia Plc and/or its subsidiary(-ies).
* Copyright (c) 2008-2012 Nokia Corporation and/or its subsidiary(-ies).
*
* This file is part of CopperSpice.
*
* CopperSpice is free software. You can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* version 2.1 as published by the Free Software Foundation.
*
* CopperSpice is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://www.gnu.org/licenses/
*
***********************************************************************/

#ifndef QLOCALE_DATA_P_H
#define QLOCALE_DATA_P_H

// This part of the file is not generated, it is written by hand since Unicode CLDR
// does not contain measurement system information.

#include <qlocale.h>
#include <qlocale_p.h>

struct CountryLanguage {
   quint16 languageId;
   quint16 countryId;
   QLocale::MeasurementSystem system;
};

static const CountryLanguage ImperialMeasurementSystems[] = {
   { QLocale::English,  QLocale::UnitedStates,                     QLocale::ImperialUSSystem },
   { QLocale::English,  QLocale::UnitedStatesMinorOutlyingIslands, QLocale::ImperialUSSystem },
   { QLocale::Spanish,  QLocale::UnitedStates,                     QLocale::ImperialUSSystem },
   { QLocale::Hawaiian, QLocale::UnitedStates,                     QLocale::ImperialUSSystem },
   { QLocale::English,  QLocale::UnitedKingdom,                    QLocale::ImperialUKSystem }
};

static const int ImperialMeasurementSystemsCount = sizeof(ImperialMeasurementSystems) / sizeof(ImperialMeasurementSystems[0]);

// GENERATED PART STARTS HERE

/*
    This part of the file was generated on 2023-10-06 from the
    Common Locale Data Repository v43

    https://www.unicode.org/cldr/

    Do not change it, instead edit CLDR data and regenerate this file using
    locale_cldr2xml.py and locale_xml2locale.py.
*/


static const QLocaleId likely_subtags[] = {
    {   4,  0,   0 }, {   4, 74,  77 }, // aa -> aa_Latn_ET
    {   3,  0,   0 }, {   3, 29,  88 }, // ab -> ab_Cyrl_GE
    {   2,  0,   0 }, {   2, 29,   0 }, // abq -> abq_Cyrl
    {  25,  0,   0 }, {  25,  6, 110 }, // ae -> ae_Avst_IR
    {   5,  0,   0 }, {   5, 74, 205 }, // af -> af_Latn_ZA
    {   6,  0,   0 }, {   6, 74,  40 }, // agq -> agq_Latn_CM
    {   7,  0,   0 }, {   7, 74,  90 }, // ak -> ak_Latn_GH
    {   8,  0,   0 }, {   8, 26, 111 }, // akk -> akk_Xsux_IQ
    {  12,  0,   0 }, {  12, 38,  77 }, // am -> am_Ethi_ET
    {  17,  0,   0 }, {  17, 74, 209 }, // an -> an_Latn_ES
    { 243,  0,   0 }, { 243, 74, 166 }, // ann -> ann_Latn_NG
    {  16,  0,   0 }, {  16,  4,  71 }, // ar -> ar_Arab_EG
    {  18,  0,   0 }, {  18, 55, 110 }, // arc -> arc_Armi_IR
    {  18, 98,   0 }, {  18, 98, 120 }, // arc_Nbat -> arc_Nbat_JO
    {  18, 121,   0 }, {  18, 121, 223 }, // arc_Palm -> arc_Palm_SY
    { 206,  0,   0 }, { 206, 74,  49 }, // arn -> arn_Latn_CL
    {  20,  0,   0 }, {  20,  9, 108 }, // as -> as_Beng_IN
    {  22,  0,   0 }, {  22, 74, 226 }, // asa -> asa_Latn_TZ
    {  11,  0,   0 }, {  11, 134, 243 }, // ase -> ase_Sgnw_US
    {  21,  0,   0 }, {  21, 74, 209 }, // ast -> ast_Latn_ES
    {  24,  0,   0 }, {  24, 29, 189 }, // av -> av_Cyrl_RU
    {  26,  0,   0 }, {  26, 74,  28 }, // ay -> ay_Latn_BO
    {  27,  0,   0 }, {  27, 74,  17 }, // az -> az_Latn_AZ
    {  27,  0, 111 }, {  27,  4, 111 }, // az_IQ -> az_Arab_IQ
    {  27,  0, 110 }, {  27,  4, 110 }, // az_IR -> az_Arab_IR
    {  27,  0, 189 }, {  27, 29, 189 }, // az_RU -> az_Cyrl_RU
    {  27,  4,   0 }, {  27,  4, 110 }, // az_Arab -> az_Arab_IR
    {  35,  0,   0 }, {  35, 29, 189 }, // ba -> ba_Cyrl_RU
    {  30,  0,   0 }, {  30,  4, 174 }, // bal -> bal_Arab_PK
    {  29,  0,   0 }, {  29, 74, 109 }, // ban -> ban_Latn_ID
    {  34,  0,   0 }, {  34, 74,  40 }, // bas -> bas_Latn_CM
    {  32,  0,   0 }, {  32,  8,  40 }, // bax -> bax_Bamu_CM
    {  37,  0,   0 }, {  37, 74, 109 }, // bbc -> bbc_Latn_ID
    {  38,  0,   0 }, {  38, 29,  22 }, // be -> be_Cyrl_BY
    {  39,  0,   0 }, {  39, 74, 256 }, // bem -> bem_Latn_ZM
    {  40,  0,   0 }, {  40, 74, 226 }, // bez -> bez_Latn_TZ
    {  49,  0,   0 }, {  49, 29,  36 }, // bg -> bg_Cyrl_BG
    { 111,  0,   0 }, { 111, 31, 108 }, // bgc -> bgc_Deva_IN
    { 362,  0,   0 }, { 362,  4, 174 }, // bgn -> bgn_Arab_PK
    {  41,  0,   0 }, {  41, 31, 108 }, // bho -> bho_Deva_IN
    {  42,  0,   0 }, {  42, 74, 248 }, // bi -> bi_Latn_VU
    {  48,  0,   0 }, {  48, 74, 181 }, // bku -> bku_Latn_PH
    { 321,  0,   0 }, { 321, 147, 251 }, // blt -> blt_Tavt_VN
    {  31,  0,   0 }, {  31, 74, 141 }, // bm -> bm_Latn_ML
    {  33,  0,   0 }, {  33,  9,  20 }, // bn -> bn_Beng_BD
    { 333,  0,   0 }, { 333, 154,  50 }, // bo -> bo_Tibt_CN
    {  46,  0,   0 }, {  46, 74,  82 }, // br -> br_Latn_FR
    {  44,  0,   0 }, {  44, 31, 108 }, // brx -> brx_Deva_IN
    {  45,  0,   0 }, {  45, 74,  29 }, // bs -> bs_Latn_BA
    {   9,  0,   0 }, {   9, 74,  40 }, // bss -> bss_Latn_CM
    {  47,  0,   0 }, {  47, 74, 109 }, // bug -> bug_Latn_ID
    {  43,  0,   0 }, {  43, 38,  74 }, // byn -> byn_Ethi_ER
    {  53,  0,   0 }, {  53, 74, 209 }, // ca -> ca_Latn_ES
    {  23,  0,   0 }, {  23, 74, 166 }, // cch -> cch_Latn_NG
    {  57,  0,   0 }, {  57, 21,  20 }, // ccp -> ccp_Cakm_BD
    {  59,  0,   0 }, {  59, 29, 189 }, // ce -> ce_Cyrl_RU
    {  54,  0,   0 }, {  54, 74, 181 }, // ceb -> ceb_Latn_PH
    {  62,  0,   0 }, {  62, 74, 239 }, // cgg -> cgg_Latn_UG
    {  58,  0,   0 }, {  58, 74,  96 }, // ch -> ch_Latn_GU
    {  60,  0,   0 }, {  60, 23, 243 }, // chr -> chr_Cher_US
    {  61,  0,   0 }, {  61, 74, 243 }, // cic -> cic_Latn_US
    {  80,  0,   0 }, {  80, 22, 251 }, // cjm -> cjm_Cham_VN
    {  56,  0,   0 }, {  56,  4, 111 }, // ckb -> ckb_Arab_IQ
    {  70,  0,   0 }, {  70, 74,  82 }, // co -> co_Latn_FR
    {  68,  0,   0 }, {  68, 25,  71 }, // cop -> cop_Copt_EG
    {  71,  0,   0 }, {  71, 18,  41 }, // cr -> cr_Cans_CA
    {  73,  0,   0 }, {  73, 74,  64 }, // cs -> cs_Latn_CZ
    { 329,  0,   0 }, { 329, 122, 157 }, // ctd -> ctd_Pauc_MM
    {  64,  0,   0 }, {  64, 29, 189 }, // cu -> cu_Cyrl_RU
    {  64, 41,   0 }, {  64, 41,  36 }, // cu_Glag -> cu_Glag_BG
    {  65,  0,   0 }, {  65, 29, 189 }, // cv -> cv_Cyrl_RU
    { 361,  0,   0 }, { 361, 74, 242 }, // cy -> cy_Latn_GB
    {  74,  0,   0 }, {  74, 74,  65 }, // da -> da_Latn_DK
    { 323,  0,   0 }, { 323, 74, 122 }, // dav -> dav_Latn_KE
    { 103,  0,   0 }, { 103, 74,  89 }, // de -> de_Latn_DE
    { 370,  0,   0 }, { 370, 74, 165 }, // dje -> dje_Latn_NE
    {  76,  0,   0 }, {  76, 31, 108 }, // doi -> doi_Deva_IN
    { 183,  0,   0 }, { 183, 74,  89 }, // dsb -> dsb_Latn_DE
    {  77,  0,   0 }, {  77, 74,  40 }, // dua -> dua_Latn_CM
    {  75,  0,   0 }, {  75, 152, 140 }, // dv -> dv_Thaa_MV
    { 136,  0,   0 }, { 136, 74, 195 }, // dyo -> dyo_Latn_SN
    {  79,  0,   0 }, {  79, 154,  27 }, // dz -> dz_Tibt_BT
    {  82,  0,   0 }, {  82, 74, 122 }, // ebu -> ebu_Latn_KE
    {  88,  0,   0 }, {  88, 74,  90 }, // ee -> ee_Latn_GH
    {  14,  0,   0 }, {  14, 35,  71 }, // egy -> egy_Egyp_EG
    {  81,  0,   0 }, {  81, 65, 157 }, // eky -> eky_Kali_MM
    { 105,  0,   0 }, { 105, 44,  92 }, // el -> el_Grek_GR
    {  83,  0,   0 }, {  83, 74, 243 }, // en -> en_Latn_US
    {  83, 132,   0 }, {  83, 132, 242 }, // en_Shaw -> en_Shaw_GB
    {  85,  0,   0 }, {  85, 74, 254 }, // eo -> eo_Latn_001
    { 309,  0,   0 }, { 309, 74, 209 }, // es -> es_Latn_ES
    {  86,  0,   0 }, {  86, 74,  75 }, // et -> et_Latn_EE
    {  87,  0,   0 }, {  87, 110, 115 }, // ett -> ett_Ital_IT
    {  36,  0,   0 }, {  36, 74, 209 }, // eu -> eu_Latn_ES
    {  89,  0,   0 }, {  89, 74,  40 }, // ewo -> ewo_Latn_CM
    { 260,  0,   0 }, { 260,  4, 110 }, // fa -> fa_Arab_IR
    {  96,  0,   0 }, {  96, 74, 195 }, // ff -> ff_Latn_SN
    {  96,  1,   0 }, {  96,  1,  99 }, // ff_Adlm -> ff_Adlm_GN
    {  93,  0,   0 }, {  93, 74,  81 }, // fi -> fi_Latn_FI
    {  92,  0,   0 }, {  92, 74, 181 }, // fil -> fil_Latn_PH
    {  91,  0,   0 }, {  91, 74,  80 }, // fj -> fj_Latn_FJ
    {  90,  0,   0 }, {  90, 74,  79 }, // fo -> fo_Latn_FO
    {  94,  0,   0 }, {  94, 74,  82 }, // fr -> fr_Latn_FR
    { 233,  0,   0 }, { 233, 74,  89 }, // frr -> frr_Latn_DE
    {  95,  0,   0 }, {  95, 74, 115 }, // fur -> fur_Latn_IT
    { 363,  0,   0 }, { 363, 74, 161 }, // fy -> fy_Latn_NL
    { 131,  0,   0 }, { 131, 74, 112 }, // ga -> ga_Latn_IE
    {  97,  0,   0 }, {  97, 74,  90 }, // gaa -> gaa_Latn_GH
    {  98,  0,   0 }, {  98, 74, 242 }, // gd -> gd_Latn_GB
    { 101,  0,   0 }, { 101, 38,  77 }, // gez -> gez_Ethi_ET
    {  99,  0,   0 }, {  99, 74, 209 }, // gl -> gl_Latn_ES
    { 106,  0,   0 }, { 106, 74, 179 }, // gn -> gn_Latn_PY
    { 104,  0,   0 }, { 104, 42, 240 }, // got -> got_Goth_UA
    {  15,  0,   0 }, {  15, 27,  63 }, // grc -> grc_Cprt_CY
    {  15, 78,   0 }, {  15, 78,  92 }, // grc_Linb -> grc_Linb_GR
    { 315,  0,   0 }, { 315, 74, 222 }, // gsw -> gsw_Latn_CH
    { 107,  0,   0 }, { 107, 45, 108 }, // gu -> gu_Gujr_IN
    { 108,  0,   0 }, { 108, 74, 122 }, // guz -> guz_Latn_KE
    { 204,  0,   0 }, { 204, 74, 113 }, // gv -> gv_Latn_IM
    { 112,  0,   0 }, { 112, 74, 166 }, // ha -> ha_Latn_NG
    { 112,  0,  40 }, { 112,  4,  40 }, // ha_CM -> ha_Arab_CM
    { 112,  0, 218 }, { 112,  4, 218 }, // ha_SD -> ha_Arab_SD
    { 113,  0,   0 }, { 113, 74, 243 }, // haw -> haw_Latn_US
    { 114,  0,   0 }, { 114, 53, 114 }, // he -> he_Hebr_IL
    { 116,  0,   0 }, { 116, 31, 108 }, // hi -> hi_Deva_IN
    { 116, 74,   0 }, { 116, 74, 108 }, // hi_Latn -> hi_Latn_IN
    { 168,  0,   0 }, { 168, 125,  50 }, // hmd -> hmd_Plrd_CN
    { 118,  0,   0 }, { 118, 105, 243 }, // hnj -> hnj_Hmnp_US
    { 118,  0,  15 }, { 118, 73,  15 }, // hnj_AU -> hnj_Laoo_AU
    { 118,  0,  50 }, { 118, 73,  50 }, // hnj_CN -> hnj_Laoo_CN
    { 118,  0,  82 }, { 118, 73,  82 }, // hnj_FR -> hnj_Laoo_FR
    { 118,  0,  83 }, { 118, 73,  83 }, // hnj_GF -> hnj_Laoo_GF
    { 118,  0, 127 }, { 118, 73, 127 }, // hnj_LA -> hnj_Laoo_LA
    { 118,  0, 157 }, { 118, 73, 157 }, // hnj_MM -> hnj_Laoo_MM
    { 118,  0, 219 }, { 118, 73, 219 }, // hnj_SR -> hnj_Laoo_SR
    { 118,  0, 227 }, { 118, 73, 227 }, // hnj_TH -> hnj_Laoo_TH
    { 118,  0, 243 }, { 118, 105, 243 }, // hnj_US -> hnj_Hmnp_US
    { 118,  0, 251 }, { 118, 73, 251 }, // hnj_VN -> hnj_Laoo_VN
    { 118, 73,   0 }, { 118, 73, 127 }, // hnj_Laoo -> hnj_Laoo_LA
    { 110,  0,   0 }, { 110, 74, 181 }, // hnn -> hnn_Latn_PH
    { 117,  0,   0 }, { 117, 74, 178 }, // ho -> ho_Latn_PG
    { 119,  0,   0 }, { 119, 31, 108 }, // hoc -> hoc_Deva_IN
    {  72,  0,   0 }, {  72, 74,  60 }, // hr -> hr_Latn_HR
    { 349,  0,   0 }, { 349, 74,  89 }, // hsb -> hsb_Latn_DE
    { 109,  0,   0 }, { 109, 74, 102 }, // ht -> ht_Latn_HT
    { 120,  0,   0 }, { 120, 74, 106 }, // hu -> hu_Latn_HU
    {  19,  0,   0 }, {  19,  5,  12 }, // hy -> hy_Armn_AM
    { 115,  0,   0 }, { 115, 74, 158 }, // hz -> hz_Latn_NA
    { 127,  0,   0 }, { 127, 74, 254 }, // ia -> ia_Latn_001
    { 125,  0,   0 }, { 125, 74, 109 }, // id -> id_Latn_ID
    { 123,  0,   0 }, { 123, 74, 166 }, // ig -> ig_Latn_NG
    { 293,  0,   0 }, { 293, 165,  50 }, // ii -> ii_Yiii_CN
    { 130,  0,   0 }, { 130, 74, 243 }, // ik -> ik_Latn_US
    { 126,  0,   0 }, { 126, 29, 189 }, // inh -> inh_Cyrl_RU
    { 122,  0,   0 }, { 122, 74, 254 }, // io -> io_Latn_001
    { 121,  0,   0 }, { 121, 74, 107 }, // is -> is_Latn_IS
    { 132,  0,   0 }, { 132, 74, 115 }, // it -> it_Latn_IT
    { 129,  0,   0 }, { 129, 18,  41 }, // iu -> iu_Cans_CA
    { 133,  0,   0 }, { 133, 59, 118 }, // ja -> ja_Jpan_JP
    { 181,  0,   0 }, { 181, 74, 254 }, // jbo -> jbo_Latn_001
    { 228,  0,   0 }, { 228, 74,  40 }, // jgo -> jgo_Latn_CM
    { 193,  0,   0 }, { 193, 74, 226 }, // jmc -> jmc_Latn_TZ
    { 134,  0,   0 }, { 134, 74, 109 }, // jv -> jv_Latn_ID
    { 102,  0,   0 }, { 102, 40,  88 }, // ka -> ka_Geor_GE
    { 138,  0,   0 }, { 138, 74,   4 }, // kab -> kab_Latn_DZ
    { 135,  0,   0 }, { 135, 74, 166 }, // kaj -> kaj_Latn_NG
    { 143,  0,   0 }, { 143, 74, 122 }, // kam -> kam_Latn_KE
    { 346,  0,   0 }, { 346, 74, 166 }, // kcg -> kcg_Latn_NG
    { 196,  0,   0 }, { 196, 74, 226 }, // kde -> kde_Latn_TZ
    { 137,  0,   0 }, { 137, 74,  43 }, // kea -> kea_Latn_CV
    { 148,  0,   0 }, { 148, 74,  40 }, // ken -> ken_Latn_CM
    { 157,  0,   0 }, { 157, 74, 116 }, // kfo -> kfo_Latn_CI
    { 154,  0,   0 }, { 154, 74,  57 }, // kg -> kg_Latn_CD
    { 139,  0,   0 }, { 139, 74,  32 }, // kgp -> kgp_Latn_BR
    { 184,  0,   0 }, { 184, 101,  50 }, // khb -> khb_Talu_CN
    { 158,  0,   0 }, { 158, 74, 141 }, // khq -> khq_Latn_ML
    { 151,  0,   0 }, { 151, 74, 122 }, // ki -> ki_Latn_KE
    { 161,  0,   0 }, { 161, 74, 158 }, // kj -> kj_Latn_NA
    { 147,  0,   0 }, { 147, 29, 121 }, // kk -> kk_Cyrl_KZ
    { 147,  0,   1 }, { 147,  4,   1 }, // kk_AF -> kk_Arab_AF
    { 147,  0,  50 }, { 147,  4,  50 }, // kk_CN -> kk_Arab_CN
    { 147,  0, 110 }, { 147,  4, 110 }, // kk_IR -> kk_Arab_IR
    { 147,  0, 152 }, { 147,  4, 152 }, // kk_MN -> kk_Arab_MN
    { 147,  4,   0 }, { 147,  4,  50 }, // kk_Arab -> kk_Arab_CN
    { 140,  0,   0 }, { 140, 74,  40 }, // kkj -> kkj_Latn_CM
    { 141,  0,   0 }, { 141, 74,  93 }, // kl -> kl_Latn_GL
    { 142,  0,   0 }, { 142, 74, 122 }, // kln -> kln_Latn_KE
    { 149,  0,   0 }, { 149, 68,  39 }, // km -> km_Khmr_KH
    { 144,  0,   0 }, { 144, 62, 108 }, // kn -> kn_Knda_IN
    { 156,  0,   0 }, { 156, 71, 207 }, // ko -> ko_Kore_KR
    { 155,  0,   0 }, { 155, 31, 108 }, // kok -> kok_Deva_IN
    { 160,  0,   0 }, { 160, 74, 131 }, // kpe -> kpe_Latn_LR
    { 145,  0,   0 }, { 145, 74,   0 }, // kr -> kr_Latn
    { 146,  0,   0 }, { 146,  4, 108 }, // ks -> ks_Arab_IN
    { 291,  0,   0 }, { 291, 74, 226 }, // ksb -> ksb_Latn_TZ
    {  28,  0,   0 }, {  28, 74,  40 }, // ksf -> ksf_Latn_CM
    {  67,  0,   0 }, {  67, 74,  89 }, // ksh -> ksh_Latn_DE
    { 162,  0,   0 }, { 162, 74, 235 }, // ku -> ku_Latn_TR
    { 162,  0, 129 }, { 162,  4, 129 }, // ku_LB -> ku_Arab_LB
    { 162,  4,   0 }, { 162,  4, 111 }, // ku_Arab -> ku_Arab_IQ
    { 162, 164,   0 }, { 162, 164,  88 }, // ku_Yezi -> ku_Yezi_GE
    { 153,  0,   0 }, { 153, 29, 189 }, // kv -> kv_Cyrl_RU
    {  69,  0,   0 }, {  69, 74, 242 }, // kw -> kw_Latn_GB
    { 164,  0,   0 }, { 164, 29, 126 }, // ky -> ky_Cyrl_KG
    { 164,  0,  50 }, { 164,  4,  50 }, // ky_CN -> ky_Arab_CN
    { 164,  0, 235 }, { 164, 74, 235 }, // ky_TR -> ky_Latn_TR
    { 164,  4,   0 }, { 164,  4,  50 }, // ky_Arab -> ky_Arab_CN
    { 164, 74,   0 }, { 164, 74, 235 }, // ky_Latn -> ky_Latn_TR
    { 169,  0,   0 }, { 169, 74, 249 }, // la -> la_Latn_VA
    { 176,  0,   0 }, { 176, 77,  92 }, // lab -> lab_Lina_GR
    { 166,  0,   0 }, { 166, 74, 226 }, // lag -> lag_Latn_TZ
    { 188,  0,   0 }, { 188, 74, 135 }, // lb -> lb_Latn_LU
    { 171,  0,   0 }, { 171, 75, 108 }, // lep -> lep_Lepc_IN
    { 172,  0,   0 }, { 172, 29, 189 }, // lez -> lez_Cyrl_RU
    { 100,  0,   0 }, { 100, 74, 239 }, // lg -> lg_Latn_UG
    { 175,  0,   0 }, { 175, 74, 161 }, // li -> li_Latn_NL
    { 174,  0,   0 }, { 174, 31, 160 }, // lif -> lif_Deva_NP
    { 174, 76,   0 }, { 174, 76, 108 }, // lif_Limb -> lif_Limb_IN
    { 173,  0,   0 }, { 173, 74, 115 }, // lij -> lij_Latn_IT
    { 178,  0,   0 }, { 178, 39,  50 }, // lis -> lis_Lisu_CN
    { 165,  0,   0 }, { 165, 74, 243 }, // lkt -> lkt_Latn_US
    { 177,  0,   0 }, { 177, 74,  57 }, // ln -> ln_Latn_CD
    { 167,  0,   0 }, { 167, 73, 127 }, // lo -> lo_Laoo_LA
    { 234,  0,   0 }, { 234,  4, 110 }, // lrc -> lrc_Arab_IR
    { 180,  0,   0 }, { 180, 74, 134 }, // lt -> lt_Latn_LT
    { 185,  0,   0 }, { 185, 74,  57 }, // lu -> lu_Latn_CD
    { 187,  0,   0 }, { 187, 74, 122 }, // luo -> luo_Latn_KE
    { 189,  0,   0 }, { 189, 74, 122 }, // luy -> luy_Latn_KE
    { 170,  0,   0 }, { 170, 74, 128 }, // lv -> lv_Latn_LV
    { 179,  0,   0 }, { 179, 135,  50 }, // lzh -> lzh_Hans_CN
    { 194,  0,   0 }, { 194, 31, 108 }, // mai -> mai_Deva_IN
    { 201,  0,   0 }, { 201, 74,  87 }, // man -> man_Latn_GM
    { 201,  0,  99 }, { 201, 103,  99 }, // man_GN -> man_Nkoo_GN
    { 201, 103,   0 }, { 201, 103,  99 }, // man_Nkoo -> man_Nkoo_GN
    { 209,  0,   0 }, { 209, 74, 122 }, // mas -> mas_Latn_KE
    { 216,  0,   0 }, { 216, 29, 189 }, // mdf -> mdf_Cyrl_RU
    { 211,  0,   0 }, { 211, 74, 198 }, // men -> men_Latn_SL
    { 213,  0,   0 }, { 213, 74, 122 }, // mer -> mer_Latn_KE
    { 218,  0,   0 }, { 218, 74, 146 }, // mfe -> mfe_Latn_MU
    { 197,  0,   0 }, { 197, 74, 137 }, // mg -> mg_Latn_MG
    { 195,  0,   0 }, { 195, 74, 156 }, // mgh -> mgh_Latn_MZ
    { 214,  0,   0 }, { 214, 74,  40 }, // mgo -> mgo_Latn_CM
    { 208,  0,   0 }, { 208, 74, 143 }, // mh -> mh_Latn_MH
    { 205,  0,   0 }, { 205, 74, 163 }, // mi -> mi_Latn_NZ
    { 192,  0,   0 }, { 192, 29, 170 }, // mk -> mk_Cyrl_MK
    { 199,  0,   0 }, { 199, 83, 108 }, // ml -> ml_Mlym_IN
    { 217,  0,   0 }, { 217, 29, 152 }, // mn -> mn_Cyrl_MN
    { 217,  0,  50 }, { 217, 94,  50 }, // mn_CN -> mn_Mong_CN
    { 217, 94,   0 }, { 217, 94,  50 }, // mn_Mong -> mn_Mong_CN
    { 203,  0,   0 }, { 203,  9, 108 }, // mni -> mni_Beng_IN
    { 215,  0,   0 }, { 215, 74,  41 }, // moh -> moh_Latn_CA
    { 207,  0,   0 }, { 207, 31, 108 }, // mr -> mr_Deva_IN
    { 198,  0,   0 }, { 198, 74, 139 }, // ms -> ms_Latn_MY
    { 198,  0,  53 }, { 198,  4,  53 }, // ms_CC -> ms_Arab_CC
    { 200,  0,   0 }, { 200, 74, 142 }, // mt -> mt_Latn_MT
    { 219,  0,   0 }, { 219, 74,  40 }, // mua -> mua_Latn_CM
    { 220,  0,   0 }, { 220, 74, 243 }, // mus -> mus_Latn_US
    {  50,  0,   0 }, {  50, 97, 157 }, // my -> my_Mymr_MM
    {  84,  0,   0 }, {  84, 29, 189 }, // myv -> myv_Cyrl_RU
    {  66,  0,   0 }, {  66, 84, 110 }, // myz -> myz_Mand_IR
    { 210,  0,   0 }, { 210,  4, 110 }, // mzn -> mzn_Arab_IR
    { 222,  0,   0 }, { 222, 74, 159 }, // na -> na_Latn_NR
    { 221,  0,   0 }, { 221, 74, 158 }, // naq -> naq_Latn_NA
    { 238,  0,   0 }, { 238, 74, 172 }, // nb -> nb_Latn_NO
    { 232,  0,   0 }, { 232, 74, 257 }, // nd -> nd_Latn_ZW
    { 182,  0,   0 }, { 182, 74,  89 }, // nds -> nds_Latn_DE
    { 225,  0,   0 }, { 225, 31, 160 }, // ne -> ne_Deva_NP
    { 226,  0,   0 }, { 226, 31, 160 }, // new -> new_Deva_NP
    { 224,  0,   0 }, { 224, 74, 158 }, // ng -> ng_Latn_NA
    {  78,  0,   0 }, {  78, 74, 161 }, // nl -> nl_Latn_NL
    { 163,  0,   0 }, { 163, 74,  40 }, // nmg -> nmg_Latn_CM
    { 239,  0,   0 }, { 239, 74, 172 }, // nn -> nn_Latn_NO
    { 227,  0,   0 }, { 227, 74,  40 }, // nnh -> nnh_Latn_CM
    { 237,  0,   0 }, { 237, 72, 227 }, // nod -> nod_Lana_TH
    { 248,  0,   0 }, { 248, 128, 221 }, // non -> non_Runr_SE
    { 231,  0,   0 }, { 231, 103,  99 }, // nqo -> nqo_Nkoo_GN
    { 305,  0,   0 }, { 305, 74, 205 }, // nr -> nr_Latn_ZA
    { 236,  0,   0 }, { 236, 74, 205 }, // nso -> nso_Latn_ZA
    { 240,  0,   0 }, { 240, 74, 208 }, // nus -> nus_Latn_SS
    { 223,  0,   0 }, { 223, 74, 243 }, // nv -> nv_Latn_US
    { 241,  0,   0 }, { 241, 74, 138 }, // ny -> ny_Latn_MW
    { 242,  0,   0 }, { 242, 74, 239 }, // nyn -> nyn_Latn_UG
    { 244,  0,   0 }, { 244, 74,  82 }, // oc -> oc_Latn_FR
    { 246,  0,   0 }, { 246, 18,  41 }, // oj -> oj_Cans_CA
    { 251,  0,   0 }, { 251, 74,  77 }, // om -> om_Latn_ET
    { 245,  0,   0 }, { 245, 106, 108 }, // or -> or_Orya_IN
    { 253,  0,   0 }, { 253, 29,  88 }, // os -> os_Cyrl_GE
    { 252,  0,   0 }, { 252, 118, 243 }, // osa -> osa_Osge_US
    { 250,  0,   0 }, { 250, 117, 152 }, // otk -> otk_Orkh_MN
    { 266,  0,   0 }, { 266, 47, 108 }, // pa -> pa_Guru_IN
    { 266,  0, 174 }, { 266,  4, 174 }, // pa_PK -> pa_Arab_PK
    { 266,  4,   0 }, { 266,  4, 174 }, // pa_Arab -> pa_Arab_PK
    { 254,  0,   0 }, { 254, 56, 110 }, // pal -> pal_Phli_IR
    { 254, 126,   0 }, { 254, 126,  50 }, // pal_Phlp -> pal_Phlp_CN
    { 257,  0,   0 }, { 257, 74,  62 }, // pap -> pap_Latn_CW
    { 255,  0,   0 }, { 255, 74, 175 }, // pau -> pau_Latn_PW
    { 230,  0,   0 }, { 230, 74, 166 }, // pcm -> pcm_Latn_NG
    { 249,  0,   0 }, { 249, 113, 110 }, // peo -> peo_Xpeo_IR
    { 261,  0,   0 }, { 261, 124, 129 }, // phn -> phn_Phnx_LB
    { 262,  0,   0 }, { 262, 74, 203 }, // pis -> pis_Latn_SB
    { 263,  0,   0 }, { 263, 74, 183 }, // pl -> pl_Latn_PL
    { 265,  0,   0 }, { 265, 74, 254 }, // prg -> prg_Latn_001
    { 259,  0,   0 }, { 259,  4,   1 }, // ps -> ps_Arab_AF
    { 264,  0,   0 }, { 264, 74,  32 }, // pt -> pt_Latn_BR
    { 267,  0,   0 }, { 267, 74, 180 }, // qu -> qu_Latn_PE
    { 150,  0,   0 }, { 150, 74,  97 }, // quc -> quc_Latn_GT
    { 268,  0,   0 }, { 268, 31, 108 }, // raj -> raj_Deva_IN
    { 269,  0,   0 }, { 269, 74, 109 }, // rej -> rej_Latn_ID
    { 270,  0,   0 }, { 270, 50, 157 }, // rhg -> rhg_Rohg_MM
    { 272,  0,   0 }, { 272, 74, 222 }, // rm -> rm_Latn_CH
    { 274,  0,   0 }, { 274, 74,  38 }, // rn -> rn_Latn_BI
    { 271,  0,   0 }, { 271, 74, 188 }, // ro -> ro_Latn_RO
    { 273,  0,   0 }, { 273, 74, 226 }, // rof -> rof_Latn_TZ
    { 275,  0,   0 }, { 275, 29, 189 }, // ru -> ru_Cyrl_RU
    { 152,  0,   0 }, { 152, 74, 190 }, // rw -> rw_Latn_RW
    { 276,  0,   0 }, { 276, 74, 226 }, // rwk -> rwk_Latn_TZ
    { 285,  0,   0 }, { 285, 31, 108 }, // sa -> sa_Deva_IN
    { 279,  0,   0 }, { 279, 29, 189 }, // sah -> sah_Cyrl_RU
    { 281,  0,   0 }, { 281, 74, 122 }, // saq -> saq_Latn_KE
    { 286,  0,   0 }, { 286, 108, 108 }, // sat -> sat_Olck_IN
    { 288,  0,   0 }, { 288, 130, 108 }, // saz -> saz_Saur_IN
    { 284,  0,   0 }, { 284, 74, 226 }, // sbp -> sbp_Latn_TZ
    { 287,  0,   0 }, { 287, 74, 115 }, // sc -> sc_Latn_IT
    { 294,  0,   0 }, { 294, 74, 115 }, // scn -> scn_Latn_IT
    { 297,  0,   0 }, { 297,  4, 174 }, // sd -> sd_Arab_PK
    { 297,  0, 108 }, { 297, 31, 108 }, // sd_IN -> sd_Deva_IN
    { 297, 31,   0 }, { 297, 31, 108 }, // sd_Deva -> sd_Deva_IN
    { 297, 69,   0 }, { 297, 69, 108 }, // sd_Khoj -> sd_Khoj_IN
    { 297, 70,   0 }, { 297, 70, 108 }, // sd_Sind -> sd_Sind_IN
    { 306,  0,   0 }, { 306,  4, 110 }, // sdh -> sdh_Arab_IR
    { 235,  0,   0 }, { 235, 74, 172 }, // se -> se_Latn_NO
    { 289,  0,   0 }, { 289, 74, 156 }, // seh -> seh_Latn_MZ
    { 159,  0,   0 }, { 159, 74, 141 }, // ses -> ses_Latn_ML
    { 283,  0,   0 }, { 283, 74,  46 }, // sg -> sg_Latn_CF
    { 247,  0,   0 }, { 247, 107, 112 }, // sga -> sga_Ogam_IE
    { 318,  0,   0 }, { 318, 155, 155 }, // shi -> shi_Tfng_MA
    { 298,  0,   0 }, { 298, 136, 210 }, // si -> si_Sinh_LK
    { 295,  0,   0 }, { 295, 74,  77 }, // sid -> sid_Latn_ET
    { 300,  0,   0 }, { 300, 74, 201 }, // sk -> sk_Latn_SK
    { 301,  0,   0 }, { 301, 74, 202 }, // sl -> sl_Latn_SI
    { 282,  0,   0 }, { 282, 74, 191 }, // sm -> sm_Latn_WS
    { 307,  0,   0 }, { 307, 74, 221 }, // sma -> sma_Latn_SE
    { 186,  0,   0 }, { 186, 74, 221 }, // smj -> smj_Latn_SE
    { 124,  0,   0 }, { 124, 74,  81 }, // smn -> smn_Latn_FI
    { 280,  0,   0 }, { 280, 129, 114 }, // smp -> smp_Samr_IL
    { 299,  0,   0 }, { 299, 74,  81 }, // sms -> sms_Latn_FI
    { 292,  0,   0 }, { 292, 74, 257 }, // sn -> sn_Latn_ZW
    { 303,  0,   0 }, { 303, 74, 204 }, // so -> so_Latn_SO
    {  10,  0,   0 }, {  10, 74,   3 }, // sq -> sq_Latn_AL
    { 290,  0,   0 }, { 290, 29, 196 }, // sr -> sr_Cyrl_RS
    { 290,  0, 153 }, { 290, 74, 153 }, // sr_ME -> sr_Latn_ME
    { 290,  0, 188 }, { 290, 74, 188 }, // sr_RO -> sr_Latn_RO
    { 290,  0, 189 }, { 290, 74, 189 }, // sr_RU -> sr_Latn_RU
    { 290,  0, 235 }, { 290, 74, 235 }, // sr_TR -> sr_Latn_TR
    { 304,  0,   0 }, { 304, 138, 108 }, // srb -> srb_Sora_IN
    { 313,  0,   0 }, { 313, 74, 205 }, // ss -> ss_Latn_ZA
    { 278,  0,   0 }, { 278, 74,  74 }, // ssy -> ssy_Latn_ER
    { 308,  0,   0 }, { 308, 74, 205 }, // st -> st_Latn_ZA
    { 311,  0,   0 }, { 311, 74, 109 }, // su -> su_Latn_ID
    { 314,  0,   0 }, { 314, 74, 221 }, // sv -> sv_Latn_SE
    { 312,  0,   0 }, { 312, 74, 226 }, // sw -> sw_Latn_TZ
    { 316,  0,   0 }, { 316,  9,  20 }, // syl -> syl_Beng_BD
    { 317,  0,   0 }, { 317, 142, 111 }, // syr -> syr_Syrc_IQ
    { 296,  0,   0 }, { 296, 74, 183 }, // szl -> szl_Latn_PL
    { 325,  0,   0 }, { 325, 149, 108 }, // ta -> ta_Taml_IN
    { 319,  0,   0 }, { 319, 74, 181 }, // tbw -> tbw_Latn_PH
    { 322,  0,   0 }, { 322, 146,  50 }, // tdd -> tdd_Tale_CN
    { 330,  0,   0 }, { 330, 151, 108 }, // te -> te_Telu_IN
    { 331,  0,   0 }, { 331, 74, 239 }, // teo -> teo_Latn_UG
    { 324,  0,   0 }, { 324, 29, 225 }, // tg -> tg_Cyrl_TJ
    { 324,  0, 174 }, { 324,  4, 174 }, // tg_PK -> tg_Arab_PK
    { 324,  4,   0 }, { 324,  4, 174 }, // tg_Arab -> tg_Arab_PK
    { 332,  0,   0 }, { 332, 153, 227 }, // th -> th_Thai_TH
    { 335,  0,   0 }, { 335, 38,  77 }, // ti -> ti_Ethi_ET
    { 334,  0,   0 }, { 334, 38,  74 }, // tig -> tig_Ethi_ER
    { 344,  0,   0 }, { 344, 74, 236 }, // tk -> tk_Latn_TM
    { 337,  0,   0 }, { 337, 74, 230 }, // tkl -> tkl_Latn_TK
    { 342,  0,   0 }, { 342, 74, 205 }, // tn -> tn_Latn_ZA
    { 339,  0,   0 }, { 339, 74, 231 }, // to -> to_Latn_TO
    { 338,  0,   0 }, { 338, 74, 254 }, // tok -> tok_Latn_001
    { 336,  0,   0 }, { 336, 74, 178 }, // tpi -> tpi_Latn_PG
    { 343,  0,   0 }, { 343, 74, 235 }, // tr -> tr_Latn_TR
    { 326,  0,   0 }, { 326, 74, 224 }, // trv -> trv_Latn_TW
    { 340,  0,   0 }, { 340,  4, 174 }, // trw -> trw_Arab_PK
    { 341,  0,   0 }, { 341, 74, 205 }, // ts -> ts_Latn_ZA
    { 328,  0,   0 }, { 328, 29, 189 }, // tt -> tt_Cyrl_RU
    { 345,  0,   0 }, { 345, 74, 238 }, // tvl -> tvl_Latn_TV
    { 327,  0,   0 }, { 327, 74, 165 }, // twq -> twq_Latn_NE
    { 320,  0,   0 }, { 320, 74,  84 }, // ty -> ty_Latn_PF
    {  55,  0,   0 }, {  55, 74, 155 }, // tzm -> tzm_Latn_MA
    { 351,  0,   0 }, { 351,  4,  50 }, // ug -> ug_Arab_CN
    { 351,  0, 121 }, { 351, 29, 121 }, // ug_KZ -> ug_Cyrl_KZ
    { 351,  0, 152 }, { 351, 29, 152 }, // ug_MN -> ug_Cyrl_MN
    { 351, 29,   0 }, { 351, 29, 121 }, // ug_Cyrl -> ug_Cyrl_KZ
    { 347,  0,   0 }, { 347, 159, 223 }, // uga -> uga_Ugar_SY
    { 348,  0,   0 }, { 348, 29, 240 }, // uk -> uk_Cyrl_UA
    { 350,  0,   0 }, { 350,  4, 174 }, // ur -> ur_Arab_PK
    { 352,  0,   0 }, { 352, 74, 247 }, // uz -> uz_Latn_UZ
    { 352,  0,   1 }, { 352,  4,   1 }, // uz_AF -> uz_Arab_AF
    { 352,  0,  50 }, { 352, 29,  50 }, // uz_CN -> uz_Cyrl_CN
    { 352,  4,   0 }, { 352,  4,   1 }, // uz_Arab -> uz_Arab_AF
    { 353,  0,   0 }, { 353, 160, 131 }, // vai -> vai_Vaii_LR
    { 354,  0,   0 }, { 354, 74, 205 }, // ve -> ve_Latn_ZA
    { 355,  0,   0 }, { 355, 74, 251 }, // vi -> vi_Latn_VN
    { 356,  0,   0 }, { 356, 74, 254 }, // vo -> vo_Latn_001
    { 357,  0,   0 }, { 357, 74, 226 }, // vun -> vun_Latn_TZ
    { 358,  0,   0 }, { 358, 74,  23 }, // wa -> wa_Latn_BE
    { 359,  0,   0 }, { 359, 74, 222 }, // wae -> wae_Latn_CH
    { 364,  0,   0 }, { 364, 38,  77 }, // wal -> wal_Ethi_ET
    { 360,  0,   0 }, { 360, 74,  15 }, // wbp -> wbp_Latn_AU
    { 365,  0,   0 }, { 365, 74, 195 }, // wo -> wo_Latn_SN
    {  52,  0,   0 }, {  52, 19, 235 }, // xcr -> xcr_Cari_TR
    { 366,  0,   0 }, { 366, 74, 205 }, // xh -> xh_Latn_ZA
    { 190,  0,   0 }, { 190, 79, 235 }, // xlc -> xlc_Lyci_TR
    { 191,  0,   0 }, { 191, 80, 235 }, // xld -> xld_Lydi_TR
    { 202,  0,   0 }, { 202, 85,  50 }, // xmn -> xmn_Mani_CN
    { 212,  0,   0 }, { 212, 91, 218 }, // xmr -> xmr_Merc_SD
    {  13,  0,   0 }, {  13, 111, 194 }, // xna -> xna_Narb_SA
    { 302,  0,   0 }, { 302, 74, 239 }, // xog -> xog_Latn_UG
    { 258,  0,   0 }, { 258, 57, 110 }, // xpr -> xpr_Prti_IR
    { 277,  0,   0 }, { 277, 115, 255 }, // xsa -> xsa_Sarb_YE
    { 367,  0,   0 }, { 367, 74,  40 }, // yav -> yav_Latn_CM
    { 368,  0,   0 }, { 368, 53, 254 }, // yi -> yi_Hebr_001
    { 369,  0,   0 }, { 369, 74, 166 }, // yo -> yo_Latn_NG
    { 229,  0,   0 }, { 229, 74,  32 }, // yrl -> yrl_Latn_BR
    {  51,  0,   0 }, {  51, 158, 105 }, // yue -> yue_Hant_HK
    {  51,  0,  50 }, {  51, 135,  50 }, // yue_CN -> yue_Hans_CN
    {  51, 135,   0 }, {  51, 135,  50 }, // yue_Hans -> yue_Hans_CN
    { 371,  0,   0 }, { 371, 74,  50 }, // za -> za_Latn_CN
    { 310,  0,   0 }, { 310, 155, 155 }, // zgh -> zgh_Tfng_MA
    {  63,  0,   0 }, {  63, 135,  50 }, // zh -> zh_Hans_CN
    {  63,  0,  15 }, {  63, 158,  15 }, // zh_AU -> zh_Hant_AU
    {  63,  0,  35 }, {  63, 158,  35 }, // zh_BN -> zh_Hant_BN
    {  63,  0, 242 }, {  63, 158, 242 }, // zh_GB -> zh_Hant_GB
    {  63,  0,  83 }, {  63, 158,  83 }, // zh_GF -> zh_Hant_GF
    {  63,  0, 105 }, {  63, 158, 105 }, // zh_HK -> zh_Hant_HK
    {  63,  0, 109 }, {  63, 158, 109 }, // zh_ID -> zh_Hant_ID
    {  63,  0, 136 }, {  63, 158, 136 }, // zh_MO -> zh_Hant_MO
    {  63,  0, 177 }, {  63, 158, 177 }, // zh_PA -> zh_Hant_PA
    {  63,  0,  84 }, {  63, 158,  84 }, // zh_PF -> zh_Hant_PF
    {  63,  0, 181 }, {  63, 158, 181 }, // zh_PH -> zh_Hant_PH
    {  63,  0, 219 }, {  63, 158, 219 }, // zh_SR -> zh_Hant_SR
    {  63,  0, 227 }, {  63, 158, 227 }, // zh_TH -> zh_Hant_TH
    {  63,  0, 224 }, {  63, 158, 224 }, // zh_TW -> zh_Hant_TW
    {  63,  0, 243 }, {  63, 158, 243 }, // zh_US -> zh_Hant_US
    {  63,  0, 251 }, {  63, 158, 251 }, // zh_VN -> zh_Hant_VN
    {  63, 13,   0 }, {  63, 13, 224 }, // zh_Bopo -> zh_Bopo_TW
    {  63, 158,   0 }, {  63, 158, 224 }, // zh_Hant -> zh_Hant_TW
    { 372,  0,   0 }, { 372, 74, 205 }, // zu -> zu_Latn_ZA
    {   0,  0,   6 }, {  53, 74,   6 }, // und_AD -> ca_Latn_AD
    {   0,  0, 241 }, {  16,  4, 241 }, // und_AE -> ar_Arab_AE
    {   0,  0,   1 }, { 260,  4,   1 }, // und_AF -> fa_Arab_AF
    {   0,  0,   3 }, {  10, 74,   3 }, // und_AL -> sq_Latn_AL
    {   0,  0,  12 }, {  19,  5,  12 }, // und_AM -> hy_Armn_AM
    {   0,  0,   7 }, { 264, 74,   7 }, // und_AO -> pt_Latn_AO
    {   0,  0,   9 }, {   0, 74,   9 }, // und_AQ -> und_Latn_AQ
    {   0,  0,  11 }, { 309, 74,  11 }, // und_AR -> es_Latn_AR
    {   0,  0,   5 }, { 282, 74,   5 }, // und_AS -> sm_Latn_AS
    {   0,  0,  16 }, { 103, 74,  16 }, // und_AT -> de_Latn_AT
    {   0,  0,  13 }, {  78, 74,  13 }, // und_AW -> nl_Latn_AW
    {   0,  0,  14 }, { 314, 74,  14 }, // und_AX -> sv_Latn_AX
    {   0,  0,  17 }, {  27, 74,  17 }, // und_AZ -> az_Latn_AZ
    {   0,  0,  29 }, {  45, 74,  29 }, // und_BA -> bs_Latn_BA
    {   0,  0,  20 }, {  33,  9,  20 }, // und_BD -> bn_Beng_BD
    {   0,  0,  23 }, {  78, 74,  23 }, // und_BE -> nl_Latn_BE
    {   0,  0,  37 }, {  94, 74,  37 }, // und_BF -> fr_Latn_BF
    {   0,  0,  36 }, {  49, 29,  36 }, // und_BG -> bg_Cyrl_BG
    {   0,  0,  19 }, {  16,  4,  19 }, // und_BH -> ar_Arab_BH
    {   0,  0,  38 }, { 274, 74,  38 }, // und_BI -> rn_Latn_BI
    {   0,  0,  25 }, {  94, 74,  25 }, // und_BJ -> fr_Latn_BJ
    {   0,  0, 211 }, {  94, 74, 211 }, // und_BL -> fr_Latn_BL
    {   0,  0,  35 }, { 198, 74,  35 }, // und_BN -> ms_Latn_BN
    {   0,  0,  28 }, { 309, 74,  28 }, // und_BO -> es_Latn_BO
    {   0,  0,  44 }, { 257, 74,  44 }, // und_BQ -> pap_Latn_BQ
    {   0,  0,  32 }, { 264, 74,  32 }, // und_BR -> pt_Latn_BR
    {   0,  0,  27 }, {  79, 154,  27 }, // und_BT -> dz_Tibt_BT
    {   0,  0,  31 }, {   0, 74,  31 }, // und_BV -> und_Latn_BV
    {   0,  0,  22 }, {  38, 29,  22 }, // und_BY -> be_Cyrl_BY
    {   0,  0,  57 }, { 312, 74,  57 }, // und_CD -> sw_Latn_CD
    {   0,  0,  46 }, {  94, 74,  46 }, // und_CF -> fr_Latn_CF
    {   0,  0,  56 }, {  94, 74,  56 }, // und_CG -> fr_Latn_CG
    {   0,  0, 222 }, { 103, 74, 222 }, // und_CH -> de_Latn_CH
    {   0,  0, 116 }, {  94, 74, 116 }, // und_CI -> fr_Latn_CI
    {   0,  0,  49 }, { 309, 74,  49 }, // und_CL -> es_Latn_CL
    {   0,  0,  40 }, {  94, 74,  40 }, // und_CM -> fr_Latn_CM
    {   0,  0,  50 }, {  63, 135,  50 }, // und_CN -> zh_Hans_CN
    {   0,  0,  54 }, { 309, 74,  54 }, // und_CO -> es_Latn_CO
    {   0,  0,  52 }, {   0, 74,  52 }, // und_CP -> und_Latn_CP
    {   0,  0,  59 }, { 309, 74,  59 }, // und_CR -> es_Latn_CR
    {   0,  0,  61 }, { 309, 74,  61 }, // und_CU -> es_Latn_CU
    {   0,  0,  43 }, { 264, 74,  43 }, // und_CV -> pt_Latn_CV
    {   0,  0,  62 }, { 257, 74,  62 }, // und_CW -> pap_Latn_CW
    {   0,  0,  63 }, { 105, 44,  63 }, // und_CY -> el_Grek_CY
    {   0,  0,  64 }, {  73, 74,  64 }, // und_CZ -> cs_Latn_CZ
    {   0,  0,  89 }, { 103, 74,  89 }, // und_DE -> de_Latn_DE
    {   0,  0,  67 }, {   4, 74,  67 }, // und_DJ -> aa_Latn_DJ
    {   0,  0,  65 }, {  74, 74,  65 }, // und_DK -> da_Latn_DK
    {   0,  0,  69 }, { 309, 74,  69 }, // und_DO -> es_Latn_DO
    {   0,  0,   4 }, {  16,  4,   4 }, // und_DZ -> ar_Arab_DZ
    {   0,  0,  47 }, { 309, 74,  47 }, // und_EA -> es_Latn_EA
    {   0,  0,  70 }, { 309, 74,  70 }, // und_EC -> es_Latn_EC
    {   0,  0,  75 }, {  86, 74,  75 }, // und_EE -> et_Latn_EE
    {   0,  0,  71 }, {  16,  4,  71 }, // und_EG -> ar_Arab_EG
    {   0,  0, 253 }, {  16,  4, 253 }, // und_EH -> ar_Arab_EH
    {   0,  0,  74 }, { 335, 38,  74 }, // und_ER -> ti_Ethi_ER
    {   0,  0, 209 }, { 309, 74, 209 }, // und_ES -> es_Latn_ES
    {   0,  0,  77 }, {  12, 38,  77 }, // und_ET -> am_Ethi_ET
    {   0,  0,  81 }, {  93, 74,  81 }, // und_FI -> fi_Latn_FI
    {   0,  0,  79 }, {  90, 74,  79 }, // und_FO -> fo_Latn_FO
    {   0,  0,  82 }, {  94, 74,  82 }, // und_FR -> fr_Latn_FR
    {   0,  0,  86 }, {  94, 74,  86 }, // und_GA -> fr_Latn_GA
    {   0,  0,  88 }, { 102, 40,  88 }, // und_GE -> ka_Geor_GE
    {   0,  0,  83 }, {  94, 74,  83 }, // und_GF -> fr_Latn_GF
    {   0,  0,  90 }, {   7, 74,  90 }, // und_GH -> ak_Latn_GH
    {   0,  0,  93 }, { 141, 74,  93 }, // und_GL -> kl_Latn_GL
    {   0,  0,  99 }, {  94, 74,  99 }, // und_GN -> fr_Latn_GN
    {   0,  0,  95 }, {  94, 74,  95 }, // und_GP -> fr_Latn_GP
    {   0,  0,  73 }, { 309, 74,  73 }, // und_GQ -> es_Latn_GQ
    {   0,  0,  92 }, { 105, 44,  92 }, // und_GR -> el_Grek_GR
    {   0,  0, 206 }, {   0, 74, 206 }, // und_GS -> und_Latn_GS
    {   0,  0,  97 }, { 309, 74,  97 }, // und_GT -> es_Latn_GT
    {   0,  0, 100 }, { 264, 74, 100 }, // und_GW -> pt_Latn_GW
    {   0,  0, 105 }, {  63, 158, 105 }, // und_HK -> zh_Hant_HK
    {   0,  0, 103 }, {   0, 74, 103 }, // und_HM -> und_Latn_HM
    {   0,  0, 104 }, { 309, 74, 104 }, // und_HN -> es_Latn_HN
    {   0,  0,  60 }, {  72, 74,  60 }, // und_HR -> hr_Latn_HR
    {   0,  0, 102 }, { 109, 74, 102 }, // und_HT -> ht_Latn_HT
    {   0,  0, 106 }, { 120, 74, 106 }, // und_HU -> hu_Latn_HU
    {   0,  0,  42 }, { 309, 74,  42 }, // und_IC -> es_Latn_IC
    {   0,  0, 109 }, { 125, 74, 109 }, // und_ID -> id_Latn_ID
    {   0,  0, 114 }, { 114, 53, 114 }, // und_IL -> he_Hebr_IL
    {   0,  0, 108 }, { 116, 31, 108 }, // und_IN -> hi_Deva_IN
    {   0,  0, 111 }, {  16,  4, 111 }, // und_IQ -> ar_Arab_IQ
    {   0,  0, 110 }, { 260,  4, 110 }, // und_IR -> fa_Arab_IR
    {   0,  0, 107 }, { 121, 74, 107 }, // und_IS -> is_Latn_IS
    {   0,  0, 115 }, { 132, 74, 115 }, // und_IT -> it_Latn_IT
    {   0,  0, 120 }, {  16,  4, 120 }, // und_JO -> ar_Arab_JO
    {   0,  0, 118 }, { 133, 59, 118 }, // und_JP -> ja_Jpan_JP
    {   0,  0, 122 }, { 312, 74, 122 }, // und_KE -> sw_Latn_KE
    {   0,  0, 126 }, { 164, 29, 126 }, // und_KG -> ky_Cyrl_KG
    {   0,  0,  39 }, { 149, 68,  39 }, // und_KH -> km_Khmr_KH
    {   0,  0,  55 }, {  16,  4,  55 }, // und_KM -> ar_Arab_KM
    {   0,  0, 169 }, { 156, 71, 169 }, // und_KP -> ko_Kore_KP
    {   0,  0, 207 }, { 156, 71, 207 }, // und_KR -> ko_Kore_KR
    {   0,  0, 125 }, {  16,  4, 125 }, // und_KW -> ar_Arab_KW
    {   0,  0, 121 }, { 275, 29, 121 }, // und_KZ -> ru_Cyrl_KZ
    {   0,  0, 127 }, { 167, 73, 127 }, // und_LA -> lo_Laoo_LA
    {   0,  0, 129 }, {  16,  4, 129 }, // und_LB -> ar_Arab_LB
    {   0,  0, 133 }, { 103, 74, 133 }, // und_LI -> de_Latn_LI
    {   0,  0, 210 }, { 298, 136, 210 }, // und_LK -> si_Sinh_LK
    {   0,  0, 130 }, { 308, 74, 130 }, // und_LS -> st_Latn_LS
    {   0,  0, 134 }, { 180, 74, 134 }, // und_LT -> lt_Latn_LT
    {   0,  0, 135 }, {  94, 74, 135 }, // und_LU -> fr_Latn_LU
    {   0,  0, 128 }, { 170, 74, 128 }, // und_LV -> lv_Latn_LV
    {   0,  0, 132 }, {  16,  4, 132 }, // und_LY -> ar_Arab_LY
    {   0,  0, 155 }, {  16,  4, 155 }, // und_MA -> ar_Arab_MA
    {   0,  0, 151 }, {  94, 74, 151 }, // und_MC -> fr_Latn_MC
    {   0,  0, 150 }, { 271, 74, 150 }, // und_MD -> ro_Latn_MD
    {   0,  0, 153 }, { 290, 74, 153 }, // und_ME -> sr_Latn_ME
    {   0,  0, 215 }, {  94, 74, 215 }, // und_MF -> fr_Latn_MF
    {   0,  0, 137 }, { 197, 74, 137 }, // und_MG -> mg_Latn_MG
    {   0,  0, 170 }, { 192, 29, 170 }, // und_MK -> mk_Cyrl_MK
    {   0,  0, 141 }, {  31, 74, 141 }, // und_ML -> bm_Latn_ML
    {   0,  0, 157 }, {  50, 97, 157 }, // und_MM -> my_Mymr_MM
    {   0,  0, 152 }, { 217, 29, 152 }, // und_MN -> mn_Cyrl_MN
    {   0,  0, 136 }, {  63, 158, 136 }, // und_MO -> zh_Hant_MO
    {   0,  0, 144 }, {  94, 74, 144 }, // und_MQ -> fr_Latn_MQ
    {   0,  0, 145 }, {  16,  4, 145 }, // und_MR -> ar_Arab_MR
    {   0,  0, 142 }, { 200, 74, 142 }, // und_MT -> mt_Latn_MT
    {   0,  0, 146 }, { 218, 74, 146 }, // und_MU -> mfe_Latn_MU
    {   0,  0, 140 }, {  75, 152, 140 }, // und_MV -> dv_Thaa_MV
    {   0,  0, 148 }, { 309, 74, 148 }, // und_MX -> es_Latn_MX
    {   0,  0, 139 }, { 198, 74, 139 }, // und_MY -> ms_Latn_MY
    {   0,  0, 156 }, { 264, 74, 156 }, // und_MZ -> pt_Latn_MZ
    {   0,  0, 158 }, {   5, 74, 158 }, // und_NA -> af_Latn_NA
    {   0,  0, 162 }, {  94, 74, 162 }, // und_NC -> fr_Latn_NC
    {   0,  0, 165 }, { 112, 74, 165 }, // und_NE -> ha_Latn_NE
    {   0,  0, 164 }, { 309, 74, 164 }, // und_NI -> es_Latn_NI
    {   0,  0, 161 }, {  78, 74, 161 }, // und_NL -> nl_Latn_NL
    {   0,  0, 172 }, { 238, 74, 172 }, // und_NO -> nb_Latn_NO
    {   0,  0, 160 }, { 225, 31, 160 }, // und_NP -> ne_Deva_NP
    {   0,  0, 173 }, {  16,  4, 173 }, // und_OM -> ar_Arab_OM
    {   0,  0, 177 }, { 309, 74, 177 }, // und_PA -> es_Latn_PA
    {   0,  0, 180 }, { 309, 74, 180 }, // und_PE -> es_Latn_PE
    {   0,  0,  84 }, {  94, 74,  84 }, // und_PF -> fr_Latn_PF
    {   0,  0, 178 }, { 336, 74, 178 }, // und_PG -> tpi_Latn_PG
    {   0,  0, 181 }, {  92, 74, 181 }, // und_PH -> fil_Latn_PH
    {   0,  0, 174 }, { 350,  4, 174 }, // und_PK -> ur_Arab_PK
    {   0,  0, 183 }, { 263, 74, 183 }, // und_PL -> pl_Latn_PL
    {   0,  0, 216 }, {  94, 74, 216 }, // und_PM -> fr_Latn_PM
    {   0,  0, 185 }, { 309, 74, 185 }, // und_PR -> es_Latn_PR
    {   0,  0, 176 }, {  16,  4, 176 }, // und_PS -> ar_Arab_PS
    {   0,  0, 184 }, { 264, 74, 184 }, // und_PT -> pt_Latn_PT
    {   0,  0, 175 }, { 255, 74, 175 }, // und_PW -> pau_Latn_PW
    {   0,  0, 179 }, { 106, 74, 179 }, // und_PY -> gn_Latn_PY
    {   0,  0, 186 }, {  16,  4, 186 }, // und_QA -> ar_Arab_QA
    {   0,  0, 187 }, {  94, 74, 187 }, // und_RE -> fr_Latn_RE
    {   0,  0, 188 }, { 271, 74, 188 }, // und_RO -> ro_Latn_RO
    {   0,  0, 196 }, { 290, 29, 196 }, // und_RS -> sr_Cyrl_RS
    {   0,  0, 189 }, { 275, 29, 189 }, // und_RU -> ru_Cyrl_RU
    {   0,  0, 190 }, { 152, 74, 190 }, // und_RW -> rw_Latn_RW
    {   0,  0, 194 }, {  16,  4, 194 }, // und_SA -> ar_Arab_SA
    {   0,  0, 197 }, {  94, 74, 197 }, // und_SC -> fr_Latn_SC
    {   0,  0, 218 }, {  16,  4, 218 }, // und_SD -> ar_Arab_SD
    {   0,  0, 221 }, { 314, 74, 221 }, // und_SE -> sv_Latn_SE
    {   0,  0, 202 }, { 301, 74, 202 }, // und_SI -> sl_Latn_SI
    {   0,  0, 220 }, { 238, 74, 220 }, // und_SJ -> nb_Latn_SJ
    {   0,  0, 201 }, { 300, 74, 201 }, // und_SK -> sk_Latn_SK
    {   0,  0, 192 }, { 132, 74, 192 }, // und_SM -> it_Latn_SM
    {   0,  0, 195 }, {  94, 74, 195 }, // und_SN -> fr_Latn_SN
    {   0,  0, 204 }, { 303, 74, 204 }, // und_SO -> so_Latn_SO
    {   0,  0, 219 }, {  78, 74, 219 }, // und_SR -> nl_Latn_SR
    {   0,  0, 193 }, { 264, 74, 193 }, // und_ST -> pt_Latn_ST
    {   0,  0,  72 }, { 309, 74,  72 }, // und_SV -> es_Latn_SV
    {   0,  0, 223 }, {  16,  4, 223 }, // und_SY -> ar_Arab_SY
    {   0,  0,  48 }, {  94, 74,  48 }, // und_TD -> fr_Latn_TD
    {   0,  0,  85 }, {  94, 74,  85 }, // und_TF -> fr_Latn_TF
    {   0,  0, 229 }, {  94, 74, 229 }, // und_TG -> fr_Latn_TG
    {   0,  0, 227 }, { 332, 153, 227 }, // und_TH -> th_Thai_TH
    {   0,  0, 225 }, { 324, 29, 225 }, // und_TJ -> tg_Cyrl_TJ
    {   0,  0, 230 }, { 337, 74, 230 }, // und_TK -> tkl_Latn_TK
    {   0,  0, 228 }, { 264, 74, 228 }, // und_TL -> pt_Latn_TL
    {   0,  0, 236 }, { 344, 74, 236 }, // und_TM -> tk_Latn_TM
    {   0,  0, 234 }, {  16,  4, 234 }, // und_TN -> ar_Arab_TN
    {   0,  0, 231 }, { 339, 74, 231 }, // und_TO -> to_Latn_TO
    {   0,  0, 235 }, { 343, 74, 235 }, // und_TR -> tr_Latn_TR
    {   0,  0, 238 }, { 345, 74, 238 }, // und_TV -> tvl_Latn_TV
    {   0,  0, 224 }, {  63, 158, 224 }, // und_TW -> zh_Hant_TW
    {   0,  0, 226 }, { 312, 74, 226 }, // und_TZ -> sw_Latn_TZ
    {   0,  0, 240 }, { 348, 29, 240 }, // und_UA -> uk_Cyrl_UA
    {   0,  0, 239 }, { 312, 74, 239 }, // und_UG -> sw_Latn_UG
    {   0,  0, 246 }, { 309, 74, 246 }, // und_UY -> es_Latn_UY
    {   0,  0, 247 }, { 352, 74, 247 }, // und_UZ -> uz_Latn_UZ
    {   0,  0, 249 }, { 132, 74, 249 }, // und_VA -> it_Latn_VA
    {   0,  0, 250 }, { 309, 74, 250 }, // und_VE -> es_Latn_VE
    {   0,  0, 251 }, { 355, 74, 251 }, // und_VN -> vi_Latn_VN
    {   0,  0, 248 }, {  42, 74, 248 }, // und_VU -> bi_Latn_VU
    {   0,  0, 252 }, {  94, 74, 252 }, // und_WF -> fr_Latn_WF
    {   0,  0, 191 }, { 282, 74, 191 }, // und_WS -> sm_Latn_WS
    {   0,  0, 124 }, {  10, 74, 124 }, // und_XK -> sq_Latn_XK
    {   0,  0, 255 }, {  16,  4, 255 }, // und_YE -> ar_Arab_YE
    {   0,  0, 147 }, {  94, 74, 147 }, // und_YT -> fr_Latn_YT
    {   0,  0, 257 }, { 292, 74, 257 }, // und_ZW -> sn_Latn_ZW
    {   0,  1,   0 }, {  96,  1,  99 }, // und_Adlm -> ff_Adlm_GN
    {   0,  4,   0 }, {  16,  4,  71 }, // und_Arab -> ar_Arab_EG
    {   0,  4,  53 }, { 198,  4,  53 }, // und_Arab_CC -> ms_Arab_CC
    {   0,  4,  50 }, { 351,  4,  50 }, // und_Arab_CN -> ug_Arab_CN
    {   0,  4, 242 }, { 350,  4, 242 }, // und_Arab_GB -> ur_Arab_GB
    {   0,  4, 109 }, { 198,  4, 109 }, // und_Arab_ID -> ms_Arab_ID
    {   0,  4, 108 }, { 350,  4, 108 }, // und_Arab_IN -> ur_Arab_IN
    {   0,  4, 157 }, { 270,  4, 157 }, // und_Arab_MM -> rhg_Arab_MM
    {   0,  4, 152 }, { 147,  4, 152 }, // und_Arab_MN -> kk_Arab_MN
    {   0,  4, 146 }, { 350,  4, 146 }, // und_Arab_MU -> ur_Arab_MU
    {   0,  4, 166 }, { 112,  4, 166 }, // und_Arab_NG -> ha_Arab_NG
    {   0,  4, 174 }, { 350,  4, 174 }, // und_Arab_PK -> ur_Arab_PK
    {   0,  4, 225 }, { 260,  4, 225 }, // und_Arab_TJ -> fa_Arab_TJ
    {   0, 55,   0 }, {  18, 55, 110 }, // und_Armi -> arc_Armi_IR
    {   0,  5,   0 }, {  19,  5,  12 }, // und_Armn -> hy_Armn_AM
    {   0,  6,   0 }, {  25,  6, 110 }, // und_Avst -> ae_Avst_IR
    {   0,  7,   0 }, {  29,  7, 109 }, // und_Bali -> ban_Bali_ID
    {   0,  8,   0 }, {  32,  8,  40 }, // und_Bamu -> bax_Bamu_CM
    {   0, 11,   0 }, {  37, 11, 109 }, // und_Batk -> bbc_Batk_ID
    {   0,  9,   0 }, {  33,  9,  20 }, // und_Beng -> bn_Beng_BD
    {   0, 12,   0 }, { 285, 12, 108 }, // und_Bhks -> sa_Bhks_IN
    {   0, 13,   0 }, {  63, 13, 224 }, // und_Bopo -> zh_Bopo_TW
    {   0, 15,   0 }, {  94, 15,  82 }, // und_Brai -> fr_Brai_FR
    {   0, 16,   0 }, {  47, 16, 109 }, // und_Bugi -> bug_Bugi_ID
    {   0, 17,   0 }, {  48, 17, 181 }, // und_Buhd -> bku_Buhd_PH
    {   0, 21,   0 }, {  57, 21,  20 }, // und_Cakm -> ccp_Cakm_BD
    {   0, 18,   0 }, { 129, 18,  41 }, // und_Cans -> iu_Cans_CA
    {   0, 19,   0 }, {  52, 19, 235 }, // und_Cari -> xcr_Cari_TR
    {   0, 22,   0 }, {  80, 22, 251 }, // und_Cham -> cjm_Cham_VN
    {   0, 23,   0 }, {  60, 23, 243 }, // und_Cher -> chr_Cher_US
    {   0, 25,   0 }, {  68, 25,  71 }, // und_Copt -> cop_Copt_EG
    {   0, 28,   0 }, {   0, 28,  63 }, // und_Cpmn -> und_Cpmn_CY
    {   0, 28,  63 }, {   0, 28,  63 }, // und_Cpmn_CY -> und_Cpmn_CY
    {   0, 27,   0 }, {  15, 27,  63 }, // und_Cprt -> grc_Cprt_CY
    {   0, 29,   0 }, { 275, 29, 189 }, // und_Cyrl -> ru_Cyrl_RU
    {   0, 29,   3 }, { 192, 29,   3 }, // und_Cyrl_AL -> mk_Cyrl_AL
    {   0, 29,  29 }, { 290, 29,  29 }, // und_Cyrl_BA -> sr_Cyrl_BA
    {   0, 29,  88 }, {   3, 29,  88 }, // und_Cyrl_GE -> ab_Cyrl_GE
    {   0, 29,  92 }, { 192, 29,  92 }, // und_Cyrl_GR -> mk_Cyrl_GR
    {   0, 29, 150 }, { 348, 29, 150 }, // und_Cyrl_MD -> uk_Cyrl_MD
    {   0, 29, 188 }, {  49, 29, 188 }, // und_Cyrl_RO -> bg_Cyrl_RO
    {   0, 29, 201 }, { 348, 29, 201 }, // und_Cyrl_SK -> uk_Cyrl_SK
    {   0, 29, 124 }, { 290, 29, 124 }, // und_Cyrl_XK -> sr_Cyrl_XK
    {   0, 31,   0 }, { 116, 31, 108 }, // und_Deva -> hi_Deva_IN
    {   0, 31,  27 }, { 225, 31,  27 }, // und_Deva_BT -> ne_Deva_BT
    {   0, 31, 146 }, {  41, 31, 146 }, // und_Deva_MU -> bho_Deva_MU
    {   0, 32,   0 }, {  75, 32, 140 }, // und_Diak -> dv_Diak_MV
    {   0, 33,   0 }, {  76, 33, 108 }, // und_Dogr -> doi_Dogr_IN
    {   0, 34,   0 }, {  94, 34,  82 }, // und_Dupl -> fr_Dupl_FR
    {   0, 35,   0 }, {  14, 35,  71 }, // und_Egyp -> egy_Egyp_EG
    {   0, 36,   0 }, {  10, 36,   3 }, // und_Elba -> sq_Elba_AL
    {   0, 37,   0 }, {  18, 37, 110 }, // und_Elym -> arc_Elym_IR
    {   0, 38,   0 }, {  12, 38,  77 }, // und_Ethi -> am_Ethi_ET
    {   0, 40,   0 }, { 102, 40,  88 }, // und_Geor -> ka_Geor_GE
    {   0, 41,   0 }, {  64, 41,  36 }, // und_Glag -> cu_Glag_BG
    {   0, 42,   0 }, { 104, 42, 240 }, // und_Goth -> got_Goth_UA
    {   0, 43,   0 }, { 285, 43, 108 }, // und_Gran -> sa_Gran_IN
    {   0, 44,   0 }, { 105, 44,  92 }, // und_Grek -> el_Grek_GR
    {   0, 45,   0 }, { 107, 45, 108 }, // und_Gujr -> gu_Gujr_IN
    {   0, 47,   0 }, { 266, 47, 108 }, // und_Guru -> pa_Guru_IN
    {   0, 49,   0 }, { 156, 49, 207 }, // und_Hang -> ko_Hang_KR
    {   0, 48,   0 }, {  63, 48,  50 }, // und_Hani -> zh_Hani_CN
    {   0, 51,   0 }, { 110, 51, 181 }, // und_Hano -> hnn_Hano_PH
    {   0, 135,   0 }, {  63, 135,  50 }, // und_Hans -> zh_Hans_CN
    {   0, 158,   0 }, {  63, 158, 224 }, // und_Hant -> zh_Hant_TW
    {   0, 158,  41 }, {  51, 158,  41 }, // und_Hant_CA -> yue_Hant_CA
    {   0, 53,   0 }, { 114, 53, 114 }, // und_Hebr -> he_Hebr_IL
    {   0, 53, 221 }, { 368, 53, 221 }, // und_Hebr_SE -> yi_Hebr_SE
    {   0, 53, 240 }, { 368, 53, 240 }, // und_Hebr_UA -> yi_Hebr_UA
    {   0, 53, 243 }, { 368, 53, 243 }, // und_Hebr_US -> yi_Hebr_US
    {   0, 54,   0 }, { 133, 54, 118 }, // und_Hira -> ja_Hira_JP
    {   0, 120,   0 }, { 118, 120, 127 }, // und_Hmng -> hnj_Hmng_LA
    {   0, 105,   0 }, { 118, 105, 243 }, // und_Hmnp -> hnj_Hmnp_US
    {   0, 109,   0 }, { 120, 109, 106 }, // und_Hung -> hu_Hung_HU
    {   0, 110,   0 }, {  87, 110, 115 }, // und_Ital -> ett_Ital_IT
    {   0, 58,   0 }, { 156, 58, 207 }, // und_Jamo -> ko_Jamo_KR
    {   0, 60,   0 }, { 134, 60, 109 }, // und_Java -> jv_Java_ID
    {   0, 59,   0 }, { 133, 59, 118 }, // und_Jpan -> ja_Jpan_JP
    {   0, 65,   0 }, {  81, 65, 157 }, // und_Kali -> eky_Kali_MM
    {   0, 63,   0 }, { 133, 63, 118 }, // und_Kana -> ja_Kana_JP
    {   0, 68,   0 }, { 149, 68,  39 }, // und_Khmr -> km_Khmr_KH
    {   0, 69,   0 }, { 297, 69, 108 }, // und_Khoj -> sd_Khoj_IN
    {   0, 62,   0 }, { 144, 62, 108 }, // und_Knda -> kn_Knda_IN
    {   0, 71,   0 }, { 156, 71, 207 }, // und_Kore -> ko_Kore_KR
    {   0, 61,   0 }, {  41, 61, 108 }, // und_Kthi -> bho_Kthi_IN
    {   0, 72,   0 }, { 237, 72, 227 }, // und_Lana -> nod_Lana_TH
    {   0, 73,   0 }, { 167, 73, 127 }, // und_Laoo -> lo_Laoo_LA
    {   0, 73,  15 }, { 118, 73,  15 }, // und_Laoo_AU -> hnj_Laoo_AU
    {   0, 73,  50 }, { 118, 73,  50 }, // und_Laoo_CN -> hnj_Laoo_CN
    {   0, 73,  82 }, { 118, 73,  82 }, // und_Laoo_FR -> hnj_Laoo_FR
    {   0, 73,  83 }, { 118, 73,  83 }, // und_Laoo_GF -> hnj_Laoo_GF
    {   0, 73, 157 }, { 118, 73, 157 }, // und_Laoo_MM -> hnj_Laoo_MM
    {   0, 73, 219 }, { 118, 73, 219 }, // und_Laoo_SR -> hnj_Laoo_SR
    {   0, 73, 227 }, { 118, 73, 227 }, // und_Laoo_TH -> hnj_Laoo_TH
    {   0, 73, 243 }, { 118, 73, 243 }, // und_Laoo_US -> hnj_Laoo_US
    {   0, 73, 251 }, { 118, 73, 251 }, // und_Laoo_VN -> hnj_Laoo_VN
    {   0, 74,   1 }, { 344, 74,   1 }, // und_Latn_AF -> tk_Latn_AF
    {   0, 74,  12 }, { 162, 74,  12 }, // und_Latn_AM -> ku_Latn_AM
    {   0, 74,  50 }, { 371, 74,  50 }, // und_Latn_CN -> za_Latn_CN
    {   0, 74,  63 }, { 343, 74,  63 }, // und_Latn_CY -> tr_Latn_CY
    {   0, 74,   4 }, {  94, 74,   4 }, // und_Latn_DZ -> fr_Latn_DZ
    {   0, 74,  77 }, {  83, 74,  77 }, // und_Latn_ET -> en_Latn_ET
    {   0, 74,  88 }, { 162, 74,  88 }, // und_Latn_GE -> ku_Latn_GE
    {   0, 74, 110 }, { 344, 74, 110 }, // und_Latn_IR -> tk_Latn_IR
    {   0, 74,  55 }, {  94, 74,  55 }, // und_Latn_KM -> fr_Latn_KM
    {   0, 74, 155 }, {  94, 74, 155 }, // und_Latn_MA -> fr_Latn_MA
    {   0, 74, 170 }, {  10, 74, 170 }, // und_Latn_MK -> sq_Latn_MK
    {   0, 74, 136 }, { 264, 74, 136 }, // und_Latn_MO -> pt_Latn_MO
    {   0, 74, 145 }, {  94, 74, 145 }, // und_Latn_MR -> fr_Latn_MR
    {   0, 74, 223 }, {  94, 74, 223 }, // und_Latn_SY -> fr_Latn_SY
    {   0, 74, 234 }, {  94, 74, 234 }, // und_Latn_TN -> fr_Latn_TN
    {   0, 74, 224 }, { 326, 74, 224 }, // und_Latn_TW -> trv_Latn_TW
    {   0, 74, 240 }, { 263, 74, 240 }, // und_Latn_UA -> pl_Latn_UA
    {   0, 75,   0 }, { 171, 75, 108 }, // und_Lepc -> lep_Lepc_IN
    {   0, 76,   0 }, { 174, 76, 108 }, // und_Limb -> lif_Limb_IN
    {   0, 77,   0 }, { 176, 77,  92 }, // und_Lina -> lab_Lina_GR
    {   0, 78,   0 }, {  15, 78,  92 }, // und_Linb -> grc_Linb_GR
    {   0, 39,   0 }, { 178, 39,  50 }, // und_Lisu -> lis_Lisu_CN
    {   0, 79,   0 }, { 190, 79, 235 }, // und_Lyci -> xlc_Lyci_TR
    {   0, 80,   0 }, { 191, 80, 235 }, // und_Lydi -> xld_Lydi_TR
    {   0, 81,   0 }, { 116, 81, 108 }, // und_Mahj -> hi_Mahj_IN
    {   0, 84,   0 }, {  66, 84, 110 }, // und_Mand -> myz_Mand_IR
    {   0, 85,   0 }, { 202, 85,  50 }, // und_Mani -> xmn_Mani_CN
    {   0, 86,   0 }, { 333, 86,  50 }, // und_Marc -> bo_Marc_CN
    {   0, 90,   0 }, { 211, 90, 198 }, // und_Mend -> men_Mend_SL
    {   0, 91,   0 }, { 212, 91, 218 }, // und_Merc -> xmr_Merc_SD
    {   0, 92,   0 }, { 212, 92, 218 }, // und_Mero -> xmr_Mero_SD
    {   0, 83,   0 }, { 199, 83, 108 }, // und_Mlym -> ml_Mlym_IN
    {   0, 93,   0 }, { 207, 93, 108 }, // und_Modi -> mr_Modi_IN
    {   0, 94,   0 }, { 217, 94,  50 }, // und_Mong -> mn_Mong_CN
    {   0, 89,   0 }, { 203, 89, 108 }, // und_Mtei -> mni_Mtei_IN
    {   0, 97,   0 }, {  50, 97, 157 }, // und_Mymr -> my_Mymr_MM
    {   0, 100,   0 }, { 285, 100, 108 }, // und_Nand -> sa_Nand_IN
    {   0, 111,   0 }, {  13, 111, 194 }, // und_Narb -> xna_Narb_SA
    {   0, 98,   0 }, {  18, 98, 120 }, // und_Nbat -> arc_Nbat_JO
    {   0, 102,   0 }, { 226, 102, 160 }, // und_Newa -> new_Newa_NP
    {   0, 103,   0 }, { 201, 103,  99 }, // und_Nkoo -> man_Nkoo_GN
    {   0, 107,   0 }, { 247, 107, 112 }, // und_Ogam -> sga_Ogam_IE
    {   0, 108,   0 }, { 286, 108, 108 }, // und_Olck -> sat_Olck_IN
    {   0, 117,   0 }, { 250, 117, 152 }, // und_Orkh -> otk_Orkh_MN
    {   0, 106,   0 }, { 245, 106, 108 }, // und_Orya -> or_Orya_IN
    {   0, 118,   0 }, { 252, 118, 243 }, // und_Osge -> osa_Osge_US
    {   0, 119,   0 }, { 303, 119, 204 }, // und_Osma -> so_Osma_SO
    {   0, 121,   0 }, {  18, 121, 223 }, // und_Palm -> arc_Palm_SY
    {   0, 122,   0 }, { 329, 122, 157 }, // und_Pauc -> ctd_Pauc_MM
    {   0, 112,   0 }, { 153, 112, 189 }, // und_Perm -> kv_Perm_RU
    {   0, 123,   0 }, { 179, 123,  50 }, // und_Phag -> lzh_Phag_CN
    {   0, 56,   0 }, { 254, 56, 110 }, // und_Phli -> pal_Phli_IR
    {   0, 126,   0 }, { 254, 126,  50 }, // und_Phlp -> pal_Phlp_CN
    {   0, 124,   0 }, { 261, 124, 129 }, // und_Phnx -> phn_Phnx_LB
    {   0, 125,   0 }, { 168, 125,  50 }, // und_Plrd -> hmd_Plrd_CN
    {   0, 57,   0 }, { 258, 57, 110 }, // und_Prti -> xpr_Prti_IR
    {   0, 127,   0 }, { 269, 127, 109 }, // und_Rjng -> rej_Rjng_ID
    {   0, 50,   0 }, { 270, 50, 157 }, // und_Rohg -> rhg_Rohg_MM
    {   0, 128,   0 }, { 248, 128, 221 }, // und_Runr -> non_Runr_SE
    {   0, 129,   0 }, { 280, 129, 114 }, // und_Samr -> smp_Samr_IL
    {   0, 115,   0 }, { 277, 115, 255 }, // und_Sarb -> xsa_Sarb_YE
    {   0, 130,   0 }, { 288, 130, 108 }, // und_Saur -> saz_Saur_IN
    {   0, 134,   0 }, {  11, 134, 243 }, // und_Sgnw -> ase_Sgnw_US
    {   0, 132,   0 }, {  83, 132, 242 }, // und_Shaw -> en_Shaw_GB
    {   0, 131,   0 }, { 285, 131, 108 }, // und_Shrd -> sa_Shrd_IN
    {   0, 133,   0 }, { 285, 133, 108 }, // und_Sidd -> sa_Sidd_IN
    {   0, 70,   0 }, { 297, 70, 108 }, // und_Sind -> sd_Sind_IN
    {   0, 136,   0 }, { 298, 136, 210 }, // und_Sinh -> si_Sinh_LK
    {   0, 138,   0 }, { 304, 138, 108 }, // und_Sora -> srb_Sora_IN
    {   0, 140,   0 }, { 311, 140, 109 }, // und_Sund -> su_Sund_ID
    {   0, 141,   0 }, { 316, 141,  20 }, // und_Sylo -> syl_Sylo_BD
    {   0, 142,   0 }, { 317, 142, 111 }, // und_Syrc -> syr_Syrc_IQ
    {   0, 144,   0 }, { 319, 144, 181 }, // und_Tagb -> tbw_Tagb_PH
    {   0, 148,   0 }, {  76, 148, 108 }, // und_Takr -> doi_Takr_IN
    {   0, 146,   0 }, { 322, 146,  50 }, // und_Tale -> tdd_Tale_CN
    {   0, 101,   0 }, { 184, 101,  50 }, // und_Talu -> khb_Talu_CN
    {   0, 149,   0 }, { 325, 149, 108 }, // und_Taml -> ta_Taml_IN
    {   0, 147,   0 }, { 321, 147, 251 }, // und_Tavt -> blt_Tavt_VN
    {   0, 151,   0 }, { 330, 151, 108 }, // und_Telu -> te_Telu_IN
    {   0, 155,   0 }, { 310, 155, 155 }, // und_Tfng -> zgh_Tfng_MA
    {   0, 143,   0 }, {  92, 143, 181 }, // und_Tglg -> fil_Tglg_PH
    {   0, 152,   0 }, {  75, 152, 140 }, // und_Thaa -> dv_Thaa_MV
    {   0, 153,   0 }, { 332, 153, 227 }, // und_Thai -> th_Thai_TH
    {   0, 154,   0 }, { 333, 154,  50 }, // und_Tibt -> bo_Tibt_CN
    {   0, 156,   0 }, { 194, 156, 108 }, // und_Tirh -> mai_Tirh_IN
    {   0, 159,   0 }, { 347, 159, 223 }, // und_Ugar -> uga_Ugar_SY
    {   0, 160,   0 }, { 353, 160, 131 }, // und_Vaii -> vai_Vaii_LR
    {   0, 162,   0 }, {  10, 162,   3 }, // und_Vith -> sq_Vith_AL
    {   0, 161,   0 }, { 119, 161, 108 }, // und_Wara -> hoc_Wara_IN
    {   0, 113,   0 }, { 249, 113, 110 }, // und_Xpeo -> peo_Xpeo_IR
    {   0, 26,   0 }, {   8, 26, 111 }, // und_Xsux -> akk_Xsux_IQ
    {   0, 164,   0 }, { 162, 164,  88 }, // und_Yezi -> ku_Yezi_GE
    {   0, 165,   0 }, { 293, 165,  50 }, // und_Yiii -> ii_Yiii_CN
    { 128,  0,   0 }, { 128, 74, 254 }, // ie -> ie_Latn_001
    { 256,  0,   0 }, { 256, 136, 108 }, // pi -> pi_Sinh_IN
    { 256, 14,   0 }, { 256, 14, 108 }, // pi_Brah -> pi_Brah_IN
    { 256, 31,   0 }, { 256, 31, 108 }, // pi_Deva -> pi_Deva_IN
    { 256, 66,   0 }, { 256, 66, 108 }, // pi_Khar -> pi_Khar_IN
    { 256, 68,   0 }, { 256, 68, 108 }, // pi_Khmr -> pi_Khmr_IN
    { 256, 97,   0 }, { 256, 97, 108 }, // pi_Mymr -> pi_Mymr_IN
    { 256, 153,   0 }, { 256, 153, 108 }  // pi_Thai -> pi_Thai_IN
};

static const quint16 locale_index[] = {
     0, // AnyLanguage
     0, // C
     0, // Abaza
     1, // Abkhazian
     2, // Afar
     5, // Afrikaans
     7, // Aghem
     8, // Akan
     0, // Akkadian
     9, // Akoose
    10, // Albanian
     0, // American Sign Language
    13, // Amharic
     0, // Ancient North Arabian
     0, // AncientEgyptian
     0, // AncientGreek
    14, // Arabic
    42, // Aragonese
     0, // Aramaic
    43, // Armenian
    44, // Assamese
    45, // Asturian
    46, // Asu
    47, // Atsam
     0, // Avaric
     0, // Avestan
     0, // Aymara
    48, // Azerbaijani
    53, // Bafia
     0, // Balinese
    54, // Baluchi
    56, // Bambara
     0, // Bamun
    58, // Bangla
    60, // Basaa
    61, // Bashkir
    62, // Basque
     0, // BatakToba
    63, // Belarusian
    64, // Bemba
    65, // Bena
    66, // Bhojpuri
     0, // Bislama
    67, // Blin
    68, // Bodo
    69, // Bosnian
    71, // Breton
     0, // Buginese
     0, // Buhid
    72, // Bulgarian
    73, // Burmese
    74, // Cantonese
     0, // Carian
    76, // Catalan
    80, // Cebuano
    81, // Central Atlas Tamazight
    82, // Central Kurdish
    84, // Chakma
     0, // Chamorro
    86, // Chechen
    87, // Cherokee
    88, // Chickasaw
    89, // Chiga
    90, // Chinese
    97, // Church
    98, // Chuvash
     0, // Classical Mandaic
    99, // Colognian
     0, // Coptic
   100, // Cornish
   101, // Corsican
     0, // Cree
   102, // Croatian
   104, // Czech
   105, // Danish
   107, // Divehi
   108, // Dogri
   109, // Duala
   110, // Dutch
   117, // Dzongkha
     0, // Eastern Cham
     0, // Eastern Kayah
   118, // Embu
   119, // English
   226, // Erzya
   227, // Esperanto
   228, // Estonian
     0, // Etruscan
   229, // Ewe
   231, // Ewondo
   232, // Faroese
     0, // Fijian
   234, // Filipino
   235, // Finnish
   236, // French
   282, // Friulian
   283, // Fulah
   307, // Ga
   308, // Gaelic
   309, // Galician
   310, // Ganda
   311, // Geez
   313, // Georgian
   314, // German
     0, // Gothic
   321, // Greek
   323, // Guarani
   324, // Gujarati
   325, // Gusii
     0, // Haitian
     0, // Hanunoo
   326, // Haryanvi
   327, // Hausa
   332, // Hawaiian
   333, // Hebrew
     0, // Herero
   334, // Hindi
     0, // Hiri Motu
   336, // Hmong Njua
     0, // Ho
   337, // Hungarian
   338, // Icelandic
   339, // Ido
   340, // Igbo
   341, // Inari Sami
   342, // Indonesian
     0, // Ingush
   343, // Interlingua
     0, // Interlingue
   344, // Inuktitut
     0, // Inupiaq
   346, // Irish
   348, // Italian
   352, // Japanese
   353, // Javanese
   354, // Jju
   355, // JolaFonyi
   356, // Kabuverdianu
   357, // Kabyle
   358, // Kaingang
   359, // Kako
   360, // Kalaallisut
   361, // Kalenjin
   362, // Kamba
   363, // Kannada
     0, // Kanuri
   364, // Kashmiri
   366, // Kazakh
   367, // Kenyang
   368, // Khmer
   369, // Kiche
   370, // Kikuyu
   371, // Kinyarwanda
     0, // Komi
     0, // Kongo
   372, // Konkani
   373, // Korean
     0, // Koro
   375, // Koyra Chiini
   376, // Koyraboro Senni
   377, // Kpelle
     0, // Kuanyama
   379, // Kurdish
   380, // Kwasio
   381, // Kyrgyz
   382, // Lakota
   383, // Langi
   384, // Lao
     0, // Large Flowery Miao
   385, // Latin
   386, // Latvian
     0, // Lepcha
     0, // Lezghian
   387, // Ligurian
     0, // Limbu
     0, // Limburgish
     0, // Linear A
   388, // Lingala
     0, // Lisu
     0, // Literary Chinese
   392, // Lithuanian
   393, // Lojban
   394, // Low German
   396, // Lower Sorbian
     0, // Lu
   397, // LubaKatanga
   398, // Lule Sami
   400, // Luo
   401, // Luxembourgish
   402, // Luyia
     0, // Lycian
     0, // Lydian
   403, // Macedonian
   404, // Machame
   405, // Maithili
   406, // Makhuwa-Meetto
   407, // Makonde
   408, // Malagasy
   409, // Malay
   415, // Malayalam
   416, // Maltese
     0, // Mandingo
     0, // Manichaean Middle Persian
   417, // Manipuri
   419, // Manx
   420, // Maori
   421, // Mapuche
   422, // Marathi
     0, // Marshallese
   423, // Masai
   425, // Mazanderani
     0, // Mende
     0, // Meroitic
   426, // Meru
   427, // Meta
   428, // Mohawk
   429, // Moksha
   430, // Mongolian
   433, // Morisyen
   434, // Mundang
   435, // Muscogee
   436, // Nama
     0, // Nauru
   437, // Navajo
     0, // Ndonga
   438, // Nepali
     0, // Newari
   440, // Ngiemboon
   441, // Ngomba
   442, // Nheengatu
   445, // Nigerian Pidgin
   446, // Nko
   447, // North Ndebele
   448, // Northern Frisian
   449, // Northern Luri
   451, // Northern Sami
   454, // Northern Sotho
     0, // Northern Thai
   455, // Norwegian Bokmal
   457, // Norwegian Nynorsk
   458, // Nuer
   459, // Nyanja
   460, // Nyankole
   461, // Obolo
   462, // Occitan
   464, // Odia
     0, // Ojibwa
     0, // Old Irish
     0, // Old Norse
     0, // Old Persian
     0, // Old Turkish
   465, // Oromo
   467, // Osage
   468, // Ossetic
     0, // Pahlavi
     0, // Palauan
     0, // Pali
   470, // Papiamento
     0, // Parthian
   472, // Pashto
   474, // Persian
     0, // Phoenician
   476, // Pijin
   477, // Polish
   478, // Portuguese
   490, // Prussian
   491, // Punjabi
   493, // Quechua
   496, // Rajasthani
     0, // Rejang
   497, // Rohingya
   499, // Romanian
   501, // Romansh
   502, // Rombo
   503, // Rundi
   504, // Russian
   510, // Rwa
     0, // Sabaean
   511, // Saho
   512, // Sakha
     0, // Samaritan
   513, // Samburu
     0, // Samoan
   514, // Sango
   515, // Sangu
   516, // Sanskrit
   517, // Santali
   519, // Sardinian
     0, // Saurashtra
   520, // Sena
   521, // Serbian
   529, // Shambala
   530, // Shona
   531, // Sichuan Yi
   532, // Sicilian
   533, // Sidamo
   534, // Silesian
   535, // Sindhi
   537, // Sinhala
   538, // Skolt Sami
   539, // Slovak
   540, // Slovenian
   541, // Soga
   542, // Somali
     0, // Sora
   546, // South Ndebele
   547, // Southern Kurdish
   549, // Southern Sami
   551, // Southern Sotho
   553, // Spanish
   580, // Standard Moroccan Tamazight
   581, // Sundanese
   582, // Swahili
   586, // Swati
   588, // Swedish
   591, // Swiss German
     0, // Sylheti
   594, // Syriac
   596, // Tachelhit
     0, // Tagbanwa
     0, // Tahitian
   598, // Tai Dam
     0, // Tai Nua
   599, // Taita
   600, // Tajik
   601, // Tamil
   605, // Taroko
   606, // Tasawaq
   607, // Tatar
     0, // Tedim Chin
   608, // Telugu
   609, // Teso
   611, // Thai
   612, // Tibetan
   614, // Tigre
   615, // Tigrinya
   617, // Tok Pisin
     0, // Tokelau
   618, // Toki Pona
   619, // Tongan
   620, // Torwali
   621, // Tsonga
   622, // Tswana
   624, // Turkish
   626, // Turkmen
     0, // Tuvalu
   627, // Tyap
     0, // Ugaritic
   628, // Ukrainian
   629, // Upper Sorbian
   630, // Urdu
   632, // Uyghur
   633, // Uzbek
   636, // Vai
   638, // Venda
   639, // Vietnamese
   640, // Volapuk
   641, // Vunjo
   642, // Walloon
   643, // Walser
   644, // Warlpiri
   645, // Welsh
   646, // Western Balochi
   651, // Western Frisian
   652, // Wolaytta
   653, // Wolof
   654, // Xhosa
   655, // Yangben
   656, // Yiddish
   657, // Yoruba
   659, // Zarma
     0, // Zhuang
   660, // Zulu
     0 // trailing 0
};

static const QLocaleData locale_data[] = {
//      lang   script terr    dec  group   list  prcnt   zero  minus  plus    exp quotStart quotEnd altQuotStart altQuotEnd lpStart lpMid lpEnd lpTwo sDtFmt lDtFmt sTmFmt lTmFmt ssMonth slMonth  sMonth lMonth  sDays  lDays  am,len      pm,len
    {      1,     0,     0,    46,    44,    59,    37,    48,    45,    43,   101,    34,    34,    39,    39, 0,6 , 0,6 , 0,6 , 0,6 , 0,10 , 10,17 , 0,8 , 8,10 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 158,27 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 99,14 , 0,2 , 0,2 , {0,0,0},  0,0 , 0,7 , 0,4 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // C/AnyScript/AnyCountry
    {      3,    29,    88,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 6,9 , 6,9 , 27,10 , 37,22 , 18,5 , 8,10 , 185,59 , 244,98 , 342,29 , 185,59 , 244,98 , 371,29 , 113,23 , 136,49 , 185,16 , 113,23 , 136,49 , 185,16 , 0,2 , 0,2 , {71,69,76},  0,1 , 0,7 , 4,5 , 4,0 , 0,6 , 6,9 ,     2,     1,     1,     6,     7 }, // Abkhazian/Cyrillic/Georgia
    {      4,    74,    77,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 67,19 , 23,7 , 30,12 , 400,48 , 448,118 , 566,24 , 400,48 , 448,118 , 566,24 , 201,28 , 229,52 , 281,14 , 201,28 , 229,52 , 281,14 , 0,2 , 0,2 , {69,84,66},  1,2 , 0,7 , 9,4 , 4,0 , 15,5 , 20,7 ,     2,     1,     7,     6,     7 }, // Afar/Latin/Ethiopia
    {      4,    74,    67,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 67,19 , 23,7 , 30,12 , 400,48 , 590,119 , 566,24 , 400,48 , 590,119 , 566,24 , 201,28 , 229,52 , 281,14 , 201,28 , 229,52 , 281,14 , 0,2 , 0,2 , {68,74,70},  3,3 , 0,7 , 9,4 , 4,0 , 15,5 , 27,7 ,     0,     0,     6,     6,     7 }, // Afar/Latin/Djibouti
    {      4,    74,    74,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 67,19 , 23,7 , 30,12 , 400,48 , 448,118 , 566,24 , 400,48 , 448,118 , 566,24 , 201,28 , 229,52 , 281,14 , 201,28 , 229,52 , 281,14 , 0,2 , 0,2 , {69,82,78},  6,3 , 0,7 , 9,4 , 4,0 , 15,5 , 34,7 ,     2,     1,     1,     6,     7 }, // Afar/Latin/Eritrea
    {      5,    74,   205,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 15,8 , 15,8 , 86,10 , 96,17 , 18,5 , 8,10 , 709,59 , 768,92 , 134,24 , 709,59 , 768,92 , 134,24 , 295,28 , 323,58 , 381,14 , 295,28 , 323,58 , 381,14 , 2,3 , 2,3 , {90,65,82},  9,1 , 7,67 , 9,4 , 4,0 , 41,9 , 50,11 ,     2,     1,     7,     6,     7 }, // Afrikaans/Latin/SouthAfrica
    {      5,    74,   158,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 15,8 , 15,8 , 86,10 , 113,16 , 23,7 , 30,12 , 709,59 , 768,92 , 134,24 , 709,59 , 768,92 , 134,24 , 295,28 , 323,58 , 381,14 , 295,28 , 323,58 , 381,14 , 2,3 , 2,3 , {78,65,68},  10,1 , 74,55 , 9,4 , 4,0 , 41,9 , 61,7 ,     2,     1,     1,     6,     7 }, // Afrikaans/Latin/Namibia
    {      6,    74,    40,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 860,48 , 908,195 , 1103,24 , 860,48 , 908,195 , 1103,24 , 395,28 , 423,72 , 495,14 , 395,28 , 423,72 , 495,14 , 5,3 , 5,3 , {88,65,70},  11,4 , 129,21 , 0,4 , 4,0 , 68,5 , 73,7 ,     0,     0,     1,     6,     7 }, // Aghem/Latin/Cameroon
    {      7,    74,    90,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 137,8 , 145,18 , 23,7 , 30,12 , 1127,48 , 1175,192 , 158,27 , 1127,48 , 1175,192 , 158,27 , 509,28 , 537,49 , 586,14 , 509,28 , 537,49 , 586,14 , 8,2 , 8,2 , {71,72,83},  15,3 , 150,17 , 9,4 , 4,0 , 80,4 , 84,5 ,     2,     1,     1,     6,     7 }, // Akan/Latin/Ghana
    {      9,    74,    40,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 23,5 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {88,65,70},  11,4 , 167,17 , 13,5 , 4,0 , 89,6 , 95,7 ,     0,     0,     1,     6,     7 }, // Akoose/Latin/Cameroon
    {     10,    74,     3,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 28,9 , 28,9 , 180,6 , 10,17 , 23,7 , 42,13 , 1415,50 , 1465,78 , 1543,27 , 1415,50 , 1465,78 , 1543,27 , 600,28 , 628,58 , 686,15 , 701,28 , 628,58 , 686,15 , 10,11 , 10,10 , {65,76,76},  18,4 , 184,45 , 4,5 , 4,0 , 102,5 , 107,8 ,     0,     0,     1,     6,     7 }, // Albanian/Latin/Albania
    {     10,    74,   124,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 28,9 , 28,9 , 180,6 , 10,17 , 18,5 , 8,10 , 1415,50 , 1465,78 , 1543,27 , 1415,50 , 1465,78 , 1543,27 , 600,28 , 628,58 , 686,15 , 701,28 , 628,58 , 686,15 , 10,11 , 10,10 , {69,85,82},  22,1 , 229,21 , 4,5 , 4,0 , 102,5 , 115,6 ,     2,     1,     1,     6,     7 }, // Albanian/Latin/Kosovo
    {     10,    74,   170,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 28,9 , 28,9 , 180,6 , 10,17 , 18,5 , 8,10 , 1415,50 , 1465,78 , 1543,27 , 1415,50 , 1465,78 , 1543,27 , 600,28 , 628,58 , 686,15 , 701,28 , 628,58 , 686,15 , 10,11 , 10,10 , {77,75,68},  23,3 , 250,54 , 4,5 , 4,0 , 102,5 , 121,18 ,     2,     1,     1,     6,     7 }, // Albanian/Latin/NorthMacedonia
    {     12,    38,    77,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 37,6 , 37,6 , 43,9 , 52,8 , 186,10 , 163,17 , 55,7 , 62,12 , 1570,46 , 1616,61 , 1677,24 , 1570,46 , 1616,61 , 1677,24 , 729,27 , 756,28 , 784,14 , 729,27 , 756,28 , 784,14 , 21,3 , 20,4 , {69,84,66},  26,2 , 304,34 , 9,4 , 4,0 , 139,4 , 143,5 ,     2,     1,     7,     6,     7 }, // Amharic/Ethiopic/Ethiopia
    {     16,     4,    71,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {69,71,80},  28,5 , 338,81 , 18,6 , 4,0 , 148,7 , 155,3 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Egypt
    {     16,     4,     4,    44,    46,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1800,71 , 1800,71 , 1871,24 , 1800,71 , 1800,71 , 1871,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {68,90,68},  33,5 , 419,102 , 18,6 , 4,0 , 148,7 , 158,7 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Algeria
    {     16,     4,    19,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {66,72,68},  38,5 , 521,91 , 18,6 , 4,0 , 148,7 , 165,7 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Bahrain
    {     16,     4,    48,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {88,65,70},  11,4 , 612,112 , 18,6 , 4,0 , 148,7 , 172,4 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Chad
    {     16,     4,    55,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 18,5 , 8,10 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {75,77,70},  43,2 , 724,105 , 18,6 , 4,0 , 148,7 , 176,9 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Comoros
    {     16,     4,    67,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {68,74,70},  3,3 , 829,84 , 18,6 , 4,0 , 148,7 , 185,6 ,     0,     0,     6,     6,     7 }, // Arabic/Arabic/Djibouti
    {     16,     4,    74,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {69,82,78},  6,3 , 913,91 , 18,6 , 4,0 , 148,7 , 191,7 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/Eritrea
    {     16,     4,   111,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1895,92 , 1895,92 , 1987,24 , 2011,92 , 1895,92 , 1987,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {73,81,68},  45,5 , 1004,84 , 18,6 , 4,0 , 148,7 , 198,6 ,     0,     0,     6,     5,     6 }, // Arabic/Arabic/Iraq
    {     16,     4,   114,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 74,4 , 78,9 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {73,76,83},  50,1 , 1088,133 , 18,6 , 4,0 , 148,7 , 204,7 ,     2,     1,     7,     5,     6 }, // Arabic/Arabic/Israel
    {     16,     4,   120,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1895,92 , 1895,92 , 1987,24 , 1895,92 , 1895,92 , 1987,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {74,79,68},  51,5 , 1221,84 , 18,6 , 4,0 , 148,7 , 211,6 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Jordan
    {     16,     4,   125,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {75,87,68},  56,5 , 1305,84 , 18,6 , 4,0 , 148,7 , 217,6 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Kuwait
    {     16,     4,   129,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1895,92 , 1895,92 , 1987,24 , 1895,92 , 1895,92 , 1987,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {76,66,80},  61,5 , 1389,84 , 18,6 , 4,0 , 148,7 , 223,5 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Lebanon
    {     16,     4,   132,    44,    46,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {76,89,68},  66,5 , 1473,88 , 18,6 , 4,0 , 148,7 , 228,5 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Libya
    {     16,     4,   145,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 2103,72 , 2103,72 , 2175,24 , 2103,72 , 2103,72 , 2175,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {77,82,85},  71,4 , 1561,112 , 18,6 , 4,0 , 148,7 , 233,9 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/Mauritania
    {     16,     4,   155,    44,    46,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 18,5 , 8,10 , 2199,70 , 2199,70 , 2269,24 , 2199,70 , 2199,70 , 2269,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {77,65,68},  75,5 , 1673,87 , 18,6 , 4,0 , 148,7 , 242,6 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/Morocco
    {     16,     4,   173,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {79,77,82},  80,5 , 1760,77 , 18,6 , 4,0 , 148,7 , 248,5 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Oman
    {     16,     4,   176,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1895,92 , 1895,92 , 1987,24 , 1895,92 , 1895,92 , 1987,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {73,76,83},  50,1 , 1088,133 , 18,6 , 4,0 , 148,7 , 253,18 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/PalestinianTerritories
    {     16,     4,   186,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {81,65,82},  85,5 , 1837,70 , 18,6 , 4,0 , 148,7 , 271,3 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Qatar
    {     16,     4,   194,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {83,65,82},  90,5 , 1907,77 , 18,6 , 4,0 , 148,7 , 274,24 ,     2,     1,     7,     5,     6 }, // Arabic/Arabic/SaudiArabia
    {     16,     4,   204,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {83,79,83},  95,1 , 1984,77 , 18,6 , 4,0 , 148,7 , 298,7 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Somalia
    {     16,     4,   208,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {83,83,80},  96,1 , 2061,132 , 18,6 , 4,0 , 148,7 , 305,12 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/SouthSudan
    {     16,     4,   218,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {83,68,71},  97,4 , 2193,91 , 18,6 , 4,0 , 148,7 , 317,7 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Sudan
    {     16,     4,   223,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1895,92 , 1895,92 , 1987,24 , 1895,92 , 1895,92 , 1987,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {83,89,80},  101,5 , 2284,77 , 18,6 , 4,0 , 148,7 , 324,5 ,     0,     0,     6,     5,     6 }, // Arabic/Arabic/Syria
    {     16,     4,   234,    44,    46,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1800,71 , 1800,71 , 1871,24 , 1800,71 , 1800,71 , 1871,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {84,78,68},  106,5 , 2361,95 , 18,6 , 4,0 , 148,7 , 329,4 ,     3,     0,     1,     6,     7 }, // Arabic/Arabic/Tunisia
    {     16,     4,   241,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {65,69,68},  111,5 , 2456,91 , 18,6 , 4,0 , 148,7 , 333,24 ,     2,     1,     6,     6,     7 }, // Arabic/Arabic/UnitedArabEmirates
    {     16,     4,   253,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {77,65,68},  75,5 , 1673,87 , 18,6 , 4,0 , 148,7 , 357,15 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/WesternSahara
    {     16,     4,   254,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {0,0,0},  0,0 , 2547,0 , 18,6 , 4,0 , 372,22 , 394,6 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/World
    {     16,     4,   255,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 60,6 , 60,6 , 60,6 , 60,6 , 196,10 , 206,17 , 55,7 , 62,12 , 1701,75 , 1701,75 , 1776,24 , 1701,75 , 1701,75 , 1776,24 , 798,52 , 798,52 , 850,14 , 798,52 , 798,52 , 850,14 , 24,1 , 24,1 , {89,69,82},  116,5 , 2547,70 , 18,6 , 4,0 , 148,7 , 400,5 ,     0,     0,     7,     5,     6 }, // Arabic/Arabic/Yemen
    {     17,    74,   209,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8221,  8221, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 229,22 , 74,4 , 78,9 , 2293,60 , 2353,91 , 158,27 , 2293,60 , 2444,123 , 158,27 , 864,28 , 892,52 , 944,17 , 864,28 , 892,52 , 944,17 , 0,2 , 0,2 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 405,8 , 413,7 ,     2,     1,     1,     6,     7 }, // Aragonese/Latin/Spain
    {     19,     5,    12,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 73,7 , 73,7 , 251,8 , 259,20 , 18,5 , 8,10 , 2567,48 , 2615,94 , 2709,24 , 2567,48 , 2733,106 , 2709,24 , 961,28 , 989,62 , 1051,14 , 961,28 , 989,62 , 1051,14 , 0,2 , 0,2 , {65,77,68},  121,1 , 2637,46 , 4,5 , 4,0 , 420,7 , 427,8 ,     2,     0,     1,     6,     7 }, // Armenian/Armenian/Armenia
    {     20,     9,   108,    46,    44,    59,    37,  2534,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 80,9 , 80,9 , 279,8 , 287,18 , 87,7 , 94,12 , 2839,64 , 2903,89 , 2992,24 , 2839,64 , 2903,89 , 2992,24 , 1065,32 , 1097,58 , 1155,14 , 1065,32 , 1097,58 , 1155,14 , 25,9 , 25,7 , {73,78,82},  122,1 , 2683,43 , 13,5 , 4,0 , 435,7 , 442,4 ,     2,     1,     7,     7,     7 }, // Assamese/Bangla/India
    {     21,    74,   209,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 229,22 , 18,5 , 8,10 , 3016,48 , 3064,85 , 3149,24 , 3173,48 , 3221,117 , 3149,24 , 1169,28 , 1197,54 , 1251,14 , 1169,28 , 1197,54 , 1251,14 , 34,12 , 32,11 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 446,9 , 455,6 ,     2,     1,     1,     6,     7 }, // Asturian/Latin/Spain
    {     22,    74,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 3338,48 , 3386,84 , 134,24 , 3338,48 , 3386,84 , 134,24 , 1265,28 , 1293,60 , 1353,14 , 1265,28 , 1293,60 , 1353,14 , 46,9 , 43,8 , {84,90,83},  123,3 , 2726,28 , 4,5 , 4,0 , 461,6 , 467,8 ,     2,     0,     1,     6,     7 }, // Asu/Latin/Tanzania
    {     23,    74,   166,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 137,8 , 145,18 , 18,5 , 8,10 , 3470,59 , 3529,129 , 158,27 , 3470,59 , 3529,129 , 158,27 , 1367,34 , 1401,87 , 85,14 , 1367,34 , 1401,87 , 85,14 , 0,2 , 0,2 , {78,71,78},  126,1 , 2754,11 , 13,5 , 4,0 , 475,5 , 0,0 ,     2,     1,     1,     6,     7 }, // Atsam/Latin/Nigeria
    {     27,    74,    17,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 89,8 , 89,8 , 251,8 , 305,17 , 18,5 , 8,10 , 3658,48 , 3706,77 , 158,27 , 3658,48 , 3706,77 , 158,27 , 1488,27 , 1515,67 , 99,14 , 1582,27 , 1515,67 , 99,14 , 0,2 , 0,2 , {65,90,78},  127,1 , 2765,58 , 4,5 , 4,0 , 480,10 , 490,10 ,     2,     1,     1,     6,     7 }, // Azerbaijani/Latin/Azerbaijan
    {     27,     4,   110,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {73,82,82},  0,0 , 0,7 , 13,5 , 4,0 , 500,6 , 0,0 ,     0,     0,     6,     5,     5 }, // Azerbaijani/Arabic/Iran
    {     27,     4,   111,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {73,81,68},  0,0 , 0,7 , 13,5 , 4,0 , 500,6 , 0,0 ,     0,     0,     6,     5,     6 }, // Azerbaijani/Arabic/Iraq
    {     27,     4,   235,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {84,82,89},  128,1 , 0,7 , 13,5 , 4,0 , 500,6 , 0,0 ,     2,     1,     1,     6,     7 }, // Azerbaijani/Arabic/Turkey
    {     27,    29,    17,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 0,6 , 0,6 , 251,8 , 305,17 , 18,5 , 8,10 , 3783,48 , 3831,77 , 158,27 , 3783,48 , 3908,77 , 158,27 , 1609,27 , 1636,67 , 99,14 , 1609,27 , 1636,67 , 99,14 , 55,2 , 51,2 , {65,90,78},  127,1 , 2823,12 , 4,5 , 4,0 , 506,10 , 516,10 ,     2,     1,     1,     6,     7 }, // Azerbaijani/Cyrillic/Azerbaijan
    {     28,    74,    40,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 3985,39 , 4024,191 , 158,27 , 3985,39 , 4024,191 , 158,27 , 1703,29 , 1732,45 , 1777,14 , 1703,29 , 1732,45 , 1777,14 , 57,6 , 53,7 , {88,65,70},  11,4 , 2835,11 , 4,5 , 4,0 , 526,5 , 531,7 ,     0,     0,     1,     6,     7 }, // Bafia/Latin/Cameroon
    {     30,     4,   174,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 223,6 , 287,18 , 106,8 , 114,13 , 4215,49 , 4264,70 , 158,27 , 4215,49 , 4264,70 , 158,27 , 1791,25 , 1816,47 , 85,14 , 1791,25 , 1816,47 , 85,14 , 0,2 , 0,2 , {80,75,82},  129,2 , 2846,20 , 13,5 , 4,0 , 538,5 , 543,7 ,     2,     0,     7,     6,     7 }, // Baluchi/Arabic/Pakistan
    {     30,    74,   174,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 223,6 , 287,18 , 127,8 , 135,13 , 4334,48 , 4382,83 , 158,27 , 4334,48 , 4382,83 , 158,27 , 1863,27 , 1890,71 , 85,14 , 1863,27 , 1890,71 , 85,14 , 0,2 , 0,2 , {80,75,82},  129,2 , 2866,21 , 13,5 , 4,0 , 550,7 , 557,8 ,     2,     0,     7,     6,     7 }, // Baluchi/Latin/Pakistan
    {     31,    74,   141,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 4465,47 , 4512,92 , 4604,24 , 4465,47 , 4512,92 , 4604,24 , 1961,28 , 1989,44 , 2033,14 , 1961,28 , 1989,44 , 2033,14 , 0,2 , 0,2 , {88,79,70},  131,5 , 2887,24 , 9,4 , 4,0 , 565,9 , 574,4 ,     0,     0,     1,     6,     7 }, // Bambara/Latin/Mali
    {     31,   103,   141,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {88,79,70},  131,5 , 0,7 , 9,4 , 4,0 , 0,0 , 0,0 ,     0,     0,     1,     6,     7 }, // Bambara/Nko/Mali
    {     33,     9,    20,    46,    44,    59,    37,  2534,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 97,9 , 97,9 , 223,6 , 287,18 , 55,7 , 62,12 , 4628,77 , 4705,90 , 4795,33 , 4828,54 , 4705,90 , 4795,33 , 2047,37 , 2084,58 , 2142,18 , 2047,37 , 2084,58 , 2142,18 , 0,2 , 0,2 , {66,68,84},  136,1 , 2911,49 , 0,4 , 4,0 , 578,5 , 583,8 ,     2,     1,     7,     6,     7 }, // Bangla/Bangla/Bangladesh
    {     33,     9,   108,    46,    44,    59,    37,  2534,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 97,9 , 97,9 , 223,6 , 287,18 , 55,7 , 62,12 , 4882,67 , 4705,90 , 4949,34 , 4983,61 , 4705,90 , 4949,34 , 2047,37 , 2084,58 , 2142,18 , 2047,37 , 2084,58 , 2142,18 , 0,2 , 0,2 , {73,78,82},  122,1 , 2960,43 , 9,4 , 4,0 , 578,5 , 591,4 ,     2,     1,     7,     7,     7 }, // Bangla/Bangla/India
    {     34,    74,    40,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 5044,48 , 5092,90 , 5182,24 , 5044,48 , 5092,90 , 5182,24 , 2160,28 , 2188,70 , 2258,14 , 2160,28 , 2188,70 , 2258,14 , 63,10 , 60,9 , {88,65,70},  11,4 , 3003,22 , 4,5 , 4,0 , 595,5 , 600,8 ,     0,     0,     1,     6,     7 }, // Basaa/Latin/Cameroon
    {     35,    29,   189,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {82,85,66},  137,1 , 0,7 , 13,5 , 4,0 , 608,12 , 0,0 ,     2,     1,     1,     6,     7 }, // Bashkir/Cyrillic/Russia
    {     36,    74,   209,    44,    46,    59,    37,    48,  8722,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 106,9 , 106,9 , 322,6 , 328,36 , 18,5 , 148,12 , 5206,60 , 5266,93 , 5359,24 , 5206,60 , 5266,93 , 5359,24 , 2272,28 , 2300,68 , 2368,14 , 2272,28 , 2300,68 , 2368,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 3025,20 , 4,5 , 4,0 , 620,7 , 627,8 ,     2,     1,     1,     6,     7 }, // Basque/Latin/Spain
    {     38,    29,    22,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 115,7 , 115,7 , 364,7 , 371,22 , 18,5 , 160,11 , 5383,48 , 5431,95 , 5526,24 , 5550,48 , 5598,98 , 5526,24 , 2382,21 , 2403,56 , 2459,14 , 2382,21 , 2403,56 , 2459,14 , 0,2 , 0,2 , {66,89,78},  1,2 , 3045,89 , 4,5 , 4,0 , 635,10 , 645,8 ,     2,     0,     1,     6,     7 }, // Belarusian/Cyrillic/Belarus
    {     39,    74,   256,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 23,7 , 30,12 , 5696,48 , 5744,83 , 5827,24 , 5696,48 , 5744,83 , 5827,24 , 2473,80 , 2473,80 , 85,14 , 2473,80 , 2473,80 , 85,14 , 73,8 , 69,7 , {90,77,87},  138,1 , 0,7 , 9,4 , 4,0 , 653,9 , 662,6 ,     2,     1,     1,     6,     7 }, // Bemba/Latin/Zambia
    {     40,    74,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 5851,48 , 5899,254 , 6153,24 , 5851,48 , 5899,254 , 6153,24 , 2553,28 , 2581,82 , 2663,14 , 2553,28 , 2581,82 , 2663,14 , 81,7 , 76,7 , {84,90,83},  123,3 , 3134,29 , 0,4 , 4,0 , 668,6 , 674,10 ,     2,     0,     1,     6,     7 }, // Bena/Latin/Tanzania
    {     41,    31,   108,    46,    44,    59,    37,  2406,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 55,7 , 62,12 , 6177,73 , 6177,73 , 158,27 , 6177,73 , 6177,73 , 158,27 , 2677,56 , 2677,56 , 85,14 , 2677,56 , 2677,56 , 85,14 , 88,3 , 83,4 , {73,78,82},  122,1 , 0,7 , 9,4 , 4,0 , 684,7 , 691,4 ,     2,     1,     7,     7,     7 }, // Bhojpuri/Devanagari/India
    {     43,    38,    74,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 393,22 , 55,7 , 62,12 , 6250,47 , 6297,77 , 6374,24 , 6250,47 , 6297,77 , 6374,24 , 2733,26 , 2759,43 , 2802,14 , 2733,26 , 2759,43 , 2802,14 , 0,2 , 0,2 , {69,82,78},  6,3 , 0,7 , 9,4 , 4,0 , 695,3 , 698,4 ,     2,     1,     1,     6,     7 }, // Blin/Ethiopic/Eritrea
    {     44,    31,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 122,10 , 132,9 , 415,10 , 305,17 , 171,10 , 181,12 , 6398,53 , 6451,88 , 6539,24 , 6398,53 , 6451,88 , 6539,24 , 2816,33 , 2849,55 , 2904,18 , 2816,33 , 2922,54 , 2904,18 , 91,3 , 87,6 , {73,78,82},  122,1 , 3163,40 , 13,5 , 4,0 , 702,3 , 691,4 ,     2,     1,     7,     7,     7 }, // Bodo/Devanagari/India
    {     45,    74,    29,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8221,  8216,  8217, 0,6 , 0,6 , 141,7 , 141,7 , 425,11 , 436,19 , 18,5 , 8,10 , 6563,48 , 6611,83 , 6694,24 , 6563,48 , 6611,83 , 6694,24 , 2976,28 , 3004,58 , 3062,14 , 2976,28 , 3004,58 , 3076,14 , 94,10 , 93,7 , {66,65,77},  139,2 , 3203,170 , 4,5 , 4,0 , 705,8 , 713,19 ,     2,     1,     1,     6,     7 }, // Bosnian/Latin/BosniaAndHerzegowina
    {     45,    29,    29,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 148,7 , 148,7 , 455,7 , 462,20 , 18,5 , 8,10 , 6718,48 , 6766,83 , 6849,24 , 6718,48 , 6766,83 , 6849,24 , 3090,28 , 3118,56 , 3174,14 , 3090,28 , 3118,56 , 3174,14 , 104,11 , 100,13 , {66,65,77},  141,2 , 3373,152 , 4,5 , 4,0 , 732,8 , 740,19 ,     2,     1,     1,     6,     7 }, // Bosnian/Cyrillic/BosniaAndHerzegowina
    {     46,    74,    82,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 155,8 , 155,8 , 186,10 , 113,16 , 18,5 , 8,10 , 6873,63 , 6936,78 , 7014,36 , 6873,63 , 6936,78 , 7014,36 , 3188,33 , 3221,43 , 3264,18 , 3188,33 , 3221,43 , 3264,18 , 115,4 , 113,4 , {69,85,82},  22,1 , 3525,36 , 4,5 , 4,0 , 759,9 , 768,5 ,     2,     1,     1,     6,     7 }, // Breton/Latin/France
    {     49,    29,    36,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8220,  8222,  8220, 0,6 , 0,6 , 148,7 , 148,7 , 482,12 , 371,22 , 193,9 , 202,14 , 7050,49 , 7099,82 , 7181,24 , 7050,49 , 7099,82 , 7181,24 , 3282,21 , 3303,55 , 3358,14 , 3282,21 , 3303,55 , 3358,14 , 119,6 , 117,6 , {66,71,78},  143,3 , 3561,47 , 4,5 , 4,0 , 773,9 , 782,8 ,     2,     1,     1,     6,     7 }, // Bulgarian/Cyrillic/Bulgaria
    {     50,    97,   157,    46,    44,  4170,    37,  4160,    45,    43,   101,  8220,  8221,  8216,  8217, 163,7 , 163,7 , 170,10 , 170,10 , 223,6 , 494,18 , 74,4 , 216,10 , 7205,43 , 7248,88 , 7336,24 , 7205,43 , 7248,88 , 7336,24 , 3372,54 , 3372,54 , 3426,14 , 3372,54 , 3372,54 , 3426,14 , 125,5 , 123,3 , {77,77,75},  138,1 , 3608,29 , 4,5 , 4,0 , 790,6 , 790,6 ,     0,     0,     7,     6,     7 }, // Burmese/Myanmar/Myanmar
    {     51,   158,   105,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 180,5 , 180,5 , 185,5 , 185,5 , 512,8 , 520,14 , 226,6 , 232,13 , 7360,39 , 7360,39 , 158,27 , 7360,39 , 7360,39 , 158,27 , 3440,28 , 3440,28 , 3468,14 , 3440,28 , 3440,28 , 3468,14 , 130,2 , 126,2 , {72,75,68},  146,3 , 3637,11 , 9,4 , 4,0 , 796,2 , 798,14 ,     2,     1,     7,     6,     7 }, // Cantonese/Traditional Han/HongKong
    {     51,   135,    50,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 180,5 , 180,5 , 185,5 , 185,5 , 512,8 , 534,13 , 18,5 , 216,10 , 7360,39 , 7399,38 , 158,27 , 7360,39 , 7399,38 , 158,27 , 3482,21 , 3440,28 , 3468,14 , 3482,21 , 3440,28 , 3468,14 , 130,2 , 126,2 , {67,78,89},  149,1 , 3648,13 , 9,4 , 4,0 , 812,2 , 814,7 ,     2,     1,     1,     6,     7 }, // Cantonese/Simplified Han/China
    {     53,    74,   209,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 141,7 , 141,7 , 223,6 , 229,22 , 74,4 , 245,11 , 7437,60 , 7497,82 , 7579,36 , 7615,93 , 7708,115 , 7579,36 , 3503,28 , 3531,60 , 3591,21 , 3503,28 , 3531,60 , 3591,21 , 132,5 , 128,5 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 821,6 , 413,7 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/Spain
    {     53,    74,     6,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 141,7 , 141,7 , 223,6 , 229,22 , 74,4 , 245,11 , 7437,60 , 7497,82 , 7579,36 , 7615,93 , 7708,115 , 7579,36 , 3503,28 , 3531,60 , 3591,21 , 3503,28 , 3531,60 , 3591,21 , 132,5 , 128,5 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 821,6 , 827,7 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/Andorra
    {     53,    74,    82,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 141,7 , 141,7 , 223,6 , 229,22 , 74,4 , 245,11 , 7437,60 , 7497,82 , 7579,36 , 7615,93 , 7708,115 , 7579,36 , 3503,28 , 3531,60 , 3591,21 , 3503,28 , 3531,60 , 3591,21 , 132,5 , 128,5 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 821,6 , 834,6 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/France
    {     53,    74,   115,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 141,7 , 141,7 , 223,6 , 229,22 , 74,4 , 245,11 , 7437,60 , 7497,82 , 7579,36 , 7615,93 , 7708,115 , 7579,36 , 3503,28 , 3531,60 , 3591,21 , 3503,28 , 3531,60 , 3591,21 , 132,5 , 128,5 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 821,6 , 840,6 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/Italy
    {     54,    74,   181,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 190,9 , 199,8 , 547,6 , 553,18 , 23,7 , 30,12 , 7823,48 , 7871,88 , 7959,24 , 7823,48 , 7871,88 , 7959,24 , 3612,28 , 3640,56 , 3696,14 , 3612,28 , 3640,56 , 3696,14 , 0,2 , 0,2 , {80,72,80},  150,1 , 3661,53 , 9,4 , 4,0 , 846,7 , 853,9 ,     2,     1,     7,     6,     7 }, // Cebuano/Latin/Philippines
    {     55,    74,   155,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 7983,48 , 8031,86 , 8117,24 , 7983,48 , 8031,86 , 8117,24 , 3710,28 , 3738,48 , 3786,14 , 3710,28 , 3738,48 , 3786,14 , 137,9 , 133,10 , {77,65,68},  0,0 , 3714,22 , 4,5 , 4,0 , 862,17 , 879,6 ,     2,     1,     1,     6,     7 }, // Central Atlas Tamazight/Latin/Morocco
    {     56,     4,   111,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 55,7 , 62,12 , 8141,105 , 8141,105 , 8246,24 , 8141,105 , 8141,105 , 8246,24 , 3800,58 , 3800,58 , 3858,14 , 3800,58 , 3800,58 , 3858,14 , 146,3 , 143,3 , {73,81,68},  45,5 , 3736,20 , 4,5 , 4,0 , 885,14 , 899,5 ,     0,     0,     6,     5,     6 }, // Central Kurdish/Arabic/Iraq
    {     56,     4,   110,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 8141,105 , 8141,105 , 8246,24 , 8141,105 , 8141,105 , 8246,24 , 3800,58 , 3800,58 , 3858,14 , 3800,58 , 3800,58 , 3858,14 , 146,3 , 143,3 , {73,82,82},  0,0 , 3756,19 , 4,5 , 4,0 , 885,14 , 904,5 ,     0,     0,     6,     5,     5 }, // Central Kurdish/Arabic/Iran
    {     57,    21,    20,    46,    44,    59,    37, 69942,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 207,12 , 207,12 , 223,6 , 287,18 , 55,7 , 62,12 , 8270,190 , 8270,190 , 8460,58 , 8518,168 , 8686,190 , 8460,58 , 3872,85 , 3957,127 , 4084,39 , 3872,85 , 3957,127 , 4084,39 , 0,2 , 0,2 , {66,68,84},  136,1 , 3775,70 , 0,4 , 4,0 , 909,12 , 921,14 ,     2,     1,     7,     6,     7 }, // Chakma/Chakma/Bangladesh
    {     57,    21,   108,    46,    44,    59,    37, 69942,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 207,12 , 207,12 , 223,6 , 287,18 , 55,7 , 62,12 , 8270,190 , 8270,190 , 8460,58 , 8518,168 , 8686,190 , 8460,58 , 3872,85 , 3957,127 , 4084,39 , 3872,85 , 3957,127 , 4084,39 , 0,2 , 0,2 , {73,78,82},  122,1 , 3845,88 , 0,4 , 4,0 , 909,12 , 935,10 ,     2,     1,     7,     7,     7 }, // Chakma/Chakma/India
    {     59,    29,   189,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 8876,48 , 8924,80 , 9004,24 , 8876,48 , 8924,80 , 9004,24 , 4123,25 , 4148,45 , 4193,17 , 4123,25 , 4148,45 , 4123,25 , 0,2 , 0,2 , {82,85,66},  137,1 , 3933,43 , 4,5 , 4,0 , 945,7 , 952,5 ,     2,     1,     1,     6,     7 }, // Chechen/Cyrillic/Russia
    {     60,    23,   243,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 219,9 , 228,8 , 547,6 , 553,18 , 55,7 , 62,12 , 9028,36 , 9064,58 , 9122,24 , 9028,36 , 9064,58 , 9122,24 , 4210,28 , 4238,49 , 4287,14 , 4210,28 , 4238,49 , 4287,14 , 149,3 , 146,6 , {85,83,68},  10,1 , 3976,25 , 9,4 , 4,0 , 957,3 , 960,15 ,     2,     1,     7,     6,     7 }, // Cherokee/Cherokee/UnitedStates
    {     61,    74,   243,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 547,6 , 553,18 , 23,7 , 30,12 , 9146,119 , 9146,119 , 158,27 , 9146,119 , 9146,119 , 158,27 , 4301,88 , 4301,88 , 85,14 , 4301,88 , 4301,88 , 85,14 , 0,2 , 0,2 , {85,83,68},  10,1 , 0,7 , 24,6 , 4,0 , 975,16 , 991,13 ,     2,     1,     7,     6,     7 }, // Chickasaw/Latin/UnitedStates
    {     62,    74,   239,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 9265,48 , 9313,152 , 134,24 , 9265,48 , 9313,152 , 134,24 , 4389,28 , 4417,74 , 4491,14 , 4389,28 , 4417,74 , 4491,14 , 0,2 , 0,2 , {85,71,88},  151,3 , 4001,26 , 9,4 , 4,0 , 1004,6 , 1010,6 ,     0,     0,     1,     7,     7 }, // Chiga/Latin/Uganda
    {     63,   135,    50,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 180,5 , 180,5 , 236,5 , 236,5 , 512,8 , 534,13 , 18,5 , 216,10 , 7360,39 , 7399,38 , 158,27 , 7360,39 , 7399,38 , 158,27 , 3482,21 , 3440,28 , 3468,14 , 3482,21 , 3440,28 , 3468,14 , 130,2 , 126,2 , {67,78,89},  154,1 , 3648,13 , 9,4 , 4,0 , 1016,4 , 1020,2 ,     2,     1,     1,     6,     7 }, // Chinese/Simplified Han/China
    {     63,   135,   105,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 180,5 , 180,5 , 236,5 , 236,5 , 223,6 , 534,13 , 226,6 , 256,11 , 7360,39 , 7399,38 , 158,27 , 7360,39 , 7399,38 , 158,27 , 3482,21 , 3440,28 , 3468,14 , 3482,21 , 3440,28 , 3468,14 , 130,2 , 126,2 , {72,75,68},  146,3 , 4027,11 , 9,4 , 4,0 , 1016,4 , 1022,9 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/HongKong
    {     63,   135,   136,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 180,5 , 180,5 , 236,5 , 236,5 , 223,6 , 534,13 , 226,6 , 256,11 , 7360,39 , 7399,38 , 158,27 , 7360,39 , 7399,38 , 158,27 , 3482,21 , 3440,28 , 3468,14 , 3482,21 , 3440,28 , 3468,14 , 130,2 , 126,2 , {77,79,80},  155,4 , 4038,13 , 9,4 , 4,0 , 1016,4 , 1031,9 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/Macao
    {     63,   135,   199,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 180,5 , 180,5 , 236,5 , 236,5 , 59,8 , 534,13 , 226,6 , 256,11 , 7360,39 , 7399,38 , 158,27 , 7360,39 , 7399,38 , 158,27 , 3482,21 , 3440,28 , 3468,14 , 3482,21 , 3440,28 , 3468,14 , 130,2 , 126,2 , {83,71,68},  10,1 , 4051,15 , 9,4 , 4,0 , 1016,4 , 1040,3 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/Singapore
    {     63,   158,   105,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 180,5 , 180,5 , 241,5 , 241,5 , 129,8 , 534,13 , 226,6 , 232,13 , 7360,39 , 7360,39 , 158,27 , 7360,39 , 7360,39 , 158,27 , 4505,21 , 3440,28 , 3468,14 , 4505,21 , 3440,28 , 3468,14 , 130,2 , 126,2 , {72,75,68},  146,3 , 4027,11 , 30,5 , 4,0 , 1043,4 , 1047,9 ,     2,     1,     7,     6,     7 }, // Chinese/Traditional Han/HongKong
    {     63,   158,   136,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 180,5 , 180,5 , 241,5 , 241,5 , 129,8 , 534,13 , 226,6 , 232,13 , 7360,39 , 7360,39 , 158,27 , 7360,39 , 7360,39 , 158,27 , 4505,21 , 3440,28 , 3468,14 , 4505,21 , 3440,28 , 3468,14 , 130,2 , 126,2 , {77,79,80},  155,4 , 4066,13 , 30,5 , 4,0 , 1043,4 , 1056,9 ,     2,     1,     7,     6,     7 }, // Chinese/Traditional Han/Macao
    {     63,   158,   224,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 180,5 , 180,5 , 236,5 , 236,5 , 512,8 , 520,14 , 267,5 , 272,12 , 7360,39 , 7360,39 , 158,27 , 7360,39 , 7360,39 , 158,27 , 4505,21 , 3440,28 , 3468,14 , 4505,21 , 3440,28 , 3468,14 , 130,2 , 126,2 , {84,87,68},  10,1 , 4079,13 , 4,5 , 4,0 , 1043,4 , 1065,2 ,     2,     0,     7,     6,     7 }, // Chinese/Traditional Han/Taiwan
    {     64,    29,   189,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 246,8 , 246,8 , 571,10 , 581,23 , 18,5 , 8,10 , 9465,65 , 9530,117 , 9647,30 , 9465,65 , 9677,117 , 9647,30 , 4526,37 , 4563,68 , 4631,14 , 4526,37 , 4563,68 , 4631,14 , 0,2 , 0,2 , {82,85,66},  137,1 , 4092,44 , 4,5 , 4,0 , 1067,19 , 1086,7 ,     2,     1,     1,     6,     7 }, // Church/Cyrillic/Russia
    {     65,    29,   189,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 254,10 , 254,10 , 27,10 , 604,22 , 18,5 , 8,10 , 9794,53 , 9847,61 , 9908,24 , 9794,53 , 9847,61 , 9908,24 , 4645,33 , 4678,66 , 4744,14 , 4645,33 , 4678,66 , 4744,14 , 0,2 , 0,2 , {82,85,66},  137,1 , 4136,31 , 4,5 , 4,0 , 1093,5 , 1098,6 ,     2,     1,     1,     6,     7 }, // Chuvash/Cyrillic/Russia
    {     67,    74,    89,    44,   160,    59,    37,    48,  8722,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 264,8 , 264,8 , 626,10 , 636,23 , 18,5 , 8,10 , 9932,59 , 9991,87 , 10078,24 , 10102,48 , 9991,87 , 10078,24 , 4758,28 , 4786,72 , 4858,14 , 4758,28 , 4786,72 , 4858,14 , 152,16 , 152,16 , {69,85,82},  22,1 , 4167,11 , 4,5 , 4,0 , 1104,6 , 1110,11 ,     2,     1,     1,     6,     7 }, // Colognian/Latin/Germany
    {     69,    74,   242,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 113,16 , 18,5 , 8,10 , 10150,46 , 10196,130 , 158,27 , 10150,46 , 10196,130 , 158,27 , 4872,28 , 4900,61 , 85,14 , 4872,28 , 4900,61 , 85,14 , 168,4 , 168,4 , {71,66,80},  96,1 , 0,7 , 9,4 , 4,0 , 1121,8 , 1129,14 ,     2,     1,     1,     6,     7 }, // Cornish/Latin/UnitedKingdom
    {     70,    74,    82,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 272,7 , 272,7 , 186,10 , 659,25 , 18,5 , 8,10 , 10326,61 , 10387,99 , 10486,24 , 10326,61 , 10510,132 , 10486,24 , 4961,35 , 4996,51 , 5047,14 , 4961,35 , 4996,51 , 5047,14 , 0,2 , 0,2 , {69,85,82},  159,3 , 4178,11 , 4,5 , 4,0 , 1143,5 , 1148,7 ,     2,     1,     1,     6,     7 }, // Corsican/Latin/France
    {     72,    74,    60,    44,    46,    59,    37,    48,  8722,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 141,7 , 141,7 , 684,13 , 436,19 , 18,5 , 148,12 , 10642,49 , 10691,94 , 10785,39 , 10642,49 , 10824,98 , 10785,39 , 2976,28 , 3004,58 , 3062,14 , 2976,28 , 3004,58 , 3076,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 4189,23 , 4,5 , 4,0 , 1155,8 , 1163,8 ,     2,     1,     1,     6,     7 }, // Croatian/Latin/Croatia
    {     72,    74,    29,    44,    46,    59,    37,    48,  8722,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 141,7 , 141,7 , 697,9 , 436,19 , 18,5 , 148,12 , 10642,49 , 10691,94 , 10785,39 , 10642,49 , 10824,98 , 10785,39 , 2976,28 , 3004,58 , 3076,14 , 2976,28 , 3004,58 , 3076,14 , 0,2 , 0,2 , {66,65,77},  139,2 , 4212,85 , 4,5 , 4,0 , 1155,8 , 713,19 ,     2,     1,     1,     6,     7 }, // Croatian/Latin/BosniaAndHerzegowina
    {     73,    74,    64,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 279,7 , 279,7 , 251,8 , 706,17 , 74,4 , 284,10 , 10922,48 , 10970,82 , 158,27 , 10922,48 , 11052,84 , 158,27 , 5061,21 , 5082,49 , 5131,14 , 5061,21 , 5082,49 , 5131,14 , 172,4 , 172,4 , {67,90,75},  162,2 , 4297,68 , 4,5 , 4,0 , 1171,7 , 1178,5 ,     2,     0,     1,     6,     7 }, // Czech/Latin/Czechia
    {     74,    74,    65,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 286,8 , 286,8 , 27,10 , 723,23 , 294,5 , 299,10 , 11136,59 , 11195,84 , 134,24 , 11136,59 , 11195,84 , 134,24 , 5145,37 , 5182,51 , 5233,14 , 5145,37 , 5182,51 , 5233,14 , 0,2 , 0,2 , {68,75,75},  164,3 , 4365,42 , 4,5 , 4,0 , 1183,5 , 1188,7 ,     2,     0,     1,     6,     7 }, // Danish/Latin/Denmark
    {     74,    74,    93,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 286,8 , 286,8 , 27,10 , 723,23 , 294,5 , 299,10 , 11136,59 , 11195,84 , 134,24 , 11136,59 , 11195,84 , 134,24 , 5145,37 , 5182,51 , 5233,14 , 5145,37 , 5182,51 , 5233,14 , 0,2 , 0,2 , {68,75,75},  164,3 , 4365,42 , 4,5 , 4,0 , 1183,5 , 1195,8 ,     2,     0,     1,     6,     7 }, // Danish/Latin/Greenland
    {     75,   152,   140,    46,    44,    44,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 746,6 , 113,16 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {77,86,82},  167,2 , 0,7 , 13,5 , 4,0 , 1203,10 , 1213,13 ,     2,     1,     5,     6,     7 }, // Divehi/Thaana/Maldives
    {     76,    31,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 294,9 , 303,8 , 223,6 , 752,18 , 55,7 , 62,12 , 11279,60 , 11339,73 , 11412,30 , 11279,60 , 11339,73 , 11412,30 , 5247,30 , 5277,51 , 5328,23 , 5247,30 , 5277,51 , 5351,25 , 176,4 , 176,9 , {73,78,82},  122,1 , 4407,37 , 9,4 , 4,0 , 1226,5 , 691,4 ,     2,     1,     7,     7,     7 }, // Dogri/Devanagari/India
    {     77,    74,    40,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 11442,49 , 11491,99 , 11590,24 , 11442,49 , 11491,99 , 11590,24 , 5376,28 , 5404,45 , 5449,14 , 5376,28 , 5404,45 , 5449,14 , 180,5 , 185,6 , {88,65,70},  11,4 , 0,7 , 4,5 , 4,0 , 1231,5 , 1236,8 ,     0,     0,     1,     6,     7 }, // Duala/Latin/Cameroon
    {     78,    74,   161,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8216,  8217, 0,6 , 0,6 , 15,8 , 15,8 , 415,10 , 113,16 , 18,5 , 8,10 , 11614,48 , 11662,88 , 134,24 , 11614,48 , 11662,88 , 134,24 , 5463,21 , 5484,59 , 5543,14 , 5463,21 , 5484,59 , 5543,14 , 168,4 , 168,4 , {69,85,82},  22,1 , 4444,19 , 13,5 , 35,6 , 1244,10 , 1254,9 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Netherlands
    {     78,    74,    13,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8216,  8217, 0,6 , 0,6 , 15,8 , 15,8 , 415,10 , 113,16 , 18,5 , 8,10 , 11614,48 , 11662,88 , 134,24 , 11614,48 , 11662,88 , 134,24 , 5463,21 , 5484,59 , 5543,14 , 5463,21 , 5484,59 , 5543,14 , 168,4 , 168,4 , {65,87,71},  169,4 , 4463,55 , 13,5 , 35,6 , 1244,10 , 1263,5 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Aruba
    {     78,    74,    23,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8216,  8217, 0,6 , 0,6 , 15,8 , 15,8 , 770,9 , 113,16 , 18,5 , 8,10 , 11614,48 , 11662,88 , 134,24 , 11614,48 , 11662,88 , 134,24 , 5463,21 , 5484,59 , 5543,14 , 5463,21 , 5484,59 , 5543,14 , 168,4 , 168,4 , {69,85,82},  22,1 , 4444,19 , 13,5 , 35,6 , 1268,6 , 1274,6 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Belgium
    {     78,    74,    44,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8216,  8217, 0,6 , 0,6 , 15,8 , 15,8 , 415,10 , 113,16 , 18,5 , 8,10 , 11614,48 , 11662,88 , 134,24 , 11614,48 , 11662,88 , 134,24 , 5463,21 , 5484,59 , 5543,14 , 5463,21 , 5484,59 , 5543,14 , 168,4 , 168,4 , {85,83,68},  10,1 , 4518,61 , 13,5 , 35,6 , 1244,10 , 1280,19 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/CaribbeanNetherlands
    {     78,    74,    62,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8216,  8217, 0,6 , 0,6 , 15,8 , 15,8 , 415,10 , 113,16 , 18,5 , 8,10 , 11614,48 , 11662,88 , 134,24 , 11614,48 , 11662,88 , 134,24 , 5463,21 , 5484,59 , 5543,14 , 5463,21 , 5484,59 , 5543,14 , 168,4 , 168,4 , {65,78,71},  173,4 , 4579,97 , 13,5 , 35,6 , 1244,10 , 1299,7 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Curacao
    {     78,    74,   200,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8216,  8217, 0,6 , 0,6 , 15,8 , 15,8 , 415,10 , 113,16 , 18,5 , 8,10 , 11614,48 , 11662,88 , 134,24 , 11614,48 , 11662,88 , 134,24 , 5463,21 , 5484,59 , 5543,14 , 5463,21 , 5484,59 , 5543,14 , 168,4 , 168,4 , {65,78,71},  173,4 , 4579,97 , 13,5 , 35,6 , 1244,10 , 1306,12 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/SintMaarten
    {     78,    74,   219,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8216,  8217, 0,6 , 0,6 , 15,8 , 15,8 , 415,10 , 113,16 , 18,5 , 8,10 , 11614,48 , 11662,88 , 134,24 , 11614,48 , 11662,88 , 134,24 , 5463,21 , 5484,59 , 5543,14 , 5463,21 , 5484,59 , 5543,14 , 168,4 , 168,4 , {83,82,68},  10,1 , 4676,58 , 13,5 , 35,6 , 1244,10 , 1318,8 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Suriname
    {     79,   154,    27,    46,    44,    59,    37,  3872,    45,    43,   101,  8220,  8221,  8216,  8217, 311,9 , 311,9 , 311,9 , 311,9 , 86,10 , 779,30 , 309,22 , 331,27 , 11750,63 , 11813,191 , 12004,27 , 12031,27 , 12058,132 , 12190,27 , 5557,34 , 5591,79 , 5670,27 , 5557,34 , 5591,79 , 5670,27 , 185,5 , 191,6 , {66,84,78},  177,3 , 4734,15 , 9,4 , 4,0 , 1326,6 , 1332,5 ,     2,     1,     7,     6,     7 }, // Dzongkha/Tibetan/Bhutan
    {     82,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 12217,48 , 12265,207 , 12472,24 , 12217,48 , 12265,207 , 12472,24 , 5697,28 , 5725,64 , 5789,14 , 5697,28 , 5725,64 , 5789,14 , 190,2 , 197,2 , {75,69,83},  180,3 , 4749,24 , 9,4 , 4,0 , 1337,6 , 1343,5 ,     2,     1,     7,     6,     7 }, // Embu/Latin/Kenya
    {     83,    74,   243,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 320,10 , 330,9 , 547,6 , 553,18 , 23,7 , 30,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  10,1 , 4773,35 , 9,4 , 4,0 , 1348,16 , 991,13 ,     2,     1,     7,     6,     7 }, // English/Latin/UnitedStates
    {     83,    30,   243,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 12496,80 , 12576,154 , 12730,36 , 12496,80 , 12576,154 , 12730,36 , 5803,49 , 5852,85 , 5937,21 , 5803,49 , 5852,85 , 5937,21 , 192,4 , 199,4 , {85,83,68},  10,1 , 0,7 , 13,5 , 4,0 , 1364,10 , 1374,25 ,     2,     1,     7,     6,     7 }, // English/Deseret/UnitedStates
    {     83,    74,     5,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 320,10 , 330,9 , 547,6 , 553,18 , 23,7 , 30,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  10,1 , 4773,35 , 9,4 , 4,0 , 1399,7 , 1406,14 ,     2,     1,     7,     6,     7 }, // English/Latin/AmericanSamoa
    {     83,    74,     8,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {88,67,68},  10,1 , 4808,71 , 9,4 , 4,0 , 1399,7 , 1420,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Anguilla
    {     83,    74,    10,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {88,67,68},  10,1 , 4808,71 , 9,4 , 4,0 , 1399,7 , 1428,17 ,     2,     1,     7,     6,     7 }, // English/Latin/AntiguaAndBarbuda
    {     83,    74,    15,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 223,6 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12815,51 , 48,86 , 134,24 , 0,28 , 28,57 , 5958,25 , 0,28 , 28,57 , 5958,25 , 196,2 , 203,2 , {65,85,68},  10,1 , 4879,59 , 9,4 , 4,0 , 1445,18 , 1463,9 ,     2,     1,     1,     6,     7 }, // English/Latin/Australia
    {     83,    74,    16,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {69,85,82},  22,1 , 4938,20 , 13,5 , 4,0 , 1399,7 , 1472,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Austria
    {     83,    74,    18,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {66,83,68},  10,1 , 4958,53 , 9,4 , 4,0 , 1399,7 , 1479,7 ,     2,     1,     7,     6,     7 }, // English/Latin/Bahamas
    {     83,    74,    21,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {66,66,68},  10,1 , 5011,56 , 9,4 , 4,0 , 1399,7 , 1486,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Barbados
    {     83,    74,    23,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 59,8 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {69,85,82},  22,1 , 4938,20 , 4,5 , 4,0 , 1399,7 , 1494,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Belgium
    {     83,    74,    24,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 59,8 , 809,18 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {66,90,68},  10,1 , 5067,47 , 9,4 , 4,0 , 1399,7 , 1501,6 ,     2,     1,     7,     6,     7 }, // English/Latin/Belize
    {     83,    74,    26,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {66,77,68},  10,1 , 5114,56 , 9,4 , 4,0 , 1399,7 , 1507,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Bermuda
    {     83,    74,    30,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 59,8 , 809,18 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {66,87,80},  183,1 , 5170,50 , 9,4 , 4,0 , 1399,7 , 1514,8 ,     2,     1,     7,     6,     7 }, // English/Latin/Botswana
    {     83,    74,    33,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {85,83,68},  184,3 , 4773,35 , 9,4 , 4,0 , 1399,7 , 1522,30 ,     2,     1,     1,     6,     7 }, // English/Latin/BritishIndianOceanTerritory
    {     83,    74,    34,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {85,83,68},  184,3 , 4773,35 , 9,4 , 4,0 , 1399,7 , 1552,22 ,     2,     1,     1,     6,     7 }, // English/Latin/BritishVirginIslands
    {     83,    74,    38,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 320,10 , 330,9 , 547,6 , 553,18 , 18,5 , 8,10 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {66,73,70},  187,3 , 5220,53 , 9,4 , 4,0 , 1399,7 , 1574,7 ,     0,     0,     1,     6,     7 }, // English/Latin/Burundi
    {     83,    74,    40,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {88,65,70},  11,4 , 5273,83 , 9,4 , 4,0 , 1399,7 , 1581,8 ,     0,     0,     1,     6,     7 }, // English/Latin/Cameroon
    {     83,    74,    41,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 86,10 , 553,18 , 23,7 , 30,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 168,4 , 168,4 , {67,65,68},  10,1 , 5356,53 , 9,4 , 4,0 , 1589,16 , 1605,6 ,     2,     0,     7,     6,     7 }, // English/Latin/Canada
    {     83,    74,    45,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {75,89,68},  10,1 , 5409,71 , 9,4 , 4,0 , 1399,7 , 1611,14 ,     2,     1,     1,     6,     7 }, // English/Latin/CaymanIslands
    {     83,    74,    51,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {65,85,68},  10,1 , 4879,59 , 9,4 , 4,0 , 1399,7 , 1625,16 ,     2,     1,     1,     6,     7 }, // English/Latin/ChristmasIsland
    {     83,    74,    53,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {65,85,68},  10,1 , 4879,59 , 9,4 , 4,0 , 1399,7 , 1641,23 ,     2,     1,     1,     6,     7 }, // English/Latin/CocosIslands
    {     83,    74,    58,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {78,90,68},  10,1 , 5480,62 , 9,4 , 4,0 , 1399,7 , 1664,12 ,     2,     1,     1,     6,     7 }, // English/Latin/CookIslands
    {     83,    74,    63,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {69,85,82},  22,1 , 4938,20 , 9,4 , 4,0 , 1399,7 , 1676,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Cyprus
    {     83,    74,    65,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 294,5 , 299,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {68,75,75},  164,3 , 5542,44 , 4,5 , 4,0 , 1399,7 , 1682,7 ,     2,     0,     1,     6,     7 }, // English/Latin/Denmark
    {     83,    74,    66,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {85,83,68},  184,3 , 4773,35 , 9,4 , 4,0 , 1399,7 , 1689,12 ,     2,     1,     1,     6,     7 }, // English/Latin/DiegoGarcia
    {     83,    74,    68,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {88,67,68},  10,1 , 4808,71 , 9,4 , 4,0 , 1399,7 , 1701,8 ,     2,     1,     7,     6,     7 }, // English/Latin/Dominica
    {     83,    74,    74,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {69,82,78},  6,3 , 5586,50 , 9,4 , 4,0 , 1399,7 , 1709,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Eritrea
    {     83,    74,    76,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {83,90,76},  190,1 , 5636,53 , 9,4 , 4,0 , 1399,7 , 1716,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Eswatini
    {     83,    74,    78,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {70,75,80},  96,1 , 5689,74 , 9,4 , 4,0 , 1399,7 , 1724,16 ,     2,     1,     1,     6,     7 }, // English/Latin/FalklandIslands
    {     83,    74,    80,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {70,74,68},  10,1 , 5763,47 , 9,4 , 4,0 , 1399,7 , 1740,4 ,     2,     1,     1,     6,     7 }, // English/Latin/Fiji
    {     83,    74,    81,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 358,4 , 362,9 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {69,85,82},  22,1 , 4938,20 , 4,5 , 4,0 , 1399,7 , 1744,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Finland
    {     83,    74,    87,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {71,77,68},  191,1 , 5810,50 , 9,4 , 4,0 , 1399,7 , 1751,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Gambia
    {     83,    74,    89,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {69,85,82},  22,1 , 4938,20 , 4,5 , 4,0 , 1399,7 , 1757,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Germany
    {     83,    74,    90,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {71,72,83},  15,3 , 5860,47 , 9,4 , 4,0 , 1399,7 , 1764,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Ghana
    {     83,    74,    91,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {71,73,80},  96,1 , 5907,53 , 9,4 , 4,0 , 1399,7 , 1769,9 ,     2,     1,     1,     6,     7 }, // English/Latin/Gibraltar
    {     83,    74,    94,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {88,67,68},  10,1 , 4808,71 , 9,4 , 4,0 , 1399,7 , 1778,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Grenada
    {     83,    74,    96,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 320,10 , 330,9 , 547,6 , 553,18 , 23,7 , 30,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  10,1 , 4773,35 , 9,4 , 4,0 , 1399,7 , 1785,4 ,     2,     1,     7,     6,     7 }, // English/Latin/Guam
    {     83,    74,    98,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {71,66,80},  96,1 , 5960,32 , 9,4 , 4,0 , 1399,7 , 1789,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Guernsey
    {     83,    74,   101,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {71,89,68},  10,1 , 5992,56 , 9,4 , 4,0 , 1399,7 , 1797,6 ,     2,     0,     1,     6,     7 }, // English/Latin/Guyana
    {     83,    74,   105,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 129,8 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {72,75,68},  146,3 , 6048,56 , 9,4 , 4,0 , 1399,7 , 1803,19 ,     2,     1,     7,     6,     7 }, // English/Latin/HongKong
    {     83,    74,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 320,10 , 330,9 , 59,8 , 287,18 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {73,78,82},  122,1 , 6104,44 , 9,4 , 4,0 , 1399,7 , 1822,5 ,     2,     1,     7,     7,     7 }, // English/Latin/India
    {     83,    74,   112,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 113,16 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 168,4 , 168,4 , {69,85,82},  22,1 , 4938,20 , 9,4 , 4,0 , 1399,7 , 1827,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Ireland
    {     83,    74,   113,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {71,66,80},  96,1 , 5960,32 , 9,4 , 4,0 , 1399,7 , 1834,11 ,     2,     1,     1,     6,     7 }, // English/Latin/IsleOfMan
    {     83,    74,   114,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 74,4 , 78,9 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {73,76,83},  50,1 , 6148,62 , 9,4 , 4,0 , 1399,7 , 1845,6 ,     2,     1,     7,     5,     6 }, // English/Latin/Israel
    {     83,    74,   117,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 223,6 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {74,77,68},  10,1 , 6210,53 , 9,4 , 4,0 , 1399,7 , 1851,7 ,     2,     1,     7,     6,     7 }, // English/Latin/Jamaica
    {     83,    74,   119,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {71,66,80},  96,1 , 5960,32 , 9,4 , 4,0 , 1399,7 , 1858,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Jersey
    {     83,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {75,69,83},  180,3 , 6263,53 , 9,4 , 4,0 , 1399,7 , 1343,5 ,     2,     1,     7,     6,     7 }, // English/Latin/Kenya
    {     83,    74,   123,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {65,85,68},  10,1 , 4879,59 , 9,4 , 4,0 , 1399,7 , 1864,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Kiribati
    {     83,    74,   130,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {90,65,82},  9,1 , 6316,61 , 9,4 , 4,0 , 1399,7 , 1872,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Lesotho
    {     83,    74,   131,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {76,82,68},  10,1 , 6377,53 , 9,4 , 4,0 , 1399,7 , 1879,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Liberia
    {     83,    74,   136,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {77,79,80},  155,4 , 6430,53 , 9,4 , 4,0 , 1399,7 , 1886,15 ,     2,     1,     7,     6,     7 }, // English/Latin/Macao
    {     83,    74,   137,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {77,71,65},  192,2 , 6483,52 , 9,4 , 4,0 , 1399,7 , 1901,10 ,     0,     0,     1,     6,     7 }, // English/Latin/Madagascar
    {     83,    74,   138,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {77,87,75},  194,2 , 6535,53 , 9,4 , 4,0 , 1399,7 , 1911,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Malawi
    {     83,    74,   139,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {77,89,82},  196,2 , 6588,59 , 9,4 , 4,0 , 1399,7 , 1917,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Malaysia
    {     83,    74,   140,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 746,6 , 113,16 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {77,86,82},  198,2 , 6647,58 , 13,5 , 4,0 , 1399,7 , 1925,8 ,     2,     1,     5,     6,     7 }, // English/Latin/Maldives
    {     83,    74,   142,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {69,85,82},  22,1 , 4938,20 , 9,4 , 4,0 , 1399,7 , 1933,5 ,     2,     1,     7,     6,     7 }, // English/Latin/Malta
    {     83,    74,   143,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 320,10 , 330,9 , 547,6 , 553,18 , 23,7 , 30,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  10,1 , 4773,35 , 9,4 , 4,0 , 1399,7 , 1938,16 ,     2,     1,     7,     6,     7 }, // English/Latin/MarshallIslands
    {     83,    74,   146,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {77,85,82},  129,2 , 6705,53 , 9,4 , 4,0 , 1399,7 , 1954,9 ,     2,     0,     1,     6,     7 }, // English/Latin/Mauritius
    {     83,    74,   149,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {85,83,68},  184,3 , 4773,35 , 9,4 , 4,0 , 1399,7 , 1963,10 ,     2,     1,     1,     6,     7 }, // English/Latin/Micronesia
    {     83,    74,   154,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {88,67,68},  10,1 , 4808,71 , 9,4 , 4,0 , 1399,7 , 1973,10 ,     2,     1,     1,     6,     7 }, // English/Latin/Montserrat
    {     83,    74,   158,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {78,65,68},  10,1 , 6758,53 , 9,4 , 4,0 , 1399,7 , 1983,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Namibia
    {     83,    74,   159,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {65,85,68},  10,1 , 4879,59 , 9,4 , 4,0 , 1399,7 , 1990,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Nauru
    {     83,    74,   161,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {69,85,82},  22,1 , 4938,20 , 13,5 , 35,6 , 1399,7 , 1995,11 ,     2,     1,     1,     6,     7 }, // English/Latin/Netherlands
    {     83,    74,   163,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 827,7 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {78,90,68},  10,1 , 5480,62 , 9,4 , 4,0 , 1399,7 , 2006,11 ,     2,     1,     1,     6,     7 }, // English/Latin/NewZealand
    {     83,    74,   166,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {78,71,78},  126,1 , 6811,50 , 9,4 , 4,0 , 1399,7 , 2017,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Nigeria
    {     83,    74,   167,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {78,90,68},  10,1 , 5480,62 , 9,4 , 4,0 , 1399,7 , 2024,4 ,     2,     1,     1,     6,     7 }, // English/Latin/Niue
    {     83,    74,   168,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {65,85,68},  10,1 , 4879,59 , 9,4 , 4,0 , 1399,7 , 2028,14 ,     2,     1,     1,     6,     7 }, // English/Latin/NorfolkIsland
    {     83,    74,   171,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 320,10 , 330,9 , 547,6 , 553,18 , 23,7 , 30,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  10,1 , 4773,35 , 9,4 , 4,0 , 1399,7 , 2042,24 ,     2,     1,     1,     6,     7 }, // English/Latin/NorthernMarianaIslands
    {     83,    74,   174,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {80,75,82},  129,2 , 6861,53 , 9,4 , 4,0 , 1399,7 , 2066,8 ,     2,     0,     7,     6,     7 }, // English/Latin/Pakistan
    {     83,    74,   175,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {85,83,68},  184,3 , 4773,35 , 9,4 , 4,0 , 1399,7 , 2074,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Palau
    {     83,    74,   178,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {80,71,75},  138,1 , 6914,73 , 9,4 , 4,0 , 1399,7 , 2079,16 ,     2,     1,     1,     6,     7 }, // English/Latin/PapuaNewGuinea
    {     83,    74,   181,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 320,10 , 330,9 , 547,6 , 553,18 , 23,7 , 30,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {80,72,80},  150,1 , 3661,53 , 9,4 , 4,0 , 1399,7 , 2095,11 ,     2,     1,     7,     6,     7 }, // English/Latin/Philippines
    {     83,    74,   182,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {78,90,68},  10,1 , 5480,62 , 9,4 , 4,0 , 1399,7 , 2106,16 ,     2,     1,     1,     6,     7 }, // English/Latin/Pitcairn
    {     83,    74,   185,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 320,10 , 330,9 , 547,6 , 553,18 , 23,7 , 30,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  10,1 , 4773,35 , 9,4 , 4,0 , 1399,7 , 2122,11 ,     2,     1,     7,     6,     7 }, // English/Latin/PuertoRico
    {     83,    74,   190,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {82,87,70},  200,2 , 6987,47 , 9,4 , 4,0 , 1399,7 , 2133,6 ,     0,     0,     1,     6,     7 }, // English/Latin/Rwanda
    {     83,    74,   191,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {87,83,84},  202,3 , 7034,40 , 9,4 , 4,0 , 1399,7 , 2139,5 ,     2,     1,     7,     6,     7 }, // English/Latin/Samoa
    {     83,    74,   197,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {83,67,82},  205,2 , 7074,59 , 9,4 , 4,0 , 1399,7 , 2144,10 ,     2,     1,     1,     6,     7 }, // English/Latin/Seychelles
    {     83,    74,   198,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {83,76,69},  207,2 , 7133,68 , 9,4 , 4,0 , 1399,7 , 2154,12 ,     2,     0,     1,     6,     7 }, // English/Latin/SierraLeone
    {     83,    74,   199,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 223,6 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {83,71,68},  10,1 , 7201,56 , 9,4 , 4,0 , 1399,7 , 2166,9 ,     2,     1,     7,     6,     7 }, // English/Latin/Singapore
    {     83,    74,   200,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {65,78,71},  173,4 , 7257,95 , 9,4 , 4,0 , 1399,7 , 2175,12 ,     2,     1,     1,     6,     7 }, // English/Latin/SintMaarten
    {     83,    74,   202,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {69,85,82},  22,1 , 4938,20 , 4,5 , 41,7 , 1399,7 , 2187,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Slovenia
    {     83,    74,   203,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {83,66,68},  10,1 , 7352,74 , 9,4 , 4,0 , 1399,7 , 2195,15 ,     2,     1,     1,     6,     7 }, // English/Latin/SolomonIslands
    {     83,    74,   205,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 834,10 , 809,18 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {90,65,82},  9,1 , 6316,61 , 9,4 , 4,0 , 1399,7 , 2210,12 ,     2,     1,     7,     6,     7 }, // English/Latin/SouthAfrica
    {     83,    74,   208,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {83,83,80},  96,1 , 7426,68 , 9,4 , 4,0 , 1399,7 , 2222,11 ,     2,     1,     1,     6,     7 }, // English/Latin/SouthSudan
    {     83,    74,   212,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {83,72,80},  96,1 , 7494,53 , 9,4 , 4,0 , 1399,7 , 2233,9 ,     2,     1,     1,     6,     7 }, // English/Latin/SaintHelena
    {     83,    74,   213,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {88,67,68},  10,1 , 4808,71 , 9,4 , 4,0 , 1399,7 , 2242,16 ,     2,     1,     1,     6,     7 }, // English/Latin/SaintKittsAndNevis
    {     83,    74,   214,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {88,67,68},  10,1 , 4808,71 , 9,4 , 4,0 , 1399,7 , 2258,8 ,     2,     1,     1,     6,     7 }, // English/Latin/SaintLucia
    {     83,    74,   217,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {88,67,68},  10,1 , 4808,71 , 9,4 , 4,0 , 1399,7 , 2266,27 ,     2,     1,     1,     6,     7 }, // English/Latin/SaintVincentAndGrenadines
    {     83,    74,   218,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {83,68,71},  0,0 , 7547,50 , 9,4 , 4,0 , 1399,7 , 2293,5 ,     2,     1,     6,     5,     6 }, // English/Latin/Sudan
    {     83,    74,   221,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 86,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {83,69,75},  209,2 , 7597,47 , 4,5 , 4,0 , 1399,7 , 2298,6 ,     2,     0,     1,     6,     7 }, // English/Latin/Sweden
    {     83,    74,   222,    46,  8217,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 27,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {67,72,70},  0,0 , 7644,41 , 13,5 , 48,5 , 1399,7 , 2304,11 ,     2,     0,     1,     6,     7 }, // English/Latin/Switzerland
    {     83,    74,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {84,90,83},  123,3 , 7685,62 , 9,4 , 4,0 , 1399,7 , 2315,8 ,     2,     0,     1,     6,     7 }, // English/Latin/Tanzania
    {     83,    74,   230,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {78,90,68},  10,1 , 5480,62 , 9,4 , 4,0 , 1399,7 , 2323,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Tokelau
    {     83,    74,   231,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {84,79,80},  211,2 , 7747,49 , 9,4 , 4,0 , 1399,7 , 2330,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Tonga
    {     83,    74,   232,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {84,84,68},  10,1 , 7796,80 , 9,4 , 4,0 , 1399,7 , 2335,17 ,     2,     1,     7,     6,     7 }, // English/Latin/TrinidadAndTobago
    {     83,    74,   237,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {85,83,68},  184,3 , 4773,35 , 9,4 , 4,0 , 1399,7 , 2352,22 ,     2,     1,     1,     6,     7 }, // English/Latin/TurksAndCaicosIslands
    {     83,    74,   238,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {65,85,68},  10,1 , 4879,59 , 9,4 , 4,0 , 1399,7 , 2374,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Tuvalu
    {     83,    74,   239,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {85,71,88},  151,3 , 7876,56 , 9,4 , 4,0 , 1399,7 , 1010,6 ,     0,     0,     1,     7,     7 }, // English/Latin/Uganda
    {     83,    74,   241,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 320,10 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {65,69,68},  213,3 , 7932,55 , 9,4 , 4,0 , 1399,7 , 2380,20 ,     2,     1,     6,     6,     7 }, // English/Latin/UnitedArabEmirates
    {     83,    74,   242,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {71,66,80},  96,1 , 7987,47 , 9,4 , 4,0 , 2400,15 , 2415,14 ,     2,     1,     1,     6,     7 }, // English/Latin/UnitedKingdom
    {     83,    74,   244,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 320,10 , 330,9 , 547,6 , 553,18 , 23,7 , 30,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  10,1 , 4773,35 , 9,4 , 4,0 , 1399,7 , 2429,21 ,     2,     1,     7,     6,     7 }, // English/Latin/UnitedStatesOutlyingIslands
    {     83,    74,   245,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 320,10 , 330,9 , 547,6 , 553,18 , 23,7 , 30,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  10,1 , 4773,35 , 9,4 , 4,0 , 1399,7 , 2450,19 ,     2,     1,     7,     6,     7 }, // English/Latin/UnitedStatesVirginIslands
    {     83,    74,   248,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {86,85,86},  216,2 , 8034,43 , 9,4 , 4,0 , 1399,7 , 2469,7 ,     0,     0,     1,     6,     7 }, // English/Latin/Vanuatu
    {     83,    74,   254,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {0,0,0},  0,0 , 2547,0 , 9,4 , 4,0 , 1399,7 , 2476,5 ,     2,     1,     1,     6,     7 }, // English/Latin/World
    {     83,    74,   256,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 186,10 , 10,17 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {90,77,87},  138,1 , 8077,50 , 9,4 , 4,0 , 1399,7 , 662,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Zambia
    {     83,    74,   257,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 330,9 , 330,9 , 129,8 , 809,18 , 18,5 , 8,10 , 12766,49 , 48,86 , 134,24 , 12766,49 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 196,2 , 203,2 , {85,83,68},  184,3 , 4773,35 , 9,4 , 4,0 , 1399,7 , 2481,8 ,     2,     1,     7,     6,     7 }, // English/Latin/Zimbabwe
    {     83,   132,   242,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 12866,72 , 12938,156 , 13094,36 , 12866,72 , 12938,156 , 13094,36 , 5983,42 , 6025,88 , 6113,21 , 5983,42 , 6025,88 , 6113,21 , 198,4 , 205,4 , {71,66,80},  96,1 , 0,7 , 13,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // English/Shavian/UnitedKingdom
    {     84,    29,   189,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 13130,48 , 13178,106 , 158,27 , 13178,106 , 13178,106 , 158,27 , 6134,28 , 6162,61 , 85,14 , 6134,28 , 6223,82 , 85,14 , 0,2 , 0,2 , {82,85,66},  137,1 , 0,7 , 13,5 , 4,0 , 2489,11 , 2500,13 ,     2,     1,     1,     6,     7 }, // Erzya/Cyrillic/Russia
    {     85,    74,   254,    44,   160,    59,    37,    48,  8722,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 339,9 , 339,9 , 844,8 , 852,26 , 18,5 , 371,25 , 13284,48 , 13332,91 , 134,24 , 13423,48 , 13332,91 , 134,24 , 6305,21 , 6326,51 , 6377,14 , 6305,21 , 6326,51 , 6377,14 , 202,3 , 209,3 , {0,0,0},  0,0 , 2547,0 , 24,6 , 4,0 , 2513,9 , 2522,5 ,     2,     1,     1,     6,     7 }, // Esperanto/Latin/World
    {     86,    74,    75,    44,   160,    59,    37,    48,  8722,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 348,8 , 348,8 , 251,8 , 878,18 , 18,5 , 8,10 , 13471,59 , 13530,91 , 13621,24 , 13471,59 , 13530,91 , 13621,24 , 6391,14 , 6405,63 , 6391,14 , 6391,14 , 6405,63 , 6391,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 8127,20 , 4,5 , 4,0 , 2527,5 , 2532,5 ,     2,     1,     1,     6,     7 }, // Estonian/Latin/Estonia
    {     88,    74,    90,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 356,11 , 367,10 , 547,6 , 896,23 , 396,12 , 408,17 , 13645,48 , 13693,87 , 13780,24 , 13645,48 , 13693,87 , 13780,24 , 6468,28 , 6496,44 , 6540,14 , 6468,28 , 6496,44 , 6540,14 , 205,3 , 212,5 , {71,72,83},  15,3 , 8147,37 , 9,4 , 4,0 , 2537,6 , 2543,12 ,     2,     1,     1,     6,     7 }, // Ewe/Latin/Ghana
    {     88,    74,   229,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 356,11 , 367,10 , 547,6 , 896,23 , 18,5 , 8,10 , 13645,48 , 13693,87 , 13780,24 , 13645,48 , 13693,87 , 13780,24 , 6468,28 , 6496,44 , 6540,14 , 6468,28 , 6496,44 , 6540,14 , 205,3 , 212,5 , {88,79,70},  131,5 , 8184,106 , 9,4 , 4,0 , 2537,6 , 2555,11 ,     0,     0,     1,     6,     7 }, // Ewe/Latin/Togo
    {     89,    74,    40,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 13804,50 , 13854,141 , 13995,24 , 13804,50 , 13854,141 , 13995,24 , 6554,30 , 6584,85 , 6669,14 , 6554,30 , 6584,85 , 6669,14 , 208,7 , 217,9 , {88,65,70},  11,4 , 8290,23 , 4,5 , 4,0 , 2566,6 , 2572,7 ,     0,     0,     1,     6,     7 }, // Ewondo/Latin/Cameroon
    {     90,    74,    79,    44,    46,    59,    37,    48,  8722,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 286,8 , 286,8 , 251,8 , 878,18 , 18,5 , 8,10 , 14019,48 , 14067,83 , 134,24 , 14150,59 , 14067,83 , 134,24 , 6683,28 , 6711,74 , 6785,14 , 6799,35 , 6711,74 , 6785,14 , 0,2 , 0,2 , {68,75,75},  209,2 , 8313,43 , 4,5 , 4,0 , 2579,8 , 2587,7 ,     2,     0,     1,     6,     7 }, // Faroese/Latin/FaroeIslands
    {     90,    74,    65,    44,    46,    59,    37,    48,  8722,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 286,8 , 286,8 , 251,8 , 878,18 , 18,5 , 8,10 , 14019,48 , 14067,83 , 134,24 , 14150,59 , 14067,83 , 134,24 , 6683,28 , 6711,74 , 6785,14 , 6799,35 , 6711,74 , 6785,14 , 0,2 , 0,2 , {68,75,75},  164,3 , 8313,43 , 4,5 , 4,0 , 2579,8 , 1188,7 ,     2,     0,     1,     6,     7 }, // Faroese/Latin/Denmark
    {     92,    74,   181,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 377,9 , 386,8 , 547,6 , 553,18 , 23,7 , 30,12 , 7823,48 , 7871,88 , 14209,38 , 7823,48 , 7871,88 , 7823,48 , 6834,28 , 6862,55 , 6834,28 , 6834,28 , 6862,55 , 6834,28 , 0,2 , 0,2 , {80,72,80},  150,1 , 8356,58 , 9,4 , 4,0 , 2594,8 , 853,9 ,     2,     1,     7,     6,     7 }, // Filipino/Latin/Philippines
    {     93,    74,    81,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 348,8 , 348,8 , 919,8 , 706,17 , 358,4 , 362,9 , 14247,69 , 14316,105 , 14421,24 , 14445,93 , 14538,129 , 14421,24 , 6917,21 , 6938,67 , 7005,14 , 6917,21 , 7019,81 , 7005,14 , 215,3 , 226,3 , {69,85,82},  22,1 , 8414,20 , 4,5 , 4,0 , 2602,5 , 2607,5 ,     2,     1,     1,     6,     7 }, // Finnish/Latin/Finland
    {     94,    74,    82,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 2612,8 , 2620,6 ,     2,     1,     1,     6,     7 }, // French/Latin/France
    {     94,    74,     4,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 23,7 , 30,12 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {68,90,68},  218,2 , 8434,51 , 4,5 , 4,0 , 2612,8 , 2626,7 ,     2,     1,     6,     5,     6 }, // French/Latin/Algeria
    {     94,    74,    23,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 827,7 , 113,16 , 18,5 , 425,23 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 2612,8 , 2633,8 ,     2,     1,     1,     6,     7 }, // French/Latin/Belgium
    {     94,    74,    25,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,79,70},  131,5 , 8485,59 , 4,5 , 4,0 , 2612,8 , 2641,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Benin
    {     94,    74,    37,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,79,70},  131,5 , 8485,59 , 4,5 , 4,0 , 2612,8 , 2646,12 ,     0,     0,     1,     6,     7 }, // French/Latin/BurkinaFaso
    {     94,    74,    38,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {66,73,70},  187,3 , 8544,53 , 4,5 , 4,0 , 2612,8 , 1574,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Burundi
    {     94,    74,    40,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 218,5 , 229,4 , {88,65,70},  11,4 , 8597,56 , 4,5 , 4,0 , 2612,8 , 1236,8 ,     0,     0,     1,     6,     7 }, // French/Latin/Cameroon
    {     94,    74,    41,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8221,  8220, 0,6 , 0,6 , 394,8 , 394,8 , 86,10 , 113,16 , 448,9 , 457,24 , 14815,64 , 14730,85 , 134,24 , 14815,64 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 168,4 , 168,4 , {67,65,68},  10,1 , 8653,54 , 53,6 , 4,0 , 2658,17 , 1605,6 ,     2,     0,     7,     6,     7 }, // French/Latin/Canada
    {     94,    74,    46,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,65,70},  11,4 , 8597,56 , 4,5 , 4,0 , 2612,8 , 2675,25 ,     0,     0,     1,     6,     7 }, // French/Latin/CentralAfricanRepublic
    {     94,    74,    48,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 23,7 , 30,12 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,65,70},  11,4 , 8597,56 , 4,5 , 4,0 , 2612,8 , 2700,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Chad
    {     94,    74,    55,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {75,77,70},  43,2 , 8707,51 , 4,5 , 4,0 , 2612,8 , 2705,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Comoros
    {     94,    74,    56,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,65,70},  11,4 , 8597,56 , 4,5 , 4,0 , 2612,8 , 2712,17 ,     0,     0,     1,     6,     7 }, // French/Latin/CongoBrazzaville
    {     94,    74,    57,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {67,68,70},  220,2 , 8758,53 , 4,5 , 4,0 , 2612,8 , 2729,14 ,     2,     1,     1,     6,     7 }, // French/Latin/CongoKinshasa
    {     94,    74,    67,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 23,7 , 30,12 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {68,74,70},  3,3 , 8811,57 , 4,5 , 4,0 , 2612,8 , 2743,8 ,     0,     0,     6,     6,     7 }, // French/Latin/Djibouti
    {     94,    74,    73,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,65,70},  11,4 , 8597,56 , 4,5 , 4,0 , 2612,8 , 2751,18 ,     0,     0,     1,     6,     7 }, // French/Latin/EquatorialGuinea
    {     94,    74,    83,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 2612,8 , 2769,16 ,     2,     1,     1,     6,     7 }, // French/Latin/FrenchGuiana
    {     94,    74,    84,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,80,70},  222,4 , 8868,35 , 4,5 , 4,0 , 2612,8 , 2785,19 ,     0,     0,     1,     6,     7 }, // French/Latin/FrenchPolynesia
    {     94,    74,    86,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,65,70},  11,4 , 8597,56 , 4,5 , 4,0 , 2612,8 , 2804,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Gabon
    {     94,    74,    95,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 2612,8 , 2809,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Guadeloupe
    {     94,    74,    99,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {71,78,70},  226,2 , 8903,48 , 4,5 , 4,0 , 2612,8 , 2819,6 ,     0,     0,     1,     6,     7 }, // French/Latin/Guinea
    {     94,    74,   102,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {72,84,71},  228,1 , 8951,57 , 4,5 , 4,0 , 2612,8 , 2825,5 ,     2,     1,     1,     6,     7 }, // French/Latin/Haiti
    {     94,    74,   116,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,79,70},  131,5 , 8485,59 , 4,5 , 4,0 , 2612,8 , 2830,13 ,     0,     0,     1,     6,     7 }, // French/Latin/IvoryCoast
    {     94,    74,   135,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 2612,8 , 2843,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Luxembourg
    {     94,    74,   137,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {77,71,65},  192,2 , 9008,54 , 4,5 , 4,0 , 2612,8 , 1901,10 ,     0,     0,     1,     6,     7 }, // French/Latin/Madagascar
    {     94,    74,   141,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,79,70},  131,5 , 8485,59 , 4,5 , 4,0 , 2612,8 , 574,4 ,     0,     0,     1,     6,     7 }, // French/Latin/Mali
    {     94,    74,   144,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 2612,8 , 2853,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Martinique
    {     94,    74,   145,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 23,7 , 30,12 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {77,82,85},  229,2 , 9062,66 , 4,5 , 4,0 , 2612,8 , 2863,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Mauritania
    {     94,    74,   146,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {77,85,82},  129,2 , 9128,63 , 4,5 , 4,0 , 2612,8 , 2873,7 ,     2,     0,     1,     6,     7 }, // French/Latin/Mauritius
    {     94,    74,   147,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 2612,8 , 2880,7 ,     2,     1,     1,     6,     7 }, // French/Latin/Mayotte
    {     94,    74,   151,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 2612,8 , 2887,6 ,     2,     1,     1,     6,     7 }, // French/Latin/Monaco
    {     94,    74,   155,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14879,61 , 14730,85 , 134,24 , 14879,61 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 168,4 , 168,4 , {77,65,68},  231,3 , 9191,54 , 4,5 , 4,0 , 2612,8 , 2893,5 ,     2,     1,     1,     6,     7 }, // French/Latin/Morocco
    {     94,    74,   162,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,80,70},  222,4 , 8868,35 , 4,5 , 4,0 , 2612,8 , 2898,18 ,     0,     0,     1,     6,     7 }, // French/Latin/NewCaledonia
    {     94,    74,   165,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,79,70},  131,5 , 8485,59 , 4,5 , 4,0 , 2612,8 , 2916,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Niger
    {     94,    74,   187,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 2612,8 , 2921,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Reunion
    {     94,    74,   190,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {82,87,70},  200,2 , 9245,50 , 4,5 , 4,0 , 2612,8 , 2133,6 ,     0,     0,     1,     6,     7 }, // French/Latin/Rwanda
    {     94,    74,   195,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,79,70},  131,5 , 8485,59 , 4,5 , 4,0 , 2612,8 , 2931,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Senegal
    {     94,    74,   197,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {83,67,82},  205,2 , 9295,71 , 4,5 , 4,0 , 2612,8 , 2144,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Seychelles
    {     94,    74,   211,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 2612,8 , 2938,16 ,     2,     1,     1,     6,     7 }, // French/Latin/SaintBarthelemy
    {     94,    74,   215,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 2612,8 , 2954,12 ,     2,     1,     1,     6,     7 }, // French/Latin/SaintMartin
    {     94,    74,   216,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 2612,8 , 2966,24 ,     2,     1,     1,     6,     7 }, // French/Latin/SaintPierreAndMiquelon
    {     94,    74,   222,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 394,8 , 394,8 , 251,8 , 10,17 , 18,5 , 481,14 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {67,72,70},  234,3 , 9366,45 , 4,5 , 4,0 , 2990,15 , 3005,6 ,     2,     0,     1,     6,     7 }, // French/Latin/Switzerland
    {     94,    74,   223,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 23,7 , 30,12 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {83,89,80},  237,2 , 9411,51 , 4,5 , 4,0 , 2612,8 , 3011,5 ,     0,     0,     6,     5,     6 }, // French/Latin/Syria
    {     94,    74,   229,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,79,70},  131,5 , 8485,59 , 4,5 , 4,0 , 2612,8 , 3016,4 ,     0,     0,     1,     6,     7 }, // French/Latin/Togo
    {     94,    74,   234,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 23,7 , 30,12 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {84,78,68},  239,2 , 9462,51 , 4,5 , 4,0 , 2612,8 , 3020,7 ,     3,     0,     1,     6,     7 }, // French/Latin/Tunisia
    {     94,    74,   248,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 23,7 , 30,12 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {86,85,86},  216,2 , 9513,51 , 4,5 , 4,0 , 2612,8 , 2469,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Vanuatu
    {     94,    74,   252,    44,  8239,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 394,8 , 394,8 , 186,10 , 113,16 , 18,5 , 8,10 , 14667,63 , 14730,85 , 134,24 , 14667,63 , 14730,85 , 134,24 , 7100,35 , 7135,52 , 7187,14 , 7100,35 , 7135,52 , 7187,14 , 0,2 , 0,2 , {88,80,70},  222,4 , 8868,35 , 4,5 , 4,0 , 2612,8 , 3027,16 ,     0,     0,     1,     6,     7 }, // French/Latin/WallisAndFutuna
    {     95,    74,   115,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 927,27 , 18,5 , 8,10 , 14940,48 , 14988,77 , 15065,24 , 14940,48 , 14988,77 , 15065,24 , 7201,28 , 7229,50 , 7187,14 , 7201,28 , 7229,50 , 7187,14 , 223,2 , 233,2 , {69,85,82},  22,1 , 2617,20 , 13,5 , 4,0 , 3043,6 , 3049,6 ,     2,     1,     1,     6,     7 }, // Friulian/Latin/Italy
    {     96,    74,   195,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 15089,48 , 15137,77 , 15214,24 , 15089,48 , 15137,77 , 15214,24 , 7279,28 , 7307,59 , 7366,14 , 7279,28 , 7307,59 , 7366,14 , 225,6 , 235,7 , {88,79,70},  131,5 , 9564,26 , 4,5 , 4,0 , 3055,6 , 3061,8 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Senegal
    {     96,     1,    37,    46, 11841,  8271,    37,125264,    45,    43,125227,  8220,  8221,  8216,  8217, 409,6 , 409,6 , 415,9 , 424,8 , 279,8 , 954,17 , 18,5 , 8,10 , 15238,94 , 15332,130 , 15462,36 , 15332,130 , 15332,130 , 15462,36 , 7380,53 , 7433,119 , 7552,23 , 7380,53 , 7433,119 , 7552,23 , 231,4 , 242,4 , {88,79,70},  241,6 , 9590,164 , 13,5 , 4,0 , 3069,10 , 3079,25 ,     0,     0,     1,     6,     7 }, // Fulah/Adlam/BurkinaFaso
    {     96,     1,    40,    46, 11841,  8271,    37,125264,    45,    43,125227,  8220,  8221,  8216,  8217, 409,6 , 409,6 , 415,9 , 424,8 , 279,8 , 954,17 , 18,5 , 8,10 , 15238,94 , 15332,130 , 15462,36 , 15332,130 , 15332,130 , 15462,36 , 7380,53 , 7433,119 , 7552,23 , 7380,53 , 7433,119 , 7552,23 , 231,4 , 242,4 , {88,65,70},  247,8 , 9754,143 , 13,5 , 4,0 , 3069,10 , 3104,16 ,     0,     0,     1,     6,     7 }, // Fulah/Adlam/Cameroon
    {     96,     1,    87,    46, 11841,  8271,    37,125264,    45,    43,125227,  8220,  8221,  8216,  8217, 409,6 , 409,6 , 415,9 , 424,8 , 279,8 , 954,17 , 55,7 , 62,12 , 15238,94 , 15332,130 , 15462,36 , 15332,130 , 15332,130 , 15462,36 , 7380,53 , 7433,119 , 7552,23 , 7380,53 , 7433,119 , 7552,23 , 231,4 , 242,4 , {71,77,68},  191,1 , 9897,100 , 13,5 , 4,0 , 3069,10 , 3120,14 ,     2,     1,     1,     6,     7 }, // Fulah/Adlam/Gambia
    {     96,     1,    90,    46, 11841,  8271,    37,125264,    45,    43,125227,  8220,  8221,  8216,  8217, 409,6 , 409,6 , 415,9 , 424,8 , 279,8 , 954,17 , 55,7 , 62,12 , 15238,94 , 15332,130 , 15462,36 , 15332,130 , 15332,130 , 15462,36 , 7380,53 , 7433,119 , 7552,23 , 7380,53 , 7433,119 , 7552,23 , 231,4 , 242,4 , {71,72,83},  15,3 , 9997,82 , 13,5 , 4,0 , 3069,10 , 3134,8 ,     2,     1,     1,     6,     7 }, // Fulah/Adlam/Ghana
    {     96,     1,    99,    46, 11841,  8271,    37,125264,    45,    43,125227,  8220,  8221,  8216,  8217, 409,6 , 409,6 , 415,9 , 424,8 , 279,8 , 954,17 , 18,5 , 8,10 , 15238,94 , 15332,130 , 15462,36 , 15332,130 , 15332,130 , 15462,36 , 7380,53 , 7433,119 , 7552,23 , 7380,53 , 7433,119 , 7552,23 , 231,4 , 242,4 , {71,78,70},  226,2 , 10079,86 , 13,5 , 4,0 , 3069,10 , 3142,8 ,     0,     0,     1,     6,     7 }, // Fulah/Adlam/Guinea
    {     96,     1,   100,    46, 11841,  8271,    37,125264,    45,    43,125227,  8220,  8221,  8216,  8217, 409,6 , 409,6 , 415,9 , 424,8 , 279,8 , 954,17 , 18,5 , 8,10 , 15238,94 , 15332,130 , 15462,36 , 15332,130 , 15332,130 , 15462,36 , 7380,53 , 7433,119 , 7552,23 , 7380,53 , 7433,119 , 7552,23 , 231,4 , 242,4 , {88,79,70},  241,6 , 9590,164 , 13,5 , 4,0 , 3069,10 , 3150,23 ,     0,     0,     1,     6,     7 }, // Fulah/Adlam/GuineaBissau
    {     96,     1,   131,    46, 11841,  8271,    37,125264,    45,    43,125227,  8220,  8221,  8216,  8217, 409,6 , 409,6 , 415,9 , 424,8 , 279,8 , 954,17 , 55,7 , 62,12 , 15238,94 , 15332,130 , 15462,36 , 15332,130 , 15332,130 , 15462,36 , 7380,53 , 7433,119 , 7552,23 , 7380,53 , 7433,119 , 7552,23 , 231,4 , 242,4 , {76,82,68},  10,1 , 10165,106 , 13,5 , 4,0 , 3069,10 , 3173,18 ,     2,     1,     1,     6,     7 }, // Fulah/Adlam/Liberia
    {     96,     1,   145,    46, 11841,  8271,    37,125264,    45,    43,125227,  8220,  8221,  8216,  8217, 409,6 , 409,6 , 415,9 , 424,8 , 279,8 , 954,17 , 55,7 , 62,12 , 15238,94 , 15332,130 , 15462,36 , 15332,130 , 15332,130 , 15462,36 , 7380,53 , 7433,119 , 7552,23 , 7380,53 , 7433,119 , 7552,23 , 231,4 , 242,4 , {77,82,85},  229,2 , 10271,124 , 13,5 , 4,0 , 3069,10 , 3191,16 ,     2,     1,     1,     6,     7 }, // Fulah/Adlam/Mauritania
    {     96,     1,   165,    46, 11841,  8271,    37,125264,    45,    43,125227,  8220,  8221,  8216,  8217, 409,6 , 409,6 , 415,9 , 424,8 , 279,8 , 954,17 , 18,5 , 8,10 , 15238,94 , 15332,130 , 15462,36 , 15332,130 , 15332,130 , 15462,36 , 7380,53 , 7433,119 , 7552,23 , 7380,53 , 7433,119 , 7552,23 , 231,4 , 242,4 , {88,79,70},  241,6 , 9590,164 , 13,5 , 4,0 , 3069,10 , 3207,12 ,     0,     0,     1,     6,     7 }, // Fulah/Adlam/Niger
    {     96,     1,   166,    46, 11841,  8271,    37,125264,    45,    43,125227,  8220,  8221,  8216,  8217, 409,6 , 409,6 , 415,9 , 424,8 , 279,8 , 954,17 , 18,5 , 8,10 , 15238,94 , 15332,130 , 15462,36 , 15332,130 , 15332,130 , 15462,36 , 7380,53 , 7433,119 , 7552,23 , 7380,53 , 7433,119 , 7552,23 , 231,4 , 242,4 , {78,71,78},  126,1 , 10395,112 , 13,5 , 4,0 , 3069,10 , 3219,18 ,     2,     1,     1,     6,     7 }, // Fulah/Adlam/Nigeria
    {     96,     1,   195,    46, 11841,  8271,    37,125264,    45,    43,125227,  8220,  8221,  8216,  8217, 409,6 , 409,6 , 415,9 , 424,8 , 279,8 , 954,17 , 18,5 , 8,10 , 15238,94 , 15332,130 , 15462,36 , 15332,130 , 15332,130 , 15462,36 , 7380,53 , 7433,119 , 7552,23 , 7380,53 , 7433,119 , 7552,23 , 231,4 , 242,4 , {88,79,70},  241,6 , 9590,164 , 13,5 , 4,0 , 3069,10 , 3237,16 ,     0,     0,     1,     6,     7 }, // Fulah/Adlam/Senegal
    {     96,     1,   198,    46, 11841,  8271,    37,125264,    45,    43,125227,  8220,  8221,  8216,  8217, 409,6 , 409,6 , 415,9 , 424,8 , 279,8 , 954,17 , 55,7 , 62,12 , 15238,94 , 15332,130 , 15462,36 , 15332,130 , 15332,130 , 15462,36 , 7380,53 , 7433,119 , 7552,23 , 7380,53 , 7433,119 , 7552,23 , 231,4 , 242,4 , {83,76,69},  207,2 , 0,7 , 13,5 , 4,0 , 3069,10 , 3253,14 ,     2,     0,     1,     6,     7 }, // Fulah/Adlam/SierraLeone
    {     96,    74,    37,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 15089,48 , 15137,77 , 15214,24 , 15089,48 , 15137,77 , 15214,24 , 7279,28 , 7307,59 , 7366,14 , 7279,28 , 7307,59 , 7366,14 , 225,6 , 235,7 , {88,79,70},  131,5 , 9564,26 , 4,5 , 4,0 , 3055,6 , 3267,14 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/BurkinaFaso
    {     96,    74,    40,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 15089,48 , 15137,77 , 15214,24 , 15089,48 , 15137,77 , 15214,24 , 7279,28 , 7307,59 , 7366,14 , 7279,28 , 7307,59 , 7366,14 , 225,6 , 235,7 , {88,65,70},  11,4 , 10507,25 , 4,5 , 4,0 , 3055,6 , 3281,8 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Cameroon
    {     96,    74,    87,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 23,7 , 30,12 , 15089,48 , 15137,77 , 15214,24 , 15089,48 , 15137,77 , 15214,24 , 7279,28 , 7307,59 , 7366,14 , 7279,28 , 7307,59 , 7366,14 , 225,6 , 235,7 , {71,77,68},  191,1 , 10532,20 , 4,5 , 4,0 , 3055,6 , 3289,6 ,     2,     1,     1,     6,     7 }, // Fulah/Latin/Gambia
    {     96,    74,    90,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 23,7 , 30,12 , 15089,48 , 15137,77 , 15214,24 , 15089,48 , 15137,77 , 15214,24 , 7279,28 , 7307,59 , 7366,14 , 7279,28 , 7307,59 , 7366,14 , 225,6 , 235,7 , {71,72,83},  15,3 , 0,7 , 4,5 , 4,0 , 3055,6 , 3295,5 ,     2,     1,     1,     6,     7 }, // Fulah/Latin/Ghana
    {     96,    74,    99,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 15089,48 , 15137,77 , 15214,24 , 15089,48 , 15137,77 , 15214,24 , 7279,28 , 7307,59 , 7366,14 , 7279,28 , 7307,59 , 7366,14 , 225,6 , 235,7 , {71,78,70},  226,2 , 0,7 , 4,5 , 4,0 , 3055,6 , 3300,4 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Guinea
    {     96,    74,   100,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 15089,48 , 15137,77 , 15214,24 , 15089,48 , 15137,77 , 15214,24 , 7279,28 , 7307,59 , 7366,14 , 7279,28 , 7307,59 , 7366,14 , 225,6 , 235,7 , {88,79,70},  131,5 , 9564,26 , 4,5 , 4,0 , 3055,6 , 3304,12 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/GuineaBissau
    {     96,    74,   131,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 23,7 , 30,12 , 15089,48 , 15137,77 , 15214,24 , 15089,48 , 15137,77 , 15214,24 , 7279,28 , 7307,59 , 7366,14 , 7279,28 , 7307,59 , 7366,14 , 225,6 , 235,7 , {76,82,68},  10,1 , 10552,23 , 4,5 , 4,0 , 3055,6 , 3316,9 ,     2,     1,     1,     6,     7 }, // Fulah/Latin/Liberia
    {     96,    74,   145,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 23,7 , 30,12 , 15089,48 , 15137,77 , 15214,24 , 15089,48 , 15137,77 , 15214,24 , 7279,28 , 7307,59 , 7366,14 , 7279,28 , 7307,59 , 7366,14 , 225,6 , 235,7 , {77,82,85},  229,2 , 10575,22 , 4,5 , 4,0 , 3055,6 , 3325,8 ,     2,     1,     1,     6,     7 }, // Fulah/Latin/Mauritania
    {     96,    74,   165,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 15089,48 , 15137,77 , 15214,24 , 15089,48 , 15137,77 , 15214,24 , 7279,28 , 7307,59 , 7366,14 , 7279,28 , 7307,59 , 7366,14 , 225,6 , 235,7 , {88,79,70},  131,5 , 9564,26 , 4,5 , 4,0 , 3055,6 , 3333,6 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Niger
    {     96,    74,   166,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 15089,48 , 15137,77 , 15214,24 , 15089,48 , 15137,77 , 15214,24 , 7279,28 , 7307,59 , 7366,14 , 7279,28 , 7307,59 , 7366,14 , 225,6 , 235,7 , {78,71,78},  126,1 , 10597,23 , 4,5 , 4,0 , 3055,6 , 3339,9 ,     2,     1,     1,     6,     7 }, // Fulah/Latin/Nigeria
    {     96,    74,   198,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 23,7 , 30,12 , 15089,48 , 15137,77 , 15214,24 , 15089,48 , 15137,77 , 15214,24 , 7279,28 , 7307,59 , 7366,14 , 7279,28 , 7307,59 , 7366,14 , 225,6 , 235,7 , {83,76,69},  207,2 , 0,7 , 4,5 , 4,0 , 3055,6 , 3348,11 ,     2,     0,     1,     6,     7 }, // Fulah/Latin/SierraLeone
    {     97,    74,    90,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 432,9 , 441,8 , 547,6 , 553,18 , 23,7 , 30,12 , 15498,48 , 15546,92 , 15638,24 , 15498,48 , 15662,92 , 15638,24 , 7575,27 , 7602,33 , 7635,14 , 7575,27 , 7602,33 , 7635,14 , 0,2 , 0,2 , {71,72,83},  15,3 , 10620,28 , 9,4 , 59,6 , 3359,2 , 1764,5 ,     2,     1,     1,     6,     7 }, // Ga/Latin/Ghana
    {     98,    74,   242,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 449,10 , 449,10 , 186,10 , 971,21 , 18,5 , 8,10 , 15754,61 , 15815,142 , 15957,24 , 15754,61 , 15981,167 , 15957,24 , 7649,28 , 7677,69 , 7746,14 , 7649,28 , 7677,69 , 7746,14 , 235,1 , 246,1 , {71,66,80},  96,1 , 10648,86 , 9,4 , 4,0 , 3361,8 , 3369,22 ,     2,     1,     1,     6,     7 }, // Gaelic/Latin/UnitedKingdom
    {     99,    74,   209,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 992,27 , 18,5 , 8,10 , 16148,60 , 16208,87 , 16295,24 , 16319,60 , 16379,87 , 16466,36 , 7760,35 , 7795,49 , 1251,14 , 7844,35 , 7879,49 , 7928,21 , 168,4 , 168,4 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 3391,6 , 455,6 ,     2,     1,     1,     6,     7 }, // Galician/Latin/Spain
    {    100,    74,   239,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 16502,48 , 16550,97 , 134,24 , 16502,48 , 16550,97 , 134,24 , 7949,28 , 7977,66 , 8043,14 , 7949,28 , 7977,66 , 8043,14 , 0,2 , 0,2 , {85,71,88},  151,3 , 10734,26 , 0,4 , 4,0 , 3397,7 , 3404,7 ,     0,     0,     1,     7,     7 }, // Ganda/Latin/Uganda
    {    101,    38,    77,    46,  4808,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 1019,23 , 55,7 , 62,12 , 16647,49 , 16647,49 , 16696,24 , 16647,49 , 16647,49 , 16696,24 , 8057,29 , 8057,29 , 8086,14 , 8057,29 , 8057,29 , 8086,14 , 0,2 , 0,2 , {69,84,66},  0,0 , 10760,16 , 9,4 , 4,0 , 3411,4 , 143,5 ,     2,     1,     7,     6,     7 }, // Geez/Ethiopic/Ethiopia
    {    101,    38,    74,    46,  4808,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 1019,23 , 55,7 , 62,12 , 16647,49 , 16647,49 , 16696,24 , 16647,49 , 16647,49 , 16696,24 , 8057,29 , 8057,29 , 8086,14 , 8057,29 , 8057,29 , 8086,14 , 0,2 , 0,2 , {69,82,78},  6,3 , 0,7 , 9,4 , 4,0 , 3411,4 , 698,4 ,     2,     1,     1,     6,     7 }, // Geez/Ethiopic/Eritrea
    {    102,    40,    88,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8220,   171,   187, 0,6 , 0,6 , 459,8 , 459,8 , 251,8 , 1042,19 , 18,5 , 8,10 , 16720,48 , 16768,99 , 16867,24 , 16720,48 , 16768,99 , 16867,24 , 8100,28 , 8128,62 , 8190,14 , 8100,28 , 8128,62 , 8190,14 , 0,2 , 0,2 , {71,69,76},  255,1 , 10776,43 , 4,5 , 4,0 , 3415,7 , 3422,10 ,     2,     1,     1,     6,     7 }, // Georgian/Georgian/Georgia
    {    103,    74,    89,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 467,9 , 467,9 , 251,8 , 878,18 , 18,5 , 8,10 , 16891,48 , 16939,83 , 134,24 , 17022,60 , 16939,83 , 134,24 , 8204,21 , 8225,60 , 4858,14 , 8285,28 , 8225,60 , 4858,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 10819,19 , 4,5 , 4,0 , 3432,7 , 3439,11 ,     2,     1,     1,     6,     7 }, // German/Latin/Germany
    {    103,    74,    16,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 467,9 , 467,9 , 251,8 , 878,18 , 18,5 , 8,10 , 17082,48 , 17130,83 , 134,24 , 17213,59 , 17130,83 , 134,24 , 8204,21 , 8225,60 , 4858,14 , 8285,28 , 8225,60 , 4858,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 10819,19 , 13,5 , 4,0 , 3450,24 , 3474,10 ,     2,     1,     1,     6,     7 }, // German/Latin/Austria
    {    103,    74,    23,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 467,9 , 467,9 , 251,8 , 878,18 , 18,5 , 8,10 , 16891,48 , 16939,83 , 134,24 , 17022,60 , 16939,83 , 134,24 , 8204,21 , 8225,60 , 4858,14 , 8285,28 , 8225,60 , 4858,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 10819,19 , 4,5 , 4,0 , 3432,7 , 3484,7 ,     2,     1,     1,     6,     7 }, // German/Latin/Belgium
    {    103,    74,   115,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 467,9 , 467,9 , 251,8 , 878,18 , 18,5 , 8,10 , 17082,48 , 17130,83 , 134,24 , 17213,59 , 17130,83 , 134,24 , 8204,21 , 8225,60 , 4858,14 , 8285,28 , 8225,60 , 4858,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 10819,19 , 4,5 , 4,0 , 3432,7 , 3491,7 ,     2,     1,     1,     6,     7 }, // German/Latin/Italy
    {    103,    74,   133,    46,  8217,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 467,9 , 467,9 , 251,8 , 878,18 , 18,5 , 8,10 , 16891,48 , 16939,83 , 134,24 , 17022,60 , 16939,83 , 134,24 , 8204,21 , 8225,60 , 4858,14 , 8285,28 , 8225,60 , 4858,14 , 0,2 , 0,2 , {67,72,70},  234,3 , 10838,58 , 13,5 , 4,0 , 3432,7 , 3498,13 ,     2,     0,     1,     6,     7 }, // German/Latin/Liechtenstein
    {    103,    74,   135,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 467,9 , 467,9 , 251,8 , 878,18 , 18,5 , 8,10 , 16891,48 , 16939,83 , 134,24 , 17022,60 , 16939,83 , 134,24 , 8204,21 , 8225,60 , 4858,14 , 8285,28 , 8225,60 , 4858,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 10819,19 , 4,5 , 4,0 , 3432,7 , 3511,9 ,     2,     1,     1,     6,     7 }, // German/Latin/Luxembourg
    {    103,    74,   222,    46,  8217,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 467,9 , 467,9 , 251,8 , 878,18 , 18,5 , 8,10 , 16891,48 , 16939,83 , 134,24 , 17022,60 , 16939,83 , 134,24 , 8204,21 , 8225,60 , 4858,14 , 8285,28 , 8225,60 , 4858,14 , 0,2 , 0,2 , {67,72,70},  234,3 , 10838,58 , 13,5 , 48,5 , 3520,21 , 3541,7 ,     2,     0,     1,     6,     7 }, // German/Latin/Switzerland
    {    105,    44,    92,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 476,9 , 476,9 , 223,6 , 113,16 , 23,7 , 30,12 , 17272,50 , 17322,115 , 17437,24 , 17461,50 , 17511,115 , 17437,24 , 8313,28 , 8341,55 , 8396,14 , 8313,28 , 8341,55 , 8396,14 , 236,4 , 247,4 , {69,85,82},  22,1 , 10896,19 , 4,5 , 4,0 , 3548,8 , 3556,6 ,     2,     1,     1,     6,     7 }, // Greek/Greek/Greece
    {    105,    44,    63,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 476,9 , 476,9 , 223,6 , 113,16 , 23,7 , 30,12 , 17272,50 , 17322,115 , 17437,24 , 17461,50 , 17511,115 , 17437,24 , 8313,28 , 8341,55 , 8396,14 , 8313,28 , 8341,55 , 8396,14 , 236,4 , 247,4 , {69,85,82},  22,1 , 10896,19 , 4,5 , 4,0 , 3548,8 , 3562,6 ,     2,     1,     1,     6,     7 }, // Greek/Greek/Cyprus
    {    106,    74,   179,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 17626,110 , 17626,110 , 158,27 , 17626,110 , 17626,110 , 158,27 , 8410,54 , 8410,54 , 85,14 , 8410,54 , 8410,54 , 85,14 , 0,2 , 0,2 , {80,89,71},  256,1 , 0,7 , 13,5 , 4,0 , 3568,7 , 3575,8 ,     0,     0,     7,     6,     7 }, // Guarani/Latin/Paraguay
    {    107,    45,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 485,9 , 485,9 , 223,6 , 287,18 , 106,8 , 114,13 , 17736,67 , 17803,87 , 17890,31 , 17736,67 , 17803,87 , 17890,31 , 8464,32 , 8496,53 , 8549,19 , 8464,32 , 8496,53 , 8549,19 , 0,2 , 0,2 , {73,78,82},  122,1 , 10915,46 , 9,4 , 4,0 , 3583,7 , 3590,4 ,     2,     1,     7,     7,     7 }, // Gujarati/Gujarati/India
    {    108,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 17921,48 , 17969,88 , 18057,24 , 17921,48 , 17969,88 , 18057,24 , 8568,28 , 8596,62 , 8658,14 , 8568,28 , 8596,62 , 8658,14 , 240,6 , 251,3 , {75,69,83},  180,3 , 4749,24 , 9,4 , 4,0 , 3594,8 , 1343,5 ,     2,     1,     7,     6,     7 }, // Gusii/Latin/Kenya
    {    111,    31,   108,    46,    44,    59,    37,  2406,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 55,7 , 62,12 , 18081,74 , 18081,74 , 158,27 , 18081,74 , 18081,74 , 158,27 , 8672,55 , 8672,55 , 85,14 , 8672,55 , 8672,55 , 85,14 , 246,4 , 83,4 , {73,78,82},  122,1 , 0,7 , 13,5 , 4,0 , 3602,8 , 691,4 ,     2,     1,     7,     7,     7 }, // Haryanvi/Devanagari/India
    {    112,    74,   166,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 494,9 , 503,8 , 223,6 , 1061,17 , 18,5 , 8,10 , 18155,48 , 18203,85 , 18288,24 , 18155,48 , 18203,85 , 18288,24 , 8727,28 , 8755,52 , 8807,14 , 8727,28 , 8755,52 , 8807,14 , 250,6 , 254,5 , {78,71,78},  126,1 , 10961,52 , 13,5 , 4,0 , 3610,5 , 3615,8 ,     2,     1,     1,     6,     7 }, // Hausa/Latin/Nigeria
    {    112,     4,   166,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 18312,55 , 18367,99 , 158,27 , 18312,55 , 18367,99 , 158,27 , 8821,31 , 8852,57 , 85,14 , 8821,31 , 8852,57 , 85,14 , 0,2 , 0,2 , {78,71,78},  126,1 , 11013,13 , 13,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Hausa/Arabic/Nigeria
    {    112,     4,   218,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 18312,55 , 18367,99 , 158,27 , 18312,55 , 18367,99 , 158,27 , 8821,31 , 8852,57 , 85,14 , 8821,31 , 8852,57 , 85,14 , 0,2 , 0,2 , {83,68,71},  0,0 , 0,7 , 13,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     6,     5,     6 }, // Hausa/Arabic/Sudan
    {    112,    74,    90,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 494,9 , 503,8 , 223,6 , 1061,17 , 23,7 , 30,12 , 18155,48 , 18203,85 , 18288,24 , 18155,48 , 18203,85 , 18288,24 , 8727,28 , 8755,52 , 8807,14 , 8727,28 , 8755,52 , 8807,14 , 250,6 , 254,5 , {71,72,83},  15,3 , 11026,46 , 13,5 , 4,0 , 3610,5 , 3623,4 ,     2,     1,     1,     6,     7 }, // Hausa/Latin/Ghana
    {    112,    74,   165,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 494,9 , 503,8 , 223,6 , 1061,17 , 18,5 , 8,10 , 18155,48 , 18203,85 , 18288,24 , 18155,48 , 18203,85 , 18288,24 , 8727,28 , 8755,52 , 8807,14 , 8727,28 , 8755,52 , 8807,14 , 250,6 , 254,5 , {88,79,70},  131,5 , 11072,94 , 13,5 , 4,0 , 3610,5 , 3627,5 ,     0,     0,     1,     6,     7 }, // Hausa/Latin/Niger
    {    113,    74,   243,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 223,6 , 10,17 , 23,7 , 30,12 , 18466,59 , 18525,95 , 158,27 , 18466,59 , 18525,95 , 158,27 , 8909,21 , 8930,57 , 85,14 , 8909,21 , 8930,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  10,1 , 0,7 , 9,4 , 4,0 , 3632,14 , 3646,19 ,     2,     1,     7,     6,     7 }, // Hawaiian/Latin/UnitedStates
    {    114,    53,   114,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 511,6 , 511,6 , 919,8 , 1078,18 , 74,4 , 78,9 , 18620,58 , 18678,72 , 158,27 , 18620,58 , 18678,72 , 158,27 , 8987,46 , 9033,65 , 9098,21 , 8987,46 , 9033,65 , 9098,21 , 256,6 , 259,5 , {73,76,83},  50,1 , 11166,54 , 65,7 , 72,9 , 3665,5 , 3670,5 ,     2,     1,     7,     5,     6 }, // Hebrew/Hebrew/Israel
    {    116,    31,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 517,9 , 526,8 , 223,6 , 10,17 , 55,7 , 62,12 , 18750,59 , 18809,73 , 18882,30 , 18750,59 , 18809,73 , 18882,30 , 9119,32 , 9151,53 , 9204,19 , 9119,32 , 9151,53 , 9204,19 , 196,2 , 203,2 , {73,78,82},  122,1 , 11220,42 , 9,4 , 4,0 , 3675,6 , 691,4 ,     2,     1,     7,     7,     7 }, // Hindi/Devanagari/India
    {    116,    74,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 534,10 , 544,9 , 186,10 , 287,18 , 23,7 , 30,12 , 12766,49 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 9223,39 , 9262,67 , 9329,22 , 9223,39 , 9262,67 , 9329,22 , 0,2 , 0,2 , {73,78,82},  122,1 , 6104,44 , 9,4 , 4,0 , 3681,13 , 1822,5 ,     2,     1,     7,     7,     7 }, // Hindi/Latin/India
    {    118,   105,   243,    46,    44,    59,    37,123200,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 18912,142 , 18912,142 , 158,27 , 18912,142 , 18912,142 , 158,27 , 0,28 , 9351,55 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {85,83,68},  257,2 , 0,7 , 13,5 , 4,0 , 3694,14 , 3708,12 ,     2,     1,     7,     6,     7 }, // Hmong Njua/Nyiakeng Puachue Hmong/UnitedStates
    {    120,    74,   106,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,   187,   171, 0,6 , 0,6 , 553,8 , 553,8 , 1096,13 , 1109,19 , 74,4 , 78,9 , 19054,64 , 19118,98 , 19216,25 , 19054,64 , 19118,98 , 19216,25 , 9406,19 , 9425,52 , 9477,17 , 9406,19 , 9425,52 , 9477,17 , 262,3 , 264,3 , {72,85,70},  259,2 , 11262,46 , 4,5 , 4,0 , 3720,6 , 3726,12 ,     2,     0,     1,     6,     7 }, // Hungarian/Latin/Hungary
    {    121,    74,   107,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 286,8 , 286,8 , 919,8 , 878,18 , 18,5 , 8,10 , 19241,59 , 19300,82 , 19382,24 , 19241,59 , 19300,82 , 19382,24 , 9494,35 , 9529,81 , 9610,14 , 9494,35 , 9529,81 , 9610,14 , 265,4 , 267,4 , {73,83,75},  164,3 , 11308,49 , 4,5 , 4,0 , 3738,8 , 3746,6 ,     0,     0,     1,     6,     7 }, // Icelandic/Latin/Iceland
    {    122,    74,   254,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {0,0,0},  0,0 , 2547,0 , 13,5 , 4,0 , 3752,3 , 0,0 ,     2,     1,     1,     6,     7 }, // Ido/Latin/World
    {    123,    74,   166,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 561,9 , 570,8 , 223,6 , 10,17 , 18,5 , 8,10 , 19406,48 , 19454,87 , 19541,24 , 19406,48 , 19454,87 , 19541,24 , 9624,29 , 9653,54 , 85,14 , 9624,29 , 9653,54 , 85,14 , 269,7 , 271,7 , {78,71,78},  126,1 , 11357,17 , 9,4 , 4,0 , 3755,4 , 3759,8 ,     2,     1,     1,     6,     7 }, // Igbo/Latin/Nigeria
    {    124,    74,    81,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 919,8 , 1128,18 , 358,4 , 362,9 , 19565,77 , 19642,140 , 19782,25 , 19565,77 , 19642,140 , 19782,25 , 9707,28 , 9735,70 , 85,14 , 9707,28 , 9805,73 , 9878,14 , 276,3 , 278,3 , {69,85,82},  22,1 , 4178,11 , 4,5 , 4,0 , 3767,11 , 3778,5 ,     2,     1,     1,     6,     7 }, // Inari Sami/Latin/Finland
    {    125,    74,   109,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 578,10 , 588,9 , 59,8 , 809,18 , 294,5 , 299,10 , 19807,48 , 19855,87 , 134,24 , 19807,48 , 19855,87 , 134,24 , 9892,28 , 9920,43 , 9963,14 , 9892,28 , 9920,43 , 9963,14 , 0,2 , 0,2 , {73,68,82},  261,2 , 11374,39 , 9,4 , 4,0 , 3783,9 , 3783,9 ,     2,     0,     7,     6,     7 }, // Indonesian/Latin/Indonesia
    {    127,    74,   254,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 415,10 , 1146,26 , 18,5 , 8,10 , 19942,48 , 19990,93 , 158,27 , 19942,48 , 19990,93 , 6694,24 , 9977,28 , 10005,57 , 10062,14 , 9977,28 , 10005,57 , 10062,14 , 0,2 , 0,2 , {0,0,0},  0,0 , 2547,0 , 13,5 , 4,0 , 3792,11 , 3803,5 ,     2,     1,     1,     6,     7 }, // Interlingua/Latin/World
    {    129,    18,    41,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 1172,10 , 553,18 , 55,7 , 62,12 , 20083,59 , 20083,59 , 158,27 , 20083,59 , 20083,59 , 158,27 , 10076,55 , 10076,55 , 85,14 , 10076,55 , 10076,55 , 85,14 , 0,2 , 0,2 , {67,65,68},  263,3 , 0,7 , 13,5 , 4,0 , 3808,6 , 3814,4 ,     2,     0,     7,     6,     7 }, // Inuktitut/Canadian Aboriginal/Canada
    {    129,    74,    41,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {67,65,68},  263,3 , 0,7 , 13,5 , 4,0 , 0,0 , 0,0 ,     2,     0,     7,     6,     7 }, // Inuktitut/Latin/Canada
    {    131,    74,   112,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 449,10 , 449,10 , 186,10 , 113,16 , 18,5 , 8,10 , 20142,62 , 20204,107 , 20311,24 , 20142,62 , 20204,107 , 20311,24 , 10131,37 , 10168,75 , 10243,14 , 10131,37 , 10168,75 , 10243,14 , 279,4 , 281,4 , {69,85,82},  22,1 , 11413,31 , 9,4 , 4,0 , 3818,7 , 3825,4 ,     2,     1,     1,     6,     7 }, // Irish/Latin/Ireland
    {    131,    74,   242,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 449,10 , 449,10 , 186,10 , 113,16 , 18,5 , 8,10 , 20142,62 , 20204,107 , 20311,24 , 20142,62 , 20204,107 , 20311,24 , 10131,37 , 10168,75 , 10243,14 , 10131,37 , 10168,75 , 10243,14 , 279,4 , 281,4 , {71,66,80},  96,1 , 11444,95 , 9,4 , 4,0 , 3818,7 , 3829,19 ,     2,     1,     1,     6,     7 }, // Irish/Latin/UnitedKingdom
    {    132,    74,   115,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 113,16 , 18,5 , 8,10 , 20335,48 , 20383,94 , 10486,24 , 20335,48 , 20383,94 , 10486,24 , 10257,28 , 10285,57 , 5047,14 , 10257,28 , 10285,57 , 5047,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 11539,19 , 4,5 , 4,0 , 3848,8 , 3856,6 ,     2,     1,     1,     6,     7 }, // Italian/Latin/Italy
    {    132,    74,   192,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 113,16 , 18,5 , 8,10 , 20335,48 , 20383,94 , 10486,24 , 20335,48 , 20383,94 , 10486,24 , 10257,28 , 10285,57 , 5047,14 , 10257,28 , 10285,57 , 5047,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 11539,19 , 4,5 , 4,0 , 3848,8 , 3862,10 ,     2,     1,     1,     6,     7 }, // Italian/Latin/SanMarino
    {    132,    74,   222,    46,  8217,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 402,7 , 402,7 , 251,8 , 10,17 , 18,5 , 8,10 , 20335,48 , 20383,94 , 10486,24 , 20335,48 , 20383,94 , 10486,24 , 10257,28 , 10285,57 , 5047,14 , 10257,28 , 10285,57 , 5047,14 , 0,2 , 0,2 , {67,72,70},  0,0 , 11558,53 , 13,5 , 48,5 , 3848,8 , 3872,8 ,     2,     0,     1,     6,     7 }, // Italian/Latin/Switzerland
    {    132,    74,   249,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 113,16 , 18,5 , 8,10 , 20335,48 , 20383,94 , 10486,24 , 20335,48 , 20383,94 , 10486,24 , 10257,28 , 10285,57 , 5047,14 , 10257,28 , 10285,57 , 5047,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 11539,19 , 4,5 , 4,0 , 3848,8 , 3880,18 ,     2,     1,     1,     6,     7 }, // Italian/Latin/VaticanCity
    {    133,    59,   118,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 180,5 , 180,5 , 180,5 , 180,5 , 834,10 , 534,13 , 74,4 , 495,10 , 7360,39 , 7360,39 , 158,27 , 7360,39 , 7360,39 , 158,27 , 10342,14 , 10356,28 , 10342,14 , 10342,14 , 10356,28 , 10342,14 , 283,2 , 285,2 , {74,80,89},  149,1 , 11611,11 , 9,4 , 4,0 , 3898,3 , 3901,2 ,     0,     0,     7,     6,     7 }, // Japanese/Japanese/Japan
    {    134,    74,   109,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 597,10 , 607,9 , 415,10 , 10,17 , 18,5 , 8,10 , 20477,48 , 19855,87 , 134,24 , 20477,48 , 19855,87 , 134,24 , 10384,29 , 10413,41 , 10454,14 , 10384,29 , 10413,41 , 10454,14 , 285,4 , 287,5 , {73,68,82},  261,2 , 11374,39 , 13,5 , 4,0 , 3903,4 , 3907,9 ,     2,     0,     7,     6,     7 }, // Javanese/Latin/Indonesia
    {    135,    74,   166,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 137,8 , 145,18 , 18,5 , 8,10 , 20525,57 , 20582,178 , 158,27 , 20525,57 , 20582,178 , 158,27 , 10468,28 , 10496,44 , 85,14 , 10468,28 , 10496,44 , 85,14 , 0,2 , 0,2 , {78,71,78},  126,1 , 11622,14 , 13,5 , 4,0 , 3916,4 , 0,0 ,     2,     1,     1,     6,     7 }, // Jju/Latin/Nigeria
    {    136,    74,   195,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 20760,36 , 20796,82 , 20878,24 , 20760,36 , 20796,82 , 20878,24 , 10540,28 , 10568,50 , 10618,14 , 10540,28 , 10568,50 , 10618,14 , 0,2 , 0,2 , {88,79,70},  131,5 , 11636,23 , 4,5 , 4,0 , 3920,5 , 3925,7 ,     0,     0,     1,     6,     7 }, // JolaFonyi/Latin/Senegal
    {    137,    74,    43,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 141,7 , 141,7 , 186,10 , 1182,27 , 18,5 , 8,10 , 20902,48 , 20950,85 , 134,24 , 20902,48 , 20950,85 , 134,24 , 10632,28 , 10660,73 , 10733,14 , 10632,28 , 10660,73 , 10733,14 , 196,2 , 203,2 , {67,86,69},  266,1 , 11659,43 , 4,5 , 4,0 , 3932,12 , 3944,10 ,     2,     1,     1,     6,     7 }, // Kabuverdianu/Latin/CapeVerde
    {    138,    74,     4,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 616,8 , 624,7 , 129,8 , 113,16 , 23,7 , 30,12 , 21035,48 , 21083,84 , 21167,24 , 21035,48 , 21083,84 , 21167,24 , 10747,28 , 10775,34 , 10809,14 , 10823,30 , 10853,51 , 10904,14 , 289,7 , 292,9 , {68,90,68},  218,2 , 11702,57 , 0,4 , 4,0 , 3954,9 , 3963,8 ,     2,     1,     6,     5,     6 }, // Kabyle/Latin/Algeria
    {    139,    74,    32,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 631,9 , 631,9 , 186,10 , 1209,23 , 18,5 , 8,10 , 21191,63 , 21254,87 , 21341,39 , 21191,63 , 21254,87 , 21341,39 , 10918,35 , 10953,87 , 11040,21 , 10918,35 , 10953,87 , 11040,21 , 0,2 , 0,2 , {66,82,76},  267,2 , 11759,46 , 13,5 , 4,0 , 3971,7 , 3978,6 ,     2,     1,     7,     6,     7 }, // Kaingang/Latin/Brazil
    {    140,    74,    40,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 0,6 , 0,6 , 1232,10 , 96,17 , 18,5 , 8,10 , 21380,103 , 21380,103 , 158,27 , 21380,103 , 21380,103 , 158,27 , 11061,54 , 11061,54 , 11115,21 , 11061,54 , 11061,54 , 11115,21 , 0,2 , 0,2 , {88,65,70},  11,4 , 11805,16 , 24,6 , 4,0 , 3984,4 , 3988,7 ,     0,     0,     1,     6,     7 }, // Kako/Latin/Cameroon
    {    141,    74,    93,    44,    46,    59,    37,    48,  8722,    43,   101,   187,   171,  8250,  8249, 0,6 , 0,6 , 640,11 , 640,11 , 86,10 , 96,17 , 294,5 , 299,10 , 21483,50 , 21533,99 , 134,24 , 21483,50 , 21632,111 , 134,24 , 11136,28 , 11164,98 , 11262,14 , 11136,28 , 11164,98 , 11262,14 , 0,2 , 0,2 , {68,75,75},  164,3 , 11821,62 , 9,4 , 81,5 , 3995,11 , 4006,16 ,     2,     0,     1,     6,     7 }, // Kalaallisut/Latin/Greenland
    {    142,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 21743,49 , 21792,121 , 21913,24 , 21743,49 , 21792,121 , 21913,24 , 11276,28 , 11304,53 , 11357,14 , 11276,28 , 11304,53 , 11357,14 , 296,6 , 301,10 , {75,69,83},  180,3 , 11883,26 , 9,4 , 4,0 , 4022,8 , 4030,12 ,     2,     1,     7,     6,     7 }, // Kalenjin/Latin/Kenya
    {    143,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 21937,48 , 21985,189 , 22174,24 , 21937,48 , 21985,189 , 22174,24 , 11371,28 , 11399,74 , 11473,14 , 11371,28 , 11399,74 , 11473,14 , 302,9 , 311,7 , {75,69,83},  180,3 , 11909,23 , 9,4 , 4,0 , 4042,7 , 1343,5 ,     2,     1,     7,     6,     7 }, // Kamba/Latin/Kenya
    {    144,    62,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 651,12 , 663,11 , 223,6 , 553,18 , 106,8 , 114,13 , 22198,63 , 22261,87 , 22348,31 , 22379,73 , 22261,87 , 22348,31 , 11487,33 , 11520,54 , 11574,20 , 11487,33 , 11520,54 , 11574,20 , 311,9 , 318,7 , {73,78,82},  122,1 , 11932,49 , 9,4 , 4,0 , 4049,5 , 4054,4 ,     2,     1,     7,     7,     7 }, // Kannada/Kannada/India
    {    146,     4,   108,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 674,6 , 674,6 , 680,10 , 690,9 , 547,6 , 553,18 , 55,7 , 62,12 , 22452,72 , 22452,72 , 22524,24 , 22452,72 , 22452,72 , 22524,24 , 11594,50 , 11644,52 , 11696,14 , 11594,50 , 11644,52 , 11696,14 , 320,6 , 325,6 , {73,78,82},  122,1 , 11981,55 , 9,4 , 4,0 , 4058,5 , 4063,9 ,     2,     1,     7,     7,     7 }, // Kashmiri/Arabic/India
    {    146,    31,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 699,9 , 708,8 , 223,6 , 10,17 , 505,7 , 181,12 , 22548,75 , 22548,75 , 22623,25 , 22548,75 , 22548,75 , 22623,25 , 11710,50 , 11710,50 , 11760,14 , 11710,50 , 11710,50 , 11760,14 , 326,5 , 331,5 , {73,78,82},  122,1 , 12036,42 , 9,4 , 4,0 , 4072,5 , 4077,10 ,     2,     1,     7,     7,     7 }, // Kashmiri/Devanagari/India
    {    147,    29,   121,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 716,10 , 251,8 , 1242,22 , 18,5 , 8,10 , 22648,60 , 22708,83 , 22791,24 , 22648,60 , 22815,83 , 22791,24 , 11774,21 , 11795,56 , 11851,14 , 11774,21 , 11795,56 , 11851,14 , 0,2 , 0,2 , {75,90,84},  269,1 , 12078,58 , 4,5 , 4,0 , 4087,10 , 4097,9 ,     2,     1,     1,     6,     7 }, // Kazakh/Cyrillic/Kazakhstan
    {    148,    74,    40,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {88,65,70},  11,4 , 0,7 , 13,5 , 4,0 , 4106,6 , 0,0 ,     0,     0,     1,     6,     7 }, // Kenyang/Latin/Cameroon
    {    149,    68,    39,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 726,9 , 735,9 , 223,6 , 113,16 , 55,7 , 62,12 , 22898,71 , 22898,71 , 22969,24 , 22898,71 , 22898,71 , 22969,24 , 11865,40 , 11905,46 , 11951,14 , 11865,40 , 11965,47 , 11951,14 , 0,2 , 0,2 , {75,72,82},  270,1 , 12136,29 , 0,4 , 4,0 , 4112,5 , 4117,7 ,     2,     1,     7,     6,     7 }, // Khmer/Khmer/Cambodia
    {    150,    74,    97,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {71,84,81},  271,1 , 0,7 , 13,5 , 4,0 , 4124,7 , 0,0 ,     2,     1,     7,     6,     7 }, // Kiche/Latin/Guatemala
    {    151,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 22993,48 , 23041,185 , 23226,24 , 22993,48 , 23041,185 , 23226,24 , 12012,28 , 12040,63 , 12103,14 , 12012,28 , 12040,63 , 12103,14 , 331,6 , 336,8 , {75,69,83},  180,3 , 12165,23 , 9,4 , 4,0 , 4131,6 , 1343,5 ,     2,     1,     7,     6,     7 }, // Kikuyu/Latin/Kenya
    {    152,    74,   190,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 23250,60 , 23310,100 , 158,27 , 23250,60 , 23310,100 , 158,27 , 12117,35 , 12152,84 , 85,14 , 12117,35 , 12152,84 , 85,14 , 0,2 , 0,2 , {82,87,70},  200,2 , 0,7 , 13,5 , 4,0 , 4137,11 , 4148,8 ,     0,     0,     1,     6,     7 }, // Kinyarwanda/Latin/Rwanda
    {    155,    31,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 746,6 , 113,16 , 55,7 , 62,12 , 23410,59 , 23469,86 , 158,27 , 23469,86 , 23469,86 , 158,27 , 12236,51 , 12236,51 , 12287,19 , 12236,51 , 12236,51 , 12306,20 , 337,4 , 344,4 , {73,78,82},  122,1 , 12188,31 , 9,4 , 4,0 , 4156,6 , 691,4 ,     2,     1,     7,     7,     7 }, // Konkani/Devanagari/India
    {    156,    71,   207,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 744,7 , 744,7 , 1264,9 , 1273,16 , 505,7 , 512,13 , 23555,39 , 23555,39 , 23555,39 , 23555,39 , 23555,39 , 23555,39 , 12326,14 , 12340,28 , 12326,14 , 12326,14 , 12340,28 , 12326,14 , 341,2 , 348,2 , {75,82,87},  272,1 , 12219,19 , 9,4 , 4,0 , 4162,3 , 4165,4 ,     0,     0,     7,     6,     7 }, // Korean/Korean/SouthKorea
    {    156,    71,   169,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 744,7 , 744,7 , 1264,9 , 1273,16 , 505,7 , 512,13 , 23555,39 , 23555,39 , 23555,39 , 23555,39 , 23555,39 , 23555,39 , 12326,14 , 12340,28 , 12326,14 , 12326,14 , 12340,28 , 12326,14 , 341,2 , 348,2 , {75,80,87},  273,3 , 12238,39 , 9,4 , 4,0 , 4162,3 , 4169,11 ,     0,     0,     1,     6,     7 }, // Korean/Korean/NorthKorea
    {    158,    74,   141,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 23594,46 , 23640,88 , 23728,24 , 23594,46 , 23640,88 , 23728,24 , 12368,28 , 12396,53 , 12449,14 , 12368,28 , 12396,53 , 12449,14 , 343,6 , 350,6 , {88,79,70},  131,5 , 12277,23 , 0,4 , 4,0 , 4180,11 , 4191,5 ,     0,     0,     1,     6,     7 }, // Koyra Chiini/Latin/Mali
    {    159,    74,   141,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 23594,46 , 23640,88 , 23728,24 , 23594,46 , 23640,88 , 23728,24 , 12463,28 , 12491,54 , 12449,14 , 12463,28 , 12491,54 , 12449,14 , 343,6 , 350,6 , {88,79,70},  131,5 , 12277,23 , 0,4 , 4,0 , 4196,15 , 4191,5 ,     0,     0,     1,     6,     7 }, // Koyraboro Senni/Latin/Mali
    {    160,    74,   131,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 23,7 , 30,12 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {76,82,68},  10,1 , 0,7 , 13,5 , 4,0 , 4211,6 , 0,0 ,     2,     1,     1,     6,     7 }, // Kpelle/Latin/Liberia
    {    160,    74,    99,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {71,78,70},  226,2 , 0,7 , 13,5 , 4,0 , 4211,6 , 0,0 ,     0,     0,     1,     6,     7 }, // Kpelle/Latin/Guinea
    {    162,    74,   235,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 751,7 , 751,7 , 86,10 , 163,17 , 18,5 , 8,10 , 23752,48 , 23800,88 , 23888,24 , 23752,48 , 23912,101 , 23888,24 , 12545,20 , 12565,42 , 12607,14 , 12545,20 , 12565,42 , 12607,14 , 349,2 , 356,2 , {84,82,89},  128,1 , 0,7 , 4,5 , 4,0 , 4217,5 , 4222,7 ,     2,     1,     1,     6,     7 }, // Kurdish/Latin/Turkey
    {    163,    74,    40,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,   171,   187, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 24013,51 , 24064,143 , 158,27 , 24013,51 , 24064,143 , 158,27 , 12621,30 , 12651,89 , 12740,14 , 12621,30 , 12651,89 , 12740,14 , 351,4 , 358,4 , {88,65,70},  11,4 , 12300,20 , 4,5 , 4,0 , 4229,6 , 4235,7 ,     0,     0,     1,     6,     7 }, // Kwasio/Latin/Cameroon
    {    164,    29,   126,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 758,10 , 758,10 , 223,6 , 1289,23 , 18,5 , 8,10 , 24207,48 , 24255,80 , 9004,24 , 24335,59 , 8924,80 , 9004,24 , 12754,38 , 12792,57 , 12849,14 , 12754,38 , 12792,57 , 12849,14 , 355,5 , 362,14 , {75,71,83},  276,3 , 12320,52 , 4,5 , 4,0 , 4242,8 , 4250,10 ,     2,     1,     1,     6,     7 }, // Kyrgyz/Cyrillic/Kyrgyzstan
    {    165,    74,   243,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 547,6 , 553,18 , 23,7 , 30,12 , 24394,180 , 24394,180 , 158,27 , 24394,180 , 24394,180 , 158,27 , 12863,87 , 12863,87 , 85,14 , 12863,87 , 12863,87 , 12950,14 , 0,2 , 0,2 , {85,83,68},  10,1 , 0,7 , 24,6 , 4,0 , 4260,12 , 4272,22 ,     2,     1,     7,     6,     7 }, // Lakota/Latin/UnitedStates
    {    166,    74,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 24574,83 , 24657,111 , 24768,24 , 24574,83 , 24657,111 , 24768,24 , 12964,36 , 13000,63 , 13063,14 , 12964,36 , 13000,63 , 13063,14 , 360,3 , 376,3 , {84,90,83},  123,3 , 12372,29 , 24,6 , 4,0 , 4294,8 , 4302,9 ,     2,     0,     1,     6,     7 }, // Langi/Latin/Tanzania
    {    167,    73,   127,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 768,9 , 129,8 , 1312,19 , 74,4 , 525,24 , 24792,61 , 24853,75 , 158,27 , 24792,61 , 24853,75 , 158,27 , 13077,36 , 13113,57 , 13170,17 , 13077,36 , 13113,57 , 13170,17 , 363,8 , 379,8 , {76,65,75},  279,1 , 12401,21 , 9,4 , 48,5 , 4311,3 , 4311,3 ,     0,     0,     7,     6,     7 }, // Lao/Lao/Laos
    {    169,    74,   249,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 394,8 , 394,8 , 1331,8 , 1339,23 , 18,5 , 8,10 , 24928,48 , 24976,102 , 158,27 , 24928,48 , 25078,99 , 158,27 , 13187,28 , 13215,85 , 85,14 , 13187,28 , 13215,85 , 85,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 4167,11 , 13,5 , 4,0 , 4314,6 , 4320,16 ,     2,     1,     1,     6,     7 }, // Latin/Latin/VaticanCity
    {    170,    74,   128,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 264,8 , 264,8 , 251,8 , 1362,26 , 18,5 , 8,10 , 25177,65 , 25242,101 , 134,24 , 25177,65 , 25242,101 , 134,24 , 13300,51 , 13351,72 , 13423,14 , 13437,51 , 13488,72 , 13423,14 , 371,14 , 387,11 , {69,85,82},  22,1 , 12422,23 , 4,5 , 4,0 , 4336,8 , 4344,7 ,     2,     1,     1,     6,     7 }, // Latvian/Latin/Latvia
    {    173,    74,   115,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 1388,21 , 18,5 , 8,10 , 25343,60 , 25403,84 , 25487,36 , 25523,93 , 25616,117 , 25487,36 , 13560,35 , 13595,55 , 13650,14 , 13560,35 , 13595,55 , 13650,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 11539,19 , 4,5 , 4,0 , 4351,6 , 3856,6 ,     2,     1,     1,     6,     7 }, // Ligurian/Latin/Italy
    {    177,    74,    57,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 777,9 , 777,9 , 129,8 , 113,16 , 18,5 , 8,10 , 25733,48 , 25781,203 , 25984,24 , 25733,48 , 25781,203 , 25984,24 , 13664,28 , 13692,100 , 13792,14 , 13664,28 , 13692,100 , 13792,14 , 385,8 , 398,6 , {67,68,70},  220,2 , 12445,23 , 4,5 , 4,0 , 4357,7 , 4364,30 ,     2,     1,     1,     6,     7 }, // Lingala/Latin/CongoKinshasa
    {    177,    74,     7,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 777,9 , 777,9 , 129,8 , 113,16 , 18,5 , 8,10 , 25733,48 , 25781,203 , 25984,24 , 25733,48 , 25781,203 , 25984,24 , 13664,28 , 13692,100 , 13792,14 , 13664,28 , 13692,100 , 13792,14 , 385,8 , 398,6 , {65,79,65},  280,2 , 12468,23 , 4,5 , 4,0 , 4357,7 , 4394,6 ,     2,     1,     1,     6,     7 }, // Lingala/Latin/Angola
    {    177,    74,    46,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 777,9 , 777,9 , 129,8 , 113,16 , 18,5 , 8,10 , 25733,48 , 25781,203 , 25984,24 , 25733,48 , 25781,203 , 25984,24 , 13664,28 , 13692,100 , 13792,14 , 13664,28 , 13692,100 , 13792,14 , 385,8 , 398,6 , {88,65,70},  11,4 , 12491,23 , 4,5 , 4,0 , 4357,7 , 4400,26 ,     0,     0,     1,     6,     7 }, // Lingala/Latin/CentralAfricanRepublic
    {    177,    74,    56,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 777,9 , 777,9 , 129,8 , 113,16 , 18,5 , 8,10 , 25733,48 , 25781,203 , 25984,24 , 25733,48 , 25781,203 , 25984,24 , 13664,28 , 13692,100 , 13792,14 , 13664,28 , 13692,100 , 13792,14 , 385,8 , 398,6 , {88,65,70},  11,4 , 12491,23 , 4,5 , 4,0 , 4357,7 , 4426,5 ,     0,     0,     1,     6,     7 }, // Lingala/Latin/CongoBrazzaville
    {    180,    74,   134,    44,   160,    59,    37,    48,  8722,    43,   101,  8222,  8220,  8222,  8220, 0,6 , 0,6 , 786,8 , 786,8 , 86,10 , 1409,27 , 18,5 , 8,10 , 26008,70 , 26078,96 , 26174,24 , 26008,70 , 26198,98 , 26174,24 , 13806,21 , 13827,89 , 13916,14 , 13806,21 , 13827,89 , 13916,14 , 393,9 , 404,6 , {69,85,82},  22,1 , 12514,30 , 4,5 , 4,0 , 4431,8 , 4439,7 ,     2,     1,     1,     6,     7 }, // Lithuanian/Latin/Lithuania
    {    181,    74,   254,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {0,0,0},  0,0 , 2547,0 , 13,5 , 4,0 , 4446,11 , 0,0 ,     2,     1,     1,     6,     7 }, // Lojban/Latin/World
    {    182,    74,    89,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 264,8 , 264,8 , 364,7 , 1436,23 , 549,10 , 559,19 , 26296,59 , 26355,85 , 134,24 , 26296,59 , 26355,85 , 134,24 , 13930,28 , 13958,65 , 4858,14 , 13930,28 , 13958,65 , 4858,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 12544,15 , 4,5 , 4,0 , 4457,14 , 4471,11 ,     2,     1,     1,     6,     7 }, // Low German/Latin/Germany
    {    182,    74,   161,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 264,8 , 264,8 , 364,7 , 1436,23 , 549,10 , 559,19 , 26296,59 , 26355,85 , 134,24 , 26296,59 , 26355,85 , 134,24 , 13930,28 , 13958,65 , 4858,14 , 13930,28 , 13958,65 , 4858,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 12544,15 , 4,5 , 4,0 , 4457,14 , 4482,12 ,     2,     1,     1,     6,     7 }, // Low German/Latin/Netherlands
    {    183,    74,    89,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 794,7 , 794,7 , 180,6 , 878,18 , 74,4 , 78,9 , 26440,48 , 26488,85 , 6694,24 , 26573,60 , 26633,93 , 6694,24 , 14023,28 , 14051,53 , 14104,14 , 14023,28 , 14051,53 , 14104,14 , 402,9 , 410,10 , {69,85,82},  22,1 , 12559,27 , 4,5 , 4,0 , 4494,14 , 4508,6 ,     2,     1,     1,     6,     7 }, // Lower Sorbian/Latin/Germany
    {    185,    74,    57,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 26726,49 , 26775,99 , 26874,24 , 26726,49 , 26775,99 , 26874,24 , 14118,28 , 14146,50 , 14196,14 , 14118,28 , 14146,50 , 14196,14 , 411,5 , 420,6 , {67,68,70},  220,2 , 12586,24 , 0,4 , 4,0 , 4514,8 , 4522,16 ,     2,     1,     1,     6,     7 }, // LubaKatanga/Latin/CongoKinshasa
    {    186,    74,   221,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {83,69,75},  209,2 , 0,7 , 13,5 , 4,0 , 4538,15 , 0,0 ,     2,     0,     1,     6,     7 }, // Lule Sami/Latin/Sweden
    {    186,    74,   172,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {78,79,75},  209,2 , 0,7 , 13,5 , 4,0 , 4538,15 , 0,0 ,     2,     0,     1,     6,     7 }, // Lule Sami/Latin/Norway
    {    187,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 26898,48 , 26946,186 , 27132,24 , 26898,48 , 26946,186 , 27132,24 , 14210,28 , 14238,69 , 14307,14 , 14210,28 , 14238,69 , 14307,14 , 416,2 , 426,2 , {75,69,83},  180,3 , 12610,23 , 0,4 , 4,0 , 4553,6 , 1343,5 ,     2,     1,     7,     6,     7 }, // Luo/Latin/Kenya
    {    188,    74,   135,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 801,10 , 801,10 , 251,8 , 878,18 , 18,5 , 8,10 , 27156,48 , 27204,85 , 134,24 , 27289,59 , 27204,85 , 134,24 , 14321,28 , 14349,65 , 4858,14 , 14414,35 , 14349,65 , 4858,14 , 418,5 , 428,8 , {69,85,82},  22,1 , 10819,19 , 4,5 , 4,0 , 4559,14 , 4573,10 ,     2,     1,     1,     6,     7 }, // Luxembourgish/Latin/Luxembourg
    {    189,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 27348,48 , 3386,84 , 134,24 , 27348,48 , 3386,84 , 134,24 , 14449,21 , 14470,75 , 85,14 , 14449,21 , 14470,75 , 85,14 , 168,4 , 168,4 , {75,69,83},  180,3 , 12633,23 , 9,4 , 86,6 , 4583,7 , 1343,5 ,     2,     1,     7,     6,     7 }, // Luyia/Latin/Kenya
    {    192,    29,   170,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 148,7 , 148,7 , 180,6 , 10,17 , 18,5 , 8,10 , 27396,61 , 27457,85 , 6849,24 , 27396,61 , 27457,85 , 6849,24 , 14545,35 , 14580,54 , 3358,14 , 14545,35 , 14580,54 , 3358,14 , 423,7 , 436,5 , {77,75,68},  282,4 , 12656,56 , 4,5 , 4,0 , 4590,10 , 4600,18 ,     2,     1,     1,     6,     7 }, // Macedonian/Cyrillic/NorthMacedonia
    {    193,    74,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 27542,48 , 27590,87 , 134,24 , 27542,48 , 27590,87 , 134,24 , 14634,28 , 14662,62 , 1353,14 , 14634,28 , 14662,62 , 1353,14 , 430,5 , 441,9 , {84,90,83},  123,3 , 12712,27 , 9,4 , 4,0 , 4618,9 , 2315,8 ,     2,     0,     1,     6,     7 }, // Machame/Latin/Tanzania
    {    194,    31,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 517,9 , 526,8 , 223,6 , 10,17 , 55,7 , 62,12 , 27677,58 , 27735,72 , 27807,29 , 18750,59 , 27836,72 , 27807,29 , 9119,32 , 14724,64 , 9204,19 , 9119,32 , 14724,64 , 9204,19 , 88,3 , 83,4 , {73,78,82},  122,1 , 12188,31 , 13,5 , 4,0 , 4627,6 , 691,4 ,     2,     1,     7,     7,     7 }, // Maithili/Devanagari/India
    {    195,    74,   156,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 27908,48 , 27956,213 , 28169,24 , 27908,48 , 27956,213 , 28169,24 , 14788,28 , 14816,59 , 14875,14 , 14788,28 , 14816,59 , 14875,14 , 435,8 , 450,10 , {77,90,78},  286,3 , 0,7 , 24,6 , 4,0 , 4633,5 , 4638,10 ,     2,     1,     7,     6,     7 }, // Makhuwa-Meetto/Latin/Mozambique
    {    196,    74,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 27542,48 , 28193,264 , 134,24 , 27542,48 , 28193,264 , 134,24 , 14889,28 , 14917,133 , 15050,14 , 14889,28 , 14917,133 , 15050,14 , 443,4 , 460,5 , {84,90,83},  123,3 , 12712,27 , 9,4 , 4,0 , 4648,10 , 2315,8 ,     2,     0,     1,     6,     7 }, // Makonde/Latin/Tanzania
    {    197,    74,   137,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 113,16 , 18,5 , 8,10 , 28457,48 , 28505,92 , 134,24 , 28457,48 , 28505,92 , 134,24 , 15064,34 , 15098,60 , 15158,14 , 15064,34 , 15098,60 , 15158,14 , 0,2 , 0,2 , {77,71,65},  192,2 , 12739,13 , 13,5 , 4,0 , 4658,8 , 4666,12 ,     0,     0,     1,     6,     7 }, // Malagasy/Latin/Madagascar
    {    198,    74,   139,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 588,9 , 588,9 , 827,7 , 10,17 , 23,7 , 30,12 , 28597,48 , 28645,82 , 10078,24 , 28597,48 , 28645,82 , 10078,24 , 15172,28 , 15200,43 , 15243,14 , 15172,28 , 15200,43 , 15243,14 , 447,2 , 465,3 , {77,89,82},  196,2 , 12752,39 , 9,4 , 4,0 , 4678,6 , 1917,8 ,     2,     1,     1,     6,     7 }, // Malay/Latin/Malaysia
    {    198,     4,    35,    44,    46,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 0,6 , 0,6 , 0,6 , 0,6 , 827,7 , 1459,12 , 55,7 , 62,12 , 28727,75 , 28727,75 , 158,27 , 28727,75 , 28727,75 , 158,27 , 15257,35 , 15257,35 , 85,14 , 15257,35 , 15257,35 , 85,14 , 0,2 , 0,2 , {66,78,68},  10,1 , 12791,17 , 13,5 , 4,0 , 4684,10 , 4694,5 ,     2,     1,     1,     6,     7 }, // Malay/Arabic/Brunei
    {    198,     4,   139,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 0,6 , 0,6 , 0,6 , 0,6 , 827,7 , 206,17 , 55,7 , 62,12 , 28727,75 , 28727,75 , 158,27 , 28727,75 , 28727,75 , 158,27 , 15257,35 , 15257,35 , 85,14 , 15257,35 , 15257,35 , 85,14 , 0,2 , 0,2 , {77,89,82},  196,2 , 12808,20 , 9,4 , 4,0 , 4684,10 , 4699,6 ,     2,     1,     1,     6,     7 }, // Malay/Arabic/Malaysia
    {    198,    74,    35,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 588,9 , 588,9 , 827,7 , 1459,12 , 23,7 , 30,12 , 28597,48 , 28645,82 , 10078,24 , 28597,48 , 28645,82 , 10078,24 , 15172,28 , 15200,43 , 15243,14 , 15172,28 , 15200,43 , 15243,14 , 447,2 , 465,3 , {66,78,68},  10,1 , 12828,31 , 13,5 , 4,0 , 4678,6 , 4705,6 ,     2,     1,     1,     6,     7 }, // Malay/Latin/Brunei
    {    198,    74,   109,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 588,9 , 588,9 , 59,8 , 809,18 , 294,5 , 299,10 , 28597,48 , 28645,82 , 10078,24 , 28597,48 , 28645,82 , 10078,24 , 15172,28 , 15200,43 , 15243,14 , 15172,28 , 15200,43 , 15243,14 , 447,2 , 465,3 , {73,68,82},  261,2 , 11374,39 , 9,4 , 4,0 , 4678,6 , 3783,9 ,     2,     0,     7,     6,     7 }, // Malay/Latin/Indonesia
    {    198,    74,   199,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 588,9 , 588,9 , 827,7 , 10,17 , 23,7 , 30,12 , 28597,48 , 28645,82 , 10078,24 , 28597,48 , 28645,82 , 10078,24 , 15172,28 , 15200,43 , 15243,14 , 15172,28 , 15200,43 , 15243,14 , 447,2 , 465,3 , {83,71,68},  10,1 , 12859,37 , 9,4 , 4,0 , 4678,6 , 4711,9 ,     2,     1,     7,     6,     7 }, // Malay/Latin/Singapore
    {    199,    83,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 811,13 , 824,12 , 223,6 , 1471,18 , 55,7 , 62,12 , 28802,62 , 28864,88 , 28952,32 , 28802,62 , 28864,88 , 28952,32 , 15292,41 , 15333,77 , 15410,22 , 15292,41 , 15432,76 , 15508,21 , 0,2 , 0,2 , {73,78,82},  122,1 , 12896,40 , 9,4 , 4,0 , 4720,6 , 4726,6 ,     2,     1,     7,     7,     7 }, // Malayalam/Malayalam/India
    {    200,    74,   142,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 836,8 , 844,7 , 186,10 , 1489,23 , 18,5 , 8,10 , 28984,48 , 29032,86 , 29118,36 , 28984,48 , 29032,86 , 29154,24 , 15529,28 , 15557,63 , 15620,21 , 15529,28 , 15557,63 , 15641,20 , 0,2 , 0,2 , {69,85,82},  22,1 , 12936,31 , 9,4 , 4,0 , 4732,5 , 1933,5 ,     2,     1,     7,     6,     7 }, // Maltese/Latin/Malta
    {    203,     9,   108,    46,    44,    59,    37,  2534,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 851,11 , 851,11 , 223,6 , 1512,18 , 55,7 , 62,12 , 29178,58 , 29236,88 , 29324,37 , 29361,88 , 29361,88 , 29449,38 , 15661,59 , 15661,59 , 15720,26 , 15661,59 , 15661,59 , 15746,30 , 449,4 , 468,5 , {73,78,82},  122,1 , 12967,35 , 13,5 , 4,0 , 4737,8 , 4745,8 ,     2,     1,     7,     7,     7 }, // Manipuri/Bangla/India
    {    203,    89,   108,    46,    44,    59,    37, 44016,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 279,8 , 287,18 , 578,8 , 586,12 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {73,78,82},  122,1 , 0,7 , 13,5 , 4,0 , 4753,7 , 0,0 ,     2,     1,     7,     7,     7 }, // Manipuri/Meitei Mayek/India
    {    204,    74,   113,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 96,17 , 18,5 , 8,10 , 29487,102 , 29589,140 , 158,27 , 29487,102 , 29589,140 , 158,27 , 15776,30 , 15806,57 , 85,14 , 15776,30 , 15806,57 , 85,14 , 168,4 , 168,4 , {71,66,80},  96,1 , 0,7 , 9,4 , 4,0 , 4760,5 , 4765,12 ,     2,     1,     1,     6,     7 }, // Manx/Latin/IsleOfMan
    {    205,    74,   163,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 415,10 , 10,17 , 23,7 , 30,12 , 29729,51 , 29780,84 , 29864,24 , 29729,51 , 29780,84 , 29864,24 , 15863,31 , 15894,48 , 15942,16 , 15863,31 , 15894,48 , 15958,16 , 0,2 , 0,2 , {78,90,68},  10,1 , 13002,37 , 92,2 , 4,0 , 4777,5 , 4782,8 ,     2,     1,     1,     6,     7 }, // Maori/Latin/NewZealand
    {    206,    74,    49,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {67,76,80},  10,1 , 0,7 , 13,5 , 4,0 , 4790,10 , 0,0 ,     0,     0,     1,     6,     7 }, // Mapuche/Latin/Chile
    {    207,    31,   108,    46,    44,    59,    37,  2406,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 862,9 , 862,9 , 223,6 , 287,18 , 55,7 , 62,12 , 29888,66 , 29954,86 , 30040,32 , 29888,66 , 29954,86 , 30040,32 , 15974,32 , 16006,53 , 9204,19 , 15974,32 , 16006,53 , 9204,19 , 0,2 , 0,2 , {73,78,82},  122,1 , 13039,43 , 9,4 , 4,0 , 4800,5 , 691,4 ,     2,     1,     7,     7,     7 }, // Marathi/Devanagari/India
    {    209,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 30072,51 , 30123,132 , 158,27 , 30072,51 , 30123,132 , 158,27 , 14634,28 , 16059,58 , 15050,14 , 14634,28 , 16059,58 , 15050,14 , 453,9 , 473,6 , {75,69,83},  180,3 , 13082,25 , 9,4 , 4,0 , 4805,3 , 1343,5 ,     2,     1,     7,     6,     7 }, // Masai/Latin/Kenya
    {    209,    74,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 30072,51 , 30123,132 , 158,27 , 30072,51 , 30123,132 , 158,27 , 14634,28 , 16059,58 , 15050,14 , 14634,28 , 16059,58 , 15050,14 , 453,9 , 473,6 , {84,90,83},  123,3 , 13107,28 , 9,4 , 4,0 , 4805,3 , 4808,8 ,     2,     0,     1,     6,     7 }, // Masai/Latin/Tanzania
    {    210,     4,   110,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 30255,70 , 30255,70 , 158,27 , 30255,70 , 30255,70 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {73,82,82},  289,3 , 13135,27 , 13,5 , 4,0 , 4816,7 , 4823,5 ,     0,     0,     6,     5,     5 }, // Mazanderani/Arabic/Iran
    {    213,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 30325,48 , 30373,86 , 30459,24 , 30325,48 , 30373,86 , 30459,24 , 16117,28 , 16145,51 , 16196,14 , 16117,28 , 16145,51 , 16196,14 , 462,2 , 479,2 , {75,69,83},  180,3 , 4749,24 , 9,4 , 4,0 , 4828,6 , 1343,5 ,     2,     1,     7,     6,     7 }, // Meru/Latin/Kenya
    {    214,    74,    40,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 145,18 , 18,5 , 8,10 , 30483,137 , 30620,142 , 30762,36 , 30483,137 , 30620,142 , 30762,36 , 16210,49 , 16210,49 , 16259,21 , 16210,49 , 16210,49 , 16259,21 , 0,2 , 0,2 , {88,65,70},  11,4 , 13162,12 , 13,5 , 4,0 , 4834,5 , 4839,7 ,     0,     0,     1,     6,     7 }, // Meta/Latin/Cameroon
    {    215,    74,    41,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 23,7 , 30,12 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {67,65,68},  263,3 , 0,7 , 13,5 , 4,0 , 4846,11 , 0,0 ,     2,     0,     7,     6,     7 }, // Mohawk/Latin/Canada
    {    216,    29,   189,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {82,85,66},  137,1 , 0,7 , 13,5 , 4,0 , 4857,12 , 0,0 ,     2,     1,     1,     6,     7 }, // Moksha/Cyrillic/Russia
    {    217,    29,   152,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 571,10 , 1530,35 , 18,5 , 148,12 , 30798,99 , 30897,192 , 31089,38 , 30798,99 , 31127,192 , 31089,38 , 16280,21 , 16301,43 , 16280,21 , 16280,21 , 16344,43 , 16280,21 , 464,4 , 481,4 , {77,78,84},  292,1 , 13174,46 , 13,5 , 4,0 , 4869,6 , 4875,6 ,     2,     0,     1,     6,     7 }, // Mongolian/Cyrillic/Mongolia
    {    217,    94,    50,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {67,78,89},  293,3 , 13220,19 , 13,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Mongolian/Mongolian/China
    {    217,    94,   152,    44,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 571,10 , 1565,36 , 18,5 , 148,12 , 31319,132 , 31451,212 , 31089,38 , 31663,133 , 31451,212 , 31089,38 , 16387,24 , 16411,43 , 16454,24 , 16478,24 , 16411,43 , 16502,23 , 468,4 , 485,5 , {77,78,84},  292,1 , 13239,31 , 9,4 , 4,0 , 4881,6 , 4881,6 ,     2,     0,     1,     6,     7 }, // Mongolian/Mongolian/Mongolia
    {    218,    74,   146,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 31796,47 , 31843,68 , 31911,24 , 31796,47 , 31843,68 , 31911,24 , 16525,27 , 16552,48 , 16600,14 , 16525,27 , 16552,48 , 16600,14 , 0,2 , 0,2 , {77,85,82},  129,2 , 13270,21 , 24,6 , 4,0 , 4887,14 , 4901,5 ,     2,     0,     1,     6,     7 }, // Morisyen/Latin/Mauritius
    {    219,    74,    40,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 31935,48 , 31983,139 , 32122,24 , 31935,48 , 31983,139 , 32122,24 , 16614,28 , 16642,74 , 16716,14 , 16614,28 , 16642,74 , 16716,14 , 472,5 , 490,5 , {88,65,70},  11,4 , 13291,17 , 9,4 , 4,0 , 4906,6 , 4912,7 ,     0,     0,     1,     6,     7 }, // Mundang/Latin/Cameroon
    {    220,    74,   243,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 547,6 , 553,18 , 23,7 , 30,12 , 32146,125 , 32146,125 , 158,27 , 32146,125 , 32146,125 , 158,27 , 16730,107 , 16730,107 , 85,14 , 16730,107 , 16730,107 , 85,14 , 0,2 , 0,2 , {85,83,68},  10,1 , 0,7 , 24,6 , 4,0 , 4919,7 , 991,13 ,     2,     1,     7,     6,     7 }, // Muscogee/Latin/UnitedStates
    {    221,    74,   158,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 23,7 , 30,12 , 0,48 , 32271,136 , 134,24 , 0,48 , 32271,136 , 134,24 , 16837,23 , 16860,92 , 16952,14 , 16837,23 , 16860,92 , 16952,14 , 477,7 , 495,5 , {78,65,68},  10,1 , 13308,22 , 9,4 , 4,0 , 4926,13 , 4939,8 ,     2,     1,     1,     6,     7 }, // Nama/Latin/Namibia
    {    223,    74,   243,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {85,83,68},  184,3 , 0,7 , 13,5 , 4,0 , 4947,11 , 0,0 ,     2,     1,     7,     6,     7 }, // Navajo/Latin/UnitedStates
    {    225,    31,   160,    46,    44,    59,    37,  2406,    45,    43,   101,  8220,  8221,  8216,  8217, 871,5 , 0,6 , 876,7 , 876,7 , 322,6 , 163,17 , 18,5 , 8,10 , 32407,85 , 32407,85 , 32492,53 , 32407,85 , 32407,85 , 32545,52 , 16966,33 , 16999,54 , 17053,18 , 16966,33 , 16999,54 , 17053,18 , 484,9 , 500,7 , {78,80,82},  296,4 , 13330,49 , 13,5 , 4,0 , 4958,6 , 4964,5 ,     2,     1,     7,     6,     7 }, // Nepali/Devanagari/Nepal
    {    225,    31,   108,    46,    44,    59,    37,  2406,    45,    43,   101,  8220,  8221,  8216,  8217, 871,5 , 0,6 , 876,7 , 876,7 , 322,6 , 163,17 , 55,7 , 62,12 , 32407,85 , 32407,85 , 32492,53 , 32407,85 , 32407,85 , 32545,52 , 16966,33 , 16999,54 , 17053,18 , 16966,33 , 16999,54 , 17053,18 , 484,9 , 500,7 , {73,78,82},  122,1 , 13379,49 , 13,5 , 4,0 , 4958,6 , 691,4 ,     2,     1,     7,     7,     7 }, // Nepali/Devanagari/India
    {    227,    74,    40,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 1601,32 , 18,5 , 8,10 , 32597,165 , 32597,165 , 158,27 , 32597,165 , 32597,165 , 158,27 , 17071,111 , 17071,111 , 85,14 , 17071,111 , 17071,111 , 85,14 , 493,9 , 507,8 , {88,65,70},  11,4 , 13428,16 , 13,5 , 4,0 , 4969,16 , 4985,7 ,     0,     0,     1,     6,     7 }, // Ngiemboon/Latin/Cameroon
    {    228,    74,    40,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 883,11 , 883,11 , 894,16 , 910,9 , 86,10 , 145,18 , 18,5 , 8,10 , 32762,174 , 32762,174 , 158,27 , 32762,174 , 32762,174 , 158,27 , 17182,60 , 17182,60 , 17242,25 , 17182,60 , 17182,60 , 17242,25 , 502,8 , 515,13 , {88,65,70},  11,4 , 13444,12 , 13,5 , 4,0 , 4992,5 , 4997,7 ,     0,     0,     1,     6,     7 }, // Ngomba/Latin/Cameroon
    {    229,    74,    32,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 919,10 , 919,10 , 186,10 , 10,17 , 18,5 , 8,10 , 32936,36 , 32972,101 , 33073,24 , 32936,36 , 32972,101 , 33073,24 , 17267,28 , 17295,65 , 17360,14 , 17267,28 , 17295,65 , 17360,14 , 0,2 , 0,2 , {66,82,76},  267,2 , 13456,56 , 13,5 , 4,0 , 5004,8 , 5012,6 ,     2,     1,     7,     6,     7 }, // Nheengatu/Latin/Brazil
    {    229,    74,    54,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 919,10 , 919,10 , 186,10 , 10,17 , 23,7 , 30,12 , 32936,36 , 32972,101 , 33073,24 , 32936,36 , 32972,101 , 33073,24 , 17267,28 , 17295,65 , 17360,14 , 17267,28 , 17295,65 , 17360,14 , 132,5 , 128,5 , {67,79,80},  10,1 , 13512,64 , 13,5 , 4,0 , 5018,7 , 5025,8 ,     2,     0,     7,     6,     7 }, // Nheengatu/Latin/Colombia
    {    229,    74,   250,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 919,10 , 919,10 , 186,10 , 10,17 , 23,7 , 30,12 , 32936,36 , 32972,101 , 33073,24 , 32936,36 , 32972,101 , 33073,24 , 17267,28 , 17295,65 , 17360,14 , 17267,28 , 17295,65 , 17360,14 , 132,5 , 128,5 , {86,69,83},  300,4 , 13576,77 , 13,5 , 4,0 , 5018,7 , 5033,9 ,     2,     1,     7,     6,     7 }, // Nheengatu/Latin/Venezuela
    {    230,    74,   166,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 929,9 , 938,8 , 186,10 , 10,17 , 18,5 , 8,10 , 33097,51 , 33148,83 , 134,24 , 33231,50 , 33148,83 , 134,24 , 17374,33 , 17407,52 , 85,14 , 17374,33 , 17407,52 , 85,14 , 510,9 , 528,8 , {78,71,78},  126,1 , 13653,50 , 9,4 , 4,0 , 5042,14 , 5056,8 ,     2,     1,     1,     6,     7 }, // Nigerian Pidgin/Latin/Nigeria
    {    231,   103,    99,    46,  1548,    59,    37,  1984,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 33281,62 , 33343,106 , 33449,24 , 33281,62 , 33343,106 , 33449,24 , 17459,33 , 17492,61 , 17553,14 , 17567,35 , 17492,61 , 17553,14 , 519,1 , 536,1 , {71,78,70},  304,1 , 13703,51 , 13,5 , 4,0 , 5064,3 , 5067,6 ,     0,     0,     1,     6,     7 }, // Nko/Nko/Guinea
    {    232,    74,   257,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 33473,52 , 33525,112 , 33637,24 , 33473,52 , 33525,112 , 33637,24 , 17602,28 , 17630,50 , 17680,14 , 17602,28 , 17630,50 , 17680,14 , 0,2 , 0,2 , {85,83,68},  184,3 , 13754,24 , 9,4 , 4,0 , 5073,10 , 2481,8 ,     2,     1,     7,     6,     7 }, // North Ndebele/Latin/Zimbabwe
    {    233,    74,    89,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 938,8 , 938,8 , 59,8 , 878,18 , 18,5 , 8,10 , 33661,48 , 33709,95 , 134,24 , 33661,48 , 33709,95 , 134,24 , 17694,28 , 17722,57 , 85,14 , 17694,28 , 17722,57 , 85,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 13778,16 , 13,5 , 4,0 , 5083,10 , 5093,9 ,     2,     1,     1,     6,     7 }, // Northern Frisian/Latin/Germany
    {    234,     4,   110,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 33804,77 , 33804,77 , 158,27 , 33804,77 , 33804,77 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {73,82,82},  0,0 , 0,7 , 13,5 , 4,0 , 5102,11 , 0,0 ,     0,     0,     6,     5,     5 }, // Northern Luri/Arabic/Iran
    {    234,     4,   111,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 55,7 , 62,12 , 33804,77 , 33804,77 , 158,27 , 33804,77 , 33804,77 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {73,81,68},  45,5 , 0,7 , 13,5 , 4,0 , 5102,11 , 0,0 ,     0,     0,     6,     5,     6 }, // Northern Luri/Arabic/Iraq
    {    235,    74,   172,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 348,8 , 348,8 , 86,10 , 163,17 , 18,5 , 8,10 , 33881,59 , 33940,145 , 34085,24 , 33881,59 , 33940,145 , 34085,24 , 17779,33 , 17812,75 , 17887,14 , 17779,33 , 17812,75 , 17887,14 , 520,11 , 537,13 , {78,79,75},  209,2 , 13794,63 , 4,5 , 4,0 , 5113,15 , 5128,5 ,     2,     0,     1,     6,     7 }, // Northern Sami/Latin/Norway
    {    235,    74,    81,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 348,8 , 348,8 , 27,10 , 113,16 , 18,5 , 8,10 , 34109,60 , 33940,145 , 34085,24 , 34109,60 , 33940,145 , 34085,24 , 17901,21 , 17922,70 , 17992,14 , 17901,21 , 17922,70 , 17992,14 , 531,2 , 550,2 , {69,85,82},  22,1 , 13857,23 , 4,5 , 4,0 , 5113,15 , 5133,6 ,     2,     1,     1,     6,     7 }, // Northern Sami/Latin/Finland
    {    235,    74,   221,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 348,8 , 348,8 , 86,10 , 163,17 , 18,5 , 8,10 , 33881,59 , 33940,145 , 34085,24 , 33881,59 , 33940,145 , 34085,24 , 17779,33 , 17812,75 , 17887,14 , 17779,33 , 17812,75 , 17887,14 , 520,11 , 537,13 , {83,69,75},  209,2 , 13880,63 , 4,5 , 4,0 , 5113,15 , 5139,6 ,     2,     0,     1,     6,     7 }, // Northern Sami/Latin/Sweden
    {    236,    74,   205,    46,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 34169,65 , 34234,106 , 34340,24 , 34169,65 , 34234,106 , 34340,24 , 18006,27 , 18033,64 , 18097,14 , 18006,27 , 18033,64 , 18097,14 , 0,2 , 0,2 , {90,65,82},  9,1 , 0,7 , 13,5 , 4,0 , 5145,16 , 5161,12 ,     2,     1,     7,     6,     7 }, // Northern Sotho/Latin/SouthAfrica
    {    238,    74,   172,    44,   160,    59,    37,    48,  8722,    43,   101,   171,   187,  8216,  8217, 0,6 , 0,6 , 286,8 , 286,8 , 27,10 , 706,17 , 18,5 , 8,10 , 14019,48 , 34364,83 , 134,24 , 34447,59 , 34364,83 , 134,24 , 18111,35 , 5182,51 , 5233,14 , 18111,35 , 5182,51 , 5233,14 , 168,4 , 168,4 , {78,79,75},  209,2 , 13943,44 , 13,5 , 4,0 , 5173,12 , 5185,5 ,     2,     0,     1,     6,     7 }, // Norwegian Bokmal/Latin/Norway
    {    238,    74,   220,    44,   160,    59,    37,    48,  8722,    43,   101,   171,   187,  8216,  8217, 0,6 , 0,6 , 286,8 , 286,8 , 27,10 , 706,17 , 18,5 , 8,10 , 14019,48 , 34364,83 , 134,24 , 34447,59 , 34364,83 , 134,24 , 18111,35 , 5182,51 , 5233,14 , 18111,35 , 5182,51 , 5233,14 , 168,4 , 168,4 , {78,79,75},  209,2 , 13943,44 , 13,5 , 4,0 , 5173,12 , 5190,21 ,     2,     0,     1,     6,     7 }, // Norwegian Bokmal/Latin/SvalbardAndJanMayen
    {    239,    74,   172,    44,   160,    59,    37,    48,  8722,    43,   101,   171,   187,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,10 , 706,17 , 18,5 , 598,16 , 14019,48 , 34364,83 , 134,24 , 34447,59 , 34364,83 , 134,24 , 18146,28 , 18174,51 , 5233,14 , 18225,28 , 18174,51 , 5233,14 , 168,4 , 168,4 , {78,79,75},  209,2 , 13943,44 , 4,5 , 4,0 , 5211,13 , 5224,5 ,     2,     0,     1,     6,     7 }, // Norwegian Nynorsk/Latin/Norway
    {    240,    74,   208,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 770,9 , 113,16 , 23,7 , 614,12 , 34506,54 , 34560,96 , 34656,24 , 34506,54 , 34560,96 , 34656,24 , 18253,38 , 18291,79 , 18370,14 , 18253,38 , 18291,79 , 18370,14 , 533,2 , 552,2 , {83,83,80},  96,1 , 0,7 , 9,4 , 4,0 , 5229,9 , 0,0 ,     2,     1,     1,     6,     7 }, // Nuer/Latin/SouthSudan
    {    241,    74,   138,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 23,7 , 30,12 , 34680,48 , 34728,91 , 158,27 , 34680,48 , 34728,91 , 158,27 , 18384,28 , 18412,67 , 85,14 , 18384,28 , 18412,67 , 85,14 , 0,2 , 0,2 , {77,87,75},  0,0 , 13987,22 , 13,5 , 4,0 , 5238,6 , 0,0 ,     2,     1,     1,     6,     7 }, // Nyanja/Latin/Malawi
    {    242,    74,   239,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 9265,48 , 9313,152 , 134,24 , 9265,48 , 9313,152 , 134,24 , 4389,28 , 4417,74 , 4491,14 , 4389,28 , 4417,74 , 4491,14 , 0,2 , 0,2 , {85,71,88},  151,3 , 4001,26 , 9,4 , 4,0 , 5244,10 , 1010,6 ,     0,     0,     1,     7,     7 }, // Nyankole/Latin/Uganda
    {    243,    74,   166,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {78,71,78},  126,1 , 0,7 , 13,5 , 4,0 , 5254,5 , 0,0 ,     2,     1,     1,     6,     7 }, // Obolo/Latin/Nigeria
    {    244,    74,    82,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 946,8 , 402,7 , 827,7 , 1633,21 , 626,6 , 8,10 , 34819,59 , 34878,83 , 34961,24 , 34819,59 , 34985,116 , 34961,24 , 18479,57 , 18479,57 , 18536,21 , 18479,57 , 18479,57 , 18536,21 , 0,2 , 0,2 , {69,85,82},  22,1 , 14009,16 , 0,4 , 4,0 , 5259,7 , 834,6 ,     2,     1,     1,     6,     7 }, // Occitan/Latin/France
    {    244,    74,   209,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 827,7 , 992,27 , 74,4 , 245,11 , 35101,48 , 35149,74 , 34961,24 , 35101,48 , 35149,74 , 35223,24 , 18557,28 , 18585,58 , 18643,14 , 18557,28 , 18585,58 , 18643,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 14009,16 , 0,4 , 4,0 , 5259,7 , 5266,7 ,     2,     1,     1,     6,     7 }, // Occitan/Latin/Spain
    {    245,   106,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 954,8 , 962,7 , 547,6 , 553,18 , 55,7 , 62,12 , 35247,86 , 35247,86 , 35333,32 , 35247,86 , 35247,86 , 35333,32 , 18657,33 , 18690,54 , 18744,18 , 18657,33 , 18690,54 , 18744,18 , 0,2 , 0,2 , {73,78,82},  122,1 , 14025,43 , 9,4 , 4,0 , 5273,5 , 5278,4 ,     2,     1,     7,     7,     7 }, // Odia/Odia/India
    {    251,    74,    77,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 553,18 , 23,7 , 30,12 , 35365,48 , 35413,111 , 134,24 , 35365,48 , 35413,111 , 134,24 , 18762,28 , 18790,55 , 85,14 , 18762,28 , 18790,55 , 85,14 , 535,2 , 554,2 , {69,84,66},  1,2 , 14068,24 , 9,4 , 4,0 , 5282,6 , 5288,10 ,     2,     1,     7,     6,     7 }, // Oromo/Latin/Ethiopia
    {    251,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 553,18 , 18,5 , 8,10 , 35365,48 , 35413,111 , 35524,24 , 35365,48 , 35413,111 , 134,24 , 18762,28 , 18790,55 , 18845,14 , 18762,28 , 18790,55 , 18845,14 , 535,2 , 554,2 , {75,69,83},  180,3 , 0,7 , 9,4 , 4,0 , 5282,6 , 5298,8 ,     2,     1,     7,     6,     7 }, // Oromo/Latin/Kenya
    {    252,   118,   243,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 547,6 , 553,18 , 55,7 , 62,12 , 35548,156 , 35704,332 , 158,27 , 35548,156 , 35704,332 , 158,27 , 18859,181 , 18859,181 , 85,14 , 18859,181 , 18859,181 , 19040,21 , 0,2 , 0,2 , {85,83,68},  10,1 , 0,7 , 24,6 , 4,0 , 5306,12 , 991,13 ,     2,     1,     7,     6,     7 }, // Osage/Osage/UnitedStates
    {    253,    29,    88,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 969,9 , 969,9 , 251,8 , 1654,23 , 18,5 , 8,10 , 36036,63 , 36099,82 , 9004,24 , 36181,60 , 36241,86 , 9004,24 , 19061,28 , 19089,61 , 19150,14 , 19164,28 , 19192,61 , 19150,14 , 537,15 , 556,15 , {71,69,76},  255,1 , 14092,17 , 13,5 , 4,0 , 5318,4 , 5322,11 ,     2,     1,     1,     6,     7 }, // Ossetic/Cyrillic/Georgia
    {    253,    29,   189,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 969,9 , 969,9 , 251,8 , 1654,23 , 18,5 , 8,10 , 36036,63 , 36099,82 , 9004,24 , 36181,60 , 36241,86 , 9004,24 , 19061,28 , 19089,61 , 19150,14 , 19164,28 , 19192,61 , 19150,14 , 537,15 , 556,15 , {82,85,66},  137,1 , 14109,17 , 13,5 , 4,0 , 5318,4 , 5333,6 ,     2,     1,     1,     6,     7 }, // Ossetic/Cyrillic/Russia
    {    257,    74,    62,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 36327,87 , 36327,87 , 158,27 , 36327,87 , 36327,87 , 158,27 , 19253,63 , 19253,63 , 85,14 , 19253,63 , 19253,63 , 85,14 , 0,2 , 0,2 , {65,78,71},  0,0 , 0,7 , 13,5 , 4,0 , 5339,10 , 5349,6 ,     2,     1,     1,     6,     7 }, // Papiamento/Latin/Curacao
    {    257,    74,    13,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 36327,87 , 36327,87 , 158,27 , 36327,87 , 36327,87 , 158,27 , 19253,63 , 19253,63 , 85,14 , 19253,63 , 19253,63 , 85,14 , 0,2 , 0,2 , {65,87,71},  0,0 , 0,7 , 13,5 , 4,0 , 5339,10 , 1263,5 ,     2,     1,     1,     6,     7 }, // Papiamento/Latin/Aruba
    {    259,     4,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 674,6 , 674,6 , 978,9 , 987,8 , 512,8 , 1677,20 , 74,4 , 245,11 , 36414,68 , 36482,69 , 158,27 , 36551,69 , 36551,69 , 36620,24 , 19316,39 , 19316,39 , 85,14 , 19316,39 , 19316,39 , 85,14 , 552,4 , 571,4 , {65,70,78},  305,1 , 14126,25 , 13,5 , 4,0 , 5355,4 , 5359,9 ,     0,     0,     6,     4,     5 }, // Pashto/Arabic/Afghanistan
    {    259,     4,   174,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 674,6 , 674,6 , 978,9 , 987,8 , 512,8 , 1677,20 , 55,7 , 62,12 , 36414,68 , 36482,69 , 158,27 , 36551,69 , 36551,69 , 36620,24 , 19316,39 , 19316,39 , 85,14 , 19316,39 , 19316,39 , 85,14 , 552,4 , 571,4 , {80,75,82},  129,2 , 14151,52 , 13,5 , 4,0 , 5355,4 , 543,7 ,     2,     0,     7,     6,     7 }, // Pashto/Arabic/Pakistan
    {    260,     4,   110,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,   171,   187,  8249,  8250, 995,7 , 995,7 , 1002,8 , 1010,7 , 512,8 , 113,16 , 74,4 , 245,11 , 30255,70 , 30255,70 , 36644,24 , 30255,70 , 36668,74 , 36644,24 , 19355,49 , 19355,49 , 19404,14 , 19355,49 , 19355,49 , 19404,14 , 556,9 , 575,8 , {73,82,82},  306,4 , 14203,37 , 94,5 , 4,0 , 5368,5 , 4823,5 ,     0,     0,     6,     5,     5 }, // Persian/Arabic/Iran
    {    260,     4,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,   171,   187,  8249,  8250, 995,7 , 995,7 , 1002,8 , 1010,7 , 512,8 , 113,16 , 74,4 , 245,11 , 36742,68 , 36742,68 , 36620,24 , 36810,62 , 36742,68 , 36620,24 , 19355,49 , 19355,49 , 19404,14 , 19355,49 , 19355,49 , 19404,14 , 556,9 , 575,8 , {65,70,78},  305,1 , 14240,55 , 13,5 , 4,0 , 5373,3 , 5359,9 ,     0,     0,     6,     4,     5 }, // Persian/Arabic/Afghanistan
    {    262,    74,   203,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 36872,77 , 36872,77 , 158,27 , 36872,77 , 36872,77 , 158,27 , 19418,47 , 19418,47 , 85,14 , 19418,47 , 19418,47 , 85,14 , 0,2 , 0,2 , {83,66,68},  10,1 , 0,7 , 13,5 , 4,0 , 5376,5 , 5381,13 ,     2,     1,     1,     6,     7 }, // Pijin/Latin/SolomonIslands
    {    263,    74,   183,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,   171,   187, 0,6 , 0,6 , 141,7 , 141,7 , 1697,9 , 10,17 , 18,5 , 8,10 , 36949,48 , 36997,97 , 37094,24 , 36949,48 , 37118,99 , 37217,24 , 19465,34 , 19499,59 , 19558,14 , 19465,34 , 19499,59 , 19572,14 , 0,2 , 0,2 , {80,76,78},  310,2 , 14295,77 , 4,5 , 4,0 , 5394,6 , 5400,6 ,     2,     1,     1,     6,     7 }, // Polish/Latin/Poland
    {    264,    74,    32,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 402,7 , 402,7 , 186,10 , 992,27 , 18,5 , 8,10 , 37241,60 , 37301,89 , 134,24 , 37241,60 , 37301,89 , 134,24 , 19586,35 , 19621,79 , 19700,14 , 19586,35 , 19621,79 , 19700,14 , 0,2 , 0,2 , {66,82,76},  267,2 , 14372,54 , 13,5 , 4,0 , 5406,9 , 5415,6 ,     2,     1,     7,     6,     7 }, // Portuguese/Latin/Brazil
    {    264,    74,     7,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 992,27 , 18,5 , 8,10 , 37241,60 , 37301,89 , 134,24 , 37241,60 , 37301,89 , 134,24 , 19714,49 , 19621,79 , 19700,14 , 19714,49 , 19621,79 , 19700,14 , 565,8 , 583,8 , {65,79,65},  280,2 , 14426,54 , 4,5 , 4,0 , 5406,9 , 5421,6 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/Angola
    {    264,    74,    43,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 992,27 , 18,5 , 8,10 , 37241,60 , 37301,89 , 134,24 , 37241,60 , 37301,89 , 134,24 , 19714,49 , 19621,79 , 19700,14 , 19714,49 , 19621,79 , 19700,14 , 565,8 , 583,8 , {67,86,69},  266,1 , 14480,69 , 4,5 , 4,0 , 5406,9 , 5427,10 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/CapeVerde
    {    264,    74,    73,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 992,27 , 18,5 , 8,10 , 37241,60 , 37301,89 , 134,24 , 37241,60 , 37301,89 , 134,24 , 19714,49 , 19621,79 , 19700,14 , 19714,49 , 19621,79 , 19700,14 , 565,8 , 583,8 , {88,65,70},  11,4 , 14549,59 , 4,5 , 4,0 , 5406,9 , 5437,16 ,     0,     0,     1,     6,     7 }, // Portuguese/Latin/EquatorialGuinea
    {    264,    74,   100,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 992,27 , 18,5 , 8,10 , 37241,60 , 37301,89 , 134,24 , 37241,60 , 37301,89 , 134,24 , 19714,49 , 19621,79 , 19700,14 , 19714,49 , 19621,79 , 19700,14 , 565,8 , 583,8 , {88,79,70},  131,5 , 14608,62 , 4,5 , 4,0 , 5406,9 , 5453,12 ,     0,     0,     1,     6,     7 }, // Portuguese/Latin/GuineaBissau
    {    264,    74,   135,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 992,27 , 18,5 , 8,10 , 37241,60 , 37301,89 , 134,24 , 37241,60 , 37301,89 , 134,24 , 19714,49 , 19621,79 , 19700,14 , 19714,49 , 19621,79 , 19700,14 , 565,8 , 583,8 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 5406,9 , 5465,10 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/Luxembourg
    {    264,    74,   136,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 992,27 , 23,7 , 30,12 , 37241,60 , 37301,89 , 134,24 , 37241,60 , 37301,89 , 134,24 , 19714,49 , 19621,79 , 19700,14 , 19714,49 , 19621,79 , 19700,14 , 565,8 , 583,8 , {77,79,80},  155,4 , 14670,54 , 4,5 , 4,0 , 5406,9 , 5475,19 ,     2,     1,     7,     6,     7 }, // Portuguese/Latin/Macao
    {    264,    74,   156,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 992,27 , 18,5 , 8,10 , 37241,60 , 37301,89 , 134,24 , 37241,60 , 37301,89 , 134,24 , 19714,49 , 19621,79 , 19700,14 , 19714,49 , 19621,79 , 19700,14 , 565,8 , 583,8 , {77,90,78},  286,3 , 14724,66 , 4,5 , 4,0 , 5406,9 , 5494,10 ,     2,     1,     7,     6,     7 }, // Portuguese/Latin/Mozambique
    {    264,    74,   184,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 992,27 , 18,5 , 8,10 , 37241,60 , 37301,89 , 134,24 , 37241,60 , 37301,89 , 134,24 , 19714,49 , 19621,79 , 19700,14 , 19714,49 , 19621,79 , 19700,14 , 565,8 , 583,8 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 5504,17 , 5521,8 ,     2,     1,     7,     6,     7 }, // Portuguese/Latin/Portugal
    {    264,    74,   193,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 992,27 , 18,5 , 8,10 , 37241,60 , 37301,89 , 134,24 , 37241,60 , 37301,89 , 134,24 , 19714,49 , 19621,79 , 19700,14 , 19714,49 , 19621,79 , 19700,14 , 565,8 , 583,8 , {83,84,78},  312,2 , 14790,92 , 4,5 , 4,0 , 5406,9 , 5529,19 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/SaoTomeAndPrincipe
    {    264,    74,   222,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 992,27 , 18,5 , 8,10 , 37241,60 , 37301,89 , 134,24 , 37241,60 , 37301,89 , 134,24 , 19714,49 , 19621,79 , 19700,14 , 19714,49 , 19621,79 , 19700,14 , 565,8 , 583,8 , {67,72,70},  234,3 , 14882,45 , 4,5 , 4,0 , 5406,9 , 5548,5 ,     2,     0,     1,     6,     7 }, // Portuguese/Latin/Switzerland
    {    264,    74,   228,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 59,8 , 992,27 , 18,5 , 8,10 , 37241,60 , 37301,89 , 134,24 , 37241,60 , 37301,89 , 134,24 , 19714,49 , 19621,79 , 19700,14 , 19714,49 , 19621,79 , 19700,14 , 565,8 , 583,8 , {85,83,68},  184,3 , 14927,81 , 4,5 , 4,0 , 5406,9 , 5553,11 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/TimorLeste
    {    265,    74,   254,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8220,  8222,  8220, 0,6 , 0,6 , 1017,8 , 1017,8 , 251,8 , 1706,27 , 18,5 , 8,10 , 37390,48 , 37438,91 , 37529,24 , 37390,48 , 37438,91 , 37529,24 , 19763,28 , 19791,69 , 19860,14 , 19763,28 , 19791,69 , 19860,14 , 0,2 , 0,2 , {0,0,0},  0,0 , 2547,0 , 4,5 , 4,0 , 5564,9 , 5573,6 ,     2,     1,     1,     6,     7 }, // Prussian/Latin/World
    {    266,    47,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1025,9 , 1025,9 , 223,6 , 10,17 , 55,7 , 62,12 , 37553,50 , 37603,68 , 37671,28 , 37553,50 , 37603,68 , 37671,28 , 19874,36 , 19910,57 , 19967,23 , 19874,36 , 19910,57 , 19967,23 , 573,6 , 591,6 , {73,78,82},  122,1 , 15008,39 , 9,4 , 4,0 , 5579,6 , 5585,4 ,     2,     1,     7,     7,     7 }, // Punjabi/Gurmukhi/India
    {    266,     4,   174,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 809,18 , 55,7 , 62,12 , 37699,67 , 37699,67 , 158,27 , 37699,67 , 37699,67 , 158,27 , 19990,37 , 19990,37 , 85,14 , 19990,37 , 19990,37 , 85,14 , 0,2 , 0,2 , {80,75,82},  314,1 , 15047,13 , 24,6 , 4,0 , 5589,6 , 543,7 ,     2,     0,     7,     6,     7 }, // Punjabi/Arabic/Pakistan
    {    267,    74,   180,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1034,11 , 1045,10 , 186,10 , 287,18 , 18,5 , 8,10 , 37766,48 , 37814,88 , 158,27 , 37766,48 , 37814,88 , 158,27 , 20027,28 , 20055,53 , 20108,14 , 20027,28 , 20055,53 , 20108,14 , 168,4 , 168,4 , {80,69,78},  315,2 , 15060,29 , 13,5 , 4,0 , 5595,8 , 5603,4 ,     2,     1,     7,     6,     7 }, // Quechua/Latin/Peru
    {    267,    74,    28,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1034,11 , 1045,10 , 186,10 , 287,18 , 18,5 , 8,10 , 37766,48 , 37814,88 , 158,27 , 37766,48 , 37814,88 , 158,27 , 20027,28 , 20055,53 , 20108,14 , 20027,28 , 20055,53 , 20108,14 , 168,4 , 168,4 , {66,79,66},  317,2 , 15089,25 , 13,5 , 4,0 , 5595,8 , 5607,7 ,     2,     1,     1,     6,     7 }, // Quechua/Latin/Bolivia
    {    267,    74,    70,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1034,11 , 1045,10 , 186,10 , 287,18 , 18,5 , 8,10 , 37766,48 , 37814,88 , 158,27 , 37766,48 , 37814,88 , 158,27 , 20027,28 , 20055,53 , 20108,14 , 20027,28 , 20055,53 , 20108,14 , 168,4 , 168,4 , {85,83,68},  10,1 , 15114,37 , 13,5 , 4,0 , 5595,8 , 5614,7 ,     2,     1,     1,     6,     7 }, // Quechua/Latin/Ecuador
    {    268,    31,   108,    46,    44,    59,    37,  2406,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 55,7 , 62,12 , 6177,73 , 6177,73 , 158,27 , 6177,73 , 6177,73 , 158,27 , 9151,53 , 9151,53 , 85,14 , 9151,53 , 9151,53 , 85,14 , 579,5 , 597,4 , {73,78,82},  122,1 , 0,7 , 13,5 , 4,0 , 5621,9 , 691,4 ,     2,     1,     7,     7,     7 }, // Rajasthani/Devanagari/India
    {    270,    50,   157,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 74,4 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {77,77,75},  138,1 , 0,7 , 13,5 , 4,0 , 5630,18 , 0,0 ,     0,     0,     7,     6,     7 }, // Rohingya/Hanifi Rohingya/Myanmar
    {    270,    50,    20,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 55,7 , 62,12 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {66,68,84},  136,1 , 0,7 , 13,5 , 4,0 , 5630,18 , 0,0 ,     2,     1,     7,     6,     7 }, // Rohingya/Hanifi Rohingya/Bangladesh
    {    271,    74,   188,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8221,   171,   187, 0,6 , 0,6 , 1055,8 , 1055,8 , 27,10 , 10,17 , 18,5 , 8,10 , 37902,60 , 37962,98 , 38060,24 , 37902,60 , 37962,98 , 38060,24 , 20122,34 , 20156,48 , 7187,14 , 20122,34 , 20156,48 , 7187,14 , 168,4 , 168,4 , {82,79,78},  319,3 , 15151,57 , 4,5 , 4,0 , 5648,6 , 5654,7 ,     2,     1,     1,     6,     7 }, // Romanian/Latin/Romania
    {    271,    74,   150,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8221,   171,   187, 0,6 , 0,6 , 1055,8 , 1055,8 , 27,10 , 10,17 , 18,5 , 8,10 , 37902,60 , 37962,98 , 38060,24 , 37902,60 , 37962,98 , 38060,24 , 20204,28 , 20156,48 , 20232,16 , 20204,28 , 20156,48 , 20232,16 , 168,4 , 168,4 , {77,68,76},  322,1 , 15208,69 , 4,5 , 4,0 , 5648,6 , 5661,17 ,     2,     1,     1,     6,     7 }, // Romanian/Latin/Moldova
    {    272,    74,   222,    46,  8217,    59,    37,    48,  8722,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 402,7 , 402,7 , 1733,8 , 1741,23 , 18,5 , 8,10 , 38084,67 , 38151,92 , 38243,24 , 38084,67 , 38267,125 , 38243,24 , 20248,23 , 20271,56 , 20327,14 , 20248,23 , 20271,56 , 20327,14 , 0,2 , 0,2 , {67,72,70},  234,3 , 15277,48 , 4,5 , 4,0 , 5678,9 , 5687,6 ,     2,     0,     1,     6,     7 }, // Romansh/Latin/Switzerland
    {    273,    74,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 38392,39 , 38431,194 , 38625,24 , 38392,39 , 38431,194 , 38625,24 , 20341,29 , 20370,65 , 15050,14 , 20341,29 , 20370,65 , 15050,14 , 584,8 , 601,7 , {84,90,83},  123,3 , 15325,25 , 9,4 , 4,0 , 5693,9 , 2315,8 ,     2,     0,     1,     6,     7 }, // Rombo/Latin/Tanzania
    {    274,    74,    38,    44,    46,    59,    37,    48,    45,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 38649,60 , 38709,106 , 158,27 , 38649,60 , 38709,106 , 158,27 , 20435,34 , 20469,89 , 85,14 , 20435,34 , 20469,89 , 85,14 , 592,5 , 608,5 , {66,73,70},  187,3 , 15350,27 , 0,4 , 4,0 , 5702,8 , 5710,8 ,     0,     0,     1,     6,     7 }, // Rundi/Latin/Burundi
    {    275,    29,   189,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 148,7 , 148,7 , 27,10 , 371,22 , 18,5 , 8,10 , 38815,62 , 8924,80 , 9004,24 , 38877,62 , 38939,82 , 9004,24 , 20558,21 , 20579,62 , 20641,14 , 20558,21 , 20579,62 , 20641,14 , 0,2 , 0,2 , {82,85,66},  137,1 , 15377,89 , 4,5 , 4,0 , 5718,7 , 5725,6 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Russia
    {    275,    29,    22,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 148,7 , 148,7 , 27,10 , 371,22 , 18,5 , 8,10 , 38815,62 , 8924,80 , 9004,24 , 38877,62 , 38939,82 , 9004,24 , 20558,21 , 20579,62 , 20641,14 , 20558,21 , 20579,62 , 20641,14 , 0,2 , 0,2 , {66,89,78},  1,2 , 15466,94 , 4,5 , 4,0 , 5718,7 , 645,8 ,     2,     0,     1,     6,     7 }, // Russian/Cyrillic/Belarus
    {    275,    29,   121,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 148,7 , 148,7 , 27,10 , 371,22 , 18,5 , 8,10 , 38815,62 , 8924,80 , 9004,24 , 38877,62 , 38939,82 , 9004,24 , 20558,21 , 20579,62 , 20641,14 , 20558,21 , 20579,62 , 20641,14 , 0,2 , 0,2 , {75,90,84},  269,1 , 15560,83 , 4,5 , 4,0 , 5718,7 , 5731,9 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Kazakhstan
    {    275,    29,   126,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 148,7 , 148,7 , 27,10 , 371,22 , 18,5 , 8,10 , 38815,62 , 8924,80 , 9004,24 , 38877,62 , 38939,82 , 9004,24 , 20558,21 , 20579,62 , 20641,14 , 20558,21 , 20579,62 , 20641,14 , 0,2 , 0,2 , {75,71,83},  276,3 , 15643,82 , 4,5 , 4,0 , 5718,7 , 5740,8 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Kyrgyzstan
    {    275,    29,   150,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 148,7 , 148,7 , 27,10 , 371,22 , 18,5 , 8,10 , 38815,62 , 8924,80 , 9004,24 , 38877,62 , 38939,82 , 9004,24 , 20558,21 , 20579,62 , 20641,14 , 20558,21 , 20579,62 , 20641,14 , 0,2 , 0,2 , {77,68,76},  322,1 , 15725,79 , 4,5 , 4,0 , 5718,7 , 5748,7 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Moldova
    {    275,    29,   240,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 148,7 , 148,7 , 27,10 , 371,22 , 18,5 , 8,10 , 38815,62 , 8924,80 , 9004,24 , 38877,62 , 38939,82 , 9004,24 , 20558,21 , 20579,62 , 20641,14 , 20558,21 , 20579,62 , 20641,14 , 0,2 , 0,2 , {85,65,72},  323,1 , 15804,92 , 4,5 , 4,0 , 5718,7 , 5755,7 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Ukraine
    {    276,    74,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 27542,48 , 27590,87 , 134,24 , 27542,48 , 27590,87 , 134,24 , 14634,28 , 14662,62 , 1353,14 , 14634,28 , 14662,62 , 1353,14 , 430,5 , 441,9 , {84,90,83},  123,3 , 12712,27 , 0,4 , 4,0 , 5762,6 , 2315,8 ,     2,     0,     1,     6,     7 }, // Rwa/Latin/Tanzania
    {    278,    74,    74,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 67,19 , 23,7 , 30,12 , 400,48 , 448,118 , 566,24 , 400,48 , 448,118 , 566,24 , 20655,28 , 20683,56 , 20739,14 , 20655,28 , 20683,56 , 20739,14 , 0,2 , 0,2 , {69,82,78},  6,3 , 0,7 , 9,4 , 4,0 , 5768,4 , 34,7 ,     2,     1,     1,     6,     7 }, // Saho/Latin/Eritrea
    {    279,    29,   189,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 1063,11 , 1063,11 , 322,6 , 1764,30 , 18,5 , 8,10 , 39021,50 , 39071,116 , 39187,24 , 39021,50 , 39211,121 , 39187,24 , 20753,21 , 20774,71 , 20845,14 , 20753,21 , 20774,71 , 20845,14 , 597,2 , 613,2 , {82,85,66},  137,1 , 15896,47 , 4,5 , 4,0 , 5772,9 , 5781,9 ,     2,     1,     1,     6,     7 }, // Sakha/Cyrillic/Russia
    {    281,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 39332,48 , 39380,173 , 39553,24 , 39332,48 , 39380,173 , 39553,24 , 20859,28 , 20887,105 , 20992,14 , 20859,28 , 20887,105 , 20992,14 , 599,7 , 615,5 , {75,69,83},  180,3 , 15943,25 , 9,4 , 4,0 , 5790,8 , 1343,5 ,     2,     1,     7,     6,     7 }, // Samburu/Latin/Kenya
    {    283,    74,    46,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 39577,48 , 39625,91 , 39716,24 , 39577,48 , 39625,91 , 39716,24 , 21006,28 , 21034,66 , 21100,14 , 21006,28 , 21034,66 , 21100,14 , 606,2 , 620,2 , {88,65,70},  11,4 , 15968,25 , 9,4 , 48,5 , 5798,5 , 5803,22 ,     0,     0,     1,     6,     7 }, // Sango/Latin/CentralAfricanRepublic
    {    284,    74,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 39740,48 , 39788,117 , 158,27 , 39740,48 , 39788,117 , 158,27 , 21114,28 , 21142,60 , 21202,14 , 21114,28 , 21142,60 , 21202,14 , 608,9 , 622,9 , {84,90,83},  123,3 , 15993,25 , 0,4 , 4,0 , 5825,9 , 5834,9 ,     2,     0,     1,     6,     7 }, // Sangu/Latin/Tanzania
    {    285,    31,   108,    46,    44,    59,    37,  2406,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1074,10 , 1084,9 , 223,6 , 10,17 , 55,7 , 62,12 , 39905,83 , 39988,120 , 158,27 , 39905,83 , 39988,120 , 27807,29 , 9119,32 , 21216,67 , 9204,19 , 9119,32 , 21216,67 , 9204,19 , 484,9 , 500,7 , {73,78,82},  122,1 , 16018,37 , 9,4 , 4,0 , 5843,12 , 5855,5 ,     2,     1,     7,     7,     7 }, // Sanskrit/Devanagari/India
    {    286,   108,   108,    46,    44,    59,    37,  7248,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1093,16 , 1109,15 , 223,6 , 10,17 , 55,7 , 62,12 , 40108,47 , 40155,83 , 40238,24 , 40108,47 , 40155,83 , 40238,24 , 21283,26 , 21309,42 , 21351,14 , 21283,26 , 21309,42 , 21351,14 , 617,5 , 631,5 , {73,78,82},  122,1 , 16055,71 , 13,5 , 4,0 , 5860,7 , 5867,6 ,     2,     1,     7,     7,     7 }, // Santali/Ol Chiki/India
    {    286,    31,   108,    46,    44,    59,    37,  2406,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 223,6 , 10,17 , 55,7 , 62,12 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {73,78,82},  122,1 , 0,7 , 13,5 , 4,0 , 5873,8 , 0,0 ,     2,     1,     7,     7,     7 }, // Santali/Devanagari/India
    {    287,    74,   115,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 402,7 , 402,7 , 186,10 , 1794,31 , 18,5 , 8,10 , 40262,48 , 40310,101 , 40411,24 , 40262,48 , 40310,101 , 40411,24 , 21365,28 , 21393,55 , 21448,14 , 21365,28 , 21393,55 , 21448,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 16126,20 , 4,5 , 4,0 , 5881,5 , 840,6 ,     2,     1,     1,     6,     7 }, // Sardinian/Latin/Italy
    {    289,    74,   156,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 992,27 , 18,5 , 8,10 , 40435,48 , 40483,88 , 134,24 , 40435,48 , 40483,88 , 134,24 , 21462,28 , 21490,55 , 21545,14 , 21462,28 , 21490,55 , 21545,14 , 0,2 , 0,2 , {77,90,78},  286,3 , 16146,28 , 0,4 , 4,0 , 5886,4 , 5494,10 ,     2,     1,     7,     6,     7 }, // Sena/Latin/Mozambique
    {    290,    29,   196,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 148,7 , 148,7 , 455,7 , 436,19 , 18,5 , 8,10 , 40571,48 , 40619,81 , 6849,24 , 40571,48 , 40619,81 , 6849,24 , 21559,28 , 21587,52 , 3174,14 , 21559,28 , 21587,52 , 3174,14 , 0,2 , 0,2 , {82,83,68},  324,3 , 16174,58 , 4,5 , 4,0 , 5890,6 , 5896,6 ,     0,     0,     1,     6,     7 }, // Serbian/Cyrillic/Serbia
    {    290,    29,    29,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 148,7 , 148,7 , 455,7 , 436,19 , 18,5 , 8,10 , 40571,48 , 40619,81 , 6849,24 , 40571,48 , 40619,81 , 6849,24 , 3090,28 , 3118,56 , 3174,14 , 3090,28 , 3118,56 , 3174,14 , 104,11 , 636,8 , {66,65,77},  141,2 , 16232,170 , 4,5 , 4,0 , 5890,6 , 740,19 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/BosniaAndHerzegowina
    {    290,    29,   124,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 148,7 , 148,7 , 455,7 , 436,19 , 18,5 , 8,10 , 40700,50 , 40619,81 , 6849,24 , 40700,50 , 40619,81 , 6849,24 , 21559,28 , 21587,52 , 3174,14 , 21559,28 , 21587,52 , 3174,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 16402,23 , 4,5 , 4,0 , 5890,6 , 5902,6 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/Kosovo
    {    290,    29,   153,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 148,7 , 148,7 , 455,7 , 436,19 , 18,5 , 8,10 , 40700,50 , 40619,81 , 6849,24 , 40700,50 , 40619,81 , 6849,24 , 21559,28 , 21639,55 , 3174,14 , 21559,28 , 21639,55 , 3174,14 , 104,11 , 636,8 , {69,85,82},  22,1 , 16402,23 , 4,5 , 4,0 , 5890,6 , 5908,9 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/Montenegro
    {    290,    74,    29,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 141,7 , 141,7 , 455,7 , 436,19 , 18,5 , 8,10 , 40750,48 , 40798,81 , 6694,24 , 40750,48 , 40798,81 , 6694,24 , 2976,28 , 3004,58 , 3062,14 , 2976,28 , 3004,58 , 3062,14 , 622,11 , 644,8 , {66,65,77},  139,2 , 3203,170 , 4,5 , 4,0 , 5917,6 , 713,19 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/BosniaAndHerzegowina
    {    290,    74,   124,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 141,7 , 141,7 , 455,7 , 436,19 , 18,5 , 8,10 , 40879,50 , 40798,81 , 6694,24 , 40879,50 , 40798,81 , 6694,24 , 21694,28 , 21722,54 , 3062,14 , 21694,28 , 21722,54 , 3062,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 16425,23 , 4,5 , 4,0 , 5917,6 , 5923,6 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/Kosovo
    {    290,    74,   153,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 141,7 , 141,7 , 455,7 , 436,19 , 18,5 , 8,10 , 40879,50 , 40798,81 , 6694,24 , 40879,50 , 40798,81 , 6694,24 , 21694,28 , 21776,57 , 3062,14 , 21694,28 , 21776,57 , 3062,14 , 622,11 , 644,8 , {69,85,82},  22,1 , 16425,23 , 4,5 , 4,0 , 5917,6 , 5929,9 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/Montenegro
    {    290,    74,   196,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 141,7 , 141,7 , 455,7 , 436,19 , 18,5 , 8,10 , 40750,48 , 40798,81 , 6694,24 , 40750,48 , 40798,81 , 6694,24 , 21694,28 , 21722,54 , 3062,14 , 21694,28 , 21722,54 , 3062,14 , 0,2 , 0,2 , {82,83,68},  324,3 , 16448,58 , 4,5 , 4,0 , 5917,6 , 5938,6 ,     0,     0,     1,     6,     7 }, // Serbian/Latin/Serbia
    {    291,    74,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 27542,48 , 40929,84 , 134,24 , 27542,48 , 40929,84 , 134,24 , 21833,28 , 21861,63 , 21924,14 , 21833,28 , 21861,63 , 21924,14 , 633,5 , 652,8 , {84,90,83},  123,3 , 16506,27 , 0,4 , 4,0 , 5944,9 , 2315,8 ,     2,     0,     1,     6,     7 }, // Shambala/Latin/Tanzania
    {    292,    74,   257,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 41013,48 , 41061,100 , 41161,24 , 41013,48 , 41061,100 , 41161,24 , 21938,28 , 21966,55 , 22021,14 , 21938,28 , 21966,55 , 22021,14 , 0,2 , 0,2 , {85,83,68},  184,3 , 16533,22 , 9,4 , 4,0 , 5953,8 , 2481,8 ,     2,     1,     7,     6,     7 }, // Shona/Latin/Zimbabwe
    {    293,   165,    50,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 41185,38 , 41185,38 , 158,27 , 41185,38 , 41185,38 , 158,27 , 22035,21 , 22056,28 , 22084,14 , 22035,21 , 22056,28 , 22084,14 , 638,2 , 660,2 , {67,78,89},  154,1 , 0,7 , 13,5 , 4,0 , 5961,3 , 5964,2 ,     2,     1,     1,     6,     7 }, // Sichuan Yi/Yi/China
    {    294,    74,   115,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 41223,48 , 41271,98 , 41369,24 , 41223,48 , 41271,98 , 41369,24 , 22098,63 , 22098,63 , 85,14 , 22098,63 , 22098,63 , 85,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 0,7 , 13,5 , 4,0 , 5966,9 , 3856,6 ,     2,     1,     1,     6,     7 }, // Sicilian/Latin/Italy
    {    295,    74,    77,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 67,19 , 23,7 , 30,12 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 22161,28 , 22189,51 , 22240,14 , 22161,28 , 22189,51 , 22240,14 , 0,2 , 0,2 , {69,84,66},  1,2 , 0,7 , 9,4 , 4,0 , 5975,11 , 5986,11 ,     2,     1,     7,     6,     7 }, // Sidamo/Latin/Ethiopia
    {    296,    74,   183,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,   187,   171, 0,6 , 0,6 , 141,7 , 141,7 , 27,10 , 10,17 , 18,5 , 8,10 , 41393,48 , 41441,97 , 37094,24 , 41393,48 , 41538,99 , 37094,24 , 22254,28 , 22282,61 , 14104,14 , 22254,28 , 22282,61 , 14104,14 , 640,11 , 662,11 , {80,76,78},  310,2 , 0,7 , 13,5 , 4,0 , 5997,7 , 5400,6 ,     2,     1,     1,     6,     7 }, // Silesian/Latin/Poland
    {    297,     4,   174,  1643,  1644,  1563,    37,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1124,8 , 1132,7 , 86,10 , 553,18 , 55,7 , 62,12 , 41637,72 , 41637,72 , 134,24 , 41637,72 , 41637,72 , 134,24 , 22343,35 , 22343,35 , 22378,31 , 22343,35 , 22343,35 , 22378,31 , 651,11 , 673,11 , {80,75,82},  129,2 , 16555,43 , 13,5 , 4,0 , 6004,4 , 6008,7 ,     2,     0,     7,     6,     7 }, // Sindhi/Arabic/Pakistan
    {    297,    31,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 547,6 , 553,18 , 55,7 , 62,12 , 41709,54 , 41763,75 , 41838,30 , 41868,52 , 41920,75 , 41995,31 , 22409,23 , 22432,28 , 22460,21 , 22481,29 , 22510,42 , 22460,21 , 662,8 , 684,6 , {73,78,82},  122,1 , 16598,58 , 13,5 , 4,0 , 6015,6 , 691,4 ,     2,     1,     7,     7,     7 }, // Sindhi/Devanagari/India
    {    298,   136,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1139,9 , 1148,8 , 86,10 , 163,17 , 294,5 , 299,10 , 42026,59 , 42085,96 , 42181,32 , 42213,61 , 42085,96 , 42181,32 , 22552,39 , 22591,62 , 22653,19 , 22552,39 , 22591,62 , 22653,19 , 670,5 , 690,4 , {76,75,82},  327,3 , 16656,58 , 9,4 , 4,0 , 6021,5 , 6026,11 ,     2,     1,     1,     6,     7 }, // Sinhala/Sinhala/SriLanka
    {    299,    74,    81,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 0,7 , 13,5 , 4,0 , 6037,10 , 6047,12 ,     2,     1,     1,     6,     7 }, // Skolt Sami/Latin/Finland
    {    300,    74,   201,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 794,7 , 279,7 , 626,10 , 706,17 , 74,4 , 78,9 , 42274,48 , 42322,82 , 6694,24 , 42274,48 , 42404,89 , 6694,24 , 22672,21 , 22693,52 , 22745,14 , 22672,21 , 22693,52 , 22745,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 16714,26 , 4,5 , 4,0 , 6059,10 , 6069,9 ,     2,     1,     1,     6,     7 }, // Slovak/Latin/Slovakia
    {    301,    74,   202,    44,    46,    59,    37,    48,  8722,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 1156,8 , 1156,8 , 1825,9 , 878,18 , 18,5 , 8,10 , 42493,59 , 42552,86 , 6694,24 , 42493,59 , 42552,86 , 6694,24 , 22759,35 , 22794,52 , 22846,14 , 22759,35 , 22794,52 , 22846,14 , 172,4 , 694,4 , {69,85,82},  22,1 , 16740,28 , 4,5 , 4,0 , 6078,11 , 6089,9 ,     2,     1,     1,     6,     7 }, // Slovenian/Latin/Slovenia
    {    302,    74,   239,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 16502,48 , 16550,97 , 134,24 , 16502,48 , 16550,97 , 134,24 , 22860,35 , 22895,65 , 22960,14 , 22860,35 , 22895,65 , 22960,14 , 675,6 , 698,6 , {85,71,88},  151,3 , 10734,26 , 4,5 , 4,0 , 6098,7 , 3404,7 ,     0,     0,     1,     7,     7 }, // Soga/Latin/Uganda
    {    303,    74,   204,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1164,9 , 1164,9 , 59,8 , 553,18 , 23,7 , 30,12 , 42638,48 , 42686,97 , 42783,24 , 42638,48 , 42807,189 , 42783,24 , 22974,32 , 23006,47 , 23053,15 , 22974,32 , 23006,47 , 23053,15 , 681,2 , 704,2 , {83,79,83},  95,1 , 16768,67 , 9,4 , 4,0 , 6105,8 , 6113,10 ,     0,     0,     1,     6,     7 }, // Somali/Latin/Somalia
    {    303,    74,    67,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1164,9 , 1164,9 , 59,8 , 553,18 , 23,7 , 30,12 , 42638,48 , 42686,97 , 42783,24 , 42638,48 , 42807,189 , 42783,24 , 22974,32 , 23006,47 , 23053,15 , 22974,32 , 23006,47 , 23053,15 , 681,2 , 704,2 , {68,74,70},  3,3 , 16835,50 , 9,4 , 4,0 , 6105,8 , 6123,7 ,     0,     0,     6,     6,     7 }, // Somali/Latin/Djibouti
    {    303,    74,    77,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1164,9 , 1164,9 , 59,8 , 553,18 , 23,7 , 30,12 , 42638,48 , 42686,97 , 42783,24 , 42638,48 , 42807,189 , 42783,24 , 22974,32 , 23006,47 , 23053,15 , 22974,32 , 23006,47 , 23053,15 , 681,2 , 704,2 , {69,84,66},  1,2 , 16885,52 , 9,4 , 4,0 , 6105,8 , 6130,8 ,     2,     1,     7,     6,     7 }, // Somali/Latin/Ethiopia
    {    303,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1164,9 , 1164,9 , 59,8 , 553,18 , 18,5 , 8,10 , 42638,48 , 42686,97 , 42783,24 , 42638,48 , 42807,189 , 42783,24 , 22974,32 , 23006,47 , 23053,15 , 22974,32 , 23006,47 , 23053,15 , 681,2 , 704,2 , {75,69,83},  180,3 , 16937,52 , 9,4 , 4,0 , 6105,8 , 1343,5 ,     2,     1,     7,     6,     7 }, // Somali/Latin/Kenya
    {    305,    74,   205,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 42996,48 , 43044,100 , 158,27 , 42996,48 , 43044,100 , 158,27 , 23068,27 , 23095,66 , 85,14 , 23068,27 , 23095,66 , 85,14 , 0,2 , 0,2 , {90,65,82},  9,1 , 0,7 , 9,4 , 4,0 , 5073,10 , 0,0 ,     2,     1,     7,     6,     7 }, // South Ndebele/Latin/SouthAfrica
    {    306,     4,   110,  1643,  1644,  1563,    37,  1632,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {73,82,82},  0,0 , 0,7 , 13,5 , 4,0 , 6138,11 , 0,0 ,     0,     0,     6,     5,     5 }, // Southern Kurdish/Arabic/Iran
    {    306,     4,   111,  1643,  1644,  1563,    37,  1632,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {73,81,68},  0,0 , 0,7 , 13,5 , 4,0 , 6138,11 , 0,0 ,     0,     0,     6,     5,     6 }, // Southern Kurdish/Arabic/Iraq
    {    307,    74,   221,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {83,69,75},  209,2 , 0,7 , 13,5 , 4,0 , 6149,19 , 0,0 ,     2,     0,     1,     6,     7 }, // Southern Sami/Latin/Sweden
    {    307,    74,   172,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {78,79,75},  209,2 , 0,7 , 13,5 , 4,0 , 6149,19 , 0,0 ,     2,     0,     1,     6,     7 }, // Southern Sami/Latin/Norway
    {    308,    74,   205,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 43144,48 , 43192,105 , 158,27 , 43144,48 , 43192,105 , 158,27 , 23161,27 , 23188,61 , 85,14 , 23161,27 , 23188,61 , 85,14 , 0,2 , 0,2 , {90,65,82},  9,1 , 0,7 , 9,4 , 4,0 , 6168,7 , 0,0 ,     2,     1,     7,     6,     7 }, // Southern Sotho/Latin/SouthAfrica
    {    308,    74,   130,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 23,7 , 30,12 , 43144,48 , 43192,105 , 158,27 , 43144,48 , 43192,105 , 158,27 , 23161,27 , 23188,61 , 85,14 , 23161,27 , 23188,61 , 85,14 , 0,2 , 0,2 , {90,65,82},  9,1 , 0,7 , 9,4 , 4,0 , 6168,7 , 0,0 ,     2,     1,     1,     6,     7 }, // Southern Sotho/Latin/Lesotho
    {    309,    74,   209,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 74,4 , 245,11 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 20108,14 , 23249,28 , 23277,53 , 20108,14 , 132,5 , 128,5 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 6175,17 , 455,6 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Spain
    {    309,    74,    11,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 18,5 , 8,10 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {65,82,83},  10,1 , 16989,51 , 13,5 , 4,0 , 6192,7 , 6199,9 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Argentina
    {    309,    74,    24,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 18,5 , 8,10 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {66,90,68},  10,1 , 17040,52 , 9,4 , 4,0 , 6192,7 , 6208,6 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Belize
    {    309,    74,    28,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 18,5 , 8,10 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {66,79,66},  317,2 , 17092,35 , 9,4 , 4,0 , 6192,7 , 5607,7 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Bolivia
    {    309,    74,    32,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 18,5 , 8,10 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {66,82,76},  267,2 , 17127,52 , 9,4 , 4,0 , 6192,7 , 5415,6 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Brazil
    {    309,    74,    42,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 74,4 , 245,11 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 20108,14 , 23249,28 , 23277,53 , 20108,14 , 132,5 , 128,5 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 6192,7 , 6214,8 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/CanaryIslands
    {    309,    74,    47,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 74,4 , 245,11 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 20108,14 , 23249,28 , 23277,53 , 20108,14 , 132,5 , 128,5 , {69,85,82},  22,1 , 2617,20 , 4,5 , 4,0 , 6192,7 , 6222,15 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/CeutaAndMelilla
    {    309,    74,    49,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 1733,8 , 992,27 , 18,5 , 8,10 , 43459,61 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {67,76,80},  10,1 , 17179,45 , 9,4 , 48,5 , 6192,7 , 6237,5 ,     0,     0,     1,     6,     7 }, // Spanish/Latin/Chile
    {    309,    74,    54,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 827,7 , 992,27 , 23,7 , 30,12 , 43459,61 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 10062,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {67,79,80},  10,1 , 17224,54 , 13,5 , 4,0 , 6192,7 , 6242,8 ,     2,     0,     7,     6,     7 }, // Spanish/Latin/Colombia
    {    309,    74,    59,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 18,5 , 8,10 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {67,82,67},  330,1 , 17278,67 , 9,4 , 4,0 , 6192,7 , 6250,10 ,     2,     0,     1,     6,     7 }, // Spanish/Latin/CostaRica
    {    309,    74,    61,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 18,5 , 8,10 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {67,85,80},  10,1 , 17345,42 , 9,4 , 4,0 , 6192,7 , 6260,4 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Cuba
    {    309,    74,    69,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 23,7 , 30,12 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {68,79,80},  331,3 , 17387,54 , 9,4 , 59,6 , 6192,7 , 6264,20 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/DominicanRepublic
    {    309,    74,    70,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 18,5 , 8,10 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {85,83,68},  10,1 , 17441,70 , 9,4 , 48,5 , 6192,7 , 5614,7 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Ecuador
    {    309,    74,    72,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 18,5 , 8,10 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {85,83,68},  10,1 , 17441,70 , 9,4 , 4,0 , 6192,7 , 6284,11 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/ElSalvador
    {    309,    74,    73,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 74,4 , 245,11 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 20108,14 , 23249,28 , 23277,53 , 20108,14 , 132,5 , 128,5 , {88,65,70},  11,4 , 17511,92 , 9,4 , 4,0 , 6192,7 , 6295,17 ,     0,     0,     1,     6,     7 }, // Spanish/Latin/EquatorialGuinea
    {    309,    74,    97,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 827,7 , 992,27 , 18,5 , 8,10 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {71,84,81},  271,1 , 17603,30 , 30,5 , 4,0 , 6192,7 , 6312,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Guatemala
    {    309,    74,   104,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 1834,27 , 18,5 , 8,10 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {72,78,76},  322,1 , 17633,60 , 9,4 , 4,0 , 6192,7 , 6321,8 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Honduras
    {    309,    74,   148,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 59,8 , 992,27 , 18,5 , 8,10 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {77,88,78},  10,1 , 17693,48 , 53,6 , 4,0 , 6329,17 , 6346,6 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Mexico
    {    309,    74,   164,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 18,5 , 8,10 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {78,73,79},  334,2 , 17741,69 , 9,4 , 4,0 , 6192,7 , 6352,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Nicaragua
    {    309,    74,   177,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 1861,8 , 992,27 , 23,7 , 30,12 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {80,65,66},  336,3 , 17810,54 , 9,4 , 4,0 , 6192,7 , 6361,6 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Panama
    {    309,    74,   179,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 18,5 , 8,10 , 43459,61 , 43346,89 , 43435,24 , 43459,61 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {80,89,71},  339,3 , 17864,61 , 13,5 , 35,6 , 6192,7 , 6367,8 ,     0,     0,     7,     6,     7 }, // Spanish/Latin/Paraguay
    {    309,    74,   180,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 827,7 , 992,27 , 18,5 , 8,10 , 43520,60 , 37814,88 , 43435,24 , 43580,60 , 43640,88 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {80,69,78},  315,2 , 17925,43 , 13,5 , 4,0 , 6192,7 , 5603,4 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Peru
    {    309,    74,   181,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 23,7 , 30,12 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 20108,14 , 23249,28 , 23277,53 , 20108,14 , 132,5 , 128,5 , {80,72,80},  150,1 , 17968,48 , 4,5 , 4,0 , 6192,7 , 6375,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Philippines
    {    309,    74,   185,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 1861,8 , 992,27 , 23,7 , 30,12 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {85,83,68},  10,1 , 17441,70 , 9,4 , 4,0 , 6192,7 , 2122,11 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/PuertoRico
    {    309,    74,   243,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 66,7 , 66,7 , 129,8 , 992,27 , 23,7 , 30,12 , 43297,49 , 43346,89 , 43435,24 , 43297,49 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {85,83,68},  10,1 , 17441,70 , 99,6 , 4,0 , 6192,7 , 6384,14 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/UnitedStates
    {    309,    74,   246,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 18,5 , 8,10 , 43520,60 , 37814,88 , 43435,24 , 43580,60 , 43640,88 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {85,89,85},  10,1 , 18016,48 , 13,5 , 4,0 , 6192,7 , 6398,7 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Uruguay
    {    309,    74,   250,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 66,7 , 66,7 , 223,6 , 992,27 , 23,7 , 30,12 , 43459,61 , 43346,89 , 43435,24 , 43459,61 , 43346,89 , 43435,24 , 23249,28 , 23277,53 , 7187,14 , 23249,28 , 23277,53 , 7187,14 , 132,5 , 128,5 , {86,69,83},  300,4 , 18064,58 , 9,4 , 48,5 , 6192,7 , 6405,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Venezuela
    {    310,   155,   155,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 43728,48 , 43776,81 , 43857,24 , 43728,48 , 43776,81 , 43857,24 , 23330,30 , 23360,48 , 85,14 , 23330,30 , 23360,48 , 85,14 , 683,6 , 706,8 , {77,65,68},  0,0 , 18122,21 , 0,4 , 4,0 , 6414,8 , 6422,6 ,     2,     1,     1,     6,     7 }, // Standard Moroccan Tamazight/Tifinagh/Morocco
    {    311,    74,   109,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1173,13 , 1186,12 , 223,6 , 10,17 , 358,4 , 362,9 , 43881,48 , 43929,87 , 44016,24 , 43881,48 , 43929,87 , 44016,24 , 23408,28 , 23436,44 , 9963,14 , 23408,28 , 23436,44 , 9963,14 , 0,2 , 0,2 , {73,68,82},  261,2 , 18143,37 , 9,4 , 4,0 , 6428,10 , 3783,9 ,     2,     0,     7,     6,     7 }, // Sundanese/Latin/Indonesia
    {    312,    74,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 570,8 , 570,8 , 186,10 , 10,17 , 18,5 , 8,10 , 27542,48 , 3386,84 , 134,24 , 27542,48 , 3386,84 , 134,24 , 1293,60 , 1293,60 , 85,14 , 1293,60 , 1293,60 , 85,14 , 0,2 , 0,2 , {84,90,83},  123,3 , 18180,67 , 13,5 , 4,0 , 6438,9 , 2315,8 ,     2,     0,     1,     6,     7 }, // Swahili/Latin/Tanzania
    {    312,    74,    57,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 570,8 , 570,8 , 186,10 , 10,17 , 18,5 , 8,10 , 27542,48 , 3386,84 , 134,24 , 27542,48 , 3386,84 , 134,24 , 1293,60 , 1293,60 , 85,14 , 1293,60 , 1293,60 , 85,14 , 0,2 , 0,2 , {67,68,70},  220,2 , 18247,55 , 13,5 , 4,0 , 6438,9 , 6447,32 ,     2,     1,     1,     6,     7 }, // Swahili/Latin/CongoKinshasa
    {    312,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 570,8 , 570,8 , 186,10 , 10,17 , 18,5 , 8,10 , 27542,48 , 3386,84 , 134,24 , 27542,48 , 3386,84 , 134,24 , 1293,60 , 1293,60 , 85,14 , 1293,60 , 1293,60 , 85,14 , 0,2 , 0,2 , {75,69,83},  180,3 , 18302,58 , 92,2 , 105,4 , 6438,9 , 1343,5 ,     2,     1,     7,     6,     7 }, // Swahili/Latin/Kenya
    {    312,    74,   239,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 570,8 , 570,8 , 186,10 , 10,17 , 18,5 , 8,10 , 27542,48 , 3386,84 , 134,24 , 27542,48 , 3386,84 , 134,24 , 1293,60 , 1293,60 , 85,14 , 1293,60 , 1293,60 , 85,14 , 0,2 , 0,2 , {85,71,88},  151,3 , 18360,61 , 13,5 , 4,0 , 6438,9 , 1010,6 ,     0,     0,     1,     7,     7 }, // Swahili/Latin/Uganda
    {    313,    74,   205,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 44040,48 , 44088,114 , 158,27 , 44040,48 , 44088,114 , 158,27 , 23480,27 , 23507,68 , 85,14 , 23480,27 , 23507,68 , 85,14 , 0,2 , 0,2 , {90,65,82},  9,1 , 0,7 , 9,4 , 4,0 , 6479,7 , 0,0 ,     2,     1,     7,     6,     7 }, // Swati/Latin/SouthAfrica
    {    313,    74,    76,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 23,7 , 30,12 , 44040,48 , 44088,114 , 158,27 , 44040,48 , 44088,114 , 158,27 , 23480,27 , 23507,68 , 85,14 , 23480,27 , 23507,68 , 85,14 , 0,2 , 0,2 , {83,90,76},  190,1 , 0,7 , 9,4 , 4,0 , 6479,7 , 6486,8 ,     2,     1,     1,     6,     7 }, // Swati/Latin/Eswatini
    {    314,    74,   221,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 1198,9 , 1198,9 , 86,10 , 113,16 , 18,5 , 8,10 , 44202,59 , 44261,86 , 134,24 , 44202,59 , 44261,86 , 134,24 , 23575,29 , 23604,50 , 5233,14 , 23575,29 , 23604,50 , 5233,14 , 689,2 , 714,2 , {83,69,75},  209,2 , 18421,45 , 4,5 , 4,0 , 6494,7 , 6501,7 ,     2,     0,     1,     6,     7 }, // Swedish/Latin/Sweden
    {    314,    74,    14,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 1198,9 , 1198,9 , 86,10 , 113,16 , 18,5 , 8,10 , 44202,59 , 44261,86 , 134,24 , 44202,59 , 44261,86 , 134,24 , 23575,29 , 23604,50 , 5233,14 , 23575,29 , 23604,50 , 5233,14 , 689,2 , 714,2 , {69,85,82},  22,1 , 11539,19 , 4,5 , 4,0 , 6494,7 , 6508,5 ,     2,     1,     1,     6,     7 }, // Swedish/Latin/AscensionIsland
    {    314,    74,    81,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 1198,9 , 1198,9 , 86,10 , 113,16 , 18,5 , 8,10 , 44202,59 , 44261,86 , 134,24 , 44202,59 , 44261,86 , 134,24 , 23575,29 , 23604,50 , 5233,14 , 23575,29 , 23604,50 , 5233,14 , 689,2 , 714,2 , {69,85,82},  22,1 , 11539,19 , 4,5 , 4,0 , 6494,7 , 1744,7 ,     2,     1,     1,     6,     7 }, // Swedish/Latin/Finland
    {    315,    74,   222,    46,  8217,    59,    37,    48,  8722,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 467,9 , 467,9 , 251,8 , 878,18 , 18,5 , 8,10 , 16891,48 , 44347,86 , 134,24 , 16891,48 , 44347,86 , 134,24 , 23654,28 , 23682,63 , 4858,14 , 23654,28 , 23682,63 , 4858,14 , 691,12 , 716,11 , {67,72,70},  234,3 , 18466,55 , 4,5 , 4,0 , 6513,16 , 6529,7 ,     2,     0,     1,     6,     7 }, // Swiss German/Latin/Switzerland
    {    315,    74,    82,    46,  8217,    59,    37,    48,  8722,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 467,9 , 467,9 , 251,8 , 878,18 , 18,5 , 8,10 , 16891,48 , 44347,86 , 134,24 , 16891,48 , 44347,86 , 134,24 , 23654,28 , 23682,63 , 4858,14 , 23654,28 , 23682,63 , 4858,14 , 691,12 , 716,11 , {69,85,82},  22,1 , 10819,19 , 4,5 , 4,0 , 6513,16 , 6536,10 ,     2,     1,     1,     6,     7 }, // Swiss German/Latin/France
    {    315,    74,   133,    46,  8217,    59,    37,    48,  8722,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 467,9 , 467,9 , 251,8 , 878,18 , 18,5 , 8,10 , 16891,48 , 44347,86 , 134,24 , 16891,48 , 44347,86 , 134,24 , 23654,28 , 23682,63 , 4858,14 , 23654,28 , 23682,63 , 4858,14 , 691,12 , 716,11 , {67,72,70},  234,3 , 18466,55 , 4,5 , 4,0 , 6513,16 , 6546,13 ,     2,     0,     1,     6,     7 }, // Swiss German/Latin/Liechtenstein
    {    317,   142,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 0,6 , 0,6 , 1207,7 , 1214,6 , 86,10 , 206,17 , 55,7 , 62,12 , 44433,61 , 44494,84 , 44578,26 , 44433,61 , 44604,83 , 44578,26 , 23745,30 , 23775,53 , 23828,14 , 23775,53 , 23775,53 , 23828,14 , 703,2 , 727,2 , {73,81,68},  0,0 , 0,7 , 13,5 , 109,6 , 6559,6 , 6565,4 ,     0,     0,     6,     5,     6 }, // Syriac/Syriac/Iraq
    {    317,   142,   223,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 0,6 , 0,6 , 1207,7 , 1214,6 , 86,10 , 206,17 , 55,7 , 62,12 , 44433,61 , 44494,84 , 44578,26 , 44433,61 , 44604,83 , 44578,26 , 23745,30 , 23775,53 , 23828,14 , 23775,53 , 23775,53 , 23828,14 , 703,2 , 727,2 , {83,89,80},  101,5 , 0,7 , 13,5 , 109,6 , 6559,6 , 6569,5 ,     0,     0,     6,     5,     6 }, // Syriac/Syriac/Syria
    {    318,   155,   155,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 43728,48 , 43776,81 , 43857,24 , 43728,48 , 43776,81 , 43857,24 , 23330,30 , 23842,47 , 85,14 , 23330,30 , 23842,47 , 85,14 , 683,6 , 706,8 , {77,65,68},  0,0 , 18122,21 , 0,4 , 4,0 , 6574,7 , 6422,6 ,     2,     1,     1,     6,     7 }, // Tachelhit/Tifinagh/Morocco
    {    318,    74,   155,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 44687,48 , 44735,81 , 44816,24 , 44687,48 , 44735,81 , 44816,24 , 23889,30 , 23919,48 , 85,14 , 23889,30 , 23919,48 , 85,14 , 705,6 , 729,8 , {77,65,68},  0,0 , 18521,21 , 0,4 , 4,0 , 6581,10 , 6591,6 ,     2,     1,     1,     6,     7 }, // Tachelhit/Latin/Morocco
    {    321,   147,   251,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {86,78,68},  342,1 , 0,7 , 13,5 , 4,0 , 6597,4 , 0,0 ,     0,     0,     1,     6,     7 }, // Tai Dam/Tai Viet/Vietnam
    {    323,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 44840,48 , 44888,221 , 45109,24 , 44840,48 , 44888,221 , 45109,24 , 23967,28 , 23995,105 , 24100,14 , 23967,28 , 23995,105 , 24100,14 , 711,10 , 737,10 , {75,69,83},  180,3 , 4749,24 , 9,4 , 4,0 , 6601,7 , 1343,5 ,     2,     1,     7,     6,     7 }, // Taita/Latin/Kenya
    {    324,    29,   225,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 809,18 , 18,5 , 8,10 , 24207,48 , 45133,71 , 9004,24 , 24207,48 , 45133,71 , 9004,24 , 24114,28 , 24142,55 , 24197,14 , 24114,28 , 24142,55 , 24197,14 , 0,2 , 0,2 , {84,74,83},  343,4 , 18542,19 , 4,5 , 4,0 , 6608,6 , 6614,10 ,     2,     1,     1,     6,     7 }, // Tajik/Cyrillic/Tajikistan
    {    325,   149,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1220,13 , 1220,13 , 223,6 , 287,18 , 505,7 , 181,12 , 45204,58 , 45262,86 , 45348,31 , 45204,58 , 45262,86 , 45348,31 , 24211,39 , 24250,49 , 24299,20 , 24211,39 , 24250,49 , 24299,20 , 721,8 , 747,8 , {73,78,82},  122,1 , 18561,49 , 9,4 , 4,0 , 6624,5 , 6629,7 ,     2,     1,     7,     7,     7 }, // Tamil/Tamil/India
    {    325,   149,   139,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1220,13 , 1220,13 , 223,6 , 287,18 , 505,7 , 181,12 , 45204,58 , 45262,86 , 45348,31 , 45204,58 , 45262,86 , 45348,31 , 24211,39 , 24250,49 , 24299,20 , 24211,39 , 24250,49 , 24299,20 , 721,8 , 747,8 , {77,89,82},  196,2 , 18610,61 , 13,5 , 4,0 , 6624,5 , 6636,7 ,     2,     1,     1,     6,     7 }, // Tamil/Tamil/Malaysia
    {    325,   149,   199,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1220,13 , 1220,13 , 223,6 , 287,18 , 505,7 , 181,12 , 45204,58 , 45262,86 , 45348,31 , 45204,58 , 45262,86 , 45348,31 , 24211,39 , 24250,49 , 24299,20 , 24211,39 , 24250,49 , 24299,20 , 721,8 , 747,8 , {83,71,68},  10,1 , 18671,61 , 13,5 , 4,0 , 6624,5 , 6643,11 ,     2,     1,     7,     6,     7 }, // Tamil/Tamil/Singapore
    {    325,   149,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1220,13 , 1220,13 , 223,6 , 287,18 , 18,5 , 8,10 , 45204,58 , 45262,86 , 45348,31 , 45204,58 , 45262,86 , 45348,31 , 24211,39 , 24250,49 , 24299,20 , 24211,39 , 24250,49 , 24299,20 , 721,8 , 747,8 , {76,75,82},  347,3 , 18732,49 , 9,4 , 4,0 , 6624,5 , 6654,6 ,     2,     1,     1,     6,     7 }, // Tamil/Tamil/SriLanka
    {    326,    74,   224,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 145,18 , 23,7 , 30,12 , 45379,48 , 45427,142 , 45569,24 , 45379,48 , 45427,142 , 45569,24 , 24319,28 , 24347,172 , 24519,14 , 24319,28 , 24347,172 , 24519,14 , 0,2 , 0,2 , {84,87,68},  350,3 , 18781,18 , 13,5 , 4,0 , 6660,12 , 0,0 ,     2,     0,     7,     6,     7 }, // Taroko/Latin/Taiwan
    {    327,    74,   165,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 23594,46 , 23640,88 , 23728,24 , 23594,46 , 23640,88 , 23728,24 , 12463,28 , 12491,54 , 12449,14 , 12463,28 , 12491,54 , 12449,14 , 729,8 , 755,10 , {88,79,70},  131,5 , 12277,23 , 0,4 , 4,0 , 6672,13 , 6685,5 ,     0,     0,     1,     6,     7 }, // Tasawaq/Latin/Niger
    {    328,    29,   189,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1233,9 , 1233,9 , 27,10 , 1869,23 , 74,4 , 78,9 , 45593,62 , 45655,81 , 158,27 , 45593,62 , 45655,81 , 158,27 , 24533,36 , 24569,56 , 24625,14 , 24533,36 , 24569,56 , 24625,14 , 0,2 , 0,2 , {82,85,66},  137,1 , 18799,21 , 0,4 , 4,0 , 6690,5 , 5725,6 ,     2,     1,     1,     6,     7 }, // Tatar/Cyrillic/Russia
    {    330,   151,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1242,11 , 1242,11 , 1733,8 , 1892,18 , 55,7 , 62,12 , 45736,62 , 45798,86 , 45884,31 , 45736,62 , 45798,86 , 45884,31 , 24639,32 , 24671,60 , 24731,18 , 24639,32 , 24671,60 , 24731,18 , 0,2 , 0,2 , {73,78,82},  122,1 , 18820,50 , 9,4 , 4,0 , 6695,6 , 6701,8 ,     2,     1,     7,     7,     7 }, // Telugu/Telugu/India
    {    331,    74,   239,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 45915,48 , 45963,94 , 46057,24 , 45915,48 , 45963,94 , 46057,24 , 24749,28 , 24777,69 , 24846,14 , 24749,28 , 24777,69 , 24846,14 , 737,9 , 765,6 , {85,71,88},  151,3 , 18870,28 , 9,4 , 4,0 , 6709,6 , 1010,6 ,     0,     0,     1,     7,     7 }, // Teso/Latin/Uganda
    {    331,    74,   122,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 45915,48 , 45963,94 , 46057,24 , 45915,48 , 45963,94 , 46057,24 , 24749,28 , 24777,69 , 24846,14 , 24749,28 , 24777,69 , 24846,14 , 737,9 , 765,6 , {75,69,83},  180,3 , 18898,27 , 9,4 , 4,0 , 6709,6 , 6715,5 ,     2,     1,     7,     6,     7 }, // Teso/Latin/Kenya
    {    332,   153,   227,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 23,5 , 23,5 , 1253,8 , 1261,7 , 223,6 , 1910,19 , 18,5 , 632,28 , 46081,63 , 46144,98 , 46081,63 , 46081,63 , 46144,98 , 46081,63 , 24860,23 , 24883,68 , 24951,16 , 24860,23 , 24883,68 , 24951,16 , 746,10 , 771,10 , {84,72,66},  353,1 , 18925,16 , 9,4 , 4,0 , 6720,3 , 6720,3 ,     2,     1,     7,     6,     7 }, // Thai/Thai/Thailand
    {    333,   154,    50,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 1929,23 , 18,5 , 8,10 , 11750,63 , 46242,159 , 158,27 , 11750,63 , 46401,147 , 158,27 , 24967,51 , 25018,79 , 25097,27 , 24967,51 , 25018,79 , 25097,27 , 756,7 , 781,8 , {67,78,89},  154,1 , 18941,13 , 13,5 , 4,0 , 6723,8 , 6731,6 ,     2,     1,     1,     6,     7 }, // Tibetan/Tibetan/China
    {    333,   154,   108,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 1929,23 , 55,7 , 62,12 , 11750,63 , 46242,159 , 158,27 , 11750,63 , 46401,147 , 158,27 , 24967,51 , 25018,79 , 25097,27 , 24967,51 , 25018,79 , 25097,27 , 756,7 , 781,8 , {73,78,82},  122,1 , 18954,19 , 13,5 , 4,0 , 6723,8 , 6737,7 ,     2,     1,     7,     7,     7 }, // Tibetan/Tibetan/India
    {    334,    38,    74,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 1952,21 , 55,7 , 62,12 , 46548,46 , 46594,62 , 1677,24 , 46548,46 , 46594,62 , 1677,24 , 25124,27 , 25151,41 , 25192,14 , 25124,27 , 25151,41 , 25192,14 , 0,2 , 0,2 , {69,82,78},  6,3 , 0,7 , 9,4 , 4,0 , 6744,3 , 698,4 ,     2,     1,     1,     6,     7 }, // Tigre/Ethiopic/Eritrea
    {    335,    38,    77,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 37,6 , 37,6 , 1268,7 , 1268,7 , 59,8 , 1973,17 , 55,7 , 62,12 , 46656,36 , 46692,54 , 46746,24 , 46656,36 , 46692,54 , 46746,24 , 25206,21 , 25227,29 , 25256,14 , 25206,21 , 25227,29 , 25256,14 , 763,4 , 789,4 , {69,84,66},  1,2 , 18973,13 , 9,4 , 4,0 , 6747,4 , 143,5 ,     2,     1,     7,     6,     7 }, // Tigrinya/Ethiopic/Ethiopia
    {    335,    38,    74,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 37,6 , 37,6 , 1268,7 , 1268,7 , 59,8 , 1973,17 , 55,7 , 62,12 , 46656,36 , 46692,54 , 46746,24 , 46656,36 , 46692,54 , 46746,24 , 25206,21 , 25227,29 , 25256,14 , 25206,21 , 25227,29 , 25256,14 , 763,4 , 789,4 , {69,82,78},  6,3 , 18986,16 , 9,4 , 4,0 , 6747,4 , 698,4 ,     2,     1,     1,     6,     7 }, // Tigrinya/Ethiopic/Eritrea
    {    336,    74,   178,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 1990,17 , 127,8 , 135,13 , 46770,47 , 46817,77 , 158,27 , 46770,47 , 46817,77 , 158,27 , 25270,28 , 25298,45 , 85,14 , 25270,28 , 25298,45 , 85,14 , 0,2 , 0,2 , {80,71,75},  0,0 , 0,7 , 4,5 , 4,0 , 6751,9 , 6760,13 ,     2,     1,     1,     6,     7 }, // Tok Pisin/Latin/PapuaNewGuinea
    {    338,    74,   254,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {0,0,0},  0,0 , 2547,0 , 13,5 , 4,0 , 6773,9 , 6782,6 ,     2,     1,     1,     6,     7 }, // Toki Pona/Latin/World
    {    339,    74,   231,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 1275,8 , 1275,8 , 1275,8 , 1275,8 , 223,6 , 113,16 , 23,7 , 30,12 , 46894,51 , 46945,87 , 47032,24 , 46894,51 , 46945,87 , 47056,27 , 25343,29 , 25372,60 , 25432,14 , 25343,29 , 25372,60 , 25432,14 , 767,10 , 793,6 , {84,79,80},  211,2 , 19002,41 , 13,5 , 4,0 , 6788,13 , 2330,5 ,     2,     1,     1,     6,     7 }, // Tongan/Latin/Tonga
    {    340,     4,   174,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 1283,5 , 1283,5 , 1288,9 , 1297,8 , 223,6 , 2007,18 , 55,7 , 62,12 , 37699,67 , 37699,67 , 36620,24 , 37699,67 , 37699,67 , 36620,24 , 25446,58 , 25446,58 , 25504,14 , 25446,58 , 25446,58 , 25504,14 , 0,2 , 0,2 , {80,75,82},  129,2 , 19043,35 , 13,5 , 4,0 , 6801,7 , 543,7 ,     2,     0,     7,     6,     7 }, // Torwali/Arabic/Pakistan
    {    341,    74,   205,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 47083,48 , 47131,122 , 158,27 , 47083,48 , 47131,122 , 158,27 , 25518,27 , 25545,72 , 85,14 , 25518,27 , 25545,72 , 85,14 , 0,2 , 0,2 , {90,65,82},  9,1 , 0,7 , 13,5 , 4,0 , 6808,8 , 0,0 ,     2,     1,     7,     6,     7 }, // Tsonga/Latin/SouthAfrica
    {    342,    74,   205,    46,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 47253,48 , 47301,117 , 158,27 , 47253,48 , 47301,117 , 158,27 , 25617,32 , 25649,64 , 85,14 , 25617,32 , 25649,64 , 85,14 , 0,2 , 0,2 , {90,65,82},  9,1 , 0,7 , 9,4 , 4,0 , 6816,8 , 6824,13 ,     2,     1,     7,     6,     7 }, // Tswana/Latin/SouthAfrica
    {    342,    74,    30,    46,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 47253,48 , 47301,117 , 158,27 , 47253,48 , 47301,117 , 158,27 , 25617,32 , 25649,64 , 85,14 , 25617,32 , 25649,64 , 85,14 , 0,2 , 0,2 , {66,87,80},  183,1 , 0,7 , 9,4 , 4,0 , 6816,8 , 0,0 ,     2,     1,     7,     6,     7 }, // Tswana/Latin/Botswana
    {    343,    74,   235,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1305,8 , 1305,8 , 1697,9 , 2025,16 , 18,5 , 8,10 , 47418,48 , 47466,75 , 47541,24 , 47418,48 , 47466,75 , 47541,24 , 25713,28 , 25741,54 , 25795,14 , 25713,28 , 25741,54 , 25795,14 , 777,2 , 799,2 , {84,82,89},  128,1 , 19078,40 , 9,4 , 4,0 , 6837,6 , 6843,7 ,     2,     1,     1,     6,     7 }, // Turkish/Latin/Turkey
    {    343,    74,    63,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1305,8 , 1305,8 , 1697,9 , 2025,16 , 23,7 , 30,12 , 47418,48 , 47466,75 , 47541,24 , 47418,48 , 47466,75 , 47541,24 , 25713,28 , 25741,54 , 25795,14 , 25713,28 , 25741,54 , 25795,14 , 777,2 , 799,2 , {69,85,82},  22,1 , 10819,19 , 9,4 , 4,0 , 6837,6 , 6850,6 ,     2,     1,     1,     6,     7 }, // Turkish/Latin/Cyprus
    {    344,    74,   236,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8220,  8221, 0,6 , 0,6 , 1313,8 , 1313,8 , 27,10 , 2025,16 , 18,5 , 8,10 , 47565,50 , 47615,77 , 47692,24 , 47716,51 , 47767,77 , 47692,24 , 25809,28 , 25837,54 , 25891,14 , 25905,28 , 25933,54 , 25891,14 , 779,13 , 801,14 , {84,77,84},  354,3 , 19118,49 , 4,5 , 4,0 , 6856,12 , 6868,12 ,     2,     1,     1,     6,     7 }, // Turkmen/Latin/Turkmenistan
    {    346,    74,   166,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 137,8 , 145,18 , 18,5 , 8,10 , 47844,48 , 47892,153 , 158,27 , 47844,48 , 47892,153 , 158,27 , 25987,28 , 26015,42 , 85,14 , 25987,28 , 26015,42 , 85,14 , 0,2 , 0,2 , {78,71,78},  126,1 , 19167,11 , 13,5 , 4,0 , 6880,5 , 0,0 ,     2,     1,     1,     6,     7 }, // Tyap/Latin/Nigeria
    {    348,    29,   240,    44,   160,    59,    37,    48,    45,    43,  1077,   171,   187,  8222,  8220, 0,6 , 0,6 , 115,7 , 115,7 , 251,8 , 2041,22 , 18,5 , 8,10 , 48045,48 , 48093,95 , 48188,24 , 48212,67 , 48279,87 , 48366,24 , 3282,21 , 26057,56 , 4631,14 , 3282,21 , 26057,56 , 4631,14 , 792,2 , 815,2 , {85,65,72},  323,1 , 19178,95 , 4,5 , 4,0 , 6885,10 , 6895,7 ,     2,     1,     1,     6,     7 }, // Ukrainian/Cyrillic/Ukraine
    {    349,    74,    89,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 794,7 , 794,7 , 180,6 , 878,18 , 660,12 , 78,9 , 48390,48 , 48438,86 , 6694,24 , 48524,60 , 48584,93 , 6694,24 , 26113,28 , 26141,53 , 26194,14 , 26113,28 , 26141,53 , 26194,14 , 402,9 , 817,9 , {69,85,82},  22,1 , 19273,29 , 4,5 , 4,0 , 6902,15 , 6917,6 ,     2,     1,     1,     6,     7 }, // Upper Sorbian/Latin/Germany
    {    350,     4,   174,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 674,6 , 674,6 , 1321,10 , 1331,9 , 223,6 , 2007,18 , 55,7 , 62,12 , 48677,68 , 48677,68 , 134,24 , 48677,68 , 48677,68 , 134,24 , 26208,36 , 26208,36 , 85,14 , 26208,36 , 26208,36 , 85,14 , 0,2 , 0,2 , {80,75,82},  129,2 , 19302,49 , 9,4 , 4,0 , 6923,4 , 543,7 ,     2,     0,     7,     6,     7 }, // Urdu/Arabic/Pakistan
    {    350,     4,   108,  1643,  1644,    59,    37,  1776,    45,    43,   101,  8221,  8220,  8217,  8216, 674,6 , 674,6 , 1321,10 , 1331,9 , 223,6 , 2007,18 , 55,7 , 62,12 , 48677,68 , 48677,68 , 134,24 , 48677,68 , 48677,68 , 134,24 , 26208,36 , 26208,36 , 85,14 , 26208,36 , 26208,36 , 85,14 , 0,2 , 0,2 , {73,78,82},  122,1 , 19351,42 , 13,5 , 4,0 , 6923,4 , 6927,5 ,     2,     1,     7,     7,     7 }, // Urdu/Arabic/India
    {    351,     4,    50,    46,    44,    59,    37,    48,    45,    43,   101,   187,   171,  8250,  8249, 0,6 , 0,6 , 320,10 , 330,9 , 86,10 , 2063,17 , 18,5 , 8,10 , 48745,84 , 48745,84 , 158,27 , 48745,84 , 48745,84 , 158,27 , 26244,21 , 26265,55 , 26320,14 , 26244,21 , 26265,55 , 26320,14 , 794,12 , 826,12 , {67,78,89},  149,1 , 19393,40 , 9,4 , 4,0 , 6932,8 , 6940,5 ,     2,     1,     1,     6,     7 }, // Uyghur/Arabic/China
    {    352,    74,   247,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8217,  8216, 0,6 , 0,6 , 1340,8 , 1340,8 , 59,8 , 2080,18 , 18,5 , 245,11 , 48829,48 , 48877,75 , 48952,24 , 48976,48 , 49024,75 , 48952,24 , 26334,32 , 26366,61 , 26427,14 , 26334,32 , 26366,61 , 26427,14 , 806,2 , 838,2 , {85,90,83},  357,4 , 19433,58 , 4,5 , 4,0 , 6945,6 , 6951,11 ,     2,     0,     1,     6,     7 }, // Uzbek/Latin/Uzbekistan
    {    352,     4,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 512,8 , 2098,33 , 74,4 , 245,11 , 49099,47 , 36742,68 , 158,27 , 49099,47 , 36742,68 , 158,27 , 26441,21 , 19355,49 , 85,14 , 26441,21 , 19355,49 , 85,14 , 0,2 , 0,2 , {65,70,78},  305,1 , 19491,13 , 4,5 , 4,0 , 6962,6 , 5359,9 ,     0,     0,     6,     4,     5 }, // Uzbek/Arabic/Afghanistan
    {    352,    29,   247,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 1042,19 , 18,5 , 148,12 , 8876,48 , 49146,71 , 9004,24 , 8876,48 , 49146,71 , 9004,24 , 26462,28 , 26490,53 , 26543,14 , 26462,28 , 26490,53 , 26543,14 , 808,2 , 840,2 , {85,90,83},  361,3 , 19504,49 , 4,5 , 4,0 , 6968,7 , 6975,10 ,     2,     0,     1,     6,     7 }, // Uzbek/Cyrillic/Uzbekistan
    {    353,   160,   131,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 55,7 , 62,12 , 49217,38 , 49255,61 , 158,27 , 49217,38 , 49255,61 , 158,27 , 26557,30 , 26557,30 , 85,14 , 26557,30 , 26557,30 , 85,14 , 0,2 , 0,2 , {76,82,68},  10,1 , 19553,15 , 9,4 , 4,0 , 6985,2 , 6987,4 ,     2,     1,     1,     6,     7 }, // Vai/Vai/Liberia
    {    353,    74,   131,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 23,7 , 30,12 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 26587,48 , 26587,48 , 85,14 , 26587,48 , 26587,48 , 85,14 , 0,2 , 0,2 , {76,82,68},  10,1 , 19568,20 , 9,4 , 4,0 , 6991,3 , 6994,8 ,     2,     1,     1,     6,     7 }, // Vai/Latin/Liberia
    {    354,    74,   205,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 49316,48 , 49364,111 , 158,27 , 49316,48 , 49364,111 , 158,27 , 26635,27 , 26662,70 , 85,14 , 26635,27 , 26662,70 , 85,14 , 0,2 , 0,2 , {90,65,82},  9,1 , 0,7 , 9,4 , 4,0 , 7002,9 , 0,0 ,     2,     1,     7,     6,     7 }, // Venda/Latin/SouthAfrica
    {    355,    74,   251,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1348,8 , 1348,8 , 186,10 , 287,18 , 18,5 , 8,10 , 49475,75 , 49550,99 , 158,27 , 49649,75 , 49724,99 , 158,27 , 26732,33 , 26765,55 , 26820,21 , 26732,33 , 26765,55 , 26820,21 , 810,2 , 842,2 , {86,78,68},  342,1 , 19588,33 , 4,5 , 4,0 , 7011,10 , 7021,8 ,     0,     0,     1,     6,     7 }, // Vietnamese/Latin/Vietnam
    {    356,    74,   254,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 2131,23 , 18,5 , 8,10 , 49823,48 , 49871,74 , 49945,24 , 49969,48 , 49871,74 , 49945,24 , 26841,21 , 26862,43 , 26905,14 , 26919,28 , 26862,43 , 26905,14 , 0,2 , 0,2 , {0,0,0},  0,0 , 2547,0 , 13,5 , 4,0 , 7029,7 , 0,0 ,     2,     1,     1,     6,     7 }, // Volapuk/Latin/World
    {    357,    74,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 186,10 , 10,17 , 18,5 , 8,10 , 27542,48 , 27590,87 , 134,24 , 27542,48 , 27590,87 , 134,24 , 14634,28 , 14662,62 , 1353,14 , 14634,28 , 14662,62 , 1353,14 , 430,5 , 441,9 , {84,90,83},  123,3 , 12712,27 , 9,4 , 4,0 , 7036,8 , 2315,8 ,     2,     0,     1,     6,     7 }, // Vunjo/Latin/Tanzania
    {    358,    74,    23,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 0,7 , 13,5 , 4,0 , 7044,5 , 0,0 ,     2,     1,     1,     6,     7 }, // Walloon/Latin/Belgium
    {    359,    74,   222,    44,  8217,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 467,9 , 467,9 , 86,10 , 878,18 , 18,5 , 8,10 , 50017,48 , 50065,99 , 50164,24 , 50017,48 , 50065,99 , 50164,24 , 26947,28 , 26975,53 , 27028,14 , 26947,28 , 26975,53 , 27028,14 , 0,2 , 0,2 , {67,72,70},  0,0 , 0,7 , 24,6 , 4,0 , 7049,6 , 7055,6 ,     2,     0,     1,     6,     7 }, // Walser/Latin/Switzerland
    {    360,    74,    15,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {65,85,68},  364,2 , 0,7 , 13,5 , 4,0 , 7061,8 , 0,0 ,     2,     1,     1,     6,     7 }, // Warlpiri/Latin/Australia
    {    361,    74,   242,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1356,11 , 1367,10 , 59,8 , 10,17 , 18,5 , 8,10 , 50188,52 , 50240,87 , 50327,26 , 50353,56 , 50240,87 , 50327,26 , 27042,29 , 27071,77 , 27148,15 , 27163,30 , 27071,77 , 27148,15 , 812,2 , 844,2 , {71,66,80},  96,1 , 19621,91 , 9,4 , 4,0 , 7069,7 , 7076,16 ,     2,     1,     1,     6,     7 }, // Welsh/Latin/UnitedKingdom
    {    362,     4,   174,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 674,6 , 674,6 , 1002,8 , 1010,7 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {80,75,82},  366,3 , 19712,33 , 13,5 , 4,0 , 7092,14 , 0,0 ,     2,     0,     7,     6,     7 }, // Western Balochi/Arabic/Pakistan
    {    362,     4,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 674,6 , 674,6 , 1002,8 , 1010,7 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {65,70,78},  305,1 , 19745,41 , 13,5 , 4,0 , 7092,14 , 0,0 ,     0,     0,     6,     4,     5 }, // Western Balochi/Arabic/Afghanistan
    {    362,     4,   110,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 674,6 , 674,6 , 1002,8 , 1010,7 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {73,82,82},  306,4 , 19786,29 , 13,5 , 4,0 , 7092,14 , 0,0 ,     0,     0,     6,     5,     5 }, // Western Balochi/Arabic/Iran
    {    362,     4,   173,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 674,6 , 674,6 , 1002,8 , 1010,7 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {79,77,82},  0,0 , 0,7 , 13,5 , 4,0 , 7092,14 , 7106,5 ,     3,     0,     6,     5,     6 }, // Western Balochi/Arabic/Oman
    {    362,     4,   241,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 674,6 , 674,6 , 1002,8 , 1010,7 , 86,10 , 163,17 , 18,5 , 8,10 , 1367,48 , 1367,48 , 158,27 , 1367,48 , 1367,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {65,69,68},  0,0 , 0,7 , 13,5 , 4,0 , 7092,14 , 7111,19 ,     2,     1,     6,     6,     7 }, // Western Balochi/Arabic/UnitedArabEmirates
    {    363,    74,   161,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 15,8 , 15,8 , 1733,8 , 113,16 , 18,5 , 8,10 , 50409,48 , 50457,95 , 134,24 , 50409,48 , 50457,95 , 134,24 , 27193,21 , 27214,54 , 85,14 , 27193,21 , 27214,54 , 85,14 , 0,2 , 0,2 , {69,85,82},  22,1 , 4444,19 , 13,5 , 109,6 , 7130,5 , 7135,8 ,     2,     1,     1,     6,     7 }, // Western Frisian/Latin/Netherlands
    {    364,    38,    77,    46,  8217,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 59,8 , 2154,22 , 55,7 , 62,12 , 46548,46 , 46594,62 , 1677,24 , 46548,46 , 46594,62 , 1677,24 , 27268,27 , 27268,27 , 27295,14 , 27268,27 , 27268,27 , 27295,14 , 0,2 , 0,2 , {69,84,66},  1,2 , 10760,16 , 9,4 , 4,0 , 7143,5 , 143,5 ,     2,     1,     7,     6,     7 }, // Wolaytta/Ethiopic/Ethiopia
    {    365,    74,   195,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 415,10 , 2176,17 , 18,5 , 8,10 , 50552,47 , 50599,84 , 158,27 , 50552,47 , 50599,84 , 158,27 , 27309,28 , 27337,50 , 27309,28 , 27309,28 , 27337,50 , 27309,28 , 814,3 , 846,3 , {88,79,70},  131,5 , 19815,65 , 13,5 , 4,0 , 7148,5 , 3061,8 ,     0,     0,     1,     6,     7 }, // Wolof/Latin/Senegal
    {    366,    74,   205,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1377,9 , 1386,8 , 547,6 , 553,18 , 18,5 , 8,10 , 50683,48 , 50731,91 , 158,27 , 50822,49 , 50871,92 , 158,27 , 27387,28 , 27415,61 , 27476,21 , 27497,30 , 27415,61 , 27527,22 , 0,2 , 0,2 , {90,65,82},  9,1 , 19880,82 , 9,4 , 4,0 , 7153,8 , 7161,15 ,     2,     1,     7,     6,     7 }, // Xhosa/Latin/SouthAfrica
    {    367,    74,    40,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 50963,51 , 51014,191 , 158,27 , 50963,51 , 51014,191 , 158,27 , 27549,21 , 27570,71 , 27641,14 , 27549,21 , 27570,71 , 27641,14 , 817,8 , 849,8 , {88,65,70},  11,4 , 0,7 , 4,5 , 4,0 , 7176,6 , 7182,7 ,     0,     0,     1,     6,     7 }, // Yangben/Latin/Cameroon
    {    368,    53,   254,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 1394,9 , 1394,9 , 59,8 , 2193,19 , 18,5 , 8,10 , 51205,58 , 51263,92 , 158,27 , 51263,92 , 51263,92 , 158,27 , 27655,54 , 27655,54 , 85,14 , 27655,54 , 27655,54 , 85,14 , 825,11 , 857,10 , {0,0,0},  0,0 , 2547,0 , 24,6 , 4,0 , 7189,6 , 7195,5 ,     2,     1,     1,     6,     7 }, // Yiddish/Hebrew/World
    {    369,    74,   166,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 2212,16 , 672,3 , 8,10 , 51355,40 , 51395,73 , 51468,27 , 51495,55 , 51550,121 , 51468,27 , 27709,33 , 27742,44 , 27786,14 , 27709,33 , 27800,69 , 27786,14 , 836,5 , 867,5 , {78,71,78},  126,1 , 19962,35 , 9,4 , 4,0 , 7200,10 , 7210,8 ,     2,     1,     1,     6,     7 }, // Yoruba/Latin/Nigeria
    {    369,    74,    25,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 1403,11 , 0,6 , 0,6 , 0,6 , 129,8 , 2212,16 , 672,3 , 8,10 , 51671,41 , 51712,74 , 51786,27 , 51813,56 , 51869,134 , 51786,27 , 27869,33 , 27902,44 , 27946,14 , 27869,33 , 27960,69 , 27946,14 , 841,5 , 872,5 , {88,79,70},  131,5 , 19997,64 , 9,4 , 4,0 , 7200,10 , 7218,6 ,     0,     0,     1,     6,     7 }, // Yoruba/Latin/Benin
    {    370,    74,   165,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 129,8 , 113,16 , 18,5 , 8,10 , 23594,46 , 23640,88 , 23728,24 , 23594,46 , 23640,88 , 23728,24 , 12463,28 , 28029,53 , 28082,14 , 12463,28 , 28029,53 , 28082,14 , 729,8 , 755,10 , {88,79,70},  131,5 , 12277,23 , 0,4 , 4,0 , 7224,10 , 6685,5 ,     0,     0,     1,     6,     7 }, // Zarma/Latin/Niger
    {    372,    74,   205,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 1414,9 , 1423,8 , 547,6 , 553,18 , 18,5 , 8,10 , 52003,48 , 52051,91 , 134,24 , 52003,48 , 52051,91 , 52142,24 , 28096,28 , 28124,74 , 28198,14 , 28096,28 , 28124,74 , 28198,14 , 0,2 , 0,2 , {90,65,82},  9,1 , 20061,67 , 9,4 , 4,0 , 7234,7 , 7241,17 ,     2,     1,     7,     6,     7 }, // Zulu/Latin/SouthAfrica
    {      0,      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,0,    0,0,    0,0,   0,0,     0,0,     0,0,     0,0,     0,0,     0,0,     0,0,     0,0,    0,0,    0,0,    0,0,   0,0,   0,0,   0,0,   0,0,   0,0,   0,0,   0,0,   0,0, {0,0,0}, 0,0, 0,0, 0,0, 0,0, 0, 0, 0, 0, 0, 0,0, 0,0 }  // trailing 0s
};

static const ushort list_pattern_part_data[] = {
0x25, 0x31, 0x2c, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2d, 0x438, 0x20, 0x25, 0x32, 0x2d, 0x438, 0x25, 0x31, 0x20, 0x65, 0x6e,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x68, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x1363,
0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x12a5, 0x1293, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x12a5, 0x1293, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x648, 0x25, 0x32, 0x25, 0x31, 0x20, 0x79, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x587, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x986, 0x9f0, 0x9c1, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x76, 0x259, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20,
0x98f, 0x9ac, 0x982, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x74, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x456, 0x20,
0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x906, 0x930, 0x94b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x906, 0x930, 0x94b, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x69, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x438, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x68, 0x61,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x2d, 0x20, 0x25, 0x32, 0x25, 0x31, 0x1014, 0x103e, 0x1004, 0x1037, 0x103a, 0x20, 0x25, 0x32,
0x25, 0x31, 0x3001, 0x25, 0x32, 0x25, 0x31, 0x540c, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x75, 0x67, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x75, 0x67, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xd804, 0xdd03, 0xd804, 0xdd33, 0xd804, 0xdd03, 0x20, 0x25, 0x32, 0x25,
0x31, 0x2c, 0x20, 0x13a0, 0x13b4, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x13a0, 0x13b4, 0x20, 0x25, 0x32, 0x25, 0x31, 0x548c, 0x25,
0x32, 0x25, 0x31, 0x53ca, 0x25, 0x32, 0x25, 0x31, 0x20, 0x438, 0x486, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x442, 0x430, 0x442,
0x430, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xe8, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x61, 0xa0, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6f, 0x67, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x924, 0x947,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x924, 0x947, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xf51, 0xf44, 0xf0b, 0x20, 0x25, 0x32,
0x25, 0x31, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x6b, 0x61, 0x6a, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6a, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20,
0x6b, 0x70, 0x6c, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6b, 0x70, 0x6c, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c,
0x20, 0x61, 0x74, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x74, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x74, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2e41, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2e41, 0x20, 0xd83a,
0xdd2b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xd83a, 0xdd2b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x6b, 0x25b, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x6b, 0x25b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x67, 0x75, 0x73, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x10d3, 0x10d0, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x3ba,
0x3b1, 0x3b9, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xa85, 0xaa8, 0xac7, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x64, 0x61,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x5d5, 0x25, 0x32, 0x25, 0x31, 0x2c,
0x20, 0x914, 0x930, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x914, 0x930, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x61, 0x75,
0x72, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x75, 0x72, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xe9, 0x73, 0x20, 0x25,
0x32, 0x25, 0x31, 0x2c, 0x20, 0x6e, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6e, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31,
0x2c, 0x20, 0x64, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c,
0x20, 0x6c, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6c, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20,
0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6b, 0x61, 0x72, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x61, 0x61, 0x6d, 0x6d, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0xcae, 0xca4, 0xccd, 0xca4, 0xcc1,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xcae, 0xca4, 0xccd, 0xca4, 0xcc1, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x25, 0x32,
0x25, 0x31, 0x60c, 0x20, 0x62a, 0x655, 0x6c1, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x62a, 0x655, 0x6c1, 0x20, 0x25, 0x32, 0x25,
0x31, 0x2c, 0x20, 0x924, 0x93f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x924, 0x93f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x436,
0x4d9, 0x43d, 0x435, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x1793, 0x17b7, 0x1784, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x1793, 0x17b7,
0x1784, 0x200b, 0x25, 0x32, 0x25, 0x31, 0x20, 0xbc0f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xfb, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x436, 0x430, 0x43d, 0x430, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xec1, 0xea5, 0xeb0, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20,
0x6d, 0x70, 0xe9, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69, 0x72, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x61, 0x28, 0x6e, 0x29, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x25, 0x32, 0x20, 0xd0e, 0xd28,
0xd4d, 0xd28, 0xd3f, 0xd35, 0x25, 0x31, 0x20, 0xd15, 0xd42, 0xd1f, 0xd3e, 0xd24, 0xd46, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20,
0x75, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x985, 0x9ae, 0x9b8, 0x9c1, 0x982, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x906, 0x923, 0x93f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x25, 0x32, 0x25, 0x31, 0x20, 0x930,
0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x14b, 0x301, 0x67, 0x25b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x1e3f, 0x62,
0x25b, 0x6e, 0x20, 0x14b, 0x301, 0x67, 0x25b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x70, 0x254, 0x70, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x61, 0x73, 0x75, 0xed, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0xb13, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0xb13, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x4d5, 0x43c, 0x4d5, 0x20, 0x25, 0x32, 0x25, 0x31,
0x60c, 0x20, 0x627, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x627, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x200f, 0x20,
0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20,
0x62, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xa05, 0xa24, 0xa47, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x75, 0x74,
0x61, 0x71, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x74, 0x61, 0x71, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x219, 0x69,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x443, 0x43e, 0x43d, 0x43d, 0x430, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x924, 0x925,
0x93e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x924, 0x925, 0x93e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x1c5f, 0x1c68, 0x1c75,
0x1c5f, 0x1c5d, 0x1c60, 0x1c77, 0x1c5f, 0x1c71, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x1c5f, 0x1c68, 0x1c75, 0x1c5f, 0x1c5d, 0x1c60, 0x1c77, 0x1c5f,
0x1c71, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x6fd, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6fd, 0x20, 0x25, 0x32, 0x25,
0x31, 0x2c, 0x20, 0xdc3, 0xdc4, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xdc3, 0xdc4, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69,
0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69, 0x79, 0x6f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x73, 0x61, 0x72,
0x65, 0x6e, 0x67, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x73, 0x61, 0x72, 0x65, 0x6e, 0x67, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x6f, 0x63, 0x68, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x718, 0x25, 0x32, 0x25, 0x31, 0x20, 0x718, 0x25, 0x32,
0x25, 0x31, 0x20, 0xbae, 0xbb1, 0xbcd, 0xbb1, 0xbc1, 0xbae, 0xbcd, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x4bb, 0x4d9, 0x43c, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0xc2e, 0xc30, 0xc3f, 0xc2f, 0xc41, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xe41, 0xe25, 0xe30, 0x25,
0x32, 0x25, 0x31, 0xe41, 0xe25, 0xe30, 0x25, 0x32, 0x25, 0x31, 0x1295, 0x20, 0x25, 0x32, 0x1295, 0x25, 0x31, 0x20, 0x6d, 0x6f,
0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x25, 0x32, 0x25, 0x31, 0x20, 0x60c, 0x622, 0x6ba, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20,
0x622, 0x6ba, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x76, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x77, 0x65, 0x20, 0x25,
0x32, 0x25, 0x31, 0x60c, 0x20, 0x627, 0x648, 0x631, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x627, 0x648, 0x631, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x76, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x76, 0xe0, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20,
0x61, 0x28, 0x63, 0x29, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x28, 0x63, 0x29, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c,
0x20, 0x6f, 0x72, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6f, 0x72, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x5d0, 0x5d5, 0x5df,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x70, 0x25b, 0x300, 0x6c, 0xfa, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x6e, 0x65,
0x2d, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6e, 0x65, 0x2d, 0x25, 0x32
};

static const ushort date_format_data[] = {
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64,
0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x448, 0x27, 0x2e, 0x64,
0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64,
0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2d, 0x4d, 0x4d, 0x2d, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2f, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2f,
0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d,
0x20, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64,
0x64, 0x2e, 0x4d, 0x2e, 0x79, 0x79, 0x64, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x64, 0x200f, 0x2f, 0x4d,
0x200f, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x60c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79,
0x79, 0x79, 0x79, 0x64, 0x2f, 0x4d, 0x2f, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x79,
0x79, 0x79, 0x79, 0x20, 0x569, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64,
0x2d, 0x4d, 0x2d, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c,
0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2c, 0x20, 0x64, 0x64,
0x64, 0x64, 0x79, 0x79, 0x2f, 0x4d, 0x2f, 0x64, 0x79, 0x79, 0x79, 0x79, 0x28, 0x27, 0x65, 0x27, 0x29, 0x27, 0x6b, 0x6f,
0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x27, 0x72, 0x65, 0x6e, 0x27, 0x20, 0x64, 0x28, 0x27, 0x61, 0x27, 0x29, 0x2c, 0x20,
0x64, 0x64, 0x64, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x202f, 0x27, 0x433, 0x27, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x1361, 0x20, 0x64,
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x130d, 0x122d, 0x130b, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2d, 0x4d, 0x4d,
0x2d, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x64, 0x64, 0x64,
0x2c, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x2e, 0x4d, 0x2e, 0x79,
0x79, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79,
0x79, 0x2e, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x202f, 0x27, 0x433, 0x27, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x104a, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x104a, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x2f, 0x4d, 0x2f, 0x64,
0x79, 0x79, 0x79, 0x79, 0x5e74, 0x4d, 0x6708, 0x64, 0x65e5, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x5e74, 0x4d,
0x6708, 0x64, 0x65e5, 0x64, 0x64, 0x64, 0x64, 0x4d, 0x2f, 0x64, 0x2f, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x4d, 0x4d, 0x2e, 0x64,
0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x43b, 0x27, 0x2e, 0x20, 0x79,
0x79, 0x79, 0x79, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79,
0x79, 0x202f, 0x27, 0x4ab, 0x27, 0x2e, 0x64, 0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64,
0x2c, 0x20, 0x27, 0x64, 0xe4, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x64, 0x64, 0x64, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x27, 0x75, 0x27, 0x20,
0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x2e, 0x20,
0x4d, 0x2e, 0x20, 0x79, 0x79, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79,
0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x27, 0x64, 0x65, 0x6e, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2d, 0x4d, 0x2d, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2c,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x64,
0x64, 0x64, 0x64, 0x2c, 0x20, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf63, 0xf7c, 0xf0b, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0xf5a, 0xf7a, 0xf66, 0xf0b, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2f, 0x4d,
0x4d, 0x2f, 0x64, 0x64, 0x79, 0x79, 0x2d, 0x4d, 0x4d, 0x2d, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2d,
0x27, 0x61, 0x27, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64,
0x64, 0x64, 0x2c, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64,
0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x20, 0x27, 0x6c, 0x69, 0x61, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x2e, 0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x61, 0x6c, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2e41, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x27, 0x6d,
0x68, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20,
0x27, 0x64, 0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x64, 0x64, 0x64, 0x1365, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x1218, 0x12d3, 0x120d, 0x1275, 0x20, 0x79, 0x79,
0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79,
0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64,
0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x5d1, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79,
0x2e, 0x20, 0x4d, 0x4d, 0x2e, 0x20, 0x64, 0x64, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20,
0x64, 0x2e, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64,
0x2e, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x27, 0x6c, 0x65, 0x27, 0x20, 0x64, 0x20, 0x27, 0x64,
0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x2f, 0x79, 0x79,
0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20,
0x27, 0x64, 0x69, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x27, 0x6e, 0x65,
0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2f, 0x4d, 0x4d, 0x20, 0x79, 0x79,
0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x202f, 0x27, 0x436, 0x27, 0x2e, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20,
0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x64, 0x2e, 0x79, 0x79, 0x79, 0x79, 0xb144, 0x20, 0x4d,
0xc6d4, 0x20, 0x64, 0xc77c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x2d, 0x27, 0x436, 0x27, 0x2e, 0x2c, 0x20,
0x64, 0x2d, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x20, 0xe97, 0xeb5, 0x20,
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x64, 0x64, 0x64, 0x2c, 0x20, 0x27, 0x64, 0x69, 0x65, 0x27, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79,
0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x27, 0x67, 0x61, 0x64, 0x61, 0x27,
0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20,
0x27, 0x64, 0x6f, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x6d, 0x27, 0x2e, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x20, 0x27, 0x64, 0x27, 0x2e, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
0x2c, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2c, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x20, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x27, 0x74, 0x61,
0x27, 0x2019, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20,
0x79, 0x79, 0x79, 0x79, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x202f, 0x27, 0x43e, 0x43d, 0x44b, 0x27,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x27, 0x44b, 0x43d, 0x27, 0x20, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x20, 0x27, 0x433,
0x430, 0x440, 0x430, 0x433, 0x27, 0x79, 0x79, 0x79, 0x79, 0x20, 0x1823, 0x1828, 0x20, 0x180e, 0x180e, 0x180e, 0x1824, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x180e, 0x180e, 0x1822, 0x1822, 0x1828, 0x64, 0x2e, 0x20, 0x64, 0x64, 0x64, 0x64, 0x20, 0x180b, 0x182d, 0x1820, 0x1837, 0x1820,
0x182d, 0x64, 0x64, 0x64, 0x64, 0x20, 0x2c, 0x20, 0x27, 0x6c, 0x79, 0x25b, 0x27, 0x30c, 0x2bc, 0x20, 0x64, 0x20, 0x27, 0x6e,
0x61, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20,
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x202f, 0x27, 0x430, 0x437, 0x27, 0x64, 0x64, 0x64,
0x64, 0x20, 0x62f, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x62f, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x2e, 0x4d,
0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x6d, 0x65,
0x74, 0x74, 0x61, 0x73, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x64, 0x64, 0x2d, 0x4d, 0x4d, 0x2d, 0x79,
0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x27, 0x69, 0x6c, 0x73, 0x27, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20,
0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x202f, 0x27, 0x441, 0x44b, 0x43b, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20,
0x64, 0x20, 0x27, 0x43a, 0x4af, 0x43d, 0x44d, 0x27, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64,
0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x27, 0x73, 0x75, 0x27,
0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64,
0x64, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79,
0x79, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x2f, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79,
0x79, 0x202f, 0x27, 0x435, 0x43b, 0x27, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20,
0x79, 0x79, 0x79, 0x79, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0xe17, 0xe35, 0xe48, 0x20, 0x64, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0xf60, 0xf72,
0xf0b, 0xf5a, 0xf7a, 0xf66, 0xf0b, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x1361, 0x20, 0x64, 0x64,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x12ee, 0x121d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x1363, 0x20, 0x64,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x60c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x60c,
0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x64, 0x64, 0x64,
0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x202f, 0x27,
0x440, 0x27, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x20, 0x64, 0x2d, 0x4d, 0x4d, 0x4d, 0x4d, 0x60c, 0x20, 0x64, 0x64, 0x64, 0x64,
0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2d, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79,
0x79, 0x79, 0x20, 0x646, 0x686, 0x6cc, 0x20, 0x6cc, 0x6cc, 0x644, 0x20, 0x64, 0x20, 0x646, 0x686, 0x6cc, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x20, 0x64, 0x64, 0x64, 0x64, 0x20, 0x6a9, 0x648, 0x646, 0x6cc, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d,
0x27, 0x61, 0x27, 0x20, 0x27, 0x64, 0x27, 0x2e, 0x20, 0x64, 0x27, 0x69, 0x64, 0x27, 0x64, 0x64, 0x64, 0x64, 0x1365, 0x20,
0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x130b, 0x120b, 0x1233, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64,
0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64,
0x5d8, 0x5df, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20,
0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79
};

static const ushort time_format_data[] = {
0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x48, 0x48,
0x3a, 0x6d, 0x6d, 0x68, 0x3a, 0x6d, 0x6d, 0x202f, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x202f, 0x41, 0x50,
0x20, 0x74, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x202f, 0x41, 0x50, 0x2c, 0x20, 0x74, 0x68, 0x3a, 0x6d, 0x6d, 0x20,
0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x48, 0x3a,
0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x41, 0x50, 0x20, 0x68, 0x2e, 0x6d, 0x6d, 0x41, 0x50, 0x20, 0x68, 0x2e, 0x6d,
0x6d, 0x2e, 0x73, 0x73, 0x20, 0x74, 0x68, 0x68, 0x3a, 0x6d, 0x6d, 0x20, 0x41, 0x50, 0x68, 0x68, 0x3a, 0x6d, 0x6d, 0x3a,
0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x68, 0x68, 0x3a, 0x6d, 0x6d, 0x202f, 0x41, 0x50, 0x68, 0x68, 0x3a, 0x6d, 0x6d,
0x3a, 0x73, 0x73, 0x202f, 0x41, 0x50, 0x20, 0x74, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x28, 0x74, 0x29,
0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x2c, 0x20, 0x74, 0x41, 0x50, 0x20, 0x928, 0x93f, 0x20, 0x68, 0x3a, 0x6d,
0x6d, 0x41, 0x50, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x20, 0x27, 0x447,
0x27, 0x2e, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x27, 0x447, 0x27, 0x2e, 0x20, 0x74, 0x74, 0x20, 0x48, 0x48,
0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73,
0x73, 0x20, 0x5b, 0x74, 0x5d, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x28, 0x74, 0x29, 0x74, 0x20, 0x41, 0x50,
0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x42, 0x68, 0x3a, 0x6d, 0x6d, 0x42, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73,
0x20, 0x5b, 0x74, 0x5d, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x2c, 0x20, 0x74, 0x48, 0x48, 0x2e, 0x6d, 0x6d, 0x48,
0x48, 0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x74, 0xf46, 0xf74, 0xf0b, 0xf5a, 0xf7c, 0xf51, 0xf0b, 0x20, 0x68, 0x20, 0xf66,
0xf90, 0xf62, 0xf0b, 0xf58, 0xf0b, 0x20, 0x6d, 0x6d, 0x20, 0x41, 0x50, 0xf46, 0xf74, 0xf0b, 0xf5a, 0xf7c, 0xf51, 0xf0b, 0x20, 0x68,
0x20, 0xf66, 0xf90, 0xf62, 0xf0b, 0xf58, 0xf0b, 0x20, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x48, 0x2e,
0x6d, 0x6d, 0x48, 0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x74, 0x48, 0x2d, 0x27, 0x61, 0x27, 0x20, 0x27, 0x68, 0x6f,
0x72, 0x6f, 0x27, 0x20, 0x27, 0x6b, 0x61, 0x6a, 0x27, 0x20, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x41, 0x50, 0x20, 0x27,
0x67, 0x61, 0x27, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x41, 0x50, 0x20, 0x27, 0x67, 0x61, 0x27, 0x20, 0x68, 0x3a, 0x6d, 0x6d,
0x3a, 0x73, 0x73, 0x20, 0x74, 0x48, 0x20, 0x27, 0x68, 0x27, 0x20, 0x6d, 0x6d, 0x20, 0x27, 0x6d, 0x69, 0x6e, 0x27, 0x20,
0x73, 0x73, 0x20, 0x27, 0x73, 0x27, 0x20, 0x74, 0x48, 0x48, 0x20, 0x27, 0x68, 0x27, 0x20, 0x6d, 0x6d, 0x48, 0x48, 0x20,
0x27, 0x68, 0x27, 0x20, 0x6d, 0x6d, 0x20, 0x27, 0x6d, 0x69, 0x6e, 0x27, 0x20, 0x73, 0x73, 0x20, 0x27, 0x73, 0x27, 0x20,
0x74, 0x48, 0x48, 0x2e, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x27, 0x68, 0x27, 0x20, 0x74, 0x48, 0x6642, 0x6d, 0x6d, 0x5206,
0x73, 0x73, 0x79d2, 0x20, 0x74, 0x41, 0x50, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x41, 0x50, 0x20, 0x68, 0xc2dc, 0x20, 0x6d, 0xbd84,
0x20, 0x73, 0xcd08, 0x20, 0x74, 0x48, 0x20, 0xec2, 0xea1, 0xe87, 0x20, 0x6d, 0x20, 0xe99, 0xeb2, 0xe97, 0xeb5, 0x20, 0x73, 0x73,
0x20, 0xea7, 0xeb4, 0xe99, 0xeb2, 0xe97, 0xeb5, 0x20, 0x74, 0x27, 0x4b, 0x6c, 0x27, 0x2e, 0x20, 0x48, 0x2e, 0x6d, 0x6d, 0x27,
0x4b, 0x6c, 0x6f, 0x63, 0x6b, 0x27, 0x20, 0x48, 0x2e, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x28, 0x74, 0x29, 0x68, 0x2e,
0x6d, 0x6d, 0x2e, 0x20, 0x41, 0x50, 0x68, 0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x27, 0x6b,
0x6c, 0x27, 0x2e, 0x20, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x74, 0x20, 0x68, 0x3a, 0x6d, 0x6d,
0x3a, 0x73, 0x73, 0x202f, 0x41, 0x50, 0x48, 0x27, 0x68, 0x27, 0x6d, 0x6d, 0x48, 0x20, 0xe19, 0xe32, 0xe2c, 0xe34, 0xe01, 0xe32,
0x20, 0x6d, 0x6d, 0x20, 0xe19, 0xe32, 0xe17, 0xe35, 0x20, 0x73, 0x73, 0x20, 0xe27, 0xe34, 0xe19, 0xe32, 0xe17, 0xe35, 0x20, 0x74,
0x48, 0x3a, 0x6d, 0x6d, 0x20, 0x27, 0x68, 0x6f, 0x64, 0x17a, 0x27, 0x2e, 0x48, 0x3a, 0x6d
};

static const ushort months_data[] = {
0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b,
0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x63, 0x74, 0x3b,
0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x79, 0x3b, 0x46, 0x65, 0x62, 0x72,
0x75, 0x61, 0x72, 0x79, 0x3b, 0x4d, 0x61, 0x72, 0x63, 0x68, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x79,
0x3b, 0x4a, 0x75, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6c, 0x79, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65,
0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x31, 0x3b,
0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31,
0x31, 0x3b, 0x31, 0x32, 0x3b, 0x410, 0x436, 0x44c, 0x3b, 0x416, 0x259, 0x430, 0x431, 0x3b, 0x425, 0x259, 0x430, 0x436, 0x4d9, 0x3b,
0x41c, 0x448, 0x3b, 0x41b, 0x430, 0x4b5, 0x3b, 0x420, 0x430, 0x448, 0x4d9, 0x3b, 0x524, 0x445, 0x44b, 0x43d, 0x433, 0x4d9, 0x3b, 0x41d,
0x430, 0x43d, 0x4b3, 0x4d9, 0x3b, 0x426, 0x259, 0x44b, 0x431, 0x3b, 0x416, 0x44c, 0x4ad, 0x3b, 0x410, 0x431, 0x4b5, 0x3b, 0x524, 0x445,
0x44b, 0x43d, 0x4b7, 0x3b, 0x410, 0x436, 0x44c, 0x44b, 0x440, 0x43d, 0x44b, 0x4b3, 0x259, 0x430, 0x3b, 0x416, 0x259, 0x430, 0x431, 0x440,
0x430, 0x43d, 0x3b, 0x425, 0x259, 0x430, 0x436, 0x259, 0x43a, 0x44b, 0x440, 0x430, 0x3b, 0x41c, 0x448, 0x430, 0x525, 0x44b, 0x3b, 0x41b,
0x430, 0x4b5, 0x430, 0x440, 0x430, 0x3b, 0x420, 0x430, 0x448, 0x259, 0x430, 0x440, 0x430, 0x3b, 0x524, 0x445, 0x44b, 0x43d, 0x433, 0x259,
0x44b, 0x3b, 0x41d, 0x430, 0x43d, 0x4b3, 0x259, 0x430, 0x3b, 0x426, 0x259, 0x44b, 0x431, 0x431, 0x440, 0x430, 0x3b, 0x416, 0x44c, 0x4ad,
0x430, 0x430, 0x440, 0x430, 0x3b, 0x410, 0x431, 0x4b5, 0x430, 0x440, 0x430, 0x3b, 0x524, 0x445, 0x44b, 0x43d, 0x4b7, 0x43a, 0x4d9, 0x44b,
0x43d, 0x3b, 0x416, 0x44c, 0x3b, 0x416, 0x259, 0x3b, 0x425, 0x259, 0x3b, 0x41c, 0x3b, 0x41b, 0x3b, 0x420, 0x3b, 0x413, 0x4d9, 0x3b,
0x41d, 0x3b, 0x426, 0x4d9, 0x3b, 0x4ac, 0x3b, 0x411, 0x3b, 0x4b6, 0x3b, 0x416, 0x44c, 0x3b, 0x416, 0x259, 0x3b, 0x425, 0x259, 0x3b,
0x41c, 0x3b, 0x41b, 0x3b, 0x420, 0x3b, 0x413, 0x4d9, 0x3b, 0x41d, 0x3b, 0x426, 0x259, 0x3b, 0x4ac, 0x3b, 0x411, 0x3b, 0x4b6, 0x3b,
0x51, 0x75, 0x6e, 0x3b, 0x4e, 0x61, 0x68, 0x3b, 0x43, 0x69, 0x67, 0x3b, 0x41, 0x67, 0x64, 0x3b, 0x43, 0x61, 0x78, 0x3b,
0x51, 0x61, 0x73, 0x3b, 0x51, 0x61, 0x64, 0x3b, 0x4c, 0x65, 0x71, 0x3b, 0x57, 0x61, 0x79, 0x3b, 0x44, 0x69, 0x74, 0x3b,
0x58, 0x69, 0x6d, 0x3b, 0x4b, 0x61, 0x78, 0x3b, 0x51, 0x75, 0x6e, 0x78, 0x61, 0x20, 0x47, 0x61, 0x72, 0x61, 0x62, 0x6c,
0x75, 0x3b, 0x4b, 0x75, 0x64, 0x6f, 0x3b, 0x43, 0x69, 0x67, 0x67, 0x69, 0x6c, 0x74, 0x61, 0x20, 0x4b, 0x75, 0x64, 0x6f,
0x3b, 0x41, 0x67, 0x64, 0x61, 0x20, 0x42, 0x61, 0x78, 0x69, 0x73, 0x3b, 0x43, 0x61, 0x78, 0x61, 0x68, 0x20, 0x41, 0x6c,
0x73, 0x61, 0x3b, 0x51, 0x61, 0x73, 0x61, 0x20, 0x44, 0x69, 0x72, 0x72, 0x69, 0x3b, 0x51, 0x61, 0x64, 0x6f, 0x20, 0x44,
0x69, 0x72, 0x72, 0x69, 0x3b, 0x4c, 0x69, 0x69, 0x71, 0x65, 0x6e, 0x3b, 0x57, 0x61, 0x79, 0x73, 0x75, 0x3b, 0x44, 0x69,
0x74, 0x65, 0x6c, 0x69, 0x3b, 0x58, 0x69, 0x6d, 0x6f, 0x6c, 0x69, 0x3b, 0x4b, 0x61, 0x78, 0x78, 0x61, 0x20, 0x47, 0x61,
0x72, 0x61, 0x62, 0x6c, 0x75, 0x3b, 0x51, 0x3b, 0x4e, 0x3b, 0x43, 0x3b, 0x41, 0x3b, 0x43, 0x3b, 0x51, 0x3b, 0x51, 0x3b,
0x4c, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x58, 0x3b, 0x4b, 0x3b, 0x51, 0x75, 0x6e, 0x78, 0x61, 0x20, 0x47, 0x61, 0x72, 0x61,
0x62, 0x6c, 0x75, 0x3b, 0x4b, 0x75, 0x64, 0x6f, 0x3b, 0x43, 0x69, 0x67, 0x67, 0x69, 0x6c, 0x74, 0x61, 0x20, 0x4b, 0x75,
0x64, 0x6f, 0x3b, 0x41, 0x67, 0x64, 0x61, 0x20, 0x42, 0x61, 0x78, 0x69, 0x73, 0x3b, 0x43, 0x61, 0x78, 0x61, 0x68, 0x20,
0x41, 0x6c, 0x73, 0x61, 0x3b, 0x51, 0x61, 0x73, 0x61, 0x20, 0x44, 0x69, 0x72, 0x72, 0x69, 0x3b, 0x51, 0x61, 0x64, 0x6f,
0x20, 0x44, 0x69, 0x72, 0x72, 0x69, 0x3b, 0x4c, 0x65, 0x71, 0x65, 0x65, 0x6e, 0x69, 0x3b, 0x57, 0x61, 0x79, 0x73, 0x75,
0x3b, 0x44, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x3b, 0x58, 0x69, 0x6d, 0x6f, 0x6c, 0x69, 0x3b, 0x4b, 0x61, 0x78, 0x78, 0x61,
0x20, 0x47, 0x61, 0x72, 0x61, 0x62, 0x6c, 0x75, 0x3b, 0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d,
0x72, 0x74, 0x2e, 0x3b, 0x41, 0x70, 0x72, 0x2e, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x2e, 0x3b, 0x4a, 0x75,
0x6c, 0x2e, 0x3b, 0x41, 0x75, 0x67, 0x2e, 0x3b, 0x53, 0x65, 0x70, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f,
0x76, 0x2e, 0x3b, 0x44, 0x65, 0x73, 0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b, 0x46, 0x65, 0x62,
0x72, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b, 0x4d, 0x61, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d,
0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x65, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x65, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73,
0x74, 0x75, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65,
0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x6e, 0xf9, 0x6d, 0x3b, 0x6b, 0x268, 0x7a, 0x3b, 0x74, 0x268, 0x64, 0x3b, 0x74, 0x61, 0x61, 0x3b, 0x73, 0x65, 0x65, 0x3b,
0x6e, 0x7a, 0x75, 0x3b, 0x64, 0x75, 0x6d, 0x3b, 0x66, 0x254, 0x65, 0x3b, 0x64, 0x7a, 0x75, 0x3b, 0x6c, 0x254, 0x6d, 0x3b,
0x6b, 0x61, 0x61, 0x3b, 0x66, 0x77, 0x6f, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x6e, 0xf9, 0x6d, 0x3b,
0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x6b, 0x197, 0x300, 0x7a, 0xf9, 0x294, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300,
0x14b, 0x254, 0x300, 0x74, 0x197, 0x300, 0x64, 0x289, 0x300, 0x67, 0x68, 0xe0, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254,
0x300, 0x74, 0x1ce, 0x61, 0x66, 0x289, 0x304, 0x67, 0x68, 0x101, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0xe8, 0x73, 0xe8,
0x65, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x6e, 0x7a, 0xf9, 0x67, 0x68, 0xf2, 0x3b, 0x6e, 0x64, 0x7a,
0x254, 0x300, 0x14b, 0x254, 0x300, 0x64, 0xf9, 0x6d, 0x6c, 0x6f, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x6b,
0x77, 0xee, 0x66, 0x254, 0x300, 0x65, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x74, 0x197, 0x300, 0x66, 0x289,
0x300, 0x67, 0x68, 0xe0, 0x64, 0x7a, 0x75, 0x67, 0x68, 0xf9, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x67,
0x68, 0x1d4, 0x75, 0x77, 0x65, 0x6c, 0x254, 0x300, 0x6d, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x63, 0x68,
0x77, 0x61, 0x294, 0xe0, 0x6b, 0x61, 0x61, 0x20, 0x77, 0x6f, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0xe8, 0x66, 0x77,
0xf2, 0x6f, 0x3b, 0x6e, 0x3b, 0x6b, 0x3b, 0x74, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x7a, 0x3b, 0x6b, 0x3b, 0x66, 0x3b, 0x64,
0x3b, 0x6c, 0x3b, 0x63, 0x3b, 0x66, 0x3b, 0x53, 0x2d, 0x186, 0x3b, 0x4b, 0x2d, 0x186, 0x3b, 0x45, 0x2d, 0x186, 0x3b, 0x45,
0x2d, 0x4f, 0x3b, 0x45, 0x2d, 0x4b, 0x3b, 0x4f, 0x2d, 0x41, 0x3b, 0x41, 0x2d, 0x4b, 0x3b, 0x44, 0x2d, 0x186, 0x3b, 0x46,
0x2d, 0x190, 0x3b, 0x186, 0x2d, 0x41, 0x3b, 0x186, 0x2d, 0x4f, 0x3b, 0x4d, 0x2d, 0x186, 0x3b, 0x53, 0x61, 0x6e, 0x64, 0x61,
0x2d, 0x186, 0x70, 0x25b, 0x70, 0x254, 0x6e, 0x3b, 0x4b, 0x77, 0x61, 0x6b, 0x77, 0x61, 0x72, 0x2d, 0x186, 0x67, 0x79, 0x65,
0x66, 0x75, 0x6f, 0x3b, 0x45, 0x62, 0x254, 0x77, 0x2d, 0x186, 0x62, 0x65, 0x6e, 0x65, 0x6d, 0x3b, 0x45, 0x62, 0x254, 0x62,
0x69, 0x72, 0x61, 0x2d, 0x4f, 0x66, 0x6f, 0x72, 0x69, 0x73, 0x75, 0x6f, 0x3b, 0x45, 0x73, 0x75, 0x73, 0x6f, 0x77, 0x20,
0x41, 0x6b, 0x65, 0x74, 0x73, 0x65, 0x61, 0x62, 0x61, 0x2d, 0x4b, 0x254, 0x74, 0x254, 0x6e, 0x69, 0x6d, 0x62, 0x61, 0x3b,
0x4f, 0x62, 0x69, 0x72, 0x61, 0x64, 0x65, 0x2d, 0x41, 0x79, 0x25b, 0x77, 0x6f, 0x68, 0x6f, 0x6d, 0x75, 0x6d, 0x75, 0x3b,
0x41, 0x79, 0x25b, 0x77, 0x6f, 0x68, 0x6f, 0x2d, 0x4b, 0x69, 0x74, 0x61, 0x77, 0x6f, 0x6e, 0x73, 0x61, 0x3b, 0x44, 0x69,
0x66, 0x75, 0x75, 0x2d, 0x186, 0x73, 0x61, 0x6e, 0x64, 0x61, 0x61, 0x3b, 0x46, 0x61, 0x6e, 0x6b, 0x77, 0x61, 0x2d, 0x190,
0x62, 0x254, 0x3b, 0x186, 0x62, 0x25b, 0x73, 0x25b, 0x2d, 0x41, 0x68, 0x69, 0x6e, 0x69, 0x6d, 0x65, 0x3b, 0x186, 0x62, 0x65,
0x72, 0x25b, 0x66, 0x25b, 0x77, 0x2d, 0x4f, 0x62, 0x75, 0x62, 0x75, 0x6f, 0x3b, 0x4d, 0x75, 0x6d, 0x75, 0x2d, 0x186, 0x70,
0x25b, 0x6e, 0x69, 0x6d, 0x62, 0x61, 0x3b, 0x4d, 0x30, 0x31, 0x3b, 0x4d, 0x30, 0x32, 0x3b, 0x4d, 0x30, 0x33, 0x3b, 0x4d,
0x30, 0x34, 0x3b, 0x4d, 0x30, 0x35, 0x3b, 0x4d, 0x30, 0x36, 0x3b, 0x4d, 0x30, 0x37, 0x3b, 0x4d, 0x30, 0x38, 0x3b, 0x4d,
0x30, 0x39, 0x3b, 0x4d, 0x31, 0x30, 0x3b, 0x4d, 0x31, 0x31, 0x3b, 0x4d, 0x31, 0x32, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x73,
0x68, 0x6b, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x70, 0x72, 0x69, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x71, 0x65, 0x72, 0x3b, 0x6b,
0x6f, 0x72, 0x72, 0x3b, 0x67, 0x75, 0x73, 0x68, 0x3b, 0x73, 0x68, 0x74, 0x3b, 0x74, 0x65, 0x74, 0x3b, 0x6e, 0xeb, 0x6e,
0x3b, 0x64, 0x68, 0x6a, 0x3b, 0x6a, 0x61, 0x6e, 0x61, 0x72, 0x3b, 0x73, 0x68, 0x6b, 0x75, 0x72, 0x74, 0x3b, 0x6d, 0x61,
0x72, 0x73, 0x3b, 0x70, 0x72, 0x69, 0x6c, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x71, 0x65, 0x72, 0x73, 0x68, 0x6f, 0x72,
0x3b, 0x6b, 0x6f, 0x72, 0x72, 0x69, 0x6b, 0x3b, 0x67, 0x75, 0x73, 0x68, 0x74, 0x3b, 0x73, 0x68, 0x74, 0x61, 0x74, 0x6f,
0x72, 0x3b, 0x74, 0x65, 0x74, 0x6f, 0x72, 0x3b, 0x6e, 0xeb, 0x6e, 0x74, 0x6f, 0x72, 0x3b, 0x64, 0x68, 0x6a, 0x65, 0x74,
0x6f, 0x72, 0x3b, 0x6a, 0x3b, 0x73, 0x68, 0x3b, 0x6d, 0x3b, 0x70, 0x3b, 0x6d, 0x3b, 0x71, 0x3b, 0x6b, 0x3b, 0x67, 0x3b,
0x73, 0x68, 0x3b, 0x74, 0x3b, 0x6e, 0x3b, 0x64, 0x68, 0x3b, 0x1303, 0x1295, 0x12e9, 0x3b, 0x134c, 0x1265, 0x1229, 0x3b, 0x121b, 0x122d,
0x127d, 0x3b, 0x12a4, 0x1355, 0x122a, 0x3b, 0x121c, 0x12ed, 0x3b, 0x1301, 0x1295, 0x3b, 0x1301, 0x120b, 0x12ed, 0x3b, 0x12a6, 0x1308, 0x1235, 0x3b,
0x1234, 0x1355, 0x1274, 0x3b, 0x12a6, 0x12ad, 0x1276, 0x3b, 0x1296, 0x126c, 0x121d, 0x3b, 0x12f2, 0x1234, 0x121d, 0x3b, 0x1303, 0x1295, 0x12e9, 0x12c8,
0x122a, 0x3b, 0x134c, 0x1265, 0x1229, 0x12c8, 0x122a, 0x3b, 0x121b, 0x122d, 0x127d, 0x3b, 0x12a4, 0x1355, 0x122a, 0x120d, 0x3b, 0x121c, 0x12ed, 0x3b,
0x1301, 0x1295, 0x3b, 0x1301, 0x120b, 0x12ed, 0x3b, 0x12a6, 0x1308, 0x1235, 0x1275, 0x3b, 0x1234, 0x1355, 0x1274, 0x121d, 0x1260, 0x122d, 0x3b, 0x12a6,
0x12ad, 0x1276, 0x1260, 0x122d, 0x3b, 0x1296, 0x126c, 0x121d, 0x1260, 0x122d, 0x3b, 0x12f2, 0x1234, 0x121d, 0x1260, 0x122d, 0x3b, 0x1303, 0x3b, 0x134c,
0x3b, 0x121b, 0x3b, 0x12a4, 0x3b, 0x121c, 0x3b, 0x1301, 0x3b, 0x1301, 0x3b, 0x12a6, 0x3b, 0x1234, 0x3b, 0x12a6, 0x3b, 0x1296, 0x3b, 0x12f2,
0x3b, 0x64a, 0x646, 0x627, 0x64a, 0x631, 0x3b, 0x641, 0x628, 0x631, 0x627, 0x64a, 0x631, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x623,
0x628, 0x631, 0x64a, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x646, 0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x644, 0x64a,
0x648, 0x3b, 0x623, 0x63a, 0x633, 0x637, 0x633, 0x3b, 0x633, 0x628, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x623, 0x643, 0x62a, 0x648, 0x628,
0x631, 0x3b, 0x646, 0x648, 0x641, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x64a, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x64a, 0x3b, 0x641, 0x3b,
0x645, 0x3b, 0x623, 0x3b, 0x648, 0x3b, 0x646, 0x3b, 0x644, 0x3b, 0x63a, 0x3b, 0x633, 0x3b, 0x643, 0x3b, 0x628, 0x3b, 0x62f, 0x3b,
0x62c, 0x627, 0x646, 0x641, 0x64a, 0x3b, 0x641, 0x64a, 0x641, 0x631, 0x64a, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x623, 0x641, 0x631,
0x64a, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x3b, 0x62c, 0x648, 0x627, 0x646, 0x3b, 0x62c, 0x648, 0x64a, 0x644, 0x64a, 0x629, 0x3b, 0x623,
0x648, 0x62a, 0x3b, 0x633, 0x628, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x623, 0x643, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x641,
0x645, 0x628, 0x631, 0x3b, 0x62f, 0x64a, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x62c, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x623, 0x3b, 0x645,
0x3b, 0x62c, 0x3b, 0x62c, 0x3b, 0x623, 0x3b, 0x633, 0x3b, 0x623, 0x3b, 0x646, 0x3b, 0x62f, 0x3b, 0x643, 0x627, 0x646, 0x648, 0x646,
0x20, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x64a, 0x3b, 0x634, 0x628, 0x627, 0x637, 0x3b, 0x622, 0x630, 0x627, 0x631, 0x3b, 0x646, 0x64a,
0x633, 0x627, 0x646, 0x3b, 0x623, 0x64a, 0x627, 0x631, 0x3b, 0x62d, 0x632, 0x64a, 0x631, 0x627, 0x646, 0x3b, 0x62a, 0x645, 0x648, 0x632,
0x3b, 0x622, 0x628, 0x3b, 0x623, 0x64a, 0x644, 0x648, 0x644, 0x3b, 0x62a, 0x634, 0x631, 0x64a, 0x646, 0x20, 0x627, 0x644, 0x623, 0x648,
0x644, 0x3b, 0x62a, 0x634, 0x631, 0x64a, 0x646, 0x20, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x64a, 0x3b, 0x643, 0x627, 0x646, 0x648, 0x646,
0x20, 0x627, 0x644, 0x623, 0x648, 0x644, 0x3b, 0x643, 0x3b, 0x634, 0x3b, 0x622, 0x3b, 0x646, 0x3b, 0x623, 0x3b, 0x62d, 0x3b, 0x62a,
0x3b, 0x622, 0x3b, 0x623, 0x3b, 0x62a, 0x3b, 0x62a, 0x3b, 0x643, 0x3b, 0x643, 0x627, 0x646, 0x648, 0x646, 0x20, 0x627, 0x644, 0x62b,
0x627, 0x646, 0x64a, 0x3b, 0x634, 0x628, 0x627, 0x637, 0x3b, 0x622, 0x630, 0x627, 0x631, 0x3b, 0x646, 0x64a, 0x633, 0x627, 0x646, 0x3b,
0x623, 0x64a, 0x627, 0x631, 0x3b, 0x62d, 0x632, 0x64a, 0x631, 0x627, 0x646, 0x3b, 0x62a, 0x645, 0x648, 0x632, 0x3b, 0x622, 0x628, 0x3b,
0x623, 0x64a, 0x644, 0x648, 0x644, 0x3b, 0x62a, 0x634, 0x631, 0x64a, 0x646, 0xa0, 0x627, 0x644, 0x623, 0x648, 0x644, 0x3b, 0x62a, 0x634,
0x631, 0x64a, 0x646, 0x20, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x64a, 0x3b, 0x643, 0x627, 0x646, 0x648, 0x646, 0x20, 0x627, 0x644, 0x623,
0x648, 0x644, 0x3b, 0x64a, 0x646, 0x627, 0x64a, 0x631, 0x3b, 0x641, 0x628, 0x631, 0x627, 0x64a, 0x631, 0x3b, 0x645, 0x627, 0x631, 0x633,
0x3b, 0x625, 0x628, 0x631, 0x64a, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x646, 0x64a, 0x648, 0x3b, 0x64a, 0x648,
0x644, 0x64a, 0x648, 0x3b, 0x623, 0x63a, 0x634, 0x62a, 0x3b, 0x634, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x623, 0x643, 0x62a, 0x648, 0x628,
0x631, 0x3b, 0x646, 0x648, 0x641, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x62c, 0x645, 0x628, 0x631, 0x3b, 0x64a, 0x3b, 0x641, 0x3b, 0x645,
0x3b, 0x625, 0x3b, 0x648, 0x3b, 0x646, 0x3b, 0x644, 0x3b, 0x63a, 0x3b, 0x634, 0x3b, 0x643, 0x3b, 0x628, 0x3b, 0x62f, 0x3b, 0x64a,
0x646, 0x627, 0x64a, 0x631, 0x3b, 0x641, 0x628, 0x631, 0x627, 0x64a, 0x631, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x623, 0x628, 0x631,
0x64a, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x3b, 0x64a, 0x648, 0x646, 0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x644, 0x64a, 0x648, 0x632, 0x3b,
0x63a, 0x634, 0x62a, 0x3b, 0x634, 0x62a, 0x646, 0x628, 0x631, 0x3b, 0x623, 0x643, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x646,
0x628, 0x631, 0x3b, 0x62f, 0x62c, 0x646, 0x628, 0x631, 0x3b, 0x64a, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x623, 0x3b, 0x645, 0x3b, 0x646,
0x3b, 0x644, 0x3b, 0x63a, 0x3b, 0x634, 0x3b, 0x643, 0x3b, 0x628, 0x3b, 0x62f, 0x3b, 0x63, 0x68, 0x69, 0x2e, 0x3b, 0x66, 0x65,
0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x79, 0x2e, 0x3b, 0x63, 0x68,
0x6e, 0x2e, 0x3b, 0x63, 0x68, 0x6c, 0x2e, 0x3b, 0x61, 0x67, 0x6f, 0x2e, 0x3b, 0x73, 0x65, 0x74, 0x2e, 0x3b, 0x6f, 0x63,
0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x61, 0x76, 0x69, 0x2e, 0x3b, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x72, 0x6f,
0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c,
0x3b, 0x6d, 0x61, 0x79, 0x6f, 0x3b, 0x63, 0x68, 0x75, 0x6e, 0x79, 0x6f, 0x3b, 0x63, 0x68, 0x75, 0x6c, 0x69, 0x6f, 0x6c,
0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63,
0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x61, 0x76, 0x69, 0x65,
0x6e, 0x74, 0x6f, 0x3b, 0x64, 0x65, 0x20, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x72, 0x6f, 0x3b, 0x64, 0x65, 0x20, 0x66, 0x65,
0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x64, 0x2019, 0x61, 0x62, 0x72,
0x69, 0x6c, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x79, 0x6f, 0x3b, 0x64, 0x65, 0x20, 0x63, 0x68, 0x75, 0x6e, 0x79, 0x6f,
0x3b, 0x64, 0x65, 0x20, 0x63, 0x68, 0x75, 0x6c, 0x69, 0x6f, 0x6c, 0x3b, 0x64, 0x2019, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f,
0x3b, 0x64, 0x65, 0x20, 0x73, 0x65, 0x74, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x2019, 0x6f, 0x63, 0x74, 0x75,
0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x20, 0x6e, 0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x2019, 0x61,
0x76, 0x69, 0x65, 0x6e, 0x74, 0x6f, 0x3b, 0x570, 0x576, 0x57e, 0x3b, 0x583, 0x57f, 0x57e, 0x3b, 0x574, 0x580, 0x57f, 0x3b, 0x561,
0x57a, 0x580, 0x3b, 0x574, 0x575, 0x57d, 0x3b, 0x570, 0x576, 0x57d, 0x3b, 0x570, 0x56c, 0x57d, 0x3b, 0x585, 0x563, 0x57d, 0x3b, 0x57d,
0x565, 0x57a, 0x3b, 0x570, 0x578, 0x56f, 0x3b, 0x576, 0x578, 0x575, 0x3b, 0x564, 0x565, 0x56f, 0x3b, 0x570, 0x578, 0x582, 0x576, 0x57e,
0x561, 0x580, 0x3b, 0x583, 0x565, 0x57f, 0x580, 0x57e, 0x561, 0x580, 0x3b, 0x574, 0x561, 0x580, 0x57f, 0x3b, 0x561, 0x57a, 0x580, 0x56b,
0x56c, 0x3b, 0x574, 0x561, 0x575, 0x56b, 0x57d, 0x3b, 0x570, 0x578, 0x582, 0x576, 0x56b, 0x57d, 0x3b, 0x570, 0x578, 0x582, 0x56c, 0x56b,
0x57d, 0x3b, 0x585, 0x563, 0x578, 0x57d, 0x57f, 0x578, 0x57d, 0x3b, 0x57d, 0x565, 0x57a, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b,
0x570, 0x578, 0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x576, 0x578, 0x575, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x564,
0x565, 0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x540, 0x3b, 0x553, 0x3b, 0x544, 0x3b, 0x531, 0x3b, 0x544, 0x3b, 0x540,
0x3b, 0x540, 0x3b, 0x555, 0x3b, 0x54d, 0x3b, 0x540, 0x3b, 0x546, 0x3b, 0x534, 0x3b, 0x570, 0x578, 0x582, 0x576, 0x57e, 0x561, 0x580,
0x56b, 0x3b, 0x583, 0x565, 0x57f, 0x580, 0x57e, 0x561, 0x580, 0x56b, 0x3b, 0x574, 0x561, 0x580, 0x57f, 0x56b, 0x3b, 0x561, 0x57a, 0x580,
0x56b, 0x56c, 0x56b, 0x3b, 0x574, 0x561, 0x575, 0x56b, 0x57d, 0x56b, 0x3b, 0x570, 0x578, 0x582, 0x576, 0x56b, 0x57d, 0x56b, 0x3b, 0x570,
0x578, 0x582, 0x56c, 0x56b, 0x57d, 0x56b, 0x3b, 0x585, 0x563, 0x578, 0x57d, 0x57f, 0x578, 0x57d, 0x56b, 0x3b, 0x57d, 0x565, 0x57a, 0x57f,
0x565, 0x574, 0x562, 0x565, 0x580, 0x56b, 0x3b, 0x570, 0x578, 0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x56b, 0x3b, 0x576, 0x578,
0x575, 0x565, 0x574, 0x562, 0x565, 0x580, 0x56b, 0x3b, 0x564, 0x565, 0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x56b, 0x3b, 0x99c,
0x9be, 0x9a8, 0x9c1, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x9cd, 0x9f0, 0x9c1, 0x3b, 0x9ae, 0x9be, 0x9f0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd,
0x9f0, 0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x2019, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997,
0x3b, 0x99b, 0x9c7, 0x9aa, 0x9cd, 0x9a4, 0x9c7, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x3b, 0x9a8, 0x9f1, 0x9c7, 0x3b, 0x9a1, 0x9bf,
0x99a, 0x9c7, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x9f1, 0x9be, 0x9f0, 0x9c0, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x9cd, 0x9f0, 0x9c1, 0x9f1, 0x9be,
0x9f0, 0x9c0, 0x3b, 0x9ae, 0x9be, 0x9f0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9f0, 0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x2019, 0x3b,
0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x9b7, 0x9cd, 0x99f, 0x3b, 0x99b, 0x9c7, 0x9aa, 0x9cd,
0x9a4, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9f0, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x9ac, 0x9f0, 0x3b, 0x9a8, 0x9f1, 0x9c7, 0x9ae, 0x9cd,
0x9ac, 0x9f0, 0x3b, 0x9a1, 0x9bf, 0x99a, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9f0, 0x3b, 0x99c, 0x3b, 0x9ab, 0x3b, 0x9ae, 0x3b, 0x98f, 0x3b,
0x9ae, 0x3b, 0x99c, 0x3b, 0x99c, 0x3b, 0x986, 0x3b, 0x99b, 0x3b, 0x985, 0x3b, 0x9a8, 0x3b, 0x9a1, 0x3b, 0x58, 0x69, 0x6e, 0x3b,
0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x58, 0x75, 0x6e, 0x3b,
0x58, 0x6e, 0x74, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x63, 0x68, 0x3b, 0x50, 0x61, 0x79, 0x3b,
0x41, 0x76, 0x69, 0x3b, 0x78, 0x69, 0x6e, 0x65, 0x72, 0x75, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x75, 0x3b, 0x6d,
0x61, 0x72, 0x7a, 0x75, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x75, 0x3b, 0x78, 0x75, 0x6e, 0x75,
0x3b, 0x78, 0x75, 0x6e, 0x65, 0x74, 0x75, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x75, 0x3b, 0x73, 0x65, 0x74, 0x69, 0x65,
0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x68, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x70, 0x61, 0x79, 0x61, 0x72, 0x65, 0x73,
0x3b, 0x61, 0x76, 0x69, 0x65, 0x6e, 0x74, 0x75, 0x3b, 0x58, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x58,
0x3b, 0x58, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x50, 0x3b, 0x41, 0x3b, 0x78, 0x69, 0x6e, 0x3b, 0x66, 0x65, 0x62,
0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x62, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x78, 0x75, 0x6e, 0x3b, 0x78, 0x6e, 0x74,
0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x3b, 0x6f, 0x63, 0x68, 0x3b, 0x70, 0x61, 0x79, 0x3b, 0x61, 0x76, 0x69,
0x3b, 0x64, 0x65, 0x20, 0x78, 0x69, 0x6e, 0x65, 0x72, 0x75, 0x3b, 0x64, 0x65, 0x20, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72,
0x75, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x7a, 0x75, 0x3b, 0x64, 0x2019, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x64,
0x65, 0x20, 0x6d, 0x61, 0x79, 0x75, 0x3b, 0x64, 0x65, 0x20, 0x78, 0x75, 0x6e, 0x75, 0x3b, 0x64, 0x65, 0x20, 0x78, 0x75,
0x6e, 0x65, 0x74, 0x75, 0x3b, 0x64, 0x2019, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x75, 0x3b, 0x64, 0x65, 0x20, 0x73, 0x65, 0x74,
0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x2019, 0x6f, 0x63, 0x68, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x20,
0x70, 0x61, 0x79, 0x61, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x2019, 0x61, 0x76, 0x69, 0x65, 0x6e, 0x74, 0x75, 0x3b, 0x4a, 0x61,
0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75,
0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f,
0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61,
0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x65, 0x69, 0x3b,
0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65,
0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62,
0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x79, 0x6f, 0x6e, 0x3b, 0x42, 0x61, 0x61, 0x3b, 0x41,
0x74, 0x61, 0x74, 0x3b, 0x41, 0x6e, 0x61, 0x73, 0x3b, 0x41, 0x74, 0x79, 0x6f, 0x3b, 0x41, 0x63, 0x68, 0x69, 0x3b, 0x41,
0x74, 0x61, 0x72, 0x3b, 0x41, 0x77, 0x75, 0x72, 0x3b, 0x53, 0x68, 0x61, 0x64, 0x3b, 0x53, 0x68, 0x61, 0x6b, 0x3b, 0x4e,
0x61, 0x62, 0x61, 0x3b, 0x4e, 0x61, 0x74, 0x61, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x44, 0x79, 0x6f, 0x6e, 0x3b, 0x50, 0x65,
0x6e, 0x20, 0x42, 0x61, 0x2bc, 0x61, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x41, 0x74, 0x61, 0x74, 0x3b, 0x50, 0x65, 0x6e, 0x20,
0x41, 0x6e, 0x61, 0x73, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x41, 0x74, 0x79, 0x6f, 0x6e, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x41,
0x63, 0x68, 0x69, 0x72, 0x69, 0x6d, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x41, 0x74, 0x61, 0x72, 0x69, 0x62, 0x61, 0x3b, 0x50,
0x65, 0x6e, 0x20, 0x41, 0x77, 0x75, 0x72, 0x72, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x53, 0x68, 0x61, 0x64, 0x6f, 0x6e, 0x3b,
0x50, 0x65, 0x6e, 0x20, 0x53, 0x68, 0x61, 0x6b, 0x75, 0x72, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x4b, 0x75, 0x72, 0x20, 0x4e,
0x61, 0x62, 0x61, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x4b, 0x75, 0x72, 0x20, 0x4e, 0x61, 0x74, 0x61, 0x74, 0x3b, 0x79, 0x61,
0x6e, 0x3b, 0x66, 0x65, 0x76, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x69, 0x79,
0x6e, 0x3b, 0x69, 0x79, 0x6c, 0x3b, 0x61, 0x76, 0x71, 0x3b, 0x73, 0x65, 0x6e, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f,
0x79, 0x3b, 0x64, 0x65, 0x6b, 0x3b, 0x79, 0x61, 0x6e, 0x76, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x76, 0x72, 0x61, 0x6c, 0x3b,
0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x69, 0x79, 0x75, 0x6e, 0x3b,
0x69, 0x79, 0x75, 0x6c, 0x3b, 0x61, 0x76, 0x71, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x6e, 0x74, 0x79, 0x61, 0x62, 0x72,
0x3b, 0x6f, 0x6b, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x6e, 0x6f, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x64, 0x65, 0x6b, 0x61,
0x62, 0x72, 0x3b, 0x458, 0x430, 0x43d, 0x3b, 0x444, 0x435, 0x432, 0x3b, 0x43c, 0x430, 0x440, 0x3b, 0x430, 0x43f, 0x440, 0x3b, 0x43c,
0x430, 0x439, 0x3b, 0x438, 0x458, 0x43d, 0x3b, 0x438, 0x458, 0x43b, 0x3b, 0x430, 0x432, 0x433, 0x3b, 0x441, 0x435, 0x43d, 0x3b, 0x43e,
0x43a, 0x442, 0x3b, 0x43d, 0x43e, 0x458, 0x3b, 0x434, 0x435, 0x43a, 0x3b, 0x408, 0x430, 0x43d, 0x432, 0x430, 0x440, 0x3b, 0x424, 0x435,
0x432, 0x440, 0x430, 0x43b, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x3b, 0x410, 0x43f, 0x440, 0x435, 0x43b, 0x3b, 0x41c, 0x430, 0x439, 0x3b,
0x418, 0x458, 0x443, 0x43d, 0x3b, 0x418, 0x458, 0x443, 0x43b, 0x3b, 0x410, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x421, 0x435, 0x43d,
0x442, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x41e, 0x43a, 0x442, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x41d, 0x43e, 0x458, 0x430, 0x431, 0x440,
0x3b, 0x414, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x3b, 0x458, 0x430, 0x43d, 0x432, 0x430, 0x440, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430,
0x43b, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x435, 0x43b, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x458, 0x443,
0x43d, 0x3b, 0x438, 0x458, 0x443, 0x43b, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x458, 0x430,
0x431, 0x440, 0x3b, 0x43e, 0x43a, 0x442, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x43d, 0x43e, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x434, 0x435,
0x43a, 0x430, 0x431, 0x440, 0x3b, 0x14b, 0x31, 0x3b, 0x14b, 0x32, 0x3b, 0x14b, 0x33, 0x3b, 0x14b, 0x34, 0x3b, 0x14b, 0x35, 0x3b,
0x14b, 0x36, 0x3b, 0x14b, 0x37, 0x3b, 0x14b, 0x38, 0x3b, 0x14b, 0x39, 0x3b, 0x14b, 0x31, 0x30, 0x3b, 0x14b, 0x31, 0x31, 0x3b,
0x14b, 0x31, 0x32, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x20, 0x6e, 0x74, 0x254, 0x301, 0x6e, 0x74, 0x254, 0x3b, 0x14b,
0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x62, 0x25b, 0x301, 0x25b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b,
0x1dd, 0x20, 0x72, 0xe1, 0xe1, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x6e, 0x69, 0x6e, 0x3b, 0x14b,
0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x6e, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b,
0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x66, 0x254, 0x6b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1,
0x61, 0x62, 0x25b, 0x25b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x72, 0x61, 0x61,
0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x6e, 0x69, 0x6e, 0x3b, 0x14b, 0x77, 0xed,
0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x6e, 0x74, 0x25b, 0x6b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20,
0x6e, 0x74, 0x25b, 0x6b, 0x20, 0x64, 0x69, 0x20, 0x62, 0x254, 0x301, 0x6b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b,
0x1dd, 0x20, 0x6e, 0x74, 0x25b, 0x6b, 0x20, 0x64, 0x69, 0x20, 0x62, 0x25b, 0x301, 0x25b, 0x3b, 0x62c, 0x646, 0x3b, 0x67e, 0x631,
0x3b, 0x645, 0x627, 0x631, 0x3b, 0x627, 0x67e, 0x631, 0x3b, 0x645, 0x626, 0x6cc, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x6c6,
0x644, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x62a, 0x645, 0x3b, 0x627, 0x6a9, 0x62a, 0x3b, 0x646, 0x626, 0x648, 0x645, 0x3b,
0x62f, 0x633, 0x645, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x6cc, 0x3b, 0x67e, 0x631, 0x648, 0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x686,
0x3b, 0x627, 0x67e, 0x631, 0x6ce, 0x644, 0x3b, 0x645, 0x626, 0x6cc, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x6c6, 0x644, 0x627,
0x6cc, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631,
0x3b, 0x646, 0x626, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x50, 0x61,
0x72, 0x3b, 0x4d, 0xe1, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0xf3,
0x6c, 0x3b, 0x41, 0x67, 0x61, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x41, 0x6b, 0x74, 0x3b, 0x4e, 0x61, 0x77, 0x3b, 0x44, 0x61,
0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x77, 0x61, 0x72, 0x69, 0x3b, 0x50, 0x61, 0x72, 0x77, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0xe1,
0x72, 0x63, 0x68, 0x3b, 0x41, 0x70, 0x72, 0xe9, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0xf3,
0x6c, 0xe1, 0x69, 0x3b, 0x41, 0x67, 0x61, 0x73, 0x74, 0x3b, 0x53, 0x61, 0x74, 0x61, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x41,
0x6b, 0x74, 0x75, 0x62, 0x61, 0x72, 0x3b, 0x4e, 0x61, 0x77, 0x61, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x44, 0x61, 0x73, 0x61,
0x6d, 0x62, 0x61, 0x72, 0x3b, 0x7a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x77, 0x69,
0x3b, 0x6d, 0x25b, 0x3b, 0x7a, 0x75, 0x77, 0x3b, 0x7a, 0x75, 0x6c, 0x3b, 0x75, 0x74, 0x69, 0x3b, 0x73, 0x25b, 0x74, 0x3b,
0x254, 0x6b, 0x75, 0x3b, 0x6e, 0x6f, 0x77, 0x3b, 0x64, 0x65, 0x73, 0x3b, 0x7a, 0x61, 0x6e, 0x77, 0x75, 0x79, 0x65, 0x3b,
0x66, 0x65, 0x62, 0x75, 0x72, 0x75, 0x79, 0x65, 0x3b, 0x6d, 0x61, 0x72, 0x69, 0x73, 0x69, 0x3b, 0x61, 0x77, 0x69, 0x72,
0x69, 0x6c, 0x69, 0x3b, 0x6d, 0x25b, 0x3b, 0x7a, 0x75, 0x77, 0x25b, 0x6e, 0x3b, 0x7a, 0x75, 0x6c, 0x75, 0x79, 0x65, 0x3b,
0x75, 0x74, 0x69, 0x3b, 0x73, 0x25b, 0x74, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x75, 0x3b, 0x254, 0x6b, 0x75, 0x74, 0x254, 0x62,
0x75, 0x72, 0x75, 0x3b, 0x6e, 0x6f, 0x77, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x75, 0x3b, 0x64, 0x65, 0x73, 0x61, 0x6e, 0x62,
0x75, 0x72, 0x75, 0x3b, 0x5a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0x5a, 0x3b, 0x55, 0x3b,
0x53, 0x3b, 0x186, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x3b, 0x9ae, 0x9be, 0x9b0,
0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9b0, 0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2,
0x9be, 0x987, 0x3b, 0x986, 0x997, 0x9b8, 0x9cd, 0x99f, 0x3b, 0x9b8, 0x9c7, 0x9aa, 0x9cd, 0x99f, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b,
0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x9ac, 0x9b0, 0x3b, 0x9a8, 0x9ad, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x9a1, 0x9bf, 0x9b8, 0x9c7,
0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x9af, 0x9bc, 0x9be, 0x9b0, 0x9c0, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x9cd, 0x9b0,
0x9c1, 0x9af, 0x9bc, 0x9be, 0x9b0, 0x9c0, 0x3b, 0x9ae, 0x9be, 0x9b0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9b0, 0x9bf, 0x9b2, 0x3b,
0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x9b8, 0x9cd, 0x99f, 0x3b, 0x9b8,
0x9c7, 0x9aa, 0x9cd, 0x99f, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x9ac, 0x9b0, 0x3b, 0x9a8, 0x9ad,
0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x9a1, 0x9bf, 0x9b8, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x99c, 0x9be, 0x3b, 0x9ab, 0x9c7,
0x3b, 0x9ae, 0x9be, 0x3b, 0x98f, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x3b, 0x986, 0x3b, 0x9b8, 0x9c7,
0x3b, 0x985, 0x3b, 0x9a8, 0x3b, 0x9a1, 0x9bf, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x3b, 0x9ae, 0x9be, 0x9b0,
0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9b0, 0x9bf, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x3b,
0x986, 0x997, 0x3b, 0x9b8, 0x9c7, 0x9aa, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x3b, 0x9a8, 0x9ad, 0x9c7, 0x3b, 0x9a1, 0x9bf, 0x9b8,
0x9c7, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x3b, 0x9ae, 0x9be, 0x9b0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd,
0x9b0, 0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x9b8,
0x9cd, 0x99f, 0x3b, 0x9b8, 0x9c7, 0x9aa, 0x9cd, 0x99f, 0x9c7, 0x983, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x983, 0x3b, 0x9a8, 0x9ad,
0x9c7, 0x983, 0x3b, 0x9a1, 0x9bf, 0x9b8, 0x9c7, 0x983, 0x3b, 0x99c, 0x9be, 0x3b, 0x9ab, 0x9c7, 0x3b, 0x9ae, 0x9be, 0x3b, 0x98f, 0x3b,
0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x3b, 0x986, 0x3b, 0x9b8, 0x9c7, 0x3b, 0x985, 0x3b, 0x9a8, 0x3b,
0x9a1, 0x9bf, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x3b, 0x9ae, 0x9be, 0x9b0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa,
0x9cd, 0x9b0, 0x9bf, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x3b, 0x986, 0x997, 0x3b, 0x9b8, 0x9c7,
0x9aa, 0x9cd, 0x99f, 0x9c7, 0x983, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x983, 0x3b, 0x9a8, 0x9ad, 0x9c7, 0x983, 0x3b, 0x9a1, 0x9bf,
0x9b8, 0x9c7, 0x983, 0x3b, 0x6b, 0x254, 0x6e, 0x3b, 0x6d, 0x61, 0x63, 0x3b, 0x6d, 0x61, 0x74, 0x3b, 0x6d, 0x74, 0x6f, 0x3b,
0x6d, 0x70, 0x75, 0x3b, 0x68, 0x69, 0x6c, 0x3b, 0x6e, 0x6a, 0x65, 0x3b, 0x68, 0x69, 0x6b, 0x3b, 0x64, 0x69, 0x70, 0x3b,
0x62, 0x69, 0x6f, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x6c, 0x69, 0x253, 0x3b, 0x4b, 0x254, 0x6e, 0x64, 0x254, 0x14b, 0x3b, 0x4d,
0xe0, 0x63, 0x25b, 0x302, 0x6c, 0x3b, 0x4d, 0xe0, 0x74, 0xf9, 0x6d, 0x62, 0x3b, 0x4d, 0xe0, 0x74, 0x6f, 0x70, 0x3b, 0x4d,
0x300, 0x70, 0x75, 0x79, 0x25b, 0x3b, 0x48, 0xec, 0x6c, 0xf2, 0x6e, 0x64, 0x25b, 0x300, 0x3b, 0x4e, 0x6a, 0xe8, 0x62, 0xe0,
0x3b, 0x48, 0xec, 0x6b, 0x61, 0x14b, 0x3b, 0x44, 0xec, 0x70, 0x254, 0x300, 0x73, 0x3b, 0x42, 0xec, 0xf2, 0xf4, 0x6d, 0x3b,
0x4d, 0xe0, 0x79, 0x25b, 0x73, 0xe8, 0x70, 0x3b, 0x4c, 0xec, 0x62, 0x75, 0x79, 0x20, 0x6c, 0x69, 0x20, 0x144, 0x79, 0xe8,
0x65, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x68, 0x3b, 0x6e, 0x3b, 0x68, 0x3b, 0x64, 0x3b,
0x62, 0x3b, 0x6d, 0x3b, 0x6c, 0x3b, 0x75, 0x72, 0x74, 0x2e, 0x3b, 0x6f, 0x74, 0x73, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e,
0x3b, 0x61, 0x70, 0x69, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x2e, 0x3b, 0x65, 0x6b, 0x61, 0x2e, 0x3b, 0x75, 0x7a, 0x74, 0x2e,
0x3b, 0x61, 0x62, 0x75, 0x2e, 0x3b, 0x69, 0x72, 0x61, 0x2e, 0x3b, 0x75, 0x72, 0x72, 0x2e, 0x3b, 0x61, 0x7a, 0x61, 0x2e,
0x3b, 0x61, 0x62, 0x65, 0x2e, 0x3b, 0x75, 0x72, 0x74, 0x61, 0x72, 0x72, 0x69, 0x6c, 0x61, 0x3b, 0x6f, 0x74, 0x73, 0x61,
0x69, 0x6c, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x78, 0x6f, 0x61, 0x3b, 0x61, 0x70, 0x69, 0x72, 0x69, 0x6c, 0x61, 0x3b,
0x6d, 0x61, 0x69, 0x61, 0x74, 0x7a, 0x61, 0x3b, 0x65, 0x6b, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x75, 0x7a, 0x74, 0x61, 0x69,
0x6c, 0x61, 0x3b, 0x61, 0x62, 0x75, 0x7a, 0x74, 0x75, 0x61, 0x3b, 0x69, 0x72, 0x61, 0x69, 0x6c, 0x61, 0x3b, 0x75, 0x72,
0x72, 0x69, 0x61, 0x3b, 0x61, 0x7a, 0x61, 0x72, 0x6f, 0x61, 0x3b, 0x61, 0x62, 0x65, 0x6e, 0x64, 0x75, 0x61, 0x3b, 0x55,
0x3b, 0x4f, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x55, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x55, 0x3b, 0x41,
0x3b, 0x41, 0x3b, 0x441, 0x442, 0x443, 0x3b, 0x43b, 0x44e, 0x442, 0x3b, 0x441, 0x430, 0x43a, 0x3b, 0x43a, 0x440, 0x430, 0x3b, 0x43c,
0x430, 0x439, 0x3b, 0x447, 0x44d, 0x440, 0x3b, 0x43b, 0x456, 0x43f, 0x3b, 0x436, 0x43d, 0x456, 0x3b, 0x432, 0x435, 0x440, 0x3b, 0x43a,
0x430, 0x441, 0x3b, 0x43b, 0x456, 0x441, 0x3b, 0x441, 0x43d, 0x435, 0x3b, 0x441, 0x442, 0x443, 0x434, 0x437, 0x435, 0x43d, 0x44c, 0x3b,
0x43b, 0x44e, 0x442, 0x44b, 0x3b, 0x441, 0x430, 0x43a, 0x430, 0x432, 0x456, 0x43a, 0x3b, 0x43a, 0x440, 0x430, 0x441, 0x430, 0x432, 0x456,
0x43a, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x447, 0x44d, 0x440, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x43b, 0x456, 0x43f, 0x435, 0x43d, 0x44c,
0x3b, 0x436, 0x43d, 0x456, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x432, 0x435, 0x440, 0x430, 0x441, 0x435, 0x43d, 0x44c, 0x3b, 0x43a, 0x430,
0x441, 0x442, 0x440, 0x44b, 0x447, 0x43d, 0x456, 0x43a, 0x3b, 0x43b, 0x456, 0x441, 0x442, 0x430, 0x43f, 0x430, 0x434, 0x3b, 0x441, 0x43d,
0x435, 0x436, 0x430, 0x43d, 0x44c, 0x3b, 0x441, 0x3b, 0x43b, 0x3b, 0x441, 0x3b, 0x43a, 0x3b, 0x43c, 0x3b, 0x447, 0x3b, 0x43b, 0x3b,
0x436, 0x3b, 0x432, 0x3b, 0x43a, 0x3b, 0x43b, 0x3b, 0x441, 0x3b, 0x441, 0x442, 0x443, 0x3b, 0x43b, 0x44e, 0x442, 0x3b, 0x441, 0x430,
0x43a, 0x3b, 0x43a, 0x440, 0x430, 0x3b, 0x43c, 0x430, 0x44f, 0x3b, 0x447, 0x44d, 0x440, 0x3b, 0x43b, 0x456, 0x43f, 0x3b, 0x436, 0x43d,
0x456, 0x3b, 0x432, 0x435, 0x440, 0x3b, 0x43a, 0x430, 0x441, 0x3b, 0x43b, 0x456, 0x441, 0x3b, 0x441, 0x43d, 0x435, 0x3b, 0x441, 0x442,
0x443, 0x434, 0x437, 0x435, 0x43d, 0x44f, 0x3b, 0x43b, 0x44e, 0x442, 0x430, 0x433, 0x430, 0x3b, 0x441, 0x430, 0x43a, 0x430, 0x432, 0x456,
0x43a, 0x430, 0x3b, 0x43a, 0x440, 0x430, 0x441, 0x430, 0x432, 0x456, 0x43a, 0x430, 0x3b, 0x43c, 0x430, 0x44f, 0x3b, 0x447, 0x44d, 0x440,
0x432, 0x435, 0x43d, 0x44f, 0x3b, 0x43b, 0x456, 0x43f, 0x435, 0x43d, 0x44f, 0x3b, 0x436, 0x43d, 0x456, 0x45e, 0x43d, 0x44f, 0x3b, 0x432,
0x435, 0x440, 0x430, 0x441, 0x43d, 0x44f, 0x3b, 0x43a, 0x430, 0x441, 0x442, 0x440, 0x44b, 0x447, 0x43d, 0x456, 0x43a, 0x430, 0x3b, 0x43b,
0x456, 0x441, 0x442, 0x430, 0x43f, 0x430, 0x434, 0x430, 0x3b, 0x441, 0x43d, 0x435, 0x436, 0x43d, 0x44f, 0x3b, 0x4a, 0x61, 0x6e, 0x3b,
0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x45, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b,
0x4a, 0x75, 0x6c, 0x3b, 0x4f, 0x67, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b,
0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69,
0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x45, 0x70, 0x72, 0x65, 0x6f, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e,
0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x4f, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65,
0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44,
0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a,
0x3b, 0x4f, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x48, 0x75, 0x74, 0x3b, 0x56, 0x69, 0x6c, 0x3b, 0x44,
0x61, 0x74, 0x3b, 0x54, 0x61, 0x69, 0x3b, 0x48, 0x61, 0x6e, 0x3b, 0x53, 0x69, 0x74, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4e,
0x61, 0x6e, 0x3b, 0x54, 0x69, 0x73, 0x3b, 0x4b, 0x75, 0x6d, 0x3b, 0x4b, 0x6d, 0x6a, 0x3b, 0x4b, 0x6d, 0x62, 0x3b, 0x70,
0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x68, 0x75, 0x74, 0x61, 0x6c, 0x61, 0x3b,
0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x76, 0x69, 0x6c, 0x69,
0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x64, 0x61, 0x74,
0x75, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x74, 0x61,
0x69, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x68, 0x61,
0x6e, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x73, 0x69, 0x74,
0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x73, 0x61, 0x62, 0x61,
0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6e, 0x61, 0x6e, 0x65, 0x3b,
0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x74, 0x69, 0x73, 0x61, 0x3b, 0x70,
0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x70, 0x61,
0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20,
0x6d, 0x6f, 0x6a, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6b,
0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x48, 0x3b, 0x56, 0x3b, 0x44, 0x3b, 0x54,
0x3b, 0x48, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x91c, 0x928, 0x935,
0x930, 0x940, 0x3b, 0x92b, 0x930, 0x935, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x948,
0x932, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x924,
0x3b, 0x938, 0x93f, 0x924, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x942, 0x92c, 0x930, 0x3b, 0x928, 0x935, 0x902,
0x92c, 0x930, 0x3b, 0x926, 0x93f, 0x938, 0x902, 0x92c, 0x930, 0x3b, 0x120d, 0x12f0, 0x1275, 0x3b, 0x12ab, 0x1265, 0x12bd, 0x3b, 0x12ad, 0x1265,
0x120b, 0x3b, 0x134b, 0x1305, 0x12ba, 0x3b, 0x12ad, 0x1262, 0x1245, 0x3b, 0x121d, 0x2f, 0x1275, 0x3b, 0x12b0, 0x122d, 0x3b, 0x121b, 0x122d, 0x12eb,
0x3b, 0x12eb, 0x12b8, 0x1292, 0x3b, 0x1218, 0x1270, 0x1209, 0x3b, 0x121d, 0x2f, 0x121d, 0x3b, 0x1270, 0x1215, 0x1233, 0x3b, 0x120d, 0x12f0, 0x1275,
0x122a, 0x3b, 0x12ab, 0x1265, 0x12bd, 0x1265, 0x1272, 0x3b, 0x12ad, 0x1265, 0x120b, 0x3b, 0x134b, 0x1305, 0x12ba, 0x122a, 0x3b, 0x12ad, 0x1262, 0x1245,
0x122a, 0x3b, 0x121d, 0x12aa, 0x12a4, 0x120d, 0x20, 0x1275, 0x131f, 0x1292, 0x122a, 0x3b, 0x12b0, 0x122d, 0x12a9, 0x3b, 0x121b, 0x122d, 0x12eb, 0x121d,
0x20, 0x1275, 0x122a, 0x3b, 0x12eb, 0x12b8, 0x1292, 0x20, 0x1218, 0x1233, 0x1245, 0x1208, 0x122a, 0x3b, 0x1218, 0x1270, 0x1209, 0x3b, 0x121d, 0x12aa,
0x12a4, 0x120d, 0x20, 0x1218, 0x123d, 0x12c8, 0x122a, 0x3b, 0x1270, 0x1215, 0x1233, 0x1235, 0x122a, 0x3b, 0x120d, 0x3b, 0x12ab, 0x3b, 0x12ad, 0x3b,
0x134b, 0x3b, 0x12ad, 0x3b, 0x121d, 0x3b, 0x12b0, 0x3b, 0x121b, 0x3b, 0x12eb, 0x3b, 0x1218, 0x3b, 0x121d, 0x3b, 0x1270, 0x3b, 0x91c, 0x93e,
0x928, 0x3b, 0x92b, 0x947, 0x92c, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x90f, 0x92a, 0x94d, 0x930, 0x93f, 0x3b, 0x92e, 0x947,
0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x3b, 0x906, 0x917, 0x3b, 0x938, 0x947, 0x92a, 0x3b, 0x905, 0x915, 0x94d, 0x91f,
0x2019, 0x3b, 0x928, 0x935, 0x947, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x3b, 0x91c, 0x93e, 0x928, 0x941, 0x935, 0x93e, 0x930, 0x940, 0x3b,
0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x942, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x90f, 0x92a, 0x94d,
0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x906, 0x917, 0x937,
0x94d, 0x91f, 0x3b, 0x938, 0x947, 0x92a, 0x94d, 0x925, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x2019, 0x92c,
0x930, 0x3b, 0x928, 0x935, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x91c,
0x3b, 0x92b, 0x3b, 0x92e, 0x3b, 0x90f, 0x3b, 0x92e, 0x3b, 0x91c, 0x3b, 0x91c, 0x3b, 0x906, 0x3b, 0x938, 0x3b, 0x905, 0x3b, 0x928,
0x3b, 0x921, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d,
0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f,
0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65,
0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a,
0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65,
0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x6a, 0x3b, 0x66, 0x3b, 0x6d, 0x3b,
0x61, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x6a, 0x3b, 0x61, 0x3b, 0x73, 0x3b, 0x6f, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x458, 0x430,
0x43d, 0x3b, 0x444, 0x435, 0x431, 0x3b, 0x43c, 0x430, 0x440, 0x3b, 0x430, 0x43f, 0x440, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443,
0x43d, 0x3b, 0x458, 0x443, 0x43b, 0x3b, 0x430, 0x443, 0x433, 0x3b, 0x441, 0x435, 0x43f, 0x3b, 0x43e, 0x43a, 0x442, 0x3b, 0x43d, 0x43e,
0x432, 0x3b, 0x434, 0x435, 0x446, 0x3b, 0x458, 0x430, 0x43d, 0x443, 0x430, 0x440, 0x3b, 0x444, 0x435, 0x431, 0x440, 0x443, 0x430, 0x440,
0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x438, 0x43b, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x438,
0x3b, 0x458, 0x443, 0x43b, 0x438, 0x3b, 0x430, 0x443, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x431,
0x430, 0x440, 0x3b, 0x43e, 0x43a, 0x442, 0x43e, 0x431, 0x430, 0x440, 0x3b, 0x43d, 0x43e, 0x432, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b,
0x434, 0x435, 0x446, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x458, 0x3b, 0x444, 0x3b, 0x43c, 0x3b, 0x430, 0x3b, 0x43c, 0x3b, 0x458,
0x3b, 0x458, 0x3b, 0x430, 0x3b, 0x441, 0x3b, 0x43e, 0x3b, 0x43d, 0x3b, 0x434, 0x3b, 0x47, 0x65, 0x6e, 0x2e, 0x3b, 0x43, 0x2bc,
0x68, 0x77, 0x65, 0x2e, 0x3b, 0x4d, 0x65, 0x75, 0x72, 0x2e, 0x3b, 0x45, 0x62, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x65, 0x3b,
0x4d, 0x65, 0x7a, 0x68, 0x2e, 0x3b, 0x47, 0x6f, 0x75, 0x65, 0x2e, 0x3b, 0x45, 0x6f, 0x73, 0x74, 0x3b, 0x47, 0x77, 0x65,
0x6e, 0x2e, 0x3b, 0x48, 0x65, 0x72, 0x65, 0x3b, 0x44, 0x75, 0x3b, 0x4b, 0x7a, 0x75, 0x2e, 0x3b, 0x47, 0x65, 0x6e, 0x76,
0x65, 0x72, 0x3b, 0x43, 0x2bc, 0x68, 0x77, 0x65, 0x76, 0x72, 0x65, 0x72, 0x3b, 0x4d, 0x65, 0x75, 0x72, 0x7a, 0x68, 0x3b,
0x45, 0x62, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x61, 0x65, 0x3b, 0x4d, 0x65, 0x7a, 0x68, 0x65, 0x76, 0x65, 0x6e, 0x3b, 0x47,
0x6f, 0x75, 0x65, 0x72, 0x65, 0x3b, 0x45, 0x6f, 0x73, 0x74, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x67, 0x6f, 0x6c, 0x6f, 0x3b,
0x48, 0x65, 0x72, 0x65, 0x3b, 0x44, 0x75, 0x3b, 0x4b, 0x65, 0x72, 0x7a, 0x75, 0x3b, 0x30, 0x31, 0x3b, 0x30, 0x32, 0x3b,
0x30, 0x33, 0x3b, 0x30, 0x34, 0x3b, 0x30, 0x35, 0x3b, 0x30, 0x36, 0x3b, 0x30, 0x37, 0x3b, 0x30, 0x38, 0x3b, 0x30, 0x39,
0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0x44f, 0x43d, 0x443, 0x3b, 0x444, 0x435, 0x432, 0x3b, 0x43c, 0x430,
0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x44e, 0x43d, 0x438, 0x3b, 0x44e, 0x43b, 0x438, 0x3b, 0x430,
0x432, 0x433, 0x3b, 0x441, 0x435, 0x43f, 0x3b, 0x43e, 0x43a, 0x442, 0x3b, 0x43d, 0x43e, 0x435, 0x3b, 0x434, 0x435, 0x43a, 0x3b, 0x44f,
0x43d, 0x443, 0x430, 0x440, 0x438, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x443, 0x430, 0x440, 0x438, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b,
0x430, 0x43f, 0x440, 0x438, 0x43b, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x44e, 0x43d, 0x438, 0x3b, 0x44e, 0x43b, 0x438, 0x3b, 0x430, 0x432,
0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43e, 0x43a, 0x442, 0x43e, 0x43c,
0x432, 0x440, 0x438, 0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x434, 0x435, 0x43a, 0x435, 0x43c, 0x432, 0x440, 0x438,
0x3b, 0x44f, 0x3b, 0x444, 0x3b, 0x43c, 0x3b, 0x430, 0x3b, 0x43c, 0x3b, 0x44e, 0x3b, 0x44e, 0x3b, 0x430, 0x3b, 0x441, 0x3b, 0x43e,
0x3b, 0x43d, 0x3b, 0x434, 0x3b, 0x1007, 0x1014, 0x103a, 0x3b, 0x1016, 0x1031, 0x3b, 0x1019, 0x1010, 0x103a, 0x3b, 0x1027, 0x3b, 0x1019, 0x1031,
0x3b, 0x1007, 0x103d, 0x1014, 0x103a, 0x3b, 0x1007, 0x1030, 0x3b, 0x1029, 0x3b, 0x1005, 0x1000, 0x103a, 0x3b, 0x1021, 0x1031, 0x102c, 0x1000, 0x103a,
0x3b, 0x1014, 0x102d, 0x102f, 0x3b, 0x1012, 0x102e, 0x3b, 0x1007, 0x1014, 0x103a, 0x1014, 0x101d, 0x102b, 0x101b, 0x102e, 0x3b, 0x1016, 0x1031, 0x1016,
0x1031, 0x102c, 0x103a, 0x101d, 0x102b, 0x101b, 0x102e, 0x3b, 0x1019, 0x1010, 0x103a, 0x3b, 0x1027, 0x1015, 0x103c, 0x102e, 0x3b, 0x1019, 0x1031, 0x3b,
0x1007, 0x103d, 0x1014, 0x103a, 0x3b, 0x1007, 0x1030, 0x101c, 0x102d, 0x102f, 0x1004, 0x103a, 0x3b, 0x1029, 0x1002, 0x102f, 0x1010, 0x103a, 0x3b, 0x1005,
0x1000, 0x103a, 0x1010, 0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1021, 0x1031, 0x102c, 0x1000, 0x103a, 0x1010, 0x102d, 0x102f, 0x1018, 0x102c, 0x3b, 0x1014,
0x102d, 0x102f, 0x101d, 0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1012, 0x102e, 0x1007, 0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1007, 0x3b, 0x1016, 0x3b,
0x1019, 0x3b, 0x1027, 0x3b, 0x1019, 0x3b, 0x1007, 0x3b, 0x1007, 0x3b, 0x1029, 0x3b, 0x1005, 0x3b, 0x1021, 0x3b, 0x1014, 0x3b, 0x1012, 0x3b,
0x31, 0x6708, 0x3b, 0x32, 0x6708, 0x3b, 0x33, 0x6708, 0x3b, 0x34, 0x6708, 0x3b, 0x35, 0x6708, 0x3b, 0x36, 0x6708, 0x3b, 0x37, 0x6708,
0x3b, 0x38, 0x6708, 0x3b, 0x39, 0x6708, 0x3b, 0x31, 0x30, 0x6708, 0x3b, 0x31, 0x31, 0x6708, 0x3b, 0x31, 0x32, 0x6708, 0x3b, 0x4e00,
0x6708, 0x3b, 0x4e8c, 0x6708, 0x3b, 0x4e09, 0x6708, 0x3b, 0x56db, 0x6708, 0x3b, 0x4e94, 0x6708, 0x3b, 0x516d, 0x6708, 0x3b, 0x4e03, 0x6708, 0x3b,
0x516b, 0x6708, 0x3b, 0x4e5d, 0x6708, 0x3b, 0x5341, 0x6708, 0x3b, 0x5341, 0x4e00, 0x6708, 0x3b, 0x5341, 0x4e8c, 0x6708, 0x3b, 0x67, 0x65, 0x6e,
0x2e, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61,
0x69, 0x67, 0x3b, 0x6a, 0x75, 0x6e, 0x79, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x74,
0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x73, 0x2e, 0x3b, 0x67, 0x65, 0x6e,
0x65, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c,
0x3b, 0x6d, 0x61, 0x69, 0x67, 0x3b, 0x6a, 0x75, 0x6e, 0x79, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x6c, 0x3b, 0x61, 0x67,
0x6f, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x75, 0x62, 0x72, 0x65,
0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x47,
0x4e, 0x3b, 0x46, 0x42, 0x3b, 0x4d, 0xc7, 0x3b, 0x41, 0x42, 0x3b, 0x4d, 0x47, 0x3b, 0x4a, 0x4e, 0x3b, 0x4a, 0x4c, 0x3b,
0x41, 0x47, 0x3b, 0x53, 0x54, 0x3b, 0x4f, 0x43, 0x3b, 0x4e, 0x56, 0x3b, 0x44, 0x53, 0x3b, 0x64, 0x65, 0x20, 0x67, 0x65,
0x6e, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x66, 0x65, 0x62, 0x72, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x72, 0xe7, 0x3b,
0x64, 0x2019, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x69, 0x67, 0x3b, 0x64, 0x65, 0x20, 0x6a, 0x75,
0x6e, 0x79, 0x3b, 0x64, 0x65, 0x20, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x64, 0x2019, 0x61, 0x67, 0x2e, 0x3b, 0x64, 0x65, 0x20,
0x73, 0x65, 0x74, 0x2e, 0x3b, 0x64, 0x2019, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x6e, 0x6f, 0x76, 0x2e, 0x3b,
0x64, 0x65, 0x20, 0x64, 0x65, 0x73, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x20,
0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x64, 0x2019, 0x61, 0x62, 0x72,
0x69, 0x6c, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x69, 0x67, 0x3b, 0x64, 0x65, 0x20, 0x6a, 0x75, 0x6e, 0x79, 0x3b, 0x64,
0x65, 0x20, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x6c, 0x3b, 0x64, 0x2019, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x3b, 0x64, 0x65, 0x20,
0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x2019, 0x6f, 0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x64,
0x65, 0x20, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x20, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62,
0x72, 0x65, 0x3b, 0x45, 0x6e, 0x65, 0x3b, 0x50, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d,
0x61, 0x79, 0x3b, 0x48, 0x75, 0x6e, 0x3b, 0x48, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f,
0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x62, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x45, 0x6e, 0x65, 0x72, 0x6f, 0x3b, 0x50, 0x65, 0x62,
0x72, 0x65, 0x72, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x79,
0x6f, 0x3b, 0x48, 0x75, 0x6e, 0x79, 0x6f, 0x3b, 0x48, 0x75, 0x6c, 0x79, 0x6f, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f,
0x3b, 0x53, 0x65, 0x74, 0x79, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x4f, 0x6b, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x4e,
0x6f, 0x62, 0x79, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x44, 0x69, 0x73, 0x79, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x45,
0x3b, 0x50, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x48, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e,
0x3b, 0x44, 0x3b, 0x59, 0x65, 0x6e, 0x3b, 0x59, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x49, 0x62, 0x72, 0x3b, 0x4d,
0x61, 0x79, 0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59, 0x75, 0x6c, 0x3b, 0x194, 0x75, 0x63, 0x3b, 0x43, 0x75, 0x74, 0x3b, 0x4b,
0x1e6d, 0x75, 0x3b, 0x4e, 0x77, 0x61, 0x3b, 0x44, 0x75, 0x6a, 0x3b, 0x59, 0x65, 0x6e, 0x6e, 0x61, 0x79, 0x65, 0x72, 0x3b,
0x59, 0x65, 0x62, 0x72, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x3b, 0x49, 0x62, 0x72, 0x69, 0x72, 0x3b,
0x4d, 0x61, 0x79, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6e, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6c, 0x79, 0x75, 0x7a, 0x3b, 0x194,
0x75, 0x63, 0x74, 0x3b, 0x43, 0x75, 0x74, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x4b, 0x1e6d, 0x75, 0x62, 0x65, 0x72, 0x3b,
0x4e, 0x77, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x44, 0x75, 0x6a, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x59, 0x3b, 0x59,
0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x194, 0x3b, 0x43, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x44,
0x3b, 0x6a9, 0x627, 0x646, 0x648, 0x648, 0x646, 0x6cc, 0x20, 0x62f, 0x648, 0x648, 0x6d5, 0x645, 0x3b, 0x634, 0x648, 0x628, 0x627, 0x62a,
0x3b, 0x626, 0x627, 0x632, 0x627, 0x631, 0x3b, 0x646, 0x6cc, 0x633, 0x627, 0x646, 0x3b, 0x626, 0x627, 0x6cc, 0x627, 0x631, 0x3b, 0x62d,
0x648, 0x632, 0x6d5, 0x6cc, 0x631, 0x627, 0x646, 0x3b, 0x62a, 0x6d5, 0x645, 0x648, 0x648, 0x632, 0x3b, 0x626, 0x627, 0x628, 0x3b, 0x626,
0x6d5, 0x6cc, 0x644, 0x648, 0x648, 0x644, 0x3b, 0x62a, 0x634, 0x631, 0x6cc, 0x646, 0x6cc, 0x20, 0x6cc, 0x6d5, 0x6a9, 0x6d5, 0x645, 0x3b,
0x62a, 0x634, 0x631, 0x6cc, 0x646, 0x6cc, 0x20, 0x62f, 0x648, 0x648, 0x6d5, 0x645, 0x3b, 0x6a9, 0x627, 0x646, 0x648, 0x646, 0x6cc, 0x20,
0x6cc, 0x6d5, 0x6a9, 0x6d5, 0x645, 0x3b, 0x6a9, 0x3b, 0x634, 0x3b, 0x626, 0x3b, 0x646, 0x3b, 0x626, 0x3b, 0x62d, 0x3b, 0x62a, 0x3b,
0x626, 0x3b, 0x626, 0x3b, 0x62a, 0x3b, 0x62a, 0x3b, 0x6a9, 0x3b, 0xd804, 0xdd0e, 0xd804, 0xdd1a, 0xd804, 0xdd2a, 0xd804, 0xdd20, 0xd804, 0xdd22,
0xd804, 0xdd28, 0x3b, 0xd804, 0xdd1c, 0xd804, 0xdd2c, 0xd804, 0xdd1b, 0xd804, 0xdd34, 0xd804, 0xdd1d, 0xd804, 0xdd33, 0xd804, 0xdd22, 0xd804, 0xdd2a, 0xd804,
0xdd20, 0xd804, 0xdd22, 0xd804, 0xdd28, 0x3b, 0xd804, 0xdd1f, 0xd804, 0xdd22, 0xd804, 0xdd34, 0xd804, 0xdd0c, 0xd804, 0xdd27, 0x3b, 0xd804, 0xdd03, 0xd804,
0xdd2c, 0xd804, 0xdd1b, 0xd804, 0xdd33, 0xd804, 0xdd22, 0xd804, 0xdd28, 0xd804, 0xdd23, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1f, 0xd804, 0xdd2c, 0x3b, 0xd804,
0xdd0e, 0xd804, 0xdd2a, 0xd804, 0xdd1a, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd0e, 0xd804, 0xdd2a, 0xd804, 0xdd23, 0xd804, 0xdd2d, 0x3b, 0xd804, 0xdd03, 0xd804,
0xdd09, 0xd804, 0xdd27, 0xd804, 0xdd0c, 0xd804, 0xdd34, 0xd804, 0xdd11, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd2c, 0xd804, 0xdd1b, 0xd804, 0xdd34,
0xd804, 0xdd11, 0xd804, 0xdd2c, 0xd804, 0xdd1f, 0xd804, 0xdd34, 0xd804, 0xdd1d, 0xd804, 0xdd27, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd03, 0xd804,
0xdd27, 0xd804, 0xdd07, 0xd804, 0xdd34, 0xd804, 0xdd11, 0xd804, 0xdd2e, 0xd804, 0xdd1d, 0xd804, 0xdd27, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1a,
0xd804, 0xdd27, 0xd804, 0xdd1e, 0xd804, 0xdd2c, 0xd804, 0xdd1f, 0xd804, 0xdd34, 0xd804, 0xdd1d, 0xd804, 0xdd27, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804,
0xdd13, 0xd804, 0xdd28, 0xd804, 0xdd25, 0xd804, 0xdd2c, 0xd804, 0xdd1f, 0xd804, 0xdd34, 0xd804, 0xdd1d, 0xd804, 0xdd27, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b,
0xd804, 0xdd0e, 0x3b, 0xd804, 0xdd1c, 0xd804, 0xdd2c, 0x3b, 0xd804, 0xdd1f, 0x3b, 0xd804, 0xdd03, 0xd804, 0xdd2c, 0x3b, 0xd804, 0xdd1f, 0xd804, 0xdd2c,
0x3b, 0xd804, 0xdd0e, 0xd804, 0xdd2a, 0xd804, 0xdd1a, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd0e, 0xd804, 0xdd2a, 0x3b, 0xd804, 0xdd03, 0x3b, 0xd804, 0xdd25,
0xd804, 0xdd2c, 0x3b, 0xd804, 0xdd03, 0xd804, 0xdd27, 0x3b, 0xd804, 0xdd1a, 0xd804, 0xdd27, 0x3b, 0xd804, 0xdd13, 0xd804, 0xdd28, 0x3b, 0xd804, 0xdd0e,
0xd804, 0xdd1a, 0xd804, 0xdd2a, 0x3b, 0xd804, 0xdd1c, 0xd804, 0xdd2c, 0xd804, 0xdd1b, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1f, 0xd804, 0xdd22, 0xd804, 0xdd34,
0xd804, 0xdd0c, 0xd804, 0xdd27, 0x3b, 0xd804, 0xdd03, 0xd804, 0xdd2c, 0xd804, 0xdd1b, 0xd804, 0xdd33, 0xd804, 0xdd22, 0xd804, 0xdd28, 0xd804, 0xdd23, 0xd804,
0xdd34, 0x3b, 0xd804, 0xdd1f, 0xd804, 0xdd2c, 0x3b, 0xd804, 0xdd0e, 0xd804, 0xdd2a, 0xd804, 0xdd1a, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd0e, 0xd804, 0xdd2a,
0xd804, 0xdd23, 0xd804, 0xdd2d, 0x3b, 0xd804, 0xdd03, 0xd804, 0xdd09, 0xd804, 0xdd27, 0xd804, 0xdd0c, 0xd804, 0xdd34, 0xd804, 0xdd11, 0xd804, 0xdd34, 0x3b,
0xd804, 0xdd25, 0xd804, 0xdd2c, 0xd804, 0xdd1b, 0xd804, 0xdd34, 0xd804, 0xdd11, 0xd804, 0xdd2c, 0xd804, 0xdd1f, 0xd804, 0xdd34, 0xd804, 0xdd1d, 0xd804, 0xdd27,
0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd03, 0xd804, 0xdd27, 0xd804, 0xdd07, 0xd804, 0xdd34, 0xd804, 0xdd11, 0xd804, 0xdd2e, 0xd804, 0xdd1d, 0xd804,
0xdd27, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1a, 0xd804, 0xdd27, 0xd804, 0xdd1e, 0xd804, 0xdd2c, 0xd804, 0xdd1f, 0xd804, 0xdd34, 0xd804, 0xdd1d,
0xd804, 0xdd27, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd13, 0xd804, 0xdd28, 0xd804, 0xdd25, 0xd804, 0xdd2c, 0xd804, 0xdd1f, 0xd804, 0xdd34, 0xd804,
0xdd1d, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd0e, 0xd804, 0xdd1a, 0xd804, 0xdd2a, 0xd804, 0xdd20, 0xd804, 0xdd22, 0xd804, 0xdd28, 0x3b, 0xd804,
0xdd1c, 0xd804, 0xdd2c, 0xd804, 0xdd1b, 0xd804, 0xdd34, 0xd804, 0xdd1d, 0xd804, 0xdd33, 0xd804, 0xdd22, 0xd804, 0xdd2a, 0xd804, 0xdd20, 0xd804, 0xdd22, 0xd804,
0xdd28, 0x3b, 0xd804, 0xdd1f, 0xd804, 0xdd22, 0xd804, 0xdd34, 0xd804, 0xdd0c, 0xd804, 0xdd27, 0x3b, 0xd804, 0xdd03, 0xd804, 0xdd2c, 0xd804, 0xdd1b, 0xd804,
0xdd33, 0xd804, 0xdd22, 0xd804, 0xdd28, 0xd804, 0xdd23, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1f, 0xd804, 0xdd2c, 0x3b, 0xd804, 0xdd0e, 0xd804, 0xdd2a, 0xd804,
0xdd1a, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd0e, 0xd804, 0xdd2a, 0xd804, 0xdd23, 0xd804, 0xdd2d, 0x3b, 0xd804, 0xdd03, 0xd804, 0xdd09, 0xd804, 0xdd27, 0xd804,
0xdd0c, 0xd804, 0xdd34, 0xd804, 0xdd11, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd2c, 0xd804, 0xdd1b, 0xd804, 0xdd34, 0xd804, 0xdd11, 0xd804, 0xdd2c,
0xd804, 0xdd1f, 0xd804, 0xdd34, 0xd804, 0xdd1d, 0xd804, 0xdd27, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd03, 0xd804, 0xdd27, 0xd804, 0xdd07, 0xd804,
0xdd34, 0xd804, 0xdd11, 0xd804, 0xdd2c, 0xd804, 0xdd1d, 0xd804, 0xdd27, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1a, 0xd804, 0xdd27, 0xd804, 0xdd1e,
0xd804, 0xdd2c, 0xd804, 0xdd1f, 0xd804, 0xdd34, 0xd804, 0xdd1d, 0xd804, 0xdd27, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd13, 0xd804, 0xdd28, 0xd804,
0xdd25, 0xd804, 0xdd2c, 0xd804, 0xdd1f, 0xd804, 0xdd34, 0xd804, 0xdd1d, 0xd804, 0xdd27, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0x44f, 0x43d, 0x432, 0x3b,
0x444, 0x435, 0x432, 0x3b, 0x43c, 0x430, 0x440, 0x3b, 0x430, 0x43f, 0x440, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x44e, 0x43d, 0x3b,
0x438, 0x44e, 0x43b, 0x3b, 0x430, 0x432, 0x433, 0x3b, 0x441, 0x435, 0x43d, 0x3b, 0x43e, 0x43a, 0x442, 0x3b, 0x43d, 0x43e, 0x44f, 0x3b,
0x434, 0x435, 0x43a, 0x3b, 0x44f, 0x43d, 0x432, 0x430, 0x440, 0x44c, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44c, 0x3b, 0x43c,
0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x435, 0x43b, 0x44c, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x44e, 0x43d, 0x44c, 0x3b,
0x438, 0x44e, 0x43b, 0x44c, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44c,
0x3b, 0x43e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x434, 0x435, 0x43a, 0x430,
0x431, 0x440, 0x44c, 0x3b, 0x42f, 0x3b, 0x424, 0x3b, 0x41c, 0x3b, 0x410, 0x3b, 0x41c, 0x3b, 0x418, 0x3b, 0x418, 0x3b, 0x410, 0x3b,
0x421, 0x3b, 0x41e, 0x3b, 0x41d, 0x3b, 0x414, 0x3b, 0x13a4, 0x13c3, 0x3b, 0x13a7, 0x13a6, 0x3b, 0x13a0, 0x13c5, 0x3b, 0x13a7, 0x13ec, 0x3b,
0x13a0, 0x13c2, 0x3b, 0x13d5, 0x13ad, 0x3b, 0x13ab, 0x13f0, 0x3b, 0x13a6, 0x13b6, 0x3b, 0x13da, 0x13b5, 0x3b, 0x13da, 0x13c2, 0x3b, 0x13c5, 0x13d3,
0x3b, 0x13a5, 0x13cd, 0x3b, 0x13a4, 0x13c3, 0x13b8, 0x13d4, 0x13c5, 0x3b, 0x13a7, 0x13a6, 0x13b5, 0x3b, 0x13a0, 0x13c5, 0x13f1, 0x3b, 0x13a7, 0x13ec,
0x13c2, 0x3b, 0x13a0, 0x13c2, 0x13cd, 0x13ac, 0x13d8, 0x3b, 0x13d5, 0x13ad, 0x13b7, 0x13f1, 0x3b, 0x13ab, 0x13f0, 0x13c9, 0x13c2, 0x3b, 0x13a6, 0x13b6,
0x13c2, 0x3b, 0x13da, 0x13b5, 0x13cd, 0x13d7, 0x3b, 0x13da, 0x13c2, 0x13c5, 0x13d7, 0x3b, 0x13c5, 0x13d3, 0x13d5, 0x13c6, 0x3b, 0x13a5, 0x13cd, 0x13a9,
0x13f1, 0x3b, 0x13a4, 0x3b, 0x13a7, 0x3b, 0x13a0, 0x3b, 0x13a7, 0x3b, 0x13a0, 0x3b, 0x13d5, 0x3b, 0x13ab, 0x3b, 0x13a6, 0x3b, 0x13da, 0x3b,
0x13da, 0x3b, 0x13c5, 0x3b, 0x13a5, 0x3b, 0x48, 0x61, 0x73, 0x68, 0x69, 0x2bc, 0x20, 0x41, 0x6d, 0x6d, 0x6f, 0x2bc, 0x6e, 0x61,
0x2bc, 0x3b, 0x48, 0x61, 0x73, 0x68, 0x69, 0x2bc, 0x20, 0x41, 0x74, 0x6f, 0x6b, 0x6c, 0x6f, 0x2bc, 0x3b, 0x48, 0x61, 0x73,
0x68, 0x69, 0x2bc, 0x20, 0x41, 0x74, 0x6f, 0x63, 0x68, 0x63, 0x68, 0xed, 0x2bc, 0x6e, 0x61, 0x2bc, 0x3b, 0x49, 0x69, 0x70,
0x6c, 0x61, 0x6c, 0x3b, 0x4d, 0x69, 0x68, 0x3b, 0x43, 0x68, 0x6f, 0x6f, 0x6e, 0x3b, 0x43, 0x68, 0x6f, 0x6f, 0x6c, 0x61,
0x3b, 0x41, 0x6b, 0x61, 0x61, 0x73, 0x3b, 0x53, 0x69, 0x70, 0x74, 0x69, 0x6d, 0x70, 0x61, 0x2bc, 0x3b, 0x41, 0x61, 0x6b,
0x74, 0x6f, 0x70, 0x61, 0x2bc, 0x3b, 0x4e, 0x6f, 0x66, 0x69, 0x6d, 0x70, 0x61, 0x2bc, 0x3b, 0x54, 0x69, 0x69, 0x73, 0x69,
0x6d, 0x70, 0x61, 0x2bc, 0x3b, 0x4b, 0x42, 0x5a, 0x3b, 0x4b, 0x42, 0x52, 0x3b, 0x4b, 0x53, 0x54, 0x3b, 0x4b, 0x4b, 0x4e,
0x3b, 0x4b, 0x54, 0x4e, 0x3b, 0x4b, 0x4d, 0x4b, 0x3b, 0x4b, 0x4d, 0x53, 0x3b, 0x4b, 0x4d, 0x4e, 0x3b, 0x4b, 0x4d, 0x57,
0x3b, 0x4b, 0x4b, 0x4d, 0x3b, 0x4b, 0x4e, 0x4b, 0x3b, 0x4b, 0x4e, 0x42, 0x3b, 0x4f, 0x6b, 0x77, 0x6f, 0x6b, 0x75, 0x62,
0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4f, 0x6b, 0x77, 0x61,
0x6b, 0x61, 0x73, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6b, 0x77,
0x61, 0x6b, 0x61, 0x74, 0x61, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61,
0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x75, 0x73, 0x68, 0x61, 0x6e, 0x6a, 0x75, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x75,
0x6e, 0x61, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x77, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4f, 0x6b, 0x77,
0x61, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20,
0x6b, 0x75, 0x6d, 0x77, 0x65, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x69,
0x62, 0x69, 0x72, 0x69, 0x3b, 0x456, 0x486, 0x430, 0x2de9, 0x487, 0x3b, 0x444, 0x435, 0x2de1, 0x487, 0x3b, 0x43c, 0x430, 0x2dec, 0x487,
0x3b, 0x430, 0x486, 0x43f, 0x2dec, 0x487, 0x3b, 0x43c, 0x430, 0xa675, 0x3b, 0x456, 0x486, 0xa64b, 0x2de9, 0x487, 0x3b, 0x456, 0x486, 0xa64b,
0x2de7, 0x487, 0x3b, 0x430, 0x486, 0x301, 0x475, 0x2de2, 0x487, 0x3b, 0x441, 0x435, 0x2deb, 0x487, 0x3b, 0x47b, 0x486, 0x43a, 0x2dee, 0x3b,
0x43d, 0x43e, 0x435, 0x2de8, 0x3b, 0x434, 0x435, 0x2de6, 0x487, 0x3b, 0x456, 0x486, 0x430, 0x43d, 0x43d, 0xa64b, 0x430, 0x301, 0x440, 0x457,
0x439, 0x3b, 0x444, 0x435, 0x432, 0x440, 0xa64b, 0x430, 0x301, 0x440, 0x457, 0x439, 0x3b, 0x43c, 0x430, 0x301, 0x440, 0x442, 0x44a, 0x3b,
0x430, 0x486, 0x43f, 0x440, 0x456, 0x301, 0x43b, 0x43b, 0x457, 0x439, 0x3b, 0x43c, 0x430, 0x301, 0x457, 0x439, 0x3b, 0x456, 0x486, 0xa64b,
0x301, 0x43d, 0x457, 0x439, 0x3b, 0x456, 0x486, 0xa64b, 0x301, 0x43b, 0x457, 0x439, 0x3b, 0x430, 0x486, 0x301, 0x475, 0x433, 0xa64b, 0x441,
0x442, 0x44a, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x301, 0x43c, 0x432, 0x440, 0x457, 0x439, 0x3b, 0x47b, 0x486, 0x43a, 0x442, 0x461,
0x301, 0x432, 0x440, 0x457, 0x439, 0x3b, 0x43d, 0x43e, 0x435, 0x301, 0x43c, 0x432, 0x440, 0x457, 0x439, 0x3b, 0x434, 0x435, 0x43a, 0x435,
0x301, 0x43c, 0x432, 0x440, 0x457, 0x439, 0x3b, 0x406, 0x486, 0x3b, 0x424, 0x3b, 0x41c, 0x3b, 0x410, 0x486, 0x3b, 0x41c, 0x3b, 0x406,
0x486, 0x3b, 0x406, 0x486, 0x3b, 0x410, 0x486, 0x3b, 0x421, 0x3b, 0x47a, 0x486, 0x3b, 0x41d, 0x3b, 0x414, 0x3b, 0x456, 0x486, 0x430,
0x43d, 0x43d, 0xa64b, 0x430, 0x301, 0x440, 0x457, 0x430, 0x3b, 0x444, 0x435, 0x432, 0x440, 0xa64b, 0x430, 0x301, 0x440, 0x457, 0x430, 0x3b,
0x43c, 0x430, 0x301, 0x440, 0x442, 0x430, 0x3b, 0x430, 0x486, 0x43f, 0x440, 0x456, 0x301, 0x43b, 0x43b, 0x457, 0x430, 0x3b, 0x43c, 0x430,
0x301, 0x457, 0x430, 0x3b, 0x456, 0x486, 0xa64b, 0x301, 0x43d, 0x457, 0x430, 0x3b, 0x456, 0x486, 0xa64b, 0x301, 0x43b, 0x457, 0x430, 0x3b,
0x430, 0x486, 0x301, 0x475, 0x433, 0xa64b, 0x441, 0x442, 0x430, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x301, 0x43c, 0x432, 0x440, 0x457,
0x430, 0x3b, 0x47b, 0x486, 0x43a, 0x442, 0x461, 0x301, 0x432, 0x440, 0x457, 0x430, 0x3b, 0x43d, 0x43e, 0x435, 0x301, 0x43c, 0x432, 0x440,
0x457, 0x430, 0x3b, 0x434, 0x435, 0x43a, 0x435, 0x301, 0x43c, 0x432, 0x440, 0x457, 0x430, 0x3b, 0x43a, 0x4d1, 0x440, 0x2e, 0x3b, 0x43d,
0x430, 0x440, 0x2e, 0x3b, 0x43f, 0x443, 0x448, 0x3b, 0x430, 0x43a, 0x430, 0x3b, 0x4ab, 0x443, 0x3b, 0x4ab, 0x4d7, 0x440, 0x2e, 0x3b,
0x443, 0x442, 0x4d1, 0x3b, 0x4ab, 0x443, 0x440, 0x2e, 0x3b, 0x430, 0x432, 0x4d1, 0x43d, 0x3b, 0x44e, 0x43f, 0x430, 0x3b, 0x447, 0x4f3,
0x43a, 0x3b, 0x440, 0x430, 0x448, 0x2e, 0x3b, 0x43a, 0x4d1, 0x440, 0x43b, 0x430, 0x447, 0x3b, 0x43d, 0x430, 0x440, 0x4d1, 0x441, 0x3b,
0x43f, 0x443, 0x448, 0x3b, 0x430, 0x43a, 0x430, 0x3b, 0x4ab, 0x443, 0x3b, 0x4ab, 0x4d7, 0x440, 0x442, 0x43c, 0x435, 0x3b, 0x443, 0x442,
0x4d1, 0x3b, 0x4ab, 0x443, 0x440, 0x43b, 0x430, 0x3b, 0x430, 0x432, 0x4d1, 0x43d, 0x3b, 0x44e, 0x43f, 0x430, 0x3b, 0x447, 0x4f3, 0x43a,
0x3b, 0x440, 0x430, 0x448, 0x442, 0x430, 0x432, 0x3b, 0x41a, 0x3b, 0x41d, 0x3b, 0x41f, 0x3b, 0x410, 0x3b, 0x4aa, 0x3b, 0x4aa, 0x3b,
0x423, 0x3b, 0x4aa, 0x3b, 0x410, 0x3b, 0x42e, 0x3b, 0x427, 0x3b, 0x420, 0x3b, 0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0xe4, 0x62,
0x2e, 0x3b, 0x4d, 0xe4, 0x7a, 0x2e, 0x3b, 0x41, 0x70, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x2e,
0x3b, 0x4a, 0x75, 0x6c, 0x2e, 0x3b, 0x4f, 0x75, 0x6a, 0x2e, 0x3b, 0x53, 0xe4, 0x70, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e,
0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x65, 0x7a, 0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x6e, 0x65, 0x77, 0x61, 0x3b, 0x46,
0xe4, 0x62, 0x72, 0x6f, 0x77, 0x61, 0x3b, 0x4d, 0xe4, 0xe4, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x6c, 0x3b, 0x4d,
0x61, 0x69, 0x3b, 0x4a, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x75, 0x6c, 0x69, 0x3b, 0x4f, 0x75, 0x6a, 0x6f, 0xdf,
0x3b, 0x53, 0x65, 0x70, 0x74, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x68, 0x62, 0x65, 0x72, 0x3b,
0x4e, 0x6f, 0x76, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b,
0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4f, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b,
0x44, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0xe4, 0x62, 0x3b, 0x4d, 0xe4, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61,
0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x4f, 0x75, 0x6a, 0x3b, 0x53, 0xe4, 0x70, 0x3b, 0x4f, 0x6b,
0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x7a, 0x3b, 0x47, 0x65, 0x6e, 0x3b, 0x48, 0x77, 0x65, 0x3b, 0x4d, 0x65,
0x75, 0x3b, 0x45, 0x62, 0x72, 0x3b, 0x4d, 0x65, 0x3b, 0x4d, 0x65, 0x74, 0x3b, 0x47, 0x6f, 0x72, 0x3b, 0x45, 0x73, 0x74,
0x3b, 0x47, 0x77, 0x6e, 0x3b, 0x48, 0x65, 0x64, 0x3b, 0x44, 0x75, 0x3b, 0x4b, 0x65, 0x76, 0x3b, 0x6d, 0x69, 0x73, 0x20,
0x47, 0x65, 0x6e, 0x76, 0x65, 0x72, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x48, 0x77, 0x65, 0x76, 0x72, 0x65, 0x72, 0x3b, 0x6d,
0x69, 0x73, 0x20, 0x4d, 0x65, 0x75, 0x72, 0x74, 0x68, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x45, 0x62, 0x72, 0x65, 0x6c, 0x3b,
0x6d, 0x69, 0x73, 0x20, 0x4d, 0x65, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x4d, 0x65, 0x74, 0x68, 0x65, 0x76, 0x65, 0x6e, 0x3b,
0x6d, 0x69, 0x73, 0x20, 0x47, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x45, 0x73,
0x74, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x47, 0x77, 0x79, 0x6e, 0x6e, 0x67, 0x61, 0x6c, 0x61, 0x3b, 0x6d, 0x69, 0x73, 0x20,
0x48, 0x65, 0x64, 0x72, 0x61, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x44, 0x75, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x4b, 0x65, 0x76,
0x61, 0x72, 0x64, 0x68, 0x75, 0x3b, 0x67, 0x68, 0x6a, 0x2e, 0x3b, 0x66, 0x65, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e,
0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x67, 0x2e, 0x3b, 0x67, 0x68, 0x6a, 0x75, 0x2e, 0x3b, 0x6c, 0x75, 0x67,
0x2e, 0x3b, 0x61, 0x6f, 0x73, 0x2e, 0x3b, 0x73, 0x69, 0x74, 0x2e, 0x3b, 0x6f, 0x74, 0x74, 0x2e, 0x3b, 0x6e, 0x75, 0x76,
0x2e, 0x3b, 0x64, 0x69, 0x63, 0x2e, 0x3b, 0x67, 0x68, 0x6a, 0x65, 0x6e, 0x6e, 0x61, 0x67, 0x68, 0x6a, 0x75, 0x3b, 0x66,
0x65, 0x72, 0x72, 0x61, 0x67, 0x68, 0x6a, 0x75, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x75, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c,
0x65, 0x3b, 0x6d, 0x61, 0x67, 0x68, 0x6a, 0x75, 0x3b, 0x67, 0x68, 0x6a, 0x75, 0x67, 0x6e, 0x75, 0x3b, 0x6c, 0x75, 0x67,
0x6c, 0x69, 0x75, 0x3b, 0x61, 0x6f, 0x73, 0x74, 0x75, 0x3b, 0x73, 0x69, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b,
0x6f, 0x74, 0x74, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x75, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x69, 0x63,
0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x47, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x4c, 0x3b,
0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x64, 0x69, 0x20, 0x67, 0x68, 0x6a, 0x65, 0x6e, 0x6e, 0x61,
0x67, 0x68, 0x6a, 0x75, 0x3b, 0x64, 0x69, 0x20, 0x66, 0x65, 0x72, 0x72, 0x61, 0x67, 0x68, 0x6a, 0x75, 0x3b, 0x64, 0x69,
0x20, 0x6d, 0x61, 0x72, 0x7a, 0x75, 0x3b, 0x64, 0x2019, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x65, 0x3b, 0x64, 0x69, 0x20, 0x6d,
0x61, 0x67, 0x68, 0x6a, 0x75, 0x3b, 0x64, 0x69, 0x20, 0x67, 0x68, 0x6a, 0x75, 0x67, 0x6e, 0x75, 0x3b, 0x64, 0x69, 0x20,
0x6c, 0x75, 0x67, 0x6c, 0x69, 0x75, 0x3b, 0x64, 0x2019, 0x61, 0x6f, 0x73, 0x74, 0x75, 0x3b, 0x64, 0x69, 0x20, 0x73, 0x69,
0x74, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x2019, 0x6f, 0x74, 0x74, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x69,
0x20, 0x6e, 0x75, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x69, 0x20, 0x64, 0x69, 0x63, 0x65, 0x6d, 0x62, 0x72,
0x65, 0x3b, 0x73, 0x69, 0x6a, 0x3b, 0x76, 0x65, 0x6c, 0x6a, 0x3b, 0x6f, 0x17e, 0x75, 0x3b, 0x74, 0x72, 0x61, 0x3b, 0x73,
0x76, 0x69, 0x3b, 0x6c, 0x69, 0x70, 0x3b, 0x73, 0x72, 0x70, 0x3b, 0x6b, 0x6f, 0x6c, 0x3b, 0x72, 0x75, 0x6a, 0x3b, 0x6c,
0x69, 0x73, 0x3b, 0x73, 0x74, 0x75, 0x3b, 0x70, 0x72, 0x6f, 0x3b, 0x73, 0x69, 0x6a, 0x65, 0x10d, 0x61, 0x6e, 0x6a, 0x3b,
0x76, 0x65, 0x6c, 0x6a, 0x61, 0x10d, 0x61, 0x3b, 0x6f, 0x17e, 0x75, 0x6a, 0x61, 0x6b, 0x3b, 0x74, 0x72, 0x61, 0x76, 0x61,
0x6e, 0x6a, 0x3b, 0x73, 0x76, 0x69, 0x62, 0x61, 0x6e, 0x6a, 0x3b, 0x6c, 0x69, 0x70, 0x61, 0x6e, 0x6a, 0x3b, 0x73, 0x72,
0x70, 0x61, 0x6e, 0x6a, 0x3b, 0x6b, 0x6f, 0x6c, 0x6f, 0x76, 0x6f, 0x7a, 0x3b, 0x72, 0x75, 0x6a, 0x61, 0x6e, 0x3b, 0x6c,
0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x3b, 0x73, 0x74, 0x75, 0x64, 0x65, 0x6e, 0x69, 0x3b, 0x70, 0x72, 0x6f, 0x73,
0x69, 0x6e, 0x61, 0x63, 0x3b, 0x31, 0x2e, 0x3b, 0x32, 0x2e, 0x3b, 0x33, 0x2e, 0x3b, 0x34, 0x2e, 0x3b, 0x35, 0x2e, 0x3b,
0x36, 0x2e, 0x3b, 0x37, 0x2e, 0x3b, 0x38, 0x2e, 0x3b, 0x39, 0x2e, 0x3b, 0x31, 0x30, 0x2e, 0x3b, 0x31, 0x31, 0x2e, 0x3b,
0x31, 0x32, 0x2e, 0x3b, 0x73, 0x69, 0x6a, 0x65, 0x10d, 0x6e, 0x6a, 0x61, 0x3b, 0x76, 0x65, 0x6c, 0x6a, 0x61, 0x10d, 0x65,
0x3b, 0x6f, 0x17e, 0x75, 0x6a, 0x6b, 0x61, 0x3b, 0x74, 0x72, 0x61, 0x76, 0x6e, 0x6a, 0x61, 0x3b, 0x73, 0x76, 0x69, 0x62,
0x6e, 0x6a, 0x61, 0x3b, 0x6c, 0x69, 0x70, 0x6e, 0x6a, 0x61, 0x3b, 0x73, 0x72, 0x70, 0x6e, 0x6a, 0x61, 0x3b, 0x6b, 0x6f,
0x6c, 0x6f, 0x76, 0x6f, 0x7a, 0x61, 0x3b, 0x72, 0x75, 0x6a, 0x6e, 0x61, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x61,
0x64, 0x61, 0x3b, 0x73, 0x74, 0x75, 0x64, 0x65, 0x6e, 0x6f, 0x67, 0x61, 0x3b, 0x70, 0x72, 0x6f, 0x73, 0x69, 0x6e, 0x63,
0x61, 0x3b, 0x6c, 0x65, 0x64, 0x3b, 0xfa, 0x6e, 0x6f, 0x3b, 0x62, 0x159, 0x65, 0x3b, 0x64, 0x75, 0x62, 0x3b, 0x6b, 0x76,
0x11b, 0x3b, 0x10d, 0x76, 0x6e, 0x3b, 0x10d, 0x76, 0x63, 0x3b, 0x73, 0x72, 0x70, 0x3b, 0x7a, 0xe1, 0x159, 0x3b, 0x159, 0xed,
0x6a, 0x3b, 0x6c, 0x69, 0x73, 0x3b, 0x70, 0x72, 0x6f, 0x3b, 0x6c, 0x65, 0x64, 0x65, 0x6e, 0x3b, 0xfa, 0x6e, 0x6f, 0x72,
0x3b, 0x62, 0x159, 0x65, 0x7a, 0x65, 0x6e, 0x3b, 0x64, 0x75, 0x62, 0x65, 0x6e, 0x3b, 0x6b, 0x76, 0x11b, 0x74, 0x65, 0x6e,
0x3b, 0x10d, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x3b, 0x10d, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x65, 0x63, 0x3b, 0x73, 0x72, 0x70,
0x65, 0x6e, 0x3b, 0x7a, 0xe1, 0x159, 0xed, 0x3b, 0x159, 0xed, 0x6a, 0x65, 0x6e, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70,
0x61, 0x64, 0x3b, 0x70, 0x72, 0x6f, 0x73, 0x69, 0x6e, 0x65, 0x63, 0x3b, 0x6c, 0x65, 0x64, 0x6e, 0x61, 0x3b, 0xfa, 0x6e,
0x6f, 0x72, 0x61, 0x3b, 0x62, 0x159, 0x65, 0x7a, 0x6e, 0x61, 0x3b, 0x64, 0x75, 0x62, 0x6e, 0x61, 0x3b, 0x6b, 0x76, 0x11b,
0x74, 0x6e, 0x61, 0x3b, 0x10d, 0x65, 0x72, 0x76, 0x6e, 0x61, 0x3b, 0x10d, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x63, 0x65, 0x3b,
0x73, 0x72, 0x70, 0x6e, 0x61, 0x3b, 0x7a, 0xe1, 0x159, 0xed, 0x3b, 0x159, 0xed, 0x6a, 0x6e, 0x61, 0x3b, 0x6c, 0x69, 0x73,
0x74, 0x6f, 0x70, 0x61, 0x64, 0x75, 0x3b, 0x70, 0x72, 0x6f, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x3b, 0x6a, 0x61, 0x6e, 0x2e,
0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x6a, 0x3b,
0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b,
0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61,
0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69,
0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75,
0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72,
0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x91c,
0x928, 0x2e, 0x3b, 0x92b, 0x930, 0x2e, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x948, 0x932, 0x3b,
0x92e, 0x947, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x2e, 0x3b, 0x938, 0x93f,
0x924, 0x2e, 0x3b, 0x905, 0x915, 0x94d, 0x924, 0x942, 0x2e, 0x3b, 0x928, 0x935, 0x2e, 0x3b, 0x926, 0x93f, 0x938, 0x2e, 0x3b, 0x91c,
0x928, 0x935, 0x930, 0x940, 0x3b, 0x92b, 0x930, 0x935, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d,
0x930, 0x948, 0x932, 0x3b, 0x92e, 0x947, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917,
0x938, 0x94d, 0x924, 0x3b, 0x938, 0x93f, 0x924, 0x902, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x924, 0x942, 0x92c, 0x930, 0x3b, 0x928,
0x935, 0x902, 0x92c, 0x930, 0x3b, 0x926, 0x93f, 0x938, 0x902, 0x92c, 0x930, 0x3b, 0x91c, 0x3b, 0x92b, 0x3b, 0x92e, 0x93e, 0x3b, 0x905,
0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x3b, 0x91c, 0x941, 0x3b, 0x905, 0x3b, 0x938, 0x93f, 0x3b, 0x905, 0x3b, 0x928, 0x3b, 0x926,
0x93f, 0x3b, 0x64, 0x69, 0x3b, 0x14b, 0x67, 0x254, 0x6e, 0x3b, 0x73, 0x254, 0x14b, 0x3b, 0x64, 0x69, 0x253, 0x3b, 0x65, 0x6d,
0x69, 0x3b, 0x65, 0x73, 0x254, 0x3b, 0x6d, 0x61, 0x64, 0x3b, 0x64, 0x69, 0x14b, 0x3b, 0x6e, 0x79, 0x25b, 0x74, 0x3b, 0x6d,
0x61, 0x79, 0x3b, 0x74, 0x69, 0x6e, 0x3b, 0x65, 0x6c, 0xe1, 0x3b, 0x64, 0x69, 0x6d, 0x254, 0x301, 0x64, 0x69, 0x3b, 0x14b,
0x67, 0x254, 0x6e, 0x64, 0x25b, 0x3b, 0x73, 0x254, 0x14b, 0x25b, 0x3b, 0x64, 0x69, 0x253, 0xe1, 0x253, 0xe1, 0x3b, 0x65, 0x6d,
0x69, 0x61, 0x73, 0x65, 0x6c, 0x65, 0x3b, 0x65, 0x73, 0x254, 0x70, 0x25b, 0x73, 0x254, 0x70, 0x25b, 0x3b, 0x6d, 0x61, 0x64,
0x69, 0x253, 0x25b, 0x301, 0x64, 0xed, 0x253, 0x25b, 0x301, 0x3b, 0x64, 0x69, 0x14b, 0x67, 0x69, 0x6e, 0x64, 0x69, 0x3b, 0x6e,
0x79, 0x25b, 0x74, 0x25b, 0x6b, 0x69, 0x3b, 0x6d, 0x61, 0x79, 0xe9, 0x73, 0x25b, 0x301, 0x3b, 0x74, 0x69, 0x6e, 0xed, 0x6e,
0xed, 0x3b, 0x65, 0x6c, 0xe1, 0x14b, 0x67, 0x25b, 0x301, 0x3b, 0x64, 0x3b, 0x14b, 0x3b, 0x73, 0x3b, 0x64, 0x3b, 0x65, 0x3b,
0x65, 0x3b, 0x6d, 0x3b, 0x64, 0x3b, 0x6e, 0x3b, 0x6d, 0x3b, 0x74, 0x3b, 0x65, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65,
0x62, 0x3b, 0x6d, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x65, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75,
0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65,
0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x6d,
0x61, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x65, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b,
0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf22, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0xf23, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf24, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf25, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf26, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0xf27, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf28, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf29, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0xf20,
0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0xf21, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0xf22, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3,
0xf0b, 0xf51, 0xf44, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54,
0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf42, 0xf66, 0xf74, 0xf58, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4,
0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf5e, 0xf72, 0xf0b, 0xf54, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b,
0xf63, 0xf94, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42, 0xf0b, 0xf54,
0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf51, 0xf74, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1,
0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf62, 0xf92, 0xfb1, 0xf51, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f,
0xfb3, 0xf0b, 0xf51, 0xf42, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74,
0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf45, 0xf72, 0xf42,
0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66,
0xf0b, 0xf54, 0xf0b, 0x3b, 0xf21, 0x3b, 0xf22, 0x3b, 0xf23, 0x3b, 0xf24, 0x3b, 0xf25, 0x3b, 0xf26, 0x3b, 0xf27, 0x3b, 0xf28, 0x3b,
0xf29, 0x3b, 0xf21, 0xf20, 0x3b, 0xf21, 0xf21, 0x3b, 0xf21, 0xf22, 0x3b, 0xf21, 0x3b, 0xf22, 0x3b, 0xf23, 0x3b, 0xf24, 0x3b, 0xf25,
0x3b, 0xf26, 0x3b, 0xf27, 0x3b, 0xf28, 0x3b, 0xf29, 0x3b, 0xf21, 0xf20, 0x3b, 0xf21, 0xf21, 0x3b, 0x31, 0x32, 0x3b, 0xf5f, 0xfb3,
0xf0b, 0xf51, 0xf44, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b,
0xf42, 0xf66, 0xf74, 0xf58, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf5e, 0xf72, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3,
0xf0b, 0xf63, 0xf94, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b,
0xf56, 0xf51, 0xf74, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf62, 0xf92, 0xfb1, 0xf51, 0xf0b, 0xf54, 0xf0b, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0xf51, 0xf42, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf45, 0xf72, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45,
0xf74, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf21, 0x3b, 0xf22, 0x3b, 0xf23, 0x3b, 0x34, 0x3b, 0xf25, 0x3b,
0xf26, 0x3b, 0xf27, 0x3b, 0xf28, 0x3b, 0x39, 0x3b, 0xf21, 0xf20, 0x3b, 0xf21, 0xf21, 0x3b, 0xf21, 0xf22, 0x3b, 0x4d, 0x62, 0x65,
0x3b, 0x4b, 0x61, 0x69, 0x3b, 0x4b, 0x61, 0x74, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x47, 0x61, 0x74, 0x3b, 0x47, 0x61, 0x6e,
0x3b, 0x4d, 0x75, 0x67, 0x3b, 0x4b, 0x6e, 0x6e, 0x3b, 0x4b, 0x65, 0x6e, 0x3b, 0x49, 0x6b, 0x75, 0x3b, 0x49, 0x6d, 0x77,
0x3b, 0x49, 0x67, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x72, 0x65, 0x3b,
0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x129, 0x72, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x68, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61,
0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e,
0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x74, 0x61, 0x74, 0x169,
0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x169, 0x67, 0x77, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x4d,
0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69,
0x6b, 0x169, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x20,
0x6e, 0x61, 0x20, 0x169, 0x6d, 0x77, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169,
0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x4b, 0x61, 0x129, 0x72, 0x129, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b,
0x47, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc30,
0xd801, 0xdc4c, 0x3b, 0xd801, 0xdc19, 0xd801, 0xdc2f, 0xd801, 0xdc3a, 0x3b, 0xd801, 0xdc23, 0xd801, 0xdc2a, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc01, 0xd801,
0xdc39, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc23, 0xd801, 0xdc29, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc2d, 0xd801, 0xdc4c, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc2d,
0xd801, 0xdc4a, 0x3b, 0xd801, 0xdc02, 0xd801, 0xdc40, 0x3b, 0xd801, 0xdc1d, 0xd801, 0xdc2f, 0xd801, 0xdc39, 0x3b, 0xd801, 0xdc09, 0xd801, 0xdc3f, 0xd801,
0xdc3b, 0x3b, 0xd801, 0xdc24, 0xd801, 0xdc2c, 0xd801, 0xdc42, 0x3b, 0xd801, 0xdc14, 0xd801, 0xdc28, 0xd801, 0xdc45, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc30,
0xd801, 0xdc4c, 0xd801, 0xdc37, 0xd801, 0xdc2d, 0xd801, 0xdc2f, 0xd801, 0xdc49, 0xd801, 0xdc28, 0x3b, 0xd801, 0xdc19, 0xd801, 0xdc2f, 0xd801, 0xdc3a, 0xd801,
0xdc49, 0xd801, 0xdc2d, 0xd801, 0xdc2f, 0xd801, 0xdc49, 0xd801, 0xdc28, 0x3b, 0xd801, 0xdc23, 0xd801, 0xdc2a, 0xd801, 0xdc49, 0xd801, 0xdc3d, 0x3b, 0xd801,
0xdc01, 0xd801, 0xdc39, 0xd801, 0xdc49, 0xd801, 0xdc2e, 0xd801, 0xdc4a, 0x3b, 0xd801, 0xdc23, 0xd801, 0xdc29, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc2d, 0xd801,
0xdc4c, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc2d, 0xd801, 0xdc4a, 0xd801, 0xdc34, 0x3b, 0xd801, 0xdc02, 0xd801, 0xdc40, 0xd801, 0xdc32, 0xd801, 0xdc45, 0xd801,
0xdc3b, 0x3b, 0xd801, 0xdc1d, 0xd801, 0xdc2f, 0xd801, 0xdc39, 0xd801, 0xdc3b, 0xd801, 0xdc2f, 0xd801, 0xdc4b, 0xd801, 0xdc3a, 0xd801, 0xdc32, 0xd801, 0xdc49,
0x3b, 0xd801, 0xdc09, 0xd801, 0xdc3f, 0xd801, 0xdc3b, 0xd801, 0xdc2c, 0xd801, 0xdc3a, 0xd801, 0xdc32, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc24, 0xd801, 0xdc2c,
0xd801, 0xdc42, 0xd801, 0xdc2f, 0xd801, 0xdc4b, 0xd801, 0xdc3a, 0xd801, 0xdc32, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc14, 0xd801, 0xdc28, 0xd801, 0xdc45, 0xd801,
0xdc2f, 0xd801, 0xdc4b, 0xd801, 0xdc3a, 0xd801, 0xdc32, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc16, 0x3b, 0xd801, 0xdc19, 0x3b, 0xd801, 0xdc23, 0x3b, 0xd801,
0xdc01, 0x3b, 0xd801, 0xdc23, 0x3b, 0xd801, 0xdc16, 0x3b, 0xd801, 0xdc16, 0x3b, 0xd801, 0xdc02, 0x3b, 0xd801, 0xdc1d, 0x3b, 0xd801, 0xdc09, 0x3b,
0xd801, 0xdc24, 0x3b, 0xd801, 0xdc14, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70,
0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65,
0x70, 0x74, 0x3b, 0x4f, 0x63, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46,
0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x4a, 0x75, 0x6e, 0x65, 0x3b,
0x4a, 0x75, 0x6c, 0x79, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x3b, 0x4f, 0x63, 0x74, 0x3b, 0x4e, 0x6f,
0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0xb7, 0xd801, 0xdc61, 0xd801, 0xdc68, 0x3b, 0xb7, 0xd801, 0xdc53, 0xd801, 0xdc67, 0x3b, 0xb7, 0xd801,
0xdc65, 0xd801, 0xdc78, 0x3b, 0xb7, 0xd801, 0xdc71, 0xd801, 0xdc50, 0x3b, 0xb7, 0xd801, 0xdc65, 0xd801, 0xdc71, 0x3b, 0xb7, 0xd801, 0xdc61, 0xd801,
0xdc75, 0x3b, 0xb7, 0xd801, 0xdc61, 0xd801, 0xdc6b, 0x3b, 0xb7, 0xd801, 0xdc6a, 0xd801, 0xdc5c, 0x3b, 0xb7, 0xd801, 0xdc55, 0xd801, 0xdc67, 0x3b,
0xb7, 0xd801, 0xdc77, 0xd801, 0xdc52, 0x3b, 0xb7, 0xd801, 0xdc6f, 0xd801, 0xdc74, 0x3b, 0xb7, 0xd801, 0xdc5b, 0xd801, 0xdc6d, 0x3b, 0xb7, 0xd801,
0xdc61, 0xd801, 0xdc68, 0xd801, 0xdc59, 0xd801, 0xdc58, 0xd801, 0xdc6d, 0xd801, 0xdc62, 0xd801, 0xdc7a, 0xd801, 0xdc70, 0x3b, 0xb7, 0xd801, 0xdc53, 0xd801,
0xdc67, 0xd801, 0xdc5a, 0xd801, 0xdc58, 0xd801, 0xdc75, 0xd801, 0xdc62, 0xd801, 0xdc7a, 0xd801, 0xdc70, 0x3b, 0xb7, 0xd801, 0xdc65, 0xd801, 0xdc78, 0xd801,
0xdc57, 0x3b, 0xb7, 0xd801, 0xdc71, 0xd801, 0xdc50, 0xd801, 0xdc6e, 0xd801, 0xdc6d, 0xd801, 0xdc64, 0x3b, 0xb7, 0xd801, 0xdc65, 0xd801, 0xdc71, 0x3b,
0xb7, 0xd801, 0xdc61, 0xd801, 0xdc75, 0xd801, 0xdc6f, 0x3b, 0xb7, 0xd801, 0xdc61, 0xd801, 0xdc6b, 0xd801, 0xdc64, 0xd801, 0xdc72, 0x3b, 0xb7, 0xd801,
0xdc6a, 0xd801, 0xdc5c, 0xd801, 0xdc6d, 0xd801, 0xdc55, 0xd801, 0xdc51, 0x3b, 0xb7, 0xd801, 0xdc55, 0xd801, 0xdc67, 0xd801, 0xdc50, 0xd801, 0xdc51, 0xd801,
0xdc67, 0xd801, 0xdc65, 0xd801, 0xdc5a, 0xd801, 0xdc78, 0x3b, 0xb7, 0xd801, 0xdc77, 0xd801, 0xdc52, 0xd801, 0xdc51, 0xd801, 0xdc74, 0xd801, 0xdc5a, 0xd801,
0xdc78, 0x3b, 0xb7, 0xd801, 0xdc6f, 0xd801, 0xdc74, 0xd801, 0xdc5d, 0xd801, 0xdc67, 0xd801, 0xdc65, 0xd801, 0xdc5a, 0xd801, 0xdc78, 0x3b, 0xb7, 0xd801,
0xdc5b, 0xd801, 0xdc6d, 0xd801, 0xdc55, 0xd801, 0xdc67, 0xd801, 0xdc65, 0xd801, 0xdc5a, 0xd801, 0xdc78, 0x3b, 0xd801, 0xdc61, 0x3b, 0xd801, 0xdc53, 0x3b,
0xd801, 0xdc65, 0x3b, 0xd801, 0xdc71, 0x3b, 0xd801, 0xdc65, 0x3b, 0xd801, 0xdc61, 0x3b, 0xd801, 0xdc61, 0x3b, 0xd801, 0xdc6a, 0x3b, 0xd801, 0xdc55,
0x3b, 0xd801, 0xdc77, 0x3b, 0xd801, 0xdc6f, 0x3b, 0xd801, 0xdc5b, 0x3b, 0x44f, 0x43a, 0x448, 0x3b, 0x434, 0x430, 0x432, 0x3b, 0x44d, 0x439,
0x437, 0x3b, 0x447, 0x430, 0x434, 0x3b, 0x43f, 0x430, 0x43d, 0x3b, 0x430, 0x448, 0x442, 0x3b, 0x43c, 0x435, 0x434, 0x3b, 0x443, 0x43c,
0x430, 0x3b, 0x442, 0x430, 0x448, 0x3b, 0x43e, 0x436, 0x43e, 0x3b, 0x441, 0x443, 0x43d, 0x3b, 0x430, 0x446, 0x430, 0x3b, 0x44f, 0x43a,
0x448, 0x430, 0x43c, 0x43a, 0x43e, 0x432, 0x3b, 0x434, 0x430, 0x432, 0x43e, 0x43b, 0x43a, 0x43e, 0x432, 0x3b, 0x44d, 0x439, 0x437, 0x44e,
0x440, 0x43a, 0x43e, 0x432, 0x3b, 0x447, 0x430, 0x434, 0x44b, 0x43a, 0x43e, 0x432, 0x3b, 0x43f, 0x430, 0x43d, 0x436, 0x438, 0x43a, 0x43e,
0x432, 0x3b, 0x430, 0x448, 0x442, 0x435, 0x43c, 0x43a, 0x43e, 0x432, 0x3b, 0x43c, 0x435, 0x434, 0x44c, 0x43a, 0x43e, 0x432, 0x3b, 0x443,
0x43c, 0x430, 0x440, 0x44c, 0x43a, 0x43e, 0x432, 0x3b, 0x442, 0x430, 0x448, 0x442, 0x430, 0x43c, 0x43a, 0x43e, 0x432, 0x3b, 0x43e, 0x436,
0x43e, 0x43a, 0x43e, 0x432, 0x3b, 0x441, 0x443, 0x43d, 0x434, 0x435, 0x440, 0x44c, 0x43a, 0x43e, 0x432, 0x3b, 0x430, 0x446, 0x430, 0x43c,
0x43a, 0x43e, 0x432, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b,
0x4d, 0x61, 0x6a, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x16d, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b,
0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x6f, 0x3b,
0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x6f, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c,
0x6f, 0x3b, 0x6d, 0x61, 0x6a, 0x6f, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x3b, 0x61,
0x16d, 0x67, 0x75, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x6f, 0x6b, 0x74,
0x6f, 0x62, 0x72, 0x6f, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62,
0x72, 0x6f, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d,
0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x16d, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f,
0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x61, 0x6e, 0x3b, 0x76, 0x65, 0x65, 0x62,
0x72, 0x3b, 0x6d, 0xe4, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6e,
0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x3b, 0x6f, 0x6b, 0x74,
0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x74, 0x73, 0x3b, 0x6a, 0x61, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x76, 0x65,
0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0xe4, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x6c, 0x3b,
0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75,
0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x65,
0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x74, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x4a, 0x3b, 0x56, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f,
0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x64, 0x7a, 0x76, 0x3b, 0x64, 0x7a, 0x64, 0x3b, 0x74, 0x65, 0x64, 0x3b, 0x61, 0x66, 0x254,
0x3b, 0x64, 0x61, 0x6d, 0x3b, 0x6d, 0x61, 0x73, 0x3b, 0x73, 0x69, 0x61, 0x3b, 0x64, 0x65, 0x61, 0x3b, 0x61, 0x6e, 0x79,
0x3b, 0x6b, 0x65, 0x6c, 0x3b, 0x61, 0x64, 0x65, 0x3b, 0x64, 0x7a, 0x6d, 0x3b, 0x64, 0x7a, 0x6f, 0x76, 0x65, 0x3b, 0x64,
0x7a, 0x6f, 0x64, 0x7a, 0x65, 0x3b, 0x74, 0x65, 0x64, 0x6f, 0x78, 0x65, 0x3b, 0x61, 0x66, 0x254, 0x66, 0x129, 0x65, 0x3b,
0x64, 0x61, 0x6d, 0x61, 0x3b, 0x6d, 0x61, 0x73, 0x61, 0x3b, 0x73, 0x69, 0x61, 0x6d, 0x6c, 0x254, 0x6d, 0x3b, 0x64, 0x65,
0x61, 0x73, 0x69, 0x61, 0x6d, 0x69, 0x6d, 0x65, 0x3b, 0x61, 0x6e, 0x79, 0x254, 0x6e, 0x79, 0x254, 0x3b, 0x6b, 0x65, 0x6c,
0x65, 0x3b, 0x61, 0x64, 0x65, 0x25b, 0x6d, 0x65, 0x6b, 0x70, 0x254, 0x78, 0x65, 0x3b, 0x64, 0x7a, 0x6f, 0x6d, 0x65, 0x3b,
0x64, 0x3b, 0x64, 0x3b, 0x74, 0x3b, 0x61, 0x3b, 0x64, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x64, 0x3b, 0x61, 0x3b, 0x6b, 0x3b,
0x61, 0x3b, 0x64, 0x3b, 0x6e, 0x67, 0x6f, 0x3b, 0x6e, 0x67, 0x62, 0x3b, 0x6e, 0x67, 0x6c, 0x3b, 0x6e, 0x67, 0x6e, 0x3b,
0x6e, 0x67, 0x74, 0x3b, 0x6e, 0x67, 0x73, 0x3b, 0x6e, 0x67, 0x7a, 0x3b, 0x6e, 0x67, 0x6d, 0x3b, 0x6e, 0x67, 0x65, 0x3b,
0x6e, 0x67, 0x61, 0x3b, 0x6e, 0x67, 0x61, 0x64, 0x3b, 0x6e, 0x67, 0x61, 0x62, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6f,
0x73, 0xfa, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x62, 0x25b, 0x30c, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6c, 0xe1, 0x6c,
0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6e, 0x79, 0x69, 0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x74, 0xe1,
0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x73, 0x61, 0x6d, 0x259, 0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20,
0x7a, 0x61, 0x6d, 0x67, 0x62, 0xe1, 0x6c, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6d, 0x77, 0x6f, 0x6d, 0x3b, 0x6e,
0x67, 0x254, 0x6e, 0x20, 0x65, 0x62, 0x75, 0x6c, 0xfa, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x61, 0x77, 0xf3, 0x6d, 0x3b,
0x6e, 0x67, 0x254, 0x6e, 0x20, 0x61, 0x77, 0xf3, 0x6d, 0x20, 0x61, 0x69, 0x20, 0x64, 0x7a, 0x69, 0xe1, 0x3b, 0x6e, 0x67,
0x254, 0x6e, 0x20, 0x61, 0x77, 0xf3, 0x6d, 0x20, 0x61, 0x69, 0x20, 0x62, 0x25b, 0x30c, 0x3b, 0x6f, 0x3b, 0x62, 0x3b, 0x6c,
0x3b, 0x6e, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x7a, 0x3b, 0x6d, 0x3b, 0x65, 0x3b, 0x61, 0x3b, 0x64, 0x3b, 0x62, 0x3b, 0x6a,
0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a,
0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e,
0x6f, 0x76, 0x3b, 0x64, 0x65, 0x73, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61,
0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0xed, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e,
0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b,
0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a,
0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e,
0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x73, 0x2e, 0x3b, 0x45, 0x3b, 0x50, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x48,
0x75, 0x6e, 0x3b, 0x48, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e,
0x6f, 0x62, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x74, 0x61, 0x6d, 0x6d, 0x69, 0x3b, 0x68, 0x65, 0x6c, 0x6d, 0x69, 0x3b, 0x6d,
0x61, 0x61, 0x6c, 0x69, 0x73, 0x3b, 0x68, 0x75, 0x68, 0x74, 0x69, 0x3b, 0x74, 0x6f, 0x75, 0x6b, 0x6f, 0x3b, 0x6b, 0x65,
0x73, 0xe4, 0x3b, 0x68, 0x65, 0x69, 0x6e, 0xe4, 0x3b, 0x65, 0x6c, 0x6f, 0x3b, 0x73, 0x79, 0x79, 0x73, 0x3b, 0x6c, 0x6f,
0x6b, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x72, 0x61, 0x73, 0x3b, 0x6a, 0x6f, 0x75, 0x6c, 0x75, 0x3b, 0x74, 0x61, 0x6d, 0x6d,
0x69, 0x6b, 0x75, 0x75, 0x3b, 0x68, 0x65, 0x6c, 0x6d, 0x69, 0x6b, 0x75, 0x75, 0x3b, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x73,
0x6b, 0x75, 0x75, 0x3b, 0x68, 0x75, 0x68, 0x74, 0x69, 0x6b, 0x75, 0x75, 0x3b, 0x74, 0x6f, 0x75, 0x6b, 0x6f, 0x6b, 0x75,
0x75, 0x3b, 0x6b, 0x65, 0x73, 0xe4, 0x6b, 0x75, 0x75, 0x3b, 0x68, 0x65, 0x69, 0x6e, 0xe4, 0x6b, 0x75, 0x75, 0x3b, 0x65,
0x6c, 0x6f, 0x6b, 0x75, 0x75, 0x3b, 0x73, 0x79, 0x79, 0x73, 0x6b, 0x75, 0x75, 0x3b, 0x6c, 0x6f, 0x6b, 0x61, 0x6b, 0x75,
0x75, 0x3b, 0x6d, 0x61, 0x72, 0x72, 0x61, 0x73, 0x6b, 0x75, 0x75, 0x3b, 0x6a, 0x6f, 0x75, 0x6c, 0x75, 0x6b, 0x75, 0x75,
0x3b, 0x54, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x48, 0x3b, 0x45, 0x3b, 0x53, 0x3b, 0x4c,
0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x74, 0x61, 0x6d, 0x6d, 0x69, 0x6b, 0x2e, 0x3b, 0x68, 0x65, 0x6c, 0x6d, 0x69, 0x6b, 0x2e,
0x3b, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x73, 0x6b, 0x2e, 0x3b, 0x68, 0x75, 0x68, 0x74, 0x69, 0x6b, 0x2e, 0x3b, 0x74, 0x6f,
0x75, 0x6b, 0x6f, 0x6b, 0x2e, 0x3b, 0x6b, 0x65, 0x73, 0xe4, 0x6b, 0x2e, 0x3b, 0x68, 0x65, 0x69, 0x6e, 0xe4, 0x6b, 0x2e,
0x3b, 0x65, 0x6c, 0x6f, 0x6b, 0x2e, 0x3b, 0x73, 0x79, 0x79, 0x73, 0x6b, 0x2e, 0x3b, 0x6c, 0x6f, 0x6b, 0x61, 0x6b, 0x2e,
0x3b, 0x6d, 0x61, 0x72, 0x72, 0x61, 0x73, 0x6b, 0x2e, 0x3b, 0x6a, 0x6f, 0x75, 0x6c, 0x75, 0x6b, 0x2e, 0x3b, 0x74, 0x61,
0x6d, 0x6d, 0x69, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x68, 0x65, 0x6c, 0x6d, 0x69, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b,
0x6d, 0x61, 0x61, 0x6c, 0x69, 0x73, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x68, 0x75, 0x68, 0x74, 0x69, 0x6b, 0x75, 0x75,
0x74, 0x61, 0x3b, 0x74, 0x6f, 0x75, 0x6b, 0x6f, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6b, 0x65, 0x73, 0xe4, 0x6b, 0x75,
0x75, 0x74, 0x61, 0x3b, 0x68, 0x65, 0x69, 0x6e, 0xe4, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x65, 0x6c, 0x6f, 0x6b, 0x75,
0x75, 0x74, 0x61, 0x3b, 0x73, 0x79, 0x79, 0x73, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6c, 0x6f, 0x6b, 0x61, 0x6b, 0x75,
0x75, 0x74, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x72, 0x61, 0x73, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6a, 0x6f, 0x75, 0x6c,
0x75, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x2e, 0x3b, 0x66, 0xe9, 0x76, 0x72, 0x2e, 0x3b, 0x6d,
0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x69, 0x6e, 0x3b, 0x6a, 0x75,
0x69, 0x6c, 0x2e, 0x3b, 0x61, 0x6f, 0xfb, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b,
0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0xe9, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x69, 0x65, 0x72, 0x3b, 0x66, 0xe9,
0x76, 0x72, 0x69, 0x65, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69,
0x3b, 0x6a, 0x75, 0x69, 0x6e, 0x3b, 0x6a, 0x75, 0x69, 0x6c, 0x6c, 0x65, 0x74, 0x3b, 0x61, 0x6f, 0xfb, 0x74, 0x3b, 0x73,
0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76,
0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0xe9, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x2e,
0x3b, 0x66, 0xe9, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69,
0x3b, 0x6a, 0x75, 0x69, 0x6e, 0x3b, 0x6a, 0x75, 0x69, 0x6c, 0x6c, 0x2e, 0x3b, 0x61, 0x6f, 0xfb, 0x74, 0x3b, 0x73, 0x65,
0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0xe9, 0x63, 0x2e, 0x3b, 0x6a,
0x61, 0x6e, 0x2e, 0x3b, 0x66, 0xe9, 0x76, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d,
0x61, 0x69, 0x3b, 0x6a, 0x75, 0x69, 0x2e, 0x3b, 0x6a, 0x75, 0x69, 0x6c, 0x2e, 0x3b, 0x61, 0x6f, 0xfb, 0x74, 0x3b, 0x73,
0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0xe9, 0x63, 0x2e, 0x3b,
0x5a, 0x65, 0x6e, 0x3b, 0x46, 0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x76, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b,
0x4a, 0x75, 0x67, 0x3b, 0x4c, 0x75, 0x69, 0x3b, 0x41, 0x76, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x74, 0x75, 0x3b,
0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x63, 0x3b, 0x5a, 0x65, 0x6e, 0xe2, 0x72, 0x3b, 0x46, 0x65, 0x76, 0x72, 0xe2, 0x72,
0x3b, 0x4d, 0x61, 0x72, 0xe7, 0x3b, 0x41, 0x76, 0x72, 0xee, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x67, 0x6e,
0x3b, 0x4c, 0x75, 0x69, 0x3b, 0x41, 0x76, 0x6f, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b,
0x4f, 0x74, 0x75, 0x62, 0x61, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x44, 0x69, 0x63, 0x65,
0x6d, 0x62, 0x61, 0x72, 0x3b, 0x5a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4c, 0x3b, 0x41,
0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x73, 0x69, 0x69, 0x3b, 0x63, 0x6f, 0x6c, 0x3b, 0x6d, 0x62, 0x6f,
0x3b, 0x73, 0x65, 0x65, 0x3b, 0x64, 0x75, 0x75, 0x3b, 0x6b, 0x6f, 0x72, 0x3b, 0x6d, 0x6f, 0x72, 0x3b, 0x6a, 0x75, 0x6b,
0x3b, 0x73, 0x6c, 0x74, 0x3b, 0x79, 0x61, 0x72, 0x3b, 0x6a, 0x6f, 0x6c, 0x3b, 0x62, 0x6f, 0x77, 0x3b, 0x73, 0x69, 0x69,
0x6c, 0x6f, 0x3b, 0x63, 0x6f, 0x6c, 0x74, 0x65, 0x3b, 0x6d, 0x62, 0x6f, 0x6f, 0x79, 0x3b, 0x73, 0x65, 0x65, 0x257, 0x74,
0x6f, 0x3b, 0x64, 0x75, 0x75, 0x6a, 0x61, 0x6c, 0x3b, 0x6b, 0x6f, 0x72, 0x73, 0x65, 0x3b, 0x6d, 0x6f, 0x72, 0x73, 0x6f,
0x3b, 0x6a, 0x75, 0x6b, 0x6f, 0x3b, 0x73, 0x69, 0x69, 0x6c, 0x74, 0x6f, 0x3b, 0x79, 0x61, 0x72, 0x6b, 0x6f, 0x6d, 0x61,
0x61, 0x3b, 0x6a, 0x6f, 0x6c, 0x61, 0x6c, 0x3b, 0x62, 0x6f, 0x77, 0x74, 0x65, 0x3b, 0x73, 0x3b, 0x63, 0x3b, 0x6d, 0x3b,
0x73, 0x3b, 0x64, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x73, 0x3b, 0x79, 0x3b, 0x6a, 0x3b, 0x62, 0x3b, 0xd83a, 0xdd05,
0xd83a, 0xdd2d, 0xd83a, 0xdd45, 0xd83a, 0xdd24, 0x3b, 0xd83a, 0xdd15, 0xd83a, 0xdd2e, 0xd83a, 0xdd24, 0x3b, 0xd83a, 0xdd10, 0xd83a, 0xdd26, 0xd83a, 0xdd2e,
0xd83a, 0xdd45, 0xd83a, 0xdd34, 0x3b, 0xd83a, 0xdd05, 0xd83a, 0xdd2b, 0xd83a, 0xdd45, 0xd83a, 0xdd3c, 0x3b, 0xd83a, 0xdd01, 0xd83a, 0xdd35, 0xd83a, 0xdd45,
0xd83a, 0xdd36, 0x3b, 0xd83a, 0xdd11, 0xd83a, 0xdd2e, 0xd83a, 0xdd2a, 0x3b, 0xd83a, 0xdd03, 0xd83a, 0xdd2e, 0xd83a, 0xdd2a, 0x3b, 0xd83a, 0xdd14, 0xd83a,
0xdd35, 0xd83a, 0xdd33, 0x3b, 0xd83a, 0xdd05, 0xd83a, 0xdd2d, 0xd83a, 0xdd24, 0x3b, 0xd83a, 0xdd12, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0x3b, 0xd83a, 0xdd14,
0xd83a, 0xdd2e, 0xd83a, 0xdd24, 0x3b, 0xd83a, 0xdd04, 0xd83a, 0xdd2e, 0xd83a, 0xdd31, 0x3b, 0xd83a, 0xdd05, 0xd83a, 0xdd2d, 0xd83a, 0xdd45, 0xd83a, 0xdd24,
0xd83a, 0xdd2e, 0x3b, 0xd83a, 0xdd15, 0xd83a, 0xdd2e, 0xd83a, 0xdd24, 0xd83a, 0xdd3c, 0xd83a, 0xdd2e, 0x3b, 0xd83a, 0xdd10, 0xd83a, 0xdd26, 0xd83a, 0xdd2e,
0xd83a, 0xdd45, 0xd83a, 0xdd34, 0xd83a, 0xdd2e, 0x3b, 0xd83a, 0xdd05, 0xd83a, 0xdd2b, 0xd83a, 0xdd45, 0xd83a, 0xdd3c, 0xd83a, 0xdd2e, 0x3b, 0xd83a, 0xdd01,
0xd83a, 0xdd35, 0xd83a, 0xdd45, 0xd83a, 0xdd36, 0xd83a, 0xdd2e, 0x3b, 0xd83a, 0xdd11, 0xd83a, 0xdd2e, 0xd83a, 0xdd2a, 0xd83a, 0xdd27, 0xd83a, 0xdd2e, 0x3b,
0xd83a, 0xdd03, 0xd83a, 0xdd2e, 0xd83a, 0xdd2a, 0xd83a, 0xdd27, 0xd83a, 0xdd2e, 0x3b, 0xd83a, 0xdd14, 0xd83a, 0xdd35, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b,
0xd83a, 0xdd05, 0xd83a, 0xdd2d, 0xd83a, 0xdd24, 0xd83a, 0xdd3c, 0xd83a, 0xdd2e, 0x3b, 0xd83a, 0xdd12, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a, 0xdd33, 0xd83a,
0xdd2e, 0x3b, 0xd83a, 0xdd14, 0xd83a, 0xdd2e, 0xd83a, 0xdd24, 0xd83a, 0xdd2e, 0x3b, 0xd83a, 0xdd04, 0xd83a, 0xdd2e, 0xd83a, 0xdd31, 0xd83a, 0xdd3c, 0xd83a,
0xdd2e, 0x3b, 0xd83a, 0xdd05, 0x3b, 0xd83a, 0xdd15, 0x3b, 0xd83a, 0xdd04, 0x3b, 0xd83a, 0xdd05, 0x3b, 0xd83a, 0xdd01, 0x3b, 0xd83a, 0xdd11, 0x3b,
0xd83a, 0xdd03, 0x3b, 0xd83a, 0xdd14, 0x3b, 0xd83a, 0xdd05, 0x3b, 0xd83a, 0xdd12, 0x3b, 0xd83a, 0xdd14, 0x3b, 0xd83a, 0xdd04, 0x3b, 0x41, 0x68,
0x61, 0x3b, 0x4f, 0x66, 0x6c, 0x3b, 0x4f, 0x74, 0x73, 0x3b, 0x41, 0x62, 0x65, 0x3b, 0x41, 0x67, 0x62, 0x3b, 0x4f, 0x74,
0x75, 0x3b, 0x4d, 0x61, 0x61, 0x3b, 0x4d, 0x61, 0x6e, 0x3b, 0x47, 0x62, 0x6f, 0x3b, 0x41, 0x6e, 0x74, 0x3b, 0x41, 0x6c,
0x65, 0x3b, 0x41, 0x66, 0x75, 0x3b, 0x41, 0x68, 0x61, 0x72, 0x61, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x4f, 0x66, 0x6c, 0x254,
0x3b, 0x4f, 0x74, 0x73, 0x6f, 0x6b, 0x72, 0x69, 0x6b, 0x72, 0x69, 0x3b, 0x41, 0x62, 0x65, 0x69, 0x62, 0x65, 0x3b, 0x41,
0x67, 0x62, 0x69, 0x25b, 0x6e, 0x61, 0x61, 0x3b, 0x4f, 0x74, 0x75, 0x6b, 0x77, 0x61, 0x6a, 0x61, 0x6e, 0x3b, 0x4d, 0x61,
0x61, 0x77, 0x25b, 0x3b, 0x4d, 0x61, 0x6e, 0x79, 0x61, 0x77, 0x61, 0x6c, 0x65, 0x3b, 0x47, 0x62, 0x6f, 0x3b, 0x41, 0x6e,
0x74, 0x254, 0x14b, 0x3b, 0x41, 0x6c, 0x65, 0x6d, 0x6c, 0x65, 0x3b, 0x41, 0x66, 0x75, 0x61, 0x62, 0x65, 0x3b, 0x41, 0x3b,
0x4f, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x4f, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x41, 0x3b, 0x41, 0x3b,
0x41, 0x3b, 0x41, 0x68, 0x61, 0x72, 0x61, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x4f, 0x66, 0x6c, 0x254, 0x3b, 0x4f, 0x74, 0x73,
0x6f, 0x6b, 0x72, 0x69, 0x6b, 0x72, 0x69, 0x3b, 0x41, 0x62, 0x65, 0x69, 0x62, 0x65, 0x3b, 0x41, 0x67, 0x62, 0x69, 0x25b,
0x6e, 0x61, 0x61, 0x3b, 0x4f, 0x74, 0x75, 0x6b, 0x77, 0x61, 0x6a, 0x61, 0x14b, 0x3b, 0x4d, 0x61, 0x61, 0x77, 0x25b, 0x3b,
0x4d, 0x61, 0x6e, 0x79, 0x61, 0x77, 0x61, 0x6c, 0x65, 0x3b, 0x47, 0x62, 0x6f, 0x3b, 0x41, 0x6e, 0x74, 0x254, 0x14b, 0x3b,
0x41, 0x6c, 0x65, 0x6d, 0x6c, 0x65, 0x3b, 0x41, 0x66, 0x75, 0x61, 0x62, 0x65, 0x3b, 0x46, 0x61, 0x6f, 0x69, 0x3b, 0x47,
0x65, 0x61, 0x72, 0x72, 0x3b, 0x4d, 0xe0, 0x72, 0x74, 0x3b, 0x47, 0x69, 0x62, 0x6c, 0x3b, 0x43, 0xe8, 0x69, 0x74, 0x3b,
0xd2, 0x67, 0x6d, 0x68, 0x3b, 0x49, 0x75, 0x63, 0x68, 0x3b, 0x4c, 0xf9, 0x6e, 0x61, 0x3b, 0x53, 0x75, 0x6c, 0x74, 0x3b,
0x44, 0xe0, 0x6d, 0x68, 0x3b, 0x53, 0x61, 0x6d, 0x68, 0x3b, 0x44, 0xf9, 0x62, 0x68, 0x3b, 0x41, 0x6d, 0x20, 0x46, 0x61,
0x6f, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x63, 0x68, 0x3b, 0x41, 0x6e, 0x20, 0x47, 0x65, 0x61, 0x72, 0x72, 0x61, 0x6e, 0x3b,
0x41, 0x6d, 0x20, 0x4d, 0xe0, 0x72, 0x74, 0x3b, 0x41, 0x6e, 0x20, 0x47, 0x69, 0x62, 0x6c, 0x65, 0x61, 0x6e, 0x3b, 0x41,
0x6e, 0x20, 0x43, 0xe8, 0x69, 0x74, 0x65, 0x61, 0x6e, 0x3b, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0xd2, 0x67, 0x6d, 0x68, 0x69,
0x6f, 0x73, 0x3b, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0x49, 0x75, 0x63, 0x68, 0x61, 0x72, 0x3b, 0x41, 0x6e, 0x20, 0x4c, 0xf9,
0x6e, 0x61, 0x73, 0x74, 0x61, 0x6c, 0x3b, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0x53, 0x75, 0x6c, 0x74, 0x61, 0x69, 0x6e, 0x3b,
0x41, 0x6e, 0x20, 0x44, 0xe0, 0x6d, 0x68, 0x61, 0x69, 0x72, 0x3b, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0x53, 0x61, 0x6d, 0x68,
0x61, 0x69, 0x6e, 0x3b, 0x41, 0x6e, 0x20, 0x44, 0xf9, 0x62, 0x68, 0x6c, 0x61, 0x63, 0x68, 0x64, 0x3b, 0x46, 0x3b, 0x47,
0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x43, 0x3b, 0xd2, 0x3b, 0x49, 0x3b, 0x4c, 0x3b, 0x53, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x44,
0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x46, 0x68, 0x61, 0x6f, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x63, 0x68, 0x3b, 0x64, 0x68,
0x65, 0x6e, 0x20, 0x47, 0x68, 0x65, 0x61, 0x72, 0x72, 0x61, 0x6e, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x4d, 0x68, 0xe0,
0x72, 0x74, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x47, 0x68, 0x69, 0x62, 0x6c, 0x65, 0x61, 0x6e, 0x3b, 0x64, 0x68, 0x65,
0x6e, 0x20, 0x43, 0x68, 0xe8, 0x69, 0x74, 0x65, 0x61, 0x6e, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0xd2, 0x67, 0x6d, 0x68,
0x69, 0x6f, 0x73, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x49, 0x75, 0x63, 0x68, 0x61, 0x72, 0x3b, 0x64, 0x68, 0x65, 0x6e,
0x20, 0x4c, 0xf9, 0x6e, 0x61, 0x73, 0x74, 0x61, 0x6c, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x74, 0x2d, 0x53, 0x75, 0x6c,
0x74, 0x61, 0x69, 0x6e, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x44, 0xe0, 0x6d, 0x68, 0x61, 0x69, 0x72, 0x3b, 0x64, 0x68,
0x65, 0x6e, 0x20, 0x74, 0x2d, 0x53, 0x61, 0x6d, 0x68, 0x61, 0x69, 0x6e, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x44, 0xf9,
0x62, 0x68, 0x6c, 0x61, 0x63, 0x68, 0x64, 0x3b, 0x58, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d, 0x61,
0x72, 0x2e, 0x3b, 0x41, 0x62, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x69, 0x6f, 0x3b, 0x58, 0x75, 0xf1, 0x6f, 0x3b, 0x58, 0x75,
0x6c, 0x2e, 0x3b, 0x41, 0x67, 0x6f, 0x2e, 0x3b, 0x53, 0x65, 0x74, 0x2e, 0x3b, 0x4f, 0x75, 0x74, 0x2e, 0x3b, 0x4e, 0x6f,
0x76, 0x2e, 0x3b, 0x44, 0x65, 0x63, 0x2e, 0x3b, 0x58, 0x61, 0x6e, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x46, 0x65, 0x62, 0x72,
0x65, 0x69, 0x72, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69,
0x6f, 0x3b, 0x58, 0x75, 0xf1, 0x6f, 0x3b, 0x58, 0x75, 0x6c, 0x6c, 0x6f, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b,
0x53, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x4f, 0x75, 0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x4e, 0x6f, 0x76,
0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x58, 0x3b, 0x46, 0x3b, 0x4d,
0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x58, 0x3b, 0x58, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x78,
0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x6d,
0x61, 0x69, 0x6f, 0x3b, 0x78, 0x75, 0xf1, 0x6f, 0x3b, 0x78, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x67, 0x6f, 0x2e, 0x3b, 0x73,
0x65, 0x74, 0x2e, 0x3b, 0x6f, 0x75, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x78,
0x61, 0x6e, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x7a,
0x6f, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x6f, 0x3b, 0x78, 0x75, 0xf1, 0x6f, 0x3b, 0x78, 0x75,
0x6c, 0x6c, 0x6f, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b,
0x6f, 0x75, 0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x64, 0x65, 0x63,
0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x78, 0x2e, 0x3b, 0x66, 0x2e, 0x3b, 0x6d, 0x2e, 0x3b, 0x61, 0x2e, 0x3b, 0x6d, 0x2e,
0x3b, 0x78, 0x2e, 0x3b, 0x78, 0x2e, 0x3b, 0x61, 0x2e, 0x3b, 0x73, 0x2e, 0x3b, 0x6f, 0x2e, 0x3b, 0x6e, 0x2e, 0x3b, 0x64,
0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x75, 0x3b, 0x4d, 0x61,
0x61, 0x3b, 0x4a, 0x75, 0x75, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x75, 0x3b, 0x53, 0x65, 0x62, 0x3b, 0x4f, 0x6b,
0x69, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x77, 0x61, 0x6c, 0x69, 0x79, 0x6f, 0x3b,
0x46, 0x65, 0x62, 0x77, 0x61, 0x6c, 0x69, 0x79, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x69, 0x73, 0x69, 0x3b, 0x41, 0x70, 0x75,
0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x61, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x61,
0x79, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x69, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x62, 0x75, 0x74, 0x74, 0x65, 0x6d, 0x62,
0x61, 0x3b, 0x4f, 0x6b, 0x69, 0x74, 0x6f, 0x62, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44,
0x65, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x1320, 0x1210, 0x1228, 0x3b, 0x12a8, 0x1270, 0x1270, 0x3b, 0x1218, 0x1308, 0x1260, 0x3b, 0x12a0,
0x1280, 0x12d8, 0x3b, 0x130d, 0x1295, 0x1263, 0x1275, 0x3b, 0x1220, 0x1295, 0x12e8, 0x3b, 0x1210, 0x1218, 0x1208, 0x3b, 0x1290, 0x1210, 0x1230, 0x3b,
0x12a8, 0x1228, 0x1218, 0x3b, 0x1320, 0x1240, 0x1218, 0x3b, 0x1280, 0x12f0, 0x1228, 0x3b, 0x1280, 0x1220, 0x1220, 0x3b, 0x1320, 0x3b, 0x12a8, 0x3b,
0x1218, 0x3b, 0x12a0, 0x3b, 0x130d, 0x3b, 0x1220, 0x3b, 0x1210, 0x3b, 0x1290, 0x3b, 0x12a8, 0x3b, 0x1320, 0x3b, 0x1280, 0x3b, 0x1280, 0x3b,
0x10d8, 0x10d0, 0x10dc, 0x3b, 0x10d7, 0x10d4, 0x10d1, 0x3b, 0x10db, 0x10d0, 0x10e0, 0x3b, 0x10d0, 0x10de, 0x10e0, 0x3b, 0x10db, 0x10d0, 0x10d8, 0x3b,
0x10d8, 0x10d5, 0x10dc, 0x3b, 0x10d8, 0x10d5, 0x10da, 0x3b, 0x10d0, 0x10d2, 0x10d5, 0x3b, 0x10e1, 0x10d4, 0x10e5, 0x3b, 0x10dd, 0x10e5, 0x10e2, 0x3b,
0x10dc, 0x10dd, 0x10d4, 0x3b, 0x10d3, 0x10d4, 0x10d9, 0x3b, 0x10d8, 0x10d0, 0x10dc, 0x10d5, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x10d7, 0x10d4, 0x10d1, 0x10d4,
0x10e0, 0x10d5, 0x10d0, 0x10da, 0x10d8, 0x3b, 0x10db, 0x10d0, 0x10e0, 0x10e2, 0x10d8, 0x3b, 0x10d0, 0x10de, 0x10e0, 0x10d8, 0x10da, 0x10d8, 0x3b, 0x10db,
0x10d0, 0x10d8, 0x10e1, 0x10d8, 0x3b, 0x10d8, 0x10d5, 0x10dc, 0x10d8, 0x10e1, 0x10d8, 0x3b, 0x10d8, 0x10d5, 0x10da, 0x10d8, 0x10e1, 0x10d8, 0x3b, 0x10d0,
0x10d2, 0x10d5, 0x10d8, 0x10e1, 0x10e2, 0x10dd, 0x3b, 0x10e1, 0x10d4, 0x10e5, 0x10e2, 0x10d4, 0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10dd, 0x10e5,
0x10e2, 0x10dd, 0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10dc, 0x10dd, 0x10d4, 0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10d3, 0x10d4, 0x10d9,
0x10d4, 0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10d8, 0x3b, 0x10d7, 0x3b, 0x10db, 0x3b, 0x10d0, 0x3b, 0x10db, 0x3b, 0x10d8, 0x3b, 0x10d8,
0x3b, 0x10d0, 0x3b, 0x10e1, 0x3b, 0x10dd, 0x3b, 0x10dc, 0x3b, 0x10d3, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d,
0xe4, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41,
0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x7a, 0x3b, 0x4a,
0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41,
0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41,
0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f,
0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x65,
0x72, 0x3b, 0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72,
0x2e, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x2e,
0x3b, 0x53, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x65, 0x7a,
0x2e, 0x3b, 0x4a, 0xe4, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0xe4, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61,
0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b,
0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x7a, 0x3b, 0x4a, 0xe4, 0x6e, 0x6e, 0x65, 0x72, 0x3b, 0x46, 0x65, 0x62,
0x72, 0x75, 0x61, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b,
0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70,
0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0xe4, 0x6e, 0x2e, 0x3b, 0x46, 0x65,
0x62, 0x2e, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e,
0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x2e, 0x3b, 0x53, 0x65, 0x70, 0x2e, 0x3b, 0x4f, 0x6b, 0x74,
0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x65, 0x7a, 0x2e, 0x3b, 0x399, 0x3b1, 0x3bd, 0x3b, 0x3a6, 0x3b5, 0x3b2, 0x3b,
0x39c, 0x3ac, 0x3c1, 0x3b, 0x391, 0x3c0, 0x3c1, 0x3b, 0x39c, 0x3ac, 0x3b9, 0x3b, 0x399, 0x3bf, 0x3cd, 0x3bd, 0x3b, 0x399, 0x3bf, 0x3cd,
0x3bb, 0x3b, 0x391, 0x3cd, 0x3b3, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3b, 0x39f, 0x3ba, 0x3c4, 0x3b, 0x39d, 0x3bf, 0x3ad, 0x3b, 0x394, 0x3b5,
0x3ba, 0x3b, 0x399, 0x3b1, 0x3bd, 0x3bf, 0x3c5, 0x3ac, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x3a6, 0x3b5, 0x3b2, 0x3c1, 0x3bf, 0x3c5, 0x3ac,
0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x39c, 0x3ac, 0x3c1, 0x3c4, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x391, 0x3c0, 0x3c1, 0x3af, 0x3bb, 0x3b9, 0x3bf,
0x3c2, 0x3b, 0x39c, 0x3ac, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x399, 0x3bf, 0x3cd, 0x3bd, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x399, 0x3bf, 0x3cd, 0x3bb,
0x3b9, 0x3bf, 0x3c2, 0x3b, 0x391, 0x3cd, 0x3b3, 0x3bf, 0x3c5, 0x3c3, 0x3c4, 0x3bf, 0x3c2, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3c4, 0x3ad, 0x3bc,
0x3b2, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x39f, 0x3ba, 0x3c4, 0x3ce, 0x3b2, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x39d, 0x3bf, 0x3ad, 0x3bc,
0x3b2, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x394, 0x3b5, 0x3ba, 0x3ad, 0x3bc, 0x3b2, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x399, 0x3b, 0x3a6,
0x3b, 0x39c, 0x3b, 0x391, 0x3b, 0x39c, 0x3b, 0x399, 0x3b, 0x399, 0x3b, 0x391, 0x3b, 0x3a3, 0x3b, 0x39f, 0x3b, 0x39d, 0x3b, 0x394,
0x3b, 0x399, 0x3b1, 0x3bd, 0x3b, 0x3a6, 0x3b5, 0x3b2, 0x3b, 0x39c, 0x3b1, 0x3c1, 0x3b, 0x391, 0x3c0, 0x3c1, 0x3b, 0x39c, 0x3b1, 0x390,
0x3b, 0x399, 0x3bf, 0x3c5, 0x3bd, 0x3b, 0x399, 0x3bf, 0x3c5, 0x3bb, 0x3b, 0x391, 0x3c5, 0x3b3, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3b, 0x39f,
0x3ba, 0x3c4, 0x3b, 0x39d, 0x3bf, 0x3b5, 0x3b, 0x394, 0x3b5, 0x3ba, 0x3b, 0x399, 0x3b1, 0x3bd, 0x3bf, 0x3c5, 0x3b1, 0x3c1, 0x3af, 0x3bf,
0x3c5, 0x3b, 0x3a6, 0x3b5, 0x3b2, 0x3c1, 0x3bf, 0x3c5, 0x3b1, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x39c, 0x3b1, 0x3c1, 0x3c4, 0x3af, 0x3bf,
0x3c5, 0x3b, 0x391, 0x3c0, 0x3c1, 0x3b9, 0x3bb, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x39c, 0x3b1, 0x390, 0x3bf, 0x3c5, 0x3b, 0x399, 0x3bf, 0x3c5,
0x3bd, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x399, 0x3bf, 0x3c5, 0x3bb, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x391, 0x3c5, 0x3b3, 0x3bf, 0x3cd, 0x3c3, 0x3c4,
0x3bf, 0x3c5, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3c4, 0x3b5, 0x3bc, 0x3b2, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x39f, 0x3ba, 0x3c4, 0x3c9, 0x3b2,
0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x39d, 0x3bf, 0x3b5, 0x3bc, 0x3b2, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x394, 0x3b5, 0x3ba, 0x3b5, 0x3bc,
0x3b2, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x4a, 0x61, 0x73, 0x79, 0x74, 0x65, 0x129, 0x3b, 0x4a, 0x61, 0x73, 0x79, 0x6b, 0xf5,
0x69, 0x3b, 0x4a, 0x61, 0x73, 0x79, 0x61, 0x70, 0x79, 0x3b, 0x4a, 0x61, 0x73, 0x79, 0x72, 0x75, 0x6e, 0x64, 0x79, 0x3b,
0x4a, 0x61, 0x73, 0x79, 0x70, 0x6f, 0x3b, 0x4a, 0x61, 0x73, 0x79, 0x70, 0x6f, 0x74, 0x65, 0x129, 0x3b, 0x4a, 0x61, 0x73,
0x79, 0x70, 0x6f, 0x6b, 0xf5, 0x69, 0x3b, 0x4a, 0x61, 0x73, 0x79, 0x70, 0x6f, 0x61, 0x70, 0x79, 0x3b, 0x4a, 0x61, 0x73,
0x79, 0x70, 0x6f, 0x72, 0x75, 0x6e, 0x64, 0x79, 0x3b, 0x4a, 0x61, 0x73, 0x79, 0x70, 0x61, 0x3b, 0x4a, 0x61, 0x73, 0x79,
0x70, 0x61, 0x74, 0x65, 0x129, 0x3b, 0x4a, 0x61, 0x73, 0x79, 0x70, 0x61, 0x6b, 0xf5, 0x69, 0x3b, 0xa9c, 0xabe, 0xaa8, 0xacd,
0xaaf, 0xac1, 0x3b, 0xaab, 0xac7, 0xaac, 0xacd, 0xab0, 0xac1, 0x3b, 0xaae, 0xabe, 0xab0, 0xacd, 0xa9a, 0x3b, 0xa8f, 0xaaa, 0xacd, 0xab0,
0xabf, 0xab2, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2, 0xaa8, 0x3b, 0xa9c, 0xac1, 0xab2, 0xabe, 0xa88, 0x3b, 0xa91, 0xa97, 0xab8, 0xacd,
0xa9f, 0x3b, 0xab8, 0xaaa, 0xacd, 0xa9f, 0xac7, 0x3b, 0xa91, 0xa95, 0xacd, 0xa9f, 0xacb, 0x3b, 0xaa8, 0xab5, 0xac7, 0x3b, 0xaa1, 0xabf,
0xab8, 0xac7, 0x3b, 0xa9c, 0xabe, 0xaa8, 0xacd, 0xaaf, 0xac1, 0xa86, 0xab0, 0xac0, 0x3b, 0xaab, 0xac7, 0xaac, 0xacd, 0xab0, 0xac1, 0xa86,
0xab0, 0xac0, 0x3b, 0xaae, 0xabe, 0xab0, 0xacd, 0xa9a, 0x3b, 0xa8f, 0xaaa, 0xacd, 0xab0, 0xabf, 0xab2, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c,
0xac2, 0xaa8, 0x3b, 0xa9c, 0xac1, 0xab2, 0xabe, 0xa88, 0x3b, 0xa91, 0xa97, 0xab8, 0xacd, 0xa9f, 0x3b, 0xab8, 0xaaa, 0xacd, 0xa9f, 0xac7,
0xaae, 0xacd, 0xaac, 0xab0, 0x3b, 0xa91, 0xa95, 0xacd, 0xa9f, 0xacb, 0xaac, 0xab0, 0x3b, 0xaa8, 0xab5, 0xac7, 0xaae, 0xacd, 0xaac, 0xab0,
0x3b, 0xaa1, 0xabf, 0xab8, 0xac7, 0xaae, 0xacd, 0xaac, 0xab0, 0x3b, 0xa9c, 0xabe, 0x3b, 0xaab, 0xac7, 0x3b, 0xaae, 0xabe, 0x3b, 0xa8f,
0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2, 0x3b, 0xa9c, 0xac1, 0x3b, 0xa91, 0x3b, 0xab8, 0x3b, 0xa91, 0x3b, 0xaa8, 0x3b, 0xaa1, 0xabf,
0x3b, 0x43, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69,
0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x43, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74,
0x3b, 0x4e, 0x6f, 0x62, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x43, 0x68, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65,
0x62, 0x75, 0x72, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x69, 0x72, 0x69, 0x72, 0x69,
0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x43, 0x68, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x6f,
0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x69, 0x74, 0x6f, 0x62, 0x61,
0x3b, 0x4e, 0x6f, 0x62, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x43, 0x3b, 0x46,
0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x43, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44,
0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940, 0x3b, 0x92b, 0x930, 0x935, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905,
0x92a, 0x94d, 0x930, 0x948, 0x932, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905,
0x917, 0x938, 0x94d, 0x924, 0x3b, 0x938, 0x93f, 0x924, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x942, 0x92c, 0x930,
0x3b, 0x928, 0x935, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x926, 0x93f, 0x938, 0x902, 0x92c, 0x930, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46,
0x61, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x66, 0x69, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59,
0x75, 0x6c, 0x3b, 0x41, 0x67, 0x75, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x75, 0x77, 0x3b, 0x44,
0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x61, 0x69, 0x72, 0x75, 0x3b, 0x46, 0x61, 0x62, 0x75, 0x72, 0x61, 0x69, 0x72, 0x75,
0x3b, 0x4d, 0x61, 0x72, 0x69, 0x73, 0x3b, 0x41, 0x66, 0x69, 0x72, 0x69, 0x6c, 0x75, 0x3b, 0x4d, 0x61, 0x79, 0x75, 0x3b,
0x59, 0x75, 0x6e, 0x69, 0x3b, 0x59, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x74,
0x75, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x75, 0x77, 0x61, 0x6d, 0x62, 0x61, 0x3b,
0x44, 0x69, 0x73, 0x61, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x59, 0x3b,
0x59, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x62c, 0x64e, 0x646, 0x3b, 0x6a2, 0x64e, 0x628, 0x3b,
0x645, 0x64e, 0x631, 0x3b, 0x623, 0x64e, 0x6a2, 0x652, 0x631, 0x3b, 0x645, 0x64e, 0x64a, 0x3b, 0x64a, 0x64f, 0x648, 0x646, 0x3b, 0x64a,
0x64f, 0x648, 0x644, 0x3b, 0x623, 0x64e, 0x63a, 0x64f, 0x3b, 0x633, 0x64e, 0x62a, 0x3b, 0x623, 0x64f, 0x643, 0x652, 0x62a, 0x3b, 0x646,
0x64f, 0x648, 0x3b, 0x62f, 0x650, 0x633, 0x3b, 0x62c, 0x64e, 0x646, 0x64e, 0x64a, 0x652, 0x631, 0x64f, 0x3b, 0x6a2, 0x64e, 0x628, 0x652,
0x631, 0x64e, 0x64a, 0x652, 0x631, 0x64f, 0x3b, 0x645, 0x64e, 0x631, 0x650, 0x633, 0x652, 0x3b, 0x623, 0x64e, 0x6a2, 0x652, 0x631, 0x650,
0x644, 0x64f, 0x3b, 0x645, 0x64e, 0x64a, 0x64f, 0x3b, 0x64a, 0x64f, 0x648, 0x646, 0x650, 0x3b, 0x64a, 0x64f, 0x648, 0x644, 0x650, 0x3b,
0x623, 0x64e, 0x63a, 0x64f, 0x633, 0x652, 0x62a, 0x64e, 0x3b, 0x633, 0x64e, 0x62a, 0x64f, 0x645, 0x652, 0x628, 0x64e, 0x3b, 0x623, 0x64f,
0x643, 0x652, 0x62a, 0x648, 0x64f, 0x628, 0x64e, 0x3b, 0x646, 0x64f, 0x648, 0x64e, 0x645, 0x652, 0x628, 0x64e, 0x3b, 0x62f, 0x650, 0x633,
0x64e, 0x645, 0x652, 0x628, 0x64e, 0x3b, 0x49, 0x61, 0x6e, 0x2e, 0x3b, 0x50, 0x65, 0x70, 0x2e, 0x3b, 0x4d, 0x61, 0x6c, 0x2e,
0x3b, 0x2bb, 0x41, 0x70, 0x2e, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x49, 0x75, 0x6e, 0x2e, 0x3b, 0x49, 0x75, 0x6c, 0x2e, 0x3b,
0x2bb, 0x41, 0x75, 0x2e, 0x3b, 0x4b, 0x65, 0x70, 0x2e, 0x3b, 0x2bb, 0x4f, 0x6b, 0x2e, 0x3b, 0x4e, 0x6f, 0x77, 0x2e, 0x3b,
0x4b, 0x65, 0x6b, 0x2e, 0x3b, 0x49, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x50, 0x65, 0x70, 0x65, 0x6c, 0x75, 0x61,
0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x6b, 0x69, 0x3b, 0x2bb, 0x41, 0x70, 0x65, 0x6c, 0x69, 0x6c, 0x61, 0x3b, 0x4d,
0x65, 0x69, 0x3b, 0x49, 0x75, 0x6e, 0x65, 0x3b, 0x49, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x2bb, 0x41, 0x75, 0x6b, 0x61, 0x6b,
0x65, 0x3b, 0x4b, 0x65, 0x70, 0x61, 0x6b, 0x65, 0x6d, 0x61, 0x70, 0x61, 0x3b, 0x2bb, 0x4f, 0x6b, 0x61, 0x6b, 0x6f, 0x70,
0x61, 0x3b, 0x4e, 0x6f, 0x77, 0x65, 0x6d, 0x61, 0x70, 0x61, 0x3b, 0x4b, 0x65, 0x6b, 0x65, 0x6d, 0x61, 0x70, 0x61, 0x3b,
0x5d9, 0x5e0, 0x5d5, 0x5f3, 0x3b, 0x5e4, 0x5d1, 0x5e8, 0x5f3, 0x3b, 0x5de, 0x5e8, 0x5e5, 0x3b, 0x5d0, 0x5e4, 0x5e8, 0x5f3, 0x3b, 0x5de,
0x5d0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5e0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dc, 0x5d9, 0x3b, 0x5d0, 0x5d5, 0x5d2, 0x5f3, 0x3b, 0x5e1, 0x5e4,
0x5d8, 0x5f3, 0x3b, 0x5d0, 0x5d5, 0x5e7, 0x5f3, 0x3b, 0x5e0, 0x5d5, 0x5d1, 0x5f3, 0x3b, 0x5d3, 0x5e6, 0x5de, 0x5f3, 0x3b, 0x5d9, 0x5e0,
0x5d5, 0x5d0, 0x5e8, 0x3b, 0x5e4, 0x5d1, 0x5e8, 0x5d5, 0x5d0, 0x5e8, 0x3b, 0x5de, 0x5e8, 0x5e5, 0x3b, 0x5d0, 0x5e4, 0x5e8, 0x5d9, 0x5dc,
0x3b, 0x5de, 0x5d0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5e0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dc, 0x5d9, 0x3b, 0x5d0, 0x5d5, 0x5d2, 0x5d5, 0x5e1,
0x5d8, 0x3b, 0x5e1, 0x5e4, 0x5d8, 0x5de, 0x5d1, 0x5e8, 0x3b, 0x5d0, 0x5d5, 0x5e7, 0x5d8, 0x5d5, 0x5d1, 0x5e8, 0x3b, 0x5e0, 0x5d5, 0x5d1,
0x5de, 0x5d1, 0x5e8, 0x3b, 0x5d3, 0x5e6, 0x5de, 0x5d1, 0x5e8, 0x3b, 0x91c, 0x928, 0x970, 0x3b, 0x92b, 0x93c, 0x930, 0x970, 0x3b, 0x92e,
0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x948, 0x932, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c,
0x941, 0x932, 0x970, 0x3b, 0x905, 0x917, 0x970, 0x3b, 0x938, 0x93f, 0x924, 0x970, 0x3b, 0x905, 0x915, 0x94d, 0x924, 0x942, 0x970, 0x3b,
0x928, 0x935, 0x970, 0x3b, 0x926, 0x93f, 0x938, 0x970, 0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940, 0x3b, 0x92b, 0x93c, 0x930, 0x935, 0x930,
0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x948, 0x932, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942,
0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x924, 0x3b, 0x938, 0x93f, 0x924, 0x902, 0x92c, 0x930,
0x3b, 0x905, 0x915, 0x94d, 0x924, 0x942, 0x92c, 0x930, 0x3b, 0x928, 0x935, 0x902, 0x92c, 0x930, 0x3b, 0x926, 0x93f, 0x938, 0x902, 0x92c,
0x930, 0x3b, 0x91c, 0x3b, 0x92b, 0x93c, 0x3b, 0x92e, 0x93e, 0x3b, 0x905, 0x3b, 0x92e, 0x3b, 0x91c, 0x942, 0x3b, 0x91c, 0x941, 0x3b,
0x905, 0x3b, 0x938, 0x93f, 0x3b, 0x905, 0x3b, 0x928, 0x3b, 0x926, 0x93f, 0x3b, 0xd838, 0xdd06, 0xd838, 0xdd2c, 0x3b, 0xd838, 0xdd1b, 0xd838,
0xdd28, 0xd838, 0xdd31, 0xd838, 0xdd04, 0xd838, 0xdd24, 0xd838, 0xdd32, 0xd838, 0xdd28, 0x3b, 0xd838, 0xdd12, 0xd838, 0xdd2b, 0xd838, 0xdd30, 0xd838, 0xdd12,
0xd838, 0xdd2a, 0xd838, 0xdd31, 0x3b, 0xd838, 0xdd24, 0xd838, 0xdd28, 0xd838, 0xdd31, 0x3b, 0xd838, 0xdd00, 0xd838, 0xdd2a, 0xd838, 0xdd34, 0x3b, 0xd838,
0xdd1b, 0xd838, 0xdd24, 0xd838, 0xdd31, 0xd838, 0xdd1e, 0xd838, 0xdd24, 0xd838, 0xdd26, 0x3b, 0xd838, 0xdd14, 0xd838, 0xdd29, 0xd838, 0xdd34, 0xd838, 0xdd06,
0xd838, 0xdd28, 0xd838, 0xdd30, 0x3b, 0xd838, 0xdd15, 0xd838, 0xdd29, 0xd838, 0xdd32, 0xd838, 0xdd14, 0xd838, 0xdd04, 0xd838, 0xdd30, 0xd838, 0xdd24, 0x3b,
0xd838, 0xdd1b, 0xd838, 0xdd24, 0xd838, 0xdd31, 0xd838, 0xdd12, 0xd838, 0xdd24, 0xd838, 0xdd30, 0x3b, 0xd838, 0xdd2a, 0xd838, 0xdd31, 0xd838, 0xdd00, 0xd838,
0xdd24, 0xd838, 0xdd34, 0x3b, 0xd838, 0xdd1a, 0xd838, 0xdd26, 0xd838, 0xdd32, 0xd838, 0xdd24, 0xd838, 0xdd1a, 0xd838, 0xdd04, 0xd838, 0xdd30, 0xd838, 0xdd2b,
0x3b, 0xd838, 0xdd12, 0xd838, 0xdd29, 0xd838, 0xdd31, 0xd838, 0xdd14, 0xd838, 0xdd2c, 0xd838, 0xdd34, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66,
0x65, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0xe1, 0x72, 0x63, 0x2e, 0x3b, 0xe1, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0xe1, 0x6a, 0x2e,
0x3b, 0x6a, 0xfa, 0x6e, 0x2e, 0x3b, 0x6a, 0xfa, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x7a, 0x65, 0x70,
0x74, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61,
0x6e, 0x75, 0xe1, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0xe1, 0x72, 0x3b, 0x6d, 0xe1, 0x72, 0x63, 0x69, 0x75, 0x73,
0x3b, 0xe1, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x73, 0x3b, 0x6d, 0xe1, 0x6a, 0x75, 0x73, 0x3b, 0x6a, 0xfa, 0x6e, 0x69, 0x75,
0x73, 0x3b, 0x6a, 0xfa, 0x6c, 0x69, 0x75, 0x73, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x7a, 0x74, 0x75, 0x73, 0x3b, 0x73,
0x7a, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0xf3, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f,
0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b,
0x4d, 0x3b, 0xc1, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x7a, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44,
0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e,
0x3b, 0x6d, 0x61, 0xed, 0x3b, 0x6a, 0xfa, 0x6e, 0x2e, 0x3b, 0x6a, 0xfa, 0x6c, 0x2e, 0x3b, 0xe1, 0x67, 0xfa, 0x2e, 0x3b,
0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0xf3, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x73, 0x2e, 0x3b,
0x6a, 0x61, 0x6e, 0xfa, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0xfa, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b,
0x61, 0x70, 0x72, 0xed, 0x6c, 0x3b, 0x6d, 0x61, 0xed, 0x3b, 0x6a, 0xfa, 0x6e, 0xed, 0x3b, 0x6a, 0xfa, 0x6c, 0xed, 0x3b,
0xe1, 0x67, 0xfa, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0xf3,
0x62, 0x65, 0x72, 0x3b, 0x6e, 0xf3, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65,
0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0xc1, 0x3b, 0x53, 0x3b,
0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4a, 0x65, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x61, 0x3b, 0x45, 0x70,
0x72, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x75, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x1ecc, 0x67, 0x1ecd, 0x3b, 0x53, 0x65,
0x70, 0x3b, 0x1ecc, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x65, 0x6e, 0x1ee5, 0x77, 0x61,
0x72, 0x1ecb, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x1ee5, 0x77, 0x61, 0x72, 0x1ecb, 0x3b, 0x4d, 0x61, 0x61, 0x63, 0x68, 0x1ecb, 0x3b,
0x45, 0x70, 0x72, 0x65, 0x65, 0x6c, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x61,
0x1ecb, 0x3b, 0x1ecc, 0x67, 0x1ecd, 0x1ecd, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x1ecc, 0x6b,
0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61,
0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x1ecc, 0x3b, 0x53, 0x3b, 0x1ecc,
0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x75, 0x111, 0x69, 0x76, 0x3b, 0x6b, 0x75, 0x6f, 0x76, 0xe2, 0x3b, 0x6e, 0x6a, 0x75, 0x68,
0x10d, 0xe2, 0x3b, 0x63, 0x75, 0xe1, 0x14b, 0x75, 0x69, 0x3b, 0x76, 0x79, 0x65, 0x73, 0x69, 0x3b, 0x6b, 0x65, 0x73, 0x69,
0x3b, 0x73, 0x79, 0x65, 0x69, 0x6e, 0x69, 0x3b, 0x70, 0x6f, 0x72, 0x67, 0x65, 0x3b, 0x10d, 0x6f, 0x68, 0x10d, 0xe2, 0x3b,
0x72, 0x6f, 0x6f, 0x76, 0x76, 0xe2, 0x64, 0x3b, 0x73, 0x6b, 0x61, 0x6d, 0x6d, 0xe2, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x6c,
0xe2, 0x3b, 0x75, 0x111, 0x111, 0xe2, 0x69, 0x76, 0x65, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x6b, 0x75, 0x6f, 0x76, 0xe2,
0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x6e, 0x6a, 0x75, 0x68, 0x10d, 0xe2, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x63, 0x75,
0xe1, 0x14b, 0x75, 0x69, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x76, 0x79, 0x65, 0x73, 0x69, 0x6d, 0xe1, 0xe1, 0x6e, 0x75,
0x3b, 0x6b, 0x65, 0x73, 0x69, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x73, 0x79, 0x65, 0x69, 0x6e, 0x69, 0x6d, 0xe1, 0xe1,
0x6e, 0x75, 0x3b, 0x70, 0x6f, 0x72, 0x67, 0x65, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x10d, 0x6f, 0x68, 0x10d, 0xe2, 0x6d,
0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x72, 0x6f, 0x6f, 0x76, 0x76, 0xe2, 0x64, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x73, 0x6b,
0x61, 0x6d, 0x6d, 0xe2, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x6c, 0xe2, 0x6d, 0xe1, 0xe1, 0x6e,
0x75, 0x3b, 0x55, 0x3b, 0x4b, 0x3b, 0x4e, 0x4a, 0x3b, 0x43, 0x3b, 0x56, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x50, 0x3b, 0x10c,
0x3b, 0x52, 0x3b, 0x53, 0x3b, 0x4a, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41,
0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x75, 0x3b, 0x53,
0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61,
0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x72, 0x65, 0x74, 0x3b, 0x41, 0x70,
0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x67,
0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f,
0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65,
0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61,
0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x63,
0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x6f, 0x3b, 0x66,
0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x69, 0x6f, 0x3b, 0x61, 0x70, 0x72, 0x69,
0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x3b, 0x61,
0x75, 0x67, 0x75, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74,
0x6f, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62,
0x72, 0x65, 0x3b, 0x152d, 0x14d0, 0x14c4, 0x140a, 0x14d5, 0x3b, 0x1555, 0x155d, 0x1557, 0x140a, 0x14d5, 0x3b, 0x14ab, 0x1466, 0x14ef, 0x3b, 0x140a,
0x1403, 0x1449, 0x1433, 0x14d7, 0x3b, 0x14aa, 0x1403, 0x3b, 0x152b, 0x14c2, 0x3b, 0x152a, 0x14da, 0x1403, 0x3b, 0x140a, 0x1405, 0x14a1, 0x148d, 0x14ef,
0x3b, 0x14ef, 0x144e, 0x1431, 0x1546, 0x3b, 0x1406, 0x1466, 0x1451, 0x155d, 0x1559, 0x3b, 0x14c4, 0x1555, 0x1431, 0x1546, 0x3b, 0x144e, 0x14ef, 0x1431,
0x1546, 0x3b, 0x45, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x61, 0x62, 0x68, 0x3b, 0x4d, 0xe1, 0x72, 0x74, 0x61, 0x3b, 0x41, 0x69,
0x62, 0x3b, 0x42, 0x65, 0x61, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x74, 0x68, 0x3b, 0x49, 0xfa, 0x69, 0x6c, 0x3b, 0x4c, 0xfa,
0x6e, 0x3b, 0x4d, 0x46, 0xf3, 0x6d, 0x68, 0x3b, 0x44, 0x46, 0xf3, 0x6d, 0x68, 0x3b, 0x53, 0x61, 0x6d, 0x68, 0x3b, 0x4e,
0x6f, 0x6c, 0x6c, 0x3b, 0x45, 0x61, 0x6e, 0xe1, 0x69, 0x72, 0x3b, 0x46, 0x65, 0x61, 0x62, 0x68, 0x72, 0x61, 0x3b, 0x4d,
0xe1, 0x72, 0x74, 0x61, 0x3b, 0x41, 0x69, 0x62, 0x72, 0x65, 0xe1, 0x6e, 0x3b, 0x42, 0x65, 0x61, 0x6c, 0x74, 0x61, 0x69,
0x6e, 0x65, 0x3b, 0x4d, 0x65, 0x69, 0x74, 0x68, 0x65, 0x61, 0x6d, 0x68, 0x3b, 0x49, 0xfa, 0x69, 0x6c, 0x3b, 0x4c, 0xfa,
0x6e, 0x61, 0x73, 0x61, 0x3b, 0x4d, 0x65, 0xe1, 0x6e, 0x20, 0x46, 0xf3, 0x6d, 0x68, 0x61, 0x69, 0x72, 0x3b, 0x44, 0x65,
0x69, 0x72, 0x65, 0x61, 0x64, 0x68, 0x20, 0x46, 0xf3, 0x6d, 0x68, 0x61, 0x69, 0x72, 0x3b, 0x53, 0x61, 0x6d, 0x68, 0x61,
0x69, 0x6e, 0x3b, 0x4e, 0x6f, 0x6c, 0x6c, 0x61, 0x69, 0x67, 0x3b, 0x45, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x42,
0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x67, 0x65, 0x6e, 0x3b, 0x66,
0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x67, 0x3b, 0x67, 0x69, 0x75, 0x3b, 0x6c,
0x75, 0x67, 0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x3b, 0x6f, 0x74, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64,
0x69, 0x63, 0x3b, 0x67, 0x65, 0x6e, 0x6e, 0x61, 0x69, 0x6f, 0x3b, 0x66, 0x65, 0x62, 0x62, 0x72, 0x61, 0x69, 0x6f, 0x3b,
0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x65, 0x3b, 0x6d, 0x61, 0x67, 0x67, 0x69, 0x6f, 0x3b,
0x67, 0x69, 0x75, 0x67, 0x6e, 0x6f, 0x3b, 0x6c, 0x75, 0x67, 0x6c, 0x69, 0x6f, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f,
0x3b, 0x73, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x74, 0x74, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x6e,
0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x69, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x4a, 0x61, 0x6e,
0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e,
0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76,
0x3b, 0x44, 0x65, 0x73, 0x3b, 0x41, 0x331, 0x79, 0x72, 0x3b, 0x41, 0x331, 0x68, 0x77, 0x3b, 0x41, 0x331, 0x74, 0x61, 0x3b,
0x41, 0x331, 0x6e, 0x61, 0x3b, 0x41, 0x331, 0x70, 0x66, 0x3b, 0x41, 0x331, 0x6b, 0x69, 0x3b, 0x41, 0x331, 0x74, 0x79, 0x3b,
0x41, 0x331, 0x6e, 0x69, 0x3b, 0x41, 0x331, 0x6b, 0x75, 0x3b, 0x53, 0x77, 0x61, 0x3b, 0x53, 0x62, 0x79, 0x3b, 0x53, 0x62,
0x68, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x79, 0x72, 0x6e, 0x69, 0x67, 0x3b, 0x48, 0x79, 0x77, 0x61,
0x6e, 0x20, 0x41, 0x331, 0x68, 0x77, 0x61, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x74, 0x61, 0x74, 0x3b,
0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x6e, 0x61, 0x61, 0x69, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41,
0x331, 0x70, 0x66, 0x77, 0x6f, 0x6e, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x6b, 0x69, 0x74, 0x61, 0x74,
0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x74, 0x79, 0x69, 0x72, 0x69, 0x6e, 0x3b, 0x48, 0x79, 0x77, 0x61,
0x6e, 0x20, 0x41, 0x331, 0x6e, 0x69, 0x6e, 0x61, 0x69, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x6b, 0x75,
0x6d, 0x76, 0x69, 0x72, 0x69, 0x79, 0x69, 0x6e, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x53, 0x77, 0x61, 0x6b, 0x3b,
0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x53, 0x77, 0x61, 0x6b, 0x20, 0x42, 0x2019, 0x61, 0x331, 0x79, 0x72, 0x6e, 0x69, 0x67,
0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x53, 0x77, 0x61, 0x6b, 0x20, 0x42, 0x2019, 0x61, 0x331, 0x68, 0x77, 0x61, 0x3b,
0x53, 0x61, 0x3b, 0x46, 0x65, 0x3b, 0x4d, 0x61, 0x3b, 0x41, 0x62, 0x3b, 0x4d, 0x65, 0x3b, 0x53, 0x75, 0x3b, 0x53, 0xfa,
0x3b, 0x55, 0x74, 0x3b, 0x53, 0x65, 0x3b, 0x4f, 0x6b, 0x3b, 0x4e, 0x6f, 0x3b, 0x44, 0x65, 0x3b, 0x53, 0x61, 0x6e, 0x76,
0x69, 0x65, 0x3b, 0x46, 0xe9, 0x62, 0x69, 0x72, 0x69, 0x65, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x3b, 0x41, 0x62, 0x75, 0x72,
0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x53, 0x75, 0x65, 0x14b, 0x3b, 0x53, 0xfa, 0x75, 0x79, 0x65, 0x65, 0x3b, 0x55,
0x74, 0x3b, 0x53, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x3b,
0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x44, 0x69, 0x73, 0x61, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x53, 0x3b,
0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b,
0x44, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61,
0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x74,
0x75, 0x3b, 0x4e, 0x75, 0x76, 0x3b, 0x44, 0x69, 0x7a, 0x3b, 0x4a, 0x61, 0x6e, 0x65, 0x72, 0x75, 0x3b, 0x46, 0x65, 0x62,
0x72, 0x65, 0x72, 0x75, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x75, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69,
0x75, 0x3b, 0x4a, 0x75, 0x6e, 0x68, 0x75, 0x3b, 0x4a, 0x75, 0x6c, 0x68, 0x75, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x75,
0x3b, 0x53, 0x65, 0x74, 0x65, 0x6e, 0x62, 0x72, 0x75, 0x3b, 0x4f, 0x74, 0x75, 0x62, 0x72, 0x75, 0x3b, 0x4e, 0x75, 0x76,
0x65, 0x6e, 0x62, 0x72, 0x75, 0x3b, 0x44, 0x69, 0x7a, 0x65, 0x6e, 0x62, 0x72, 0x75, 0x3b, 0x59, 0x65, 0x6e, 0x3b, 0x46,
0x75, 0x72, 0x3b, 0x4d, 0x65, 0x263, 0x3b, 0x59, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59,
0x75, 0x6c, 0x3b, 0x194, 0x75, 0x63, 0x3b, 0x43, 0x74, 0x65, 0x3b, 0x54, 0x75, 0x62, 0x3b, 0x4e, 0x75, 0x6e, 0x3b, 0x44,
0x75, 0x1e7, 0x3b, 0x59, 0x65, 0x6e, 0x6e, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x46, 0x75, 0x1e5b, 0x61, 0x72, 0x3b, 0x4d, 0x65,
0x263, 0x72, 0x65, 0x73, 0x3b, 0x59, 0x65, 0x62, 0x72, 0x69, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x79, 0x75, 0x3b, 0x59, 0x75,
0x6e, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6c, 0x79, 0x75, 0x3b, 0x194, 0x75, 0x63, 0x74, 0x3b, 0x43, 0x74, 0x65, 0x6d, 0x62,
0x65, 0x1e5b, 0x3b, 0x54, 0x75, 0x62, 0x65, 0x1e5b, 0x3b, 0x4e, 0x75, 0x6e, 0x65, 0x6d, 0x62, 0x65, 0x1e5b, 0x3b, 0x44, 0x75,
0x1e7, 0x65, 0x6d, 0x62, 0x65, 0x1e5b, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x59,
0x3b, 0x194, 0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x31, 0x4b, 0x79, 0x2e, 0x3b, 0x32, 0x4b, 0x79, 0x2e,
0x3b, 0x33, 0x4b, 0x79, 0x2e, 0x3b, 0x34, 0x4b, 0x79, 0x2e, 0x3b, 0x35, 0x4b, 0x79, 0x2e, 0x3b, 0x36, 0x4b, 0x79, 0x2e,
0x3b, 0x37, 0x4b, 0x79, 0x2e, 0x3b, 0x38, 0x4b, 0x79, 0x2e, 0x3b, 0x39, 0x4b, 0x79, 0x2e, 0x3b, 0x31, 0x30, 0x4b, 0x79,
0x2e, 0x3b, 0x31, 0x31, 0x4b, 0x79, 0x2e, 0x3b, 0x31, 0x32, 0x4b, 0x79, 0x2e, 0x3b, 0x31, 0x2d, 0x4b, 0x79, 0x73, 0xe3,
0x3b, 0x32, 0x2d, 0x4b, 0x79, 0x73, 0xe3, 0x3b, 0x33, 0x2d, 0x4b, 0x79, 0x73, 0xe3, 0x3b, 0x34, 0x2d, 0x4b, 0x79, 0x73,
0xe3, 0x3b, 0x35, 0x2d, 0x4b, 0x79, 0x73, 0xe3, 0x3b, 0x36, 0x2d, 0x4b, 0x79, 0x73, 0xe3, 0x3b, 0x37, 0x2d, 0x4b, 0x79,
0x73, 0xe3, 0x3b, 0x38, 0x2d, 0x4b, 0x79, 0x73, 0xe3, 0x3b, 0x39, 0x2d, 0x4b, 0x79, 0x73, 0xe3, 0x3b, 0x31, 0x30, 0x2d,
0x4b, 0x79, 0x73, 0xe3, 0x3b, 0x31, 0x31, 0x2d, 0x4b, 0x79, 0x73, 0xe3, 0x3b, 0x31, 0x32, 0x2d, 0x4b, 0x79, 0x73, 0xe3,
0x3b, 0x31, 0x4b, 0x3b, 0x32, 0x4b, 0x3b, 0x33, 0x4b, 0x3b, 0x34, 0x4b, 0x3b, 0x35, 0x4b, 0x3b, 0x36, 0x4b, 0x3b, 0x37,
0x4b, 0x3b, 0x38, 0x4b, 0x3b, 0x39, 0x4b, 0x3b, 0x31, 0x30, 0x4b, 0x3b, 0x31, 0x31, 0x4b, 0x3b, 0x31, 0x32, 0x4b, 0x3b,
0x70, 0x61, 0x6d, 0x62, 0x61, 0x3b, 0x77, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x6d, 0x62, 0x69, 0x79, 0x254, 0x20, 0x6d, 0x25b,
0x6e, 0x64, 0x6f, 0x14b, 0x67, 0x254, 0x3b, 0x4e, 0x79, 0x254, 0x6c, 0x254, 0x6d, 0x62, 0x254, 0x14b, 0x67, 0x254, 0x3b, 0x4d,
0x254, 0x6e, 0x254, 0x20, 0x14b, 0x67, 0x62, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x4e, 0x79, 0x61, 0x14b, 0x67, 0x77, 0x25b, 0x20,
0x14b, 0x67, 0x62, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x6b, 0x75, 0x14b, 0x67, 0x77, 0x25b, 0x3b, 0x66, 0x25b, 0x3b, 0x6e, 0x6a,
0x61, 0x70, 0x69, 0x3b, 0x6e, 0x79, 0x75, 0x6b, 0x75, 0x6c, 0x3b, 0x4d, 0x31, 0x31, 0x3b, 0x253, 0x75, 0x6c, 0x253, 0x75,
0x73, 0x25b, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b,
0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x74,
0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x61, 0x72,
0x69, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x61, 0x72, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x69, 0x3b, 0x61, 0x70,
0x72, 0x69, 0x69, 0x6c, 0x69, 0x3b, 0x6d, 0x61, 0x61, 0x6a, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75,
0x75, 0x6c, 0x69, 0x3b, 0x61, 0x67, 0x67, 0x75, 0x73, 0x74, 0x69, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61,
0x72, 0x69, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x69, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72,
0x69, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x69, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x61, 0x72, 0x69,
0x70, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x61, 0x72, 0x69, 0x70, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x69, 0x70, 0x3b,
0x61, 0x70, 0x72, 0x69, 0x69, 0x6c, 0x69, 0x70, 0x3b, 0x6d, 0x61, 0x61, 0x6a, 0x69, 0x70, 0x3b, 0x6a, 0x75, 0x75, 0x6e,
0x69, 0x70, 0x3b, 0x6a, 0x75, 0x75, 0x6c, 0x69, 0x70, 0x3b, 0x61, 0x67, 0x67, 0x75, 0x73, 0x74, 0x69, 0x70, 0x3b, 0x73,
0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x69, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x69, 0x70,
0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x69, 0x70, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x61, 0x72,
0x69, 0x70, 0x3b, 0x4d, 0x75, 0x6c, 0x3b, 0x4e, 0x67, 0x61, 0x74, 0x3b, 0x54, 0x61, 0x61, 0x3b, 0x49, 0x77, 0x6f, 0x3b,
0x4d, 0x61, 0x6d, 0x3b, 0x50, 0x61, 0x61, 0x3b, 0x4e, 0x67, 0x65, 0x3b, 0x52, 0x6f, 0x6f, 0x3b, 0x42, 0x75, 0x72, 0x3b,
0x45, 0x70, 0x65, 0x3b, 0x4b, 0x70, 0x74, 0x3b, 0x4b, 0x70, 0x61, 0x3b, 0x4d, 0x75, 0x6c, 0x67, 0x75, 0x6c, 0x3b, 0x4e,
0x67, 0x2019, 0x61, 0x74, 0x79, 0x61, 0x61, 0x74, 0x6f, 0x3b, 0x4b, 0x69, 0x70, 0x74, 0x61, 0x61, 0x6d, 0x6f, 0x3b, 0x49,
0x77, 0x6f, 0x6f, 0x74, 0x6b, 0x75, 0x75, 0x74, 0x3b, 0x4d, 0x61, 0x6d, 0x75, 0x75, 0x74, 0x3b, 0x50, 0x61, 0x61, 0x67,
0x69, 0x3b, 0x4e, 0x67, 0x2019, 0x65, 0x69, 0x79, 0x65, 0x65, 0x74, 0x3b, 0x52, 0x6f, 0x6f, 0x70, 0x74, 0x75, 0x69, 0x3b,
0x42, 0x75, 0x72, 0x65, 0x65, 0x74, 0x3b, 0x45, 0x70, 0x65, 0x65, 0x73, 0x6f, 0x3b, 0x4b, 0x69, 0x70, 0x73, 0x75, 0x75,
0x6e, 0x64, 0x65, 0x20, 0x6e, 0x65, 0x20, 0x74, 0x61, 0x61, 0x69, 0x3b, 0x4b, 0x69, 0x70, 0x73, 0x75, 0x75, 0x6e, 0x64,
0x65, 0x20, 0x6e, 0x65, 0x62, 0x6f, 0x20, 0x61, 0x65, 0x6e, 0x67, 0x2019, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x49,
0x3b, 0x4d, 0x3b, 0x50, 0x3b, 0x4e, 0x3b, 0x52, 0x3b, 0x42, 0x3b, 0x45, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4d, 0x62, 0x65,
0x3b, 0x4b, 0x65, 0x6c, 0x3b, 0x4b, 0x74, 0x169, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x4b, 0x74, 0x6e, 0x3b, 0x54, 0x68, 0x61,
0x3b, 0x4d, 0x6f, 0x6f, 0x3b, 0x4e, 0x79, 0x61, 0x3b, 0x4b, 0x6e, 0x64, 0x3b, 0x128, 0x6b, 0x75, 0x3b, 0x128, 0x6b, 0x6d,
0x3b, 0x128, 0x6b, 0x6c, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x65, 0x3b, 0x4d, 0x77,
0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6c, 0x129, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b,
0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d,
0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77,
0x61, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x74, 0x68, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20,
0x6d, 0x75, 0x6f, 0x6e, 0x7a, 0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6e, 0x79, 0x61, 0x61, 0x6e,
0x79, 0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x77, 0x61,
0x69, 0x20, 0x77, 0x61, 0x20, 0x129, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x129,
0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x129, 0x6d, 0x77, 0x65, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61,
0x20, 0x129, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x69, 0x6c, 0x129, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b,
0x4b, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x128, 0x3b, 0x128, 0x3b, 0x128, 0x3b, 0xc9c, 0xca8,
0x3b, 0xcab, 0xcc6, 0xcac, 0xccd, 0xcb0, 0x3b, 0xcae, 0xcbe, 0xcb0, 0xccd, 0xc9a, 0xccd, 0x3b, 0xc8f, 0xcaa, 0xccd, 0xcb0, 0xcbf, 0x3b,
0xcae, 0xcc7, 0x3b, 0xc9c, 0xcc2, 0xca8, 0xccd, 0x3b, 0xc9c, 0xcc1, 0xcb2, 0xcc8, 0x3b, 0xc86, 0xc97, 0x3b, 0xcb8, 0xcc6, 0xcaa, 0xccd,
0xc9f, 0xcc6, 0xc82, 0x3b, 0xc85, 0xc95, 0xccd, 0xc9f, 0xccb, 0x3b, 0xca8, 0xcb5, 0xcc6, 0xc82, 0x3b, 0xca1, 0xcbf, 0xcb8, 0xcc6, 0xc82,
0x3b, 0xc9c, 0xca8, 0xcb5, 0xcb0, 0xcbf, 0x3b, 0xcab, 0xcc6, 0xcac, 0xccd, 0xcb0, 0xcb5, 0xcb0, 0xcbf, 0x3b, 0xcae, 0xcbe, 0xcb0, 0xccd,
0xc9a, 0xccd, 0x3b, 0xc8f, 0xcaa, 0xccd, 0xcb0, 0xcbf, 0xcb2, 0xccd, 0x3b, 0xcae, 0xcc7, 0x3b, 0xc9c, 0xcc2, 0xca8, 0xccd, 0x3b, 0xc9c,
0xcc1, 0xcb2, 0xcc8, 0x3b, 0xc86, 0xc97, 0xcb8, 0xccd, 0xc9f, 0xccd, 0x3b, 0xcb8, 0xcc6, 0xcaa, 0xccd, 0xc9f, 0xcc6, 0xc82, 0xcac, 0xcb0,
0xccd, 0x3b, 0xc85, 0xc95, 0xccd, 0xc9f, 0xccb, 0xcac, 0xcb0, 0xccd, 0x3b, 0xca8, 0xcb5, 0xcc6, 0xc82, 0xcac, 0xcb0, 0xccd, 0x3b, 0xca1,
0xcbf, 0xcb8, 0xcc6, 0xc82, 0xcac, 0xcb0, 0xccd, 0x3b, 0xc9c, 0x3b, 0xcab, 0xcc6, 0x3b, 0xcae, 0xcbe, 0x3b, 0xc8f, 0x3b, 0xcae, 0xcc7,
0x3b, 0xc9c, 0xcc2, 0x3b, 0xc9c, 0xcc1, 0x3b, 0xc86, 0x3b, 0xcb8, 0xcc6, 0x3b, 0xc85, 0x3b, 0xca8, 0x3b, 0xca1, 0xcbf, 0x3b, 0xc9c,
0xca8, 0xcb5, 0xcb0, 0xcbf, 0x3b, 0xcab, 0xcc6, 0xcac, 0xccd, 0xcb0, 0xcb5, 0xcb0, 0xcbf, 0x3b, 0xcae, 0xcbe, 0xcb0, 0xccd, 0xc9a, 0xccd,
0x3b, 0xc8f, 0xcaa, 0xccd, 0xcb0, 0xcbf, 0x3b, 0xcae, 0xcc7, 0x3b, 0xc9c, 0xcc2, 0xca8, 0xccd, 0x3b, 0xc9c, 0xcc1, 0xcb2, 0xcc8, 0x3b,
0xc86, 0xc97, 0xcb8, 0xccd, 0xc9f, 0xccd, 0x3b, 0xcb8, 0xcc6, 0xcaa, 0xccd, 0xc9f, 0xcc6, 0xc82, 0x3b, 0xc85, 0xc95, 0xccd, 0xc9f, 0xccb,
0x3b, 0xca8, 0xcb5, 0xcc6, 0xc82, 0x3b, 0xca1, 0xcbf, 0xcb8, 0xcc6, 0xc82, 0x3b, 0x62c, 0x646, 0x624, 0x631, 0x6cc, 0x3b, 0x641, 0x631,
0x624, 0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x655, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x626, 0x6cc, 0x3b,
0x62c, 0x648, 0x657, 0x646, 0x3b, 0x62c, 0x648, 0x657, 0x644, 0x627, 0x6cc, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x62a,
0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x657, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633,
0x645, 0x628, 0x631, 0x3b, 0x62c, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x627, 0x3b, 0x645, 0x3b, 0x62c, 0x3b, 0x62c, 0x3b, 0x627, 0x3b,
0x633, 0x3b, 0x633, 0x3b, 0x627, 0x3b, 0x646, 0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940, 0x3b, 0x92b, 0x93c, 0x930, 0x935, 0x930, 0x940,
0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x948, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x928,
0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x924, 0x3b, 0x938, 0x924, 0x941, 0x902, 0x92c, 0x930, 0x3b,
0x905, 0x915, 0x924, 0x941, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x928, 0x935, 0x942, 0x92e, 0x92c, 0x930, 0x3b, 0x926, 0x938, 0x942, 0x92e,
0x92c, 0x930, 0x3b, 0x91c, 0x3b, 0x92b, 0x93c, 0x3b, 0x92e, 0x3b, 0x905, 0x3b, 0x92e, 0x3b, 0x91c, 0x3b, 0x91c, 0x3b, 0x905, 0x3b,
0x938, 0x3b, 0x913, 0x3b, 0x928, 0x3b, 0x926, 0x3b, 0x49b, 0x430, 0x4a3, 0x2e, 0x3b, 0x430, 0x49b, 0x43f, 0x2e, 0x3b, 0x43d, 0x430,
0x443, 0x2e, 0x3b, 0x441, 0x4d9, 0x443, 0x2e, 0x3b, 0x43c, 0x430, 0x43c, 0x2e, 0x3b, 0x43c, 0x430, 0x443, 0x2e, 0x3b, 0x448, 0x456,
0x43b, 0x2e, 0x3b, 0x442, 0x430, 0x43c, 0x2e, 0x3b, 0x49b, 0x44b, 0x440, 0x2e, 0x3b, 0x49b, 0x430, 0x437, 0x2e, 0x3b, 0x49b, 0x430,
0x440, 0x2e, 0x3b, 0x436, 0x435, 0x43b, 0x2e, 0x3b, 0x49a, 0x430, 0x4a3, 0x442, 0x430, 0x440, 0x3b, 0x410, 0x49b, 0x43f, 0x430, 0x43d,
0x3b, 0x41d, 0x430, 0x443, 0x440, 0x44b, 0x437, 0x3b, 0x421, 0x4d9, 0x443, 0x456, 0x440, 0x3b, 0x41c, 0x430, 0x43c, 0x44b, 0x440, 0x3b,
0x41c, 0x430, 0x443, 0x441, 0x44b, 0x43c, 0x3b, 0x428, 0x456, 0x43b, 0x434, 0x435, 0x3b, 0x422, 0x430, 0x43c, 0x44b, 0x437, 0x3b, 0x49a,
0x44b, 0x440, 0x43a, 0x4af, 0x439, 0x435, 0x43a, 0x3b, 0x49a, 0x430, 0x437, 0x430, 0x43d, 0x3b, 0x49a, 0x430, 0x440, 0x430, 0x448, 0x430,
0x3b, 0x416, 0x435, 0x43b, 0x442, 0x43e, 0x49b, 0x441, 0x430, 0x43d, 0x3b, 0x49a, 0x3b, 0x410, 0x3b, 0x41d, 0x3b, 0x421, 0x3b, 0x41c,
0x3b, 0x41c, 0x3b, 0x428, 0x3b, 0x422, 0x3b, 0x49a, 0x3b, 0x49a, 0x3b, 0x49a, 0x3b, 0x416, 0x3b, 0x49b, 0x430, 0x4a3, 0x442, 0x430,
0x440, 0x3b, 0x430, 0x49b, 0x43f, 0x430, 0x43d, 0x3b, 0x43d, 0x430, 0x443, 0x440, 0x44b, 0x437, 0x3b, 0x441, 0x4d9, 0x443, 0x456, 0x440,
0x3b, 0x43c, 0x430, 0x43c, 0x44b, 0x440, 0x3b, 0x43c, 0x430, 0x443, 0x441, 0x44b, 0x43c, 0x3b, 0x448, 0x456, 0x43b, 0x434, 0x435, 0x3b,
0x442, 0x430, 0x43c, 0x44b, 0x437, 0x3b, 0x49b, 0x44b, 0x440, 0x43a, 0x4af, 0x439, 0x435, 0x43a, 0x3b, 0x49b, 0x430, 0x437, 0x430, 0x43d,
0x3b, 0x49b, 0x430, 0x440, 0x430, 0x448, 0x430, 0x3b, 0x436, 0x435, 0x43b, 0x442, 0x43e, 0x49b, 0x441, 0x430, 0x43d, 0x3b, 0x1798, 0x1780,
0x179a, 0x17b6, 0x3b, 0x1780, 0x17bb, 0x1798, 0x17d2, 0x1797, 0x17c8, 0x3b, 0x1798, 0x17b8, 0x1793, 0x17b6, 0x3b, 0x1798, 0x17c1, 0x179f, 0x17b6, 0x3b,
0x17a7, 0x179f, 0x1797, 0x17b6, 0x3b, 0x1798, 0x17b7, 0x1790, 0x17bb, 0x1793, 0x17b6, 0x3b, 0x1780, 0x1780, 0x17d2, 0x1780, 0x178a, 0x17b6, 0x3b, 0x179f,
0x17b8, 0x17a0, 0x17b6, 0x3b, 0x1780, 0x1789, 0x17d2, 0x1789, 0x17b6, 0x3b, 0x178f, 0x17bb, 0x179b, 0x17b6, 0x3b, 0x179c, 0x17b7, 0x1785, 0x17d2, 0x1786,
0x17b7, 0x1780, 0x17b6, 0x3b, 0x1792, 0x17d2, 0x1793, 0x17bc, 0x3b, 0x1798, 0x3b, 0x1780, 0x3b, 0x1798, 0x3b, 0x1798, 0x3b, 0x17a7, 0x3b, 0x1798,
0x3b, 0x1780, 0x3b, 0x179f, 0x3b, 0x1780, 0x3b, 0x178f, 0x3b, 0x179c, 0x3b, 0x1792, 0x3b, 0x4a, 0x45, 0x4e, 0x3b, 0x57, 0x4b, 0x52,
0x3b, 0x57, 0x47, 0x54, 0x3b, 0x57, 0x4b, 0x4e, 0x3b, 0x57, 0x54, 0x4e, 0x3b, 0x57, 0x54, 0x44, 0x3b, 0x57, 0x4d, 0x4a,
0x3b, 0x57, 0x4e, 0x4e, 0x3b, 0x57, 0x4b, 0x44, 0x3b, 0x57, 0x49, 0x4b, 0x3b, 0x57, 0x4d, 0x57, 0x3b, 0x44, 0x49, 0x54,
0x3b, 0x4e, 0x6a, 0x65, 0x6e, 0x75, 0x61, 0x72, 0x129, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b,
0x65, 0x72, 0x129, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b,
0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20,
0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x67,
0x61, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x169,
0x67, 0x77, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61,
0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77,
0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x169, 0x6d, 0x77, 0x65, 0x3b, 0x4e, 0x64, 0x69, 0x74,
0x68, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x47, 0x3b, 0x4d, 0x3b,
0x4b, 0x3b, 0x4b, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x44, 0x3b, 0x6d, 0x75, 0x74, 0x2e, 0x3b, 0x67, 0x61, 0x73, 0x2e, 0x3b,
0x77, 0x65, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x74, 0x2e, 0x3b, 0x67, 0x69, 0x63, 0x2e, 0x3b, 0x6b, 0x61, 0x6d, 0x2e, 0x3b,
0x6e, 0x79, 0x61, 0x2e, 0x3b, 0x6b, 0x61, 0x6e, 0x2e, 0x3b, 0x6e, 0x7a, 0x65, 0x2e, 0x3b, 0x75, 0x6b, 0x77, 0x2e, 0x3b,
0x75, 0x67, 0x75, 0x2e, 0x3b, 0x75, 0x6b, 0x75, 0x2e, 0x3b, 0x4d, 0x75, 0x74, 0x61, 0x72, 0x61, 0x6d, 0x61, 0x3b, 0x47,
0x61, 0x73, 0x68, 0x79, 0x61, 0x6e, 0x74, 0x61, 0x72, 0x65, 0x3b, 0x57, 0x65, 0x72, 0x75, 0x72, 0x77, 0x65, 0x3b, 0x4d,
0x61, 0x74, 0x61, 0x3b, 0x47, 0x69, 0x63, 0x75, 0x72, 0x61, 0x73, 0x69, 0x3b, 0x4b, 0x61, 0x6d, 0x65, 0x6e, 0x61, 0x3b,
0x4e, 0x79, 0x61, 0x6b, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x4b, 0x61, 0x6e, 0x61, 0x6d, 0x61, 0x3b, 0x4e, 0x7a, 0x65, 0x6c,
0x69, 0x3b, 0x55, 0x6b, 0x77, 0x61, 0x6b, 0x69, 0x72, 0x61, 0x3b, 0x55, 0x67, 0x75, 0x73, 0x68, 0x79, 0x69, 0x6e, 0x67,
0x6f, 0x3b, 0x55, 0x6b, 0x75, 0x62, 0x6f, 0x7a, 0x61, 0x3b, 0x91c, 0x93e, 0x928, 0x947, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930,
0x941, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x90f, 0x92a, 0x94d, 0x930, 0x940, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x928,
0x3b, 0x91c, 0x941, 0x932, 0x3b, 0x911, 0x917, 0x3b, 0x938, 0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x3b, 0x911, 0x915, 0x94d, 0x91f, 0x94b,
0x3b, 0x928, 0x94b, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x3b, 0x91c, 0x93e, 0x928, 0x947, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92b, 0x947,
0x92c, 0x94d, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x90f, 0x92a, 0x94d, 0x930, 0x940,
0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x92f, 0x3b, 0x911, 0x917, 0x938, 0x94d, 0x91f, 0x3b,
0x938, 0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x911, 0x915, 0x94d, 0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x935,
0x94d, 0x939, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x31, 0xc6d4, 0x3b, 0x32, 0xc6d4,
0x3b, 0x33, 0xc6d4, 0x3b, 0x34, 0xc6d4, 0x3b, 0x35, 0xc6d4, 0x3b, 0x36, 0xc6d4, 0x3b, 0x37, 0xc6d4, 0x3b, 0x38, 0xc6d4, 0x3b, 0x39,
0xc6d4, 0x3b, 0x31, 0x30, 0xc6d4, 0x3b, 0x31, 0x31, 0xc6d4, 0x3b, 0x31, 0x32, 0xc6d4, 0x3b, 0x17d, 0x61, 0x6e, 0x3b, 0x46, 0x65,
0x65, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x77, 0x69, 0x3b, 0x4d, 0x65, 0x3b, 0x17d, 0x75, 0x77, 0x3b, 0x17d, 0x75, 0x79,
0x3b, 0x55, 0x74, 0x3b, 0x53, 0x65, 0x6b, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x6f, 0x3b, 0x44, 0x65, 0x65, 0x3b,
0x17d, 0x61, 0x6e, 0x77, 0x69, 0x79, 0x65, 0x3b, 0x46, 0x65, 0x65, 0x77, 0x69, 0x72, 0x69, 0x79, 0x65, 0x3b, 0x4d, 0x61,
0x72, 0x73, 0x69, 0x3b, 0x41, 0x77, 0x69, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x3b, 0x17d, 0x75, 0x77, 0x65, 0x14b, 0x3b,
0x17d, 0x75, 0x79, 0x79, 0x65, 0x3b, 0x55, 0x74, 0x3b, 0x53, 0x65, 0x6b, 0x74, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x3b, 0x4f,
0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x75, 0x72, 0x3b, 0x4e, 0x6f, 0x6f, 0x77, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x3b, 0x44, 0x65,
0x65, 0x73, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x3b, 0x17d, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x17d, 0x3b,
0x17d, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x72, 0xea, 0x62, 0x3b, 0x72, 0x65, 0x15f, 0x3b,
0x61, 0x64, 0x61, 0x3b, 0x61, 0x76, 0x72, 0x3b, 0x67, 0x75, 0x6c, 0x3b, 0x70, 0xfb, 0x15f, 0x3b, 0x74, 0xee, 0x72, 0x3b,
0x67, 0x65, 0x6c, 0x3b, 0x72, 0x65, 0x7a, 0x3b, 0x6b, 0x65, 0x77, 0x3b, 0x73, 0x65, 0x72, 0x3b, 0x62, 0x65, 0x72, 0x3b,
0x72, 0xea, 0x62, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x3b, 0x72, 0x65, 0x15f, 0x65, 0x6d, 0xee, 0x3b, 0x61, 0x64, 0x61, 0x72,
0x3b, 0x61, 0x76, 0x72, 0xea, 0x6c, 0x3b, 0x67, 0x75, 0x6c, 0x61, 0x6e, 0x3b, 0x70, 0xfb, 0x15f, 0x70, 0x65, 0x72, 0x3b,
0x74, 0xee, 0x72, 0x6d, 0x65, 0x68, 0x3b, 0x67, 0x65, 0x6c, 0x61, 0x77, 0xea, 0x6a, 0x3b, 0x72, 0x65, 0x7a, 0x62, 0x65,
0x72, 0x3b, 0x6b, 0x65, 0x77, 0xe7, 0xea, 0x72, 0x3b, 0x73, 0x65, 0x72, 0x6d, 0x61, 0x77, 0x65, 0x7a, 0x3b, 0x62, 0x65,
0x72, 0x66, 0x61, 0x6e, 0x62, 0x61, 0x72, 0x3b, 0x52, 0x3b, 0x52, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x47, 0x3b, 0x50, 0x3b,
0x54, 0x3b, 0x47, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x42, 0x3b, 0x72, 0xea, 0x62, 0x65, 0x6e, 0x64, 0x61, 0x6e,
0xea, 0x3b, 0x72, 0x65, 0x15f, 0x65, 0x6d, 0x69, 0x79, 0xea, 0x3b, 0x61, 0x64, 0x61, 0x72, 0xea, 0x3b, 0x61, 0x76, 0x72,
0xea, 0x6c, 0xea, 0x3b, 0x67, 0x75, 0x6c, 0x61, 0x6e, 0xea, 0x3b, 0x70, 0xfb, 0x15f, 0x70, 0x65, 0x72, 0xea, 0x3b, 0x74,
0xee, 0x72, 0x6d, 0x65, 0x68, 0xea, 0x3b, 0x67, 0x65, 0x6c, 0x61, 0x77, 0xea, 0x6a, 0xea, 0x3b, 0x72, 0x65, 0x7a, 0x62,
0x65, 0x72, 0xea, 0x3b, 0x6b, 0x65, 0x77, 0xe7, 0xea, 0x72, 0xea, 0x3b, 0x73, 0x65, 0x72, 0x6d, 0x61, 0x77, 0x65, 0x7a,
0xea, 0x3b, 0x62, 0x65, 0x72, 0x66, 0x61, 0x6e, 0x62, 0x61, 0x72, 0xea, 0x3b, 0x6e, 0x67, 0x31, 0x3b, 0x6e, 0x67, 0x32,
0x3b, 0x6e, 0x67, 0x33, 0x3b, 0x6e, 0x67, 0x34, 0x3b, 0x6e, 0x67, 0x35, 0x3b, 0x6e, 0x67, 0x36, 0x3b, 0x6e, 0x67, 0x37,
0x3b, 0x6e, 0x67, 0x38, 0x3b, 0x6e, 0x67, 0x39, 0x3b, 0x6e, 0x67, 0x31, 0x30, 0x3b, 0x6e, 0x67, 0x31, 0x31, 0x3b, 0x6b,
0x72, 0x69, 0x73, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x6d, 0x61, 0x74, 0xe1, 0x68, 0x72, 0x61, 0x3b, 0x6e, 0x67,
0x77, 0x25b, 0x6e, 0x20, 0x144, 0x6d, 0x62, 0x61, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x6c, 0x61, 0x6c, 0x3b,
0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x74, 0x61, 0x6e,
0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x74, 0x75, 0xf3, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x68, 0x25b,
0x6d, 0x62, 0x75, 0x25b, 0x72, 0xed, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x6c, 0x254, 0x6d, 0x62, 0x69, 0x3b, 0x6e,
0x67, 0x77, 0x25b, 0x6e, 0x20, 0x72, 0x25b, 0x62, 0x76, 0x75, 0xe2, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x77, 0x75,
0x6d, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x77, 0x75, 0x6d, 0x20, 0x6e, 0x61, 0x76, 0x1d4, 0x72, 0x3b, 0x6b, 0x72,
0xed, 0x73, 0x69, 0x6d, 0x69, 0x6e, 0x3b, 0x42f, 0x43d, 0x432, 0x3b, 0x424, 0x435, 0x432, 0x3b, 0x41c, 0x430, 0x440, 0x3b, 0x410,
0x43f, 0x440, 0x3b, 0x41c, 0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x3b, 0x418, 0x44e, 0x43b, 0x3b, 0x410, 0x432, 0x433, 0x3b, 0x421,
0x435, 0x43d, 0x3b, 0x41e, 0x43a, 0x442, 0x3b, 0x41d, 0x43e, 0x44f, 0x3b, 0x414, 0x435, 0x43a, 0x3b, 0x42f, 0x43d, 0x432, 0x430, 0x440,
0x44c, 0x3b, 0x424, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44c, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x3b, 0x410, 0x43f, 0x440, 0x435, 0x43b,
0x44c, 0x3b, 0x41c, 0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x44c, 0x3b, 0x418, 0x44e, 0x43b, 0x44c, 0x3b, 0x410, 0x432, 0x433, 0x443,
0x441, 0x442, 0x3b, 0x421, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x41e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b,
0x41d, 0x43e, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x414, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44c, 0x3b, 0x44f, 0x43d, 0x432, 0x2e, 0x3b,
0x444, 0x435, 0x432, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x2e, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438,
0x44e, 0x43d, 0x2e, 0x3b, 0x438, 0x44e, 0x43b, 0x2e, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43d, 0x2e, 0x3b, 0x43e,
0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x44f, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b, 0x57, 0x69, 0xf3, 0x74, 0x68, 0x65,
0x21f, 0x69, 0x6b, 0x61, 0x20, 0x57, 0xed, 0x3b, 0x54, 0x68, 0x69, 0x79, 0xf3, 0x21f, 0x65, 0x79, 0x75, 0x14b, 0x6b, 0x61,
0x20, 0x57, 0xed, 0x3b, 0x49, 0x161, 0x74, 0xe1, 0x77, 0x69, 0x10d, 0x68, 0x61, 0x79, 0x61, 0x7a, 0x61, 0x14b, 0x20, 0x57,
0xed, 0x3b, 0x50, 0x21f, 0x65, 0x17e, 0xed, 0x74, 0x21f, 0x6f, 0x20, 0x57, 0xed, 0x3b, 0x10c, 0x68, 0x61, 0x14b, 0x77, 0xe1,
0x70, 0x65, 0x74, 0x21f, 0x6f, 0x20, 0x57, 0xed, 0x3b, 0x57, 0xed, 0x70, 0x61, 0x7a, 0x75, 0x6b, 0x21f, 0x61, 0x2d, 0x77,
0x61, 0x161, 0x74, 0xe9, 0x20, 0x57, 0xed, 0x3b, 0x10c, 0x68, 0x61, 0x14b, 0x70, 0x21f, 0xe1, 0x73, 0x61, 0x70, 0x61, 0x20,
0x57, 0xed, 0x3b, 0x57, 0x61, 0x73, 0xfa, 0x74, 0x21f, 0x75, 0x14b, 0x20, 0x57, 0xed, 0x3b, 0x10c, 0x68, 0x61, 0x14b, 0x77,
0xe1, 0x70, 0x65, 0x1e7, 0x69, 0x20, 0x57, 0xed, 0x3b, 0x10c, 0x68, 0x61, 0x14b, 0x77, 0xe1, 0x70, 0x65, 0x2d, 0x6b, 0x61,
0x73, 0x6e, 0xe1, 0x20, 0x57, 0xed, 0x3b, 0x57, 0x61, 0x6e, 0xed, 0x79, 0x65, 0x74, 0x75, 0x20, 0x57, 0xed, 0x3b, 0x54,
0x21f, 0x61, 0x68, 0xe9, 0x6b, 0x61, 0x70, 0x161, 0x75, 0x14b, 0x20, 0x57, 0xed, 0x3b, 0x46, 0xfa, 0x6e, 0x67, 0x61, 0x74,
0x268, 0x3b, 0x4e, 0x61, 0x61, 0x6e, 0x268, 0x3b, 0x4b, 0x65, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x49, 0x6b, 0xfa, 0x6d, 0x69,
0x3b, 0x49, 0x6e, 0x79, 0x61, 0x6d, 0x62, 0x61, 0x6c, 0x61, 0x3b, 0x49, 0x64, 0x77, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x4d,
0x289, 0x289, 0x6e, 0x63, 0x68, 0x268, 0x3b, 0x56, 0x268, 0x268, 0x72, 0x268, 0x3b, 0x53, 0x61, 0x61, 0x74, 0x289, 0x3b, 0x49,
0x6e, 0x79, 0x69, 0x3b, 0x53, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x53, 0x61, 0x73, 0x61, 0x74, 0x289, 0x3b, 0x4b, 0x289, 0x66,
0xfa, 0x6e, 0x67, 0x61, 0x74, 0x268, 0x3b, 0x4b, 0x289, 0x6e, 0x61, 0x61, 0x6e, 0x268, 0x3b, 0x4b, 0x289, 0x6b, 0x65, 0x65,
0x6e, 0x64, 0x61, 0x3b, 0x4b, 0x77, 0x69, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4b, 0x77, 0x69, 0x69, 0x6e, 0x79, 0x61,
0x6d, 0x62, 0xe1, 0x6c, 0x61, 0x3b, 0x4b, 0x77, 0x69, 0x69, 0x64, 0x77, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x4b, 0x289, 0x6d,
0x289, 0x289, 0x6e, 0x63, 0x68, 0x268, 0x3b, 0x4b, 0x289, 0x76, 0x268, 0x268, 0x72, 0x268, 0x3b, 0x4b, 0x289, 0x73, 0x61, 0x61,
0x74, 0x289, 0x3b, 0x4b, 0x77, 0x69, 0x69, 0x6e, 0x79, 0x69, 0x3b, 0x4b, 0x289, 0x73, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x4b,
0x289, 0x73, 0x61, 0x73, 0x61, 0x74, 0x289, 0x3b, 0x46, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b,
0x4d, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0xea1, 0x2e, 0xe81, 0x2e, 0x3b, 0xe81, 0x2e, 0xe9e,
0x2e, 0x3b, 0xea1, 0x2e, 0xe99, 0x2e, 0x3b, 0xea1, 0x2e, 0xeaa, 0x2e, 0x3b, 0xe9e, 0x2e, 0xe9e, 0x2e, 0x3b, 0xea1, 0xeb4, 0x2e,
0xe96, 0x2e, 0x3b, 0xe81, 0x2e, 0xea5, 0x2e, 0x3b, 0xeaa, 0x2e, 0xeab, 0x2e, 0x3b, 0xe81, 0x2e, 0xe8d, 0x2e, 0x3b, 0xe95, 0x2e,
0xea5, 0x2e, 0x3b, 0xe9e, 0x2e, 0xe88, 0x2e, 0x3b, 0xe97, 0x2e, 0xea7, 0x2e, 0x3b, 0xea1, 0xeb1, 0xe87, 0xe81, 0xead, 0xe99, 0x3b,
0xe81, 0xeb8, 0xea1, 0xe9e, 0xeb2, 0x3b, 0xea1, 0xeb5, 0xe99, 0xeb2, 0x3b, 0xec0, 0xea1, 0xeaa, 0xeb2, 0x3b, 0xe9e, 0xeb6, 0xe94, 0xeaa,
0xeb0, 0xe9e, 0xeb2, 0x3b, 0xea1, 0xeb4, 0xe96, 0xeb8, 0xe99, 0xeb2, 0x3b, 0xe81, 0xecd, 0xea5, 0xeb0, 0xe81, 0xebb, 0xe94, 0x3b, 0xeaa,
0xeb4, 0xe87, 0xeab, 0xeb2, 0x3b, 0xe81, 0xeb1, 0xe99, 0xe8d, 0xeb2, 0x3b, 0xe95, 0xeb8, 0xea5, 0xeb2, 0x3b, 0xe9e, 0xeb0, 0xe88, 0xeb4,
0xe81, 0x3b, 0xe97, 0xeb1, 0xe99, 0xea7, 0xeb2, 0x3b, 0x49, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b,
0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x49, 0x75, 0x6e, 0x3b, 0x49, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b,
0x53, 0x65, 0x70, 0x3b, 0x4f, 0x63, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x49, 0x61, 0x6e, 0x75,
0x61, 0x72, 0x69, 0x75, 0x73, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x75, 0x73, 0x3b, 0x4d, 0x61, 0x72,
0x74, 0x69, 0x75, 0x73, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x73, 0x3b, 0x4d, 0x61, 0x69, 0x75, 0x73, 0x3b, 0x49,
0x75, 0x6e, 0x69, 0x75, 0x73, 0x3b, 0x49, 0x75, 0x6c, 0x69, 0x75, 0x73, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75,
0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b,
0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x49, 0x61,
0x6e, 0x75, 0x61, 0x72, 0x69, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x69, 0x3b, 0x4d, 0x61, 0x72,
0x74, 0x69, 0x69, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x73, 0x3b, 0x4d, 0x61, 0x69, 0x69, 0x3b, 0x49, 0x75, 0x6e,
0x69, 0x69, 0x3b, 0x49, 0x75, 0x6c, 0x69, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70,
0x74, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x4f, 0x63, 0x74, 0x6f, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x4e, 0x6f, 0x76,
0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x6a, 0x61, 0x6e,
0x76, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b,
0x6d, 0x61, 0x69, 0x6a, 0x73, 0x3b, 0x6a, 0x16b, 0x6e, 0x2e, 0x3b, 0x6a, 0x16b, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e,
0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63,
0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x101, 0x72, 0x69, 0x73, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x101, 0x72, 0x69, 0x73,
0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x12b, 0x6c, 0x69, 0x73, 0x3b, 0x6d, 0x61, 0x69, 0x6a, 0x73,
0x3b, 0x6a, 0x16b, 0x6e, 0x69, 0x6a, 0x73, 0x3b, 0x6a, 0x16b, 0x6c, 0x69, 0x6a, 0x73, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73,
0x74, 0x73, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x72,
0x69, 0x73, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72,
0x69, 0x73, 0x3b, 0x7a, 0x65, 0x6e, 0x2e, 0x3b, 0x66, 0x72, 0x65, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x72,
0x76, 0x2e, 0x3b, 0x6d, 0x61, 0x7a, 0x2e, 0x3b, 0x7a, 0x75, 0x67, 0x2e, 0x3b, 0x6c, 0x75, 0x67, 0x2e, 0x3b, 0x61, 0x67,
0x6f, 0x2e, 0x3b, 0x73, 0x65, 0x74, 0x2e, 0x3b, 0x6f, 0x74, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65,
0x78, 0x2e, 0x3b, 0x7a, 0x65, 0x6e, 0xe2, 0x3b, 0x66, 0x72, 0x65, 0x76, 0xe2, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x6f, 0x3b,
0x61, 0x72, 0x76, 0xee, 0x3b, 0x6d, 0x61, 0x7a, 0x7a, 0x6f, 0x3b, 0x7a, 0x75, 0x67, 0x6e, 0x6f, 0x3b, 0x6c, 0x75, 0x67,
0x67, 0x69, 0x6f, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65,
0x3b, 0x6f, 0x74, 0x74, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65,
0x78, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x5a, 0x4e, 0x3b, 0x46, 0x52, 0x3b, 0x4d, 0x52, 0x3b, 0x41, 0x52, 0x3b, 0x4d,
0x5a, 0x3b, 0x5a, 0x47, 0x3b, 0x4c, 0x47, 0x3b, 0x41, 0x47, 0x3b, 0x53, 0x54, 0x3b, 0x4f, 0x54, 0x3b, 0x4e, 0x56, 0x3b,
0x44, 0x58, 0x3b, 0x64, 0x65, 0x20, 0x7a, 0x65, 0x6e, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x66, 0x72, 0x65, 0x2e, 0x3b, 0x64,
0x65, 0x20, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x64, 0x2019, 0x61, 0x72, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x7a,
0x2e, 0x3b, 0x64, 0x65, 0x20, 0x7a, 0x75, 0x67, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x6c, 0x75, 0x67, 0x2e, 0x3b, 0x64, 0x2019,
0x61, 0x67, 0x6f, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x73, 0x65, 0x74, 0x2e, 0x3b, 0x64, 0x2019, 0x6f, 0x74, 0x74, 0x2e, 0x3b,
0x64, 0x65, 0x20, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x64, 0x65, 0x78, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x7a,
0x65, 0x6e, 0xe2, 0x3b, 0x64, 0x65, 0x20, 0x66, 0x72, 0x65, 0x76, 0xe2, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x73,
0x6f, 0x3b, 0x64, 0x2019, 0x61, 0x72, 0x76, 0xee, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x7a, 0x7a, 0x6f, 0x3b, 0x64, 0x65,
0x20, 0x7a, 0x75, 0x67, 0x6e, 0x6f, 0x3b, 0x64, 0x65, 0x20, 0x6c, 0x75, 0x67, 0x67, 0x69, 0x6f, 0x3b, 0x64, 0x2019, 0x61,
0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x64, 0x65, 0x20, 0x73, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64,
0x2019, 0x6f, 0x74, 0x74, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x20, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65,
0x3b, 0x64, 0x65, 0x20, 0x64, 0x65, 0x78, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x79, 0x61, 0x6e, 0x3b, 0x66, 0x62, 0x6c,
0x3b, 0x6d, 0x73, 0x69, 0x3b, 0x61, 0x70, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x79, 0x75, 0x6e, 0x3b, 0x79, 0x75, 0x6c,
0x3b, 0x61, 0x67, 0x74, 0x3b, 0x73, 0x74, 0x62, 0x3b, 0x254, 0x74, 0x62, 0x3b, 0x6e, 0x76, 0x62, 0x3b, 0x64, 0x73, 0x62,
0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x79, 0x61, 0x6d, 0x62, 0x6f, 0x3b, 0x73, 0xe1, 0x6e, 0x7a,
0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x62, 0x61, 0x6c, 0xe9, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61,
0x20, 0x6d, 0xed, 0x73, 0xe1, 0x74, 0x6f, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x6e,
0x65, 0x69, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x74, 0xe1, 0x6e, 0x6f, 0x3b, 0x73,
0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0x6f, 0x74, 0xf3, 0x62, 0xe1, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1,
0x20, 0x79, 0x61, 0x20, 0x6e, 0x73, 0x61, 0x6d, 0x62, 0x6f, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20,
0x6d, 0x77, 0x61, 0x6d, 0x62, 0x65, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6c, 0x69, 0x62, 0x77,
0x61, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x7a, 0xf3, 0x6d, 0x69, 0x3b, 0x73, 0xe1, 0x6e, 0x7a,
0xe1, 0x20, 0x79, 0x61, 0x20, 0x7a, 0xf3, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x254, 0x30c, 0x6b, 0x254, 0x301, 0x3b,
0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x7a, 0xf3, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0xed, 0x62,
0x61, 0x6c, 0xe9, 0x3b, 0x79, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x79, 0x3b, 0x79, 0x3b, 0x61, 0x3b,
0x73, 0x3b, 0x254, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x73, 0x61, 0x75, 0x73, 0x2e, 0x3b, 0x76, 0x61, 0x73, 0x2e, 0x3b, 0x6b,
0x6f, 0x76, 0x2e, 0x3b, 0x62, 0x61, 0x6c, 0x2e, 0x3b, 0x67, 0x65, 0x67, 0x2e, 0x3b, 0x62, 0x69, 0x72, 0x17e, 0x2e, 0x3b,
0x6c, 0x69, 0x65, 0x70, 0x2e, 0x3b, 0x72, 0x75, 0x67, 0x70, 0x2e, 0x3b, 0x72, 0x75, 0x67, 0x73, 0x2e, 0x3b, 0x73, 0x70,
0x61, 0x6c, 0x2e, 0x3b, 0x6c, 0x61, 0x70, 0x6b, 0x72, 0x2e, 0x3b, 0x67, 0x72, 0x75, 0x6f, 0x64, 0x2e, 0x3b, 0x73, 0x61,
0x75, 0x73, 0x69, 0x73, 0x3b, 0x76, 0x61, 0x73, 0x61, 0x72, 0x69, 0x73, 0x3b, 0x6b, 0x6f, 0x76, 0x61, 0x73, 0x3b, 0x62,
0x61, 0x6c, 0x61, 0x6e, 0x64, 0x69, 0x73, 0x3b, 0x67, 0x65, 0x67, 0x75, 0x17e, 0x117, 0x3b, 0x62, 0x69, 0x72, 0x17e, 0x65,
0x6c, 0x69, 0x73, 0x3b, 0x6c, 0x69, 0x65, 0x70, 0x61, 0x3b, 0x72, 0x75, 0x67, 0x70, 0x6a, 0x16b, 0x74, 0x69, 0x73, 0x3b,
0x72, 0x75, 0x67, 0x73, 0x117, 0x6a, 0x69, 0x73, 0x3b, 0x73, 0x70, 0x61, 0x6c, 0x69, 0x73, 0x3b, 0x6c, 0x61, 0x70, 0x6b,
0x72, 0x69, 0x74, 0x69, 0x73, 0x3b, 0x67, 0x72, 0x75, 0x6f, 0x64, 0x69, 0x73, 0x3b, 0x53, 0x3b, 0x56, 0x3b, 0x4b, 0x3b,
0x42, 0x3b, 0x47, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x52, 0x3b, 0x52, 0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x47, 0x3b, 0x73, 0x61,
0x75, 0x73, 0x69, 0x6f, 0x3b, 0x76, 0x61, 0x73, 0x61, 0x72, 0x69, 0x6f, 0x3b, 0x6b, 0x6f, 0x76, 0x6f, 0x3b, 0x62, 0x61,
0x6c, 0x61, 0x6e, 0x64, 0x17e, 0x69, 0x6f, 0x3b, 0x67, 0x65, 0x67, 0x75, 0x17e, 0x117, 0x73, 0x3b, 0x62, 0x69, 0x72, 0x17e,
0x65, 0x6c, 0x69, 0x6f, 0x3b, 0x6c, 0x69, 0x65, 0x70, 0x6f, 0x73, 0x3b, 0x72, 0x75, 0x67, 0x70, 0x6a, 0x16b, 0x10d, 0x69,
0x6f, 0x3b, 0x72, 0x75, 0x67, 0x73, 0x117, 0x6a, 0x6f, 0x3b, 0x73, 0x70, 0x61, 0x6c, 0x69, 0x6f, 0x3b, 0x6c, 0x61, 0x70,
0x6b, 0x72, 0x69, 0x10d, 0x69, 0x6f, 0x3b, 0x67, 0x72, 0x75, 0x6f, 0x64, 0x17e, 0x69, 0x6f, 0x3b, 0x4a, 0x61, 0x6e, 0x2e,
0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x69, 0x3b,
0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x2e, 0x3b, 0x53, 0x65, 0x70, 0x2e, 0x3b,
0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x65, 0x7a, 0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61,
0x61, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x61, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72,
0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67,
0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x76, 0x65,
0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x11b, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x6a, 0x3b,
0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x77, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b,
0x6e, 0x6f, 0x77, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75,
0x61, 0x72, 0x3b, 0x6d, 0x11b, 0x72, 0x63, 0x3b, 0x61, 0x70, 0x72, 0x79, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75,
0x6e, 0x69, 0x6a, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6a, 0x3b, 0x61, 0x77, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70,
0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x77, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65,
0x62, 0x2e, 0x3b, 0x6d, 0x11b, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x6a, 0x2e, 0x3b, 0x6a, 0x75,
0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x77, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b,
0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x77, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x61,
0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x61, 0x3b, 0x6d, 0x11b, 0x72, 0x63, 0x61, 0x3b, 0x61, 0x70, 0x72, 0x79,
0x6c, 0x61, 0x3b, 0x6d, 0x61, 0x6a, 0x61, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6a, 0x61, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6a,
0x61, 0x3b, 0x61, 0x77, 0x67, 0x75, 0x73, 0x74, 0x61, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b,
0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x72, 0x61, 0x3b, 0x6e, 0x6f, 0x77, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x64, 0x65, 0x63,
0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x43, 0x69, 0x6f, 0x3b, 0x4c, 0x75, 0x69, 0x3b, 0x4c, 0x75, 0x73, 0x3b, 0x4d, 0x75,
0x75, 0x3b, 0x4c, 0x75, 0x6d, 0x3b, 0x4c, 0x75, 0x66, 0x3b, 0x4b, 0x61, 0x62, 0x3b, 0x4c, 0x75, 0x73, 0x68, 0x3b, 0x4c,
0x75, 0x74, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x43, 0x69, 0x73, 0x3b, 0x43, 0x69, 0x6f, 0x6e, 0x67,
0x6f, 0x3b, 0x4c, 0xf9, 0x69, 0x73, 0x68, 0x69, 0x3b, 0x4c, 0x75, 0x73, 0xf2, 0x6c, 0x6f, 0x3b, 0x4d, 0xf9, 0x75, 0x79,
0xe0, 0x3b, 0x4c, 0x75, 0x6d, 0xf9, 0x6e, 0x67, 0xf9, 0x6c, 0xf9, 0x3b, 0x4c, 0x75, 0x66, 0x75, 0x69, 0x6d, 0x69, 0x3b,
0x4b, 0x61, 0x62, 0xe0, 0x6c, 0xe0, 0x73, 0x68, 0xec, 0x70, 0xf9, 0x3b, 0x4c, 0xf9, 0x73, 0x68, 0xec, 0x6b, 0xe0, 0x3b,
0x4c, 0x75, 0x74, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x67, 0xf9, 0x64, 0x69, 0x3b, 0x4b, 0x61,
0x73, 0x77, 0xe8, 0x6b, 0xe8, 0x73, 0xe8, 0x3b, 0x43, 0x69, 0x73, 0x77, 0xe0, 0x3b, 0x43, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b,
0x4d, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x43, 0x3b, 0x44, 0x41,
0x43, 0x3b, 0x44, 0x41, 0x52, 0x3b, 0x44, 0x41, 0x44, 0x3b, 0x44, 0x41, 0x4e, 0x3b, 0x44, 0x41, 0x48, 0x3b, 0x44, 0x41,
0x55, 0x3b, 0x44, 0x41, 0x4f, 0x3b, 0x44, 0x41, 0x42, 0x3b, 0x44, 0x4f, 0x43, 0x3b, 0x44, 0x41, 0x50, 0x3b, 0x44, 0x47,
0x49, 0x3b, 0x44, 0x41, 0x47, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x63, 0x68, 0x69, 0x65, 0x6c,
0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d,
0x61, 0x72, 0x20, 0x41, 0x64, 0x65, 0x6b, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x6e, 0x67, 0x2019,
0x77, 0x65, 0x6e, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x62, 0x69, 0x63, 0x68, 0x3b, 0x44, 0x77,
0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x75, 0x63, 0x68, 0x69, 0x65, 0x6c, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61,
0x72, 0x20, 0x41, 0x62, 0x69, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x62,
0x6f, 0x72, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x4f, 0x63, 0x68, 0x69, 0x6b, 0x6f, 0x3b, 0x44,
0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x70, 0x61, 0x72, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20,
0x67, 0x69, 0x20, 0x61, 0x63, 0x68, 0x69, 0x65, 0x6c, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x70,
0x61, 0x72, 0x20, 0x67, 0x69, 0x20, 0x61, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x43, 0x3b, 0x52, 0x3b, 0x44, 0x3b, 0x4e, 0x3b,
0x42, 0x3b, 0x55, 0x3b, 0x42, 0x3b, 0x42, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x4a, 0x61, 0x6e, 0x3b,
0x46, 0x65, 0x62, 0x3b, 0x4d, 0xe4, 0x65, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x6e, 0x3b,
0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b,
0x44, 0x65, 0x7a, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x4d,
0xe4, 0x65, 0x72, 0x7a, 0x3b, 0x41, 0x62, 0x72, 0xeb, 0x6c, 0x6c, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x6e, 0x69,
0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d,
0xe4, 0x65, 0x2e, 0x3b, 0x41, 0x62, 0x72, 0x2e, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75,
0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x2e, 0x3b, 0x53, 0x65, 0x70, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f,
0x76, 0x2e, 0x3b, 0x44, 0x65, 0x7a, 0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b,
0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b,
0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x458, 0x430, 0x43d, 0x2e,
0x3b, 0x444, 0x435, 0x432, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x2e, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x458, 0x3b,
0x458, 0x443, 0x43d, 0x2e, 0x3b, 0x458, 0x443, 0x43b, 0x2e, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x2e,
0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b, 0x458, 0x430, 0x43d,
0x443, 0x430, 0x440, 0x438, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x443, 0x430, 0x440, 0x438, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430,
0x43f, 0x440, 0x438, 0x43b, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x438, 0x3b, 0x458, 0x443, 0x43b, 0x438, 0x3b, 0x430,
0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43e, 0x43a, 0x442, 0x43e,
0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x434, 0x435, 0x43a, 0x435, 0x43c, 0x432, 0x440,
0x438, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65,
0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b,
0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65,
0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x79, 0x69,
0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x79, 0x61, 0x69, 0x3b, 0x41, 0x67,
0x75, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61,
0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x91c, 0x928, 0x970,
0x3b, 0x92b, 0x930, 0x970, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x948, 0x932, 0x3b, 0x92e, 0x908,
0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x970, 0x3b, 0x905, 0x917, 0x970, 0x3b, 0x938, 0x93f, 0x924, 0x970, 0x3b, 0x905,
0x915, 0x94d, 0x924, 0x942, 0x970, 0x3b, 0x928, 0x935, 0x970, 0x3b, 0x926, 0x93f, 0x938, 0x970, 0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940,
0x3b, 0x92b, 0x930, 0x935, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x948, 0x932, 0x3b,
0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x924, 0x3b, 0x938,
0x93f, 0x924, 0x902, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x942, 0x92c, 0x930, 0x3b, 0x928, 0x935, 0x902, 0x92c, 0x930, 0x3b,
0x926, 0x93f, 0x938, 0x902, 0x92c, 0x930, 0x3b, 0x91c, 0x3b, 0x92b, 0x3b, 0x92e, 0x93e, 0x3b, 0x905, 0x3b, 0x92e, 0x3b, 0x91c, 0x942,
0x3b, 0x91c, 0x941, 0x3b, 0x905, 0x3b, 0x938, 0x93f, 0x3b, 0x905, 0x3b, 0x928, 0x3b, 0x926, 0x93f, 0x3b, 0x91c, 0x928, 0x935, 0x930,
0x940, 0x3b, 0x92b, 0x930, 0x935, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x948, 0x932,
0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x924, 0x3b,
0x938, 0x93f, 0x924, 0x902, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x924, 0x942, 0x92c, 0x930, 0x3b, 0x928, 0x935, 0x902, 0x92c, 0x930,
0x3b, 0x926, 0x93f, 0x938, 0x902, 0x92c, 0x930, 0x3b, 0x4b, 0x77, 0x61, 0x3b, 0x55, 0x6e, 0x61, 0x3b, 0x52, 0x61, 0x72, 0x3b,
0x43, 0x68, 0x65, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x4d, 0x6f, 0x63, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4e, 0x61, 0x6e, 0x3b,
0x54, 0x69, 0x73, 0x3b, 0x4b, 0x75, 0x6d, 0x3b, 0x4d, 0x6f, 0x6a, 0x3b, 0x59, 0x65, 0x6c, 0x3b, 0x4d, 0x77, 0x65, 0x72,
0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f,
0x20, 0x75, 0x6e, 0x61, 0x79, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x75, 0x6e,
0x65, 0x72, 0x61, 0x72, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x75, 0x6e, 0x65, 0x63, 0x68,
0x65, 0x73, 0x68, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x75, 0x6e, 0x65, 0x74, 0x68, 0x61,
0x6e, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x75, 0x20, 0x6e, 0x61,
0x20, 0x6d, 0x6f, 0x63, 0x68, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x73, 0x61, 0x62, 0x61,
0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6e, 0x61, 0x6e, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x6f, 0x20, 0x74, 0x69, 0x73, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x75,
0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20,
0x6d, 0x6f, 0x6a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e,
0x61, 0x20, 0x79, 0x65, 0x6c, 0x2019, 0x6c, 0x69, 0x3b, 0x4b, 0x3b, 0x55, 0x3b, 0x52, 0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x4d,
0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x4e,
0x74, 0x61, 0x6e, 0x64, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x3b,
0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x54, 0x61, 0x74, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20,
0x77, 0x61, 0x20, 0x4e, 0x63, 0x68, 0x65, 0x63, 0x68, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20,
0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61,
0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x55, 0x6d, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e,
0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d, 0x69, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64,
0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d, 0x69, 0x74, 0x61, 0x74,
0x75, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61,
0x20, 0x4e, 0x63, 0x68, 0x65, 0x63, 0x68, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e,
0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69,
0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f,
0x20, 0x6e, 0x61, 0x20, 0x55, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e,
0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d, 0x3b, 0x4a, 0x61, 0x6e,
0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x79, 0x3b, 0x4a, 0x6f, 0x6e,
0x3b, 0x4a, 0x6f, 0x6c, 0x3b, 0x41, 0x6f, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76,
0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x6f, 0x61, 0x72, 0x79, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x6f, 0x61, 0x72,
0x79, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x73, 0x61, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x79, 0x3b, 0x4d, 0x65, 0x79, 0x3b,
0x4a, 0x6f, 0x6e, 0x61, 0x3b, 0x4a, 0x6f, 0x6c, 0x61, 0x79, 0x3b, 0x41, 0x6f, 0x67, 0x6f, 0x73, 0x69, 0x74, 0x72, 0x61,
0x3b, 0x53, 0x65, 0x70, 0x74, 0x61, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x72, 0x61, 0x3b, 0x4e,
0x6f, 0x76, 0x61, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x61, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x4a, 0x61, 0x6e,
0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e,
0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x4f, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76,
0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72,
0x69, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b,
0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x4f, 0x67, 0x6f, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x69,
0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x62c, 0x627, 0x646, 0x648, 0x627, 0x631, 0x64a, 0x3b, 0x641, 0x64a, 0x628, 0x648, 0x627,
0x631, 0x64a, 0x3b, 0x645, 0x686, 0x3b, 0x627, 0x6a4, 0x631, 0x64a, 0x644, 0x3b, 0x645, 0x64a, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c,
0x648, 0x644, 0x627, 0x64a, 0x3b, 0x762, 0x648, 0x633, 0x3b, 0x633, 0x64a, 0x6a4, 0x62a, 0x64a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x648,
0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x6cf, 0x64a, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x64a, 0x633, 0x64a, 0x645, 0x628,
0x631, 0x3b, 0xd1c, 0xd28, 0xd41, 0x3b, 0xd2b, 0xd46, 0xd2c, 0xd4d, 0xd30, 0xd41, 0x3b, 0xd2e, 0xd3e, 0xd7c, 0x3b, 0xd0f, 0xd2a, 0xd4d,
0xd30, 0xd3f, 0x3b, 0xd2e, 0xd47, 0xd2f, 0xd4d, 0x3b, 0xd1c, 0xd42, 0xd7a, 0x3b, 0xd1c, 0xd42, 0xd32, 0xd48, 0x3b, 0xd13, 0xd17, 0x3b,
0xd38, 0xd46, 0xd2a, 0xd4d, 0xd31, 0xd4d, 0xd31, 0xd02, 0x3b, 0xd12, 0xd15, 0xd4d, 0xd1f, 0xd4b, 0x3b, 0xd28, 0xd35, 0xd02, 0x3b, 0xd21,
0xd3f, 0xd38, 0xd02, 0x3b, 0xd1c, 0xd28, 0xd41, 0xd35, 0xd30, 0xd3f, 0x3b, 0xd2b, 0xd46, 0xd2c, 0xd4d, 0xd30, 0xd41, 0xd35, 0xd30, 0xd3f,
0x3b, 0xd2e, 0xd3e, 0xd7c, 0xd1a, 0xd4d, 0xd1a, 0xd4d, 0x3b, 0xd0f, 0xd2a, 0xd4d, 0xd30, 0xd3f, 0xd7d, 0x3b, 0xd2e, 0xd47, 0xd2f, 0xd4d,
0x3b, 0xd1c, 0xd42, 0xd7a, 0x3b, 0xd1c, 0xd42, 0xd32, 0xd48, 0x3b, 0xd13, 0xd17, 0xd38, 0xd4d, 0xd31, 0xd4d, 0xd31, 0xd4d, 0x3b, 0xd38,
0xd46, 0xd2a, 0xd4d, 0xd31, 0xd4d, 0xd31, 0xd02, 0xd2c, 0xd7c, 0x3b, 0xd12, 0xd15, 0xd4d, 0x200c, 0xd1f, 0xd4b, 0xd2c, 0xd7c, 0x3b, 0xd28,
0xd35, 0xd02, 0xd2c, 0xd7c, 0x3b, 0xd21, 0xd3f, 0xd38, 0xd02, 0xd2c, 0xd7c, 0x3b, 0xd1c, 0x3b, 0xd2b, 0xd46, 0x3b, 0xd2e, 0xd3e, 0x3b,
0xd0f, 0x3b, 0xd2e, 0xd46, 0x3b, 0xd1c, 0xd42, 0xd7a, 0x3b, 0xd1c, 0xd42, 0x3b, 0xd13, 0x3b, 0xd38, 0xd46, 0x3b, 0xd12, 0x3b, 0xd28,
0x3b, 0xd21, 0xd3f, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x72, 0x61, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b,
0x4d, 0x65, 0x6a, 0x3b, 0x120, 0x75, 0x6e, 0x3b, 0x4c, 0x75, 0x6c, 0x3b, 0x41, 0x77, 0x77, 0x3b, 0x53, 0x65, 0x74, 0x3b,
0x4f, 0x74, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x10b, 0x3b, 0x4a, 0x61, 0x6e, 0x6e, 0x61, 0x72, 0x3b, 0x46,
0x72, 0x61, 0x72, 0x3b, 0x4d, 0x61, 0x72, 0x7a, 0x75, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x6a, 0x6a,
0x75, 0x3b, 0x120, 0x75, 0x6e, 0x6a, 0x75, 0x3b, 0x4c, 0x75, 0x6c, 0x6a, 0x75, 0x3b, 0x41, 0x77, 0x77, 0x69, 0x73, 0x73,
0x75, 0x3b, 0x53, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x75, 0x3b, 0x4f, 0x74, 0x74, 0x75, 0x62, 0x72, 0x75, 0x3b,
0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x75, 0x3b, 0x44, 0x69, 0x10b, 0x65, 0x6d, 0x62, 0x72, 0x75, 0x3b, 0x4a, 0x6e,
0x3b, 0x46, 0x72, 0x3b, 0x4d, 0x7a, 0x3b, 0x41, 0x70, 0x3b, 0x4d, 0x6a, 0x3b, 0x120, 0x6e, 0x3b, 0x4c, 0x6a, 0x3b, 0x41,
0x77, 0x3b, 0x53, 0x74, 0x3b, 0x4f, 0x62, 0x3b, 0x4e, 0x76, 0x3b, 0x44, 0x10b, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x120, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x99c, 0x9be,
0x9a8, 0x9c1, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x9cd, 0x9b0, 0x9c1, 0x3b, 0x9ae, 0x9be, 0x9b0, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9b0, 0x9bf, 0x3b,
0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x3b, 0x986, 0x997, 0x3b, 0x9b8, 0x9c7, 0x9aa, 0x9cd, 0x99f,
0x3b, 0x993, 0x995, 0x9cd, 0x99f, 0x9cb, 0x3b, 0x9a8, 0x9ad, 0x9c7, 0x3b, 0x9a1, 0x9bf, 0x9b8, 0x9c7, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1,
0x9f1, 0x9be, 0x9b0, 0x9bf, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x9cd, 0x9b0, 0x9c1, 0x9f1, 0x9be, 0x9b0, 0x9bf, 0x3b, 0x9ae, 0x9be, 0x9b0, 0x9cd,
0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9b0, 0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be,
0x987, 0x3b, 0x993, 0x997, 0x9b7, 0x9cd, 0x99f, 0x3b, 0x9b8, 0x9c7, 0x9aa, 0x9cd, 0x99f, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x993,
0x995, 0x9cd, 0x99f, 0x9cb, 0x9ac, 0x9b0, 0x3b, 0x9a8, 0x9ac, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x9a1, 0x9bf, 0x9b8, 0x9c7, 0x9ae,
0x9cd, 0x9ac, 0x9b0, 0x3b, 0x99c, 0x9be, 0x3b, 0x9ab, 0x9c7, 0x3b, 0x9ae, 0x9be, 0x9b0, 0x3b, 0x98f, 0x9aa, 0x3b, 0x9ae, 0x9c7, 0x3b,
0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x3b, 0x986, 0x3b, 0x9b8, 0x9c7, 0x3b, 0x993, 0x3b, 0x9a8, 0x9ac, 0x3b, 0x9a1, 0x9bf,
0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x9f1, 0x9be, 0x9b0, 0x9bf, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x9cd, 0x9b0, 0x9c1, 0x9f1, 0x9be, 0x9b0, 0x9bf,
0x3b, 0x9ae, 0x9be, 0x9b0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9b0, 0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8,
0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x9b8, 0x9cd, 0x99f, 0x3b, 0x9b8, 0x9c7, 0x9aa, 0x9cd, 0x99f, 0x9c7, 0x9ae,
0x9cd, 0x9ac, 0x9b0, 0x3b, 0x993, 0x995, 0x9cd, 0x99f, 0x9cb, 0x9ac, 0x9b0, 0x3b, 0x9a8, 0x9ad, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b,
0x9a1, 0x9bf, 0x9b8, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x99c, 0x9be, 0x3b, 0x9ab, 0x9c7, 0x3b, 0x9ae, 0x9be, 0x9b0, 0x3b, 0x98f,
0x9aa, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x3b, 0x986, 0x3b, 0x9b8, 0x9c7, 0x3b, 0x993, 0x995,
0x3b, 0x9a8, 0x9ac, 0x3b, 0x9a1, 0x9bf, 0x3b, 0x4a, 0x2d, 0x67, 0x75, 0x65, 0x72, 0x3b, 0x54, 0x2d, 0x61, 0x72, 0x72, 0x65,
0x65, 0x3b, 0x4d, 0x61, 0x79, 0x72, 0x6e, 0x74, 0x3b, 0x41, 0x76, 0x72, 0x72, 0x69, 0x6c, 0x3b, 0x42, 0x6f, 0x61, 0x6c,
0x64, 0x79, 0x6e, 0x3b, 0x4d, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x4a, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65,
0x65, 0x3b, 0x4c, 0x75, 0x61, 0x6e, 0x69, 0x73, 0x74, 0x79, 0x6e, 0x3b, 0x4d, 0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72,
0x3b, 0x4a, 0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4d, 0x2d, 0x48, 0x6f, 0x75, 0x6e, 0x65, 0x79, 0x3b, 0x4d,
0x2d, 0x4e, 0x6f, 0x6c, 0x6c, 0x69, 0x63, 0x6b, 0x3b, 0x4a, 0x65, 0x72, 0x72, 0x65, 0x79, 0x2d, 0x67, 0x65, 0x75, 0x72,
0x65, 0x65, 0x3b, 0x54, 0x6f, 0x73, 0x68, 0x69, 0x61, 0x67, 0x68, 0x74, 0x2d, 0x61, 0x72, 0x72, 0x65, 0x65, 0x3b, 0x4d,
0x61, 0x79, 0x72, 0x6e, 0x74, 0x3b, 0x41, 0x76, 0x65, 0x72, 0x69, 0x6c, 0x3b, 0x42, 0x6f, 0x61, 0x6c, 0x64, 0x79, 0x6e,
0x3b, 0x4d, 0x65, 0x61, 0x6e, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x4a, 0x65, 0x72, 0x72, 0x65, 0x79, 0x2d,
0x73, 0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x4c, 0x75, 0x61, 0x6e, 0x69, 0x73, 0x74, 0x79, 0x6e, 0x3b, 0x4d, 0x65, 0x61,
0x6e, 0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4a, 0x65, 0x72, 0x72, 0x65, 0x79, 0x2d, 0x66, 0x6f, 0x75, 0x79,
0x69, 0x72, 0x3b, 0x4d, 0x65, 0x65, 0x20, 0x48, 0x6f, 0x75, 0x6e, 0x65, 0x79, 0x3b, 0x4d, 0x65, 0x65, 0x20, 0x6e, 0x79,
0x20, 0x4e, 0x6f, 0x6c, 0x6c, 0x69, 0x63, 0x6b, 0x3b, 0x48, 0x101, 0x6e, 0x3b, 0x50, 0x113, 0x70, 0x3b, 0x4d, 0x101, 0x65,
0x3b, 0x100, 0x70, 0x65, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x48, 0x75, 0x6e, 0x65, 0x3b, 0x48, 0x16b, 0x72, 0x3b, 0x100, 0x6b,
0x75, 0x3b, 0x48, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x65, 0x3b, 0x4e, 0x6f, 0x65, 0x6d, 0x3b, 0x54, 0x12b, 0x68, 0x65, 0x3b,
0x48, 0x101, 0x6e, 0x75, 0x65, 0x72, 0x65, 0x3b, 0x50, 0x113, 0x70, 0x75, 0x65, 0x72, 0x65, 0x3b, 0x4d, 0x101, 0x65, 0x68,
0x65, 0x3b, 0x100, 0x70, 0x65, 0x72, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x48, 0x75, 0x6e, 0x65, 0x3b,
0x48, 0x16b, 0x72, 0x61, 0x65, 0x3b, 0x100, 0x6b, 0x75, 0x68, 0x61, 0x74, 0x61, 0x3b, 0x48, 0x65, 0x70, 0x65, 0x74, 0x65,
0x6d, 0x61, 0x3b, 0x4f, 0x6b, 0x65, 0x74, 0x6f, 0x70, 0x61, 0x3b, 0x4e, 0x6f, 0x65, 0x6d, 0x61, 0x3b, 0x54, 0x12b, 0x68,
0x65, 0x6d, 0x61, 0x3b, 0x48, 0x3b, 0x50, 0x3b, 0x4d, 0x3b, 0x100, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x48, 0x3b, 0x100, 0x3b,
0x48, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x91c, 0x93e, 0x928, 0x947, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x3b,
0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x90f, 0x92a, 0x94d, 0x930, 0x93f, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c,
0x941, 0x932, 0x948, 0x3b, 0x911, 0x917, 0x3b, 0x938, 0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x3b, 0x911, 0x915, 0x94d, 0x91f, 0x94b, 0x3b,
0x928, 0x94b, 0x935, 0x94d, 0x939, 0x947, 0x902, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x902, 0x3b, 0x91c, 0x93e, 0x928, 0x947, 0x935, 0x93e,
0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b,
0x90f, 0x92a, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x948, 0x3b, 0x911,
0x917, 0x938, 0x94d, 0x91f, 0x3b, 0x938, 0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x911, 0x915, 0x94d, 0x91f, 0x94b, 0x92c,
0x930, 0x3b, 0x928, 0x94b, 0x935, 0x94d, 0x939, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x902, 0x92c, 0x930, 0x3b,
0x91c, 0x93e, 0x3b, 0x92b, 0x947, 0x3b, 0x92e, 0x93e, 0x3b, 0x90f, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x3b, 0x91c, 0x941, 0x3b,
0x911, 0x3b, 0x938, 0x3b, 0x911, 0x3b, 0x928, 0x94b, 0x3b, 0x921, 0x93f, 0x3b, 0x44, 0x61, 0x6c, 0x3b, 0x41, 0x72, 0xe1, 0x3b,
0x186, 0x25b, 0x6e, 0x3b, 0x44, 0x6f, 0x79, 0x3b, 0x4c, 0xe9, 0x70, 0x3b, 0x52, 0x6f, 0x6b, 0x3b, 0x53, 0xe1, 0x73, 0x3b,
0x42, 0x254, 0x301, 0x72, 0x3b, 0x4b, 0xfa, 0x73, 0x3b, 0x47, 0xed, 0x73, 0x3b, 0x53, 0x68, 0x289, 0x301, 0x3b, 0x4e, 0x74,
0x289, 0x301, 0x3b, 0x4f, 0x6c, 0x61, 0x64, 0x61, 0x6c, 0x289, 0x301, 0x3b, 0x41, 0x72, 0xe1, 0x74, 0x3b, 0x186, 0x25b, 0x6e,
0x268, 0x301, 0x254, 0x268, 0x14b, 0x254, 0x6b, 0x3b, 0x4f, 0x6c, 0x6f, 0x64, 0x6f, 0x79, 0xed, 0xf3, 0x72, 0xed, 0xea, 0x20,
0x69, 0x6e, 0x6b, 0xf3, 0x6b, 0xfa, 0xe2, 0x3b, 0x4f, 0x6c, 0x6f, 0x69, 0x6c, 0xe9, 0x70, 0x16b, 0x6e, 0x79, 0x12b, 0x113,
0x20, 0x69, 0x6e, 0x6b, 0xf3, 0x6b, 0xfa, 0xe2, 0x3b, 0x4b, 0xfa, 0x6a, 0xfa, 0x254, 0x72, 0x254, 0x6b, 0x3b, 0x4d, 0xf3,
0x72, 0x75, 0x73, 0xe1, 0x73, 0x69, 0x6e, 0x3b, 0x186, 0x6c, 0x254, 0x301, 0x268, 0x301, 0x62, 0x254, 0x301, 0x72, 0xe1, 0x72,
0x25b, 0x3b, 0x4b, 0xfa, 0x73, 0x68, 0xee, 0x6e, 0x3b, 0x4f, 0x6c, 0x67, 0xed, 0x73, 0x61, 0x6e, 0x3b, 0x50, 0x289, 0x73,
0x68, 0x289, 0x301, 0x6b, 0x61, 0x3b, 0x4e, 0x74, 0x289, 0x301, 0x14b, 0x289, 0x301, 0x73, 0x3b, 0x698, 0x627, 0x646, 0x648, 0x6cc,
0x647, 0x3b, 0x641, 0x648, 0x631, 0x6cc, 0x647, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x622, 0x648, 0x631, 0x6cc, 0x644, 0x3b, 0x645,
0x647, 0x3b, 0x698, 0x648, 0x626, 0x646, 0x3b, 0x698, 0x648, 0x626, 0x6cc, 0x647, 0x3b, 0x627, 0x648, 0x62a, 0x3b, 0x633, 0x67e, 0x62a,
0x627, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x627, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633,
0x627, 0x645, 0x628, 0x631, 0x3b, 0x4a, 0x41, 0x4e, 0x3b, 0x46, 0x45, 0x42, 0x3b, 0x4d, 0x41, 0x43, 0x3b, 0x128, 0x50, 0x55,
0x3b, 0x4d, 0x128, 0x128, 0x3b, 0x4e, 0x4a, 0x55, 0x3b, 0x4e, 0x4a, 0x52, 0x3b, 0x41, 0x47, 0x41, 0x3b, 0x53, 0x50, 0x54,
0x3b, 0x4f, 0x4b, 0x54, 0x3b, 0x4e, 0x4f, 0x56, 0x3b, 0x44, 0x45, 0x43, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x129,
0x3b, 0x46, 0x65, 0x62, 0x75, 0x72, 0x75, 0x61, 0x72, 0x129, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x128, 0x70, 0x75,
0x72, 0x169, 0x3b, 0x4d, 0x129, 0x129, 0x3b, 0x4e, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x72, 0x61, 0x129, 0x3b,
0x41, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x169,
0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x63, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a,
0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x128, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e,
0x3b, 0x44, 0x3b, 0x6d, 0x62, 0x65, 0x67, 0x74, 0x75, 0x67, 0x3b, 0x69, 0x6d, 0x65, 0x67, 0x20, 0xe0, 0x62, 0xf9, 0x62,
0xec, 0x3b, 0x69, 0x6d, 0x65, 0x67, 0x20, 0x6d, 0x62, 0x259, 0x14b, 0x63, 0x68, 0x75, 0x62, 0x69, 0x3b, 0x69, 0x6d, 0x259,
0x67, 0x20, 0x6e, 0x67, 0x77, 0x259, 0x300, 0x74, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x66, 0x6f, 0x67, 0x3b, 0x69, 0x6d,
0x259, 0x67, 0x20, 0x69, 0x63, 0x68, 0x69, 0x69, 0x62, 0x254, 0x64, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0xe0, 0x64, 0xf9,
0x6d, 0x62, 0x259, 0x300, 0x14b, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x69, 0x63, 0x68, 0x69, 0x6b, 0x61, 0x3b, 0x69, 0x6d,
0x259, 0x67, 0x20, 0x6b, 0x75, 0x64, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x74, 0xe8, 0x73, 0x69, 0x2bc, 0x65, 0x3b, 0x69,
0x6d, 0x259, 0x67, 0x20, 0x7a, 0xf2, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x6b, 0x72, 0x69, 0x7a, 0x6d, 0x65, 0x64, 0x3b,
0x69, 0x6d, 0x259, 0x67, 0x20, 0x6d, 0x62, 0x65, 0x67, 0x74, 0x75, 0x67, 0x3b, 0x69, 0x6d, 0x65, 0x67, 0x20, 0xe0, 0x62,
0xf9, 0x62, 0xec, 0x3b, 0x69, 0x6d, 0x65, 0x67, 0x20, 0x6d, 0x62, 0x259, 0x14b, 0x63, 0x68, 0x75, 0x62, 0x69, 0x3b, 0x69,
0x6d, 0x259, 0x67, 0x20, 0x6e, 0x67, 0x77, 0x259, 0x300, 0x74, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x66, 0x6f, 0x67, 0x3b,
0x69, 0x6d, 0x259, 0x67, 0x20, 0x69, 0x63, 0x68, 0x69, 0x69, 0x62, 0x254, 0x64, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0xe0,
0x64, 0xf9, 0x6d, 0x62, 0x259, 0x300, 0x14b, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x69, 0x63, 0x68, 0x69, 0x6b, 0x61, 0x3b,
0x69, 0x6d, 0x259, 0x67, 0x20, 0x6b, 0x75, 0x64, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x74, 0xe8, 0x73, 0x69, 0x2bc, 0x65,
0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x7a, 0xf2, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x6b, 0x72, 0x69, 0x7a, 0x6d, 0x65,
0x64, 0x3b, 0x4d, 0x31, 0x3b, 0x41, 0x32, 0x3b, 0x4d, 0x33, 0x3b, 0x4e, 0x34, 0x3b, 0x46, 0x35, 0x3b, 0x49, 0x36, 0x3b,
0x41, 0x37, 0x3b, 0x49, 0x38, 0x3b, 0x4b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0x31, 0x2d,
0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x32, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x33, 0x2d, 0x440, 0x20, 0x441, 0x430,
0x440, 0x3b, 0x34, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x35, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x36, 0x2d,
0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x37, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x38, 0x2d, 0x440, 0x20, 0x441, 0x430,
0x440, 0x3b, 0x39, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x31, 0x30, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x31,
0x31, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x31, 0x32, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x41d, 0x44d, 0x433,
0x434, 0x4af, 0x433, 0x44d, 0x44d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x425, 0x43e, 0x451, 0x440, 0x434, 0x443, 0x433, 0x430, 0x430,
0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x413, 0x443, 0x440, 0x430, 0x432, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430,
0x440, 0x3b, 0x414, 0x4e9, 0x440, 0x4e9, 0x432, 0x434, 0x4af, 0x433, 0x44d, 0x44d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x422, 0x430,
0x432, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x417, 0x443, 0x440, 0x433, 0x430, 0x430, 0x434, 0x443,
0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x414, 0x43e, 0x43b, 0x43e, 0x43e, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440,
0x20, 0x441, 0x430, 0x440, 0x3b, 0x41d, 0x430, 0x439, 0x43c, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b,
0x415, 0x441, 0x434, 0x4af, 0x433, 0x44d, 0x44d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x410, 0x440, 0x430, 0x432, 0x434, 0x443, 0x433,
0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x410, 0x440, 0x432, 0x430, 0x43d, 0x20, 0x43d, 0x44d, 0x433, 0x434, 0x4af, 0x433,
0x44d, 0x44d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x410, 0x440, 0x432, 0x430, 0x43d, 0x20, 0x445, 0x43e, 0x451, 0x440, 0x434, 0x443,
0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x49, 0x3b, 0x49, 0x49, 0x3b, 0x49, 0x49, 0x49, 0x3b, 0x49, 0x56,
0x3b, 0x56, 0x3b, 0x56, 0x49, 0x3b, 0x56, 0x49, 0x49, 0x3b, 0x56, 0x49, 0x49, 0x49, 0x3b, 0x49, 0x58, 0x3b, 0x58, 0x3b,
0x58, 0x49, 0x3b, 0x58, 0x49, 0x49, 0x3b, 0x43d, 0x44d, 0x433, 0x434, 0x4af, 0x433, 0x44d, 0x44d, 0x440, 0x20, 0x441, 0x430, 0x440,
0x3b, 0x445, 0x43e, 0x451, 0x440, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x433, 0x443, 0x440, 0x430,
0x432, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x434, 0x4e9, 0x440, 0x4e9, 0x432, 0x434, 0x4af, 0x433,
0x44d, 0x44d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x442, 0x430, 0x432, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430,
0x440, 0x3b, 0x437, 0x443, 0x440, 0x433, 0x430, 0x430, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x434,
0x43e, 0x43b, 0x43e, 0x43e, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x43d, 0x430, 0x439, 0x43c, 0x434,
0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x435, 0x441, 0x434, 0x4af, 0x433, 0x44d, 0x44d, 0x440, 0x20, 0x441,
0x430, 0x440, 0x3b, 0x430, 0x440, 0x430, 0x432, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x430, 0x440,
0x432, 0x430, 0x43d, 0x20, 0x43d, 0x44d, 0x433, 0x434, 0x4af, 0x433, 0x44d, 0x44d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x430, 0x440,
0x432, 0x430, 0x43d, 0x20, 0x445, 0x43e, 0x451, 0x440, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x31,
0x202f, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x32, 0x202f, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820,
0x3b, 0x33, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x34, 0x202f, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e,
0x1820, 0x3b, 0x35, 0x202f, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x36, 0x202f, 0x180a, 0x1837, 0x20, 0x1830, 0x1820,
0x1837, 0x180e, 0x1820, 0x3b, 0x37, 0x202f, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x38, 0x202f, 0x180a, 0x1837, 0x20,
0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x39, 0x202f, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x31, 0x30, 0x20,
0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x31, 0x31, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b,
0x31, 0x32, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x1828, 0x1822, 0x182d, 0x1821, 0x1833, 0x1825, 0x182d, 0x1821, 0x1837,
0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x182c, 0x1823, 0x1836, 0x1820, 0x1833, 0x1823, 0x182d, 0x1820, 0x1837, 0x20, 0x1830, 0x1820, 0x1837,
0x202f, 0x1820, 0x3b, 0x182d, 0x1823, 0x1837, 0x182a, 0x1821, 0x1833, 0x1823, 0x182d, 0x1820, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x202f, 0x1820, 0x3b,
0x1833, 0x1825, 0x1837, 0x182a, 0x1821, 0x1833, 0x1825, 0x182d, 0x1821, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x1832, 0x1820, 0x182a,
0x1823, 0x1833, 0x1823, 0x182d, 0x1820, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x202f, 0x1820, 0x3b, 0x1835, 0x1822, 0x1837, 0x182d, 0x1823, 0x182d, 0x1820,
0x1833, 0x1823, 0x182d, 0x1820, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x1832, 0x1823, 0x182f, 0x1823, 0x182d, 0x1820, 0x1833, 0x1823,
0x182d, 0x1820, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x1828, 0x1820, 0x1822, 0x182e, 0x1820, 0x1833, 0x1825, 0x182d, 0x1820, 0x1837,
0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x1836, 0x1822, 0x1830, 0x1825, 0x1833, 0x1825, 0x182d, 0x1821, 0x1837, 0x20, 0x1830, 0x1820, 0x1837,
0x180e, 0x1820, 0x3b, 0x1820, 0x1837, 0x182a, 0x1820, 0x1833, 0x1823, 0x182d, 0x1820, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x1820,
0x1837, 0x182a, 0x1820, 0x1828, 0x20, 0x1828, 0x1822, 0x182d, 0x1821, 0x1833, 0x1825, 0x182d, 0x1821, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820,
0x3b, 0x1820, 0x1837, 0x182a, 0x1820, 0x1828, 0x20, 0x182c, 0x1823, 0x1836, 0x1820, 0x1833, 0x1823, 0x182d, 0x1820, 0x1837, 0x20, 0x1830, 0x1820, 0x1837,
0x180e, 0x1820, 0x3b, 0x31, 0x202f, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x32, 0x202f, 0x180a, 0x1837, 0x20, 0x1830,
0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x33, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x34, 0x202f, 0x180a, 0x1837, 0x20,
0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x35, 0x202f, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x36, 0x202f, 0x180a,
0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x37, 0x202f, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x38,
0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x39, 0x20, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b,
0x31, 0x30, 0x20, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x31, 0x31, 0x20, 0x180a, 0x1837, 0x20, 0x1830, 0x1820,
0x1837, 0x180e, 0x1820, 0x3b, 0x31, 0x32, 0x20, 0x180a, 0x1837, 0x20, 0x1830, 0x1820, 0x1837, 0x180e, 0x1820, 0x3b, 0x7a, 0x61, 0x6e, 0x3b,
0x66, 0x65, 0x76, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x76, 0x72, 0x3b, 0x6d, 0x65, 0x3b, 0x7a, 0x69, 0x6e, 0x3b, 0x7a,
0x69, 0x6c, 0x3b, 0x6f, 0x75, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64,
0x65, 0x73, 0x3b, 0x7a, 0x61, 0x6e, 0x76, 0x69, 0x65, 0x3b, 0x66, 0x65, 0x76, 0x72, 0x69, 0x79, 0x65, 0x3b, 0x6d, 0x61,
0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x65, 0x3b, 0x7a, 0x69, 0x6e, 0x3b, 0x7a, 0x69, 0x6c, 0x79,
0x65, 0x3b, 0x6f, 0x75, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x61, 0x6d, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x3b, 0x6e,
0x6f, 0x76, 0x61, 0x6d, 0x3b, 0x64, 0x65, 0x73, 0x61, 0x6d, 0x3b, 0x7a, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x61, 0x3b, 0x6d,
0x3b, 0x7a, 0x3b, 0x7a, 0x3b, 0x6f, 0x3b, 0x73, 0x3b, 0x6f, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x46, 0x4c, 0x4f, 0x3b, 0x43,
0x4c, 0x41, 0x3b, 0x43, 0x4b, 0x49, 0x3b, 0x46, 0x4d, 0x46, 0x3b, 0x4d, 0x41, 0x44, 0x3b, 0x4d, 0x42, 0x49, 0x3b, 0x4d,
0x4c, 0x49, 0x3b, 0x4d, 0x41, 0x4d, 0x3b, 0x46, 0x44, 0x45, 0x3b, 0x46, 0x4d, 0x55, 0x3b, 0x46, 0x47, 0x57, 0x3b, 0x46,
0x59, 0x55, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x4c, 0x6f, 0x6f, 0x3b, 0x43, 0x6f, 0x6b, 0x63, 0x77, 0x61, 0x6b, 0x6c, 0x61,
0x14b, 0x6e, 0x65, 0x3b, 0x43, 0x6f, 0x6b, 0x63, 0x77, 0x61, 0x6b, 0x6c, 0x69, 0x69, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x4d,
0x61, 0x72, 0x66, 0x6f, 0x6f, 0x3b, 0x4d, 0x61, 0x64, 0x1dd, 0x1dd, 0x75, 0x75, 0x74, 0x1dd, 0x62, 0x69, 0x6a, 0x61, 0x14b,
0x3b, 0x4d, 0x61, 0x6d, 0x1dd, 0x14b, 0x67, 0x77, 0xe3, 0x61, 0x66, 0x61, 0x68, 0x62, 0x69, 0x69, 0x3b, 0x4d, 0x61, 0x6d,
0x1dd, 0x14b, 0x67, 0x77, 0xe3, 0x61, 0x6c, 0x69, 0x69, 0x3b, 0x4d, 0x61, 0x64, 0x1dd, 0x6d, 0x62, 0x69, 0x69, 0x3b, 0x46,
0x129, 0x69, 0x20, 0x44, 0x1dd, 0x253, 0x6c, 0x69, 0x69, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x4d, 0x75, 0x6e, 0x64, 0x61, 0x14b,
0x3b, 0x46, 0x129, 0x69, 0x20, 0x47, 0x77, 0x61, 0x68, 0x6c, 0x6c, 0x65, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x59, 0x75, 0x72,
0x75, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x46, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x45, 0x3b,
0x55, 0x3b, 0x57, 0x3b, 0x59, 0x3b, 0x52, 0x76, 0x66, 0x6f, 0x20, 0x43, 0x75, 0x73, 0x65, 0x3b, 0x48, 0x6f, 0x74, 0x76,
0x6c, 0x65, 0x20, 0x48, 0x76, 0x73, 0x65, 0x3b, 0x54, 0x61, 0x73, 0x61, 0x68, 0x63, 0x75, 0x63, 0x65, 0x3b, 0x54, 0x61,
0x73, 0x61, 0x68, 0x63, 0x65, 0x20, 0x52, 0x61, 0x6b, 0x6b, 0x6f, 0x3b, 0x4b, 0x65, 0x20, 0x48, 0x76, 0x73, 0x65, 0x3b,
0x4b, 0x76, 0x63, 0x6f, 0x20, 0x48, 0x76, 0x73, 0x65, 0x3b, 0x48, 0x69, 0x79, 0x75, 0x63, 0x65, 0x3b, 0x48, 0x69, 0x79,
0x6f, 0x20, 0x52, 0x61, 0x6b, 0x6b, 0x6f, 0x3b, 0x4f, 0x74, 0x6f, 0x77, 0x6f, 0x73, 0x6b, 0x75, 0x63, 0x65, 0x3b, 0x4f,
0x74, 0x6f, 0x77, 0x6f, 0x73, 0x6b, 0x76, 0x20, 0x52, 0x61, 0x6b, 0x6b, 0x6f, 0x3b, 0x45, 0x68, 0x6f, 0x6c, 0x65, 0x3b,
0x52, 0x76, 0x66, 0x6f, 0x20, 0x52, 0x61, 0x6b, 0x6b, 0x6f, 0x3b, 0x1c3, 0x4b, 0x68, 0x61, 0x6e, 0x6e, 0x69, 0x3b, 0x1c3,
0x4b, 0x68, 0x61, 0x6e, 0x1c0, 0x67, 0xf4, 0x61, 0x62, 0x3b, 0x1c0, 0x4b, 0x68, 0x75, 0x75, 0x1c1, 0x6b, 0x68, 0xe2, 0x62,
0x3b, 0x1c3, 0x48, 0xf4, 0x61, 0x1c2, 0x6b, 0x68, 0x61, 0x69, 0x62, 0x3b, 0x1c3, 0x4b, 0x68, 0x61, 0x69, 0x74, 0x73, 0xe2,
0x62, 0x3b, 0x47, 0x61, 0x6d, 0x61, 0x1c0, 0x61, 0x65, 0x62, 0x3b, 0x1c2, 0x4b, 0x68, 0x6f, 0x65, 0x73, 0x61, 0x6f, 0x62,
0x3b, 0x41, 0x6f, 0x1c1, 0x6b, 0x68, 0x75, 0x75, 0x6d, 0xfb, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x54, 0x61, 0x72, 0x61,
0x1c0, 0x6b, 0x68, 0x75, 0x75, 0x6d, 0xfb, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x1c2, 0x4e, 0xfb, 0x1c1, 0x6e, 0xe2, 0x69,
0x73, 0x65, 0x62, 0x3b, 0x1c0, 0x48, 0x6f, 0x6f, 0x1c2, 0x67, 0x61, 0x65, 0x62, 0x3b, 0x48, 0xf4, 0x61, 0x73, 0x6f, 0x72,
0x65, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x905,
0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c,
0x941, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x91f, 0x3b, 0x938, 0x947, 0x92a, 0x94d, 0x91f,
0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x92d, 0x947, 0x92e, 0x94d,
0x92c, 0x930, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x91c, 0x928, 0x3b, 0x92b, 0x947, 0x947, 0x92c, 0x3b,
0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c, 0x941,
0x932, 0x3b, 0x905, 0x917, 0x3b, 0x938, 0x947, 0x92a, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x94b, 0x3b, 0x928, 0x94b, 0x92d, 0x947, 0x3b,
0x921, 0x93f, 0x938, 0x947, 0x3b, 0x91c, 0x928, 0x3b, 0x92b, 0x947, 0x92c, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a,
0x94d, 0x930, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x3b, 0x905, 0x917, 0x3b, 0x938, 0x947, 0x92a,
0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x94b, 0x3b, 0x928, 0x94b, 0x92d, 0x947, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x3b, 0x73, 0x61, 0x14b,
0x20, 0x74, 0x73, 0x65, 0x74, 0x73, 0x25b, 0x300, 0x25b, 0x20, 0x6c, 0xf9, 0x6d, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6b, 0xe0,
0x67, 0x20, 0x6e, 0x67, 0x77, 0xf3, 0x14b, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6c, 0x65, 0x70, 0x79, 0xe8, 0x20, 0x73, 0x68,
0xfa, 0x6d, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x63, 0xff, 0xf3, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x74, 0x73, 0x25b, 0x300, 0x25b,
0x20, 0x63, 0xff, 0xf3, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6e, 0x6a, 0xff, 0x6f, 0x6c, 0xe1, 0x2bc, 0x3b, 0x73, 0x61, 0x14b,
0x20, 0x74, 0x79, 0x25b, 0x300, 0x62, 0x20, 0x74, 0x79, 0x25b, 0x300, 0x62, 0x20, 0x6d, 0x62, 0x289, 0x300, 0x14b, 0x3b, 0x73,
0x61, 0x14b, 0x20, 0x6d, 0x62, 0x289, 0x300, 0x14b, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6e, 0x67, 0x77, 0x254, 0x300, 0x2bc, 0x20,
0x6d, 0x62, 0xff, 0x25b, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x74, 0xe0, 0x14b, 0x61, 0x20, 0x74, 0x73, 0x65, 0x74, 0x73, 0xe1,
0x2bc, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6d, 0x65, 0x6a, 0x77, 0x6f, 0x14b, 0xf3, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6c, 0xf9,
0x6d, 0x3b, 0x4e, 0x64, 0x75, 0x14b, 0x6d, 0x62, 0x69, 0x20, 0x53, 0x61, 0x14b, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20,
0x50, 0x25b, 0x301, 0x70, 0xe1, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x50, 0x25b, 0x301, 0x74, 0xe1, 0x74, 0x3b, 0x50,
0x25b, 0x73, 0x61, 0x14b, 0x20, 0x50, 0x25b, 0x301, 0x6e, 0x25b, 0x301, 0x6b, 0x77, 0x61, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b,
0x20, 0x50, 0x61, 0x74, 0x61, 0x61, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x50, 0x25b, 0x301, 0x6e, 0x25b, 0x301, 0x6e,
0x74, 0xfa, 0x6b, 0xfa, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x53, 0x61, 0x61, 0x6d, 0x62, 0xe1, 0x3b, 0x50, 0x25b,
0x73, 0x61, 0x14b, 0x20, 0x50, 0x25b, 0x301, 0x6e, 0x25b, 0x301, 0x66, 0x254, 0x6d, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20,
0x50, 0x25b, 0x301, 0x6e, 0x25b, 0x301, 0x70, 0x66, 0xfa, 0xa78b, 0xfa, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x4e, 0x25b,
0x67, 0x25b, 0x301, 0x6d, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x4e, 0x74, 0x73, 0x254, 0x30c, 0x70, 0x6d, 0x254, 0x301,
0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x4e, 0x74, 0x73, 0x254, 0x30c, 0x70, 0x70, 0xe1, 0x3b, 0x79, 0x65, 0x3b, 0x6d,
0x6b, 0x3b, 0x6d, 0x73, 0x3b, 0x69, 0x64, 0x3b, 0x70, 0x75, 0x3b, 0x70, 0x79, 0x3b, 0x70, 0x6d, 0x3b, 0x70, 0x73, 0x3b,
0x70, 0x69, 0x3b, 0x79, 0x70, 0x3b, 0x79, 0x79, 0x3b, 0x79, 0x6d, 0x3b, 0x79, 0x65, 0x70, 0xe9, 0x3b, 0x6d, 0x75, 0x6b,
0x169, 0x69, 0x3b, 0x6d, 0x75, 0x73, 0x61, 0x70, 0xed, 0x72, 0x69, 0x3b, 0x69, 0x72, 0x169, 0x64, 0xed, 0x3b, 0x70, 0xfa,
0x3b, 0x70, 0xfa, 0x2d, 0x79, 0x65, 0x70, 0xe9, 0x3b, 0x70, 0xfa, 0x2d, 0x6d, 0x75, 0x6b, 0x169, 0x69, 0x3b, 0x70, 0xfa,
0x2d, 0x6d, 0x75, 0x73, 0x61, 0x70, 0xed, 0x72, 0x69, 0x3b, 0x70, 0xfa, 0x2d, 0x69, 0x72, 0x169, 0x64, 0xed, 0x3b, 0x79,
0x65, 0x70, 0xe9, 0x2d, 0x70, 0x75, 0x74, 0x69, 0x6d, 0x61, 0xe3, 0x3b, 0x79, 0x65, 0x70, 0xe9, 0x2d, 0x79, 0x65, 0x70,
0xe9, 0x3b, 0x79, 0x65, 0x70, 0xe9, 0x2d, 0x6d, 0x75, 0x6b, 0x169, 0x69, 0x3b, 0x59, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x49,
0x3b, 0x50, 0x3b, 0x50, 0x3b, 0x50, 0x3b, 0x50, 0x3b, 0x50, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x4a, 0xe9, 0x6e,
0x3b, 0x46, 0x1eb9, 0x301, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x3b, 0xc9, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a,
0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x1ecc, 0x301, 0x67, 0x1ecd, 0x3b, 0x53, 0x1eb9, 0x70, 0x3b, 0x1ecc, 0x6b, 0x74, 0x3b,
0x4e, 0x1ecd, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0xe9, 0x6e, 0xfa, 0xe1, 0x72, 0x69, 0x3b, 0x46, 0x1eb9, 0x301, 0x62,
0xfa, 0xe1, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x3b, 0xc9, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x65, 0x65, 0x3b,
0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x1ecc, 0x67, 0x1ecd, 0x73, 0x74, 0x3b, 0x53, 0x1eb9, 0x70, 0x74,
0x1eb9, 0x301, 0x6d, 0x62, 0x61, 0x3b, 0x1ecc, 0x6b, 0x74, 0xf3, 0x62, 0x61, 0x3b, 0x4e, 0x1ecd, 0x76, 0x1eb9, 0x301, 0x6d, 0x62,
0x61, 0x3b, 0x44, 0x69, 0x73, 0x1eb9, 0x301, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0xe9, 0x6e, 0x3b, 0x46, 0x1eb9, 0x301, 0x62, 0x3b,
0x4d, 0x61, 0x63, 0x68, 0x3b, 0xc9, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c,
0x3b, 0x1ecc, 0x67, 0x1ecd, 0x3b, 0x53, 0x1eb9, 0x70, 0x3b, 0x1ecc, 0x6b, 0x74, 0x3b, 0x4e, 0x1ecd, 0x76, 0x3b, 0x44, 0x69, 0x73,
0x3b, 0x7d3, 0x7cc, 0x7f2, 0x7e0, 0x3b, 0x7de, 0x7cf, 0x7f2, 0x7de, 0x3b, 0x7d5, 0x7d9, 0x7ca, 0x3b, 0x7de, 0x7cf, 0x7f2, 0x7d8, 0x3b,
0x7d8, 0x7d3, 0x7ca, 0x7ec, 0x7d5, 0x3b, 0x7e5, 0x7ca, 0x7ec, 0x7db, 0x3b, 0x7de, 0x7ca, 0x7ec, 0x7d9, 0x3b, 0x7d8, 0x7d3, 0x7ca, 0x7ec,
0x7d3, 0x3b, 0x7d5, 0x7ce, 0x7df, 0x7ca, 0x7dd, 0x7cc, 0x7f2, 0x3b, 0x7de, 0x7cf, 0x7f2, 0x7d3, 0x3b, 0x7e3, 0x7cd, 0x7e3, 0x3b, 0x7de,
0x7cf, 0x7df, 0x3b, 0x7d3, 0x7cc, 0x7f2, 0x7e0, 0x7ca, 0x7e5, 0x7ce, 0x7df, 0x7cb, 0x7f2, 0x3b, 0x7de, 0x7cf, 0x7f2, 0x7de, 0x7cf, 0x7dc,
0x7cd, 0x3b, 0x7d5, 0x7d9, 0x7ca, 0x7d3, 0x7ca, 0x3b, 0x7de, 0x7cf, 0x7f2, 0x7de, 0x7cf, 0x7d8, 0x7cc, 0x7ec, 0x7d3, 0x7cc, 0x3b, 0x7d8,
0x7d3, 0x7ca, 0x7ec, 0x7d5, 0x7ca, 0x3b, 0x7e5, 0x7ca, 0x7ec, 0x7db, 0x7cc, 0x7ec, 0x7e5, 0x7d9, 0x7ca, 0x3b, 0x7de, 0x7ca, 0x7ec, 0x7d9,
0x7cc, 0x7dd, 0x7d0, 0x7ed, 0x3b, 0x7d8, 0x7d3, 0x7ca, 0x7ec, 0x7d3, 0x7cc, 0x7df, 0x7ca, 0x3b, 0x7d5, 0x7ce, 0x7df, 0x7ca, 0x7dd, 0x7cc,
0x7f2, 0x3b, 0x7de, 0x7cf, 0x7f2, 0x7d3, 0x7cc, 0x7d5, 0x7cc, 0x7ee, 0x3b, 0x7e3, 0x7cd, 0x7e3, 0x7cd, 0x7d3, 0x7ca, 0x3b, 0x7de, 0x7cf,
0x7df, 0x7cc, 0x7f2, 0x7de, 0x7cf, 0x7df, 0x7cc, 0x7f2, 0x3b, 0x7d3, 0x3b, 0x7de, 0x3b, 0x7d5, 0x3b, 0x7de, 0x3b, 0x7d8, 0x3b, 0x7e5,
0x3b, 0x7de, 0x3b, 0x7d8, 0x3b, 0x7d5, 0x3b, 0x7de, 0x3b, 0x7e3, 0x3b, 0x7de, 0x3b, 0x5a, 0x69, 0x62, 0x3b, 0x4e, 0x68, 0x6c,
0x6f, 0x3b, 0x4d, 0x62, 0x69, 0x3b, 0x4d, 0x61, 0x62, 0x3b, 0x4e, 0x6b, 0x77, 0x3b, 0x4e, 0x68, 0x6c, 0x61, 0x3b, 0x4e,
0x74, 0x75, 0x3b, 0x4e, 0x63, 0x77, 0x3b, 0x4d, 0x70, 0x61, 0x6e, 0x3b, 0x4d, 0x66, 0x75, 0x3b, 0x4c, 0x77, 0x65, 0x3b,
0x4d, 0x70, 0x61, 0x6c, 0x3b, 0x5a, 0x69, 0x62, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x6c, 0x61, 0x3b, 0x4e, 0x68, 0x6c, 0x6f,
0x6c, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x4d, 0x62, 0x69, 0x6d, 0x62, 0x69, 0x74, 0x68, 0x6f, 0x3b, 0x4d, 0x61, 0x62, 0x61,
0x73, 0x61, 0x3b, 0x4e, 0x6b, 0x77, 0x65, 0x6e, 0x6b, 0x77, 0x65, 0x7a, 0x69, 0x3b, 0x4e, 0x68, 0x6c, 0x61, 0x6e, 0x67,
0x75, 0x6c, 0x61, 0x3b, 0x4e, 0x74, 0x75, 0x6c, 0x69, 0x6b, 0x61, 0x7a, 0x69, 0x3b, 0x4e, 0x63, 0x77, 0x61, 0x62, 0x61,
0x6b, 0x61, 0x7a, 0x69, 0x3b, 0x4d, 0x70, 0x61, 0x6e, 0x64, 0x75, 0x6c, 0x61, 0x3b, 0x4d, 0x66, 0x75, 0x6d, 0x66, 0x75,
0x3b, 0x4c, 0x77, 0x65, 0x7a, 0x69, 0x3b, 0x4d, 0x70, 0x61, 0x6c, 0x61, 0x6b, 0x61, 0x7a, 0x69, 0x3b, 0x5a, 0x3b, 0x4e,
0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4c, 0x3b, 0x4d,
0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69,
0x3b, 0x4a, 0xfc, 0x6e, 0x3b, 0x4a, 0xfc, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74,
0x3b, 0x4e, 0x6f, 0x66, 0x3b, 0x44, 0x65, 0x74, 0x3b, 0x4a, 0x61, 0x6e, 0x65, 0x77, 0x6f, 0x6f, 0x72, 0x65, 0x3b, 0x46,
0x65, 0x62, 0x72, 0x65, 0x77, 0x6f, 0x6f, 0x72, 0x65, 0x3b, 0x4d, 0x61, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x41, 0x70, 0x72,
0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0xfc, 0xfc, 0x6e, 0x65, 0x3b, 0x4a, 0xfc, 0xfc, 0x6c, 0x65, 0x3b, 0x41,
0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x75,
0x75, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x66, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x74, 0x73, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x62c, 0x627, 0x646, 0x6a4, 0x6cc, 0x6d5, 0x3b, 0x641, 0x626, 0x6a4, 0x631, 0x6cc, 0x6d5, 0x3b, 0x645, 0x627,
0x631, 0x633, 0x3b, 0x622, 0x6a4, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x626, 0x6cc, 0x3b, 0x62c, 0x648, 0x659, 0x623, 0x646, 0x3b, 0x62c,
0x648, 0x659, 0x644, 0x627, 0x3b, 0x622, 0x6af, 0x648, 0x633, 0x62a, 0x3b, 0x633, 0x626, 0x67e, 0x62a, 0x627, 0x645, 0x631, 0x3b, 0x626,
0x648, 0x6a9, 0x62a, 0x648, 0x6a4, 0x631, 0x3b, 0x646, 0x648, 0x6a4, 0x627, 0x645, 0x631, 0x3b, 0x62f, 0x626, 0x633, 0x627, 0x645, 0x631,
0x3b, 0x6f, 0x111, 0x111, 0x6a, 0x3b, 0x67, 0x75, 0x6f, 0x76, 0x3b, 0x6e, 0x6a, 0x75, 0x6b, 0x3b, 0x63, 0x75, 0x6f, 0x3b,
0x6d, 0x69, 0x65, 0x73, 0x3b, 0x67, 0x65, 0x61, 0x73, 0x3b, 0x73, 0x75, 0x6f, 0x69, 0x3b, 0x62, 0x6f, 0x72, 0x67, 0x3b,
0x10d, 0x61, 0x6b, 0x10d, 0x3b, 0x67, 0x6f, 0x6c, 0x67, 0x3b, 0x73, 0x6b, 0xe1, 0x62, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x3b,
0x6f, 0x111, 0x111, 0x61, 0x6a, 0x61, 0x67, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x67, 0x75, 0x6f, 0x76, 0x76, 0x61,
0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x6e, 0x6a, 0x75, 0x6b, 0x10d, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x63, 0x75,
0x6f, 0x14b, 0x6f, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x6d, 0x69, 0x65, 0x73, 0x73, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75,
0x3b, 0x67, 0x65, 0x61, 0x73, 0x73, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x73, 0x75, 0x6f, 0x69, 0x64, 0x6e, 0x65,
0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x62, 0x6f, 0x72, 0x67, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x10d, 0x61, 0x6b,
0x10d, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x67, 0x6f, 0x6c, 0x67, 0x67, 0x6f, 0x74, 0x6d, 0xe1, 0x6e, 0x6e, 0x75,
0x3b, 0x73, 0x6b, 0xe1, 0x62, 0x6d, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x6c, 0x61, 0x6d,
0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x4f, 0x3b, 0x47, 0x3b, 0x4e, 0x3b, 0x43, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x42,
0x3b, 0x10c, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x4a, 0x3b, 0x6f, 0x111, 0x111, 0x6a, 0x3b, 0x67, 0x75, 0x6f, 0x76, 0x3b, 0x6e,
0x6a, 0x75, 0x6b, 0x3b, 0x63, 0x75, 0x6f, 0x14b, 0x3b, 0x6d, 0x69, 0x65, 0x73, 0x3b, 0x67, 0x65, 0x61, 0x73, 0x3b, 0x73,
0x75, 0x6f, 0x69, 0x3b, 0x62, 0x6f, 0x72, 0x67, 0x3b, 0x10d, 0x61, 0x6b, 0x10d, 0x3b, 0x67, 0x6f, 0x6c, 0x67, 0x3b, 0x73,
0x6b, 0xe1, 0x62, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x3b, 0x50, 0x68, 0x65, 0x72, 0x65, 0x3b, 0x44, 0x69, 0x62, 0x6f, 0x3b,
0x48, 0x6c, 0x61, 0x6b, 0x3b, 0x4d, 0x6f, 0x72, 0x61, 0x3b, 0x4d, 0x6f, 0x70, 0x69, 0x3b, 0x50, 0x68, 0x75, 0x70, 0x75,
0x3b, 0x4d, 0x6f, 0x73, 0x65, 0x3b, 0x50, 0x68, 0x61, 0x74, 0x6f, 0x3b, 0x4c, 0x65, 0x77, 0x65, 0x3b, 0x44, 0x69, 0x70,
0x68, 0x61, 0x3b, 0x44, 0x69, 0x62, 0x61, 0x3b, 0x4d, 0x61, 0x6e, 0x74, 0x68, 0x3b, 0x50, 0x68, 0x65, 0x72, 0x65, 0x6b,
0x67, 0x6f, 0x6e, 0x67, 0x3b, 0x44, 0x69, 0x62, 0x6f, 0x6b, 0x77, 0x61, 0x6e, 0x65, 0x3b, 0x48, 0x6c, 0x61, 0x6b, 0x6f,
0x6c, 0x61, 0x3b, 0x4d, 0x6f, 0x72, 0x61, 0x6e, 0x61, 0x6e, 0x67, 0x3b, 0x4d, 0x6f, 0x70, 0x69, 0x74, 0x6c, 0x6f, 0x3b,
0x50, 0x68, 0x75, 0x70, 0x75, 0x3b, 0x4d, 0x6f, 0x73, 0x65, 0x67, 0x65, 0x6d, 0x61, 0x6e, 0x79, 0x65, 0x3b, 0x50, 0x68,
0x61, 0x74, 0x6f, 0x3b, 0x4c, 0x65, 0x77, 0x65, 0x64, 0x69, 0x3b, 0x44, 0x69, 0x70, 0x68, 0x61, 0x6c, 0x61, 0x6e, 0x65,
0x3b, 0x44, 0x69, 0x62, 0x61, 0x74, 0x73, 0x65, 0x6c, 0x61, 0x3b, 0x4d, 0x61, 0x6e, 0x74, 0x68, 0x6f, 0x6c, 0x65, 0x3b,
0x50, 0x3b, 0x44, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x50, 0x3b, 0x4d, 0x3b, 0x50, 0x3b, 0x4c, 0x3b, 0x44, 0x3b,
0x44, 0x3b, 0x4d, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d,
0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a,
0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65,
0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72,
0x73, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69,
0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e,
0x3b, 0x64, 0x65, 0x73, 0x2e, 0x3b, 0x54, 0x69, 0x6f, 0x70, 0x3b, 0x50, 0x25b, 0x74, 0x3b, 0x44, 0x75, 0x254, 0x331, 0x254,
0x331, 0x3b, 0x47, 0x75, 0x61, 0x6b, 0x3b, 0x44, 0x75, 0xe4, 0x3b, 0x4b, 0x6f, 0x72, 0x3b, 0x50, 0x61, 0x79, 0x3b, 0x54,
0x68, 0x6f, 0x6f, 0x3b, 0x54, 0x25b, 0x25b, 0x3b, 0x4c, 0x61, 0x61, 0x3b, 0x4b, 0x75, 0x72, 0x3b, 0x54, 0x69, 0x64, 0x3b,
0x54, 0x69, 0x6f, 0x70, 0x20, 0x74, 0x68, 0x61, 0x72, 0x20, 0x70, 0x25b, 0x74, 0x3b, 0x50, 0x25b, 0x74, 0x3b, 0x44, 0x75,
0x254, 0x331, 0x254, 0x331, 0x14b, 0x3b, 0x47, 0x75, 0x61, 0x6b, 0x3b, 0x44, 0x75, 0xe4, 0x74, 0x3b, 0x4b, 0x6f, 0x72, 0x6e,
0x79, 0x6f, 0x6f, 0x74, 0x3b, 0x50, 0x61, 0x79, 0x20, 0x79, 0x69, 0x65, 0x331, 0x74, 0x6e, 0x69, 0x3b, 0x54, 0x68, 0x6f,
0x331, 0x6f, 0x331, 0x72, 0x3b, 0x54, 0x25b, 0x25b, 0x72, 0x3b, 0x4c, 0x61, 0x61, 0x74, 0x68, 0x3b, 0x4b, 0x75, 0x72, 0x3b,
0x54, 0x69, 0x6f, 0x331, 0x70, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x69, 0x331, 0x69, 0x331, 0x74, 0x3b, 0x54, 0x3b, 0x50, 0x3b,
0x44, 0x3b, 0x47, 0x3b, 0x44, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x54, 0x3b,
0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x6c, 0x3b, 0x45, 0x70, 0x75, 0x3b, 0x4d, 0x65, 0x69, 0x3b,
0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x4f, 0x67, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x75, 0x3b,
0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x77, 0x61, 0x6c, 0x65, 0x3b, 0x46, 0x65, 0x62,
0x75, 0x6c, 0x75, 0x77, 0x61, 0x6c, 0x65, 0x3b, 0x4d, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x3b, 0x45, 0x70, 0x75, 0x6c,
0x6f, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x4f, 0x67, 0x61,
0x73, 0x69, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x75, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x75, 0x74, 0x6f,
0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x67,
0x65, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x6d,
0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x68, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x67, 0x6f, 0x2e, 0x3b, 0x73, 0x65,
0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x67, 0x65,
0x6e, 0x69, 0xe8, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x69, 0xe8, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x61, 0x62,
0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x68, 0x3b, 0x6a, 0x75, 0x6c, 0x68, 0x65, 0x74, 0x3b,
0x61, 0x67, 0x6f, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0xf2, 0x62,
0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x65,
0x3b, 0x47, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f,
0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x64, 0x65, 0x20, 0x67, 0x65, 0x6e, 0x69, 0xe8, 0x72, 0x3b, 0x64, 0x65, 0x20, 0x66, 0x65,
0x62, 0x72, 0x69, 0xe8, 0x72, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x64, 0x2019, 0x61, 0x62, 0x72, 0x69,
0x6c, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x69, 0x3b, 0x64, 0x65, 0x20, 0x6a, 0x75, 0x6e, 0x68, 0x3b, 0x64, 0x65, 0x20,
0x6a, 0x75, 0x6c, 0x68, 0x65, 0x74, 0x3b, 0x64, 0x2019, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x3b, 0x64, 0x65, 0x20, 0x73, 0x65,
0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x2019, 0x6f, 0x63, 0x74, 0xf2, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x20,
0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x20, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x65,
0x3b, 0x67, 0xe8, 0x72, 0x3b, 0x68, 0x65, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x62, 0x72, 0x3b, 0x6d, 0x61, 0x69,
0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x72, 0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x3b, 0x6f, 0x63, 0x74,
0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x67, 0xe8, 0x72, 0x3b, 0x68, 0x65, 0x72, 0x65, 0x75, 0xe8, 0x72,
0x3b, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x75, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x68,
0x3b, 0x6a, 0x75, 0x72, 0x69, 0xf2, 0x6c, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x65,
0x3b, 0x6f, 0x63, 0x74, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x3b, 0x64, 0x65, 0x73, 0x65,
0x6d, 0x65, 0x3b, 0x47, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53,
0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0xb1c, 0xb3e, 0xb28, 0xb41, 0xb06, 0xb30, 0xb40, 0x3b, 0xb2b, 0xb47, 0xb2c, 0xb43, 0xb06,
0xb30, 0xb40, 0x3b, 0xb2e, 0xb3e, 0xb30, 0xb4d, 0xb1a, 0xb4d, 0xb1a, 0x3b, 0xb05, 0xb2a, 0xb4d, 0xb30, 0xb47, 0xb32, 0x3b, 0xb2e, 0xb07,
0x3b, 0xb1c, 0xb41, 0xb28, 0x3b, 0xb1c, 0xb41, 0xb32, 0xb3e, 0xb07, 0x3b, 0xb05, 0xb17, 0xb37, 0xb4d, 0xb1f, 0x3b, 0xb38, 0xb47, 0xb2a,
0xb4d, 0xb1f, 0xb47, 0xb2e, 0xb4d, 0xb2c, 0xb30, 0x3b, 0xb05, 0xb15, 0xb4d, 0xb1f, 0xb4b, 0xb2c, 0xb30, 0x3b, 0xb28, 0xb2d, 0xb47, 0xb2e,
0xb4d, 0xb2c, 0xb30, 0x3b, 0xb21, 0xb3f, 0xb38, 0xb47, 0xb2e, 0xb4d, 0xb2c, 0xb30, 0x3b, 0xb1c, 0xb3e, 0x3b, 0xb2b, 0xb47, 0x3b, 0xb2e,
0xb3e, 0x3b, 0xb05, 0x3b, 0xb2e, 0xb07, 0x3b, 0xb1c, 0xb41, 0x3b, 0xb1c, 0xb41, 0x3b, 0xb05, 0x3b, 0xb38, 0xb47, 0x3b, 0xb05, 0x3b,
0xb28, 0x3b, 0xb21, 0xb3f, 0x3b, 0x41, 0x6d, 0x61, 0x3b, 0x47, 0x75, 0x72, 0x3b, 0x42, 0x69, 0x74, 0x3b, 0x45, 0x6c, 0x62,
0x3b, 0x43, 0x61, 0x6d, 0x3b, 0x57, 0x61, 0x78, 0x3b, 0x41, 0x64, 0x6f, 0x3b, 0x48, 0x61, 0x67, 0x3b, 0x46, 0x75, 0x6c,
0x3b, 0x4f, 0x6e, 0x6b, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x4d, 0x75, 0x64, 0x3b, 0x41, 0x6d, 0x61, 0x6a, 0x6a, 0x69, 0x69,
0x3b, 0x47, 0x75, 0x72, 0x61, 0x61, 0x6e, 0x64, 0x68, 0x61, 0x6c, 0x61, 0x3b, 0x42, 0x69, 0x74, 0x6f, 0x6f, 0x74, 0x65,
0x65, 0x73, 0x73, 0x61, 0x3b, 0x45, 0x6c, 0x62, 0x61, 0x3b, 0x43, 0x61, 0x61, 0x6d, 0x73, 0x61, 0x3b, 0x57, 0x61, 0x78,
0x61, 0x62, 0x61, 0x6a, 0x6a, 0x69, 0x69, 0x3b, 0x41, 0x64, 0x6f, 0x6f, 0x6c, 0x65, 0x65, 0x73, 0x73, 0x61, 0x3b, 0x48,
0x61, 0x67, 0x61, 0x79, 0x79, 0x61, 0x3b, 0x46, 0x75, 0x75, 0x6c, 0x62, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6e, 0x6b, 0x6f,
0x6c, 0x6f, 0x6c, 0x65, 0x65, 0x73, 0x73, 0x61, 0x3b, 0x53, 0x61, 0x64, 0x61, 0x61, 0x73, 0x61, 0x3b, 0x4d, 0x75, 0x64,
0x64, 0x65, 0x65, 0x3b, 0x41, 0x3b, 0x47, 0x3b, 0x42, 0x3b, 0x45, 0x3b, 0x43, 0x3b, 0x57, 0x3b, 0x41, 0x3b, 0x48, 0x3b,
0x46, 0x3b, 0x4f, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0xd801, 0xdcc4, 0xd801, 0xdcd8, 0xd801, 0xdce1, 0xd801, 0xdcdb, 0x358, 0xd801, 0xdce7, 0xd801,
0xdcdf, 0x3b, 0xd801, 0xdcf5, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x3b, 0xd801, 0xdcf5, 0xd801, 0xdcd8, 0xd801, 0xdcdc, 0xd801, 0xdce3,
0x3b, 0xd801, 0xdcf0, 0xd801, 0xdcea, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x3b, 0xd801, 0xdcee, 0xd801, 0xdcd8, 0xd801, 0xdcf0, 0xd801, 0xdcd8, 0x3b, 0xd801,
0xdcef, 0xd801, 0xdcd8, 0xd801, 0xdcec, 0xd801, 0xdcdf, 0x3b, 0xd801, 0xdcc4, 0xd801, 0xdcdf, 0xd801, 0xdcf5, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec, 0xd801,
0xdcd8, 0x3b, 0xd801, 0xdcbc, 0xd801, 0xdce3, 0xd801, 0xdcdf, 0xd801, 0xdcf0, 0xd801, 0xdcea, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x3b, 0xd801, 0xdcbf, 0xd801,
0xdcdf, 0xd801, 0xdcdc, 0xd801, 0xdcdb, 0xd801, 0xdcf2, 0xd801, 0xdcdf, 0xd801, 0xdcf7, 0xd801, 0xdce3, 0x358, 0xd801, 0xdce4, 0xd801, 0xdcdf, 0x3b, 0xd801,
0xdcbf, 0xd801, 0xdcdf, 0xd801, 0xdcdc, 0xd801, 0xdcdb, 0x3b, 0xd801, 0xdcb0, 0xd801, 0xdce7, 0xd801, 0xdce3, 0x20, 0xd801, 0xdccf, 0xd801, 0xdce3, 0x358,
0xd801, 0xdcf8, 0xd801, 0xdcf2, 0xd801, 0xdce3, 0x3b, 0xd801, 0xdcb0, 0xd801, 0xdce7, 0xd801, 0xdce3, 0x20, 0xd801, 0xdccd, 0xd801, 0xdcea, 0x358, 0xd801,
0xdcec, 0xd801, 0xdcd8, 0x3b, 0xd801, 0xdcc0, 0xd801, 0xdce3, 0x358, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdcc4, 0xd801,
0xdcd8, 0xd801, 0xdce1, 0xd801, 0xdcdb, 0x358, 0xd801, 0xdce7, 0xd801, 0xdcdf, 0x3b, 0xd801, 0xdcc0, 0xd801, 0xdce3, 0x358, 0xd801, 0xdcea, 0x358, 0xd801,
0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdccf, 0xd801, 0xdcdf, 0xd801, 0xdcf5, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x3b, 0xd801, 0xdcc0,
0xd801, 0xdce3, 0x358, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdccf, 0xd801, 0xdcdf, 0xd801, 0xdcf5, 0xd801, 0xdcd8, 0xd801,
0xdcdc, 0xd801, 0xdce3, 0x3b, 0xd801, 0xdcc0, 0xd801, 0xdce3, 0x358, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdccf, 0xd801,
0xdcdf, 0xd801, 0xdcf0, 0xd801, 0xdcea, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x3b, 0xd801, 0xdcc0, 0xd801, 0xdce3, 0x358, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec,
0xd801, 0xdcd8, 0x20, 0xd801, 0xdccf, 0xd801, 0xdcdf, 0xd801, 0xdcee, 0xd801, 0xdcd8, 0xd801, 0xdcf0, 0xd801, 0xdcd8, 0x3b, 0xd801, 0xdcc0, 0xd801, 0xdce3,
0x358, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdccf, 0xd801, 0xdcdf, 0xd801, 0xdcef, 0xd801, 0xdcd8, 0xd801, 0xdcec, 0xd801,
0xdcdf, 0x3b, 0xd801, 0xdcc0, 0xd801, 0xdce3, 0x358, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdcc4, 0xd801, 0xdcdf, 0xd801,
0xdcf5, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x3b, 0xd801, 0xdcc0, 0xd801, 0xdce3, 0x358, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec, 0xd801,
0xdcd8, 0x20, 0xd801, 0xdcbc, 0xd801, 0xdce3, 0xd801, 0xdcdf, 0xd801, 0xdcf0, 0xd801, 0xdcea, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x3b, 0xd801, 0xdcc0, 0xd801,
0xdce3, 0x358, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdcbf, 0xd801, 0xdcdf, 0xd801, 0xdcdc, 0xd801, 0xdcdb, 0xd801, 0xdcf2,
0xd801, 0xdcdf, 0xd801, 0xdcf7, 0xd801, 0xdce3, 0x358, 0xd801, 0xdce4, 0xd801, 0xdcdf, 0x3b, 0xd801, 0xdcc0, 0xd801, 0xdce3, 0x358, 0xd801, 0xdcea, 0x358,
0xd801, 0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdcbf, 0xd801, 0xdcdf, 0xd801, 0xdcdc, 0xd801, 0xdcdb, 0x3b, 0xd801, 0xdcc0, 0xd801, 0xdce3, 0x358, 0xd801,
0xdcea, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdcb0, 0xd801, 0xdce7, 0xd801, 0xdce3, 0x20, 0xd801, 0xdccf, 0xd801, 0xdce3, 0x358, 0xd801,
0xdcf8, 0xd801, 0xdcf2, 0xd801, 0xdce3, 0x3b, 0xd801, 0xdcc0, 0xd801, 0xdce3, 0x358, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801,
0xdcb0, 0xd801, 0xdce7, 0xd801, 0xdce3, 0x20, 0xd801, 0xdccd, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x3b, 0x42f, 0x43d, 0x432, 0x2e,
0x3b, 0x424, 0x435, 0x432, 0x440, 0x2e, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x2e, 0x3b, 0x410, 0x43f, 0x440, 0x2e, 0x3b, 0x41c, 0x430,
0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x44c, 0x3b, 0x418, 0x44e, 0x43b, 0x44c, 0x3b, 0x410, 0x432, 0x433, 0x2e, 0x3b, 0x421, 0x435, 0x43d,
0x442, 0x2e, 0x3b, 0x41e, 0x43a, 0x442, 0x2e, 0x3b, 0x41d, 0x43e, 0x44f, 0x431, 0x2e, 0x3b, 0x414, 0x435, 0x43a, 0x2e, 0x3b, 0x42f,
0x43d, 0x432, 0x430, 0x440, 0x44c, 0x3b, 0x424, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44c, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x44a, 0x438,
0x3b, 0x410, 0x43f, 0x440, 0x435, 0x43b, 0x44c, 0x3b, 0x41c, 0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x44c, 0x3b, 0x418, 0x44e, 0x43b,
0x44c, 0x3b, 0x410, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x421, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x41e, 0x43a,
0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x41d, 0x43e, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x414, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44c,
0x3b, 0x44f, 0x43d, 0x432, 0x2e, 0x3b, 0x444, 0x435, 0x432, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x2e, 0x3b, 0x430, 0x43f, 0x440, 0x2e,
0x3b, 0x43c, 0x430, 0x439, 0x44b, 0x3b, 0x438, 0x44e, 0x43d, 0x44b, 0x3b, 0x438, 0x44e, 0x43b, 0x44b, 0x3b, 0x430, 0x432, 0x433, 0x2e,
0x3b, 0x441, 0x435, 0x43d, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x44f, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e,
0x3b, 0x44f, 0x43d, 0x432, 0x430, 0x440, 0x44b, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44b, 0x3b, 0x43c, 0x430, 0x440, 0x442,
0x44a, 0x438, 0x439, 0x44b, 0x3b, 0x430, 0x43f, 0x440, 0x435, 0x43b, 0x44b, 0x3b, 0x43c, 0x430, 0x439, 0x44b, 0x3b, 0x438, 0x44e, 0x43d,
0x44b, 0x3b, 0x438, 0x44e, 0x43b, 0x44b, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x44b, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x44f,
0x431, 0x440, 0x44b, 0x3b, 0x43e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x44b, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x440, 0x44b, 0x3b, 0x434,
0x435, 0x43a, 0x430, 0x431, 0x440, 0x44b, 0x3b, 0x59, 0x61, 0x6e, 0xfc, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0xfc,
0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x59,
0xfc, 0x6e, 0x69, 0x3b, 0x59, 0xfc, 0x6c, 0x69, 0x3b, 0x4f, 0x75, 0x67, 0xf9, 0x73, 0x74, 0xf9, 0x73, 0x3b, 0x53, 0xe8,
0x70, 0x74, 0xe8, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0xd2, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0xe8,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x73, 0xe8, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x64a, 0x3b,
0x641, 0x628, 0x631, 0x648, 0x631, 0x64a, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cd,
0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x6cc, 0x3b, 0x627, 0x6ab, 0x633, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x645,
0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628,
0x631, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x64a, 0x3b, 0x641, 0x6d0, 0x628, 0x631, 0x648, 0x631, 0x64a, 0x3b, 0x645, 0x627, 0x631, 0x686,
0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cd, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x6cc, 0x3b,
0x627, 0x6ab, 0x633, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646,
0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x64a, 0x3b, 0x641, 0x628, 0x631,
0x648, 0x631, 0x64a, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cd, 0x3b, 0x62c, 0x648,
0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x6cc, 0x3b, 0x627, 0x6ab, 0x633, 0x62a, 0x3b, 0x633, 0x6d0, 0x67e, 0x62a, 0x645, 0x628, 0x631,
0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b,
0x62c, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x627, 0x3b, 0x645, 0x3b, 0x62c, 0x3b, 0x62c, 0x3b, 0x627, 0x3b, 0x633, 0x3b, 0x627, 0x3b,
0x646, 0x3b, 0x62f, 0x3b, 0x698, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x622, 0x3b, 0x645, 0x3b, 0x698, 0x3b, 0x698, 0x3b, 0x627, 0x3b,
0x633, 0x3b, 0x627, 0x3b, 0x646, 0x3b, 0x62f, 0x3b, 0x698, 0x627, 0x646, 0x648, 0x6cc, 0x647, 0x654, 0x3b, 0x641, 0x648, 0x631, 0x6cc,
0x647, 0x654, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x622, 0x648, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x647, 0x654, 0x3b, 0x698, 0x648,
0x626, 0x646, 0x3b, 0x698, 0x648, 0x626, 0x6cc, 0x647, 0x654, 0x3b, 0x627, 0x648, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x627, 0x645, 0x628,
0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x627, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x627, 0x645, 0x628,
0x631, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x6cc, 0x3b, 0x641, 0x628, 0x631, 0x648, 0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b,
0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x6cc, 0x3b, 0x627,
0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648,
0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x62c, 0x646, 0x648, 0x3b, 0x641, 0x628, 0x631, 0x648, 0x631, 0x6cc,
0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c,
0x648, 0x644, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628,
0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x65, 0x3b,
0x46, 0x65, 0x62, 0x75, 0x61, 0x72, 0x65, 0x3b, 0x4d, 0x61, 0x73, 0x3b, 0x45, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x65,
0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x65, 0x3b, 0x4f, 0x67, 0x75, 0x73, 0x3b, 0x53, 0x65, 0x70,
0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61,
0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x73, 0x74, 0x79, 0x3b, 0x6c, 0x75, 0x74, 0x3b, 0x6d, 0x61, 0x72,
0x3b, 0x6b, 0x77, 0x69, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x63, 0x7a, 0x65, 0x3b, 0x6c, 0x69, 0x70, 0x3b, 0x73, 0x69, 0x65,
0x3b, 0x77, 0x72, 0x7a, 0x3b, 0x70, 0x61, 0x17a, 0x3b, 0x6c, 0x69, 0x73, 0x3b, 0x67, 0x72, 0x75, 0x3b, 0x73, 0x74, 0x79,
0x63, 0x7a, 0x65, 0x144, 0x3b, 0x6c, 0x75, 0x74, 0x79, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x65, 0x63, 0x3b, 0x6b, 0x77, 0x69,
0x65, 0x63, 0x69, 0x65, 0x144, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x63, 0x7a, 0x65, 0x72, 0x77, 0x69, 0x65, 0x63, 0x3b, 0x6c,
0x69, 0x70, 0x69, 0x65, 0x63, 0x3b, 0x73, 0x69, 0x65, 0x72, 0x70, 0x69, 0x65, 0x144, 0x3b, 0x77, 0x72, 0x7a, 0x65, 0x73,
0x69, 0x65, 0x144, 0x3b, 0x70, 0x61, 0x17a, 0x64, 0x7a, 0x69, 0x65, 0x72, 0x6e, 0x69, 0x6b, 0x3b, 0x6c, 0x69, 0x73, 0x74,
0x6f, 0x70, 0x61, 0x64, 0x3b, 0x67, 0x72, 0x75, 0x64, 0x7a, 0x69, 0x65, 0x144, 0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b,
0x4b, 0x3b, 0x4d, 0x3b, 0x43, 0x3b, 0x4c, 0x3b, 0x53, 0x3b, 0x57, 0x3b, 0x50, 0x3b, 0x4c, 0x3b, 0x47, 0x3b, 0x73, 0x74,
0x79, 0x63, 0x7a, 0x6e, 0x69, 0x61, 0x3b, 0x6c, 0x75, 0x74, 0x65, 0x67, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x63, 0x61, 0x3b,
0x6b, 0x77, 0x69, 0x65, 0x74, 0x6e, 0x69, 0x61, 0x3b, 0x6d, 0x61, 0x6a, 0x61, 0x3b, 0x63, 0x7a, 0x65, 0x72, 0x77, 0x63,
0x61, 0x3b, 0x6c, 0x69, 0x70, 0x63, 0x61, 0x3b, 0x73, 0x69, 0x65, 0x72, 0x70, 0x6e, 0x69, 0x61, 0x3b, 0x77, 0x72, 0x7a,
0x65, 0x15b, 0x6e, 0x69, 0x61, 0x3b, 0x70, 0x61, 0x17a, 0x64, 0x7a, 0x69, 0x65, 0x72, 0x6e, 0x69, 0x6b, 0x61, 0x3b, 0x6c,
0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x61, 0x3b, 0x67, 0x72, 0x75, 0x64, 0x6e, 0x69, 0x61, 0x3b, 0x73, 0x3b, 0x6c,
0x3b, 0x6d, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x63, 0x3b, 0x6c, 0x3b, 0x73, 0x3b, 0x77, 0x3b, 0x70, 0x3b, 0x6c, 0x3b, 0x67,
0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x76, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x62, 0x72, 0x2e,
0x3b, 0x6d, 0x61, 0x69, 0x2e, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x67, 0x6f, 0x2e,
0x3b, 0x73, 0x65, 0x74, 0x2e, 0x3b, 0x6f, 0x75, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x7a, 0x2e,
0x3b, 0x6a, 0x61, 0x6e, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x66, 0x65, 0x76, 0x65, 0x72, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x6d,
0x61, 0x72, 0xe7, 0x6f, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6e, 0x68,
0x6f, 0x3b, 0x6a, 0x75, 0x6c, 0x68, 0x6f, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x65, 0x6d,
0x62, 0x72, 0x6f, 0x3b, 0x6f, 0x75, 0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f,
0x3b, 0x64, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x72, 0x61, 0x67, 0x3b, 0x77, 0x61, 0x73, 0x3b, 0x70, 0x16b,
0x6c, 0x3b, 0x73, 0x61, 0x6b, 0x3b, 0x7a, 0x61, 0x6c, 0x3b, 0x73, 0x12b, 0x6d, 0x3b, 0x6c, 0x12b, 0x70, 0x3b, 0x64, 0x61,
0x67, 0x3b, 0x73, 0x69, 0x6c, 0x3b, 0x73, 0x70, 0x61, 0x3b, 0x6c, 0x61, 0x70, 0x3b, 0x73, 0x61, 0x6c, 0x3b, 0x72, 0x61,
0x67, 0x73, 0x3b, 0x77, 0x61, 0x73, 0x73, 0x61, 0x72, 0x69, 0x6e, 0x73, 0x3b, 0x70, 0x16b, 0x6c, 0x69, 0x73, 0x3b, 0x73,
0x61, 0x6b, 0x6b, 0x69, 0x73, 0x3b, 0x7a, 0x61, 0x6c, 0x6c, 0x61, 0x77, 0x73, 0x3b, 0x73, 0x12b, 0x6d, 0x65, 0x6e, 0x69,
0x73, 0x3b, 0x6c, 0x12b, 0x70, 0x61, 0x3b, 0x64, 0x61, 0x67, 0x67, 0x69, 0x73, 0x3b, 0x73, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
0x73, 0x3b, 0x73, 0x70, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x73, 0x3b, 0x6c, 0x61, 0x70, 0x6b, 0x72, 0x16b, 0x74, 0x69, 0x73,
0x3b, 0x73, 0x61, 0x6c, 0x6c, 0x61, 0x77, 0x73, 0x3b, 0x52, 0x3b, 0x57, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x5a, 0x3b, 0x53,
0x3b, 0x4c, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x53, 0x3b, 0xa1c, 0xa28, 0x3b, 0xa2b, 0xa3c, 0xa30, 0x3b,
0xa2e, 0xa3e, 0xa30, 0xa1a, 0x3b, 0xa05, 0xa2a, 0xa4d, 0xa30, 0xa48, 0x3b, 0xa2e, 0xa08, 0x3b, 0xa1c, 0xa42, 0xa28, 0x3b, 0xa1c, 0xa41,
0xa32, 0xa3e, 0x3b, 0xa05, 0xa17, 0x3b, 0xa38, 0xa24, 0xa70, 0x3b, 0xa05, 0xa15, 0xa24, 0xa42, 0x3b, 0xa28, 0xa35, 0xa70, 0x3b, 0xa26,
0xa38, 0xa70, 0x3b, 0xa1c, 0xa28, 0xa35, 0xa30, 0xa40, 0x3b, 0xa2b, 0xa3c, 0xa30, 0xa35, 0xa30, 0xa40, 0x3b, 0xa2e, 0xa3e, 0xa30, 0xa1a,
0x3b, 0xa05, 0xa2a, 0xa4d, 0xa30, 0xa48, 0xa32, 0x3b, 0xa2e, 0xa08, 0x3b, 0xa1c, 0xa42, 0xa28, 0x3b, 0xa1c, 0xa41, 0xa32, 0xa3e, 0xa08,
0x3b, 0xa05, 0xa17, 0xa38, 0xa24, 0x3b, 0xa38, 0xa24, 0xa70, 0xa2c, 0xa30, 0x3b, 0xa05, 0xa15, 0xa24, 0xa42, 0xa2c, 0xa30, 0x3b, 0xa28,
0xa35, 0xa70, 0xa2c, 0xa30, 0x3b, 0xa26, 0xa38, 0xa70, 0xa2c, 0xa30, 0x3b, 0xa1c, 0x3b, 0xa2b, 0xa3c, 0x3b, 0xa2e, 0xa3e, 0x3b, 0xa05,
0x3b, 0xa2e, 0x3b, 0xa1c, 0xa42, 0x3b, 0xa1c, 0xa41, 0x3b, 0xa05, 0x3b, 0xa38, 0x3b, 0xa05, 0x3b, 0xa28, 0x3b, 0xa26, 0x3b, 0x62c,
0x646, 0x648, 0x631, 0x6cc, 0x3b, 0x641, 0x631, 0x648, 0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc,
0x644, 0x3b, 0x645, 0x626, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x626, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a,
0x3b, 0x633, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b,
0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x45, 0x6e, 0x65, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62,
0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65,
0x74, 0x3b, 0x4f, 0x63, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x63, 0x3b, 0x45, 0x6e, 0x65, 0x72, 0x6f, 0x3b,
0x46, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b,
0x4d, 0x61, 0x79, 0x6f, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x6f, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x6f, 0x3b, 0x41, 0x67, 0x6f,
0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x4f, 0x63, 0x74, 0x75, 0x62, 0x72,
0x65, 0x3b, 0x4e, 0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x44, 0x69, 0x63, 0x69, 0x65, 0x6d, 0x62, 0x72,
0x65, 0x3b, 0x69, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72,
0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x69, 0x75, 0x6e, 0x2e, 0x3b, 0x69, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e,
0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63,
0x2e, 0x3b, 0x69, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x65,
0x3b, 0x6d, 0x61, 0x72, 0x74, 0x69, 0x65, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x65, 0x3b, 0x6d, 0x61, 0x69, 0x3b,
0x69, 0x75, 0x6e, 0x69, 0x65, 0x3b, 0x69, 0x75, 0x6c, 0x69, 0x65, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73,
0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x6f, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b,
0x6e, 0x6f, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b,
0x49, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b,
0x4e, 0x3b, 0x44, 0x3b, 0x73, 0x63, 0x68, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72,
0x73, 0x3b, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x74, 0x67, 0x3b, 0x7a, 0x65, 0x72, 0x63, 0x6c, 0x2e, 0x3b, 0x66,
0x61, 0x6e, 0x2e, 0x3b, 0x61, 0x76, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e,
0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x73, 0x63, 0x68, 0x61, 0x6e, 0x65, 0x72, 0x3b, 0x66,
0x61, 0x76, 0x72, 0x65, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x69, 0x67, 0x6c, 0x3b, 0x6d, 0x61,
0x74, 0x67, 0x3b, 0x7a, 0x65, 0x72, 0x63, 0x6c, 0x61, 0x64, 0x75, 0x72, 0x3b, 0x66, 0x61, 0x6e, 0x61, 0x64, 0x75, 0x72,
0x3b, 0x61, 0x76, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x63, 0x74,
0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x53, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0x46, 0x3b, 0x41, 0x3b, 0x53,
0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x64, 0x61, 0x20, 0x73, 0x63, 0x68, 0x61, 0x6e, 0x65, 0x72, 0x3b, 0x64, 0x61,
0x20, 0x66, 0x61, 0x76, 0x72, 0x65, 0x72, 0x3b, 0x64, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x64, 0x2019, 0x61, 0x76,
0x72, 0x69, 0x67, 0x6c, 0x3b, 0x64, 0x61, 0x20, 0x6d, 0x61, 0x74, 0x67, 0x3b, 0x64, 0x61, 0x20, 0x7a, 0x65, 0x72, 0x63,
0x6c, 0x61, 0x64, 0x75, 0x72, 0x3b, 0x64, 0x61, 0x20, 0x66, 0x61, 0x6e, 0x61, 0x64, 0x75, 0x72, 0x3b, 0x64, 0x2019, 0x61,
0x76, 0x75, 0x73, 0x74, 0x3b, 0x64, 0x61, 0x20, 0x73, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x2019,
0x6f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x61, 0x20, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x64, 0x61, 0x20, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4d, 0x31, 0x3b, 0x4d, 0x32, 0x3b, 0x4d, 0x33,
0x3b, 0x4d, 0x34, 0x3b, 0x4d, 0x35, 0x3b, 0x4d, 0x36, 0x3b, 0x4d, 0x37, 0x3b, 0x4d, 0x38, 0x3b, 0x4d, 0x39, 0x3b, 0x4d,
0x31, 0x30, 0x3b, 0x4d, 0x31, 0x31, 0x3b, 0x4d, 0x31, 0x32, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20,
0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x69, 0x6c,
0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77,
0x61, 0x20, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x73, 0x69, 0x74, 0x61,
0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x73, 0x61, 0x62, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x61, 0x20, 0x6e, 0x61, 0x6e, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x74, 0x69,
0x73, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x6a, 0x61,
0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d,
0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4e,
0x3b, 0x54, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x4d, 0x75, 0x74, 0x2e, 0x3b, 0x47, 0x61, 0x73, 0x2e, 0x3b, 0x57,
0x65, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x74, 0x2e, 0x3b, 0x47, 0x69, 0x63, 0x2e, 0x3b, 0x4b, 0x61, 0x6d, 0x2e, 0x3b, 0x4e,
0x79, 0x61, 0x2e, 0x3b, 0x4b, 0x61, 0x6e, 0x2e, 0x3b, 0x4e, 0x7a, 0x65, 0x2e, 0x3b, 0x55, 0x6b, 0x77, 0x2e, 0x3b, 0x55,
0x67, 0x75, 0x2e, 0x3b, 0x55, 0x6b, 0x75, 0x2e, 0x3b, 0x4e, 0x7a, 0x65, 0x72, 0x6f, 0x3b, 0x52, 0x75, 0x68, 0x75, 0x68,
0x75, 0x6d, 0x61, 0x3b, 0x4e, 0x74, 0x77, 0x61, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x3b, 0x4e, 0x64, 0x61, 0x6d, 0x75, 0x6b,
0x69, 0x7a, 0x61, 0x3b, 0x52, 0x75, 0x73, 0x61, 0x6d, 0x61, 0x3b, 0x52, 0x75, 0x68, 0x65, 0x73, 0x68, 0x69, 0x3b, 0x4d,
0x75, 0x6b, 0x61, 0x6b, 0x61, 0x72, 0x6f, 0x3b, 0x4e, 0x79, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x61, 0x72, 0x6f, 0x3b, 0x4e,
0x79, 0x61, 0x6b, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x47, 0x69, 0x74, 0x75, 0x67, 0x75, 0x74, 0x75, 0x3b, 0x4d, 0x75, 0x6e,
0x79, 0x6f, 0x6e, 0x79, 0x6f, 0x3b, 0x4b, 0x69, 0x67, 0x61, 0x72, 0x61, 0x6d, 0x61, 0x3b, 0x44f, 0x43d, 0x432, 0x2e, 0x3b,
0x444, 0x435, 0x432, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x439, 0x3b,
0x438, 0x44e, 0x43d, 0x44c, 0x3b, 0x438, 0x44e, 0x43b, 0x44c, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x2e,
0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b, 0x44f, 0x43d, 0x432,
0x2e, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x2e, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430,
0x44f, 0x3b, 0x438, 0x44e, 0x43d, 0x2e, 0x3b, 0x438, 0x44e, 0x43b, 0x2e, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43d,
0x442, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b, 0x44f,
0x43d, 0x432, 0x430, 0x440, 0x44f, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44f, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x430, 0x3b,
0x430, 0x43f, 0x440, 0x435, 0x43b, 0x44f, 0x3b, 0x43c, 0x430, 0x44f, 0x3b, 0x438, 0x44e, 0x43d, 0x44f, 0x3b, 0x438, 0x44e, 0x43b, 0x44f,
0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x430, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44f, 0x3b, 0x43e, 0x43a,
0x442, 0x44f, 0x431, 0x440, 0x44f, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x440, 0x44f, 0x3b, 0x434, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44f,
0x3b, 0x422, 0x43e, 0x445, 0x441, 0x3b, 0x41e, 0x43b, 0x443, 0x43d, 0x3b, 0x41a, 0x43b, 0x43d, 0x3b, 0x41c, 0x441, 0x443, 0x3b, 0x42b,
0x430, 0x43c, 0x3b, 0x411, 0x44d, 0x441, 0x3b, 0x41e, 0x442, 0x439, 0x3b, 0x410, 0x442, 0x440, 0x3b, 0x411, 0x43b, 0x495, 0x3b, 0x410,
0x43b, 0x442, 0x3b, 0x421, 0x44d, 0x442, 0x3b, 0x410, 0x445, 0x441, 0x3b, 0x442, 0x43e, 0x445, 0x441, 0x443, 0x43d, 0x43d, 0x44c, 0x443,
0x3b, 0x43e, 0x43b, 0x443, 0x43d, 0x43d, 0x44c, 0x443, 0x3b, 0x43a, 0x443, 0x43b, 0x443, 0x43d, 0x20, 0x442, 0x443, 0x442, 0x430, 0x440,
0x3b, 0x43c, 0x443, 0x443, 0x441, 0x20, 0x443, 0x441, 0x442, 0x430, 0x440, 0x3b, 0x44b, 0x430, 0x43c, 0x20, 0x44b, 0x439, 0x430, 0x3b,
0x431, 0x44d, 0x441, 0x20, 0x44b, 0x439, 0x430, 0x3b, 0x43e, 0x442, 0x20, 0x44b, 0x439, 0x430, 0x3b, 0x430, 0x442, 0x44b, 0x440, 0x434,
0x44c, 0x44b, 0x445, 0x20, 0x44b, 0x439, 0x430, 0x3b, 0x431, 0x430, 0x43b, 0x430, 0x495, 0x430, 0x43d, 0x20, 0x44b, 0x439, 0x430, 0x3b,
0x430, 0x43b, 0x442, 0x44b, 0x43d, 0x43d, 0x44c, 0x44b, 0x3b, 0x441, 0x44d, 0x442, 0x438, 0x43d, 0x43d, 0x44c, 0x438, 0x3b, 0x430, 0x445,
0x441, 0x44b, 0x43d, 0x43d, 0x44c, 0x44b, 0x3b, 0x422, 0x3b, 0x41e, 0x3b, 0x41a, 0x3b, 0x41c, 0x3b, 0x42b, 0x3b, 0x411, 0x3b, 0x41e,
0x3b, 0x410, 0x3b, 0x411, 0x3b, 0x410, 0x3b, 0x421, 0x3b, 0x410, 0x3b, 0x422, 0x43e, 0x445, 0x441, 0x443, 0x43d, 0x43d, 0x44c, 0x443,
0x3b, 0x41e, 0x43b, 0x443, 0x43d, 0x43d, 0x44c, 0x443, 0x3b, 0x41a, 0x443, 0x43b, 0x443, 0x43d, 0x20, 0x442, 0x443, 0x442, 0x430, 0x440,
0x3b, 0x41c, 0x443, 0x443, 0x441, 0x20, 0x443, 0x441, 0x442, 0x430, 0x440, 0x3b, 0x42b, 0x430, 0x43c, 0x20, 0x44b, 0x439, 0x44b, 0x43d,
0x3b, 0x411, 0x44d, 0x441, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x41e, 0x442, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x410, 0x442,
0x44b, 0x440, 0x434, 0x44c, 0x44b, 0x445, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x411, 0x430, 0x43b, 0x430, 0x495, 0x430, 0x43d, 0x20,
0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x410, 0x43b, 0x442, 0x44b, 0x43d, 0x43d, 0x44c, 0x44b, 0x3b, 0x421, 0x44d, 0x442, 0x438, 0x43d, 0x43d,
0x44c, 0x438, 0x3b, 0x430, 0x445, 0x441, 0x44b, 0x43d, 0x43d, 0x44c, 0x44b, 0x3b, 0x4f, 0x62, 0x6f, 0x3b, 0x57, 0x61, 0x61, 0x3b,
0x4f, 0x6b, 0x75, 0x3b, 0x4f, 0x6e, 0x67, 0x3b, 0x49, 0x6d, 0x65, 0x3b, 0x49, 0x6c, 0x65, 0x3b, 0x53, 0x61, 0x70, 0x3b,
0x49, 0x73, 0x69, 0x3b, 0x53, 0x61, 0x61, 0x3b, 0x54, 0x6f, 0x6d, 0x3b, 0x54, 0x6f, 0x62, 0x3b, 0x54, 0x6f, 0x77, 0x3b,
0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x6f, 0x62, 0x6f, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20,
0x77, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x6f, 0x6b, 0x75, 0x6e, 0x69, 0x3b,
0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x6f, 0x6e, 0x67, 0x2019, 0x77, 0x61, 0x6e, 0x3b, 0x4c, 0x61, 0x70, 0x61,
0x20, 0x6c, 0x65, 0x20, 0x69, 0x6d, 0x65, 0x74, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x69, 0x6c, 0x65,
0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x73, 0x61, 0x70, 0x61, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c,
0x65, 0x20, 0x69, 0x73, 0x69, 0x65, 0x74, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x73, 0x61, 0x61, 0x6c,
0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6d, 0x6f, 0x6e, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20,
0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x6f, 0x62, 0x6f, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65,
0x20, 0x74, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x77, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x4f, 0x3b, 0x57, 0x3b, 0x4f, 0x3b, 0x4f,
0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4e, 0x79, 0x65,
0x3b, 0x46, 0x75, 0x6c, 0x3b, 0x4d, 0x62, 0xe4, 0x3b, 0x4e, 0x67, 0x75, 0x3b, 0x42, 0xea, 0x6c, 0x3b, 0x46, 0xf6, 0x6e,
0x3b, 0x4c, 0x65, 0x6e, 0x3b, 0x4b, 0xfc, 0x6b, 0x3b, 0x4d, 0x76, 0x75, 0x3b, 0x4e, 0x67, 0x62, 0x3b, 0x4e, 0x61, 0x62,
0x3b, 0x4b, 0x61, 0x6b, 0x3b, 0x4e, 0x79, 0x65, 0x6e, 0x79, 0x65, 0x3b, 0x46, 0x75, 0x6c, 0x75, 0x6e, 0x64, 0xef, 0x67,
0x69, 0x3b, 0x4d, 0x62, 0xe4, 0x6e, 0x67, 0xfc, 0x3b, 0x4e, 0x67, 0x75, 0x62, 0xf9, 0x65, 0x3b, 0x42, 0xea, 0x6c, 0xe4,
0x77, 0xfc, 0x3b, 0x46, 0xf6, 0x6e, 0x64, 0x6f, 0x3b, 0x4c, 0x65, 0x6e, 0x67, 0x75, 0x61, 0x3b, 0x4b, 0xfc, 0x6b, 0xfc,
0x72, 0xfc, 0x3b, 0x4d, 0x76, 0x75, 0x6b, 0x61, 0x3b, 0x4e, 0x67, 0x62, 0x65, 0x72, 0x65, 0x72, 0x65, 0x3b, 0x4e, 0x61,
0x62, 0xe4, 0x6e, 0x64, 0xfc, 0x72, 0x75, 0x3b, 0x4b, 0x61, 0x6b, 0x61, 0x75, 0x6b, 0x61, 0x3b, 0x4e, 0x3b, 0x46, 0x3b,
0x4d, 0x3b, 0x4e, 0x3b, 0x42, 0x3b, 0x46, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b,
0x4d, 0x75, 0x70, 0x3b, 0x4d, 0x77, 0x69, 0x3b, 0x4d, 0x73, 0x68, 0x3b, 0x4d, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x67, 0x3b,
0x4d, 0x75, 0x6a, 0x3b, 0x4d, 0x73, 0x70, 0x3b, 0x4d, 0x70, 0x67, 0x3b, 0x4d, 0x79, 0x65, 0x3b, 0x4d, 0x6f, 0x6b, 0x3b,
0x4d, 0x75, 0x73, 0x3b, 0x4d, 0x75, 0x68, 0x3b, 0x4d, 0x75, 0x70, 0x61, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x77, 0x61,
0x3b, 0x4d, 0x77, 0x69, 0x74, 0x6f, 0x70, 0x65, 0x3b, 0x4d, 0x75, 0x73, 0x68, 0x65, 0x6e, 0x64, 0x65, 0x3b, 0x4d, 0x75,
0x6e, 0x79, 0x69, 0x3b, 0x4d, 0x75, 0x73, 0x68, 0x65, 0x6e, 0x64, 0x65, 0x20, 0x4d, 0x61, 0x67, 0x61, 0x6c, 0x69, 0x3b,
0x4d, 0x75, 0x6a, 0x69, 0x6d, 0x62, 0x69, 0x3b, 0x4d, 0x75, 0x73, 0x68, 0x69, 0x70, 0x65, 0x70, 0x6f, 0x3b, 0x4d, 0x75,
0x70, 0x75, 0x67, 0x75, 0x74, 0x6f, 0x3b, 0x4d, 0x75, 0x6e, 0x79, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x4d, 0x6f, 0x6b, 0x68,
0x75, 0x3b, 0x4d, 0x75, 0x73, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x64, 0x65, 0x6d, 0x62, 0x77, 0x65, 0x3b, 0x4d, 0x75, 0x68,
0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940, 0x3a, 0x3b, 0x92b, 0x930, 0x935, 0x930, 0x940, 0x3a, 0x3b, 0x92e,
0x93e, 0x930, 0x94d, 0x91a, 0x3a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x948, 0x932, 0x3a, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928,
0x3a, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3a, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x924, 0x3a, 0x3b, 0x938, 0x93f, 0x924, 0x902,
0x92c, 0x930, 0x3a, 0x3b, 0x905, 0x915, 0x94d, 0x924, 0x942, 0x92c, 0x930, 0x3a, 0x3b, 0x928, 0x935, 0x902, 0x92c, 0x930, 0x3a, 0x3b,
0x926, 0x93f, 0x938, 0x902, 0x92c, 0x930, 0x3a, 0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940, 0x92e, 0x93e, 0x938, 0x903, 0x3b, 0x92b, 0x930,
0x935, 0x930, 0x940, 0x92e, 0x93e, 0x938, 0x903, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x92e, 0x93e, 0x938, 0x903, 0x3b, 0x905, 0x92a,
0x94d, 0x930, 0x948, 0x932, 0x92e, 0x93e, 0x938, 0x903, 0x3b, 0x92e, 0x908, 0x92e, 0x93e, 0x938, 0x903, 0x3b, 0x91c, 0x942, 0x928, 0x92e,
0x93e, 0x938, 0x903, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x92e, 0x93e, 0x938, 0x903, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x924, 0x92e,
0x93e, 0x938, 0x903, 0x3b, 0x938, 0x93f, 0x924, 0x902, 0x92c, 0x930, 0x92e, 0x93e, 0x938, 0x903, 0x3b, 0x905, 0x915, 0x94d, 0x924, 0x942,
0x92c, 0x930, 0x92e, 0x93e, 0x938, 0x903, 0x3b, 0x928, 0x935, 0x902, 0x92c, 0x930, 0x92e, 0x93e, 0x938, 0x903, 0x3b, 0x926, 0x93f, 0x938,
0x902, 0x92c, 0x930, 0x92e, 0x93e, 0x938, 0x903, 0x3b, 0x1c61, 0x1c5f, 0x1c71, 0x3b, 0x1c6f, 0x1c77, 0x1c5f, 0x3b, 0x1c62, 0x1c5f, 0x1c68, 0x3b,
0x1c5f, 0x1c6f, 0x1c68, 0x3b, 0x1c62, 0x1c6e, 0x3b, 0x1c61, 0x1c69, 0x1c71, 0x3b, 0x1c61, 0x1c69, 0x1c5e, 0x3b, 0x1c5f, 0x1c5c, 0x1c5f, 0x3b, 0x1c65,
0x1c6e, 0x1c6f, 0x3b, 0x1c5a, 0x1c60, 0x1c74, 0x3b, 0x1c71, 0x1c5f, 0x1c63, 0x3b, 0x1c6b, 0x1c64, 0x1c65, 0x3b, 0x1c61, 0x1c5f, 0x1c71, 0x1c63, 0x1c5f,
0x1c68, 0x1c64, 0x3b, 0x1c6f, 0x1c77, 0x1c5f, 0x1c68, 0x1c63, 0x1c5f, 0x1c68, 0x1c64, 0x3b, 0x1c62, 0x1c5f, 0x1c68, 0x1c6a, 0x3b, 0x1c5f, 0x1c6f, 0x1c68,
0x1c6e, 0x1c5e, 0x3b, 0x1c62, 0x1c6e, 0x3b, 0x1c61, 0x1c69, 0x1c71, 0x3b, 0x1c61, 0x1c69, 0x1c5e, 0x1c5f, 0x1c6d, 0x3b, 0x1c5f, 0x1c5c, 0x1c5f, 0x1c65,
0x1c5b, 0x3b, 0x1c65, 0x1c6e, 0x1c6f, 0x1c74, 0x1c6e, 0x1c62, 0x1c75, 0x1c5f, 0x1c68, 0x3b, 0x1c5a, 0x1c60, 0x1c74, 0x1c5a, 0x1c75, 0x1c5f, 0x1c68, 0x3b,
0x1c71, 0x1c5f, 0x1c63, 0x1c5f, 0x1c62, 0x1c75, 0x1c5f, 0x1c68, 0x3b, 0x1c6b, 0x1c64, 0x1c65, 0x1c5f, 0x1c62, 0x1c75, 0x1c5f, 0x1c68, 0x3b, 0x1c61, 0x3b,
0x1c6f, 0x3b, 0x1c62, 0x3b, 0x1c5f, 0x3b, 0x1c62, 0x3b, 0x1c61, 0x3b, 0x1c61, 0x3b, 0x1c5f, 0x3b, 0x1c65, 0x3b, 0x1c5a, 0x3b, 0x1c71, 0x3b,
0x1c6b, 0x3b, 0x67, 0x68, 0x65, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x62, 0x72, 0x3b, 0x6d, 0x61,
0x6a, 0x3b, 0x6c, 0xe0, 0x6d, 0x3b, 0x74, 0x72, 0xec, 0x3b, 0x61, 0x75, 0x73, 0x3b, 0x63, 0x61, 0x62, 0x3b, 0x73, 0x74,
0x47, 0x3b, 0x73, 0x74, 0x41, 0x3b, 0x6e, 0x61, 0x64, 0x3b, 0x67, 0x68, 0x65, 0x6e, 0x6e, 0xe0, 0x72, 0x67, 0x69, 0x75,
0x3b, 0x66, 0x72, 0x65, 0xe0, 0x72, 0x67, 0x69, 0x75, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x7a, 0x75, 0x3b, 0x61, 0x62, 0x72,
0x69, 0x6c, 0x65, 0x3b, 0x6d, 0x61, 0x6a, 0x75, 0x3b, 0x6c, 0xe0, 0x6d, 0x70, 0x61, 0x64, 0x61, 0x73, 0x3b, 0x74, 0x72,
0xec, 0x75, 0x6c, 0x61, 0x73, 0x3b, 0x61, 0x75, 0x73, 0x74, 0x75, 0x3b, 0x63, 0x61, 0x62, 0x75, 0x64, 0x61, 0x6e, 0x6e,
0x69, 0x3b, 0x73, 0x61, 0x6e, 0x74, 0x75, 0x67, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x73, 0x61, 0x6e, 0x74, 0x61, 0x6e, 0x64,
0x72, 0x69, 0x61, 0x3b, 0x6e, 0x61, 0x64, 0x61, 0x6c, 0x65, 0x3b, 0x47, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d,
0x3b, 0x4c, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x43, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46,
0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a,
0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44,
0x65, 0x63, 0x3b, 0x4a, 0x61, 0x6e, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x46, 0x65, 0x76, 0x72, 0x65, 0x69, 0x72, 0x6f, 0x3b,
0x4d, 0x61, 0x72, 0x63, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x6f, 0x3b, 0x4a, 0x75, 0x6e,
0x68, 0x6f, 0x3b, 0x4a, 0x75, 0x6c, 0x68, 0x6f, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x74,
0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x4f, 0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72,
0x6f, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x458, 0x430, 0x43d, 0x3b, 0x444, 0x435, 0x431, 0x3b, 0x43c,
0x430, 0x440, 0x3b, 0x430, 0x43f, 0x440, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x3b, 0x458, 0x443, 0x43b, 0x3b, 0x430,
0x432, 0x433, 0x3b, 0x441, 0x435, 0x43f, 0x3b, 0x43e, 0x43a, 0x442, 0x3b, 0x43d, 0x43e, 0x432, 0x3b, 0x434, 0x435, 0x446, 0x3b, 0x458,
0x430, 0x43d, 0x443, 0x430, 0x440, 0x3b, 0x444, 0x435, 0x431, 0x440, 0x443, 0x430, 0x440, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430,
0x43f, 0x440, 0x438, 0x43b, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x3b, 0x458, 0x443, 0x43b, 0x3b, 0x430, 0x432, 0x433,
0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x43e, 0x43a, 0x442, 0x43e, 0x431, 0x430,
0x440, 0x3b, 0x43d, 0x43e, 0x432, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x434, 0x435, 0x446, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b,
0x458, 0x430, 0x43d, 0x3b, 0x444, 0x435, 0x431, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x3b, 0x43c, 0x430, 0x458,
0x3b, 0x458, 0x443, 0x43d, 0x3b, 0x458, 0x443, 0x43b, 0x3b, 0x430, 0x432, 0x433, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x3b, 0x43e, 0x43a,
0x442, 0x3b, 0x43d, 0x43e, 0x432, 0x3b, 0x434, 0x435, 0x446, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61,
0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x76,
0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61,
0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70,
0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x75,
0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72,
0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x6a,
0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x6a, 0x3b,
0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x3b, 0x6f, 0x6b, 0x74,
0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x46, 0x65, 0x62,
0x6c, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x6c, 0x69, 0x6c, 0x69, 0x3b, 0x4d,
0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x69,
0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76,
0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4e, 0x64, 0x69, 0x3b, 0x4b, 0x75, 0x6b,
0x3b, 0x4b, 0x75, 0x72, 0x3b, 0x4b, 0x75, 0x62, 0x3b, 0x43, 0x68, 0x76, 0x3b, 0x43, 0x68, 0x6b, 0x3b, 0x43, 0x68, 0x67,
0x3b, 0x4e, 0x79, 0x61, 0x3b, 0x47, 0x75, 0x6e, 0x3b, 0x47, 0x75, 0x6d, 0x3b, 0x4d, 0x62, 0x75, 0x3b, 0x5a, 0x76, 0x69,
0x3b, 0x4e, 0x64, 0x69, 0x72, 0x61, 0x3b, 0x4b, 0x75, 0x6b, 0x61, 0x64, 0x7a, 0x69, 0x3b, 0x4b, 0x75, 0x72, 0x75, 0x6d,
0x65, 0x3b, 0x4b, 0x75, 0x62, 0x76, 0x75, 0x6d, 0x62, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x76, 0x61, 0x62, 0x76, 0x75, 0x3b,
0x43, 0x68, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x6b, 0x75, 0x6e, 0x67, 0x75, 0x72, 0x75, 0x3b, 0x4e,
0x79, 0x61, 0x6d, 0x61, 0x76, 0x68, 0x75, 0x76, 0x68, 0x75, 0x3b, 0x47, 0x75, 0x6e, 0x79, 0x61, 0x6e, 0x61, 0x3b, 0x47,
0x75, 0x6d, 0x69, 0x67, 0x75, 0x72, 0x75, 0x3b, 0x4d, 0x62, 0x75, 0x64, 0x7a, 0x69, 0x3b, 0x5a, 0x76, 0x69, 0x74, 0x61,
0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x4e, 0x3b, 0x47, 0x3b, 0x47,
0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0xa2cd, 0xa1aa, 0x3b, 0xa44d, 0xa1aa, 0x3b, 0xa315, 0xa1aa, 0x3b, 0xa1d6, 0xa1aa, 0x3b, 0xa26c, 0xa1aa, 0x3b,
0xa0d8, 0xa1aa, 0x3b, 0xa3c3, 0xa1aa, 0x3b, 0xa246, 0xa1aa, 0x3b, 0xa22c, 0xa1aa, 0x3b, 0xa2b0, 0xa1aa, 0x3b, 0xa2b0, 0xa2aa, 0xa1aa, 0x3b, 0xa2b0,
0xa44b, 0xa1aa, 0x3b, 0x6a, 0x69, 0x6e, 0x3b, 0x66, 0x72, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d,
0x61, 0x6a, 0x3b, 0x67, 0x69, 0x75, 0x3b, 0x67, 0x6e, 0x74, 0x3b, 0x61, 0x67, 0x75, 0x3b, 0x73, 0x69, 0x74, 0x3b, 0x75,
0x74, 0x74, 0x3b, 0x6e, 0x75, 0x76, 0x3b, 0x64, 0x69, 0x63, 0x3b, 0x6a, 0x69, 0x6e, 0x6e, 0x61, 0x72, 0x75, 0x3b, 0x66,
0x72, 0x69, 0x76, 0x61, 0x72, 0x75, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x75, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x3b,
0x6d, 0x61, 0x6a, 0x75, 0x3b, 0x67, 0x69, 0x75, 0x67, 0x6e, 0x75, 0x3b, 0x67, 0x69, 0x75, 0x67, 0x6e, 0x65, 0x74, 0x74,
0x75, 0x3b, 0x61, 0x67, 0x75, 0x73, 0x74, 0x75, 0x3b, 0x73, 0x69, 0x74, 0x74, 0xe8, 0x6d, 0x6d, 0x69, 0x72, 0x75, 0x3b,
0x75, 0x74, 0x74, 0xf2, 0x76, 0x69, 0x72, 0x75, 0x3b, 0x6e, 0x75, 0x76, 0xe8, 0x6d, 0x6d, 0x69, 0x72, 0x75, 0x3b, 0x64,
0x69, 0x63, 0xe8, 0x6d, 0x6d, 0x69, 0x72, 0x75, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x47,
0x3b, 0x47, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x55, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x73, 0x74, 0x79, 0x3b, 0x6c, 0x75, 0x74,
0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6b, 0x77, 0x69, 0x3b, 0x6d, 0x6f, 0x6a, 0x3b, 0x63, 0x7a, 0x79, 0x3b, 0x6c, 0x69, 0x70,
0x3b, 0x73, 0x69, 0x79, 0x3b, 0x77, 0x72, 0x7a, 0x3b, 0x70, 0x61, 0x17a, 0x3b, 0x6c, 0x69, 0x73, 0x3b, 0x67, 0x72, 0x75,
0x3b, 0x73, 0x74, 0x79, 0x63, 0x7a, 0x79, 0x144, 0x3b, 0x6c, 0x75, 0x74, 0x79, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x65, 0x63,
0x3b, 0x6b, 0x77, 0x69, 0x65, 0x63, 0x69, 0x79, 0x144, 0x3b, 0x6d, 0x6f, 0x6a, 0x3b, 0x63, 0x7a, 0x79, 0x72, 0x77, 0x69,
0x65, 0x63, 0x3b, 0x6c, 0x69, 0x70, 0x69, 0x65, 0x63, 0x3b, 0x73, 0x69, 0x79, 0x72, 0x70, 0x69, 0x79, 0x144, 0x3b, 0x77,
0x72, 0x7a, 0x65, 0x73, 0x69, 0x79, 0x144, 0x3b, 0x70, 0x61, 0x17a, 0x64, 0x7a, 0x69, 0x65, 0x72, 0x6e, 0x69, 0x6b, 0x3b,
0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x3b, 0x67, 0x72, 0x75, 0x64, 0x7a, 0x69, 0x79, 0x144, 0x3b, 0x73, 0x74,
0x79, 0x63, 0x7a, 0x6e, 0x69, 0x61, 0x3b, 0x6c, 0x75, 0x74, 0x65, 0x67, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x63, 0x61, 0x3b,
0x6b, 0x77, 0x69, 0x65, 0x74, 0x6e, 0x69, 0x61, 0x3b, 0x6d, 0x6f, 0x6a, 0x61, 0x3b, 0x63, 0x7a, 0x79, 0x72, 0x77, 0x63,
0x61, 0x3b, 0x6c, 0x69, 0x70, 0x63, 0x61, 0x3b, 0x73, 0x69, 0x79, 0x72, 0x70, 0x6e, 0x69, 0x61, 0x3b, 0x77, 0x72, 0x7a,
0x65, 0x15b, 0x6e, 0x69, 0x61, 0x3b, 0x70, 0x61, 0x17a, 0x64, 0x7a, 0x69, 0x65, 0x72, 0x6e, 0x69, 0x6b, 0x61, 0x3b, 0x6c,
0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x61, 0x3b, 0x67, 0x72, 0x75, 0x64, 0x6e, 0x69, 0x61, 0x3b, 0x62c, 0x646, 0x648,
0x631, 0x64a, 0x3b, 0x641, 0x64a, 0x628, 0x631, 0x648, 0x631, 0x64a, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x64a,
0x644, 0x3b, 0x645, 0x626, 0x64a, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x621, 0x650, 0x3b, 0x622, 0x6af, 0x633,
0x67d, 0x3b, 0x633, 0x64a, 0x67e, 0x67d, 0x645, 0x628, 0x631, 0x3b, 0x622, 0x6aa, 0x67d, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645,
0x628, 0x631, 0x3b, 0x68a, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x91c, 0x928, 0x3b, 0x92b, 0x930, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a,
0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x948, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x3b, 0x905,
0x917, 0x3b, 0x938, 0x92a, 0x94d, 0x91f, 0x947, 0x3b, 0x911, 0x915, 0x94d, 0x91f, 0x94b, 0x3b, 0x928, 0x935, 0x902, 0x3b, 0x921, 0x93f,
0x938, 0x902, 0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940, 0x3b, 0x92b, 0x930, 0x935, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a,
0x941, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x948, 0x932, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e,
0x908, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x91f, 0x3b, 0x938, 0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x911, 0x915, 0x94d,
0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x935, 0x902, 0x92c, 0x930, 0x3b, 0x921, 0x93f, 0x938, 0x902, 0x92c, 0x930, 0x3b, 0x91c, 0x3b,
0x92b, 0x93c, 0x3b, 0x92e, 0x3b, 0x905, 0x3b, 0x92e, 0x93e, 0x3b, 0x91c, 0x942, 0x3b, 0x91c, 0x941, 0x3b, 0x905, 0x917, 0x3b, 0x938,
0x3b, 0x911, 0x3b, 0x928, 0x3b, 0x921, 0x93f, 0x3b, 0x91c, 0x928, 0x3b, 0x92b, 0x930, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b,
0x905, 0x92a, 0x94d, 0x930, 0x948, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x3b, 0x905, 0x917, 0x3b, 0x938,
0x92a, 0x94d, 0x91f, 0x947, 0x3b, 0x911, 0x915, 0x94d, 0x91f, 0x94b, 0x3b, 0x928, 0x935, 0x902, 0x3b, 0x921, 0x93f, 0x938, 0x902, 0x3b,
0x91c, 0x928, 0x935, 0x930, 0x940, 0x3b, 0x92b, 0x930, 0x935, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x941, 0x3b, 0x905,
0x92a, 0x94d, 0x930, 0x948, 0x932, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905,
0x917, 0x938, 0x94d, 0x91f, 0x3b, 0x938, 0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x913, 0x915, 0x94d, 0x91f, 0x94b, 0x92c,
0x930, 0x3b, 0x928, 0x935, 0x902, 0x92c, 0x930, 0x3b, 0x921, 0x93f, 0x938, 0x902, 0x92c, 0x930, 0x3b, 0x91c, 0x3b, 0x92b, 0x93c, 0x3b,
0x92e, 0x93e, 0x3b, 0x905, 0x3b, 0x92e, 0x93e, 0x3b, 0x91c, 0x942, 0x3b, 0x91c, 0x941, 0x3b, 0x905, 0x917, 0x3b, 0x938, 0x3b, 0x911,
0x3b, 0x928, 0x3b, 0x921, 0x93f, 0x3b, 0xda2, 0xdb1, 0x3b, 0xdb4, 0xdd9, 0xdb6, 0x3b, 0xdb8, 0xdcf, 0xdbb, 0xdca, 0x3b, 0xd85, 0xdb4,
0xdca, 0x200d, 0xdbb, 0xdda, 0xdbd, 0xdca, 0x3b, 0xdb8, 0xdd0, 0xdba, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdb1, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdbd,
0xdd2, 0x3b, 0xd85, 0xd9c, 0xddd, 0x3b, 0xdc3, 0xdd0, 0xdb4, 0xdca, 0x3b, 0xd94, 0xd9a, 0xdca, 0x3b, 0xdb1, 0xddc, 0xdc0, 0xdd0, 0x3b,
0xdaf, 0xdd9, 0xdc3, 0xdd0, 0x3b, 0xda2, 0xdb1, 0xdc0, 0xdcf, 0xdbb, 0xdd2, 0x3b, 0xdb4, 0xdd9, 0xdb6, 0xdbb, 0xdc0, 0xdcf, 0xdbb, 0xdd2,
0x3b, 0xdb8, 0xdcf, 0xdbb, 0xdca, 0xdad, 0xdd4, 0x3b, 0xd85, 0xdb4, 0xdca, 0x200d, 0xdbb, 0xdda, 0xdbd, 0xdca, 0x3b, 0xdb8, 0xdd0, 0xdba,
0xdd2, 0x3b, 0xda2, 0xdd6, 0xdb1, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdbd, 0xdd2, 0x3b, 0xd85, 0xd9c, 0xddd, 0xdc3, 0xdca, 0xdad, 0xdd4, 0x3b,
0xdc3, 0xdd0, 0xdb4, 0xdca, 0xdad, 0xdd0, 0xdb8, 0xdca, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xd94, 0xd9a, 0xdca, 0xdad, 0xddd, 0xdb6, 0xdbb, 0xdca,
0x3b, 0xdb1, 0xddc, 0xdc0, 0xdd0, 0xdb8, 0xdca, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xdaf, 0xdd9, 0xdc3, 0xdd0, 0xdb8, 0xdca, 0xdb6, 0xdbb, 0xdca,
0x3b, 0xda2, 0x3b, 0xdb4, 0xdd9, 0x3b, 0xdb8, 0xdcf, 0x3b, 0xd85, 0x3b, 0xdb8, 0xdd0, 0x3b, 0xda2, 0xdd6, 0x3b, 0xda2, 0xdd6, 0x3b,
0xd85, 0x3b, 0xdc3, 0xdd0, 0x3b, 0xd94, 0x3b, 0xdb1, 0xdd9, 0x3b, 0xdaf, 0xdd9, 0x3b, 0xda2, 0xdb1, 0x3b, 0xdb4, 0xdd9, 0xdb6, 0x3b,
0xdb8, 0xdcf, 0xdbb, 0xdca, 0xdad, 0xdd4, 0x3b, 0xd85, 0xdb4, 0xdca, 0x200d, 0xdbb, 0xdda, 0xdbd, 0xdca, 0x3b, 0xdb8, 0xdd0, 0xdba, 0xdd2,
0x3b, 0xda2, 0xdd6, 0xdb1, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdbd, 0xdd2, 0x3b, 0xd85, 0xd9c, 0xddd, 0x3b, 0xdc3, 0xdd0, 0xdb4, 0xdca, 0x3b,
0xd94, 0xd9a, 0xdca, 0x3b, 0xdb1, 0xddc, 0xdc0, 0xdd0, 0x3b, 0xdaf, 0xdd9, 0xdc3, 0xdd0, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65,
0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0xe1, 0x6a, 0x3b, 0x6a, 0xfa, 0x6e, 0x3b, 0x6a, 0xfa,
0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65,
0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0xe1, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0xe1, 0x72, 0x3b, 0x6d, 0x61, 0x72,
0x65, 0x63, 0x3b, 0x61, 0x70, 0x72, 0xed, 0x6c, 0x3b, 0x6d, 0xe1, 0x6a, 0x3b, 0x6a, 0xfa, 0x6e, 0x3b, 0x6a, 0xfa, 0x6c,
0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b,
0x74, 0xf3, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0xe1, 0x72, 0x61, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0xe1, 0x72, 0x61,
0x3b, 0x6d, 0x61, 0x72, 0x63, 0x61, 0x3b, 0x61, 0x70, 0x72, 0xed, 0x6c, 0x61, 0x3b, 0x6d, 0xe1, 0x6a, 0x61, 0x3b, 0x6a,
0xfa, 0x6e, 0x61, 0x3b, 0x6a, 0xfa, 0x6c, 0x61, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x61, 0x3b, 0x73, 0x65, 0x70,
0x74, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x6f, 0x6b, 0x74, 0xf3, 0x62, 0x72, 0x61, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d,
0x62, 0x72, 0x61, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65,
0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e,
0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x76, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74,
0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66,
0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x65, 0x63, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d,
0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6a, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6a, 0x3b, 0x61, 0x76, 0x67, 0x75, 0x73,
0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b,
0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x61,
0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x4a, 0x75,
0x6e, 0x3b, 0x4c, 0x75, 0x6c, 0x3b, 0x4f, 0x67, 0x73, 0x3b, 0x53, 0x65, 0x62, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f,
0x66, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x6e, 0x61, 0x61, 0x79, 0x6f, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x61,
0x61, 0x79, 0x6f, 0x3b, 0x4d, 0x61, 0x61, 0x72, 0x73, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x69, 0x6c, 0x3b, 0x4d, 0x61,
0x79, 0x3b, 0x4a, 0x75, 0x75, 0x6e, 0x3b, 0x4c, 0x75, 0x75, 0x6c, 0x69, 0x79, 0x6f, 0x3b, 0x4f, 0x67, 0x6f, 0x73, 0x74,
0x6f, 0x3b, 0x53, 0x65, 0x62, 0x74, 0x65, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x61,
0x72, 0x3b, 0x4e, 0x6f, 0x6f, 0x66, 0x65, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x65, 0x6d, 0x62,
0x61, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4c, 0x3b, 0x4f, 0x3b, 0x53,
0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4b, 0x6f, 0x6f, 0x62, 0x61, 0x61, 0x64,
0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4c, 0x61, 0x62, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20,
0x53, 0x61, 0x64, 0x64, 0x65, 0x78, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x41, 0x66, 0x72, 0x61,
0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x53, 0x68, 0x61, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73,
0x68, 0x61, 0x20, 0x4c, 0x69, 0x78, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x54, 0x6f, 0x64, 0x6f,
0x62, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x53, 0x69, 0x64, 0x65, 0x65, 0x64, 0x61, 0x61, 0x64,
0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x53, 0x61, 0x67, 0x61, 0x61, 0x6c, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73,
0x68, 0x61, 0x20, 0x54, 0x6f, 0x62, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4b, 0x6f, 0x77,
0x20, 0x69, 0x79, 0x6f, 0x20, 0x54, 0x6f, 0x62, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4c,
0x61, 0x62, 0x61, 0x20, 0x69, 0x79, 0x6f, 0x20, 0x54, 0x6f, 0x62, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x4a, 0x61, 0x6e, 0x3b,
0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x79, 0x3b, 0x4a, 0x75, 0x6e, 0x3b,
0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x72, 0x68, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x55, 0x73, 0x69, 0x3b,
0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x61, 0x62, 0x61, 0x72, 0x69, 0x3b, 0x75, 0x46, 0x65, 0x62, 0x65, 0x72, 0x62,
0x61, 0x72, 0x69, 0x3b, 0x75, 0x4d, 0x61, 0x74, 0x6a, 0x68, 0x69, 0x3b, 0x75, 0x2d, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x69,
0x3b, 0x4d, 0x65, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x79, 0x69, 0x3b, 0x41, 0x72,
0x68, 0x6f, 0x73, 0x74, 0x6f, 0x73, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74,
0x6f, 0x62, 0x61, 0x3b, 0x55, 0x73, 0x69, 0x6e, 0x79, 0x69, 0x6b, 0x68, 0x61, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65,
0x6d, 0x62, 0x61, 0x3b, 0x50, 0x68, 0x65, 0x3b, 0x4b, 0x6f, 0x6c, 0x3b, 0x55, 0x62, 0x65, 0x3b, 0x4d, 0x6d, 0x65, 0x3b,
0x4d, 0x6f, 0x74, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x55, 0x70, 0x75, 0x3b, 0x50, 0x68, 0x61, 0x3b, 0x4c, 0x65, 0x6f, 0x3b,
0x4d, 0x70, 0x68, 0x3b, 0x50, 0x75, 0x6e, 0x3b, 0x54, 0x73, 0x68, 0x3b, 0x50, 0x68, 0x65, 0x73, 0x65, 0x6b, 0x67, 0x6f,
0x6e, 0x67, 0x3b, 0x48, 0x6c, 0x61, 0x6b, 0x6f, 0x6c, 0x61, 0x3b, 0x48, 0x6c, 0x61, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65,
0x3b, 0x4d, 0x6d, 0x65, 0x73, 0x65, 0x3b, 0x4d, 0x6f, 0x74, 0x73, 0x68, 0x65, 0x61, 0x6e, 0x6f, 0x6e, 0x67, 0x3b, 0x50,
0x68, 0x75, 0x70, 0x6a, 0x61, 0x6e, 0x65, 0x3b, 0x50, 0x68, 0x75, 0x70, 0x75, 0x3b, 0x50, 0x68, 0x61, 0x74, 0x61, 0x3b,
0x4c, 0x65, 0x6f, 0x74, 0x73, 0x68, 0x65, 0x3b, 0x4d, 0x70, 0x68, 0x61, 0x6c, 0x61, 0x6e, 0x65, 0x3b, 0x50, 0x75, 0x6e,
0x64, 0x75, 0x6e, 0x67, 0x77, 0x61, 0x6e, 0x65, 0x3b, 0x54, 0x73, 0x68, 0x69, 0x74, 0x77, 0x65, 0x3b, 0x65, 0x6e, 0x65,
0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x62, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x6a, 0x75, 0x6e,
0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x3b, 0x6f, 0x63, 0x74, 0x3b, 0x6e, 0x6f,
0x76, 0x3b, 0x64, 0x69, 0x63, 0x3b, 0x65, 0x6e, 0x65, 0x72, 0x6f, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b,
0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x6f, 0x3b, 0x6a, 0x75, 0x6e,
0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x70, 0x74,
0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x69, 0x65,
0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x69, 0x63, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x45, 0x3b, 0x46, 0x3b, 0x4d,
0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x65,
0x6e, 0x65, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x6d,
0x61, 0x79, 0x2e, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x67, 0x6f, 0x2e, 0x3b, 0x73,
0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x69, 0x63, 0x2e, 0x3b,
0x45, 0x6e, 0x65, 0x2e, 0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d, 0x61, 0x72, 0x2e, 0x3b, 0x41, 0x62, 0x72, 0x2e, 0x3b,
0x4d, 0x61, 0x79, 0x2e, 0x3b, 0x4a, 0x75, 0x6e, 0x2e, 0x3b, 0x4a, 0x75, 0x6c, 0x2e, 0x3b, 0x41, 0x67, 0x6f, 0x2e, 0x3b,
0x53, 0x65, 0x74, 0x2e, 0x3b, 0x4f, 0x63, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x69, 0x63, 0x2e, 0x3b,
0x65, 0x6e, 0x65, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x62, 0x72, 0x2e, 0x3b,
0x6d, 0x61, 0x79, 0x2e, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x67, 0x6f, 0x2e, 0x3b,
0x73, 0x65, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x69, 0x63, 0x2e, 0x3b,
0x65, 0x6e, 0x65, 0x72, 0x6f, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b,
0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x6f, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6c,
0x69, 0x6f, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b,
0x6f, 0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x69,
0x63, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x2d49, 0x2d4f, 0x2d4f, 0x3b, 0x2d31, 0x2d55, 0x2d30, 0x3b, 0x2d4e, 0x2d30, 0x2d55, 0x3b,
0x2d49, 0x2d31, 0x2d54, 0x3b, 0x2d4e, 0x2d30, 0x2d62, 0x3b, 0x2d62, 0x2d53, 0x2d4f, 0x3b, 0x2d62, 0x2d53, 0x2d4d, 0x3b, 0x2d56, 0x2d53, 0x2d5b, 0x3b,
0x2d5b, 0x2d53, 0x2d5c, 0x3b, 0x2d3d, 0x2d5c, 0x2d53, 0x3b, 0x2d4f, 0x2d53, 0x2d61, 0x3b, 0x2d37, 0x2d53, 0x2d4a, 0x3b, 0x2d49, 0x2d4f, 0x2d4f, 0x2d30,
0x2d62, 0x2d54, 0x3b, 0x2d31, 0x2d55, 0x2d30, 0x2d62, 0x2d55, 0x3b, 0x2d4e, 0x2d30, 0x2d55, 0x2d5a, 0x3b, 0x2d49, 0x2d31, 0x2d54, 0x2d49, 0x2d54, 0x3b,
0x2d4e, 0x2d30, 0x2d62, 0x2d62, 0x2d53, 0x3b, 0x2d62, 0x2d53, 0x2d4f, 0x2d62, 0x2d53, 0x3b, 0x2d62, 0x2d53, 0x2d4d, 0x2d62, 0x2d53, 0x2d63, 0x3b, 0x2d56,
0x2d53, 0x2d5b, 0x2d5c, 0x3b, 0x2d5b, 0x2d53, 0x2d5c, 0x2d30, 0x2d4f, 0x2d31, 0x2d49, 0x2d54, 0x3b, 0x2d3d, 0x2d5c, 0x2d53, 0x2d31, 0x2d54, 0x3b, 0x2d4f,
0x2d53, 0x2d61, 0x2d30, 0x2d4f, 0x2d31, 0x2d49, 0x2d54, 0x3b, 0x2d37, 0x2d53, 0x2d4a, 0x2d30, 0x2d4f, 0x2d31, 0x2d49, 0x2d54, 0x3b, 0x2d49, 0x3b, 0x2d31,
0x3b, 0x2d4e, 0x3b, 0x2d49, 0x3b, 0x2d4e, 0x3b, 0x2d62, 0x3b, 0x2d62, 0x3b, 0x2d56, 0x3b, 0x2d5b, 0x3b, 0x2d3d, 0x3b, 0x2d4f, 0x3b, 0x2d37,
0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x50, 0xe9, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0xe9, 0x69,
0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x73, 0x3b, 0x53, 0xe9, 0x70, 0x3b, 0x4f, 0x6b, 0x74,
0x3b, 0x4e, 0x6f, 0x70, 0x3b, 0x44, 0xe9, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x50, 0xe9, 0x62,
0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x72, 0x65, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0xe9,
0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b,
0x53, 0xe9, 0x70, 0x74, 0xe9, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f,
0x70, 0xe9, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0xe9, 0x73, 0xe9, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x50, 0x3b,
0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b,
0x42, 0x68, 0x69, 0x3b, 0x56, 0x61, 0x6e, 0x3b, 0x56, 0x6f, 0x6c, 0x3b, 0x4d, 0x61, 0x62, 0x3b, 0x4e, 0x6b, 0x68, 0x3b,
0x4e, 0x68, 0x6c, 0x3b, 0x4b, 0x68, 0x6f, 0x3b, 0x4e, 0x67, 0x63, 0x3b, 0x4e, 0x79, 0x6f, 0x3b, 0x4d, 0x70, 0x68, 0x3b,
0x4c, 0x77, 0x65, 0x3b, 0x4e, 0x67, 0x6f, 0x3b, 0x42, 0x68, 0x69, 0x6d, 0x62, 0x69, 0x64, 0x76, 0x77, 0x61, 0x6e, 0x65,
0x3b, 0x69, 0x4e, 0x64, 0x6c, 0x6f, 0x76, 0x61, 0x6e, 0x61, 0x3b, 0x69, 0x4e, 0x64, 0x6c, 0x6f, 0x76, 0x75, 0x2d, 0x6c,
0x65, 0x6e, 0x6b, 0x68, 0x75, 0x6c, 0x75, 0x3b, 0x4d, 0x61, 0x62, 0x61, 0x73, 0x61, 0x3b, 0x69, 0x4e, 0x6b, 0x68, 0x77,
0x65, 0x6b, 0x68, 0x77, 0x65, 0x74, 0x69, 0x3b, 0x69, 0x4e, 0x68, 0x6c, 0x61, 0x62, 0x61, 0x3b, 0x4b, 0x68, 0x6f, 0x6c,
0x77, 0x61, 0x6e, 0x65, 0x3b, 0x69, 0x4e, 0x67, 0x63, 0x69, 0x3b, 0x69, 0x4e, 0x79, 0x6f, 0x6e, 0x69, 0x3b, 0x69, 0x4d,
0x70, 0x68, 0x61, 0x6c, 0x61, 0x3b, 0x4c, 0x77, 0x65, 0x74, 0x69, 0x3b, 0x69, 0x4e, 0x67, 0x6f, 0x6e, 0x67, 0x6f, 0x6e,
0x69, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72,
0x2e, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x2e,
0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e,
0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x6d, 0x61,
0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75,
0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x69, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65,
0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61,
0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e,
0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x63, 0x68, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74,
0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0xe4, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x71f, 0x722, 0x70a, 0x20, 0x712, 0x3b, 0x72b,
0x712, 0x71b, 0x3b, 0x710, 0x715, 0x72a, 0x3b, 0x722, 0x71d, 0x723, 0x722, 0x3b, 0x710, 0x71d, 0x72a, 0x3b, 0x71a, 0x719, 0x71d, 0x72a,
0x722, 0x3b, 0x72c, 0x721, 0x718, 0x719, 0x3b, 0x710, 0x712, 0x3b, 0x710, 0x71d, 0x720, 0x718, 0x720, 0x3b, 0x72c, 0x72b, 0x70a, 0x20,
0x710, 0x3b, 0x72c, 0x72b, 0x70a, 0x20, 0x712, 0x3b, 0x71f, 0x722, 0x70a, 0x20, 0x710, 0x3b, 0x71f, 0x722, 0x718, 0x722, 0x20, 0x710,
0x71a, 0x72a, 0x71d, 0x710, 0x3b, 0x72b, 0x712, 0x71b, 0x3b, 0x710, 0x715, 0x72a, 0x3b, 0x722, 0x71d, 0x723, 0x722, 0x3b, 0x710, 0x71d,
0x72a, 0x3b, 0x71a, 0x719, 0x71d, 0x72a, 0x722, 0x3b, 0x72c, 0x721, 0x718, 0x719, 0x3b, 0x710, 0x712, 0x3b, 0x710, 0x71d, 0x720, 0x718,
0x720, 0x3b, 0x72c, 0x72b, 0x72a, 0x71d, 0x722, 0x20, 0x729, 0x715, 0x721, 0x71d, 0x710, 0x3b, 0x72c, 0x72b, 0x72a, 0x71d, 0x73c, 0x722,
0x20, 0x710, 0x71a, 0x72a, 0x71d, 0x710, 0x3b, 0x71f, 0x722, 0x718, 0x722, 0x20, 0x729, 0x715, 0x721, 0x71d, 0x710, 0x3b, 0x710, 0x3b,
0x712, 0x3b, 0x713, 0x3b, 0x715, 0x3b, 0x717, 0x3b, 0x718, 0x3b, 0x719, 0x3b, 0x71a, 0x3b, 0x71b, 0x3b, 0x71d, 0x3b, 0x71d, 0x710,
0x3b, 0x71d, 0x712, 0x3b, 0x71f, 0x722, 0x718, 0x722, 0x20, 0x710, 0x71a, 0x72a, 0x71d, 0x710, 0x3b, 0x72b, 0x712, 0x71b, 0x3b, 0x710,
0x715, 0x72a, 0x3b, 0x722, 0x71d, 0x723, 0x722, 0x3b, 0x710, 0x71d, 0x72a, 0x3b, 0x71a, 0x719, 0x71d, 0x72a, 0x722, 0x3b, 0x72c, 0x721,
0x718, 0x719, 0x3b, 0x710, 0x712, 0x3b, 0x710, 0x71d, 0x720, 0x718, 0x720, 0x3b, 0x72c, 0x72b, 0x72a, 0x71d, 0x722, 0x20, 0x729, 0x715,
0x721, 0x71d, 0x710, 0x3b, 0x72c, 0x72b, 0x72a, 0x71d, 0x722, 0x20, 0x710, 0x71a, 0x72a, 0x71d, 0x710, 0x3b, 0x71f, 0x722, 0x718, 0x722,
0x20, 0x729, 0x715, 0x721, 0x71d, 0x710, 0x3b, 0x69, 0x6e, 0x6e, 0x3b, 0x62, 0x1e5b, 0x61, 0x3b, 0x6d, 0x61, 0x1e5b, 0x3b, 0x69,
0x62, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x79, 0x75, 0x6e, 0x3b, 0x79, 0x75, 0x6c, 0x3b, 0x263, 0x75, 0x63, 0x3b, 0x63,
0x75, 0x74, 0x3b, 0x6b, 0x74, 0x75, 0x3b, 0x6e, 0x75, 0x77, 0x3b, 0x64, 0x75, 0x6a, 0x3b, 0x69, 0x6e, 0x6e, 0x61, 0x79,
0x72, 0x3b, 0x62, 0x1e5b, 0x61, 0x79, 0x1e5b, 0x3b, 0x6d, 0x61, 0x1e5b, 0x1e63, 0x3b, 0x69, 0x62, 0x72, 0x69, 0x72, 0x3b, 0x6d,
0x61, 0x79, 0x79, 0x75, 0x3b, 0x79, 0x75, 0x6e, 0x79, 0x75, 0x3b, 0x79, 0x75, 0x6c, 0x79, 0x75, 0x7a, 0x3b, 0x263, 0x75,
0x63, 0x74, 0x3b, 0x63, 0x75, 0x74, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x6b, 0x74, 0x75, 0x62, 0x72, 0x3b, 0x6e, 0x75,
0x77, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x64, 0x75, 0x6a, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x69, 0x3b, 0x62, 0x3b,
0x6d, 0x3b, 0x69, 0x3b, 0x6d, 0x3b, 0x79, 0x3b, 0x79, 0x3b, 0x263, 0x3b, 0x63, 0x3b, 0x6b, 0x3b, 0x6e, 0x3b, 0x64, 0x3b,
0x49, 0x6d, 0x62, 0x3b, 0x4b, 0x61, 0x77, 0x3b, 0x4b, 0x61, 0x64, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x4b, 0x61, 0x73, 0x3b,
0x4b, 0x61, 0x72, 0x3b, 0x4d, 0x66, 0x75, 0x3b, 0x57, 0x75, 0x6e, 0x3b, 0x49, 0x6b, 0x65, 0x3b, 0x49, 0x6b, 0x75, 0x3b,
0x49, 0x6d, 0x77, 0x3b, 0x49, 0x77, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6d,
0x62, 0x69, 0x72, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x77, 0x69, 0x3b,
0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x64, 0x61, 0x64, 0x75, 0x3b, 0x4d, 0x6f, 0x72,
0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77,
0x61, 0x20, 0x6b, 0x61, 0x73, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b,
0x61, 0x72, 0x61, 0x6e, 0x64, 0x61, 0x64, 0x75, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6d,
0x66, 0x75, 0x6e, 0x67, 0x61, 0x64, 0x65, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x77, 0x75,
0x6e, 0x79, 0x61, 0x6e, 0x79, 0x61, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x65,
0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b,
0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x69,
0x6d, 0x77, 0x65, 0x72, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d,
0x69, 0x20, 0x6e, 0x61, 0x20, 0x69, 0x77, 0x69, 0x3b, 0x49, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b,
0x3b, 0x4d, 0x3b, 0x57, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x42f, 0x43d, 0x432, 0x430, 0x440, 0x3b, 0x424,
0x435, 0x432, 0x440, 0x430, 0x43b, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x3b, 0x410, 0x43f, 0x440, 0x435, 0x43b, 0x3b, 0x41c, 0x430, 0x439,
0x3b, 0x418, 0x44e, 0x43d, 0x3b, 0x418, 0x44e, 0x43b, 0x3b, 0x410, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x421, 0x435, 0x43d, 0x442,
0x44f, 0x431, 0x440, 0x3b, 0x41e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x3b, 0x41d, 0x43e, 0x44f, 0x431, 0x440, 0x3b, 0x414, 0x435, 0x43a,
0x430, 0x431, 0x440, 0x3b, 0xb9c, 0xba9, 0x2e, 0x3b, 0xbaa, 0xbbf, 0xbaa, 0xbcd, 0x2e, 0x3b, 0xbae, 0xbbe, 0xbb0, 0xbcd, 0x2e, 0x3b,
0xb8f, 0xbaa, 0xbcd, 0x2e, 0x3b, 0xbae, 0xbc7, 0x3b, 0xb9c, 0xbc2, 0xba9, 0xbcd, 0x3b, 0xb9c, 0xbc2, 0xbb2, 0xbc8, 0x3b, 0xb86, 0xb95,
0x2e, 0x3b, 0xb9a, 0xbc6, 0xbaa, 0xbcd, 0x2e, 0x3b, 0xb85, 0xb95, 0xbcd, 0x2e, 0x3b, 0xba8, 0xbb5, 0x2e, 0x3b, 0xb9f, 0xbbf, 0xb9a,
0x2e, 0x3b, 0xb9c, 0xba9, 0xbb5, 0xbb0, 0xbbf, 0x3b, 0xbaa, 0xbbf, 0xbaa, 0xbcd, 0xbb0, 0xbb5, 0xbb0, 0xbbf, 0x3b, 0xbae, 0xbbe, 0xbb0,
0xbcd, 0xb9a, 0xbcd, 0x3b, 0xb8f, 0xbaa, 0xbcd, 0xbb0, 0xbb2, 0xbcd, 0x3b, 0xbae, 0xbc7, 0x3b, 0xb9c, 0xbc2, 0xba9, 0xbcd, 0x3b, 0xb9c,
0xbc2, 0xbb2, 0xbc8, 0x3b, 0xb86, 0xb95, 0xbb8, 0xbcd, 0xb9f, 0xbcd, 0x3b, 0xb9a, 0xbc6, 0xbaa, 0xbcd, 0xb9f, 0xbae, 0xbcd, 0xbaa, 0xbb0,
0xbcd, 0x3b, 0xb85, 0xb95, 0xbcd, 0xb9f, 0xbcb, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xba8, 0xbb5, 0xbae, 0xbcd, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb9f,
0xbbf, 0xb9a, 0xbae, 0xbcd, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb9c, 0x3b, 0xbaa, 0xbbf, 0x3b, 0xbae, 0xbbe, 0x3b, 0xb8f, 0x3b, 0xbae, 0xbc7,
0x3b, 0xb9c, 0xbc2, 0x3b, 0xb9c, 0xbc2, 0x3b, 0xb86, 0x3b, 0xb9a, 0xbc6, 0x3b, 0xb85, 0x3b, 0xba8, 0x3b, 0xb9f, 0xbbf, 0x3b, 0x4b,
0x69, 0x69, 0x3b, 0x44, 0x68, 0x69, 0x3b, 0x54, 0x72, 0x69, 0x3b, 0x53, 0x70, 0x69, 0x3b, 0x52, 0x69, 0x69, 0x3b, 0x4d,
0x74, 0x69, 0x3b, 0x45, 0x6d, 0x69, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4d, 0x6e, 0x69, 0x3b, 0x4d, 0x78, 0x69, 0x3b, 0x4d,
0x78, 0x6b, 0x3b, 0x4d, 0x78, 0x64, 0x3b, 0x4b, 0x69, 0x6e, 0x67, 0x61, 0x6c, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x44,
0x68, 0x61, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x54, 0x72, 0x75, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x53, 0x70, 0x61,
0x74, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x52, 0x69, 0x6d, 0x61, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x4d, 0x61, 0x74,
0x61, 0x72, 0x75, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x45, 0x6d, 0x70, 0x69, 0x74, 0x75, 0x20, 0x69, 0x64, 0x61, 0x73,
0x3b, 0x4d, 0x61, 0x73, 0x70, 0x61, 0x74, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x4d, 0x6e, 0x67, 0x61, 0x72, 0x69, 0x20,
0x69, 0x64, 0x61, 0x73, 0x3b, 0x4d, 0x61, 0x78, 0x61, 0x6c, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x4d, 0x61, 0x78, 0x61,
0x6c, 0x20, 0x6b, 0x69, 0x6e, 0x67, 0x61, 0x6c, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x4d, 0x61, 0x78, 0x61, 0x6c, 0x20,
0x64, 0x68, 0x61, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x4b, 0x3b, 0x44, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x4d,
0x3b, 0x45, 0x3b, 0x50, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x44, 0x3b, 0x433, 0x44b, 0x439, 0x43d, 0x2e, 0x3b, 0x444,
0x435, 0x432, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x2e, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x44e,
0x43d, 0x44c, 0x3b, 0x438, 0x44e, 0x43b, 0x44c, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x2e, 0x3b, 0x43e,
0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b, 0x433, 0x44b, 0x439, 0x43d, 0x432,
0x430, 0x440, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44c, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x435,
0x43b, 0x44c, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x44e, 0x43d, 0x44c, 0x3b, 0x438, 0x44e, 0x43b, 0x44c, 0x3b, 0x430, 0x432, 0x433,
0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x43e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x44c,
0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x434, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44c, 0x3b, 0xc1c, 0xc28, 0x3b, 0xc2b,
0xc3f, 0xc2c, 0xc4d, 0xc30, 0x3b, 0xc2e, 0xc3e, 0xc30, 0xc4d, 0xc1a, 0xc3f, 0x3b, 0xc0f, 0xc2a, 0xc4d, 0xc30, 0xc3f, 0x3b, 0xc2e, 0xc47,
0x3b, 0xc1c, 0xc42, 0xc28, 0xc4d, 0x3b, 0xc1c, 0xc41, 0xc32, 0xc48, 0x3b, 0xc06, 0xc17, 0x3b, 0xc38, 0xc46, 0xc2a, 0xc4d, 0xc1f, 0xc46,
0xc02, 0x3b, 0xc05, 0xc15, 0xc4d, 0xc1f, 0xc4b, 0x3b, 0xc28, 0xc35, 0xc02, 0x3b, 0xc21, 0xc3f, 0xc38, 0xc46, 0xc02, 0x3b, 0xc1c, 0xc28,
0xc35, 0xc30, 0xc3f, 0x3b, 0xc2b, 0xc3f, 0xc2c, 0xc4d, 0xc30, 0xc35, 0xc30, 0xc3f, 0x3b, 0xc2e, 0xc3e, 0xc30, 0xc4d, 0xc1a, 0xc3f, 0x3b,
0xc0f, 0xc2a, 0xc4d, 0xc30, 0xc3f, 0xc32, 0xc4d, 0x3b, 0xc2e, 0xc47, 0x3b, 0xc1c, 0xc42, 0xc28, 0xc4d, 0x3b, 0xc1c, 0xc41, 0xc32, 0xc48,
0x3b, 0xc06, 0xc17, 0xc38, 0xc4d, 0xc1f, 0xc41, 0x3b, 0xc38, 0xc46, 0xc2a, 0xc4d, 0xc1f, 0xc46, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc05,
0xc15, 0xc4d, 0xc1f, 0xc4b, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc28, 0xc35, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc21, 0xc3f, 0xc38, 0xc46, 0xc02,
0xc2c, 0xc30, 0xc4d, 0x3b, 0xc1c, 0x3b, 0xc2b, 0xc3f, 0x3b, 0xc2e, 0xc3e, 0x3b, 0xc0f, 0x3b, 0xc2e, 0xc47, 0x3b, 0xc1c, 0xc42, 0x3b,
0xc1c, 0xc41, 0x3b, 0xc06, 0x3b, 0xc38, 0xc46, 0x3b, 0xc05, 0x3b, 0xc28, 0x3b, 0xc21, 0xc3f, 0x3b, 0x52, 0x61, 0x72, 0x3b, 0x4d,
0x75, 0x6b, 0x3b, 0x4b, 0x77, 0x61, 0x3b, 0x44, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x6f, 0x64, 0x3b, 0x4a,
0x6f, 0x6c, 0x3b, 0x50, 0x65, 0x64, 0x3b, 0x53, 0x6f, 0x6b, 0x3b, 0x54, 0x69, 0x62, 0x3b, 0x4c, 0x61, 0x62, 0x3b, 0x50,
0x6f, 0x6f, 0x3b, 0x4f, 0x72, 0x61, 0x72, 0x61, 0x3b, 0x4f, 0x6d, 0x75, 0x6b, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x67,
0x2019, 0x3b, 0x4f, 0x64, 0x75, 0x6e, 0x67, 0x2019, 0x65, 0x6c, 0x3b, 0x4f, 0x6d, 0x61, 0x72, 0x75, 0x6b, 0x3b, 0x4f, 0x6d,
0x6f, 0x64, 0x6f, 0x6b, 0x2019, 0x6b, 0x69, 0x6e, 0x67, 0x2019, 0x6f, 0x6c, 0x3b, 0x4f, 0x6a, 0x6f, 0x6c, 0x61, 0x3b, 0x4f,
0x70, 0x65, 0x64, 0x65, 0x6c, 0x3b, 0x4f, 0x73, 0x6f, 0x6b, 0x6f, 0x73, 0x6f, 0x6b, 0x6f, 0x6d, 0x61, 0x3b, 0x4f, 0x74,
0x69, 0x62, 0x61, 0x72, 0x3b, 0x4f, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x3b, 0x4f, 0x70, 0x6f, 0x6f, 0x3b, 0x52, 0x3b, 0x4d,
0x3b, 0x4b, 0x3b, 0x44, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x50,
0x3b, 0xe21, 0x2e, 0xe04, 0x2e, 0x3b, 0xe01, 0x2e, 0xe1e, 0x2e, 0x3b, 0xe21, 0xe35, 0x2e, 0xe04, 0x2e, 0x3b, 0xe40, 0xe21, 0x2e,
0xe22, 0x2e, 0x3b, 0xe1e, 0x2e, 0xe04, 0x2e, 0x3b, 0xe21, 0xe34, 0x2e, 0xe22, 0x2e, 0x3b, 0xe01, 0x2e, 0xe04, 0x2e, 0x3b, 0xe2a,
0x2e, 0xe04, 0x2e, 0x3b, 0xe01, 0x2e, 0xe22, 0x2e, 0x3b, 0xe15, 0x2e, 0xe04, 0x2e, 0x3b, 0xe1e, 0x2e, 0xe22, 0x2e, 0x3b, 0xe18,
0x2e, 0xe04, 0x2e, 0x3b, 0xe21, 0xe01, 0xe23, 0xe32, 0xe04, 0xe21, 0x3b, 0xe01, 0xe38, 0xe21, 0xe20, 0xe32, 0xe1e, 0xe31, 0xe19, 0xe18,
0xe4c, 0x3b, 0xe21, 0xe35, 0xe19, 0xe32, 0xe04, 0xe21, 0x3b, 0xe40, 0xe21, 0xe29, 0xe32, 0xe22, 0xe19, 0x3b, 0xe1e, 0xe24, 0xe29, 0xe20,
0xe32, 0xe04, 0xe21, 0x3b, 0xe21, 0xe34, 0xe16, 0xe38, 0xe19, 0xe32, 0xe22, 0xe19, 0x3b, 0xe01, 0xe23, 0xe01, 0xe0e, 0xe32, 0xe04, 0xe21,
0x3b, 0xe2a, 0xe34, 0xe07, 0xe2b, 0xe32, 0xe04, 0xe21, 0x3b, 0xe01, 0xe31, 0xe19, 0xe22, 0xe32, 0xe22, 0xe19, 0x3b, 0xe15, 0xe38, 0xe25,
0xe32, 0xe04, 0xe21, 0x3b, 0xe1e, 0xe24, 0xe28, 0xe08, 0xe34, 0xe01, 0xe32, 0xe22, 0xe19, 0x3b, 0xe18, 0xe31, 0xe19, 0xe27, 0xe32, 0xe04,
0xe21, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xf44, 0xf0b, 0xf54, 0xf7c, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf42,
0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf42, 0xf66, 0xf74, 0xf58, 0xf0b, 0xf54, 0xf0b, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf5e, 0xf72, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf63, 0xf94, 0xf0b,
0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56,
0xf0b, 0xf56, 0xf51, 0xf74, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf62, 0xf92, 0xfb1, 0xf51, 0xf0b,
0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xf42, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b,
0xf56, 0xf45, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf45, 0xf72, 0xf42,
0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b,
0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xf44, 0xf0b, 0xf54, 0xf7c, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf42, 0xf49, 0xf72,
0xf66, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf42, 0xf66, 0xf74, 0xf58, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56,
0xf0b, 0xf56, 0xf5e, 0xf72, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf63, 0xf94, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b,
0xf56, 0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf51, 0xf74, 0xf53, 0xf0b, 0xf54,
0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf62, 0xf92, 0xfb1, 0xf51, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51,
0xf42, 0xf74, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56,
0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf45, 0xf72, 0xf42, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74,
0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0x3b, 0x1303, 0x1295, 0x12e9, 0x3b, 0x134c, 0x1265, 0x1229, 0x3b, 0x121b, 0x122d, 0x127d, 0x3b,
0x12a4, 0x1355, 0x1228, 0x3b, 0x121c, 0x12ed, 0x3b, 0x1301, 0x1295, 0x3b, 0x1301, 0x120b, 0x12ed, 0x3b, 0x12a6, 0x1308, 0x1235, 0x3b, 0x1234, 0x1355,
0x1274, 0x3b, 0x12a6, 0x12ad, 0x1270, 0x3b, 0x1296, 0x126c, 0x121d, 0x3b, 0x12f2, 0x1234, 0x121d, 0x3b, 0x1303, 0x1295, 0x12e9, 0x12c8, 0x122a, 0x3b,
0x134c, 0x1265, 0x1229, 0x12c8, 0x122a, 0x3b, 0x121b, 0x122d, 0x127d, 0x3b, 0x12a4, 0x1355, 0x1228, 0x120d, 0x3b, 0x121c, 0x12ed, 0x3b, 0x1301, 0x1295,
0x3b, 0x1301, 0x120b, 0x12ed, 0x3b, 0x12a6, 0x1308, 0x1235, 0x1275, 0x3b, 0x1234, 0x1355, 0x1274, 0x121d, 0x1260, 0x122d, 0x3b, 0x12a6, 0x12ad, 0x1270,
0x12cd, 0x1260, 0x122d, 0x3b, 0x1296, 0x126c, 0x121d, 0x1260, 0x122d, 0x3b, 0x12f2, 0x1234, 0x121d, 0x1260, 0x122d, 0x3b, 0x1325, 0x122a, 0x3b, 0x1208,
0x12ab, 0x3b, 0x1218, 0x130b, 0x3b, 0x121a, 0x12eb, 0x3b, 0x130d, 0x1295, 0x3b, 0x1230, 0x1290, 0x3b, 0x1213, 0x121d, 0x3b, 0x1290, 0x1213, 0x3b,
0x1218, 0x1235, 0x3b, 0x1325, 0x1245, 0x3b, 0x1215, 0x12f3, 0x3b, 0x1273, 0x1215, 0x3b, 0x1325, 0x122a, 0x3b, 0x1208, 0x12ab, 0x1272, 0x1275, 0x3b,
0x1218, 0x130b, 0x1262, 0x1275, 0x3b, 0x121a, 0x12eb, 0x12dd, 0x12eb, 0x3b, 0x130d, 0x1295, 0x1266, 0x1275, 0x3b, 0x1230, 0x1290, 0x3b, 0x1213, 0x121d,
0x1208, 0x3b, 0x1290, 0x1213, 0x1230, 0x3b, 0x1218, 0x1235, 0x12a8, 0x1228, 0x121d, 0x3b, 0x1325, 0x1245, 0x121d, 0x1272, 0x3b, 0x1215, 0x12f3, 0x122d,
0x3b, 0x1273, 0x1215, 0x1233, 0x1235, 0x3b, 0x1325, 0x3b, 0x1208, 0x3b, 0x1218, 0x3b, 0x121a, 0x3b, 0x130d, 0x3b, 0x1230, 0x3b, 0x1213, 0x3b,
0x1290, 0x3b, 0x1218, 0x3b, 0x1325, 0x3b, 0x1215, 0x3b, 0x1273, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61,
0x73, 0x3b, 0x45, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x4f, 0x67, 0x61,
0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e,
0x75, 0x65, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x65, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x73, 0x3b, 0x45, 0x70,
0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x4f, 0x67, 0x61,
0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f,
0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x53, 0x101, 0x6e, 0x3b, 0x46, 0x113,
0x70, 0x3b, 0x4d, 0x61, 0x2bb, 0x61, 0x3b, 0x2bb, 0x45, 0x70, 0x65, 0x3b, 0x4d, 0x113, 0x3b, 0x53, 0x75, 0x6e, 0x3b, 0x53,
0x69, 0x75, 0x3b, 0x2bb, 0x41, 0x6f, 0x6b, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x2bb, 0x4f, 0x6b, 0x61, 0x3b, 0x4e, 0x14d, 0x76,
0x3b, 0x54, 0x12b, 0x73, 0x3b, 0x53, 0x101, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x46, 0x113, 0x70, 0x75, 0x65, 0x6c, 0x69,
0x3b, 0x4d, 0x61, 0x2bb, 0x61, 0x73, 0x69, 0x3b, 0x2bb, 0x45, 0x70, 0x65, 0x6c, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x113, 0x3b,
0x53, 0x75, 0x6e, 0x65, 0x3b, 0x53, 0x69, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x2bb, 0x41, 0x6f, 0x6b, 0x6f, 0x73, 0x69, 0x3b,
0x53, 0x65, 0x70, 0x69, 0x74, 0x65, 0x6d, 0x61, 0x3b, 0x2bb, 0x4f, 0x6b, 0x61, 0x74, 0x6f, 0x70, 0x61, 0x3b, 0x4e, 0x14d,
0x76, 0x65, 0x6d, 0x61, 0x3b, 0x54, 0x12b, 0x73, 0x65, 0x6d, 0x61, 0x3b, 0x53, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x45, 0x3b,
0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x46, 0x3b,
0x4d, 0x3b, 0x2bb, 0x45, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x2bb, 0x41, 0x3b, 0x53, 0x3b, 0x2bb, 0x4f, 0x3b, 0x4e,
0x3b, 0x54, 0x3b, 0x53, 0x75, 0x6e, 0x3b, 0x59, 0x61, 0x6e, 0x3b, 0x4b, 0x75, 0x6c, 0x3b, 0x44, 0x7a, 0x69, 0x3b, 0x4d,
0x75, 0x64, 0x3b, 0x4b, 0x68, 0x6f, 0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x4d, 0x68, 0x61, 0x3b, 0x4e, 0x64, 0x7a, 0x3b, 0x4e,
0x68, 0x6c, 0x3b, 0x48, 0x75, 0x6b, 0x3b, 0x4e, 0x2019, 0x77, 0x3b, 0x53, 0x75, 0x6e, 0x67, 0x75, 0x74, 0x69, 0x3b, 0x4e,
0x79, 0x65, 0x6e, 0x79, 0x65, 0x6e, 0x79, 0x61, 0x6e, 0x69, 0x3b, 0x4e, 0x79, 0x65, 0x6e, 0x79, 0x61, 0x6e, 0x6b, 0x75,
0x6c, 0x75, 0x3b, 0x44, 0x7a, 0x69, 0x76, 0x61, 0x6d, 0x69, 0x73, 0x6f, 0x6b, 0x6f, 0x3b, 0x4d, 0x75, 0x64, 0x79, 0x61,
0x78, 0x69, 0x68, 0x69, 0x3b, 0x4b, 0x68, 0x6f, 0x74, 0x61, 0x76, 0x75, 0x78, 0x69, 0x6b, 0x61, 0x3b, 0x4d, 0x61, 0x77,
0x75, 0x77, 0x61, 0x6e, 0x69, 0x3b, 0x4d, 0x68, 0x61, 0x77, 0x75, 0x72, 0x69, 0x3b, 0x4e, 0x64, 0x7a, 0x68, 0x61, 0x74,
0x69, 0x3b, 0x4e, 0x68, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x61, 0x3b, 0x48, 0x75, 0x6b, 0x75, 0x72, 0x69, 0x3b, 0x4e,
0x2019, 0x77, 0x65, 0x6e, 0x64, 0x7a, 0x61, 0x6d, 0x68, 0x61, 0x6c, 0x61, 0x3b, 0x46, 0x65, 0x72, 0x3b, 0x54, 0x6c, 0x68,
0x3b, 0x4d, 0x6f, 0x70, 0x3b, 0x4d, 0x6f, 0x72, 0x3b, 0x4d, 0x6f, 0x74, 0x3b, 0x53, 0x65, 0x65, 0x3b, 0x50, 0x68, 0x75,
0x3b, 0x50, 0x68, 0x61, 0x3b, 0x4c, 0x77, 0x65, 0x3b, 0x44, 0x69, 0x70, 0x3b, 0x4e, 0x67, 0x77, 0x3b, 0x53, 0x65, 0x64,
0x3b, 0x46, 0x65, 0x72, 0x69, 0x6b, 0x67, 0x6f, 0x6e, 0x67, 0x3b, 0x54, 0x6c, 0x68, 0x61, 0x6b, 0x6f, 0x6c, 0x65, 0x3b,
0x4d, 0x6f, 0x70, 0x69, 0x74, 0x6c, 0x6f, 0x3b, 0x4d, 0x6f, 0x72, 0x61, 0x6e, 0x61, 0x6e, 0x67, 0x3b, 0x4d, 0x6f, 0x74,
0x73, 0x68, 0x65, 0x67, 0x61, 0x6e, 0x61, 0x6e, 0x67, 0x3b, 0x53, 0x65, 0x65, 0x74, 0x65, 0x62, 0x6f, 0x73, 0x69, 0x67,
0x6f, 0x3b, 0x50, 0x68, 0x75, 0x6b, 0x77, 0x69, 0x3b, 0x50, 0x68, 0x61, 0x74, 0x77, 0x65, 0x3b, 0x4c, 0x77, 0x65, 0x74,
0x73, 0x65, 0x3b, 0x44, 0x69, 0x70, 0x68, 0x61, 0x6c, 0x61, 0x6e, 0x65, 0x3b, 0x4e, 0x67, 0x77, 0x61, 0x6e, 0x61, 0x74,
0x73, 0x65, 0x6c, 0x65, 0x3b, 0x53, 0x65, 0x64, 0x69, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6f, 0x6c, 0x65, 0x3b, 0x4f, 0x63,
0x61, 0x3b, 0x15e, 0x75, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4e, 0x69, 0x73, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x48, 0x61,
0x7a, 0x3b, 0x54, 0x65, 0x6d, 0x3b, 0x41, 0x11f, 0x75, 0x3b, 0x45, 0x79, 0x6c, 0x3b, 0x45, 0x6b, 0x69, 0x3b, 0x4b, 0x61,
0x73, 0x3b, 0x41, 0x72, 0x61, 0x3b, 0x4f, 0x63, 0x61, 0x6b, 0x3b, 0x15e, 0x75, 0x62, 0x61, 0x74, 0x3b, 0x4d, 0x61, 0x72,
0x74, 0x3b, 0x4e, 0x69, 0x73, 0x61, 0x6e, 0x3b, 0x4d, 0x61, 0x79, 0x131, 0x73, 0x3b, 0x48, 0x61, 0x7a, 0x69, 0x72, 0x61,
0x6e, 0x3b, 0x54, 0x65, 0x6d, 0x6d, 0x75, 0x7a, 0x3b, 0x41, 0x11f, 0x75, 0x73, 0x74, 0x6f, 0x73, 0x3b, 0x45, 0x79, 0x6c,
0xfc, 0x6c, 0x3b, 0x45, 0x6b, 0x69, 0x6d, 0x3b, 0x4b, 0x61, 0x73, 0x131, 0x6d, 0x3b, 0x41, 0x72, 0x61, 0x6c, 0x131, 0x6b,
0x3b, 0x4f, 0x3b, 0x15e, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x45, 0x3b, 0x45,
0x3b, 0x4b, 0x3b, 0x41, 0x3b, 0xdd, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x77, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72,
0x3b, 0x4d, 0x61, 0xfd, 0x3b, 0x49, 0xfd, 0x75, 0x6e, 0x3b, 0x49, 0xfd, 0x75, 0x6c, 0x3b, 0x41, 0x77, 0x67, 0x3b, 0x53,
0x65, 0x6e, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0xfd, 0x3b, 0x44, 0x65, 0x6b, 0x3b, 0xdd, 0x61, 0x6e, 0x77, 0x61,
0x72, 0x3b, 0x46, 0x65, 0x77, 0x72, 0x61, 0x6c, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x3b,
0x4d, 0x61, 0xfd, 0x3b, 0x49, 0xfd, 0x75, 0x6e, 0x3b, 0x49, 0xfd, 0x75, 0x6c, 0x3b, 0x41, 0x77, 0x67, 0x75, 0x73, 0x74,
0x3b, 0x53, 0x65, 0x6e, 0x74, 0xfd, 0x61, 0x62, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0xfd, 0x61, 0x62, 0x72, 0x3b, 0x4e, 0x6f,
0xfd, 0x61, 0x62, 0x72, 0x3b, 0x44, 0x65, 0x6b, 0x61, 0x62, 0x72, 0x3b, 0xdd, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b,
0x4d, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0xfd, 0x61, 0x6e, 0x3b,
0x66, 0x65, 0x77, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0xfd, 0x3b, 0x69, 0xfd, 0x75,
0x6e, 0x3b, 0x69, 0xfd, 0x75, 0x6c, 0x3b, 0x61, 0x77, 0x67, 0x3b, 0x73, 0x65, 0x6e, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e,
0x6f, 0xfd, 0x3b, 0x64, 0x65, 0x6b, 0x3b, 0xfd, 0x61, 0x6e, 0x77, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x77, 0x72, 0x61, 0x6c,
0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x6d, 0x61, 0xfd, 0x3b, 0x69, 0xfd, 0x75, 0x6e,
0x3b, 0x69, 0xfd, 0x75, 0x6c, 0x3b, 0x61, 0x77, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x6e, 0x74, 0xfd, 0x61, 0x62,
0x72, 0x3b, 0x6f, 0x6b, 0x74, 0xfd, 0x61, 0x62, 0x72, 0x3b, 0x6e, 0x6f, 0xfd, 0x61, 0x62, 0x72, 0x3b, 0x64, 0x65, 0x6b,
0x61, 0x62, 0x72, 0x3b, 0x4a, 0x75, 0x77, 0x3b, 0x53, 0x77, 0x69, 0x3b, 0x54, 0x73, 0x61, 0x3b, 0x4e, 0x79, 0x61, 0x3b,
0x54, 0x73, 0x77, 0x3b, 0x41, 0x74, 0x61, 0x3b, 0x41, 0x6e, 0x61, 0x3b, 0x41, 0x72, 0x69, 0x3b, 0x41, 0x6b, 0x75, 0x3b,
0x53, 0x77, 0x61, 0x3b, 0x4d, 0x61, 0x6e, 0x3b, 0x4d, 0x61, 0x73, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x4a, 0x75, 0x77,
0x75, 0x6e, 0x67, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x53, 0x77, 0x69, 0x79, 0x61, 0x6e, 0x67, 0x3b, 0x5a, 0x77, 0x61,
0x74, 0x20, 0x54, 0x73, 0x61, 0x74, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x4e, 0x79, 0x61, 0x69, 0x3b, 0x5a, 0x77, 0x61,
0x74, 0x20, 0x54, 0x73, 0x77, 0x6f, 0x6e, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x41, 0x74, 0x61, 0x61, 0x68, 0x3b, 0x5a,
0x77, 0x61, 0x74, 0x20, 0x41, 0x6e, 0x61, 0x74, 0x61, 0x74, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x41, 0x72, 0x69, 0x6e,
0x61, 0x69, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x41, 0x6b, 0x75, 0x62, 0x75, 0x6e, 0x79, 0x75, 0x6e, 0x67, 0x3b, 0x5a,
0x77, 0x61, 0x74, 0x20, 0x53, 0x77, 0x61, 0x67, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x4d, 0x61, 0x6e, 0x67, 0x6a, 0x75,
0x77, 0x61, 0x6e, 0x67, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x53, 0x77, 0x61, 0x67, 0x2d, 0x4d, 0x61, 0x2d, 0x53, 0x75,
0x79, 0x61, 0x6e, 0x67, 0x3b, 0x441, 0x456, 0x447, 0x3b, 0x43b, 0x44e, 0x442, 0x3b, 0x431, 0x435, 0x440, 0x3b, 0x43a, 0x432, 0x456,
0x3b, 0x442, 0x440, 0x430, 0x3b, 0x447, 0x435, 0x440, 0x3b, 0x43b, 0x438, 0x43f, 0x3b, 0x441, 0x435, 0x440, 0x3b, 0x432, 0x435, 0x440,
0x3b, 0x436, 0x43e, 0x432, 0x3b, 0x43b, 0x438, 0x441, 0x3b, 0x433, 0x440, 0x443, 0x3b, 0x441, 0x456, 0x447, 0x435, 0x43d, 0x44c, 0x3b,
0x43b, 0x44e, 0x442, 0x438, 0x439, 0x3b, 0x431, 0x435, 0x440, 0x435, 0x437, 0x435, 0x43d, 0x44c, 0x3b, 0x43a, 0x432, 0x456, 0x442, 0x435,
0x43d, 0x44c, 0x3b, 0x442, 0x440, 0x430, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x447, 0x435, 0x440, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x43b,
0x438, 0x43f, 0x435, 0x43d, 0x44c, 0x3b, 0x441, 0x435, 0x440, 0x43f, 0x435, 0x43d, 0x44c, 0x3b, 0x432, 0x435, 0x440, 0x435, 0x441, 0x435,
0x43d, 0x44c, 0x3b, 0x436, 0x43e, 0x432, 0x442, 0x435, 0x43d, 0x44c, 0x3b, 0x43b, 0x438, 0x441, 0x442, 0x43e, 0x43f, 0x430, 0x434, 0x3b,
0x433, 0x440, 0x443, 0x434, 0x435, 0x43d, 0x44c, 0x3b, 0x421, 0x3b, 0x41b, 0x3b, 0x411, 0x3b, 0x41a, 0x3b, 0x422, 0x3b, 0x427, 0x3b,
0x41b, 0x3b, 0x421, 0x3b, 0x412, 0x3b, 0x416, 0x3b, 0x41b, 0x3b, 0x413, 0x3b, 0x441, 0x456, 0x447, 0x2e, 0x3b, 0x43b, 0x44e, 0x442,
0x2e, 0x3b, 0x431, 0x435, 0x440, 0x2e, 0x3b, 0x43a, 0x432, 0x456, 0x442, 0x2e, 0x3b, 0x442, 0x440, 0x430, 0x432, 0x2e, 0x3b, 0x447,
0x435, 0x440, 0x432, 0x2e, 0x3b, 0x43b, 0x438, 0x43f, 0x2e, 0x3b, 0x441, 0x435, 0x440, 0x43f, 0x2e, 0x3b, 0x432, 0x435, 0x440, 0x2e,
0x3b, 0x436, 0x43e, 0x432, 0x442, 0x2e, 0x3b, 0x43b, 0x438, 0x441, 0x442, 0x2e, 0x3b, 0x433, 0x440, 0x443, 0x434, 0x2e, 0x3b, 0x441,
0x456, 0x447, 0x43d, 0x44f, 0x3b, 0x43b, 0x44e, 0x442, 0x43e, 0x433, 0x43e, 0x3b, 0x431, 0x435, 0x440, 0x435, 0x437, 0x43d, 0x44f, 0x3b,
0x43a, 0x432, 0x456, 0x442, 0x43d, 0x44f, 0x3b, 0x442, 0x440, 0x430, 0x432, 0x43d, 0x44f, 0x3b, 0x447, 0x435, 0x440, 0x432, 0x43d, 0x44f,
0x3b, 0x43b, 0x438, 0x43f, 0x43d, 0x44f, 0x3b, 0x441, 0x435, 0x440, 0x43f, 0x43d, 0x44f, 0x3b, 0x432, 0x435, 0x440, 0x435, 0x441, 0x43d,
0x44f, 0x3b, 0x436, 0x43e, 0x432, 0x442, 0x43d, 0x44f, 0x3b, 0x43b, 0x438, 0x441, 0x442, 0x43e, 0x43f, 0x430, 0x434, 0x430, 0x3b, 0x433,
0x440, 0x443, 0x434, 0x43d, 0x44f, 0x3b, 0x441, 0x3b, 0x43b, 0x3b, 0x431, 0x3b, 0x43a, 0x3b, 0x442, 0x3b, 0x447, 0x3b, 0x43b, 0x3b,
0x441, 0x3b, 0x432, 0x3b, 0x436, 0x3b, 0x43b, 0x3b, 0x433, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x11b,
0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x65, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x77,
0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x77, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61,
0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x11b, 0x72, 0x63, 0x3b, 0x61, 0x70,
0x72, 0x79, 0x6c, 0x3b, 0x6d, 0x65, 0x6a, 0x61, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6a, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6a,
0x3b, 0x61, 0x77, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b,
0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x77, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x11b, 0x72, 0x2e, 0x3b, 0x61,
0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x65, 0x6a, 0x2e, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61,
0x77, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x77, 0x2e, 0x3b, 0x64,
0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x61, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x61,
0x3b, 0x6d, 0x11b, 0x72, 0x63, 0x61, 0x3b, 0x61, 0x70, 0x72, 0x79, 0x6c, 0x61, 0x3b, 0x6d, 0x65, 0x6a, 0x65, 0x3b, 0x6a,
0x75, 0x6e, 0x69, 0x6a, 0x61, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6a, 0x61, 0x3b, 0x61, 0x77, 0x67, 0x75, 0x73, 0x74, 0x61,
0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x72, 0x61, 0x3b, 0x6e,
0x6f, 0x77, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x62c, 0x646, 0x648,
0x631, 0x6cc, 0x3b, 0x641, 0x631, 0x648, 0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b,
0x645, 0x626, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x626, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b,
0x633, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f,
0x633, 0x645, 0x628, 0x631, 0x3b, 0x64a, 0x627, 0x646, 0x6cb, 0x627, 0x631, 0x3b, 0x641, 0x6d0, 0x6cb, 0x631, 0x627, 0x644, 0x3b, 0x645,
0x627, 0x631, 0x62a, 0x3b, 0x626, 0x627, 0x67e, 0x631, 0x6d0, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x3b, 0x626, 0x649, 0x64a, 0x6c7, 0x646,
0x3b, 0x626, 0x649, 0x64a, 0x6c7, 0x644, 0x3b, 0x626, 0x627, 0x6cb, 0x63a, 0x6c7, 0x633, 0x62a, 0x3b, 0x633, 0x6d0, 0x646, 0x62a, 0x6d5,
0x628, 0x649, 0x631, 0x3b, 0x626, 0x6c6, 0x643, 0x62a, 0x6d5, 0x628, 0x649, 0x631, 0x3b, 0x646, 0x648, 0x64a, 0x627, 0x628, 0x649, 0x631,
0x3b, 0x62f, 0x6d0, 0x643, 0x627, 0x628, 0x649, 0x631, 0x3b, 0x59, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72,
0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x49, 0x79, 0x6e, 0x3b, 0x49, 0x79, 0x6c, 0x3b, 0x41, 0x76, 0x67,
0x3b, 0x53, 0x65, 0x6e, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x79, 0x3b, 0x44, 0x65, 0x6b, 0x3b, 0x59, 0x61, 0x6e,
0x76, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x76, 0x72, 0x61, 0x6c, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x65,
0x6c, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x49, 0x79, 0x75, 0x6e, 0x3b, 0x49, 0x79, 0x75, 0x6c, 0x3b, 0x41, 0x76, 0x67, 0x75,
0x73, 0x74, 0x3b, 0x53, 0x65, 0x6e, 0x74, 0x61, 0x62, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x61, 0x62, 0x72, 0x3b, 0x4e, 0x6f,
0x79, 0x61, 0x62, 0x72, 0x3b, 0x44, 0x65, 0x6b, 0x61, 0x62, 0x72, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b,
0x4d, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x79, 0x61, 0x6e, 0x3b,
0x66, 0x65, 0x76, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x69, 0x79, 0x6e, 0x3b,
0x69, 0x79, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x3b, 0x73, 0x65, 0x6e, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x79, 0x3b,
0x64, 0x65, 0x6b, 0x3b, 0x79, 0x61, 0x6e, 0x76, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x76, 0x72, 0x61, 0x6c, 0x3b, 0x6d, 0x61,
0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x69, 0x79, 0x75, 0x6e, 0x3b, 0x69, 0x79,
0x75, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x62, 0x72, 0x3b, 0x6f, 0x6b,
0x74, 0x61, 0x62, 0x72, 0x3b, 0x6e, 0x6f, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x64, 0x65, 0x6b, 0x61, 0x62, 0x72, 0x3b, 0x62c,
0x646, 0x648, 0x3b, 0x641, 0x628, 0x631, 0x3b, 0x645, 0x627, 0x631, 0x3b, 0x627, 0x67e, 0x631, 0x3b, 0x645, 0x6cc, 0x3b, 0x62c, 0x648,
0x646, 0x3b, 0x62c, 0x648, 0x644, 0x3b, 0x627, 0x6af, 0x633, 0x3b, 0x633, 0x67e, 0x62a, 0x3b, 0x627, 0x6a9, 0x62a, 0x3b, 0x646, 0x648,
0x645, 0x3b, 0x62f, 0x633, 0x645, 0x3b, 0x44f, 0x43d, 0x432, 0x430, 0x440, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x3b, 0x43c,
0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x435, 0x43b, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x44e, 0x43d, 0x3b, 0x438, 0x44e,
0x43b, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x3b, 0x43e, 0x43a, 0x442,
0x44f, 0x431, 0x440, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x440, 0x3b, 0x434, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x3b, 0xa5a8, 0xa595, 0xa51e,
0x3b, 0xa552, 0xa561, 0x3b, 0xa57e, 0xa5ba, 0x3b, 0xa5a2, 0xa595, 0x3b, 0xa591, 0xa571, 0x3b, 0xa5b1, 0xa60b, 0x3b, 0xa5b1, 0xa55e, 0x3b, 0xa5db,
0xa515, 0x3b, 0xa562, 0xa54c, 0x3b, 0xa56d, 0xa583, 0x3b, 0xa51e, 0xa60b, 0x3b, 0xa5a8, 0xa595, 0xa5cf, 0x3b, 0xa5a8, 0xa595, 0x20, 0xa56a, 0xa574,
0x20, 0xa51e, 0xa500, 0xa56e, 0xa54a, 0x3b, 0xa552, 0xa561, 0xa59d, 0xa595, 0x3b, 0xa57e, 0xa5ba, 0x3b, 0xa5a2, 0xa595, 0x3b, 0xa591, 0xa571, 0x3b,
0xa5b1, 0xa60b, 0x3b, 0xa5b1, 0xa55e, 0xa524, 0x3b, 0xa5db, 0xa515, 0x3b, 0xa562, 0xa54c, 0x3b, 0xa56d, 0xa583, 0x3b, 0xa51e, 0xa60b, 0xa554, 0xa57f,
0x20, 0xa578, 0xa583, 0xa5cf, 0x3b, 0xa5a8, 0xa595, 0x20, 0xa56a, 0xa574, 0x20, 0xa5cf, 0xa5ba, 0xa56e, 0xa54a, 0x3b, 0x50, 0x68, 0x61, 0x3b,
0x4c, 0x75, 0x68, 0x3b, 0x1e70, 0x68, 0x66, 0x3b, 0x4c, 0x61, 0x6d, 0x3b, 0x53, 0x68, 0x75, 0x3b, 0x4c, 0x77, 0x69, 0x3b,
0x4c, 0x77, 0x61, 0x3b, 0x1e70, 0x68, 0x61, 0x3b, 0x4b, 0x68, 0x75, 0x3b, 0x54, 0x73, 0x68, 0x3b, 0x1e3c, 0x61, 0x72, 0x3b,
0x4e, 0x79, 0x65, 0x3b, 0x50, 0x68, 0x61, 0x6e, 0x64, 0x6f, 0x3b, 0x4c, 0x75, 0x68, 0x75, 0x68, 0x69, 0x3b, 0x1e70, 0x68,
0x61, 0x66, 0x61, 0x6d, 0x75, 0x68, 0x77, 0x65, 0x3b, 0x4c, 0x61, 0x6d, 0x62, 0x61, 0x6d, 0x61, 0x69, 0x3b, 0x53, 0x68,
0x75, 0x6e, 0x64, 0x75, 0x6e, 0x74, 0x68, 0x75, 0x6c, 0x65, 0x3b, 0x46, 0x75, 0x6c, 0x77, 0x69, 0x3b, 0x46, 0x75, 0x6c,
0x77, 0x61, 0x6e, 0x61, 0x3b, 0x1e70, 0x68, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x65, 0x3b, 0x4b, 0x68, 0x75, 0x62, 0x76, 0x75,
0x6d, 0x65, 0x64, 0x7a, 0x69, 0x3b, 0x54, 0x73, 0x68, 0x69, 0x6d, 0x65, 0x64, 0x7a, 0x69, 0x3b, 0x1e3c, 0x61, 0x72, 0x61,
0x3b, 0x4e, 0x79, 0x65, 0x6e, 0x64, 0x61, 0x76, 0x68, 0x75, 0x73, 0x69, 0x6b, 0x75, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x31,
0x3b, 0x54, 0x68, 0x67, 0x20, 0x32, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x33, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x34, 0x3b, 0x54,
0x68, 0x67, 0x20, 0x35, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x36, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x37, 0x3b, 0x54, 0x68, 0x67,
0x20, 0x38, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x39, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x31, 0x30, 0x3b, 0x54, 0x68, 0x67, 0x20,
0x31, 0x31, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x31, 0x32, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x3b, 0x54, 0x68,
0xe1, 0x6e, 0x67, 0x20, 0x32, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x33, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20,
0x34, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x35, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x36, 0x3b, 0x54, 0x68,
0xe1, 0x6e, 0x67, 0x20, 0x37, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x38, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20,
0x39, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x30, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x31, 0x3b,
0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x32, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x32,
0x3b, 0x74, 0x68, 0x67, 0x20, 0x33, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x34, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x35, 0x3b, 0x74,
0x68, 0x67, 0x20, 0x36, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x37, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x38, 0x3b, 0x74, 0x68, 0x67,
0x20, 0x39, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31, 0x30, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31, 0x31, 0x3b, 0x74, 0x68, 0x67,
0x20, 0x31, 0x32, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x32, 0x3b,
0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x33, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x34, 0x3b, 0x74, 0x68, 0xe1, 0x6e,
0x67, 0x20, 0x35, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x36, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x37, 0x3b,
0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x38, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x39, 0x3b, 0x74, 0x68, 0xe1, 0x6e,
0x67, 0x20, 0x31, 0x30, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x31, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20,
0x31, 0x32, 0x3b, 0x79, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0xe4, 0x7a, 0x3b, 0x70, 0x72, 0x6c, 0x3b, 0x6d,
0x61, 0x79, 0x3b, 0x79, 0x75, 0x6e, 0x3b, 0x79, 0x75, 0x6c, 0x3b, 0x67, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74, 0x3b, 0x74,
0x6f, 0x62, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x6b, 0x3b, 0x79, 0x61, 0x6e, 0x75, 0x6c, 0x3b, 0x66, 0x65, 0x62,
0x75, 0x6c, 0x3b, 0x6d, 0xe4, 0x7a, 0x75, 0x6c, 0x3b, 0x70, 0x72, 0x69, 0x6c, 0x75, 0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x75,
0x6c, 0x3b, 0x79, 0x75, 0x6e, 0x75, 0x6c, 0x3b, 0x79, 0x75, 0x6c, 0x75, 0x6c, 0x3b, 0x67, 0x75, 0x73, 0x74, 0x75, 0x6c,
0x3b, 0x73, 0x65, 0x74, 0x75, 0x6c, 0x3b, 0x74, 0x6f, 0x62, 0x75, 0x6c, 0x3b, 0x6e, 0x6f, 0x76, 0x75, 0x6c, 0x3b, 0x64,
0x65, 0x6b, 0x75, 0x6c, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x50, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x47,
0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x79, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0xe4, 0x7a,
0x3b, 0x70, 0x72, 0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x79, 0x75, 0x6e, 0x3b, 0x79, 0x75, 0x6c, 0x3b, 0x67, 0x73, 0x74,
0x3b, 0x73, 0x65, 0x74, 0x3b, 0x74, 0x6f, 0x6e, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x6b, 0x3b, 0x4a, 0x65, 0x6e,
0x3b, 0x48, 0x6f, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x42, 0x72, 0xe1,
0x3b, 0x48, 0x65, 0x69, 0x3b, 0xd6, 0x69, 0x67, 0x3b, 0x48, 0x65, 0x72, 0x3b, 0x57, 0xed, 0x6d, 0x3b, 0x57, 0x69, 0x6e,
0x3b, 0x43, 0x68, 0x72, 0x3b, 0x4a, 0x65, 0x6e, 0x6e, 0x65, 0x72, 0x3b, 0x48, 0x6f, 0x72, 0x6e, 0x69, 0x67, 0x3b, 0x4d,
0xe4, 0x72, 0x7a, 0x65, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x6c, 0x65, 0x3b, 0x4d, 0x65, 0x69, 0x6a, 0x65, 0x3b, 0x42,
0x72, 0xe1, 0x10d, 0x65, 0x74, 0x3b, 0x48, 0x65, 0x69, 0x77, 0x65, 0x74, 0x3b, 0xd6, 0x69, 0x67, 0x161, 0x74, 0x65, 0x3b,
0x48, 0x65, 0x72, 0x62, 0x161, 0x74, 0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b, 0x57, 0xed, 0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b,
0x57, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b, 0x43, 0x68, 0x72, 0x69, 0x161, 0x74, 0x6d, 0xe1,
0x6e, 0x65, 0x74, 0x3b, 0x4a, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x42, 0x3b, 0x48, 0x3b, 0xd6, 0x3b,
0x48, 0x3b, 0x57, 0x3b, 0x57, 0x3b, 0x43, 0x3b, 0x49, 0x6f, 0x6e, 0x3b, 0x43, 0x68, 0x77, 0x3b, 0x4d, 0x61, 0x77, 0x3b,
0x45, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4d, 0x65, 0x68, 0x3b, 0x47, 0x6f, 0x72, 0x3b, 0x41, 0x77, 0x73, 0x74,
0x3b, 0x4d, 0x65, 0x64, 0x69, 0x3b, 0x48, 0x79, 0x64, 0x3b, 0x54, 0x61, 0x63, 0x68, 0x3b, 0x52, 0x68, 0x61, 0x67, 0x3b,
0x49, 0x6f, 0x6e, 0x61, 0x77, 0x72, 0x3b, 0x43, 0x68, 0x77, 0x65, 0x66, 0x72, 0x6f, 0x72, 0x3b, 0x4d, 0x61, 0x77, 0x72,
0x74, 0x68, 0x3b, 0x45, 0x62, 0x72, 0x69, 0x6c, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4d, 0x65, 0x68, 0x65, 0x66, 0x69,
0x6e, 0x3b, 0x47, 0x6f, 0x72, 0x66, 0x66, 0x65, 0x6e, 0x6e, 0x61, 0x66, 0x3b, 0x41, 0x77, 0x73, 0x74, 0x3b, 0x4d, 0x65,
0x64, 0x69, 0x3b, 0x48, 0x79, 0x64, 0x72, 0x65, 0x66, 0x3b, 0x54, 0x61, 0x63, 0x68, 0x77, 0x65, 0x64, 0x64, 0x3b, 0x52,
0x68, 0x61, 0x67, 0x66, 0x79, 0x72, 0x3b, 0x49, 0x3b, 0x43, 0x68, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b,
0x47, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x52, 0x68, 0x3b, 0x49, 0x6f, 0x6e, 0x3b, 0x43, 0x68, 0x77,
0x65, 0x66, 0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x45, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4d, 0x65, 0x68, 0x3b, 0x47,
0x6f, 0x72, 0x66, 0x66, 0x3b, 0x41, 0x77, 0x73, 0x74, 0x3b, 0x4d, 0x65, 0x64, 0x69, 0x3b, 0x48, 0x79, 0x64, 0x3b, 0x54,
0x61, 0x63, 0x68, 0x3b, 0x52, 0x68, 0x61, 0x67, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x72, 0x74,
0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67,
0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e,
0x6e, 0x65, 0x77, 0x61, 0x72, 0x69, 0x73, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x65, 0x77, 0x61, 0x72, 0x69, 0x73, 0x3b, 0x4d,
0x61, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x61, 0x69, 0x65, 0x3b, 0x4a, 0x75, 0x6e,
0x79, 0x3b, 0x4a, 0x75, 0x6c, 0x79, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74,
0x69, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x69, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x44, 0x65, 0x73, 0x69, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x53, 0x61, 0x6d, 0x3b, 0x46, 0x65, 0x77, 0x3b,
0x4d, 0x61, 0x72, 0x3b, 0x41, 0x77, 0x72, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x53, 0x75, 0x77, 0x3b, 0x53, 0x75, 0x6c, 0x3b,
0x55, 0x74, 0x3b, 0x53, 0xe0, 0x74, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x77, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x53,
0x61, 0x6d, 0x77, 0x69, 0x79, 0x65, 0x65, 0x3b, 0x46, 0x65, 0x77, 0x72, 0x69, 0x79, 0x65, 0x65, 0x3b, 0x4d, 0x61, 0x72,
0x73, 0x3b, 0x41, 0x77, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x53, 0x75, 0x77, 0x65, 0x3b, 0x53, 0x75, 0x6c,
0x65, 0x74, 0x3b, 0x55, 0x74, 0x3b, 0x53, 0xe0, 0x74, 0x74, 0x75, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f,
0x6f, 0x62, 0x61, 0x72, 0x3b, 0x4e, 0x6f, 0x77, 0xe0, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x44, 0x65, 0x73, 0xe0, 0x6d, 0x62,
0x61, 0x72, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x74, 0x3b, 0x45, 0x70, 0x72, 0x3b, 0x4d,
0x65, 0x79, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f,
0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x79, 0x75, 0x77, 0x61, 0x72, 0x69,
0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x77, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x74, 0x73, 0x68, 0x69, 0x3b, 0x45, 0x70,
0x72, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x65, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x79,
0x69, 0x3b, 0x41, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b,
0x74, 0x68, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62,
0x61, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x74, 0x3b, 0x45, 0x70, 0x72, 0x3b, 0x4d, 0x65,
0x79, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x3b, 0x4f,
0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x79, 0x75, 0x77, 0x61, 0x72, 0x69,
0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x77, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x74, 0x73, 0x68, 0x69, 0x3b, 0x45, 0x70,
0x72, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x65, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x79,
0x69, 0x3b, 0x41, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b,
0x74, 0x68, 0x6f, 0x62, 0x68, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d,
0x62, 0x61, 0x3b, 0x6f, 0x2e, 0x31, 0x3b, 0x6f, 0x2e, 0x32, 0x3b, 0x6f, 0x2e, 0x33, 0x3b, 0x6f, 0x2e, 0x34, 0x3b, 0x6f,
0x2e, 0x35, 0x3b, 0x6f, 0x2e, 0x36, 0x3b, 0x6f, 0x2e, 0x37, 0x3b, 0x6f, 0x2e, 0x38, 0x3b, 0x6f, 0x2e, 0x39, 0x3b, 0x6f,
0x2e, 0x31, 0x30, 0x3b, 0x6f, 0x2e, 0x31, 0x31, 0x3b, 0x6f, 0x2e, 0x31, 0x32, 0x3b, 0x70, 0x69, 0x6b, 0xed, 0x74, 0xed,
0x6b, 0xed, 0x74, 0x69, 0x65, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0xed, 0x20, 0xfa, 0x20, 0x6b, 0x75, 0x74, 0xfa, 0x61, 0x6e,
0x3b, 0x73, 0x69, 0x25b, 0x79, 0x25b, 0x301, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe1, 0x6e, 0x64,
0xed, 0x25b, 0x3b, 0x254, 0x6e, 0x73, 0xfa, 0x6d, 0x62, 0x254, 0x6c, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20,
0x6b, 0xe1, 0x74, 0xe1, 0x74, 0xfa, 0x25b, 0x3b, 0x6d, 0x65, 0x73, 0x69, 0x14b, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20,
0xfa, 0x20, 0x6b, 0xe9, 0x6e, 0x69, 0x65, 0x3b, 0x65, 0x6e, 0x73, 0x69, 0x6c, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20,
0xfa, 0x20, 0x6b, 0xe1, 0x74, 0xe1, 0x6e, 0x75, 0x25b, 0x3b, 0x254, 0x73, 0x254, 0x6e, 0x3b, 0x65, 0x66, 0x75, 0x74, 0x65,
0x3b, 0x70, 0x69, 0x73, 0x75, 0x79, 0xfa, 0x3b, 0x69, 0x6d, 0x25b, 0x14b, 0x20, 0x69, 0x20, 0x70, 0x75, 0x254, 0x73, 0x3b,
0x69, 0x6d, 0x25b, 0x14b, 0x20, 0x69, 0x20, 0x70, 0x75, 0x74, 0xfa, 0x6b, 0x2c, 0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20,
0x6b, 0xe1, 0x74, 0xed, 0x25b, 0x3b, 0x6d, 0x61, 0x6b, 0x61, 0x6e, 0x64, 0x69, 0x6b, 0x25b, 0x3b, 0x70, 0x69, 0x6c, 0x254,
0x6e, 0x64, 0x254, 0x301, 0x3b, 0x5d9, 0x5d0, 0x5b7, 0x5e0, 0x3b, 0x5e4, 0x5bf, 0x5e2, 0x5d1, 0x3b, 0x5de, 0x5e2, 0x5e8, 0x5e5, 0x3b,
0x5d0, 0x5b7, 0x5e4, 0x5bc, 0x5e8, 0x3b, 0x5de, 0x5d9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5e0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dc, 0x5d9, 0x3b,
0x5d0, 0x5d5, 0x5d9, 0x5d2, 0x3b, 0x5e1, 0x5e2, 0x5e4, 0x5bc, 0x3b, 0x5d0, 0x5e7, 0x5d8, 0x3b, 0x5e0, 0x5d0, 0x5d5, 0x5d5, 0x3b, 0x5d3,
0x5e2, 0x5e6, 0x3b, 0x5d9, 0x5d0, 0x5b7, 0x5e0, 0x5d5, 0x5d0, 0x5b7, 0x5e8, 0x3b, 0x5e4, 0x5bf, 0x5e2, 0x5d1, 0x5e8, 0x5d5, 0x5d0, 0x5b7,
0x5e8, 0x3b, 0x5de, 0x5e2, 0x5e8, 0x5e5, 0x3b, 0x5d0, 0x5b7, 0x5e4, 0x5bc, 0x5e8, 0x5d9, 0x5dc, 0x3b, 0x5de, 0x5d9, 0x5d9, 0x3b, 0x5d9,
0x5d5, 0x5e0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dc, 0x5d9, 0x3b, 0x5d0, 0x5d5, 0x5d9, 0x5d2, 0x5d5, 0x5e1, 0x5d8, 0x3b, 0x5e1, 0x5e2, 0x5e4,
0x5bc, 0x5d8, 0x5e2, 0x5de, 0x5d1, 0x5e2, 0x5e8, 0x3b, 0x5d0, 0x5e7, 0x5d8, 0x5d0, 0x5d1, 0x5e2, 0x5e8, 0x3b, 0x5e0, 0x5d0, 0x5d5, 0x5d5,
0x5e2, 0x5de, 0x5d1, 0x5e2, 0x5e8, 0x3b, 0x5d3, 0x5e2, 0x5e6, 0x5e2, 0x5de, 0x5d1, 0x5e2, 0x5e8, 0x3b, 0x1e62, 0x1eb9, 0x301, 0x3b, 0xc8,
0x72, 0x3b, 0x1eb8, 0x72, 0x3b, 0xcc, 0x67, 0x3b, 0x1eb8, 0x300, 0x62, 0x3b, 0xd2, 0x6b, 0x3b, 0x41, 0x67, 0x3b, 0xd2, 0x67,
0x3b, 0x4f, 0x77, 0x3b, 0x1ecc, 0x300, 0x77, 0x3b, 0x42, 0xe9, 0x3b, 0x1ecc, 0x300, 0x70, 0x3b, 0x1e62, 0x1eb9, 0x301, 0x72, 0x1eb9,
0x301, 0x3b, 0xc8, 0x72, 0xe8, 0x6c, 0xe8, 0x3b, 0x1eb8, 0x72, 0x1eb9, 0x300, 0x6e, 0xe0, 0x3b, 0xcc, 0x67, 0x62, 0xe9, 0x3b,
0x1eb8, 0x300, 0x62, 0x69, 0x62, 0x69, 0x3b, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x41, 0x67, 0x1eb9, 0x6d, 0x1ecd, 0x3b, 0xd2,
0x67, 0xfa, 0x6e, 0x3b, 0x4f, 0x77, 0x65, 0x77, 0x65, 0x3b, 0x1ecc, 0x300, 0x77, 0xe0, 0x72, 0xe0, 0x3b, 0x42, 0xe9, 0x6c,
0xfa, 0x3b, 0x1ecc, 0x300, 0x70, 0x1eb9, 0x300, 0x3b, 0x53, 0x3b, 0xc8, 0x3b, 0x1eb8, 0x3b, 0xcc, 0x3b, 0x1eb8, 0x300, 0x3b, 0xd2,
0x3b, 0x41, 0x3b, 0xd2, 0x3b, 0x4f, 0x3b, 0x1ecc, 0x300, 0x3b, 0x42, 0x3b, 0x1ecc, 0x300, 0x3b, 0x1e62, 0x1eb9, 0x301, 0x72, 0x3b,
0xc8, 0x72, 0xe8, 0x6c, 0x3b, 0x1eb8, 0x72, 0x1eb9, 0x300, 0x6e, 0x3b, 0xcc, 0x67, 0x62, 0x3b, 0x1eb8, 0x300, 0x62, 0x69, 0x3b,
0xd2, 0x6b, 0xfa, 0x3b, 0x41, 0x67, 0x1eb9, 0x3b, 0xd2, 0x67, 0xfa, 0x3b, 0x4f, 0x77, 0x65, 0x3b, 0x1ecc, 0x300, 0x77, 0xe0,
0x3b, 0x42, 0xe9, 0x6c, 0x3b, 0x1ecc, 0x300, 0x70, 0x1eb9, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1e62, 0x1eb9, 0x301, 0x72, 0x1eb9, 0x301,
0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xc8, 0x72, 0xe8, 0x6c, 0xe8, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1eb8, 0x72, 0x1eb9, 0x300, 0x6e,
0xe0, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xcc, 0x67, 0x62, 0xe9, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1eb8, 0x300, 0x62, 0x69, 0x62,
0x69, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x41, 0x67, 0x1eb9, 0x6d,
0x1ecd, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xd2, 0x67, 0xfa, 0x6e, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x4f, 0x77, 0x65, 0x77, 0x65,
0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1ecc, 0x300, 0x77, 0xe0, 0x72, 0xe0, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x42, 0xe9, 0x6c, 0xfa,
0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1ecc, 0x300, 0x70, 0x1eb9, 0x300, 0x3b, 0x53, 0x68, 0x25b, 0x301, 0x3b, 0xc8, 0x72, 0x3b, 0x190,
0x72, 0x3b, 0xcc, 0x67, 0x3b, 0x190, 0x300, 0x62, 0x3b, 0xd2, 0x6b, 0x3b, 0x41, 0x67, 0x3b, 0xd2, 0x67, 0x3b, 0x4f, 0x77,
0x3b, 0x186, 0x300, 0x77, 0x3b, 0x42, 0xe9, 0x3b, 0x186, 0x300, 0x70, 0x3b, 0x53, 0x68, 0x25b, 0x301, 0x72, 0x25b, 0x301, 0x3b,
0xc8, 0x72, 0xe8, 0x6c, 0xe8, 0x3b, 0x190, 0x72, 0x25b, 0x300, 0x6e, 0xe0, 0x3b, 0xcc, 0x67, 0x62, 0xe9, 0x3b, 0x190, 0x300,
0x62, 0x69, 0x62, 0x69, 0x3b, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x41, 0x67, 0x25b, 0x6d, 0x254, 0x3b, 0xd2, 0x67, 0xfa,
0x6e, 0x3b, 0x4f, 0x77, 0x65, 0x77, 0x65, 0x3b, 0x186, 0x300, 0x77, 0xe0, 0x72, 0xe0, 0x3b, 0x42, 0xe9, 0x6c, 0xfa, 0x3b,
0x186, 0x300, 0x70, 0x25b, 0x300, 0x3b, 0x53, 0x3b, 0xc8, 0x3b, 0x190, 0x3b, 0xcc, 0x3b, 0x190, 0x300, 0x3b, 0xd2, 0x3b, 0x41,
0x3b, 0xd2, 0x3b, 0x4f, 0x3b, 0x186, 0x300, 0x3b, 0x42, 0x3b, 0x186, 0x300, 0x3b, 0x53, 0x68, 0x25b, 0x301, 0x72, 0x3b, 0xc8,
0x72, 0xe8, 0x6c, 0x3b, 0x190, 0x72, 0x25b, 0x300, 0x6e, 0x3b, 0xcc, 0x67, 0x62, 0x3b, 0x190, 0x300, 0x62, 0x69, 0x3b, 0xd2,
0x6b, 0xfa, 0x3b, 0x41, 0x67, 0x25b, 0x3b, 0xd2, 0x67, 0xfa, 0x3b, 0x4f, 0x77, 0x65, 0x3b, 0x186, 0x300, 0x77, 0xe0, 0x3b,
0x42, 0xe9, 0x6c, 0x3b, 0x186, 0x300, 0x70, 0x25b, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x53, 0x68, 0x25b, 0x301, 0x72, 0x25b,
0x301, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0xc8, 0x72, 0xe8, 0x6c, 0xe8, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x190, 0x72,
0x25b, 0x300, 0x6e, 0xe0, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0xcc, 0x67, 0x62, 0xe9, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20,
0x190, 0x300, 0x62, 0x69, 0x62, 0x69, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x4f, 0x73,
0x68, 0xf9, 0x20, 0x41, 0x67, 0x25b, 0x6d, 0x254, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0xd2, 0x67, 0xfa, 0x6e, 0x3b, 0x4f,
0x73, 0x68, 0xf9, 0x20, 0x4f, 0x77, 0x65, 0x77, 0x65, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x186, 0x300, 0x77, 0xe0, 0x72,
0xe0, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x42, 0xe9, 0x6c, 0xfa, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x186, 0x300, 0x70,
0x25b, 0x300, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x73, 0x3b, 0x45, 0x70, 0x68, 0x3b, 0x4d,
0x65, 0x79, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f,
0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x77, 0x61, 0x72, 0x69, 0x3b,
0x46, 0x65, 0x62, 0x72, 0x75, 0x77, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x73, 0x68, 0x69, 0x3b, 0x45, 0x70, 0x68, 0x72,
0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x65, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x79, 0x69,
0x3b, 0x41, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x68, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b,
0x74, 0x68, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62,
0x61, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b,
0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b
};

static const ushort days_data[] = {
0x53, 0x75, 0x6e, 0x3b, 0x4d, 0x6f, 0x6e, 0x3b, 0x54, 0x75, 0x65, 0x3b, 0x57, 0x65, 0x64, 0x3b, 0x54, 0x68, 0x75, 0x3b,
0x46, 0x72, 0x69, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x53, 0x75, 0x6e, 0x64, 0x61, 0x79, 0x3b, 0x4d, 0x6f, 0x6e, 0x64, 0x61,
0x79, 0x3b, 0x54, 0x75, 0x65, 0x73, 0x64, 0x61, 0x79, 0x3b, 0x57, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x64, 0x61, 0x79, 0x3b,
0x54, 0x68, 0x75, 0x72, 0x73, 0x64, 0x61, 0x79, 0x3b, 0x46, 0x72, 0x69, 0x64, 0x61, 0x79, 0x3b, 0x53, 0x61, 0x74, 0x75,
0x72, 0x64, 0x61, 0x79, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x57, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x53, 0x3b, 0x37,
0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x410, 0x43c, 0x3b, 0x410, 0x448, 0x4d9, 0x3b,
0x410, 0x4a9, 0x3b, 0x410, 0x445, 0x3b, 0x410, 0x525, 0x3b, 0x410, 0x445, 0x4d9, 0x3b, 0x410, 0x441, 0x3b, 0x410, 0x43c, 0x4bd, 0x44b,
0x448, 0x430, 0x3b, 0x410, 0x448, 0x4d9, 0x430, 0x445, 0x44c, 0x430, 0x3b, 0x410, 0x4a9, 0x430, 0x448, 0x430, 0x3b, 0x410, 0x445, 0x430,
0x448, 0x430, 0x3b, 0x410, 0x525, 0x448, 0x44c, 0x430, 0x448, 0x430, 0x3b, 0x410, 0x445, 0x4d9, 0x430, 0x448, 0x430, 0x3b, 0x410, 0x441,
0x430, 0x431, 0x448, 0x430, 0x3b, 0x41c, 0x3b, 0x428, 0x4d9, 0x3b, 0x4a8, 0x3b, 0x425, 0x3b, 0x524, 0x3b, 0x425, 0x4d9, 0x3b, 0x421,
0x3b, 0x41, 0x63, 0x61, 0x3b, 0x45, 0x74, 0x6c, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x41, 0x72, 0x62, 0x3b, 0x4b, 0x61, 0x6d,
0x3b, 0x47, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x41, 0x63, 0x61, 0x61, 0x64, 0x61, 0x3b, 0x45, 0x74, 0x6c, 0x65,
0x65, 0x6e, 0x69, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x72, 0x62, 0x61, 0x71, 0x61, 0x3b, 0x4b,
0x61, 0x6d, 0x69, 0x69, 0x73, 0x69, 0x3b, 0x47, 0x75, 0x6d, 0x71, 0x61, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x69,
0x3b, 0x41, 0x3b, 0x45, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x53, 0x6f, 0x2e, 0x3b, 0x4d,
0x61, 0x2e, 0x3b, 0x44, 0x69, 0x2e, 0x3b, 0x57, 0x6f, 0x2e, 0x3b, 0x44, 0x6f, 0x2e, 0x3b, 0x56, 0x72, 0x2e, 0x3b, 0x53,
0x61, 0x2e, 0x3b, 0x53, 0x6f, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x4d, 0x61, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x44, 0x69,
0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x57, 0x6f, 0x65, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x44, 0x6f, 0x6e, 0x64, 0x65,
0x72, 0x64, 0x61, 0x67, 0x3b, 0x56, 0x72, 0x79, 0x64, 0x61, 0x67, 0x3b, 0x53, 0x61, 0x74, 0x65, 0x72, 0x64, 0x61, 0x67,
0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x6e, 0x74, 0x73, 0x3b, 0x6b,
0x70, 0x61, 0x3b, 0x67, 0x68, 0x254, 0x3b, 0x74, 0x254, 0x6d, 0x3b, 0x75, 0x6d, 0x65, 0x3b, 0x67, 0x68, 0x268, 0x3b, 0x64,
0x7a, 0x6b, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x6e, 0x74, 0x73, 0x268, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x6b, 0x70, 0xe0,
0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x67, 0x68, 0x254, 0x65, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x74, 0x254, 0x300, 0x6d,
0x6c, 0xf2, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x6d, 0xe8, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x67, 0x68, 0x268, 0x302,
0x6d, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x6e, 0x64, 0x7a, 0x268, 0x6b, 0x254, 0x294, 0x254, 0x3b, 0x6e, 0x3b, 0x6b, 0x3b, 0x67,
0x3b, 0x74, 0x3b, 0x75, 0x3b, 0x67, 0x3b, 0x64, 0x3b, 0x4b, 0x77, 0x65, 0x3b, 0x44, 0x77, 0x6f, 0x3b, 0x42, 0x65, 0x6e,
0x3b, 0x57, 0x75, 0x6b, 0x3b, 0x59, 0x61, 0x77, 0x3b, 0x46, 0x69, 0x61, 0x3b, 0x4d, 0x65, 0x6d, 0x3b, 0x4b, 0x77, 0x65,
0x73, 0x69, 0x64, 0x61, 0x3b, 0x44, 0x77, 0x6f, 0x77, 0x64, 0x61, 0x3b, 0x42, 0x65, 0x6e, 0x61, 0x64, 0x61, 0x3b, 0x57,
0x75, 0x6b, 0x75, 0x64, 0x61, 0x3b, 0x59, 0x61, 0x77, 0x64, 0x61, 0x3b, 0x46, 0x69, 0x64, 0x61, 0x3b, 0x4d, 0x65, 0x6d,
0x65, 0x6e, 0x65, 0x64, 0x61, 0x3b, 0x4b, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x57, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x64, 0x69, 0x65, 0x3b, 0x68, 0xeb, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0xeb, 0x72, 0x3b, 0x65, 0x6e, 0x6a, 0x3b,
0x70, 0x72, 0x65, 0x3b, 0x73, 0x68, 0x74, 0x3b, 0x65, 0x20, 0x64, 0x69, 0x65, 0x6c, 0x3b, 0x65, 0x20, 0x68, 0xeb, 0x6e,
0xeb, 0x3b, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x74, 0xeb, 0x3b, 0x65, 0x20, 0x6d, 0xeb, 0x72, 0x6b, 0x75, 0x72, 0xeb, 0x3b,
0x65, 0x20, 0x65, 0x6e, 0x6a, 0x74, 0x65, 0x3b, 0x65, 0x20, 0x70, 0x72, 0x65, 0x6d, 0x74, 0x65, 0x3b, 0x65, 0x20, 0x73,
0x68, 0x74, 0x75, 0x6e, 0xeb, 0x3b, 0x64, 0x3b, 0x68, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x65, 0x3b, 0x70, 0x3b, 0x73, 0x68,
0x3b, 0x44, 0x69, 0x65, 0x3b, 0x48, 0xeb, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0xeb, 0x72, 0x3b, 0x45, 0x6e, 0x6a,
0x3b, 0x50, 0x72, 0x65, 0x3b, 0x53, 0x68, 0x74, 0x3b, 0x12a5, 0x1211, 0x12f5, 0x3b, 0x1230, 0x129e, 0x3b, 0x121b, 0x12ad, 0x1230, 0x3b,
0x1228, 0x1261, 0x12d5, 0x3b, 0x1210, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1265, 0x3b, 0x1245, 0x12f3, 0x121c, 0x3b, 0x12a5, 0x1211, 0x12f5, 0x3b,
0x1230, 0x129e, 0x3b, 0x121b, 0x12ad, 0x1230, 0x129e, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1210, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1265, 0x3b,
0x1245, 0x12f3, 0x121c, 0x3b, 0x12a5, 0x3b, 0x1230, 0x3b, 0x121b, 0x3b, 0x1228, 0x3b, 0x1210, 0x3b, 0x12d3, 0x3b, 0x1245, 0x3b, 0x627, 0x644,
0x623, 0x62d, 0x62f, 0x3b, 0x627, 0x644, 0x627, 0x62b, 0x646, 0x64a, 0x646, 0x3b, 0x627, 0x644, 0x62b, 0x644, 0x627, 0x62b, 0x627, 0x621,
0x3b, 0x627, 0x644, 0x623, 0x631, 0x628, 0x639, 0x627, 0x621, 0x3b, 0x627, 0x644, 0x62e, 0x645, 0x64a, 0x633, 0x3b, 0x627, 0x644, 0x62c,
0x645, 0x639, 0x629, 0x3b, 0x627, 0x644, 0x633, 0x628, 0x62a, 0x3b, 0x62d, 0x3b, 0x646, 0x3b, 0x62b, 0x3b, 0x631, 0x3b, 0x62e, 0x3b,
0x62c, 0x3b, 0x633, 0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x69, 0x65, 0x3b,
0x63, 0x68, 0x75, 0x3b, 0x76, 0x69, 0x65, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x63, 0x68, 0x65,
0x3b, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x7a, 0x3b, 0x6d, 0x69, 0x65, 0x72, 0x63, 0x72, 0x65, 0x73,
0x3b, 0x63, 0x68, 0x75, 0x65, 0x76, 0x65, 0x73, 0x3b, 0x76, 0x69, 0x65, 0x72, 0x6e, 0x65, 0x73, 0x3b, 0x73, 0x61, 0x62,
0x61, 0x64, 0x6f, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x61, 0x3b, 0x4d, 0x69, 0x3b, 0x43, 0x68, 0x3b, 0x56, 0x3b, 0x53,
0x3b, 0x56f, 0x56b, 0x580, 0x3b, 0x565, 0x580, 0x56f, 0x3b, 0x565, 0x580, 0x584, 0x3b, 0x579, 0x580, 0x584, 0x3b, 0x570, 0x576, 0x563,
0x3b, 0x578, 0x582, 0x580, 0x3b, 0x577, 0x562, 0x569, 0x3b, 0x56f, 0x56b, 0x580, 0x561, 0x56f, 0x56b, 0x3b, 0x565, 0x580, 0x56f, 0x578,
0x582, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x565, 0x580, 0x565, 0x584, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x579, 0x578, 0x580,
0x565, 0x584, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x570, 0x56b, 0x576, 0x563, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x578, 0x582,
0x580, 0x562, 0x561, 0x569, 0x3b, 0x577, 0x561, 0x562, 0x561, 0x569, 0x3b, 0x53f, 0x3b, 0x535, 0x3b, 0x535, 0x3b, 0x549, 0x3b, 0x540,
0x3b, 0x548, 0x3b, 0x547, 0x3b, 0x9a6, 0x9c7, 0x993, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x3b, 0x9ac,
0x9c1, 0x9a7, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9f0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x3b, 0x9a6, 0x9c7, 0x993,
0x9ac, 0x9be, 0x9f0, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x9ac, 0x9be, 0x9f0, 0x3b,
0x9ac, 0x9c1, 0x9a7, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b8, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9b6,
0x9c1, 0x995, 0x9cd, 0x9f0, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9a6, 0x3b, 0x9b8, 0x3b, 0x9ae,
0x3b, 0x9ac, 0x3b, 0x9ac, 0x3b, 0x9b6, 0x3b, 0x9b6, 0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x6c, 0x75, 0x3b, 0x6d, 0x61, 0x72,
0x3b, 0x6d, 0x69, 0xe9, 0x3b, 0x78, 0x75, 0x65, 0x3b, 0x76, 0x69, 0x65, 0x3b, 0x73, 0xe1, 0x62, 0x3b, 0x64, 0x6f, 0x6d,
0x69, 0x6e, 0x67, 0x75, 0x3b, 0x6c, 0x6c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x6d,
0x69, 0xe9, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b, 0x78, 0x75, 0x65, 0x76, 0x65, 0x73, 0x3b, 0x76, 0x69, 0x65, 0x6e,
0x72, 0x65, 0x73, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x75, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x58,
0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x4a, 0x70, 0x69, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e,
0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x6d, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c,
0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75,
0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a,
0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x3b, 0x59, 0x6f, 0x6b, 0x3b, 0x54, 0x75, 0x6e, 0x67, 0x3b, 0x47, 0x69, 0x74, 0x75,
0x6e, 0x67, 0x3b, 0x54, 0x73, 0x61, 0x6e, 0x3b, 0x4e, 0x61, 0x73, 0x3b, 0x4e, 0x61, 0x74, 0x3b, 0x43, 0x68, 0x69, 0x72,
0x3b, 0x57, 0x61, 0x69, 0x20, 0x59, 0x6f, 0x6b, 0x61, 0x20, 0x42, 0x61, 0x77, 0x61, 0x69, 0x3b, 0x57, 0x61, 0x69, 0x20,
0x54, 0x75, 0x6e, 0x67, 0x61, 0x3b, 0x54, 0x6f, 0x6b, 0x69, 0x20, 0x47, 0x69, 0x74, 0x75, 0x6e, 0x67, 0x3b, 0x54, 0x73,
0x61, 0x6d, 0x20, 0x4b, 0x61, 0x73, 0x75, 0x77, 0x61, 0x3b, 0x57, 0x61, 0x69, 0x20, 0x4e, 0x61, 0x20, 0x4e, 0x61, 0x73,
0x3b, 0x57, 0x61, 0x69, 0x20, 0x4e, 0x61, 0x20, 0x54, 0x69, 0x79, 0x6f, 0x6e, 0x3b, 0x57, 0x61, 0x69, 0x20, 0x4e, 0x61,
0x20, 0x43, 0x68, 0x69, 0x72, 0x69, 0x6d, 0x3b, 0x42, 0x2e, 0x3b, 0x42, 0x2e, 0x45, 0x2e, 0x3b, 0xc7, 0x2e, 0x41, 0x2e,
0x3b, 0xc7, 0x2e, 0x3b, 0x43, 0x2e, 0x41, 0x2e, 0x3b, 0x43, 0x2e, 0x3b, 0x15e, 0x2e, 0x3b, 0x62, 0x61, 0x7a, 0x61, 0x72,
0x3b, 0x62, 0x61, 0x7a, 0x61, 0x72, 0x20, 0x65, 0x72, 0x74, 0x259, 0x73, 0x69, 0x3b, 0xe7, 0x259, 0x72, 0x15f, 0x259, 0x6e,
0x62, 0x259, 0x20, 0x61, 0x78, 0x15f, 0x61, 0x6d, 0x131, 0x3b, 0xe7, 0x259, 0x72, 0x15f, 0x259, 0x6e, 0x62, 0x259, 0x3b, 0x63,
0xfc, 0x6d, 0x259, 0x20, 0x61, 0x78, 0x15f, 0x61, 0x6d, 0x131, 0x3b, 0x63, 0xfc, 0x6d, 0x259, 0x3b, 0x15f, 0x259, 0x6e, 0x62,
0x259, 0x3b, 0x42, 0x2e, 0x3b, 0x42, 0x2e, 0x65, 0x2e, 0x3b, 0xc7, 0x2e, 0x61, 0x2e, 0x3b, 0xc7, 0x2e, 0x3b, 0x43, 0x2e,
0x61, 0x2e, 0x3b, 0x43, 0x2e, 0x3b, 0x15e, 0x2e, 0x3b, 0x411, 0x2e, 0x3b, 0x411, 0x2e, 0x415, 0x2e, 0x3b, 0x427, 0x2e, 0x410,
0x2e, 0x3b, 0x427, 0x2e, 0x3b, 0x4b8, 0x2e, 0x410, 0x2e, 0x3b, 0x4b8, 0x2e, 0x3b, 0x428, 0x2e, 0x3b, 0x431, 0x430, 0x437, 0x430,
0x440, 0x3b, 0x431, 0x430, 0x437, 0x430, 0x440, 0x20, 0x435, 0x440, 0x442, 0x4d9, 0x441, 0x438, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9,
0x43d, 0x431, 0x4d9, 0x20, 0x430, 0x445, 0x448, 0x430, 0x43c, 0x44b, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9, 0x43d, 0x431, 0x4d9, 0x3b,
0x4b9, 0x4af, 0x43c, 0x4d9, 0x20, 0x430, 0x445, 0x448, 0x430, 0x43c, 0x44b, 0x3b, 0x4b9, 0x4af, 0x43c, 0x4d9, 0x3b, 0x448, 0x4d9, 0x43d,
0x431, 0x4d9, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6c, 0x1dd, 0x6e, 0x3b, 0x6d, 0x61, 0x61, 0x3b, 0x6d, 0x25b, 0x6b, 0x3b,
0x6a, 0x1dd, 0x1dd, 0x3b, 0x6a, 0xfa, 0x6d, 0x3b, 0x73, 0x61, 0x6d, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x1dd, 0x3b, 0x6c,
0x1dd, 0x6e, 0x64, 0xed, 0x3b, 0x6d, 0x61, 0x61, 0x64, 0xed, 0x3b, 0x6d, 0x25b, 0x6b, 0x72, 0x25b, 0x64, 0xed, 0x3b, 0x6a,
0x1dd, 0x1dd, 0x64, 0xed, 0x3b, 0x6a, 0xfa, 0x6d, 0x62, 0xe1, 0x3b, 0x73, 0x61, 0x6d, 0x64, 0xed, 0x3b, 0x73, 0x3b, 0x6c,
0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x6a, 0x3b, 0x73, 0x3b, 0x6cc, 0x6a9, 0x3b, 0x62f, 0x648, 0x3b, 0x633, 0x626, 0x6d2,
0x3b, 0x686, 0x627, 0x631, 0x3b, 0x67e, 0x646, 0x686, 0x3b, 0x62c, 0x645, 0x647, 0x3b, 0x634, 0x645, 0x3b, 0x6cc, 0x6a9, 0x634, 0x645,
0x628, 0x647, 0x3b, 0x62f, 0x648, 0x634, 0x645, 0x628, 0x647, 0x3b, 0x633, 0x626, 0x6cc, 0x634, 0x645, 0x628, 0x647, 0x3b, 0x686, 0x627,
0x631, 0x634, 0x645, 0x628, 0x647, 0x3b, 0x67e, 0x646, 0x686, 0x634, 0x645, 0x628, 0x647, 0x3b, 0x62c, 0x645, 0x647, 0x3b, 0x634, 0x645,
0x628, 0x647, 0x3b, 0x59, 0x61, 0x6b, 0x3b, 0x44, 0x6f, 0x3b, 0x53, 0x61, 0x79, 0x3b, 0x43, 0x68, 0xe1, 0x3b, 0x50, 0x61,
0x6e, 0x3b, 0x4a, 0x6f, 0x6d, 0x3b, 0x53, 0x68, 0x61, 0x3b, 0x59, 0x61, 0x6b, 0x73, 0x68, 0x61, 0x6d, 0x62, 0x65, 0x68,
0x3b, 0x44, 0x6f, 0x73, 0x68, 0x61, 0x6d, 0x62, 0x65, 0x68, 0x3b, 0x53, 0x61, 0x79, 0x73, 0x68, 0x61, 0x6d, 0x62, 0x65,
0x68, 0x3b, 0x43, 0x68, 0xe1, 0x72, 0x73, 0x68, 0x61, 0x6d, 0x62, 0x65, 0x68, 0x3b, 0x50, 0x61, 0x6e, 0x63, 0x68, 0x73,
0x68, 0x61, 0x6d, 0x62, 0x65, 0x68, 0x3b, 0x4a, 0x6f, 0x6d, 0x61, 0x68, 0x3b, 0x53, 0x68, 0x61, 0x6d, 0x62, 0x65, 0x68,
0x3b, 0x6b, 0x61, 0x72, 0x3b, 0x6e, 0x74, 0x25b, 0x3b, 0x74, 0x61, 0x72, 0x3b, 0x61, 0x72, 0x61, 0x3b, 0x61, 0x6c, 0x61,
0x3b, 0x6a, 0x75, 0x6d, 0x3b, 0x73, 0x69, 0x62, 0x3b, 0x6b, 0x61, 0x72, 0x69, 0x3b, 0x6e, 0x74, 0x25b, 0x6e, 0x25b, 0x3b,
0x74, 0x61, 0x72, 0x61, 0x74, 0x61, 0x3b, 0x61, 0x72, 0x61, 0x62, 0x61, 0x3b, 0x61, 0x6c, 0x61, 0x6d, 0x69, 0x73, 0x61,
0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x73, 0x69, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x41,
0x3b, 0x41, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x9b0, 0x9ac, 0x9bf, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2,
0x3b, 0x9ac, 0x9c1, 0x9a7, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b8, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9b0, 0x3b,
0x9b6, 0x9a8, 0x9bf, 0x3b, 0x9b0, 0x9ac, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ae, 0x999,
0x9cd, 0x997, 0x9b2, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b8, 0x9cd, 0x9aa,
0x9a4, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9b0, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9ac, 0x9be,
0x9b0, 0x3b, 0x9b0, 0x3b, 0x9b8, 0x9cb, 0x3b, 0x9ae, 0x3b, 0x9ac, 0x9c1, 0x3b, 0x9ac, 0x9c3, 0x3b, 0x9b6, 0x9c1, 0x3b, 0x9b6, 0x3b,
0x6e, 0x254, 0x79, 0x3b, 0x6e, 0x6a, 0x61, 0x3b, 0x75, 0x75, 0x6d, 0x3b, 0x14b, 0x67, 0x65, 0x3b, 0x6d, 0x62, 0x254, 0x3b,
0x6b, 0x254, 0x254, 0x3b, 0x6a, 0x6f, 0x6e, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6e, 0x254, 0x302, 0x79, 0x3b, 0x14b, 0x67,
0x77, 0xe0, 0x20, 0x6e, 0x6a, 0x61, 0x14b, 0x67, 0x75, 0x6d, 0x62, 0x61, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0xfb, 0x6d,
0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x14b, 0x67, 0xea, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6d, 0x62, 0x254, 0x6b, 0x3b,
0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6b, 0x254, 0x254, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6a, 0xf4, 0x6e, 0x3b, 0x6e, 0x3b,
0x6e, 0x3b, 0x75, 0x3b, 0x14b, 0x3b, 0x6d, 0x3b, 0x6b, 0x3b, 0x6a, 0x3b, 0x69, 0x67, 0x2e, 0x3b, 0x61, 0x6c, 0x2e, 0x3b,
0x61, 0x72, 0x2e, 0x3b, 0x61, 0x7a, 0x2e, 0x3b, 0x6f, 0x67, 0x2e, 0x3b, 0x6f, 0x72, 0x2e, 0x3b, 0x6c, 0x72, 0x2e, 0x3b,
0x69, 0x67, 0x61, 0x6e, 0x64, 0x65, 0x61, 0x3b, 0x61, 0x73, 0x74, 0x65, 0x6c, 0x65, 0x68, 0x65, 0x6e, 0x61, 0x3b, 0x61,
0x73, 0x74, 0x65, 0x61, 0x72, 0x74, 0x65, 0x61, 0x3b, 0x61, 0x73, 0x74, 0x65, 0x61, 0x7a, 0x6b, 0x65, 0x6e, 0x61, 0x3b,
0x6f, 0x73, 0x74, 0x65, 0x67, 0x75, 0x6e, 0x61, 0x3b, 0x6f, 0x73, 0x74, 0x69, 0x72, 0x61, 0x6c, 0x61, 0x3b, 0x6c, 0x61,
0x72, 0x75, 0x6e, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x49, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x4f, 0x3b, 0x4f, 0x3b,
0x4c, 0x3b, 0x43d, 0x434, 0x3b, 0x43f, 0x43d, 0x3b, 0x430, 0x45e, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x446, 0x3b, 0x43f, 0x442, 0x3b,
0x441, 0x431, 0x3b, 0x43d, 0x44f, 0x434, 0x437, 0x435, 0x43b, 0x44f, 0x3b, 0x43f, 0x430, 0x43d, 0x44f, 0x434, 0x437, 0x435, 0x43b, 0x430,
0x43a, 0x3b, 0x430, 0x45e, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441, 0x435, 0x440, 0x430, 0x434, 0x430, 0x3b, 0x447, 0x430, 0x446,
0x432, 0x435, 0x440, 0x3b, 0x43f, 0x44f, 0x442, 0x43d, 0x456, 0x446, 0x430, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d,
0x3b, 0x43f, 0x3b, 0x430, 0x3b, 0x441, 0x3b, 0x447, 0x3b, 0x43f, 0x3b, 0x441, 0x3b, 0x50, 0x61, 0x20, 0x4d, 0x75, 0x6c, 0x75,
0x6e, 0x67, 0x75, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x6d, 0x6f, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68,
0x69, 0x62, 0x75, 0x6c, 0x69, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x50, 0x61,
0x6c, 0x69, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x73, 0x61, 0x6e, 0x6f, 0x3b,
0x50, 0x61, 0x63, 0x68, 0x69, 0x62, 0x65, 0x6c, 0x75, 0x73, 0x68, 0x69, 0x3b, 0x4d, 0x75, 0x6c, 0x3b, 0x56, 0x69, 0x6c,
0x3b, 0x48, 0x69, 0x76, 0x3b, 0x48, 0x69, 0x64, 0x3b, 0x48, 0x69, 0x74, 0x3b, 0x48, 0x69, 0x68, 0x3b, 0x4c, 0x65, 0x6d,
0x3b, 0x70, 0x61, 0x20, 0x6d, 0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x73, 0x68, 0x61, 0x68, 0x75,
0x76, 0x69, 0x6c, 0x75, 0x68, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x70, 0x61, 0x20,
0x68, 0x69, 0x64, 0x61, 0x74, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x74, 0x61, 0x79, 0x69, 0x3b, 0x70, 0x61, 0x20,
0x68, 0x69, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x73, 0x68, 0x61, 0x68, 0x75, 0x6c, 0x65, 0x6d, 0x62, 0x65,
0x6c, 0x61, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x48, 0x3b, 0x48, 0x3b, 0x48, 0x3b, 0x57, 0x3b, 0x4a, 0x3b, 0x930, 0x92c, 0x940,
0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x92c, 0x93e, 0x930, 0x3b, 0x92c,
0x941, 0x927, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x943, 0x939, 0x938, 0x94d, 0x92a, 0x924, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x941,
0x915, 0x94d, 0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x928, 0x940, 0x91a, 0x930, 0x3b, 0x1230, 0x2f, 0x1245, 0x3b, 0x1230, 0x1291, 0x3b,
0x1230, 0x120a, 0x131d, 0x3b, 0x1208, 0x1313, 0x3b, 0x12a3, 0x121d, 0x12f5, 0x3b, 0x12a3, 0x122d, 0x1265, 0x3b, 0x1230, 0x2f, 0x123d, 0x3b, 0x1230,
0x1295, 0x1260, 0x122d, 0x20, 0x1245, 0x12f3, 0x12c5, 0x3b, 0x1230, 0x1291, 0x3b, 0x1230, 0x120a, 0x131d, 0x3b, 0x1208, 0x1313, 0x20, 0x12c8, 0x122a,
0x20, 0x1208, 0x1265, 0x12cb, 0x3b, 0x12a3, 0x121d, 0x12f5, 0x3b, 0x12a3, 0x122d, 0x1265, 0x3b, 0x1230, 0x1295, 0x1260, 0x122d, 0x20, 0x123d, 0x1313,
0x12c5, 0x3b, 0x1230, 0x3b, 0x1230, 0x3b, 0x1230, 0x3b, 0x1208, 0x3b, 0x12a3, 0x3b, 0x12a3, 0x3b, 0x1230, 0x3b, 0x930, 0x92c, 0x93f, 0x3b,
0x938, 0x92e, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x3b, 0x92c, 0x941, 0x927, 0x3b, 0x92c, 0x93f, 0x938, 0x94d, 0x925, 0x93f, 0x3b, 0x938,
0x941, 0x916, 0x941, 0x930, 0x3b, 0x938, 0x928, 0x93f, 0x3b, 0x930, 0x92c, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x92e, 0x92c, 0x93e,
0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x93f, 0x938,
0x94d, 0x925, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x941, 0x941, 0x916, 0x941, 0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x928, 0x93f,
0x92c, 0x93e, 0x930, 0x3b, 0x930, 0x3b, 0x938, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b, 0x92c, 0x93f, 0x3b, 0x938, 0x941, 0x3b,
0x938, 0x3b, 0x930, 0x92c, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x92c,
0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x93f, 0x938, 0x94d, 0x925, 0x93f, 0x92c, 0x93e, 0x930, 0x3b,
0x938, 0x941, 0x916, 0x941, 0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x928, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x6e, 0x65, 0x64, 0x3b,
0x70, 0x6f, 0x6e, 0x3b, 0x75, 0x74, 0x6f, 0x3b, 0x73, 0x72, 0x69, 0x3b, 0x10d, 0x65, 0x74, 0x3b, 0x70, 0x65, 0x74, 0x3b,
0x73, 0x75, 0x62, 0x3b, 0x6e, 0x65, 0x64, 0x6a, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x65, 0x64, 0x6a, 0x65,
0x6c, 0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x6b, 0x3b, 0x73, 0x72, 0x69, 0x6a, 0x65, 0x64, 0x61, 0x3b,
0x10d, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x61, 0x6b, 0x3b, 0x73, 0x75, 0x62, 0x6f, 0x74,
0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x75, 0x3b, 0x73, 0x3b, 0x10d, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x4e, 0x3b, 0x50, 0x3b,
0x55, 0x3b, 0x53, 0x3b, 0x10c, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x43d, 0x435, 0x434, 0x3b, 0x43f, 0x43e, 0x43d, 0x3b, 0x443, 0x442,
0x43e, 0x3b, 0x441, 0x440, 0x438, 0x3b, 0x447, 0x435, 0x442, 0x3b, 0x43f, 0x435, 0x442, 0x3b, 0x441, 0x443, 0x431, 0x3b, 0x43d, 0x435,
0x434, 0x458, 0x435, 0x459, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x458, 0x435, 0x459, 0x430, 0x43a, 0x3b, 0x443, 0x442, 0x43e,
0x440, 0x430, 0x43a, 0x3b, 0x441, 0x440, 0x438, 0x458, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x430, 0x43a,
0x3b, 0x43f, 0x435, 0x442, 0x430, 0x43a, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x3b, 0x43f, 0x3b, 0x443, 0x3b,
0x441, 0x3b, 0x447, 0x3b, 0x43f, 0x3b, 0x441, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x65, 0x75, 0x2e,
0x3b, 0x4d, 0x65, 0x72, 0x2e, 0x3b, 0x59, 0x61, 0x6f, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x2e, 0x3b, 0x53, 0x61, 0x64, 0x2e,
0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x65, 0x75, 0x72, 0x7a, 0x68, 0x3b, 0x4d, 0x65, 0x72, 0x63,
0x2bc, 0x68, 0x65, 0x72, 0x3b, 0x59, 0x61, 0x6f, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x53, 0x61, 0x64,
0x6f, 0x72, 0x6e, 0x3b, 0x53, 0x75, 0x3b, 0x4c, 0x3b, 0x4d, 0x7a, 0x3b, 0x4d, 0x63, 0x3b, 0x59, 0x3b, 0x47, 0x3b, 0x53,
0x61, 0x3b, 0x43d, 0x434, 0x3b, 0x43f, 0x43d, 0x3b, 0x432, 0x442, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x442, 0x3b, 0x43f, 0x442, 0x3b,
0x441, 0x431, 0x3b, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x44f, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x43d, 0x438, 0x43a,
0x3b, 0x432, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x441, 0x440, 0x44f, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x44a,
0x440, 0x442, 0x44a, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x44a, 0x43a, 0x3b, 0x441, 0x44a, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x3b,
0x43f, 0x3b, 0x432, 0x3b, 0x441, 0x3b, 0x447, 0x3b, 0x43f, 0x3b, 0x441, 0x3b, 0x1010, 0x1014, 0x1004, 0x103a, 0x1039, 0x1002, 0x1014, 0x103d,
0x1031, 0x3b, 0x1010, 0x1014, 0x1004, 0x103a, 0x1039, 0x101c, 0x102c, 0x3b, 0x1021, 0x1004, 0x103a, 0x1039, 0x1002, 0x102b, 0x3b, 0x1017, 0x102f, 0x1012,
0x1039, 0x1013, 0x101f, 0x1030, 0x1038, 0x3b, 0x1000, 0x103c, 0x102c, 0x101e, 0x1015, 0x1010, 0x1031, 0x1038, 0x3b, 0x101e, 0x1031, 0x102c, 0x1000, 0x103c,
0x102c, 0x3b, 0x1005, 0x1014, 0x1031, 0x3b, 0x1010, 0x3b, 0x1010, 0x3b, 0x1021, 0x3b, 0x1017, 0x3b, 0x1000, 0x3b, 0x101e, 0x3b, 0x1005, 0x3b,
0x661f, 0x671f, 0x65e5, 0x3b, 0x661f, 0x671f, 0x4e00, 0x3b, 0x661f, 0x671f, 0x4e8c, 0x3b, 0x661f, 0x671f, 0x4e09, 0x3b, 0x661f, 0x671f, 0x56db, 0x3b,
0x661f, 0x671f, 0x4e94, 0x3b, 0x661f, 0x671f, 0x516d, 0x3b, 0x65e5, 0x3b, 0x4e00, 0x3b, 0x4e8c, 0x3b, 0x4e09, 0x3b, 0x56db, 0x3b, 0x4e94, 0x3b,
0x516d, 0x3b, 0x5468, 0x65e5, 0x3b, 0x5468, 0x4e00, 0x3b, 0x5468, 0x4e8c, 0x3b, 0x5468, 0x4e09, 0x3b, 0x5468, 0x56db, 0x3b, 0x5468, 0x4e94, 0x3b,
0x5468, 0x516d, 0x3b, 0x64, 0x67, 0x2e, 0x3b, 0x64, 0x6c, 0x2e, 0x3b, 0x64, 0x74, 0x2e, 0x3b, 0x64, 0x63, 0x2e, 0x3b, 0x64,
0x6a, 0x2e, 0x3b, 0x64, 0x76, 0x2e, 0x3b, 0x64, 0x73, 0x2e, 0x3b, 0x64, 0x69, 0x75, 0x6d, 0x65, 0x6e, 0x67, 0x65, 0x3b,
0x64, 0x69, 0x6c, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0x65,
0x63, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x6a, 0x6f, 0x75, 0x73, 0x3b, 0x64, 0x69, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65,
0x73, 0x3b, 0x64, 0x69, 0x73, 0x73, 0x61, 0x62, 0x74, 0x65, 0x3b, 0x64, 0x67, 0x3b, 0x64, 0x6c, 0x3b, 0x64, 0x74, 0x3b,
0x64, 0x63, 0x3b, 0x64, 0x6a, 0x3b, 0x64, 0x76, 0x3b, 0x64, 0x73, 0x3b, 0x44, 0x6f, 0x6d, 0x3b, 0x4c, 0x75, 0x6e, 0x3b,
0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x69, 0x79, 0x3b, 0x48, 0x75, 0x77, 0x3b, 0x42, 0x69, 0x79, 0x3b, 0x53, 0x61, 0x62, 0x3b,
0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65, 0x73,
0x3b, 0x4d, 0x69, 0x79, 0x65, 0x72, 0x6b, 0x75, 0x6c, 0x65, 0x73, 0x3b, 0x48, 0x75, 0x77, 0x65, 0x62, 0x65, 0x73, 0x3b,
0x42, 0x69, 0x79, 0x65, 0x72, 0x6e, 0x65, 0x73, 0x3b, 0x53, 0x61, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x44, 0x3b, 0x4c, 0x3b,
0x4d, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x42, 0x3b, 0x53, 0x3b, 0x41, 0x73, 0x61, 0x3b, 0x41, 0x79, 0x6e, 0x3b, 0x41, 0x73,
0x6e, 0x3b, 0x41, 0x6b, 0x72, 0x3b, 0x41, 0x6b, 0x77, 0x3b, 0x41, 0x73, 0x6d, 0x3b, 0x41, 0x73, 0x1e0d, 0x3b, 0x41, 0x73,
0x61, 0x6d, 0x61, 0x73, 0x3b, 0x41, 0x79, 0x6e, 0x61, 0x73, 0x3b, 0x41, 0x73, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x41, 0x6b,
0x72, 0x61, 0x73, 0x3b, 0x41, 0x6b, 0x77, 0x61, 0x73, 0x3b, 0x41, 0x73, 0x69, 0x6d, 0x77, 0x61, 0x73, 0x3b, 0x41, 0x73,
0x69, 0x1e0d, 0x79, 0x61, 0x73, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b,
0x6cc, 0x6d5, 0x6a9, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x62f, 0x648, 0x648, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x633, 0x6ce,
0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x686, 0x648, 0x627, 0x631, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x67e, 0x6ce, 0x646, 0x62c,
0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x6be, 0x6d5, 0x6cc, 0x646, 0x6cc, 0x3b, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x6cc, 0x3b,
0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b, 0x67e, 0x3b, 0x6be, 0x3b, 0x634, 0x3b, 0xd804, 0xdd22, 0xd804, 0xdd27, 0xd804, 0xdd1d, 0xd804, 0xdd28,
0x3b, 0xd804, 0xdd25, 0xd804, 0xdd27, 0xd804, 0xdd1f, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1f, 0xd804, 0xdd27, 0xd804, 0xdd01, 0xd804, 0xdd09, 0xd804, 0xdd27,
0xd804, 0xdd23, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1d, 0xd804, 0xdd2a, 0xd804, 0xdd16, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1d, 0xd804, 0xdd33, 0xd804, 0xdd22,
0xd804, 0xdd28, 0xd804, 0xdd25, 0xd804, 0xdd2a, 0xd804, 0xdd1b, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd2a, 0xd804, 0xdd07, 0xd804, 0xdd34, 0xd804,
0xdd07, 0xd804, 0xdd2e, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd27, 0xd804, 0xdd1a, 0xd804, 0xdd28, 0x3b, 0xd804, 0xdd22, 0xd804,
0xdd27, 0xd804, 0xdd1d, 0xd804, 0xdd28, 0xd804, 0xdd1d, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd27, 0xd804, 0xdd1f, 0xd804, 0xdd34,
0xd804, 0xdd1d, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1f, 0xd804, 0xdd27, 0xd804, 0xdd01, 0xd804, 0xdd09, 0xd804, 0xdd27, 0xd804, 0xdd23, 0xd804,
0xdd34, 0xd804, 0xdd1d, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1d, 0xd804, 0xdd2a, 0xd804, 0xdd16, 0xd804, 0xdd34, 0xd804, 0xdd1d, 0xd804, 0xdd22,
0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1d, 0xd804, 0xdd33, 0xd804, 0xdd22, 0xd804, 0xdd28, 0xd804, 0xdd25, 0xd804, 0xdd2a, 0xd804, 0xdd1b, 0xd804, 0xdd34, 0xd804,
0xdd1d, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd2a, 0xd804, 0xdd07, 0xd804, 0xdd34, 0xd804, 0xdd07, 0xd804, 0xdd2e, 0xd804, 0xdd22,
0xd804, 0xdd34, 0xd804, 0xdd1d, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd27, 0xd804, 0xdd1a, 0xd804, 0xdd28, 0xd804, 0xdd1d, 0xd804,
0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd22, 0xd804, 0xdd27, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd27, 0x3b, 0xd804, 0xdd1f, 0xd804, 0xdd27, 0x3b, 0xd804,
0xdd1d, 0xd804, 0xdd2a, 0x3b, 0xd804, 0xdd1d, 0xd804, 0xdd33, 0xd804, 0xdd22, 0xd804, 0xdd28, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd2a, 0x3b, 0xd804, 0xdd25,
0xd804, 0xdd27, 0x3b, 0x43a, 0x4c0, 0x438, 0x3b, 0x43e, 0x440, 0x3b, 0x448, 0x438, 0x3b, 0x43a, 0x445, 0x430, 0x3b, 0x435, 0x430, 0x3b,
0x43f, 0x4c0, 0x435, 0x3b, 0x448, 0x443, 0x43e, 0x3b, 0x43a, 0x4c0, 0x438, 0x440, 0x430, 0x3b, 0x43e, 0x440, 0x448, 0x43e, 0x442, 0x3b,
0x448, 0x438, 0x43d, 0x430, 0x440, 0x430, 0x3b, 0x43a, 0x445, 0x430, 0x430, 0x440, 0x430, 0x3b, 0x435, 0x430, 0x440, 0x430, 0x3b, 0x43f,
0x4c0, 0x435, 0x440, 0x430, 0x441, 0x43a, 0x430, 0x3b, 0x448, 0x443, 0x43e, 0x442, 0x3b, 0x43a, 0x4c0, 0x3b, 0x43e, 0x3b, 0x448, 0x3b,
0x43a, 0x445, 0x3b, 0x435, 0x3b, 0x43f, 0x4c0, 0x3b, 0x448, 0x3b, 0x13c6, 0x13cd, 0x13ac, 0x3b, 0x13c9, 0x13c5, 0x13af, 0x3b, 0x13d4, 0x13b5,
0x13c1, 0x3b, 0x13e6, 0x13a2, 0x13c1, 0x3b, 0x13c5, 0x13a9, 0x13c1, 0x3b, 0x13e7, 0x13be, 0x13a9, 0x3b, 0x13c8, 0x13d5, 0x13be, 0x3b, 0x13a4, 0x13be,
0x13d9, 0x13d3, 0x13c6, 0x13cd, 0x13ac, 0x3b, 0x13a4, 0x13be, 0x13d9, 0x13d3, 0x13c9, 0x13c5, 0x13af, 0x3b, 0x13d4, 0x13b5, 0x13c1, 0x13a2, 0x13a6, 0x3b,
0x13e6, 0x13a2, 0x13c1, 0x13a2, 0x13a6, 0x3b, 0x13c5, 0x13a9, 0x13c1, 0x13a2, 0x13a6, 0x3b, 0x13e7, 0x13be, 0x13a9, 0x13b6, 0x13cd, 0x13d7, 0x3b, 0x13a4,
0x13be, 0x13d9, 0x13d3, 0x13c8, 0x13d5, 0x13be, 0x3b, 0x13c6, 0x3b, 0x13c9, 0x3b, 0x13d4, 0x3b, 0x13e6, 0x3b, 0x13c5, 0x3b, 0x13e7, 0x3b, 0x13a4,
0x3b, 0x4e, 0x69, 0x74, 0x74, 0x61, 0x6b, 0x20, 0x48, 0x6f, 0x6c, 0x6c, 0x6f, 0x2bc, 0x3b, 0x4d, 0x61, 0x6e, 0x74, 0x69,
0x2bc, 0x3b, 0x43, 0x68, 0x6f, 0x73, 0x74, 0x69, 0x2bc, 0x3b, 0x57, 0x69, 0x6e, 0x73, 0x74, 0x69, 0x2bc, 0x3b, 0x53, 0x6f,
0x69, 0x73, 0x74, 0x69, 0x2bc, 0x3b, 0x4e, 0x61, 0x6e, 0x6e, 0x61, 0x6c, 0x68, 0x63, 0x68, 0x69, 0x66, 0x61, 0x2bc, 0x20,
0x4e, 0x69, 0x74, 0x74, 0x61, 0x6b, 0x3b, 0x4e, 0x69, 0x74, 0x74, 0x61, 0x6b, 0x20, 0x48, 0x6f, 0x6c, 0x6c, 0x6f, 0x2bc,
0x20, 0x4e, 0x61, 0x6b, 0x66, 0x69, 0x73, 0x68, 0x3b, 0x53, 0x41, 0x4e, 0x3b, 0x4f, 0x52, 0x4b, 0x3b, 0x4f, 0x4b, 0x42,
0x3b, 0x4f, 0x4b, 0x53, 0x3b, 0x4f, 0x4b, 0x4e, 0x3b, 0x4f, 0x4b, 0x54, 0x3b, 0x4f, 0x4d, 0x4b, 0x3b, 0x53, 0x61, 0x6e,
0x64, 0x65, 0x3b, 0x4f, 0x72, 0x77, 0x6f, 0x6b, 0x75, 0x62, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b,
0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61, 0x73, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x4f, 0x72,
0x77, 0x61, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61, 0x74, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x4f,
0x72, 0x77, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x52, 0x3b, 0x53, 0x3b, 0x4e,
0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x9031, 0x65e5, 0x3b, 0x9031, 0x4e00, 0x3b, 0x9031, 0x4e8c, 0x3b, 0x9031, 0x4e09, 0x3b, 0x9031, 0x56db, 0x3b,
0x9031, 0x4e94, 0x3b, 0x9031, 0x516d, 0x3b, 0x43d, 0x434, 0x2de7, 0x487, 0x467, 0x3b, 0x43f, 0x43d, 0x2de3, 0x435, 0x3b, 0x432, 0x442, 0x43e,
0x2dec, 0x487, 0x3b, 0x441, 0x440, 0x2de3, 0x435, 0x3b, 0x447, 0x435, 0x2de6, 0x487, 0x3b, 0x43f, 0x467, 0x2de6, 0x487, 0x3b, 0x441, 0xa64b,
0x2de0, 0x487, 0x3b, 0x43d, 0x435, 0x434, 0x463, 0x301, 0x43b, 0x467, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x463, 0x301, 0x43b, 0x44c,
0x43d, 0x438, 0x43a, 0x44a, 0x3b, 0x432, 0x442, 0x43e, 0x301, 0x440, 0x43d, 0x438, 0x43a, 0x44a, 0x3b, 0x441, 0x440, 0x435, 0x434, 0x430,
0x300, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x435, 0x440, 0x442, 0x43e, 0x301, 0x43a, 0x44a, 0x3b, 0x43f, 0x467, 0x442, 0x43e, 0x301, 0x43a,
0x44a, 0x3b, 0x441, 0xa64b, 0x431, 0x431, 0x461, 0x301, 0x442, 0x430, 0x3b, 0x41d, 0x3b, 0x41f, 0x3b, 0x412, 0x3b, 0x421, 0x3b, 0x427,
0x3b, 0x41f, 0x3b, 0x421, 0x3b, 0x432, 0x44b, 0x440, 0x2e, 0x3b, 0x442, 0x443, 0x43d, 0x2e, 0x3b, 0x44b, 0x442, 0x43b, 0x2e, 0x3b,
0x44e, 0x43d, 0x2e, 0x3b, 0x43a, 0x4d7, 0x4ab, 0x2e, 0x3b, 0x44d, 0x440, 0x2e, 0x3b, 0x448, 0x4d1, 0x43c, 0x2e, 0x3b, 0x432, 0x44b,
0x440, 0x441, 0x430, 0x440, 0x43d, 0x438, 0x43a, 0x443, 0x43d, 0x3b, 0x442, 0x443, 0x43d, 0x442, 0x438, 0x43a, 0x443, 0x43d, 0x3b, 0x44b,
0x442, 0x43b, 0x430, 0x440, 0x438, 0x43a, 0x443, 0x43d, 0x3b, 0x44e, 0x43d, 0x43a, 0x443, 0x43d, 0x3b, 0x43a, 0x4d7, 0x4ab, 0x43d, 0x435,
0x440, 0x43d, 0x438, 0x43a, 0x443, 0x43d, 0x3b, 0x44d, 0x440, 0x43d, 0x435, 0x43a, 0x443, 0x43d, 0x3b, 0x448, 0x4d1, 0x43c, 0x430, 0x442,
0x43a, 0x443, 0x43d, 0x3b, 0x412, 0x3b, 0x422, 0x3b, 0x42b, 0x3b, 0x42e, 0x3b, 0x41a, 0x3b, 0x42d, 0x3b, 0x428, 0x3b, 0x53, 0x75,
0x2e, 0x3b, 0x4d, 0x6f, 0x2e, 0x3b, 0x44, 0x69, 0x2e, 0x3b, 0x4d, 0x65, 0x2e, 0x3b, 0x44, 0x75, 0x2e, 0x3b, 0x46, 0x72,
0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x53, 0x75, 0x6e, 0x6e, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4d, 0x6f, 0x68, 0x6e,
0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x44, 0x69, 0x6e, 0x6e, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4d, 0x65, 0x74,
0x77, 0x6f, 0x63, 0x68, 0x3b, 0x44, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x46, 0x72,
0x69, 0x69, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x53, 0x3b,
0x4d, 0x3b, 0x44, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x46, 0x3b, 0x53, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e, 0x3b,
0x4d, 0x74, 0x68, 0x3b, 0x4d, 0x68, 0x72, 0x3b, 0x59, 0x6f, 0x77, 0x3b, 0x47, 0x77, 0x65, 0x3b, 0x53, 0x61, 0x64, 0x3b,
0x64, 0x79, 0x20, 0x53, 0x75, 0x6c, 0x3b, 0x64, 0x79, 0x20, 0x4c, 0x75, 0x6e, 0x3b, 0x64, 0x79, 0x20, 0x4d, 0x65, 0x75,
0x72, 0x74, 0x68, 0x3b, 0x64, 0x79, 0x20, 0x4d, 0x65, 0x72, 0x68, 0x65, 0x72, 0x3b, 0x64, 0x79, 0x20, 0x59, 0x6f, 0x77,
0x3b, 0x64, 0x79, 0x20, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x64, 0x79, 0x20, 0x53, 0x61, 0x64, 0x6f, 0x72, 0x6e,
0x3b, 0x64, 0x75, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x6d, 0x65, 0x72, 0x2e,
0x3b, 0x67, 0x68, 0x6a, 0x2e, 0x3b, 0x76, 0x65, 0x6e, 0x2e, 0x3b, 0x73, 0x61, 0x62, 0x2e, 0x3b, 0x64, 0x75, 0x6d, 0x65,
0x6e, 0x69, 0x63, 0x61, 0x3b, 0x6c, 0x75, 0x6e, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x69, 0x3b, 0x6d, 0x65, 0x72, 0x63,
0x75, 0x72, 0x69, 0x3b, 0x67, 0x68, 0x6a, 0x6f, 0x76, 0x69, 0x3b, 0x76, 0x65, 0x6e, 0x6e, 0x65, 0x72, 0x69, 0x3b, 0x73,
0x61, 0x62, 0x62, 0x61, 0x74, 0x75, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x56, 0x3b, 0x53,
0x3b, 0x6e, 0x65, 0x3b, 0x70, 0x6f, 0x3b, 0xfa, 0x74, 0x3b, 0x73, 0x74, 0x3b, 0x10d, 0x74, 0x3b, 0x70, 0xe1, 0x3b, 0x73,
0x6f, 0x3b, 0x6e, 0x65, 0x64, 0x11b, 0x6c, 0x65, 0x3b, 0x70, 0x6f, 0x6e, 0x64, 0x11b, 0x6c, 0xed, 0x3b, 0xfa, 0x74, 0x65,
0x72, 0xfd, 0x3b, 0x73, 0x74, 0x159, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x74, 0x76, 0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0xe1,
0x74, 0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x4e, 0x3b, 0x50, 0x3b, 0xda, 0x3b, 0x53, 0x3b, 0x10c,
0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x73, 0xf8, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x6e, 0x2e, 0x3b, 0x74, 0x69, 0x72, 0x73, 0x2e,
0x3b, 0x6f, 0x6e, 0x73, 0x2e, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x3b, 0x66, 0x72, 0x65, 0x2e, 0x3b, 0x6c, 0xf8, 0x72,
0x2e, 0x3b, 0x73, 0xf8, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x69, 0x72, 0x73,
0x64, 0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66,
0x72, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c, 0xf8, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4f,
0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x4c, 0x3b, 0x910, 0x924, 0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x3b, 0x92c,
0x941, 0x927, 0x3b, 0x92c, 0x940, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x3b, 0x910, 0x924, 0x92c,
0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x941,
0x927, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x940, 0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x92c, 0x93e, 0x930,
0x3b, 0x936, 0x928, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x910, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x2e, 0x3b, 0x92c, 0x941, 0x2e, 0x3b,
0x92c, 0x940, 0x2e, 0x3b, 0x936, 0x941, 0x2e, 0x3b, 0x936, 0x2e, 0x3b, 0x910, 0x2e, 0x3b, 0x938, 0x94b, 0x2e, 0x3b, 0x92e, 0x2e,
0x3b, 0x92c, 0x941, 0x2e, 0x3b, 0x92c, 0x940, 0x2e, 0x3b, 0x936, 0x941, 0x2e, 0x3b, 0x936, 0x2e, 0x3b, 0xe9, 0x74, 0x3b, 0x6d,
0x254, 0x301, 0x73, 0x3b, 0x6b, 0x77, 0x61, 0x3b, 0x6d, 0x75, 0x6b, 0x3b, 0x14b, 0x67, 0x69, 0x3b, 0x257, 0xf3, 0x6e, 0x3b,
0x65, 0x73, 0x61, 0x3b, 0xe9, 0x74, 0x69, 0x3b, 0x6d, 0x254, 0x301, 0x73, 0xfa, 0x3b, 0x6b, 0x77, 0x61, 0x73, 0xfa, 0x3b,
0x6d, 0x75, 0x6b, 0x254, 0x301, 0x73, 0xfa, 0x3b, 0x14b, 0x67, 0x69, 0x73, 0xfa, 0x3b, 0x257, 0xf3, 0x6e, 0x25b, 0x73, 0xfa,
0x3b, 0x65, 0x73, 0x61, 0x253, 0x61, 0x73, 0xfa, 0x3b, 0x65, 0x3b, 0x6d, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x14b, 0x3b, 0x257,
0x3b, 0x65, 0x3b, 0x7a, 0x6f, 0x3b, 0x6d, 0x61, 0x3b, 0x64, 0x69, 0x3b, 0x77, 0x6f, 0x3b, 0x64, 0x6f, 0x3b, 0x76, 0x72,
0x3b, 0x7a, 0x61, 0x3b, 0x7a, 0x6f, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0x61, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x64,
0x69, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x77, 0x6f, 0x65, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x64, 0x6f, 0x6e, 0x64,
0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x76, 0x72, 0x69, 0x6a, 0x64, 0x61, 0x67, 0x3b, 0x7a, 0x61, 0x74, 0x65, 0x72, 0x64,
0x61, 0x67, 0x3b, 0x5a, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x56, 0x3b, 0x5a, 0x3b, 0xf5f, 0xfb3, 0xf0b,
0x3b, 0xf58, 0xf72, 0xf62, 0xf0b, 0x3b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0x3b, 0xf55, 0xf74, 0xf62, 0xf0b, 0x3b, 0xf66, 0xf44, 0xf66, 0xf0b,
0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0x3b, 0xf49, 0xf72, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b,
0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf58, 0xf72, 0xf42, 0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf63, 0xfb7,
0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60,
0xf0b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b,
0xf42, 0xf5f, 0xf60, 0xf0b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0x3b, 0xf58, 0xf72, 0xf62, 0x3b, 0xf63, 0xfb7, 0xf42,
0x3b, 0xf55, 0xf74, 0xf62, 0x3b, 0xf66, 0xf44, 0xfb6, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0x3b, 0xf49, 0xf72, 0x3b, 0x4b, 0x6d, 0x61,
0x3b, 0x54, 0x61, 0x74, 0x3b, 0x49, 0x6e, 0x65, 0x3b, 0x54, 0x61, 0x6e, 0x3b, 0x41, 0x72, 0x6d, 0x3b, 0x4d, 0x61, 0x61,
0x3b, 0x4e, 0x4d, 0x4d, 0x3b, 0x4b, 0x69, 0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74,
0x75, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f,
0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69, 0x74, 0x68, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4e, 0x4a, 0x75,
0x6d, 0x61, 0x6d, 0x6f, 0x74, 0x68, 0x69, 0x69, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x3b, 0x4d,
0x3b, 0x4e, 0x3b, 0xd801, 0xdc1d, 0xd801, 0xdc32, 0xd801, 0xdc4c, 0x3b, 0xd801, 0xdc23, 0xd801, 0xdc32, 0xd801, 0xdc4c, 0x3b, 0xd801, 0xdc13, 0xd801,
0xdc2d, 0xd801, 0xdc46, 0x3b, 0xd801, 0xdc0e, 0xd801, 0xdc2f, 0xd801, 0xdc4c, 0x3b, 0xd801, 0xdc1b, 0xd801, 0xdc32, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc19,
0xd801, 0xdc49, 0xd801, 0xdc34, 0x3b, 0xd801, 0xdc1d, 0xd801, 0xdc30, 0xd801, 0xdc3b, 0x3b, 0xd801, 0xdc1d, 0xd801, 0xdc32, 0xd801, 0xdc4c, 0xd801, 0xdc3c,
0xd801, 0xdc29, 0x3b, 0xd801, 0xdc23, 0xd801, 0xdc32, 0xd801, 0xdc4c, 0xd801, 0xdc3c, 0xd801, 0xdc29, 0x3b, 0xd801, 0xdc13, 0xd801, 0xdc2d, 0xd801, 0xdc46,
0xd801, 0xdc3c, 0xd801, 0xdc29, 0x3b, 0xd801, 0xdc0e, 0xd801, 0xdc2f, 0xd801, 0xdc4c, 0xd801, 0xdc46, 0xd801, 0xdc3c, 0xd801, 0xdc29, 0x3b, 0xd801, 0xdc1b,
0xd801, 0xdc32, 0xd801, 0xdc49, 0xd801, 0xdc46, 0xd801, 0xdc3c, 0xd801, 0xdc29, 0x3b, 0xd801, 0xdc19, 0xd801, 0xdc49, 0xd801, 0xdc34, 0xd801, 0xdc3c, 0xd801,
0xdc29, 0x3b, 0xd801, 0xdc1d, 0xd801, 0xdc30, 0xd801, 0xdc3b, 0xd801, 0xdc32, 0xd801, 0xdc49, 0xd801, 0xdc3c, 0xd801, 0xdc29, 0x3b, 0xd801, 0xdc1d, 0x3b,
0xd801, 0xdc23, 0x3b, 0xd801, 0xdc13, 0x3b, 0xd801, 0xdc0e, 0x3b, 0xd801, 0xdc1b, 0x3b, 0xd801, 0xdc19, 0x3b, 0xd801, 0xdc1d, 0x3b, 0x53, 0x75,
0x2e, 0x3b, 0x4d, 0x2e, 0x3b, 0x54, 0x75, 0x2e, 0x3b, 0x57, 0x2e, 0x3b, 0x54, 0x68, 0x2e, 0x3b, 0x46, 0x2e, 0x3b, 0x53,
0x61, 0x2e, 0x3b, 0xb7, 0xd801, 0xdc55, 0xd801, 0xdc6d, 0x3b, 0xb7, 0xd801, 0xdc65, 0xd801, 0xdc6d, 0x3b, 0xb7, 0xd801, 0xdc51, 0xd801, 0xdc75,
0x3b, 0xb7, 0xd801, 0xdc62, 0xd801, 0xdc67, 0x3b, 0xb7, 0xd801, 0xdc54, 0xd801, 0xdc7b, 0x3b, 0xb7, 0xd801, 0xdc53, 0xd801, 0xdc6e, 0x3b, 0xb7,
0xd801, 0xdc55, 0xd801, 0xdc68, 0x3b, 0xb7, 0xd801, 0xdc55, 0xd801, 0xdc6d, 0xd801, 0xdc59, 0xd801, 0xdc5b, 0xd801, 0xdc71, 0x3b, 0xb7, 0xd801, 0xdc65,
0xd801, 0xdc6d, 0xd801, 0xdc59, 0xd801, 0xdc5b, 0xd801, 0xdc71, 0x3b, 0xb7, 0xd801, 0xdc51, 0xd801, 0xdc75, 0xd801, 0xdc5f, 0xd801, 0xdc5b, 0xd801, 0xdc71,
0x3b, 0xb7, 0xd801, 0xdc62, 0xd801, 0xdc67, 0xd801, 0xdc59, 0xd801, 0xdc5f, 0xd801, 0xdc5b, 0xd801, 0xdc71, 0x3b, 0xb7, 0xd801, 0xdc54, 0xd801, 0xdc7b,
0xd801, 0xdc5f, 0xd801, 0xdc5b, 0xd801, 0xdc71, 0x3b, 0xb7, 0xd801, 0xdc53, 0xd801, 0xdc6e, 0xd801, 0xdc72, 0xd801, 0xdc5b, 0xd801, 0xdc71, 0x3b, 0xb7,
0xd801, 0xdc55, 0xd801, 0xdc68, 0xd801, 0xdc5b, 0xd801, 0xdc7b, 0xd801, 0xdc5b, 0xd801, 0xdc71, 0x3b, 0xd801, 0xdc55, 0x3b, 0xd801, 0xdc65, 0x3b, 0xd801,
0xdc51, 0x3b, 0xd801, 0xdc62, 0x3b, 0xd801, 0xdc54, 0x3b, 0xd801, 0xdc53, 0x3b, 0xd801, 0xdc55, 0x3b, 0x442, 0x430, 0x440, 0x3b, 0x430, 0x442,
0x44f, 0x3b, 0x432, 0x430, 0x441, 0x3b, 0x43a, 0x443, 0x43d, 0x3b, 0x43a, 0x430, 0x43b, 0x3b, 0x441, 0x44e, 0x43a, 0x3b, 0x448, 0x43b,
0x44f, 0x3b, 0x442, 0x430, 0x440, 0x433, 0x43e, 0x447, 0x438, 0x3b, 0x430, 0x442, 0x44f, 0x43d, 0x44c, 0x447, 0x438, 0x3b, 0x432, 0x430,
0x441, 0x442, 0x430, 0x43d, 0x44c, 0x447, 0x438, 0x3b, 0x43a, 0x443, 0x43d, 0x448, 0x43a, 0x430, 0x447, 0x438, 0x3b, 0x43a, 0x430, 0x43b,
0x43e, 0x43d, 0x44c, 0x447, 0x438, 0x3b, 0x441, 0x44e, 0x43a, 0x43e, 0x43d, 0x44c, 0x447, 0x438, 0x3b, 0x448, 0x43b, 0x44f, 0x43c, 0x43e,
0x447, 0x438, 0x3b, 0x442, 0x430, 0x440, 0x433, 0x43e, 0x447, 0x438, 0x441, 0x442, 0x44d, 0x3b, 0x430, 0x442, 0x44f, 0x43d, 0x44c, 0x447,
0x438, 0x441, 0x442, 0x44d, 0x3b, 0x432, 0x430, 0x441, 0x442, 0x430, 0x43d, 0x44c, 0x447, 0x438, 0x441, 0x442, 0x44d, 0x3b, 0x43a, 0x443,
0x43d, 0x448, 0x43a, 0x430, 0x447, 0x438, 0x441, 0x442, 0x44d, 0x3b, 0x43a, 0x430, 0x43b, 0x43e, 0x43d, 0x44c, 0x447, 0x438, 0x441, 0x442,
0x44d, 0x3b, 0x441, 0x44e, 0x43a, 0x43e, 0x43d, 0x44c, 0x447, 0x438, 0x441, 0x442, 0x44d, 0x3b, 0x448, 0x43b, 0x44f, 0x43c, 0x43e, 0x447,
0x438, 0x441, 0x442, 0x44d, 0x3b, 0x64, 0x69, 0x3b, 0x6c, 0x75, 0x3b, 0x6d, 0x61, 0x3b, 0x6d, 0x65, 0x3b, 0x135, 0x61, 0x3b,
0x76, 0x65, 0x3b, 0x73, 0x61, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x6e, 0x109, 0x6f, 0x3b, 0x6c, 0x75, 0x6e, 0x64, 0x6f, 0x3b,
0x6d, 0x61, 0x72, 0x64, 0x6f, 0x3b, 0x6d, 0x65, 0x72, 0x6b, 0x72, 0x65, 0x64, 0x6f, 0x3b, 0x135, 0x61, 0x16d, 0x64, 0x6f,
0x3b, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65, 0x64, 0x6f, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b, 0x44, 0x3b, 0x4c,
0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x134, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x50, 0x3b, 0x45, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4e,
0x3b, 0x52, 0x3b, 0x4c, 0x3b, 0x70, 0xfc, 0x68, 0x61, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x65, 0x73, 0x6d, 0x61, 0x73, 0x70,
0xe4, 0x65, 0x76, 0x3b, 0x74, 0x65, 0x69, 0x73, 0x69, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x6b, 0x6f, 0x6c, 0x6d, 0x61, 0x70,
0xe4, 0x65, 0x76, 0x3b, 0x6e, 0x65, 0x6c, 0x6a, 0x61, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x72, 0x65, 0x65, 0x64, 0x65, 0x3b,
0x6c, 0x61, 0x75, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x6b, 0x254, 0x73, 0x3b, 0x64, 0x7a, 0x6f, 0x3b, 0x62, 0x6c, 0x61, 0x3b,
0x6b, 0x75, 0x256, 0x3b, 0x79, 0x61, 0x77, 0x3b, 0x66, 0x69, 0x256, 0x3b, 0x6d, 0x65, 0x6d, 0x3b, 0x6b, 0x254, 0x73, 0x69,
0x256, 0x61, 0x3b, 0x64, 0x7a, 0x6f, 0x256, 0x61, 0x3b, 0x62, 0x6c, 0x61, 0x256, 0x61, 0x3b, 0x6b, 0x75, 0x256, 0x61, 0x3b,
0x79, 0x61, 0x77, 0x6f, 0x256, 0x61, 0x3b, 0x66, 0x69, 0x256, 0x61, 0x3b, 0x6d, 0x65, 0x6d, 0x6c, 0x65, 0x256, 0x61, 0x3b,
0x6b, 0x3b, 0x64, 0x3b, 0x62, 0x3b, 0x6b, 0x3b, 0x79, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6d,
0x254, 0x301, 0x6e, 0x3b, 0x73, 0x6d, 0x62, 0x3b, 0x73, 0x6d, 0x6c, 0x3b, 0x73, 0x6d, 0x6e, 0x3b, 0x66, 0xfa, 0x6c, 0x3b,
0x73, 0xe9, 0x72, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0x73, 0x254,
0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x259, 0x6c, 0xfa, 0x20, 0x6d, 0x259, 0x301, 0x62, 0x25b, 0x30c, 0x3b, 0x73, 0x254, 0x301,
0x6e, 0x64, 0x254, 0x20, 0x6d, 0x259, 0x6c, 0xfa, 0x20, 0x6d, 0x259, 0x301, 0x6c, 0x25b, 0x301, 0x3b, 0x73, 0x254, 0x301, 0x6e,
0x64, 0x254, 0x20, 0x6d, 0x259, 0x6c, 0xfa, 0x20, 0x6d, 0x259, 0x301, 0x6e, 0x79, 0x69, 0x3b, 0x66, 0xfa, 0x6c, 0x61, 0x64,
0xe9, 0x3b, 0x73, 0xe9, 0x72, 0x61, 0x64, 0xe9, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x66,
0x3b, 0x73, 0x3b, 0x73, 0x75, 0x6e, 0x3b, 0x6d, 0xe1, 0x6e, 0x3b, 0x74, 0xfd, 0x73, 0x3b, 0x6d, 0x69, 0x6b, 0x3b, 0x68,
0xf3, 0x73, 0x3b, 0x66, 0x72, 0xed, 0x3b, 0x6c, 0x65, 0x79, 0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x64, 0x61, 0x67, 0x75,
0x72, 0x3b, 0x6d, 0xe1, 0x6e, 0x61, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x74, 0xfd, 0x73, 0x64, 0x61, 0x67, 0x75, 0x72,
0x3b, 0x6d, 0x69, 0x6b, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x68, 0xf3, 0x73, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b,
0x66, 0x72, 0xed, 0x67, 0x67, 0x6a, 0x61, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6c, 0x65, 0x79, 0x67, 0x61, 0x72, 0x64,
0x61, 0x67, 0x75, 0x72, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x46, 0x3b, 0x4c, 0x3b, 0x73,
0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0xe1, 0x6e, 0x2e, 0x3b, 0x74, 0xfd, 0x73, 0x2e, 0x3b, 0x6d, 0x69, 0x6b, 0x2e, 0x3b, 0x68,
0xf3, 0x73, 0x2e, 0x3b, 0x66, 0x72, 0xed, 0x2e, 0x3b, 0x6c, 0x65, 0x79, 0x2e, 0x3b, 0x4c, 0x69, 0x6e, 0x3b, 0x4c, 0x75,
0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x69, 0x79, 0x3b, 0x48, 0x75, 0x77, 0x3b, 0x42, 0x69, 0x79, 0x3b, 0x53, 0x61,
0x62, 0x3b, 0x4c, 0x69, 0x6e, 0x67, 0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65,
0x73, 0x3b, 0x4d, 0x69, 0x79, 0x65, 0x72, 0x6b, 0x75, 0x6c, 0x65, 0x73, 0x3b, 0x48, 0x75, 0x77, 0x65, 0x62, 0x65, 0x73,
0x3b, 0x42, 0x69, 0x79, 0x65, 0x72, 0x6e, 0x65, 0x73, 0x3b, 0x53, 0x61, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x73, 0x75, 0x3b,
0x6d, 0x61, 0x3b, 0x74, 0x69, 0x3b, 0x6b, 0x65, 0x3b, 0x74, 0x6f, 0x3b, 0x70, 0x65, 0x3b, 0x6c, 0x61, 0x3b, 0x73, 0x75,
0x6e, 0x6e, 0x75, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x6d, 0x61, 0x61, 0x6e, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x74, 0x69,
0x69, 0x73, 0x74, 0x61, 0x69, 0x3b, 0x6b, 0x65, 0x73, 0x6b, 0x69, 0x76, 0x69, 0x69, 0x6b, 0x6b, 0x6f, 0x3b, 0x74, 0x6f,
0x72, 0x73, 0x74, 0x61, 0x69, 0x3b, 0x70, 0x65, 0x72, 0x6a, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x6c, 0x61, 0x75, 0x61,
0x6e, 0x74, 0x61, 0x69, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x50, 0x3b, 0x4c, 0x3b, 0x73,
0x75, 0x6e, 0x6e, 0x75, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6d, 0x61, 0x61, 0x6e, 0x61, 0x6e, 0x74, 0x61, 0x69,
0x6e, 0x61, 0x3b, 0x74, 0x69, 0x69, 0x73, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6b, 0x65, 0x73, 0x6b, 0x69, 0x76, 0x69,
0x69, 0x6b, 0x6b, 0x6f, 0x6e, 0x61, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x70, 0x65, 0x72,
0x6a, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6c, 0x61, 0x75, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b,
0x64, 0x69, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x6d, 0x65, 0x72, 0x2e, 0x3b,
0x6a, 0x65, 0x75, 0x2e, 0x3b, 0x76, 0x65, 0x6e, 0x2e, 0x3b, 0x73, 0x61, 0x6d, 0x2e, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x6e,
0x63, 0x68, 0x65, 0x3b, 0x6c, 0x75, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x65, 0x72, 0x63,
0x72, 0x65, 0x64, 0x69, 0x3b, 0x6a, 0x65, 0x75, 0x64, 0x69, 0x3b, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65, 0x64, 0x69, 0x3b,
0x73, 0x61, 0x6d, 0x65, 0x64, 0x69, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x56, 0x3b, 0x53,
0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x69, 0x65, 0x3b, 0x6a, 0x6f, 0x69,
0x3b, 0x76, 0x69, 0x6e, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x65, 0x6e, 0x69, 0x65, 0x3b, 0x6c, 0x75, 0x6e,
0x69, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x61, 0x72, 0x73, 0x3b, 0x6d, 0x69, 0x65, 0x72, 0x63, 0x75, 0x73, 0x3b, 0x6a,
0x6f, 0x69, 0x62, 0x65, 0x3b, 0x76, 0x69, 0x6e, 0x61, 0x72, 0x73, 0x3b, 0x73, 0x61, 0x62, 0x69, 0x64, 0x65, 0x3b, 0x64,
0x65, 0x77, 0x3b, 0x61, 0x61, 0x253, 0x3b, 0x6d, 0x61, 0x77, 0x3b, 0x6e, 0x6a, 0x65, 0x3b, 0x6e, 0x61, 0x61, 0x3b, 0x6d,
0x77, 0x64, 0x3b, 0x68, 0x62, 0x69, 0x3b, 0x64, 0x65, 0x77, 0x6f, 0x3b, 0x61, 0x61, 0x253, 0x6e, 0x64, 0x65, 0x3b, 0x6d,
0x61, 0x77, 0x62, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x6e, 0x6a, 0x65, 0x73, 0x6c, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x6e, 0x61,
0x61, 0x73, 0x61, 0x61, 0x6e, 0x64, 0x65, 0x3b, 0x6d, 0x61, 0x77, 0x6e, 0x64, 0x65, 0x3b, 0x68, 0x6f, 0x6f, 0x72, 0x65,
0x2d, 0x62, 0x69, 0x69, 0x72, 0x3b, 0x64, 0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x6e, 0x3b, 0x6e, 0x3b, 0x6d, 0x3b, 0x68, 0x3b,
0xd83a, 0xdd08, 0xd83a, 0xdd2b, 0xd83a, 0xdd2c, 0x3b, 0xd83a, 0xdd00, 0xd83a, 0xdd44, 0xd83a, 0xdd29, 0xd83a, 0xdd35, 0x3b, 0xd83a, 0xdd03, 0xd83a, 0xdd22,
0xd83a, 0xdd26, 0x3b, 0xd83a, 0xdd14, 0xd83a, 0xdd2b, 0xd83a, 0xdd27, 0x3b, 0xd83a, 0xdd10, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd27, 0x3b, 0xd83a,
0xdd03, 0xd83a, 0xdd22, 0xd83a, 0xdd23, 0x3b, 0xd83a, 0xdd16, 0xd83a, 0xdd2e, 0xd83a, 0xdd2a, 0x3b, 0xd83a, 0xdd08, 0xd83a, 0xdd2b, 0xd83a, 0xdd2c, 0xd83a,
0xdd26, 0xd83a, 0xdd2d, 0xd83a, 0xdd2a, 0xd83a, 0xdd46, 0xd83a, 0xdd2b, 0x3b, 0xd83a, 0xdd00, 0xd83a, 0xdd44, 0xd83a, 0xdd29, 0xd83a, 0xdd35, 0xd83a, 0xdd32,
0xd83a, 0xdd4b, 0xd83a, 0xdd23, 0xd83a, 0xdd2b, 0x3b, 0xd83a, 0xdd03, 0xd83a, 0xdd22, 0xd83a, 0xdd31, 0xd83a, 0xdd26, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a,
0xdd2a, 0xd83a, 0xdd2b, 0x3b, 0xd83a, 0xdd10, 0xd83a, 0xdd36, 0xd83a, 0xdd2b, 0xd83a, 0xdd27, 0xd83a, 0xdd24, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd2a,
0xd83a, 0xdd2b, 0x3b, 0xd83a, 0xdd10, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd27, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd32, 0xd83a, 0xdd23, 0xd83a,
0xdd2b, 0x3b, 0xd83a, 0xdd03, 0xd83a, 0xdd22, 0xd83a, 0xdd31, 0xd83a, 0xdd32, 0xd83a, 0xdd23, 0xd83a, 0xdd2b, 0x3b, 0xd83a, 0xdd16, 0xd83a, 0xdd2e, 0xd83a,
0xdd2a, 0xd83a, 0xdd26, 0xd83a, 0xdd2d, 0xd83a, 0xdd2a, 0xd83a, 0xdd46, 0xd83a, 0xdd2b, 0x3b, 0xd83a, 0xdd08, 0x3b, 0xd83a, 0xdd00, 0xd83a, 0xdd44, 0x3b,
0xd83a, 0xdd03, 0x3b, 0xd83a, 0xdd14, 0x3b, 0xd83a, 0xdd10, 0x3b, 0xd83a, 0xdd03, 0x3b, 0xd83a, 0xdd16, 0x3b, 0x48, 0x254, 0x67, 0x3b, 0x4a,
0x75, 0x3b, 0x4a, 0x75, 0x66, 0x3b, 0x53, 0x68, 0x254, 0x3b, 0x53, 0x6f, 0x6f, 0x3b, 0x53, 0x6f, 0x68, 0x3b, 0x48, 0x254,
0x254, 0x3b, 0x48, 0x254, 0x67, 0x62, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x3b, 0x4a, 0x75, 0x66, 0x254, 0x3b, 0x53, 0x68, 0x254,
0x3b, 0x53, 0x6f, 0x6f, 0x3b, 0x53, 0x6f, 0x68, 0x61, 0x61, 0x3b, 0x48, 0x254, 0x254, 0x3b, 0x48, 0x3b, 0x4a, 0x3b, 0x4a,
0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x48, 0x3b, 0x44, 0x69, 0x44, 0x3b, 0x44, 0x69, 0x4c, 0x3b, 0x44, 0x69, 0x4d,
0x3b, 0x44, 0x69, 0x43, 0x3b, 0x44, 0x69, 0x61, 0x3b, 0x44, 0x69, 0x68, 0x3b, 0x44, 0x69, 0x53, 0x3b, 0x44, 0x69, 0x44,
0xf2, 0x6d, 0x68, 0x6e, 0x61, 0x69, 0x63, 0x68, 0x3b, 0x44, 0x69, 0x4c, 0x75, 0x61, 0x69, 0x6e, 0x3b, 0x44, 0x69, 0x4d,
0xe0, 0x69, 0x72, 0x74, 0x3b, 0x44, 0x69, 0x43, 0x69, 0x61, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x44, 0x69, 0x61, 0x72, 0x44,
0x61, 0x6f, 0x69, 0x6e, 0x3b, 0x44, 0x69, 0x68, 0x41, 0x6f, 0x69, 0x6e, 0x65, 0x3b, 0x44, 0x69, 0x53, 0x61, 0x74, 0x68,
0x61, 0x69, 0x72, 0x6e, 0x65, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x43, 0x3b, 0x41, 0x3b, 0x48, 0x3b, 0x53, 0x3b,
0x44, 0x6f, 0x6d, 0x2e, 0x3b, 0x4c, 0x75, 0x6e, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x2e, 0x3b, 0x4d, 0xe9, 0x72, 0x2e, 0x3b,
0x58, 0x6f, 0x76, 0x2e, 0x3b, 0x56, 0x65, 0x6e, 0x2e, 0x3b, 0x53, 0xe1, 0x62, 0x2e, 0x3b, 0x44, 0x6f, 0x6d, 0x69, 0x6e,
0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0xe9, 0x72, 0x63, 0x6f,
0x72, 0x65, 0x73, 0x3b, 0x58, 0x6f, 0x76, 0x65, 0x73, 0x3b, 0x56, 0x65, 0x6e, 0x72, 0x65, 0x73, 0x3b, 0x53, 0xe1, 0x62,
0x61, 0x64, 0x6f, 0x3b, 0x64, 0x6f, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x6d,
0xe9, 0x72, 0x2e, 0x3b, 0x78, 0x6f, 0x76, 0x2e, 0x3b, 0x76, 0x65, 0x6e, 0x2e, 0x3b, 0x73, 0xe1, 0x62, 0x2e, 0x3b, 0x64,
0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x6d,
0xe9, 0x72, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x3b, 0x78, 0x6f, 0x76, 0x65, 0x73, 0x3b, 0x76, 0x65, 0x6e, 0x72, 0x65, 0x73,
0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x64, 0x2e, 0x3b, 0x6c, 0x2e, 0x3b, 0x6d, 0x2e, 0x3b, 0x6d, 0x2e, 0x3b,
0x78, 0x2e, 0x3b, 0x76, 0x2e, 0x3b, 0x73, 0x2e, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x42, 0x61, 0x6c, 0x3b, 0x4c, 0x77, 0x32,
0x3b, 0x4c, 0x77, 0x33, 0x3b, 0x4c, 0x77, 0x34, 0x3b, 0x4c, 0x77, 0x35, 0x3b, 0x4c, 0x77, 0x36, 0x3b, 0x53, 0x61, 0x62,
0x62, 0x69, 0x69, 0x74, 0x69, 0x3b, 0x42, 0x61, 0x6c, 0x61, 0x7a, 0x61, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x62, 0x69,
0x72, 0x69, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x73, 0x61, 0x74, 0x75, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x6e, 0x61,
0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x74, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x4c, 0x77, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x61,
0x67, 0x61, 0x3b, 0x53, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x12a5, 0x1281, 0x12f5,
0x3b, 0x1230, 0x1291, 0x12ed, 0x3b, 0x1220, 0x1209, 0x1235, 0x3b, 0x122b, 0x1265, 0x12d5, 0x3b, 0x1210, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1260,
0x3b, 0x1240, 0x12f3, 0x121a, 0x1275, 0x3b, 0x12a5, 0x3b, 0x1230, 0x3b, 0x1220, 0x3b, 0x122b, 0x3b, 0x1210, 0x3b, 0x12d3, 0x3b, 0x1240, 0x3b,
0x10d9, 0x10d5, 0x10d8, 0x3b, 0x10dd, 0x10e0, 0x10e8, 0x3b, 0x10e1, 0x10d0, 0x10db, 0x3b, 0x10dd, 0x10d7, 0x10ee, 0x3b, 0x10ee, 0x10e3, 0x10d7, 0x3b,
0x10de, 0x10d0, 0x10e0, 0x3b, 0x10e8, 0x10d0, 0x10d1, 0x3b, 0x10d9, 0x10d5, 0x10d8, 0x10e0, 0x10d0, 0x3b, 0x10dd, 0x10e0, 0x10e8, 0x10d0, 0x10d1, 0x10d0,
0x10d7, 0x10d8, 0x3b, 0x10e1, 0x10d0, 0x10db, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10dd, 0x10d7, 0x10ee, 0x10e8, 0x10d0, 0x10d1, 0x10d0,
0x10d7, 0x10d8, 0x3b, 0x10ee, 0x10e3, 0x10d7, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10de, 0x10d0, 0x10e0, 0x10d0, 0x10e1, 0x10d9, 0x10d4,
0x10d5, 0x10d8, 0x3b, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10d9, 0x3b, 0x10dd, 0x3b, 0x10e1, 0x3b, 0x10dd, 0x3b, 0x10ee, 0x3b,
0x10de, 0x3b, 0x10e8, 0x3b, 0x53, 0x6f, 0x3b, 0x4d, 0x6f, 0x3b, 0x44, 0x69, 0x3b, 0x4d, 0x69, 0x3b, 0x44, 0x6f, 0x3b, 0x46,
0x72, 0x3b, 0x53, 0x61, 0x3b, 0x53, 0x6f, 0x6e, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x4d, 0x6f, 0x6e, 0x74, 0x61, 0x67, 0x3b,
0x44, 0x69, 0x65, 0x6e, 0x73, 0x74, 0x61, 0x67, 0x3b, 0x4d, 0x69, 0x74, 0x74, 0x77, 0x6f, 0x63, 0x68, 0x3b, 0x44, 0x6f,
0x6e, 0x6e, 0x65, 0x72, 0x73, 0x74, 0x61, 0x67, 0x3b, 0x46, 0x72, 0x65, 0x69, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x61, 0x6d,
0x73, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x6f, 0x2e, 0x3b, 0x4d, 0x6f, 0x2e, 0x3b, 0x44, 0x69, 0x2e, 0x3b, 0x4d, 0x69, 0x2e,
0x3b, 0x44, 0x6f, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x39a, 0x3c5, 0x3c1, 0x3b, 0x394, 0x3b5, 0x3c5,
0x3b, 0x3a4, 0x3c1, 0x3af, 0x3b, 0x3a4, 0x3b5, 0x3c4, 0x3b, 0x3a0, 0x3ad, 0x3bc, 0x3b, 0x3a0, 0x3b1, 0x3c1, 0x3b, 0x3a3, 0x3ac, 0x3b2,
0x3b, 0x39a, 0x3c5, 0x3c1, 0x3b9, 0x3b1, 0x3ba, 0x3ae, 0x3b, 0x394, 0x3b5, 0x3c5, 0x3c4, 0x3ad, 0x3c1, 0x3b1, 0x3b, 0x3a4, 0x3c1, 0x3af,
0x3c4, 0x3b7, 0x3b, 0x3a4, 0x3b5, 0x3c4, 0x3ac, 0x3c1, 0x3c4, 0x3b7, 0x3b, 0x3a0, 0x3ad, 0x3bc, 0x3c0, 0x3c4, 0x3b7, 0x3b, 0x3a0, 0x3b1,
0x3c1, 0x3b1, 0x3c3, 0x3ba, 0x3b5, 0x3c5, 0x3ae, 0x3b, 0x3a3, 0x3ac, 0x3b2, 0x3b2, 0x3b1, 0x3c4, 0x3bf, 0x3b, 0x39a, 0x3b, 0x394, 0x3b,
0x3a4, 0x3b, 0x3a4, 0x3b, 0x3a0, 0x3b, 0x3a0, 0x3b, 0x3a3, 0x3b, 0x41, 0x72, 0x61, 0x74, 0x65, 0x129, 0x3b, 0x41, 0x72, 0x61,
0x6b, 0xf5, 0x69, 0x3b, 0x41, 0x72, 0x61, 0x61, 0x70, 0x79, 0x3b, 0x41, 0x72, 0x61, 0x72, 0x75, 0x6e, 0x64, 0x79, 0x3b,
0x41, 0x72, 0x61, 0x70, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x70, 0x6f, 0x74, 0x65, 0x129, 0x3b, 0x41, 0x72, 0x61, 0x70, 0x6f,
0x6b, 0xf5, 0x69, 0x3b, 0xab0, 0xab5, 0xabf, 0x3b, 0xab8, 0xacb, 0xaae, 0x3b, 0xaae, 0xa82, 0xa97, 0xab3, 0x3b, 0xaac, 0xac1, 0xaa7,
0x3b, 0xa97, 0xac1, 0xab0, 0xac1, 0x3b, 0xab6, 0xac1, 0xa95, 0xacd, 0xab0, 0x3b, 0xab6, 0xaa8, 0xabf, 0x3b, 0xab0, 0xab5, 0xabf, 0xab5,
0xabe, 0xab0, 0x3b, 0xab8, 0xacb, 0xaae, 0xab5, 0xabe, 0xab0, 0x3b, 0xaae, 0xa82, 0xa97, 0xab3, 0xab5, 0xabe, 0xab0, 0x3b, 0xaac, 0xac1,
0xaa7, 0xab5, 0xabe, 0xab0, 0x3b, 0xa97, 0xac1, 0xab0, 0xac1, 0xab5, 0xabe, 0xab0, 0x3b, 0xab6, 0xac1, 0xa95, 0xacd, 0xab0, 0xab5, 0xabe,
0xab0, 0x3b, 0xab6, 0xaa8, 0xabf, 0xab5, 0xabe, 0xab0, 0x3b, 0xab0, 0x3b, 0xab8, 0xacb, 0x3b, 0xaae, 0xa82, 0x3b, 0xaac, 0xac1, 0x3b,
0xa97, 0xac1, 0x3b, 0xab6, 0xac1, 0x3b, 0xab6, 0x3b, 0x43, 0x70, 0x72, 0x3b, 0x43, 0x74, 0x74, 0x3b, 0x43, 0x6d, 0x6e, 0x3b,
0x43, 0x6d, 0x74, 0x3b, 0x41, 0x72, 0x73, 0x3b, 0x49, 0x63, 0x6d, 0x3b, 0x45, 0x73, 0x74, 0x3b, 0x43, 0x68, 0x75, 0x6d,
0x61, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43, 0x68, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x6f, 0x3b, 0x43, 0x68, 0x75, 0x6d,
0x61, 0x69, 0x6e, 0x65, 0x3b, 0x43, 0x68, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69,
0x73, 0x69, 0x3b, 0x49, 0x63, 0x68, 0x75, 0x6d, 0x61, 0x3b, 0x45, 0x73, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b, 0x43, 0x3b,
0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x45, 0x3b, 0x910, 0x924, 0x935, 0x93e, 0x930, 0x3b, 0x938, 0x94b,
0x92e, 0x935, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930, 0x3b,
0x92c, 0x943, 0x939, 0x938, 0x94d, 0x92a, 0x924, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x935, 0x93e, 0x930, 0x3b,
0x936, 0x928, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x4c, 0x61, 0x68, 0x3b, 0x4c, 0x69, 0x74, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x4c,
0x61, 0x72, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x41, 0x73, 0x61, 0x3b, 0x4c, 0x61, 0x68, 0x61, 0x64,
0x69, 0x3b, 0x4c, 0x69, 0x74, 0x69, 0x6e, 0x69, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x4c, 0x61, 0x72,
0x61, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x6d, 0x61, 0x2bc, 0x61, 0x3b,
0x41, 0x73, 0x61, 0x62, 0x61, 0x72, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x4a, 0x3b, 0x41,
0x3b, 0x644, 0x64e, 0x62d, 0x3b, 0x644, 0x650, 0x62a, 0x3b, 0x62a, 0x64e, 0x644, 0x3b, 0x644, 0x64e, 0x631, 0x3b, 0x623, 0x64e, 0x644,
0x652, 0x62d, 0x3b, 0x62c, 0x64f, 0x645, 0x3b, 0x623, 0x64e, 0x633, 0x64e, 0x3b, 0x644, 0x64e, 0x62d, 0x64e, 0x62f, 0x650, 0x3b, 0x644,
0x650, 0x62a, 0x650, 0x646, 0x650, 0x646, 0x652, 0x3b, 0x62a, 0x64e, 0x644, 0x64e, 0x62a, 0x64e, 0x3b, 0x644, 0x64e, 0x631, 0x64e, 0x628,
0x64e, 0x3b, 0x623, 0x64e, 0x644, 0x652, 0x62d, 0x64e, 0x645, 0x650, 0x633, 0x652, 0x3b, 0x62c, 0x64f, 0x645, 0x64e, 0x639, 0x64e, 0x3b,
0x623, 0x64e, 0x633, 0x64e, 0x628, 0x64e, 0x631, 0x652, 0x3b, 0x4c, 0x50, 0x3b, 0x50, 0x31, 0x3b, 0x50, 0x32, 0x3b, 0x50, 0x33,
0x3b, 0x50, 0x34, 0x3b, 0x50, 0x35, 0x3b, 0x50, 0x36, 0x3b, 0x4c, 0x101, 0x70, 0x75, 0x6c, 0x65, 0x3b, 0x50, 0x6f, 0x2bb,
0x61, 0x6b, 0x61, 0x68, 0x69, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6c, 0x75, 0x61, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6b, 0x6f,
0x6c, 0x75, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x68, 0x101, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6c, 0x69, 0x6d, 0x61, 0x3b, 0x50,
0x6f, 0x2bb, 0x61, 0x6f, 0x6e, 0x6f, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d0, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d1, 0x5f3,
0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d2, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d3, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d4,
0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d5, 0x5f3, 0x3b, 0x5e9, 0x5d1, 0x5ea, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e8, 0x5d0, 0x5e9,
0x5d5, 0x5df, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5e0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5dc, 0x5d9, 0x5e9, 0x5d9,
0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e8, 0x5d1, 0x5d9, 0x5e2, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d7, 0x5de, 0x5d9, 0x5e9, 0x5d9,
0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5d9, 0x5e9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5d1, 0x5ea, 0x3b, 0x5d0, 0x5f3,
0x3b, 0x5d1, 0x5f3, 0x3b, 0x5d2, 0x5f3, 0x3b, 0x5d3, 0x5f3, 0x3b, 0x5d4, 0x5f3, 0x3b, 0x5d5, 0x5f3, 0x3b, 0x5e9, 0x5f3, 0x3b, 0x930,
0x935, 0x93f, 0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x3b, 0x92c, 0x941, 0x927, 0x3b, 0x917, 0x941, 0x930, 0x941,
0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x3b, 0x930, 0x935, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x938, 0x94b,
0x92e, 0x935, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930, 0x3b,
0x917, 0x941, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f,
0x935, 0x93e, 0x930, 0x3b, 0x930, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b, 0x917, 0x941, 0x3b, 0x936, 0x941,
0x3b, 0x936, 0x3b, 0x52, 0x61, 0x76, 0x69, 0x3b, 0x53, 0x6f, 0x6d, 0x3b, 0x4d, 0x61, 0x6e, 0x67, 0x61, 0x6c, 0x3b, 0x42,
0x75, 0x64, 0x68, 0x3b, 0x47, 0x75, 0x72, 0x75, 0x3b, 0x53, 0x68, 0x75, 0x6b, 0x72, 0x61, 0x3b, 0x53, 0x68, 0x61, 0x6e,
0x69, 0x3b, 0x52, 0x61, 0x76, 0x69, 0x77, 0x61, 0x61, 0x72, 0x3b, 0x53, 0x6f, 0x6d, 0x77, 0x61, 0x61, 0x72, 0x3b, 0x4d,
0x61, 0x6e, 0x67, 0x61, 0x6c, 0x77, 0x61, 0x61, 0x72, 0x3b, 0x42, 0x75, 0x64, 0x68, 0x77, 0x61, 0x61, 0x72, 0x3b, 0x47,
0x75, 0x72, 0x75, 0x77, 0x61, 0x61, 0x72, 0x3b, 0x53, 0x68, 0x75, 0x6b, 0x72, 0x61, 0x77, 0x61, 0x61, 0x72, 0x3b, 0x53,
0x68, 0x61, 0x6e, 0x69, 0x77, 0x61, 0x61, 0x72, 0x3b, 0x52, 0x61, 0x3b, 0x53, 0x6f, 0x3b, 0x4d, 0x61, 0x3b, 0x42, 0x75,
0x3b, 0x47, 0x75, 0x3b, 0x53, 0x68, 0x3b, 0x53, 0x68, 0x61, 0x3b, 0xd838, 0xdd0e, 0xd838, 0xdd24, 0xd838, 0xdd32, 0x3b, 0xd838, 0xdd08,
0xd838, 0xdd26, 0x3b, 0xd838, 0xdd06, 0xd838, 0xdd28, 0xd838, 0xdd30, 0x3b, 0xd838, 0xdd17, 0xd838, 0xdd04, 0xd838, 0xdd24, 0xd838, 0xdd30, 0xd838, 0xdd26,
0x3b, 0xd838, 0xdd19, 0xd838, 0xdd24, 0xd838, 0xdd31, 0xd838, 0xdd28, 0x3b, 0xd838, 0xdd11, 0xd838, 0xdd24, 0xd838, 0xdd31, 0xd838, 0xdd28, 0x3b, 0xd838,
0xdd0a, 0xd838, 0xdd27, 0xd838, 0xdd33, 0x3b, 0x56, 0x3b, 0x48, 0x3b, 0x4b, 0x3b, 0x53, 0x7a, 0x65, 0x3b, 0x43, 0x73, 0x3b, 0x50,
0x3b, 0x53, 0x7a, 0x6f, 0x3b, 0x76, 0x61, 0x73, 0xe1, 0x72, 0x6e, 0x61, 0x70, 0x3b, 0x68, 0xe9, 0x74, 0x66, 0x151, 0x3b,
0x6b, 0x65, 0x64, 0x64, 0x3b, 0x73, 0x7a, 0x65, 0x72, 0x64, 0x61, 0x3b, 0x63, 0x73, 0xfc, 0x74, 0xf6, 0x72, 0x74, 0xf6,
0x6b, 0x3b, 0x70, 0xe9, 0x6e, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x7a, 0x6f, 0x6d, 0x62, 0x61, 0x74, 0x3b, 0x56, 0x3b, 0x48,
0x3b, 0x4b, 0x3b, 0x53, 0x7a, 0x3b, 0x43, 0x73, 0x3b, 0x50, 0x3b, 0x53, 0x7a, 0x3b, 0x73, 0x75, 0x6e, 0x2e, 0x3b, 0x6d,
0xe1, 0x6e, 0x2e, 0x3b, 0xfe, 0x72, 0x69, 0x2e, 0x3b, 0x6d, 0x69, 0xf0, 0x2e, 0x3b, 0x66, 0x69, 0x6d, 0x2e, 0x3b, 0x66,
0xf6, 0x73, 0x2e, 0x3b, 0x6c, 0x61, 0x75, 0x2e, 0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b,
0x6d, 0xe1, 0x6e, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0xfe, 0x72, 0x69, 0xf0, 0x6a, 0x75, 0x64, 0x61, 0x67, 0x75,
0x72, 0x3b, 0x6d, 0x69, 0xf0, 0x76, 0x69, 0x6b, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x66, 0x69, 0x6d, 0x6d, 0x74,
0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x66, 0xf6, 0x73, 0x74, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6c, 0x61,
0x75, 0x67, 0x61, 0x72, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0xde, 0x3b, 0x4d, 0x3b, 0x46, 0x3b,
0x46, 0x3b, 0x4c, 0x3b, 0x53, 0x1ecd, 0x6e, 0x3b, 0x4d, 0x1ecd, 0x6e, 0x3b, 0x54, 0x69, 0x75, 0x3b, 0x57, 0x65, 0x6e, 0x3b,
0x54, 0x1ecd, 0x1ecd, 0x3b, 0x46, 0x72, 0x61, 0x1ecb, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x53, 0x1ecd, 0x6e, 0x64, 0x65, 0x65, 0x3b,
0x4d, 0x1ecd, 0x6e, 0x64, 0x65, 0x3b, 0x54, 0x69, 0x75, 0x7a, 0x64, 0x65, 0x65, 0x3b, 0x57, 0x65, 0x6e, 0x65, 0x7a, 0x64,
0x65, 0x65, 0x3b, 0x54, 0x1ecd, 0x1ecd, 0x7a, 0x64, 0x65, 0x65, 0x3b, 0x46, 0x72, 0x61, 0x1ecb, 0x64, 0x65, 0x65, 0x3b, 0x53,
0x61, 0x74, 0x1ecd, 0x64, 0x65, 0x65, 0x3b, 0x70, 0x61, 0x73, 0x3b, 0x76, 0x75, 0x6f, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6b,
0x6f, 0x73, 0x3b, 0x74, 0x75, 0x6f, 0x3b, 0x76, 0xe1, 0x73, 0x3b, 0x6c, 0xe1, 0x76, 0x3b, 0x70, 0x61, 0x73, 0x65, 0x70,
0x65, 0x69, 0x76, 0x69, 0x3b, 0x76, 0x75, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6d, 0x61, 0x6a, 0x65, 0x62,
0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6b, 0x6f, 0x73, 0x6b, 0x6f, 0x6b, 0x6b, 0x6f, 0x3b, 0x74, 0x75, 0x6f, 0x72, 0xe2, 0x73,
0x74, 0xe2, 0x68, 0x3b, 0x76, 0xe1, 0x73, 0x74, 0x75, 0x70, 0x70, 0x65, 0x69, 0x76, 0x69, 0x3b, 0x6c, 0xe1, 0x76, 0x75,
0x72, 0x64, 0xe2, 0x68, 0x3b, 0x70, 0x61, 0x73, 0x65, 0x70, 0x65, 0x65, 0x69, 0x76, 0x69, 0x3b, 0x76, 0x75, 0x6f, 0x73,
0x73, 0x61, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6d, 0x61, 0x6a, 0x65, 0x62, 0x61, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6b, 0x6f,
0x73, 0x6b, 0x6f, 0x68, 0x6f, 0x3b, 0x74, 0x75, 0x6f, 0x72, 0xe2, 0x73, 0x74, 0x75, 0x76, 0x3b, 0x76, 0xe1, 0x73, 0x74,
0x75, 0x70, 0x70, 0x65, 0x65, 0x69, 0x76, 0x69, 0x3b, 0x6c, 0xe1, 0x76, 0x75, 0x72, 0x64, 0x75, 0x76, 0x3b, 0x70, 0x3b,
0x56, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x56, 0x3b, 0x4c, 0x3b, 0x4d, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6e, 0x3b,
0x53, 0x65, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x3b, 0x4b, 0x61, 0x6d, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x3b,
0x4d, 0x69, 0x6e, 0x67, 0x67, 0x75, 0x3b, 0x53, 0x65, 0x6e, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x61, 0x73, 0x61, 0x3b,
0x52, 0x61, 0x62, 0x75, 0x3b, 0x4b, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x3b, 0x53, 0x61, 0x62,
0x74, 0x75, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d,
0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x72, 0x3b, 0x6a, 0x6f, 0x76, 0x3b, 0x76, 0x65, 0x6e,
0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x3b, 0x6c, 0x75, 0x6e, 0x65, 0x64, 0x69,
0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x64, 0x69, 0x3b, 0x6d, 0x65, 0x72, 0x63, 0x75, 0x72, 0x69, 0x64, 0x69, 0x3b, 0x6a,
0x6f, 0x76, 0x65, 0x64, 0x69, 0x3b, 0x76, 0x65, 0x6e, 0x65, 0x72, 0x64, 0x69, 0x3b, 0x73, 0x61, 0x62, 0x62, 0x61, 0x74,
0x6f, 0x3b, 0x64, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x76, 0x3b, 0x73, 0x3b, 0x14c8, 0x1466, 0x144f, 0x1591,
0x152d, 0x1585, 0x3b, 0x14c7, 0x14a1, 0x1490, 0x153e, 0x152d, 0x1405, 0x3b, 0x14c7, 0x14a1, 0x1490, 0x153e, 0x152d, 0x1405, 0x14d5, 0x1585, 0x146d, 0x3b,
0x1431, 0x1593, 0x1466, 0x14ef, 0x1585, 0x3b, 0x14ef, 0x1455, 0x14bb, 0x14a5, 0x1585, 0x3b, 0x1455, 0x14ea, 0x14d5, 0x14bb, 0x14a5, 0x1405, 0x1466, 0x3b,
0x14c8, 0x1466, 0x14f0, 0x1591, 0x152d, 0x14db, 0x1550, 0x14c2, 0x140a, 0x1585, 0x3b, 0x44, 0x6f, 0x6d, 0x68, 0x3b, 0x4c, 0x75, 0x61, 0x6e,
0x3b, 0x4d, 0xe1, 0x69, 0x72, 0x74, 0x3b, 0x43, 0xe9, 0x61, 0x64, 0x3b, 0x44, 0xe9, 0x61, 0x72, 0x3b, 0x41, 0x6f, 0x69,
0x6e, 0x65, 0x3b, 0x53, 0x61, 0x74, 0x68, 0x3b, 0x44, 0xe9, 0x20, 0x44, 0x6f, 0x6d, 0x68, 0x6e, 0x61, 0x69, 0x67, 0x68,
0x3b, 0x44, 0xe9, 0x20, 0x4c, 0x75, 0x61, 0x69, 0x6e, 0x3b, 0x44, 0xe9, 0x20, 0x4d, 0xe1, 0x69, 0x72, 0x74, 0x3b, 0x44,
0xe9, 0x20, 0x43, 0xe9, 0x61, 0x64, 0x61, 0x6f, 0x69, 0x6e, 0x3b, 0x44, 0xe9, 0x61, 0x72, 0x64, 0x61, 0x6f, 0x69, 0x6e,
0x3b, 0x44, 0xe9, 0x20, 0x68, 0x41, 0x6f, 0x69, 0x6e, 0x65, 0x3b, 0x44, 0xe9, 0x20, 0x53, 0x61, 0x74, 0x68, 0x61, 0x69,
0x72, 0x6e, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x43, 0x3b, 0x44, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d,
0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x72, 0x3b, 0x67, 0x69, 0x6f, 0x3b, 0x76, 0x65, 0x6e,
0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x65, 0x6e, 0x69, 0x63, 0x61, 0x3b, 0x6c, 0x75, 0x6e, 0x65, 0x64, 0xec,
0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x64, 0xec, 0x3b, 0x6d, 0x65, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x64, 0xec, 0x3b, 0x67,
0x69, 0x6f, 0x76, 0x65, 0x64, 0xec, 0x3b, 0x76, 0x65, 0x6e, 0x65, 0x72, 0x64, 0xec, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x74,
0x6f, 0x3b, 0x65e5, 0x3b, 0x6708, 0x3b, 0x706b, 0x3b, 0x6c34, 0x3b, 0x6728, 0x3b, 0x91d1, 0x3b, 0x571f, 0x3b, 0x65e5, 0x66dc, 0x65e5, 0x3b,
0x6708, 0x66dc, 0x65e5, 0x3b, 0x706b, 0x66dc, 0x65e5, 0x3b, 0x6c34, 0x66dc, 0x65e5, 0x3b, 0x6728, 0x66dc, 0x65e5, 0x3b, 0x91d1, 0x66dc, 0x65e5, 0x3b,
0x571f, 0x66dc, 0x65e5, 0x3b, 0x41, 0x68, 0x61, 0x64, 0x3b, 0x53, 0x65, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x3b, 0x52, 0x61, 0x62,
0x3b, 0x4b, 0x61, 0x6d, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x41, 0x68, 0x61, 0x64, 0x3b, 0x53, 0x65,
0x6e, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x61, 0x73, 0x61, 0x3b, 0x52, 0x61, 0x62, 0x75, 0x3b, 0x4b, 0x61, 0x6d, 0x69,
0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x75, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x53, 0x3b,
0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x4c, 0x61, 0x64, 0x3b, 0x4c, 0x69, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x3b,
0x4c, 0x61, 0x72, 0x3b, 0x4c, 0x61, 0x6d, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x41, 0x73, 0x61, 0x3b, 0x4c, 0x61, 0x64, 0x69,
0x3b, 0x4c, 0x69, 0x6e, 0x74, 0x61, 0x6e, 0x69, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x4c, 0x61, 0x72, 0x62,
0x61, 0x3b, 0x4c, 0x61, 0x6d, 0x69, 0x74, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x61, 0x72, 0x3b,
0x44, 0x69, 0x6d, 0x3b, 0x54, 0x65, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x72, 0x61, 0x3b,
0x41, 0x72, 0x6a, 0x3b, 0x53, 0x69, 0x62, 0x3b, 0x44, 0x69, 0x6d, 0x61, 0x73, 0x3b, 0x54, 0x65, 0x6e, 0x65, 0x14b, 0x3b,
0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x79, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69,
0x73, 0x61, 0x79, 0x3b, 0x41, 0x72, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x53, 0x69, 0x62, 0x69, 0x74, 0x69, 0x3b, 0x44, 0x3b,
0x54, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x64, 0x75, 0x6d, 0x3b, 0x73, 0x69, 0x67, 0x3b,
0x74, 0x65, 0x72, 0x3b, 0x6b, 0x75, 0x61, 0x3b, 0x6b, 0x69, 0x6e, 0x3b, 0x73, 0x65, 0x73, 0x3b, 0x73, 0x61, 0x62, 0x3b,
0x64, 0x75, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x73, 0x69, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61,
0x3b, 0x74, 0x65, 0x72, 0x73, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x6b, 0x75, 0x61, 0x72, 0x74, 0x61, 0x2d, 0x66,
0x65, 0x72, 0x61, 0x3b, 0x6b, 0x69, 0x6e, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x73, 0x65, 0x73, 0x74, 0x61,
0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x75, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x4b,
0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x41, 0x63, 0x65, 0x3b, 0x41, 0x72, 0x69, 0x3b, 0x41, 0x72, 0x61, 0x3b, 0x41,
0x68, 0x61, 0x3b, 0x41, 0x6d, 0x68, 0x3b, 0x53, 0x65, 0x6d, 0x3b, 0x53, 0x65, 0x64, 0x3b, 0x41, 0x63, 0x65, 0x72, 0x3b,
0x41, 0x72, 0x69, 0x6d, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x3b, 0x41, 0x68, 0x61, 0x64, 0x3b, 0x41, 0x6d, 0x68, 0x61, 0x64,
0x3b, 0x53, 0x65, 0x6d, 0x3b, 0x53, 0x65, 0x64, 0x3b, 0x59, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x53,
0x3b, 0x53, 0x3b, 0x59, 0x61, 0x6e, 0x3b, 0x53, 0x61, 0x6e, 0x3b, 0x4b, 0x72, 0x61, 0x1e0d, 0x3b, 0x4b, 0x75, 0x1e93, 0x3b,
0x53, 0x61, 0x6d, 0x3b, 0x53, 0x1e0d, 0x69, 0x73, 0x3b, 0x53, 0x61, 0x79, 0x3b, 0x59, 0x61, 0x6e, 0x61, 0x73, 0x73, 0x3b,
0x53, 0x61, 0x6e, 0x61, 0x73, 0x73, 0x3b, 0x4b, 0x72, 0x61, 0x1e0d, 0x61, 0x73, 0x73, 0x3b, 0x4b, 0x75, 0x1e93, 0x61, 0x73,
0x73, 0x3b, 0x53, 0x61, 0x6d, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x1e0d, 0x69, 0x73, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x61, 0x79,
0x61, 0x73, 0x73, 0x3b, 0x43, 0x3b, 0x52, 0x3b, 0x52, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x6e, 0x75,
0x6d, 0x2e, 0x3b, 0x70, 0x69, 0x72, 0x2e, 0x3b, 0x72, 0xe9, 0x67, 0x2e, 0x3b, 0x74, 0x1ebd, 0x67, 0x2e, 0x3b, 0x76, 0x1ebd,
0x6e, 0x2e, 0x3b, 0x70, 0xe9, 0x6e, 0x2e, 0x3b, 0x73, 0x61, 0x76, 0x2e, 0x3b, 0x6e, 0x75, 0x6d, 0x129, 0x67, 0x67, 0x75,
0x3b, 0x70, 0x69, 0x72, 0x2d, 0x6b, 0x75, 0x72, 0xe3, 0x2d, 0x68, 0xe1, 0x3b, 0x72, 0xe9, 0x67, 0x72, 0x65, 0x2d, 0x6b,
0x75, 0x72, 0xe3, 0x2d, 0x68, 0xe1, 0x3b, 0x74, 0x1ebd, 0x67, 0x74, 0x169, 0x2d, 0x6b, 0x75, 0x72, 0xe3, 0x2d, 0x68, 0xe1,
0x3b, 0x76, 0x1ebd, 0x6e, 0x68, 0x6b, 0xe3, 0x67, 0x72, 0x61, 0x2d, 0x6b, 0x75, 0x72, 0xe3, 0x2d, 0x68, 0xe1, 0x3b, 0x70,
0xe9, 0x6e, 0x6b, 0x61, 0x72, 0x2d, 0x6b, 0x75, 0x72, 0xe3, 0x2d, 0x68, 0xe1, 0x3b, 0x73, 0x61, 0x76, 0x6e, 0x75, 0x3b,
0x4e, 0x2e, 0x3b, 0x50, 0x2e, 0x3b, 0x52, 0x2e, 0x3b, 0x54, 0x2e, 0x3b, 0x56, 0x2e, 0x3b, 0x50, 0x2e, 0x3b, 0x53, 0x2e,
0x3b, 0x73, 0x254, 0x6e, 0x64, 0x69, 0x3b, 0x6c, 0x75, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d,
0x25b, 0x72, 0x6b, 0x25b, 0x72, 0x25b, 0x64, 0x69, 0x3b, 0x79, 0x65, 0x64, 0x69, 0x3b, 0x76, 0x61, 0x14b, 0x64, 0x25b, 0x72,
0x25b, 0x64, 0x69, 0x3b, 0x6d, 0x254, 0x6e, 0x254, 0x20, 0x73, 0x254, 0x6e, 0x64, 0x69, 0x3b, 0x73, 0x6f, 0x3b, 0x6c, 0x75,
0x3b, 0x6d, 0x61, 0x3b, 0x6d, 0x25b, 0x3b, 0x79, 0x65, 0x3b, 0x76, 0x61, 0x3b, 0x6d, 0x73, 0x3b, 0x73, 0x61, 0x70, 0x3b,
0x61, 0x74, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x70, 0x69, 0x6e, 0x3b, 0x73, 0x69, 0x73, 0x3b, 0x74, 0x61, 0x6c, 0x3b,
0x61, 0x72, 0x66, 0x3b, 0x73, 0x61, 0x70, 0x61, 0x61, 0x74, 0x3b, 0x61, 0x74, 0x61, 0x61, 0x73, 0x69, 0x6e, 0x6e, 0x67,
0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x6d, 0x61, 0x72, 0x6c, 0x75, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b,
0x70, 0x69, 0x6e, 0x67, 0x61, 0x73, 0x75, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x73, 0x69, 0x73, 0x61,
0x6d, 0x61, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x74, 0x61, 0x6c, 0x6c, 0x69, 0x6d, 0x61, 0x6e, 0x6e,
0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x61, 0x72, 0x66, 0x69, 0x6e, 0x69, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65,
0x71, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x4b, 0x74, 0x73, 0x3b,
0x4b, 0x6f, 0x74, 0x3b, 0x4b, 0x6f, 0x6f, 0x3b, 0x4b, 0x6f, 0x73, 0x3b, 0x4b, 0x6f, 0x61, 0x3b, 0x4b, 0x6f, 0x6d, 0x3b,
0x4b, 0x6f, 0x6c, 0x3b, 0x4b, 0x6f, 0x74, 0x69, 0x73, 0x61, 0x70, 0x3b, 0x4b, 0x6f, 0x74, 0x61, 0x61, 0x69, 0x3b, 0x4b,
0x6f, 0x61, 0x65, 0x6e, 0x67, 0x2019, 0x3b, 0x4b, 0x6f, 0x73, 0x6f, 0x6d, 0x6f, 0x6b, 0x3b, 0x4b, 0x6f, 0x61, 0x6e, 0x67,
0x2019, 0x77, 0x61, 0x6e, 0x3b, 0x4b, 0x6f, 0x6d, 0x75, 0x75, 0x74, 0x3b, 0x4b, 0x6f, 0x6c, 0x6f, 0x3b, 0x54, 0x3b, 0x54,
0x3b, 0x4f, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4c, 0x3b, 0x57, 0x6b, 0x79, 0x3b, 0x57, 0x6b, 0x77, 0x3b, 0x57,
0x6b, 0x6c, 0x3b, 0x57, 0x74, 0x169, 0x3b, 0x57, 0x6b, 0x6e, 0x3b, 0x57, 0x74, 0x6e, 0x3b, 0x57, 0x74, 0x68, 0x3b, 0x57,
0x61, 0x20, 0x6b, 0x79, 0x75, 0x6d, 0x77, 0x61, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x77, 0x61, 0x6d, 0x62, 0x129, 0x6c, 0x129,
0x6c, 0x79, 0x61, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x65, 0x6c, 0x129, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x74,
0x169, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b,
0x57, 0x61, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x74, 0x68, 0x61, 0x74, 0x169, 0x3b, 0x59, 0x3b, 0x57, 0x3b, 0x45, 0x3b, 0x41,
0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0xcad, 0xcbe, 0xca8, 0xcc1, 0x3b, 0xcb8, 0xccb, 0xcae, 0x3b, 0xcae, 0xc82, 0xc97, 0xcb3,
0x3b, 0xcac, 0xcc1, 0xca7, 0x3b, 0xc97, 0xcc1, 0xcb0, 0xcc1, 0x3b, 0xcb6, 0xcc1, 0xc95, 0xccd, 0xcb0, 0x3b, 0xcb6, 0xca8, 0xcbf, 0x3b,
0xcad, 0xcbe, 0xca8, 0xcc1, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcb8, 0xccb, 0xcae, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcae, 0xc82, 0xc97, 0xcb3, 0xcb5,
0xcbe, 0xcb0, 0x3b, 0xcac, 0xcc1, 0xca7, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xc97, 0xcc1, 0xcb0, 0xcc1, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcb6, 0xcc1,
0xc95, 0xccd, 0xcb0, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcb6, 0xca8, 0xcbf, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcad, 0xcbe, 0x3b, 0xcb8, 0xccb, 0x3b,
0xcae, 0xc82, 0x3b, 0xcac, 0xcc1, 0x3b, 0xc97, 0xcc1, 0x3b, 0xcb6, 0xcc1, 0x3b, 0xcb6, 0x3b, 0x622, 0x62a, 0x6be, 0x648, 0x627, 0x631,
0x3b, 0x698, 0x654, 0x646, 0x62f, 0x655, 0x631, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x6c6, 0x645, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x648,
0x62f, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x631, 0x620, 0x633, 0x648, 0x627, 0x631, 0x3b, 0x62c, 0x64f, 0x645, 0x6c1, 0x3b, 0x628, 0x679,
0x648, 0x627, 0x631, 0x3b, 0x627, 0x64e, 0x62a, 0x6be, 0x648, 0x627, 0x631, 0x3b, 0x698, 0x654, 0x646, 0x62f, 0x631, 0x655, 0x631, 0x648,
0x627, 0x631, 0x3b, 0x628, 0x6c6, 0x645, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x648, 0x62f, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x631, 0x620,
0x633, 0x648, 0x627, 0x631, 0x3b, 0x62c, 0x64f, 0x645, 0x6c1, 0x3b, 0x628, 0x679, 0x648, 0x627, 0x631, 0x3b, 0x627, 0x3b, 0x698, 0x3b,
0x628, 0x3b, 0x628, 0x3b, 0x628, 0x3b, 0x62c, 0x3b, 0x628, 0x3b, 0x906, 0x925, 0x935, 0x93e, 0x930, 0x3b, 0x91a, 0x902, 0x926, 0x93f,
0x930, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x94b, 0x926, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x94d,
0x930, 0x947, 0x938, 0x935, 0x93e, 0x930, 0x3b, 0x91c, 0x941, 0x92e, 0x94d, 0x92e, 0x93e, 0x3b, 0x92c, 0x91f, 0x935, 0x93e, 0x930, 0x3b,
0x905, 0x3b, 0x91a, 0x3b, 0x92c, 0x3b, 0x92c, 0x3b, 0x92c, 0x3b, 0x91c, 0x3b, 0x92c, 0x3b, 0x436, 0x441, 0x3b, 0x434, 0x441, 0x3b,
0x441, 0x441, 0x3b, 0x441, 0x440, 0x3b, 0x431, 0x441, 0x3b, 0x436, 0x43c, 0x3b, 0x441, 0x431, 0x3b, 0x436, 0x435, 0x43a, 0x441, 0x435,
0x43d, 0x431, 0x456, 0x3b, 0x434, 0x4af, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x441, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431,
0x456, 0x3b, 0x441, 0x4d9, 0x440, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x431, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b,
0x436, 0x4b1, 0x43c, 0x430, 0x3b, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x416, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x421, 0x3b, 0x411,
0x3b, 0x416, 0x3b, 0x421, 0x3b, 0x17a2, 0x17b6, 0x1791, 0x17b7, 0x178f, 0x17d2, 0x1799, 0x3b, 0x1785, 0x1793, 0x17d2, 0x1791, 0x3b, 0x17a2, 0x1784,
0x17d2, 0x1782, 0x17b6, 0x179a, 0x3b, 0x1796, 0x17bb, 0x1792, 0x3b, 0x1796, 0x17d2, 0x179a, 0x17a0, 0x3b, 0x179f, 0x17bb, 0x1780, 0x17d2, 0x179a, 0x3b,
0x179f, 0x17c5, 0x179a, 0x17cd, 0x3b, 0x17a2, 0x17b6, 0x1791, 0x17b7, 0x178f, 0x17d2, 0x1799, 0x3b, 0x1785, 0x1793, 0x17d2, 0x1791, 0x3b, 0x17a2, 0x1784,
0x17d2, 0x1782, 0x17b6, 0x179a, 0x3b, 0x1796, 0x17bb, 0x1792, 0x3b, 0x1796, 0x17d2, 0x179a, 0x17a0, 0x179f, 0x17d2, 0x1794, 0x178f, 0x17b7, 0x17cd, 0x3b,
0x179f, 0x17bb, 0x1780, 0x17d2, 0x179a, 0x3b, 0x179f, 0x17c5, 0x179a, 0x17cd, 0x3b, 0x17a2, 0x3b, 0x1785, 0x3b, 0x17a2, 0x3b, 0x1796, 0x3b, 0x1796,
0x3b, 0x179f, 0x3b, 0x179f, 0x3b, 0x17a2, 0x17b6, 0x1791, 0x17b7, 0x178f, 0x17d2, 0x1799, 0x3b, 0x1785, 0x17d0, 0x1793, 0x17d2, 0x1791, 0x3b, 0x17a2,
0x1784, 0x17d2, 0x1782, 0x17b6, 0x179a, 0x3b, 0x1796, 0x17bb, 0x1792, 0x3b, 0x1796, 0x17d2, 0x179a, 0x17a0, 0x179f, 0x17d2, 0x1794, 0x178f, 0x17b7, 0x17cd,
0x3b, 0x179f, 0x17bb, 0x1780, 0x17d2, 0x179a, 0x3b, 0x179f, 0x17c5, 0x179a, 0x17cd, 0x3b, 0x4b, 0x4d, 0x41, 0x3b, 0x4e, 0x54, 0x54, 0x3b,
0x4e, 0x4d, 0x4e, 0x3b, 0x4e, 0x4d, 0x54, 0x3b, 0x41, 0x52, 0x54, 0x3b, 0x4e, 0x4d, 0x41, 0x3b, 0x4e, 0x4d, 0x4d, 0x3b,
0x4b, 0x69, 0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4e, 0x6a, 0x75,
0x6d, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x61, 0x3b, 0x41, 0x72, 0x61, 0x6d,
0x69, 0x74, 0x68, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x74,
0x68, 0x69, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x63, 0x79, 0x75,
0x2e, 0x3b, 0x6d, 0x62, 0x65, 0x2e, 0x3b, 0x6b, 0x61, 0x62, 0x2e, 0x3b, 0x67, 0x74, 0x75, 0x2e, 0x3b, 0x6b, 0x61, 0x6e,
0x2e, 0x3b, 0x67, 0x6e, 0x75, 0x2e, 0x3b, 0x67, 0x6e, 0x64, 0x2e, 0x3b, 0x4b, 0x75, 0x20, 0x63, 0x79, 0x75, 0x6d, 0x77,
0x65, 0x72, 0x75, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x72, 0x65, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20,
0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4b,
0x75, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x65, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x75,
0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x75, 0x3b, 0x906, 0x92f, 0x924, 0x93e,
0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x933, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e,
0x930, 0x3b, 0x92c, 0x93f, 0x930, 0x947, 0x938, 0x94d, 0x924, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x93e, 0x930, 0x3b,
0x936, 0x947, 0x928, 0x935, 0x93e, 0x930, 0x3b, 0x906, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b, 0x92c, 0x3b,
0x936, 0x941, 0x3b, 0x936, 0x947, 0x3b, 0x906, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b, 0x92c, 0x93f, 0x3b,
0x936, 0x941, 0x3b, 0x936, 0x947, 0x3b, 0xc77c, 0x3b, 0xc6d4, 0x3b, 0xd654, 0x3b, 0xc218, 0x3b, 0xbaa9, 0x3b, 0xae08, 0x3b, 0xd1a0, 0x3b,
0xc77c, 0xc694, 0xc77c, 0x3b, 0xc6d4, 0xc694, 0xc77c, 0x3b, 0xd654, 0xc694, 0xc77c, 0x3b, 0xc218, 0xc694, 0xc77c, 0x3b, 0xbaa9, 0xc694, 0xc77c, 0x3b,
0xae08, 0xc694, 0xc77c, 0x3b, 0xd1a0, 0xc694, 0xc77c, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x41, 0x74, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x3b,
0x41, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x6d, 0x3b, 0x41, 0x6c, 0x6a, 0x3b, 0x41, 0x73, 0x73, 0x3b, 0x41, 0x6c, 0x68, 0x61,
0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61,
0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x61, 0x3b, 0x41, 0x6c, 0x6a, 0x75, 0x6d, 0x61,
0x3b, 0x41, 0x73, 0x73, 0x61, 0x62, 0x64, 0x75, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c,
0x3b, 0x53, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x41, 0x74, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41,
0x6c, 0x6d, 0x3b, 0x41, 0x6c, 0x7a, 0x3b, 0x41, 0x73, 0x69, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74,
0x69, 0x6e, 0x6e, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x6c, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61,
0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x61, 0x3b, 0x41, 0x6c, 0x7a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73,
0x69, 0x62, 0x74, 0x69, 0x3b, 0x79, 0x15f, 0x3b, 0x64, 0x15f, 0x3b, 0x73, 0x15f, 0x3b, 0xe7, 0x15f, 0x3b, 0x70, 0x15f, 0x3b,
0xee, 0x6e, 0x3b, 0x15f, 0x3b, 0x79, 0x65, 0x6b, 0x15f, 0x65, 0x6d, 0x3b, 0x64, 0x75, 0x15f, 0x65, 0x6d, 0x3b, 0x73, 0xea,
0x15f, 0x65, 0x6d, 0x3b, 0xe7, 0x61, 0x72, 0x15f, 0x65, 0x6d, 0x3b, 0x70, 0xea, 0x6e, 0x63, 0x15f, 0x65, 0x6d, 0x3b, 0xee,
0x6e, 0x3b, 0x15f, 0x65, 0x6d, 0xee, 0x3b, 0x59, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0xc7, 0x3b, 0x50, 0x3b, 0xce, 0x3b, 0x15e,
0x3b, 0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x3b, 0x73, 0x6d, 0x62, 0x3b, 0x73, 0x6d, 0x6c, 0x3b, 0x73,
0x6d, 0x6e, 0x3b, 0x6d, 0x62, 0x73, 0x3b, 0x73, 0x61, 0x73, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x3b, 0x6d, 0x254,
0x301, 0x6e, 0x64, 0x254, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x62,
0x61, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x6c, 0x61, 0x6c, 0x3b,
0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x6e, 0x61, 0x3b, 0x6d, 0x61, 0x62,
0xe1, 0x67, 0xe1, 0x20, 0x6d, 0xe1, 0x20, 0x73, 0x75, 0x6b, 0x75, 0x6c, 0x3b, 0x73, 0xe1, 0x73, 0x61, 0x64, 0x69, 0x3b,
0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x436, 0x435, 0x43a, 0x2e, 0x3b, 0x434,
0x4af, 0x439, 0x2e, 0x3b, 0x448, 0x435, 0x439, 0x448, 0x2e, 0x3b, 0x448, 0x430, 0x440, 0x448, 0x2e, 0x3b, 0x431, 0x435, 0x439, 0x448,
0x2e, 0x3b, 0x436, 0x443, 0x43c, 0x430, 0x3b, 0x438, 0x448, 0x43c, 0x2e, 0x3b, 0x436, 0x435, 0x43a, 0x448, 0x435, 0x43c, 0x431, 0x438,
0x3b, 0x434, 0x4af, 0x439, 0x448, 0x4e9, 0x43c, 0x431, 0x4af, 0x3b, 0x448, 0x435, 0x439, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x448,
0x430, 0x440, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x431, 0x435, 0x439, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x436, 0x443, 0x43c,
0x430, 0x3b, 0x438, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x416, 0x3b, 0x414, 0x3b, 0x428, 0x3b, 0x428, 0x3b, 0x411, 0x3b, 0x416,
0x3b, 0x418, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x77, 0x61, 0x6b, 0x21f, 0x61, 0x14b, 0x3b, 0x41, 0x14b, 0x70, 0xe9,
0x74, 0x75, 0x77, 0x61, 0x14b, 0x17e, 0x69, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x6e, 0x75, 0x14b, 0x70, 0x61, 0x3b,
0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x79, 0x61, 0x6d, 0x6e, 0x69, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x74, 0x6f,
0x70, 0x61, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x7a, 0x61, 0x70, 0x74, 0x61, 0x14b, 0x3b, 0x4f, 0x77, 0xe1, 0x14b,
0x67, 0x79, 0x75, 0x17e, 0x61, 0x17e, 0x61, 0x70, 0x69, 0x3b, 0x41, 0x3b, 0x57, 0x3b, 0x4e, 0x3b, 0x59, 0x3b, 0x54, 0x3b,
0x5a, 0x3b, 0x4f, 0x3b, 0x50, 0xed, 0x69, 0x6c, 0x69, 0x3b, 0x54, 0xe1, 0x61, 0x74, 0x75, 0x3b, 0xcd, 0x6e, 0x65, 0x3b,
0x54, 0xe1, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x6d, 0x3b, 0x4d, 0xf3, 0x6f, 0x73, 0x69, 0x3b,
0x4a, 0x75, 0x6d, 0x61, 0x70, 0xed, 0x69, 0x72, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x74, 0x75, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0xed, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x61,
0x6d, 0xed, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0xe1, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0xf3, 0x6f,
0x73, 0x69, 0x3b, 0x50, 0x3b, 0x54, 0x3b, 0x45, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4d, 0x3b, 0xead, 0xeb2, 0xe97,
0xeb4, 0xe94, 0x3b, 0xe88, 0xeb1, 0xe99, 0x3b, 0xead, 0xeb1, 0xe87, 0xe84, 0xeb2, 0xe99, 0x3b, 0xe9e, 0xeb8, 0xe94, 0x3b, 0xe9e, 0xeb0,
0xeab, 0xeb1, 0xe94, 0x3b, 0xeaa, 0xeb8, 0xe81, 0x3b, 0xec0, 0xeaa, 0xebb, 0xeb2, 0x3b, 0xea7, 0xeb1, 0xe99, 0xead, 0xeb2, 0xe97, 0xeb4,
0xe94, 0x3b, 0xea7, 0xeb1, 0xe99, 0xe88, 0xeb1, 0xe99, 0x3b, 0xea7, 0xeb1, 0xe99, 0xead, 0xeb1, 0xe87, 0xe84, 0xeb2, 0xe99, 0x3b, 0xea7,
0xeb1, 0xe99, 0xe9e, 0xeb8, 0xe94, 0x3b, 0xea7, 0xeb1, 0xe99, 0xe9e, 0xeb0, 0xeab, 0xeb1, 0xe94, 0x3b, 0xea7, 0xeb1, 0xe99, 0xeaa, 0xeb8,
0xe81, 0x3b, 0xea7, 0xeb1, 0xe99, 0xec0, 0xeaa, 0xebb, 0xeb2, 0x3b, 0xead, 0xeb2, 0x3b, 0xe88, 0x3b, 0xead, 0x3b, 0xe9e, 0x3b, 0xe9e,
0xeab, 0x3b, 0xeaa, 0xeb8, 0x3b, 0xeaa, 0x3b, 0x53, 0x6f, 0x6c, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d,
0x65, 0x72, 0x3b, 0x49, 0x6f, 0x76, 0x3b, 0x56, 0x65, 0x6e, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x64, 0x69, 0x65, 0x73, 0x20,
0x53, 0x6f, 0x6c, 0x69, 0x73, 0x3b, 0x64, 0x69, 0x65, 0x73, 0x20, 0x4c, 0x75, 0x6e, 0x61, 0x65, 0x3b, 0x64, 0x69, 0x65,
0x73, 0x20, 0x4d, 0x61, 0x72, 0x74, 0x69, 0x73, 0x3b, 0x64, 0x69, 0x65, 0x73, 0x20, 0x4d, 0x65, 0x72, 0x63, 0x75, 0x72,
0x69, 0x69, 0x3b, 0x64, 0x69, 0x65, 0x73, 0x20, 0x49, 0x6f, 0x76, 0x69, 0x73, 0x3b, 0x64, 0x69, 0x65, 0x73, 0x20, 0x56,
0x65, 0x6e, 0x65, 0x72, 0x69, 0x73, 0x3b, 0x64, 0x69, 0x65, 0x73, 0x20, 0x53, 0x61, 0x74, 0x75, 0x72, 0x6e, 0x69, 0x3b,
0x53, 0x76, 0x113, 0x74, 0x64, 0x2e, 0x3b, 0x50, 0x69, 0x72, 0x6d, 0x64, 0x2e, 0x3b, 0x4f, 0x74, 0x72, 0x64, 0x2e, 0x3b,
0x54, 0x72, 0x65, 0x161, 0x64, 0x2e, 0x3b, 0x43, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64, 0x2e, 0x3b, 0x50, 0x69, 0x65, 0x6b,
0x74, 0x64, 0x2e, 0x3b, 0x53, 0x65, 0x73, 0x74, 0x64, 0x2e, 0x3b, 0x53, 0x76, 0x113, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61,
0x3b, 0x50, 0x69, 0x72, 0x6d, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x4f, 0x74, 0x72, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b,
0x54, 0x72, 0x65, 0x161, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x43, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64, 0x69, 0x65, 0x6e,
0x61, 0x3b, 0x50, 0x69, 0x65, 0x6b, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x53, 0x65, 0x73, 0x74, 0x64, 0x69, 0x65,
0x6e, 0x61, 0x3b, 0x53, 0x3b, 0x50, 0x3b, 0x4f, 0x3b, 0x54, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x73, 0x76, 0x113,
0x74, 0x64, 0x2e, 0x3b, 0x70, 0x69, 0x72, 0x6d, 0x64, 0x2e, 0x3b, 0x6f, 0x74, 0x72, 0x64, 0x2e, 0x3b, 0x74, 0x72, 0x65,
0x161, 0x64, 0x2e, 0x3b, 0x63, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64, 0x2e, 0x3b, 0x70, 0x69, 0x65, 0x6b, 0x74, 0x64, 0x2e,
0x3b, 0x73, 0x65, 0x73, 0x74, 0x64, 0x2e, 0x3b, 0x73, 0x76, 0x113, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x70, 0x69,
0x72, 0x6d, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x6f, 0x74, 0x72, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x74, 0x72, 0x65,
0x161, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x63, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x70,
0x69, 0x65, 0x6b, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x73, 0x65, 0x73, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b,
0x64, 0x6f, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0xe4, 0x74, 0x2e, 0x3b, 0x6d, 0xe4, 0x63, 0x2e, 0x3b,
0x7a, 0x65, 0x75, 0x2e, 0x3b, 0x76, 0x65, 0x6e, 0x2e, 0x3b, 0x73, 0x61, 0x62, 0x2e, 0x3b, 0x64, 0x6f, 0x6d, 0x65, 0x6e,
0x65, 0x67, 0x61, 0x3b, 0x6c, 0x75, 0x6e, 0x65, 0x73, 0x64, 0xec, 0x3b, 0x6d, 0xe4, 0x74, 0x65, 0x73, 0x64, 0xec, 0x3b,
0x6d, 0xe4, 0x63, 0x6f, 0x72, 0x64, 0xec, 0x3b, 0x7a, 0x65, 0x75, 0x67, 0x67, 0x69, 0x61, 0x3b, 0x76, 0x65, 0x6e, 0x61,
0x72, 0x64, 0xec, 0x3b, 0x73, 0x61, 0x62, 0x62, 0x6f, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b,
0x56, 0x3b, 0x53, 0x3b, 0x65, 0x79, 0x65, 0x3b, 0x79, 0x62, 0x6f, 0x3b, 0x6d, 0x62, 0x6c, 0x3b, 0x6d, 0x73, 0x74, 0x3b,
0x6d, 0x69, 0x6e, 0x3b, 0x6d, 0x74, 0x6e, 0x3b, 0x6d, 0x70, 0x73, 0x3b, 0x65, 0x79, 0x65, 0x6e, 0x67, 0x61, 0x3b, 0x6d,
0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x6d, 0x77, 0x61, 0x20, 0x79, 0x61, 0x6d, 0x62, 0x6f, 0x3b, 0x6d, 0x6f, 0x6b, 0x254,
0x6c, 0x254, 0x20, 0x6d, 0x77, 0x61, 0x20, 0x6d, 0xed, 0x62, 0x61, 0x6c, 0xe9, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254,
0x20, 0x6d, 0x77, 0x61, 0x20, 0x6d, 0xed, 0x73, 0xe1, 0x74, 0x6f, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x79,
0x61, 0x20, 0x6d, 0xed, 0x6e, 0xe9, 0x69, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed,
0x74, 0xe1, 0x6e, 0x6f, 0x3b, 0x6d, 0x70, 0x254, 0x301, 0x73, 0x254, 0x3b, 0x65, 0x3b, 0x79, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b,
0x6d, 0x3b, 0x6d, 0x3b, 0x70, 0x3b, 0x73, 0x6b, 0x3b, 0x70, 0x72, 0x3b, 0x61, 0x6e, 0x3b, 0x74, 0x72, 0x3b, 0x6b, 0x74,
0x3b, 0x70, 0x6e, 0x3b, 0x161, 0x74, 0x3b, 0x73, 0x65, 0x6b, 0x6d, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x70,
0x69, 0x72, 0x6d, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x61, 0x6e, 0x74, 0x72, 0x61, 0x64, 0x69, 0x65, 0x6e,
0x69, 0x73, 0x3b, 0x74, 0x72, 0x65, 0x10d, 0x69, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x6b, 0x65, 0x74, 0x76,
0x69, 0x72, 0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x70, 0x65, 0x6e, 0x6b, 0x74, 0x61, 0x64, 0x69, 0x65,
0x6e, 0x69, 0x73, 0x3b, 0x161, 0x65, 0x161, 0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x53, 0x3b, 0x50, 0x3b,
0x41, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x160, 0x3b, 0x53, 0xfc, 0x2e, 0x3b, 0x4d, 0x61, 0x2e, 0x3b, 0x44, 0x69,
0x2e, 0x3b, 0x4d, 0x69, 0x2e, 0x3b, 0x44, 0x75, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x53, 0xfc,
0x6e, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x4d, 0x61, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x44, 0x69, 0x6e, 0x67, 0x73, 0x64,
0x61, 0x67, 0x3b, 0x4d, 0x69, 0x64, 0x64, 0x65, 0x77, 0x65, 0x6b, 0x65, 0x6e, 0x3b, 0x44, 0x75, 0x6e, 0x6e, 0x65, 0x72,
0x73, 0x64, 0x61, 0x67, 0x3b, 0x46, 0x72, 0x65, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x53, 0xfc, 0x6e, 0x6e, 0x61, 0x76, 0x65,
0x6e, 0x64, 0x3b, 0x6e, 0x6a, 0x65, 0x3b, 0x70, 0xf3, 0x6e, 0x3b, 0x77, 0x61, 0x142, 0x3b, 0x73, 0x72, 0x6a, 0x3b, 0x73,
0x74, 0x77, 0x3b, 0x70, 0x11b, 0x74, 0x3b, 0x73, 0x6f, 0x62, 0x3b, 0x6e, 0x6a, 0x65, 0x17a, 0x65, 0x6c, 0x61, 0x3b, 0x70,
0xf3, 0x6e, 0x6a, 0x65, 0x17a, 0x65, 0x6c, 0x65, 0x3b, 0x77, 0x61, 0x142, 0x74, 0x6f, 0x72, 0x61, 0x3b, 0x73, 0x72, 0x6a,
0x6f, 0x64, 0x61, 0x3b, 0x73, 0x74, 0x77, 0xf3, 0x72, 0x74, 0x6b, 0x3b, 0x70, 0x11b, 0x74, 0x6b, 0x3b, 0x73, 0x6f, 0x62,
0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x77, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x4c, 0x75,
0x6d, 0x3b, 0x4e, 0x6b, 0x6f, 0x3b, 0x4e, 0x64, 0x79, 0x3b, 0x4e, 0x64, 0x67, 0x3b, 0x4e, 0x6a, 0x77, 0x3b, 0x4e, 0x67,
0x76, 0x3b, 0x4c, 0x75, 0x62, 0x3b, 0x4c, 0x75, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x4e, 0x6b, 0x6f, 0x64, 0x79, 0x61,
0x3b, 0x4e, 0x64, 0xe0, 0x61, 0x79, 0xe0, 0x3b, 0x4e, 0x64, 0x61, 0x6e, 0x67, 0xf9, 0x3b, 0x4e, 0x6a, 0xf2, 0x77, 0x61,
0x3b, 0x4e, 0x67, 0xf2, 0x76, 0x79, 0x61, 0x3b, 0x4c, 0x75, 0x62, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x4c, 0x3b, 0x4e, 0x3b,
0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4c, 0x3b, 0x4a, 0x4d, 0x50, 0x3b, 0x57, 0x55, 0x54, 0x3b, 0x54, 0x41,
0x52, 0x3b, 0x54, 0x41, 0x44, 0x3b, 0x54, 0x41, 0x4e, 0x3b, 0x54, 0x41, 0x42, 0x3b, 0x4e, 0x47, 0x53, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x70, 0x69, 0x6c, 0x3b, 0x57, 0x75, 0x6f, 0x6b, 0x20, 0x54, 0x69, 0x63, 0x68, 0x3b, 0x54, 0x69, 0x63, 0x68,
0x20, 0x41, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20, 0x41, 0x64, 0x65, 0x6b, 0x3b, 0x54, 0x69, 0x63,
0x68, 0x20, 0x41, 0x6e, 0x67, 0x2019, 0x77, 0x65, 0x6e, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20, 0x41, 0x62, 0x69, 0x63, 0x68,
0x3b, 0x4e, 0x67, 0x65, 0x73, 0x6f, 0x3b, 0x4a, 0x3b, 0x57, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4e,
0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0xe9, 0x69, 0x3b, 0x44, 0xeb, 0x6e, 0x3b, 0x4d, 0xeb, 0x74, 0x3b, 0x44, 0x6f, 0x6e,
0x3b, 0x46, 0x72, 0x65, 0x3b, 0x53, 0x61, 0x6d, 0x3b, 0x53, 0x6f, 0x6e, 0x6e, 0x64, 0x65, 0x67, 0x3b, 0x4d, 0xe9, 0x69,
0x6e, 0x64, 0x65, 0x67, 0x3b, 0x44, 0xeb, 0x6e, 0x73, 0x63, 0x68, 0x64, 0x65, 0x67, 0x3b, 0x4d, 0xeb, 0x74, 0x74, 0x77,
0x6f, 0x63, 0x68, 0x3b, 0x44, 0x6f, 0x6e, 0x6e, 0x65, 0x73, 0x63, 0x68, 0x64, 0x65, 0x67, 0x3b, 0x46, 0x72, 0x65, 0x69,
0x64, 0x65, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x63, 0x68, 0x64, 0x65, 0x67, 0x3b, 0x53, 0x6f, 0x6e, 0x2e, 0x3b, 0x4d,
0xe9, 0x69, 0x2e, 0x3b, 0x44, 0xeb, 0x6e, 0x2e, 0x3b, 0x4d, 0xeb, 0x74, 0x2e, 0x3b, 0x44, 0x6f, 0x6e, 0x2e, 0x3b, 0x46,
0x72, 0x65, 0x2e, 0x3b, 0x53, 0x61, 0x6d, 0x2e, 0x3b, 0x4a, 0x32, 0x3b, 0x4a, 0x33, 0x3b, 0x4a, 0x34, 0x3b, 0x4a, 0x35,
0x3b, 0x41, 0x6c, 0x3b, 0x49, 0x6a, 0x3b, 0x4a, 0x31, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x75, 0x72, 0x77, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x61, 0x6e, 0x6e, 0x65, 0x3b,
0x4d, 0x75, 0x72, 0x77, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x43d, 0x435, 0x434, 0x2e, 0x3b, 0x43f, 0x43e, 0x43d, 0x2e, 0x3b, 0x432, 0x442, 0x43e, 0x2e, 0x3b,
0x441, 0x440, 0x435, 0x2e, 0x3b, 0x447, 0x435, 0x442, 0x2e, 0x3b, 0x43f, 0x435, 0x442, 0x2e, 0x3b, 0x441, 0x430, 0x431, 0x2e, 0x3b,
0x43d, 0x435, 0x434, 0x435, 0x43b, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x43d, 0x438, 0x43a, 0x3b, 0x432, 0x442,
0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x441, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x43e, 0x43a,
0x3b, 0x43f, 0x435, 0x442, 0x43e, 0x43a, 0x3b, 0x441, 0x430, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x4a, 0x70, 0x69, 0x3b, 0x4a, 0x74,
0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d,
0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75,
0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x41,
0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d,
0x6f, 0x73, 0x69, 0x3b, 0x930, 0x935, 0x93f, 0x20, 0x926, 0x93f, 0x928, 0x3b, 0x938, 0x94b, 0x92e, 0x20, 0x926, 0x93f, 0x928, 0x3b,
0x92e, 0x902, 0x917, 0x932, 0x20, 0x926, 0x93f, 0x928, 0x3b, 0x92c, 0x941, 0x927, 0x20, 0x926, 0x93f, 0x928, 0x3b, 0x92c, 0x943, 0x939,
0x938, 0x94d, 0x92a, 0x924, 0x93f, 0x20, 0x926, 0x93f, 0x928, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x20, 0x926, 0x93f, 0x928, 0x3b,
0x936, 0x928, 0x93f, 0x20, 0x926, 0x93f, 0x928, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b,
0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x72, 0x61, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x53, 0x61, 0x62, 0x61,
0x74, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b,
0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49,
0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x53, 0x3b, 0x4a, 0x3b, 0x4a,
0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x3b, 0x4c, 0x6c, 0x32, 0x3b, 0x4c, 0x6c, 0x33, 0x3b, 0x4c, 0x6c, 0x34,
0x3b, 0x4c, 0x6c, 0x35, 0x3b, 0x4c, 0x6c, 0x36, 0x3b, 0x4c, 0x6c, 0x37, 0x3b, 0x4c, 0x6c, 0x31, 0x3b, 0x4c, 0x69, 0x64,
0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x70, 0x69, 0x6c, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c,
0x79, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x63, 0x68,
0x65, 0x63, 0x68, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e, 0x79, 0x61, 0x6e,
0x6f, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e,
0x61, 0x20, 0x6c, 0x69, 0x6e, 0x6a, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e,
0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76,
0x61, 0x20, 0x6c, 0x69, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b,
0x37, 0x3b, 0x31, 0x3b, 0x41, 0x6c, 0x61, 0x68, 0x3b, 0x41, 0x6c, 0x61, 0x74, 0x73, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x41,
0x6c, 0x61, 0x72, 0x3b, 0x41, 0x6c, 0x61, 0x6b, 0x3b, 0x5a, 0x6f, 0x6d, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x3b, 0x41, 0x6c,
0x61, 0x68, 0x61, 0x64, 0x79, 0x3b, 0x41, 0x6c, 0x61, 0x74, 0x73, 0x69, 0x6e, 0x61, 0x69, 0x6e, 0x79, 0x3b, 0x54, 0x61,
0x6c, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x6f, 0x62, 0x69, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x6b, 0x61, 0x6d,
0x69, 0x73, 0x79, 0x3b, 0x5a, 0x6f, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x6f, 0x74, 0x73, 0x79, 0x3b, 0x41, 0x3b,
0x41, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x5a, 0x3b, 0x41, 0x3b, 0x41, 0x68, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x3b,
0x53, 0x65, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x3b, 0x4b, 0x68, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x3b,
0x41, 0x68, 0x61, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x61, 0x73, 0x61, 0x3b, 0x52, 0x61,
0x62, 0x75, 0x3b, 0x4b, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x74, 0x3b, 0x53, 0x61, 0x62,
0x74, 0x75, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x627, 0x62d, 0x62f,
0x3b, 0x627, 0x62b, 0x646, 0x64a, 0x646, 0x3b, 0x62b, 0x644, 0x627, 0x62b, 0x3b, 0x631, 0x627, 0x628, 0x648, 0x3b, 0x62e, 0x645, 0x64a,
0x633, 0x3b, 0x62c, 0x645, 0x639, 0x629, 0x3b, 0x633, 0x628, 0x62a, 0x648, 0x3b, 0xd1e, 0xd3e, 0xd2f, 0xd7c, 0x3b, 0xd24, 0xd3f, 0xd19,
0xd4d, 0xd15, 0xd7e, 0x3b, 0xd1a, 0xd4a, 0xd35, 0xd4d, 0xd35, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd7b, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0xd34,
0xd02, 0x3b, 0xd35, 0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f, 0x3b, 0xd36, 0xd28, 0xd3f, 0x3b, 0xd1e, 0xd3e, 0xd2f, 0xd31, 0xd3e, 0xd34, 0xd4d,
0x200c, 0xd1a, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd33, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd1a, 0xd4a, 0xd35, 0xd4d, 0xd35,
0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd28, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e,
0xd34, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b,
0xd36, 0xd28, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd1e, 0xd3e, 0x3b, 0xd24, 0xd3f, 0x3b, 0xd1a, 0xd4a, 0x3b, 0xd2c,
0xd41, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0x3b, 0xd35, 0xd46, 0x3b, 0xd36, 0x3b, 0xd1e, 0xd3e, 0xd2f, 0xd31, 0xd3e, 0xd34, 0xd4d, 0x200c,
0xd1a, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd33, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd1a, 0xd4a, 0xd35, 0xd4d, 0xd35, 0xd3e,
0xd34, 0xd4d, 0xd1a, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd28, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0xd34, 0xd3e,
0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd36, 0xd28,
0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd1e, 0x3b, 0xd24, 0xd3f, 0x3b, 0xd1a, 0xd4a, 0x3b, 0xd2c, 0xd41, 0x3b, 0xd35,
0xd4d, 0xd2f, 0xd3e, 0x3b, 0xd35, 0xd46, 0x3b, 0xd36, 0x3b, 0x126, 0x61, 0x64, 0x3b, 0x54, 0x6e, 0x65, 0x3b, 0x54, 0x6c, 0x69,
0x3b, 0x45, 0x72, 0x62, 0x3b, 0x126, 0x61, 0x6d, 0x3b, 0x120, 0x69, 0x6d, 0x3b, 0x53, 0x69, 0x62, 0x3b, 0x49, 0x6c, 0x2d,
0x126, 0x61, 0x64, 0x64, 0x3b, 0x49, 0x74, 0x2d, 0x54, 0x6e, 0x65, 0x6a, 0x6e, 0x3b, 0x49, 0x74, 0x2d, 0x54, 0x6c, 0x69,
0x65, 0x74, 0x61, 0x3b, 0x4c, 0x2d, 0x45, 0x72, 0x62, 0x67, 0x127, 0x61, 0x3b, 0x49, 0x6c, 0x2d, 0x126, 0x61, 0x6d, 0x69,
0x73, 0x3b, 0x49, 0x6c, 0x2d, 0x120, 0x69, 0x6d, 0x67, 0x127, 0x61, 0x3b, 0x49, 0x73, 0x2d, 0x53, 0x69, 0x62, 0x74, 0x3b,
0x126, 0x64, 0x3b, 0x54, 0x6e, 0x3b, 0x54, 0x6c, 0x3b, 0x45, 0x72, 0x3b, 0x126, 0x6d, 0x3b, 0x120, 0x6d, 0x3b, 0x53, 0x62,
0x3b, 0x126, 0x64, 0x3b, 0x54, 0x3b, 0x54, 0x6c, 0x3b, 0x45, 0x72, 0x3b, 0x126, 0x6d, 0x3b, 0x120, 0x6d, 0x3b, 0x53, 0x62,
0x3b, 0x9a8, 0x9cb, 0x982, 0x9ae, 0x9be, 0x987, 0x99c, 0x9bf, 0x982, 0x3b, 0x9a8, 0x9bf, 0x982, 0x9a5, 0x9cc, 0x995, 0x9be, 0x9ac, 0x9be,
0x3b, 0x9b2, 0x9c8, 0x9ac, 0x9be, 0x995, 0x9aa, 0x9cb, 0x995, 0x9aa, 0x9be, 0x3b, 0x9af, 0x9bc, 0x9c1, 0x9ae, 0x9b6, 0x995, 0x9c8, 0x9b6,
0x9be, 0x3b, 0x9b6, 0x997, 0x9cb, 0x9b2, 0x9b6, 0x9c7, 0x9a8, 0x3b, 0x987, 0x9b0, 0x9be, 0x987, 0x3b, 0x9a5, 0x9be, 0x982, 0x99c, 0x3b,
0x9a8, 0x9cb, 0x3b, 0x9a8, 0x9bf, 0x982, 0x3b, 0x9b2, 0x9c8, 0x3b, 0x9af, 0x9bc, 0x9c1, 0x9ae, 0x3b, 0x9b6, 0x997, 0x3b, 0x987, 0x9b0,
0x9be, 0x3b, 0x9a5, 0x9be, 0x982, 0x3b, 0x9a8, 0x9cb, 0x982, 0x3b, 0x9a8, 0x9bf, 0x982, 0x3b, 0x9b2, 0x9c8, 0x9ac, 0x9be, 0x3b, 0x9af,
0x9bc, 0x9c1, 0x9ae, 0x3b, 0x9b6, 0x997, 0x9cb, 0x3b, 0x987, 0x9b0, 0x9be, 0x3b, 0x9a5, 0x9be, 0x982, 0x3b, 0x4a, 0x65, 0x64, 0x3b,
0x4a, 0x65, 0x6c, 0x3b, 0x4a, 0x65, 0x6d, 0x3b, 0x4a, 0x65, 0x72, 0x63, 0x3b, 0x4a, 0x65, 0x72, 0x64, 0x3b, 0x4a, 0x65,
0x68, 0x3b, 0x4a, 0x65, 0x73, 0x3b, 0x4a, 0x65, 0x64, 0x6f, 0x6f, 0x6e, 0x65, 0x65, 0x3b, 0x4a, 0x65, 0x6c, 0x68, 0x65,
0x69, 0x6e, 0x3b, 0x4a, 0x65, 0x6d, 0x61, 0x79, 0x72, 0x74, 0x3b, 0x4a, 0x65, 0x72, 0x63, 0x65, 0x61, 0x6e, 0x3b, 0x4a,
0x65, 0x72, 0x64, 0x65, 0x69, 0x6e, 0x3b, 0x4a, 0x65, 0x68, 0x65, 0x69, 0x6e, 0x65, 0x79, 0x3b, 0x4a, 0x65, 0x73, 0x61,
0x72, 0x6e, 0x3b, 0x52, 0x101, 0x74, 0x3b, 0x4d, 0x61, 0x6e, 0x65, 0x3b, 0x54, 0x16b, 0x72, 0x3b, 0x57, 0x65, 0x6e, 0x65,
0x3b, 0x54, 0x101, 0x69, 0x74, 0x3b, 0x50, 0x61, 0x72, 0x3b, 0x52, 0x101, 0x68, 0x3b, 0x52, 0x101, 0x74, 0x61, 0x70, 0x75,
0x3b, 0x4d, 0x61, 0x6e, 0x65, 0x3b, 0x54, 0x16b, 0x72, 0x65, 0x69, 0x3b, 0x57, 0x65, 0x6e, 0x65, 0x72, 0x65, 0x69, 0x3b,
0x54, 0x101, 0x69, 0x74, 0x65, 0x3b, 0x50, 0x61, 0x72, 0x61, 0x69, 0x72, 0x65, 0x3b, 0x52, 0x101, 0x68, 0x6f, 0x72, 0x6f,
0x69, 0x3b, 0x52, 0x74, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x57, 0x3b, 0x54, 0x3b, 0x50, 0x3b, 0x52, 0x68, 0x3b, 0x52, 0x74,
0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x45, 0x3b, 0x54, 0x3b, 0x50, 0x3b, 0x52, 0x68, 0x3b, 0x930, 0x935, 0x93f, 0x3b, 0x938, 0x94b,
0x92e, 0x3b, 0x92e, 0x902, 0x917, 0x933, 0x3b, 0x92c, 0x941, 0x927, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x3b, 0x936, 0x941, 0x915, 0x94d,
0x930, 0x3b, 0x936, 0x928, 0x93f, 0x3b, 0x930, 0x935, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x935, 0x93e, 0x930, 0x3b,
0x92e, 0x902, 0x917, 0x933, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x935,
0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x70, 0xed, 0x6c, 0xed, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d,
0x61, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x6e, 0x254, 0x3b, 0x41, 0x6c, 0x61, 0xe1, 0x6d, 0x69, 0x73,
0x69, 0x3b, 0x4a, 0x75, 0x6d, 0xe1, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0xf3, 0x73, 0x69, 0x3b, 0x4b, 0x49, 0x55,
0x3b, 0x4d, 0x52, 0x41, 0x3b, 0x57, 0x41, 0x49, 0x3b, 0x57, 0x45, 0x54, 0x3b, 0x57, 0x45, 0x4e, 0x3b, 0x57, 0x54, 0x4e,
0x3b, 0x4a, 0x55, 0x4d, 0x3b, 0x4b, 0x69, 0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4d, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x6f,
0x3b, 0x57, 0x61, 0x69, 0x72, 0x69, 0x3b, 0x57, 0x65, 0x74, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x57, 0x65, 0x6e, 0x61, 0x3b,
0x57, 0x65, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b,
0x57, 0x3b, 0x57, 0x3b, 0x57, 0x3b, 0x57, 0x3b, 0x4a, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x31, 0x3b, 0x41, 0x6e, 0x65,
0x67, 0x20, 0x32, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x33, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x34, 0x3b, 0x41, 0x6e,
0x65, 0x67, 0x20, 0x35, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x36, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x37, 0x3b, 0x41,
0x31, 0x3b, 0x41, 0x32, 0x3b, 0x41, 0x33, 0x3b, 0x41, 0x34, 0x3b, 0x41, 0x35, 0x3b, 0x41, 0x36, 0x3b, 0x41, 0x37, 0x3b,
0x41d, 0x44f, 0x3b, 0x414, 0x430, 0x3b, 0x41c, 0x44f, 0x3b, 0x41b, 0x445, 0x3b, 0x41f, 0x4af, 0x3b, 0x411, 0x430, 0x3b, 0x411, 0x44f,
0x3b, 0x41d, 0x44f, 0x43c, 0x3b, 0x414, 0x430, 0x432, 0x430, 0x430, 0x3b, 0x41c, 0x44f, 0x433, 0x43c, 0x430, 0x440, 0x3b, 0x41b, 0x445,
0x430, 0x433, 0x432, 0x430, 0x3b, 0x41f, 0x4af, 0x440, 0x44d, 0x432, 0x3b, 0x411, 0x430, 0x430, 0x441, 0x430, 0x43d, 0x3b, 0x411, 0x44f,
0x43c, 0x431, 0x430, 0x3b, 0x43d, 0x44f, 0x43c, 0x3b, 0x434, 0x430, 0x432, 0x430, 0x430, 0x3b, 0x43c, 0x44f, 0x433, 0x43c, 0x430, 0x440,
0x3b, 0x43b, 0x445, 0x430, 0x433, 0x432, 0x430, 0x3b, 0x43f, 0x4af, 0x440, 0x44d, 0x432, 0x3b, 0x431, 0x430, 0x430, 0x441, 0x430, 0x43d,
0x3b, 0x431, 0x44f, 0x43c, 0x431, 0x430, 0x3b, 0x1828, 0x1822, 0x3b, 0x1833, 0x1820, 0x3b, 0x182e, 0x1822, 0x182d, 0x3b, 0x1840, 0x1820, 0x3b,
0x182b, 0x1826, 0x1837, 0x3b, 0x182a, 0x1820, 0x3b, 0x182a, 0x1822, 0x182e, 0x3b, 0x1828, 0x1822, 0x182e, 0x180e, 0x1820, 0x3b, 0x1833, 0x1820, 0x1838,
0x1820, 0x3b, 0x182e, 0x1822, 0x1820, 0x1820, 0x182e, 0x1820, 0x1837, 0x3b, 0x1840, 0x1820, 0x182d, 0x182a, 0x1820, 0x3b, 0x182b, 0x1826, 0x1837, 0x182a,
0x1826, 0x3b, 0x182a, 0x1820, 0x1830, 0x1820, 0x1829, 0x3b, 0x182a, 0x1822, 0x182e, 0x182a, 0x1820, 0x3b, 0x1828, 0x1822, 0x3b, 0x1833, 0x1820, 0x3b,
0x182e, 0x1822, 0x182d, 0x3b, 0x1840, 0x1820, 0x3b, 0x182b, 0x1825, 0x1837, 0x3b, 0x182a, 0x1820, 0x3b, 0x182a, 0x1822, 0x182e, 0x3b, 0x1828, 0x1822,
0x3b, 0x1832, 0x1820, 0x3b, 0x182e, 0x1822, 0x182d, 0x3b, 0x1840, 0x1820, 0x3b, 0x182b, 0x1825, 0x1837, 0x3b, 0x182a, 0x1820, 0x3b, 0x182a, 0x1822,
0x182e, 0x3b, 0x1828, 0x1822, 0x3b, 0x1833, 0x1820, 0x3b, 0x182e, 0x1822, 0x182d, 0x3b, 0x1840, 0x1820, 0x3b, 0x182b, 0x1825, 0x1837, 0x3b, 0x182a,
0x1820, 0x3b, 0x182a, 0x1822, 0x3b, 0x64, 0x69, 0x6d, 0x3b, 0x6c, 0x69, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x72,
0x3b, 0x7a, 0x65, 0x3b, 0x76, 0x61, 0x6e, 0x3b, 0x73, 0x61, 0x6d, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x6e, 0x73, 0x3b, 0x6c,
0x69, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x65, 0x72, 0x6b, 0x72, 0x65, 0x64, 0x69, 0x3b,
0x7a, 0x65, 0x64, 0x69, 0x3b, 0x76, 0x61, 0x6e, 0x64, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x73, 0x61, 0x6d, 0x64, 0x69, 0x3b,
0x64, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x7a, 0x3b, 0x76, 0x3b, 0x73, 0x3b, 0x43, 0x79, 0x61, 0x3b, 0x43, 0x6c,
0x61, 0x3b, 0x43, 0x7a, 0x69, 0x3b, 0x43, 0x6b, 0x6f, 0x3b, 0x43, 0x6b, 0x61, 0x3b, 0x43, 0x67, 0x61, 0x3b, 0x43, 0x7a,
0x65, 0x3b, 0x43, 0x6f, 0x6d, 0x2019, 0x79, 0x61, 0x6b, 0x6b, 0x65, 0x3b, 0x43, 0x6f, 0x6d, 0x6c, 0x61, 0x61, 0x257, 0x69,
0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x7a, 0x79, 0x69, 0x69, 0x257, 0x69, 0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x6b, 0x6f, 0x6c, 0x6c,
0x65, 0x3b, 0x43, 0x6f, 0x6d, 0x6b, 0x61, 0x6c, 0x64, 0x1dd, 0x253, 0x6c, 0x69, 0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x67, 0x61,
0x69, 0x73, 0x75, 0x75, 0x3b, 0x43, 0x6f, 0x6d, 0x7a, 0x79, 0x65, 0x253, 0x73, 0x75, 0x75, 0x3b, 0x59, 0x3b, 0x4c, 0x3b,
0x5a, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x47, 0x3b, 0x45, 0x3b, 0x4e, 0x65, 0x74, 0x74, 0x76, 0x20, 0x43, 0x61, 0x6b, 0x6f,
0x3b, 0x45, 0x6e, 0x68, 0x76, 0x74, 0x65, 0x63, 0x65, 0x73, 0x6b, 0x76, 0x3b, 0x45, 0x6e, 0x68, 0x76, 0x74, 0x65, 0x63,
0x65, 0x73, 0x6b, 0x76, 0x20, 0x45, 0x6e, 0x68, 0x76, 0x79, 0x76, 0x74, 0x6b, 0x65, 0x3b, 0x45, 0x6e, 0x6e, 0x76, 0x72,
0x6b, 0x76, 0x70, 0x76, 0x3b, 0x45, 0x6e, 0x6e, 0x76, 0x72, 0x6b, 0x76, 0x70, 0x76, 0x20, 0x45, 0x6e, 0x68, 0x76, 0x79,
0x76, 0x74, 0x6b, 0x65, 0x3b, 0x4e, 0x61, 0x6b, 0x20, 0x4f, 0x6b, 0x6b, 0x6f, 0x73, 0x6b, 0x76, 0x20, 0x4e, 0x65, 0x74,
0x74, 0x76, 0x3b, 0x4e, 0x65, 0x74, 0x74, 0x76, 0x20, 0x43, 0x61, 0x6b, 0x63, 0x75, 0x73, 0x65, 0x3b, 0x53, 0x6f, 0x6e,
0x3b, 0x4d, 0x61, 0x3b, 0x44, 0x65, 0x3b, 0x57, 0x75, 0x3b, 0x44, 0x6f, 0x3b, 0x46, 0x72, 0x3b, 0x53, 0x61, 0x74, 0x3b,
0x53, 0x6f, 0x6e, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x6e, 0x74, 0x61, 0x78, 0x74, 0x73,
0x65, 0x65, 0x73, 0x3b, 0x44, 0x65, 0x6e, 0x73, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x57, 0x75, 0x6e,
0x73, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x44, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x74, 0x61, 0x78, 0x74,
0x73, 0x65, 0x65, 0x73, 0x3b, 0x46, 0x72, 0x61, 0x69, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x53, 0x61,
0x74, 0x65, 0x72, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x57, 0x3b,
0x44, 0x3b, 0x46, 0x3b, 0x41, 0x3b, 0x906, 0x907, 0x924, 0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e, 0x919, 0x94d, 0x917, 0x932, 0x3b,
0x92c, 0x941, 0x927, 0x3b, 0x92c, 0x93f, 0x939, 0x93f, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x3b, 0x906,
0x907, 0x924, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x919, 0x94d, 0x917, 0x932, 0x92c, 0x93e,
0x930, 0x3b, 0x92c, 0x941, 0x927, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x93f, 0x939, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915,
0x94d, 0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x906, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x3b,
0x92c, 0x941, 0x3b, 0x92c, 0x93f, 0x3b, 0x936, 0x941, 0x3b, 0x936, 0x3b, 0x6c, 0x79, 0x25b, 0x2bc, 0x25b, 0x301, 0x20, 0x73, 0x1e85,
0xed, 0x14b, 0x74, 0xe8, 0x3b, 0x6d, 0x76, 0x66, 0xf2, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0x62, 0x254, 0x301,
0x254, 0x6e, 0x74, 0xe8, 0x20, 0x6d, 0x76, 0x66, 0xf2, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x74, 0x73, 0xe8, 0x74,
0x73, 0x25b, 0x300, 0x25b, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0x62, 0x254, 0x301, 0x254, 0x6e, 0x74, 0xe8, 0x20,
0x74, 0x73, 0x65, 0x74, 0x73, 0x25b, 0x300, 0x25b, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0x76, 0x66, 0xf2, 0x20,
0x6d, 0xe0, 0x67, 0x61, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0xe0, 0x67, 0x61, 0x20, 0x6c, 0x79, 0x25b, 0x30c,
0x2bc, 0x3b, 0x53, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0x4d, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0xc1, 0x70, 0x74, 0x61,
0x20, 0x4d, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0x57, 0x25b, 0x301, 0x6e, 0x25b, 0x73, 0x25b, 0x64, 0x25b, 0x3b, 0x54, 0x254,
0x301, 0x73, 0x25b, 0x64, 0x25b, 0x3b, 0x46, 0x25b, 0x6c, 0xe2, 0x79, 0x25b, 0x64, 0x25b, 0x3b, 0x53, 0xe1, 0x73, 0x69, 0x64,
0x25b, 0x3b, 0x53, 0x254, 0x301, 0x3b, 0x4d, 0x254, 0x301, 0x3b, 0xc1, 0x4d, 0x3b, 0x57, 0x25b, 0x301, 0x3b, 0x54, 0x254, 0x301,
0x3b, 0x46, 0x25b, 0x3b, 0x53, 0xe1, 0x3b, 0x6d, 0x69, 0x74, 0x3b, 0x6d, 0x75, 0x72, 0x3b, 0x6d, 0x6d, 0x6b, 0x3b, 0x6d,
0x6d, 0x73, 0x3b, 0x73, 0x75, 0x70, 0x3b, 0x79, 0x75, 0x6b, 0x3b, 0x73, 0x61, 0x75, 0x3b, 0x6d, 0x69, 0x74, 0x75, 0xfa,
0x3b, 0x6d, 0x75, 0x72, 0x61, 0x6b, 0x69, 0x70, 0xed, 0x3b, 0x6d, 0x75, 0x72, 0x61, 0x6b, 0xed, 0x2d, 0x6d, 0x75, 0x6b,
0x169, 0x69, 0x3b, 0x6d, 0x75, 0x72, 0x61, 0x6b, 0xed, 0x2d, 0x6d, 0x75, 0x73, 0x61, 0x70, 0xed, 0x72, 0x69, 0x3b, 0x73,
0x75, 0x70, 0x61, 0x70, 0xe1, 0x3b, 0x79, 0x75, 0x6b, 0x75, 0x61, 0x6b, 0xfa, 0x3b, 0x73, 0x61, 0x75, 0x72, 0xfa, 0x3b,
0x4d, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x59, 0x3b, 0x53, 0x3b, 0x53, 0x1ecd, 0x301, 0x6e, 0x3b, 0x4d,
0x1ecd, 0x301, 0x6e, 0x3b, 0x54, 0x69, 0xfa, 0x3b, 0x57, 0x1eb9, 0x301, 0x6e, 0x3b, 0x54, 0x1ecd, 0x301, 0x7a, 0x3b, 0x46, 0x72,
0x61, 0xed, 0x3b, 0x53, 0xe1, 0x74, 0x3b, 0x53, 0x1ecd, 0x301, 0x6e, 0x64, 0xe8, 0x3b, 0x4d, 0x1ecd, 0x301, 0x6e, 0x64, 0xe8,
0x3b, 0x54, 0x69, 0xfa, 0x7a, 0x64, 0xe8, 0x3b, 0x57, 0x1eb9, 0x301, 0x6e, 0x1eb9, 0x301, 0x7a, 0x64, 0xe8, 0x3b, 0x54, 0x1ecd,
0x301, 0x7a, 0x64, 0xe8, 0x3b, 0x46, 0x72, 0x61, 0xed, 0x64, 0xe8, 0x3b, 0x53, 0xe1, 0x74, 0x1ecd, 0x64, 0xe8, 0x3b, 0x7de,
0x7ca, 0x7ef, 0x7d9, 0x3b, 0x7de, 0x7d0, 0x7ec, 0x7d3, 0x3b, 0x7de, 0x7d0, 0x7ec, 0x7df, 0x3b, 0x7de, 0x7ce, 0x7e3, 0x3b, 0x7d3, 0x7cc,
0x7df, 0x3b, 0x7db, 0x7cc, 0x7ec, 0x7e3, 0x3b, 0x7de, 0x7cd, 0x7f2, 0x7d8, 0x3b, 0x7de, 0x7ca, 0x7ef, 0x7d9, 0x7cc, 0x7df, 0x7cf, 0x7f2,
0x3b, 0x7de, 0x7d0, 0x7ec, 0x7d3, 0x7ca, 0x7ec, 0x7df, 0x7cf, 0x7f2, 0x3b, 0x7de, 0x7d0, 0x7ec, 0x7df, 0x7cf, 0x7f2, 0x3b, 0x7de, 0x7ce,
0x7e3, 0x7ce, 0x7f2, 0x7df, 0x7cf, 0x7f2, 0x3b, 0x7d3, 0x7cc, 0x7df, 0x7cf, 0x7f2, 0x3b, 0x7db, 0x7cc, 0x7ec, 0x7e3, 0x7cc, 0x7f2, 0x7ec,
0x7df, 0x7cf, 0x7f2, 0x3b, 0x7de, 0x7cd, 0x7f2, 0x7d8, 0x7cd, 0x7df, 0x7cf, 0x7f2, 0x3b, 0x7de, 0x3b, 0x7de, 0x3b, 0x7de, 0x3b, 0x7de,
0x3b, 0x7d3, 0x3b, 0x7db, 0x3b, 0x7de, 0x3b, 0x7de, 0x7ca, 0x7ef, 0x7d9, 0x3b, 0x7de, 0x7d0, 0x7ec, 0x7d3, 0x3b, 0x7de, 0x7d0, 0x7ec,
0x7df, 0x7cf, 0x7f2, 0x3b, 0x7de, 0x7ce, 0x7e3, 0x3b, 0x7d3, 0x7cc, 0x7df, 0x3b, 0x7db, 0x7cc, 0x7ec, 0x7e3, 0x3b, 0x7de, 0x7cd, 0x7f2,
0x7d8, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x76, 0x75, 0x3b, 0x53, 0x69, 0x62, 0x3b, 0x53, 0x69, 0x74, 0x3b, 0x53, 0x69,
0x6e, 0x3b, 0x53, 0x69, 0x68, 0x3b, 0x4d, 0x67, 0x71, 0x3b, 0x53, 0x6f, 0x6e, 0x74, 0x6f, 0x3b, 0x4d, 0x76, 0x75, 0x6c,
0x6f, 0x3b, 0x53, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x53, 0x69, 0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x53, 0x69,
0x6e, 0x65, 0x3b, 0x53, 0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x67, 0x71, 0x69, 0x62, 0x65, 0x6c, 0x6f, 0x3b,
0x53, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x53, 0xf6, 0x6e, 0x3b, 0x4d, 0x75,
0x6e, 0x3b, 0x54, 0x65, 0x69, 0x3b, 0x57, 0x65, 0x64, 0x3b, 0x54, 0xfc, 0x72, 0x3b, 0x46, 0x72, 0x65, 0x3b, 0x53, 0x61,
0x6e, 0x3b, 0x53, 0xf6, 0x6e, 0x64, 0x61, 0x69, 0x3b, 0x4d, 0x75, 0x6e, 0x64, 0x61, 0x69, 0x3b, 0x54, 0x65, 0x69, 0x73,
0x64, 0x61, 0x69, 0x3b, 0x57, 0x65, 0x65, 0x64, 0x65, 0x6e, 0x73, 0x64, 0x61, 0x69, 0x3b, 0x54, 0xfc, 0xfc, 0x72, 0x73,
0x64, 0x61, 0x69, 0x3b, 0x46, 0x72, 0x65, 0x69, 0x64, 0x61, 0x69, 0x3b, 0x53, 0x61, 0x6e, 0x69, 0x6e, 0x6a, 0x3b, 0x73,
0x6f, 0x74, 0x6e, 0x3b, 0x76, 0x75, 0x6f, 0x73, 0x3b, 0x6d, 0x61, 0x14b, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x3b, 0x64, 0x75,
0x6f, 0x72, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x3b, 0x6c, 0xe1, 0x76, 0x3b, 0x73, 0x6f, 0x74, 0x6e, 0x61, 0x62, 0x65, 0x61,
0x69, 0x76, 0x69, 0x3b, 0x76, 0x75, 0x6f, 0x73, 0x73, 0xe1, 0x72, 0x67, 0x61, 0x3b, 0x6d, 0x61, 0x14b, 0x14b, 0x65, 0x62,
0xe1, 0x72, 0x67, 0x61, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x61, 0x76, 0x61, 0x68, 0x6b, 0x6b, 0x75, 0x3b, 0x64, 0x75, 0x6f,
0x72, 0x61, 0x73, 0x64, 0x61, 0x74, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x6a, 0x61, 0x64, 0x61, 0x74, 0x3b, 0x6c, 0xe1, 0x76,
0x76, 0x61, 0x72, 0x64, 0x61, 0x74, 0x3b, 0x53, 0x3b, 0x56, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x4c,
0x3b, 0x73, 0x6f, 0x3b, 0x6d, 0xe1, 0x3b, 0x64, 0x69, 0x3b, 0x67, 0x61, 0x3b, 0x64, 0x75, 0x3b, 0x62, 0x65, 0x3b, 0x6c,
0xe1, 0x3b, 0x73, 0x6f, 0x74, 0x6e, 0x61, 0x62, 0x65, 0x61, 0x69, 0x76, 0x69, 0x3b, 0x6d, 0xe1, 0x6e, 0x6e, 0x6f, 0x64,
0x61, 0x74, 0x3b, 0x64, 0x69, 0x73, 0x64, 0x61, 0x74, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x61, 0x76, 0x61, 0x68, 0x6b, 0x6b,
0x75, 0x3b, 0x64, 0x75, 0x6f, 0x72, 0x61, 0x73, 0x74, 0x61, 0x74, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x6a, 0x61, 0x64, 0x61,
0x74, 0x3b, 0x6c, 0xe1, 0x76, 0x76, 0x6f, 0x72, 0x64, 0x61, 0x74, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x47, 0x3b,
0x44, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x4c, 0x61, 0x6d, 0x3b, 0x4d, 0x6f, 0x73, 0x3b, 0x42, 0x65, 0x64, 0x3b, 0x52, 0x61,
0x72, 0x3b, 0x4e, 0x65, 0x3b, 0x48, 0x6c, 0x61, 0x3b, 0x4d, 0x6f, 0x6b, 0x3b, 0x4c, 0x61, 0x6d, 0x6f, 0x72, 0x65, 0x6e,
0x61, 0x3b, 0x4d, 0x75, 0x73, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x6f, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x62, 0x65, 0x64,
0x69, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x72, 0x6f, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x6e, 0x65, 0x3b, 0x4c, 0x61,
0x62, 0x6f, 0x68, 0x6c, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x6f, 0x6b, 0x69, 0x62, 0x65, 0x6c, 0x6f, 0x3b, 0x4c, 0x3b, 0x4d,
0x3b, 0x42, 0x3b, 0x52, 0x3b, 0x4e, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x73, 0xf8, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x6e, 0x2e,
0x3b, 0x74, 0x69, 0x72, 0x2e, 0x3b, 0x6f, 0x6e, 0x73, 0x2e, 0x3b, 0x74, 0x6f, 0x72, 0x2e, 0x3b, 0x66, 0x72, 0x65, 0x2e,
0x3b, 0x6c, 0xf8, 0x72, 0x2e, 0x3b, 0x73, 0xf8, 0x6e, 0x3b, 0x6d, 0xe5, 0x6e, 0x3b, 0x74, 0x79, 0x73, 0x3b, 0x6f, 0x6e,
0x73, 0x3b, 0x74, 0x6f, 0x72, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c, 0x61, 0x75, 0x3b, 0x73, 0xf8, 0x6e, 0x64, 0x61, 0x67,
0x3b, 0x6d, 0xe5, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x79, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61,
0x67, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66, 0x72, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c, 0x61, 0x75,
0x72, 0x64, 0x61, 0x67, 0x3b, 0x73, 0xf8, 0x2e, 0x3b, 0x6d, 0xe5, 0x2e, 0x3b, 0x74, 0x79, 0x2e, 0x3b, 0x6f, 0x6e, 0x2e,
0x3b, 0x74, 0x6f, 0x2e, 0x3b, 0x66, 0x72, 0x2e, 0x3b, 0x6c, 0x61, 0x2e, 0x3b, 0x43, 0xe4, 0x14b, 0x3b, 0x4a, 0x69, 0x65,
0x63, 0x3b, 0x52, 0x25b, 0x77, 0x3b, 0x44, 0x69, 0x254, 0x331, 0x6b, 0x3b, 0x14a, 0x75, 0x61, 0x61, 0x6e, 0x3b, 0x44, 0x68,
0x69, 0x65, 0x65, 0x63, 0x3b, 0x42, 0xe4, 0x6b, 0x25b, 0x6c, 0x3b, 0x43, 0xe4, 0x14b, 0x20, 0x6b, 0x75, 0x254, 0x74, 0x68,
0x3b, 0x4a, 0x69, 0x65, 0x63, 0x20, 0x6c, 0x61, 0x331, 0x74, 0x3b, 0x52, 0x25b, 0x77, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69,
0x3b, 0x44, 0x69, 0x254, 0x331, 0x6b, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x14a, 0x75, 0x61, 0x61, 0x6e, 0x20, 0x6c,
0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x44, 0x68, 0x69, 0x65, 0x65, 0x63, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x42, 0xe4,
0x6b, 0x25b, 0x6c, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x43, 0x3b, 0x4a, 0x3b, 0x52, 0x3b, 0x44, 0x3b, 0x14a, 0x3b,
0x44, 0x3b, 0x42, 0x3b, 0x4d, 0x75, 0x6c, 0x3b, 0x4c, 0x65, 0x6d, 0x3b, 0x57, 0x69, 0x72, 0x3b, 0x54, 0x61, 0x74, 0x3b,
0x4e, 0x61, 0x69, 0x3b, 0x53, 0x61, 0x6e, 0x3b, 0x57, 0x65, 0x72, 0x3b, 0x4c, 0x61, 0x6d, 0x75, 0x6c, 0x75, 0x6e, 0x67,
0x75, 0x3b, 0x4c, 0x6f, 0x6c, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4c, 0x61, 0x63, 0x68, 0x69, 0x77, 0x69, 0x72, 0x69, 0x3b,
0x4c, 0x61, 0x63, 0x68, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4c, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x61, 0x79, 0x69, 0x3b,
0x4c, 0x61, 0x63, 0x68, 0x69, 0x73, 0x61, 0x6e, 0x75, 0x3b, 0x4c, 0x6f, 0x77, 0x65, 0x72, 0x75, 0x6b, 0x61, 0x3b, 0x64,
0x69, 0x6d, 0x65, 0x6e, 0x67, 0x65, 0x3b, 0x64, 0x69, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x72, 0x73,
0x3b, 0x64, 0x69, 0x6d, 0xe8, 0x63, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x6a, 0xf2, 0x75, 0x73, 0x3b, 0x64, 0x69, 0x76,
0x65, 0x6e, 0x64, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x73, 0x73, 0x61, 0x62, 0x74, 0x65, 0x3b, 0x44, 0x67, 0x3b, 0x44,
0x6c, 0x3b, 0x44, 0x6d, 0x3b, 0x44, 0x63, 0x3b, 0x44, 0x6a, 0x3b, 0x44, 0x76, 0x3b, 0x44, 0x73, 0x3b, 0x64, 0x69, 0x6d,
0x3b, 0x64, 0x65, 0x6c, 0x3b, 0x64, 0x6d, 0x61, 0x3b, 0x64, 0x6d, 0xe8, 0x3b, 0x64, 0x69, 0x6a, 0x3b, 0x64, 0x69, 0x75,
0x3b, 0x64, 0x69, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x67, 0x65, 0x3b, 0x64, 0x65, 0x6c, 0x75, 0x6e, 0x73, 0x3b,
0x64, 0x69, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0xe8, 0x72, 0x63, 0x6c, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x6a,
0x61, 0x75, 0x73, 0x3b, 0x64, 0x69, 0x75, 0x65, 0x6e, 0x64, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x73, 0x73, 0x61, 0x62,
0x74, 0x65, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x58, 0x3b, 0x4a, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0xb30, 0xb2c, 0xb3f,
0x3b, 0xb38, 0xb4b, 0xb2e, 0x3b, 0xb2e, 0xb19, 0xb4d, 0xb17, 0xb33, 0x3b, 0xb2c, 0xb41, 0xb27, 0x3b, 0xb17, 0xb41, 0xb30, 0xb41, 0x3b,
0xb36, 0xb41, 0xb15, 0xb4d, 0xb30, 0x3b, 0xb36, 0xb28, 0xb3f, 0x3b, 0xb30, 0xb2c, 0xb3f, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb38, 0xb4b, 0xb2e,
0xb2c, 0xb3e, 0xb30, 0x3b, 0xb2e, 0xb19, 0xb4d, 0xb17, 0xb33, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb2c, 0xb41, 0xb27, 0xb2c, 0xb3e, 0xb30, 0x3b,
0xb17, 0xb41, 0xb30, 0xb41, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb36, 0xb41, 0xb15, 0xb4d, 0xb30, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb36, 0xb28, 0xb3f,
0xb2c, 0xb3e, 0xb30, 0x3b, 0xb30, 0x3b, 0xb38, 0xb4b, 0x3b, 0xb2e, 0x3b, 0xb2c, 0xb41, 0x3b, 0xb17, 0xb41, 0x3b, 0xb36, 0xb41, 0x3b,
0xb36, 0x3b, 0x44, 0x69, 0x6c, 0x3b, 0x57, 0x69, 0x78, 0x3b, 0x51, 0x69, 0x62, 0x3b, 0x52, 0x6f, 0x62, 0x3b, 0x4b, 0x61,
0x6d, 0x3b, 0x4a, 0x69, 0x6d, 0x3b, 0x53, 0x61, 0x6e, 0x3b, 0x44, 0x69, 0x6c, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x57, 0x69,
0x69, 0x78, 0x61, 0x74, 0x61, 0x3b, 0x51, 0x69, 0x62, 0x78, 0x61, 0x74, 0x61, 0x3b, 0x52, 0x6f, 0x6f, 0x62, 0x69, 0x69,
0x3b, 0x4b, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x61, 0x3b, 0x4a, 0x69, 0x6d, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x6e,
0x62, 0x61, 0x74, 0x61, 0x3b, 0x44, 0x3b, 0x57, 0x3b, 0x51, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0xd801,
0xdcb9, 0xd801, 0xdcd8, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdccf, 0xd801, 0xdcd8, 0xd801, 0xdce4, 0xd801, 0xdcd8, 0x358, 0xd801, 0xdcf0,
0xd801, 0xdcd8, 0xd801, 0xdce4, 0xd801, 0xdce3, 0x3b, 0xd801, 0xdcb9, 0xd801, 0xdcd8, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdcc4, 0xd801,
0xdcd8, 0xd801, 0xdce1, 0xd801, 0xdcdb, 0x358, 0xd801, 0xdce7, 0xd801, 0xdce3, 0x3b, 0xd801, 0xdcb9, 0xd801, 0xdcd8, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8,
0x20, 0xd801, 0xdccf, 0xd801, 0xdcdf, 0xd801, 0xdcf5, 0xd801, 0xdcea, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x3b, 0xd801, 0xdcb9, 0xd801, 0xdcd8, 0x358,
0xd801, 0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdccf, 0xd801, 0xdcdf, 0xd801, 0xdcf5, 0xd801, 0xdcd8, 0xd801, 0xdcdc, 0xd801, 0xdce3, 0x3b, 0xd801, 0xdcb9,
0xd801, 0xdcd8, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdccf, 0xd801, 0xdcdf, 0xd801, 0xdcf0, 0xd801, 0xdcea, 0xd801, 0xdcec, 0xd801, 0xdcd8,
0x3b, 0xd801, 0xdcb9, 0xd801, 0xdcd8, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdcc8, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdcf5, 0xd801, 0xdcd8,
0xd801, 0xdcf2, 0xd801, 0xdcd8, 0x20, 0xd801, 0xdcfb, 0xd801, 0xdce3, 0x358, 0x3b, 0xd801, 0xdcb9, 0xd801, 0xdcd8, 0x358, 0xd801, 0xdcec, 0xd801, 0xdcd8,
0x20, 0xd801, 0xdcc2, 0xd801, 0xdce4, 0xd801, 0xdcd8, 0xd801, 0xdcf8, 0xd801, 0xdcdf, 0x20, 0xd801, 0xdce3, 0x358, 0xd801, 0xdce4, 0xd801, 0xdcdf, 0x3b,
0xd801, 0xdccf, 0x3b, 0xd801, 0xdcc4, 0x3b, 0xd801, 0xdccd, 0x3b, 0xd801, 0xdcb4, 0x3b, 0xd801, 0xdcc8, 0x3b, 0xd801, 0xdcca, 0x3b, 0xd801, 0xdcf8,
0x3b, 0x425, 0x446, 0x431, 0x3b, 0x41a, 0x440, 0x441, 0x3b, 0x414, 0x446, 0x433, 0x3b, 0x4d4, 0x440, 0x442, 0x3b, 0x426, 0x43f, 0x440,
0x3b, 0x41c, 0x440, 0x431, 0x3b, 0x421, 0x431, 0x442, 0x3b, 0x425, 0x443, 0x44b, 0x446, 0x430, 0x443, 0x431, 0x43e, 0x43d, 0x3b, 0x41a,
0x44a, 0x443, 0x44b, 0x440, 0x438, 0x441, 0x4d5, 0x440, 0x3b, 0x414, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x4d4, 0x440, 0x442, 0x44b,
0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x426, 0x44b, 0x43f, 0x43f, 0x4d5, 0x440, 0x4d5, 0x43c, 0x3b, 0x41c, 0x430, 0x439, 0x440, 0x4d5, 0x43c,
0x431, 0x43e, 0x43d, 0x3b, 0x421, 0x430, 0x431, 0x430, 0x442, 0x3b, 0x425, 0x3b, 0x41a, 0x3b, 0x414, 0x3b, 0x4d4, 0x3b, 0x426, 0x3b,
0x41c, 0x3b, 0x421, 0x3b, 0x445, 0x446, 0x431, 0x3b, 0x43a, 0x440, 0x441, 0x3b, 0x434, 0x446, 0x433, 0x3b, 0x4d5, 0x440, 0x442, 0x3b,
0x446, 0x43f, 0x440, 0x3b, 0x43c, 0x440, 0x431, 0x3b, 0x441, 0x431, 0x442, 0x3b, 0x445, 0x443, 0x44b, 0x446, 0x430, 0x443, 0x431, 0x43e,
0x43d, 0x3b, 0x43a, 0x44a, 0x443, 0x44b, 0x440, 0x438, 0x441, 0x4d5, 0x440, 0x3b, 0x434, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x4d5,
0x440, 0x442, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x446, 0x44b, 0x43f, 0x43f, 0x4d5, 0x440, 0x4d5, 0x43c, 0x3b, 0x43c, 0x430, 0x439,
0x440, 0x4d5, 0x43c, 0x431, 0x43e, 0x43d, 0x3b, 0x441, 0x430, 0x431, 0x430, 0x442, 0x3b, 0x64, 0x6a, 0x61, 0x64, 0x75, 0x6d, 0x69,
0x6e, 0x67, 0x75, 0x3b, 0x64, 0x6a, 0x61, 0x6c, 0x75, 0x6e, 0x61, 0x3b, 0x64, 0x6a, 0x61, 0x6d, 0x61, 0x72, 0x73, 0x3b,
0x64, 0x6a, 0x61, 0x72, 0x61, 0x73, 0x6f, 0x6e, 0x3b, 0x64, 0x6a, 0x61, 0x77, 0x65, 0x70, 0x73, 0x3b, 0x64, 0x6a, 0x61,
0x62, 0x69, 0xe8, 0x72, 0x6e, 0xe8, 0x3b, 0x64, 0x6a, 0x61, 0x73, 0x61, 0x62, 0x72, 0x61, 0x3b, 0x64a, 0x648, 0x646, 0x6cd,
0x3b, 0x62f, 0x648, 0x646, 0x6cd, 0x3b, 0x62f, 0x631, 0x6d0, 0x646, 0x6cd, 0x3b, 0x685, 0x644, 0x631, 0x646, 0x6cd, 0x3b, 0x67e, 0x64a,
0x646, 0x681, 0x646, 0x6cd, 0x3b, 0x62c, 0x645, 0x639, 0x647, 0x3b, 0x627, 0x648, 0x646, 0x6cd, 0x3b, 0x6cc, 0x6a9, 0x634, 0x646, 0x628,
0x647, 0x3b, 0x62f, 0x648, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x633, 0x647, 0x200c, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x686, 0x647, 0x627,
0x631, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x67e, 0x646, 0x62c, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x62c, 0x645, 0x639, 0x647, 0x3b, 0x634,
0x646, 0x628, 0x647, 0x3b, 0x6cc, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b, 0x67e, 0x3b, 0x62c, 0x3b, 0x634, 0x3b, 0x53, 0x61,
0x6e, 0x64, 0x65, 0x3b, 0x4d, 0x61, 0x6e, 0x64, 0x65, 0x3b, 0x54, 0x69, 0x75, 0x73, 0x64, 0x65, 0x3b, 0x57, 0x65, 0x6e,
0x65, 0x73, 0x64, 0x65, 0x3b, 0x54, 0x6f, 0x73, 0x64, 0x65, 0x3b, 0x46, 0x72, 0x61, 0x65, 0x64, 0x65, 0x3b, 0x53, 0x61,
0x74, 0x61, 0x64, 0x65, 0x3b, 0x6e, 0x69, 0x65, 0x64, 0x7a, 0x2e, 0x3b, 0x70, 0x6f, 0x6e, 0x2e, 0x3b, 0x77, 0x74, 0x2e,
0x3b, 0x15b, 0x72, 0x2e, 0x3b, 0x63, 0x7a, 0x77, 0x2e, 0x3b, 0x70, 0x74, 0x2e, 0x3b, 0x73, 0x6f, 0x62, 0x2e, 0x3b, 0x6e,
0x69, 0x65, 0x64, 0x7a, 0x69, 0x65, 0x6c, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x69, 0x65, 0x64, 0x7a, 0x69, 0x61, 0x142, 0x65,
0x6b, 0x3b, 0x77, 0x74, 0x6f, 0x72, 0x65, 0x6b, 0x3b, 0x15b, 0x72, 0x6f, 0x64, 0x61, 0x3b, 0x63, 0x7a, 0x77, 0x61, 0x72,
0x74, 0x65, 0x6b, 0x3b, 0x70, 0x69, 0x105, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x4e, 0x3b,
0x50, 0x3b, 0x57, 0x3b, 0x15a, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x77, 0x3b, 0x15b, 0x3b,
0x63, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x64, 0x6f, 0x6d, 0x2e, 0x3b, 0x73, 0x65, 0x67, 0x2e, 0x3b, 0x74, 0x65, 0x72, 0x2e,
0x3b, 0x71, 0x75, 0x61, 0x2e, 0x3b, 0x71, 0x75, 0x69, 0x2e, 0x3b, 0x73, 0x65, 0x78, 0x2e, 0x3b, 0x73, 0xe1, 0x62, 0x2e,
0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x2d, 0x66, 0x65, 0x69,
0x72, 0x61, 0x3b, 0x74, 0x65, 0x72, 0xe7, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x71, 0x75, 0x61, 0x72, 0x74,
0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x71, 0x75, 0x69, 0x6e, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61,
0x3b, 0x73, 0x65, 0x78, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b,
0x44, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x51, 0x3b, 0x51, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67,
0x6f, 0x3b, 0x73, 0x65, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x3b, 0x74, 0x65, 0x72, 0xe7, 0x61, 0x3b, 0x71, 0x75, 0x61, 0x72,
0x74, 0x61, 0x3b, 0x71, 0x75, 0x69, 0x6e, 0x74, 0x61, 0x3b, 0x73, 0x65, 0x78, 0x74, 0x61, 0x3b, 0x73, 0xe1, 0x62, 0x61,
0x64, 0x6f, 0x3b, 0x6e, 0x61, 0x64, 0x3b, 0x70, 0x61, 0x6e, 0x3b, 0x77, 0x69, 0x73, 0x3b, 0x70, 0x75, 0x73, 0x3b, 0x6b,
0x65, 0x74, 0x3b, 0x70, 0x113, 0x6e, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x6e, 0x61, 0x64, 0x12b, 0x6c, 0x69, 0x3b, 0x70, 0x61,
0x6e, 0x61, 0x64, 0x12b, 0x6c, 0x69, 0x3b, 0x77, 0x69, 0x73, 0x61, 0x73, 0x12b, 0x64, 0x69, 0x73, 0x3b, 0x70, 0x75, 0x73,
0x73, 0x69, 0x73, 0x61, 0x77, 0x61, 0x69, 0x74, 0x69, 0x3b, 0x6b, 0x65, 0x74, 0x77, 0x69, 0x72, 0x74, 0x69, 0x6b, 0x73,
0x3b, 0x70, 0x113, 0x6e, 0x74, 0x6e, 0x69, 0x6b, 0x73, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x74, 0x74, 0x69, 0x6b, 0x61, 0x3b,
0x4e, 0x3b, 0x50, 0x3b, 0x57, 0x3b, 0x50, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0xa10, 0xa24, 0x3b, 0xa38, 0xa4b, 0xa2e,
0x3b, 0xa2e, 0xa70, 0xa17, 0xa32, 0x3b, 0xa2c, 0xa41, 0xa71, 0xa27, 0x3b, 0xa35, 0xa40, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71, 0xa15,
0xa30, 0x3b, 0xa38, 0xa3c, 0xa28, 0xa3f, 0xa71, 0xa1a, 0xa30, 0x3b, 0xa10, 0xa24, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa4b, 0xa2e, 0xa35,
0xa3e, 0xa30, 0x3b, 0xa2e, 0xa70, 0xa17, 0xa32, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa2c, 0xa41, 0xa71, 0xa27, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa35,
0xa40, 0xa30, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71, 0xa15, 0xa30, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa28, 0xa3f,
0xa71, 0xa1a, 0xa30, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa10, 0x3b, 0xa38, 0xa4b, 0x3b, 0xa2e, 0xa70, 0x3b, 0xa2c, 0xa41, 0xa71, 0x3b, 0xa35,
0xa40, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71, 0x3b, 0xa38, 0xa3c, 0x3b, 0x627, 0x62a, 0x648, 0x627, 0x631, 0x3b, 0x67e, 0x6cc, 0x631, 0x3b,
0x645, 0x646, 0x6af, 0x644, 0x3b, 0x628, 0x64f, 0x62f, 0x6be, 0x3b, 0x62c, 0x645, 0x639, 0x631, 0x627, 0x62a, 0x3b, 0x62c, 0x645, 0x639,
0x6c1, 0x3b, 0x6c1, 0x641, 0x62a, 0x6c1, 0x3b, 0x44, 0x6f, 0x6d, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d,
0x69, 0xe9, 0x3b, 0x4a, 0x75, 0x65, 0x3b, 0x56, 0x69, 0x65, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x44, 0x6f, 0x6d, 0x69, 0x6e,
0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0x69, 0xe9, 0x72,
0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b, 0x4a, 0x75, 0x65, 0x76, 0x65, 0x73, 0x3b, 0x56, 0x69, 0x65, 0x72, 0x6e, 0x65, 0x73,
0x3b, 0x53, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x58, 0x3b, 0x4a, 0x3b, 0x56, 0x3b,
0x53, 0x3b, 0x64, 0x75, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x6d, 0x69, 0x65,
0x2e, 0x3b, 0x6a, 0x6f, 0x69, 0x3b, 0x76, 0x69, 0x6e, 0x2e, 0x3b, 0x73, 0xe2, 0x6d, 0x2e, 0x3b, 0x64, 0x75, 0x6d, 0x69,
0x6e, 0x69, 0x63, 0x103, 0x3b, 0x6c, 0x75, 0x6e, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x21b, 0x69, 0x3b, 0x6d, 0x69, 0x65, 0x72,
0x63, 0x75, 0x72, 0x69, 0x3b, 0x6a, 0x6f, 0x69, 0x3b, 0x76, 0x69, 0x6e, 0x65, 0x72, 0x69, 0x3b, 0x73, 0xe2, 0x6d, 0x62,
0x103, 0x74, 0x103, 0x3b, 0x44, 0x75, 0x6d, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x69, 0x65, 0x3b,
0x4a, 0x6f, 0x69, 0x3b, 0x56, 0x69, 0x6e, 0x3b, 0x53, 0xe2, 0x6d, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x61, 0x3b, 0x4d,
0x69, 0x3b, 0x4a, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x64, 0x75, 0x3b, 0x67, 0x6c, 0x69, 0x3b, 0x6d, 0x61, 0x3b, 0x6d, 0x65,
0x3b, 0x67, 0x69, 0x65, 0x3b, 0x76, 0x65, 0x3b, 0x73, 0x6f, 0x3b, 0x64, 0x75, 0x6d, 0x65, 0x6e, 0x67, 0x69, 0x61, 0x3b,
0x67, 0x6c, 0x69, 0x6e, 0x64, 0x65, 0x73, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x65, 0x73, 0x65,
0x6d, 0x6e, 0x61, 0x3b, 0x67, 0x69, 0x65, 0x76, 0x67, 0x69, 0x61, 0x3b, 0x76, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x69,
0x3b, 0x73, 0x6f, 0x6e, 0x64, 0x61, 0x3b, 0x44, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x56, 0x3b, 0x53,
0x3b, 0x49, 0x6a, 0x70, 0x3b, 0x49, 0x6a, 0x74, 0x3b, 0x49, 0x6a, 0x6e, 0x3b, 0x49, 0x6a, 0x74, 0x6e, 0x3b, 0x41, 0x6c,
0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x49, 0x6a, 0x6d, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x69, 0x3b,
0x49, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x49,
0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a,
0x75, 0x6d, 0x61, 0x61, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x63, 0x75, 0x2e, 0x3b, 0x6d,
0x62, 0x65, 0x2e, 0x3b, 0x6b, 0x61, 0x62, 0x2e, 0x3b, 0x67, 0x74, 0x75, 0x2e, 0x3b, 0x6b, 0x61, 0x6e, 0x2e, 0x3b, 0x67,
0x6e, 0x75, 0x2e, 0x3b, 0x67, 0x6e, 0x64, 0x2e, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x2019, 0x69, 0x6e, 0x64, 0x77, 0x69, 0x3b,
0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x72, 0x65, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61,
0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4b, 0x75,
0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x65, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e,
0x75, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x75, 0x3b, 0x432, 0x441,
0x3b, 0x43f, 0x43d, 0x3b, 0x432, 0x442, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x442, 0x3b, 0x43f, 0x442, 0x3b, 0x441, 0x431, 0x3b, 0x432,
0x43e, 0x441, 0x43a, 0x440, 0x435, 0x441, 0x435, 0x43d, 0x44c, 0x435, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x44c, 0x43d,
0x438, 0x43a, 0x3b, 0x432, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x441, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442,
0x432, 0x435, 0x440, 0x433, 0x3b, 0x43f, 0x44f, 0x442, 0x43d, 0x438, 0x446, 0x430, 0x3b, 0x441, 0x443, 0x431, 0x431, 0x43e, 0x442, 0x430,
0x3b, 0x412, 0x3b, 0x41f, 0x3b, 0x412, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x421, 0x3b, 0x4e, 0x61, 0x62, 0x3b, 0x53,
0x61, 0x6e, 0x3b, 0x53, 0x61, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x3b, 0x43, 0x61, 0x6d, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x51,
0x75, 0x6e, 0x3b, 0x4e, 0x61, 0x62, 0x61, 0x20, 0x53, 0x61, 0x6d, 0x62, 0x61, 0x74, 0x3b, 0x53, 0x61, 0x6e, 0x69, 0x3b,
0x53, 0x61, 0x6c, 0x75, 0x73, 0x3b, 0x52, 0x61, 0x62, 0x75, 0x71, 0x3b, 0x43, 0x61, 0x6d, 0x75, 0x73, 0x3b, 0x4a, 0x75,
0x6d, 0x71, 0x61, 0x74, 0x61, 0x3b, 0x51, 0x75, 0x6e, 0x78, 0x61, 0x20, 0x53, 0x61, 0x6d, 0x62, 0x61, 0x74, 0x3b, 0x4e,
0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x43, 0x3b, 0x4a, 0x3b, 0x51, 0x3b, 0x431, 0x441, 0x3b, 0x431, 0x43d, 0x3b, 0x43e,
0x43f, 0x3b, 0x441, 0x44d, 0x3b, 0x447, 0x43f, 0x3b, 0x431, 0x44d, 0x3b, 0x441, 0x431, 0x3b, 0x431, 0x430, 0x441, 0x43a, 0x44b, 0x4bb,
0x44b, 0x430, 0x43d, 0x43d, 0x44c, 0x430, 0x3b, 0x431, 0x44d, 0x43d, 0x438, 0x434, 0x438, 0x44d, 0x43d, 0x43d, 0x44c, 0x438, 0x43a, 0x3b,
0x43e, 0x43f, 0x442, 0x443, 0x43e, 0x440, 0x443, 0x43d, 0x43d, 0x44c, 0x443, 0x43a, 0x3b, 0x441, 0x44d, 0x440, 0x44d, 0x434, 0x44d, 0x3b,
0x447, 0x44d, 0x43f, 0x43f, 0x438, 0x44d, 0x440, 0x3b, 0x411, 0x44d, 0x44d, 0x442, 0x438, 0x4a5, 0x441, 0x44d, 0x3b, 0x441, 0x443, 0x431,
0x443, 0x43e, 0x442, 0x430, 0x3b, 0x411, 0x3b, 0x411, 0x3b, 0x41e, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x411, 0x3b, 0x421, 0x3b, 0x41,
0x72, 0x65, 0x3b, 0x4b, 0x75, 0x6e, 0x3b, 0x4f, 0x6e, 0x67, 0x3b, 0x49, 0x6e, 0x65, 0x3b, 0x49, 0x6c, 0x65, 0x3b, 0x53,
0x61, 0x70, 0x3b, 0x4b, 0x77, 0x65, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x61, 0x72, 0x65,
0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x6b, 0x75, 0x6e, 0x69, 0x3b, 0x4d, 0x64, 0x65, 0x72,
0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x6f, 0x6e, 0x67, 0x2019, 0x77, 0x61, 0x6e, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74,
0x20, 0x65, 0x65, 0x20, 0x69, 0x6e, 0x65, 0x74, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x69,
0x6c, 0x65, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x73, 0x61, 0x70, 0x61, 0x3b, 0x4d, 0x64,
0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x6b, 0x77, 0x65, 0x3b, 0x41, 0x3b, 0x4b, 0x3b, 0x4f, 0x3b, 0x49, 0x3b,
0x49, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x42, 0x6b, 0x31, 0x3b, 0x42, 0x6b, 0x32, 0x3b, 0x42, 0x6b, 0x33, 0x3b, 0x42, 0x6b,
0x34, 0x3b, 0x42, 0x6b, 0x35, 0x3b, 0x4c, 0xe2, 0x70, 0x3b, 0x4c, 0xe2, 0x79, 0x3b, 0x42, 0x69, 0x6b, 0x75, 0x61, 0x2d,
0xf4, 0x6b, 0x6f, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d, 0xfb, 0x73, 0x65, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d,
0x70, 0x74, 0xe2, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d, 0x75, 0x73, 0xef, 0xf6, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61,
0x2d, 0x6f, 0x6b, 0xfc, 0x3b, 0x4c, 0xe2, 0x70, 0xf4, 0x73, 0xf6, 0x3b, 0x4c, 0xe2, 0x79, 0x65, 0x6e, 0x67, 0x61, 0x3b,
0x4b, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x59, 0x3b, 0x4d, 0x75, 0x6c, 0x3b, 0x4a, 0x74,
0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d,
0x6f, 0x3b, 0x4d, 0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x61, 0x68,
0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73,
0x69, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x3b, 0x930, 0x935, 0x93f, 0x935,
0x93e, 0x938, 0x930, 0x903, 0x3b, 0x938, 0x94b, 0x92e, 0x935, 0x93e, 0x938, 0x930, 0x903, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x935, 0x93e,
0x938, 0x930, 0x903, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x938, 0x930, 0x903, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x935, 0x93e, 0x938,
0x930, 0x3a, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x935, 0x93e, 0x938, 0x930, 0x903, 0x3b, 0x936, 0x928, 0x93f, 0x935, 0x93e, 0x938,
0x930, 0x903, 0x3b, 0x1c65, 0x1c64, 0x1c78, 0x3b, 0x1c5a, 0x1c5b, 0x3b, 0x1c75, 0x1c5f, 0x3b, 0x1c65, 0x1c5f, 0x1c79, 0x3b, 0x1c65, 0x1c5f, 0x1c79,
0x1c68, 0x3b, 0x1c61, 0x1c5f, 0x1c79, 0x3b, 0x1c67, 0x1c69, 0x3b, 0x1c65, 0x1c64, 0x1c78, 0x1c5c, 0x1c6e, 0x3b, 0x1c5a, 0x1c5b, 0x1c6e, 0x3b, 0x1c75,
0x1c5f, 0x1c5e, 0x1c6e, 0x3b, 0x1c65, 0x1c5f, 0x1c79, 0x1c5c, 0x1c69, 0x1c71, 0x3b, 0x1c65, 0x1c5f, 0x1c79, 0x1c68, 0x1c6b, 0x1c64, 0x3b, 0x1c61, 0x1c5f,
0x1c79, 0x1c68, 0x1c69, 0x1c62, 0x3b, 0x1c67, 0x1c69, 0x1c66, 0x1c69, 0x1c62, 0x3b, 0x1c65, 0x3b, 0x1c5a, 0x3b, 0x1c75, 0x3b, 0x1c65, 0x3b, 0x1c65,
0x3b, 0x1c61, 0x3b, 0x1c67, 0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0xe8, 0x72,
0x3b, 0x67, 0x69, 0xf2, 0x3b, 0x63, 0x68, 0x65, 0x3b, 0x73, 0xe0, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0xec, 0x6e, 0x69, 0x67,
0x61, 0x3b, 0x6c, 0x75, 0x6e, 0x69, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x69, 0x73, 0x3b, 0x6d, 0xe8, 0x72, 0x63, 0x75,
0x72, 0x69, 0x73, 0x3b, 0x67, 0x69, 0xf2, 0x62, 0x69, 0x61, 0x3b, 0x63, 0x68, 0x65, 0x6e, 0xe0, 0x62, 0x75, 0x72, 0x61,
0x3b, 0x73, 0xe0, 0x62, 0x61, 0x64, 0x75, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x43, 0x3b,
0x53, 0x3b, 0x44, 0x69, 0x6d, 0x3b, 0x50, 0x6f, 0x73, 0x3b, 0x50, 0x69, 0x72, 0x3b, 0x54, 0x61, 0x74, 0x3b, 0x4e, 0x61,
0x69, 0x3b, 0x53, 0x68, 0x61, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x44, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x43, 0x68,
0x69, 0x70, 0x6f, 0x73, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x74, 0x61, 0x74,
0x75, 0x3b, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x73, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x53, 0x61,
0x62, 0x75, 0x64, 0x75, 0x3b, 0x44, 0x3b, 0x50, 0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x4e, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x43d,
0x435, 0x434, 0x3b, 0x43f, 0x43e, 0x43d, 0x3b, 0x443, 0x442, 0x43e, 0x3b, 0x441, 0x440, 0x435, 0x3b, 0x447, 0x435, 0x442, 0x3b, 0x43f,
0x435, 0x442, 0x3b, 0x441, 0x443, 0x431, 0x3b, 0x43d, 0x435, 0x434, 0x435, 0x459, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435,
0x459, 0x430, 0x43a, 0x3b, 0x443, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442,
0x432, 0x440, 0x442, 0x430, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x430, 0x43a, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d,
0x435, 0x434, 0x458, 0x435, 0x459, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x459, 0x430, 0x43a, 0x3b, 0x443, 0x442, 0x43e,
0x440, 0x430, 0x43a, 0x3b, 0x441, 0x440, 0x438, 0x458, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x430, 0x43a,
0x3b, 0x43f, 0x435, 0x442, 0x430, 0x43a, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x6e, 0x65, 0x64, 0x3b, 0x70, 0x6f,
0x6e, 0x3b, 0x75, 0x74, 0x6f, 0x3b, 0x73, 0x72, 0x65, 0x3b, 0x10d, 0x65, 0x74, 0x3b, 0x70, 0x65, 0x74, 0x3b, 0x73, 0x75,
0x62, 0x3b, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x6b,
0x3b, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x6b, 0x3b, 0x73, 0x72, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x65, 0x74, 0x76, 0x72, 0x74,
0x61, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x61, 0x6b, 0x3b, 0x73, 0x75, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x65, 0x64, 0x6a,
0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72,
0x61, 0x6b, 0x3b, 0x73, 0x72, 0x69, 0x6a, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 0x6b, 0x3b,
0x70, 0x65, 0x74, 0x61, 0x6b, 0x3b, 0x73, 0x75, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x4a, 0x70, 0x69, 0x3b, 0x4a, 0x74, 0x74,
0x3b, 0x4a, 0x6d, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x70, 0x69, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b,
0x4a, 0x75, 0x6d, 0x61, 0x61, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c,
0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x6d,
0x6f, 0x73, 0x69, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x31, 0x3b, 0x53, 0x76,
0x6f, 0x3b, 0x4d, 0x75, 0x76, 0x3b, 0x43, 0x68, 0x70, 0x3b, 0x43, 0x68, 0x74, 0x3b, 0x43, 0x68, 0x6e, 0x3b, 0x43, 0x68,
0x73, 0x3b, 0x4d, 0x75, 0x67, 0x3b, 0x53, 0x76, 0x6f, 0x6e, 0x64, 0x6f, 0x3b, 0x4d, 0x75, 0x76, 0x68, 0x75, 0x72, 0x6f,
0x3b, 0x43, 0x68, 0x69, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x43, 0x68, 0x69,
0x6e, 0x61, 0x3b, 0x43, 0x68, 0x69, 0x73, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x75, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x61,
0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x4d, 0x3b, 0xa46d, 0xa18f, 0x3b, 0xa18f, 0xa2cd,
0x3b, 0xa18f, 0xa44d, 0x3b, 0xa18f, 0xa315, 0x3b, 0xa18f, 0xa1d6, 0x3b, 0xa18f, 0xa26c, 0x3b, 0xa18f, 0xa0d8, 0x3b, 0xa46d, 0xa18f, 0xa44d, 0x3b,
0xa18f, 0xa282, 0xa2cd, 0x3b, 0xa18f, 0xa282, 0xa44d, 0x3b, 0xa18f, 0xa282, 0xa315, 0x3b, 0xa18f, 0xa282, 0xa1d6, 0x3b, 0xa18f, 0xa282, 0xa26c, 0x3b,
0xa18f, 0xa282, 0xa0d8, 0x3b, 0xa18f, 0x3b, 0xa2cd, 0x3b, 0xa44d, 0x3b, 0xa315, 0x3b, 0xa1d6, 0x3b, 0xa26c, 0x3b, 0xa0d8, 0x3b, 0x64, 0x75,
0x6d, 0xec, 0x6e, 0x69, 0x63, 0x61, 0x3b, 0x6c, 0x75, 0x6e, 0x6e, 0x69, 0x64, 0xec, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x74,
0x69, 0x64, 0xec, 0x61, 0x3b, 0x6d, 0x65, 0x72, 0x63, 0x75, 0x72, 0x69, 0x64, 0xec, 0x61, 0x3b, 0x6a, 0x6f, 0x76, 0x69,
0x64, 0xec, 0x61, 0x3b, 0x76, 0x65, 0x6e, 0x6e, 0x69, 0x64, 0xec, 0x61, 0x3b, 0x73, 0xe0, 0x62, 0x62, 0x61, 0x74, 0x75,
0x3b, 0x53, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x6e, 0x3b, 0x4d, 0x61, 0x6b, 0x3b, 0x52, 0x6f, 0x77, 0x3b, 0x48, 0x61, 0x6d,
0x3b, 0x41, 0x72, 0x62, 0x3b, 0x51, 0x69, 0x64, 0x3b, 0x53, 0x61, 0x6d, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x6e,
0x79, 0x6f, 0x3b, 0x4d, 0x61, 0x61, 0x6b, 0x69, 0x73, 0x61, 0x6e, 0x79, 0x6f, 0x3b, 0x52, 0x6f, 0x6f, 0x77, 0x65, 0x3b,
0x48, 0x61, 0x6d, 0x75, 0x73, 0x65, 0x3b, 0x41, 0x72, 0x62, 0x65, 0x3b, 0x51, 0x69, 0x64, 0x61, 0x61, 0x6d, 0x65, 0x3b,
0x53, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x52, 0x3b, 0x48, 0x3b, 0x41, 0x3b, 0x51, 0x3b, 0x6e, 0x69, 0x79, 0x3b, 0x70, 0x79,
0x144, 0x3b, 0x77, 0x74, 0x6f, 0x3b, 0x73, 0x74, 0x72, 0x3b, 0x73, 0x7a, 0x74, 0x3b, 0x70, 0x69, 0x14d, 0x3b, 0x73, 0x6f,
0x62, 0x3b, 0x6e, 0x69, 0x79, 0x64, 0x7a, 0x69, 0x65, 0x6c, 0x61, 0x3b, 0x70, 0x79, 0x144, 0x64, 0x7a, 0x69, 0x61, 0x142,
0x65, 0x6b, 0x3b, 0x77, 0x74, 0x6f, 0x72, 0x65, 0x6b, 0x3b, 0x73, 0x74, 0x72, 0x7a, 0x6f, 0x64, 0x61, 0x3b, 0x73, 0x7a,
0x74, 0x77, 0x6f, 0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0x69, 0x14d, 0x6e, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f,
0x74, 0x61, 0x3b, 0x622, 0x686, 0x631, 0x3b, 0x633, 0x648, 0x645, 0x631, 0x3b, 0x627, 0x6b1, 0x627, 0x631, 0x648, 0x3b, 0x627, 0x631,
0x628, 0x639, 0x3b, 0x62e, 0x645, 0x64a, 0x633, 0x3b, 0x62c, 0x645, 0x639, 0x648, 0x3b, 0x687, 0x646, 0x687, 0x631, 0x3b, 0x622, 0x686,
0x631, 0x3b, 0x633, 0x648, 0x3b, 0x627, 0x6b1, 0x627, 0x631, 0x648, 0x3b, 0x627, 0x631, 0x628, 0x639, 0x3b, 0x62e, 0x645, 0x3b, 0x62c,
0x645, 0x639, 0x648, 0x3b, 0x687, 0x646, 0x687, 0x631, 0x3b, 0x906, 0x3b, 0x938, 0x942, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x927,
0x3b, 0x935, 0x93f, 0x938, 0x3b, 0x91c, 0x941, 0x3b, 0x91b, 0x902, 0x91b, 0x3b, 0x906, 0x930, 0x94d, 0x924, 0x3b, 0x938, 0x942, 0x3b,
0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x952, 0x927, 0x3b, 0x935, 0x93f, 0x938, 0x3b, 0x91c, 0x941, 0x92e, 0x3b, 0x91b, 0x902, 0x91b, 0x3b,
0x906, 0x3b, 0x938, 0x942, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x952, 0x3b, 0x935, 0x93f, 0x3b, 0x91c, 0x941, 0x3b, 0x91b, 0x902,
0x3b, 0x906, 0x930, 0x94d, 0x924, 0x3b, 0x938, 0x942, 0x3b, 0x92e, 0x902, 0x917, 0x3b, 0x92c, 0x941, 0x952, 0x927, 0x3b, 0x935, 0x93f,
0x938, 0x3b, 0x91c, 0x941, 0x92e, 0x3b, 0x91b, 0x902, 0x91b, 0x3b, 0x906, 0x930, 0x94d, 0x924, 0x935, 0x93e, 0x930, 0x3b, 0x938, 0x942,
0x92e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x941, 0x3b, 0x92c, 0x941, 0x952, 0x927, 0x930, 0x3b, 0x935, 0x93f, 0x938, 0x94d, 0x92a,
0x924, 0x3b, 0x91c, 0x941, 0x92e, 0x94b, 0x3b, 0x91b, 0x902, 0x91b, 0x930, 0x3b, 0xd89, 0xdbb, 0xdd2, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdb3,
0xdd4, 0xdaf, 0xdcf, 0x3b, 0xd85, 0xd9f, 0xdc4, 0x3b, 0xdb6, 0xdaf, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb, 0xdc4, 0xdc3,
0xdca, 0x3b, 0xdc3, 0xdd2, 0xd9a, 0xdd4, 0x3b, 0xdc3, 0xdd9, 0xdb1, 0x3b, 0xd89, 0xdbb, 0xdd2, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdb3, 0xdd4,
0xdaf, 0xdcf, 0x3b, 0xd85, 0xd9f, 0xdc4, 0xdbb, 0xdd4, 0xdc0, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdaf, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6,
0xdca, 0x200d, 0xdbb, 0xdc4, 0xdc3, 0xdca, 0xdb4, 0xdad, 0xdd2, 0xdb1, 0xdca, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdd2, 0xd9a, 0xdd4, 0xdbb, 0xdcf,
0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdd9, 0xdb1, 0xdc3, 0xdd4, 0xdbb, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xd89, 0x3b, 0xdc3, 0x3b, 0xd85, 0x3b, 0xdb6,
0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb, 0x3b, 0xdc3, 0xdd2, 0x3b, 0xdc3, 0xdd9, 0x3b, 0x6e, 0x65, 0x3b, 0x70, 0x6f, 0x3b, 0x75, 0x74,
0x3b, 0x73, 0x74, 0x3b, 0x161, 0x74, 0x3b, 0x70, 0x69, 0x3b, 0x73, 0x6f, 0x3b, 0x6e, 0x65, 0x64, 0x65, 0x13e, 0x61, 0x3b,
0x70, 0x6f, 0x6e, 0x64, 0x65, 0x6c, 0x6f, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x6f, 0x6b, 0x3b, 0x73, 0x74, 0x72, 0x65,
0x64, 0x61, 0x3b, 0x161, 0x74, 0x76, 0x72, 0x74, 0x6f, 0x6b, 0x3b, 0x70, 0x69, 0x61, 0x74, 0x6f, 0x6b, 0x3b, 0x73, 0x6f,
0x62, 0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x75, 0x3b, 0x73, 0x3b, 0x161, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x6e,
0x65, 0x64, 0x2e, 0x3b, 0x70, 0x6f, 0x6e, 0x2e, 0x3b, 0x74, 0x6f, 0x72, 0x2e, 0x3b, 0x73, 0x72, 0x65, 0x2e, 0x3b, 0x10d,
0x65, 0x74, 0x2e, 0x3b, 0x70, 0x65, 0x74, 0x2e, 0x3b, 0x73, 0x6f, 0x62, 0x2e, 0x3b, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a,
0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x65, 0x6b, 0x3b, 0x74, 0x6f, 0x72, 0x65, 0x6b, 0x3b, 0x73,
0x72, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x65, 0x74, 0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x65, 0x6b, 0x3b, 0x73,
0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x10d, 0x3b, 0x70, 0x3b, 0x73, 0x3b,
0x53, 0x61, 0x62, 0x69, 0x3b, 0x42, 0x61, 0x6c, 0x61, 0x3b, 0x4b, 0x75, 0x62, 0x69, 0x3b, 0x4b, 0x75, 0x73, 0x61, 0x3b,
0x4b, 0x75, 0x6e, 0x61, 0x3b, 0x4b, 0x75, 0x74, 0x61, 0x3b, 0x4d, 0x75, 0x6b, 0x61, 0x3b, 0x53, 0x61, 0x62, 0x69, 0x69,
0x74, 0x69, 0x3b, 0x42, 0x61, 0x6c, 0x61, 0x7a, 0x61, 0x3b, 0x4f, 0x77, 0x6f, 0x6b, 0x75, 0x62, 0x69, 0x6c, 0x69, 0x3b,
0x4f, 0x77, 0x6f, 0x6b, 0x75, 0x73, 0x61, 0x74, 0x75, 0x3b, 0x4f, 0x6c, 0x6f, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x4f, 0x6c,
0x6f, 0x6b, 0x75, 0x74, 0x61, 0x61, 0x6e, 0x75, 0x3b, 0x4f, 0x6c, 0x6f, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b,
0x53, 0x3b, 0x42, 0x3b, 0x42, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x41, 0x78, 0x64, 0x3b, 0x49, 0x73,
0x6e, 0x3b, 0x54, 0x6c, 0x64, 0x6f, 0x3b, 0x41, 0x72, 0x62, 0x63, 0x3b, 0x4b, 0x68, 0x6d, 0x73, 0x3b, 0x4a, 0x6d, 0x63,
0x3b, 0x53, 0x62, 0x74, 0x69, 0x3b, 0x41, 0x78, 0x61, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x69, 0x69, 0x6e, 0x3b, 0x54, 0x61,
0x6c, 0x61, 0x61, 0x64, 0x6f, 0x3b, 0x41, 0x72, 0x62, 0x61, 0x63, 0x6f, 0x3b, 0x4b, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73,
0x3b, 0x4a, 0x69, 0x6d, 0x63, 0x6f, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x69, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x54, 0x3b, 0x41,
0x3b, 0x4b, 0x68, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x76, 0x75, 0x3b, 0x42, 0x69, 0x6c, 0x3b,
0x54, 0x68, 0x61, 0x3b, 0x4e, 0x65, 0x3b, 0x48, 0x6c, 0x61, 0x3b, 0x47, 0x71, 0x69, 0x3b, 0x75, 0x53, 0x6f, 0x6e, 0x74,
0x6f, 0x3b, 0x75, 0x4d, 0x76, 0x75, 0x6c, 0x6f, 0x3b, 0x75, 0x4c, 0x65, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4c,
0x65, 0x73, 0x69, 0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x75, 0x4c, 0x65, 0x73, 0x69, 0x6e, 0x65, 0x3b, 0x6e, 0x67,
0x6f, 0x4c, 0x65, 0x73, 0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x75, 0x6d, 0x47, 0x71, 0x69, 0x62, 0x65, 0x6c, 0x6f,
0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x6d, 0x61, 0x3b, 0x42, 0x65, 0x64, 0x3b, 0x52, 0x61, 0x72, 0x3b, 0x4e, 0x65, 0x3b,
0x48, 0x6c, 0x61, 0x3b, 0x4d, 0x6f, 0x71, 0x3b, 0x53, 0x6f, 0x6e, 0x74, 0x61, 0x68, 0x61, 0x3b, 0x4d, 0x6d, 0x61, 0x6e,
0x74, 0x61, 0x68, 0x61, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x62, 0x65, 0x64, 0x69, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x72, 0x61,
0x72, 0x75, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x6e, 0x65, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x68, 0x6c, 0x61, 0x6e, 0x65, 0x3b,
0x4d, 0x6f, 0x71, 0x65, 0x62, 0x65, 0x6c, 0x6f, 0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72,
0x3b, 0x6d, 0x69, 0xe9, 0x3b, 0x6a, 0x75, 0x65, 0x3b, 0x76, 0x69, 0x65, 0x3b, 0x73, 0xe1, 0x62, 0x3b, 0x64, 0x6f, 0x6d,
0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x6c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x6d, 0x69,
0xe9, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b, 0x6a, 0x75, 0x65, 0x76, 0x65, 0x73, 0x3b, 0x76, 0x69, 0x65, 0x72, 0x6e,
0x65, 0x73, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x2d30, 0x2d59, 0x2d30, 0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x3b, 0x2d30, 0x2d59,
0x2d49, 0x3b, 0x2d30, 0x2d3d, 0x2d55, 0x3b, 0x2d30, 0x2d3d, 0x2d61, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4e, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x3b,
0x2d30, 0x2d59, 0x2d30, 0x2d4e, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4f, 0x2d30, 0x2d59, 0x3b,
0x2d30, 0x2d3d, 0x2d55, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4e, 0x2d61, 0x2d30, 0x2d59, 0x3b,
0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x2d62, 0x2d30, 0x2d59, 0x3b, 0x4d, 0x6e, 0x67, 0x3b, 0x53, 0x65, 0x6e, 0x3b, 0x53, 0x61, 0x6c, 0x3b,
0x52, 0x65, 0x62, 0x3b, 0x4b, 0x65, 0x6d, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x70, 0x3b, 0x4d, 0x69, 0x6e, 0x67,
0x67, 0x75, 0x3b, 0x53, 0x65, 0x6e, 0xe9, 0x6e, 0x3b, 0x53, 0x61, 0x6c, 0x61, 0x73, 0x61, 0x3b, 0x52, 0x65, 0x62, 0x6f,
0x3b, 0x4b, 0x65, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x68, 0x3b, 0x53, 0x61, 0x70, 0x74, 0x75, 0x3b,
0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x73, 0x6f, 0x3b, 0x42, 0x69, 0x6c, 0x3b, 0x54, 0x73, 0x61, 0x3b, 0x4e, 0x65, 0x3b, 0x48,
0x6c, 0x61, 0x3b, 0x4d, 0x67, 0x63, 0x3b, 0x4c, 0x69, 0x73, 0x6f, 0x6e, 0x74, 0x66, 0x6f, 0x3b, 0x75, 0x4d, 0x73, 0x6f,
0x6d, 0x62, 0x75, 0x6c, 0x75, 0x6b, 0x6f, 0x3b, 0x4c, 0x65, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4c, 0x65, 0x73,
0x69, 0x74, 0x73, 0x61, 0x74, 0x66, 0x75, 0x3b, 0x4c, 0x65, 0x73, 0x69, 0x6e, 0x65, 0x3b, 0x4c, 0x65, 0x73, 0x69, 0x68,
0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x75, 0x4d, 0x67, 0x63, 0x69, 0x62, 0x65, 0x6c, 0x6f, 0x3b, 0x73, 0xf6, 0x6e, 0x3b, 0x6d,
0xe5, 0x6e, 0x3b, 0x74, 0x69, 0x73, 0x3b, 0x6f, 0x6e, 0x73, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x3b, 0x66, 0x72, 0x65, 0x3b,
0x6c, 0xf6, 0x72, 0x3b, 0x73, 0xf6, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0xe5, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x69,
0x73, 0x64, 0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b,
0x66, 0x72, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c, 0xf6, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x53, 0x75, 0x2e, 0x3b, 0x4d, 0xe4,
0x2e, 0x3b, 0x5a, 0x69, 0x2e, 0x3b, 0x4d, 0x69, 0x2e, 0x3b, 0x44, 0x75, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61,
0x2e, 0x3b, 0x53, 0x75, 0x6e, 0x6e, 0x74, 0x69, 0x67, 0x3b, 0x4d, 0xe4, 0xe4, 0x6e, 0x74, 0x69, 0x67, 0x3b, 0x5a, 0x69,
0x69, 0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x3b, 0x4d, 0x69, 0x74, 0x74, 0x77, 0x75, 0x63, 0x68, 0x3b, 0x44, 0x75, 0x6e,
0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x3b, 0x46, 0x72, 0x69, 0x69, 0x74, 0x69, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x63,
0x68, 0x74, 0x69, 0x67, 0x3b, 0x71a, 0x715, 0x3b, 0x72c, 0x72a, 0x71d, 0x722, 0x3b, 0x72c, 0x720, 0x72c, 0x3b, 0x710, 0x72a, 0x712,
0x725, 0x3b, 0x71a, 0x721, 0x72b, 0x3b, 0x725, 0x72a, 0x718, 0x3b, 0x72b, 0x712, 0x72c, 0x710, 0x3b, 0x71a, 0x715, 0x712, 0x72b, 0x712,
0x710, 0x3b, 0x72c, 0x72a, 0x71d, 0x722, 0x712, 0x72b, 0x712, 0x710, 0x3b, 0x72c, 0x720, 0x72c, 0x712, 0x72b, 0x712, 0x710, 0x3b, 0x710,
0x72a, 0x712, 0x725, 0x712, 0x72b, 0x712, 0x710, 0x3b, 0x71a, 0x721, 0x72b, 0x712, 0x72b, 0x712, 0x710, 0x3b, 0x725, 0x72a, 0x718, 0x712,
0x72c, 0x710, 0x3b, 0x72b, 0x712, 0x72c, 0x710, 0x3b, 0x710, 0x3b, 0x712, 0x3b, 0x713, 0x3b, 0x715, 0x3b, 0x717, 0x3b, 0x725, 0x3b,
0x72b, 0x3b, 0x2d30, 0x2d59, 0x2d30, 0x2d4e, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4f, 0x2d30,
0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d55, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d59, 0x2d49, 0x2d4e, 0x2d61, 0x2d30, 0x2d59,
0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x2d62, 0x2d30, 0x2d59, 0x3b, 0x61, 0x73, 0x61, 0x3b, 0x61, 0x79, 0x6e, 0x3b, 0x61, 0x73, 0x69,
0x3b, 0x61, 0x6b, 0x1e5b, 0x3b, 0x61, 0x6b, 0x77, 0x3b, 0x61, 0x73, 0x69, 0x6d, 0x3b, 0x61, 0x73, 0x69, 0x1e0d, 0x3b, 0x61,
0x73, 0x61, 0x6d, 0x61, 0x73, 0x3b, 0x61, 0x79, 0x6e, 0x61, 0x73, 0x3b, 0x61, 0x73, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x61,
0x6b, 0x1e5b, 0x61, 0x73, 0x3b, 0x61, 0x6b, 0x77, 0x61, 0x73, 0x3b, 0x61, 0x73, 0x69, 0x6d, 0x77, 0x61, 0x73, 0x3b, 0x61,
0x73, 0x69, 0x1e0d, 0x79, 0x61, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x4a, 0x69, 0x6d, 0x3b, 0x4b, 0x61, 0x77, 0x3b, 0x4b,
0x61, 0x64, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x4e, 0x67, 0x75, 0x3b, 0x49, 0x74, 0x75, 0x6b, 0x75,
0x20, 0x6a, 0x61, 0x20, 0x6a, 0x75, 0x6d, 0x77, 0x61, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6a,
0x69, 0x6d, 0x77, 0x65, 0x72, 0x69, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x77, 0x69,
0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x64, 0x61, 0x64, 0x75, 0x3b, 0x4b, 0x75, 0x72,
0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20,
0x6b, 0x61, 0x73, 0x61, 0x6e, 0x75, 0x3b, 0x4b, 0x69, 0x66, 0x75, 0x6c, 0x61, 0x20, 0x6e, 0x67, 0x75, 0x77, 0x6f, 0x3b,
0x4a, 0x3b, 0x4a, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x42f, 0x448, 0x431, 0x3b, 0x414, 0x448,
0x431, 0x3b, 0x421, 0x448, 0x431, 0x3b, 0x427, 0x448, 0x431, 0x3b, 0x41f, 0x448, 0x431, 0x3b, 0x4b6, 0x43c, 0x44a, 0x3b, 0x428, 0x43d,
0x431, 0x3b, 0x42f, 0x43a, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x414, 0x443, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x421, 0x435,
0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x427, 0x43e, 0x440, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x41f, 0x430, 0x43d, 0x4b7, 0x448,
0x430, 0x43d, 0x431, 0x435, 0x3b, 0x4b6, 0x443, 0x43c, 0x44a, 0x430, 0x3b, 0x428, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x42f, 0x3b, 0x414,
0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x4b6, 0x3b, 0x428, 0x3b, 0xb9e, 0xbbe, 0xbaf, 0xbbf, 0x2e, 0x3b, 0xba4, 0xbbf, 0xb99,
0xbcd, 0x2e, 0x3b, 0xb9a, 0xbc6, 0xbb5, 0xbcd, 0x2e, 0x3b, 0xbaa, 0xbc1, 0xba4, 0x2e, 0x3b, 0xbb5, 0xbbf, 0xbaf, 0xbbe, 0x2e, 0x3b,
0xbb5, 0xbc6, 0xbb3, 0xbcd, 0x2e, 0x3b, 0xb9a, 0xba9, 0xbbf, 0x3b, 0xb9e, 0xbbe, 0xbaf, 0xbbf, 0xbb1, 0xbc1, 0x3b, 0xba4, 0xbbf, 0xb99,
0xbcd, 0xb95, 0xbb3, 0xbcd, 0x3b, 0xb9a, 0xbc6, 0xbb5, 0xbcd, 0xbb5, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0xbaa, 0xbc1, 0xba4, 0xba9, 0xbcd, 0x3b,
0xbb5, 0xbbf, 0xbaf, 0xbbe, 0xbb4, 0xba9, 0xbcd, 0x3b, 0xbb5, 0xbc6, 0xbb3, 0xbcd, 0xbb3, 0xbbf, 0x3b, 0xb9a, 0xba9, 0xbbf, 0x3b, 0xb9e,
0xbbe, 0x3b, 0xba4, 0xbbf, 0x3b, 0xb9a, 0xbc6, 0x3b, 0xbaa, 0xbc1, 0x3b, 0xbb5, 0xbbf, 0x3b, 0xbb5, 0xbc6, 0x3b, 0xb9a, 0x3b, 0x45,
0x6d, 0x70, 0x3b, 0x4b, 0x69, 0x6e, 0x3b, 0x44, 0x68, 0x61, 0x3b, 0x54, 0x72, 0x75, 0x3b, 0x53, 0x70, 0x61, 0x3b, 0x52,
0x69, 0x6d, 0x3b, 0x4d, 0x61, 0x74, 0x3b, 0x4a, 0x69, 0x79, 0x61, 0x78, 0x20, 0x73, 0x6e, 0x67, 0x61, 0x79, 0x61, 0x6e,
0x3b, 0x74, 0x67, 0x4b, 0x69, 0x6e, 0x67, 0x61, 0x6c, 0x20, 0x6a, 0x69, 0x79, 0x61, 0x78, 0x20, 0x69, 0x79, 0x61, 0x78,
0x20, 0x73, 0x6e, 0x67, 0x61, 0x79, 0x61, 0x6e, 0x3b, 0x74, 0x67, 0x44, 0x68, 0x61, 0x20, 0x6a, 0x69, 0x79, 0x61, 0x78,
0x20, 0x69, 0x79, 0x61, 0x78, 0x20, 0x73, 0x6e, 0x67, 0x61, 0x79, 0x61, 0x6e, 0x3b, 0x74, 0x67, 0x54, 0x72, 0x75, 0x20,
0x6a, 0x69, 0x79, 0x61, 0x78, 0x20, 0x69, 0x79, 0x61, 0x78, 0x20, 0x73, 0x6e, 0x67, 0x61, 0x79, 0x61, 0x6e, 0x3b, 0x74,
0x67, 0x53, 0x70, 0x61, 0x63, 0x20, 0x6a, 0x69, 0x79, 0x61, 0x78, 0x20, 0x69, 0x79, 0x61, 0x78, 0x20, 0x73, 0x6e, 0x67,
0x61, 0x79, 0x61, 0x6e, 0x3b, 0x74, 0x67, 0x52, 0x69, 0x6d, 0x61, 0x20, 0x6a, 0x69, 0x79, 0x61, 0x78, 0x20, 0x69, 0x79,
0x61, 0x78, 0x20, 0x73, 0x6e, 0x67, 0x61, 0x79, 0x61, 0x6e, 0x3b, 0x74, 0x67, 0x4d, 0x61, 0x74, 0x61, 0x72, 0x75, 0x20,
0x6a, 0x69, 0x79, 0x61, 0x78, 0x20, 0x69, 0x79, 0x61, 0x78, 0x20, 0x73, 0x6e, 0x67, 0x61, 0x79, 0x61, 0x6e, 0x3b, 0x45,
0x3b, 0x4b, 0x3b, 0x44, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x4d, 0x3b, 0x44f, 0x43a, 0x448, 0x2e, 0x3b, 0x434, 0x4af,
0x448, 0x2e, 0x3b, 0x441, 0x438, 0x448, 0x2e, 0x3b, 0x447, 0x4d9, 0x440, 0x2e, 0x3b, 0x43f, 0x4d9, 0x43d, 0x497, 0x2e, 0x3b, 0x497,
0x43e, 0x43c, 0x2e, 0x3b, 0x448, 0x438, 0x43c, 0x2e, 0x3b, 0x44f, 0x43a, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x434, 0x4af, 0x448,
0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x441, 0x438, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9, 0x43c, 0x431,
0x435, 0x3b, 0x43f, 0x4d9, 0x43d, 0x497, 0x435, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x497, 0x43e, 0x43c, 0x433, 0x430, 0x3b, 0x448,
0x438, 0x43c, 0x431, 0x4d9, 0x3b, 0x42f, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x496, 0x3b, 0x428, 0x3b, 0xc06,
0xc26, 0xc3f, 0x3b, 0xc38, 0xc4b, 0xc2e, 0x3b, 0xc2e, 0xc02, 0xc17, 0xc33, 0x3b, 0xc2c, 0xc41, 0xc27, 0x3b, 0xc17, 0xc41, 0xc30, 0xc41,
0x3b, 0xc36, 0xc41, 0xc15, 0xc4d, 0xc30, 0x3b, 0xc36, 0xc28, 0xc3f, 0x3b, 0xc06, 0xc26, 0xc3f, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc38,
0xc4b, 0xc2e, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc2e, 0xc02, 0xc17, 0xc33, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc2c, 0xc41, 0xc27, 0xc35,
0xc3e, 0xc30, 0xc02, 0x3b, 0xc17, 0xc41, 0xc30, 0xc41, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc36, 0xc41, 0xc15, 0xc4d, 0xc30, 0xc35, 0xc3e,
0xc30, 0xc02, 0x3b, 0xc36, 0xc28, 0xc3f, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc06, 0x3b, 0xc38, 0xc4b, 0x3b, 0xc2e, 0x3b, 0xc2c, 0xc41,
0x3b, 0xc17, 0xc41, 0x3b, 0xc36, 0xc41, 0x3b, 0xc36, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x42, 0x61, 0x72, 0x3b, 0x41, 0x61, 0x72,
0x3b, 0x55, 0x6e, 0x69, 0x3b, 0x55, 0x6e, 0x67, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4e, 0x61, 0x6b,
0x61, 0x65, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x65, 0x62, 0x61, 0x72, 0x61, 0x73, 0x61, 0x3b, 0x4e,
0x61, 0x6b, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x75, 0x6e, 0x69, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x75,
0x6e, 0x67, 0x2019, 0x6f, 0x6e, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x6b, 0x61, 0x6e, 0x79, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x73,
0x61, 0x62, 0x69, 0x74, 0x69, 0x3b, 0x4a, 0x3b, 0x42, 0x3b, 0x41, 0x3b, 0x55, 0x3b, 0x55, 0x3b, 0x4b, 0x3b, 0x53, 0x3b,
0xe2d, 0xe32, 0x2e, 0x3b, 0xe08, 0x2e, 0x3b, 0xe2d, 0x2e, 0x3b, 0xe1e, 0x2e, 0x3b, 0xe1e, 0xe24, 0x2e, 0x3b, 0xe28, 0x2e, 0x3b,
0xe2a, 0x2e, 0x3b, 0xe27, 0xe31, 0xe19, 0xe2d, 0xe32, 0xe17, 0xe34, 0xe15, 0xe22, 0xe4c, 0x3b, 0xe27, 0xe31, 0xe19, 0xe08, 0xe31, 0xe19,
0xe17, 0xe23, 0xe4c, 0x3b, 0xe27, 0xe31, 0xe19, 0xe2d, 0xe31, 0xe07, 0xe04, 0xe32, 0xe23, 0x3b, 0xe27, 0xe31, 0xe19, 0xe1e, 0xe38, 0xe18,
0x3b, 0xe27, 0xe31, 0xe19, 0xe1e, 0xe24, 0xe2b, 0xe31, 0xe2a, 0xe1a, 0xe14, 0xe35, 0x3b, 0xe27, 0xe31, 0xe19, 0xe28, 0xe38, 0xe01, 0xe23,
0xe4c, 0x3b, 0xe27, 0xe31, 0xe19, 0xe40, 0xe2a, 0xe32, 0xe23, 0xe4c, 0x3b, 0xe2d, 0xe32, 0x3b, 0xe08, 0x3b, 0xe2d, 0x3b, 0xe1e, 0x3b,
0xe1e, 0xe24, 0x3b, 0xe28, 0x3b, 0xe2a, 0x3b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf58,
0xf72, 0xf42, 0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56,
0xf74, 0xf0b, 0x3b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f,
0xf60, 0xf0b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf42, 0xf5f,
0xf60, 0xf0b, 0xf58, 0xf72, 0xf42, 0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54,
0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf54, 0xf0b,
0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf49, 0xf72, 0x3b,
0xf5f, 0xfb3, 0x3b, 0xf58, 0xf72, 0xf42, 0x3b, 0xf63, 0xfb7, 0xf42, 0x3b, 0xf55, 0xf74, 0xf62, 0x3b, 0xf66, 0xf44, 0xf66, 0x3b, 0xf66,
0xfa4, 0xf7a, 0xf53, 0x3b, 0x1230, 0x2f, 0x12d3, 0x3b, 0x1230, 0x1296, 0x3b, 0x1273, 0x120b, 0x1238, 0x3b, 0x12a3, 0x1228, 0x122d, 0x3b, 0x12a8,
0x121a, 0x123d, 0x3b, 0x1305, 0x121d, 0x12d3, 0x3b, 0x1230, 0x2f, 0x1295, 0x3b, 0x1230, 0x1295, 0x1260, 0x1275, 0x20, 0x12d3, 0x1263, 0x12ed, 0x3b,
0x1230, 0x1296, 0x3b, 0x1273, 0x120b, 0x1238, 0x1296, 0x3b, 0x12a3, 0x1228, 0x122d, 0x1263, 0x12d3, 0x3b, 0x12a8, 0x121a, 0x123d, 0x3b, 0x1305, 0x121d,
0x12d3, 0x1275, 0x3b, 0x1230, 0x1295, 0x1260, 0x1275, 0x20, 0x1295, 0x12a2, 0x123d, 0x3b, 0x1230, 0x3b, 0x1230, 0x3b, 0x1273, 0x3b, 0x12a3, 0x3b,
0x12a8, 0x3b, 0x1305, 0x3b, 0x1230, 0x3b, 0x1230, 0x1295, 0x3b, 0x1230, 0x1291, 0x3b, 0x1230, 0x1209, 0x3b, 0x1228, 0x1261, 0x3b, 0x1213, 0x1219,
0x3b, 0x12d3, 0x122d, 0x3b, 0x1240, 0x12f3, 0x3b, 0x1230, 0x1295, 0x1260, 0x1275, 0x3b, 0x1230, 0x1291, 0x12ed, 0x3b, 0x1230, 0x1209, 0x1235, 0x3b,
0x1228, 0x1261, 0x12d5, 0x3b, 0x1213, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1262, 0x3b, 0x1240, 0x12f3, 0x121d, 0x3b, 0x1230, 0x3b, 0x1230, 0x3b,
0x1230, 0x3b, 0x1228, 0x3b, 0x1213, 0x3b, 0x12d3, 0x3b, 0x1240, 0x3b, 0x53, 0x61, 0x6e, 0x3b, 0x4d, 0x61, 0x6e, 0x3b, 0x54, 0x75,
0x6e, 0x3b, 0x54, 0x72, 0x69, 0x3b, 0x46, 0x6f, 0x6e, 0x3b, 0x46, 0x72, 0x61, 0x3b, 0x53, 0x61, 0x72, 0x3b, 0x53, 0x61,
0x6e, 0x64, 0x65, 0x3b, 0x4d, 0x61, 0x6e, 0x64, 0x65, 0x3b, 0x54, 0x75, 0x6e, 0x64, 0x65, 0x3b, 0x54, 0x72, 0x69, 0x6e,
0x64, 0x65, 0x3b, 0x46, 0x6f, 0x6e, 0x64, 0x65, 0x3b, 0x46, 0x72, 0x61, 0x69, 0x64, 0x65, 0x3b, 0x53, 0x61, 0x72, 0x65,
0x72, 0x65, 0x3b, 0x53, 0x101, 0x70, 0x3b, 0x4d, 0x14d, 0x6e, 0x3b, 0x54, 0x16b, 0x73, 0x3b, 0x50, 0x75, 0x6c, 0x3b, 0x54,
0x75, 0x2bb, 0x61, 0x3b, 0x46, 0x61, 0x6c, 0x3b, 0x54, 0x6f, 0x6b, 0x3b, 0x53, 0x101, 0x70, 0x61, 0x74, 0x65, 0x3b, 0x4d,
0x14d, 0x6e, 0x69, 0x74, 0x65, 0x3b, 0x54, 0x16b, 0x73, 0x69, 0x74, 0x65, 0x3b, 0x50, 0x75, 0x6c, 0x65, 0x6c, 0x75, 0x6c,
0x75, 0x3b, 0x54, 0x75, 0x2bb, 0x61, 0x70, 0x75, 0x6c, 0x65, 0x6c, 0x75, 0x6c, 0x75, 0x3b, 0x46, 0x61, 0x6c, 0x61, 0x69,
0x74, 0x65, 0x3b, 0x54, 0x6f, 0x6b, 0x6f, 0x6e, 0x61, 0x6b, 0x69, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x50, 0x3b,
0x54, 0x3b, 0x46, 0x3b, 0x54, 0x3b, 0x627, 0x6cc, 0x6a9, 0x634, 0x6cc, 0x645, 0x6d2, 0x3b, 0x62f, 0x64f, 0x648, 0x634, 0x6cc, 0x645,
0x6d2, 0x3b, 0x6af, 0x6be, 0x646, 0x20, 0x622, 0x646, 0x6af, 0x627, 0x3b, 0x686, 0x627, 0x631, 0x634, 0x6cc, 0x645, 0x6d2, 0x3b, 0x67e,
0x64e, 0x626, 0x20, 0x634, 0x6cc, 0x645, 0x6d2, 0x3b, 0x634, 0x64f, 0x648, 0x6af, 0x627, 0x631, 0x3b, 0x644, 0x64e, 0x648, 0x20, 0x622,
0x646, 0x6af, 0x627, 0x3b, 0x627, 0x3b, 0x62f, 0x3b, 0x6af, 0x3b, 0x686, 0x3b, 0x67e, 0x3b, 0x634, 0x3b, 0x644, 0x3b, 0x53, 0x6f,
0x6e, 0x3b, 0x4d, 0x75, 0x73, 0x3b, 0x42, 0x69, 0x72, 0x3b, 0x48, 0x61, 0x72, 0x3b, 0x4e, 0x65, 0x3b, 0x54, 0x6c, 0x68,
0x3b, 0x4d, 0x75, 0x67, 0x3b, 0x53, 0x6f, 0x6e, 0x74, 0x61, 0x3b, 0x4d, 0x75, 0x73, 0x75, 0x6d, 0x62, 0x68, 0x75, 0x6e,
0x75, 0x6b, 0x75, 0x3b, 0x52, 0x61, 0x76, 0x75, 0x6d, 0x62, 0x69, 0x72, 0x68, 0x69, 0x3b, 0x52, 0x61, 0x76, 0x75, 0x6e,
0x68, 0x61, 0x72, 0x68, 0x75, 0x3b, 0x52, 0x61, 0x76, 0x75, 0x6d, 0x75, 0x6e, 0x65, 0x3b, 0x52, 0x61, 0x76, 0x75, 0x6e,
0x74, 0x6c, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x75, 0x67, 0x71, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x3b, 0x54, 0x73, 0x68,
0x3b, 0x4d, 0x6f, 0x73, 0x3b, 0x4c, 0x61, 0x62, 0x62, 0x3b, 0x4c, 0x61, 0x62, 0x72, 0x3b, 0x4c, 0x61, 0x62, 0x6e, 0x3b,
0x4c, 0x61, 0x62, 0x74, 0x3b, 0x4d, 0x61, 0x74, 0x3b, 0x54, 0x73, 0x68, 0x69, 0x70, 0x69, 0x3b, 0x4d, 0x6f, 0x73, 0x6f,
0x70, 0x75, 0x6c, 0x6f, 0x67, 0x6f, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x62, 0x65, 0x64, 0x69, 0x3b, 0x4c, 0x61, 0x62, 0x6f,
0x72, 0x61, 0x72, 0x6f, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x6e, 0x65, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x74, 0x6c, 0x68, 0x61,
0x6e, 0x6f, 0x3b, 0x4d, 0x61, 0x74, 0x6c, 0x68, 0x61, 0x74, 0x73, 0x6f, 0x3b, 0x50, 0x61, 0x7a, 0x3b, 0x50, 0x7a, 0x74,
0x3b, 0x53, 0x61, 0x6c, 0x3b, 0xc7, 0x61, 0x72, 0x3b, 0x50, 0x65, 0x72, 0x3b, 0x43, 0x75, 0x6d, 0x3b, 0x43, 0x6d, 0x74,
0x3b, 0x50, 0x61, 0x7a, 0x61, 0x72, 0x3b, 0x50, 0x61, 0x7a, 0x61, 0x72, 0x74, 0x65, 0x73, 0x69, 0x3b, 0x53, 0x61, 0x6c,
0x131, 0x3b, 0xc7, 0x61, 0x72, 0x15f, 0x61, 0x6d, 0x62, 0x61, 0x3b, 0x50, 0x65, 0x72, 0x15f, 0x65, 0x6d, 0x62, 0x65, 0x3b,
0x43, 0x75, 0x6d, 0x61, 0x3b, 0x43, 0x75, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x69, 0x3b, 0x50, 0x3b, 0x50, 0x3b, 0x53,
0x3b, 0xc7, 0x3b, 0x50, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0xdd, 0x65, 0x6b, 0x3b, 0x44, 0x75, 0x15f, 0x3b, 0x53, 0x69, 0x15f,
0x3b, 0xc7, 0x61, 0x72, 0x3b, 0x50, 0x65, 0x6e, 0x3b, 0x41, 0x6e, 0x6e, 0x3b, 0x15e, 0x65, 0x6e, 0x3b, 0xdd, 0x65, 0x6b,
0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x44, 0x75, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x53, 0x69, 0x15f, 0x65, 0x6e, 0x62,
0x65, 0x3b, 0xc7, 0x61, 0x72, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x50, 0x65, 0x6e, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b,
0x41, 0x6e, 0x6e, 0x61, 0x3b, 0x15e, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0xdd, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0xc7, 0x3b, 0x50,
0x3b, 0x41, 0x3b, 0x15e, 0x3b, 0xfd, 0x65, 0x6b, 0x3b, 0x64, 0x75, 0x15f, 0x3b, 0x73, 0x69, 0x15f, 0x3b, 0xe7, 0x61, 0x72,
0x3b, 0x70, 0x65, 0x6e, 0x3b, 0x61, 0x6e, 0x6e, 0x3b, 0x15f, 0x65, 0x6e, 0x3b, 0xfd, 0x65, 0x6b, 0x15f, 0x65, 0x6e, 0x62,
0x65, 0x3b, 0x64, 0x75, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x73, 0x69, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0xe7, 0x61,
0x72, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x70, 0x65, 0x6e, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x61, 0x6e, 0x6e, 0x61,
0x3b, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x4c, 0x61, 0x64, 0x3b, 0x54, 0x61, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x4c,
0x61, 0x72, 0x3b, 0x4c, 0x61, 0x6d, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x41, 0x73, 0x61, 0x3b, 0x4c, 0x61, 0x64, 0x69, 0x3b,
0x54, 0x61, 0x6e, 0x69, 0x69, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x4c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x4c,
0x61, 0x6d, 0x69, 0x74, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x61, 0x74, 0x3b, 0x43d, 0x435, 0x434,
0x456, 0x43b, 0x44f, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x456, 0x43b, 0x43e, 0x43a, 0x3b, 0x432, 0x456, 0x432, 0x442, 0x43e, 0x440,
0x43e, 0x43a, 0x3b, 0x441, 0x435, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x435, 0x440, 0x3b, 0x43f, 0x2bc, 0x44f,
0x442, 0x43d, 0x438, 0x446, 0x44f, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x6e, 0x6a, 0x65, 0x3b, 0x70, 0xf3, 0x6e,
0x3b, 0x77, 0x75, 0x74, 0x3b, 0x73, 0x72, 0x6a, 0x3b, 0x161, 0x74, 0x77, 0x3b, 0x70, 0x6a, 0x61, 0x3b, 0x73, 0x6f, 0x62,
0x3b, 0x6e, 0x6a, 0x65, 0x64, 0x17a, 0x65, 0x6c, 0x61, 0x3b, 0x70, 0xf3, 0x6e, 0x64, 0x17a, 0x65, 0x6c, 0x61, 0x3b, 0x77,
0x75, 0x74, 0x6f, 0x72, 0x61, 0x3b, 0x73, 0x72, 0x6a, 0x65, 0x64, 0x61, 0x3b, 0x161, 0x74, 0x77, 0xf3, 0x72, 0x74, 0x6b,
0x3b, 0x70, 0x6a, 0x61, 0x74, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x77, 0x3b,
0x73, 0x3b, 0x161, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x627, 0x62a, 0x648, 0x627, 0x631, 0x3b, 0x67e, 0x6cc, 0x631, 0x3b, 0x645, 0x646,
0x6af, 0x644, 0x3b, 0x628, 0x62f, 0x6be, 0x3b, 0x62c, 0x645, 0x639, 0x631, 0x627, 0x62a, 0x3b, 0x62c, 0x645, 0x639, 0x6c1, 0x3b, 0x6c1,
0x641, 0x62a, 0x6c1, 0x3b, 0x64a, 0x6d5, 0x3b, 0x62f, 0x6c8, 0x3b, 0x633, 0x6d5, 0x3b, 0x686, 0x627, 0x3b, 0x67e, 0x6d5, 0x3b, 0x62c,
0x6c8, 0x3b, 0x634, 0x6d5, 0x3b, 0x64a, 0x6d5, 0x643, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x62f, 0x6c8, 0x634, 0x6d5, 0x646, 0x628,
0x6d5, 0x3b, 0x633, 0x6d5, 0x64a, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x686, 0x627, 0x631, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b,
0x67e, 0x6d5, 0x64a, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x62c, 0x6c8, 0x645, 0x6d5, 0x3b, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b,
0x64a, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b, 0x67e, 0x3b, 0x62c, 0x3b, 0x634, 0x3b, 0x59, 0x61, 0x6b, 0x3b, 0x44, 0x75,
0x73, 0x68, 0x3b, 0x53, 0x65, 0x73, 0x68, 0x3b, 0x43, 0x68, 0x6f, 0x72, 0x3b, 0x50, 0x61, 0x79, 0x3b, 0x4a, 0x75, 0x6d,
0x3b, 0x53, 0x68, 0x61, 0x6e, 0x3b, 0x79, 0x61, 0x6b, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x64, 0x75, 0x73, 0x68,
0x61, 0x6e, 0x62, 0x61, 0x3b, 0x73, 0x65, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x63, 0x68, 0x6f, 0x72, 0x73, 0x68,
0x61, 0x6e, 0x62, 0x61, 0x3b, 0x70, 0x61, 0x79, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x3b,
0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x59, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x4a, 0x3b, 0x53,
0x3b, 0x6cc, 0x2e, 0x3b, 0x62f, 0x2e, 0x3b, 0x633, 0x2e, 0x3b, 0x686, 0x2e, 0x3b, 0x67e, 0x2e, 0x3b, 0x62c, 0x2e, 0x3b, 0x634,
0x2e, 0x3b, 0x44f, 0x43a, 0x448, 0x3b, 0x434, 0x443, 0x448, 0x3b, 0x441, 0x435, 0x448, 0x3b, 0x447, 0x43e, 0x440, 0x3b, 0x43f, 0x430,
0x439, 0x3b, 0x436, 0x443, 0x43c, 0x3b, 0x448, 0x430, 0x43d, 0x3b, 0x44f, 0x43a, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x434, 0x443,
0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x441, 0x435, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x447, 0x43e, 0x440, 0x448, 0x430, 0x43d,
0x431, 0x430, 0x3b, 0x43f, 0x430, 0x439, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x436, 0x443, 0x43c, 0x430, 0x3b, 0x448, 0x430, 0x43d,
0x431, 0x430, 0x3b, 0x42f, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x416, 0x3b, 0x428, 0x3b, 0xa55e, 0xa54c, 0xa535,
0x3b, 0xa5f3, 0xa5e1, 0xa609, 0x3b, 0xa55a, 0xa55e, 0xa55a, 0x3b, 0xa549, 0xa55e, 0xa552, 0x3b, 0xa549, 0xa524, 0xa546, 0xa562, 0x3b, 0xa549, 0xa524,
0xa540, 0xa56e, 0x3b, 0xa53b, 0xa52c, 0xa533, 0x3b, 0x6c, 0x61, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x74, 0x25b, 0x25b, 0x6e, 0x25b, 0x25b,
0x3b, 0x74, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x61, 0x6c, 0x61, 0x62, 0x61, 0x3b, 0x61, 0x69, 0x6d, 0x69, 0x73, 0x61,
0x3b, 0x61, 0x69, 0x6a, 0x69, 0x6d, 0x61, 0x3b, 0x73, 0x69, 0x253, 0x69, 0x74, 0x69, 0x3b, 0x53, 0x77, 0x6f, 0x3b, 0x4d,
0x75, 0x73, 0x3b, 0x56, 0x68, 0x69, 0x3b, 0x52, 0x61, 0x72, 0x3b, 0x1e4a, 0x61, 0x3b, 0x1e70, 0x61, 0x6e, 0x3b, 0x4d, 0x75,
0x67, 0x3b, 0x53, 0x77, 0x6f, 0x6e, 0x64, 0x61, 0x68, 0x61, 0x3b, 0x4d, 0x75, 0x73, 0x75, 0x6d, 0x62, 0x75, 0x6c, 0x75,
0x77, 0x6f, 0x3b, 0x1e3c, 0x61, 0x76, 0x68, 0x75, 0x76, 0x68, 0x69, 0x6c, 0x69, 0x3b, 0x1e3c, 0x61, 0x76, 0x68, 0x75, 0x72,
0x61, 0x72, 0x75, 0x3b, 0x1e3c, 0x61, 0x76, 0x68, 0x75, 0x1e4b, 0x61, 0x3b, 0x1e3c, 0x61, 0x76, 0x68, 0x75, 0x1e71, 0x61, 0x6e,
0x75, 0x3b, 0x4d, 0x75, 0x67, 0x69, 0x76, 0x68, 0x65, 0x6c, 0x61, 0x3b, 0x43, 0x4e, 0x3b, 0x54, 0x68, 0x20, 0x32, 0x3b,
0x54, 0x68, 0x20, 0x33, 0x3b, 0x54, 0x68, 0x20, 0x34, 0x3b, 0x54, 0x68, 0x20, 0x35, 0x3b, 0x54, 0x68, 0x20, 0x36, 0x3b,
0x54, 0x68, 0x20, 0x37, 0x3b, 0x43, 0x68, 0x1ee7, 0x20, 0x4e, 0x68, 0x1ead, 0x74, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x48, 0x61,
0x69, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x42, 0x61, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x54, 0x1b0, 0x3b, 0x54, 0x68, 0x1ee9, 0x20,
0x4e, 0x103, 0x6d, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x53, 0xe1, 0x75, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x42, 0x1ea3, 0x79, 0x3b,
0x43, 0x4e, 0x3b, 0x54, 0x32, 0x3b, 0x54, 0x33, 0x3b, 0x54, 0x34, 0x3b, 0x54, 0x35, 0x3b, 0x54, 0x36, 0x3b, 0x54, 0x37,
0x3b, 0x53, 0x75, 0x3b, 0x4d, 0x75, 0x3b, 0x54, 0x75, 0x3b, 0x56, 0x65, 0x3b, 0x44, 0xf6, 0x3b, 0x46, 0x72, 0x3b, 0x5a,
0xe4, 0x3b, 0x73, 0x75, 0x64, 0x65, 0x6c, 0x3b, 0x6d, 0x75, 0x64, 0x65, 0x6c, 0x3b, 0x74, 0x75, 0x64, 0x65, 0x6c, 0x3b,
0x76, 0x65, 0x64, 0x65, 0x6c, 0x3b, 0x64, 0xf6, 0x64, 0x65, 0x6c, 0x3b, 0x66, 0x72, 0x69, 0x64, 0x65, 0x6c, 0x3b, 0x7a,
0xe4, 0x64, 0x65, 0x6c, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x56, 0x3b, 0x44, 0x3b, 0x46, 0x3b, 0x5a, 0x3b, 0x73,
0x75, 0x2e, 0x3b, 0x6d, 0x75, 0x2e, 0x3b, 0x74, 0x75, 0x2e, 0x3b, 0x76, 0x65, 0x2e, 0x3b, 0x64, 0xf6, 0x2e, 0x3b, 0x66,
0x72, 0x2e, 0x3b, 0x7a, 0xe4, 0x2e, 0x3b, 0x53, 0x75, 0x6e, 0x3b, 0x4d, 0xe4, 0x6e, 0x3b, 0x5a, 0x69, 0x161, 0x3b, 0x4d,
0x69, 0x74, 0x3b, 0x46, 0x72, 0xf3, 0x3b, 0x46, 0x72, 0x69, 0x3b, 0x53, 0x61, 0x6d, 0x3b, 0x53, 0x75, 0x6e, 0x6e, 0x74,
0x61, 0x67, 0x3b, 0x4d, 0xe4, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x5a, 0x69, 0x161, 0x74, 0x61, 0x67, 0x3b, 0x4d, 0x69, 0x74,
0x74, 0x77, 0x75, 0x10d, 0x3b, 0x46, 0x72, 0xf3, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x46, 0x72, 0x69, 0x74, 0x61, 0x67, 0x3b,
0x53, 0x61, 0x6d, 0x161, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0x4d, 0x3b, 0x46, 0x3b, 0x46, 0x3b,
0x53, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x6c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x4d, 0x65, 0x72, 0x3b, 0x49,
0x61, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x53, 0x75, 0x6c, 0x3b,
0x44, 0x79, 0x64, 0x64, 0x20, 0x4c, 0x6c, 0x75, 0x6e, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x4d, 0x61, 0x77, 0x72, 0x74,
0x68, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x65, 0x72, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20,
0x49, 0x61, 0x75, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x44, 0x79, 0x64, 0x64,
0x20, 0x53, 0x61, 0x64, 0x77, 0x72, 0x6e, 0x3b, 0x53, 0x3b, 0x4c, 0x6c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x47,
0x3b, 0x53, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x6c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x4d, 0x65, 0x72, 0x3b,
0x49, 0x61, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x73, 0x69, 0x3b, 0x6d, 0x6f, 0x3b, 0x74,
0x69, 0x3b, 0x77, 0x6f, 0x3b, 0x74, 0x6f, 0x3b, 0x66, 0x72, 0x3b, 0x73, 0x6f, 0x3b, 0x73, 0x6e, 0x65, 0x69, 0x6e, 0x3b,
0x6d, 0x6f, 0x61, 0x6e, 0x64, 0x65, 0x69, 0x3b, 0x74, 0x69, 0x69, 0x73, 0x64, 0x65, 0x69, 0x3b, 0x77, 0x6f, 0x61, 0x6e,
0x73, 0x64, 0x65, 0x69, 0x3b, 0x74, 0x6f, 0x6e, 0x67, 0x65, 0x72, 0x73, 0x64, 0x65, 0x69, 0x3b, 0x66, 0x72, 0x65, 0x65,
0x64, 0x3b, 0x73, 0x6e, 0x65, 0x6f, 0x6e, 0x3b, 0x12c8, 0x130b, 0x3b, 0x1233, 0x12ed, 0x1296, 0x3b, 0x121b, 0x1246, 0x1233, 0x129b, 0x3b,
0x12a0, 0x1229, 0x12cb, 0x3b, 0x1203, 0x1219, 0x1233, 0x3b, 0x12a0, 0x122d, 0x1263, 0x3b, 0x1244, 0x122b, 0x3b, 0x12c8, 0x3b, 0x1233, 0x3b, 0x121b,
0x3b, 0x12a0, 0x3b, 0x1203, 0x3b, 0x12a0, 0x3b, 0x1244, 0x3b, 0x44, 0x69, 0x62, 0x3b, 0x41, 0x6c, 0x74, 0x3b, 0x54, 0x61, 0x6c,
0x3b, 0xc0, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x78, 0x3b, 0xc0, 0x6a, 0x6a, 0x3b, 0x41, 0x73, 0x65, 0x3b, 0x44, 0x69, 0x62,
0xe9, 0x65, 0x72, 0x3b, 0x41, 0x6c, 0x74, 0x69, 0x6e, 0x65, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x61, 0x74, 0x61, 0x3b, 0xc0,
0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x78, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0xc0, 0x6a, 0x6a, 0x75, 0x6d, 0x61,
0x3b, 0x41, 0x73, 0x65, 0x65, 0x72, 0x3b, 0x43, 0x61, 0x77, 0x3b, 0x4d, 0x76, 0x75, 0x3b, 0x42, 0x69, 0x6e, 0x3b, 0x54,
0x68, 0x61, 0x3b, 0x53, 0x69, 0x6e, 0x3b, 0x48, 0x6c, 0x61, 0x3b, 0x4d, 0x67, 0x71, 0x3b, 0x43, 0x61, 0x77, 0x65, 0x3b,
0x4d, 0x76, 0x75, 0x6c, 0x6f, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x62, 0x69, 0x6e, 0x69, 0x3b, 0x4c, 0x77, 0x65, 0x73,
0x69, 0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x6e, 0x65, 0x3b, 0x4c, 0x77, 0x65, 0x73,
0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x67, 0x71, 0x69, 0x62, 0x65, 0x6c, 0x6f, 0x3b, 0x43, 0x3b, 0x4d, 0x3b,
0x53, 0x62, 0x3b, 0x53, 0x74, 0x3b, 0x53, 0x69, 0x6e, 0x3b, 0x48, 0x6c, 0x3b, 0x4d, 0x67, 0x71, 0x3b, 0x43, 0x61, 0x77,
0x3b, 0x4d, 0x76, 0x75, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x62, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x53, 0x69, 0x6e, 0x3b, 0x48,
0x6c, 0x61, 0x3b, 0x4d, 0x67, 0x71, 0x3b, 0x43, 0x3b, 0x4d, 0x3b, 0x53, 0x62, 0x3b, 0x54, 0x68, 0x74, 0x3b, 0x53, 0x69,
0x6e, 0x3b, 0x48, 0x6c, 0x3b, 0x4d, 0x67, 0x71, 0x3b, 0x73, 0x64, 0x3b, 0x6d, 0x64, 0x3b, 0x6d, 0x77, 0x3b, 0x65, 0x74,
0x3b, 0x6b, 0x6c, 0x3b, 0x66, 0x6c, 0x3b, 0x73, 0x73, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x25b, 0x3b, 0x6d, 0xf3,
0x6e, 0x64, 0x69, 0x65, 0x3b, 0x6d, 0x75, 0xe1, 0x6e, 0x79, 0xe1, 0x14b, 0x6d, 0xf3, 0x6e, 0x64, 0x69, 0x65, 0x3b, 0x6d,
0x65, 0x74, 0xfa, 0x6b, 0x70, 0xed, 0xe1, 0x70, 0x25b, 0x3b, 0x6b, 0xfa, 0x70, 0xe9, 0x6c, 0x69, 0x6d, 0x65, 0x74, 0xfa,
0x6b, 0x70, 0x69, 0x61, 0x70, 0x25b, 0x3b, 0x66, 0x65, 0x6c, 0xe9, 0x74, 0x65, 0x3b, 0x73, 0xe9, 0x73, 0x65, 0x6c, 0xe9,
0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x65, 0x3b, 0x6b, 0x3b, 0x66, 0x3b, 0x73, 0x3b, 0x5d6, 0x5d5, 0x5e0, 0x5d8, 0x5d9,
0x5e7, 0x3b, 0x5de, 0x5d0, 0x5b8, 0x5e0, 0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5d3, 0x5d9, 0x5e0, 0x5e1, 0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5de, 0x5d9,
0x5d8, 0x5d5, 0x5d5, 0x5d0, 0x5da, 0x3b, 0x5d3, 0x5d0, 0x5e0, 0x5e2, 0x5e8, 0x5e9, 0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5e4, 0x5bf, 0x5e8, 0x5f2,
0x5b7, 0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5e9, 0x5d1, 0x5ea, 0x3b, 0xc0, 0xec, 0x6b, 0x3b, 0x41, 0x6a, 0x3b, 0xcc, 0x73, 0x1eb9, 0x301,
0x67, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x72, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x62, 0x3b, 0x1eb8, 0x74, 0x3b, 0xc0, 0x62, 0xe1,
0x6d, 0x3b, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x41, 0x6a, 0xe9, 0x3b, 0xcc, 0x73, 0x1eb9, 0x301, 0x67, 0x75, 0x6e, 0x3b, 0x1ecc,
0x6a, 0x1ecd, 0x301, 0x72, 0xfa, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x62, 0x1ecd, 0x3b, 0x1eb8, 0x74, 0xec, 0x3b, 0xc0, 0x62, 0xe1,
0x6d, 0x1eb9, 0x301, 0x74, 0x61, 0x3b, 0xc0, 0x3b, 0x41, 0x3b, 0xcc, 0x3b, 0x1ecc, 0x3b, 0x1ecc, 0x3b, 0x1eb8, 0x3b, 0xc0, 0x3b,
0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0x41, 0x6a, 0xe9, 0x3b, 0x1ecc,
0x6a, 0x1ecd, 0x301, 0x20, 0xcc, 0x73, 0x1eb9, 0x301, 0x67, 0x75, 0x6e, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x72, 0xfa, 0x3b, 0x1ecc,
0x6a, 0x1ecd, 0x301, 0x62, 0x1ecd, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0x1eb8, 0x74, 0xec, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20,
0xc0, 0x62, 0xe1, 0x6d, 0x1eb9, 0x301, 0x74, 0x61, 0x3b, 0xc0, 0xec, 0x6b, 0x3b, 0x41, 0x6a, 0x3b, 0xcc, 0x73, 0x25b, 0x301,
0x67, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x72, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x62, 0x3b, 0x190, 0x74, 0x3b, 0xc0, 0x62, 0xe1,
0x6d, 0x3b, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x41, 0x6a, 0xe9, 0x3b, 0xcc, 0x73, 0x25b, 0x301, 0x67, 0x75, 0x6e, 0x3b, 0x186,
0x6a, 0x254, 0x301, 0x72, 0xfa, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x62, 0x254, 0x3b, 0x190, 0x74, 0xec, 0x3b, 0xc0, 0x62, 0xe1,
0x6d, 0x25b, 0x301, 0x74, 0x61, 0x3b, 0xc0, 0x3b, 0x41, 0x3b, 0xcc, 0x3b, 0x186, 0x3b, 0x186, 0x3b, 0x190, 0x3b, 0xc0, 0x3b,
0x186, 0x6a, 0x254, 0x301, 0x20, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0x41, 0x6a, 0xe9, 0x3b, 0x186,
0x6a, 0x254, 0x301, 0x20, 0xcc, 0x73, 0x25b, 0x301, 0x67, 0x75, 0x6e, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x72, 0xfa, 0x3b, 0x186,
0x6a, 0x254, 0x301, 0x62, 0x254, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0x190, 0x74, 0xec, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20,
0xc0, 0x62, 0xe1, 0x6d, 0x25b, 0x301, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e,
0x6e, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x6c, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41,
0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x41, 0x6c, 0x7a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x69, 0x62, 0x74,
0x69, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0x53, 0x3b, 0x53, 0x6f, 0x6e, 0x3b,
0x4d, 0x73, 0x6f, 0x3b, 0x42, 0x69, 0x6c, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x53, 0x69, 0x6e, 0x3b, 0x48, 0x6c, 0x61, 0x3b,
0x4d, 0x67, 0x71, 0x3b, 0x49, 0x53, 0x6f, 0x6e, 0x74, 0x6f, 0x3b, 0x55, 0x4d, 0x73, 0x6f, 0x6d, 0x62, 0x75, 0x6c, 0x75,
0x6b, 0x6f, 0x3b, 0x55, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x55, 0x4c, 0x77, 0x65, 0x73, 0x69,
0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x55, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x6e, 0x65, 0x3b, 0x55, 0x4c, 0x77, 0x65,
0x73, 0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x55, 0x4d, 0x67, 0x71, 0x69, 0x62, 0x65, 0x6c, 0x6f, 0x3b, 0x53, 0x3b,
0x4d, 0x3b, 0x42, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x48, 0x3b, 0x4d, 0x3b
};

static const ushort am_data[] = {
0x41, 0x4d, 0x76, 0x6d, 0x2e, 0x61, 0x2e, 0x67, 0x41, 0x4e, 0x65, 0x20, 0x70, 0x61, 0x72, 0x61, 0x64, 0x69, 0x74, 0x65,
0x73, 0x1325, 0x12cb, 0x1275, 0x635, 0x9aa, 0x9c2, 0x9f0, 0x9cd, 0x9ac, 0x9be, 0x9b9, 0x9cd, 0x9a8, 0x64, 0x65, 0x20, 0x6c, 0x61, 0x20,
0x6d, 0x61, 0xf1, 0x61, 0x6e, 0x61, 0x69, 0x63, 0x68, 0x65, 0x68, 0x65, 0x61, 0x76, 0x6f, 0x410, 0x41c, 0x73, 0xe1, 0x72,
0xfa, 0x77, 0xe1, 0x49, 0x20, 0x62, 0x69, 0x6b, 0x25b, 0x302, 0x67, 0x6c, 0xe0, 0x75, 0x6c, 0x75, 0x63, 0x68, 0x65, 0x6c,
0x6f, 0x70, 0x61, 0x6d, 0x69, 0x6c, 0x61, 0x75, 0x92d, 0x94b, 0x930, 0x92b, 0x941, 0x902, 0x70, 0x72, 0x69, 0x6a, 0x65, 0x70,
0x6f, 0x64, 0x6e, 0x65, 0x43f, 0x440, 0x438, 0x458, 0x435, 0x20, 0x43f, 0x43e, 0x434, 0x43d, 0x435, 0x41, 0x2e, 0x4d, 0x2e, 0x43f,
0x440, 0x2e, 0x43e, 0x431, 0x2e, 0x1014, 0x1036, 0x1014, 0x1000, 0x103a, 0x4e0a, 0x5348, 0x61, 0x2e, 0xa0, 0x6d, 0x2e, 0x5a, 0x64, 0x61,
0x74, 0x20, 0x61, 0x7a, 0x61, 0x6c, 0x628, 0x2e, 0x646, 0x13cc, 0x13be, 0x13b4, 0x55, 0x68, 0x72, 0x20, 0x76, 0xf6, 0x72, 0x6d,
0x69, 0x64, 0x64, 0x61, 0x61, 0x63, 0x68, 0x73, 0x61, 0x2e, 0x6d, 0x2e, 0x64, 0x6f, 0x70, 0x2e, 0x938, 0x935, 0x947, 0x930,
0x69, 0x64, 0x69, 0x253, 0x61, 0xf66, 0xf94, 0xf0b, 0xf46, 0xf0b, 0x4b, 0x49, 0xd801, 0xdc08, 0xd801, 0xdc23, 0x61, 0x6d, 0xd801, 0xdc68,
0xd801, 0xdc65, 0x61, 0x74, 0x6d, 0x14b, 0x64, 0x69, 0x6b, 0xed, 0x6b, 0xed, 0x72, 0xed, 0x67, 0x61, 0x70, 0x2e, 0x6d, 0x61,
0x74, 0x69, 0x6e, 0x61, 0x2e, 0x73, 0x75, 0x62, 0x61, 0x6b, 0x61, 0xd83a, 0xdd00, 0xd83a, 0xdd0e, 0x6d, 0x3c0, 0x2e, 0x3bc, 0x2e,
0x4d, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x924, 0x921, 0x915, 0x947, 0x53, 0x61, 0x66, 0x69, 0x79, 0x61, 0x5dc, 0x5e4, 0x5e0, 0x5d4,
0x5f4, 0x5e6, 0x64, 0x65, 0x2e, 0x66, 0x2e, 0x68, 0x2e, 0x4e, 0x2019, 0x1ee5, 0x74, 0x1ee5, 0x74, 0x1ee5, 0x69, 0x70, 0x2e, 0x72,
0x2e, 0x6e, 0x2e, 0x5348, 0x524d, 0x49, 0x73, 0x75, 0x6b, 0x6e, 0x20, 0x74, 0x75, 0x66, 0x61, 0x74, 0x6b, 0x61, 0x72, 0x6f,
0x6f, 0x6e, 0x128, 0x79, 0x61, 0x6b, 0x77, 0x61, 0x6b, 0x79, 0x61, 0xcaa, 0xcc2, 0xcb0, 0xccd, 0xcb5, 0xcbe, 0xcb9, 0xccd, 0xca8,
0x627, 0x6d2, 0x20, 0x627, 0x6cc, 0x645, 0x92f, 0x947, 0x20, 0x90f, 0x92e, 0x4b, 0x69, 0x72, 0x6f, 0x6b, 0x6f, 0x938, 0x915, 0x93e,
0x933, 0xc624, 0xc804, 0x41, 0x64, 0x64, 0x75, 0x68, 0x61, 0x42, 0x4e, 0x6d, 0x61, 0x6e, 0xe1, 0x442, 0x430, 0x4a3, 0x43a, 0x44b,
0x54, 0x4f, 0x4f, 0xe81, 0xec8, 0xead, 0xe99, 0xe97, 0xec8, 0xebd, 0xe87, 0x70, 0x72, 0x69, 0x65, 0x6b, 0x161, 0x70, 0x75, 0x73,
0x64, 0x69, 0x65, 0x6e, 0x101, 0x6e, 0x74, 0x254, 0x301, 0x6e, 0x67, 0x254, 0x301, 0x70, 0x72, 0x69, 0x65, 0x161, 0x70, 0x69,
0x65, 0x74, 0x64, 0x6f, 0x70, 0x6f, 0x142, 0x64, 0x6e, 0x6a, 0x61, 0x44, 0x69, 0x6e, 0x64, 0x61, 0x4f, 0x44, 0x6d, 0x6f,
0x69, 0x65, 0x73, 0x43f, 0x440, 0x435, 0x442, 0x43f, 0x43b, 0x2e, 0x75, 0x74, 0x75, 0x6b, 0x6f, 0x77, 0x69, 0x63, 0x68, 0x69,
0x73, 0x68, 0x75, 0x4d, 0x75, 0x68, 0x69, 0x50, 0x47, 0x98f, 0x20, 0x98f, 0x9ae, 0x190, 0x6e, 0x6b, 0x61, 0x6b, 0x25b, 0x6e,
0x79, 0xe1, 0x52, 0x168, 0x4af, 0x2e, 0x4e9, 0x2e, 0x1826, 0x1802, 0x20, 0x1825, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x1c1, 0x67, 0x6f,
0x61, 0x67, 0x61, 0x73, 0x92a, 0x942, 0x930, 0x94d, 0x935, 0x93e, 0x939, 0x94d, 0x928, 0x6d, 0x62, 0x61, 0x2bc, 0xe1, 0x6d, 0x62,
0x61, 0x2bc, 0x6d, 0x62, 0x61, 0xa78c, 0x6d, 0x62, 0x61, 0xa78c, 0x46, 0x1ecd, 0x20, 0x6d, 0x1ecd, 0x301, 0x6e, 0x69, 0x6e, 0x7db,
0x69, 0x111, 0x69, 0x74, 0x62, 0x65, 0x61, 0x69, 0x76, 0x65, 0x74, 0x69, 0x62, 0x52, 0x57, 0x57, 0x44, 0x4d5, 0x43c, 0x431,
0x438, 0x441, 0x431, 0x43e, 0x43d, 0x44b, 0x20, 0x440, 0x430, 0x437, 0x43c, 0x4d5, 0x63a, 0x2e, 0x645, 0x2e, 0x642, 0x628, 0x644, 0x200c,
0x627, 0x632, 0x638, 0x647, 0x631, 0x64, 0x61, 0x20, 0x6d, 0x61, 0x6e, 0x68, 0xe3, 0xa2a, 0xa42, 0x2e, 0xa26, 0xa41, 0x2e, 0x938,
0x92c, 0x947, 0x930, 0x947, 0x6b, 0x61, 0x6e, 0x67, 0x2019, 0x61, 0x6d, 0x61, 0x5a, 0x2e, 0x4d, 0x55, 0x2e, 0x42d, 0x418, 0x54,
0x65, 0x73, 0x69, 0x72, 0x61, 0x6e, 0x4e, 0x44, 0x4c, 0x77, 0x61, 0x6d, 0x69, 0x6c, 0x61, 0x77, 0x75, 0x1c65, 0x1c6e, 0x1c5b,
0x1c5f, 0x1c5c, 0x70, 0x72, 0x69, 0x6a, 0x65, 0x20, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x6d, 0x61, 0x6b, 0x65, 0x6f, 0xa3b8, 0xa111,
0x64, 0x6f, 0x20, 0x70, 0x6f, 0x142, 0x65, 0x64, 0x6e, 0x69, 0x14f, 0x635, 0x628, 0x62d, 0x60c, 0x20, 0x645, 0x646, 0x62c, 0x647,
0x646, 0x62f, 0x938, 0x941, 0x92c, 0x941, 0x939, 0x20, 0x91c, 0x93e, 0xdb4, 0xdd9, 0x2e, 0xdc0, 0x2e, 0x4d, 0x75, 0x6e, 0x6b, 0x79,
0x6f, 0x47, 0x48, 0x2d5c, 0x2d49, 0x2d3c, 0x2d30, 0x2d61, 0x2d5c, 0x66, 0x6d, 0x61, 0x6d, 0x20, 0x56, 0x6f, 0x72, 0x6d, 0x69, 0x74,
0x74, 0x61, 0x67, 0x729, 0x71b, 0x74, 0x69, 0x66, 0x61, 0x77, 0x74, 0x4c, 0x75, 0x6d, 0x61, 0x20, 0x6c, 0x77, 0x61, 0x20,
0x4b, 0xbae, 0xbc1, 0xbb1, 0xbcd, 0xbaa, 0xb95, 0xbb2, 0xbcd, 0x53, 0x75, 0x62, 0x62, 0x61, 0x61, 0x68, 0x69, 0x54, 0x61, 0x70,
0x61, 0x72, 0x61, 0x63, 0x68, 0x75, 0xe01, 0xe48, 0xe2d, 0xe19, 0xe40, 0xe17, 0xe35, 0xe48, 0xe22, 0xe07, 0xf66, 0xf94, 0xf0b, 0xf51,
0xfb2, 0xf7c, 0xf0b, 0x1245, 0x2e, 0x1240, 0x2e, 0x68, 0x65, 0x6e, 0x67, 0x69, 0x68, 0x65, 0x6e, 0x67, 0x69, 0xd6, 0xd6, 0x67,
0xfc, 0x6e, 0x6f, 0x72, 0x74, 0x61, 0x64, 0x61, 0x6e, 0x20, 0xf6, 0x148, 0x434, 0x43f, 0x686, 0x6c8, 0x634, 0x62a, 0x649, 0x646,
0x20, 0x628, 0x6c7, 0x631, 0x6c7, 0x646, 0x54, 0x4f, 0x422, 0x41e, 0x53, 0x41, 0x79, 0x62, 0x53, 0x75, 0x62, 0x6b, 0x69, 0x25b,
0x6d, 0x25b, 0x301, 0x25b, 0x6d, 0x5e4, 0x5bf, 0x5d0, 0x5b7, 0x5e8, 0x5de, 0x5d9, 0x5d8, 0x5d0, 0x5b8, 0x5d2, 0xc0, 0xe1, 0x72, 0x1ecd,
0x300, 0xc0, 0xe1, 0x72, 0x254, 0x300
};

static const ushort pm_data[] = {
0x50, 0x4d, 0x6e, 0x6d, 0x2e, 0x61, 0x2e, 0x6b, 0x45, 0x57, 0x65, 0x20, 0x70, 0x61, 0x73, 0x64, 0x69, 0x74, 0x65, 0x73,
0x12a8, 0x1230, 0x12d3, 0x1275, 0x645, 0x985, 0x9aa, 0x9f0, 0x9be, 0x9b9, 0x9cd, 0x9a8, 0x64, 0x65, 0x20, 0x6c, 0x61, 0x20, 0x74, 0x61,
0x72, 0x64, 0x65, 0x69, 0x63, 0x68, 0x61, 0x6d, 0x74, 0x68, 0x69, 0x41f, 0x41c, 0x63, 0x25b, 0x25b, 0x301, 0x6e, 0x6b, 0x6f,
0x49, 0x20, 0x253, 0x75, 0x67, 0x61, 0x6a, 0x254, 0x70, 0x61, 0x6b, 0x61, 0x73, 0x75, 0x62, 0x61, 0x70, 0x61, 0x6d, 0x75,
0x6e, 0x79, 0x69, 0x938, 0x93e, 0x902, 0x91d, 0x92c, 0x947, 0x932, 0x93e, 0x938, 0x947, 0x70, 0x6f, 0x70, 0x6f, 0x64, 0x6e, 0x65,
0x43f, 0x43e, 0x441, 0x43b, 0x438, 0x458, 0x435, 0x20, 0x43f, 0x43e, 0x434, 0x43d, 0x435, 0x47, 0x2e, 0x4d, 0x2e, 0x441, 0x43b, 0x2e,
0x43e, 0x431, 0x2e, 0x100a, 0x1014, 0x1031, 0x4e0b, 0x5348, 0x70, 0x2e, 0xa0, 0x6d, 0x2e, 0x1e0c, 0x65, 0x66, 0x66, 0x69, 0x72, 0x20,
0x61, 0x7a, 0x61, 0x62f, 0x2e, 0x646, 0x13d2, 0x13af, 0x13f1, 0x13a2, 0x13d7, 0x13e2, 0x55, 0x68, 0x72, 0x20, 0x6e, 0x6f, 0x6d, 0x6d,
0x65, 0x6e, 0x64, 0x61, 0x61, 0x63, 0x68, 0x73, 0x70, 0x2e, 0x6d, 0x2e, 0x6f, 0x64, 0x70, 0x2e, 0x926, 0x92a, 0x948, 0x939,
0x930, 0x20, 0x92c, 0x93e, 0x926, 0x65, 0x62, 0x79, 0xe1, 0x6d, 0x75, 0xf55, 0xfb1, 0xf72, 0xf0b, 0xf46, 0xf0b, 0x55, 0x54, 0xd801,
0xdc11, 0xd801, 0xdc23, 0x70, 0x6d, 0xd801, 0xdc50, 0xd801, 0xdc65, 0x70, 0x74, 0x6d, 0x263, 0x65, 0x74, 0x72, 0x254, 0x6e, 0x67, 0x259,
0x67, 0xf3, 0x67, 0x259, 0x6c, 0x65, 0x69, 0x70, 0x2e, 0x73, 0x6f, 0x69, 0x72, 0x70, 0x2e, 0x6b, 0x69, 0x6b, 0x69, 0x69,
0x257, 0x65, 0xd83a, 0xdd07, 0xd83a, 0xdd0e, 0x66, 0x3bc, 0x2e, 0x3bc, 0x2e, 0x4d, 0x6f, 0x67, 0x59, 0x61, 0x6d, 0x6d, 0x61, 0x5d0,
0x5d7, 0x5d4, 0x5f4, 0x5e6, 0x64, 0x75, 0x2e, 0x65, 0x2e, 0x68, 0x2e, 0x4e, 0x2019, 0x61, 0x62, 0x61, 0x6c, 0x69, 0x65, 0x70,
0x2e, 0x69, 0x2e, 0x6e, 0x2e, 0x5348, 0x5f8c, 0x57, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x20, 0x74, 0x6d, 0x65, 0x64, 0x64, 0x69,
0x74, 0x6b, 0x6f, 0x6f, 0x73, 0x6b, 0x6f, 0x6c, 0x69, 0x6e, 0x79, 0x128, 0x79, 0x61, 0x77, 0x129, 0x6f, 0x6f, 0xc85, 0xcaa,
0xcb0, 0xcbe, 0xcb9, 0xccd, 0xca8, 0x67e, 0x6cc, 0x20, 0x627, 0x6cc, 0x645, 0x92a, 0x940, 0x20, 0x90f, 0x92e, 0x48, 0x77, 0x61, 0x129,
0x2d, 0x69, 0x6e, 0x129, 0x938, 0x93e, 0x902, 0x91c, 0xc624, 0xd6c4, 0x41, 0x6c, 0x75, 0x75, 0x6c, 0x61, 0x50, 0x4e, 0x6b, 0x75,
0x67, 0xfa, 0x442, 0x4af, 0x448, 0x442, 0x4e9, 0x43d, 0x20, 0x43a, 0x438, 0x439, 0x438, 0x43d, 0x43a, 0x438, 0x4d, 0x55, 0x55, 0xeab,
0xebc, 0xeb1, 0xe87, 0xe97, 0xec8, 0xebd, 0xe87, 0x70, 0x113, 0x63, 0x70, 0x75, 0x73, 0x64, 0x69, 0x65, 0x6e, 0x101, 0x6d, 0x70,
0xf3, 0x6b, 0x77, 0x61, 0x70, 0x6f, 0x70, 0x69, 0x65, 0x74, 0x77, 0xf3, 0x74, 0x70, 0x6f, 0x142, 0x64, 0x6e, 0x6a, 0x61,
0x44, 0x69, 0x6c, 0x6f, 0x6c, 0x6f, 0x4f, 0x54, 0x6e, 0x6f, 0x6d, 0xeb, 0x74, 0x74, 0x65, 0x73, 0x43f, 0x43e, 0x43f, 0x43b,
0x2e, 0x6b, 0x79, 0x69, 0x75, 0x6b, 0x6f, 0x6e, 0x79, 0x69, 0x6d, 0x63, 0x68, 0x6f, 0x63, 0x68, 0x69, 0x6c, 0x2019, 0x6c,
0x43, 0x68, 0x69, 0x6c, 0x6f, 0x50, 0x54, 0x47, 0x9aa, 0x9bf, 0x20, 0x98f, 0x9ae, 0x190, 0x6e, 0x64, 0xe1, 0x6d, 0xe2, 0x168,
0x47, 0x4af, 0x2e, 0x445, 0x2e, 0x1826, 0x1802, 0x20, 0x182c, 0x1823, 0x6c, 0x69, 0x6c, 0x6c, 0x69, 0x1c3, 0x75, 0x69, 0x61, 0x73,
0x905, 0x92a, 0x930, 0x93e, 0x939, 0x94d, 0x928, 0x6e, 0x63, 0x77, 0xf2, 0x6e, 0x7a, 0xe9, 0x6d, 0x14b, 0x6b, 0x61, 0x20, 0x6d,
0x62, 0x254, 0x301, 0x74, 0x20, 0x6e, 0x6a, 0x69, 0x46, 0x1ecd, 0x20, 0xed, 0x76, 0x6e, 0x69, 0x6e, 0x7e5, 0x65, 0x61, 0x68,
0x6b, 0x65, 0x74, 0x62, 0x65, 0x61, 0x69, 0x76, 0x65, 0x74, 0x65, 0x62, 0x54, 0x14a, 0x57, 0x42, 0x4d5, 0x43c, 0x431, 0x438,
0x441, 0x431, 0x43e, 0x43d, 0x44b, 0x20, 0x444, 0x4d5, 0x441, 0x442, 0x4d5, 0x63a, 0x2e, 0x648, 0x2e, 0x628, 0x639, 0x62f, 0x627, 0x632,
0x638, 0x647, 0x631, 0x64, 0x61, 0x20, 0x74, 0x61, 0x72, 0x64, 0x65, 0xa2c, 0xa3e, 0x2e, 0xa26, 0xa41, 0x2e, 0x938, 0x93e, 0x902,
0x92e, 0x6b, 0x69, 0x6e, 0x67, 0x6f, 0x74, 0x6f, 0x5a, 0x2e, 0x4d, 0x57, 0x2e, 0x42d, 0x41a, 0x54, 0x65, 0x69, 0x70, 0x61,
0x4c, 0x4b, 0x50, 0x61, 0x73, 0x68, 0x61, 0x6d, 0x69, 0x68, 0x65, 0x1c67, 0x1c64, 0x1c6b, 0x1c5f, 0x1c79, 0x43f, 0x43e, 0x20, 0x43f,
0x43e, 0x434, 0x43d, 0x435, 0x70, 0x6f, 0x20, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x6e, 0x79, 0x69, 0x61, 0x67, 0x68, 0x75, 0x6f,
0xa06f, 0xa2d2, 0x70, 0x6f, 0x20, 0x70, 0x6f, 0x142, 0x65, 0x64, 0x6e, 0x69, 0x75, 0x645, 0x646, 0x62c, 0x647, 0x646, 0x62f, 0x60c,
0x20, 0x634, 0x627, 0x645, 0x936, 0x93e, 0x92e, 0x20, 0x91c, 0x93e, 0xdb4, 0x2e, 0xdc0, 0x2e, 0x70, 0x6f, 0x70, 0x2e, 0x45, 0x69,
0x67, 0x75, 0x6c, 0x6f, 0x47, 0x44, 0x2d5c, 0x2d30, 0x2d37, 0x2d33, 0x2d33, 0x2d6f, 0x2d30, 0x2d5c, 0x65, 0x6d, 0x61, 0x6d, 0x20, 0x4e,
0x61, 0x6d, 0x69, 0x74, 0x74, 0x61, 0x67, 0x712, 0x71b, 0x74, 0x61, 0x64, 0x67, 0x67, 0x2b7, 0x61, 0x74, 0x6c, 0x75, 0x6d,
0x61, 0x20, 0x6c, 0x77, 0x61, 0x20, 0x70, 0xbaa, 0xbbf, 0xbb1, 0xbcd, 0xbaa, 0xb95, 0xbb2, 0xbcd, 0x5a, 0x61, 0x61, 0x72, 0x69,
0x6b, 0x61, 0x79, 0x20, 0x62, 0x45, 0x62, 0x6f, 0x6e, 0x67, 0x69, 0xe2b, 0xe25, 0xe31, 0xe07, 0xe40, 0xe17, 0xe35, 0xe48, 0xe22,
0xe07, 0xf55, 0xfb1, 0xf72, 0xf0b, 0xf51, 0xfb2, 0xf7c, 0xf0b, 0x12f5, 0x2e, 0x1240, 0x2e, 0x65, 0x66, 0x69, 0x61, 0x66, 0x69, 0xd6,
0x53, 0x67, 0xfc, 0x6e, 0x6f, 0x72, 0x74, 0x61, 0x64, 0x61, 0x6e, 0x20, 0x73, 0x6f, 0x148, 0x43f, 0x43f, 0x70, 0x6f, 0x70,
0x6f, 0x142, 0x64, 0x6e, 0x6a, 0x75, 0x686, 0x6c8, 0x634, 0x62a, 0x649, 0x646, 0x20, 0x643, 0x6d0, 0x64a, 0x649, 0x646, 0x54, 0x4b,
0x422, 0x41a, 0x43, 0x48, 0x79, 0x68, 0x4e, 0x67, 0x6f, 0x6b, 0x69, 0x73, 0x25b, 0x301, 0x6e, 0x64, 0x25b, 0x5e0, 0x5d0, 0x5b8,
0x5db, 0x5de, 0x5d9, 0x5d8, 0x5d0, 0x5b8, 0x5d2, 0x1ecc, 0x300, 0x73, 0xe1, 0x6e, 0x186, 0x300, 0x73, 0xe1, 0x6e
};

static const ushort currency_symbol_data[] = {
0x10da, 0x42, 0x72, 0x46, 0x64, 0x6a, 0x4e, 0x66, 0x6b, 0x52, 0x24, 0x46, 0x43, 0x46, 0x41, 0x47, 0x48, 0x20b5, 0x4c, 0x65,
0x6b, 0xeb, 0x20ac, 0x64, 0x65, 0x6e, 0x1265, 0x122d, 0x62c, 0x2e, 0x645, 0x2e, 0x200f, 0x62f, 0x2e, 0x62c, 0x2e, 0x200f, 0x62f, 0x2e,
0x628, 0x2e, 0x200f, 0x43, 0x46, 0x62f, 0x2e, 0x639, 0x2e, 0x200f, 0x20aa, 0x62f, 0x2e, 0x623, 0x2e, 0x200f, 0x62f, 0x2e, 0x643, 0x2e,
0x200f, 0x644, 0x2e, 0x644, 0x2e, 0x200f, 0x62f, 0x2e, 0x644, 0x2e, 0x200f, 0x623, 0x2e, 0x645, 0x2e, 0x62f, 0x2e, 0x645, 0x2e, 0x200f,
0x631, 0x2e, 0x639, 0x2e, 0x200f, 0x631, 0x2e, 0x642, 0x2e, 0x200f, 0x631, 0x2e, 0x633, 0x2e, 0x200f, 0x53, 0xa3, 0x62c, 0x2e, 0x633,
0x2e, 0x644, 0x2e, 0x633, 0x2e, 0x200f, 0x62f, 0x2e, 0x62a, 0x2e, 0x200f, 0x62f, 0x2e, 0x625, 0x2e, 0x200f, 0x631, 0x2e, 0x64a, 0x2e,
0x200f, 0x58f, 0x20b9, 0x54, 0x53, 0x68, 0x20a6, 0x20bc, 0x20ba, 0x52, 0x73, 0x46, 0x202f, 0x43, 0x46, 0x41, 0x9f3, 0x20bd, 0x4b, 0x4b,
0x4d, 0x41a, 0x41c, 0x43b, 0x432, 0x2e, 0x48, 0x4b, 0x24, 0xffe5, 0x20b1, 0x55, 0x53, 0x68, 0xa5, 0x4d, 0x4f, 0x50, 0x24, 0x45,
0x55, 0x52, 0x4b, 0x10d, 0x6b, 0x72, 0x2e, 0x783, 0x2e, 0x41, 0x66, 0x6c, 0x2e, 0x4e, 0x41, 0x66, 0x2e, 0x4e, 0x75, 0x2e,
0x4b, 0x73, 0x68, 0x50, 0x55, 0x53, 0x24, 0x46, 0x42, 0x75, 0x45, 0x44, 0x41, 0x72, 0x4d, 0x4b, 0x52, 0x4d, 0x52, 0x66,
0x52, 0x46, 0x57, 0x53, 0x24, 0x53, 0x52, 0x4c, 0x65, 0x6b, 0x72, 0x54, 0x24, 0x41, 0x45, 0x44, 0x56, 0x54, 0x44, 0x41,
0x46, 0x43, 0x46, 0x43, 0x46, 0x50, 0x46, 0x47, 0x47, 0x55, 0x4d, 0x4d, 0x41, 0x44, 0x43, 0x48, 0x46, 0x4c, 0x53, 0x44,
0x54, 0xd83a, 0xdd05, 0xd83a, 0xdd0a, 0xd83a, 0xdd00, 0xd83a, 0xdd0a, 0xd83a, 0xdd05, 0xd83a, 0xdd0a, 0xd83a, 0xdd00, 0x20be, 0x20b2, 0xd838, 0xdd4e, 0x46,
0x74, 0x52, 0x70, 0x43, 0x41, 0x24, 0x200b, 0x52, 0x24, 0x20b8, 0x17db, 0x51, 0x20a9, 0x4b, 0x50, 0x57, 0x441, 0x43e, 0x43c, 0x20ad,
0x4b, 0x7a, 0x434, 0x435, 0x43d, 0x2e, 0x4d, 0x54, 0x6e, 0x49, 0x52, 0x52, 0x20ae, 0x43, 0x4e, 0xa5, 0x928, 0x947, 0x930, 0x942,
0x42, 0x73, 0x2e, 0x53, 0x7ff, 0x60b, 0x631, 0x6cc, 0x627, 0x644, 0x7a, 0x142, 0x44, 0x62, 0x631, 0x53, 0x2f, 0x42, 0x73, 0x52,
0x4f, 0x4e, 0x4c, 0x20b4, 0x52, 0x53, 0x44, 0xdbb, 0xdd4, 0x2e, 0x20a1, 0x52, 0x44, 0x24, 0x43, 0x24, 0x42, 0x2f, 0x2e, 0x47,
0x73, 0x2e, 0x20ab, 0x441, 0x43e, 0x43c, 0x2e, 0x52, 0x73, 0x2e, 0x4e, 0x54, 0x24, 0xe3f, 0x54, 0x4d, 0x54, 0x73, 0x6f, 0x2bb,
0x6d, 0x441, 0x45e, 0x43c, 0x41, 0x24, 0x50, 0x4b, 0x52
};

static const ushort currency_display_name_data[] = {
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e,
0x73, 0x65, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61,
0x61, 0x6e, 0x73, 0x65, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66,
0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69,
0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x65, 0x73,
0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x65, 0x73,
0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x43, 0x46, 0x41, 0x20, 0x46, 0xe0, 0x6c, 0xe2, 0x14b, 0x20, 0x42,
0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x53, 0x69, 0x64, 0x69,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x72, 0xe2, 0x6e, 0x6b, 0x65, 0x20, 0x43, 0x46, 0x41, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x4c, 0x65, 0x6b, 0x75, 0x20, 0x73, 0x68, 0x71, 0x69, 0x70, 0x74, 0x61, 0x72, 0x3b, 0x3b, 0x6c,
0x65, 0x6b, 0x20, 0x73, 0x68, 0x71, 0x69, 0x70, 0x74, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x6c, 0x65, 0x6b, 0xeb, 0x20,
0x73, 0x68, 0x71, 0x69, 0x70, 0x74, 0x61, 0x72, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x6a, 0x61, 0x3b, 0x3b, 0x65, 0x75, 0x72,
0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x44, 0x65, 0x6e, 0x61, 0x72, 0x69, 0x20, 0x6d, 0x61, 0x71,
0x65, 0x64, 0x6f, 0x6e, 0x61, 0x73, 0x3b, 0x3b, 0x64, 0x65, 0x6e, 0x61, 0x72, 0x20, 0x6d, 0x61, 0x71, 0x65, 0x64, 0x6f,
0x6e, 0x61, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x65, 0x6e, 0x61, 0x72, 0xeb, 0x20, 0x6d, 0x61, 0x71, 0x65, 0x64, 0x6f,
0x6e, 0x61, 0x73, 0x3b, 0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x20, 0x1265, 0x122d, 0x3b, 0x3b, 0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335,
0x12eb, 0x20, 0x1265, 0x122d, 0x3b, 0x3b, 0x3b, 0x3b, 0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x20, 0x1265, 0x122d, 0x3b, 0x62c, 0x646,
0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646,
0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x627, 0x646, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x627,
0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x627, 0x62a, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x629, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x64b,
0x627, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x64b, 0x627, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62f,
0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632,
0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a,
0x646, 0x627, 0x631, 0x627, 0x646, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x627, 0x646, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631,
0x627, 0x62a, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x629, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x64b, 0x627, 0x20, 0x62c,
0x632, 0x627, 0x626, 0x631, 0x64a, 0x64b, 0x627, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a,
0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b,
0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628,
0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f,
0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633, 0x637,
0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631,
0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b,
0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643,
0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633, 0x637,
0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631,
0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641,
0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c,
0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644,
0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641,
0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c,
0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a,
0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a,
0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646,
0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a,
0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623,
0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646,
0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631,
0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627,
0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a,
0x62a, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627,
0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b,
0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631,
0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627,
0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644,
0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a,
0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20,
0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c,
0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f,
0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a,
0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f,
0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623,
0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646,
0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a,
0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623,
0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646,
0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a,
0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643,
0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646,
0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a,
0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628,
0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a,
0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a,
0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644,
0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631,
0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x627, 0x646, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x627, 0x646,
0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x627, 0x62a, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x629, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631,
0x64b, 0x627, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x64b, 0x627, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a,
0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642,
0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645,
0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a,
0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629,
0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642,
0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a,
0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20,
0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x627, 0x646, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x627, 0x646,
0x3b, 0x62f, 0x631, 0x627, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x629, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x64b, 0x627,
0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x64b, 0x627, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b,
0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646,
0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645,
0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20,
0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627,
0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627,
0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627,
0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627,
0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a,
0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b,
0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f,
0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639,
0x648, 0x62f, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635,
0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646,
0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634,
0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a,
0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c,
0x646, 0x64a, 0x647, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a,
0x647, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x627,
0x646, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x627,
0x62a, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x64b,
0x627, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20,
0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648,
0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a,
0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a,
0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x627, 0x62a, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x62c, 0x646, 0x64a, 0x647,
0x64b, 0x627, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x64b, 0x627, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f,
0x627, 0x646, 0x64a, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20,
0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631,
0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644,
0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629,
0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62a,
0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646,
0x627, 0x631, 0x627, 0x646, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x627, 0x646, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x627, 0x62a,
0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x629, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x64b, 0x627, 0x20, 0x62a, 0x648, 0x646, 0x633,
0x64a, 0x64b, 0x627, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645,
0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a,
0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20,
0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a,
0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625,
0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627,
0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627,
0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627,
0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x65, 0x75, 0x72,
0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x73, 0x3b, 0x570, 0x561, 0x575,
0x56f, 0x561, 0x56f, 0x561, 0x576, 0x20, 0x564, 0x580, 0x561, 0x574, 0x3b, 0x3b, 0x570, 0x561, 0x575, 0x56f, 0x561, 0x56f, 0x561, 0x576,
0x20, 0x564, 0x580, 0x561, 0x574, 0x3b, 0x3b, 0x3b, 0x3b, 0x570, 0x561, 0x575, 0x56f, 0x561, 0x56f, 0x561, 0x576, 0x20, 0x564, 0x580,
0x561, 0x574, 0x3b, 0x9ad, 0x9be, 0x9f0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9f0, 0x9c1, 0x9aa, 0x9c0, 0x3b, 0x3b, 0x9ad, 0x9be, 0x9f0,
0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9f0, 0x9c1, 0x9aa, 0x9c0, 0x3b, 0x3b, 0x3b, 0x3b, 0x9ad, 0x9be, 0x9f0, 0x9a4, 0x9c0, 0x9af, 0x9bc,
0x20, 0x9f0, 0x9c1, 0x9aa, 0x9c0, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61,
0x6e, 0x64, 0x68, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x6d, 0x61, 0x6e, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e, 0x20, 0x4d, 0x61, 0x6e, 0x61,
0x74, 0x131, 0x3b, 0x3b, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x74,
0x131, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x61,
0x74, 0x131, 0x3b, 0x43c, 0x430, 0x43d, 0x430, 0x442, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0xe1, 0x14b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0xe1, 0x6b, 0x65, 0x73, 0x74, 0xe1, 0x6e, 0x69, 0x20, 0x72, 0x75, 0x70, 0x69,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x65, 0x66, 0x61, 0x20, 0x46, 0x72, 0x61, 0x14b, 0x20, 0x28, 0x42, 0x43,
0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9c0,
0x20, 0x99f, 0x9be, 0x995, 0x9be, 0x3b, 0x3b, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9c0, 0x20, 0x99f, 0x9be, 0x995,
0x9be, 0x3b, 0x3b, 0x3b, 0x3b, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9c0, 0x20, 0x99f, 0x9be, 0x995, 0x9be, 0x3b,
0x9ad, 0x9be, 0x9b0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9b0, 0x9c1, 0x9aa, 0x9bf, 0x3b, 0x3b, 0x9ad, 0x9be, 0x9b0, 0x9a4, 0x9c0, 0x9af,
0x9bc, 0x20, 0x9b0, 0x9c1, 0x9aa, 0x9bf, 0x3b, 0x3b, 0x3b, 0x3b, 0x9ad, 0x9be, 0x9b0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9b0, 0x9c1,
0x9aa, 0x9bf, 0x3b, 0x46, 0x72, 0x1ce, 0x14b, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x61, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b,
0x65, 0x75, 0x72, 0x6f, 0x3b, 0x431, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x43a, 0x456, 0x20, 0x440, 0x443, 0x431, 0x435, 0x43b,
0x44c, 0x3b, 0x3b, 0x431, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x43a, 0x456, 0x20, 0x440, 0x443, 0x431, 0x435, 0x43b, 0x44c, 0x3b,
0x3b, 0x431, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x43a, 0x456, 0x44f, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x456, 0x3b, 0x431, 0x435,
0x43b, 0x430, 0x440, 0x443, 0x441, 0x43a, 0x456, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x451, 0x45e, 0x3b, 0x431, 0x435, 0x43b, 0x430,
0x440, 0x443, 0x441, 0x43a, 0x430, 0x433, 0x430, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e,
0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x48, 0x75, 0x74, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x928, 0x93f, 0x20, 0x930, 0x941, 0x92a, 0x940, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924,
0x928, 0x93f, 0x20, 0x930, 0x941, 0x92a, 0x940, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x928, 0x93f, 0x20, 0x930, 0x941,
0x92a, 0x940, 0x3b, 0x42, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61,
0x10d, 0x6b, 0x61, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61,
0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f,
0x76, 0x61, 0x10d, 0x6b, 0x61, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20,
0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x68, 0x65, 0x72, 0x63, 0x65,
0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x65, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e,
0x65, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x68, 0x65, 0x72,
0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x69, 0x68, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62,
0x69, 0x6c, 0x6e, 0x69, 0x68, 0x20, 0x6d, 0x61, 0x72, 0x61, 0x6b, 0x61, 0x3b, 0x41a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442,
0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x430, 0x3b, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441,
0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x430, 0x20, 0x43a, 0x43e, 0x43d, 0x432,
0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x430, 0x3b, 0x3b, 0x431, 0x43e, 0x441,
0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x435, 0x20, 0x43a,
0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x435, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x435, 0x3b, 0x3b,
0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a,
0x438, 0x445, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x438, 0x445, 0x20, 0x43c, 0x430,
0x440, 0x430, 0x43a, 0x430, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f,
0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x61, 0x20, 0x65, 0x75, 0x72, 0x6f, 0x69, 0x6f, 0xf9, 0x3b, 0x65, 0x75, 0x72, 0x6f,
0x3b, 0x411, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x20, 0x43b, 0x435, 0x432, 0x3b, 0x3b, 0x431, 0x44a, 0x43b, 0x433,
0x430, 0x440, 0x441, 0x43a, 0x438, 0x20, 0x43b, 0x435, 0x432, 0x3b, 0x3b, 0x3b, 0x3b, 0x431, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441,
0x43a, 0x438, 0x20, 0x43b, 0x435, 0x432, 0x430, 0x3b, 0x1019, 0x103c, 0x1014, 0x103a, 0x1019, 0x102c, 0x20, 0x1000, 0x103b, 0x1015, 0x103a, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x1019, 0x103c, 0x1014, 0x103a, 0x1019, 0x102c, 0x20, 0x1000, 0x103b, 0x1015, 0x103a, 0x3b, 0x6e2f, 0x5e63, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e2f, 0x5e63, 0x3b, 0x4eba, 0x6c11, 0x5e01, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4eba, 0x6c11, 0x5e01,
0x3b, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x50, 0x65, 0x73, 0x6f, 0x3b, 0x3b, 0x50, 0x68,
0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x70, 0x65, 0x73, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x68, 0x69,
0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x3b, 0x44, 0x65, 0x72, 0x68, 0x65, 0x6d,
0x20, 0x55, 0x6d, 0x65, 0x1e5b, 0x1e5b, 0x75, 0x6b, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x62f, 0x6cc, 0x646, 0x627,
0x631, 0x6cc, 0x20, 0x639, 0x6ce, 0x631, 0x627, 0x642, 0x6cc, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x695, 0x6cc, 0x627, 0x6b5,
0x6cc, 0x20, 0x626, 0x6ce, 0x631, 0x627, 0x646, 0x6cc, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xd804, 0xdd1d, 0xd804, 0xdd01, 0xd804,
0xdd23, 0xd804, 0xdd18, 0xd804, 0xdd2c, 0xd804, 0xdd25, 0xd804, 0xdd28, 0x20, 0xd804, 0xdd11, 0xd804, 0xdd2c, 0xd804, 0xdd0b, 0x3b, 0x3b, 0xd804, 0xdd1d,
0xd804, 0xdd01, 0xd804, 0xdd23, 0xd804, 0xdd18, 0xd804, 0xdd2c, 0xd804, 0xdd25, 0xd804, 0xdd28, 0x20, 0xd804, 0xdd11, 0xd804, 0xdd2c, 0xd804, 0xdd0b, 0x3b,
0x3b, 0x3b, 0x3b, 0xd804, 0xdd1d, 0xd804, 0xdd01, 0xd804, 0xdd23, 0xd804, 0xdd18, 0xd804, 0xdd2c, 0xd804, 0xdd25, 0xd804, 0xdd28, 0x20, 0xd804, 0xdd11,
0xd804, 0xdd2c, 0xd804, 0xdd0b, 0x3b, 0xd804, 0xdd03, 0xd804, 0xdd28, 0xd804, 0xdd1a, 0xd804, 0xdd34, 0xd804, 0xdd18, 0xd804, 0xdd28, 0xd804, 0xdd20, 0xd804,
0xdd1a, 0xd804, 0xdd34, 0x20, 0xd804, 0xdd22, 0xd804, 0xdd2a, 0xd804, 0xdd1b, 0xd804, 0xdd28, 0x3b, 0x3b, 0xd804, 0xdd03, 0xd804, 0xdd28, 0xd804, 0xdd1a,
0xd804, 0xdd34, 0xd804, 0xdd18, 0xd804, 0xdd28, 0xd804, 0xdd20, 0xd804, 0xdd1a, 0xd804, 0xdd34, 0x20, 0xd804, 0xdd22, 0xd804, 0xdd2a, 0xd804, 0xdd1b, 0xd804,
0xdd28, 0x3b, 0x3b, 0x3b, 0x3b, 0xd804, 0xdd03, 0xd804, 0xdd28, 0xd804, 0xdd1a, 0xd804, 0xdd34, 0xd804, 0xdd18, 0xd804, 0xdd28, 0xd804, 0xdd20, 0xd804,
0xdd1a, 0xd804, 0xdd34, 0x20, 0xd804, 0xdd22, 0xd804, 0xdd2a, 0xd804, 0xdd1b, 0xd804, 0xdd28, 0x3b, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x43d,
0x20, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x43d, 0x20, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x3b,
0x3b, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x43d, 0x20, 0x441, 0x43e, 0x44c, 0x43c, 0x430, 0x448, 0x3b, 0x55, 0x53, 0x20, 0x13a0,
0x13d5, 0x13b3, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x13a0, 0x13d5, 0x13b3, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x13a0, 0x13d5, 0x13b3,
0x3b, 0x45, 0x73, 0x68, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e2f, 0x5143, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e2f, 0x5143, 0x3b, 0x6fb3, 0x95e8,
0x5e01, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6fb3, 0x95e8, 0x5143, 0x3b, 0x65b0, 0x52a0, 0x5761, 0x5143, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x65b0, 0x52a0, 0x5761, 0x5143, 0x3b, 0x6fb3, 0x9580, 0x5143, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6fb3, 0x9580, 0x5143, 0x3b, 0x65b0,
0x53f0, 0x5e63, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65b0, 0x53f0, 0x5e63, 0x3b, 0x440, 0x461, 0x441, 0x441, 0x456, 0x301, 0x439, 0x441,
0x43a, 0x457, 0x439, 0x20, 0x440, 0xa64b, 0x301, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x440, 0x461, 0x441, 0x441,
0x456, 0x301, 0x439, 0x441, 0x43a, 0x430, 0x433, 0x461, 0x20, 0x440, 0xa64b, 0x431, 0x43b, 0x467, 0x300, 0x3b, 0x420, 0x430, 0x4ab, 0x4ab,
0x435, 0x439, 0x20, 0x442, 0x435, 0x43d, 0x43a, 0x4d7, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x420, 0x430, 0x4ab, 0x4ab, 0x435, 0x439,
0x20, 0x442, 0x435, 0x43d, 0x43a, 0x438, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75,
0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b,
0x3b, 0x65, 0x75, 0x72, 0x61, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x61, 0x3b, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69,
0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74,
0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72,
0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x3b, 0x3b, 0x6b, 0x6f, 0x6e, 0x76, 0x65,
0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x69, 0x68, 0x20, 0x6d, 0x61, 0x72, 0x61, 0x6b, 0x61, 0x3b, 0x10d, 0x65, 0x73,
0x6b, 0xe1, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xe1, 0x20, 0x6b, 0x6f, 0x72,
0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xe9, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x79, 0x3b, 0x10d, 0x65,
0x73, 0x6b, 0xe9, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x79, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xfd, 0x63, 0x68, 0x20, 0x6b,
0x6f, 0x72, 0x75, 0x6e, 0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x64, 0x61,
0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x65, 0x20,
0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x20, 0x930, 0x92a, 0x947, 0x93d, 0x3b, 0x3b, 0x92d,
0x93e, 0x930, 0x924, 0x940, 0x20, 0x930, 0x92a, 0x947, 0x93d, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x20, 0x930,
0x92a, 0x947, 0x93d, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75,
0x72, 0x6f, 0x3b, 0x41, 0x72, 0x75, 0x62, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b,
0x3b, 0x41, 0x72, 0x75, 0x62, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x3b, 0x3b,
0x3b, 0x41, 0x72, 0x75, 0x62, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x41, 0x6d,
0x65, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x41, 0x6d,
0x65, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b,
0x41, 0x6d, 0x65, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x4e,
0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x2d, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x61, 0x6e,
0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x3b, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64,
0x73, 0x2d, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65,
0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x2d, 0x41, 0x6e, 0x74, 0x69,
0x6c, 0x6c, 0x69, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x53, 0x75, 0x72, 0x69,
0x6e, 0x61, 0x61, 0x6d, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x53, 0x75, 0x72, 0x69, 0x6e,
0x61, 0x61, 0x6d, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x72, 0x69,
0x6e, 0x61, 0x61, 0x6d, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0xf51, 0xf44, 0xf74, 0xf63, 0xf0b, 0xf40,
0xfb2, 0xf58, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61,
0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x44, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x53, 0x20,
0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x45, 0x61, 0x73, 0x74, 0x20, 0x43, 0x61, 0x72, 0x69, 0x62, 0x62, 0x65,
0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x45, 0x61, 0x73, 0x74, 0x20, 0x43, 0x61, 0x72, 0x69,
0x62, 0x62, 0x65, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x61, 0x73, 0x74,
0x20, 0x43, 0x61, 0x72, 0x69, 0x62, 0x62, 0x65, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x41,
0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x41, 0x75,
0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x41,
0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x45, 0x75,
0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x73, 0x3b, 0x42, 0x61,
0x68, 0x61, 0x6d, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x42, 0x61, 0x68, 0x61, 0x6d,
0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x61, 0x68, 0x61, 0x6d, 0x69,
0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e,
0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72,
0x3b, 0x3b, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x42,
0x65, 0x6c, 0x69, 0x7a, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64,
0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x69, 0x61,
0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x69, 0x61,
0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42, 0x6f, 0x74, 0x73, 0x77, 0x61, 0x6e, 0x61, 0x6e, 0x20,
0x50, 0x75, 0x6c, 0x61, 0x3b, 0x3b, 0x42, 0x6f, 0x74, 0x73, 0x77, 0x61, 0x6e, 0x61, 0x6e, 0x20, 0x70, 0x75, 0x6c, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x6f, 0x74, 0x73, 0x77, 0x61, 0x6e, 0x61, 0x6e, 0x20, 0x70, 0x75, 0x6c, 0x61, 0x73, 0x3b,
0x42, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x42, 0x75, 0x72,
0x75, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x75, 0x72, 0x75,
0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x3b, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c,
0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x43, 0x46, 0x41, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b,
0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x43, 0x46, 0x41, 0x20,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x20, 0x41, 0x66, 0x72,
0x69, 0x63, 0x61, 0x6e, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x3b, 0x43, 0x61, 0x6e, 0x61,
0x64, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61,
0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x43, 0x61, 0x79, 0x6d, 0x61, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61,
0x6e, 0x64, 0x73, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x43, 0x61, 0x79, 0x6d, 0x61, 0x6e, 0x20, 0x49,
0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x61, 0x79,
0x6d, 0x61, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b,
0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b,
0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b,
0x3b, 0x3b, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72,
0x73, 0x3b, 0x44, 0x61, 0x6e, 0x69, 0x73, 0x68, 0x20, 0x4b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x44, 0x61, 0x6e, 0x69,
0x73, 0x68, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x61, 0x6e, 0x69, 0x73, 0x68, 0x20, 0x6b,
0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b, 0x45, 0x72, 0x69, 0x74, 0x72, 0x65, 0x61, 0x6e, 0x20, 0x4e, 0x61, 0x6b, 0x66, 0x61,
0x3b, 0x3b, 0x45, 0x72, 0x69, 0x74, 0x72, 0x65, 0x61, 0x6e, 0x20, 0x6e, 0x61, 0x6b, 0x66, 0x61, 0x3b, 0x3b, 0x3b, 0x3b,
0x45, 0x72, 0x69, 0x74, 0x72, 0x65, 0x61, 0x6e, 0x20, 0x6e, 0x61, 0x6b, 0x66, 0x61, 0x73, 0x3b, 0x53, 0x77, 0x61, 0x7a,
0x69, 0x20, 0x4c, 0x69, 0x6c, 0x61, 0x6e, 0x67, 0x65, 0x6e, 0x69, 0x3b, 0x3b, 0x53, 0x77, 0x61, 0x7a, 0x69, 0x20, 0x6c,
0x69, 0x6c, 0x61, 0x6e, 0x67, 0x65, 0x6e, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x77, 0x61, 0x7a, 0x69, 0x20, 0x65, 0x6d,
0x61, 0x6c, 0x61, 0x6e, 0x67, 0x65, 0x6e, 0x69, 0x3b, 0x46, 0x61, 0x6c, 0x6b, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x49, 0x73,
0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x46, 0x61, 0x6c, 0x6b, 0x6c, 0x61, 0x6e,
0x64, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x46,
0x61, 0x6c, 0x6b, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x70, 0x6f, 0x75, 0x6e,
0x64, 0x73, 0x3b, 0x46, 0x69, 0x6a, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x46, 0x69,
0x6a, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x69, 0x6a, 0x69, 0x61,
0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x47, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x61,
0x6c, 0x61, 0x73, 0x69, 0x3b, 0x3b, 0x47, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x61, 0x6c, 0x61, 0x73, 0x69,
0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x61, 0x6c, 0x61, 0x73, 0x69, 0x73, 0x3b,
0x47, 0x68, 0x61, 0x6e, 0x61, 0x69, 0x61, 0x6e, 0x20, 0x43, 0x65, 0x64, 0x69, 0x3b, 0x3b, 0x47, 0x68, 0x61, 0x6e, 0x61,
0x69, 0x61, 0x6e, 0x20, 0x63, 0x65, 0x64, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x69, 0x61, 0x6e,
0x20, 0x63, 0x65, 0x64, 0x69, 0x73, 0x3b, 0x47, 0x69, 0x62, 0x72, 0x61, 0x6c, 0x74, 0x61, 0x72, 0x20, 0x50, 0x6f, 0x75,
0x6e, 0x64, 0x3b, 0x3b, 0x47, 0x69, 0x62, 0x72, 0x61, 0x6c, 0x74, 0x61, 0x72, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b,
0x3b, 0x3b, 0x3b, 0x47, 0x69, 0x62, 0x72, 0x61, 0x6c, 0x74, 0x61, 0x72, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b,
0x55, 0x4b, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x55, 0x4b, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b,
0x3b, 0x3b, 0x55, 0x4b, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x65, 0x73,
0x65, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x65, 0x73, 0x65, 0x20,
0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x65, 0x73, 0x65, 0x20,
0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x44, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x73, 0x3b, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x49, 0x6e,
0x64, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e,
0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x49, 0x73, 0x72, 0x61, 0x65, 0x6c, 0x69, 0x20, 0x4e, 0x65, 0x77, 0x20,
0x53, 0x68, 0x65, 0x6b, 0x65, 0x6c, 0x3b, 0x3b, 0x49, 0x73, 0x72, 0x61, 0x65, 0x6c, 0x69, 0x20, 0x6e, 0x65, 0x77, 0x20,
0x73, 0x68, 0x65, 0x6b, 0x65, 0x6c, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x73, 0x72, 0x61, 0x65, 0x6c, 0x69, 0x20, 0x6e, 0x65,
0x77, 0x20, 0x73, 0x68, 0x65, 0x6b, 0x65, 0x6c, 0x73, 0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x44,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x73, 0x3b, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x6e, 0x20, 0x53, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b,
0x4b, 0x65, 0x6e, 0x79, 0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x3b, 0x3b, 0x4b,
0x65, 0x6e, 0x79, 0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x3b, 0x53, 0x6f, 0x75, 0x74,
0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x6f, 0x75, 0x74,
0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6f,
0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x4c, 0x69, 0x62,
0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69,
0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x61,
0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4d, 0x61, 0x63, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x50,
0x61, 0x74, 0x61, 0x63, 0x61, 0x3b, 0x3b, 0x4d, 0x61, 0x63, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x61, 0x74, 0x61,
0x63, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x63, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x61, 0x74, 0x61, 0x63,
0x61, 0x73, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x67, 0x61, 0x73, 0x79, 0x20, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x3b, 0x3b,
0x4d, 0x61, 0x6c, 0x61, 0x67, 0x61, 0x73, 0x79, 0x20, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d,
0x61, 0x6c, 0x61, 0x67, 0x61, 0x73, 0x79, 0x20, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x77,
0x69, 0x61, 0x6e, 0x20, 0x4b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69, 0x61, 0x6e,
0x20, 0x6b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69, 0x61, 0x6e, 0x20,
0x6b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x73, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x52, 0x69,
0x6e, 0x67, 0x67, 0x69, 0x74, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x69, 0x6e,
0x67, 0x67, 0x69, 0x74, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x69,
0x6e, 0x67, 0x67, 0x69, 0x74, 0x73, 0x3b, 0x4d, 0x61, 0x6c, 0x64, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x66,
0x69, 0x79, 0x61, 0x61, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x64, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x66, 0x69,
0x79, 0x61, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x64, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x66,
0x69, 0x79, 0x61, 0x61, 0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65,
0x3b, 0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b,
0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x4e, 0x61,
0x6d, 0x69, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69, 0x62,
0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69,
0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20,
0x4e, 0x61, 0x69, 0x72, 0x61, 0x3b, 0x3b, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x6e, 0x61, 0x69, 0x72,
0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x6e, 0x61, 0x69, 0x72, 0x61, 0x73,
0x3b, 0x50, 0x61, 0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x69, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x50, 0x61,
0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x69, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x6b,
0x69, 0x73, 0x74, 0x61, 0x6e, 0x69, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x50, 0x61, 0x70, 0x75, 0x61, 0x20,
0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x4b, 0x69, 0x6e, 0x61, 0x3b, 0x3b, 0x50, 0x61,
0x70, 0x75, 0x61, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x6b, 0x69, 0x6e, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x70, 0x75, 0x61, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61,
0x6e, 0x20, 0x6b, 0x69, 0x6e, 0x61, 0x3b, 0x52, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x6e, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x63,
0x3b, 0x3b, 0x52, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x6e, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x3b, 0x3b, 0x52,
0x77, 0x61, 0x6e, 0x64, 0x61, 0x6e, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x3b, 0x53, 0x61, 0x6d, 0x6f, 0x61, 0x6e,
0x20, 0x54, 0x61, 0x6c, 0x61, 0x3b, 0x3b, 0x53, 0x61, 0x6d, 0x6f, 0x61, 0x6e, 0x20, 0x74, 0x61, 0x6c, 0x61, 0x3b, 0x3b,
0x3b, 0x3b, 0x53, 0x61, 0x6d, 0x6f, 0x61, 0x6e, 0x20, 0x74, 0x61, 0x6c, 0x61, 0x3b, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65,
0x6c, 0x6c, 0x6f, 0x69, 0x73, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c,
0x6c, 0x6f, 0x69, 0x73, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65,
0x6c, 0x6c, 0x6f, 0x69, 0x73, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x53, 0x69, 0x65, 0x72, 0x72, 0x61, 0x20,
0x4c, 0x65, 0x6f, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x53, 0x69, 0x65, 0x72, 0x72,
0x61, 0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x6c, 0x65, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x53,
0x69, 0x65, 0x72, 0x72, 0x61, 0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x6c, 0x65, 0x6f, 0x6e, 0x65, 0x73,
0x3b, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x6f, 0x72, 0x65, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x53,
0x69, 0x6e, 0x67, 0x61, 0x70, 0x6f, 0x72, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x53,
0x69, 0x6e, 0x67, 0x61, 0x70, 0x6f, 0x72, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4e, 0x65, 0x74,
0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x6e, 0x20, 0x47,
0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x3b, 0x3b, 0x4e, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20,
0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x6e, 0x20, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x3b, 0x3b, 0x3b,
0x3b, 0x4e, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x65,
0x61, 0x6e, 0x20, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x3b, 0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x20,
0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x53, 0x6f, 0x6c, 0x6f,
0x6d, 0x6f, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b,
0x3b, 0x3b, 0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65,
0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65,
0x73, 0x65, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x53, 0x75,
0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x53, 0x74, 0x20, 0x48, 0x65, 0x6c,
0x65, 0x6e, 0x61, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x74, 0x20, 0x48, 0x65, 0x6c, 0x65, 0x6e, 0x61,
0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x74, 0x20, 0x48, 0x65, 0x6c, 0x65, 0x6e, 0x61, 0x20,
0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x50, 0x6f, 0x75, 0x6e,
0x64, 0x3b, 0x3b, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b,
0x3b, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x53, 0x77, 0x65,
0x64, 0x69, 0x73, 0x68, 0x20, 0x4b, 0x72, 0x6f, 0x6e, 0x61, 0x3b, 0x3b, 0x53, 0x77, 0x65, 0x64, 0x69, 0x73, 0x68, 0x20,
0x6b, 0x72, 0x6f, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x77, 0x65, 0x64, 0x69, 0x73, 0x68, 0x20, 0x6b, 0x72, 0x6f,
0x6e, 0x6f, 0x72, 0x3b, 0x53, 0x77, 0x69, 0x73, 0x73, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x53, 0x77, 0x69,
0x73, 0x73, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x77, 0x69, 0x73, 0x73, 0x20, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x73, 0x3b, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x6e, 0x20, 0x53, 0x68, 0x69, 0x6c, 0x6c,
0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c,
0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x3b, 0x3b, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x6e, 0x20, 0x73, 0x68, 0x69,
0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x3b, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x20, 0x50, 0x61, 0x2bb, 0x61, 0x6e, 0x67,
0x61, 0x3b, 0x3b, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x20, 0x70, 0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x3b, 0x3b,
0x3b, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x20, 0x70, 0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x54, 0x72, 0x69, 0x6e,
0x69, 0x64, 0x61, 0x64, 0x20, 0x26, 0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72,
0x3b, 0x3b, 0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x26, 0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f, 0x20,
0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x26,
0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x55, 0x67, 0x61, 0x6e,
0x64, 0x61, 0x6e, 0x20, 0x53, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61,
0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61,
0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x3b, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x41,
0x72, 0x61, 0x62, 0x20, 0x45, 0x6d, 0x69, 0x72, 0x61, 0x74, 0x65, 0x73, 0x20, 0x44, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x3b,
0x3b, 0x55, 0x41, 0x45, 0x20, 0x64, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x41, 0x45, 0x20, 0x64,
0x69, 0x72, 0x68, 0x61, 0x6d, 0x73, 0x3b, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64,
0x3b, 0x3b, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x42,
0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x56, 0x61, 0x6e, 0x75, 0x61, 0x74,
0x75, 0x20, 0x76, 0x61, 0x74, 0x75, 0x3b, 0x3b, 0x56, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x20, 0x76, 0x61, 0x74, 0x75,
0x3b, 0x3b, 0x3b, 0x3b, 0x56, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x20, 0x76, 0x61, 0x74, 0x75, 0x3b, 0x5a, 0x61, 0x6d,
0x62, 0x69, 0x61, 0x6e, 0x20, 0x4b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x3b, 0x3b, 0x5a, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e,
0x20, 0x6b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x5a, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x6b,
0x77, 0x61, 0x63, 0x68, 0x61, 0x73, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b,
0x3b, 0x65, 0x75, 0x72, 0x6f, 0x74, 0x3b, 0x67, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x73, 0x69, 0x256, 0x69, 0x3b, 0x3b, 0x67,
0x68, 0x61, 0x6e, 0x61, 0x20, 0x73, 0x69, 0x256, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x67, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x73,
0x69, 0x256, 0x69, 0x3b, 0x263, 0x65, 0x74, 0x6f, 0x256, 0x6f, 0x66, 0x65, 0x20, 0x61, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x67,
0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x263,
0x65, 0x74, 0x6f, 0x256, 0x6f, 0x66, 0x65, 0x20, 0x61, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41,
0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x263, 0x65, 0x74, 0x6f,
0x256, 0x6f, 0x66, 0x65, 0x20, 0x61, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x46, 0x259, 0x6c, 0xe1, 0x14b, 0x20, 0x43, 0x46, 0x41, 0x20,
0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x6f, 0x6e, 0x73, 0x6b, 0x20, 0x6b,
0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b, 0x64, 0x6f, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b, 0x3b,
0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x61, 0x72, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x75, 0x72, 0x3b, 0x50, 0x69, 0x73, 0x6f,
0x20, 0x6e, 0x67, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x3b, 0x70, 0x69, 0x73, 0x6f, 0x20,
0x6e, 0x67, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x69, 0x73, 0x6f,
0x20, 0x6e, 0x67, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b,
0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x61, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20,
0x61, 0x6c, 0x67, 0xe9, 0x72, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x61, 0x6c, 0x67, 0xe9,
0x72, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x73, 0x20, 0x61, 0x6c, 0x67, 0xe9, 0x72,
0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41,
0x4f, 0x29, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f,
0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45,
0x41, 0x4f, 0x29, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b,
0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x3b, 0x3b,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x66, 0x72, 0x61,
0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63,
0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63,
0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x20,
0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x20, 0x63, 0x61, 0x6e,
0x61, 0x64, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x20, 0x63, 0x61, 0x6e,
0x61, 0x64, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6d, 0x6f, 0x72, 0x69, 0x65,
0x6e, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b,
0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x63, 0x6f, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63,
0x20, 0x63, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73,
0x20, 0x63, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x69, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x64, 0x6a, 0x69,
0x62, 0x6f, 0x75, 0x74, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x64, 0x6a, 0x69, 0x62, 0x6f,
0x75, 0x74, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x64, 0x6a, 0x69, 0x62,
0x6f, 0x75, 0x74, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x50, 0x3b, 0x3b, 0x66,
0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x50, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x43,
0x46, 0x50, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x67, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x6e, 0x3b, 0x3b, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x20, 0x67, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63,
0x73, 0x20, 0x67, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x6e, 0x73, 0x3b, 0x67, 0x6f, 0x75, 0x72, 0x64, 0x65, 0x20, 0x68, 0x61,
0xef, 0x74, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x67, 0x6f, 0x75, 0x72, 0x64, 0x65, 0x20, 0x68, 0x61, 0xef, 0x74,
0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x67, 0x6f, 0x75, 0x72, 0x64, 0x65, 0x73, 0x20, 0x68, 0x61, 0xef,
0x74, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x73, 0x3b, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61,
0x63, 0x68, 0x65, 0x3b, 0x3b, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61, 0x63, 0x68, 0x65,
0x3b, 0x3b, 0x3b, 0x3b, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x73, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61, 0x63, 0x68, 0x65,
0x73, 0x3b, 0x6f, 0x75, 0x67, 0x75, 0x69, 0x79, 0x61, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x65,
0x6e, 0x3b, 0x3b, 0x6f, 0x75, 0x67, 0x75, 0x69, 0x79, 0x61, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69,
0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x6f, 0x75, 0x67, 0x75, 0x69, 0x79, 0x61, 0x73, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69,
0x74, 0x61, 0x6e, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69,
0x63, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69,
0x63, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x73, 0x20, 0x6d, 0x61,
0x75, 0x72, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x20, 0x6d, 0x61,
0x72, 0x6f, 0x63, 0x61, 0x69, 0x6e, 0x3b, 0x3b, 0x64, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x20, 0x6d, 0x61, 0x72, 0x6f, 0x63,
0x61, 0x69, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x73, 0x20, 0x6d, 0x61, 0x72, 0x6f, 0x63,
0x61, 0x69, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b,
0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x66,
0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69,
0x65, 0x20, 0x64, 0x65, 0x73, 0x20, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x65, 0x73, 0x3b, 0x3b, 0x72, 0x6f,
0x75, 0x70, 0x69, 0x65, 0x20, 0x64, 0x65, 0x73, 0x20, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x65, 0x73, 0x3b,
0x3b, 0x3b, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x73, 0x20, 0x64, 0x65, 0x73, 0x20, 0x53, 0x65, 0x79, 0x63, 0x68,
0x65, 0x6c, 0x6c, 0x65, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x3b, 0x3b,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x73, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x73, 0x3b, 0x6c, 0x69, 0x76, 0x72, 0x65, 0x20, 0x73, 0x79, 0x72,
0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x6c, 0x69, 0x76, 0x72, 0x65, 0x20, 0x73, 0x79, 0x72, 0x69, 0x65, 0x6e, 0x6e,
0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x6c, 0x69, 0x76, 0x72, 0x65, 0x73, 0x20, 0x73, 0x79, 0x72, 0x69, 0x65, 0x6e, 0x6e, 0x65,
0x73, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x74, 0x75, 0x6e, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x64, 0x69,
0x6e, 0x61, 0x72, 0x20, 0x74, 0x75, 0x6e, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x69, 0x6e, 0x61,
0x72, 0x73, 0x20, 0x74, 0x75, 0x6e, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x76, 0x61, 0x74, 0x75, 0x20, 0x76, 0x61,
0x6e, 0x75, 0x61, 0x74, 0x75, 0x61, 0x6e, 0x3b, 0x3b, 0x76, 0x61, 0x74, 0x75, 0x20, 0x76, 0x61, 0x6e, 0x75, 0x61, 0x74,
0x75, 0x61, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x76, 0x61, 0x74, 0x75, 0x73, 0x20, 0x76, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75,
0x61, 0x6e, 0x73, 0x3b, 0x4d, 0x62, 0x75, 0x75, 0x257, 0x75, 0x20, 0x53, 0x65, 0x65, 0x66, 0x61, 0x61, 0x20, 0x42, 0x43,
0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xd83a, 0xdd0a, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd32,
0x20, 0xd83a, 0xdd05, 0xd83a, 0xdd0a, 0xd83a, 0xdd00, 0x20, 0xd83a, 0xdd16, 0xd83a, 0xdd2d, 0xd83a, 0xdd45, 0xd83a, 0xdd2a, 0xd83a, 0xdd32, 0xd83a, 0xdd22,
0xd83a, 0xdd44, 0xd83a, 0xdd32, 0xd83a, 0xdd3a, 0xd83a, 0xdd2b, 0x20, 0xd83a, 0xdd00, 0xd83a, 0xdd2c, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a, 0xdd33, 0xd83a,
0xdd22, 0x3b, 0x3b, 0xd83a, 0xdd2c, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0x20, 0xd83a, 0xdd05, 0xd83a, 0xdd0a, 0xd83a, 0xdd00,
0x20, 0xd83a, 0xdd16, 0xd83a, 0xdd2d, 0xd83a, 0xdd45, 0xd83a, 0xdd2a, 0xd83a, 0xdd32, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd32, 0xd83a, 0xdd3a, 0xd83a,
0xdd2b, 0x20, 0xd83a, 0xdd00, 0xd83a, 0xdd2c, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a, 0xdd33, 0xd83a, 0xdd22, 0x3b, 0x3b, 0x3b, 0x3b, 0xd83a, 0xdd2c,
0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd36, 0xd83a, 0xdd2d, 0x20, 0xd83a, 0xdd05, 0xd83a, 0xdd0a, 0xd83a, 0xdd00, 0x20,
0xd83a, 0xdd16, 0xd83a, 0xdd2d, 0xd83a, 0xdd45, 0xd83a, 0xdd2a, 0xd83a, 0xdd32, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd32, 0xd83a, 0xdd3a, 0xd83a, 0xdd2b,
0x20, 0xd83a, 0xdd00, 0xd83a, 0xdd2c, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a, 0xdd33, 0xd83a, 0xdd22, 0x3b, 0xd83a, 0xdd0a, 0xd83a, 0xdd22, 0xd83a, 0xdd2a,
0xd83a, 0xdd22, 0xd83a, 0xdd32, 0x20, 0xd83a, 0xdd1a, 0xd83a, 0xdd35, 0xd83a, 0xdd26, 0xd83a, 0xdd2e, 0xd83a, 0xdd45, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0x20,
0xd83a, 0xdd00, 0xd83a, 0xdd2c, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a, 0xdd33, 0xd83a, 0xdd2d, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0x3b,
0xd83a, 0xdd2c, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0x20, 0xd83a, 0xdd1a, 0xd83a, 0xdd35, 0xd83a, 0xdd26, 0xd83a, 0xdd2e, 0xd83a,
0xdd45, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0x20, 0xd83a, 0xdd00, 0xd83a, 0xdd2c, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a, 0xdd33, 0xd83a, 0xdd2d, 0xd83a, 0xdd32,
0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0x3b, 0x3b, 0x3b, 0xd83a, 0xdd2c, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd36,
0xd83a, 0xdd2d, 0x20, 0xd83a, 0xdd1a, 0xd83a, 0xdd35, 0xd83a, 0xdd26, 0xd83a, 0xdd2e, 0xd83a, 0xdd45, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0x20, 0xd83a, 0xdd00,
0xd83a, 0xdd2c, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a, 0xdd33, 0xd83a, 0xdd2d, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0xd83a, 0xdd01, 0xd83a,
0xdd22, 0xd83a, 0xdd24, 0xd83a, 0xdd22, 0xd83a, 0xdd27, 0xd83a, 0xdd2d, 0x20, 0xd83a, 0xdd18, 0xd83a, 0xdd22, 0xd83a, 0xdd25, 0xd83a, 0xdd26, 0xd83a, 0xdd2d,
0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0x3b, 0xd83a, 0xdd23, 0xd83a, 0xdd22, 0xd83a, 0xdd24, 0xd83a, 0xdd22, 0xd83a, 0xdd27, 0xd83a, 0xdd2d,
0x20, 0xd83a, 0xdd18, 0xd83a, 0xdd22, 0xd83a, 0xdd25, 0xd83a, 0xdd26, 0xd83a, 0xdd2d, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0x3b, 0x3b,
0x3b, 0xd83a, 0xdd23, 0xd83a, 0xdd22, 0xd83a, 0xdd24, 0xd83a, 0xdd22, 0xd83a, 0xdd27, 0xd83a, 0xdd2d, 0xd83a, 0xdd45, 0xd83a, 0xdd36, 0xd83a, 0xdd2d, 0x20,
0xd83a, 0xdd18, 0xd83a, 0xdd22, 0xd83a, 0xdd25, 0xd83a, 0xdd26, 0xd83a, 0xdd2d, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0xd83a, 0xdd05, 0xd83a,
0xdd2d, 0xd83a, 0xdd23, 0xd83a, 0xdd2d, 0x20, 0xd83a, 0xdd18, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e,
0x3b, 0x3b, 0xd83a, 0xdd27, 0xd83a, 0xdd2d, 0xd83a, 0xdd23, 0xd83a, 0xdd2d, 0x20, 0xd83a, 0xdd18, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd22, 0xd83a,
0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0x3b, 0x3b, 0x3b, 0xd83a, 0xdd27, 0xd83a, 0xdd2d, 0xd83a, 0xdd23, 0xd83a, 0xdd2d, 0xd83a, 0xdd45, 0xd83a,
0xdd36, 0xd83a, 0xdd2d, 0x20, 0xd83a, 0xdd18, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0xd83a,
0xdd0a, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0x20, 0xd83a, 0xdd18, 0xd83a, 0xdd2d, 0xd83a, 0xdd32, 0xd83a, 0xdd2b, 0xd83a, 0xdd32,
0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0x3b, 0xd83a, 0xdd2c, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0x20, 0xd83a, 0xdd18, 0xd83a,
0xdd2d, 0xd83a, 0xdd32, 0xd83a, 0xdd2b, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0x3b, 0x3b, 0x3b, 0xd83a, 0xdd2c, 0xd83a, 0xdd22, 0xd83a,
0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd36, 0xd83a, 0xdd2d, 0x20, 0xd83a, 0xdd18, 0xd83a, 0xdd2d, 0xd83a, 0xdd32, 0xd83a, 0xdd2b, 0xd83a, 0xdd32,
0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0xd83a, 0xdd01, 0xd83a, 0xdd22, 0xd83a, 0xdd24, 0xd83a, 0xdd22, 0x20, 0xd83a, 0xdd02, 0xd83a, 0xdd2d, 0xd83a, 0xdd26,
0xd83a, 0xdd2b, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a, 0xdd34, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0x3b, 0xd83a, 0xdd23,
0xd83a, 0xdd22, 0xd83a, 0xdd24, 0xd83a, 0xdd22, 0x20, 0xd83a, 0xdd02, 0xd83a, 0xdd2d, 0xd83a, 0xdd26, 0xd83a, 0xdd2b, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a,
0xdd34, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0x3b, 0x3b, 0x3b, 0xd83a, 0xdd23, 0xd83a, 0xdd22, 0xd83a, 0xdd24, 0xd83a,
0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd36, 0xd83a, 0xdd2d, 0x20, 0xd83a, 0xdd02, 0xd83a, 0xdd2d, 0xd83a, 0xdd26, 0xd83a, 0xdd2b, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d,
0xd83a, 0xdd34, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0xd83a, 0xdd13, 0xd83a, 0xdd3a, 0xd83a, 0xdd2d, 0xd83a, 0xdd34, 0xd83a,
0xdd22, 0x20, 0xd83a, 0xdd03, 0xd83a, 0xdd2e, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a, 0xdd3c, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd2d, 0xd83a, 0xdd34,
0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0x3b, 0xd83a, 0xdd35, 0xd83a, 0xdd3a, 0xd83a, 0xdd2d, 0xd83a, 0xdd34, 0xd83a, 0xdd22,
0x20, 0xd83a, 0xdd03, 0xd83a, 0xdd2e, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a, 0xdd3c, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd2d, 0xd83a, 0xdd34, 0xd83a,
0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0x3b, 0x3b, 0x3b, 0xd83a, 0xdd35, 0xd83a, 0xdd3a, 0xd83a, 0xdd2d, 0xd83a, 0xdd34, 0xd83a,
0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd36, 0xd83a, 0xdd2d, 0x20, 0xd83a, 0xdd03, 0xd83a, 0xdd2e, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a, 0xdd3c, 0xd83a, 0xdd22,
0xd83a, 0xdd32, 0xd83a, 0xdd2d, 0xd83a, 0xdd34, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0xd83a, 0xdd10, 0xd83a, 0xdd22, 0xd83a,
0xdd34, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0x20, 0xd83a, 0xdd10, 0xd83a, 0xdd22, 0xd83a, 0xdd36, 0xd83a, 0xdd2d, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd34,
0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0x3b, 0xd83a, 0xdd32, 0xd83a, 0xdd22, 0xd83a, 0xdd34, 0xd83a, 0xdd2a, 0xd83a, 0xdd22,
0x20, 0xd83a, 0xdd10, 0xd83a, 0xdd22, 0xd83a, 0xdd36, 0xd83a, 0xdd2d, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd34, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a,
0xdd33, 0xd83a, 0xdd2e, 0x3b, 0x3b, 0x3b, 0x3b, 0xd83a, 0xdd32, 0xd83a, 0xdd22, 0xd83a, 0xdd34, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a,
0xdd36, 0xd83a, 0xdd2d, 0x20, 0xd83a, 0xdd10, 0xd83a, 0xdd22, 0xd83a, 0xdd36, 0xd83a, 0xdd2d, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd34, 0xd83a, 0xdd22,
0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0x3b, 0x4d, 0x62, 0x75, 0x75, 0x257, 0x69, 0x20, 0x53, 0x65, 0x65, 0x66, 0x61, 0x61,
0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x61, 0x6c, 0x61, 0x73, 0x69, 0x20, 0x47,
0x61, 0x6d, 0x6d, 0x62, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x6f, 0x6c, 0x61, 0x61, 0x72, 0x20, 0x4c,
0x69, 0x62, 0x65, 0x72, 0x69, 0x79, 0x61, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x67, 0x69, 0x79, 0x79,
0x61, 0x20, 0x4d, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x79,
0x72, 0x61, 0x61, 0x20, 0x4e, 0x69, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x47, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x53, 0x69, 0x64, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x68, 0x61, 0x6e,
0x61, 0x20, 0x73, 0x69, 0x64, 0x69, 0x69, 0x3b, 0x50, 0x75, 0x6e, 0x6e, 0x64, 0x20, 0x53, 0x61, 0x73, 0x61, 0x6e, 0x6e,
0x61, 0x63, 0x68, 0x3b, 0x3b, 0x70, 0x68, 0x75, 0x6e, 0x6e, 0x64, 0x20, 0x53, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63,
0x68, 0x3b, 0x70, 0x68, 0x75, 0x6e, 0x6e, 0x64, 0x20, 0x53, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68, 0x3b, 0x70,
0x75, 0x69, 0x6e, 0x6e, 0x64, 0x20, 0x53, 0x68, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68, 0x3b, 0x3b, 0x70, 0x75,
0x6e, 0x6e, 0x64, 0x20, 0x53, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68, 0x3b, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67,
0x69, 0x20, 0x65, 0x79, 0x61, 0x20, 0x59, 0x75, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x20, 0x1265, 0x122d, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x10e5, 0x10d0, 0x10e0, 0x10d7,
0x10e3, 0x10da, 0x10d8, 0x20, 0x10da, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x3b, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x20, 0x10da, 0x10d0,
0x10e0, 0x10d8, 0x3b, 0x3b, 0x3b, 0x3b, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x20, 0x10da, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x45,
0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x53, 0x63,
0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e, 0x3b, 0x3b, 0x53, 0x63, 0x68,
0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x63,
0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e, 0x3b, 0x395, 0x3c5, 0x3c1, 0x3ce,
0x3b, 0x3b, 0x3b5, 0x3c5, 0x3c1, 0x3ce, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b5, 0x3c5, 0x3c1, 0x3ce, 0x3b, 0xaad, 0xabe, 0xab0, 0xaa4, 0xac0,
0xaaf, 0x20, 0xab0, 0xac2, 0xaaa, 0xabf, 0xaaf, 0xabe, 0x3b, 0x3b, 0xaad, 0xabe, 0xab0, 0xaa4, 0xac0, 0xaaf, 0x20, 0xab0, 0xac2, 0xaaa,
0xabf, 0xaaf, 0xabe, 0x3b, 0x3b, 0x3b, 0x3b, 0xaad, 0xabe, 0xab0, 0xaa4, 0xac0, 0xaaf, 0x20, 0xab0, 0xac2, 0xaaa, 0xabf, 0xaaf, 0xabe,
0x3b, 0x4e, 0x61, 0x69, 0x72, 0x61, 0x72, 0x20, 0x4e, 0x61, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61, 0x3b, 0x3b, 0x4e, 0x61,
0x69, 0x72, 0x61, 0x72, 0x20, 0x4e, 0x69, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x69,
0x72, 0x61, 0x72, 0x20, 0x4e, 0x69, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61, 0x3b, 0x646, 0x64e, 0x64a, 0x652, 0x631, 0x64e, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x64, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x3b,
0x3b, 0x53, 0x69, 0x64, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69,
0x64, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x3b, 0x4b, 0x75, 0x257, 0x69, 0x6e, 0x20, 0x53, 0x65,
0x66, 0x61, 0x20, 0x6e, 0x61, 0x20, 0x41, 0x66, 0x69, 0x72, 0x6b, 0x61, 0x20, 0x54, 0x61, 0x20, 0x59, 0x61, 0x6d, 0x6d,
0x61, 0x3b, 0x3b, 0x4b, 0x75, 0x257, 0x69, 0x6e, 0x20, 0x53, 0x65, 0x66, 0x61, 0x20, 0x6e, 0x61, 0x20, 0x41, 0x66, 0x69,
0x72, 0x6b, 0x61, 0x20, 0x54, 0x61, 0x20, 0x59, 0x61, 0x6d, 0x6d, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4b, 0x75, 0x257, 0x69,
0x6e, 0x20, 0x53, 0x65, 0x66, 0x61, 0x20, 0x6e, 0x61, 0x20, 0x41, 0x66, 0x69, 0x72, 0x6b, 0x61, 0x20, 0x54, 0x61, 0x20,
0x59, 0x61, 0x6d, 0x6d, 0x61, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x3b, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x20, 0x5d7,
0x5d3, 0x5e9, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x5d9, 0x5dd, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x5d9, 0x5dd, 0x3b, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x5d9,
0x5dd, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x5d9, 0x5dd, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x5d9, 0x5dd, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x5d9, 0x5dd, 0x3b,
0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f,
0x20, 0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a,
0x90f, 0x3b, 0x6d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x20, 0x66, 0x6f, 0x72, 0x69, 0x6e, 0x74, 0x3b, 0x3b, 0x6d, 0x61, 0x67,
0x79, 0x61, 0x72, 0x20, 0x66, 0x6f, 0x72, 0x69, 0x6e, 0x74, 0x3b, 0x3b, 0x3b, 0x3b, 0x6d, 0x61, 0x67, 0x79, 0x61, 0x72,
0x20, 0x66, 0x6f, 0x72, 0x69, 0x6e, 0x74, 0x3b, 0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e,
0x61, 0x3b, 0x3b, 0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b,
0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x61, 0x72, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x75, 0x72, 0x3b, 0x4e, 0x61, 0x1ecb,
0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x1ecb, 0x72, 0x61, 0x3b, 0x52, 0x75, 0x70, 0x69, 0x61, 0x68,
0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x75, 0x70, 0x69,
0x61, 0x68, 0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65,
0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65,
0x75, 0x72, 0x6f, 0x3b, 0x50, 0x75, 0x6e, 0x74, 0x20, 0x53, 0x74, 0x65, 0x69, 0x72, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b,
0x70, 0x68, 0x75, 0x6e, 0x74, 0x20, 0x73, 0x74, 0x65, 0x69, 0x72, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x70, 0x68, 0x75, 0x6e,
0x74, 0x20, 0x73, 0x74, 0x65, 0x69, 0x72, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x70, 0x68, 0x75, 0x6e, 0x74, 0x20, 0x73, 0x74,
0x65, 0x69, 0x72, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x62, 0x70, 0x75, 0x6e, 0x74, 0x20, 0x73, 0x74, 0x65, 0x69, 0x72, 0x6c,
0x69, 0x6e, 0x67, 0x3b, 0x70, 0x75, 0x6e, 0x74, 0x20, 0x73, 0x74, 0x65, 0x69, 0x72, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x65,
0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x6f, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x6f, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63,
0x6f, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x68,
0x69, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x69, 0x3b, 0x65e5, 0x672c, 0x5186, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x5186, 0x3b, 0x41, 0x331, 0x6e, 0x61, 0x69, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x65, 0x65, 0x66,
0x61, 0x20, 0x79, 0x61, 0x74, 0x69, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53,
0x6b, 0x75, 0x64, 0x75, 0x20, 0x4b, 0x61, 0x62, 0x75, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x75, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x53, 0x6b, 0x75, 0x64, 0x75, 0x20, 0x4b, 0x61, 0x62, 0x75, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e,
0x75, 0x3b, 0x41, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x41, 0x7a, 0x7a, 0x61, 0x79, 0x72, 0x69, 0x3b, 0x3b, 0x41, 0x64,
0x69, 0x6e, 0x61, 0x72, 0x20, 0x6e, 0x20, 0x4c, 0x65, 0x7a, 0x7a, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x49,
0x64, 0x69, 0x6e, 0x61, 0x72, 0x65, 0x6e, 0x20, 0x6e, 0x20, 0x4c, 0x65, 0x7a, 0x7a, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x4d,
0x72, 0x61, 0x73, 0x69, 0x72, 0x20, 0x52, 0x65, 0x6a, 0x61, 0x72, 0x3b, 0x3b, 0x4d, 0x72, 0x61, 0x73, 0x69, 0x72, 0x20,
0x52, 0x65, 0x6a, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x72, 0x61, 0x73, 0x69, 0x72, 0x20, 0x52, 0x65, 0x6a, 0x61,
0x72, 0x20, 0x61, 0x67, 0x3b, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x64, 0x61, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6d, 0x75, 0x74, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x75, 0x6e, 0x69,
0x3b, 0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x69, 0x6e, 0x75, 0x74, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x75, 0x6e, 0x69, 0x3b,
0x3b, 0x3b, 0x3b, 0x64, 0x61, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6d, 0x75, 0x74, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x75,
0x6e, 0x69, 0x3b, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x74, 0x61, 0x62, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e,
0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20,
0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xcad, 0xcbe, 0xcb0, 0xca4, 0xcc0, 0xcaf, 0x20, 0xcb0,
0xcc2, 0xcaa, 0xcbe, 0xcaf, 0xcbf, 0x3b, 0x3b, 0xcad, 0xcbe, 0xcb0, 0xca4, 0xcc0, 0xcaf, 0x20, 0xcb0, 0xcc2, 0xcaa, 0xcbe, 0xcaf, 0xcbf,
0x3b, 0x3b, 0x3b, 0x3b, 0xcad, 0xcbe, 0xcb0, 0xca4, 0xcc0, 0xcaf, 0x20, 0xcb0, 0xcc2, 0xcaa, 0xcbe, 0xcaf, 0xcbf, 0xc97, 0xcb3, 0xcc1,
0x3b, 0x6c1, 0x650, 0x646, 0x62f, 0x64f, 0x633, 0x62a, 0x672, 0x646, 0x6cd, 0x20, 0x631, 0x6c4, 0x67e, 0x64e, 0x6d2, 0x3b, 0x3b, 0x6c1,
0x650, 0x646, 0x62f, 0x64f, 0x633, 0x62a, 0x672, 0x646, 0x6cd, 0x20, 0x631, 0x6c4, 0x67e, 0x64e, 0x6d2, 0x3b, 0x3b, 0x3b, 0x3b, 0x6c1,
0x650, 0x646, 0x62f, 0x64f, 0x633, 0x62a, 0x672, 0x646, 0x6cd, 0x20, 0x631, 0x6c4, 0x67e, 0x64e, 0x6d2, 0x3b, 0x907, 0x902, 0x921, 0x93f,
0x92f, 0x928, 0x20, 0x930, 0x942, 0x92a, 0x940, 0x3b, 0x3b, 0x907, 0x902, 0x921, 0x93f, 0x92f, 0x928, 0x20, 0x930, 0x942, 0x92a, 0x940,
0x3b, 0x3b, 0x3b, 0x3b, 0x907, 0x902, 0x921, 0x93f, 0x92f, 0x928, 0x20, 0x930, 0x941, 0x92a, 0x940, 0x91c, 0x93c, 0x3b, 0x49a, 0x430,
0x437, 0x430, 0x49b, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x442, 0x435, 0x4a3, 0x433, 0x435, 0x441, 0x456, 0x3b, 0x3b, 0x49a, 0x430, 0x437,
0x430, 0x49b, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x442, 0x435, 0x4a3, 0x433, 0x435, 0x441, 0x456, 0x3b, 0x3b, 0x3b, 0x3b, 0x49a, 0x430,
0x437, 0x430, 0x49b, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x442, 0x435, 0x4a3, 0x433, 0x435, 0x441, 0x456, 0x3b, 0x179a, 0x17c0, 0x179b, 0x200b,
0x1780, 0x1798, 0x17d2, 0x1796, 0x17bb, 0x1787, 0x17b6, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x179a, 0x17c0, 0x179b, 0x200b, 0x1780, 0x1798, 0x17d2,
0x1796, 0x17bb, 0x1787, 0x17b6, 0x3b, 0x43, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79,
0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x93e,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0xb300,
0xd55c, 0xbbfc, 0xad6d, 0x20, 0xc6d0, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xb300, 0xd55c, 0xbbfc, 0xad6d, 0x20, 0xc6d0, 0x3b, 0xc870, 0xc120,
0x20, 0xbbfc, 0xc8fc, 0xc8fc, 0xc758, 0x20, 0xc778, 0xbbfc, 0x20, 0xacf5, 0xd654, 0xad6d, 0x20, 0xc6d0, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0xc870, 0xc120, 0x20, 0xbbfc, 0xc8fc, 0xc8fc, 0xc758, 0x20, 0xc778, 0xbbfc, 0x20, 0xacf5, 0xd654, 0xad6d, 0x20, 0xc6d0, 0x3b, 0x43, 0x46, 0x41,
0x20, 0x46, 0x72, 0x61, 0x14b, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x46, 0x72, 0x61, 0x14b, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x41a, 0x44b, 0x440, 0x433, 0x44b, 0x437, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x441, 0x43e, 0x43c, 0x443, 0x3b, 0x3b, 0x41a, 0x44b, 0x440,
0x433, 0x44b, 0x437, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x441, 0x43e, 0x43c, 0x443, 0x3b, 0x3b, 0x3b, 0x3b, 0x41a, 0x44b, 0x440, 0x433,
0x44b, 0x437, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x441, 0x43e, 0x43c, 0x443, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0xed, 0x69, 0x6e, 0x67,
0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0xed, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0xea5, 0xeb2, 0xea7, 0x20, 0xe81, 0xeb5, 0xe9a, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xea5, 0xeb2, 0xea7, 0x20, 0xe81, 0xeb5,
0xe9a, 0x3b, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b,
0x65, 0x69, 0x72, 0x6f, 0x3b, 0x46, 0x61, 0x6c, 0xe1, 0x6e, 0x67, 0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67,
0xf3, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x20, 0x79, 0x61, 0x20, 0x41, 0x6e,
0x67, 0xf3, 0x6c, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x61, 0x6c, 0xe1, 0x6e, 0x67, 0x61, 0x20, 0x43,
0x46, 0x41, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x61, 0x73, 0x3b,
0x3b, 0x65, 0x75, 0x72, 0x61, 0x73, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x61, 0x69, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65,
0x75, 0x72, 0x173, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x65,
0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b,
0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x4e, 0x66, 0x61, 0x6c, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x6f,
0x6e, 0x67, 0x75, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x6d, 0x61, 0x72,
0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x72, 0x69, 0x6e, 0x6a, 0x69,
0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41c, 0x430, 0x43a, 0x435,
0x434, 0x43e, 0x43d, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x435, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x41c, 0x430, 0x43a, 0x435, 0x434, 0x43e,
0x43d, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x435, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x3b, 0x3b, 0x41c, 0x430, 0x43a, 0x435, 0x434, 0x43e,
0x43d, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x435, 0x43d, 0x430, 0x440, 0x438, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69,
0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41,
0x72, 0x69, 0x61, 0x72, 0x79, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x69, 0x6e, 0x67, 0x67, 0x69, 0x74, 0x20,
0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x69, 0x6e, 0x67, 0x67, 0x69,
0x74, 0x20, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x3b, 0x62f, 0x648, 0x644, 0x631, 0x20, 0x628, 0x631, 0x648, 0x646,
0x64a, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x631, 0x64a, 0x6a0, 0x762, 0x64a, 0x62a, 0x20, 0x645, 0x644, 0x64a, 0x633, 0x64a,
0x627, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x6f, 0x6c, 0x61, 0x72, 0x20, 0x42, 0x72, 0x75, 0x6e, 0x65, 0x69,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x6f, 0x6c, 0x61, 0x72, 0x20, 0x42, 0x72, 0x75, 0x6e, 0x65, 0x69, 0x3b, 0x44,
0x6f, 0x6c, 0x61, 0x72, 0x20, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x75, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x44, 0x6f, 0x6c, 0x61, 0x72, 0x20, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x75, 0x72, 0x61, 0x3b, 0xd07, 0xd28, 0xd4d, 0xd24,
0xd4d, 0xd2f, 0xd7b, 0x20, 0xd30, 0xd42, 0xd2a, 0x3b, 0x3b, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0xd7b, 0x20, 0xd30, 0xd42, 0xd2a,
0x3b, 0x3b, 0x3b, 0x3b, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0xd7b, 0x20, 0xd30, 0xd42, 0xd2a, 0x3b, 0x65, 0x77, 0x72, 0x6f,
0x3b, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x65, 0x77, 0x72,
0x6f, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x987, 0x9a8, 0x9cd, 0x9a6, 0x9bf, 0x9af, 0x9bc, 0x9be, 0x9a8, 0x20, 0x9b0, 0x9c1, 0x9aa,
0x9c0, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x987, 0x9a8, 0x9cd, 0x9a6, 0x9bf, 0x9af, 0x9bc, 0x9be, 0x9a8, 0x20, 0x9b0, 0x9c1, 0x9aa,
0x9c0, 0x3b, 0x54, 0x101, 0x72, 0x61, 0x20, 0x6f, 0x20, 0x41, 0x6f, 0x74, 0x65, 0x61, 0x72, 0x6f, 0x61, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x74, 0x101, 0x72, 0x61, 0x20, 0x6f, 0x20, 0x41, 0x6f, 0x74, 0x65, 0x61, 0x72, 0x6f, 0x61, 0x3b, 0x92d,
0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20,
0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f,
0x947, 0x3b, 0x49, 0x72, 0x6f, 0x70, 0x69, 0x79, 0x69, 0x61, 0x6e, 0xed, 0x20, 0x65, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x72, 0x6f, 0x70, 0x69, 0x79, 0x69, 0x61, 0x6e, 0xed, 0x20, 0x65, 0x20,
0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x6cc, 0x631, 0x627, 0x646,
0x20, 0x631, 0x6cc, 0x627, 0x644, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x20, 0x631, 0x6cc, 0x627,
0x644, 0x3b, 0x73, 0x68, 0x69, 0x72, 0xe8, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41c, 0x43e, 0x43d, 0x433, 0x43e, 0x43b,
0x20, 0x442, 0x4e9, 0x433, 0x440, 0x4e9, 0x433, 0x3b, 0x3b, 0x41c, 0x43e, 0x43d, 0x433, 0x43e, 0x43b, 0x20, 0x442, 0x4e9, 0x433, 0x440,
0x4e9, 0x433, 0x3b, 0x3b, 0x3b, 0x3b, 0x41c, 0x43e, 0x43d, 0x433, 0x43e, 0x43b, 0x20, 0x442, 0x4e9, 0x433, 0x440, 0x4e9, 0x433, 0x3b,
0x44e, 0x430, 0x43d, 0x44c, 0x3b, 0x3b, 0x44e, 0x430, 0x43d, 0x44c, 0x3b, 0x3b, 0x3b, 0x3b, 0x44e, 0x430, 0x43d, 0x44c, 0x3b, 0x1833,
0x1825, 0x182c, 0x1825, 0x1837, 0x1822, 0x182d, 0x180c, 0x3b, 0x3b, 0x1833, 0x1825, 0x182c, 0x1825, 0x1837, 0x1822, 0x182d, 0x180c, 0x3b, 0x3b, 0x3b,
0x3b, 0x1833, 0x1825, 0x182c, 0x1825, 0x1837, 0x1822, 0x182d, 0x180c, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x20, 0x6d, 0x6f, 0x72, 0x69,
0x73, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x6f, 0x6c, 0x61, 0x69, 0x20, 0x42, 0x45, 0x41,
0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x61, 0x20, 0x44, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x940, 0x20, 0x930, 0x942, 0x92a,
0x948, 0x92f, 0x93e, 0x901, 0x3b, 0x3b, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x940, 0x20, 0x930, 0x942, 0x92a, 0x948, 0x92f, 0x93e, 0x901,
0x3b, 0x3b, 0x3b, 0x3b, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x940, 0x20, 0x930, 0x942, 0x92a, 0x948, 0x92f, 0x93e, 0x901, 0x3b, 0x92d,
0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x942, 0x92a, 0x93f, 0x901, 0x92f, 0x93e, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940,
0x92f, 0x20, 0x930, 0x942, 0x92a, 0x93f, 0x901, 0x92f, 0x93e, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20,
0x930, 0x942, 0x92a, 0x93f, 0x901, 0x92f, 0x93e, 0x3b, 0x66, 0x65, 0x6c, 0xe1, 0x14b, 0x20, 0x43, 0x46, 0x41, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x25b, 0x6c, 0xe2, 0x14b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x65, 0x61, 0x75,
0x20, 0x42, 0x72, 0x61, 0x73, 0x69, 0x75, 0x77, 0x61, 0x72, 0x61, 0x3b, 0x3b, 0x52, 0x65, 0x61, 0x75, 0x20, 0x42, 0x72,
0x61, 0x73, 0x69, 0x75, 0x77, 0x61, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x65, 0x61, 0x75, 0x2d, 0x69, 0x74, 0x61,
0x20, 0x42, 0x72, 0x61, 0x73, 0x69, 0x75, 0x77, 0x61, 0x72, 0x61, 0x3b, 0x50, 0x65, 0x73, 0x6f, 0x20, 0x4b, 0x75, 0x72,
0x169, 0x62, 0x69, 0x79, 0x61, 0x77, 0x61, 0x72, 0x61, 0x3b, 0x3b, 0x50, 0x65, 0x73, 0x6f, 0x20, 0x4b, 0x75, 0x72, 0x169,
0x62, 0x69, 0x79, 0x61, 0x77, 0x61, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x75, 0x73, 0x65, 0x77, 0x61, 0x2d, 0x69,
0x74, 0x61, 0x20, 0x4b, 0x75, 0x72, 0x169, 0x62, 0x69, 0x79, 0x61, 0x77, 0x61, 0x72, 0x61, 0x3b, 0x42, 0x75, 0x72, 0x69,
0x77, 0x61, 0x72, 0x69, 0x20, 0x57, 0x65, 0x6e, 0x65, 0x73, 0x75, 0x65, 0x72, 0x61, 0x77, 0x61, 0x72, 0x61, 0x3b, 0x3b,
0x42, 0x75, 0x72, 0x69, 0x77, 0x61, 0x72, 0x69, 0x20, 0x57, 0x65, 0x6e, 0x65, 0x73, 0x75, 0x65, 0x72, 0x61, 0x77, 0x61,
0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x75, 0x72, 0x69, 0x77, 0x61, 0x72, 0x69, 0x2d, 0x69, 0x74, 0x61, 0x20, 0x57,
0x65, 0x6e, 0x65, 0x73, 0x75, 0x65, 0x72, 0x61, 0x77, 0x61, 0x72, 0x61, 0x3b, 0x4e, 0x61, 0x69, 0x6a, 0xed, 0x72, 0x69,
0xe1, 0x20, 0x4e, 0x61, 0xed, 0x72, 0x61, 0x3b, 0x3b, 0x4e, 0x61, 0x69, 0x6a, 0xed, 0x72, 0x69, 0xe1, 0x20, 0x6e, 0x61,
0xed, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x69, 0x6a, 0xed, 0x72, 0x69, 0xe1, 0x20, 0x6e, 0x61, 0xed, 0x72,
0x61, 0x73, 0x3b, 0x7d6, 0x7cc, 0x7ec, 0x7e3, 0x7cd, 0x7ec, 0x7de, 0x7ca, 0x20, 0x7df, 0x7ce, 0x7ec, 0x20, 0x7df, 0x7ca, 0x7eb, 0x20,
0x7dd, 0x7ca, 0x7d9, 0x7ca, 0x7f2, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x7d6, 0x7cc, 0x7ec, 0x7e3, 0x7cd, 0x7ec, 0x7de, 0x7ca, 0x20,
0x7df, 0x7ce, 0x7ec, 0x20, 0x7df, 0x7ca, 0x7eb, 0x20, 0x7dd, 0x7ca, 0x7d9, 0x7ca, 0x7f2, 0x3b, 0x44, 0x6f, 0x6c, 0x61, 0x20, 0x79,
0x61, 0x73, 0x65, 0x20, 0x41, 0x6d, 0x65, 0x6c, 0x69, 0x6b, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75,
0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x73, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61,
0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61, 0x20, 0x6b, 0x72, 0x75,
0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b,
0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x65, 0x75, 0x72,
0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b,
0x72, 0x75, 0x6f, 0x167, 0x167, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x3b, 0x72, 0x75, 0x6f, 0x167,
0x167, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x72, 0x75, 0x6f, 0x167, 0x167, 0x61, 0x20, 0x6b, 0x72,
0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x72, 0x75, 0x6f, 0x167, 0x167, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64,
0x6e, 0x6f, 0x3b, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x65, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b, 0x3b, 0x6e, 0x6f,
0x72, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x65, 0x20,
0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69, 0x61, 0x6e, 0x20, 0x4b, 0x77, 0x61, 0x63,
0x68, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65,
0x75, 0x72, 0x6f, 0x73, 0x3b, 0xb2d, 0xb3e, 0xb30, 0xb24, 0xb40, 0xb5f, 0x20, 0xb1f, 0xb19, 0xb4d, 0xb15, 0xb3e, 0x3b, 0x3b, 0xb2d,
0xb3e, 0xb30, 0xb24, 0xb40, 0xb5f, 0x20, 0xb1f, 0xb19, 0xb4d, 0xb15, 0xb3e, 0x3b, 0x3b, 0x3b, 0x3b, 0xb2d, 0xb3e, 0xb30, 0xb24, 0xb40,
0xb5f, 0x20, 0xb1f, 0xb19, 0xb4d, 0xb15, 0xb3e, 0x3b, 0x49, 0x74, 0x6f, 0x6f, 0x70, 0x68, 0x69, 0x79, 0x61, 0x61, 0x20, 0x42,
0x69, 0x72, 0x72, 0x69, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41b, 0x430, 0x440, 0x3b, 0x3b, 0x43b, 0x430, 0x440,
0x3b, 0x3b, 0x3b, 0x3b, 0x43b, 0x430, 0x440, 0x44b, 0x3b, 0x421, 0x43e, 0x43c, 0x3b, 0x3b, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x3b,
0x3b, 0x441, 0x43e, 0x43c, 0x44b, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cd, 0x3b, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cd,
0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cd, 0x3b, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x6cd, 0x20,
0x6a9, 0x644, 0x62f, 0x627, 0x631, 0x647, 0x3b, 0x3b, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x6cd, 0x20, 0x6a9, 0x644, 0x62f,
0x627, 0x631, 0x647, 0x3b, 0x3b, 0x3b, 0x3b, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x6cd, 0x20, 0x6a9, 0x644, 0x62f, 0x627,
0x631, 0x6d2, 0x3b, 0x631, 0x6cc, 0x627, 0x644, 0x20, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x3b, 0x3b, 0x631, 0x6cc, 0x627, 0x644, 0x20,
0x627, 0x6cc, 0x631, 0x627, 0x646, 0x3b, 0x3b, 0x3b, 0x3b, 0x631, 0x6cc, 0x627, 0x644, 0x20, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x3b,
0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x20, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633, 0x62a, 0x627, 0x646, 0x3b, 0x3b, 0x627, 0x641,
0x63a, 0x627, 0x646, 0x6cc, 0x20, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633, 0x62a, 0x627, 0x646, 0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x641,
0x63a, 0x627, 0x646, 0x6cc, 0x20, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633, 0x62a, 0x627, 0x646, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x79,
0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x3b, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x79, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b,
0x69, 0x3b, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x65, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x65, 0x3b, 0x7a, 0x142, 0x6f,
0x74, 0x79, 0x63, 0x68, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x63, 0x68, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x65, 0x67,
0x6f, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x65, 0x67, 0x6f, 0x3b, 0x52, 0x65, 0x61, 0x6c, 0x20, 0x62, 0x72, 0x61,
0x73, 0x69, 0x6c, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x3b, 0x52, 0x65, 0x61, 0x6c, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c,
0x65, 0x69, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x65, 0x61, 0x69, 0x73, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c,
0x65, 0x69, 0x72, 0x6f, 0x73, 0x3b, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x20, 0x61, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
0x6f, 0x3b, 0x3b, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x20, 0x61, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x3b, 0x3b,
0x3b, 0x3b, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x73, 0x20, 0x61, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x73, 0x3b,
0x65, 0x73, 0x63, 0x75, 0x64, 0x6f, 0x20, 0x63, 0x61, 0x62, 0x6f, 0x2d, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x6f,
0x3b, 0x3b, 0x65, 0x73, 0x63, 0x75, 0x64, 0x6f, 0x20, 0x63, 0x61, 0x62, 0x6f, 0x2d, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61,
0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x73, 0x63, 0x75, 0x64, 0x6f, 0x73, 0x20, 0x63, 0x61, 0x62, 0x6f, 0x2d, 0x76,
0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20,
0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28,
0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x73, 0x20, 0x43, 0x46, 0x41,
0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28,
0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28,
0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x73, 0x20, 0x43, 0x46,
0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x70, 0x61, 0x74, 0x61, 0x63, 0x61, 0x20, 0x6d, 0x61, 0x63,
0x61, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x70, 0x61, 0x74, 0x61, 0x63, 0x61, 0x20, 0x6d, 0x61, 0x63, 0x61, 0x65, 0x6e,
0x73, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x61, 0x74, 0x61, 0x63, 0x61, 0x73, 0x20, 0x6d, 0x61, 0x63, 0x61, 0x65, 0x6e,
0x73, 0x65, 0x73, 0x3b, 0x6d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x6d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x63,
0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x6d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x6d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69,
0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x6d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x69, 0x73, 0x20, 0x6d, 0x6f, 0xe7,
0x61, 0x6d, 0x62, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x64, 0x6f, 0x62, 0x72, 0x61, 0x20, 0x64, 0x65, 0x20, 0x53,
0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65, 0x20, 0x50, 0x72, 0xed, 0x6e, 0x63, 0x69, 0x70, 0x65, 0x3b, 0x3b,
0x64, 0x6f, 0x62, 0x72, 0x61, 0x20, 0x64, 0x65, 0x20, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65, 0x20,
0x50, 0x72, 0xed, 0x6e, 0x63, 0x69, 0x70, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x6f, 0x62, 0x72, 0x61, 0x73, 0x20, 0x64,
0x65, 0x20, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65, 0x20, 0x50, 0x72, 0xed, 0x6e, 0x63, 0x69, 0x70,
0x65, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x73, 0x75, 0xed, 0xe7, 0x6f, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x6f, 0x20, 0x73, 0x75, 0xed, 0xe7, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x73, 0x20,
0x73, 0x75, 0xed, 0xe7, 0x6f, 0x73, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x64, 0x6f, 0x73, 0x20, 0x45, 0x73, 0x74,
0x61, 0x64, 0x6f, 0x73, 0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x3b, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x64,
0x6f, 0x73, 0x20, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73, 0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x3b, 0x3b, 0x3b,
0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x65, 0x73, 0x20, 0x64, 0x6f, 0x73, 0x20, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73,
0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x3b, 0xa2d, 0xa3e, 0xa30, 0xa24, 0xa40, 0x20, 0xa30, 0xa41, 0xa2a, 0xa07, 0xa06, 0x3b,
0x3b, 0xa2d, 0xa3e, 0xa30, 0xa24, 0xa40, 0x20, 0xa30, 0xa41, 0xa2a, 0xa07, 0xa06, 0x3b, 0x3b, 0x3b, 0x3b, 0xa2d, 0xa3e, 0xa30, 0xa24,
0xa40, 0x20, 0xa30, 0xa41, 0xa2a, 0xa0f, 0x3b, 0x631, 0x648, 0x67e, 0x626, 0x6cc, 0x6c1, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x53, 0x6f, 0x6c, 0x20, 0x50, 0x65, 0x72, 0x75, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6f, 0x6c,
0x20, 0x70, 0x65, 0x72, 0x75, 0x61, 0x6e, 0x6f, 0x3b, 0x42, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x44, 0xf3, 0x6c, 0x61, 0x72, 0x20,
0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0xf3, 0x6c, 0x61, 0x72,
0x20, 0x61, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e,
0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c,
0x65, 0x69, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x72, 0x6f,
0x6d, 0xe2, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e,
0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x73, 0x63,
0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x3b,
0x6c, 0x65, 0x69, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x66, 0x72, 0x61,
0x6e, 0x63, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x76,
0x69, 0x7a, 0x7a, 0x65, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x73, 0x76, 0x69, 0x7a,
0x7a, 0x65, 0x72, 0x73, 0x3b, 0x68, 0x65, 0x6c, 0x65, 0x72, 0x69, 0x20, 0x73, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61,
0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x66, 0x61, 0x72, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x72,
0x79, 0x2019, 0x55, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x440, 0x43e, 0x441,
0x441, 0x438, 0x439, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438,
0x439, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441,
0x43a, 0x438, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x438, 0x445,
0x20, 0x440, 0x443, 0x431, 0x43b, 0x435, 0x439, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20,
0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443,
0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443, 0x431,
0x43b, 0x44c, 0x3b, 0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b,
0x44f, 0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x435, 0x439,
0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b,
0x43a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x3b, 0x43a, 0x430, 0x437,
0x430, 0x445, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x3b, 0x43a, 0x430, 0x437, 0x430, 0x445, 0x441,
0x43a, 0x438, 0x445, 0x20, 0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x43a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x43a, 0x438, 0x445, 0x20,
0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x43a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20, 0x442, 0x435, 0x43d,
0x433, 0x435, 0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x43a,
0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438,
0x437, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x441, 0x43e, 0x43c, 0x430, 0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x438,
0x445, 0x20, 0x441, 0x43e, 0x43c, 0x43e, 0x432, 0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20,
0x441, 0x43e, 0x43c, 0x430, 0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x43b, 0x435, 0x439,