/***********************************************************************
*
* Copyright (c) 2012-2026 Barbara Geller
* Copyright (c) 2012-2026 Ansel Sermersheim
*
* Copyright (c) 2015 The Qt Company Ltd.
* Copyright (c) 2012-2016 Digia Plc and/or its subsidiary(-ies).
* Copyright (c) 2008-2012 Nokia Corporation and/or its subsidiary(-ies).
*
* This file is part of CopperSpice.
*
* CopperSpice is free software. You can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* version 2.1 as published by the Free Software Foundation.
*
* CopperSpice is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://www.gnu.org/licenses/
*
***********************************************************************/

/* File autogenerated from the Unicode 15.1 database. Do not edit */

#include "qunicodetables_p.h"

namespace QUnicodeTables {

bool cs_isTurkishLocale = false;

static const unsigned short uc_property_trie[] = {
    // [0x0..0x11000)

    6256, 6288, 6320, 6352, 6384, 6416, 6448, 6480,
    6512, 6544, 6576, 6608, 6640, 6672, 6704, 6736,
    6768, 6800, 6832, 6864, 6896, 6928, 6960, 6992,
    7024, 7056, 7088, 7120, 7152, 7184, 7216, 7248,
    7280, 7312, 7344, 7376, 7408, 7440, 7472, 7504,
    7536, 7568, 7600, 7632, 7664, 7696, 7728, 7760,
    7792, 7824, 7856, 7888, 7920, 7952, 7984, 8016,
    8048, 8080, 8112, 8144, 8176, 8208, 8240, 8272,
    8304, 8336, 8368, 8400, 8432, 8464, 8496, 8528,
    8560, 8592, 8624, 8656, 8688, 8720, 8752, 8784,
    8816, 8848, 8880, 8912, 8944, 8976, 9008, 9040,
    9072, 9104, 9136, 9168, 9200, 9232, 9264, 9296,
    9328, 9360, 9392, 9424, 9456, 9488, 9520, 9552,
    9584, 9616, 9648, 9680, 9712, 9744, 9776, 9808,
    9840, 9872, 9904, 9936, 9968, 10000, 10032, 9936,
    10064, 10096, 10128, 10160, 10192, 10224, 10256, 9936,

    10288, 10320, 10352, 10384, 10416, 10448, 10480, 10512,
    10544, 10544, 10576, 10608, 10640, 10672, 10704, 10736,
    10768, 10800, 10832, 10800, 10864, 10896, 10928, 10960,
    10992, 10800, 11024, 11056, 11088, 11120, 11120, 11152,
    11184, 11216, 11216, 11216, 11216, 11216, 11216, 11216,
    11216, 11216, 11216, 11216, 11216, 11216, 11216, 11216,
    11216, 11216, 11216, 11248, 11280, 11312, 11312, 11344,
    11376, 11408, 11440, 11472, 11504, 11536, 11568, 11600,
    11632, 11664, 11696, 11728, 11760, 11792, 11824, 11856,
    11888, 11920, 11952, 11984, 12016, 12048, 12080, 12112,
    12144, 12176, 12208, 12240, 12272, 12304, 12336, 9936,
    12368, 12400, 12432, 12464, 12496, 12528, 12560, 12592,
    12624, 12656, 12688, 12720, 12752, 12784, 12816, 12848,
    12880, 12912, 12944, 12976, 13008, 13040, 13072, 13104,
    13136, 13136, 13136, 13136, 13168, 13136, 13136, 13200,
    13232, 13264, 13296, 13328, 13360, 13392, 13424, 13456,

    13488, 13520, 13552, 13584, 13616, 13648, 13680, 13712,
    13744, 13776, 13808, 13840, 13872, 13904, 13936, 13968,
    14000, 14032, 14064, 14096, 14128, 14160, 14192, 14224,
    14256, 14288, 14320, 14352, 14384, 14416, 14448, 14480,
    14512, 14544, 14576, 14608, 14640, 14672, 14704, 14736,
    14512, 14512, 14512, 14512, 14768, 14800, 14832, 14864,
    14896, 14928, 14512, 14960, 14992, 15024, 15056, 15088,
    15120, 15152, 15184, 15216, 15248, 15280, 15312, 15344,
    15376, 15376, 15376, 15376, 15376, 15376, 15376, 15376,
    15408, 15408, 15408, 15408, 15440, 15472, 15504, 15536,
    15568, 15600, 15408, 15632, 15664, 15696, 15728, 15760,
    15792, 15824, 15856, 15888, 15920, 15952, 15984, 16016,
    16048, 16080, 16112, 16144, 16176, 16176, 16176, 16208,
    16240, 16272, 16304, 16336, 16368, 16400, 16400, 16432,
    16464, 16496, 16528, 9936, 16560, 16592, 16592, 16624,
    16656, 16656, 16656, 16656, 16656, 16656, 16688, 16720,

    16752, 16784, 16816, 16848, 16880, 16912, 16944, 16976,
    17008, 17040, 17072, 17072, 17104, 17136, 17168, 17200,
    17232, 17264, 17296, 17328, 17264, 17360, 17392, 17424,
    17456, 17456, 17488, 17520, 17552, 17552, 17584, 17616,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,

    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17680, 17712, 17712,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,

    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,

    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,

    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,

    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,

    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17744, 17744, 17744,
    17744, 17744, 17744, 17744, 17744, 17776, 17808, 17840,

    17872, 17904, 17904, 17904, 17904, 17904, 17904, 17904,
    17904, 17904, 17904, 17904, 17904, 17904, 17904, 17904,
    17904, 17904, 17904, 17904, 17904, 17904, 17904, 17904,
    17904, 17904, 17904, 17904, 17904, 17904, 17904, 17904,
    17904, 17904, 17904, 17904, 17936, 17968, 18000, 18032,
    18064, 18064, 18064, 18064, 18064, 18064, 18064, 18064,
    18096, 18128, 18160, 18192, 18224, 18256, 18256, 18288,
    18320, 18352, 18384, 18416, 18448, 18480, 18512, 18544,
    18576, 18608, 18640, 18672, 18704, 18736, 18768, 18800,
    18832, 18864, 18896, 18928, 18960, 18992, 19024, 19056,
    19088, 19120, 19152, 19184, 19216, 19248, 19280, 19312,
    19344, 19376, 19408, 19440, 19472, 19472, 19504, 19536,
    19568, 19600, 19632, 19664, 19696, 19728, 19760, 19568,
    19600, 19632, 19664, 19696, 19728, 19760, 19568, 19600,
    19632, 19664, 19696, 19728, 19760, 19568, 19600, 19632,
    19664, 19696, 19728, 19760, 19568, 19600, 19632, 19664,

    19696, 19728, 19760, 19568, 19600, 19632, 19664, 19696,
    19728, 19760, 19568, 19600, 19632, 19664, 19696, 19728,
    19760, 19568, 19600, 19632, 19664, 19696, 19728, 19760,
    19568, 19600, 19632, 19664, 19696, 19728, 19760, 19568,
    19600, 19632, 19664, 19696, 19728, 19760, 19568, 19600,
    19632, 19664, 19696, 19728, 19760, 19568, 19600, 19632,
    19664, 19696, 19728, 19760, 19568, 19600, 19632, 19664,
    19696, 19728, 19760, 19568, 19600, 19632, 19664, 19696,
    19728, 19760, 19568, 19600, 19632, 19664, 19696, 19728,
    19760, 19568, 19600, 19632, 19664, 19696, 19728, 19760,
    19568, 19600, 19632, 19664, 19696, 19728, 19760, 19568,
    19600, 19632, 19664, 19696, 19728, 19760, 19568, 19600,
    19632, 19664, 19696, 19728, 19760, 19568, 19600, 19632,
    19664, 19696, 19728, 19760, 19568, 19600, 19632, 19664,
    19696, 19728, 19760, 19568, 19600, 19632, 19664, 19696,
    19728, 19760, 19568, 19600, 19632, 19664, 19696, 19728,

    19760, 19568, 19600, 19632, 19664, 19696, 19728, 19760,
    19568, 19600, 19632, 19664, 19696, 19728, 19760, 19568,
    19600, 19632, 19664, 19696, 19728, 19760, 19568, 19600,
    19632, 19664, 19696, 19728, 19760, 19568, 19600, 19632,
    19664, 19696, 19728, 19760, 19568, 19600, 19632, 19664,
    19696, 19728, 19760, 19568, 19600, 19632, 19664, 19696,
    19728, 19760, 19568, 19600, 19632, 19664, 19696, 19728,
    19760, 19568, 19600, 19632, 19664, 19696, 19728, 19760,
    19568, 19600, 19632, 19664, 19696, 19728, 19760, 19568,
    19600, 19632, 19664, 19696, 19728, 19760, 19568, 19600,
    19632, 19664, 19696, 19728, 19760, 19568, 19600, 19632,
    19664, 19696, 19728, 19760, 19568, 19600, 19632, 19664,
    19696, 19728, 19760, 19568, 19600, 19632, 19664, 19696,
    19728, 19760, 19568, 19600, 19632, 19664, 19696, 19728,
    19760, 19568, 19600, 19632, 19664, 19696, 19728, 19760,
    19568, 19600, 19632, 19664, 19696, 19728, 19760, 19568,

    19600, 19632, 19664, 19696, 19728, 19760, 19568, 19600,
    19632, 19664, 19696, 19728, 19760, 19568, 19600, 19632,
    19664, 19696, 19728, 19760, 19568, 19600, 19632, 19664,
    19696, 19728, 19760, 19568, 19600, 19632, 19664, 19696,
    19728, 19760, 19568, 19600, 19632, 19664, 19696, 19728,
    19760, 19568, 19600, 19632, 19664, 19696, 19728, 19760,
    19568, 19600, 19632, 19664, 19696, 19728, 19760, 19568,
    19600, 19632, 19664, 19696, 19728, 19792, 19824, 19856,
    19888, 19888, 19888, 19888, 19888, 19888, 19888, 19888,
    19888, 19888, 19888, 19888, 19888, 19888, 19888, 19888,
    19888, 19888, 19888, 19888, 19888, 19888, 19888, 19888,
    19888, 19888, 19888, 19888, 19888, 19888, 19888, 19888,
    19888, 19888, 19888, 19888, 19888, 19888, 19888, 19888,
    19888, 19888, 19888, 19888, 19888, 19888, 19888, 19888,
    19888, 19888, 19888, 19888, 19888, 19888, 19888, 19888,
    19888, 19888, 19888, 19888, 19888, 19888, 19888, 19888,

    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,

    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19920, 19920, 19920, 19920, 19920, 19920, 19920, 19920,
    19952, 19952, 19952, 19952, 19952, 19952, 19952, 19952,
    19984, 20016, 20048, 20080, 20112, 20112, 20144, 20176,
    20208, 20240, 20272, 20304, 20304, 20336, 20368, 20304,
    20304, 20304, 20304, 20304, 20304, 20304, 20304, 20304,
    20304, 20400, 20432, 20304, 20464, 20304, 20496, 20528,
    20560, 20592, 20624, 20656, 20304, 20304, 20304, 20688,
    20720, 20752, 20784, 20816, 20848, 20880, 20912, 20944,

    20976, 21008, 21040, 9936, 21072, 21072, 21072, 21104,
    21136, 21168, 21200, 21232, 21264, 21296, 21328, 21360,
    9936, 9936, 9936, 9936, 21392, 21424, 21456, 21488,
    21520, 21552, 21584, 21616, 21648, 21680, 21712, 9936,
    21744, 21776, 21808, 21840, 21872, 21904, 21936, 21968,
    22000, 22032, 22064, 22096, 22128, 22160, 9936, 9936,
    22192, 22192, 22192, 22192, 22192, 22192, 22192, 22192,
    22192, 22224, 22256, 22288, 22320, 22352, 9936, 9936,
    22384, 22416, 22448, 22480, 22512, 22544, 22576, 22608,
    22640, 22672, 22576, 22576, 22704, 22736, 22768, 22800,
    22832, 22864, 22896, 22928, 22960, 22576, 22992, 23024,
    23056, 23088, 23120, 23152, 23184, 23216, 22576, 22576,
    23248, 23248, 23280, 22576, 23312, 23344, 23376, 23408,
    23440, 23472, 22576, 22576, 22576, 22576, 22576, 22576,
    22576, 22576, 22576, 23504, 23536, 23568, 22576, 23600,
    23632, 23664, 23696, 23728, 23760, 23792, 23824, 23856,

    // [0x11000..0x110000)

    23888, 24144, 24400, 24656, 24912, 25168, 25424, 25680,
    25936, 26192, 26448, 26704, 26960, 27216, 27472, 27728,
    27984, 27984, 27984, 28240, 28496, 28752, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29264,
    29520, 29520, 29776, 30032, 30288, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 30544, 30800, 31056, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    31312, 31312, 31568, 31824, 29008, 29008, 32080, 32336,
    32592, 32592, 32592, 32592, 32592, 32592, 32592, 32592,
    32592, 32592, 32592, 32592, 32592, 32592, 32592, 32592,
    32592, 32592, 32592, 32592, 32592, 32592, 32592, 32848,
    32592, 32592, 33104, 33360, 33616, 33872, 29008, 29008,

    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 34128,
    34384, 34640, 34896, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 35152, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 35408,
    35664, 35920, 36176, 36432, 36688, 36944, 37200, 37456,
    37712, 37712, 37968, 29008, 29008, 29008, 29008, 38224,
    38480, 38736, 38992, 29008, 39248, 29008, 29008, 39504,
    39760, 40016, 40272, 40272, 40528, 40784, 41040, 40272,
    41296, 41552, 41808, 42064, 42320, 42576, 42832, 43088,
    43344, 43600, 43856, 44112, 44368, 44368, 44368, 44624,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,

    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 44880, 44880,
    44880, 44880, 44880, 44880, 44880, 44880, 45136, 45392,
    45392, 45392, 45392, 45392, 45392, 45392, 45392, 45392,
    45392, 45392, 45392, 45392, 45392, 45392, 45392, 45648,
    45904, 46160, 46160, 46160, 46160, 46160, 46160, 46160,
    46160, 46160, 46160, 46160, 46160, 46160, 46160, 46160,
    46160, 46160, 46160, 46160, 46160, 46160, 46416, 46672,
    46672, 46672, 46672, 46672, 46672, 46672, 46672, 46672,
    46672, 46672, 46672, 46672, 46672, 46672, 46672, 46672,
    46672, 46672, 46672, 46672, 46672, 46672, 46672, 46672,
    46672, 46672, 46672, 46928, 47184, 47184, 47440, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    47696, 47696, 47952, 44368, 44368, 44368, 44368, 44624,
    48208, 48208, 48208, 48208, 48208, 48208, 48208, 48208,
    48208, 48208, 48208, 48208, 48208, 48208, 48208, 48208,
    48208, 48208, 48208, 48464, 48720, 48720, 48720, 48720,
    48720, 48720, 48720, 48720, 48720, 48720, 48720, 48720,
    48720, 48720, 48720, 48976, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,

    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44368,
    44368, 44368, 44368, 44368, 44368, 44368, 44368, 44624,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,

    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 49232,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,

    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 49232,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,

    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 49232,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,

    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 49232,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,

    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 49232,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,

    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 49232,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,

    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 49232,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,

    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 49232,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,

    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 49232,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,

    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 49232,
    49488, 49744, 50000, 50000, 50000, 50000, 50000, 50000,
    50000, 50000, 50000, 50000, 50000, 50000, 50000, 50000,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,

    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 29008,
    29008, 29008, 29008, 29008, 29008, 29008, 29008, 49232,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,

    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50512,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,

    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50256,
    50256, 50256, 50256, 50256, 50256, 50256, 50256, 50512,


    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 2, 3, 4, 5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6, 6, 6, 7,

    8, 9, 10, 11, 12, 13, 14, 15,
    16, 17, 14, 18, 19, 20, 21, 22,
    23, 24, 25, 26, 27, 28, 29, 30,
    31, 32, 33, 34, 35, 36, 37, 9,

    14, 38, 38, 38, 38, 38, 38, 38,
    38, 39, 38, 38, 38, 38, 38, 38,
    38, 38, 38, 38, 38, 38, 38, 38,
    38, 38, 38, 40, 41, 42, 43, 44,

    43, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 40, 46, 47, 36, 0,

    0, 0, 0, 0, 0, 48, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    49, 50, 51, 12, 12, 12, 52, 14,
    53, 52, 54, 55, 36, 56, 52, 53,
    57, 58, 59, 60, 61, 62, 14, 63,
    53, 64, 54, 65, 66, 66, 66, 50,

    67, 67, 67, 67, 67, 67, 38, 67,
    67, 67, 67, 67, 67, 67, 67, 67,
    38, 67, 67, 67, 67, 67, 67, 36,
    38, 67, 67, 67, 67, 67, 38, 68,

    69, 69, 69, 69, 69, 69, 45, 69,
    69, 69, 69, 69, 69, 69, 69, 69,
    45, 69, 69, 69, 69, 69, 69, 36,
    45, 69, 69, 69, 69, 69, 45, 70,

    71, 72, 71, 72, 71, 72, 71, 72,
    71, 72, 71, 72, 71, 72, 71, 72,
    73, 74, 71, 72, 71, 72, 71, 72,
    71, 72, 71, 72, 71, 72, 71, 72,

    71, 72, 71, 72, 71, 72, 73, 74,
    71, 72, 71, 72, 71, 72, 71, 72,
    75, 76, 77, 78, 71, 72, 71, 72,
    79, 71, 72, 71, 72, 71, 72, 77,

    78, 73, 74, 71, 72, 71, 72, 71,
    72, 80, 73, 74, 71, 72, 71, 72,
    71, 72, 73, 74, 71, 72, 71, 72,
    71, 72, 71, 72, 71, 72, 71, 72,

    71, 72, 71, 72, 71, 72, 73, 74,
    71, 72, 71, 72, 71, 72, 71, 72,
    71, 72, 71, 72, 71, 72, 71, 72,
    81, 71, 72, 71, 72, 71, 72, 82,

    83, 84, 73, 74, 73, 74, 85, 73,
    74, 86, 86, 73, 74, 79, 87, 88,
    89, 73, 74, 86, 90, 91, 92, 93,
    73, 74, 94, 79, 92, 95, 96, 97,

    71, 72, 73, 74, 73, 74, 98, 73,
    74, 98, 79, 79, 73, 74, 98, 71,
    72, 99, 99, 73, 74, 73, 74, 100,
    73, 74, 79, 101, 73, 74, 79, 102,

    101, 101, 101, 101, 103, 104, 105, 103,
    104, 105, 103, 104, 105, 71, 72, 71,
    72, 71, 72, 71, 72, 71, 72, 71,
    72, 71, 72, 71, 72, 106, 71, 72,

    71, 72, 71, 72, 73, 74, 71, 72,
    71, 72, 71, 72, 71, 72, 71, 72,
    107, 103, 104, 105, 71, 72, 108, 109,
    110, 111, 71, 72, 71, 72, 71, 72,

    71, 72, 71, 72, 71, 72, 71, 72,
    71, 72, 71, 72, 71, 72, 71, 72,
    71, 72, 71, 72, 71, 72, 71, 72,
    110, 111, 110, 111, 112, 113, 110, 111,

    114, 115, 112, 113, 112, 113, 110, 111,
    110, 111, 110, 111, 110, 111, 110, 111,
    110, 111, 110, 111, 115, 115, 115, 116,
    116, 116, 117, 118, 119, 120, 121, 122,

    122, 118, 123, 124, 125, 126, 127, 123,
    127, 123, 127, 123, 127, 123, 127, 123,
    128, 129, 130, 131, 132, 79, 133, 133,
    79, 134, 79, 135, 136, 79, 79, 79,

    133, 137, 79, 138, 79, 139, 140, 79,
    141, 142, 140, 143, 144, 79, 79, 142,
    79, 145, 146, 79, 79, 147, 79, 79,
    79, 79, 79, 79, 79, 148, 79, 79,

    149, 79, 150, 149, 79, 79, 79, 151,
    149, 152, 153, 153, 154, 79, 79, 79,
    79, 79, 155, 79, 101, 79, 79, 79,
    79, 79, 79, 79, 79, 156, 157, 79,

    79, 79, 79, 79, 79, 79, 79, 79,
    79, 158, 158, 158, 158, 158, 115, 115,
    159, 159, 159, 159, 159, 159, 159, 159,
    159, 160, 160, 161, 161, 161, 161, 161,

    162, 162, 163, 163, 163, 163, 160, 160,
    164, 160, 160, 160, 164, 160, 160, 160,
    161, 161, 163, 163, 163, 163, 163, 163,
    53, 53, 53, 53, 53, 53, 163, 165,

    159, 159, 159, 159, 159, 163, 163, 163,
    163, 163, 166, 166, 167, 168, 169, 170,
    170, 170, 170, 170, 170, 170, 170, 170,
    170, 170, 170, 170, 170, 170, 170, 170,

    171, 171, 171, 171, 171, 172, 171, 171,
    171, 171, 171, 171, 171, 172, 172, 171,
    172, 171, 172, 171, 171, 173, 174, 174,
    174, 174, 173, 175, 174, 174, 174, 174,

    174, 176, 176, 177, 177, 177, 177, 178,
    178, 174, 174, 174, 174, 177, 177, 174,
    177, 177, 174, 174, 179, 179, 179, 179,
    180, 174, 174, 174, 174, 172, 172, 172,

    181, 181, 171, 181, 181, 182, 183, 184,
    184, 184, 183, 183, 183, 184, 184, 185,
    186, 186, 186, 187, 187, 187, 187, 186,
    188, 189, 189, 190, 191, 192, 192, 193,

    194, 194, 195, 196, 196, 196, 196, 196,
    196, 196, 196, 196, 196, 196, 196, 196,
    197, 198, 197, 198, 199, 200, 197, 198,
    201, 201, 202, 203, 203, 203, 204, 205,

    201, 201, 201, 201, 206, 207, 208, 209,
    210, 210, 210, 201, 211, 201, 212, 212,
    213, 214, 214, 214, 214, 214, 214, 214,
    214, 214, 214, 214, 214, 214, 214, 214,

    214, 214, 201, 214, 214, 214, 214, 214,
    214, 214, 215, 215, 216, 217, 217, 217,
    213, 218, 218, 218, 218, 218, 218, 218,
    218, 218, 218, 218, 218, 218, 218, 218,

    218, 218, 219, 218, 218, 218, 218, 218,
    218, 218, 220, 220, 221, 222, 222, 223,
    224, 225, 226, 227, 227, 228, 229, 230,
    231, 232, 233, 234, 233, 234, 233, 234,

    233, 234, 235, 236, 235, 236, 235, 236,
    235, 236, 235, 236, 235, 236, 235, 236,
    237, 238, 239, 240, 241, 242, 243, 244,
    245, 246, 244, 245, 247, 248, 248, 248,

    249, 250, 251, 250, 251, 251, 251, 250,
    251, 251, 251, 251, 250, 249, 250, 251,
    252, 252, 252, 252, 252, 252, 252, 252,
    252, 253, 252, 252, 252, 252, 252, 252,

    252, 252, 252, 252, 252, 252, 252, 252,
    252, 252, 252, 252, 252, 252, 252, 252,
    254, 254, 254, 254, 254, 254, 254, 254,
    254, 255, 254, 254, 254, 254, 254, 254,

    254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254, 254, 254, 254,
    256, 257, 258, 257, 258, 258, 258, 257,
    258, 258, 258, 258, 257, 256, 257, 258,

    259, 260, 259, 260, 259, 260, 259, 260,
    259, 260, 259, 260, 259, 260, 259, 260,
    259, 260, 259, 260, 259, 260, 261, 262,
    259, 260, 259, 260, 259, 260, 259, 260,

    259, 260, 263, 264, 264, 172, 172, 265,
    266, 266, 267, 268, 269, 270, 269, 270,
    259, 260, 259, 260, 259, 260, 259, 260,
    259, 260, 259, 260, 259, 260, 259, 260,

    259, 260, 259, 260, 259, 260, 259, 260,
    259, 260, 259, 260, 259, 260, 259, 260,
    259, 260, 259, 260, 259, 260, 259, 260,
    259, 260, 259, 260, 259, 260, 259, 260,

    271, 261, 262, 259, 260, 267, 268, 259,
    260, 267, 268, 259, 260, 267, 268, 272,
    261, 262, 261, 262, 259, 260, 261, 262,
    259, 260, 261, 262, 261, 262, 261, 262,

    259, 260, 261, 262, 261, 262, 261, 262,
    259, 260, 261, 262, 273, 274, 261, 262,
    261, 262, 261, 262, 261, 262, 275, 276,
    261, 262, 277, 278, 277, 278, 277, 278,

    267, 268, 267, 268, 267, 268, 267, 268,
    267, 268, 267, 268, 267, 268, 267, 268,
    277, 278, 277, 278, 279, 280, 279, 280,
    279, 280, 279, 280, 279, 280, 279, 280,

    279, 280, 279, 280, 281, 282, 283, 284,
    285, 286, 285, 286, 285, 286, 285, 286,
    201, 287, 287, 287, 287, 287, 287, 287,
    287, 287, 287, 287, 287, 287, 287, 287,

    287, 287, 287, 287, 287, 287, 287, 287,
    287, 287, 287, 287, 287, 287, 287, 287,
    287, 287, 287, 287, 287, 287, 287, 201,
    201, 288, 289, 289, 289, 290, 289, 291,

    292, 293, 293, 293, 293, 293, 293, 293,
    293, 293, 293, 293, 293, 293, 293, 293,
    293, 293, 293, 293, 293, 293, 293, 293,
    293, 293, 293, 293, 293, 293, 293, 293,

    293, 293, 293, 293, 293, 293, 293, 294,
    292, 295, 296, 201, 201, 297, 297, 298,
    299, 300, 301, 301, 301, 301, 300, 301,
    301, 301, 302, 300, 301, 301, 301, 301,

    301, 301, 303, 300, 300, 300, 300, 300,
    301, 301, 300, 301, 301, 302, 304, 301,
    305, 306, 307, 308, 309, 310, 311, 312,
    313, 314, 315, 316, 317, 318, 319, 320,

    321, 322, 323, 321, 301, 303, 324, 325,
    299, 299, 299, 299, 299, 299, 299, 299,
    326, 326, 326, 326, 326, 326, 326, 326,
    326, 326, 326, 326, 326, 326, 326, 326,

    326, 326, 326, 326, 326, 326, 326, 326,
    326, 326, 326, 299, 299, 299, 299, 327,
    326, 326, 326, 328, 329, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    330, 330, 330, 330, 331, 332, 333, 333,
    334, 335, 335, 336, 19, 337, 338, 338,
    339, 339, 339, 339, 339, 339, 340, 340,
    341, 342, 343, 344, 345, 346, 347, 348,

    349, 350, 351, 351, 351, 351, 352, 353,
    354, 353, 354, 354, 354, 354, 354, 353,
    353, 353, 353, 354, 354, 354, 354, 354,
    354, 354, 354, 355, 355, 355, 355, 355,

    356, 354, 354, 354, 354, 354, 354, 354,
    353, 354, 354, 357, 358, 359, 360, 361,
    362, 363, 364, 365, 365, 366, 367, 339,
    339, 368, 368, 368, 369, 368, 368, 370,

    371, 372, 373, 374, 375, 376, 377, 378,
    379, 380, 381, 382, 383, 384, 385, 385,
    386, 353, 353, 353, 350, 387, 387, 387,
    388, 354, 354, 354, 354, 354, 354, 354,

    354, 354, 354, 354, 354, 354, 354, 354,
    353, 353, 353, 353, 353, 353, 353, 353,
    353, 353, 353, 353, 353, 353, 353, 353,
    353, 353, 354, 354, 354, 354, 354, 354,

    354, 354, 354, 354, 354, 354, 354, 354,
    354, 354, 354, 354, 354, 354, 354, 354,
    354, 354, 354, 354, 354, 354, 354, 354,
    389, 389, 354, 354, 354, 354, 354, 389,

    351, 354, 352, 353, 353, 353, 353, 353,
    353, 353, 353, 353, 354, 353, 354, 390,
    354, 354, 353, 351, 391, 353, 392, 392,
    392, 392, 392, 392, 392, 393, 394, 392,

    392, 392, 392, 395, 392, 396, 396, 392,
    392, 394, 395, 392, 392, 395, 397, 397,
    398, 399, 400, 401, 402, 403, 404, 405,
    406, 407, 389, 389, 389, 408, 408, 409,

    410, 410, 410, 411, 411, 411, 411, 411,
    411, 411, 411, 411, 411, 411, 412, 413,
    414, 415, 416, 416, 416, 414, 414, 414,
    414, 414, 416, 416, 416, 416, 414, 416,

    416, 416, 416, 416, 416, 416, 416, 416,
    414, 416, 414, 416, 414, 417, 417, 418,
    419, 420, 419, 419, 420, 419, 419, 420,
    420, 420, 419, 420, 420, 419, 420, 419,

    419, 419, 420, 419, 420, 419, 420, 419,
    420, 419, 419, 412, 412, 418, 417, 417,
    421, 421, 421, 421, 421, 421, 421, 421,
    421, 422, 422, 422, 421, 421, 421, 421,

    421, 421, 421, 421, 421, 421, 421, 421,
    421, 421, 421, 422, 422, 421, 355, 355,
    355, 423, 355, 423, 423, 355, 355, 355,
    423, 423, 355, 355, 355, 355, 355, 355,

    424, 424, 424, 424, 424, 424, 424, 424,
    424, 424, 424, 424, 424, 424, 424, 424,
    424, 424, 424, 424, 424, 424, 424, 424,
    424, 424, 424, 424, 424, 424, 424, 424,

    424, 424, 424, 424, 424, 424, 425, 425,
    425, 425, 425, 425, 425, 425, 425, 425,
    425, 426, 412, 412, 412, 412, 412, 412,
    412, 412, 412, 412, 412, 412, 412, 412,

    427, 428, 429, 430, 431, 432, 433, 434,
    435, 436, 437, 437, 437, 437, 437, 437,
    437, 437, 437, 437, 437, 437, 437, 437,
    437, 437, 437, 437, 437, 437, 437, 437,

    437, 437, 437, 437, 437, 437, 437, 437,
    437, 437, 437, 438, 438, 438, 438, 438,
    438, 438, 439, 438, 440, 440, 441, 442,
    443, 444, 445, 299, 299, 446, 447, 447,

    448, 448, 448, 448, 448, 448, 448, 448,
    448, 448, 448, 448, 448, 448, 448, 448,
    448, 448, 448, 448, 448, 448, 449, 449,
    449, 449, 450, 449, 449, 449, 449, 449,

    449, 449, 449, 449, 450, 449, 449, 449,
    450, 449, 449, 449, 449, 449, 299, 299,
    451, 451, 451, 451, 451, 451, 451, 452,
    451, 452, 451, 451, 451, 452, 452, 299,

    453, 454, 454, 454, 454, 454, 453, 453,
    454, 453, 454, 454, 454, 454, 454, 454,
    454, 454, 454, 454, 453, 454, 453, 453,
    453, 455, 455, 455, 299, 299, 456, 299,

    457, 458, 457, 457, 457, 457, 458, 459,
    457, 459, 459, 299, 299, 299, 299, 299,
    460, 460, 460, 460, 460, 460, 460, 460,
    460, 460, 460, 460, 460, 460, 460, 460,

    460, 460, 460, 461, 461, 461, 462, 463,
    464, 462, 462, 462, 462, 462, 460, 299,
    465, 465, 299, 299, 299, 299, 299, 299,
    466, 467, 467, 467, 466, 466, 466, 466,

    468, 469, 468, 468, 468, 468, 468, 468,
    468, 468, 470, 470, 470, 471, 472, 469,
    469, 472, 472, 473, 473, 462, 474, 474,
    474, 475, 474, 474, 474, 474, 476, 476,

    476, 476, 476, 476, 476, 476, 476, 476,
    462, 477, 466, 466, 466, 466, 466, 467,
    467, 467, 467, 478, 479, 479, 479, 479,
    479, 479, 479, 479, 479, 479, 479, 479,

    479, 479, 480, 481, 482, 482, 483, 482,
    482, 483, 482, 482, 482, 483, 483, 483,
    484, 485, 486, 482, 482, 482, 483, 482,
    482, 483, 483, 482, 482, 482, 482, 487,

    488, 489, 489, 490, 491, 492, 492, 492,
    492, 492, 492, 492, 492, 492, 492, 492,
    492, 492, 492, 492, 492, 492, 492, 492,
    492, 492, 492, 492, 492, 492, 492, 492,

    492, 492, 492, 492, 492, 492, 492, 492,
    492, 493, 492, 492, 492, 492, 492, 492,
    492, 493, 492, 492, 493, 492, 492, 492,
    492, 492, 494, 495, 496, 492, 490, 490,

    490, 489, 489, 489, 489, 489, 489, 489,
    489, 490, 490, 490, 490, 497, 498, 495,
    492, 172, 174, 172, 172, 488, 494, 494,
    499, 499, 499, 499, 499, 499, 499, 499,

    492, 492, 489, 489, 500, 500, 501, 502,
    503, 504, 505, 506, 507, 508, 509, 510,
    511, 512, 513, 514, 514, 514, 514, 514,
    515, 516, 516, 517, 517, 518, 517, 517,

    519, 520, 521, 521, 201, 522, 522, 522,
    522, 522, 522, 522, 522, 201, 201, 522,
    522, 201, 201, 522, 522, 522, 522, 522,
    522, 522, 522, 522, 522, 522, 522, 522,

    522, 522, 522, 522, 522, 522, 522, 522,
    522, 201, 522, 522, 522, 522, 522, 522,
    522, 201, 522, 201, 201, 201, 522, 522,
    522, 522, 201, 201, 523, 524, 525, 521,

    521, 520, 520, 520, 520, 201, 201, 521,
    521, 201, 201, 526, 526, 527, 528, 201,
    201, 201, 201, 201, 201, 201, 201, 525,
    201, 201, 201, 201, 529, 529, 201, 529,

    522, 522, 520, 520, 201, 201, 530, 531,
    532, 533, 534, 535, 536, 537, 538, 539,
    522, 522, 540, 540, 541, 541, 541, 541,
    541, 542, 543, 544, 545, 546, 547, 201,

    201, 548, 549, 550, 201, 551, 551, 551,
    551, 551, 551, 201, 201, 201, 201, 551,
    551, 201, 201, 551, 551, 551, 551, 551,
    551, 551, 551, 551, 551, 551, 551, 551,

    551, 551, 551, 551, 551, 551, 551, 551,
    551, 201, 551, 551, 551, 551, 551, 551,
    551, 201, 551, 552, 201, 551, 552, 201,
    551, 551, 201, 201, 553, 201, 554, 554,

    554, 549, 549, 201, 201, 201, 201, 549,
    549, 201, 201, 549, 549, 555, 201, 201,
    201, 556, 201, 201, 201, 201, 201, 201,
    201, 552, 552, 552, 551, 201, 552, 201,

    201, 201, 201, 201, 201, 201, 557, 558,
    559, 560, 561, 562, 563, 564, 565, 566,
    549, 549, 551, 551, 551, 556, 567, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 568, 568, 569, 201, 570, 570, 570,
    570, 570, 570, 570, 571, 570, 201, 570,
    570, 570, 201, 570, 570, 570, 570, 570,
    570, 570, 570, 570, 570, 570, 570, 570,

    570, 570, 570, 570, 570, 570, 570, 570,
    570, 201, 570, 570, 570, 570, 570, 570,
    570, 201, 570, 570, 201, 570, 570, 570,
    570, 570, 201, 201, 572, 570, 569, 569,

    569, 568, 568, 568, 568, 568, 201, 568,
    568, 569, 201, 569, 569, 573, 201, 201,
    570, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    570, 571, 574, 574, 201, 201, 575, 576,
    577, 578, 579, 580, 581, 582, 583, 584,
    585, 586, 201, 201, 201, 201, 201, 201,
    201, 587, 588, 588, 588, 588, 588, 588,

    201, 589, 590, 590, 201, 591, 591, 591,
    591, 591, 591, 591, 591, 201, 201, 591,
    591, 201, 201, 591, 591, 591, 591, 591,
    591, 591, 591, 591, 591, 591, 591, 591,

    591, 591, 591, 591, 591, 591, 591, 591,
    591, 201, 591, 591, 591, 591, 591, 591,
    591, 201, 591, 591, 201, 592, 591, 591,
    591, 591, 201, 201, 593, 591, 594, 589,

    590, 589, 589, 589, 595, 201, 201, 590,
    596, 201, 201, 596, 596, 597, 201, 201,
    201, 201, 201, 201, 201, 598, 599, 594,
    201, 201, 201, 201, 600, 600, 201, 591,

    591, 591, 595, 595, 201, 201, 601, 602,
    603, 604, 605, 606, 607, 608, 609, 610,
    611, 592, 612, 612, 612, 612, 612, 612,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 201, 613, 614, 201, 614, 614, 614,
    614, 614, 614, 201, 201, 201, 614, 614,
    614, 201, 614, 614, 615, 614, 201, 201,
    201, 614, 614, 201, 614, 201, 614, 614,

    201, 201, 201, 614, 614, 201, 201, 201,
    614, 614, 614, 201, 201, 201, 614, 614,
    614, 614, 614, 614, 614, 614, 616, 614,
    614, 614, 201, 201, 201, 201, 617, 618,

    613, 618, 618, 201, 201, 201, 618, 618,
    618, 201, 619, 619, 619, 620, 201, 201,
    621, 201, 201, 201, 201, 201, 201, 617,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 201, 201, 201, 201, 201, 622, 623,
    624, 625, 626, 627, 628, 629, 630, 631,
    632, 632, 632, 633, 633, 633, 633, 633,
    633, 634, 633, 201, 201, 201, 201, 201,

    635, 636, 636, 636, 637, 638, 638, 638,
    638, 638, 638, 638, 638, 201, 638, 638,
    638, 201, 638, 638, 638, 638, 638, 638,
    638, 638, 638, 638, 638, 638, 638, 638,

    638, 638, 638, 638, 638, 638, 638, 638,
    638, 201, 638, 638, 638, 638, 638, 638,
    638, 638, 638, 638, 639, 638, 638, 638,
    638, 638, 201, 201, 640, 641, 642, 642,

    642, 636, 636, 636, 636, 201, 642, 642,
    643, 201, 642, 642, 642, 644, 201, 201,
    201, 201, 201, 201, 201, 645, 646, 201,
    641, 641, 647, 201, 201, 648, 201, 201,

    638, 638, 649, 649, 201, 201, 650, 651,
    652, 653, 654, 655, 656, 657, 658, 659,
    201, 201, 201, 201, 201, 201, 201, 660,
    661, 661, 661, 661, 661, 661, 661, 662,

    663, 664, 665, 665, 666, 667, 667, 667,
    667, 667, 667, 667, 667, 201, 667, 667,
    667, 201, 667, 667, 667, 667, 667, 667,
    667, 667, 667, 667, 667, 667, 667, 667,

    667, 667, 667, 667, 667, 667, 667, 667,
    667, 201, 667, 667, 667, 667, 667, 667,
    667, 667, 667, 667, 201, 667, 667, 667,
    667, 667, 201, 201, 668, 669, 665, 670,

    671, 665, 672, 665, 665, 201, 670, 671,
    671, 201, 671, 671, 673, 674, 201, 201,
    201, 201, 201, 201, 201, 672, 672, 201,
    201, 201, 201, 201, 201, 675, 667, 201,

    667, 667, 676, 676, 201, 201, 677, 678,
    679, 680, 681, 682, 683, 684, 685, 686,
    201, 687, 687, 688, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    689, 690, 691, 691, 692, 693, 693, 693,
    693, 693, 693, 693, 693, 201, 693, 693,
    693, 201, 693, 693, 693, 693, 693, 693,
    693, 693, 693, 693, 693, 693, 693, 693,

    693, 693, 693, 693, 693, 693, 693, 693,
    693, 694, 693, 693, 693, 693, 693, 693,
    693, 693, 693, 693, 693, 693, 693, 693,
    693, 693, 694, 695, 695, 696, 697, 691,

    691, 698, 698, 698, 699, 201, 691, 691,
    691, 201, 700, 700, 700, 701, 702, 703,
    201, 201, 201, 201, 704, 704, 704, 697,
    705, 705, 705, 705, 705, 705, 705, 706,

    693, 693, 699, 699, 201, 201, 707, 708,
    709, 710, 711, 712, 713, 714, 715, 716,
    717, 717, 717, 717, 717, 717, 705, 705,
    705, 718, 696, 696, 696, 696, 696, 696,

    201, 719, 720, 720, 201, 721, 721, 721,
    721, 721, 721, 721, 721, 721, 721, 721,
    721, 721, 721, 721, 721, 721, 721, 201,
    201, 201, 721, 721, 721, 721, 721, 721,

    721, 721, 721, 721, 721, 721, 721, 721,
    721, 721, 721, 721, 721, 721, 721, 721,
    721, 721, 201, 721, 721, 721, 721, 721,
    721, 721, 721, 721, 201, 721, 201, 201,

    721, 721, 721, 721, 721, 721, 721, 201,
    201, 201, 722, 201, 201, 201, 201, 723,
    720, 720, 724, 724, 724, 201, 724, 201,
    720, 720, 725, 720, 725, 725, 725, 723,

    201, 201, 201, 201, 201, 201, 726, 727,
    728, 729, 730, 731, 732, 733, 734, 735,
    201, 201, 720, 720, 736, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 737, 737, 737, 737, 737, 737, 737,
    737, 737, 737, 737, 737, 737, 737, 737,
    737, 737, 737, 737, 737, 737, 737, 737,
    737, 737, 737, 737, 737, 737, 737, 737,

    737, 737, 737, 737, 737, 737, 737, 737,
    737, 737, 737, 737, 737, 737, 737, 737,
    737, 738, 737, 739, 738, 738, 738, 738,
    740, 740, 741, 201, 201, 201, 201, 12,

    737, 737, 737, 737, 737, 737, 742, 738,
    743, 743, 743, 743, 738, 738, 738, 744,
    745, 746, 747, 748, 749, 750, 751, 752,
    753, 754, 755, 755, 201, 201, 201, 201,

    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 756, 756, 201, 756, 201, 757, 756,
    756, 757, 756, 201, 757, 756, 757, 757,
    757, 757, 757, 757, 756, 756, 756, 756,
    757, 756, 756, 756, 756, 756, 756, 756,

    757, 756, 756, 756, 201, 756, 201, 756,
    757, 757, 756, 756, 757, 756, 756, 756,
    756, 758, 756, 759, 758, 758, 758, 758,
    760, 760, 761, 758, 758, 756, 201, 201,

    756, 756, 756, 756, 756, 201, 762, 201,
    763, 763, 763, 763, 758, 758, 764, 201,
    765, 766, 767, 768, 769, 770, 771, 772,
    773, 774, 201, 201, 775, 775, 776, 776,

    777, 778, 778, 778, 779, 780, 779, 779,
    781, 779, 779, 782, 783, 784, 784, 784,
    784, 784, 781, 785, 784, 785, 785, 785,
    786, 786, 785, 785, 785, 785, 785, 785,

    787, 788, 789, 790, 791, 792, 793, 794,
    795, 796, 797, 797, 797, 797, 797, 797,
    797, 797, 797, 797, 798, 786, 785, 786,
    785, 799, 800, 801, 800, 801, 802, 802,

    777, 777, 777, 803, 777, 777, 777, 777,
    201, 777, 777, 777, 777, 803, 777, 777,
    777, 777, 803, 777, 777, 777, 777, 803,
    777, 777, 777, 777, 803, 777, 777, 777,

    777, 777, 777, 777, 777, 777, 777, 777,
    777, 803, 804, 805, 805, 201, 201, 201,
    201, 806, 807, 808, 809, 808, 808, 810,
    808, 810, 807, 807, 807, 807, 811, 812,

    807, 808, 813, 813, 814, 782, 813, 813,
    777, 777, 777, 777, 815, 816, 816, 816,
    811, 811, 811, 808, 811, 811, 817, 811,
    201, 811, 811, 811, 811, 808, 811, 811,

    811, 811, 808, 811, 811, 811, 811, 808,
    811, 811, 811, 811, 808, 811, 817, 817,
    817, 811, 811, 811, 811, 811, 811, 811,
    817, 808, 817, 817, 817, 201, 818, 818,

    819, 819, 819, 819, 819, 819, 820, 819,
    819, 819, 819, 819, 819, 201, 821, 819,
    822, 822, 823, 824, 825, 826, 826, 826,
    826, 827, 827, 201, 201, 201, 201, 201,

    828, 828, 828, 828, 828, 828, 828, 828,
    828, 828, 828, 828, 828, 828, 828, 828,
    828, 828, 828, 828, 828, 828, 828, 828,
    828, 828, 828, 828, 828, 828, 828, 828,

    828, 828, 829, 828, 828, 828, 830, 828,
    829, 828, 828, 831, 832, 833, 834, 833,
    833, 835, 833, 836, 836, 836, 833, 837,
    832, 838, 839, 840, 840, 836, 836, 829,

    841, 842, 843, 844, 845, 846, 847, 848,
    849, 850, 851, 851, 852, 852, 852, 852,
    828, 828, 828, 828, 828, 828, 835, 835,
    833, 833, 829, 829, 829, 829, 836, 836,

    836, 829, 831, 831, 831, 829, 829, 831,
    831, 831, 831, 831, 831, 831, 829, 829,
    829, 836, 836, 836, 836, 829, 829, 829,
    829, 829, 829, 829, 829, 829, 829, 829,

    829, 829, 836, 831, 840, 836, 836, 831,
    831, 831, 831, 831, 831, 853, 829, 831,
    854, 855, 856, 857, 858, 859, 860, 861,
    862, 863, 864, 864, 864, 865, 866, 866,

    867, 867, 867, 867, 867, 867, 867, 867,
    867, 867, 867, 867, 867, 867, 867, 867,
    867, 867, 867, 867, 867, 867, 867, 867,
    867, 867, 867, 867, 867, 867, 867, 867,

    867, 867, 867, 867, 867, 867, 201, 868,
    201, 201, 201, 201, 201, 868, 201, 201,
    869, 869, 869, 869, 869, 869, 869, 869,
    869, 869, 869, 869, 869, 869, 869, 869,

    869, 869, 869, 869, 869, 869, 869, 869,
    869, 869, 869, 869, 869, 869, 869, 869,
    869, 869, 869, 869, 869, 869, 869, 870,
    870, 871, 871, 872, 873, 874, 874, 874,

    875, 875, 875, 875, 875, 875, 875, 875,
    875, 875, 875, 875, 875, 875, 875, 875,
    875, 875, 875, 875, 875, 875, 875, 875,
    875, 875, 875, 875, 875, 875, 875, 875,

    875, 875, 875, 875, 875, 875, 875, 875,
    875, 875, 875, 875, 875, 875, 875, 875,
    875, 875, 875, 875, 875, 875, 875, 875,
    875, 875, 876, 876, 876, 876, 876, 875,

    877, 878, 878, 878, 878, 878, 878, 878,
    878, 878, 878, 878, 878, 878, 878, 878,
    878, 878, 878, 878, 878, 878, 877, 877,
    877, 877, 877, 877, 877, 877, 877, 877,

    877, 877, 877, 877, 877, 877, 877, 877,
    877, 877, 877, 877, 877, 877, 877, 877,
    877, 877, 877, 877, 877, 877, 877, 877,
    877, 877, 877, 877, 877, 877, 877, 877,

    877, 877, 877, 879, 879, 879, 879, 879,
    880, 880, 880, 880, 880, 880, 880, 880,
    880, 880, 880, 880, 880, 880, 880, 880,
    880, 880, 880, 880, 880, 880, 880, 880,

    880, 880, 880, 881, 881, 881, 881, 881,
    881, 881, 881, 881, 881, 881, 881, 881,
    881, 881, 881, 881, 881, 881, 881, 881,
    881, 881, 881, 881, 881, 881, 881, 881,

    881, 881, 881, 881, 881, 881, 881, 881,
    881, 881, 881, 881, 881, 881, 881, 881,
    881, 881, 881, 881, 881, 881, 881, 881,
    881, 881, 882, 882, 882, 882, 882, 882,

    883, 883, 883, 883, 883, 883, 883, 884,
    883, 883, 883, 883, 883, 883, 883, 883,
    883, 883, 883, 883, 883, 883, 883, 883,
    883, 883, 883, 883, 883, 883, 883, 883,

    883, 883, 883, 883, 883, 883, 883, 883,
    883, 883, 883, 883, 883, 883, 883, 883,
    883, 883, 883, 883, 883, 883, 883, 883,
    883, 883, 883, 883, 883, 883, 883, 883,

    883, 883, 883, 883, 883, 883, 883, 884,
    883, 201, 883, 883, 883, 883, 201, 201,
    883, 883, 883, 883, 883, 883, 883, 201,
    883, 201, 883, 883, 883, 883, 201, 201,

    883, 883, 883, 883, 883, 883, 883, 884,
    883, 201, 883, 883, 883, 883, 201, 201,
    883, 883, 883, 883, 883, 883, 883, 883,
    883, 883, 883, 883, 883, 883, 883, 883,

    883, 883, 883, 883, 883, 883, 883, 883,
    883, 883, 883, 883, 883, 883, 883, 884,
    883, 201, 883, 883, 883, 883, 201, 201,
    883, 883, 883, 883, 883, 883, 883, 201,

    883, 201, 883, 883, 883, 883, 201, 201,
    883, 883, 883, 883, 883, 883, 883, 884,
    883, 883, 883, 883, 883, 883, 883, 201,
    883, 883, 883, 883, 883, 883, 883, 883,

    883, 883, 883, 883, 883, 883, 883, 883,
    883, 883, 883, 883, 883, 883, 883, 884,
    883, 883, 883, 883, 883, 883, 883, 883,
    883, 883, 883, 883, 883, 883, 883, 883,

    883, 883, 883, 883, 883, 883, 883, 883,
    883, 883, 883, 883, 883, 883, 883, 884,
    883, 201, 883, 883, 883, 883, 201, 201,
    883, 883, 883, 883, 883, 883, 883, 884,

    883, 883, 883, 883, 883, 883, 883, 884,
    883, 883, 883, 883, 883, 883, 883, 883,
    883, 883, 883, 883, 883, 883, 883, 883,
    883, 883, 883, 201, 201, 885, 885, 886,

    887, 888, 889, 890, 890, 890, 890, 889,
    889, 891, 892, 893, 894, 895, 896, 897,
    898, 899, 900, 900, 900, 900, 900, 900,
    900, 900, 900, 900, 900, 201, 201, 201,

    884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884,
    901, 901, 901, 901, 901, 901, 901, 901,
    901, 901, 201, 201, 201, 201, 201, 201,

    902, 902, 902, 902, 902, 902, 902, 902,
    902, 902, 902, 902, 902, 902, 902, 902,
    902, 902, 902, 902, 902, 902, 902, 902,
    902, 902, 902, 902, 902, 902, 902, 902,

    902, 902, 902, 902, 902, 902, 902, 902,
    902, 902, 902, 902, 902, 902, 902, 902,
    903, 903, 903, 903, 903, 904, 201, 201,
    905, 905, 905, 905, 905, 905, 201, 201,

    906, 907, 907, 907, 907, 907, 907, 907,
    907, 907, 907, 907, 907, 907, 907, 907,
    907, 907, 907, 907, 907, 907, 907, 907,
    907, 907, 907, 907, 907, 907, 907, 907,

    907, 907, 907, 907, 907, 907, 907, 907,
    907, 907, 907, 907, 907, 907, 907, 907,
    907, 907, 907, 907, 907, 907, 907, 907,
    907, 907, 907, 907, 907, 907, 907, 907,

    907, 907, 907, 907, 907, 907, 907, 907,
    907, 907, 907, 907, 907, 908, 909, 907,
    907, 907, 907, 907, 907, 907, 907, 910,
    910, 910, 910, 910, 910, 910, 910, 910,

    911, 912, 912, 912, 912, 912, 912, 912,
    912, 912, 912, 912, 912, 912, 912, 912,
    912, 912, 912, 912, 912, 912, 912, 912,
    912, 912, 912, 913, 914, 201, 201, 201,

    915, 915, 915, 915, 915, 915, 915, 915,
    915, 915, 915, 915, 915, 915, 915, 915,
    915, 915, 915, 915, 915, 915, 915, 915,
    915, 915, 915, 915, 915, 915, 915, 915,

    915, 915, 915, 915, 915, 915, 915, 915,
    915, 915, 915, 916, 916, 916, 917, 917,
    917, 918, 918, 918, 918, 918, 918, 918,
    918, 201, 201, 201, 201, 201, 201, 201,

    919, 919, 919, 919, 919, 919, 919, 919,
    919, 919, 919, 919, 919, 920, 919, 919,
    919, 919, 921, 921, 922, 923, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 920,

    924, 924, 924, 924, 924, 924, 924, 924,
    924, 924, 924, 924, 924, 924, 924, 924,
    924, 924, 925, 925, 926, 927, 927, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    928, 928, 928, 928, 928, 928, 928, 928,
    928, 928, 928, 928, 928, 928, 928, 928,
    928, 928, 929, 929, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    930, 930, 930, 930, 930, 930, 930, 930,
    930, 930, 930, 930, 930, 201, 930, 930,
    930, 201, 931, 931, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    932, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932,

    932, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 933, 933, 934, 933,
    933, 933, 933, 933, 933, 933, 934, 934,

    934, 934, 934, 934, 934, 934, 933, 934,
    934, 933, 933, 933, 933, 933, 933, 933,
    933, 933, 935, 933, 936, 936, 937, 938,
    939, 940, 939, 941, 932, 942, 201, 201,

    943, 944, 945, 946, 947, 948, 949, 950,
    951, 952, 201, 201, 201, 201, 201, 201,
    953, 953, 953, 953, 953, 953, 953, 953,
    953, 953, 201, 201, 201, 201, 201, 201,

    954, 954, 955, 956, 957, 958, 959, 960,
    961, 962, 963, 964, 964, 964, 965, 966,
    967, 968, 969, 970, 971, 972, 973, 974,
    975, 976, 201, 201, 201, 201, 201, 201,

    977, 977, 977, 977, 977, 977, 977, 977,
    977, 977, 977, 977, 977, 977, 977, 977,
    977, 977, 977, 977, 977, 977, 977, 977,
    977, 977, 977, 977, 977, 977, 977, 977,

    977, 977, 977, 978, 977, 977, 977, 977,
    977, 977, 977, 977, 977, 977, 977, 977,
    977, 977, 977, 977, 977, 977, 977, 977,
    977, 977, 977, 977, 977, 977, 977, 977,

    977, 977, 977, 977, 977, 977, 977, 977,
    977, 977, 977, 977, 977, 977, 977, 977,
    977, 977, 977, 977, 977, 977, 977, 977,
    979, 201, 201, 201, 201, 201, 201, 201,

    980, 980, 980, 980, 980, 964, 964, 977,
    977, 977, 977, 977, 977, 977, 977, 977,
    977, 977, 977, 977, 977, 977, 977, 977,
    977, 977, 977, 977, 977, 977, 977, 977,

    977, 977, 977, 977, 977, 977, 977, 977,
    977, 981, 982, 201, 201, 201, 201, 201,
    910, 910, 910, 910, 910, 910, 910, 910,
    910, 910, 910, 910, 910, 910, 910, 910,

    910, 910, 910, 910, 910, 910, 910, 910,
    910, 910, 910, 910, 910, 910, 910, 910,
    910, 910, 910, 910, 910, 910, 910, 910,
    910, 910, 910, 910, 910, 910, 910, 910,

    910, 910, 910, 910, 910, 910, 910, 910,
    910, 910, 910, 910, 910, 910, 910, 910,
    910, 910, 910, 910, 910, 910, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    983, 983, 983, 983, 983, 983, 983, 983,
    983, 983, 983, 983, 983, 983, 983, 983,
    983, 983, 983, 983, 983, 983, 983, 983,
    983, 983, 983, 983, 983, 984, 984, 201,

    985, 985, 985, 986, 986, 986, 986, 985,
    985, 986, 986, 986, 201, 201, 201, 201,
    986, 986, 985, 986, 986, 986, 986, 986,
    986, 987, 988, 989, 201, 201, 201, 201,

    990, 201, 201, 201, 991, 991, 992, 993,
    994, 995, 996, 997, 998, 999, 1000, 1001,
    1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
    1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,

    1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
    1002, 1002, 1002, 1002, 1002, 1002, 201, 201,
    1002, 1002, 1002, 1002, 1002, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
    1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
    1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
    1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,

    1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
    1003, 1003, 1004, 1004, 201, 201, 201, 201,
    1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
    1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,

    1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
    1003, 1003, 201, 201, 201, 201, 201, 201,
    1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012,
    1013, 1014, 1015, 201, 201, 201, 1016, 1016,

    1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
    1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
    1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
    1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,

    1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
    1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
    1018, 1018, 1018, 1018, 1018, 1018, 1018, 1019,
    1020, 1021, 1021, 1022, 201, 201, 1023, 1023,

    1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
    1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
    1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
    1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,

    1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
    1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
    1024, 1024, 1024, 1024, 1024, 1025, 1026, 1025,
    1026, 1026, 1026, 1026, 1026, 1026, 1026, 201,

    1027, 1028, 1026, 1028, 1028, 1026, 1026, 1026,
    1026, 1026, 1026, 1026, 1026, 1025, 1025, 1025,
    1025, 1025, 1025, 1026, 1026, 1029, 1029, 1029,
    1029, 1029, 1029, 1029, 1029, 201, 201, 1030,

    1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038,
    1039, 1040, 201, 201, 201, 201, 201, 201,
    1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038,
    1039, 1040, 201, 201, 201, 201, 201, 201,

    1041, 1041, 1041, 1041, 1041, 1041, 1041, 1042,
    1043, 1043, 1043, 1043, 1041, 1041, 201, 201,
    1044, 1044, 1044, 1044, 1044, 1045, 1045, 1045,
    1045, 1045, 1045, 1044, 1044, 1045, 1046, 1047,

    1047, 1048, 1048, 1049, 1049, 1048, 1048, 1048,
    1048, 1048, 1049, 1048, 1048, 1048, 1048, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1050, 1050, 1050, 1050, 1051, 1052, 1053, 1052,
    1053, 1052, 1053, 1052, 1053, 1052, 1053, 1052,
    1052, 1052, 1053, 1052, 1052, 1052, 1052, 1052,
    1052, 1052, 1052, 1052, 1052, 1052, 1052, 1052,

    1052, 1052, 1052, 1052, 1052, 1052, 1052, 1052,
    1052, 1052, 1052, 1052, 1052, 1052, 1052, 1052,
    1052, 1052, 1052, 1052, 1054, 1055, 1050, 1050,
    1050, 1050, 1050, 1056, 1050, 1056, 1051, 1051,

    1056, 1056, 1050, 1056, 1057, 1052, 1052, 1052,
    1052, 1052, 1052, 1052, 1058, 201, 201, 201,
    1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066,
    1067, 1068, 1069, 1069, 1070, 1071, 1069, 1069,

    1071, 1072, 1072, 1072, 1072, 1072, 1072, 1072,
    1072, 1072, 1072, 1073, 1074, 1073, 1073, 1073,
    1073, 1073, 1073, 1073, 1072, 1072, 1072, 1072,
    1072, 1072, 1072, 1072, 1072, 1075, 1075, 201,

    1076, 1076, 1077, 1078, 1078, 1078, 1078, 1078,
    1078, 1078, 1078, 1078, 1078, 1078, 1078, 1078,
    1078, 1078, 1078, 1078, 1078, 1078, 1078, 1078,
    1078, 1078, 1078, 1078, 1078, 1078, 1078, 1078,

    1078, 1077, 1076, 1076, 1076, 1076, 1077, 1077,
    1076, 1076, 1079, 1080, 1081, 1081, 1078, 1078,
    1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089,
    1090, 1091, 1092, 1092, 1092, 1092, 1092, 1092,

    1093, 1093, 1093, 1093, 1093, 1093, 1093, 1093,
    1093, 1093, 1093, 1093, 1093, 1093, 1093, 1093,
    1093, 1093, 1093, 1093, 1093, 1093, 1093, 1093,
    1093, 1093, 1093, 1093, 1093, 1093, 1093, 1093,

    1093, 1093, 1093, 1093, 1093, 1093, 1094, 1095,
    1096, 1096, 1095, 1095, 1095, 1096, 1095, 1096,
    1096, 1096, 1097, 1097, 201, 201, 201, 201,
    201, 201, 201, 201, 1098, 1098, 1098, 1098,

    1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099,
    1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099,
    1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099,
    1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099,

    1099, 1099, 1099, 1099, 1100, 1100, 1100, 1100,
    1100, 1100, 1100, 1100, 1101, 1101, 1101, 1101,
    1101, 1101, 1101, 1101, 1100, 1100, 1101, 1102,
    201, 201, 201, 1103, 1103, 1104, 1104, 1104,

    1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112,
    1113, 1114, 201, 201, 201, 1099, 1099, 1099,
    1115, 1116, 1117, 1118, 1119, 1120, 1121, 1122,
    1123, 1124, 1125, 1125, 1125, 1125, 1125, 1125,

    1125, 1125, 1125, 1125, 1125, 1125, 1125, 1125,
    1125, 1125, 1125, 1125, 1125, 1125, 1125, 1125,
    1125, 1125, 1125, 1125, 1125, 1125, 1125, 1125,
    1126, 1126, 1126, 1126, 1126, 1126, 1127, 1127,

    1128, 1129, 1130, 1131, 1131, 1132, 1133, 1134,
    1135, 201, 201, 201, 201, 201, 201, 201,
    1136, 1136, 1136, 1136, 1136, 1136, 1136, 1136,
    1136, 1136, 1136, 1136, 1136, 1136, 1136, 1136,

    1136, 1136, 1136, 1136, 1136, 1136, 1136, 1136,
    1136, 1136, 1136, 1136, 1136, 1136, 1136, 1136,
    1136, 1136, 1136, 1136, 1136, 1136, 1136, 1136,
    1136, 1136, 1136, 201, 201, 1136, 1136, 1136,

    1137, 1137, 1137, 1137, 1137, 1137, 1137, 1137,
    201, 201, 201, 201, 201, 201, 201, 201,
    1138, 1138, 1138, 1139, 1140, 1141, 1141, 1141,
    1141, 1141, 1138, 1138, 1141, 1141, 1141, 1141,

    1138, 1142, 1140, 1140, 1140, 1140, 1140, 1140,
    1140, 1143, 1143, 1143, 1143, 1141, 1143, 1143,
    1143, 1143, 1143, 1144, 1145, 1144, 1144, 1146,
    1044, 1044, 1147, 201, 201, 201, 201, 201,

    115, 115, 115, 115, 115, 115, 115, 115,
    115, 115, 115, 115, 115, 115, 115, 115,
    115, 115, 115, 115, 115, 115, 115, 115,
    115, 115, 115, 115, 115, 115, 115, 115,

    115, 115, 115, 115, 115, 115, 1148, 1148,
    1148, 1148, 1148, 1149, 1150, 1150, 1150, 1151,
    1150, 1150, 1150, 1150, 1150, 1150, 1150, 1150,
    1150, 1150, 1150, 1151, 1150, 1150, 1150, 1150,

    1150, 1150, 1150, 1150, 1150, 1150, 1150, 1150,
    1150, 1150, 1150, 1150, 1150, 1150, 1151, 1150,
    1150, 1150, 1150, 1150, 1150, 1150, 1150, 1150,
    1150, 1150, 1150, 1150, 1150, 1152, 1152, 1152,

    1152, 1152, 1150, 1150, 1150, 1150, 1152, 1152,
    1152, 1152, 1152, 115, 116, 116, 116, 116,
    116, 116, 116, 116, 116, 116, 116, 116,
    1153, 1154, 116, 116, 116, 1155, 116, 116,

    116, 116, 116, 116, 116, 116, 116, 116,
    116, 116, 116, 116, 116, 116, 1156, 116,
    116, 116, 116, 116, 116, 116, 116, 116,
    116, 116, 116, 1157, 1157, 1157, 1157, 1157,

    1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157,
    1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157,
    1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157,
    1157, 1157, 1157, 1157, 1157, 1157, 1157, 1158,

    190, 190, 189, 190, 1159, 1159, 1159, 1159,
    1159, 1159, 1160, 1161, 1161, 1162, 1163, 1164,
    1165, 1161, 1161, 1161, 1161, 1161, 1161, 1161,
    1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161,

    1161, 1161, 1161, 1161, 1161, 1161, 1161, 1044,
    1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044,
    1044, 1044, 1044, 1044, 1044, 1044, 1166, 1167,
    1167, 1168, 1169, 1170, 1171, 1141, 1159, 1160,

    71, 72, 71, 72, 71, 72, 71, 72,
    71, 72, 71, 72, 71, 72, 71, 72,
    71, 72, 71, 72, 71, 72, 71, 72,
    71, 72, 71, 72, 71, 72, 71, 72,

    71, 72, 71, 72, 71, 72, 71, 72,
    71, 72, 71, 72, 71, 72, 71, 72,
    71, 72, 71, 72, 71, 72, 107, 107,
    107, 107, 80, 1172, 1173, 1173, 1174, 1173,

    71, 72, 71, 72, 71, 72, 71, 72,
    71, 72, 71, 72, 71, 72, 71, 72,
    71, 72, 71, 72, 71, 72, 71, 72,
    71, 72, 1175, 1176, 1175, 1176, 1175, 1176,

    1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177,
    1178, 1178, 1178, 1178, 1178, 1178, 1178, 1178,
    1177, 1177, 1177, 1177, 1177, 1177, 201, 201,
    1178, 1178, 1178, 1178, 1178, 1178, 201, 201,

    1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177,
    1178, 1178, 1178, 1178, 1178, 1178, 1178, 1178,
    1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177,
    1178, 1178, 1178, 1178, 1178, 1178, 1178, 1178,

    1177, 1177, 1177, 1177, 1177, 1177, 201, 201,
    1178, 1178, 1178, 1178, 1178, 1178, 201, 201,
    213, 1177, 213, 1177, 213, 1177, 213, 1177,
    201, 1178, 201, 1178, 201, 1178, 201, 1178,

    1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177,
    1178, 1178, 1178, 1178, 1178, 1178, 1178, 1178,
    1179, 1180, 1181, 1182, 1181, 1182, 1183, 1184,
    1185, 1186, 1187, 1188, 1189, 1190, 201, 201,

    1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191,
    1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192,
    1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191,
    1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192,

    1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191,
    1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192,
    1177, 1177, 213, 1193, 213, 201, 213, 213,
    1178, 1178, 1194, 1195, 1196, 206, 1197, 206,

    206, 1198, 213, 1193, 213, 201, 213, 213,
    1199, 1200, 1199, 1200, 1196, 1198, 1198, 1198,
    1177, 1177, 213, 1201, 201, 201, 213, 213,
    1178, 1178, 1202, 1203, 201, 1198, 1198, 1198,

    1177, 1177, 213, 1204, 213, 1205, 213, 213,
    1178, 1178, 1206, 1207, 1208, 1198, 1209, 1209,
    201, 201, 213, 1193, 213, 201, 213, 213,
    1210, 1211, 1212, 1213, 1196, 1214, 206, 201,

    1215, 1215, 1216, 1216, 1216, 1216, 1216, 1217,
    1216, 1216, 1216, 1218, 1219, 1220, 1221, 1222,
    1223, 1224, 1223, 1225, 1226, 1227, 14, 1228,
    1229, 1230, 1231, 1232, 1232, 1233, 1231, 1232,

    14, 14, 14, 14, 1234, 1235, 1235, 1236,
    1237, 1238, 1239, 1240, 1241, 1242, 1243, 1244,
    13, 13, 13, 1245, 1245, 1246, 1247, 1247,
    14, 1248, 1249, 14, 1250, 1251, 1228, 44,

    44, 14, 14, 14, 1252, 16, 1253, 1254,
    1255, 1255, 1256, 1256, 1256, 1256, 1257, 1257,
    1257, 1257, 1258, 1259, 1260, 1261, 1262, 1263,
    1262, 1262, 1262, 1262, 1261, 1262, 1262, 1264,

    1265, 1266, 1266, 1266, 1267, 1268, 1269, 1270,
    1271, 1272, 1273, 1273, 1273, 1273, 1273, 1273,
    1274, 1275, 201, 201, 1276, 1277, 1278, 1279,
    1280, 1281, 1282, 1282, 1283, 1284, 1285, 159,

    1274, 64, 59, 60, 1276, 1277, 1278, 1279,
    1280, 1281, 1282, 1282, 1283, 1284, 1285, 201,
    1157, 1157, 1157, 1157, 1157, 1286, 1286, 1286,
    1286, 1286, 1286, 1286, 1286, 201, 201, 201,

    12, 12, 12, 12, 12, 12, 12, 51,
    1287, 12, 12, 1288, 1289, 1290, 1290, 1290,
    1291, 1291, 1292, 1292, 1292, 1292, 1293, 1294,
    1294, 1295, 1296, 1297, 1298, 1298, 1299, 1300,

    1301, 1302, 1302, 1302, 1302, 1302, 1302, 1302,
    1302, 1302, 1302, 1302, 1302, 1302, 1302, 1302,
    172, 172, 179, 179, 172, 172, 172, 172,
    179, 179, 179, 172, 172, 1303, 1303, 1303,

    1303, 172, 1304, 1304, 1305, 1306, 1306, 196,
    1307, 196, 1306, 1308, 1160, 1160, 1160, 1160,
    1161, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1309, 1309, 1310, 1311, 52, 1309, 1309, 1310,
    52, 1311, 1312, 1310, 1310, 1310, 1312, 1312,
    1310, 1310, 1310, 1312, 52, 1310, 1313, 52,
    36, 1310, 1310, 1310, 1310, 1310, 52, 52,

    1309, 1309, 1309, 52, 1310, 52, 1314, 52,
    1310, 52, 1315, 1316, 1310, 1310, 1317, 1312,
    1310, 1310, 1318, 1310, 1312, 1319, 1319, 1319,
    1319, 1320, 1321, 1322, 1323, 1324, 1325, 1325,

    1326, 1258, 1258, 1258, 1258, 1325, 1324, 1324,
    1324, 1324, 1327, 1258, 1328, 1329, 1330, 1331,
    1332, 1332, 1332, 66, 66, 66, 66, 66,
    66, 66, 66, 66, 66, 66, 66, 66,

    1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333,
    1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333,
    1334, 1334, 1334, 1334, 1334, 1334, 1334, 1334,
    1334, 1334, 1334, 1334, 1334, 1334, 1334, 1334,

    1335, 1335, 1335, 112, 123, 1336, 1336, 1336,
    1336, 1332, 1337, 1337, 201, 201, 201, 201,
    36, 36, 36, 36, 36, 52, 52, 52,
    52, 52, 1338, 1338, 52, 52, 52, 52,

    36, 52, 52, 36, 52, 52, 36, 52,
    52, 52, 52, 52, 52, 52, 1338, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,

    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 1339, 1338, 1338,
    52, 52, 36, 52, 36, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,

    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 1321, 1321, 1321, 1321, 1321,
    1321, 1321, 1321, 1321, 1258, 1258, 1258, 1258,
    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,

    36, 36, 36, 36, 1338, 36, 36, 36,
    1340, 1341, 1340, 1342, 1343, 1342, 36, 36,
    36, 36, 18, 58, 36, 1344, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 1345,

    1346, 1347, 1348, 36, 1349, 36, 1338, 36,
    36, 36, 36, 36, 1283, 1283, 36, 1283,
    1283, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 1350, 1351, 36, 36,

    36, 1338, 36, 1352, 1338, 1353, 36, 1338,
    36, 1338, 36, 36, 1354, 36, 36, 36,
    36, 36, 1350, 1351, 1350, 1351, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36,

    1338, 36, 1338, 36, 1350, 1351, 1350, 1351,
    1350, 1351, 1350, 1351, 36, 1338, 1355, 1356,
    1355, 1356, 1350, 1351, 1355, 1356, 1350, 1351,
    1355, 1356, 1350, 1351, 1350, 1351, 1350, 1351,

    1355, 1356, 1350, 1351, 1355, 1356, 1350, 1351,
    1355, 1356, 1350, 1351, 36, 36, 36, 1350,
    1351, 1350, 1351, 36, 36, 36, 36, 36,
    1357, 36, 36, 36, 36, 36, 36, 36,

    36, 36, 1350, 1351, 36, 36, 1358, 36,
    1359, 1360, 36, 1360, 1338, 1338, 1338, 1338,
    1350, 1351, 1350, 1351, 1350, 1351, 1350, 1351,
    1361, 36, 36, 36, 36, 36, 36, 36,

    36, 36, 36, 36, 36, 36, 36, 36,
    36, 1350, 1351, 1350, 1351, 1362, 36, 36,
    1350, 1351, 36, 36, 36, 36, 1350, 1351,
    1350, 1351, 1350, 1351, 1350, 1351, 1350, 1351,

    1355, 1356, 1355, 1356, 1350, 1351, 1350, 1351,
    1350, 1351, 1355, 1356, 1355, 1356, 36, 1363,
    1350, 1351, 1364, 1364, 1364, 1258, 1365, 1365,
    1258, 1258, 1366, 1366, 1366, 1367, 1367, 1258,

    52, 1321, 52, 52, 52, 52, 52, 52,
    16, 1253, 16, 1253, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 1368, 1368, 52, 52, 52, 52,

    36, 36, 52, 52, 52, 52, 52, 52,
    52, 1369, 1370, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 1371, 1371,
    1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,

    1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
    1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
    1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
    1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,

    1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
    1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
    1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
    1371, 1371, 1371, 1321, 1258, 1321, 1321, 1321,

    1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321,
    1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321,
    1321, 1321, 1321, 1321, 1321, 1372, 1321, 1321,
    1321, 1321, 1321, 1258, 1258, 1258, 1258, 1258,

    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,
    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,
    1258, 1258, 1258, 1258, 1327, 1327, 1327, 1327,
    1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327,

    1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327,
    1327, 1327, 1327, 1327, 1327, 1327, 1327, 1373,
    1373, 1328, 1328, 1328, 1328, 1328, 1328, 1328,
    1328, 1328, 1328, 1328, 1374, 1374, 1374, 1374,

    1374, 1374, 1329, 1329, 1329, 1329, 1329, 1329,
    1375, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1377, 1377, 1377, 1377, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1379, 1379, 1379, 1379, 1380,

    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,

    52, 52, 52, 52, 52, 1321, 1321, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1381, 1382, 1383, 1384, 1385, 1386, 1387, 1388,
    1389, 66, 66, 66, 66, 66, 66, 66,
    66, 66, 66, 66, 1381, 1382, 1383, 1384,
    1385, 1386, 1387, 1388, 1389, 66, 66, 66,

    66, 66, 66, 66, 66, 66, 66, 66,
    64, 59, 60, 1276, 1277, 1278, 1279, 1280,
    1281, 1390, 1390, 1390, 1390, 1390, 1390, 1390,
    1390, 1390, 1390, 1390, 1391, 1391, 1391, 1391,

    1391, 1391, 1391, 1391, 1391, 1391, 1391, 1391,
    1391, 1391, 1391, 1391, 1391, 1391, 1391, 1391,
    1391, 1391, 1391, 1391, 1391, 1391, 1392, 1392,
    1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,

    1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
    1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,

    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
    1393, 1393, 1394, 1395, 1395, 1395, 1395, 1395,
    1395, 1395, 1395, 1395, 1395, 1396, 1397, 1398,
    1399, 1400, 1401, 1402, 1403, 1404, 1395, 1405,

    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 1327, 1327,
    1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327,

    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 36,
    52, 52, 52, 52, 52, 52, 52, 52,

    52, 36, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,

    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321,
    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,

    1368, 1368, 1368, 1368, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 1406, 1406, 1327, 1327,
    1407, 1321, 1368, 1368, 1368, 1408, 1368, 1368,

    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    52, 1368, 1368, 1368, 52, 52, 52, 52,

    52, 52, 52, 52, 52, 52, 52, 52,
    1368, 52, 52, 52, 52, 52, 52, 36,
    1321, 1321, 1327, 1327, 1327, 1327, 1327, 1327,
    1327, 1327, 1327, 1327, 1327, 1327, 1328, 1407,

    1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327,
    1327, 1327, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1328, 1328, 1328, 1328, 1328, 1328,
    1328, 1328, 1328, 1328, 1328, 1409, 1375, 1375,

    1373, 1373, 1328, 1328, 1328, 1328, 1328, 1328,
    1328, 1328, 1328, 1328, 1410, 1328, 1328, 1328,
    1328, 1328, 1329, 1409, 1409, 1409, 1409, 1409,
    1409, 1409, 1409, 1409, 1409, 1411, 1411, 1411,

    1412, 1412, 1412, 1412, 1411, 1411, 1411, 1411,
    1411, 1375, 1375, 1375, 1375, 1411, 1376, 1411,
    1411, 1411, 1375, 1411, 1411, 1375, 1375, 1375,
    1411, 1411, 1375, 1375, 1411, 1375, 1375, 1411,

    1411, 1411, 1376, 1375, 1376, 1376, 1376, 1376,
    1375, 1375, 1411, 1375, 1375, 1375, 1375, 1375,
    1375, 1411, 1411, 1411, 1411, 1411, 1375, 1411,
    1411, 1413, 1411, 1375, 1375, 1411, 1411, 1411,

    1414, 1368, 1368, 1368, 1368, 1376, 52, 52,
    1368, 1368, 1415, 1415, 1408, 1408, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,

    52, 52, 52, 52, 52, 52, 52, 52,
    1376, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,

    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 1376, 52, 1376, 52,
    52, 52, 52, 1376, 1376, 1376, 52, 1375,
    52, 52, 52, 1416, 1416, 1416, 1416, 1417,

    1417, 52, 1418, 1418, 1368, 52, 52, 52,
    1419, 1420, 1419, 1420, 1419, 1420, 1419, 1420,
    1419, 1420, 1419, 1420, 1419, 1420, 1421, 1422,
    1423, 1424, 1425, 1426, 1427, 1428, 1429, 1430,

    1421, 1422, 1423, 1424, 1425, 1426, 1427, 1428,
    1429, 1430, 1421, 1422, 1423, 1424, 1425, 1426,
    1427, 1428, 1429, 1430, 52, 1376, 1376, 1376,
    52, 52, 52, 52, 52, 52, 52, 52,

    52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 52,
    1376, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 52, 52, 52, 52, 1376,

    1431, 1431, 1431, 1432, 1433, 1434, 1435, 1374,
    1436, 1437, 1374, 1438, 1439, 1440, 1441, 1441,
    1258, 1258, 1258, 1258, 1258, 1442, 1443, 1258,
    1258, 1258, 1258, 1258, 1444, 1442, 1443, 1258,

    1258, 1258, 1442, 1443, 1442, 1443, 1419, 1420,
    1419, 1420, 1419, 1420, 1445, 1446, 1445, 1446,
    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,
    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,

    1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
    1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
    1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,
    1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447,

    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,
    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,
    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,
    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,

    1258, 1258, 1258, 1419, 1420, 1419, 1420, 1419,
    1420, 1419, 1420, 1419, 1420, 1448, 1449, 1450,
    1451, 1419, 1420, 1419, 1420, 1419, 1420, 1419,
    1420, 1258, 1258, 1452, 1258, 1258, 1258, 1258,

    1453, 1258, 1258, 1454, 1442, 1443, 1258, 1258,
    1442, 1443, 1442, 1443, 1442, 1443, 1442, 1443,
    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,
    1455, 1258, 1258, 1258, 1258, 1258, 1258, 1258,

    1442, 1443, 1258, 1258, 1442, 1443, 1258, 1258,
    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1442,
    1443, 1442, 1443, 1258, 1442, 1443, 1258, 1258,
    1419, 1420, 1419, 1420, 1258, 1258, 1258, 1258,

    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,
    1442, 1443, 1258, 1258, 1258, 1258, 1258, 1258,
    1258, 1258, 1258, 1258, 1258, 1456, 1258, 1258,
    1442, 1443, 1258, 1258, 1419, 1420, 1258, 1258,

    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,
    1258, 1258, 1258, 1258, 1326, 1258, 1258, 1258,
    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,
    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,

    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,
    1258, 1258, 1258, 1442, 1443, 1442, 1443, 1258,
    1258, 1258, 1258, 1258, 1442, 1443, 1258, 1258,
    1258, 1258, 1258, 1258, 1442, 1443, 1258, 1258,

    1258, 1258, 1258, 1258, 1442, 1443, 1258, 1258,
    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258,
    1258, 1258, 1258, 1258, 1326, 1326, 1326, 1258,
    1258, 1442, 1443, 1442, 1443, 1442, 1443, 1442,

    1443, 1442, 1443, 1442, 1443, 1442, 1443, 1442,
    1443, 1442, 1443, 1442, 1443, 1442, 1443, 1442,
    1443, 1442, 1443, 1442, 1443, 1442, 1443, 1442,
    1443, 1442, 1443, 1442, 1443, 1442, 1443, 1442,

    1443, 1442, 1443, 1258, 1258, 1258, 1442, 1443,
    1442, 1443, 1442, 1443, 1442, 1443, 1258, 1442,
    1443, 1442, 1443, 1442, 1443, 1442, 1443, 1442,
    1443, 1442, 1443, 1442, 1443, 1442, 1443, 1442,

    1443, 1442, 1443, 1442, 1443, 1442, 1443, 1442,
    1443, 1442, 1443, 1442, 1443, 1442, 1443, 1442,
    1443, 1442, 1443, 1442, 1443, 1442, 1443, 1258,
    1258, 1258, 1258, 1258, 1457, 1258, 1458, 1258,

    1258, 1258, 1258, 1459, 1460, 1459, 1258, 1258,
    1258, 1258, 1258, 1258, 1442, 1443, 1461, 1258,
    1258, 1258, 1258, 1258, 1258, 1258, 1258, 1442,
    1443, 1442, 1443, 1258, 1258, 1258, 1258, 1258,

    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1328, 1328,
    1328, 1328, 1328, 1328, 1329, 1329, 1329, 1329,
    1329, 1329, 1329, 1409, 1409, 1409, 1409, 1409,

    1329, 1329, 1329, 1329, 1409, 1409, 1409, 1409,
    1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409,
    1439, 1439, 1439, 1439, 1439, 1439, 1439, 1439,
    1439, 1439, 1439, 1439, 1439, 1439, 1439, 1439,

    1439, 1439, 1439, 1439, 1439, 1409, 1409, 1439,
    1439, 1439, 1439, 1439, 1439, 1378, 1378, 1378,
    1409, 1409, 1409, 1409, 1409, 1375, 1375, 1375,
    1375, 1375, 1378, 1378, 1378, 1378, 1378, 1378,

    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 201, 201, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,

    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 201, 1462,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,

    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1463, 1463, 1463, 1378, 1378, 1378,

    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1464, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1380, 1463, 1463, 1463, 1463, 1463,
    1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,

    1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
    1463, 1463, 1463, 1463, 1337, 1337, 1337, 1337,
    1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
    1463, 1463, 1463, 1463, 1463, 1463, 1465, 1464,

    1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466,
    1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466,
    1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466,
    1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466,

    1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466,
    1466, 1466, 1466, 1466, 1466, 1466, 1466, 1467,
    1468, 1468, 1468, 1468, 1468, 1468, 1468, 1468,
    1468, 1468, 1468, 1468, 1468, 1468, 1468, 1468,

    1468, 1468, 1468, 1468, 1468, 1468, 1468, 1468,
    1468, 1468, 1468, 1468, 1468, 1468, 1468, 1468,
    1468, 1468, 1468, 1468, 1468, 1468, 1468, 1468,
    1468, 1468, 1468, 1468, 1468, 1468, 1468, 1469,

    127, 123, 1470, 1471, 1472, 1473, 1474, 127,
    123, 127, 123, 127, 123, 1475, 1476, 1477,
    1478, 1173, 1175, 1176, 1479, 127, 123, 1479,
    1173, 1173, 1173, 1173, 1480, 1480, 1481, 1481,

    1482, 1483, 1482, 1483, 1482, 1483, 1482, 1483,
    1482, 1483, 1482, 1483, 1482, 1483, 1482, 1483,
    1482, 1483, 1482, 1483, 1482, 1483, 1482, 1483,
    1482, 1483, 1482, 1483, 1482, 1483, 1482, 1483,

    1482, 1483, 1482, 1483, 1484, 1485, 1485, 1485,
    1485, 1485, 1485, 1486, 1487, 1486, 1487, 1488,
    1488, 1488, 1489, 1490, 201, 201, 201, 201,
    201, 1491, 1492, 1492, 1492, 1493, 1491, 1492,

    1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494,
    1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494,
    1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494,
    1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494,

    1494, 1494, 1494, 1494, 1494, 1494, 201, 1495,
    201, 201, 201, 201, 201, 1495, 201, 201,
    1496, 1496, 1496, 1496, 1496, 1496, 1496, 1496,
    1496, 1496, 1496, 1496, 1496, 1496, 1496, 1496,

    1496, 1496, 1496, 1496, 1496, 1496, 1496, 1496,
    1496, 1496, 1496, 1496, 1496, 1496, 1496, 1496,
    1496, 1496, 1496, 1496, 1496, 1496, 1496, 1496,
    1496, 1496, 1496, 1496, 1496, 1496, 1496, 1496,

    1496, 1496, 1496, 1496, 1496, 1496, 1497, 1497,
    201, 201, 201, 201, 201, 201, 201, 1498,
    1499, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 1500,

    884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    884, 884, 884, 884, 884, 884, 884, 201,
    884, 884, 884, 884, 884, 884, 884, 201,
    884, 884, 884, 884, 884, 884, 884, 201,
    884, 884, 884, 884, 884, 884, 884, 201,

    265, 265, 265, 265, 265, 265, 265, 265,
    265, 265, 265, 265, 265, 265, 265, 265,
    265, 265, 265, 265, 265, 265, 265, 265,
    265, 265, 265, 265, 265, 265, 265, 265,

    1501, 1501, 1502, 1503, 1502, 1503, 1501, 1501,
    1501, 1502, 1503, 1501, 1502, 1503, 1262, 1262,
    1262, 1262, 1262, 1262, 1262, 1262, 1261, 1504,
    1505, 1506, 1507, 1508, 1502, 1503, 1508, 1508,

    1509, 1510, 1445, 1446, 1445, 1446, 1445, 1446,
    1445, 1446, 1506, 1506, 1506, 1506, 1511, 1512,
    1506, 1513, 1514, 1515, 1515, 1514, 1514, 1514,
    1514, 1514, 1516, 1516, 1517, 1518, 1518, 1519,

    1520, 1518, 1521, 1522, 1522, 1523, 1523, 1523,
    1523, 1523, 1524, 1525, 1524, 1525, 1524, 1526,
    1462, 1462, 1527, 1528, 1528, 1529, 1530, 1529,
    1530, 1529, 1530, 1529, 1530, 1531, 201, 201,

    1532, 1532, 1532, 1532, 1532, 1532, 1532, 1532,
    1532, 1532, 1532, 1532, 1532, 1532, 1532, 1532,
    1532, 1532, 1532, 1532, 1532, 1532, 1532, 1532,
    1532, 1532, 201, 1532, 1532, 1532, 1532, 1533,

    1532, 1532, 1532, 1532, 1532, 1532, 1532, 1532,
    1532, 1532, 1532, 1532, 1532, 1532, 1532, 1532,
    1532, 1532, 1532, 1532, 1532, 1532, 1532, 1532,
    1532, 1532, 1532, 1532, 1532, 1532, 1532, 1532,

    1532, 1532, 1532, 1532, 1532, 1532, 1532, 1532,
    1532, 1532, 1532, 1532, 1532, 1532, 1532, 1532,
    1532, 1532, 1532, 1533, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533,
    1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533,
    1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533,
    1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533,

    1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533,
    1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533,
    1533, 1533, 1533, 1533, 1533, 1533, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
    1534, 1534, 1534, 1534, 1535, 1535, 1535, 1535,

    1216, 1536, 1537, 1538, 1368, 1539, 1540, 1541,
    16, 1253, 16, 1253, 16, 1253, 16, 1253,
    16, 1253, 1368, 1368, 16, 1253, 16, 1253,
    16, 1253, 16, 1253, 1542, 1231, 1543, 1543,

    1368, 1541, 1541, 1541, 1541, 1541, 1541, 1541,
    1541, 1541, 1544, 1545, 173, 1546, 1547, 1547,
    1548, 1549, 1549, 1549, 1549, 1550, 1551, 1368,
    1552, 1552, 1552, 1553, 1554, 1555, 1534, 1368,

    201, 1556, 1557, 1556, 1557, 1556, 1557, 1556,
    1557, 1556, 1557, 1557, 1558, 1557, 1558, 1557,
    1558, 1557, 1558, 1557, 1558, 1557, 1558, 1557,
    1558, 1557, 1558, 1557, 1558, 1557, 1558, 1557,

    1558, 1557, 1558, 1556, 1557, 1558, 1557, 1558,
    1557, 1558, 1557, 1557, 1557, 1557, 1557, 1557,
    1558, 1558, 1557, 1558, 1558, 1557, 1558, 1558,
    1557, 1558, 1558, 1557, 1558, 1558, 1557, 1557,

    1557, 1557, 1557, 1556, 1557, 1556, 1557, 1556,
    1557, 1557, 1557, 1557, 1557, 1557, 1556, 1557,
    1557, 1557, 1557, 1557, 1558, 1559, 1559, 201,
    201, 1560, 1560, 1561, 1561, 1562, 1563, 1564,

    1565, 1566, 1567, 1566, 1567, 1566, 1567, 1566,
    1567, 1566, 1567, 1567, 1568, 1567, 1568, 1567,
    1568, 1567, 1568, 1567, 1568, 1567, 1568, 1567,
    1568, 1567, 1568, 1567, 1568, 1567, 1568, 1567,

    1568, 1567, 1568, 1566, 1567, 1568, 1567, 1568,
    1567, 1568, 1567, 1567, 1567, 1567, 1567, 1567,
    1568, 1568, 1567, 1568, 1568, 1567, 1568, 1568,
    1567, 1568, 1568, 1567, 1568, 1568, 1567, 1567,

    1567, 1567, 1567, 1566, 1567, 1566, 1567, 1566,
    1567, 1567, 1567, 1567, 1567, 1567, 1566, 1567,
    1567, 1567, 1567, 1567, 1568, 1566, 1566, 1568,
    1568, 1568, 1568, 1569, 1570, 1571, 1572, 1573,

    201, 201, 201, 201, 201, 1574, 1574, 1574,
    1574, 1574, 1574, 1574, 1574, 1574, 1574, 1574,
    1574, 1574, 1574, 1574, 1574, 1574, 1574, 1574,
    1574, 1574, 1574, 1574, 1574, 1574, 1574, 1574,

    1574, 1574, 1574, 1574, 1574, 1574, 1574, 1574,
    1574, 1574, 1574, 1574, 1574, 1575, 1576, 1577,
    201, 1578, 1578, 1578, 1578, 1578, 1578, 1578,
    1578, 1578, 1578, 1578, 1578, 1578, 1578, 1578,

    1578, 1578, 1578, 1578, 1578, 1578, 1578, 1578,
    1578, 1578, 1578, 1578, 1578, 1578, 1578, 1578,
    1578, 1578, 1578, 1578, 1578, 1578, 1578, 1578,
    1578, 1578, 1578, 1578, 1578, 1578, 1578, 1578,

    1578, 1578, 1578, 1578, 1578, 1578, 1578, 1578,
    1578, 1578, 1578, 1578, 1578, 1578, 1578, 201,
    1579, 1579, 1580, 1580, 1580, 1580, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,

    1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
    1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
    1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
    1583, 1583, 1583, 1584, 1584, 1584, 1584, 1584,

    1407, 1407, 1407, 1407, 1407, 1407, 1407, 1407,
    1407, 1407, 1407, 1407, 1407, 1407, 1407, 1407,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,

    1412, 1412, 1412, 1412, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 1535,
    1585, 1585, 1585, 1585, 1585, 1585, 1585, 1585,
    1585, 1585, 1585, 1585, 1585, 1585, 1585, 1585,

    1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
    1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
    1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
    1586, 1586, 1586, 1586, 1586, 1587, 1587, 201,

    1580, 1580, 1580, 1580, 1580, 1580, 1580, 1580,
    1580, 1580, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,

    1581, 1581, 1581, 1581, 1588, 1588, 1588, 1588,
    1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
    1590, 1591, 1591, 1591, 1591, 1591, 1591, 1591,
    1591, 1591, 1591, 1591, 1591, 1591, 1591, 1591,

    1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
    1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
    1586, 1586, 1586, 1586, 1586, 1586, 1586, 1586,
    1586, 1586, 1586, 1586, 1587, 1587, 1592, 1579,

    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1591, 1591, 1591, 1591, 1591, 1591, 1591,
    1591, 1591, 1591, 1591, 1591, 1591, 1591, 1591,

    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1590, 1590, 1590, 1590,
    1593, 1593, 1593, 1593, 1593, 1593, 1593, 1593,
    1593, 1593, 1593, 1593, 1593, 1593, 1593, 1593,

    1593, 1593, 1593, 1593, 1593, 1593, 1593, 1593,
    1593, 1593, 1593, 1593, 1593, 1593, 1593, 1593,
    1593, 1593, 1593, 1593, 1593, 1593, 1593, 1593,
    1593, 1593, 1593, 1593, 1593, 1593, 1593, 1594,

    1593, 1593, 1593, 1593, 1593, 1593, 1593, 1593,
    1593, 1593, 1593, 1593, 1593, 1593, 1593, 1593,
    1593, 1593, 1593, 1593, 1593, 1593, 1593, 1593,
    1593, 1593, 1593, 1593, 1593, 1593, 1593, 1593,

    1593, 1593, 1593, 1593, 1593, 1593, 1593, 1593,
    1593, 1593, 1593, 1593, 1593, 1593, 1593, 1593,
    1593, 1593, 1593, 1593, 1593, 1593, 1593, 1593,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,

    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1590,
    1590, 1590, 1590, 1581, 1581, 1581, 1581, 1581,

    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,

    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1590, 1590,

    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1590,

    1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
    1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
    1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
    1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,

    1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
    1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
    1595, 1595, 1595, 1595, 1595, 1595, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,

    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,

    1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
    1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
    1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
    1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,

    1597, 1597, 1597, 1597, 1597, 1597, 1598, 1598,
    1598, 1598, 1598, 1598, 1598, 1598, 1598, 1598,
    1598, 1598, 1598, 1598, 1598, 1598, 1598, 1598,
    1598, 1598, 1598, 1598, 1599, 1599, 1599, 1599,

    1599, 1599, 1599, 1599, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1601, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,

    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1604, 1604, 1604, 1604, 1604,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1605, 1605, 1605,

    1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
    1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
    1606, 1606, 1606, 1606, 1606, 1607, 1606, 1606,
    1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,

    1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
    1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
    1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
    1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,

    1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
    1606, 1606, 1606, 1606, 1606, 201, 201, 201,
    1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
    1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,

    1608, 1608, 1609, 1609, 1608, 1608, 1608, 1608,
    1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
    1608, 1608, 1608, 1608, 1609, 1608, 1608, 1608,
    1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,

    1608, 1609, 1608, 1608, 1608, 1609, 1608, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
    1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,

    1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
    1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
    1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
    1611, 1611, 1611, 1611, 1611, 1611, 1612, 1613,

    1614, 1614, 1614, 1614, 1614, 1614, 1614, 1614,
    1614, 1614, 1614, 1614, 1614, 1614, 1614, 1614,
    1614, 1614, 1614, 1614, 1614, 1614, 1614, 1614,
    1614, 1614, 1614, 1614, 1614, 1614, 1614, 1614,

    1614, 1614, 1614, 1614, 1614, 1614, 1614, 1614,
    1614, 1614, 1614, 1614, 1615, 1616, 1617, 1618,
    1614, 1614, 1614, 1614, 1614, 1614, 1614, 1614,
    1614, 1614, 1614, 1614, 1614, 1614, 1614, 1614,

    1619, 1620, 1621, 1622, 1623, 1624, 1625, 1626,
    1627, 1628, 1614, 1614, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    279, 280, 279, 280, 279, 280, 279, 280,
    279, 280, 279, 280, 279, 280, 279, 280,
    279, 280, 279, 280, 279, 280, 279, 280,
    279, 280, 279, 280, 279, 280, 279, 280,

    283, 284, 279, 280, 279, 280, 279, 280,
    279, 280, 279, 280, 279, 280, 1629, 265,
    1630, 1630, 1630, 1631, 1632, 1632, 1632, 1632,
    1632, 1632, 1632, 1632, 265, 265, 1631, 1633,

    279, 280, 279, 280, 279, 280, 279, 280,
    279, 280, 279, 280, 279, 280, 279, 280,
    279, 280, 279, 280, 279, 280, 279, 280,
    285, 286, 285, 286, 1634, 1634, 1635, 1632,

    1636, 1636, 1636, 1636, 1636, 1636, 1636, 1636,
    1636, 1636, 1636, 1636, 1636, 1636, 1636, 1636,
    1636, 1636, 1636, 1636, 1636, 1636, 1636, 1636,
    1636, 1636, 1636, 1636, 1636, 1636, 1636, 1636,

    1636, 1636, 1636, 1636, 1636, 1636, 1637, 1637,
    1637, 1637, 1637, 1637, 1637, 1637, 1637, 1637,
    1638, 1638, 1639, 1640, 1641, 1641, 1641, 1640,
    201, 201, 201, 201, 201, 201, 201, 201,

    1642, 1642, 1642, 1642, 1642, 1642, 1642, 1642,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1644,
    1644, 1644, 1644, 1512, 1512, 1512, 1512, 1512,

    1645, 1645, 1175, 1176, 1175, 1176, 1175, 1176,
    1175, 1176, 1175, 1176, 1175, 1176, 1175, 1176,
    1173, 1173, 1175, 1176, 1175, 1176, 1175, 1176,
    1175, 1176, 1175, 1176, 1175, 1176, 1175, 1176,

    1175, 1176, 1175, 1176, 1175, 1176, 1175, 1176,
    1175, 1176, 1175, 1176, 1175, 1176, 1175, 1176,
    1175, 1176, 1175, 1176, 1175, 1176, 1175, 1176,
    1175, 1176, 1175, 1176, 1175, 1176, 1175, 1176,

    1175, 1176, 1175, 1176, 1175, 1176, 1175, 1176,
    1175, 1176, 1175, 1176, 1175, 1176, 1175, 1176,
    1480, 1173, 1173, 1173, 1173, 1173, 1173, 1173,
    1173, 1175, 1176, 1175, 1176, 1646, 1175, 1176,

    1175, 1176, 1175, 1176, 1175, 1176, 1175, 1176,
    1512, 1647, 1647, 1175, 1176, 1648, 1649, 1650,
    1651, 1652, 1653, 1654, 1655, 1656, 1657, 1658,
    1657, 1658, 1657, 1658, 1657, 1658, 1657, 1658,

    1651, 1652, 1651, 1652, 1651, 1652, 1651, 1652,
    1651, 1652, 1659, 1660, 1661, 1662, 1663, 1664,
    1665, 1666, 1667, 1668, 1669, 1670, 1669, 1670,
    1671, 1672, 1673, 1674, 1673, 1674, 1673, 1674,

    1675, 1676, 1673, 1674, 1677, 1678, 1679, 1680,
    1681, 1680, 1681, 201, 201, 201, 201, 201,
    1675, 1676, 201, 1682, 201, 1682, 1675, 1676,
    1675, 1676, 201, 201, 201, 201, 201, 201,

    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 1683, 1683, 1683, 1680, 1681, 1684,
    1685, 1685, 1649, 1686, 1686, 1686, 1686, 1686,

    1687, 1687, 1688, 1687, 1687, 1687, 1689, 1687,
    1687, 1687, 1687, 1688, 1687, 1687, 1687, 1687,
    1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
    1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,

    1687, 1687, 1687, 1690, 1690, 1688, 1688, 1690,
    1691, 1691, 1691, 1691, 1692, 201, 201, 201,
    1589, 1589, 1589, 1589, 1589, 1589, 826, 826,
    1293, 1693, 201, 201, 201, 201, 201, 201,

    1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694,
    1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694,
    1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694,
    1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694,

    1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694,
    1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694,
    1694, 1694, 1695, 1696, 1697, 1697, 1698, 1698,
    201, 201, 201, 201, 201, 201, 201, 201,

    1699, 1699, 1700, 1700, 1700, 1700, 1700, 1700,
    1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,
    1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,
    1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,

    1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,
    1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,
    1700, 1700, 1700, 1700, 1699, 1699, 1699, 1699,
    1699, 1699, 1699, 1699, 1699, 1699, 1699, 1699,

    1699, 1699, 1699, 1699, 1701, 1702, 201, 201,
    201, 201, 201, 201, 201, 201, 1703, 1703,
    1704, 1705, 1706, 1707, 1708, 1709, 1710, 1711,
    1712, 1713, 201, 201, 201, 201, 201, 201,

    1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
    1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
    1714, 1714, 516, 516, 516, 516, 516, 516,
    1715, 1715, 1715, 516, 1716, 1717, 1718, 1719,

    1720, 1721, 1722, 1723, 1724, 1725, 1726, 1727,
    1728, 1729, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,

    1730, 1730, 1730, 1730, 1730, 1730, 1731, 1731,
    1731, 1731, 1731, 1732, 1732, 1732, 1733, 1734,
    1735, 1735, 1735, 1735, 1735, 1735, 1735, 1735,
    1735, 1735, 1735, 1735, 1735, 1735, 1735, 1735,

    1735, 1735, 1735, 1735, 1735, 1735, 1735, 1736,
    1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736,
    1736, 1736, 1737, 1738, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 1739,

    876, 876, 876, 876, 876, 876, 876, 876,
    876, 876, 876, 876, 876, 876, 876, 876,
    876, 876, 876, 876, 876, 876, 876, 876,
    876, 876, 876, 876, 876, 201, 201, 201,

    1740, 1740, 1740, 1741, 1742, 1742, 1742, 1742,
    1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
    1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
    1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,

    1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
    1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
    1742, 1742, 1742, 1743, 1741, 1741, 1740, 1740,
    1740, 1740, 1741, 1741, 1740, 1740, 1741, 1741,

    1744, 1745, 1745, 1745, 1745, 1745, 1745, 1746,
    1747, 1747, 1745, 1745, 1745, 1745, 201, 1748,
    1749, 1750, 1751, 1752, 1753, 1754, 1755, 1756,
    1757, 1758, 201, 201, 201, 201, 1745, 1745,

    1759, 1759, 1759, 1759, 1759, 1760, 1761, 1759,
    1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
    1762, 1763, 1764, 1765, 1766, 1767, 1768, 1769,
    1770, 1771, 1759, 1759, 1759, 1759, 1759, 201,

    1772, 1772, 1772, 1772, 1772, 1772, 1772, 1772,
    1772, 1772, 1772, 1772, 1772, 1772, 1772, 1772,
    1772, 1772, 1772, 1772, 1772, 1772, 1772, 1772,
    1772, 1772, 1772, 1772, 1772, 1772, 1772, 1772,

    1772, 1772, 1772, 1772, 1772, 1772, 1772, 1772,
    1772, 1773, 1773, 1773, 1773, 1773, 1773, 1774,
    1774, 1773, 1773, 1774, 1774, 1773, 1773, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1775, 1775, 1775, 1773, 1775, 1775, 1775, 1775,
    1775, 1775, 1775, 1775, 1773, 1774, 201, 201,
    1776, 1777, 1778, 1779, 1780, 1781, 1782, 1783,
    1784, 1785, 201, 201, 1786, 1787, 1787, 1787,

    1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
    1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
    1789, 1788, 1788, 1788, 1788, 1788, 1788, 1790,
    1790, 1790, 1788, 864, 1760, 1791, 1759, 1759,

    1792, 1792, 1792, 1792, 1792, 1792, 1792, 1792,
    1792, 1792, 1792, 1792, 1792, 1792, 1792, 1792,
    1792, 1792, 1792, 1792, 1792, 1792, 1792, 1792,
    1792, 1792, 1792, 1792, 1792, 1792, 1792, 1792,

    1792, 1792, 1792, 1792, 1792, 1792, 1792, 1792,
    1792, 1792, 1792, 1792, 1792, 1792, 1792, 1792,
    1793, 1792, 1793, 1793, 1794, 1792, 1792, 1793,
    1793, 1792, 1792, 1792, 1792, 1792, 1793, 1793,

    1792, 1793, 1792, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 1792, 1792, 1795, 1796, 1796,

    1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797,
    1797, 1797, 1797, 1798, 1799, 1799, 1798, 1798,
    1800, 1800, 1797, 1801, 1801, 1798, 1802, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 1803, 1803, 1803, 1803, 1803, 1803, 201,
    201, 1803, 1803, 1803, 1803, 1803, 1803, 201,
    201, 1803, 1803, 1803, 1803, 1803, 1803, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1803, 1803, 1803, 1803, 1803, 1803, 1803, 201,
    1803, 1803, 1803, 1803, 1803, 1803, 1803, 201,
    1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656,
    1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656,

    1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656,
    1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656,
    1656, 1656, 1656, 1804, 1656, 1656, 1656, 1656,
    1656, 1656, 1656, 1805, 1806, 1806, 1806, 1806,

    1807, 1807, 1807, 1807, 1656, 1808, 1809, 1809,
    1810, 1811, 1812, 1812, 201, 201, 201, 201,
    1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813,
    1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813,

    1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813,
    1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813,
    1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813,
    1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813,

    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,

    1814, 1814, 1814, 1815, 1815, 1816, 1815, 1815,
    1816, 1815, 1815, 1817, 1815, 1818, 201, 201,
    1819, 1820, 1821, 1822, 1823, 1824, 1825, 1826,
    1827, 1828, 201, 201, 201, 201, 201, 201,

    1829, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1829, 1830, 1830, 1830,

    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1829, 1830, 1830, 1830, 1830, 1830, 1830, 1830,

    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1829, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,

    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1829, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,

    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1829, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,

    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1829, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,

    1830, 1830, 1830, 1830, 1829, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
    1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,

    1830, 1830, 1830, 1830, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    879, 879, 879, 879, 879, 879, 879, 879,
    879, 879, 879, 879, 879, 879, 879, 879,

    879, 879, 879, 879, 879, 879, 879, 201,
    201, 201, 201, 882, 882, 882, 882, 882,
    882, 882, 882, 882, 882, 882, 882, 882,
    882, 882, 882, 882, 882, 882, 882, 882,

    882, 882, 882, 882, 882, 882, 882, 882,
    882, 882, 882, 882, 882, 882, 882, 882,
    882, 882, 882, 882, 882, 882, 882, 882,
    882, 882, 882, 882, 201, 201, 201, 201,

    1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831,
    1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831,
    1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831,
    1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831,

    1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832,
    1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832,
    1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832,
    1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832,

    1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833,
    1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833,
    1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833,
    1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833,

    1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833,
    1833, 1833, 1833, 1833, 1833, 1833, 1597, 1597,
    1833, 1597, 1833, 1597, 1597, 1833, 1833, 1833,
    1833, 1833, 1833, 1833, 1833, 1833, 1833, 1597,

    1833, 1597, 1833, 1597, 1597, 1833, 1833, 1597,
    1597, 1597, 1833, 1833, 1833, 1833, 1834, 1834,
    1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835,
    1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835,

    1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835,
    1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835,
    1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835,
    1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835,

    1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835,
    1835, 1835, 1835, 1836, 1836, 1836, 1837, 1837,
    1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
    1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,

    1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
    1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
    1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
    1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,

    1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
    1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
    1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
    1838, 1838, 1837, 1837, 1837, 1837, 1837, 1837,

    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,

    80, 80, 80, 80, 80, 1839, 80, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 294, 294, 294, 294, 294,
    201, 201, 201, 201, 201, 1840, 1841, 1842,

    1843, 1843, 1843, 1843, 1843, 1843, 1843, 1843,
    1843, 1844, 1842, 1842, 1842, 1842, 1842, 1842,
    1842, 1842, 1842, 1842, 1842, 1842, 1842, 299,
    1842, 1842, 1842, 1842, 1842, 299, 1842, 299,

    1842, 1842, 299, 1842, 1842, 299, 1842, 1842,
    1842, 1842, 1842, 1842, 1842, 1842, 1842, 1843,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,

    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,

    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1846, 1846, 1846, 1846, 1846, 1846,
    1846, 1846, 1846, 1846, 1846, 1846, 1846, 1846,

    1846, 1846, 464, 412, 412, 412, 412, 412,
    412, 412, 412, 412, 412, 412, 412, 412,
    412, 412, 412, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,

    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1543, 1231,

    1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847,
    1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,

    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    412, 412, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,

    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    412, 412, 412, 412, 412, 412, 412, 1847,
    1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848,
    1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848,

    1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848,
    1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1849, 338, 1847, 1847,

    1850, 1850, 1850, 1850, 1850, 1850, 1850, 1850,
    1850, 1850, 1850, 1850, 1850, 1850, 1850, 1850,
    1851, 1852, 1853, 1854, 1855, 1856, 1856, 1857,
    1858, 1859, 201, 201, 201, 201, 201, 201,

    172, 172, 172, 172, 1161, 1161, 1161, 1045,
    1045, 1045, 1045, 1045, 1045, 1045, 1635, 1635,
    1860, 1861, 1861, 1862, 1862, 1863, 1864, 1863,
    1864, 1863, 1864, 1863, 1864, 1863, 1864, 1863,

    1864, 1863, 1864, 1863, 1864, 1555, 1555, 1865,
    1866, 1860, 1860, 1860, 1860, 1862, 1862, 1862,
    1867, 1868, 1869, 201, 1870, 1871, 1872, 1872,
    1861, 1284, 1285, 1284, 1285, 1284, 1285, 1873,

    1860, 1860, 1874, 1875, 1876, 1877, 1878, 201,
    1860, 1287, 1245, 1860, 201, 201, 201, 201,
    1845, 1845, 1845, 1879, 1845, 412, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,

    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    1845, 1845, 1845, 1845, 1845, 412, 412, 1880,

    201, 1872, 1860, 1873, 1287, 1245, 1860, 1881,
    1284, 1285, 1860, 1874, 1867, 1875, 1869, 1882,
    1883, 1884, 1885, 1886, 1887, 1888, 1889, 1890,
    1891, 1892, 1871, 1870, 1893, 1878, 1894, 1872,

    1860, 1895, 1895, 1895, 1895, 1895, 1895, 1895,
    1895, 1895, 1895, 1895, 1895, 1895, 1895, 1895,
    1895, 1895, 1895, 1895, 1895, 1895, 1895, 1895,
    1895, 1895, 1895, 1896, 1860, 1897, 1898, 1862,

    1898, 1899, 1899, 1899, 1899, 1899, 1899, 1899,
    1899, 1899, 1899, 1899, 1899, 1899, 1899, 1899,
    1899, 1899, 1899, 1899, 1899, 1899, 1899, 1899,
    1899, 1899, 1899, 1896, 1878, 1897, 1878, 1900,

    1901, 1902, 1284, 1285, 1903, 1904, 1905, 1906,
    1906, 1906, 1906, 1906, 1906, 1906, 1906, 1906,
    1907, 1905, 1905, 1905, 1905, 1905, 1905, 1905,
    1905, 1905, 1905, 1905, 1905, 1905, 1905, 1905,

    1905, 1905, 1905, 1905, 1905, 1905, 1905, 1905,
    1905, 1905, 1905, 1905, 1905, 1905, 1905, 1905,
    1905, 1905, 1905, 1905, 1905, 1905, 1905, 1905,
    1905, 1905, 1905, 1905, 1905, 1905, 1908, 1908,

    1578, 1578, 1578, 1578, 1578, 1578, 1578, 1578,
    1578, 1578, 1578, 1578, 1578, 1578, 1578, 1578,
    1578, 1578, 1578, 1578, 1578, 1578, 1578, 1578,
    1578, 1578, 1578, 1578, 1578, 1578, 1578, 201,

    201, 201, 1578, 1578, 1578, 1578, 1578, 1578,
    201, 201, 1578, 1578, 1578, 1578, 1578, 1578,
    201, 201, 1578, 1578, 1578, 1578, 1578, 1578,
    201, 201, 1578, 1578, 1578, 201, 201, 201,

    1909, 1287, 1878, 1898, 1551, 1287, 1287, 201,
    1309, 1283, 1283, 1283, 1283, 1309, 1309, 201,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1910, 1910, 1910, 1911, 52, 1912, 1912,

    1913, 1913, 1913, 1913, 1913, 1913, 1913, 1913,
    1913, 1913, 1913, 1913, 201, 1913, 1913, 1913,
    1913, 1913, 1913, 1913, 1913, 1913, 1913, 1913,
    1913, 1913, 1913, 1913, 1913, 1913, 1913, 1913,

    1913, 1913, 1913, 1913, 1913, 1913, 1913, 201,
    1913, 1913, 1913, 1913, 1913, 1913, 1913, 1913,
    1913, 1913, 1913, 1913, 1913, 1913, 1913, 1913,
    1913, 1913, 1913, 201, 1913, 1913, 201, 1913,

    1913, 1913, 1913, 1913, 1913, 1913, 1913, 1913,
    1913, 1913, 1913, 1913, 1913, 1913, 201, 201,
    1913, 1913, 1913, 1913, 1913, 1913, 1913, 1913,
    1913, 1913, 1913, 1913, 1913, 1913, 201, 201,

    1913, 1913, 1913, 1913, 1913, 1913, 1913, 1913,
    1913, 1913, 1913, 1913, 1913, 1913, 1913, 1913,
    1913, 1913, 1913, 1913, 1913, 1913, 1913, 1913,
    1913, 1913, 1913, 1913, 1913, 1913, 1913, 1913,

    1913, 1913, 1913, 1913, 1913, 1913, 1913, 1913,
    1913, 1913, 1913, 1913, 1913, 1913, 1913, 1913,
    1913, 1913, 1913, 1913, 1913, 1913, 1913, 1913,
    1913, 1913, 1913, 201, 201, 201, 201, 201,

    1914, 1915, 1914, 201, 201, 201, 201, 1916,
    1916, 1916, 1916, 1916, 1916, 1916, 1916, 1916,
    1916, 1916, 1916, 1916, 1916, 1916, 1916, 1916,
    1916, 1916, 1916, 1916, 1916, 1916, 1916, 1916,

    1916, 1916, 1916, 1916, 1916, 1916, 1916, 1916,
    1916, 1916, 1916, 1916, 1916, 1916, 1916, 1916,
    1916, 1916, 1916, 1916, 201, 201, 201, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,

    1918, 1918, 1918, 1918, 1918, 1918, 1918, 1918,
    1918, 1918, 1918, 1918, 1918, 1918, 1918, 1918,
    1918, 1918, 1918, 1918, 1918, 1918, 1918, 1918,
    1918, 1918, 1918, 1918, 1918, 1918, 1918, 1918,

    1918, 1918, 1918, 1918, 1918, 1918, 1918, 1918,
    1918, 1918, 1918, 1918, 1918, 1918, 1918, 1918,
    1918, 1918, 1918, 1918, 1918, 1919, 1919, 1919,
    1919, 1920, 1920, 1920, 1920, 1920, 1920, 1920,

    1920, 1920, 1920, 1920, 1920, 1920, 1920, 1920,
    1920, 1920, 1919, 1921, 1922, 1923, 1923, 201,
    1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409,
    1409, 1409, 1409, 1409, 1462, 201, 201, 201,

    1922, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    1331, 1331, 1331, 1331, 1331, 1331, 1331, 1331,
    1331, 1331, 1331, 1331, 1331, 1331, 1331, 1331,

    1331, 1331, 1331, 1331, 1331, 1331, 1331, 1331,
    1331, 1331, 1331, 1331, 1331, 1331, 1331, 1331,
    1331, 1331, 1331, 1331, 1331, 1331, 1331, 1331,
    1331, 1331, 1331, 1331, 1331, 1164, 201, 201,

    1924, 1924, 1924, 1924, 1924, 1924, 1924, 1924,
    1924, 1924, 1924, 1924, 1924, 1924, 1924, 1924,
    1924, 1924, 1924, 1924, 1924, 1924, 1924, 1924,
    1924, 1924, 1924, 1924, 1924, 201, 201, 201,

    1925, 1925, 1925, 1925, 1925, 1925, 1925, 1925,
    1925, 1925, 1925, 1925, 1925, 1925, 1925, 1925,
    1925, 1925, 1925, 1925, 1925, 1925, 1925, 1925,
    1925, 1925, 1925, 1925, 1925, 1925, 1925, 1925,

    1925, 1925, 1925, 1925, 1925, 1925, 1925, 1925,
    1925, 1925, 1925, 1925, 1925, 1925, 1925, 1925,
    1925, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1045, 1926, 1926, 1926, 1926, 1926, 1926, 1926,
    1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926,
    1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926,
    1926, 1926, 1926, 1926, 201, 201, 201, 201,

    1927, 1927, 1927, 1927, 1927, 1927, 1927, 1927,
    1927, 1927, 1927, 1927, 1927, 1927, 1927, 1927,
    1927, 1927, 1927, 1927, 1927, 1927, 1927, 1927,
    1927, 1927, 1927, 1927, 1927, 1927, 1927, 1928,

    1929, 1929, 1929, 1929, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 1930, 1930, 1930,
    1931, 1931, 1931, 1931, 1931, 1931, 1931, 1931,
    1931, 1931, 1931, 1931, 1931, 1931, 1931, 1931,

    1931, 1932, 1931, 1931, 1931, 1931, 1931, 1931,
    1931, 1931, 1932, 201, 201, 201, 201, 201,
    1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933,
    1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933,

    1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933,
    1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933,
    1933, 1933, 1933, 1933, 1933, 1933, 1934, 1934,
    1934, 1934, 1934, 201, 201, 201, 201, 201,

    1935, 1935, 1935, 1935, 1935, 1935, 1935, 1935,
    1935, 1935, 1935, 1935, 1935, 1935, 1935, 1935,
    1935, 1935, 1935, 1935, 1935, 1935, 1935, 1935,
    1935, 1935, 1935, 1935, 1935, 1935, 201, 1936,

    1937, 1937, 1937, 1937, 1937, 1937, 1937, 1937,
    1937, 1937, 1937, 1937, 1937, 1937, 1937, 1937,
    1937, 1937, 1937, 1937, 1937, 1937, 1937, 1937,
    1937, 1937, 1937, 1937, 1937, 1937, 1937, 1937,

    1937, 1937, 1937, 1937, 201, 201, 201, 201,
    1937, 1937, 1937, 1937, 1937, 1937, 1937, 1937,
    1938, 1939, 1939, 1939, 1939, 1939, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1940, 1940, 1940, 1940, 1940, 1940, 1940, 1940,
    1940, 1940, 1940, 1940, 1940, 1940, 1940, 1940,
    1940, 1940, 1940, 1940, 1940, 1940, 1940, 1940,
    1940, 1940, 1940, 1940, 1940, 1940, 1940, 1940,

    1940, 1940, 1940, 1940, 1940, 1940, 1941, 1941,
    1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942,
    1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942,
    1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942,

    1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942,
    1942, 1942, 1942, 1942, 1942, 1942, 1943, 1943,
    1944, 1944, 1944, 1944, 1944, 1944, 1944, 1944,
    1944, 1944, 1944, 1944, 1944, 1944, 1944, 1944,

    1944, 1944, 1944, 1944, 1944, 1944, 1944, 1944,
    1944, 1944, 1944, 1944, 1944, 1944, 1944, 1944,
    1944, 1944, 1944, 1944, 1944, 1944, 1944, 1944,
    1944, 1944, 1944, 1944, 1944, 1944, 1944, 1944,

    1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945,
    1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945,
    1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945,
    1945, 1945, 1945, 1945, 1945, 1945, 201, 201,

    1946, 1947, 1948, 1949, 1950, 1951, 1952, 1953,
    1954, 1955, 201, 201, 201, 201, 201, 201,
    1956, 1956, 1956, 1956, 1956, 1956, 1956, 1956,
    1956, 1956, 1956, 1956, 1956, 1956, 1956, 1956,

    1956, 1956, 1956, 1956, 1956, 1956, 1956, 1956,
    1956, 1956, 1956, 1956, 1956, 1956, 1956, 1956,
    1956, 1956, 1956, 1956, 201, 201, 201, 201,
    1957, 1957, 1957, 1957, 1957, 1957, 1957, 1957,

    1957, 1957, 1957, 1957, 1957, 1957, 1957, 1957,
    1957, 1957, 1957, 1957, 1957, 1957, 1957, 1957,
    1957, 1957, 1957, 1957, 1957, 1957, 1957, 1957,
    1957, 1957, 1957, 1957, 201, 201, 201, 201,

    1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958,
    1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958,
    1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958,
    1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958,

    1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958,
    201, 201, 201, 201, 201, 201, 201, 201,
    1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959,
    1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959,

    1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959,
    1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959,
    1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959,
    1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959,

    1959, 1959, 1959, 1959, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 1960,
    1961, 1961, 1961, 1961, 1961, 1961, 1961, 1961,
    1961, 1961, 1961, 201, 1961, 1961, 1961, 1961,

    1961, 1961, 1961, 1961, 1961, 1961, 1961, 1961,
    1961, 1961, 1961, 201, 1961, 1961, 1961, 1961,
    1961, 1961, 1961, 201, 1961, 1961, 201, 1962,
    1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962,

    1962, 1962, 201, 1962, 1962, 1962, 1962, 1962,
    1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962,
    1962, 1962, 201, 1962, 1962, 1962, 1962, 1962,
    1962, 1962, 201, 1962, 1962, 201, 201, 201,

    1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
    1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
    1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
    1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963,

    1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
    1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
    1963, 1963, 1963, 1963, 1963, 1963, 1963, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
    1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
    1963, 1963, 1963, 1963, 1963, 1963, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1964, 1965, 1965, 1683, 1683, 1683, 201, 1683,
    1683, 1683, 1683, 1683, 1683, 1683, 1683, 1683,
    1683, 1683, 1683, 1683, 1683, 1683, 1683, 1683,
    1683, 1683, 1683, 1683, 1683, 1683, 1683, 1683,

    1683, 1683, 1683, 1683, 1683, 1683, 1683, 1683,
    1683, 1683, 1683, 1683, 1683, 1683, 1683, 1683,
    1683, 201, 1683, 1683, 1683, 1683, 1683, 1683,
    1683, 1683, 1683, 201, 201, 201, 201, 201,

    1966, 1966, 1966, 1966, 1966, 1966, 299, 299,
    1966, 299, 1966, 1966, 1966, 1966, 1966, 1966,
    1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966,
    1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966,

    1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966,
    1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966,
    1966, 1966, 1966, 1966, 1966, 1966, 299, 1966,
    1966, 299, 299, 299, 1966, 299, 299, 1966,

    1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967,
    1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967,
    1967, 1967, 1967, 1967, 1967, 1967, 299, 1968,
    1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969,

    1970, 1970, 1970, 1970, 1970, 1970, 1970, 1970,
    1970, 1970, 1970, 1970, 1970, 1970, 1970, 1970,
    1970, 1970, 1970, 1970, 1970, 1970, 1970, 1971,
    1971, 1972, 1972, 1972, 1972, 1972, 1972, 1972,

    1973, 1973, 1973, 1973, 1973, 1973, 1973, 1973,
    1973, 1973, 1973, 1973, 1973, 1973, 1973, 1973,
    1973, 1973, 1973, 1973, 1973, 1973, 1973, 1973,
    1973, 1973, 1973, 1973, 1973, 1973, 1973, 299,

    299, 299, 299, 299, 299, 299, 299, 1974,
    1974, 1974, 1974, 1974, 1974, 1974, 1974, 1974,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    1975, 1975, 1975, 1975, 1975, 1975, 1975, 1975,
    1975, 1975, 1975, 1975, 1975, 1975, 1975, 1975,
    1975, 1975, 1975, 299, 1975, 1975, 299, 299,
    299, 299, 299, 1976, 1976, 1976, 1976, 1976,

    1977, 1977, 1977, 1977, 1977, 1977, 1977, 1977,
    1977, 1977, 1977, 1977, 1977, 1977, 1977, 1977,
    1977, 1977, 1977, 1977, 1977, 1977, 1978, 1978,
    1978, 1978, 1979, 1979, 299, 299, 299, 1980,

    1981, 1981, 1981, 1981, 1981, 1981, 1981, 1981,
    1981, 1981, 1981, 1981, 1981, 1981, 1981, 1981,
    1981, 1981, 1981, 1981, 1981, 1981, 1981, 1981,
    1981, 1981, 299, 299, 299, 299, 299, 1982,

    1983, 1983, 1983, 1983, 1983, 1983, 1983, 1983,
    1983, 1983, 1983, 1983, 1983, 1983, 1983, 1983,
    1983, 1983, 1983, 1983, 1983, 1983, 1983, 1983,
    1983, 1983, 1983, 1983, 1983, 1983, 1983, 1983,

    1984, 1984, 1984, 1984, 1984, 1984, 1984, 1984,
    1984, 1984, 1984, 1984, 1984, 1984, 1984, 1984,
    1984, 1984, 1984, 1984, 1984, 1984, 1984, 1984,
    299, 299, 299, 299, 1985, 1985, 1984, 1984,

    1985, 1985, 1985, 1985, 1985, 1985, 1985, 1985,
    1985, 1985, 1985, 1985, 1985, 1985, 1985, 1985,
    299, 299, 1985, 1985, 1985, 1985, 1985, 1985,
    1985, 1985, 1985, 1985, 1985, 1985, 1985, 1985,

    1985, 1985, 1985, 1985, 1985, 1985, 1985, 1985,
    1985, 1985, 1985, 1985, 1985, 1985, 1985, 1985,
    1985, 1985, 1985, 1985, 1985, 1985, 1985, 1985,
    1985, 1985, 1985, 1985, 1985, 1985, 1985, 1985,

    1986, 1987, 1987, 1987, 299, 1987, 1987, 299,
    299, 299, 299, 299, 1987, 1988, 1987, 1989,
    1986, 1986, 1986, 1986, 299, 1986, 1986, 1986,
    299, 1986, 1986, 1986, 1986, 1986, 1986, 1986,

    1986, 1986, 1986, 1986, 1986, 1986, 1986, 1986,
    1986, 1986, 1986, 1986, 1986, 1986, 1986, 1986,
    1986, 1986, 1986, 1986, 1990, 1990, 299, 299,
    1989, 1991, 1988, 299, 299, 299, 299, 1992,

    1993, 1994, 1995, 1996, 1997, 1997, 1997, 1997,
    1998, 299, 299, 299, 299, 299, 299, 299,
    1999, 1999, 1999, 1999, 1999, 1999, 2000, 2000,
    2001, 299, 299, 299, 299, 299, 299, 299,

    2002, 2002, 2002, 2002, 2002, 2002, 2002, 2002,
    2002, 2002, 2002, 2002, 2002, 2002, 2002, 2002,
    2002, 2002, 2002, 2002, 2002, 2002, 2002, 2002,
    2002, 2002, 2002, 2002, 2002, 2003, 2003, 2004,

    2005, 2005, 2005, 2005, 2005, 2005, 2005, 2005,
    2005, 2005, 2005, 2005, 2005, 2005, 2005, 2005,
    2005, 2005, 2005, 2005, 2005, 2005, 2005, 2005,
    2005, 2005, 2005, 2005, 2005, 2006, 2006, 2006,

    2007, 2007, 2007, 2007, 2007, 2008, 2009, 2008,
    2010, 2008, 2008, 2009, 2009, 2011, 2008, 2008,
    2008, 2008, 2008, 2007, 2007, 2007, 2007, 2011,
    2007, 2007, 2007, 2007, 2007, 2008, 2007, 2007,

    2007, 2008, 2009, 2009, 2008, 2012, 2013, 299,
    299, 299, 299, 2014, 2014, 2014, 2014, 2015,
    2016, 2016, 2016, 2016, 2016, 2016, 2017, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018,
    2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018,
    2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018,
    2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018,

    2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018,
    2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018,
    2018, 2018, 2018, 2018, 2018, 2018, 299, 299,
    299, 2019, 2019, 2019, 2019, 2019, 2019, 2019,

    2020, 2020, 2020, 2020, 2020, 2020, 2020, 2020,
    2020, 2020, 2020, 2020, 2020, 2020, 2020, 2020,
    2020, 2020, 2020, 2020, 2020, 2020, 299, 299,
    2021, 2021, 2021, 2021, 2021, 2021, 2021, 2021,

    2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022,
    2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022,
    2022, 2022, 2022, 299, 299, 299, 299, 299,
    2023, 2023, 2023, 2023, 2023, 2023, 2023, 2023,

    2024, 2025, 2024, 2025, 2025, 2025, 2024, 2024,
    2024, 2025, 2024, 2024, 2025, 2024, 2025, 2025,
    2024, 2025, 299, 299, 299, 299, 299, 299,
    299, 2026, 2026, 2026, 2026, 299, 299, 299,

    299, 299, 299, 299, 299, 299, 299, 299,
    299, 2027, 2027, 2027, 2027, 2028, 2028, 2029,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    2030, 2030, 2030, 2030, 2030, 2030, 2030, 2030,
    2030, 2030, 2030, 2030, 2030, 2030, 2030, 2030,
    2030, 2030, 2030, 2030, 2030, 2030, 2030, 2030,
    2030, 2030, 2030, 2030, 2030, 2030, 2030, 2030,

    2030, 2030, 2030, 2030, 2030, 2030, 2030, 2030,
    2030, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    2031, 2031, 2031, 2031, 2031, 2031, 2031, 2031,
    2031, 2031, 2031, 2031, 2031, 2031, 2031, 2031,
    2031, 2031, 2031, 2031, 2031, 2031, 2031, 2031,
    2031, 2031, 2031, 2031, 2031, 2031, 2031, 2031,

    2031, 2031, 2031, 2031, 2031, 2031, 2031, 2031,
    2031, 2031, 2031, 2031, 2031, 2031, 2031, 2031,
    2031, 2031, 2031, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,

    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 299, 299, 299, 299, 299,
    299, 299, 2033, 2033, 2033, 2033, 2033, 2033,

    2034, 2035, 2035, 2035, 2035, 2035, 2035, 2035,
    2035, 2035, 2035, 2035, 2035, 2035, 2035, 2035,
    2035, 2035, 2035, 2035, 2035, 2035, 2035, 2035,
    2035, 2035, 2035, 2035, 2035, 2035, 2035, 2035,

    2035, 2035, 2036, 2035, 2037, 2037, 2037, 2037,
    299, 299, 299, 299, 299, 299, 299, 299,
    2038, 2039, 2040, 2041, 2042, 2043, 2044, 2045,
    2046, 2047, 299, 299, 299, 299, 299, 299,

    2048, 2049, 2050, 2051, 2052, 2053, 2054, 2055,
    2056, 2057, 2057, 2057, 2057, 2057, 2057, 2057,
    2057, 2057, 2057, 2057, 2057, 2057, 2057, 2057,
    2057, 2057, 2057, 2057, 2057, 2057, 2057, 299,

    2058, 2058, 2058, 2058, 2058, 2058, 2058, 2058,
    2058, 2058, 2058, 2058, 2058, 2058, 2058, 2058,
    2058, 2058, 2058, 2058, 2058, 2058, 2058, 2058,
    2058, 2058, 2058, 2058, 2058, 2058, 2058, 2058,

    2058, 2058, 2058, 2058, 2058, 2058, 2058, 2058,
    2058, 2058, 299, 2059, 2059, 2060, 299, 299,
    2058, 2058, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 2061, 2061, 2061,

    2062, 2062, 2062, 2062, 2062, 2062, 2062, 2062,
    2062, 2062, 2062, 2062, 2062, 2062, 2062, 2062,
    2062, 2062, 2062, 2062, 2062, 2062, 2062, 2062,
    2062, 2062, 2062, 2062, 2062, 2063, 2063, 2063,

    2063, 2063, 2063, 2063, 2063, 2063, 2063, 2062,
    299, 299, 299, 299, 299, 299, 299, 299,
    2064, 2064, 2064, 2065, 2064, 2064, 2064, 2064,
    2064, 2064, 2064, 2064, 2064, 2064, 2064, 2064,

    2064, 2064, 2064, 2064, 2064, 2066, 2067, 2067,
    2068, 2068, 2068, 2067, 2068, 2067, 2067, 2067,
    2067, 2069, 2069, 2069, 2070, 2071, 2071, 2071,
    2071, 2071, 299, 299, 299, 299, 299, 299,

    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    2072, 2072, 2072, 2072, 2073, 2073, 2072, 2072,
    2072, 2072, 2072, 2072, 2072, 2072, 2072, 2072,

    2072, 2072, 2074, 2075, 2074, 2075, 2076, 2076,
    2076, 2076, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    2077, 2078, 2077, 2077, 2079, 2079, 2079, 2078,
    2077, 2079, 2079, 2077, 2077, 2079, 2077, 2077,

    2078, 2077, 2079, 2079, 2077, 2080, 2080, 2080,
    2080, 2081, 2082, 2083, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    2084, 2084, 2084, 2084, 2084, 2084, 2084, 2084,
    2084, 2084, 2084, 2084, 2084, 2084, 2084, 2084,
    2084, 2084, 2084, 2084, 2084, 2084, 2084, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    2085, 2086, 2085, 2087, 2087, 2087, 2087, 2087,
    2087, 2087, 2087, 2087, 2087, 2087, 2087, 2087,
    2087, 2087, 2087, 2087, 2087, 2087, 2087, 2087,
    2087, 2087, 2087, 2087, 2087, 2087, 2087, 2087,
    2087, 2087, 2087, 2087, 2087, 2087, 2087, 2087,
    2087, 2087, 2087, 2087, 2087, 2087, 2087, 2087,
    2087, 2087, 2087, 2087, 2087, 2087, 2087, 2087,
    2086, 2086, 2086, 2086, 2086, 2086, 2086, 2086,
    2086, 2086, 2086, 2086, 2086, 2086, 2088, 2089,
    2089, 2090, 2090, 2090, 2090, 2090, 201, 201,
    201, 201, 2091, 2092, 2093, 2094, 2095, 2096,
    2097, 2098, 2099, 2100, 2100, 2100, 2100, 2100,
    2100, 2100, 2100, 2100, 2100, 2100, 2101, 2102,
    2103, 2104, 2105, 2106, 2107, 2108, 2109, 2110,
    2111, 2112, 2112, 2113, 2113, 2112, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 2114,
    2115, 2115, 2116, 2117, 2117, 2117, 2117, 2117,
    2117, 2117, 2117, 2117, 2117, 2117, 2117, 2117,
    2117, 2117, 2117, 2117, 2117, 2117, 2117, 2117,
    2117, 2117, 2118, 2117, 2118, 2117, 2117, 2117,
    2117, 2117, 2117, 2117, 2117, 2117, 2117, 2117,
    2117, 2117, 2117, 2118, 2117, 2117, 2117, 2117,
    2116, 2116, 2116, 2115, 2115, 2115, 2115, 2116,
    2116, 2119, 2120, 2121, 2121, 2122, 2123, 2123,
    2123, 2123, 2124, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 2125, 201, 201,
    2126, 2126, 2126, 2126, 2126, 2126, 2126, 2126,
    2126, 2126, 2126, 2126, 2126, 2126, 2126, 2126,
    2126, 2126, 2126, 2126, 2126, 2126, 2126, 2126,
    2126, 201, 201, 201, 201, 201, 201, 201,
    2127, 2128, 2129, 2130, 2131, 2132, 2133, 2134,
    2135, 2136, 201, 201, 201, 201, 201, 201,

    2137, 2137, 2137, 2138, 2138, 2138, 2138, 2138,
    2138, 2138, 2138, 2138, 2138, 2138, 2138, 2138,
    2138, 2138, 2138, 2138, 2138, 2138, 2138, 2138,
    2138, 2138, 2138, 2138, 2138, 2138, 2138, 2138,
    2138, 2138, 2138, 2138, 2138, 2138, 2138, 2139,
    2140, 2140, 2140, 2140, 2141, 2140, 2142, 2142,
    2140, 2140, 2140, 2143, 2143, 201, 2144, 2145,
    2146, 2147, 2148, 2149, 2150, 2151, 2152, 2153,
    2154, 2155, 2155, 2155, 2156, 2157, 2157, 2158,
    201, 201, 201, 201, 201, 201, 201, 201,
    2159, 2159, 2159, 2159, 2159, 2159, 2159, 2159,
    2159, 2159, 2159, 2159, 2159, 2159, 2159, 2159,
    2159, 2159, 2159, 2159, 2159, 2159, 2159, 2159,
    2159, 2159, 2159, 2159, 2159, 2159, 2159, 2159,
    2159, 2159, 2159, 2160, 2161, 2162, 2159, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2163, 2163, 2164, 2165, 2165, 2165, 2165, 2165,
    2165, 2165, 2165, 2165, 2165, 2165, 2165, 2165,
    2165, 2165, 2165, 2165, 2165, 2165, 2165, 2165,
    2165, 2165, 2165, 2165, 2165, 2165, 2165, 2165,
    2165, 2165, 2165, 2165, 2165, 2165, 2165, 2165,
    2165, 2165, 2165, 2165, 2165, 2165, 2165, 2165,
    2165, 2165, 2165, 2164, 2164, 2164, 2163, 2163,
    2163, 2163, 2163, 2163, 2163, 2163, 2163, 2164,
    2166, 2165, 2167, 2167, 2165, 2168, 2168, 2169,
    2170, 2171, 2172, 2171, 2171, 2173, 2174, 2175,
    2176, 2177, 2178, 2179, 2180, 2181, 2182, 2183,
    2184, 2185, 2186, 2187, 2188, 2189, 2190, 2190,
    201, 2191, 2191, 2191, 2191, 2191, 2191, 2191,
    2191, 2191, 2191, 2191, 2191, 2191, 2191, 2191,
    2191, 2191, 2191, 2191, 2191, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2192, 2192, 2192, 2192, 2192, 2192, 2192, 2192,
    2192, 2192, 2192, 2192, 2192, 2192, 2192, 2192,
    2192, 2192, 201, 2192, 2192, 2192, 2192, 2192,
    2192, 2192, 2192, 2192, 2192, 2192, 2192, 2192,
    2192, 2192, 2192, 2192, 2192, 2192, 2192, 2192,
    2192, 2192, 2192, 2192, 2193, 2193, 2193, 2194,
    2194, 2194, 2193, 2193, 2194, 2195, 2196, 2194,
    2197, 2197, 2198, 2197, 2197, 2198, 2199, 2200,
    2200, 2201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2202, 2202, 2202, 2202, 2202, 2202, 2202, 201,
    2202, 201, 2202, 2202, 2202, 2202, 201, 2202,
    2202, 2202, 2202, 2202, 2202, 2202, 2202, 2202,
    2202, 2202, 2202, 2202, 2202, 2202, 201, 2202,
    2202, 2202, 2202, 2202, 2202, 2202, 2202, 2202,
    2202, 2203, 201, 201, 201, 201, 201, 201,
    2204, 2204, 2204, 2204, 2204, 2204, 2204, 2204,
    2204, 2204, 2204, 2204, 2204, 2204, 2204, 2204,
    2204, 2204, 2204, 2204, 2204, 2204, 2204, 2204,
    2204, 2204, 2204, 2204, 2204, 2204, 2204, 2204,
    2204, 2204, 2204, 2204, 2204, 2204, 2204, 2204,
    2204, 2204, 2204, 2204, 2204, 2204, 2204, 2205,
    2206, 2206, 2206, 2205, 2205, 2205, 2205, 2205,
    2205, 2207, 2208, 201, 201, 201, 201, 201,
    2209, 2210, 2211, 2212, 2213, 2214, 2215, 2216,
    2217, 2218, 201, 201, 201, 201, 201, 201,

    2219, 2220, 2221, 2221, 201, 2222, 2222, 2222,
    2222, 2222, 2222, 2222, 2222, 201, 201, 2222,
    2222, 201, 201, 2222, 2222, 2222, 2222, 2222,
    2222, 2222, 2222, 2222, 2222, 2222, 2222, 2222,
    2222, 2222, 2222, 2222, 2222, 2222, 2222, 2222,
    2222, 201, 2222, 2222, 2222, 2222, 2222, 2222,
    2222, 201, 2222, 2222, 201, 2222, 2222, 2222,
    2222, 2222, 201, 2223, 2224, 2225, 2226, 2221,
    2220, 2221, 2221, 2221, 2221, 201, 201, 2221,
    2221, 201, 201, 2227, 2227, 2228, 201, 201,
    2229, 201, 201, 201, 201, 201, 201, 2226,
    201, 201, 201, 201, 201, 2225, 2222, 2222,
    2222, 2222, 2221, 2221, 201, 201, 2230, 2230,
    2230, 2230, 2230, 2230, 2230, 201, 201, 201,
    2230, 2230, 2230, 2230, 2230, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2231, 2231, 2231, 2231, 2231, 2231, 2231, 2231,
    2231, 2231, 2231, 2231, 2231, 2231, 2231, 2231,
    2231, 2231, 2231, 2231, 2231, 2231, 2231, 2231,
    2231, 2231, 2231, 2231, 2231, 2231, 2231, 2231,
    2231, 2231, 2231, 2231, 2231, 2231, 2231, 2231,
    2231, 2231, 2231, 2231, 2231, 2231, 2231, 2231,
    2231, 2231, 2231, 2231, 2231, 2232, 2232, 2232,
    2233, 2233, 2233, 2233, 2233, 2233, 2233, 2233,
    2232, 2232, 2234, 2233, 2233, 2232, 2235, 2231,
    2231, 2231, 2231, 2236, 2236, 2237, 2237, 2238,
    2239, 2240, 2241, 2242, 2243, 2244, 2245, 2246,
    2247, 2248, 2249, 2237, 201, 2238, 2250, 2251,
    2252, 2252, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2253, 2253, 2253, 2253, 2253, 2253, 2253, 2253,
    2253, 2253, 2253, 2253, 2253, 2253, 2253, 2253,
    2253, 2253, 2253, 2253, 2253, 2253, 2253, 2253,
    2253, 2253, 2253, 2253, 2253, 2253, 2253, 2253,
    2253, 2253, 2253, 2253, 2253, 2253, 2253, 2253,
    2253, 2253, 2253, 2253, 2253, 2253, 2253, 2253,
    2254, 2255, 2255, 2256, 2256, 2256, 2256, 2256,
    2256, 2255, 2257, 2258, 2258, 2254, 2258, 2256,
    2256, 2255, 2259, 2260, 2253, 2253, 2261, 2253,
    201, 201, 201, 201, 201, 201, 201, 201,
    2262, 2263, 2264, 2265, 2266, 2267, 2268, 2269,
    2270, 2271, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2272, 2272, 2272, 2272, 2272, 2272, 2272, 2272,
    2272, 2272, 2272, 2272, 2272, 2272, 2272, 2272,
    2272, 2272, 2272, 2272, 2272, 2272, 2272, 2272,
    2272, 2272, 2272, 2272, 2272, 2272, 2272, 2272,
    2272, 2272, 2272, 2272, 2272, 2272, 2272, 2272,
    2272, 2272, 2272, 2272, 2272, 2272, 2272, 2273,
    2274, 2274, 2275, 2275, 2275, 2275, 201, 201,
    2274, 2274, 2276, 2276, 2275, 2275, 2274, 2277,
    2278, 2279, 2280, 2280, 2281, 2281, 2282, 2282,
    2282, 2280, 2283, 2283, 2283, 2283, 2283, 2283,
    2283, 2283, 2283, 2283, 2283, 2283, 2283, 2283,
    2284, 2284, 2284, 2284, 2285, 2285, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2286, 2286, 2286, 2286, 2286, 2286, 2286, 2286,
    2286, 2286, 2286, 2286, 2286, 2286, 2286, 2286,
    2286, 2286, 2286, 2286, 2286, 2286, 2286, 2286,
    2286, 2286, 2286, 2286, 2286, 2286, 2286, 2286,
    2286, 2286, 2286, 2286, 2286, 2286, 2286, 2286,
    2286, 2286, 2286, 2286, 2286, 2286, 2286, 2286,
    2287, 2287, 2287, 2288, 2288, 2288, 2288, 2288,
    2288, 2288, 2288, 2287, 2287, 2288, 2287, 2289,
    2288, 2290, 2290, 2291, 2286, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2292, 2293, 2294, 2295, 2296, 2297, 2298, 2299,
    2300, 2301, 201, 201, 201, 201, 201, 201,
    2302, 2302, 2302, 2302, 2302, 2302, 2302, 2302,
    2302, 2302, 2302, 2302, 2302, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2303, 2303, 2303, 2303, 2303, 2303, 2303, 2303,
    2303, 2303, 2303, 2303, 2303, 2303, 2303, 2303,
    2303, 2303, 2303, 2303, 2303, 2303, 2303, 2303,
    2303, 2303, 2303, 2303, 2303, 2303, 2303, 2303,
    2303, 2303, 2303, 2303, 2303, 2303, 2303, 2303,
    2303, 2303, 2303, 2304, 2305, 2304, 2305, 2305,
    2304, 2304, 2304, 2304, 2304, 2304, 2306, 2307,
    2308, 2309, 201, 201, 201, 201, 201, 201,
    2310, 2311, 2312, 2313, 2314, 2315, 2316, 2317,
    2318, 2319, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2320, 2320, 2320, 2320, 2320, 2320, 2320, 2320,
    2320, 2320, 2320, 2320, 2320, 2320, 2320, 2320,
    2320, 2320, 2320, 2320, 2320, 2320, 2320, 2320,
    2320, 2320, 2321, 201, 201, 2322, 2322, 2322,
    2323, 2323, 2322, 2322, 2322, 2322, 2324, 2322,
    2322, 2322, 2322, 2325, 201, 201, 201, 201,
    2326, 2327, 2328, 2329, 2330, 2331, 2332, 2333,
    2334, 2335, 2336, 2336, 2337, 2337, 2337, 2338,
    2339, 2339, 2339, 2339, 2339, 2339, 2339, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2340, 2340, 2340, 2340, 2340, 2340, 2340, 2340,
    2340, 2340, 2340, 2340, 2340, 2340, 2340, 2340,
    2340, 2340, 2340, 2340, 2340, 2340, 2340, 2340,
    2340, 2340, 2340, 2340, 2340, 2340, 2340, 2340,
    2340, 2340, 2340, 2340, 2340, 2340, 2340, 2340,
    2340, 2340, 2340, 2340, 2341, 2341, 2341, 2342,
    2342, 2342, 2342, 2342, 2342, 2342, 2342, 2342,
    2341, 2343, 2344, 2345, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2346, 2346, 2346, 2346, 2346, 2346, 2346, 2346,
    2346, 2346, 2346, 2346, 2346, 2346, 2346, 2346,
    2346, 2346, 2346, 2346, 2346, 2346, 2346, 2346,
    2346, 2346, 2346, 2346, 2346, 2346, 2346, 2346,
    2347, 2347, 2347, 2347, 2347, 2347, 2347, 2347,
    2347, 2347, 2347, 2347, 2347, 2347, 2347, 2347,
    2347, 2347, 2347, 2347, 2347, 2347, 2347, 2347,
    2347, 2347, 2347, 2347, 2347, 2347, 2347, 2347,
    2348, 2349, 2350, 2351, 2352, 2353, 2354, 2355,
    2356, 2357, 2358, 2358, 2358, 2358, 2358, 2358,
    2358, 2358, 2358, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 2359,

    2360, 2360, 2360, 2360, 2360, 2360, 2360, 201,
    201, 2360, 201, 201, 2360, 2360, 2360, 2360,
    2360, 2360, 2360, 2360, 201, 2360, 2360, 201,
    2360, 2360, 2360, 2360, 2360, 2360, 2360, 2360,
    2360, 2360, 2360, 2360, 2360, 2360, 2360, 2360,
    2360, 2360, 2360, 2360, 2360, 2360, 2360, 2360,
    2361, 2362, 2362, 2362, 2362, 2362, 201, 2362,
    2363, 201, 201, 2364, 2364, 2365, 2366, 2367,
    2362, 2367, 2362, 2368, 2369, 2370, 2369, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2371, 2372, 2373, 2374, 2375, 2376, 2377, 2378,
    2379, 2380, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381,
    201, 201, 2381, 2381, 2381, 2381, 2381, 2381,
    2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381,
    2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381,
    2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381,
    2381, 2381, 2381, 2381, 2381, 2381, 2381, 2381,
    2381, 2382, 2382, 2382, 2383, 2383, 2383, 2383,
    201, 201, 2383, 2383, 2382, 2382, 2382, 2382,
    2384, 2381, 2385, 2381, 2382, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2386, 2387, 2387, 2387, 2387, 2387, 2387, 2388,
    2388, 2387, 2387, 2386, 2386, 2386, 2386, 2386,
    2386, 2386, 2386, 2386, 2386, 2386, 2386, 2386,
    2386, 2386, 2386, 2386, 2386, 2386, 2386, 2386,
    2386, 2386, 2386, 2386, 2386, 2386, 2386, 2386,
    2386, 2386, 2386, 2386, 2386, 2386, 2386, 2386,
    2386, 2386, 2386, 2387, 2389, 2387, 2387, 2387,
    2387, 2390, 2391, 2387, 2387, 2387, 2387, 2392,
    2393, 2394, 2395, 2395, 2394, 2392, 2393, 2389,
    201, 201, 201, 201, 201, 201, 201, 201,
    2396, 2397, 2397, 2397, 2397, 2397, 2397, 2398,
    2398, 2397, 2397, 2397, 2396, 2396, 2396, 2396,
    2396, 2396, 2396, 2396, 2396, 2396, 2396, 2396,
    2396, 2396, 2396, 2396, 2396, 2396, 2396, 2396,
    2396, 2396, 2396, 2396, 2396, 2396, 2396, 2396,
    2396, 2396, 2396, 2396, 2396, 2396, 2396, 2396,
    2396, 2396, 2396, 2396, 2399, 2399, 2400, 2400,
    2400, 2400, 2397, 2397, 2397, 2397, 2397, 2397,
    2397, 2397, 2397, 2397, 2397, 2397, 2397, 2398,
    2397, 2401, 2402, 2403, 2403, 2404, 2405, 2405,
    2405, 2402, 2402, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2406, 2406, 2406, 2406, 2406, 2406, 2406, 2406,
    2406, 2406, 2406, 2406, 2406, 2406, 2406, 2406,
    2407, 2407, 2407, 2407, 2407, 2407, 2407, 2407,
    2407, 2407, 2407, 2407, 2407, 2407, 2407, 2407,
    2407, 2407, 2407, 2407, 2407, 2407, 2407, 2407,
    2407, 2407, 2407, 2407, 2407, 2407, 2407, 2407,
    2407, 2407, 2407, 2407, 2407, 2407, 2407, 2407,
    2407, 2407, 2407, 2407, 2407, 2407, 2407, 2407,
    2407, 2407, 2407, 2407, 2407, 2407, 2407, 2407,
    2407, 201, 201, 201, 201, 201, 201, 201,

    2408, 2408, 2408, 2408, 2408, 2408, 2408, 2408,
    2408, 2408, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2409, 2409, 2409, 2409, 2409, 2409, 2409, 2409,
    2409, 201, 2409, 2409, 2409, 2409, 2409, 2409,
    2409, 2409, 2409, 2409, 2409, 2409, 2409, 2409,
    2409, 2409, 2409, 2409, 2409, 2409, 2409, 2409,
    2409, 2409, 2409, 2409, 2409, 2409, 2409, 2409,
    2409, 2409, 2409, 2409, 2409, 2409, 2409, 2410,
    2411, 2411, 2411, 2411, 2411, 2411, 2411, 201,
    2411, 2411, 2411, 2411, 2411, 2411, 2410, 2412,
    2409, 2413, 2413, 2414, 2414, 2414, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2415, 2416, 2417, 2418, 2419, 2420, 2421, 2422,
    2423, 2424, 2425, 2425, 2425, 2425, 2425, 2425,
    2425, 2425, 2425, 2425, 2425, 2425, 2425, 2425,
    2425, 2425, 2425, 2425, 2425, 201, 201, 201,
    2426, 2427, 2428, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    201, 201, 2429, 2429, 2429, 2429, 2429, 2429,
    2429, 2429, 2429, 2429, 2429, 2429, 2429, 2429,
    2429, 2429, 2429, 2429, 2429, 2429, 2429, 2429,
    201, 2430, 2429, 2429, 2429, 2429, 2429, 2429,
    2429, 2430, 2429, 2429, 2430, 2429, 2429, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2431, 2431, 2431, 2431, 2431, 2431, 2431, 201,
    2431, 2431, 201, 2431, 2431, 2431, 2431, 2431,
    2431, 2431, 2431, 2431, 2431, 2431, 2431, 2431,
    2431, 2431, 2431, 2431, 2431, 2431, 2431, 2431,
    2431, 2431, 2431, 2431, 2431, 2431, 2431, 2431,
    2431, 2431, 2431, 2431, 2431, 2431, 2431, 2431,
    2431, 2432, 2432, 2432, 2432, 2432, 2432, 201,
    201, 201, 2432, 201, 2432, 2432, 201, 2432,
    2432, 2432, 2433, 2432, 2434, 2434, 2435, 2432,
    201, 201, 201, 201, 201, 201, 201, 201,
    2436, 2437, 2438, 2439, 2440, 2441, 2442, 2443,
    2444, 2445, 201, 201, 201, 201, 201, 201,
    2446, 2446, 2446, 2446, 2446, 2446, 201, 2446,
    2446, 201, 2446, 2446, 2446, 2446, 2446, 2446,
    2446, 2446, 2446, 2446, 2446, 2446, 2446, 2446,
    2446, 2446, 2446, 2446, 2446, 2446, 2446, 2446,
    2446, 2446, 2446, 2446, 2446, 2446, 2446, 2446,
    2446, 2446, 2447, 2447, 2447, 2447, 2447, 201,
    2448, 2448, 201, 2447, 2447, 2448, 2447, 2449,
    2446, 201, 201, 201, 201, 201, 201, 201,
    2450, 2451, 2452, 2453, 2454, 2455, 2456, 2457,
    2458, 2459, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2460, 2460, 2460, 2460, 2460, 2460, 2460, 2460,
    2460, 2460, 2460, 2460, 2460, 2460, 2460, 2460,
    2460, 2460, 2461, 2462, 2462, 2463, 2463, 2464,
    2464, 201, 201, 201, 201, 201, 201, 201,

    2465, 2465, 2466, 2467, 2468, 2468, 2468, 2468,
    2468, 2468, 2468, 2468, 2468, 2468, 2468, 2468,
    2468, 201, 2468, 2468, 2468, 2468, 2468, 2468,
    2468, 2468, 2468, 2468, 2468, 2468, 2468, 2468,
    2468, 2468, 2468, 2468, 2468, 2468, 2468, 2468,
    2468, 2468, 2468, 2468, 2468, 2468, 2468, 2468,
    2468, 2468, 2468, 2468, 2467, 2467, 2465, 2465,
    2465, 2465, 2465, 201, 201, 201, 2467, 2467,
    2465, 2469, 2470, 2471, 2471, 2472, 2472, 2472,
    2472, 2472, 2472, 2472, 2472, 2472, 2472, 2472,
    2473, 2474, 2475, 2476, 2477, 2478, 2479, 2480,
    2481, 2482, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2483, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2484, 2484, 2484, 2484, 2484, 2484, 2484, 2484,
    2484, 2484, 2484, 2484, 2484, 2484, 2484, 2484,
    2484, 2484, 2484, 2484, 2484, 2485, 2485, 2485,
    2485, 2485, 2485, 2485, 2485, 2486, 2486, 2486,
    2486, 2485, 2485, 2485, 2485, 2485, 2485, 2485,
    2485, 2485, 2485, 2485, 2485, 2485, 2485, 2485,
    2485, 2485, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 2487,

    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,

    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2488,
    2488, 2488, 2488, 2488, 2488, 2488, 2488, 2489,
    2489, 2489, 2489, 2489, 2489, 2489, 2489, 2489,
    2489, 2489, 2489, 2489, 2489, 2489, 2489, 2489,
    2489, 2489, 2489, 2489, 2489, 2489, 2489, 2489,
    2489, 2489, 2489, 2489, 2489, 2489, 2489, 2489,
    2489, 2489, 2489, 2489, 2489, 2489, 2489, 2489,
    2489, 2490, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 201,
    2493, 2493, 2493, 2493, 2494, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,

    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2495, 2495, 2495, 2495, 2495, 2495, 2495, 2495,
    2495, 2495, 2495, 2495, 2495, 2495, 2495, 2495,
    2495, 2495, 2495, 2495, 2495, 2495, 2495, 2495,
    2495, 2495, 2495, 2495, 2495, 2495, 2495, 2495,
    2495, 2495, 2495, 2495, 2495, 2495, 2495, 2495,
    2495, 2495, 2495, 2495, 2495, 2495, 2495, 2495,
    2495, 2495, 2495, 2495, 2495, 2495, 2495, 2495,
    2495, 2495, 2495, 2495, 2495, 2495, 2495, 2495,
    2495, 2495, 2495, 2495, 2495, 2495, 2495, 2495,
    2495, 2495, 2495, 2495, 2495, 2495, 2495, 2495,
    2495, 2495, 2495, 2495, 2495, 2495, 2495, 2495,
    2495, 2495, 2495, 2495, 2495, 2495, 2495, 2495,
    2495, 2496, 2496, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,

    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2498, 2498, 2498, 2499, 2499, 2499, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2499, 2497, 2497, 2497, 2498, 2499,
    2498, 2499, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,

    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2498, 2499, 2499, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,

    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2497,
    2497, 2497, 2497, 2497, 2497, 2497, 2497, 2500,
    2501, 2501, 2501, 2501, 2501, 2501, 2501, 2502,
    2503, 2504, 2504, 2504, 2505, 2506, 2505, 2506,
    2507, 2508, 2508, 2508, 2508, 2508, 2508, 2507,
    2507, 2507, 2507, 2507, 2507, 2507, 2507, 2507,
    2507, 2507, 2507, 2507, 2507, 2507, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,

    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2510, 2511,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,

    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 2509,
    2509, 2509, 2509, 2509, 2509, 2509, 2509, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,

    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 201, 201, 201, 201, 201, 201, 201,
    2513, 2513, 2513, 2513, 2513, 2513, 2513, 2513,
    2513, 2513, 2513, 2513, 2513, 2513, 2513, 2513,
    2513, 2513, 2513, 2513, 2513, 2513, 2513, 2513,
    2513, 2513, 2513, 2513, 2513, 2513, 2513, 201,
    2514, 2515, 2516, 2517, 2518, 2519, 2520, 2521,
    2522, 2523, 201, 201, 201, 201, 2524, 2524,
    2525, 2525, 2525, 2525, 2525, 2525, 2525, 2525,
    2525, 2525, 2525, 2525, 2525, 2525, 2525, 2525,
    2525, 2525, 2525, 2525, 2525, 2525, 2525, 2525,
    2525, 2525, 2525, 2525, 2525, 2525, 2525, 2525,
    2525, 2525, 2525, 2525, 2525, 2525, 2525, 2525,
    2525, 2525, 2525, 2525, 2525, 2525, 2525, 2525,
    2525, 2525, 2525, 2525, 2525, 2525, 2525, 2525,
    2525, 2525, 2525, 2525, 2525, 2525, 2525, 2525,
    2525, 2525, 2525, 2525, 2525, 2525, 2525, 2525,
    2525, 2525, 2525, 2525, 2525, 2525, 2525, 201,
    2526, 2527, 2528, 2529, 2530, 2531, 2532, 2533,
    2534, 2535, 201, 201, 201, 201, 201, 201,
    2536, 2536, 2536, 2536, 2536, 2536, 2536, 2536,
    2536, 2536, 2536, 2536, 2536, 2536, 2536, 2536,
    2536, 2536, 2536, 2536, 2536, 2536, 2536, 2536,
    2536, 2536, 2536, 2536, 2536, 2536, 201, 201,
    2537, 2537, 2537, 2537, 2537, 2538, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2539, 2539, 2539, 2539, 2539, 2539, 2539, 2539,
    2539, 2539, 2539, 2539, 2539, 2539, 2539, 2539,
    2539, 2539, 2539, 2539, 2539, 2539, 2539, 2539,
    2539, 2539, 2539, 2539, 2539, 2539, 2539, 2539,
    2539, 2539, 2539, 2539, 2539, 2539, 2539, 2539,
    2539, 2539, 2539, 2539, 2539, 2539, 2539, 2539,
    2540, 2540, 2540, 2540, 2540, 2540, 2540, 2541,
    2541, 2542, 2543, 2543, 2544, 2544, 2544, 2544,
    2545, 2545, 2545, 2545, 2541, 2544, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2546, 2547, 2548, 2549, 2550, 2551, 2552, 2553,
    2554, 2555, 201, 2556, 2556, 2556, 2556, 2556,
    2556, 2556, 201, 2539, 2539, 2539, 2539, 2539,
    2539, 2539, 2539, 2539, 2539, 2539, 2539, 2539,
    2539, 2539, 2539, 2539, 2539, 2539, 2539, 2539,
    201, 201, 201, 201, 201, 2539, 2539, 2539,
    2539, 2539, 2539, 2539, 2539, 2539, 2539, 2539,
    2539, 2539, 2539, 2539, 2539, 2539, 2539, 2539,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2557, 2557, 2557, 2557, 2557, 2557, 2557, 2557,
    2557, 2557, 2557, 2557, 2557, 2557, 2557, 2557,
    2557, 2557, 2557, 2557, 2557, 2557, 2557, 2557,
    2557, 2557, 2557, 2557, 2557, 2557, 2557, 2557,
    2558, 2558, 2558, 2558, 2558, 2558, 2558, 2558,
    2558, 2558, 2558, 2558, 2558, 2558, 2558, 2558,
    2558, 2558, 2558, 2558, 2558, 2558, 2558, 2558,
    2558, 2558, 2558, 2558, 2558, 2558, 2558, 2558,
    2559, 2559, 2559, 2559, 2559, 2559, 2559, 2559,
    2559, 2559, 2559, 2559, 2559, 2559, 2559, 2559,
    2559, 2559, 2559, 2559, 2559, 2559, 2559, 2560,
    2561, 2562, 2562, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2563, 2563, 2563, 2563, 2563, 2563, 2563, 2563,
    2563, 2563, 2563, 2563, 2563, 2563, 2563, 2563,
    2563, 2563, 2563, 2563, 2563, 2563, 2563, 2563,
    2563, 2563, 2563, 2563, 2563, 2563, 2563, 2563,
    2563, 2563, 2563, 2563, 2563, 2563, 2563, 2563,
    2563, 2563, 2563, 2563, 2563, 2563, 2563, 2563,
    2563, 2563, 2563, 2563, 2563, 2563, 2563, 2563,
    2563, 2563, 2563, 2563, 2563, 2563, 2563, 2563,
    2563, 2563, 2563, 2563, 2563, 2564, 2564, 2564,
    2564, 2564, 2564, 201, 201, 201, 201, 2565,
    2563, 2566, 2566, 2566, 2566, 2566, 2566, 2566,
    2566, 2566, 2566, 2566, 2566, 2566, 2566, 2566,
    2566, 2566, 2566, 2566, 2566, 2566, 2566, 2566,
    2566, 2566, 2566, 2566, 2566, 2566, 2566, 2566,
    2566, 2566, 2566, 2566, 2566, 2566, 2566, 2566,
    2566, 2566, 2566, 2566, 2566, 2566, 2566, 2567,
    2567, 2567, 2567, 2567, 2567, 2567, 2567, 2567,
    201, 201, 201, 201, 201, 201, 201, 2568,
    2568, 2568, 2568, 2569, 2569, 2569, 2569, 2569,
    2569, 2569, 2569, 2569, 2569, 2569, 2569, 2569,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2570, 2571, 2572, 2573, 2574, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2575, 2575, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,

    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2577, 2577, 2577,
    2577, 2577, 2578, 2578, 2578, 2578, 2578, 2578,
    201, 201, 201, 201, 201, 201, 201, 201,

    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2579, 2579, 2579, 2579, 2579,
    2579, 2579, 2579, 2579, 2579, 2579, 2579, 2579,

    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,

    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
    2580, 2580, 2580, 2580, 2580, 2580, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2579, 2579, 2579, 2579, 2579, 2579, 2579, 2579,
    2579, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2581, 2581, 2581, 2581, 201, 2581, 2581, 2581,
    2581, 2581, 2581, 2581, 201, 2581, 2581, 201,

    2582, 2583, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,

    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2584,
    2584, 2584, 2584, 2584, 2584, 2584, 2584, 2585,
    2586, 2586, 2586, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 2587, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2588, 2588, 2588, 201, 201, 2589, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 2590, 2590, 2590, 2590,
    201, 201, 201, 201, 201, 201, 201, 201,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,

    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 2591, 2591, 2591, 2591,
    2591, 2591, 2591, 2591, 201, 201, 201, 201,

    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 2592, 201, 201, 201, 201, 201,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 2592, 2592, 2592, 201, 201, 201,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 201, 201, 201, 201, 201, 201, 201,
    2592, 2592, 2592, 2592, 2592, 2592, 2592, 2592,
    2592, 2592, 201, 201, 2593, 2594, 2595, 2596,
    2597, 2597, 2597, 2597, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2598, 2598, 2598, 2598, 2598, 2598, 2598, 2598,
    2598, 2598, 2598, 2598, 2598, 2598, 2598, 2598,
    2598, 2598, 2598, 2598, 2598, 2598, 2598, 2598,
    2598, 2598, 2598, 2598, 2598, 2598, 2598, 2598,
    2598, 2598, 2598, 2598, 2598, 2598, 2598, 2598,
    2598, 2598, 2598, 2598, 2598, 2598, 201, 201,
    2598, 2598, 2598, 2598, 2598, 2598, 2598, 2598,
    2598, 2598, 2598, 2598, 2598, 2598, 2598, 2598,
    2598, 2598, 2598, 2598, 2598, 2598, 2598, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 2599,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 2599,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 2599,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 2599,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 2599,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 2599,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 2599,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 2599,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 2599,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 2599,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 2599,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 2599,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 2599,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 2599,
    2599, 2599, 2599, 2599, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 201,
    201, 1331, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2601, 2601,
    2601, 2601, 2601, 2601, 2601, 2602, 2603, 2604,
    2604, 2604, 2600, 2600, 2600, 2605, 2602, 2602,
    2602, 2602, 2602, 2606, 2606, 2606, 2606, 2606,
    2606, 2606, 2606, 2607, 2607, 2607, 2607, 2607,
    2607, 2607, 2607, 2600, 2600, 2608, 2608, 2608,
    2608, 2608, 2607, 2607, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2608, 2608, 2608, 2608, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2601, 2601, 2601, 2601, 2601,
    2601, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
    2600, 2600, 2600, 2600, 2600, 2600, 2609, 2609,
    2609, 2609, 2609, 2609, 2609, 2609, 2609, 2609,
    2609, 2610, 2610, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1920, 1920, 1920, 1920, 1920, 1920, 1920, 1920,
    1920, 1920, 1920, 1920, 1920, 1920, 1920, 1920,
    1920, 1920, 1920, 1920, 1920, 1920, 1920, 1920,
    1920, 1920, 1920, 1920, 1920, 1920, 1920, 1920,
    1920, 1920, 1920, 1920, 1920, 1920, 1920, 1920,
    1920, 1920, 1920, 1920, 1920, 1920, 1920, 1920,
    1920, 1920, 1920, 1920, 1920, 1920, 1920, 1920,
    1920, 1920, 1920, 1920, 1920, 1920, 1920, 1920,
    1920, 1920, 2611, 2611, 2611, 1920, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2612, 2612, 2612, 2612, 2612, 2612, 2612, 2612,
    2612, 2612, 2612, 2612, 2612, 2612, 2612, 2612,
    2612, 2612, 2612, 2612, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2613, 2613, 2613, 2613, 2613, 2613, 2613, 2613,
    2613, 2613, 2613, 2613, 2613, 2613, 2613, 2613,
    2613, 2613, 2613, 2613, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1373, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2614, 2614, 2614, 2614, 2614, 2614, 2614, 2614,
    2614, 2614, 2614, 2614, 2614, 2614, 2614, 2614,
    2614, 2614, 2613, 2613, 2613, 2613, 2613, 2613,
    2613, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 201, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2615, 201, 2615, 2615,
    201, 201, 2615, 201, 201, 2615, 2615, 201,
    201, 2615, 2615, 2615, 2615, 201, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2616, 2616,
    2616, 2616, 201, 2616, 201, 2616, 2616, 2616,
    2616, 2617, 2616, 2616, 201, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,

    2616, 2616, 2616, 2616, 2615, 2615, 201, 2615,
    2615, 2615, 2615, 201, 201, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 201, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 201, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2615, 2615, 201, 2615, 2615, 2615, 2615, 201,
    2615, 2615, 2615, 2615, 2615, 201, 2615, 201,
    201, 201, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 201, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,

    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 1323, 1323, 201, 201,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2618, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2619, 2616, 2616, 2616, 2616,
    2616, 2616, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2618, 2616, 2616, 2616, 2616,

    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2619, 2616, 2616,
    2616, 2616, 2616, 2616, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2618, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2619,
    2616, 2616, 2616, 2616, 2616, 2616, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2618,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2619, 2616, 2616, 2616, 2616, 2616, 2616,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2615, 2615, 2615, 2615, 2615, 2615, 2615,
    2615, 2618, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2619, 2616, 2616, 2616, 2616,
    2616, 2616, 2620, 2621, 201, 201, 2622, 2623,
    2624, 2625, 2626, 2627, 2628, 2629, 2630, 2631,
    2622, 2623, 2624, 2625, 2626, 2627, 2628, 2629,
    2630, 2631, 2622, 2623, 2624, 2625, 2626, 2627,
    2628, 2629, 2630, 2631, 2622, 2623, 2624, 2625,
    2626, 2627, 2628, 2629, 2630, 2631, 2622, 2623,
    2624, 2625, 2626, 2627, 2628, 2629, 2630, 2631,

    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,

    2633, 2633, 2633, 2633, 2633, 2633, 2633, 2633,
    2633, 2633, 2633, 2633, 2633, 2633, 2633, 2633,
    2633, 2633, 2633, 2633, 2633, 2633, 2633, 2633,
    2633, 2633, 2633, 2633, 2633, 2633, 2633, 2633,
    2633, 2633, 2633, 2633, 2633, 2633, 2633, 2633,
    2633, 2633, 2633, 2633, 2633, 2633, 2633, 2633,
    2633, 2633, 2633, 2633, 2633, 2633, 2633, 2632,
    2632, 2632, 2632, 2633, 2633, 2633, 2633, 2633,
    2633, 2633, 2633, 2633, 2633, 2633, 2633, 2633,
    2633, 2633, 2633, 2633, 2633, 2633, 2633, 2633,
    2633, 2633, 2633, 2633, 2633, 2633, 2633, 2633,
    2633, 2633, 2633, 2633, 2633, 2633, 2633, 2633,
    2633, 2633, 2633, 2633, 2633, 2633, 2633, 2633,
    2633, 2633, 2633, 2633, 2633, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2633, 2632, 2632,
    2632, 2632, 2632, 2632, 2632, 2632, 2632, 2632,
    2632, 2632, 2632, 2632, 2633, 2632, 2632, 2634,
    2635, 2634, 2634, 2636, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 2633, 2633, 2633, 2633, 2633,
    201, 2633, 2633, 2633, 2633, 2633, 2633, 2633,
    2633, 2633, 2633, 2633, 2633, 2633, 2633, 2633,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    1682, 1682, 1682, 1682, 1682, 1682, 1682, 1682,
    1682, 1682, 2637, 1682, 1682, 1682, 1682, 1682,
    1682, 1682, 1682, 1682, 1682, 1682, 1682, 1682,
    1682, 1682, 1682, 1682, 1682, 1682, 1682, 201,
    201, 201, 201, 201, 201, 2638, 2638, 2638,
    2638, 2638, 2638, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2639, 2639, 2639, 2639, 2639, 2639, 2639, 201,
    2639, 2639, 2639, 2639, 2639, 2639, 2639, 2639,
    2639, 2639, 2639, 2639, 2639, 2639, 2639, 2639,
    2639, 201, 201, 2639, 2639, 2639, 2639, 2639,
    2639, 2639, 201, 2639, 2639, 201, 2639, 2639,
    2639, 2639, 2639, 201, 201, 201, 201, 201,
    2640, 2640, 2640, 2640, 2640, 2640, 2640, 2640,
    2640, 2640, 2640, 2640, 2640, 2640, 2640, 2640,
    2640, 2640, 2640, 2640, 2640, 2640, 2640, 2640,
    2640, 2640, 2640, 2640, 2640, 2640, 2640, 2640,
    2640, 2640, 2640, 2640, 2640, 2640, 2640, 2640,
    2640, 2640, 2640, 2640, 2640, 2640, 2640, 2640,
    2640, 2640, 2640, 2640, 2640, 2640, 2640, 2640,
    2640, 2640, 2640, 2640, 2640, 2640, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 2641,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    2642, 2642, 2642, 2642, 2642, 2642, 2642, 2642,
    2642, 2642, 2642, 2642, 2642, 2642, 2642, 2642,
    2642, 2642, 2642, 2642, 2642, 2642, 2642, 2642,
    2642, 2642, 2642, 2642, 2642, 2642, 2642, 2642,
    2642, 2642, 2642, 2642, 2642, 2642, 2642, 2642,
    2642, 2642, 2642, 2642, 2642, 201, 201, 201,
    2643, 2643, 2643, 2643, 2643, 2643, 2643, 2644,
    2644, 2644, 2644, 2644, 2644, 2644, 201, 201,
    2645, 2646, 2647, 2648, 2649, 2650, 2651, 2652,
    2653, 2654, 201, 201, 201, 201, 2642, 2655,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,

    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2656, 2656, 2656, 2656, 2656, 2656, 2656, 2656,
    2656, 2656, 2656, 2656, 2656, 2656, 2656, 2656,
    2656, 2656, 2656, 2656, 2656, 2656, 2656, 2656,
    2656, 2656, 2656, 2656, 2656, 2656, 2657, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2658, 2658, 2658, 2658, 2658, 2658, 2658, 2658,
    2658, 2658, 2658, 2658, 2658, 2658, 2658, 2658,
    2658, 2658, 2658, 2658, 2658, 2658, 2658, 2658,
    2658, 2658, 2658, 2658, 2658, 2658, 2658, 2658,
    2658, 2658, 2658, 2658, 2658, 2658, 2658, 2658,
    2658, 2658, 2658, 2658, 2659, 2659, 2659, 2659,
    2660, 2661, 2662, 2663, 2664, 2665, 2666, 2667,
    2668, 2669, 201, 201, 201, 201, 201, 2670,

    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2671, 2671, 2671, 2671, 2671, 2671, 2671, 2671,
    2671, 2671, 2671, 2671, 2671, 2671, 2671, 2671,
    2671, 2671, 2671, 2671, 2671, 2671, 2671, 2671,
    2671, 2671, 2671, 2672, 2673, 2673, 2674, 2675,
    2676, 2677, 2678, 2679, 2680, 2681, 2682, 2683,
    2684, 2685, 201, 201, 201, 201, 201, 201,

    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2686, 2686, 2686, 2686, 2686, 2686, 2686, 201,
    2686, 2686, 2686, 2686, 201, 2686, 2686, 201,
    2686, 2686, 2686, 2686, 2686, 2686, 2686, 2686,
    2686, 2686, 2686, 2686, 2686, 2686, 2686, 201,

    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 2687, 2687, 2687,
    2687, 2687, 2687, 2687, 2687, 299, 299, 2688,
    2688, 2688, 2688, 2688, 2688, 2688, 2688, 2688,
    2689, 2689, 2689, 2689, 2689, 2689, 2689, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    2690, 2690, 2690, 2690, 2690, 2690, 2690, 2690,
    2690, 2690, 2690, 2690, 2690, 2690, 2690, 2690,
    2690, 2690, 2690, 2690, 2690, 2690, 2690, 2690,
    2690, 2690, 2690, 2690, 2690, 2690, 2690, 2690,
    2690, 2690, 2691, 2691, 2691, 2691, 2691, 2691,
    2691, 2691, 2691, 2691, 2691, 2691, 2691, 2691,
    2691, 2691, 2691, 2691, 2691, 2691, 2691, 2691,
    2691, 2691, 2691, 2691, 2691, 2691, 2691, 2691,
    2691, 2691, 2691, 2691, 2692, 2692, 2692, 2692,
    2692, 2692, 2693, 2694, 299, 299, 299, 299,
    2695, 2696, 2697, 2698, 2699, 2700, 2701, 2702,
    2703, 2704, 299, 299, 299, 299, 2705, 2705,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 2706, 2706, 2706, 2706, 2706, 2706, 2706,
    2706, 2706, 2706, 2706, 2706, 2706, 2706, 2706,
    2706, 2706, 2706, 2706, 2706, 2706, 2706, 2706,
    2706, 2706, 2706, 2706, 2706, 2706, 2706, 2706,
    2706, 2706, 2706, 2706, 2706, 2706, 2706, 2706,
    2706, 2706, 2706, 2706, 2706, 2706, 2706, 2706,
    2706, 2706, 2706, 2706, 2706, 2706, 2706, 2706,
    2706, 2706, 2706, 2706, 2707, 2706, 2706, 2706,
    2708, 2706, 2706, 2706, 2706, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    299, 2709, 2709, 2709, 2709, 2709, 2709, 2709,
    2709, 2709, 2709, 2709, 2709, 2709, 2709, 2709,
    2709, 2709, 2709, 2709, 2709, 2709, 2709, 2709,
    2709, 2709, 2709, 2709, 2709, 2709, 2709, 2709,
    2709, 2709, 2709, 2709, 2709, 2709, 2709, 2709,
    2709, 2709, 2709, 2709, 2709, 2709, 2710, 2709,
    2709, 2709, 2709, 2709, 2709, 2709, 2709, 2709,
    2709, 2709, 2709, 2709, 2709, 2709, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,
    299, 299, 299, 299, 299, 299, 299, 299,

    2711, 2711, 2711, 2711, 412, 2711, 2711, 2711,
    2711, 2711, 2711, 2711, 2711, 2711, 2711, 2711,
    2711, 2711, 2711, 2711, 2711, 2711, 2711, 2711,
    2711, 2711, 2711, 2711, 2711, 2711, 2711, 2711,
    412, 2711, 2711, 412, 2711, 412, 412, 2711,
    412, 2711, 2711, 2711, 2711, 2711, 2711, 2711,
    2711, 2711, 2711, 412, 2711, 2711, 2711, 2711,
    412, 2711, 412, 2711, 412, 412, 412, 412,
    412, 412, 2711, 412, 412, 412, 412, 2711,
    412, 2711, 412, 2711, 412, 2711, 2711, 2711,
    412, 2711, 2711, 412, 2711, 412, 412, 2711,
    412, 2711, 412, 2711, 412, 2711, 412, 2711,
    412, 2711, 2711, 412, 2711, 412, 412, 2711,
    2711, 2711, 2711, 412, 2711, 2711, 2711, 2711,
    2711, 2711, 2711, 412, 2711, 2711, 2711, 2711,
    412, 2711, 2711, 2711, 2711, 412, 2711, 412,
    2711, 2711, 2711, 2711, 2711, 2711, 2711, 2711,
    2711, 2711, 412, 2711, 2711, 2711, 2711, 2711,
    2711, 2711, 2711, 2711, 2711, 2711, 2711, 2711,
    2711, 2711, 2711, 2711, 412, 412, 412, 412,
    412, 2711, 2711, 2711, 412, 2711, 2711, 2711,
    2711, 2711, 412, 2711, 2711, 2711, 2711, 2711,
    2711, 2711, 2711, 2711, 2711, 2711, 2711, 2711,
    2711, 2711, 2711, 2711, 412, 412, 412, 412,
    412, 412, 412, 412, 412, 412, 412, 412,
    412, 412, 412, 412, 412, 412, 412, 412,
    412, 412, 412, 412, 412, 412, 412, 412,
    412, 412, 412, 412, 412, 412, 412, 412,
    412, 412, 412, 412, 412, 412, 412, 412,
    412, 412, 412, 412, 412, 412, 412, 412,
    2712, 2712, 412, 412, 412, 412, 412, 412,
    412, 412, 412, 412, 412, 412, 412, 412,

    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1837, 1837, 1837, 1837,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1837,
    1837, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1414,
    1837, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1837, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 1414, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,

    2713, 2713, 2714, 2715, 2716, 2717, 2718, 2719,
    2720, 2721, 2722, 2723, 2723, 2724, 2724, 2724,
    2725, 2725, 2725, 2725, 2725, 2725, 2725, 2725,
    2725, 2725, 2725, 2725, 2725, 2725, 2725, 2725,
    2725, 2725, 2725, 2725, 2725, 2725, 2725, 2725,
    2725, 2725, 2725, 2725, 2725, 2725, 2725, 1463,
    2726, 2727, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2727, 2726, 2727,
    2726, 2726, 2727, 2726, 2726, 2726, 2727, 2726,
    2726, 2726, 2725, 2725, 2725, 2725, 2725, 2728,
    2729, 2729, 2729, 2729, 2729, 2729, 2729, 2730,
    2729, 2729, 2729, 2729, 2729, 2729, 2729, 2730,
    2729, 2729, 2729, 2729, 2729, 2729, 2729, 2729,
    2729, 2729, 2731, 2731, 2732, 2724, 2724, 2724,
    2729, 2729, 2729, 2729, 2729, 2729, 2729, 2729,
    2729, 2730, 2729, 2730, 2730, 2729, 2729, 2730,
    2729, 2729, 2729, 2729, 2729, 2729, 2729, 2729,
    2729, 2729, 826, 826, 826, 826, 2733, 2733,
    2725, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2734, 2734, 2734, 2734, 2734,
    2734, 2734, 2734, 2734, 2734, 2734, 2734, 2734,
    2734, 2734, 2734, 2734, 2734, 2724, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 2735, 2735,
    2735, 2735, 2735, 2735, 2735, 2735, 2735, 2735,
    2735, 2735, 2735, 2735, 2735, 2735, 2735, 2735,
    2735, 2735, 2735, 2735, 2735, 2735, 2735, 2735,

    2736, 2737, 2737, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588,
    1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588,
    1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588,
    1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588,
    1588, 1588, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 2738, 1837, 1837, 1837, 1837,
    1588, 1588, 1588, 1588, 1588, 1588, 1588, 1588,
    1588, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    2737, 2737, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    2739, 2739, 2739, 2739, 2739, 2739, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,

    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 2740, 2740, 2740,
    1377, 1377, 1377, 1377, 1377, 1377, 1414, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1414, 2740, 2740,
    1377, 1377, 1377, 1377, 1377, 1415, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1378, 1378, 1414, 1414,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1376, 1376, 1377,
    1377, 1377, 1377, 1377, 1376, 1377, 1377, 1377,
    1377, 1377, 1415, 1415, 1415, 1414, 1377, 1415,
    1377, 1377, 1415, 2741, 2741, 1414, 1414, 2740,
    2740, 2740, 2740, 2740, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    2740, 2740, 2740, 2742, 2742, 2742, 2742, 2742,

    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1414,
    1377, 1414, 1415, 1415, 1377, 1377, 1415, 1415,
    1415, 1415, 1415, 1415, 1415, 1415, 1415, 1415,
    1415, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1415, 1415,
    1415, 1415, 1415, 1415, 1415, 1415, 1415, 1415,
    1415, 1415, 1415, 1415, 1415, 1415, 1415, 1415,
    1415, 1377, 1377, 1377, 1415, 1377, 1377, 1377,
    1377, 1415, 1415, 1415, 1377, 1415, 1415, 1415,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1415,
    1377, 1415, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1376, 1377, 1376, 1377, 1376, 1377, 1377, 1377,
    1377, 1377, 1415, 1377, 1377, 1377, 1377, 1376,
    1377, 1376, 1376, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1414, 1377, 1377, 1377, 1377, 1414, 1414, 2740,

    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1378, 1378,
    2743, 2743, 2743, 2743, 1378, 1378, 1378, 1378,
    1378, 1378, 1414, 2740, 2740, 2740, 2740, 2740,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 2741, 2741, 1414, 1414,
    1414, 1414, 2744, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    2741, 1414, 1414, 1414, 1414, 2741, 2741, 1414,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 2745, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1378, 1378, 1378, 1378,
    1378, 1378, 1414, 1377, 1377, 1377, 1377, 1377,

    2746, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 2746, 1377, 1377, 1377, 2746, 1377, 2746,
    1377, 2746, 1377, 2746, 1377, 1377, 1377, 2746,
    1377, 1377, 1377, 1377, 1377, 1377, 2746, 2746,
    1377, 1377, 1377, 1377, 2746, 1377, 2746, 2746,
    1377, 1377, 1377, 1377, 2746, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1414, 1414, 2740, 2740, 1415, 1415, 1415,
    1377, 1377, 1377, 1415, 1415, 1415, 1415, 1415,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 2747, 2747,
    2747, 2748, 2748, 2748, 1378, 1378, 1378, 1378,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1415, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1377, 1377, 1377, 1377, 1415, 1415, 1415, 1377,
    1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    1415, 1377, 1377, 1377, 1377, 1377, 1414, 1414,
    1414, 1414, 1414, 1414, 2741, 1414, 1414, 1414,
    2740, 2745, 2745, 2739, 2739, 2749, 2724, 2724,
    1837, 1837, 1837, 1837, 2750, 2751, 2751, 2751,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 1837, 1837, 1837,
    1414, 1414, 1414, 1414, 2745, 2745, 2745, 2739,
    2739, 2752, 2749, 2724, 2724, 1837, 1837, 1837,

    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 2750, 2750, 2750, 1837,
    1837, 1837, 1837, 2750, 2750, 2750, 2750, 2750,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 2752, 2752, 2752,
    2752, 2750, 1837, 1837, 1837, 1837, 1837, 1837,
    2749, 2749, 2749, 2749, 2749, 2749, 2749, 2749,
    2749, 2749, 2749, 2749, 1837, 1837, 1837, 1837,
    2751, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,

    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1837, 1837, 1837, 1837,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1837, 1837, 1837, 1837, 1837, 1837,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378,
    1378, 1378, 1378, 1378, 1378, 1378, 1837, 1837,
    2724, 2724, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,

    1380, 1380, 1380, 1380, 1380, 1380, 1380, 1380,
    1380, 1380, 1380, 1380, 2753, 2749, 2749, 2754,
    2740, 2740, 2740, 2740, 2740, 2740, 2740, 2740,
    2755, 2744, 2744, 2744, 2744, 2744, 2744, 2756,
    2745, 2745, 2745, 2745, 2745, 2745, 2744, 2745,
    2739, 2739, 2739, 2739, 2739, 2739, 2739, 2739,
    2744, 2756, 2756, 2744, 2744, 2744, 2744, 2744,
    2744, 2744, 2745, 2745, 2744, 2744, 2744, 2749,
    2745, 2745, 2745, 2745, 2745, 2745, 2745, 2745,
    2745, 2745, 2745, 2745, 2739, 2752, 2752, 2752,
    2745, 2745, 2745, 2745, 2745, 2745, 2745, 2745,
    2745, 2745, 2745, 2745, 2745, 2745, 2745, 2739,
    2739, 2739, 2739, 2739, 2739, 2739, 2739, 2739,
    2739, 2739, 2739, 2739, 2752, 2752, 2752, 2752,
    2752, 2749, 2724, 2752, 2752, 2752, 2752, 2753,
    2724, 2751, 2752, 2749, 2752, 2752, 2752, 2752,
    2740, 2740, 2740, 2740, 2740, 2745, 2745, 2745,
    2745, 2745, 2745, 2745, 2745, 2745, 2745, 2745,
    2745, 2745, 2739, 2739, 2739, 2739, 2739, 2739,
    2752, 2752, 2752, 2752, 2752, 2752, 2752, 2752,
    2752, 2752, 2752, 2724, 2724, 2749, 2749, 2749,
    2749, 2749, 2749, 2724, 2724, 2724, 2749, 2749,
    2752, 2752, 2752, 2752, 2752, 2757, 2757, 2752,
    2757, 2757, 2749, 2754, 2749, 2749, 2749, 2749,
    2740, 2752, 2752, 2749, 2749, 2749, 2749, 2749,
    2749, 2749, 2749, 2724, 2751, 2754, 2754, 2754,
    2739, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2739, 2739,
    2739, 2739, 2739, 2739, 2739, 2739, 2739, 2752,
    2752, 2752, 2752, 2752, 2752, 2752, 2752, 2752,
    2752, 2752, 2752, 2752, 2752, 2752, 2752, 2752,
    2752, 2752, 2752, 2752, 2752, 2752, 2752, 2752,

    1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
    1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
    1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
    1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
    1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
    1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
    1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
    1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
    1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
    1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
    1464, 1464, 1464, 1464, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    2752, 2752, 2752, 2752, 2752, 2752, 2752, 2752,
    2752, 2752, 2752, 2752, 2752, 2752, 1837, 1837,
    2749, 2749, 2749, 2749, 2724, 2750, 2750, 2750,
    2749, 2749, 2749, 2751, 2751, 1837, 1837, 1837,
    2749, 2749, 2749, 2724, 2724, 2724, 2724, 2750,
    2750, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    2749, 2749, 2749, 2749, 2749, 2749, 2724, 2724,
    2724, 2724, 2724, 2724, 2724, 2724, 2724, 2724,
    2724, 2724, 2724, 2724, 2724, 2724, 2724, 2724,
    2724, 2751, 2751, 2751, 2751, 2750, 2750, 2750,
    2724, 2724, 2724, 2724, 2724, 2724, 2724, 2751,
    2751, 2751, 2751, 2750, 2750, 2750, 1837, 2750,
    2724, 2724, 2724, 2758, 2758, 2758, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 2750, 2750,
    2724, 2724, 2724, 2724, 2724, 2724, 2724, 2751,
    2751, 2751, 2750, 2750, 1837, 1837, 1837, 1837,
    2751, 2751, 2751, 2751, 2751, 2751, 2751, 2751,
    2750, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    2758, 2758, 2758, 2758, 2758, 2758, 2758, 2759,
    2759, 1837, 1837, 1837, 1837, 1837, 1837, 1837,

    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 201, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    2760, 2761, 2762, 2763, 2764, 2765, 2766, 2767,
    2768, 2769, 201, 201, 201, 201, 201, 201,

    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,

    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 2770, 2770,

    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,

    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 2771,
    2771, 2771, 2771, 2771, 2771, 2771, 2771, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1605, 1605,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,

    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,

    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1605, 1605, 1605,
    1605, 2772, 1837, 1837, 1837, 1837, 1837, 1837,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,

    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 1837, 1837,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,

    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,

    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
    1602, 1602, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,

    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,

    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1603, 1603, 1603, 1603, 1603, 1603, 1603,
    1603, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,

    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,

    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,

    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,

    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 2775, 2775,
    2775, 2775, 2775, 2775, 2775, 2775, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,

    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,

    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1837, 1837, 1837, 1837, 1837,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,

    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,

    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    2772, 2772, 2772, 2772, 2772, 2772, 2772, 2772,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,

    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 201, 201,
    201, 201, 201, 201, 201, 201, 2770, 2770,

    1268, 2606, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    2776, 2776, 2776, 2776, 2776, 2776, 2776, 2776,
    2776, 2776, 2776, 2776, 2776, 2776, 2776, 2776,
    2776, 2776, 2776, 2776, 2776, 2776, 2776, 2776,
    2776, 2776, 2776, 2776, 2776, 2776, 2776, 2776,
    2776, 2776, 2776, 2776, 2776, 2776, 2776, 2776,
    2776, 2776, 2776, 2776, 2776, 2776, 2776, 2776,
    2776, 2776, 2776, 2776, 2776, 2776, 2776, 2776,
    2776, 2776, 2776, 2776, 2776, 2776, 2776, 2776,
    2776, 2776, 2776, 2776, 2776, 2776, 2776, 2776,
    2776, 2776, 2776, 2776, 2776, 2776, 2776, 2776,
    2776, 2776, 2776, 2776, 2776, 2776, 2776, 2776,
    2776, 2776, 2776, 2776, 2776, 2776, 2776, 2776,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,

    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    2777, 2777, 2777, 2777, 2777, 2777, 2777, 2777,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,

    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
    1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,

    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,

    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2770, 2770
};

#define GET_PROP_INDEX(ucs4) \
       (ucs4 < 0x11000 \
        ? (uc_property_trie[uc_property_trie[ucs4>>5] + (ucs4 & 0x1f)]) \
        : (uc_property_trie[uc_property_trie[((ucs4 - 0x11000)>>8) + 0x880] + (ucs4 & 0xff)]))

#define GET_PROP_INDEX_UCS2(ucs2) \
       (uc_property_trie[uc_property_trie[ucs2>>5] + (ucs2 & 0x1f)])

static const Properties uc_properties[] = {
    { 9, 18, 0, 0, -1, 0, 1, 0, 3, 0, 0, 21, 2 },
    { 9, 8, 0, 0, -1, 0, 1, 0, 3, 0, 6, 17, 2 },
    { 9, 7, 0, 0, -1, 0, 1, 0, 2, 2, 2, 37, 2 },
    { 9, 8, 0, 0, -1, 0, 1, 0, 3, 3, 6, 38, 2 },
    { 9, 9, 0, 0, -1, 0, 1, 0, 3, 3, 6, 38, 2 },
    { 9, 7, 0, 0, -1, 0, 1, 0, 1, 1, 1, 36, 2 },
    { 9, 7, 0, 0, -1, 0, 1, 0, 3, 0, 0, 21, 2 },
    { 9, 8, 0, 0, -1, 0, 1, 0, 3, 0, 0, 21, 2 },
    { 6, 9, 0, 0, -1, 0, 1, 0, 0, 22, 6, 35, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 0, 13, 6, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 12, 14, 3, 2 },
    { 25, 4, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 27, 4, 0, 0, -1, 0, 1, 0, 0, 0, 0, 9, 2 },
    { 25, 4, 0, 0, -1, 0, 1, 0, 0, 0, 0, 10, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 11, 14, 3, 2 },
    { 21, 10, 0, 0, -1, 1, 1, 0, 0, 0, 14, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 1, 0, 0, 0, 14, 2, 2 },
    { 26, 3, 0, 0, -1, 0, 1, 0, 0, 0, 0, 9, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 0, 0, 15, 12, 8, 2 },
    { 20, 3, 0, 0, -1, 0, 1, 0, 0, 0, 12, 16, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 0, 0, 15, 11, 8, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 0, 0, 0, 0, 7, 2 },
    { 3, 2, 0, 0, 0, 0, 1, 0, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 1, 0, 1, 0, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 2, 0, 1, 0, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 3, 0, 1, 0, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 4, 0, 1, 0, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 5, 0, 1, 0, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 6, 0, 1, 0, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 7, 0, 1, 0, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 8, 0, 1, 0, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 9, 0, 1, 0, 0, 16, 10, 11, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 0, 0, 0, 12, 8, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 15, 0, 8, 2 },
    { 26, 10, 0, 0, -1, 2, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -2, 1, 0, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 21, 10, 0, 0, -1, 2, 1, 0, 0, 0, 14, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 9, 2 },
    { 22, 10, 0, 0, -1, -2, 1, 0, 0, 0, 14, 2, 2 },
    { 28, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 19, 10, 0, 0, -1, 0, 1, 0, 0, 17, 0, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 26, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 17, 2 },
    { 22, 10, 0, 0, -1, -2, 1, 0, 0, 0, 14, 1, 2 },
    { 9, 7, 0, 0, -1, 0, 1, 0, 3, 3, 4, 38, 2 },
    { 6, 6, 0, 0, -1, 0, 1, 80, 0, 0, 6, 4, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 1, 0, 0, 0, 0, 10, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 18, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 3 },
    { 23, 10, 0, 0, -1, 16, 1, 0, 0, 0, 14, 3, 2 },
    { 10, 18, 0, 5, -1, 0, 1, 0, 3, 6, 5, 17, 2 },
    { 29, 4, 0, 0, -1, 0, 1, 0, 0, 0, 0, 10, 2 },
    { 26, 4, 0, 0, -1, 0, 1, 0, 0, 0, 0, 9, 2 },
    { 5, 2, 0, 0, 2, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 3, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 18, 2 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 14, 0, 12, 2 },
    { 5, 2, 0, 0, 1, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 24, 10, 0, 0, -1, -16, 1, 0, 0, 0, 14, 3, 2 },
    { 5, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 80, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 80, 0, 10, 8, 12, 3 },
    { 16, 0, 0, 0, -1, 0, 1, 80, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 4, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 4, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 4, 17, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 4, 17, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 4, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 4, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 6, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 7, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 8, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 8, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 8, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 8, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 8, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 8, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 8, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 9, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 9, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 9, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 9, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 9, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 4, 0, 0, 10, 7, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 3 },
    { 17, 10, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 1, 0, 0, 10, 0, 12, 2 },
    { 17, 10, 0, 0, -1, 0, 1, 0, 0, 10, 9, 18, 2 },
    { 28, 10, 0, 0, -1, 0, 4, 0, 0, 10, 0, 18, 2 },
    { 28, 10, 0, 0, -1, 0, 4, 0, 0, 10, 0, 12, 36 },
    { 17, 10, 0, 0, -1, 0, 4, 0, 0, 10, 9, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 4, 0, 0, 10, 0, 12, 2 },
    { 17, 0, 0, 0, -1, 0, 4, 0, 0, 10, 9, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 7, 0, 0, 10, 0, 12, 2 },
    { 0, 17, 230, 5, -1, 0, 1, 204, 4, 4, 3, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 232, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 216, 5, -1, 0, 1, 204, 4, 4, 3, 21, 1 },
    { 0, 17, 202, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 1, 204, 4, 4, 3, 21, 1 },
    { 0, 17, 202, 5, -1, 0, 1, 204, 4, 4, 3, 21, 1 },
    { 0, 17, 1, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 1, 5, -1, 0, 1, 204, 4, 4, 3, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 1, 85, 4, 4, 3, 21, 1 },
    { 0, 17, 240, 5, -1, 0, 1, 204, 4, 4, 3, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 4, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 4, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 0, 5, -1, 0, 6, 0, 4, 4, 3, 4, 1 },
    { 0, 17, 230, 5, -1, 0, 7, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 7, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 232, 5, -1, 0, 8, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 8, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 8, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 233, 5, -1, 0, 8, 0, 4, 4, 3, 4, 1 },
    { 0, 17, 234, 5, -1, 0, 7, 0, 4, 4, 3, 4, 1 },
    { 0, 17, 233, 5, -1, 0, 7, 0, 4, 4, 3, 4, 1 },
    { 0, 17, 234, 5, -1, 0, 1, 0, 4, 4, 3, 4, 1 },
    { 0, 17, 233, 5, -1, 0, 4, 0, 4, 4, 3, 4, 1 },
    { 0, 17, 230, 5, -1, 0, 6, 0, 4, 4, 3, 21, 1 },
    { 14, 0, 0, 0, -1, 0, 10, 0, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 10, 0, 0, 10, 7, 12, 4 },
    { 17, 10, 0, 0, -1, 0, 1, 85, 0, 10, 9, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 4 },
    { 13, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 12, 0 },
    { 17, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 9, 0, 0, 10, 7, 12, 4 },
    { 25, 10, 0, 0, -1, 0, 1, 85, 0, 15, 0, 8, 2 },
    { 14, 0, 0, 0, -1, 0, 16, 0, 0, 10, 8, 12, 4 },
    { 28, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 12, 4 },
    { 28, 10, 0, 0, -1, 0, 1, 81, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 25, 10, 0, 0, -1, 0, 1, 85, 0, 14, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 10, 0, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 80, 0, 10, 8, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 81, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 4, 0, 0, 10, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 6, 0, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 6, 0, 0, 10, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 4, 0, 0, 10, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 46 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 46 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 5, 80, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 5, 80, 0, 10, 7, 12, 4 },
    { 26, 10, 0, 0, -1, 0, 6, 0, 0, 0, 0, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 7, 0, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 7, 0, 0, 10, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 7, 80, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 8, 0, 0, 10, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 8, 0, 0, 10, 8, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 4, 17, 0, 10, 8, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 4, 17, 0, 10, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 5 },
    { 29, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 5 },
    { 0, 17, 230, 5, -1, 0, 1, 0, 4, 4, 3, 21, 5 },
    { 0, 17, 230, 5, -1, 0, 10, 0, 4, 4, 3, 21, 5 },
    { 2, 17, 0, 5, -1, 0, 4, 0, 4, 4, 3, 21, 5 },
    { 14, 0, 0, 0, -1, 0, 6, 0, 0, 10, 8, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 6, 0, 0, 10, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 4, 0, 0, 10, 8, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 4, 0, 0, 10, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 9, 0, 0, 10, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 4, 17, 0, 10, 8, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 4, 17, 0, 10, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 8, 0, 0, 10, 8, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 8, 0, 0, 10, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 9, 0, 0, 10, 8, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 9, 0, 0, 10, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 10, 0, 0, 10, 8, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 10, 0, 0, 10, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 11, 0, 0, 10, 8, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 11, 0, 0, 10, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 12, 0, 0, 10, 8, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 12, 0, 0, 10, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 16, 0, 0, 10, 8, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 16, 0, 0, 10, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 6 },
    { 17, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 6 },
    { 25, 0, 0, 0, -1, 0, 1, 0, 0, 10, 0, 12, 6 },
    { 25, 0, 0, 0, -1, 0, 1, 0, 0, 0, 12, 12, 6 },
    { 25, 0, 0, 0, -1, 0, 1, 0, 0, 14, 0, 12, 6 },
    { 15, 0, 0, 0, -1, 0, 20, 0, 0, 10, 7, 12, 6 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 7, 12, 6 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 6 },
    { 25, 0, 0, 0, -1, 0, 1, 0, 0, 15, 13, 8, 6 },
    { 20, 10, 0, 0, -1, 0, 4, 0, 0, 10, 0, 17, 6 },
    { 29, 10, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 6 },
    { 27, 4, 0, 0, -1, 0, 13, 0, 0, 0, 0, 9, 6 },
    { 13, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 12, 0 },
    { 0, 17, 220, 5, -1, 0, 2, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 230, 5, -1, 0, 2, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 222, 5, -1, 0, 2, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 220, 5, -1, 0, 8, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 228, 5, -1, 0, 2, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 10, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 11, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 12, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 13, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 14, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 15, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 16, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 17, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 18, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 19, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 19, 5, -1, 0, 9, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 20, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 21, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 22, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 20, 1, 0, 0, -1, 0, 1, 0, 0, 0, 0, 17, 7 },
    { 0, 17, 23, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 25, 1, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 7 },
    { 0, 17, 24, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 0, 17, 25, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 25, 1, 0, 0, -1, 0, 8, 0, 0, 0, 0, 6, 7 },
    { 0, 17, 18, 5, -1, 0, 8, 0, 4, 4, 3, 21, 7 },
    { 18, 1, 0, 0, -1, 0, 1, 0, 0, 9, 9, 13, 7 },
    { 18, 1, 0, 0, -1, 0, 20, 0, 0, 9, 9, 13, 7 },
    { 25, 1, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 7 },
    { 25, 1, 0, 0, -1, 0, 1, 0, 0, 14, 0, 12, 7 },
    { 10, 5, 0, 0, -1, 0, 7, 0, 7, 16, 10, 11, 8 },
    { 10, 5, 0, 0, -1, 0, 13, 0, 7, 16, 10, 11, 8 },
    { 10, 5, 0, 0, -1, 0, 16, 0, 7, 16, 10, 11, 2 },
    { 26, 10, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 8 },
    { 26, 13, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 8 },
    { 25, 4, 0, 0, -1, 0, 10, 0, 0, 0, 0, 10, 8 },
    { 27, 13, 0, 0, -1, 0, 8, 0, 0, 0, 0, 10, 8 },
    { 25, 13, 0, 0, -1, 0, 7, 0, 0, 15, 12, 8, 8 },
    { 29, 10, 0, 0, -1, 0, 7, 0, 0, 0, 0, 12, 8 },
    { 0, 17, 230, 5, -1, 0, 7, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 230, 5, -1, 0, 10, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 30, 5, -1, 0, 10, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 31, 5, -1, 0, 10, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 32, 5, -1, 0, 10, 0, 4, 4, 3, 21, 8 },
    { 25, 13, 0, 0, -1, 0, 1, 0, 0, 0, 0, 6, 2 },
    { 10, 13, 0, 5, -1, 0, 15, 0, 3, 6, 5, 21, 8 },
    { 25, 13, 0, 0, -1, 0, 24, 0, 0, 0, 13, 6, 8 },
    { 25, 13, 0, 0, -1, 0, 8, 0, 0, 0, 13, 6, 8 },
    { 25, 13, 0, 0, -1, 0, 1, 0, 0, 0, 13, 6, 2 },
    { 18, 13, 0, 2, -1, 0, 12, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 1, 17, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 1, 17, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 1, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 1, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 10, 0, 0, 10, 9, 12, 8 },
    { 17, 13, 0, 1, -1, 0, 1, 0, 0, 10, 9, 12, 2 },
    { 0, 17, 27, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 28, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 29, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 30, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 31, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 32, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 33, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 34, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 4, 204, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 4, 204, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 7, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 230, 5, -1, 0, 8, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 220, 5, -1, 0, 8, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 220, 5, -1, 0, 12, 0, 4, 4, 3, 21, 8 },
    { 3, 5, 0, 0, 0, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 5, 0, 0, 1, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 5, 0, 0, 2, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 5, 0, 0, 3, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 5, 0, 0, 4, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 5, 0, 0, 5, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 5, 0, 0, 6, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 5, 0, 0, 7, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 5, 0, 0, 8, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 5, 0, 0, 9, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 25, 4, 0, 0, -1, 0, 1, 0, 0, 0, 0, 10, 8 },
    { 25, 5, 0, 0, -1, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 25, 5, 0, 0, -1, 0, 1, 0, 0, 15, 10, 11, 8 },
    { 25, 13, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 6, 0, 0, 10, 9, 12, 8 },
    { 0, 17, 35, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 18, 13, 0, 3, -1, 0, 1, 80, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 1, 80, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 4, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 4, 0, 0, 10, 9, 12, 8 },
    { 25, 13, 0, 0, -1, 0, 1, 0, 0, 0, 13, 6, 8 },
    { 0, 17, 230, 5, -1, 0, 1, 0, 4, 4, 3, 21, 8 },
    { 10, 5, 0, 0, -1, 0, 1, 0, 7, 16, 10, 11, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 8 },
    { 0, 17, 220, 5, -1, 0, 1, 0, 4, 4, 3, 21, 8 },
    { 17, 13, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 7, 0, 0, 10, 9, 12, 8 },
    { 3, 2, 0, 0, 0, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 2, 0, 0, 1, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 2, 0, 0, 2, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 2, 0, 0, 3, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 2, 0, 0, 4, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 2, 0, 0, 5, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 2, 0, 0, 6, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 2, 0, 0, 7, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 2, 0, 0, 8, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 3, 2, 0, 0, 9, 0, 1, 0, 0, 16, 10, 11, 8 },
    { 29, 13, 0, 0, -1, 0, 4, 0, 0, 0, 0, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 7, 0, 0, 10, 9, 12, 8 },
    { 25, 13, 0, 0, -1, 0, 4, 0, 0, 0, 13, 12, 9 },
    { 25, 13, 0, 0, -1, 0, 4, 0, 0, 0, 0, 12, 9 },
    { 13, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 12, 0 },
    { 10, 13, 0, 5, -1, 0, 4, 0, 7, 10, 5, 12, 9 },
    { 18, 13, 0, 3, -1, 0, 4, 0, 0, 10, 9, 12, 9 },
    { 0, 17, 36, 5, -1, 0, 4, 0, 4, 4, 3, 21, 9 },
    { 18, 13, 0, 2, -1, 0, 4, 0, 0, 10, 9, 12, 9 },
    { 18, 13, 0, 2, -1, 0, 7, 0, 0, 10, 9, 12, 9 },
    { 18, 13, 0, 3, -1, 0, 7, 0, 0, 10, 9, 12, 9 },
    { 0, 17, 230, 5, -1, 0, 4, 0, 4, 4, 3, 21, 9 },
    { 0, 17, 220, 5, -1, 0, 4, 0, 4, 4, 3, 21, 9 },
    { 18, 13, 0, 2, -1, 0, 8, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 8, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 10, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 0, -1, 0, 4, 0, 0, 10, 9, 12, 10 },
    { 0, 17, 0, 5, -1, 0, 4, 0, 4, 4, 3, 21, 10 },
    { 18, 13, 0, 0, -1, 0, 6, 0, 0, 10, 9, 12, 10 },
    { 3, 1, 0, 0, 0, 0, 9, 0, 0, 16, 10, 11, 66 },
    { 3, 1, 0, 0, 1, 0, 9, 0, 0, 16, 10, 11, 66 },
    { 3, 1, 0, 0, 2, 0, 9, 0, 0, 16, 10, 11, 66 },
    { 3, 1, 0, 0, 3, 0, 9, 0, 0, 16, 10, 11, 66 },
    { 3, 1, 0, 0, 4, 0, 9, 0, 0, 16, 10, 11, 66 },
    { 3, 1, 0, 0, 5, 0, 9, 0, 0, 16, 10, 11, 66 },
    { 3, 1, 0, 0, 6, 0, 9, 0, 0, 16, 10, 11, 66 },
    { 3, 1, 0, 0, 7, 0, 9, 0, 0, 16, 10, 11, 66 },
    { 3, 1, 0, 0, 8, 0, 9, 0, 0, 16, 10, 11, 66 },
    { 3, 1, 0, 0, 9, 0, 9, 0, 0, 16, 10, 11, 66 },
    { 18, 1, 0, 2, -1, 0, 9, 0, 0, 10, 9, 12, 66 },
    { 0, 17, 230, 5, -1, 0, 9, 0, 4, 4, 3, 21, 66 },
    { 0, 17, 220, 5, -1, 0, 9, 0, 4, 4, 3, 21, 66 },
    { 17, 1, 0, 0, -1, 0, 9, 0, 0, 10, 9, 12, 66 },
    { 29, 10, 0, 0, -1, 0, 9, 0, 0, 0, 0, 12, 66 },
    { 25, 10, 0, 0, -1, 0, 9, 0, 0, 0, 0, 12, 66 },
    { 25, 10, 0, 0, -1, 0, 9, 0, 0, 15, 12, 8, 66 },
    { 25, 10, 0, 0, -1, 0, 9, 0, 0, 0, 13, 6, 66 },
    { 17, 1, 0, 1, -1, 0, 9, 0, 0, 10, 9, 12, 66 },
    { 0, 17, 220, 5, -1, 0, 20, 0, 4, 4, 3, 21, 66 },
    { 27, 1, 0, 0, -1, 0, 20, 0, 0, 0, 0, 9, 66 },
    { 18, 1, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 82 },
    { 0, 17, 230, 5, -1, 0, 11, 0, 4, 4, 3, 21, 82 },
    { 17, 1, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 82 },
    { 25, 1, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 82 },
    { 25, 1, 0, 0, -1, 0, 11, 0, 0, 0, 13, 12, 82 },
    { 18, 1, 0, 3, -1, 0, 12, 0, 0, 10, 9, 12, 95 },
    { 18, 1, 0, 2, -1, 0, 12, 0, 0, 10, 9, 12, 95 },
    { 0, 17, 220, 5, -1, 0, 12, 0, 4, 4, 3, 21, 95 },
    { 25, 1, 0, 0, -1, 0, 12, 0, 0, 0, 0, 12, 95 },
    { 18, 13, 0, 2, -1, 0, 19, 0, 0, 10, 9, 12, 9 },
    { 18, 13, 0, 0, -1, 0, 19, 0, 0, 10, 9, 12, 9 },
    { 18, 13, 0, 3, -1, 0, 19, 0, 0, 10, 9, 12, 9 },
    { 18, 13, 0, 3, -1, 0, 24, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 1, -1, 0, 24, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 24, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 0, -1, 0, 24, 0, 0, 10, 9, 12, 8 },
    { 28, 13, 0, 0, -1, 0, 24, 0, 0, 0, 0, 12, 8 },
    { 10, 5, 0, 0, -1, 0, 24, 0, 7, 16, 10, 11, 8 },
    { 0, 17, 230, 5, -1, 0, 24, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 220, 5, -1, 0, 24, 0, 4, 4, 3, 21, 8 },
    { 18, 13, 0, 2, -1, 0, 13, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 16, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 13, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 16, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 17, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 18, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 18, 0, 0, 10, 9, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 23, 0, 0, 10, 9, 12, 8 },
    { 17, 13, 0, 0, -1, 0, 24, 0, 0, 10, 9, 12, 8 },
    { 0, 17, 220, 5, -1, 0, 20, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 230, 5, -1, 0, 18, 0, 4, 4, 3, 21, 8 },
    { 10, 5, 0, 0, -1, 0, 18, 0, 7, 16, 10, 11, 2 },
    { 0, 17, 220, 5, -1, 0, 17, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 230, 5, -1, 0, 13, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 220, 5, -1, 0, 13, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 27, 5, -1, 0, 13, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 28, 5, -1, 0, 13, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 29, 5, -1, 0, 13, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 230, 5, -1, 0, 16, 0, 4, 4, 3, 21, 8 },
    { 0, 17, 0, 5, -1, 0, 11, 0, 4, 4, 3, 21, 11 },
    { 0, 17, 0, 5, -1, 0, 1, 0, 4, 4, 3, 21, 11 },
    { 1, 0, 0, 0, -1, 0, 1, 0, 8, 4, 3, 21, 11 },
    { 18, 0, 0, 0, -1, 0, 7, 0, 0, 10, 9, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 1, 17, 0, 10, 9, 12, 11 },
    { 0, 17, 0, 5, -1, 0, 12, 0, 4, 4, 3, 21, 11 },
    { 1, 0, 0, 0, -1, 0, 12, 0, 8, 4, 3, 21, 11 },
    { 0, 17, 7, 5, -1, 0, 1, 204, 4, 4, 3, 21, 11 },
    { 0, 17, 9, 5, -1, 0, 1, 0, 4, 4, 3, 21, 11 },
    { 1, 0, 0, 0, -1, 0, 11, 0, 8, 4, 3, 21, 11 },
    { 18, 0, 0, 0, -1, 0, 1, 85, 0, 10, 9, 12, 11 },
    { 25, 0, 0, 0, -1, 0, 1, 0, 0, 0, 13, 17, 2 },
    { 3, 0, 0, 0, 0, 0, 1, 0, 0, 16, 10, 11, 11 },
    { 3, 0, 0, 0, 1, 0, 1, 0, 0, 16, 10, 11, 11 },
    { 3, 0, 0, 0, 2, 0, 1, 0, 0, 16, 10, 11, 11 },
    { 3, 0, 0, 0, 3, 0, 1, 0, 0, 16, 10, 11, 11 },
    { 3, 0, 0, 0, 4, 0, 1, 0, 0, 16, 10, 11, 11 },
    { 3, 0, 0, 0, 5, 0, 1, 0, 0, 16, 10, 11, 11 },
    { 3, 0, 0, 0, 6, 0, 1, 0, 0, 16, 10, 11, 11 },
    { 3, 0, 0, 0, 7, 0, 1, 0, 0, 16, 10, 11, 11 },
    { 3, 0, 0, 0, 8, 0, 1, 0, 0, 16, 10, 11, 11 },
    { 3, 0, 0, 0, 9, 0, 1, 0, 0, 16, 10, 11, 11 },
    { 25, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 11 },
    { 17, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 12, 0, 0, 10, 9, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 9, 0, 0, 10, 9, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 8, 0, 0, 10, 9, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 12 },
    { 0, 17, 0, 5, -1, 0, 1, 0, 4, 4, 3, 21, 12 },
    { 1, 0, 0, 0, -1, 0, 1, 0, 8, 4, 3, 21, 12 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 12 },
    { 0, 17, 7, 5, -1, 0, 1, 0, 4, 4, 3, 21, 12 },
    { 18, 0, 0, 0, -1, 0, 7, 0, 0, 10, 9, 12, 12 },
    { 1, 0, 0, 0, -1, 0, 1, 204, 4, 4, 3, 21, 12 },
    { 1, 0, 0, 0, -1, 0, 1, 17, 8, 4, 3, 21, 12 },
    { 0, 17, 9, 5, -1, 0, 1, 0, 4, 4, 3, 21, 12 },
    { 18, 0, 0, 0, -1, 0, 8, 0, 0, 10, 9, 12, 12 },
    { 18, 0, 0, 0, -1, 0, 1, 85, 0, 10, 9, 12, 12 },
    { 3, 0, 0, 0, 0, 0, 1, 0, 0, 16, 10, 11, 12 },
    { 3, 0, 0, 0, 1, 0, 1, 0, 0, 16, 10, 11, 12 },
    { 3, 0, 0, 0, 2, 0, 1, 0, 0, 16, 10, 11, 12 },
    { 3, 0, 0, 0, 3, 0, 1, 0, 0, 16, 10, 11, 12 },
    { 3, 0, 0, 0, 4, 0, 1, 0, 0, 16, 10, 11, 12 },
    { 3, 0, 0, 0, 5, 0, 1, 0, 0, 16, 10, 11, 12 },
    { 3, 0, 0, 0, 6, 0, 1, 0, 0, 16, 10, 11, 12 },
    { 3, 0, 0, 0, 7, 0, 1, 0, 0, 16, 10, 11, 12 },
    { 3, 0, 0, 0, 8, 0, 1, 0, 0, 16, 10, 11, 12 },
    { 3, 0, 0, 0, 9, 0, 1, 0, 0, 16, 10, 11, 12 },
    { 27, 4, 0, 0, -1, 0, 1, 0, 0, 0, 0, 10, 12 },
    { 5, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 12 },
    { 5, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 10, 12 },
    { 29, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 12 },
    { 27, 4, 0, 0, -1, 0, 11, 0, 0, 0, 0, 9, 12 },
    { 18, 0, 0, 0, -1, 0, 19, 0, 0, 10, 9, 12, 12 },
    { 25, 0, 0, 0, -1, 0, 19, 0, 0, 0, 0, 12, 12 },
    { 0, 17, 230, 5, -1, 0, 20, 0, 4, 4, 3, 21, 12 },
    { 0, 17, 0, 5, -1, 0, 7, 0, 4, 4, 3, 21, 13 },
    { 0, 17, 0, 5, -1, 0, 1, 0, 4, 4, 3, 21, 13 },
    { 1, 0, 0, 0, -1, 0, 7, 0, 8, 4, 3, 21, 13 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 13 },
    { 18, 0, 0, 0, -1, 0, 1, 85, 0, 10, 9, 12, 13 },
    { 0, 17, 7, 5, -1, 0, 1, 0, 4, 4, 3, 21, 13 },
    { 1, 0, 0, 0, -1, 0, 1, 0, 8, 4, 3, 21, 13 },
    { 0, 17, 9, 5, -1, 0, 1, 0, 4, 4, 3, 21, 13 },
    { 0, 17, 0, 5, -1, 0, 10, 0, 4, 4, 3, 21, 13 },
    { 3, 0, 0, 0, 0, 0, 1, 0, 0, 16, 10, 11, 13 },
    { 3, 0, 0, 0, 1, 0, 1, 0, 0, 16, 10, 11, 13 },
    { 3, 0, 0, 0, 2, 0, 1, 0, 0, 16, 10, 11, 13 },
    { 3, 0, 0, 0, 3, 0, 1, 0, 0, 16, 10, 11, 13 },
    { 3, 0, 0, 0, 4, 0, 1, 0, 0, 16, 10, 11, 13 },
    { 3, 0, 0, 0, 5, 0, 1, 0, 0, 16, 10, 11, 13 },
    { 3, 0, 0, 0, 6, 0, 1, 0, 0, 16, 10, 11, 13 },
    { 3, 0, 0, 0, 7, 0, 1, 0, 0, 16, 10, 11, 13 },
    { 3, 0, 0, 0, 8, 0, 1, 0, 0, 16, 10, 11, 13 },
    { 3, 0, 0, 0, 9, 0, 1, 0, 0, 16, 10, 11, 13 },
    { 25, 0, 0, 0, -1, 0, 20, 0, 0, 0, 0, 12, 13 },
    { 0, 17, 0, 5, -1, 0, 1, 0, 4, 4, 3, 21, 14 },
    { 1, 0, 0, 0, -1, 0, 1, 0, 8, 4, 3, 21, 14 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 14 },
    { 18, 0, 0, 0, -1, 0, 7, 0, 0, 10, 9, 12, 14 },
    { 0, 17, 7, 5, -1, 0, 1, 0, 4, 4, 3, 21, 14 },
    { 0, 17, 9, 5, -1, 0, 1, 0, 4, 4, 3, 21, 14 },
    { 0, 17, 0, 5, -1, 0, 7, 0, 4, 4, 3, 21, 14 },
    { 3, 0, 0, 0, 0, 0, 1, 0, 0, 16, 10, 11, 14 },
    { 3, 0, 0, 0, 1, 0, 1, 0, 0, 16, 10, 11, 14 },
    { 3, 0, 0, 0, 2, 0, 1, 0, 0, 16, 10, 11, 14 },
    { 3, 0, 0, 0, 3, 0, 1, 0, 0, 16, 10, 11, 14 },
    { 3, 0, 0, 0, 4, 0, 1, 0, 0, 16, 10, 11, 14 },
    { 3, 0, 0, 0, 5, 0, 1, 0, 0, 16, 10, 11, 14 },
    { 3, 0, 0, 0, 6, 0, 1, 0, 0, 16, 10, 11, 14 },
    { 3, 0, 0, 0, 7, 0, 1, 0, 0, 16, 10, 11, 14 },
    { 3, 0, 0, 0, 8, 0, 1, 0, 0, 16, 10, 11, 14 },
    { 3, 0, 0, 0, 9, 0, 1, 0, 0, 16, 10, 11, 14 },
    { 25, 0, 0, 0, -1, 0, 13, 0, 0, 0, 0, 12, 14 },
    { 27, 4, 0, 0, -1, 0, 7, 0, 0, 0, 0, 9, 14 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 10, 9, 12, 14 },
    { 0, 17, 0, 5, -1, 0, 19, 0, 4, 4, 3, 21, 14 },
    { 0, 17, 0, 5, -1, 0, 1, 0, 4, 4, 3, 21, 15 },
    { 1, 0, 0, 0, -1, 0, 1, 0, 8, 4, 3, 21, 15 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 15 },
    { 18, 0, 0, 0, -1, 0, 7, 0, 0, 10, 9, 12, 15 },
    { 0, 17, 7, 5, -1, 0, 1, 0, 4, 4, 3, 21, 15 },
    { 1, 0, 0, 0, -1, 0, 1, 204, 4, 4, 3, 21, 15 },
    { 0, 17, 0, 5, -1, 0, 10, 0, 4, 4, 3, 21, 15 },
    { 1, 0, 0, 0, -1, 0, 1, 17, 8, 4, 3, 21, 15 },
    { 0, 17, 9, 5, -1, 0, 1, 0, 4, 4, 3, 21, 15 },
    { 0, 17, 0, 5, -1, 0, 23, 0, 4, 4, 3, 21, 15 },
    { 0, 17, 0, 5, -1, 0, 1, 204, 4, 4, 3, 21, 15 },
    { 18, 0, 0, 0, -1, 0, 1, 85, 0, 10, 9, 12, 15 },
    { 3, 0, 0, 0, 0, 0, 1, 0, 0, 16, 10, 11, 15 },
    { 3, 0, 0, 0, 1, 0, 1, 0, 0, 16, 10, 11, 15 },
    { 3, 0, 0, 0, 2, 0, 1, 0, 0, 16, 10, 11, 15 },
    { 3, 0, 0, 0, 3, 0, 1, 0, 0, 16, 10, 11, 15 },
    { 3, 0, 0, 0, 4, 0, 1, 0, 0, 16, 10, 11, 15 },
    { 3, 0, 0, 0, 5, 0, 1, 0, 0, 16, 10, 11, 15 },
    { 3, 0, 0, 0, 6, 0, 1, 0, 0, 16, 10, 11, 15 },
    { 3, 0, 0, 0, 7, 0, 1, 0, 0, 16, 10, 11, 15 },
    { 3, 0, 0, 0, 8, 0, 1, 0, 0, 16, 10, 11, 15 },
    { 3, 0, 0, 0, 9, 0, 1, 0, 0, 16, 10, 11, 15 },
    { 29, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 15 },
    { 5, 0, 0, 0, -1, 0, 12, 0, 0, 0, 0, 12, 15 },
    { 0, 17, 0, 5, -1, 0, 1, 0, 4, 4, 3, 21, 16 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 16 },
    { 18, 0, 0, 0, -1, 0, 1, 17, 0, 10, 9, 12, 16 },
    { 18, 0, 0, 0, -1, 0, 8, 0, 0, 10, 9, 12, 16 },
    { 1, 0, 0, 0, -1, 0, 1, 204, 4, 4, 3, 21, 16 },
    { 1, 0, 0, 0, -1, 0, 1, 0, 8, 4, 3, 21, 16 },
    { 1, 0, 0, 0, -1, 0, 1, 17, 8, 4, 3, 21, 16 },
    { 0, 17, 9, 5, -1, 0, 1, 0, 4, 4, 3, 21, 16 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 16 },
    { 3, 0, 0, 0, 0, 0, 8, 0, 0, 16, 10, 11, 16 },
    { 3, 0, 0, 0, 1, 0, 1, 0, 0, 16, 10, 11, 16 },
    { 3, 0, 0, 0, 2, 0, 1, 0, 0, 16, 10, 11, 16 },
    { 3, 0, 0, 0, 3, 0, 1, 0, 0, 16, 10, 11, 16 },
    { 3, 0, 0, 0, 4, 0, 1, 0, 0, 16, 10, 11, 16 },
    { 3, 0, 0, 0, 5, 0, 1, 0, 0, 16, 10, 11, 16 },
    { 3, 0, 0, 0, 6, 0, 1, 0, 0, 16, 10, 11, 16 },
    { 3, 0, 0, 0, 7, 0, 1, 0, 0, 16, 10, 11, 16 },
    { 3, 0, 0, 0, 8, 0, 1, 0, 0, 16, 10, 11, 16 },
    { 3, 0, 0, 0, 9, 0, 1, 0, 0, 16, 10, 11, 16 },
    { 5, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 16 },
    { 29, 10, 0, 0, -1, 0, 7, 0, 0, 0, 0, 12, 16 },
    { 27, 4, 0, 0, -1, 0, 7, 0, 0, 0, 0, 9, 16 },
    { 0, 17, 0, 5, -1, 0, 16, 0, 4, 4, 3, 21, 17 },
    { 1, 0, 0, 0, -1, 0, 1, 0, 8, 4, 3, 21, 17 },
    { 0, 17, 0, 5, -1, 0, 20, 0, 4, 4, 3, 21, 17 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 17 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 17 },
    { 0, 17, 7, 5, -1, 0, 24, 0, 4, 4, 3, 21, 17 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 17 },
    { 0, 17, 0, 5, -1, 0, 1, 0, 4, 4, 3, 21, 17 },
    { 0, 17, 0, 5, -1, 0, 1, 17, 4, 4, 3, 21, 17 },
    { 0, 17, 9, 5, -1, 0, 1, 0, 4, 4, 3, 21, 17 },
    { 0, 17, 84, 5, -1, 0, 1, 0, 4, 4, 3, 21, 17 },
    { 0, 17, 91, 5, -1, 0, 1, 204, 4, 4, 3, 21, 17 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 10, 9, 12, 17 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 10, 9, 12, 17 },
    { 0, 17, 0, 5, -1, 0, 10, 0, 4, 4, 3, 21, 17 },
    { 3, 0, 0, 0, 0, 0, 1, 0, 0, 16, 10, 11, 17 },
    { 3, 0, 0, 0, 1, 0, 1, 0, 0, 16, 10, 11, 17 },
    { 3, 0, 0, 0, 2, 0, 1, 0, 0, 16, 10, 11, 17 },
    { 3, 0, 0, 0, 3, 0, 1, 0, 0, 16, 10, 11, 17 },
    { 3, 0, 0, 0, 4, 0, 1, 0, 0, 16, 10, 11, 17 },
    { 3, 0, 0, 0, 5, 0, 1, 0, 0, 16, 10, 11, 17 },
    { 3, 0, 0, 0, 6, 0, 1, 0, 0, 16, 10, 11, 17 },
    { 3, 0, 0, 0, 7, 0, 1, 0, 0, 16, 10, 11, 17 },
    { 3, 0, 0, 0, 8, 0, 1, 0, 0, 16, 10, 11, 17 },
    { 3, 0, 0, 0, 9, 0, 1, 0, 0, 16, 10, 11, 17 },
    { 25, 0, 0, 0, -1, 0, 21, 0, 0, 0, 0, 18, 17 },
    { 5, 10, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 17 },
    { 29, 0, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 17 },
    { 18, 0, 0, 0, -1, 0, 18, 0, 0, 10, 9, 12, 18 },
    { 0, 17, 0, 5, -1, 0, 16, 0, 4, 4, 3, 21, 18 },
    { 1, 0, 0, 0, -1, 0, 1, 0, 8, 4, 3, 21, 18 },
    { 25, 0, 0, 0, -1, 0, 20, 0, 0, 0, 0, 18, 18 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 18 },
    { 0, 17, 7, 5, -1, 0, 7, 0, 4, 4, 3, 21, 18 },
    { 18, 0, 0, 0, -1, 0, 7, 0, 0, 10, 9, 12, 18 },
    { 0, 0, 0, 5, -1, 0, 1, 0, 4, 4, 3, 21, 18 },
    { 1, 0, 0, 0, -1, 0, 1, 17, 8, 4, 3, 21, 18 },
    { 1, 0, 0, 0, -1, 0, 1, 204, 4, 4, 3, 21, 18 },
    { 0, 17, 0, 5, -1, 0, 1, 0, 4, 4, 3, 21, 18 },
    { 0, 17, 9, 5, -1, 0, 1, 0, 4, 4, 3, 21, 18 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 10, 9, 12, 18 },
    { 0, 17, 0, 5, -1, 0, 9, 0, 4, 4, 3, 21, 18 },
    { 3, 0, 0, 0, 0, 0, 1, 0, 0, 16, 10, 11, 18 },
    { 3, 0, 0, 0, 1, 0, 1, 0, 0, 16, 10, 11, 18 },
    { 3, 0, 0, 0, 2, 0, 1, 0, 0, 16, 10, 11, 18 },
    { 3, 0, 0, 0, 3, 0, 1, 0, 0, 16, 10, 11, 18 },
    { 3, 0, 0, 0, 4, 0, 1, 0, 0, 16, 10, 11, 18 },
    { 3, 0, 0, 0, 5, 0, 1, 0, 0, 16, 10, 11, 18 },
    { 3, 0, 0, 0, 6, 0, 1, 0, 0, 16, 10, 11, 18 },
    { 3, 0, 0, 0, 7, 0, 1, 0, 0, 16, 10, 11, 18 },
    { 3, 0, 0, 0, 8, 0, 1, 0, 0, 16, 10, 11, 18 },
    { 3, 0, 0, 0, 9, 0, 1, 0, 0, 16, 10, 11, 18 },
    { 18, 0, 0, 0, -1, 0, 9, 0, 0, 10, 9, 12, 18 },
    { 1, 0, 0, 0, -1, 0, 25, 0, 8, 4, 3, 21, 18 },
    { 0, 17, 0, 5, -1, 0, 19, 0, 4, 4, 3, 21, 19 },
    { 0, 17, 0, 5, -1, 0, 16, 0, 4, 4, 3, 21, 19 },
    { 1, 0, 0, 0, -1, 0, 1, 0, 8, 4, 3, 21, 19 },
    { 18, 0, 0, 0, -1, 0, 23, 0, 0, 10, 9, 12, 19 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 19 },
    { 18, 0, 0, 0, -1, 0, 12, 0, 0, 10, 9, 12, 19 },
    { 0, 17, 9, 5, -1, 0, 19, 0, 4, 4, 3, 21, 19 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 19 },
    { 1, 0, 0, 0, -1, 0, 1, 204, 4, 4, 3, 21, 19 },
    { 0, 17, 0, 5, -1, 0, 1, 0, 4, 4, 3, 21, 19 },
    { 0, 17, 0, 5, -1, 0, 10, 0, 4, 4, 3, 21, 19 },
    { 1, 0, 0, 0, -1, 0, 1, 17, 8, 4, 3, 21, 19 },
    { 0, 17, 9, 5, -1, 0, 1, 0, 4, 4, 3, 21, 19 },
    { 18, 0, 0, 0, -1, 0, 12, 0, 7, 10, 9, 12, 19 },
    { 29, 0, 0, 0, -1, 0, 18, 0, 0, 0, 0, 12, 19 },
    { 18, 0, 0, 0, -1, 0, 18, 0, 0, 10, 9, 12, 19 },
    { 5, 0, 0, 0, -1, 0, 18, 0, 0, 0, 0, 12, 19 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 10, 9, 12, 19 },
    { 3, 0, 0, 0, 0, 0, 1, 0, 0, 16, 10, 11, 19 },
    { 3, 0, 0, 0, 1, 0, 1, 0, 0, 16, 10, 11, 19 },
    { 3, 0, 0, 0, 2, 0, 1, 0, 0, 16, 10, 11, 19 },
    { 3, 0, 0, 0, 3, 0, 1, 0, 0, 16, 10, 11, 19 },
    { 3, 0, 0, 0, 4, 0, 1, 0, 0, 16, 10, 11, 19 },
    { 3, 0, 0, 0, 5, 0, 1, 0, 0, 16, 10, 11, 19 },
    { 3, 0, 0, 0, 6, 0, 1, 0, 0, 16, 10, 11, 19 },
    { 3, 0, 0, 0, 7, 0, 1, 0, 0, 16, 10, 11, 19 },
    { 3, 0, 0, 0, 8, 0, 1, 0, 0, 16, 10, 11, 19 },
    { 3, 0, 0, 0, 9, 0, 1, 0, 0, 16, 10, 11, 19 },
    { 5, 0, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 19 },
    { 29, 0, 0, 0, -1, 0, 10, 0, 0, 0, 0, 10, 19 },
    { 0, 17, 0, 5, -1, 0, 23, 0, 4, 4, 3, 21, 20 },
    { 1, 0, 0, 0, -1, 0, 4, 0, 8, 4, 3, 21, 20 },
    { 18, 0, 0, 0, -1, 0, 4, 0, 0, 10, 9, 12, 20 },
    { 0, 17, 9, 5, -1, 0, 4, 204, 4, 4, 3, 21, 20 },
    { 1, 0, 0, 0, -1, 0, 4, 204, 4, 4, 3, 21, 20 },
    { 0, 17, 0, 5, -1, 0, 4, 0, 4, 4, 3, 21, 20 },
    { 1, 0, 0, 0, -1, 0, 4, 17, 8, 4, 3, 21, 20 },
    { 3, 0, 0, 0, 0, 0, 16, 0, 0, 16, 10, 11, 20 },
    { 3, 0, 0, 0, 1, 0, 16, 0, 0, 16, 10, 11, 20 },
    { 3, 0, 0, 0, 2, 0, 16, 0, 0, 16, 10, 11, 20 },
    { 3, 0, 0, 0, 3, 0, 16, 0, 0, 16, 10, 11, 20 },
    { 3, 0, 0, 0, 4, 0, 16, 0, 0, 16, 10, 11, 20 },
    { 3, 0, 0, 0, 5, 0, 16, 0, 0, 16, 10, 11, 20 },
    { 3, 0, 0, 0, 6, 0, 16, 0, 0, 16, 10, 11, 20 },
    { 3, 0, 0, 0, 7, 0, 16, 0, 0, 16, 10, 11, 20 },
    { 3, 0, 0, 0, 8, 0, 16, 0, 0, 16, 10, 11, 20 },
    { 3, 0, 0, 0, 9, 0, 16, 0, 0, 16, 10, 11, 20 },
    { 25, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 12, 20 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 0, 9, 33, 21 },
    { 0, 17, 0, 5, -1, 0, 1, 0, 4, 4, 3, 33, 21 },
    { 18, 0, 0, 0, -1, 0, 1, 80, 8, 0, 9, 33, 21 },
    { 0, 17, 103, 5, -1, 0, 1, 0, 4, 4, 3, 33, 21 },
    { 0, 17, 9, 5, -1, 0, 1, 0, 4, 4, 3, 33, 21 },
    { 17, 0, 0, 0, -1, 0, 1, 0, 0, 0, 9, 33, 21 },
    { 0, 17, 107, 5, -1, 0, 1, 0, 4, 4, 3, 33, 21 },
    { 25, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 21 },
    { 3, 0, 0, 0, 0, 0, 1, 0, 0, 16, 10, 11, 21 },
    { 3, 0, 0, 0, 1, 0, 1, 0, 0, 16, 10, 11, 21 },
    { 3, 0, 0, 0, 2, 0, 1, 0, 0, 16, 10, 11, 21 },
    { 3, 0, 0, 0, 3, 0, 1, 0, 0, 16, 10, 11, 21 },
    { 3, 0, 0, 0, 4, 0, 1, 0, 0, 16, 10, 11, 21 },
    { 3, 0, 0, 0, 5, 0, 1, 0, 0, 16, 10, 11, 21 },
    { 3, 0, 0, 0, 6, 0, 1, 0, 0, 16, 10, 11, 21 },
    { 3, 0, 0, 0, 7, 0, 1, 0, 0, 16, 10, 11, 21 },
    { 3, 0, 0, 0, 8, 0, 1, 0, 0, 16, 10, 11, 21 },
    { 3, 0, 0, 0, 9, 0, 1, 0, 0, 16, 10, 11, 21 },
    { 25, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 17, 21 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 0, 9, 33, 22 },
    { 18, 0, 0, 0, -1, 0, 21, 0, 0, 0, 9, 33, 22 },
    { 0, 17, 0, 5, -1, 0, 1, 0, 4, 4, 3, 33, 22 },
    { 18, 0, 0, 0, -1, 0, 1, 80, 8, 0, 9, 33, 22 },
    { 0, 17, 118, 5, -1, 0, 1, 0, 4, 4, 3, 33, 22 },
    { 0, 17, 9, 5, -1, 0, 21, 0, 4, 4, 3, 33, 22 },
    { 17, 0, 0, 0, -1, 0, 1, 0, 0, 0, 9, 33, 22 },
    { 0, 17, 122, 5, -1, 0, 1, 0, 4, 4, 3, 33, 22 },
    { 0, 17, 0, 5, -1, 0, 25, 0, 4, 4, 3, 33, 22 },
    { 3, 0, 0, 0, 0, 0, 1, 0, 0, 16, 10, 11, 22 },
    { 3, 0, 0, 0, 1, 0, 1, 0, 0, 16, 10, 11, 22 },
    { 3, 0, 0, 0, 2, 0, 1, 0, 0, 16, 10, 11, 22 },
    { 3, 0, 0, 0, 3, 0, 1, 0, 0, 16, 10, 11, 22 },
    { 3, 0, 0, 0, 4, 0, 1, 0, 0, 16, 10, 11, 22 },
    { 3, 0, 0, 0, 5, 0, 1, 0, 0, 16, 10, 11, 22 },
    { 3, 0, 0, 0, 6, 0, 1, 0, 0, 16, 10, 11, 22 },
    { 3, 0, 0, 0, 7, 0, 1, 0, 0, 16, 10, 11, 22 },
    { 3, 0, 0, 0, 8, 0, 1, 0, 0, 16, 10, 11, 22 },
    { 3, 0, 0, 0, 9, 0, 1, 0, 0, 16, 10, 11, 22 },
    { 18, 0, 0, 0, -1, 0, 1, 80, 0, 0, 9, 33, 22 },
    { 18, 0, 0, 0, -1, 0, 13, 0, 0, 0, 9, 33, 22 },
    { 18, 0, 0, 0, -1, 0, 2, 0, 0, 10, 9, 12, 23 },
    { 29, 0, 0, 0, -1, 0, 2, 0, 0, 0, 0, 18, 23 },
    { 25, 0, 0, 0, -1, 0, 2, 0, 0, 0, 0, 18, 23 },
    { 25, 0, 0, 0, -1, 0, 2, 0, 0, 0, 0, 12, 23 },
    { 25, 0, 0, 0, -1, 0, 2, 0, 0, 0, 0, 4, 23 },
    { 25, 0, 0, 0, -1, 0, 2, 0, 0, 0, 0, 17, 23 },
    { 25, 0, 0, 0, -1, 0, 2, 80, 0, 0, 0, 4, 23 },
    { 25, 0, 0, 0, -1, 0, 2, 0, 0, 0, 0, 6, 23 },
    { 29, 0, 0, 0, -1, 0, 2, 0, 0, 0, 0, 12, 23 },
    { 0, 17, 220, 5, -1, 0, 2, 0, 4, 4, 3, 21, 23 },
    { 3, 0, 0, 0, 0, 0, 2, 0, 0, 16, 10, 11, 23 },
    { 3, 0, 0, 0, 1, 0, 2, 0, 0, 16, 10, 11, 23 },
    { 3, 0, 0, 0, 2, 0, 2, 0, 0, 16, 10, 11, 23 },
    { 3, 0, 0, 0, 3, 0, 2, 0, 0, 16, 10, 11, 23 },
    { 3, 0, 0, 0, 4, 0, 2, 0, 0, 16, 10, 11, 23 },
    { 3, 0, 0, 0, 5, 0, 2, 0, 0, 16, 10, 11, 23 },
    { 3, 0, 0, 0, 6, 0, 2, 0, 0, 16, 10, 11, 23 },
    { 3, 0, 0, 0, 7, 0, 2, 0, 0, 16, 10, 11, 23 },
    { 3, 0, 0, 0, 8, 0, 2, 0, 0, 16, 10, 11, 23 },
    { 3, 0, 0, 0, 9, 0, 2, 0, 0, 16, 10, 11, 23 },
    { 5, 0, 0, 0, -1, 0, 2, 0, 0, 0, 0, 12, 23 },
    { 29, 0, 0, 0, -1, 0, 2, 0, 0, 0, 0, 17, 23 },
    { 0, 17, 216, 5, -1, 0, 2, 0, 4, 4, 3, 21, 23 },
    { 21, 10, 0, 0, -1, 1, 2, 0, 0, 0, 14, 0, 23 },
    { 22, 10, 0, 0, -1, -1, 2, 0, 0, 0, 14, 1, 23 },
    { 1, 0, 0, 0, -1, 0, 2, 0, 8, 4, 3, 21, 23 },
    { 18, 0, 0, 0, -1, 0, 2, 85, 0, 10, 9, 12, 23 },
    { 18, 0, 0, 0, -1, 0, 4, 0, 0, 10, 9, 12, 23 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 23 },
    { 0, 17, 129, 5, -1, 0, 2, 0, 4, 4, 3, 21, 23 },
    { 0, 17, 130, 5, -1, 0, 2, 0, 4, 4, 3, 21, 23 },
    { 0, 17, 0, 5, -1, 0, 2, 85, 4, 4, 3, 21, 23 },
    { 0, 17, 132, 5, -1, 0, 2, 0, 4, 4, 3, 21, 23 },
    { 0, 17, 0, 5, -1, 0, 2, 80, 4, 4, 3, 21, 23 },
    { 0, 17, 0, 5, -1, 0, 2, 0, 4, 4, 3, 21, 23 },
    { 1, 0, 0, 0, -1, 0, 2, 0, 8, 4, 3, 17, 23 },
    { 0, 17, 230, 5, -1, 0, 2, 0, 4, 4, 3, 21, 23 },
    { 0, 17, 9, 5, -1, 0, 2, 0, 4, 4, 3, 21, 23 },
    { 18, 0, 0, 0, -1, 0, 12, 0, 0, 10, 9, 12, 23 },
    { 0, 17, 0, 5, -1, 0, 12, 0, 4, 4, 3, 21, 23 },
    { 0, 17, 0, 5, -1, 0, 4, 0, 4, 4, 3, 21, 23 },
    { 29, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 17, 23 },
    { 29, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 12, 23 },
    { 0, 17, 220, 5, -1, 0, 4, 0, 4, 4, 3, 21, 23 },
    { 29, 0, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 23 },
    { 25, 0, 0, 0, -1, 0, 8, 0, 0, 0, 0, 18, 23 },
    { 25, 0, 0, 0, -1, 0, 10, 0, 0, 0, 0, 17, 23 },
    { 25, 0, 0, 0, -1, 0, 10, 0, 0, 0, 0, 18, 23 },
    { 25, 0, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 23 },
    { 29, 0, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 2 },
    { 25, 0, 0, 0, -1, 0, 12, 0, 0, 0, 0, 4, 23 },
    { 18, 0, 0, 0, -1, 0, 4, 0, 0, 0, 9, 33, 24 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 0, 9, 33, 24 },
    { 18, 0, 0, 0, -1, 0, 4, 17, 0, 0, 9, 33, 24 },
    { 1, 0, 0, 0, -1, 0, 10, 0, 0, 4, 3, 33, 24 },
    { 1, 0, 0, 0, -1, 0, 4, 0, 0, 4, 3, 33, 24 },
    { 0, 17, 0, 5, -1, 0, 4, 0, 4, 4, 3, 33, 24 },
    { 0, 17, 0, 5, -1, 0, 4, 204, 4, 4, 3, 33, 24 },
    { 1, 0, 0, 0, -1, 0, 4, 0, 8, 4, 3, 33, 24 },
    { 0, 17, 0, 5, -1, 0, 10, 0, 4, 4, 3, 33, 24 },
    { 0, 17, 7, 5, -1, 0, 4, 0, 4, 4, 3, 33, 24 },
    { 0, 17, 9, 5, -1, 0, 4, 0, 4, 4, 3, 33, 24 },
    { 0, 17, 9, 5, -1, 0, 10, 0, 4, 4, 3, 33, 24 },
    { 1, 0, 0, 0, -1, 0, 10, 0, 8, 4, 3, 33, 24 },
    { 3, 0, 0, 0, 0, 0, 4, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 1, 0, 4, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 2, 0, 4, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 3, 0, 4, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 4, 0, 4, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 5, 0, 4, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 6, 0, 4, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 7, 0, 4, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 8, 0, 4, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 9, 0, 4, 0, 0, 16, 10, 11, 24 },
    { 25, 0, 0, 0, -1, 0, 4, 0, 0, 0, 13, 17, 24 },
    { 25, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 12, 24 },
    { 0, 17, 220, 5, -1, 0, 10, 0, 4, 4, 3, 33, 24 },
    { 3, 0, 0, 0, 0, 0, 10, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 1, 0, 10, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 2, 0, 10, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 3, 0, 10, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 4, 0, 10, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 5, 0, 10, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 6, 0, 10, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 7, 0, 10, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 8, 0, 10, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 9, 0, 10, 0, 0, 16, 10, 11, 24 },
    { 1, 0, 0, 0, -1, 0, 11, 0, 0, 4, 3, 33, 24 },
    { 0, 17, 0, 5, -1, 0, 11, 0, 4, 4, 3, 33, 24 },
    { 29, 0, 0, 0, -1, 0, 10, 0, 0, 0, 0, 33, 24 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 25 },
    { 14, 0, 0, 0, -1, 0, 13, 0, 0, 10, 8, 12, 25 },
    { 15, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 25 },
    { 15, 0, 0, 0, -1, 0, 6, 0, 0, 10, 9, 12, 25 },
    { 15, 0, 0, 0, -1, 0, 8, 0, 0, 10, 9, 12, 25 },
    { 25, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 17, 0, 0, 0, -1, 0, 8, 80, 0, 10, 7, 12, 25 },
    { 15, 0, 0, 0, -1, 0, 13, 0, 0, 10, 9, 12, 25 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 9, 10, 9, 25, 26 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 9, 10, 9, 25, 26 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 10, 10, 9, 26, 26 },
    { 18, 0, 0, 0, -1, 0, 1, 204, 10, 10, 9, 26, 26 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 10, 10, 9, 26, 26 },
    { 18, 0, 0, 0, -1, 0, 1, 204, 11, 10, 9, 27, 26 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 11, 10, 9, 27, 26 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 11, 10, 9, 27, 26 },
    { 18, 0, 0, 0, -1, 0, 4, 0, 0, 10, 9, 12, 27 },
    { 18, 0, 0, 0, -1, 0, 8, 0, 0, 10, 9, 12, 27 },
    { 0, 17, 230, 5, -1, 0, 12, 0, 4, 4, 3, 21, 27 },
    { 0, 17, 230, 5, -1, 0, 8, 0, 4, 4, 3, 21, 27 },
    { 25, 0, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 27 },
    { 25, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 17, 27 },
    { 25, 0, 0, 0, -1, 0, 4, 0, 0, 0, 13, 12, 27 },
    { 25, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 1, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 2, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 3, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 4, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 5, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 6, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 7, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 8, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 9, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 29, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 27 },
    { 14, 0, 0, 0, -1, 0, 4, 0, 0, 10, 8, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0, 0, 10, 8, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 17, 0, 0, 10, 8, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0, 0, 10, 7, 12, 28 },
    { 20, 10, 0, 0, -1, 0, 11, 0, 0, 0, 0, 17, 29 },
    { 18, 0, 0, 0, -1, 0, 4, 0, 0, 10, 9, 12, 29 },
    { 29, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 12, 29 },
    { 25, 0, 0, 0, -1, 0, 4, 0, 0, 0, 13, 12, 29 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 29 },
    { 6, 9, 0, 0, -1, 0, 4, 0, 0, 22, 6, 17, 30 },
    { 18, 0, 0, 0, -1, 0, 4, 0, 0, 10, 9, 12, 30 },
    { 21, 10, 0, 0, -1, 1, 4, 0, 0, 0, 14, 0, 30 },
    { 22, 10, 0, 0, -1, -1, 4, 0, 0, 0, 14, 1, 30 },
    { 18, 0, 0, 0, -1, 0, 4, 0, 0, 10, 9, 12, 31 },
    { 25, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 17, 2 },
    { 4, 0, 0, 0, -1, 0, 4, 0, 0, 10, 9, 12, 31 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 31 },
    { 18, 0, 0, 0, -1, 0, 6, 0, 0, 10, 9, 12, 42 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 10, 9, 12, 42 },
    { 0, 17, 0, 5, -1, 0, 6, 0, 4, 4, 3, 21, 42 },
    { 0, 17, 9, 5, -1, 0, 6, 0, 4, 4, 3, 21, 42 },
    { 1, 0, 9, 0, -1, 0, 24, 0, 8, 4, 3, 21, 42 },
    { 18, 0, 0, 0, -1, 0, 6, 0, 0, 10, 9, 12, 43 },
    { 0, 17, 0, 5, -1, 0, 6, 0, 4, 4, 3, 21, 43 },
    { 1, 0, 9, 0, -1, 0, 6, 0, 8, 4, 3, 21, 43 },
    { 25, 0, 0, 0, -1, 0, 6, 0, 0, 0, 13, 17, 2 },
    { 18, 0, 0, 0, -1, 0, 6, 0, 0, 10, 9, 12, 44 },
    { 0, 17, 0, 5, -1, 0, 6, 0, 4, 4, 3, 21, 44 },
    { 18, 0, 0, 0, -1, 0, 6, 0, 0, 10, 9, 12, 45 },
    { 0, 17, 0, 5, -1, 0, 6, 0, 4, 4, 3, 21, 45 },
    { 18, 0, 0, 0, -1, 0, 4, 0, 0, 0, 9, 33, 32 },
    { 0, 17, 0, 5, -1, 0, 4, 0, 4, 4, 3, 33, 32 },
    { 1, 0, 0, 0, -1, 0, 4, 0, 8, 4, 3, 33, 32 },
    { 0, 17, 9, 5, -1, 0, 4, 0, 4, 4, 3, 33, 32 },
    { 25, 0, 0, 0, -1, 0, 4, 0, 0, 0, 13, 17, 32 },
    { 25, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 5, 32 },
    { 17, 0, 0, 0, -1, 0, 4, 0, 0, 0, 9, 33, 32 },
    { 25, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 17, 32 },
    { 25, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 12, 32 },
    { 27, 4, 0, 0, -1, 0, 4, 0, 0, 0, 0, 9, 32 },
    { 0, 17, 230, 5, -1, 0, 7, 0, 4, 4, 3, 33, 32 },
    { 3, 0, 0, 0, 0, 0, 4, 0, 0, 16, 10, 11, 32 },
    { 3, 0, 0, 0, 1, 0, 4, 0, 0, 16, 10, 11, 32 },
    { 3, 0, 0, 0, 2, 0, 4, 0, 0, 16, 10, 11, 32 },
    { 3, 0, 0, 0, 3, 0, 4, 0, 0, 16, 10, 11, 32 },
    { 3, 0, 0, 0, 4, 0, 4, 0, 0, 16, 10, 11, 32 },
    { 3, 0, 0, 0, 5, 0, 4, 0, 0, 16, 10, 11, 32 },
    { 3, 0, 0, 0, 6, 0, 4, 0, 0, 16, 10, 11, 32 },
    { 3, 0, 0, 0, 7, 0, 4, 0, 0, 16, 10, 11, 32 },
    { 3, 0, 0, 0, 8, 0, 4, 0, 0, 16, 10, 11, 32 },
    { 3, 0, 0, 0, 9, 0, 4, 0, 0, 16, 10, 11, 32 },
    { 5, 10, 0, 0, -1, 0, 7, 0, 0, 0, 0, 12, 32 },
    { 25, 10, 0, 0, -1, 0, 4, 0, 0, 0, 0, 12, 33 },
    { 25, 10, 0, 0, -1, 0, 4, 0, 0, 0, 12, 6, 2 },
    { 25, 10, 0, 0, -1, 0, 4, 0, 0, 0, 13, 6, 2 },
    { 25, 10, 0, 0, -1, 0, 4, 0, 0, 0, 0, 17, 33 },
    { 25, 10, 0, 0, -1, 0, 4, 0, 0, 0, 0, 17, 2 },
    { 20, 10, 0, 0, -1, 0, 4, 0, 0, 0, 0, 18, 33 },
    { 25, 10, 0, 2, -1, 0, 4, 0, 0, 0, 0, 12, 33 },
    { 25, 10, 0, 0, -1, 0, 4, 0, 0, 0, 12, 6, 33 },
    { 25, 10, 0, 0, -1, 0, 4, 0, 0, 0, 13, 6, 33 },
    { 25, 10, 0, 1, -1, 0, 4, 0, 0, 0, 0, 12, 33 },
    { 0, 17, 0, 5, -1, 0, 4, 0, 4, 4, 3, 21, 33 },
    { 10, 18, 0, 0, -1, 0, 4, 0, 3, 6, 5, 4, 33 },
    { 0, 17, 0, 5, -1, 0, 24, 0, 4, 4, 3, 21, 33 },
    { 3, 0, 0, 0, 0, 0, 4, 0, 0, 16, 10, 11, 33 },
    { 3, 0, 0, 0, 1, 0, 4, 0, 0, 16, 10, 11, 33 },
    { 3, 0, 0, 0, 2, 0, 4, 0, 0, 16, 10, 11, 33 },
    { 3, 0, 0, 0, 3, 0, 4, 0, 0, 16, 10, 11, 33 },
    { 3, 0, 0, 0, 4, 0, 4, 0, 0, 16, 10, 11, 33 },
    { 3, 0, 0, 0, 5, 0, 4, 0, 0, 16, 10, 11, 33 },
    { 3, 0, 0, 0, 6, 0, 4, 0, 0, 16, 10, 11, 33 },
    { 3, 0, 0, 0, 7, 0, 4, 0, 0, 16, 10, 11, 33 },
    { 3, 0, 0, 0, 8, 0, 4, 0, 0, 16, 10, 11, 33 },
    { 3, 0, 0, 0, 9, 0, 4, 0, 0, 16, 10, 11, 33 },
    { 18, 0, 0, 2, -1, 0, 4, 0, 0, 10, 9, 12, 33 },
    { 17, 0, 0, 2, -1, 0, 4, 0, 0, 10, 9, 12, 33 },
    { 18, 0, 0, 2, -1, 0, 20, 0, 0, 10, 9, 12, 33 },
    { 18, 0, 0, 0, -1, 0, 4, 0, 0, 10, 9, 12, 33 },
    { 0, 17, 228, 5, -1, 0, 4, 0, 4, 4, 3, 21, 33 },
    { 18, 0, 0, 2, -1, 0, 10, 0, 0, 10, 9, 12, 33 },
    { 18, 0, 0, 0, -1, 0, 7, 0, 0, 10, 9, 12, 47 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 47 },
    { 0, 17, 0, 5, -1, 0, 7, 0, 4, 4, 3, 21, 47 },
    { 1, 0, 0, 0, -1, 0, 7, 0, 8, 4, 3, 21, 47 },
    { 0, 17, 222, 5, -1, 0, 7, 0, 4, 4, 3, 21, 47 },
    { 0, 17, 230, 5, -1, 0, 7, 0, 4, 4, 3, 21, 47 },
    { 0, 17, 220, 5, -1, 0, 7, 0, 4, 4, 3, 21, 47 },
    { 29, 10, 0, 0, -1, 0, 7, 0, 0, 0, 0, 12, 47 },
    { 25, 10, 0, 0, -1, 0, 7, 0, 0, 0, 13, 6, 47 },
    { 3, 0, 0, 0, 0, 0, 7, 0, 0, 16, 10, 11, 47 },
    { 3, 0, 0, 0, 1, 0, 7, 0, 0, 16, 10, 11, 47 },
    { 3, 0, 0, 0, 2, 0, 7, 0, 0, 16, 10, 11, 47 },
    { 3, 0, 0, 0, 3, 0, 7, 0, 0, 16, 10, 11, 47 },
    { 3, 0, 0, 0, 4, 0, 7, 0, 0, 16, 10, 11, 47 },
    { 3, 0, 0, 0, 5, 0, 7, 0, 0, 16, 10, 11, 47 },
    { 3, 0, 0, 0, 6, 0, 7, 0, 0, 16, 10, 11, 47 },
    { 3, 0, 0, 0, 7, 0, 7, 0, 0, 16, 10, 11, 47 },
    { 3, 0, 0, 0, 8, 0, 7, 0, 0, 16, 10, 11, 47 },
    { 3, 0, 0, 0, 9, 0, 7, 0, 0, 16, 10, 11, 47 },
    { 18, 0, 0, 0, -1, 0, 7, 0, 0, 0, 9, 33, 48 },
    { 18, 0, 0, 0, -1, 0, 8, 0, 0, 0, 9, 33, 56 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 0, 9, 33, 56 },
    { 3, 0, 0, 0, 0, 0, 8, 0, 0, 16, 10, 11, 56 },
    { 3, 0, 0, 0, 1, 0, 8, 0, 0, 16, 10, 11, 56 },
    { 3, 0, 0, 0, 2, 0, 8, 0, 0, 16, 10, 11, 56 },
    { 3, 0, 0, 0, 3, 0, 8, 0, 0, 16, 10, 11, 56 },
    { 3, 0, 0, 0, 4, 0, 8, 0, 0, 16, 10, 11, 56 },
    { 3, 0, 0, 0, 5, 0, 8, 0, 0, 16, 10, 11, 56 },
    { 3, 0, 0, 0, 6, 0, 8, 0, 0, 16, 10, 11, 56 },
    { 3, 0, 0, 0, 7, 0, 8, 0, 0, 16, 10, 11, 56 },
    { 3, 0, 0, 0, 8, 0, 8, 0, 0, 16, 10, 11, 56 },
    { 3, 0, 0, 0, 9, 0, 8, 0, 0, 16, 10, 11, 56 },
    { 5, 0, 0, 0, 1, 0, 11, 0, 0, 0, 0, 33, 56 },
    { 29, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 33, 56 },
    { 29, 10, 0, 0, -1, 0, 7, 0, 0, 0, 0, 12, 32 },
    { 18, 0, 0, 0, -1, 0, 8, 0, 0, 10, 9, 12, 55 },
    { 0, 17, 230, 5, -1, 0, 8, 0, 4, 4, 3, 21, 55 },
    { 0, 17, 220, 5, -1, 0, 8, 0, 4, 4, 3, 21, 55 },
    { 1, 0, 0, 0, -1, 0, 8, 0, 8, 4, 3, 21, 55 },
    { 0, 17, 0, 5, -1, 0, 8, 0, 4, 4, 3, 21, 55 },
    { 25, 0, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 55 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 0, 9, 33, 78 },
    { 1, 0, 0, 0, -1, 0, 11, 0, 8, 4, 3, 33, 78 },
    { 0, 17, 0, 5, -1, 0, 11, 0, 4, 4, 3, 33, 78 },
    { 0, 17, 9, 5, -1, 0, 11, 0, 4, 4, 3, 33, 78 },
    { 1, 0, 0, 0, -1, 0, 11, 0, 0, 4, 3, 33, 78 },
    { 0, 17, 230, 5, -1, 0, 11, 0, 4, 4, 3, 33, 78 },
    { 0, 17, 220, 5, -1, 0, 11, 0, 4, 4, 3, 21, 78 },
    { 3, 0, 0, 0, 0, 0, 11, 0, 0, 16, 10, 11, 78 },
    { 3, 0, 0, 0, 1, 0, 11, 0, 0, 16, 10, 11, 78 },
    { 3, 0, 0, 0, 2, 0, 11, 0, 0, 16, 10, 11, 78 },
    { 3, 0, 0, 0, 3, 0, 11, 0, 0, 16, 10, 11, 78 },
    { 3, 0, 0, 0, 4, 0, 11, 0, 0, 16, 10, 11, 78 },
    { 3, 0, 0, 0, 5, 0, 11, 0, 0, 16, 10, 11, 78 },
    { 3, 0, 0, 0, 6, 0, 11, 0, 0, 16, 10, 11, 78 },
    { 3, 0, 0, 0, 7, 0, 11, 0, 0, 16, 10, 11, 78 },
    { 3, 0, 0, 0, 8, 0, 11, 0, 0, 16, 10, 11, 78 },
    { 3, 0, 0, 0, 9, 0, 11, 0, 0, 16, 10, 11, 78 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 0, 33, 78 },
    { 17, 0, 0, 0, -1, 0, 11, 0, 0, 0, 9, 33, 78 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 13, 33, 78 },
    { 0, 17, 230, 5, -1, 0, 16, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 16, 0, 4, 4, 3, 21, 1 },
    { 2, 17, 0, 5, -1, 0, 16, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 23, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 24, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 24, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 0, 5, -1, 0, 9, 0, 4, 4, 3, 21, 62 },
    { 1, 0, 0, 0, -1, 0, 9, 0, 8, 4, 3, 21, 62 },
    { 18, 0, 0, 0, -1, 0, 9, 0, 0, 10, 9, 12, 62 },
    { 18, 0, 0, 0, -1, 0, 9, 17, 0, 10, 9, 12, 62 },
    { 0, 17, 7, 5, -1, 0, 9, 0, 4, 4, 3, 21, 62 },
    { 1, 0, 0, 0, -1, 0, 9, 204, 4, 4, 3, 21, 62 },
    { 1, 0, 0, 0, -1, 0, 9, 17, 8, 4, 3, 21, 62 },
    { 1, 0, 9, 0, -1, 0, 9, 0, 8, 4, 3, 12, 62 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 10, 9, 12, 62 },
    { 3, 0, 0, 0, 0, 0, 9, 0, 0, 16, 10, 14, 62 },
    { 3, 0, 0, 0, 1, 0, 9, 0, 0, 16, 10, 14, 62 },
    { 3, 0, 0, 0, 2, 0, 9, 0, 0, 16, 10, 14, 62 },
    { 3, 0, 0, 0, 3, 0, 9, 0, 0, 16, 10, 14, 62 },
    { 3, 0, 0, 0, 4, 0, 9, 0, 0, 16, 10, 14, 62 },
    { 3, 0, 0, 0, 5, 0, 9, 0, 0, 16, 10, 14, 62 },
    { 3, 0, 0, 0, 6, 0, 9, 0, 0, 16, 10, 14, 62 },
    { 3, 0, 0, 0, 7, 0, 9, 0, 0, 16, 10, 14, 62 },
    { 3, 0, 0, 0, 8, 0, 9, 0, 0, 16, 10, 14, 62 },
    { 3, 0, 0, 0, 9, 0, 9, 0, 0, 16, 10, 14, 62 },
    { 25, 0, 0, 0, -1, 0, 9, 0, 0, 0, 13, 17, 62 },
    { 25, 0, 0, 0, -1, 0, 9, 0, 0, 0, 0, 14, 62 },
    { 25, 0, 0, 0, -1, 0, 9, 0, 0, 0, 0, 17, 62 },
    { 29, 0, 0, 0, -1, 0, 9, 0, 0, 0, 0, 14, 62 },
    { 0, 17, 230, 5, -1, 0, 9, 0, 4, 4, 3, 21, 62 },
    { 0, 17, 220, 5, -1, 0, 9, 0, 4, 4, 3, 21, 62 },
    { 25, 0, 0, 0, -1, 0, 24, 0, 0, 0, 13, 17, 62 },
    { 0, 17, 0, 5, -1, 0, 10, 0, 4, 4, 3, 21, 67 },
    { 1, 0, 0, 0, -1, 0, 10, 0, 8, 4, 3, 21, 67 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 67 },
    { 1, 0, 9, 0, -1, 0, 10, 0, 8, 4, 3, 21, 67 },
    { 0, 17, 9, 5, -1, 0, 13, 0, 4, 4, 3, 21, 67 },
    { 0, 17, 0, 5, -1, 0, 13, 0, 4, 4, 3, 21, 67 },
    { 3, 0, 0, 0, 0, 0, 10, 0, 0, 16, 10, 11, 67 },
    { 3, 0, 0, 0, 1, 0, 10, 0, 0, 16, 10, 11, 67 },
    { 3, 0, 0, 0, 2, 0, 10, 0, 0, 16, 10, 11, 67 },
    { 3, 0, 0, 0, 3, 0, 10, 0, 0, 16, 10, 11, 67 },
    { 3, 0, 0, 0, 4, 0, 10, 0, 0, 16, 10, 11, 67 },
    { 3, 0, 0, 0, 5, 0, 10, 0, 0, 16, 10, 11, 67 },
    { 3, 0, 0, 0, 6, 0, 10, 0, 0, 16, 10, 11, 67 },
    { 3, 0, 0, 0, 7, 0, 10, 0, 0, 16, 10, 11, 67 },
    { 3, 0, 0, 0, 8, 0, 10, 0, 0, 16, 10, 11, 67 },
    { 3, 0, 0, 0, 9, 0, 10, 0, 0, 16, 10, 11, 67 },
    { 18, 0, 0, 0, -1, 0, 13, 0, 0, 10, 9, 12, 67 },
    { 18, 0, 0, 0, -1, 0, 12, 0, 0, 10, 9, 12, 93 },
    { 0, 17, 7, 5, -1, 0, 12, 0, 4, 4, 3, 21, 93 },
    { 1, 0, 0, 0, -1, 0, 12, 0, 8, 4, 3, 21, 93 },
    { 0, 17, 0, 5, -1, 0, 12, 0, 4, 4, 3, 21, 93 },
    { 1, 0, 9, 0, -1, 0, 12, 0, 8, 4, 3, 12, 93 },
    { 25, 0, 0, 0, -1, 0, 12, 0, 0, 0, 0, 12, 93 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 68 },
    { 1, 0, 0, 0, -1, 0, 10, 0, 8, 4, 3, 21, 68 },
    { 0, 17, 0, 5, -1, 0, 10, 0, 4, 4, 3, 21, 68 },
    { 0, 17, 7, 5, -1, 0, 10, 0, 4, 4, 3, 21, 68 },
    { 25, 0, 0, 0, -1, 0, 10, 0, 0, 0, 13, 17, 68 },
    { 25, 0, 0, 0, -1, 0, 10, 0, 0, 0, 0, 17, 68 },
    { 3, 0, 0, 0, 0, 0, 10, 0, 0, 16, 10, 11, 68 },
    { 3, 0, 0, 0, 1, 0, 10, 0, 0, 16, 10, 11, 68 },
    { 3, 0, 0, 0, 2, 0, 10, 0, 0, 16, 10, 11, 68 },
    { 3, 0, 0, 0, 3, 0, 10, 0, 0, 16, 10, 11, 68 },
    { 3, 0, 0, 0, 4, 0, 10, 0, 0, 16, 10, 11, 68 },
    { 3, 0, 0, 0, 5, 0, 10, 0, 0, 16, 10, 11, 68 },
    { 3, 0, 0, 0, 6, 0, 10, 0, 0, 16, 10, 11, 68 },
    { 3, 0, 0, 0, 7, 0, 10, 0, 0, 16, 10, 11, 68 },
    { 3, 0, 0, 0, 8, 0, 10, 0, 0, 16, 10, 11, 68 },
    { 3, 0, 0, 0, 9, 0, 10, 0, 0, 16, 10, 11, 68 },
    { 3, 0, 0, 0, 0, 0, 10, 0, 0, 16, 10, 11, 69 },
    { 3, 0, 0, 0, 1, 0, 10, 0, 0, 16, 10, 11, 69 },
    { 3, 0, 0, 0, 2, 0, 10, 0, 0, 16, 10, 11, 69 },
    { 3, 0, 0, 0, 3, 0, 10, 0, 0, 16, 10, 11, 69 },
    { 3, 0, 0, 0, 4, 0, 10, 0, 0, 16, 10, 11, 69 },
    { 3, 0, 0, 0, 5, 0, 10, 0, 0, 16, 10, 11, 69 },
    { 3, 0, 0, 0, 6, 0, 10, 0, 0, 16, 10, 11, 69 },
    { 3, 0, 0, 0, 7, 0, 10, 0, 0, 16, 10, 11, 69 },
    { 3, 0, 0, 0, 8, 0, 10, 0, 0, 16, 10, 11, 69 },
    { 3, 0, 0, 0, 9, 0, 10, 0, 0, 16, 10, 11, 69 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 69 },
    { 17, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 69 },
    { 25, 0, 0, 0, -1, 0, 10, 0, 0, 0, 13, 17, 69 },
    { 15, 0, 0, 0, -1, 0, 18, 0, 0, 10, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 18, 0, 0, 10, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 18, 0, 0, 10, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 18, 0, 0, 10, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 18, 0, 0, 10, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 18, 0, 0, 10, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 18, 0, 0, 10, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 18, 0, 0, 10, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 20, 0, 0, 10, 9, 12, 25 },
    { 25, 0, 0, 0, -1, 0, 13, 0, 0, 0, 0, 12, 67 },
    { 0, 17, 230, 5, -1, 0, 11, 0, 4, 4, 3, 21, 1 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 2 },
    { 0, 17, 1, 5, -1, 0, 11, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 11, 0, 4, 4, 3, 21, 1 },
    { 1, 0, 0, 0, -1, 0, 11, 0, 8, 4, 3, 21, 2 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 2 },
    { 18, 0, 0, 0, -1, 0, 13, 0, 0, 10, 9, 12, 2 },
    { 0, 17, 230, 5, -1, 0, 13, 0, 4, 4, 3, 21, 1 },
    { 1, 0, 0, 0, -1, 0, 19, 0, 8, 4, 3, 21, 2 },
    { 18, 0, 0, 0, -1, 0, 21, 0, 0, 10, 9, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 7, 0, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 7, 0, 0, 10, 7, 12, 5 },
    { 17, 0, 0, 0, -1, 0, 7, 80, 0, 10, 7, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 7, 0, 0, 10, 7, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 7, 80, 0, 10, 7, 12, 4 },
    { 17, 0, 0, 0, -1, 0, 8, 80, 0, 10, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 8, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 8, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 8, 0, 0, 10, 7, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 8, 80, 0, 10, 7, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 8, 80, 0, 10, 7, 12, 4 },
    { 0, 17, 230, 5, -1, 0, 9, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 9, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 10, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 234, 5, -1, 0, 10, 0, 4, 4, 3, 4, 1 },
    { 0, 17, 214, 5, -1, 0, 10, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 10, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 202, 5, -1, 0, 10, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 232, 5, -1, 0, 19, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 228, 5, -1, 0, 19, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 19, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 218, 5, -1, 0, 24, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 18, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 233, 5, -1, 0, 12, 0, 4, 4, 3, 4, 1 },
    { 15, 0, 0, 0, -1, 0, 2, 81, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 10, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 10, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 10, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 10, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 85, 0, 10, 8, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85, 0, 10, 7, 12, 4 },
    { 28, 10, 0, 0, -1, 0, 1, 81, 0, 0, 0, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 85, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85, 0, 10, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 85, 0, 10, 8, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17, 0, 10, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 85, 0, 10, 8, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 28, 10, 0, 0, -1, 0, 1, 85, 0, 0, 0, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 85, 0, 10, 8, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17, 0, 10, 8, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 85, 0, 10, 8, 12, 4 },
    { 28, 10, 0, 0, -1, 0, 1, 85, 0, 0, 0, 18, 4 },
    { 6, 9, 0, 0, -1, 0, 1, 85, 0, 22, 6, 17, 2 },
    { 6, 9, 0, 0, -1, 0, 1, 80, 0, 22, 6, 17, 2 },
    { 6, 9, 0, 0, -1, 0, 1, 80, 0, 0, 6, 4, 2 },
    { 10, 18, 0, 5, -1, 0, 1, 0, 3, 0, 5, 20, 2 },
    { 10, 18, 0, 0, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 10, 18, 0, 1, -1, 0, 1, 0, 5, 5, 3, 32, 1 },
    { 10, 0, 0, 5, -1, 0, 1, 0, 3, 6, 5, 21, 2 },
    { 10, 1, 0, 5, -1, 0, 1, 0, 3, 6, 5, 21, 2 },
    { 20, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 17, 2 },
    { 20, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 4, 2 },
    { 20, 10, 0, 0, -1, 0, 1, 0, 0, 0, 12, 17, 2 },
    { 20, 10, 0, 0, -1, 0, 1, 0, 0, 0, 12, 19, 2 },
    { 20, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 23, 10, 0, 0, -1, 0, 1, 0, 0, 13, 14, 3, 2 },
    { 24, 10, 0, 0, -1, 0, 1, 0, 0, 13, 14, 3, 2 },
    { 21, 10, 0, 0, -1, 0, 1, 0, 0, 0, 14, 0, 2 },
    { 23, 10, 0, 0, -1, 0, 1, 0, 0, 0, 14, 3, 2 },
    { 24, 10, 0, 0, -1, 0, 1, 0, 0, 0, 14, 3, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80, 0, 13, 11, 15, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 15, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 14, 0, 17, 2 },
    { 7, 9, 0, 0, -1, 0, 1, 0, 3, 3, 4, 38, 2 },
    { 8, 7, 0, 0, -1, 0, 1, 0, 3, 3, 4, 38, 2 },
    { 10, 11, 0, 5, -1, 0, 1, 0, 3, 6, 5, 21, 2 },
    { 10, 14, 0, 5, -1, 0, 1, 0, 3, 6, 5, 21, 2 },
    { 10, 16, 0, 5, -1, 0, 1, 0, 3, 6, 5, 21, 2 },
    { 10, 12, 0, 5, -1, 0, 1, 0, 3, 6, 5, 21, 2 },
    { 10, 15, 0, 5, -1, 0, 1, 0, 3, 6, 5, 21, 2 },
    { 6, 6, 0, 0, -1, 0, 4, 80, 0, 17, 6, 4, 2 },
    { 25, 4, 0, 0, -1, 0, 1, 80, 0, 0, 0, 10, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 10, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 10, 2 },
    { 23, 10, 0, 0, -1, 1, 1, 0, 0, 0, 14, 3, 2 },
    { 24, 10, 0, 0, -1, -1, 1, 0, 0, 0, 14, 3, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80, 0, 0, 13, 5, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 0, 13, 5, 2 },
    { 26, 6, 0, 0, -1, 0, 1, 0, 0, 15, 0, 8, 2 },
    { 22, 10, 0, 0, -1, -1, 1, 0, 0, 0, 14, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 6, 80, 0, 0, 13, 5, 2 },
    { 25, 10, 0, 0, -1, 0, 4, 80, 0, 0, 13, 5, 2 },
    { 25, 10, 0, 0, -1, 0, 4, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 7, 0, 0, 0, 0, 12, 2 },
    { 19, 10, 0, 0, -1, 0, 7, 0, 0, 17, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 6, 80, 0, 0, 0, 10, 2 },
    { 6, 9, 0, 0, -1, 0, 6, 80, 0, 22, 6, 17, 2 },
    { 10, 18, 0, 5, -1, 0, 6, 0, 3, 6, 5, 22, 2 },
    { 10, 18, 0, 5, -1, 0, 6, 0, 3, 6, 5, 12, 2 },
    { 10, 18, 0, 5, -1, 0, 10, 0, 3, 6, 5, 12, 2 },
    { 13, 18, 0, 0, -1, 0, 0, 0, 3, 0, 0, 12, 0 },
    { 10, 19, 0, 0, -1, 0, 15, 0, 3, 6, 5, 21, 2 },
    { 10, 20, 0, 0, -1, 0, 15, 0, 3, 6, 5, 21, 2 },
    { 10, 21, 0, 0, -1, 0, 15, 0, 3, 6, 5, 21, 2 },
    { 10, 22, 0, 0, -1, 0, 15, 0, 3, 6, 5, 21, 2 },
    { 10, 18, 0, 5, -1, 0, 1, 0, 3, 6, 5, 21, 2 },
    { 5, 2, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 17, 0, 0, 0, -1, 0, 6, 80, 0, 10, 7, 12, 3 },
    { 5, 2, 0, 0, 4, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 5, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 6, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 7, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 8, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 9, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 26, 3, 0, 0, -1, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 21, 10, 0, 0, -1, 1, 1, 80, 0, 0, 14, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 1, 80, 0, 0, 14, 1, 2 },
    { 17, 0, 0, 0, -1, 0, 12, 80, 0, 10, 7, 12, 3 },
    { 27, 4, 0, 0, -1, 0, 1, 80, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 2, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 3, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 4, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 6, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 8, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 11, 0, 0, 0, 0, 10, 2 },
    { 27, 4, 0, 0, -1, 0, 11, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 12, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 14, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 16, 0, 0, 0, 0, 10, 2 },
    { 27, 4, 0, 0, -1, 0, 16, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 17, 0, 0, 0, 0, 10, 2 },
    { 27, 4, 0, 0, -1, 0, 19, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 24, 0, 0, 0, 0, 10, 2 },
    { 13, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 9, 0 },
    { 2, 17, 0, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 2, 17, 0, 5, -1, 0, 4, 0, 4, 4, 3, 21, 1 },
    { 2, 17, 0, 5, -1, 0, 6, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 1, 5, -1, 0, 6, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 6, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 1, 5, -1, 0, 8, 0, 4, 4, 3, 21, 1 },
    { 29, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 80, 0, 10, 8, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 10, 2 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 9, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 85, 0, 10, 8, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 85, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 85, 0, 10, 8, 12, 3 },
    { 29, 4, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 0, 0, 10, 8, 12, 3 },
    { 18, 0, 0, 0, -1, 0, 1, 80, 0, 10, 9, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 4, 80, 0, 10, 7, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 4, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 7, 80, 0, 0, 0, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 8, 80, 0, 10, 7, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 6, 80, 0, 10, 7, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 6, 80, 0, 10, 8, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 6, 80, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 9, 0, 0, 0, 0, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 9, 0, 0, 10, 7, 12, 3 },
    { 29, 0, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, -1, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 4, 0, 0, 0, -1, 0, 1, 80, 0, 10, 8, 12, 3 },
    { 4, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 3 },
    { 4, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 12, 3 },
    { 4, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 3 },
    { 29, 10, 0, 0, -1, 0, 17, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 1, 17, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 17, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 3, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 3, 1, 17, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -3, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -3, 1, 17, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 2016, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 2527, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 1923, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 1914, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 1918, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 2250, 1, 17, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 1, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -1, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 138, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 7, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -7, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 1, 1, 17, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -1, 1, 17, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 1824, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 2104, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 2108, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 2106, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 1316, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -138, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 15, 2 },
    { 26, 10, 0, 0, -1, 8, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 7, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -8, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -7, 6, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 14, 2 },
    { 21, 10, 0, 0, -1, 1, 1, 85, 0, 0, 14, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 1, 85, 0, 0, 14, 1, 2 },
    { 29, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 7, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 9, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 12, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 12, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 18, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 19, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 1, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 2, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 3, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 4, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 5, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 6, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 7, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 8, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 9, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, -1, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 1, 80, 0, 10, 8, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 2 },
    { 5, 10, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, -1, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 1, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 2, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 3, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 4, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 5, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 6, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 7, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 8, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 9, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 0, 0, 7, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 7, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 30, 2 },
    { 29, 10, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 11, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 10, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 11, 0, 0, 0, 0, 30, 2 },
    { 29, 10, 0, 0, -1, 0, 16, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 12, 0, 0, 0, 0, 30, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 0, 0, 0, 14, 3, 2 },
    { 29, 10, 0, 0, -1, 0, 12, 0, 0, 0, 14, 3, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 6, 2 },
    { 21, 10, 0, 0, -1, 1, 6, 0, 0, 0, 14, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 6, 0, 0, 0, 14, 1, 2 },
    { 5, 10, 0, 0, 1, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 2, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 3, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 4, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 5, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 6, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 7, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 8, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 9, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 1, 8, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -1, 8, 0, 0, 0, 0, 12, 2 },
    { 21, 10, 0, 0, -1, 1, 8, 0, 0, 0, 14, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 8, 0, 0, 0, 14, 1, 2 },
    { 26, 10, 0, 0, -1, 1, 9, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -1, 9, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 2, 13, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -2, 13, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 12, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 1, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -1, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -1316, 6, 0, 0, 0, 0, 12, 2 },
    { 21, 10, 0, 0, -1, 1, 10, 0, 0, 0, 14, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 10, 0, 0, 0, 14, 1, 2 },
    { 29, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 12, 54 },
    { 21, 10, 0, 0, -1, 3, 6, 0, 0, 0, 14, 0, 2 },
    { 22, 10, 0, 0, -1, 1, 6, 0, 0, 0, 14, 1, 2 },
    { 21, 10, 0, 0, -1, -1, 6, 0, 0, 0, 14, 0, 2 },
    { 22, 10, 0, 0, -1, -3, 6, 0, 0, 0, 14, 1, 2 },
    { 26, 10, 0, 0, -1, -1914, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -1918, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -1923, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -1824, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -2016, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 6, 85, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -2104, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -2106, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -2108, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -2250, 6, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 23, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 20, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 21, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, -2527, 20, 0, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 8, 0, 0, 10, 8, 12, 57 },
    { 14, 0, 0, 0, -1, 0, 24, 0, 0, 10, 8, 12, 57 },
    { 15, 0, 0, 0, -1, 0, 8, 0, 0, 10, 7, 12, 57 },
    { 15, 0, 0, 0, -1, 0, 24, 0, 0, 10, 7, 12, 57 },
    { 14, 0, 0, 0, -1, 0, 9, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 9, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 9, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 9, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 9, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 10, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 10, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 10, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 11, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 9, 0, 0, 10, 7, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 10, 80, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 11, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 8, 0, 0, 10, 8, 12, 46 },
    { 15, 0, 0, 0, -1, 0, 8, 0, 0, 10, 7, 12, 46 },
    { 15, 0, 0, 0, -1, 0, 8, 0, 0, 10, 7, 12, 46 },
    { 29, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 46 },
    { 14, 0, 0, 0, -1, 0, 11, 0, 0, 10, 8, 12, 46 },
    { 15, 0, 0, 0, -1, 0, 11, 0, 0, 10, 7, 12, 46 },
    { 0, 17, 230, 5, -1, 0, 11, 0, 4, 4, 3, 21, 46 },
    { 14, 0, 0, 0, -1, 0, 13, 0, 0, 10, 8, 12, 46 },
    { 15, 0, 0, 0, -1, 0, 13, 0, 0, 10, 7, 12, 46 },
    { 25, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 6, 46 },
    { 25, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 17, 46 },
    { 5, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 46 },
    { 15, 0, 0, 0, -1, 0, 8, 0, 0, 10, 7, 12, 25 },
    { 15, 0, 0, 0, -1, 0, 13, 0, 0, 10, 7, 12, 25 },
    { 18, 0, 0, 0, -1, 0, 8, 0, 0, 10, 9, 12, 58 },
    { 18, 0, 0, 0, -1, 0, 13, 0, 0, 10, 9, 12, 58 },
    { 17, 0, 0, 0, -1, 0, 8, 80, 0, 10, 9, 12, 58 },
    { 25, 0, 0, 0, -1, 0, 12, 0, 0, 0, 0, 17, 58 },
    { 0, 17, 9, 5, -1, 0, 12, 0, 4, 4, 3, 21, 58 },
    { 25, 10, 0, 0, -1, 0, 8, 0, 0, 0, 14, 3, 2 },
    { 23, 10, 0, 0, -1, 1, 8, 0, 0, 0, 14, 3, 2 },
    { 24, 10, 0, 0, -1, -1, 8, 0, 0, 0, 14, 3, 2 },
    { 20, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 10, 0, 0, 0, 0, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 10, 0, 0, 0, 0, 17, 2 },
    { 20, 10, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 2 },
    { 23, 10, 0, 0, -1, 1, 10, 0, 0, 0, 14, 3, 2 },
    { 24, 10, 0, 0, -1, -1, 10, 0, 0, 0, 14, 3, 2 },
    { 25, 10, 0, 0, -1, 0, 10, 0, 0, 0, 13, 6, 2 },
    { 17, 10, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 11, 0, 0, 0, 0, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 13, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 13, 0, 0, 0, 0, 17, 2 },
    { 20, 10, 0, 0, -1, 0, 13, 0, 0, 0, 0, 19, 2 },
    { 25, 10, 0, 0, -1, 0, 16, 0, 0, 0, 13, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 16, 0, 0, 0, 0, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 2 },
    { 20, 10, 0, 0, -1, 0, 16, 0, 0, 0, 0, 17, 2 },
    { 21, 10, 0, 0, -1, 0, 16, 0, 0, 0, 14, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 18, 0, 0, 0, 0, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 19, 0, 0, 0, 0, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 20, 0, 0, 0, 0, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 20, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 21, 0, 0, 0, 0, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 23, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 24, 0, 0, 0, 13, 6, 2 },
    { 21, 10, 0, 0, -1, 1, 24, 0, 0, 0, 14, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 24, 0, 0, 0, 14, 1, 2 },
    { 20, 10, 0, 0, -1, 0, 24, 0, 0, 0, 0, 17, 2 },
    { 29, 10, 0, 0, -1, 0, 4, 0, 0, 0, 0, 14, 37 },
    { 29, 10, 0, 0, -1, 0, 4, 80, 0, 0, 0, 14, 37 },
    { 29, 10, 0, 0, -1, 0, 4, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 26, 0, 0, 0, 0, 14, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 0, 12, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 0, 13, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 14, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 5, 37 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 0, 9, 14, 2 },
    { 4, 0, 0, 0, -1, 0, 1, 0, 0, 0, 9, 14, 37 },
    { 20, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 5, 2 },
    { 22, 10, 0, 0, -1, 0, 1, 0, 0, 0, 14, 1, 2 },
    { 0, 17, 218, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 228, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 222, 5, -1, 0, 1, 0, 4, 4, 3, 21, 1 },
    { 1, 0, 224, 0, -1, 0, 1, 0, 4, 4, 3, 21, 26 },
    { 20, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 14, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0, 0, 8, 9, 14, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0, 0, 8, 9, 21, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 4, 0, 0, 0, -1, 0, 4, 80, 0, 0, 9, 14, 37 },
    { 17, 0, 0, 0, -1, 0, 6, 0, 0, 10, 9, 5, 37 },
    { 18, 0, 0, 0, -1, 0, 6, 0, 0, 10, 9, 5, 2 },
    { 25, 10, 0, 0, -1, 0, 6, 0, 0, 0, 0, 14, 2 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 0, 9, 5, 34 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 0, 9, 14, 34 },
    { 18, 0, 0, 0, -1, 0, 1, 17, 0, 0, 9, 14, 34 },
    { 18, 0, 0, 0, -1, 0, 6, 0, 0, 0, 9, 5, 34 },
    { 0, 17, 8, 5, -1, 0, 1, 204, 4, 4, 3, 21, 1 },
    { 28, 10, 0, 0, -1, 0, 1, 80, 0, 8, 0, 5, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0, 0, 0, 9, 5, 34 },
    { 17, 0, 0, 0, -1, 0, 1, 17, 0, 0, 9, 5, 34 },
    { 18, 0, 0, 0, -1, 0, 6, 80, 0, 0, 9, 14, 34 },
    { 20, 10, 0, 0, -1, 0, 6, 0, 0, 8, 0, 5, 2 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 8, 9, 5, 35 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 8, 9, 14, 35 },
    { 18, 0, 0, 0, -1, 0, 1, 17, 0, 8, 9, 14, 35 },
    { 25, 10, 0, 0, -1, 0, 1, 0, 0, 0, 0, 5, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0, 0, 8, 9, 5, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0, 0, 8, 9, 5, 35 },
    { 17, 0, 0, 0, -1, 0, 1, 17, 0, 8, 9, 5, 35 },
    { 18, 0, 0, 0, -1, 0, 6, 80, 0, 8, 9, 14, 35 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 10, 9, 14, 36 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 14, 36 },
    { 18, 0, 0, 0, -1, 0, 19, 0, 0, 10, 9, 14, 36 },
    { 18, 0, 0, 0, -1, 0, 20, 0, 0, 10, 9, 14, 36 },
    { 18, 0, 0, 0, -1, 0, 1, 80, 0, 10, 9, 14, 26 },
    { 29, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 14, 2 },
    { 5, 0, 0, 0, -1, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 29, 0, 0, 0, -1, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 18, 0, 0, 0, -1, 0, 4, 0, 0, 10, 9, 14, 36 },
    { 18, 0, 0, 0, -1, 0, 12, 0, 0, 10, 9, 14, 36 },
    { 18, 0, 0, 0, -1, 0, 23, 0, 0, 10, 9, 14, 36 },
    { 18, 0, 0, 0, -1, 0, 6, 0, 0, 8, 9, 5, 35 },
    { 29, 0, 0, 0, -1, 0, 1, 80, 0, 0, 0, 14, 26 },
    { 29, 10, 0, 0, -1, 0, 7, 80, 0, 0, 0, 14, 26 },
    { 29, 0, 0, 0, -1, 0, 11, 80, 0, 0, 0, 14, 2 },
    { 5, 0, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 7, 80, 0, 0, 0, 14, 2 },
    { 5, 10, 0, 0, -1, 0, 6, 80, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 8, 80, 0, 0, 0, 14, 26 },
    { 29, 0, 0, 0, -1, 0, 1, 80, 0, 8, 0, 14, 35 },
    { 29, 0, 0, 0, -1, 0, 22, 80, 0, 0, 0, 14, 2 },
    { 18, 0, 0, 0, -1, 0, 4, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 23, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 1, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 8, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 13, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 19, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 20, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 4, 0, 0, 10, 9, 14, 38 },
    { 17, 0, 0, 0, -1, 0, 4, 0, 0, 10, 9, 5, 38 },
    { 29, 10, 0, 0, -1, 0, 4, 0, 0, 0, 0, 14, 38 },
    { 29, 10, 0, 0, -1, 0, 6, 0, 0, 0, 0, 14, 38 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 83 },
    { 17, 0, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 83 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 0, 17, 83 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 13, 17, 83 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 70 },
    { 17, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 70 },
    { 25, 10, 0, 0, -1, 0, 10, 0, 0, 0, 0, 17, 70 },
    { 25, 10, 0, 0, -1, 0, 10, 0, 0, 0, 13, 6, 70 },
    { 25, 10, 0, 0, -1, 0, 10, 0, 0, 0, 13, 17, 70 },
    { 3, 0, 0, 0, 0, 0, 10, 0, 0, 16, 10, 11, 70 },
    { 3, 0, 0, 0, 1, 0, 10, 0, 0, 16, 10, 11, 70 },
    { 3, 0, 0, 0, 2, 0, 10, 0, 0, 16, 10, 11, 70 },
    { 3, 0, 0, 0, 3, 0, 10, 0, 0, 16, 10, 11, 70 },
    { 3, 0, 0, 0, 4, 0, 10, 0, 0, 16, 10, 11, 70 },
    { 3, 0, 0, 0, 5, 0, 10, 0, 0, 16, 10, 11, 70 },
    { 3, 0, 0, 0, 6, 0, 10, 0, 0, 16, 10, 11, 70 },
    { 3, 0, 0, 0, 7, 0, 10, 0, 0, 16, 10, 11, 70 },
    { 3, 0, 0, 0, 8, 0, 10, 0, 0, 16, 10, 11, 70 },
    { 3, 0, 0, 0, 9, 0, 10, 0, 0, 16, 10, 11, 70 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 5 },
    { 2, 17, 0, 5, -1, 0, 10, 0, 4, 4, 3, 21, 5 },
    { 25, 10, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 5 },
    { 0, 17, 230, 5, -1, 0, 13, 0, 4, 4, 3, 21, 5 },
    { 17, 10, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 5 },
    { 17, 0, 0, 0, -1, 0, 16, 80, 0, 10, 7, 12, 5 },
    { 0, 17, 230, 5, -1, 0, 17, 0, 4, 4, 3, 21, 5 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 84 },
    { 4, 0, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 84 },
    { 0, 17, 230, 5, -1, 0, 11, 0, 4, 4, 3, 21, 84 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 84 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 13, 17, 84 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 0, 17, 84 },
    { 28, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 8, 0, 0, 10, 0, 12, 2 },
    { 17, 10, 0, 0, -1, 0, 9, 0, 0, 10, 9, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 9, 0, 0, 10, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 10, 0, 0, 10, 8, 12, 3 },
    { 28, 0, 0, 0, -1, 0, 10, 0, 0, 10, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 12, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 12, 0, 0, 10, 7, 12, 3 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 10, 9, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 12, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 12, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 13, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 13, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 16, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 16, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 16, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 16, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 13, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 16, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 16, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 16, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 18, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 20, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 16, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 16, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 17, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 17, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 17, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 17, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 20, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 20, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 21, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 21, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 24, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 24, 0, 0, 10, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 21, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 21, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 21, 0, 0, 10, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 23, 0, 0, 10, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 23, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 24, 0, 0, 10, 7, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 24, 80, 0, 10, 7, 12, 3 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 13, 80, 0, 10, 7, 12, 3 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 3 },
    { 18, 0, 0, 0, -1, 0, 8, 0, 0, 10, 9, 12, 59 },
    { 0, 17, 0, 5, -1, 0, 8, 0, 4, 4, 3, 21, 59 },
    { 0, 17, 9, 5, -1, 0, 8, 0, 4, 4, 3, 21, 59 },
    { 1, 0, 0, 0, -1, 0, 8, 0, 8, 4, 3, 21, 59 },
    { 29, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 59 },
    { 0, 17, 9, 5, -1, 0, 23, 0, 4, 4, 3, 21, 59 },
    { 29, 4, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 2 },
    { 18, 0, 0, 2, -1, 0, 9, 0, 0, 10, 9, 12, 65 },
    { 18, 0, 0, 4, -1, 0, 9, 0, 0, 10, 9, 12, 65 },
    { 18, 0, 0, 0, -1, 0, 9, 0, 0, 10, 9, 12, 65 },
    { 25, 10, 0, 0, -1, 0, 9, 0, 0, 0, 0, 18, 65 },
    { 25, 10, 0, 0, -1, 0, 9, 0, 0, 0, 13, 6, 65 },
    { 1, 0, 0, 0, -1, 0, 10, 0, 8, 4, 3, 21, 71 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 71 },
    { 0, 17, 9, 5, -1, 0, 10, 0, 4, 4, 3, 21, 71 },
    { 0, 17, 0, 5, -1, 0, 18, 0, 4, 4, 3, 21, 71 },
    { 25, 0, 0, 0, -1, 0, 10, 0, 0, 0, 13, 17, 71 },
    { 3, 0, 0, 0, 0, 0, 10, 0, 0, 16, 10, 11, 71 },
    { 3, 0, 0, 0, 1, 0, 10, 0, 0, 16, 10, 11, 71 },
    { 3, 0, 0, 0, 2, 0, 10, 0, 0, 16, 10, 11, 71 },
    { 3, 0, 0, 0, 3, 0, 10, 0, 0, 16, 10, 11, 71 },
    { 3, 0, 0, 0, 4, 0, 10, 0, 0, 16, 10, 11, 71 },
    { 3, 0, 0, 0, 5, 0, 10, 0, 0, 16, 10, 11, 71 },
    { 3, 0, 0, 0, 6, 0, 10, 0, 0, 16, 10, 11, 71 },
    { 3, 0, 0, 0, 7, 0, 10, 0, 0, 16, 10, 11, 71 },
    { 3, 0, 0, 0, 8, 0, 10, 0, 0, 16, 10, 11, 71 },
    { 3, 0, 0, 0, 9, 0, 10, 0, 0, 16, 10, 11, 71 },
    { 0, 17, 230, 5, -1, 0, 11, 0, 4, 4, 3, 21, 11 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 11 },
    { 25, 0, 0, 0, -1, 0, 17, 0, 0, 0, 0, 18, 11 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 10, 9, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 20, 0, 0, 10, 9, 12, 11 },
    { 0, 17, 0, 5, -1, 0, 20, 0, 4, 4, 3, 21, 11 },
    { 3, 0, 0, 0, 0, 0, 10, 0, 0, 16, 10, 11, 72 },
    { 3, 0, 0, 0, 1, 0, 10, 0, 0, 16, 10, 11, 72 },
    { 3, 0, 0, 0, 2, 0, 10, 0, 0, 16, 10, 11, 72 },
    { 3, 0, 0, 0, 3, 0, 10, 0, 0, 16, 10, 11, 72 },
    { 3, 0, 0, 0, 4, 0, 10, 0, 0, 16, 10, 11, 72 },
    { 3, 0, 0, 0, 5, 0, 10, 0, 0, 16, 10, 11, 72 },
    { 3, 0, 0, 0, 6, 0, 10, 0, 0, 16, 10, 11, 72 },
    { 3, 0, 0, 0, 7, 0, 10, 0, 0, 16, 10, 11, 72 },
    { 3, 0, 0, 0, 8, 0, 10, 0, 0, 16, 10, 11, 72 },
    { 3, 0, 0, 0, 9, 0, 10, 0, 0, 16, 10, 11, 72 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 72 },
    { 0, 17, 0, 5, -1, 0, 10, 0, 4, 4, 3, 21, 72 },
    { 0, 17, 220, 5, -1, 0, 10, 0, 4, 4, 3, 21, 72 },
    { 25, 0, 0, 0, -1, 0, 10, 0, 0, 0, 0, 17, 2 },
    { 25, 0, 0, 0, -1, 0, 10, 0, 0, 0, 13, 17, 72 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 73 },
    { 0, 17, 0, 5, -1, 0, 10, 0, 4, 4, 3, 21, 73 },
    { 1, 0, 0, 0, -1, 0, 10, 0, 8, 4, 3, 21, 73 },
    { 1, 0, 9, 0, -1, 0, 10, 0, 8, 4, 3, 21, 73 },
    { 25, 0, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 73 },
    { 0, 17, 0, 5, -1, 0, 11, 0, 4, 4, 3, 21, 85 },
    { 1, 0, 0, 0, -1, 0, 11, 0, 8, 4, 3, 21, 85 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 85 },
    { 0, 17, 7, 5, -1, 0, 11, 0, 4, 4, 3, 21, 85 },
    { 1, 0, 9, 0, -1, 0, 11, 0, 8, 4, 3, 12, 85 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 0, 14, 85 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 0, 17, 85 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 13, 17, 85 },
    { 17, 0, 0, 0, -1, 0, 11, 0, 0, 10, 9, 17, 2 },
    { 3, 0, 0, 0, 0, 0, 11, 0, 0, 16, 10, 14, 85 },
    { 3, 0, 0, 0, 1, 0, 11, 0, 0, 16, 10, 14, 85 },
    { 3, 0, 0, 0, 2, 0, 11, 0, 0, 16, 10, 14, 85 },
    { 3, 0, 0, 0, 3, 0, 11, 0, 0, 16, 10, 14, 85 },
    { 3, 0, 0, 0, 4, 0, 11, 0, 0, 16, 10, 14, 85 },
    { 3, 0, 0, 0, 5, 0, 11, 0, 0, 16, 10, 14, 85 },
    { 3, 0, 0, 0, 6, 0, 11, 0, 0, 16, 10, 14, 85 },
    { 3, 0, 0, 0, 7, 0, 11, 0, 0, 16, 10, 14, 85 },
    { 3, 0, 0, 0, 8, 0, 11, 0, 0, 16, 10, 14, 85 },
    { 3, 0, 0, 0, 9, 0, 11, 0, 0, 16, 10, 14, 85 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 0, 9, 33, 24 },
    { 0, 17, 0, 5, -1, 0, 16, 0, 4, 4, 3, 33, 24 },
    { 17, 0, 0, 0, -1, 0, 16, 0, 0, 0, 9, 33, 24 },
    { 3, 0, 0, 0, 0, 0, 16, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 1, 0, 16, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 2, 0, 16, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 3, 0, 16, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 4, 0, 16, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 5, 0, 16, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 6, 0, 16, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 7, 0, 16, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 8, 0, 16, 0, 0, 16, 10, 11, 24 },
    { 3, 0, 0, 0, 9, 0, 16, 0, 0, 16, 10, 11, 24 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 77 },
    { 0, 17, 0, 5, -1, 0, 10, 0, 4, 4, 3, 21, 77 },
    { 1, 0, 0, 0, -1, 0, 10, 0, 8, 4, 3, 21, 77 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 17, 77 },
    { 3, 0, 0, 0, 0, 0, 10, 0, 0, 16, 10, 14, 77 },
    { 3, 0, 0, 0, 1, 0, 10, 0, 0, 16, 10, 14, 77 },
    { 3, 0, 0, 0, 2, 0, 10, 0, 0, 16, 10, 14, 77 },
    { 3, 0, 0, 0, 3, 0, 10, 0, 0, 16, 10, 14, 77 },
    { 3, 0, 0, 0, 4, 0, 10, 0, 0, 16, 10, 14, 77 },
    { 3, 0, 0, 0, 5, 0, 10, 0, 0, 16, 10, 14, 77 },
    { 3, 0, 0, 0, 6, 0, 10, 0, 0, 16, 10, 14, 77 },
    { 3, 0, 0, 0, 7, 0, 10, 0, 0, 16, 10, 14, 77 },
    { 3, 0, 0, 0, 8, 0, 10, 0, 0, 16, 10, 14, 77 },
    { 3, 0, 0, 0, 9, 0, 10, 0, 0, 16, 10, 14, 77 },
    { 25, 0, 0, 0, -1, 0, 10, 0, 0, 0, 0, 14, 77 },
    { 25, 0, 0, 0, -1, 0, 10, 0, 0, 0, 13, 17, 77 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 0, 9, 33, 24 },
    { 17, 0, 0, 0, -1, 0, 11, 0, 0, 0, 9, 33, 24 },
    { 29, 0, 0, 0, -1, 0, 11, 0, 0, 0, 0, 33, 24 },
    { 1, 0, 0, 0, -1, 0, 16, 0, 0, 4, 3, 33, 24 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 0, 9, 33, 79 },
    { 0, 17, 230, 5, -1, 0, 11, 0, 4, 4, 3, 33, 79 },
    { 0, 17, 220, 5, -1, 0, 11, 0, 4, 4, 3, 33, 79 },
    { 17, 0, 0, 0, -1, 0, 11, 0, 0, 0, 9, 33, 79 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 0, 33, 79 },
    { 18, 0, 0, 0, -1, 0, 13, 0, 0, 10, 9, 12, 86 },
    { 1, 0, 0, 0, -1, 0, 13, 0, 8, 4, 3, 21, 86 },
    { 0, 17, 0, 5, -1, 0, 13, 0, 4, 4, 3, 21, 86 },
    { 25, 0, 0, 0, -1, 0, 13, 0, 0, 0, 13, 17, 86 },
    { 17, 0, 0, 0, -1, 0, 13, 0, 0, 10, 9, 12, 86 },
    { 0, 17, 9, 5, -1, 0, 13, 0, 4, 4, 3, 21, 86 },
    { 18, 0, 0, 0, -1, 0, 12, 0, 0, 10, 9, 12, 27 },
    { 15, 0, 0, 0, -1, 0, 16, 0, 0, 10, 7, 12, 3 },
    { 28, 0, 0, 0, -1, 0, 16, 0, 0, 10, 0, 12, 2 },
    { 17, 0, 0, 0, -1, 0, 16, 80, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 17, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 16, 0, 0, 10, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 21, 0, 0, 10, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 23, 0, 0, 10, 7, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 23, 80, 0, 10, 7, 12, 3 },
    { 28, 10, 0, 0, -1, 0, 23, 0, 0, 0, 0, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 17, 0, 0, 10, 7, 12, 28 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 86 },
    { 1, 0, 0, 0, -1, 0, 11, 0, 8, 4, 3, 21, 86 },
    { 0, 17, 0, 5, -1, 0, 11, 0, 4, 4, 3, 21, 86 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 13, 17, 86 },
    { 0, 17, 9, 5, -1, 0, 11, 0, 4, 4, 3, 21, 86 },
    { 3, 0, 0, 0, 0, 0, 11, 0, 0, 16, 10, 11, 86 },
    { 3, 0, 0, 0, 1, 0, 11, 0, 0, 16, 10, 11, 86 },
    { 3, 0, 0, 0, 2, 0, 11, 0, 0, 16, 10, 11, 86 },
    { 3, 0, 0, 0, 3, 0, 11, 0, 0, 16, 10, 11, 86 },
    { 3, 0, 0, 0, 4, 0, 11, 0, 0, 16, 10, 11, 86 },
    { 3, 0, 0, 0, 5, 0, 11, 0, 0, 16, 10, 11, 86 },
    { 3, 0, 0, 0, 6, 0, 11, 0, 0, 16, 10, 11, 86 },
    { 3, 0, 0, 0, 7, 0, 11, 0, 0, 16, 10, 11, 86 },
    { 3, 0, 0, 0, 8, 0, 11, 0, 0, 16, 10, 11, 86 },
    { 3, 0, 0, 0, 9, 0, 11, 0, 0, 16, 10, 11, 86 },
    { 18, 0, 0, 0, -1, 0, 2, 17, 12, 10, 9, 23, 26 },
    { 18, 0, 0, 0, -1, 0, 2, 17, 13, 10, 9, 24, 26 },
    { 11, 0, 0, 0, -1, 0, 2, 0, 0, 0, 0, 34, 0 },
    { 12, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 0 },
    { 18, 0, 0, 0, -1, 0, 1, 85, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 13, 85, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 6, 85, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 11, 85, 0, 0, 9, 14, 37 },
    { 13, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 14, 0 },
    { 18, 0, 0, 0, -1, 0, 8, 85, 0, 0, 9, 14, 37 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 12, 3 },
    { 18, 1, 0, 0, -1, 0, 4, 85, 0, 9, 9, 13, 7 },
    { 0, 17, 26, 5, -1, 0, 1, 0, 4, 4, 3, 21, 7 },
    { 18, 1, 0, 0, -1, 0, 1, 85, 0, 9, 9, 13, 7 },
    { 18, 1, 0, 0, -1, 0, 1, 80, 0, 9, 9, 13, 7 },
    { 26, 3, 0, 0, -1, 0, 1, 80, 0, 0, 0, 12, 7 },
    { 18, 13, 0, 0, -1, 0, 1, 80, 0, 10, 9, 12, 8 },
    { 28, 13, 0, 0, -1, 0, 12, 0, 0, 0, 0, 12, 8 },
    { 29, 10, 0, 0, -1, 0, 24, 0, 0, 0, 0, 12, 8 },
    { 13, 18, 0, 0, -1, 0, 5, 0, 0, 0, 0, 12, 0 },
    { 27, 13, 0, 0, -1, 0, 6, 80, 0, 0, 0, 10, 8 },
    { 0, 17, 0, 5, -1, 0, 6, 0, 4, 4, 3, 21, 1 },
    { 25, 10, 0, 0, -1, 0, 8, 80, 0, 15, 12, 8, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 80, 0, 0, 12, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 80, 0, 0, 0, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 80, 0, 14, 12, 8, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 80, 0, 15, 0, 8, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 80, 0, 0, 0, 6, 2 },
    { 21, 10, 0, 0, -1, 0, 8, 80, 0, 0, 14, 0, 2 },
    { 22, 10, 0, 0, -1, 0, 8, 80, 0, 0, 14, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 80, 0, 0, 0, 15, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 20, 10, 0, 0, -1, 0, 1, 80, 0, 0, 12, 14, 2 },
    { 19, 10, 0, 0, -1, 0, 1, 80, 0, 17, 0, 14, 2 },
    { 21, 10, 0, 0, -1, 0, 1, 80, 0, 0, 14, 0, 2 },
    { 22, 10, 0, 0, -1, 0, 1, 80, 0, 0, 14, 1, 2 },
    { 21, 10, 0, 0, -1, 0, 7, 80, 0, 0, 14, 0, 2 },
    { 22, 10, 0, 0, -1, 0, 7, 80, 0, 0, 14, 1, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 80, 0, 15, 12, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80, 0, 0, 12, 14, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 80, 0, 13, 11, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80, 0, 15, 0, 5, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 80, 0, 14, 12, 5, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80, 0, 0, 13, 6, 2 },
    { 25, 4, 0, 0, -1, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 26, 3, 0, 0, -1, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 20, 3, 0, 0, -1, 0, 1, 80, 0, 0, 12, 14, 2 },
    { 26, 10, 0, 0, -1, 1, 1, 80, 0, 0, 0, 14, 2 },
    { 26, 10, 0, 0, -1, -1, 1, 80, 0, 0, 0, 14, 2 },
    { 26, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 18, 13, 0, 0, -1, 0, 6, 0, 0, 10, 9, 12, 8 },
    { 10, 18, 0, 5, -1, 0, 1, 0, 3, 6, 5, 22, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80, 0, 13, 0, 14, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 3, 2, 0, 0, 0, 0, 1, 80, 0, 16, 10, 14, 2 },
    { 3, 2, 0, 0, 1, 0, 1, 80, 0, 16, 10, 14, 2 },
    { 3, 2, 0, 0, 2, 0, 1, 80, 0, 16, 10, 14, 2 },
    { 3, 2, 0, 0, 3, 0, 1, 80, 0, 16, 10, 14, 2 },
    { 3, 2, 0, 0, 4, 0, 1, 80, 0, 16, 10, 14, 2 },
    { 3, 2, 0, 0, 5, 0, 1, 80, 0, 16, 10, 14, 2 },
    { 3, 2, 0, 0, 6, 0, 1, 80, 0, 16, 10, 14, 2 },
    { 3, 2, 0, 0, 7, 0, 1, 80, 0, 16, 10, 14, 2 },
    { 3, 2, 0, 0, 8, 0, 1, 80, 0, 16, 10, 14, 2 },
    { 3, 2, 0, 0, 9, 0, 1, 80, 0, 16, 10, 14, 2 },
    { 26, 10, 0, 0, -1, 2, 1, 80, 0, 0, 0, 14, 2 },
    { 26, 10, 0, 0, -1, -2, 1, 80, 0, 0, 0, 14, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 80, 0, 10, 8, 14, 3 },
    { 21, 10, 0, 0, -1, 2, 1, 80, 0, 0, 14, 0, 2 },
    { 22, 10, 0, 0, -1, -2, 1, 80, 0, 0, 14, 1, 2 },
    { 28, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 15, 0, 0, 0, -1, 0, 1, 80, 0, 10, 7, 14, 3 },
    { 21, 10, 0, 0, -1, 1, 6, 80, 0, 0, 14, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 6, 80, 0, 0, 14, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80, 0, 0, 13, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80, 0, 0, 12, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80, 0, 0, 0, 5, 2 },
    { 18, 0, 0, 0, -1, 0, 1, 80, 0, 8, 9, 14, 35 },
    { 18, 0, 0, 0, -1, 0, 1, 80, 0, 8, 9, 5, 35 },
    { 17, 0, 0, 0, -1, 0, 1, 80, 0, 8, 9, 5, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 80, 4, 4, 3, 5, 2 },
    { 27, 4, 0, 0, -1, 0, 1, 80, 0, 0, 0, 10, 2 },
    { 10, 10, 0, 5, -1, 0, 4, 0, 3, 6, 5, 21, 2 },
    { 29, 10, 0, 0, -1, 0, 3, 0, 0, 0, 0, 29, 2 },
    { 13, 18, 0, 0, -1, 0, 1, 0, 0, 0, 0, 12, 0 },
    { 18, 0, 0, 0, -1, 0, 7, 0, 0, 10, 9, 12, 49 },
    { 25, 0, 0, 0, -1, 0, 7, 0, 0, 0, 0, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 7, 0, 0, 0, 0, 17, 2 },
    { 5, 0, 0, 0, -1, 0, 7, 0, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 7, 0, 0, 0, 0, 12, 2 },
    { 4, 10, 0, 0, -1, 0, 8, 0, 0, 10, 9, 12, 4 },
    { 5, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 4 },
    { 29, 10, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 4 },
    { 5, 10, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 4 },
    { 29, 10, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 4 },
    { 29, 0, 0, 0, -1, 0, 18, 0, 0, 0, 0, 12, 4 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 74 },
    { 18, 0, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 75 },
    { 5, 2, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 2 },
    { 18, 0, 0, 0, -1, 0, 5, 0, 0, 10, 9, 12, 39 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 39 },
    { 5, 0, 0, 0, -1, 0, 5, 0, 0, 0, 0, 12, 39 },
    { 18, 0, 0, 0, -1, 0, 19, 0, 0, 10, 9, 12, 39 },
    { 18, 0, 0, 0, -1, 0, 5, 0, 0, 10, 9, 12, 40 },
    { 4, 0, 0, 0, -1, 0, 5, 0, 0, 10, 9, 12, 40 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 120 },
    { 0, 17, 230, 5, -1, 0, 16, 0, 4, 4, 3, 21, 120 },
    { 18, 0, 0, 0, -1, 0, 7, 0, 0, 10, 9, 12, 50 },
    { 25, 0, 0, 0, -1, 0, 7, 0, 0, 0, 0, 17, 50 },
    { 18, 0, 0, 0, -1, 0, 8, 0, 0, 10, 9, 12, 60 },
    { 25, 0, 0, 0, -1, 0, 8, 0, 0, 0, 0, 17, 60 },
    { 4, 0, 0, 0, -1, 0, 8, 0, 0, 10, 9, 12, 60 },
    { 14, 0, 0, 0, -1, 0, 5, 0, 0, 10, 8, 12, 41 },
    { 14, 0, 0, 0, -1, 0, 7, 0, 0, 10, 8, 12, 41 },
    { 15, 0, 0, 0, -1, 0, 5, 0, 0, 10, 7, 12, 41 },
    { 15, 0, 0, 0, -1, 0, 7, 0, 0, 10, 7, 12, 41 },
    { 18, 0, 0, 0, -1, 0, 7, 0, 0, 10, 9, 12, 51 },
    { 18, 0, 0, 0, -1, 0, 7, 0, 0, 10, 9, 12, 52 },
    { 3, 0, 0, 0, 0, 0, 7, 0, 0, 16, 10, 11, 52 },
    { 3, 0, 0, 0, 1, 0, 7, 0, 0, 16, 10, 11, 52 },
    { 3, 0, 0, 0, 2, 0, 7, 0, 0, 16, 10, 11, 52 },
    { 3, 0, 0, 0, 3, 0, 7, 0, 0, 16, 10, 11, 52 },
    { 3, 0, 0, 0, 4, 0, 7, 0, 0, 16, 10, 11, 52 },
    { 3, 0, 0, 0, 5, 0, 7, 0, 0, 16, 10, 11, 52 },
    { 3, 0, 0, 0, 6, 0, 7, 0, 0, 16, 10, 11, 52 },
    { 3, 0, 0, 0, 7, 0, 7, 0, 0, 16, 10, 11, 52 },
    { 3, 0, 0, 0, 8, 0, 7, 0, 0, 16, 10, 11, 52 },
    { 3, 0, 0, 0, 9, 0, 7, 0, 0, 16, 10, 11, 52 },
    { 14, 0, 0, 0, -1, 0, 18, 0, 0, 10, 8, 12, 136 },
    { 15, 0, 0, 0, -1, 0, 18, 0, 0, 10, 7, 12, 136 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 106 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 103 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 103 },
    { 14, 0, 0, 0, -1, 0, 24, 0, 0, 10, 8, 12, 161 },
    { 15, 0, 0, 0, -1, 0, 24, 0, 0, 10, 7, 12, 161 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 110 },
    { 17, 0, 0, 0, -1, 0, 24, 0, 0, 10, 7, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 24, 80, 0, 10, 9, 12, 3 },
    { 18, 1, 0, 0, -1, 0, 7, 0, 0, 10, 9, 12, 53 },
    { 18, 1, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 87 },
    { 25, 1, 0, 0, -1, 0, 11, 0, 0, 0, 0, 17, 87 },
    { 5, 1, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 87 },
    { 18, 1, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 118 },
    { 29, 1, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 118 },
    { 5, 1, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 118 },
    { 18, 1, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 117 },
    { 5, 1, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 117 },
    { 18, 1, 0, 0, -1, 0, 17, 0, 0, 10, 9, 12, 128 },
    { 5, 1, 0, 0, -1, 0, 17, 0, 0, 0, 0, 12, 128 },
    { 18, 1, 0, 0, -1, 0, 9, 0, 0, 10, 9, 12, 64 },
    { 5, 1, 0, 0, -1, 0, 9, 0, 0, 0, 0, 12, 64 },
    { 5, 1, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 64 },
    { 25, 10, 0, 0, -1, 0, 9, 0, 0, 0, 0, 17, 64 },
    { 18, 1, 0, 0, -1, 0, 10, 0, 0, 10, 9, 12, 76 },
    { 25, 1, 0, 0, -1, 0, 10, 0, 0, 0, 0, 12, 76 },
    { 18, 1, 0, 0, -1, 0, 13, 0, 0, 10, 9, 12, 98 },
    { 18, 1, 0, 0, -1, 0, 13, 0, 0, 10, 9, 12, 97 },
    { 5, 1, 0, 0, -1, 0, 17, 0, 0, 0, 0, 12, 97 },
    { 18, 1, 0, 0, -1, 0, 8, 0, 0, 10, 9, 12, 61 },
    { 0, 17, 0, 5, -1, 0, 8, 0, 4, 4, 3, 21, 61 },
    { 0, 17, 220, 5, -1, 0, 8, 0, 4, 4, 3, 21, 61 },
    { 0, 17, 230, 5, -1, 0, 8, 0, 4, 4, 3, 21, 61 },
    { 18, 1, 0, 0, -1, 0, 20, 0, 0, 10, 9, 12, 61 },
    { 0, 17, 1, 5, -1, 0, 8, 0, 4, 4, 3, 21, 61 },
    { 0, 17, 9, 5, -1, 0, 8, 0, 4, 4, 3, 21, 61 },
    { 5, 1, 0, 0, 1, 0, 8, 0, 0, 0, 0, 12, 61 },
    { 5, 1, 0, 0, 2, 0, 8, 0, 0, 0, 0, 12, 61 },
    { 5, 1, 0, 0, 3, 0, 8, 0, 0, 0, 0, 12, 61 },
    { 5, 1, 0, 0, 4, 0, 8, 0, 0, 0, 0, 12, 61 },
    { 5, 1, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 61 },
    { 5, 1, 0, 0, -1, 0, 20, 0, 0, 0, 0, 12, 61 },
    { 25, 1, 0, 0, -1, 0, 8, 0, 0, 0, 0, 17, 61 },
    { 25, 1, 0, 0, -1, 0, 8, 0, 0, 0, 13, 17, 61 },
    { 25, 1, 0, 0, -1, 0, 8, 0, 0, 0, 0, 12, 61 },
    { 18, 1, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 88 },
    { 5, 1, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 88 },
    { 25, 1, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 88 },
    { 18, 1, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 116 },
    { 5, 1, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 116 },
    { 18, 1, 0, 2, -1, 0, 16, 0, 0, 10, 9, 12, 112 },
    { 18, 1, 0, 3, -1, 0, 16, 0, 0, 10, 9, 12, 112 },
    { 18, 1, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 112 },
    { 29, 1, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 112 },
    { 18, 1, 0, 4, -1, 0, 16, 0, 0, 10, 9, 12, 112 },
    { 0, 17, 230, 5, -1, 0, 16, 0, 4, 4, 3, 21, 112 },
    { 0, 17, 220, 5, -1, 0, 16, 0, 4, 4, 3, 21, 112 },
    { 5, 1, 0, 2, -1, 0, 16, 0, 0, 0, 0, 12, 112 },
    { 5, 1, 0, 3, -1, 0, 16, 0, 0, 0, 0, 12, 112 },
    { 25, 1, 0, 0, -1, 0, 16, 0, 0, 0, 0, 17, 112 },
    { 25, 1, 0, 0, -1, 0, 16, 0, 0, 0, 0, 15, 112 },
    { 18, 1, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 80 },
    { 25, 10, 0, 0, -1, 0, 11, 0, 0, 0, 0, 17, 80 },
    { 18, 1, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 89 },
    { 5, 1, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 89 },
    { 18, 1, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 90 },
    { 5, 1, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 90 },
    { 18, 1, 0, 2, -1, 0, 16, 0, 0, 10, 9, 12, 121 },
    { 18, 1, 0, 3, -1, 0, 16, 0, 0, 10, 9, 12, 121 },
    { 25, 1, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 121 },
    { 5, 1, 0, 3, -1, 0, 16, 0, 0, 0, 0, 12, 121 },
    { 5, 1, 0, 2, -1, 0, 16, 0, 0, 0, 0, 12, 121 },
    { 5, 1, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 121 },
    { 18, 1, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 91 },
    { 14, 1, 0, 0, -1, 0, 17, 0, 0, 10, 8, 12, 130 },
    { 15, 1, 0, 0, -1, 0, 17, 0, 0, 10, 7, 12, 130 },
    { 5, 1, 0, 0, -1, 0, 17, 0, 0, 0, 0, 12, 130 },
    { 18, 13, 0, 4, -1, 0, 20, 0, 0, 10, 9, 12, 144 },
    { 18, 13, 0, 2, -1, 0, 20, 0, 0, 10, 9, 12, 144 },
    { 18, 13, 0, 3, -1, 0, 20, 0, 0, 10, 9, 12, 144 },
    { 0, 17, 230, 5, -1, 0, 20, 0, 4, 4, 3, 21, 144 },
    { 3, 5, 0, 0, 0, 0, 20, 0, 0, 16, 10, 11, 144 },
    { 3, 5, 0, 0, 1, 0, 20, 0, 0, 16, 10, 11, 144 },
    { 3, 5, 0, 0, 2, 0, 20, 0, 0, 16, 10, 11, 144 },
    { 3, 5, 0, 0, 3, 0, 20, 0, 0, 16, 10, 11, 144 },
    { 3, 5, 0, 0, 4, 0, 20, 0, 0, 16, 10, 11, 144 },
    { 3, 5, 0, 0, 5, 0, 20, 0, 0, 16, 10, 11, 144 },
    { 3, 5, 0, 0, 6, 0, 20, 0, 0, 16, 10, 11, 144 },
    { 3, 5, 0, 0, 7, 0, 20, 0, 0, 16, 10, 11, 144 },
    { 3, 5, 0, 0, 8, 0, 20, 0, 0, 16, 10, 11, 144 },
    { 3, 5, 0, 0, 9, 0, 20, 0, 0, 16, 10, 11, 144 },
    { 5, 5, 0, 0, 1, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 2, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 3, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 4, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 5, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 6, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 7, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 8, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 9, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 18, 1, 0, 0, -1, 0, 23, 0, 0, 10, 9, 12, 156 },
    { 0, 17, 230, 5, -1, 0, 23, 0, 4, 4, 3, 21, 156 },
    { 20, 1, 0, 0, -1, 0, 23, 0, 0, 0, 0, 17, 156 },
    { 0, 17, 220, 5, -1, 0, 25, 0, 4, 4, 3, 21, 8 },
    { 18, 1, 0, 0, -1, 0, 20, 0, 0, 10, 9, 12, 147 },
    { 5, 1, 0, 0, -1, 0, 20, 0, 0, 0, 0, 12, 147 },
    { 18, 13, 0, 2, -1, 0, 20, 0, 0, 10, 9, 12, 148 },
    { 18, 13, 0, 3, -1, 0, 20, 0, 0, 10, 9, 12, 148 },
    { 18, 13, 0, 0, -1, 0, 20, 0, 0, 10, 9, 12, 148 },
    { 0, 17, 220, 5, -1, 0, 20, 0, 4, 4, 3, 21, 148 },
    { 0, 17, 230, 5, -1, 0, 20, 0, 4, 4, 3, 21, 148 },
    { 5, 13, 0, 2, -1, 0, 20, 0, 0, 0, 0, 12, 148 },
    { 5, 13, 0, 3, -1, 0, 20, 0, 0, 0, 0, 12, 148 },
    { 25, 13, 0, 0, -1, 0, 20, 0, 0, 0, 13, 12, 148 },
    { 18, 1, 0, 2, -1, 0, 24, 0, 0, 10, 9, 12, 158 },
    { 18, 1, 0, 3, -1, 0, 24, 0, 0, 10, 9, 12, 158 },
    { 0, 17, 230, 5, -1, 0, 24, 0, 4, 4, 3, 21, 158 },
    { 0, 17, 220, 5, -1, 0, 24, 0, 4, 4, 3, 21, 158 },
    { 25, 1, 0, 0, -1, 0, 24, 0, 0, 0, 13, 12, 158 },
    { 18, 1, 0, 2, -1, 0, 23, 0, 0, 10, 9, 12, 153 },
    { 18, 1, 0, 0, -1, 0, 23, 0, 0, 10, 9, 12, 153 },
    { 18, 1, 0, 3, -1, 0, 23, 0, 0, 10, 9, 12, 153 },
    { 5, 1, 0, 0, -1, 0, 23, 0, 0, 0, 0, 12, 153 },
    { 5, 1, 0, 3, -1, 0, 23, 0, 0, 0, 0, 12, 153 },
    { 5, 1, 0, 2, -1, 0, 23, 0, 0, 0, 0, 12, 153 },
    { 5, 1, 0, 4, -1, 0, 23, 0, 0, 0, 0, 12, 153 },
    { 18, 1, 0, 0, -1, 0, 21, 0, 0, 10, 9, 12, 149 },
    { 1, 0, 0, 0, -1, 0, 12, 0, 8, 4, 3, 21, 94 },
    { 0, 17, 0, 5, -1, 0, 12, 0, 4, 4, 3, 21, 94 },
    { 18, 0, 0, 0, -1, 0, 12, 0, 0, 10, 9, 12, 94 },
    { 0, 17, 9, 5, -1, 0, 12, 0, 4, 4, 3, 12, 94 },
    { 25, 0, 0, 0, -1, 0, 12, 0, 0, 0, 13, 17, 94 },
    { 25, 0, 0, 0, -1, 0, 12, 0, 0, 0, 0, 14, 94 },
    { 5, 10, 0, 0, 1, 0, 12, 0, 0, 0, 0, 14, 94 },
    { 5, 10, 0, 0, 2, 0, 12, 0, 0, 0, 0, 14, 94 },
    { 5, 10, 0, 0, 3, 0, 12, 0, 0, 0, 0, 14, 94 },
    { 5, 10, 0, 0, 4, 0, 12, 0, 0, 0, 0, 14, 94 },
    { 5, 10, 0, 0, 5, 0, 12, 0, 0, 0, 0, 14, 94 },
    { 5, 10, 0, 0, 6, 0, 12, 0, 0, 0, 0, 14, 94 },
    { 5, 10, 0, 0, 7, 0, 12, 0, 0, 0, 0, 14, 94 },
    { 5, 10, 0, 0, 8, 0, 12, 0, 0, 0, 0, 14, 94 },
    { 5, 10, 0, 0, 9, 0, 12, 0, 0, 0, 0, 14, 94 },
    { 5, 10, 0, 0, -1, 0, 12, 0, 0, 0, 0, 14, 94 },
    { 3, 0, 0, 0, 0, 0, 12, 0, 0, 16, 10, 12, 94 },
    { 3, 0, 0, 0, 1, 0, 12, 0, 0, 16, 10, 12, 94 },
    { 3, 0, 0, 0, 2, 0, 12, 0, 0, 16, 10, 12, 94 },
    { 3, 0, 0, 0, 3, 0, 12, 0, 0, 16, 10, 12, 94 },
    { 3, 0, 0, 0, 4, 0, 12, 0, 0, 16, 10, 12, 94 },
    { 3, 0, 0, 0, 5, 0, 12, 0, 0, 16, 10, 12, 94 },
    { 3, 0, 0, 0, 6, 0, 12, 0, 0, 16, 10, 12, 94 },
    { 3, 0, 0, 0, 7, 0, 12, 0, 0, 16, 10, 12, 94 },
    { 3, 0, 0, 0, 8, 0, 12, 0, 0, 16, 10, 12, 94 },
    { 3, 0, 0, 0, 9, 0, 12, 0, 0, 16, 10, 12, 94 },
    { 0, 17, 9, 5, -1, 0, 24, 0, 4, 4, 3, 21, 94 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 10, 9, 12, 94 },
    { 0, 17, 0, 5, -1, 0, 24, 0, 4, 4, 3, 21, 94 },
    { 0, 17, 9, 5, -1, 0, 16, 0, 4, 4, 3, 4, 94 },
    { 0, 17, 0, 5, -1, 0, 11, 0, 4, 4, 3, 21, 92 },
    { 1, 0, 0, 0, -1, 0, 11, 0, 8, 4, 3, 21, 92 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 92 },
    { 18, 0, 0, 0, -1, 0, 11, 17, 0, 10, 9, 12, 92 },
    { 0, 17, 9, 5, -1, 0, 11, 0, 4, 4, 3, 21, 92 },
    { 0, 17, 7, 5, -1, 0, 11, 204, 4, 4, 3, 21, 92 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 0, 12, 92 },
    { 10, 0, 0, 0, -1, 0, 11, 0, 7, 16, 10, 11, 92 },
    { 25, 0, 0, 0, -1, 0, 11, 0, 0, 0, 13, 17, 92 },
    { 0, 17, 0, 5, -1, 0, 24, 0, 4, 4, 3, 21, 92 },
    { 10, 0, 0, 0, -1, 0, 20, 0, 7, 16, 10, 11, 92 },
    { 18, 0, 0, 0, -1, 0, 13, 0, 0, 10, 9, 12, 101 },
    { 3, 0, 0, 0, 0, 0, 13, 0, 0, 16, 10, 11, 101 },
    { 3, 0, 0, 0, 1, 0, 13, 0, 0, 16, 10, 11, 101 },
    { 3, 0, 0, 0, 2, 0, 13, 0, 0, 16, 10, 11, 101 },
    { 3, 0, 0, 0, 3, 0, 13, 0, 0, 16, 10, 11, 101 },
    { 3, 0, 0, 0, 4, 0, 13, 0, 0, 16, 10, 11, 101 },
    { 3, 0, 0, 0, 5, 0, 13, 0, 0, 16, 10, 11, 101 },
    { 3, 0, 0, 0, 6, 0, 13, 0, 0, 16, 10, 11, 101 },
    { 3, 0, 0, 0, 7, 0, 13, 0, 0, 16, 10, 11, 101 },
    { 3, 0, 0, 0, 8, 0, 13, 0, 0, 16, 10, 11, 101 },
    { 3, 0, 0, 0, 9, 0, 13, 0, 0, 16, 10, 11, 101 },
    { 0, 17, 230, 5, -1, 0, 13, 0, 4, 4, 3, 21, 96 },
    { 18, 0, 0, 0, -1, 0, 13, 0, 0, 10, 9, 12, 96 },
    { 0, 17, 0, 5, -1, 0, 13, 204, 4, 4, 3, 21, 96 },
    { 0, 17, 0, 5, -1, 0, 13, 0, 4, 4, 3, 21, 96 },
    { 1, 0, 0, 0, -1, 0, 13, 0, 8, 4, 3, 21, 96 },
    { 0, 17, 0, 5, -1, 0, 13, 17, 4, 4, 3, 21, 96 },
    { 0, 17, 9, 5, -1, 0, 13, 0, 4, 4, 3, 21, 96 },
    { 3, 0, 0, 0, 0, 0, 13, 0, 0, 16, 10, 11, 96 },
    { 3, 0, 0, 0, 1, 0, 13, 0, 0, 16, 10, 11, 96 },
    { 3, 0, 0, 0, 2, 0, 13, 0, 0, 16, 10, 11, 96 },
    { 3, 0, 0, 0, 3, 0, 13, 0, 0, 16, 10, 11, 96 },
    { 3, 0, 0, 0, 4, 0, 13, 0, 0, 16, 10, 11, 96 },
    { 3, 0, 0, 0, 5, 0, 13, 0, 0, 16, 10, 11, 96 },
    { 3, 0, 0, 0, 6, 0, 13, 0, 0, 16, 10, 11, 96 },
    { 3, 0, 0, 0, 7, 0, 13, 0, 0, 16, 10, 11, 96 },
    { 3, 0, 0, 0, 8, 0, 13, 0, 0, 16, 10, 11, 96 },
    { 3, 0, 0, 0, 9, 0, 13, 0, 0, 16, 10, 11, 96 },
    { 25, 0, 0, 0, -1, 0, 13, 0, 0, 0, 0, 17, 96 },
    { 25, 0, 0, 0, -1, 0, 13, 0, 0, 0, 13, 17, 96 },
    { 18, 0, 0, 0, -1, 0, 20, 0, 0, 10, 9, 12, 96 },
    { 1, 0, 0, 0, -1, 0, 20, 0, 8, 4, 3, 21, 96 },
    { 18, 0, 0, 0, -1, 0, 23, 0, 0, 10, 9, 12, 96 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 111 },
    { 0, 17, 7, 5, -1, 0, 16, 0, 4, 4, 3, 21, 111 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 111 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 18, 111 },
    { 0, 17, 0, 5, -1, 0, 13, 0, 4, 4, 3, 21, 100 },
    { 1, 0, 0, 0, -1, 0, 13, 0, 8, 4, 3, 21, 100 },
    { 18, 0, 0, 0, -1, 0, 13, 0, 0, 10, 9, 12, 100 },
    { 1, 0, 9, 0, -1, 0, 13, 0, 8, 4, 3, 21, 100 },
    { 18, 0, 0, 0, -1, 0, 13, 0, 7, 10, 9, 12, 100 },
    { 25, 0, 0, 0, -1, 0, 13, 0, 0, 0, 13, 17, 100 },
    { 25, 0, 0, 0, -1, 0, 13, 0, 0, 0, 0, 12, 100 },
    { 25, 0, 0, 0, -1, 0, 13, 0, 0, 0, 0, 17, 100 },
    { 0, 17, 0, 5, -1, 0, 17, 0, 4, 4, 3, 21, 100 },
    { 0, 17, 7, 5, -1, 0, 17, 0, 4, 4, 3, 21, 100 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 13, 12, 100 },
    { 1, 0, 0, 0, -1, 0, 23, 0, 8, 4, 3, 21, 100 },
    { 0, 17, 0, 5, -1, 0, 23, 0, 4, 4, 3, 21, 100 },
    { 3, 0, 0, 0, 0, 0, 13, 0, 0, 16, 10, 11, 100 },
    { 3, 0, 0, 0, 1, 0, 13, 0, 0, 16, 10, 11, 100 },
    { 3, 0, 0, 0, 2, 0, 13, 0, 0, 16, 10, 11, 100 },
    { 3, 0, 0, 0, 3, 0, 13, 0, 0, 16, 10, 11, 100 },
    { 3, 0, 0, 0, 4, 0, 13, 0, 0, 16, 10, 11, 100 },
    { 3, 0, 0, 0, 5, 0, 13, 0, 0, 16, 10, 11, 100 },
    { 3, 0, 0, 0, 6, 0, 13, 0, 0, 16, 10, 11, 100 },
    { 3, 0, 0, 0, 7, 0, 13, 0, 0, 16, 10, 11, 100 },
    { 3, 0, 0, 0, 8, 0, 13, 0, 0, 16, 10, 11, 100 },
    { 3, 0, 0, 0, 9, 0, 13, 0, 0, 16, 10, 11, 100 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 100 },
    { 25, 0, 0, 0, -1, 0, 17, 0, 0, 0, 0, 18, 100 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 10, 9, 12, 100 },
    { 25, 0, 0, 0, -1, 0, 17, 0, 0, 0, 0, 17, 100 },
    { 25, 0, 0, 0, -1, 0, 17, 0, 0, 0, 13, 17, 100 },
    { 5, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 20 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 109 },
    { 1, 0, 0, 0, -1, 0, 16, 0, 8, 4, 3, 21, 109 },
    { 0, 17, 0, 5, -1, 0, 16, 0, 4, 4, 3, 21, 109 },
    { 1, 0, 9, 0, -1, 0, 16, 0, 8, 4, 3, 21, 109 },
    { 0, 17, 7, 5, -1, 0, 16, 0, 4, 4, 3, 21, 109 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 13, 17, 109 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 109 },
    { 0, 17, 0, 5, -1, 0, 18, 0, 4, 4, 3, 21, 109 },
    { 18, 0, 0, 0, -1, 0, 25, 0, 0, 10, 9, 12, 109 },
    { 0, 17, 0, 5, -1, 0, 25, 0, 4, 4, 3, 21, 109 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 10, 9, 12, 129 },
    { 25, 0, 0, 0, -1, 0, 17, 0, 0, 0, 13, 17, 129 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 123 },
    { 0, 17, 0, 5, -1, 0, 16, 0, 4, 4, 3, 21, 123 },
    { 1, 0, 0, 0, -1, 0, 16, 0, 8, 4, 3, 21, 123 },
    { 0, 17, 7, 5, -1, 0, 16, 0, 4, 4, 3, 21, 123 },
    { 0, 17, 9, 5, -1, 0, 16, 0, 4, 4, 3, 21, 123 },
    { 3, 0, 0, 0, 0, 0, 16, 0, 0, 16, 10, 11, 123 },
    { 3, 0, 0, 0, 1, 0, 16, 0, 0, 16, 10, 11, 123 },
    { 3, 0, 0, 0, 2, 0, 16, 0, 0, 16, 10, 11, 123 },
    { 3, 0, 0, 0, 3, 0, 16, 0, 0, 16, 10, 11, 123 },
    { 3, 0, 0, 0, 4, 0, 16, 0, 0, 16, 10, 11, 123 },
    { 3, 0, 0, 0, 5, 0, 16, 0, 0, 16, 10, 11, 123 },
    { 3, 0, 0, 0, 6, 0, 16, 0, 0, 16, 10, 11, 123 },
    { 3, 0, 0, 0, 7, 0, 16, 0, 0, 16, 10, 11, 123 },
    { 3, 0, 0, 0, 8, 0, 16, 0, 0, 16, 10, 11, 123 },
    { 3, 0, 0, 0, 9, 0, 16, 0, 0, 16, 10, 11, 123 },
    { 0, 17, 0, 5, -1, 0, 17, 0, 4, 4, 3, 21, 107 },
    { 0, 17, 0, 5, -1, 0, 16, 0, 4, 4, 3, 21, 107 },
    { 1, 0, 0, 0, -1, 0, 16, 0, 8, 4, 3, 21, 107 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 107 },
    { 0, 17, 7, 5, -1, 0, 20, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 7, 5, -1, 0, 16, 0, 4, 4, 3, 21, 107 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 17, 107 },
    { 1, 0, 0, 0, -1, 0, 16, 204, 4, 4, 3, 21, 107 },
    { 1, 0, 0, 0, -1, 0, 16, 17, 8, 4, 3, 21, 107 },
    { 1, 0, 9, 0, -1, 0, 16, 0, 8, 4, 3, 12, 107 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 10, 9, 12, 107 },
    { 0, 17, 230, 5, -1, 0, 16, 0, 4, 4, 3, 21, 107 },
    { 18, 0, 0, 0, -1, 0, 18, 0, 0, 10, 9, 12, 135 },
    { 1, 0, 0, 0, -1, 0, 18, 0, 8, 4, 3, 21, 135 },
    { 0, 17, 0, 5, -1, 0, 18, 0, 4, 4, 3, 21, 135 },
    { 0, 17, 9, 5, -1, 0, 18, 0, 4, 4, 3, 21, 135 },
    { 0, 17, 7, 5, -1, 0, 18, 0, 4, 4, 3, 21, 135 },
    { 25, 0, 0, 0, -1, 0, 18, 0, 0, 0, 13, 17, 135 },
    { 25, 0, 0, 0, -1, 0, 18, 0, 0, 0, 0, 17, 135 },
    { 25, 0, 0, 0, -1, 0, 18, 0, 0, 0, 0, 12, 135 },
    { 3, 0, 0, 0, 0, 0, 18, 0, 0, 16, 10, 11, 135 },
    { 3, 0, 0, 0, 1, 0, 18, 0, 0, 16, 10, 11, 135 },
    { 3, 0, 0, 0, 2, 0, 18, 0, 0, 16, 10, 11, 135 },
    { 3, 0, 0, 0, 3, 0, 18, 0, 0, 16, 10, 11, 135 },
    { 3, 0, 0, 0, 4, 0, 18, 0, 0, 16, 10, 11, 135 },
    { 3, 0, 0, 0, 5, 0, 18, 0, 0, 16, 10, 11, 135 },
    { 3, 0, 0, 0, 6, 0, 18, 0, 0, 16, 10, 11, 135 },
    { 3, 0, 0, 0, 7, 0, 18, 0, 0, 16, 10, 11, 135 },
    { 3, 0, 0, 0, 8, 0, 18, 0, 0, 16, 10, 11, 135 },
    { 3, 0, 0, 0, 9, 0, 18, 0, 0, 16, 10, 11, 135 },
    { 25, 0, 0, 0, -1, 0, 23, 0, 0, 0, 0, 17, 135 },
    { 0, 17, 230, 5, -1, 0, 20, 0, 4, 4, 3, 21, 135 },
    { 18, 0, 0, 0, -1, 0, 21, 0, 0, 10, 9, 12, 135 },
    { 18, 0, 0, 0, -1, 0, 23, 0, 0, 10, 9, 12, 135 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 124 },
    { 1, 0, 0, 0, -1, 0, 16, 204, 4, 4, 3, 21, 124 },
    { 1, 0, 0, 0, -1, 0, 16, 0, 8, 4, 3, 21, 124 },
    { 0, 17, 0, 5, -1, 0, 16, 0, 4, 4, 3, 21, 124 },
    { 0, 17, 0, 5, -1, 0, 16, 204, 4, 4, 3, 21, 124 },
    { 1, 0, 0, 0, -1, 0, 16, 17, 8, 4, 3, 21, 124 },
    { 0, 17, 9, 5, -1, 0, 16, 0, 4, 4, 3, 21, 124 },
    { 0, 17, 7, 5, -1, 0, 16, 0, 4, 4, 3, 21, 124 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 124 },
    { 3, 0, 0, 0, 0, 0, 16, 0, 0, 16, 10, 11, 124 },
    { 3, 0, 0, 0, 1, 0, 16, 0, 0, 16, 10, 11, 124 },
    { 3, 0, 0, 0, 2, 0, 16, 0, 0, 16, 10, 11, 124 },
    { 3, 0, 0, 0, 3, 0, 16, 0, 0, 16, 10, 11, 124 },
    { 3, 0, 0, 0, 4, 0, 16, 0, 0, 16, 10, 11, 124 },
    { 3, 0, 0, 0, 5, 0, 16, 0, 0, 16, 10, 11, 124 },
    { 3, 0, 0, 0, 6, 0, 16, 0, 0, 16, 10, 11, 124 },
    { 3, 0, 0, 0, 7, 0, 16, 0, 0, 16, 10, 11, 124 },
    { 3, 0, 0, 0, 8, 0, 16, 0, 0, 16, 10, 11, 124 },
    { 3, 0, 0, 0, 9, 0, 16, 0, 0, 16, 10, 11, 124 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 122 },
    { 1, 0, 0, 0, -1, 0, 16, 204, 4, 4, 3, 21, 122 },
    { 1, 0, 0, 0, -1, 0, 16, 0, 8, 4, 3, 21, 122 },
    { 0, 17, 0, 5, -1, 0, 16, 0, 4, 4, 3, 21, 122 },
    { 1, 0, 0, 0, -1, 0, 16, 17, 8, 4, 3, 21, 122 },
    { 0, 17, 9, 5, -1, 0, 16, 0, 4, 4, 3, 21, 122 },
    { 0, 17, 7, 5, -1, 0, 16, 0, 4, 4, 3, 21, 122 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 18, 122 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 13, 17, 122 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 6, 122 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 122 },
    { 25, 0, 0, 0, -1, 0, 17, 0, 0, 0, 13, 17, 122 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 10, 9, 12, 122 },
    { 0, 17, 0, 5, -1, 0, 17, 0, 4, 4, 3, 21, 122 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 114 },
    { 1, 0, 0, 0, -1, 0, 16, 0, 8, 4, 3, 21, 114 },
    { 0, 17, 0, 5, -1, 0, 16, 0, 4, 4, 3, 21, 114 },
    { 0, 17, 9, 5, -1, 0, 16, 0, 4, 4, 3, 21, 114 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 13, 17, 114 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 114 },
    { 3, 0, 0, 0, 0, 0, 16, 0, 0, 16, 10, 11, 114 },
    { 3, 0, 0, 0, 1, 0, 16, 0, 0, 16, 10, 11, 114 },
    { 3, 0, 0, 0, 2, 0, 16, 0, 0, 16, 10, 11, 114 },
    { 3, 0, 0, 0, 3, 0, 16, 0, 0, 16, 10, 11, 114 },
    { 3, 0, 0, 0, 4, 0, 16, 0, 0, 16, 10, 11, 114 },
    { 3, 0, 0, 0, 5, 0, 16, 0, 0, 16, 10, 11, 114 },
    { 3, 0, 0, 0, 6, 0, 16, 0, 0, 16, 10, 11, 114 },
    { 3, 0, 0, 0, 7, 0, 16, 0, 0, 16, 10, 11, 114 },
    { 3, 0, 0, 0, 8, 0, 16, 0, 0, 16, 10, 11, 114 },
    { 3, 0, 0, 0, 9, 0, 16, 0, 0, 16, 10, 11, 114 },
    { 25, 10, 0, 0, -1, 0, 18, 0, 0, 0, 0, 18, 33 },
    { 18, 0, 0, 0, -1, 0, 13, 0, 0, 10, 9, 12, 102 },
    { 0, 17, 0, 5, -1, 0, 13, 0, 4, 4, 3, 21, 102 },
    { 1, 0, 0, 0, -1, 0, 13, 0, 8, 4, 3, 21, 102 },
    { 1, 0, 9, 0, -1, 0, 13, 0, 8, 4, 3, 21, 102 },
    { 0, 17, 7, 5, -1, 0, 13, 0, 4, 4, 3, 21, 102 },
    { 18, 0, 0, 0, -1, 0, 21, 0, 0, 10, 9, 12, 102 },
    { 25, 0, 0, 0, -1, 0, 24, 0, 0, 0, 0, 12, 102 },
    { 3, 0, 0, 0, 0, 0, 13, 0, 0, 16, 10, 11, 102 },
    { 3, 0, 0, 0, 1, 0, 13, 0, 0, 16, 10, 11, 102 },
    { 3, 0, 0, 0, 2, 0, 13, 0, 0, 16, 10, 11, 102 },
    { 3, 0, 0, 0, 3, 0, 13, 0, 0, 16, 10, 11, 102 },
    { 3, 0, 0, 0, 4, 0, 13, 0, 0, 16, 10, 11, 102 },
    { 3, 0, 0, 0, 5, 0, 13, 0, 0, 16, 10, 11, 102 },
    { 3, 0, 0, 0, 6, 0, 13, 0, 0, 16, 10, 11, 102 },
    { 3, 0, 0, 0, 7, 0, 13, 0, 0, 16, 10, 11, 102 },
    { 3, 0, 0, 0, 8, 0, 13, 0, 0, 16, 10, 11, 102 },
    { 3, 0, 0, 0, 9, 0, 13, 0, 0, 16, 10, 11, 102 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 0, 9, 33, 126 },
    { 18, 0, 0, 0, -1, 0, 20, 0, 0, 0, 9, 33, 126 },
    { 0, 17, 0, 5, -1, 0, 17, 0, 4, 4, 3, 33, 126 },
    { 1, 0, 0, 0, -1, 0, 17, 0, 0, 4, 3, 33, 126 },
    { 1, 0, 0, 0, -1, 0, 17, 0, 8, 4, 3, 33, 126 },
    { 0, 17, 9, 5, -1, 0, 17, 0, 4, 4, 3, 33, 126 },
    { 3, 0, 0, 0, 0, 0, 17, 0, 0, 16, 10, 11, 126 },
    { 3, 0, 0, 0, 1, 0, 17, 0, 0, 16, 10, 11, 126 },
    { 3, 0, 0, 0, 2, 0, 17, 0, 0, 16, 10, 11, 126 },
    { 3, 0, 0, 0, 3, 0, 17, 0, 0, 16, 10, 11, 126 },
    { 3, 0, 0, 0, 4, 0, 17, 0, 0, 16, 10, 11, 126 },
    { 3, 0, 0, 0, 5, 0, 17, 0, 0, 16, 10, 11, 126 },
    { 3, 0, 0, 0, 6, 0, 17, 0, 0, 16, 10, 11, 126 },
    { 3, 0, 0, 0, 7, 0, 17, 0, 0, 16, 10, 11, 126 },
    { 3, 0, 0, 0, 8, 0, 17, 0, 0, 16, 10, 11, 126 },
    { 3, 0, 0, 0, 9, 0, 17, 0, 0, 16, 10, 11, 126 },
    { 5, 0, 0, 0, -1, 0, 17, 0, 0, 0, 0, 33, 126 },
    { 25, 0, 0, 0, -1, 0, 17, 0, 0, 0, 13, 17, 126 },
    { 29, 0, 0, 0, -1, 0, 17, 0, 0, 0, 0, 33, 126 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 0, 9, 33, 126 },
    { 18, 0, 0, 0, -1, 0, 20, 0, 0, 10, 9, 12, 142 },
    { 1, 0, 0, 0, -1, 0, 20, 0, 8, 4, 3, 21, 142 },
    { 0, 17, 0, 5, -1, 0, 20, 0, 4, 4, 3, 21, 142 },
    { 0, 17, 9, 5, -1, 0, 20, 0, 4, 4, 3, 21, 142 },
    { 0, 17, 7, 5, -1, 0, 20, 0, 4, 4, 3, 21, 142 },
    { 25, 0, 0, 0, -1, 0, 20, 0, 0, 0, 0, 12, 142 },
    { 14, 0, 0, 0, -1, 0, 16, 0, 0, 10, 8, 12, 125 },
    { 15, 0, 0, 0, -1, 0, 16, 0, 0, 10, 7, 12, 125 },
    { 3, 0, 0, 0, 0, 0, 16, 0, 0, 16, 10, 11, 125 },
    { 3, 0, 0, 0, 1, 0, 16, 0, 0, 16, 10, 11, 125 },
    { 3, 0, 0, 0, 2, 0, 16, 0, 0, 16, 10, 11, 125 },
    { 3, 0, 0, 0, 3, 0, 16, 0, 0, 16, 10, 11, 125 },
    { 3, 0, 0, 0, 4, 0, 16, 0, 0, 16, 10, 11, 125 },
    { 3, 0, 0, 0, 5, 0, 16, 0, 0, 16, 10, 11, 125 },
    { 3, 0, 0, 0, 6, 0, 16, 0, 0, 16, 10, 11, 125 },
    { 3, 0, 0, 0, 7, 0, 16, 0, 0, 16, 10, 11, 125 },
    { 3, 0, 0, 0, 8, 0, 16, 0, 0, 16, 10, 11, 125 },
    { 3, 0, 0, 0, 9, 0, 16, 0, 0, 16, 10, 11, 125 },
    { 5, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 125 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 125 },
    { 18, 0, 0, 0, -1, 0, 23, 0, 0, 10, 9, 12, 154 },
    { 1, 0, 0, 0, -1, 0, 23, 204, 4, 4, 3, 21, 154 },
    { 1, 0, 0, 0, -1, 0, 23, 0, 8, 4, 3, 21, 154 },
    { 1, 0, 0, 0, -1, 0, 23, 17, 8, 4, 3, 21, 154 },
    { 0, 17, 0, 5, -1, 0, 23, 0, 4, 4, 3, 21, 154 },
    { 1, 0, 9, 0, -1, 0, 23, 0, 8, 4, 3, 21, 154 },
    { 0, 17, 9, 5, -1, 0, 23, 0, 4, 4, 3, 12, 154 },
    { 18, 0, 0, 0, -1, 0, 23, 0, 7, 10, 9, 12, 154 },
    { 0, 17, 7, 5, -1, 0, 23, 0, 4, 4, 3, 21, 154 },
    { 25, 0, 0, 0, -1, 0, 23, 0, 0, 0, 13, 17, 154 },
    { 25, 0, 0, 0, -1, 0, 23, 0, 0, 0, 0, 17, 154 },
    { 3, 0, 0, 0, 0, 0, 23, 0, 0, 16, 10, 14, 154 },
    { 3, 0, 0, 0, 1, 0, 23, 0, 0, 16, 10, 14, 154 },
    { 3, 0, 0, 0, 2, 0, 23, 0, 0, 16, 10, 14, 154 },
    { 3, 0, 0, 0, 3, 0, 23, 0, 0, 16, 10, 14, 154 },
    { 3, 0, 0, 0, 4, 0, 23, 0, 0, 16, 10, 14, 154 },
    { 3, 0, 0, 0, 5, 0, 23, 0, 0, 16, 10, 14, 154 },
    { 3, 0, 0, 0, 6, 0, 23, 0, 0, 16, 10, 14, 154 },
    { 3, 0, 0, 0, 7, 0, 23, 0, 0, 16, 10, 14, 154 },
    { 3, 0, 0, 0, 8, 0, 23, 0, 0, 16, 10, 14, 154 },
    { 3, 0, 0, 0, 9, 0, 23, 0, 0, 16, 10, 14, 154 },
    { 18, 0, 0, 0, -1, 0, 21, 0, 0, 10, 9, 12, 150 },
    { 1, 0, 0, 0, -1, 0, 21, 0, 8, 4, 3, 21, 150 },
    { 0, 17, 0, 5, -1, 0, 21, 0, 4, 4, 3, 21, 150 },
    { 0, 17, 9, 5, -1, 0, 21, 0, 4, 4, 3, 21, 150 },
    { 25, 0, 0, 0, -1, 0, 21, 0, 0, 0, 0, 18, 150 },
    { 18, 0, 0, 0, -1, 0, 19, 0, 0, 10, 9, 12, 141 },
    { 0, 17, 0, 5, -1, 0, 19, 0, 4, 4, 3, 21, 141 },
    { 0, 0, 0, 5, -1, 0, 19, 0, 4, 4, 3, 21, 141 },
    { 0, 17, 9, 5, -1, 0, 19, 0, 4, 4, 3, 21, 141 },
    { 1, 0, 0, 0, -1, 0, 19, 0, 8, 4, 3, 21, 141 },
    { 18, 0, 0, 0, -1, 0, 19, 0, 7, 10, 9, 12, 141 },
    { 25, 0, 0, 0, -1, 0, 19, 0, 0, 0, 0, 18, 141 },
    { 25, 0, 0, 0, -1, 0, 19, 0, 0, 0, 0, 12, 141 },
    { 25, 0, 0, 0, -1, 0, 19, 0, 0, 0, 0, 17, 141 },
    { 25, 0, 0, 0, -1, 0, 19, 0, 0, 0, 13, 17, 141 },
    { 18, 0, 0, 0, -1, 0, 19, 0, 0, 10, 9, 12, 140 },
    { 0, 17, 0, 5, -1, 0, 19, 0, 4, 4, 3, 21, 140 },
    { 1, 0, 0, 0, -1, 0, 19, 0, 8, 4, 3, 21, 140 },
    { 18, 0, 0, 0, -1, 0, 21, 0, 7, 10, 9, 12, 140 },
    { 18, 0, 0, 0, -1, 0, 19, 0, 7, 10, 9, 12, 140 },
    { 0, 17, 9, 5, -1, 0, 19, 0, 4, 4, 3, 21, 140 },
    { 25, 0, 0, 0, -1, 0, 19, 0, 0, 0, 0, 17, 140 },
    { 25, 0, 0, 0, -1, 0, 19, 0, 0, 0, 13, 17, 140 },
    { 18, 0, 0, 0, -1, 0, 20, 0, 0, 10, 9, 12, 140 },
    { 25, 0, 0, 0, -1, 0, 19, 0, 0, 0, 0, 18, 140 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 10, 9, 12, 29 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 119 },
    { 25, 0, 0, 0, -1, 0, 25, 0, 0, 0, 0, 18, 11 },
    { 18, 0, 0, 0, -1, 0, 18, 0, 0, 10, 9, 12, 133 },
    { 1, 0, 0, 0, -1, 0, 18, 0, 8, 4, 3, 21, 133 },
    { 0, 17, 0, 5, -1, 0, 18, 0, 4, 4, 3, 21, 133 },
    { 0, 0, 9, 5, -1, 0, 18, 0, 4, 4, 3, 21, 133 },
    { 25, 0, 0, 0, -1, 0, 18, 0, 0, 0, 13, 17, 133 },
    { 25, 0, 0, 0, -1, 0, 18, 0, 0, 0, 0, 17, 133 },
    { 3, 0, 0, 0, 0, 0, 18, 0, 0, 16, 10, 11, 133 },
    { 3, 0, 0, 0, 1, 0, 18, 0, 0, 16, 10, 11, 133 },
    { 3, 0, 0, 0, 2, 0, 18, 0, 0, 16, 10, 11, 133 },
    { 3, 0, 0, 0, 3, 0, 18, 0, 0, 16, 10, 11, 133 },
    { 3, 0, 0, 0, 4, 0, 18, 0, 0, 16, 10, 11, 133 },
    { 3, 0, 0, 0, 5, 0, 18, 0, 0, 16, 10, 11, 133 },
    { 3, 0, 0, 0, 6, 0, 18, 0, 0, 16, 10, 11, 133 },
    { 3, 0, 0, 0, 7, 0, 18, 0, 0, 16, 10, 11, 133 },
    { 3, 0, 0, 0, 8, 0, 18, 0, 0, 16, 10, 11, 133 },
    { 3, 0, 0, 0, 9, 0, 18, 0, 0, 16, 10, 11, 133 },
    { 5, 0, 0, 0, -1, 0, 18, 0, 0, 0, 0, 12, 133 },
    { 25, 0, 0, 0, -1, 0, 18, 0, 0, 0, 0, 18, 134 },
    { 25, 0, 0, 0, -1, 0, 18, 0, 0, 0, 0, 6, 134 },
    { 18, 0, 0, 0, -1, 0, 18, 0, 0, 10, 9, 12, 134 },
    { 0, 17, 0, 5, -1, 0, 18, 0, 4, 4, 3, 21, 134 },
    { 1, 0, 0, 0, -1, 0, 18, 0, 8, 4, 3, 21, 134 },
    { 18, 0, 0, 0, -1, 0, 19, 0, 0, 10, 9, 12, 138 },
    { 0, 17, 0, 5, -1, 0, 19, 0, 4, 4, 3, 21, 138 },
    { 0, 17, 7, 5, -1, 0, 19, 0, 4, 4, 3, 21, 138 },
    { 0, 17, 9, 5, -1, 0, 19, 0, 4, 4, 3, 21, 138 },
    { 18, 0, 0, 0, -1, 0, 19, 0, 7, 10, 9, 12, 138 },
    { 3, 0, 0, 0, 0, 0, 19, 0, 0, 16, 10, 11, 138 },
    { 3, 0, 0, 0, 1, 0, 19, 0, 0, 16, 10, 11, 138 },
    { 3, 0, 0, 0, 2, 0, 19, 0, 0, 16, 10, 11, 138 },
    { 3, 0, 0, 0, 3, 0, 19, 0, 0, 16, 10, 11, 138 },
    { 3, 0, 0, 0, 4, 0, 19, 0, 0, 16, 10, 11, 138 },
    { 3, 0, 0, 0, 5, 0, 19, 0, 0, 16, 10, 11, 138 },
    { 3, 0, 0, 0, 6, 0, 19, 0, 0, 16, 10, 11, 138 },
    { 3, 0, 0, 0, 7, 0, 19, 0, 0, 16, 10, 11, 138 },
    { 3, 0, 0, 0, 8, 0, 19, 0, 0, 16, 10, 11, 138 },
    { 3, 0, 0, 0, 9, 0, 19, 0, 0, 16, 10, 11, 138 },
    { 18, 0, 0, 0, -1, 0, 20, 0, 0, 10, 9, 12, 143 },
    { 1, 0, 0, 0, -1, 0, 20, 0, 8, 4, 3, 21, 143 },
    { 0, 17, 0, 5, -1, 0, 20, 0, 4, 4, 3, 21, 143 },
    { 0, 17, 9, 5, -1, 0, 20, 0, 4, 4, 3, 21, 143 },
    { 3, 0, 0, 0, 0, 0, 20, 0, 0, 16, 10, 11, 143 },
    { 3, 0, 0, 0, 1, 0, 20, 0, 0, 16, 10, 11, 143 },
    { 3, 0, 0, 0, 2, 0, 20, 0, 0, 16, 10, 11, 143 },
    { 3, 0, 0, 0, 3, 0, 20, 0, 0, 16, 10, 11, 143 },
    { 3, 0, 0, 0, 4, 0, 20, 0, 0, 16, 10, 11, 143 },
    { 3, 0, 0, 0, 5, 0, 20, 0, 0, 16, 10, 11, 143 },
    { 3, 0, 0, 0, 6, 0, 20, 0, 0, 16, 10, 11, 143 },
    { 3, 0, 0, 0, 7, 0, 20, 0, 0, 16, 10, 11, 143 },
    { 3, 0, 0, 0, 8, 0, 20, 0, 0, 16, 10, 11, 143 },
    { 3, 0, 0, 0, 9, 0, 20, 0, 0, 16, 10, 11, 143 },
    { 18, 0, 0, 0, -1, 0, 20, 0, 0, 10, 9, 12, 145 },
    { 18, 0, 0, 0, -1, 0, 20, 0, 0, 10, 9, 17, 145 },
    { 0, 17, 0, 5, -1, 0, 20, 0, 4, 4, 3, 21, 145 },
    { 1, 0, 0, 0, -1, 0, 20, 0, 8, 4, 3, 21, 145 },
    { 25, 0, 0, 0, -1, 0, 20, 0, 0, 0, 13, 17, 145 },
    { 0, 17, 0, 5, -1, 0, 25, 0, 4, 4, 3, 21, 162 },
    { 18, 0, 0, 0, -1, 0, 25, 0, 7, 10, 9, 12, 162 },
    { 1, 0, 0, 0, -1, 0, 25, 0, 8, 4, 3, 21, 162 },
    { 18, 0, 0, 0, -1, 0, 25, 0, 0, 10, 9, 12, 162 },
    { 1, 0, 9, 0, -1, 0, 25, 0, 8, 4, 3, 21, 162 },
    { 0, 17, 9, 5, -1, 0, 25, 0, 4, 4, 3, 12, 162 },
    { 25, 0, 0, 0, -1, 0, 25, 0, 0, 0, 13, 17, 162 },
    { 25, 0, 0, 0, -1, 0, 25, 0, 0, 0, 0, 14, 162 },
    { 3, 0, 0, 0, 0, 0, 25, 0, 0, 16, 10, 12, 162 },
    { 3, 0, 0, 0, 1, 0, 25, 0, 0, 16, 10, 12, 162 },
    { 3, 0, 0, 0, 2, 0, 25, 0, 0, 16, 10, 12, 162 },
    { 3, 0, 0, 0, 3, 0, 25, 0, 0, 16, 10, 12, 162 },
    { 3, 0, 0, 0, 4, 0, 25, 0, 0, 16, 10, 12, 162 },
    { 3, 0, 0, 0, 5, 0, 25, 0, 0, 16, 10, 12, 162 },
    { 3, 0, 0, 0, 6, 0, 25, 0, 0, 16, 10, 12, 162 },
    { 3, 0, 0, 0, 7, 0, 25, 0, 0, 16, 10, 12, 162 },
    { 3, 0, 0, 0, 8, 0, 25, 0, 0, 16, 10, 12, 162 },
    { 3, 0, 0, 0, 9, 0, 25, 0, 0, 16, 10, 12, 162 },
    { 18, 0, 0, 0, -1, 0, 23, 0, 0, 10, 9, 12, 83 },
    { 5, 0, 0, 0, -1, 0, 21, 0, 0, 0, 0, 12, 16 },
    { 29, 10, 0, 0, -1, 0, 21, 0, 0, 0, 0, 12, 16 },
    { 27, 4, 0, 0, -1, 0, 21, 0, 0, 0, 0, 10, 16 },
    { 25, 0, 0, 0, -1, 0, 21, 0, 0, 0, 0, 17, 16 },
    { 18, 0, 0, 0, -1, 0, 9, 0, 0, 10, 9, 12, 63 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 63 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 10, 9, 12, 63 },
    { 4, 0, 0, 0, -1, 0, 9, 0, 0, 10, 9, 12, 63 },
    { 4, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 63 },
    { 25, 0, 0, 0, -1, 0, 9, 0, 0, 0, 0, 17, 63 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 17, 63 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 10, 9, 12, 157 },
    { 25, 0, 0, 0, -1, 0, 24, 0, 0, 0, 0, 12, 157 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 10, 9, 12, 81 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 10, 9, 0, 81 },
    { 18, 0, 0, 0, -1, 0, 11, 0, 0, 10, 9, 1, 81 },
    { 18, 0, 0, 0, -1, 0, 25, 0, 0, 10, 9, 0, 81 },
    { 10, 0, 0, 5, -1, 0, 21, 0, 3, 6, 5, 4, 81 },
    { 10, 0, 0, 5, -1, 0, 21, 0, 3, 6, 5, 0, 81 },
    { 10, 0, 0, 5, -1, 0, 21, 0, 3, 6, 5, 1, 81 },
    { 10, 0, 0, 5, -1, 0, 25, 0, 3, 6, 5, 4, 81 },
    { 10, 0, 0, 5, -1, 0, 25, 0, 3, 6, 5, 0, 81 },
    { 10, 0, 0, 5, -1, 0, 25, 0, 3, 6, 5, 1, 81 },
    { 0, 17, 0, 5, -1, 0, 25, 0, 4, 4, 3, 21, 81 },
    { 18, 0, 0, 0, -1, 0, 25, 0, 0, 10, 9, 12, 81 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 10, 9, 12, 127 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 10, 9, 0, 127 },
    { 18, 0, 0, 0, -1, 0, 17, 0, 0, 10, 9, 1, 127 },
    { 18, 0, 0, 0, -1, 0, 12, 0, 0, 10, 9, 12, 84 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 115 },
    { 3, 0, 0, 0, 0, 0, 16, 0, 0, 16, 10, 11, 115 },
    { 3, 0, 0, 0, 1, 0, 16, 0, 0, 16, 10, 11, 115 },
    { 3, 0, 0, 0, 2, 0, 16, 0, 0, 16, 10, 11, 115 },
    { 3, 0, 0, 0, 3, 0, 16, 0, 0, 16, 10, 11, 115 },
    { 3, 0, 0, 0, 4, 0, 16, 0, 0, 16, 10, 11, 115 },
    { 3, 0, 0, 0, 5, 0, 16, 0, 0, 16, 10, 11, 115 },
    { 3, 0, 0, 0, 6, 0, 16, 0, 0, 16, 10, 11, 115 },
    { 3, 0, 0, 0, 7, 0, 16, 0, 0, 16, 10, 11, 115 },
    { 3, 0, 0, 0, 8, 0, 16, 0, 0, 16, 10, 11, 115 },
    { 3, 0, 0, 0, 9, 0, 16, 0, 0, 16, 10, 11, 115 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 13, 17, 115 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 10, 9, 12, 159 },
    { 3, 0, 0, 0, 0, 0, 24, 0, 0, 16, 10, 11, 159 },
    { 3, 0, 0, 0, 1, 0, 24, 0, 0, 16, 10, 11, 159 },
    { 3, 0, 0, 0, 2, 0, 24, 0, 0, 16, 10, 11, 159 },
    { 3, 0, 0, 0, 3, 0, 24, 0, 0, 16, 10, 11, 159 },
    { 3, 0, 0, 0, 4, 0, 24, 0, 0, 16, 10, 11, 159 },
    { 3, 0, 0, 0, 5, 0, 24, 0, 0, 16, 10, 11, 159 },
    { 3, 0, 0, 0, 6, 0, 24, 0, 0, 16, 10, 11, 159 },
    { 3, 0, 0, 0, 7, 0, 24, 0, 0, 16, 10, 11, 159 },
    { 3, 0, 0, 0, 8, 0, 24, 0, 0, 16, 10, 11, 159 },
    { 3, 0, 0, 0, 9, 0, 24, 0, 0, 16, 10, 11, 159 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 104 },
    { 0, 17, 1, 5, -1, 0, 16, 0, 4, 4, 3, 21, 104 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 13, 17, 104 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 108 },
    { 0, 17, 230, 5, -1, 0, 16, 0, 4, 4, 3, 21, 108 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 13, 17, 108 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 17, 108 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 108 },
    { 29, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 108 },
    { 17, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 108 },
    { 3, 0, 0, 0, 0, 0, 16, 0, 0, 16, 10, 11, 108 },
    { 3, 0, 0, 0, 1, 0, 16, 0, 0, 16, 10, 11, 108 },
    { 3, 0, 0, 0, 2, 0, 16, 0, 0, 16, 10, 11, 108 },
    { 3, 0, 0, 0, 3, 0, 16, 0, 0, 16, 10, 11, 108 },
    { 3, 0, 0, 0, 4, 0, 16, 0, 0, 16, 10, 11, 108 },
    { 3, 0, 0, 0, 5, 0, 16, 0, 0, 16, 10, 11, 108 },
    { 3, 0, 0, 0, 6, 0, 16, 0, 0, 16, 10, 11, 108 },
    { 3, 0, 0, 0, 7, 0, 16, 0, 0, 16, 10, 11, 108 },
    { 3, 0, 0, 0, 8, 0, 16, 0, 0, 16, 10, 11, 108 },
    { 3, 0, 0, 0, 9, 0, 16, 0, 0, 16, 10, 11, 108 },
    { 5, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 108 },
    { 14, 0, 0, 0, -1, 0, 20, 0, 0, 10, 8, 12, 146 },
    { 15, 0, 0, 0, -1, 0, 20, 0, 0, 10, 7, 12, 146 },
    { 5, 0, 0, 0, -1, 0, 20, 0, 0, 0, 0, 12, 146 },
    { 25, 0, 0, 0, -1, 0, 20, 0, 0, 0, 0, 17, 146 },
    { 25, 0, 0, 0, -1, 0, 20, 0, 0, 0, 13, 17, 146 },
    { 25, 0, 0, 0, -1, 0, 20, 0, 0, 0, 0, 12, 146 },
    { 18, 0, 0, 0, -1, 0, 13, 0, 0, 10, 9, 12, 99 },
    { 18, 0, 0, 0, -1, 0, 21, 0, 0, 10, 9, 12, 99 },
    { 0, 17, 0, 5, -1, 0, 21, 0, 4, 4, 3, 21, 99 },
    { 1, 0, 0, 0, -1, 0, 13, 0, 8, 4, 3, 21, 99 },
    { 1, 0, 0, 0, -1, 0, 21, 0, 8, 4, 3, 21, 99 },
    { 0, 17, 0, 5, -1, 0, 13, 0, 4, 4, 3, 21, 99 },
    { 17, 0, 0, 0, -1, 0, 13, 0, 0, 10, 9, 12, 99 },
    { 17, 0, 0, 0, -1, 0, 18, 0, 0, 10, 9, 5, 137 },
    { 17, 0, 0, 0, -1, 0, 19, 0, 0, 10, 9, 5, 139 },
    { 25, 10, 0, 0, -1, 0, 21, 0, 0, 0, 0, 5, 37 },
    { 17, 0, 0, 0, -1, 0, 21, 0, 0, 10, 9, 5, 37 },
    { 0, 17, 0, 5, -1, 0, 23, 0, 4, 4, 3, 4, 155 },
    { 1, 0, 6, 0, -1, 0, 23, 0, 8, 4, 3, 21, 37 },
    { 18, 0, 0, 0, -1, 0, 18, 0, 0, 0, 9, 14, 137 },
    { 18, 0, 0, 0, -1, 0, 20, 0, 0, 0, 9, 14, 137 },
    { 18, 0, 0, 0, -1, 0, 21, 0, 0, 0, 9, 14, 137 },
    { 18, 0, 0, 0, -1, 0, 23, 0, 0, 0, 9, 14, 137 },
    { 18, 0, 0, 0, -1, 0, 23, 0, 0, 0, 9, 12, 155 },
    { 17, 0, 0, 0, -1, 0, 24, 0, 0, 8, 9, 12, 35 },
    { 18, 0, 0, 0, -1, 0, 12, 0, 0, 8, 9, 14, 35 },
    { 18, 0, 0, 0, -1, 0, 12, 0, 0, 0, 9, 14, 34 },
    { 18, 0, 0, 0, -1, 0, 19, 0, 0, 0, 9, 14, 34 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 0, 9, 14, 34 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 8, 9, 14, 35 },
    { 18, 0, 0, 0, -1, 0, 25, 0, 0, 0, 9, 5, 34 },
    { 18, 0, 0, 0, -1, 0, 21, 0, 0, 0, 9, 5, 34 },
    { 18, 0, 0, 0, -1, 0, 25, 0, 0, 8, 9, 5, 35 },
    { 18, 0, 0, 0, -1, 0, 21, 0, 0, 8, 9, 5, 35 },
    { 18, 0, 0, 0, -1, 0, 19, 0, 0, 0, 9, 14, 139 },
    { 18, 0, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 105 },
    { 29, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 105 },
    { 0, 17, 0, 5, -1, 0, 16, 0, 4, 4, 3, 21, 105 },
    { 0, 17, 1, 5, -1, 0, 16, 0, 4, 4, 3, 21, 105 },
    { 25, 0, 0, 0, -1, 0, 16, 0, 0, 0, 13, 17, 105 },
    { 10, 18, 0, 5, -1, 0, 16, 0, 3, 6, 5, 21, 2 },
    { 0, 17, 0, 5, -1, 0, 24, 0, 4, 4, 3, 21, 1 },
    { 29, 0, 0, 0, -1, 0, 24, 0, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 5, 0, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 5, 85, 0, 0, 0, 12, 2 },
    { 1, 0, 216, 0, -1, 0, 5, 0, 4, 4, 3, 21, 2 },
    { 1, 0, 216, 0, -1, 0, 5, 0, 8, 4, 3, 21, 2 },
    { 0, 17, 1, 5, -1, 0, 5, 0, 4, 4, 3, 21, 1 },
    { 1, 0, 226, 0, -1, 0, 5, 0, 8, 4, 3, 21, 2 },
    { 10, 18, 0, 5, -1, 0, 5, 0, 3, 6, 5, 21, 2 },
    { 0, 17, 220, 5, -1, 0, 5, 0, 4, 4, 3, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 5, 0, 4, 4, 3, 21, 1 },
    { 29, 0, 0, 0, -1, 0, 17, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 24, 0, 0, 0, 0, 12, 2 },
    { 0, 17, 230, 5, -1, 0, 8, 0, 4, 4, 3, 21, 4 },
    { 5, 0, 0, 0, -1, 0, 25, 0, 0, 0, 0, 12, 2 },
    { 5, 0, 0, 0, -1, 0, 20, 0, 0, 0, 0, 12, 2 },
    { 5, 0, 0, 0, -1, 0, 9, 0, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 5, 80, 0, 10, 8, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 5, 80, 0, 10, 7, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 7, 80, 0, 10, 7, 12, 2 },
    { 26, 0, 0, 0, -1, 0, 5, 80, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 5, 80, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 9, 80, 0, 10, 8, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 9, 80, 0, 10, 7, 12, 2 },
    { 3, 2, 0, 0, 0, 0, 5, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 1, 0, 5, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 2, 0, 5, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 3, 0, 5, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 4, 0, 5, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 5, 0, 5, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 6, 0, 5, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 7, 0, 5, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 8, 0, 5, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 9, 0, 5, 80, 0, 16, 10, 11, 2 },
    { 29, 0, 0, 0, -1, 0, 17, 0, 0, 0, 0, 12, 131 },
    { 0, 17, 0, 5, -1, 0, 17, 0, 4, 4, 3, 21, 131 },
    { 25, 0, 0, 0, -1, 0, 17, 0, 0, 0, 0, 17, 131 },
    { 25, 0, 0, 0, -1, 0, 17, 0, 0, 0, 13, 17, 131 },
    { 25, 0, 0, 0, -1, 0, 17, 0, 0, 0, 0, 12, 131 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 10, 9, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 25, 0, 0, 10, 7, 12, 3 },
    { 0, 17, 230, 5, -1, 0, 18, 0, 4, 4, 3, 21, 57 },
    { 17, 0, 0, 0, -1, 0, 25, 80, 0, 10, 7, 12, 5 },
    { 0, 17, 230, 5, -1, 0, 25, 0, 4, 4, 3, 21, 5 },
    { 18, 0, 0, 0, -1, 0, 21, 0, 0, 10, 9, 12, 151 },
    { 0, 17, 230, 5, -1, 0, 21, 0, 4, 4, 3, 21, 151 },
    { 17, 0, 0, 0, -1, 0, 21, 0, 0, 10, 9, 12, 151 },
    { 3, 0, 0, 0, 0, 0, 21, 0, 0, 16, 10, 11, 151 },
    { 3, 0, 0, 0, 1, 0, 21, 0, 0, 16, 10, 11, 151 },
    { 3, 0, 0, 0, 2, 0, 21, 0, 0, 16, 10, 11, 151 },
    { 3, 0, 0, 0, 3, 0, 21, 0, 0, 16, 10, 11, 151 },
    { 3, 0, 0, 0, 4, 0, 21, 0, 0, 16, 10, 11, 151 },
    { 3, 0, 0, 0, 5, 0, 21, 0, 0, 16, 10, 11, 151 },
    { 3, 0, 0, 0, 6, 0, 21, 0, 0, 16, 10, 11, 151 },
    { 3, 0, 0, 0, 7, 0, 21, 0, 0, 16, 10, 11, 151 },
    { 3, 0, 0, 0, 8, 0, 21, 0, 0, 16, 10, 11, 151 },
    { 3, 0, 0, 0, 9, 0, 21, 0, 0, 16, 10, 11, 151 },
    { 29, 0, 0, 0, -1, 0, 21, 0, 0, 0, 0, 12, 151 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 10, 9, 12, 160 },
    { 0, 17, 230, 5, -1, 0, 24, 0, 4, 4, 3, 21, 160 },
    { 18, 0, 0, 0, -1, 0, 21, 0, 0, 10, 9, 12, 152 },
    { 0, 17, 230, 5, -1, 0, 21, 0, 4, 4, 3, 21, 152 },
    { 3, 0, 0, 0, 0, 0, 21, 0, 0, 16, 10, 11, 152 },
    { 3, 0, 0, 0, 1, 0, 21, 0, 0, 16, 10, 11, 152 },
    { 3, 0, 0, 0, 2, 0, 21, 0, 0, 16, 10, 11, 152 },
    { 3, 0, 0, 0, 3, 0, 21, 0, 0, 16, 10, 11, 152 },
    { 3, 0, 0, 0, 4, 0, 21, 0, 0, 16, 10, 11, 152 },
    { 3, 0, 0, 0, 5, 0, 21, 0, 0, 16, 10, 11, 152 },
    { 3, 0, 0, 0, 6, 0, 21, 0, 0, 16, 10, 11, 152 },
    { 3, 0, 0, 0, 7, 0, 21, 0, 0, 16, 10, 11, 152 },
    { 3, 0, 0, 0, 8, 0, 21, 0, 0, 16, 10, 11, 152 },
    { 3, 0, 0, 0, 9, 0, 21, 0, 0, 16, 10, 11, 152 },
    { 27, 4, 0, 0, -1, 0, 21, 0, 0, 0, 0, 9, 152 },
    { 18, 0, 0, 0, -1, 0, 25, 0, 0, 10, 9, 12, 163 },
    { 17, 0, 0, 0, -1, 0, 25, 0, 0, 10, 9, 12, 163 },
    { 0, 17, 232, 5, -1, 0, 25, 0, 4, 4, 3, 21, 163 },
    { 0, 17, 220, 5, -1, 0, 25, 0, 4, 4, 3, 21, 163 },
    { 0, 17, 230, 5, -1, 0, 25, 0, 4, 4, 3, 21, 163 },
    { 3, 0, 0, 0, 0, 0, 25, 0, 0, 16, 10, 11, 163 },
    { 3, 0, 0, 0, 1, 0, 25, 0, 0, 16, 10, 11, 163 },
    { 3, 0, 0, 0, 2, 0, 25, 0, 0, 16, 10, 11, 163 },
    { 3, 0, 0, 0, 3, 0, 25, 0, 0, 16, 10, 11, 163 },
    { 3, 0, 0, 0, 4, 0, 25, 0, 0, 16, 10, 11, 163 },
    { 3, 0, 0, 0, 5, 0, 25, 0, 0, 16, 10, 11, 163 },
    { 3, 0, 0, 0, 6, 0, 25, 0, 0, 16, 10, 11, 163 },
    { 3, 0, 0, 0, 7, 0, 25, 0, 0, 16, 10, 11, 163 },
    { 3, 0, 0, 0, 8, 0, 25, 0, 0, 16, 10, 11, 163 },
    { 3, 0, 0, 0, 9, 0, 25, 0, 0, 16, 10, 11, 163 },
    { 18, 0, 0, 0, -1, 0, 24, 0, 0, 10, 9, 12, 27 },
    { 18, 1, 0, 0, -1, 0, 16, 0, 0, 10, 9, 12, 113 },
    { 5, 1, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 113 },
    { 0, 17, 220, 5, -1, 0, 16, 0, 4, 4, 3, 21, 113 },
    { 14, 1, 0, 2, -1, 0, 18, 0, 0, 10, 8, 12, 132 },
    { 15, 1, 0, 2, -1, 0, 18, 0, 0, 10, 7, 12, 132 },
    { 0, 17, 230, 5, -1, 0, 18, 0, 4, 4, 3, 21, 132 },
    { 0, 17, 7, 5, -1, 0, 18, 0, 4, 4, 3, 21, 132 },
    { 17, 1, 0, 5, -1, 0, 21, 0, 0, 10, 9, 12, 132 },
    { 3, 1, 0, 0, 0, 0, 18, 0, 0, 16, 10, 11, 132 },
    { 3, 1, 0, 0, 1, 0, 18, 0, 0, 16, 10, 11, 132 },
    { 3, 1, 0, 0, 2, 0, 18, 0, 0, 16, 10, 11, 132 },
    { 3, 1, 0, 0, 3, 0, 18, 0, 0, 16, 10, 11, 132 },
    { 3, 1, 0, 0, 4, 0, 18, 0, 0, 16, 10, 11, 132 },
    { 3, 1, 0, 0, 5, 0, 18, 0, 0, 16, 10, 11, 132 },
    { 3, 1, 0, 0, 6, 0, 18, 0, 0, 16, 10, 11, 132 },
    { 3, 1, 0, 0, 7, 0, 18, 0, 0, 16, 10, 11, 132 },
    { 3, 1, 0, 0, 8, 0, 18, 0, 0, 16, 10, 11, 132 },
    { 3, 1, 0, 0, 9, 0, 18, 0, 0, 16, 10, 11, 132 },
    { 25, 1, 0, 0, -1, 0, 18, 0, 0, 0, 0, 0, 132 },
    { 5, 13, 0, 0, -1, 0, 20, 0, 0, 0, 0, 12, 2 },
    { 29, 13, 0, 0, -1, 0, 20, 0, 0, 0, 0, 10, 2 },
    { 27, 13, 0, 0, -1, 0, 20, 0, 0, 0, 0, 10, 2 },
    { 5, 13, 0, 0, -1, 0, 21, 0, 0, 0, 0, 12, 2 },
    { 29, 13, 0, 0, -1, 0, 21, 0, 0, 0, 0, 12, 2 },
    { 18, 13, 0, 0, -1, 0, 13, 80, 0, 10, 9, 12, 8 },
    { 26, 10, 0, 0, -1, 0, 13, 0, 0, 0, 0, 12, 8 },
    { 5, 2, 0, 0, 0, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 1, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 2, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 3, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 4, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 5, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 6, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 7, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 8, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 9, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, -1, 0, 16, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 23, 0, 0, 0, 0, 14, 2 },
    { 29, 0, 0, 0, -1, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 12, 80, 0, 10, 8, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 11, 80, 0, 10, 8, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 12, 80, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 12, 0, 0, 10, 8, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 11, 0, 0, 10, 8, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 13, 80, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 21, 80, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 12, 0, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 18, 0, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 12, 0, 6, 7, 0, 28, 2 },
    { 29, 0, 0, 0, -1, 0, 11, 80, 0, 0, 0, 14, 34 },
    { 29, 0, 0, 0, -1, 0, 12, 80, 0, 0, 0, 14, 2 },
    { 29, 0, 0, 0, -1, 0, 18, 80, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 19, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 17, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 16, 0, 0, 0, 0, 30, 2 },
    { 28, 10, 0, 0, -1, 0, 17, 0, 4, 4, 0, 31, 2 },
    { 29, 10, 0, 0, -1, 0, 13, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 18, 0, 0, 0, 0, 30, 2 },
    { 29, 10, 0, 0, -1, 0, 18, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 13, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 16, 0, 0, 0, 14, 3, 2 },
    { 29, 10, 0, 0, -1, 0, 16, 0, 0, 0, 0, 5, 2 },
    { 29, 10, 0, 0, -1, 0, 21, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 25, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 24, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 20, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 23, 0, 0, 0, 0, 30, 2 },
    { 29, 10, 0, 0, -1, 0, 21, 0, 0, 0, 0, 30, 2 },
    { 29, 10, 0, 0, -1, 0, 17, 0, 0, 0, 0, 30, 2 },
    { 29, 10, 0, 0, -1, 0, 19, 0, 0, 0, 0, 30, 2 },
    { 29, 10, 0, 0, -1, 0, 20, 0, 0, 0, 0, 30, 2 },
    { 29, 10, 0, 0, -1, 0, 24, 0, 0, 0, 0, 30, 2 },
    { 29, 10, 0, 0, -1, 0, 25, 0, 0, 0, 0, 30, 2 },
    { 3, 2, 0, 0, 0, 0, 23, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 1, 0, 23, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 2, 0, 23, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 3, 0, 23, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 4, 0, 23, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 5, 0, 23, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 6, 0, 23, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 7, 0, 23, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 8, 0, 23, 80, 0, 16, 10, 11, 2 },
    { 3, 2, 0, 0, 9, 0, 23, 80, 0, 16, 10, 11, 2 },
    { 13, 18, 0, 0, -1, 0, 2, 0, 0, 0, 0, 12, 0 },
    { 18, 0, 0, 0, -1, 0, 5, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 25, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 12, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 26, 0, 0, 0, 9, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 5, 85, 0, 0, 9, 14, 37 },
    { 10, 18, 0, 5, -1, 0, 5, 0, 4, 4, 3, 21, 2 },
    { 0, 17, 0, 5, -1, 0, 7, 0, 4, 4, 3, 21, 1 },
    { 12, 0, 0, 0, -1, 0, 2, 0, 0, 0, 0, 12, 0 }
};

char32_t uc_caseFold(char32_t value)
{
   if (value < 65) {
      return value + 0;

   } else if (value < 73) {
      return value + 32;

   } else if (value < 74 && cs_isTurkishLocale) {
       // letter I, ignore for all other locales
       return value + 232;

    } else if (value < 91) {
      return value + 32;

   } else if (value < 181) {
      return value + 0;

   } else if (value < 182) {
      return value + 775;

   } else if (value < 192) {
      return value + 0;

   } else if (value < 215) {
      return value + 32;

   } else if (value < 216) {
      return value + 0;

   } else if (value == 223) {
      // special char
      return 0;

   } else if (value < 224) {
      return value + 32;

   } else if (value < 256) {
      return value + 0;

   } else if (value < 257) {
      return value + 1;

   } else if (value < 258) {
      return value + 0;

   } else if (value < 259) {
      return value + 1;

   } else if (value < 260) {
      return value + 0;

   } else if (value < 261) {
      return value + 1;

   } else if (value < 262) {
      return value + 0;

   } else if (value < 263) {
      return value + 1;

   } else if (value < 264) {
      return value + 0;

   } else if (value < 265) {
      return value + 1;

   } else if (value < 266) {
      return value + 0;

   } else if (value < 267) {
      return value + 1;

   } else if (value < 268) {
      return value + 0;

   } else if (value < 269) {
      return value + 1;

   } else if (value < 270) {
      return value + 0;

   } else if (value < 271) {
      return value + 1;

   } else if (value < 272) {
      return value + 0;

   } else if (value < 273) {
      return value + 1;

   } else if (value < 274) {
      return value + 0;

   } else if (value < 275) {
      return value + 1;

   } else if (value < 276) {
      return value + 0;

   } else if (value < 277) {
      return value + 1;

   } else if (value < 278) {
      return value + 0;

   } else if (value < 279) {
      return value + 1;

   } else if (value < 280) {
      return value + 0;

   } else if (value < 281) {
      return value + 1;

   } else if (value < 282) {
      return value + 0;

   } else if (value < 283) {
      return value + 1;

   } else if (value < 284) {
      return value + 0;

   } else if (value < 285) {
      return value + 1;

   } else if (value < 286) {
      return value + 0;

   } else if (value < 287) {
      return value + 1;

   } else if (value < 288) {
      return value + 0;

   } else if (value < 289) {
      return value + 1;

   } else if (value < 290) {
      return value + 0;

   } else if (value < 291) {
      return value + 1;

   } else if (value < 292) {
      return value + 0;

   } else if (value < 293) {
      return value + 1;

   } else if (value < 294) {
      return value + 0;

   } else if (value < 295) {
      return value + 1;

   } else if (value < 296) {
      return value + 0;

   } else if (value < 297) {
      return value + 1;

   } else if (value < 298) {
      return value + 0;

   } else if (value < 299) {
      return value + 1;

   } else if (value < 300) {
      return value + 0;

   } else if (value < 301) {
      return value + 1;

   } else if (value < 302) {
      return value + 0;

   } else if (value < 303) {
      return value + 1;

   } else if (value == 304) {
      // special char
      return 0;

   } else if (value < 306) {
      return value + 0;

   } else if (value < 307) {
      return value + 1;

   } else if (value < 308) {
      return value + 0;

   } else if (value < 309) {
      return value + 1;

   } else if (value < 310) {
      return value + 0;

   } else if (value < 311) {
      return value + 1;

   } else if (value < 313) {
      return value + 0;

   } else if (value < 314) {
      return value + 1;

   } else if (value < 315) {
      return value + 0;

   } else if (value < 316) {
      return value + 1;

   } else if (value < 317) {
      return value + 0;

   } else if (value < 318) {
      return value + 1;

   } else if (value < 319) {
      return value + 0;

   } else if (value < 320) {
      return value + 1;

   } else if (value < 321) {
      return value + 0;

   } else if (value < 322) {
      return value + 1;

   } else if (value < 323) {
      return value + 0;

   } else if (value < 324) {
      return value + 1;

   } else if (value < 325) {
      return value + 0;

   } else if (value < 326) {
      return value + 1;

   } else if (value < 327) {
      return value + 0;

   } else if (value < 328) {
      return value + 1;

   } else if (value == 329) {
      // special char
      return 0;

   } else if (value < 330) {
      return value + 0;

   } else if (value < 331) {
      return value + 1;

   } else if (value < 332) {
      return value + 0;

   } else if (value < 333) {
      return value + 1;

   } else if (value < 334) {
      return value + 0;

   } else if (value < 335) {
      return value + 1;

   } else if (value < 336) {
      return value + 0;

   } else if (value < 337) {
      return value + 1;

   } else if (value < 338) {
      return value + 0;

   } else if (value < 339) {
      return value + 1;

   } else if (value < 340) {
      return value + 0;

   } else if (value < 341) {
      return value + 1;

   } else if (value < 342) {
      return value + 0;

   } else if (value < 343) {
      return value + 1;

   } else if (value < 344) {
      return value + 0;

   } else if (value < 345) {
      return value + 1;

   } else if (value < 346) {
      return value + 0;

   } else if (value < 347) {
      return value + 1;

   }

   if (value < 348) {
      return value + 0;

   } else if (value < 349) {
      return value + 1;

   } else if (value < 350) {
      return value + 0;

   } else if (value < 351) {
      return value + 1;

   } else if (value < 352) {
      return value + 0;

   } else if (value < 353) {
      return value + 1;

   } else if (value < 354) {
      return value + 0;

   } else if (value < 355) {
      return value + 1;

   } else if (value < 356) {
      return value + 0;

   } else if (value < 357) {
      return value + 1;

   } else if (value < 358) {
      return value + 0;

   } else if (value < 359) {
      return value + 1;

   } else if (value < 360) {
      return value + 0;

   } else if (value < 361) {
      return value + 1;

   } else if (value < 362) {
      return value + 0;

   } else if (value < 363) {
      return value + 1;

   } else if (value < 364) {
      return value + 0;

   } else if (value < 365) {
      return value + 1;

   } else if (value < 366) {
      return value + 0;

   } else if (value < 367) {
      return value + 1;

   } else if (value < 368) {
      return value + 0;

   } else if (value < 369) {
      return value + 1;

   } else if (value < 370) {
      return value + 0;

   } else if (value < 371) {
      return value + 1;

   } else if (value < 372) {
      return value + 0;

   } else if (value < 373) {
      return value + 1;

   } else if (value < 374) {
      return value + 0;

   } else if (value < 375) {
      return value + 1;

   } else if (value < 376) {
      return value + 0;

   } else if (value < 377) {
      return value + -121;

   } else if (value < 378) {
      return value + 1;

   } else if (value < 379) {
      return value + 0;

   } else if (value < 380) {
      return value + 1;

   } else if (value < 381) {
      return value + 0;

   } else if (value < 382) {
      return value + 1;

   } else if (value < 383) {
      return value + 0;

   } else if (value < 384) {
      return value + -268;

   } else if (value < 385) {
      return value + 0;

   } else if (value < 386) {
      return value + 210;

   } else if (value < 387) {
      return value + 1;

   } else if (value < 388) {
      return value + 0;

   } else if (value < 389) {
      return value + 1;

   } else if (value < 390) {
      return value + 0;

   } else if (value < 391) {
      return value + 206;

   } else if (value < 392) {
      return value + 1;

   } else if (value < 393) {
      return value + 0;

   } else if (value < 395) {
      return value + 205;

   } else if (value < 396) {
      return value + 1;

   } else if (value < 398) {
      return value + 0;

   } else if (value < 399) {
      return value + 79;

   } else if (value < 400) {
      return value + 202;

   } else if (value < 401) {
      return value + 203;

   } else if (value < 402) {
      return value + 1;

   } else if (value < 403) {
      return value + 0;

   } else if (value < 404) {
      return value + 205;

   } else if (value < 405) {
      return value + 207;

   } else if (value < 406) {
      return value + 0;

   } else if (value < 407) {
      return value + 211;

   } else if (value < 408) {
      return value + 209;

   } else if (value < 409) {
      return value + 1;

   } else if (value < 412) {
      return value + 0;

   } else if (value < 413) {
      return value + 211;

   } else if (value < 414) {
      return value + 213;

   } else if (value < 415) {
      return value + 0;

   } else if (value < 416) {
      return value + 214;

   } else if (value < 417) {
      return value + 1;

   } else if (value < 418) {
      return value + 0;

   } else if (value < 419) {
      return value + 1;

   } else if (value < 420) {
      return value + 0;

   } else if (value < 421) {
      return value + 1;

   } else if (value < 422) {
      return value + 0;

   } else if (value < 423) {
      return value + 218;

   } else if (value < 424) {
      return value + 1;

   } else if (value < 425) {
      return value + 0;

   } else if (value < 426) {
      return value + 218;

   } else if (value < 428) {
      return value + 0;

   } else if (value < 429) {
      return value + 1;

   } else if (value < 430) {
      return value + 0;

   } else if (value < 431) {
      return value + 218;

   } else if (value < 432) {
      return value + 1;

   } else if (value < 433) {
      return value + 0;

   } else if (value < 435) {
      return value + 217;

   } else if (value < 436) {
      return value + 1;

   } else if (value < 437) {
      return value + 0;

   } else if (value < 438) {
      return value + 1;

   } else if (value < 439) {
      return value + 0;

   } else if (value < 440) {
      return value + 219;

   } else if (value < 441) {
      return value + 1;

   } else if (value < 444) {
      return value + 0;

   } else if (value < 445) {
      return value + 1;

   } else if (value < 452) {
      return value + 0;

   } else if (value < 453) {
      return value + 2;

   } else if (value < 454) {
      return value + 1;

   } else if (value < 455) {
      return value + 0;

   } else if (value < 456) {
      return value + 2;

   } else if (value < 457) {
      return value + 1;

   } else if (value < 458) {
      return value + 0;

   } else if (value < 459) {
      return value + 2;

   } else if (value < 460) {
      return value + 1;

   } else if (value < 461) {
      return value + 0;

   }

   if (value < 462) {
      return value + 1;

   } else if (value < 463) {
      return value + 0;

   } else if (value < 464) {
      return value + 1;

   } else if (value < 465) {
      return value + 0;

   } else if (value < 466) {
      return value + 1;

   } else if (value < 467) {
      return value + 0;

   } else if (value < 468) {
      return value + 1;

   } else if (value < 469) {
      return value + 0;

   } else if (value < 470) {
      return value + 1;

   } else if (value < 471) {
      return value + 0;

   } else if (value < 472) {
      return value + 1;

   } else if (value < 473) {
      return value + 0;

   } else if (value < 474) {
      return value + 1;

   } else if (value < 475) {
      return value + 0;

   } else if (value < 476) {
      return value + 1;

   } else if (value < 478) {
      return value + 0;

   } else if (value < 479) {
      return value + 1;

   } else if (value < 480) {
      return value + 0;

   } else if (value < 481) {
      return value + 1;

   } else if (value < 482) {
      return value + 0;

   } else if (value < 483) {
      return value + 1;

   } else if (value < 484) {
      return value + 0;

   } else if (value < 485) {
      return value + 1;

   } else if (value < 486) {
      return value + 0;

   } else if (value < 487) {
      return value + 1;

   } else if (value < 488) {
      return value + 0;

   } else if (value < 489) {
      return value + 1;

   } else if (value < 490) {
      return value + 0;

   } else if (value < 491) {
      return value + 1;

   } else if (value < 492) {
      return value + 0;

   } else if (value < 493) {
      return value + 1;

   } else if (value < 494) {
      return value + 0;

   } else if (value < 495) {
      return value + 1;

   } else if (value == 496) {
      // special char
      return 0;

   } else if (value < 497) {
      return value + 0;

   } else if (value < 498) {
      return value + 2;

   } else if (value < 499) {
      return value + 1;

   } else if (value < 500) {
      return value + 0;

   } else if (value < 501) {
      return value + 1;

   } else if (value < 502) {
      return value + 0;

   } else if (value < 503) {
      return value + -97;

   } else if (value < 504) {
      return value + -56;

   } else if (value < 505) {
      return value + 1;

   } else if (value < 506) {
      return value + 0;

   } else if (value < 507) {
      return value + 1;

   } else if (value < 508) {
      return value + 0;

   } else if (value < 509) {
      return value + 1;

   } else if (value < 510) {
      return value + 0;

   } else if (value < 511) {
      return value + 1;

   } else if (value < 512) {
      return value + 0;

   } else if (value < 513) {
      return value + 1;

   } else if (value < 514) {
      return value + 0;

   } else if (value < 515) {
      return value + 1;

   } else if (value < 516) {
      return value + 0;

   } else if (value < 517) {
      return value + 1;

   } else if (value < 518) {
      return value + 0;

   } else if (value < 519) {
      return value + 1;

   } else if (value < 520) {
      return value + 0;

   } else if (value < 521) {
      return value + 1;

   } else if (value < 522) {
      return value + 0;

   } else if (value < 523) {
      return value + 1;

   } else if (value < 524) {
      return value + 0;

   } else if (value < 525) {
      return value + 1;

   } else if (value < 526) {
      return value + 0;

   } else if (value < 527) {
      return value + 1;

   } else if (value < 528) {
      return value + 0;

   } else if (value < 529) {
      return value + 1;

   } else if (value < 530) {
      return value + 0;

   } else if (value < 531) {
      return value + 1;

   } else if (value < 532) {
      return value + 0;

   } else if (value < 533) {
      return value + 1;

   } else if (value < 534) {
      return value + 0;

   } else if (value < 535) {
      return value + 1;

   } else if (value < 536) {
      return value + 0;

   } else if (value < 537) {
      return value + 1;

   } else if (value < 538) {
      return value + 0;

   } else if (value < 539) {
      return value + 1;

   } else if (value < 540) {
      return value + 0;

   } else if (value < 541) {
      return value + 1;

   } else if (value < 542) {
      return value + 0;

   } else if (value < 543) {
      return value + 1;

   } else if (value < 544) {
      return value + 0;

   } else if (value < 545) {
      return value + -130;

   } else if (value < 546) {
      return value + 0;

   } else if (value < 547) {
      return value + 1;

   } else if (value < 548) {
      return value + 0;

   } else if (value < 549) {
      return value + 1;

   } else if (value < 550) {
      return value + 0;

   } else if (value < 551) {
      return value + 1;

   } else if (value < 552) {
      return value + 0;

   } else if (value < 553) {
      return value + 1;

   } else if (value < 554) {
      return value + 0;

   } else if (value < 555) {
      return value + 1;

   } else if (value < 556) {
      return value + 0;

   } else if (value < 557) {
      return value + 1;

   } else if (value < 558) {
      return value + 0;

   } else if (value < 559) {
      return value + 1;

   } else if (value < 560) {
      return value + 0;

   } else if (value < 561) {
      return value + 1;

   } else if (value < 562) {
      return value + 0;

   }

   if (value < 563) {
      return value + 1;

   } else if (value < 570) {
      return value + 0;

   } else if (value < 571) {
      return value + 10795;

   } else if (value < 572) {
      return value + 1;

   } else if (value < 573) {
      return value + 0;

   } else if (value < 574) {
      return value + -163;

   } else if (value < 575) {
      return value + 10792;

   } else if (value < 577) {
      return value + 0;

   } else if (value < 578) {
      return value + 1;

   } else if (value < 579) {
      return value + 0;

   } else if (value < 580) {
      return value + -195;

   } else if (value < 581) {
      return value + 69;

   } else if (value < 582) {
      return value + 71;

   } else if (value < 583) {
      return value + 1;

   } else if (value < 584) {
      return value + 0;

   } else if (value < 585) {
      return value + 1;

   } else if (value < 586) {
      return value + 0;

   } else if (value < 587) {
      return value + 1;

   } else if (value < 588) {
      return value + 0;

   } else if (value < 589) {
      return value + 1;

   } else if (value < 590) {
      return value + 0;

   } else if (value < 591) {
      return value + 1;

   } else if (value < 837) {
      return value + 0;

   } else if (value < 838) {
      return value + 116;

   } else if (value < 880) {
      return value + 0;

   } else if (value < 881) {
      return value + 1;

   } else if (value < 882) {
      return value + 0;

   } else if (value < 883) {
      return value + 1;

   } else if (value < 886) {
      return value + 0;

   } else if (value < 887) {
      return value + 1;

   } else if (value < 895) {
      return value + 0;

   } else if (value < 896) {
      return value + 116;

   } else if (value < 902) {
      return value + 0;

   } else if (value < 903) {
      return value + 38;

   } else if (value < 904) {
      return value + 0;

   } else if (value < 907) {
      return value + 37;

   } else if (value < 908) {
      return value + 0;

   } else if (value < 909) {
      return value + 64;

   } else if (value < 910) {
      return value + 0;

   } else if (value == 912) {
      // special char
      return 0;

   } else if (value < 913) {
      return value + 63;

   } else if (value < 930) {
      return value + 32;

   } else if (value < 931) {
      return value + 0;

   } else if (value < 940) {
      return value + 32;

   } else if (value == 944) {
      // special char
      return 0;

   } else if (value < 962) {
      return value + 0;

   } else if (value < 963) {
      return value + 1;

   } else if (value < 975) {
      return value + 0;

   } else if (value < 976) {
      return value + 8;

   } else if (value < 977) {
      return value + -30;

   } else if (value < 978) {
      return value + -25;

   } else if (value < 981) {
      return value + 0;

   } else if (value < 982) {
      return value + -15;

   } else if (value < 983) {
      return value + -22;

   } else if (value < 984) {
      return value + 0;

   } else if (value < 985) {
      return value + 1;

   } else if (value < 986) {
      return value + 0;

   } else if (value < 987) {
      return value + 1;

   } else if (value < 988) {
      return value + 0;

   } else if (value < 989) {
      return value + 1;

   } else if (value < 990) {
      return value + 0;

   } else if (value < 991) {
      return value + 1;

   } else if (value < 992) {
      return value + 0;

   } else if (value < 993) {
      return value + 1;

   } else if (value < 994) {
      return value + 0;

   } else if (value < 995) {
      return value + 1;

   } else if (value < 996) {
      return value + 0;

   } else if (value < 997) {
      return value + 1;

   } else if (value < 998) {
      return value + 0;

   } else if (value < 999) {
      return value + 1;

   } else if (value < 1000) {
      return value + 0;

   } else if (value < 1001) {
      return value + 1;

   } else if (value < 1002) {
      return value + 0;

   } else if (value < 1003) {
      return value + 1;

   } else if (value < 1004) {
      return value + 0;

   } else if (value < 1005) {
      return value + 1;

   } else if (value < 1006) {
      return value + 0;

   } else if (value < 1007) {
      return value + 1;

   } else if (value < 1008) {
      return value + 0;

   } else if (value < 1009) {
      return value + -54;

   } else if (value < 1010) {
      return value + -48;

   } else if (value < 1012) {
      return value + 0;

   } else if (value < 1013) {
      return value + -60;

   } else if (value < 1014) {
      return value + -64;

   } else if (value < 1015) {
      return value + 0;

   } else if (value < 1016) {
      return value + 1;

   } else if (value < 1017) {
      return value + 0;

   } else if (value < 1018) {
      return value + -7;

   } else if (value < 1019) {
      return value + 1;

   } else if (value < 1021) {
      return value + 0;

   } else if (value < 1024) {
      return value + -130;

   } else if (value < 1040) {
      return value + 80;

   } else if (value < 1072) {
      return value + 32;

   } else if (value < 1120) {
      return value + 0;

   } else if (value < 1121) {
      return value + 1;

   } else if (value < 1122) {
      return value + 0;

   } else if (value < 1123) {
      return value + 1;

   } else if (value < 1124) {
      return value + 0;

   } else if (value < 1125) {
      return value + 1;

   } else if (value < 1126) {
      return value + 0;

   }

   if (value < 1127) {
      return value + 1;

   } else if (value < 1128) {
      return value + 0;

   } else if (value < 1129) {
      return value + 1;

   } else if (value < 1130) {
      return value + 0;

   } else if (value < 1131) {
      return value + 1;

   } else if (value < 1132) {
      return value + 0;

   } else if (value < 1133) {
      return value + 1;

   } else if (value < 1134) {
      return value + 0;

   } else if (value < 1135) {
      return value + 1;

   } else if (value < 1136) {
      return value + 0;

   } else if (value < 1137) {
      return value + 1;

   } else if (value < 1138) {
      return value + 0;

   } else if (value < 1139) {
      return value + 1;

   } else if (value < 1140) {
      return value + 0;

   } else if (value < 1141) {
      return value + 1;

   } else if (value < 1142) {
      return value + 0;

   } else if (value < 1143) {
      return value + 1;

   } else if (value < 1144) {
      return value + 0;

   } else if (value < 1145) {
      return value + 1;

   } else if (value < 1146) {
      return value + 0;

   } else if (value < 1147) {
      return value + 1;

   } else if (value < 1148) {
      return value + 0;

   } else if (value < 1149) {
      return value + 1;

   } else if (value < 1150) {
      return value + 0;

   } else if (value < 1151) {
      return value + 1;

   } else if (value < 1152) {
      return value + 0;

   } else if (value < 1153) {
      return value + 1;

   } else if (value < 1162) {
      return value + 0;

   } else if (value < 1163) {
      return value + 1;

   } else if (value < 1164) {
      return value + 0;

   } else if (value < 1165) {
      return value + 1;

   } else if (value < 1166) {
      return value + 0;

   } else if (value < 1167) {
      return value + 1;

   } else if (value < 1168) {
      return value + 0;

   } else if (value < 1169) {
      return value + 1;

   } else if (value < 1170) {
      return value + 0;

   } else if (value < 1171) {
      return value + 1;

   } else if (value < 1172) {
      return value + 0;

   } else if (value < 1173) {
      return value + 1;

   } else if (value < 1174) {
      return value + 0;

   } else if (value < 1175) {
      return value + 1;

   } else if (value < 1176) {
      return value + 0;

   } else if (value < 1177) {
      return value + 1;

   } else if (value < 1178) {
      return value + 0;

   } else if (value < 1179) {
      return value + 1;

   } else if (value < 1180) {
      return value + 0;

   } else if (value < 1181) {
      return value + 1;

   } else if (value < 1182) {
      return value + 0;

   } else if (value < 1183) {
      return value + 1;

   } else if (value < 1184) {
      return value + 0;

   } else if (value < 1185) {
      return value + 1;

   } else if (value < 1186) {
      return value + 0;

   } else if (value < 1187) {
      return value + 1;

   } else if (value < 1188) {
      return value + 0;

   } else if (value < 1189) {
      return value + 1;

   } else if (value < 1190) {
      return value + 0;

   } else if (value < 1191) {
      return value + 1;

   } else if (value < 1192) {
      return value + 0;

   } else if (value < 1193) {
      return value + 1;

   } else if (value < 1194) {
      return value + 0;

   } else if (value < 1195) {
      return value + 1;

   } else if (value < 1196) {
      return value + 0;

   } else if (value < 1197) {
      return value + 1;

   } else if (value < 1198) {
      return value + 0;

   } else if (value < 1199) {
      return value + 1;

   } else if (value < 1200) {
      return value + 0;

   } else if (value < 1201) {
      return value + 1;

   } else if (value < 1202) {
      return value + 0;

   } else if (value < 1203) {
      return value + 1;

   } else if (value < 1204) {
      return value + 0;

   } else if (value < 1205) {
      return value + 1;

   } else if (value < 1206) {
      return value + 0;

   } else if (value < 1207) {
      return value + 1;

   } else if (value < 1208) {
      return value + 0;

   } else if (value < 1209) {
      return value + 1;

   } else if (value < 1210) {
      return value + 0;

   } else if (value < 1211) {
      return value + 1;

   } else if (value < 1212) {
      return value + 0;

   } else if (value < 1213) {
      return value + 1;

   } else if (value < 1214) {
      return value + 0;

   } else if (value < 1215) {
      return value + 1;

   } else if (value < 1216) {
      return value + 0;

   } else if (value < 1217) {
      return value + 15;

   } else if (value < 1218) {
      return value + 1;

   } else if (value < 1219) {
      return value + 0;

   } else if (value < 1220) {
      return value + 1;

   } else if (value < 1221) {
      return value + 0;

   } else if (value < 1222) {
      return value + 1;

   } else if (value < 1223) {
      return value + 0;

   } else if (value < 1224) {
      return value + 1;

   } else if (value < 1225) {
      return value + 0;

   } else if (value < 1226) {
      return value + 1;

   } else if (value < 1227) {
      return value + 0;

   } else if (value < 1228) {
      return value + 1;

   } else if (value < 1229) {
      return value + 0;

   } else if (value < 1230) {
      return value + 1;

   } else if (value < 1232) {
      return value + 0;

   } else if (value < 1233) {
      return value + 1;

   } else if (value < 1234) {
      return value + 0;

   } else if (value < 1235) {
      return value + 1;

   }

   if (value < 1236) {
      return value + 0;

   } else if (value < 1237) {
      return value + 1;

   } else if (value < 1238) {
      return value + 0;

   } else if (value < 1239) {
      return value + 1;

   } else if (value < 1240) {
      return value + 0;

   } else if (value < 1241) {
      return value + 1;

   } else if (value < 1242) {
      return value + 0;

   } else if (value < 1243) {
      return value + 1;

   } else if (value < 1244) {
      return value + 0;

   } else if (value < 1245) {
      return value + 1;

   } else if (value < 1246) {
      return value + 0;

   } else if (value < 1247) {
      return value + 1;

   } else if (value < 1248) {
      return value + 0;

   } else if (value < 1249) {
      return value + 1;

   } else if (value < 1250) {
      return value + 0;

   } else if (value < 1251) {
      return value + 1;

   } else if (value < 1252) {
      return value + 0;

   } else if (value < 1253) {
      return value + 1;

   } else if (value < 1254) {
      return value + 0;

   } else if (value < 1255) {
      return value + 1;

   } else if (value < 1256) {
      return value + 0;

   } else if (value < 1257) {
      return value + 1;

   } else if (value < 1258) {
      return value + 0;

   } else if (value < 1259) {
      return value + 1;

   } else if (value < 1260) {
      return value + 0;

   } else if (value < 1261) {
      return value + 1;

   } else if (value < 1262) {
      return value + 0;

   } else if (value < 1263) {
      return value + 1;

   } else if (value < 1264) {
      return value + 0;

   } else if (value < 1265) {
      return value + 1;

   } else if (value < 1266) {
      return value + 0;

   } else if (value < 1267) {
      return value + 1;

   } else if (value < 1268) {
      return value + 0;

   } else if (value < 1269) {
      return value + 1;

   } else if (value < 1270) {
      return value + 0;

   } else if (value < 1271) {
      return value + 1;

   } else if (value < 1272) {
      return value + 0;

   } else if (value < 1273) {
      return value + 1;

   } else if (value < 1274) {
      return value + 0;

   } else if (value < 1275) {
      return value + 1;

   } else if (value < 1276) {
      return value + 0;

   } else if (value < 1277) {
      return value + 1;

   } else if (value < 1278) {
      return value + 0;

   } else if (value < 1279) {
      return value + 1;

   } else if (value < 1280) {
      return value + 0;

   } else if (value < 1281) {
      return value + 1;

   } else if (value < 1282) {
      return value + 0;

   } else if (value < 1283) {
      return value + 1;

   } else if (value < 1284) {
      return value + 0;

   } else if (value < 1285) {
      return value + 1;

   } else if (value < 1286) {
      return value + 0;

   } else if (value < 1287) {
      return value + 1;

   } else if (value < 1288) {
      return value + 0;

   } else if (value < 1289) {
      return value + 1;

   } else if (value < 1290) {
      return value + 0;

   } else if (value < 1291) {
      return value + 1;

   } else if (value < 1292) {
      return value + 0;

   } else if (value < 1293) {
      return value + 1;

   } else if (value < 1294) {
      return value + 0;

   } else if (value < 1295) {
      return value + 1;

   } else if (value < 1296) {
      return value + 0;

   } else if (value < 1297) {
      return value + 1;

   } else if (value < 1298) {
      return value + 0;

   } else if (value < 1299) {
      return value + 1;

   } else if (value < 1300) {
      return value + 0;

   } else if (value < 1301) {
      return value + 1;

   } else if (value < 1302) {
      return value + 0;

   } else if (value < 1303) {
      return value + 1;

   } else if (value < 1304) {
      return value + 0;

   } else if (value < 1305) {
      return value + 1;

   } else if (value < 1306) {
      return value + 0;

   } else if (value < 1307) {
      return value + 1;

   } else if (value < 1308) {
      return value + 0;

   } else if (value < 1309) {
      return value + 1;

   } else if (value < 1310) {
      return value + 0;

   } else if (value < 1311) {
      return value + 1;

   } else if (value < 1312) {
      return value + 0;

   } else if (value < 1313) {
      return value + 1;

   } else if (value < 1314) {
      return value + 0;

   } else if (value < 1315) {
      return value + 1;

   } else if (value < 1316) {
      return value + 0;

   } else if (value < 1317) {
      return value + 1;

   } else if (value < 1318) {
      return value + 0;

   } else if (value < 1319) {
      return value + 1;

   } else if (value < 1320) {
      return value + 0;

   } else if (value < 1321) {
      return value + 1;

   } else if (value < 1322) {
      return value + 0;

   } else if (value < 1323) {
      return value + 1;

   } else if (value < 1324) {
      return value + 0;

   } else if (value < 1325) {
      return value + 1;

   } else if (value < 1326) {
      return value + 0;

   } else if (value < 1327) {
      return value + 1;

   } else if (value < 1329) {
      return value + 0;

   } else if (value < 1367) {
      return value + 48;

   } else if (value == 1415) {
      // special char
      return 0;

   } else if (value < 4256) {
      return value + 0;

   } else if (value < 4294) {
      return value + 7264;

   } else if (value < 4295) {
      return value + 0;

   } else if (value < 4296) {
      return value + 7264;

   } else if (value < 4301) {
      return value + 0;

   }

   if (value < 4302) {
      return value + 7264;

   } else if (value < 5112) {
      return value + 0;

   } else if (value < 5118) {
      return value + -8;

   } else if (value < 7296) {
      return value + 0;

   } else if (value < 7297) {
      return value + -6222;

   } else if (value < 7298) {
      return value + -6221;

   } else if (value < 7299) {
      return value + -6212;

   } else if (value < 7301) {
      return value + -6210;

   } else if (value < 7302) {
      return value + -6211;

   } else if (value < 7303) {
      return value + -6204;

   } else if (value < 7304) {
      return value + -6180;

   } else if (value < 7305) {
      return value + 35267;

   } else if (value < 7312) {
      return value + 0;

   } else if (value < 7355) {
      return value + -3008;

   } else if (value < 7357) {
      return value + 0;

   } else if (value < 7360) {
      return value + -3008;

   } else if (value < 7680) {
      return value + 0;

   } else if (value < 7681) {
      return value + 1;

   } else if (value < 7682) {
      return value + 0;

   } else if (value < 7683) {
      return value + 1;

   } else if (value < 7684) {
      return value + 0;

   } else if (value < 7685) {
      return value + 1;

   } else if (value < 7686) {
      return value + 0;

   } else if (value < 7687) {
      return value + 1;

   } else if (value < 7688) {
      return value + 0;

   } else if (value < 7689) {
      return value + 1;

   } else if (value < 7690) {
      return value + 0;

   } else if (value < 7691) {
      return value + 1;

   } else if (value < 7692) {
      return value + 0;

   } else if (value < 7693) {
      return value + 1;

   } else if (value < 7694) {
      return value + 0;

   } else if (value < 7695) {
      return value + 1;

   } else if (value < 7696) {
      return value + 0;

   } else if (value < 7697) {
      return value + 1;

   } else if (value < 7698) {
      return value + 0;

   } else if (value < 7699) {
      return value + 1;

   } else if (value < 7700) {
      return value + 0;

   } else if (value < 7701) {
      return value + 1;

   } else if (value < 7702) {
      return value + 0;

   } else if (value < 7703) {
      return value + 1;

   } else if (value < 7704) {
      return value + 0;

   } else if (value < 7705) {
      return value + 1;

   } else if (value < 7706) {
      return value + 0;

   } else if (value < 7707) {
      return value + 1;

   } else if (value < 7708) {
      return value + 0;

   } else if (value < 7709) {
      return value + 1;

   } else if (value < 7710) {
      return value + 0;

   } else if (value < 7711) {
      return value + 1;

   } else if (value < 7712) {
      return value + 0;

   } else if (value < 7713) {
      return value + 1;

   } else if (value < 7714) {
      return value + 0;

   } else if (value < 7715) {
      return value + 1;

   } else if (value < 7716) {
      return value + 0;

   } else if (value < 7717) {
      return value + 1;

   } else if (value < 7718) {
      return value + 0;

   } else if (value < 7719) {
      return value + 1;

   } else if (value < 7720) {
      return value + 0;

   } else if (value < 7721) {
      return value + 1;

   } else if (value < 7722) {
      return value + 0;

   } else if (value < 7723) {
      return value + 1;

   } else if (value < 7724) {
      return value + 0;

   } else if (value < 7725) {
      return value + 1;

   } else if (value < 7726) {
      return value + 0;

   } else if (value < 7727) {
      return value + 1;

   } else if (value < 7728) {
      return value + 0;

   } else if (value < 7729) {
      return value + 1;

   } else if (value < 7730) {
      return value + 0;

   } else if (value < 7731) {
      return value + 1;

   } else if (value < 7732) {
      return value + 0;

   } else if (value < 7733) {
      return value + 1;

   } else if (value < 7734) {
      return value + 0;

   } else if (value < 7735) {
      return value + 1;

   } else if (value < 7736) {
      return value + 0;

   } else if (value < 7737) {
      return value + 1;

   } else if (value < 7738) {
      return value + 0;

   } else if (value < 7739) {
      return value + 1;

   } else if (value < 7740) {
      return value + 0;

   } else if (value < 7741) {
      return value + 1;

   } else if (value < 7742) {
      return value + 0;

   } else if (value < 7743) {
      return value + 1;

   } else if (value < 7744) {
      return value + 0;

   } else if (value < 7745) {
      return value + 1;

   } else if (value < 7746) {
      return value + 0;

   } else if (value < 7747) {
      return value + 1;

   } else if (value < 7748) {
      return value + 0;

   } else if (value < 7749) {
      return value + 1;

   } else if (value < 7750) {
      return value + 0;

   } else if (value < 7751) {
      return value + 1;

   } else if (value < 7752) {
      return value + 0;

   } else if (value < 7753) {
      return value + 1;

   } else if (value < 7754) {
      return value + 0;

   } else if (value < 7755) {
      return value + 1;

   } else if (value < 7756) {
      return value + 0;

   } else if (value < 7757) {
      return value + 1;

   } else if (value < 7758) {
      return value + 0;

   } else if (value < 7759) {
      return value + 1;

   } else if (value < 7760) {
      return value + 0;

   } else if (value < 7761) {
      return value + 1;

   } else if (value < 7762) {
      return value + 0;

   } else if (value < 7763) {
      return value + 1;

   }

   if (value < 7764) {
      return value + 0;

   } else if (value < 7765) {
      return value + 1;

   } else if (value < 7766) {
      return value + 0;

   } else if (value < 7767) {
      return value + 1;

   } else if (value < 7768) {
      return value + 0;

   } else if (value < 7769) {
      return value + 1;

   } else if (value < 7770) {
      return value + 0;

   } else if (value < 7771) {
      return value + 1;

   } else if (value < 7772) {
      return value + 0;

   } else if (value < 7773) {
      return value + 1;

   } else if (value < 7774) {
      return value + 0;

   } else if (value < 7775) {
      return value + 1;

   } else if (value < 7776) {
      return value + 0;

   } else if (value < 7777) {
      return value + 1;

   } else if (value < 7778) {
      return value + 0;

   } else if (value < 7779) {
      return value + 1;

   } else if (value < 7780) {
      return value + 0;

   } else if (value < 7781) {
      return value + 1;

   } else if (value < 7782) {
      return value + 0;

   } else if (value < 7783) {
      return value + 1;

   } else if (value < 7784) {
      return value + 0;

   } else if (value < 7785) {
      return value + 1;

   } else if (value < 7786) {
      return value + 0;

   } else if (value < 7787) {
      return value + 1;

   } else if (value < 7788) {
      return value + 0;

   } else if (value < 7789) {
      return value + 1;

   } else if (value < 7790) {
      return value + 0;

   } else if (value < 7791) {
      return value + 1;

   } else if (value < 7792) {
      return value + 0;

   } else if (value < 7793) {
      return value + 1;

   } else if (value < 7794) {
      return value + 0;

   } else if (value < 7795) {
      return value + 1;

   } else if (value < 7796) {
      return value + 0;

   } else if (value < 7797) {
      return value + 1;

   } else if (value < 7798) {
      return value + 0;

   } else if (value < 7799) {
      return value + 1;

   } else if (value < 7800) {
      return value + 0;

   } else if (value < 7801) {
      return value + 1;

   } else if (value < 7802) {
      return value + 0;

   } else if (value < 7803) {
      return value + 1;

   } else if (value < 7804) {
      return value + 0;

   } else if (value < 7805) {
      return value + 1;

   } else if (value < 7806) {
      return value + 0;

   } else if (value < 7807) {
      return value + 1;

   } else if (value < 7808) {
      return value + 0;

   } else if (value < 7809) {
      return value + 1;

   } else if (value < 7810) {
      return value + 0;

   } else if (value < 7811) {
      return value + 1;

   } else if (value < 7812) {
      return value + 0;

   } else if (value < 7813) {
      return value + 1;

   } else if (value < 7814) {
      return value + 0;

   } else if (value < 7815) {
      return value + 1;

   } else if (value < 7816) {
      return value + 0;

   } else if (value < 7817) {
      return value + 1;

   } else if (value < 7818) {
      return value + 0;

   } else if (value < 7819) {
      return value + 1;

   } else if (value < 7820) {
      return value + 0;

   } else if (value < 7821) {
      return value + 1;

   } else if (value < 7822) {
      return value + 0;

   } else if (value < 7823) {
      return value + 1;

   } else if (value < 7824) {
      return value + 0;

   } else if (value < 7825) {
      return value + 1;

   } else if (value < 7826) {
      return value + 0;

   } else if (value < 7827) {
      return value + 1;

   } else if (value < 7828) {
      return value + 0;

   } else if (value < 7829) {
      return value + 1;

   } else if (value == 7830) {
      // special char
      return 0;

   } else if (value == 7831) {
      // special char
      return 0;

   } else if (value == 7832) {
      // special char
      return 0;

   } else if (value == 7833) {
      // special char
      return 0;

   } else if (value == 7834) {
      // special char
      return 0;

   } else if (value < 7835) {
      return value + 0;

   } else if (value < 7836) {
      return value + -58;

   } else if (value == 7838) {
      // special char
      return 0;

   } else if (value < 7840) {
      return value + 0;

   } else if (value < 7841) {
      return value + 1;

   } else if (value < 7842) {
      return value + 0;

   } else if (value < 7843) {
      return value + 1;

   } else if (value < 7844) {
      return value + 0;

   } else if (value < 7845) {
      return value + 1;

   } else if (value < 7846) {
      return value + 0;

   } else if (value < 7847) {
      return value + 1;

   } else if (value < 7848) {
      return value + 0;

   } else if (value < 7849) {
      return value + 1;

   } else if (value < 7850) {
      return value + 0;

   } else if (value < 7851) {
      return value + 1;

   } else if (value < 7852) {
      return value + 0;

   } else if (value < 7853) {
      return value + 1;

   } else if (value < 7854) {
      return value + 0;

   } else if (value < 7855) {
      return value + 1;

   } else if (value < 7856) {
      return value + 0;

   } else if (value < 7857) {
      return value + 1;

   } else if (value < 7858) {
      return value + 0;

   } else if (value < 7859) {
      return value + 1;

   } else if (value < 7860) {
      return value + 0;

   } else if (value < 7861) {
      return value + 1;

   } else if (value < 7862) {
      return value + 0;

   } else if (value < 7863) {
      return value + 1;

   } else if (value < 7864) {
      return value + 0;

   } else if (value < 7865) {
      return value + 1;

   }

   if (value < 7866) {
      return value + 0;

   } else if (value < 7867) {
      return value + 1;

   } else if (value < 7868) {
      return value + 0;

   } else if (value < 7869) {
      return value + 1;

   } else if (value < 7870) {
      return value + 0;

   } else if (value < 7871) {
      return value + 1;

   } else if (value < 7872) {
      return value + 0;

   } else if (value < 7873) {
      return value + 1;

   } else if (value < 7874) {
      return value + 0;

   } else if (value < 7875) {
      return value + 1;

   } else if (value < 7876) {
      return value + 0;

   } else if (value < 7877) {
      return value + 1;

   } else if (value < 7878) {
      return value + 0;

   } else if (value < 7879) {
      return value + 1;

   } else if (value < 7880) {
      return value + 0;

   } else if (value < 7881) {
      return value + 1;

   } else if (value < 7882) {
      return value + 0;

   } else if (value < 7883) {
      return value + 1;

   } else if (value < 7884) {
      return value + 0;

   } else if (value < 7885) {
      return value + 1;

   } else if (value < 7886) {
      return value + 0;

   } else if (value < 7887) {
      return value + 1;

   } else if (value < 7888) {
      return value + 0;

   } else if (value < 7889) {
      return value + 1;

   } else if (value < 7890) {
      return value + 0;

   } else if (value < 7891) {
      return value + 1;

   } else if (value < 7892) {
      return value + 0;

   } else if (value < 7893) {
      return value + 1;

   } else if (value < 7894) {
      return value + 0;

   } else if (value < 7895) {
      return value + 1;

   } else if (value < 7896) {
      return value + 0;

   } else if (value < 7897) {
      return value + 1;

   } else if (value < 7898) {
      return value + 0;

   } else if (value < 7899) {
      return value + 1;

   } else if (value < 7900) {
      return value + 0;

   } else if (value < 7901) {
      return value + 1;

   } else if (value < 7902) {
      return value + 0;

   } else if (value < 7903) {
      return value + 1;

   } else if (value < 7904) {
      return value + 0;

   } else if (value < 7905) {
      return value + 1;

   } else if (value < 7906) {
      return value + 0;

   } else if (value < 7907) {
      return value + 1;

   } else if (value < 7908) {
      return value + 0;

   } else if (value < 7909) {
      return value + 1;

   } else if (value < 7910) {
      return value + 0;

   } else if (value < 7911) {
      return value + 1;

   } else if (value < 7912) {
      return value + 0;

   } else if (value < 7913) {
      return value + 1;

   } else if (value < 7914) {
      return value + 0;

   } else if (value < 7915) {
      return value + 1;

   } else if (value < 7916) {
      return value + 0;

   } else if (value < 7917) {
      return value + 1;

   } else if (value < 7918) {
      return value + 0;

   } else if (value < 7919) {
      return value + 1;

   } else if (value < 7920) {
      return value + 0;

   } else if (value < 7921) {
      return value + 1;

   } else if (value < 7922) {
      return value + 0;

   } else if (value < 7923) {
      return value + 1;

   } else if (value < 7924) {
      return value + 0;

   } else if (value < 7925) {
      return value + 1;

   } else if (value < 7926) {
      return value + 0;

   } else if (value < 7927) {
      return value + 1;

   } else if (value < 7928) {
      return value + 0;

   } else if (value < 7929) {
      return value + 1;

   } else if (value < 7930) {
      return value + 0;

   } else if (value < 7931) {
      return value + 1;

   } else if (value < 7932) {
      return value + 0;

   } else if (value < 7933) {
      return value + 1;

   } else if (value < 7934) {
      return value + 0;

   } else if (value < 7935) {
      return value + 1;

   } else if (value < 7944) {
      return value + 0;

   } else if (value < 7952) {
      return value + -8;

   } else if (value < 7960) {
      return value + 0;

   } else if (value < 7966) {
      return value + -8;

   } else if (value < 7976) {
      return value + 0;

   } else if (value < 7984) {
      return value + -8;

   } else if (value < 7992) {
      return value + 0;

   } else if (value < 8000) {
      return value + -8;

   } else if (value < 8008) {
      return value + 0;

   } else if (value < 8014) {
      return value + -8;

   } else if (value == 8016) {
      // special char
      return 0;

   } else if (value == 8018) {
      // special char
      return 0;

   } else if (value == 8020) {
      // special char
      return 0;

   } else if (value == 8022) {
      // special char
      return 0;

   } else if (value < 8025) {
      return value + 0;

   } else if (value < 8026) {
      return value + -8;

   } else if (value < 8027) {
      return value + 0;

   } else if (value < 8028) {
      return value + -8;

   } else if (value < 8029) {
      return value + 0;

   } else if (value < 8030) {
      return value + -8;

   } else if (value < 8031) {
      return value + 0;

   } else if (value < 8032) {
      return value + -8;

   } else if (value < 8040) {
      return value + 0;

   } else if (value < 8048) {
      return value + -8;

   } else if (value == 8064) {
      // special char
      return 0;

   } else if (value == 8065) {
      // special char
      return 0;

   } else if (value == 8066) {
      // special char
      return 0;

   } else if (value == 8067) {
      // special char
      return 0;

   } else if (value == 8068) {
      // special char
      return 0;

   } else if (value == 8069) {
      // special char
      return 0;

   }

   if (value == 8070) {
      // special char
      return 0;

   } else if (value == 8071) {
      // special char
      return 0;

   } else if (value == 8072) {
      // special char
      return 0;

   } else if (value == 8073) {
      // special char
      return 0;

   } else if (value == 8074) {
      // special char
      return 0;

   } else if (value == 8075) {
      // special char
      return 0;

   } else if (value == 8076) {
      // special char
      return 0;

   } else if (value == 8077) {
      // special char
      return 0;

   } else if (value == 8078) {
      // special char
      return 0;

   } else if (value == 8079) {
      // special char
      return 0;

   } else if (value == 8080) {
      // special char
      return 0;

   } else if (value == 8081) {
      // special char
      return 0;

   } else if (value == 8082) {
      // special char
      return 0;

   } else if (value == 8083) {
      // special char
      return 0;

   } else if (value == 8084) {
      // special char
      return 0;

   } else if (value == 8085) {
      // special char
      return 0;

   } else if (value == 8086) {
      // special char
      return 0;

   } else if (value == 8087) {
      // special char
      return 0;

   } else if (value == 8088) {
      // special char
      return 0;

   } else if (value == 8089) {
      // special char
      return 0;

   } else if (value == 8090) {
      // special char
      return 0;

   } else if (value == 8091) {
      // special char
      return 0;

   } else if (value == 8092) {
      // special char
      return 0;

   } else if (value == 8093) {
      // special char
      return 0;

   } else if (value == 8094) {
      // special char
      return 0;

   } else if (value == 8095) {
      // special char
      return 0;

   } else if (value == 8096) {
      // special char
      return 0;

   } else if (value == 8097) {
      // special char
      return 0;

   } else if (value == 8098) {
      // special char
      return 0;

   } else if (value == 8099) {
      // special char
      return 0;

   } else if (value == 8100) {
      // special char
      return 0;

   } else if (value == 8101) {
      // special char
      return 0;

   } else if (value == 8102) {
      // special char
      return 0;

   } else if (value == 8103) {
      // special char
      return 0;

   } else if (value == 8104) {
      // special char
      return 0;

   } else if (value == 8105) {
      // special char
      return 0;

   } else if (value == 8106) {
      // special char
      return 0;

   } else if (value == 8107) {
      // special char
      return 0;

   } else if (value == 8108) {
      // special char
      return 0;

   } else if (value == 8109) {
      // special char
      return 0;

   } else if (value == 8110) {
      // special char
      return 0;

   } else if (value == 8111) {
      // special char
      return 0;

   } else if (value == 8114) {
      // special char
      return 0;

   } else if (value == 8115) {
      // special char
      return 0;

   } else if (value == 8116) {
      // special char
      return 0;

   } else if (value == 8118) {
      // special char
      return 0;

   } else if (value == 8119) {
      // special char
      return 0;

   } else if (value < 8120) {
      return value + 0;

   } else if (value < 8122) {
      return value + -8;

   } else if (value == 8124) {
      // special char
      return 0;

   } else if (value < 8125) {
      return value + -74;

   } else if (value < 8126) {
      return value + 0;

   } else if (value < 8127) {
      return value + -7173;

   } else if (value == 8130) {
      // special char
      return 0;

   } else if (value == 8131) {
      // special char
      return 0;

   } else if (value == 8132) {
      // special char
      return 0;

   } else if (value == 8134) {
      // special char
      return 0;

   } else if (value == 8135) {
      // special char
      return 0;

   } else if (value < 8136) {
      return value + 0;

   } else if (value == 8140) {
      // special char
      return 0;

   } else if (value < 8141) {
      return value + -86;

   } else if (value == 8146) {
      // special char
      return 0;

   } else if (value == 8147) {
      // special char
      return 0;

   } else if (value == 8150) {
      // special char
      return 0;

   } else if (value == 8151) {
      // special char
      return 0;

   } else if (value < 8152) {
      return value + 0;

   } else if (value < 8154) {
      return value + -8;

   } else if (value < 8156) {
      return value + -100;

   } else if (value == 8162) {
      // special char
      return 0;

   } else if (value == 8163) {
      // special char
      return 0;

   } else if (value == 8164) {
      // special char
      return 0;

   } else if (value == 8166) {
      // special char
      return 0;

   } else if (value == 8167) {
      // special char
      return 0;

   } else if (value < 8168) {
      return value + 0;

   } else if (value < 8170) {
      return value + -8;

   } else if (value < 8172) {
      return value + -112;

   } else if (value < 8173) {
      return value + -7;

   } else if (value == 8178) {
      // special char
      return 0;

   } else if (value == 8179) {
      // special char
      return 0;

   } else if (value == 8180) {
      // special char
      return 0;

   } else if (value == 8182) {
      // special char
      return 0;

   } else if (value == 8183) {
      // special char
      return 0;

   } else if (value < 8184) {
      return value + 0;

   } else if (value < 8186) {
      return value + -128;

   } else if (value == 8188) {
      // special char
      return 0;

   } else if (value < 8189) {
      return value + -126;

   } else if (value < 8486) {
      return value + 0;

   } else if (value < 8487) {
      return value + -7517;

   } else if (value < 8490) {
      return value + 0;

   } else if (value < 8491) {
      return value + -8383;

   } else if (value < 8492) {
      return value + -8262;

   } else if (value < 8498) {
      return value + 0;

   } else if (value < 8499) {
      return value + 28;

   } else if (value < 8544) {
      return value + 0;

   } else if (value < 8560) {
      return value + 16;

   } else if (value < 8579) {
      return value + 0;

   } else if (value < 8580) {
      return value + 1;

   } else if (value < 9398) {
      return value + 0;

   } else if (value < 9424) {
      return value + 26;

   } else if (value < 11264) {
      return value + 0;

   }

   if (value < 11312) {
      return value + 48;

   } else if (value < 11360) {
      return value + 0;

   } else if (value < 11361) {
      return value + 1;

   } else if (value < 11362) {
      return value + 0;

   } else if (value < 11363) {
      return value + -10743;

   } else if (value < 11364) {
      return value + -3814;

   } else if (value < 11365) {
      return value + -10727;

   } else if (value < 11367) {
      return value + 0;

   } else if (value < 11368) {
      return value + 1;

   } else if (value < 11369) {
      return value + 0;

   } else if (value < 11370) {
      return value + 1;

   } else if (value < 11371) {
      return value + 0;

   } else if (value < 11372) {
      return value + 1;

   } else if (value < 11373) {
      return value + 0;

   } else if (value < 11374) {
      return value + -10780;

   } else if (value < 11375) {
      return value + -10749;

   } else if (value < 11376) {
      return value + -10783;

   } else if (value < 11377) {
      return value + -10782;

   } else if (value < 11378) {
      return value + 0;

   } else if (value < 11379) {
      return value + 1;

   } else if (value < 11381) {
      return value + 0;

   } else if (value < 11382) {
      return value + 1;

   } else if (value < 11390) {
      return value + 0;

   } else if (value < 11392) {
      return value + -10815;

   } else if (value < 11393) {
      return value + 1;

   } else if (value < 11394) {
      return value + 0;

   } else if (value < 11395) {
      return value + 1;

   } else if (value < 11396) {
      return value + 0;

   } else if (value < 11397) {
      return value + 1;

   } else if (value < 11398) {
      return value + 0;

   } else if (value < 11399) {
      return value + 1;

   } else if (value < 11400) {
      return value + 0;

   } else if (value < 11401) {
      return value + 1;

   } else if (value < 11402) {
      return value + 0;

   } else if (value < 11403) {
      return value + 1;

   } else if (value < 11404) {
      return value + 0;

   } else if (value < 11405) {
      return value + 1;

   } else if (value < 11406) {
      return value + 0;

   } else if (value < 11407) {
      return value + 1;

   } else if (value < 11408) {
      return value + 0;

   } else if (value < 11409) {
      return value + 1;

   } else if (value < 11410) {
      return value + 0;

   } else if (value < 11411) {
      return value + 1;

   } else if (value < 11412) {
      return value + 0;

   } else if (value < 11413) {
      return value + 1;

   } else if (value < 11414) {
      return value + 0;

   } else if (value < 11415) {
      return value + 1;

   } else if (value < 11416) {
      return value + 0;

   } else if (value < 11417) {
      return value + 1;

   } else if (value < 11418) {
      return value + 0;

   } else if (value < 11419) {
      return value + 1;

   } else if (value < 11420) {
      return value + 0;

   } else if (value < 11421) {
      return value + 1;

   } else if (value < 11422) {
      return value + 0;

   } else if (value < 11423) {
      return value + 1;

   } else if (value < 11424) {
      return value + 0;

   } else if (value < 11425) {
      return value + 1;

   } else if (value < 11426) {
      return value + 0;

   } else if (value < 11427) {
      return value + 1;

   } else if (value < 11428) {
      return value + 0;

   } else if (value < 11429) {
      return value + 1;

   } else if (value < 11430) {
      return value + 0;

   } else if (value < 11431) {
      return value + 1;

   } else if (value < 11432) {
      return value + 0;

   } else if (value < 11433) {
      return value + 1;

   } else if (value < 11434) {
      return value + 0;

   } else if (value < 11435) {
      return value + 1;

   } else if (value < 11436) {
      return value + 0;

   } else if (value < 11437) {
      return value + 1;

   } else if (value < 11438) {
      return value + 0;

   } else if (value < 11439) {
      return value + 1;

   } else if (value < 11440) {
      return value + 0;

   } else if (value < 11441) {
      return value + 1;

   } else if (value < 11442) {
      return value + 0;

   } else if (value < 11443) {
      return value + 1;

   } else if (value < 11444) {
      return value + 0;

   } else if (value < 11445) {
      return value + 1;

   } else if (value < 11446) {
      return value + 0;

   } else if (value < 11447) {
      return value + 1;

   } else if (value < 11448) {
      return value + 0;

   } else if (value < 11449) {
      return value + 1;

   } else if (value < 11450) {
      return value + 0;

   } else if (value < 11451) {
      return value + 1;

   } else if (value < 11452) {
      return value + 0;

   } else if (value < 11453) {
      return value + 1;

   } else if (value < 11454) {
      return value + 0;

   } else if (value < 11455) {
      return value + 1;

   } else if (value < 11456) {
      return value + 0;

   } else if (value < 11457) {
      return value + 1;

   } else if (value < 11458) {
      return value + 0;

   } else if (value < 11459) {
      return value + 1;

   } else if (value < 11460) {
      return value + 0;

   } else if (value < 11461) {
      return value + 1;

   } else if (value < 11462) {
      return value + 0;

   } else if (value < 11463) {
      return value + 1;

   } else if (value < 11464) {
      return value + 0;

   } else if (value < 11465) {
      return value + 1;

   } else if (value < 11466) {
      return value + 0;

   } else if (value < 11467) {
      return value + 1;

   } else if (value < 11468) {
      return value + 0;

   }

   if (value < 11469) {
      return value + 1;

   } else if (value < 11470) {
      return value + 0;

   } else if (value < 11471) {
      return value + 1;

   } else if (value < 11472) {
      return value + 0;

   } else if (value < 11473) {
      return value + 1;

   } else if (value < 11474) {
      return value + 0;

   } else if (value < 11475) {
      return value + 1;

   } else if (value < 11476) {
      return value + 0;

   } else if (value < 11477) {
      return value + 1;

   } else if (value < 11478) {
      return value + 0;

   } else if (value < 11479) {
      return value + 1;

   } else if (value < 11480) {
      return value + 0;

   } else if (value < 11481) {
      return value + 1;

   } else if (value < 11482) {
      return value + 0;

   } else if (value < 11483) {
      return value + 1;

   } else if (value < 11484) {
      return value + 0;

   } else if (value < 11485) {
      return value + 1;

   } else if (value < 11486) {
      return value + 0;

   } else if (value < 11487) {
      return value + 1;

   } else if (value < 11488) {
      return value + 0;

   } else if (value < 11489) {
      return value + 1;

   } else if (value < 11490) {
      return value + 0;

   } else if (value < 11491) {
      return value + 1;

   } else if (value < 11499) {
      return value + 0;

   } else if (value < 11500) {
      return value + 1;

   } else if (value < 11501) {
      return value + 0;

   } else if (value < 11502) {
      return value + 1;

   } else if (value < 11506) {
      return value + 0;

   } else if (value < 11507) {
      return value + 1;

   } else if (value < 42560) {
      return value + 0;

   } else if (value < 42561) {
      return value + 1;

   } else if (value < 42562) {
      return value + 0;

   } else if (value < 42563) {
      return value + 1;

   } else if (value < 42564) {
      return value + 0;

   } else if (value < 42565) {
      return value + 1;

   } else if (value < 42566) {
      return value + 0;

   } else if (value < 42567) {
      return value + 1;

   } else if (value < 42568) {
      return value + 0;

   } else if (value < 42569) {
      return value + 1;

   } else if (value < 42570) {
      return value + 0;

   } else if (value < 42571) {
      return value + 1;

   } else if (value < 42572) {
      return value + 0;

   } else if (value < 42573) {
      return value + 1;

   } else if (value < 42574) {
      return value + 0;

   } else if (value < 42575) {
      return value + 1;

   } else if (value < 42576) {
      return value + 0;

   } else if (value < 42577) {
      return value + 1;

   } else if (value < 42578) {
      return value + 0;

   } else if (value < 42579) {
      return value + 1;

   } else if (value < 42580) {
      return value + 0;

   } else if (value < 42581) {
      return value + 1;

   } else if (value < 42582) {
      return value + 0;

   } else if (value < 42583) {
      return value + 1;

   } else if (value < 42584) {
      return value + 0;

   } else if (value < 42585) {
      return value + 1;

   } else if (value < 42586) {
      return value + 0;

   } else if (value < 42587) {
      return value + 1;

   } else if (value < 42588) {
      return value + 0;

   } else if (value < 42589) {
      return value + 1;

   } else if (value < 42590) {
      return value + 0;

   } else if (value < 42591) {
      return value + 1;

   } else if (value < 42592) {
      return value + 0;

   } else if (value < 42593) {
      return value + 1;

   } else if (value < 42594) {
      return value + 0;

   } else if (value < 42595) {
      return value + 1;

   } else if (value < 42596) {
      return value + 0;

   } else if (value < 42597) {
      return value + 1;

   } else if (value < 42598) {
      return value + 0;

   } else if (value < 42599) {
      return value + 1;

   } else if (value < 42600) {
      return value + 0;

   } else if (value < 42601) {
      return value + 1;

   } else if (value < 42602) {
      return value + 0;

   } else if (value < 42603) {
      return value + 1;

   } else if (value < 42604) {
      return value + 0;

   } else if (value < 42605) {
      return value + 1;

   } else if (value < 42624) {
      return value + 0;

   } else if (value < 42625) {
      return value + 1;

   } else if (value < 42626) {
      return value + 0;

   } else if (value < 42627) {
      return value + 1;

   } else if (value < 42628) {
      return value + 0;

   } else if (value < 42629) {
      return value + 1;

   } else if (value < 42630) {
      return value + 0;

   } else if (value < 42631) {
      return value + 1;

   } else if (value < 42632) {
      return value + 0;

   } else if (value < 42633) {
      return value + 1;

   } else if (value < 42634) {
      return value + 0;

   } else if (value < 42635) {
      return value + 1;

   } else if (value < 42636) {
      return value + 0;

   } else if (value < 42637) {
      return value + 1;

   } else if (value < 42638) {
      return value + 0;

   } else if (value < 42639) {
      return value + 1;

   } else if (value < 42640) {
      return value + 0;

   } else if (value < 42641) {
      return value + 1;

   } else if (value < 42642) {
      return value + 0;

   } else if (value < 42643) {
      return value + 1;

   } else if (value < 42644) {
      return value + 0;

   } else if (value < 42645) {
      return value + 1;

   } else if (value < 42646) {
      return value + 0;

   } else if (value < 42647) {
      return value + 1;

   } else if (value < 42648) {
      return value + 0;

   }

   if (value < 42649) {
      return value + 1;

   } else if (value < 42650) {
      return value + 0;

   } else if (value < 42651) {
      return value + 1;

   } else if (value < 42786) {
      return value + 0;

   } else if (value < 42787) {
      return value + 1;

   } else if (value < 42788) {
      return value + 0;

   } else if (value < 42789) {
      return value + 1;

   } else if (value < 42790) {
      return value + 0;

   } else if (value < 42791) {
      return value + 1;

   } else if (value < 42792) {
      return value + 0;

   } else if (value < 42793) {
      return value + 1;

   } else if (value < 42794) {
      return value + 0;

   } else if (value < 42795) {
      return value + 1;

   } else if (value < 42796) {
      return value + 0;

   } else if (value < 42797) {
      return value + 1;

   } else if (value < 42798) {
      return value + 0;

   } else if (value < 42799) {
      return value + 1;

   } else if (value < 42802) {
      return value + 0;

   } else if (value < 42803) {
      return value + 1;

   } else if (value < 42804) {
      return value + 0;

   } else if (value < 42805) {
      return value + 1;

   } else if (value < 42806) {
      return value + 0;

   } else if (value < 42807) {
      return value + 1;

   } else if (value < 42808) {
      return value + 0;

   } else if (value < 42809) {
      return value + 1;

   } else if (value < 42810) {
      return value + 0;

   } else if (value < 42811) {
      return value + 1;

   } else if (value < 42812) {
      return value + 0;

   } else if (value < 42813) {
      return value + 1;

   } else if (value < 42814) {
      return value + 0;

   } else if (value < 42815) {
      return value + 1;

   } else if (value < 42816) {
      return value + 0;

   } else if (value < 42817) {
      return value + 1;

   } else if (value < 42818) {
      return value + 0;

   } else if (value < 42819) {
      return value + 1;

   } else if (value < 42820) {
      return value + 0;

   } else if (value < 42821) {
      return value + 1;

   } else if (value < 42822) {
      return value + 0;

   } else if (value < 42823) {
      return value + 1;

   } else if (value < 42824) {
      return value + 0;

   } else if (value < 42825) {
      return value + 1;

   } else if (value < 42826) {
      return value + 0;

   } else if (value < 42827) {
      return value + 1;

   } else if (value < 42828) {
      return value + 0;

   } else if (value < 42829) {
      return value + 1;

   } else if (value < 42830) {
      return value + 0;

   } else if (value < 42831) {
      return value + 1;

   } else if (value < 42832) {
      return value + 0;

   } else if (value < 42833) {
      return value + 1;

   } else if (value < 42834) {
      return value + 0;

   } else if (value < 42835) {
      return value + 1;

   } else if (value < 42836) {
      return value + 0;

   } else if (value < 42837) {
      return value + 1;

   } else if (value < 42838) {
      return value + 0;

   } else if (value < 42839) {
      return value + 1;

   } else if (value < 42840) {
      return value + 0;

   } else if (value < 42841) {
      return value + 1;

   } else if (value < 42842) {
      return value + 0;

   } else if (value < 42843) {
      return value + 1;

   } else if (value < 42844) {
      return value + 0;

   } else if (value < 42845) {
      return value + 1;

   } else if (value < 42846) {
      return value + 0;

   } else if (value < 42847) {
      return value + 1;

   } else if (value < 42848) {
      return value + 0;

   } else if (value < 42849) {
      return value + 1;

   } else if (value < 42850) {
      return value + 0;

   } else if (value < 42851) {
      return value + 1;

   } else if (value < 42852) {
      return value + 0;

   } else if (value < 42853) {
      return value + 1;

   } else if (value < 42854) {
      return value + 0;

   } else if (value < 42855) {
      return value + 1;

   } else if (value < 42856) {
      return value + 0;

   } else if (value < 42857) {
      return value + 1;

   } else if (value < 42858) {
      return value + 0;

   } else if (value < 42859) {
      return value + 1;

   } else if (value < 42860) {
      return value + 0;

   } else if (value < 42861) {
      return value + 1;

   } else if (value < 42862) {
      return value + 0;

   } else if (value < 42863) {
      return value + 1;

   } else if (value < 42873) {
      return value + 0;

   } else if (value < 42874) {
      return value + 1;

   } else if (value < 42875) {
      return value + 0;

   } else if (value < 42876) {
      return value + 1;

   } else if (value < 42877) {
      return value + 0;

   } else if (value < 42878) {
      return value + -35332;

   } else if (value < 42879) {
      return value + 1;

   } else if (value < 42880) {
      return value + 0;

   } else if (value < 42881) {
      return value + 1;

   } else if (value < 42882) {
      return value + 0;

   } else if (value < 42883) {
      return value + 1;

   } else if (value < 42884) {
      return value + 0;

   } else if (value < 42885) {
      return value + 1;

   } else if (value < 42886) {
      return value + 0;

   } else if (value < 42887) {
      return value + 1;

   } else if (value < 42891) {
      return value + 0;

   } else if (value < 42892) {
      return value + 1;

   } else if (value < 42893) {
      return value + 0;

   } else if (value < 42894) {
      return value + -42280;

   } else if (value < 42896) {
      return value + 0;

   } else if (value < 42897) {
      return value + 1;

   }

   if (value < 42898) {
      return value + 0;

   } else if (value < 42899) {
      return value + 1;

   } else if (value < 42902) {
      return value + 0;

   } else if (value < 42903) {
      return value + 1;

   } else if (value < 42904) {
      return value + 0;

   } else if (value < 42905) {
      return value + 1;

   } else if (value < 42906) {
      return value + 0;

   } else if (value < 42907) {
      return value + 1;

   } else if (value < 42908) {
      return value + 0;

   } else if (value < 42909) {
      return value + 1;

   } else if (value < 42910) {
      return value + 0;

   } else if (value < 42911) {
      return value + 1;

   } else if (value < 42912) {
      return value + 0;

   } else if (value < 42913) {
      return value + 1;

   } else if (value < 42914) {
      return value + 0;

   } else if (value < 42915) {
      return value + 1;

   } else if (value < 42916) {
      return value + 0;

   } else if (value < 42917) {
      return value + 1;

   } else if (value < 42918) {
      return value + 0;

   } else if (value < 42919) {
      return value + 1;

   } else if (value < 42920) {
      return value + 0;

   } else if (value < 42921) {
      return value + 1;

   } else if (value < 42922) {
      return value + 0;

   } else if (value < 42923) {
      return value + -42308;

   } else if (value < 42924) {
      return value + -42319;

   } else if (value < 42925) {
      return value + -42315;

   } else if (value < 42926) {
      return value + -42305;

   } else if (value < 42927) {
      return value + -42308;

   } else if (value < 42928) {
      return value + 0;

   } else if (value < 42929) {
      return value + -42258;

   } else if (value < 42930) {
      return value + -42282;

   } else if (value < 42931) {
      return value + -42261;

   } else if (value < 42932) {
      return value + 928;

   } else if (value < 42933) {
      return value + 1;

   } else if (value < 42934) {
      return value + 0;

   } else if (value < 42935) {
      return value + 1;

   } else if (value < 42936) {
      return value + 0;

   } else if (value < 42937) {
      return value + 1;

   } else if (value < 42938) {
      return value + 0;

   } else if (value < 42939) {
      return value + 1;

   } else if (value < 42940) {
      return value + 0;

   } else if (value < 42941) {
      return value + 1;

   } else if (value < 42942) {
      return value + 0;

   } else if (value < 42943) {
      return value + 1;

   } else if (value < 42944) {
      return value + 0;

   } else if (value < 42945) {
      return value + 1;

   } else if (value < 42946) {
      return value + 0;

   } else if (value < 42947) {
      return value + 1;

   } else if (value < 42948) {
      return value + 0;

   } else if (value < 42949) {
      return value + -48;

   } else if (value < 42950) {
      return value + -42307;

   } else if (value < 42951) {
      return value + -35384;

   } else if (value < 42952) {
      return value + 1;

   } else if (value < 42953) {
      return value + 0;

   } else if (value < 42954) {
      return value + 1;

   } else if (value < 42960) {
      return value + 0;

   } else if (value < 42961) {
      return value + 1;

   } else if (value < 42966) {
      return value + 0;

   } else if (value < 42967) {
      return value + 1;

   } else if (value < 42968) {
      return value + 0;

   } else if (value < 42969) {
      return value + 1;

   } else if (value < 42997) {
      return value + 0;

   } else if (value < 42998) {
      return value + 1;

   } else if (value < 43888) {
      return value + 0;

   } else if (value < 43968) {
      return value + -38864;

   } else if (value == 64256) {
      // special char
      return 0;

   } else if (value == 64257) {
      // special char
      return 0;

   } else if (value == 64258) {
      // special char
      return 0;

   } else if (value == 64259) {
      // special char
      return 0;

   } else if (value == 64260) {
      // special char
      return 0;

   } else if (value == 64261) {
      // special char
      return 0;

   } else if (value == 64262) {
      // special char
      return 0;

   } else if (value == 64275) {
      // special char
      return 0;

   } else if (value == 64276) {
      // special char
      return 0;

   } else if (value == 64277) {
      // special char
      return 0;

   } else if (value == 64278) {
      // special char
      return 0;

   } else if (value == 64279) {
      // special char
      return 0;

   } else if (value < 65313) {
      return value + 0;

   } else if (value < 65339) {
      return value + 32;

   } else if (value < 66560) {
      return value + 0;

   } else if (value < 66600) {
      return value + 40;

   } else if (value < 66736) {
      return value + 0;

   } else if (value < 66772) {
      return value + 40;

   } else if (value < 66928) {
      return value + 0;

   } else if (value < 66939) {
      return value + 39;

   } else if (value < 66940) {
      return value + 0;

   } else if (value < 66955) {
      return value + 39;

   } else if (value < 66956) {
      return value + 0;

   } else if (value < 66963) {
      return value + 39;

   } else if (value < 66964) {
      return value + 0;

   } else if (value < 66966) {
      return value + 39;

   } else if (value < 68736) {
      return value + 0;

   } else if (value < 68787) {
      return value + 64;

   } else if (value < 71840) {
      return value + 0;

   } else if (value < 71872) {
      return value + 32;

   } else if (value < 93760) {
      return value + 0;

   } else if (value < 93792) {
      return value + 32;

   } else if (value < 125184) {
      return value + 0;

   } else if (value < 125218) {
      return value + 34;

   } else {
      return value;
   }
}

char32_t uc_lowerCase(char32_t value)
{
   if (value < 65) {
      return value + 0;

   } else if (value < 91) {
      return value + 32;

   } else if (value < 192) {
      return value + 0;

   } else if (value < 215) {
      return value + 32;

   } else if (value < 216) {
      return value + 0;

   } else if (value < 223) {
      return value + 32;

   } else if (value < 256) {
      return value + 0;

   } else if (value < 257) {
      return value + 1;

   } else if (value < 258) {
      return value + 0;

   } else if (value < 259) {
      return value + 1;

   } else if (value < 260) {
      return value + 0;

   } else if (value < 261) {
      return value + 1;

   } else if (value < 262) {
      return value + 0;

   } else if (value < 263) {
      return value + 1;

   } else if (value < 264) {
      return value + 0;

   } else if (value < 265) {
      return value + 1;

   } else if (value < 266) {
      return value + 0;

   } else if (value < 267) {
      return value + 1;

   } else if (value < 268) {
      return value + 0;

   } else if (value < 269) {
      return value + 1;

   } else if (value < 270) {
      return value + 0;

   } else if (value < 271) {
      return value + 1;

   } else if (value < 272) {
      return value + 0;

   } else if (value < 273) {
      return value + 1;

   } else if (value < 274) {
      return value + 0;

   } else if (value < 275) {
      return value + 1;

   } else if (value < 276) {
      return value + 0;

   } else if (value < 277) {
      return value + 1;

   } else if (value < 278) {
      return value + 0;

   } else if (value < 279) {
      return value + 1;

   } else if (value < 280) {
      return value + 0;

   } else if (value < 281) {
      return value + 1;

   } else if (value < 282) {
      return value + 0;

   } else if (value < 283) {
      return value + 1;

   } else if (value < 284) {
      return value + 0;

   } else if (value < 285) {
      return value + 1;

   } else if (value < 286) {
      return value + 0;

   } else if (value < 287) {
      return value + 1;

   } else if (value < 288) {
      return value + 0;

   } else if (value < 289) {
      return value + 1;

   } else if (value < 290) {
      return value + 0;

   } else if (value < 291) {
      return value + 1;

   } else if (value < 292) {
      return value + 0;

   } else if (value < 293) {
      return value + 1;

   } else if (value < 294) {
      return value + 0;

   } else if (value < 295) {
      return value + 1;

   } else if (value < 296) {
      return value + 0;

   } else if (value < 297) {
      return value + 1;

   } else if (value < 298) {
      return value + 0;

   } else if (value < 299) {
      return value + 1;

   } else if (value < 300) {
      return value + 0;

   } else if (value < 301) {
      return value + 1;

   } else if (value < 302) {
      return value + 0;

   } else if (value < 303) {
      return value + 1;

   } else if (value == 304) {
      // special char
      return 0;

   } else if (value < 306) {
      return value + 0;

   } else if (value < 307) {
      return value + 1;

   } else if (value < 308) {
      return value + 0;

   } else if (value < 309) {
      return value + 1;

   } else if (value < 310) {
      return value + 0;

   } else if (value < 311) {
      return value + 1;

   } else if (value < 313) {
      return value + 0;

   } else if (value < 314) {
      return value + 1;

   } else if (value < 315) {
      return value + 0;

   } else if (value < 316) {
      return value + 1;

   } else if (value < 317) {
      return value + 0;

   } else if (value < 318) {
      return value + 1;

   } else if (value < 319) {
      return value + 0;

   } else if (value < 320) {
      return value + 1;

   } else if (value < 321) {
      return value + 0;

   } else if (value < 322) {
      return value + 1;

   } else if (value < 323) {
      return value + 0;

   } else if (value < 324) {
      return value + 1;

   } else if (value < 325) {
      return value + 0;

   } else if (value < 326) {
      return value + 1;

   } else if (value < 327) {
      return value + 0;

   } else if (value < 328) {
      return value + 1;

   } else if (value < 330) {
      return value + 0;

   } else if (value < 331) {
      return value + 1;

   } else if (value < 332) {
      return value + 0;

   } else if (value < 333) {
      return value + 1;

   } else if (value < 334) {
      return value + 0;

   } else if (value < 335) {
      return value + 1;

   } else if (value < 336) {
      return value + 0;

   } else if (value < 337) {
      return value + 1;

   } else if (value < 338) {
      return value + 0;

   } else if (value < 339) {
      return value + 1;

   } else if (value < 340) {
      return value + 0;

   } else if (value < 341) {
      return value + 1;

   } else if (value < 342) {
      return value + 0;

   } else if (value < 343) {
      return value + 1;

   } else if (value < 344) {
      return value + 0;

   } else if (value < 345) {
      return value + 1;

   } else if (value < 346) {
      return value + 0;

   } else if (value < 347) {
      return value + 1;

   } else if (value < 348) {
      return value + 0;

   } else if (value < 349) {
      return value + 1;

   } else if (value < 350) {
      return value + 0;

   } else if (value < 351) {
      return value + 1;

   } else if (value < 352) {
      return value + 0;

   } else if (value < 353) {
      return value + 1;

   }

   if (value < 354) {
      return value + 0;

   } else if (value < 355) {
      return value + 1;

   } else if (value < 356) {
      return value + 0;

   } else if (value < 357) {
      return value + 1;

   } else if (value < 358) {
      return value + 0;

   } else if (value < 359) {
      return value + 1;

   } else if (value < 360) {
      return value + 0;

   } else if (value < 361) {
      return value + 1;

   } else if (value < 362) {
      return value + 0;

   } else if (value < 363) {
      return value + 1;

   } else if (value < 364) {
      return value + 0;

   } else if (value < 365) {
      return value + 1;

   } else if (value < 366) {
      return value + 0;

   } else if (value < 367) {
      return value + 1;

   } else if (value < 368) {
      return value + 0;

   } else if (value < 369) {
      return value + 1;

   } else if (value < 370) {
      return value + 0;

   } else if (value < 371) {
      return value + 1;

   } else if (value < 372) {
      return value + 0;

   } else if (value < 373) {
      return value + 1;

   } else if (value < 374) {
      return value + 0;

   } else if (value < 375) {
      return value + 1;

   } else if (value < 376) {
      return value + 0;

   } else if (value < 377) {
      return value + -121;

   } else if (value < 378) {
      return value + 1;

   } else if (value < 379) {
      return value + 0;

   } else if (value < 380) {
      return value + 1;

   } else if (value < 381) {
      return value + 0;

   } else if (value < 382) {
      return value + 1;

   } else if (value < 385) {
      return value + 0;

   } else if (value < 386) {
      return value + 210;

   } else if (value < 387) {
      return value + 1;

   } else if (value < 388) {
      return value + 0;

   } else if (value < 389) {
      return value + 1;

   } else if (value < 390) {
      return value + 0;

   } else if (value < 391) {
      return value + 206;

   } else if (value < 392) {
      return value + 1;

   } else if (value < 393) {
      return value + 0;

   } else if (value < 395) {
      return value + 205;

   } else if (value < 396) {
      return value + 1;

   } else if (value < 398) {
      return value + 0;

   } else if (value < 399) {
      return value + 79;

   } else if (value < 400) {
      return value + 202;

   } else if (value < 401) {
      return value + 203;

   } else if (value < 402) {
      return value + 1;

   } else if (value < 403) {
      return value + 0;

   } else if (value < 404) {
      return value + 205;

   } else if (value < 405) {
      return value + 207;

   } else if (value < 406) {
      return value + 0;

   } else if (value < 407) {
      return value + 211;

   } else if (value < 408) {
      return value + 209;

   } else if (value < 409) {
      return value + 1;

   } else if (value < 412) {
      return value + 0;

   } else if (value < 413) {
      return value + 211;

   } else if (value < 414) {
      return value + 213;

   } else if (value < 415) {
      return value + 0;

   } else if (value < 416) {
      return value + 214;

   } else if (value < 417) {
      return value + 1;

   } else if (value < 418) {
      return value + 0;

   } else if (value < 419) {
      return value + 1;

   } else if (value < 420) {
      return value + 0;

   } else if (value < 421) {
      return value + 1;

   } else if (value < 422) {
      return value + 0;

   } else if (value < 423) {
      return value + 218;

   } else if (value < 424) {
      return value + 1;

   } else if (value < 425) {
      return value + 0;

   } else if (value < 426) {
      return value + 218;

   } else if (value < 428) {
      return value + 0;

   } else if (value < 429) {
      return value + 1;

   } else if (value < 430) {
      return value + 0;

   } else if (value < 431) {
      return value + 218;

   } else if (value < 432) {
      return value + 1;

   } else if (value < 433) {
      return value + 0;

   } else if (value < 435) {
      return value + 217;

   } else if (value < 436) {
      return value + 1;

   } else if (value < 437) {
      return value + 0;

   } else if (value < 438) {
      return value + 1;

   } else if (value < 439) {
      return value + 0;

   } else if (value < 440) {
      return value + 219;

   } else if (value < 441) {
      return value + 1;

   } else if (value < 444) {
      return value + 0;

   } else if (value < 445) {
      return value + 1;

   } else if (value < 452) {
      return value + 0;

   } else if (value < 453) {
      return value + 2;

   } else if (value < 454) {
      return value + 1;

   } else if (value < 455) {
      return value + 0;

   } else if (value < 456) {
      return value + 2;

   } else if (value < 457) {
      return value + 1;

   } else if (value < 458) {
      return value + 0;

   } else if (value < 459) {
      return value + 2;

   } else if (value < 460) {
      return value + 1;

   } else if (value < 461) {
      return value + 0;

   } else if (value < 462) {
      return value + 1;

   } else if (value < 463) {
      return value + 0;

   } else if (value < 464) {
      return value + 1;

   } else if (value < 465) {
      return value + 0;

   } else if (value < 466) {
      return value + 1;

   } else if (value < 467) {
      return value + 0;

   } else if (value < 468) {
      return value + 1;

   } else if (value < 469) {
      return value + 0;

   }

   if (value < 470) {
      return value + 1;

   } else if (value < 471) {
      return value + 0;

   } else if (value < 472) {
      return value + 1;

   } else if (value < 473) {
      return value + 0;

   } else if (value < 474) {
      return value + 1;

   } else if (value < 475) {
      return value + 0;

   } else if (value < 476) {
      return value + 1;

   } else if (value < 478) {
      return value + 0;

   } else if (value < 479) {
      return value + 1;

   } else if (value < 480) {
      return value + 0;

   } else if (value < 481) {
      return value + 1;

   } else if (value < 482) {
      return value + 0;

   } else if (value < 483) {
      return value + 1;

   } else if (value < 484) {
      return value + 0;

   } else if (value < 485) {
      return value + 1;

   } else if (value < 486) {
      return value + 0;

   } else if (value < 487) {
      return value + 1;

   } else if (value < 488) {
      return value + 0;

   } else if (value < 489) {
      return value + 1;

   } else if (value < 490) {
      return value + 0;

   } else if (value < 491) {
      return value + 1;

   } else if (value < 492) {
      return value + 0;

   } else if (value < 493) {
      return value + 1;

   } else if (value < 494) {
      return value + 0;

   } else if (value < 495) {
      return value + 1;

   } else if (value < 497) {
      return value + 0;

   } else if (value < 498) {
      return value + 2;

   } else if (value < 499) {
      return value + 1;

   } else if (value < 500) {
      return value + 0;

   } else if (value < 501) {
      return value + 1;

   } else if (value < 502) {
      return value + 0;

   } else if (value < 503) {
      return value + -97;

   } else if (value < 504) {
      return value + -56;

   } else if (value < 505) {
      return value + 1;

   } else if (value < 506) {
      return value + 0;

   } else if (value < 507) {
      return value + 1;

   } else if (value < 508) {
      return value + 0;

   } else if (value < 509) {
      return value + 1;

   } else if (value < 510) {
      return value + 0;

   } else if (value < 511) {
      return value + 1;

   } else if (value < 512) {
      return value + 0;

   } else if (value < 513) {
      return value + 1;

   } else if (value < 514) {
      return value + 0;

   } else if (value < 515) {
      return value + 1;

   } else if (value < 516) {
      return value + 0;

   } else if (value < 517) {
      return value + 1;

   } else if (value < 518) {
      return value + 0;

   } else if (value < 519) {
      return value + 1;

   } else if (value < 520) {
      return value + 0;

   } else if (value < 521) {
      return value + 1;

   } else if (value < 522) {
      return value + 0;

   } else if (value < 523) {
      return value + 1;

   } else if (value < 524) {
      return value + 0;

   } else if (value < 525) {
      return value + 1;

   } else if (value < 526) {
      return value + 0;

   } else if (value < 527) {
      return value + 1;

   } else if (value < 528) {
      return value + 0;

   } else if (value < 529) {
      return value + 1;

   } else if (value < 530) {
      return value + 0;

   } else if (value < 531) {
      return value + 1;

   } else if (value < 532) {
      return value + 0;

   } else if (value < 533) {
      return value + 1;

   } else if (value < 534) {
      return value + 0;

   } else if (value < 535) {
      return value + 1;

   } else if (value < 536) {
      return value + 0;

   } else if (value < 537) {
      return value + 1;

   } else if (value < 538) {
      return value + 0;

   } else if (value < 539) {
      return value + 1;

   } else if (value < 540) {
      return value + 0;

   } else if (value < 541) {
      return value + 1;

   } else if (value < 542) {
      return value + 0;

   } else if (value < 543) {
      return value + 1;

   } else if (value < 544) {
      return value + 0;

   } else if (value < 545) {
      return value + -130;

   } else if (value < 546) {
      return value + 0;

   } else if (value < 547) {
      return value + 1;

   } else if (value < 548) {
      return value + 0;

   } else if (value < 549) {
      return value + 1;

   } else if (value < 550) {
      return value + 0;

   } else if (value < 551) {
      return value + 1;

   } else if (value < 552) {
      return value + 0;

   } else if (value < 553) {
      return value + 1;

   } else if (value < 554) {
      return value + 0;

   } else if (value < 555) {
      return value + 1;

   } else if (value < 556) {
      return value + 0;

   } else if (value < 557) {
      return value + 1;

   } else if (value < 558) {
      return value + 0;

   } else if (value < 559) {
      return value + 1;

   } else if (value < 560) {
      return value + 0;

   } else if (value < 561) {
      return value + 1;

   } else if (value < 562) {
      return value + 0;

   } else if (value < 563) {
      return value + 1;

   } else if (value < 570) {
      return value + 0;

   } else if (value < 571) {
      return value + 10795;

   } else if (value < 572) {
      return value + 1;

   } else if (value < 573) {
      return value + 0;

   } else if (value < 574) {
      return value + -163;

   } else if (value < 575) {
      return value + 10792;

   } else if (value < 577) {
      return value + 0;

   } else if (value < 578) {
      return value + 1;

   }

   if (value < 579) {
      return value + 0;

   } else if (value < 580) {
      return value + -195;

   } else if (value < 581) {
      return value + 69;

   } else if (value < 582) {
      return value + 71;

   } else if (value < 583) {
      return value + 1;

   } else if (value < 584) {
      return value + 0;

   } else if (value < 585) {
      return value + 1;

   } else if (value < 586) {
      return value + 0;

   } else if (value < 587) {
      return value + 1;

   } else if (value < 588) {
      return value + 0;

   } else if (value < 589) {
      return value + 1;

   } else if (value < 590) {
      return value + 0;

   } else if (value < 591) {
      return value + 1;

   } else if (value < 880) {
      return value + 0;

   } else if (value < 881) {
      return value + 1;

   } else if (value < 882) {
      return value + 0;

   } else if (value < 883) {
      return value + 1;

   } else if (value < 886) {
      return value + 0;

   } else if (value < 887) {
      return value + 1;

   } else if (value < 895) {
      return value + 0;

   } else if (value < 896) {
      return value + 116;

   } else if (value < 902) {
      return value + 0;

   } else if (value < 903) {
      return value + 38;

   } else if (value < 904) {
      return value + 0;

   } else if (value < 907) {
      return value + 37;

   } else if (value < 908) {
      return value + 0;

   } else if (value < 909) {
      return value + 64;

   } else if (value < 910) {
      return value + 0;

   } else if (value < 912) {
      return value + 63;

   } else if (value < 913) {
      return value + 0;

   } else if (value < 930) {
      return value + 32;

   } else if (value < 931) {
      return value + 0;

   } else if (value < 940) {
      return value + 32;

   } else if (value < 975) {
      return value + 0;

   } else if (value < 976) {
      return value + 8;

   } else if (value < 984) {
      return value + 0;

   } else if (value < 985) {
      return value + 1;

   } else if (value < 986) {
      return value + 0;

   } else if (value < 987) {
      return value + 1;

   } else if (value < 988) {
      return value + 0;

   } else if (value < 989) {
      return value + 1;

   } else if (value < 990) {
      return value + 0;

   } else if (value < 991) {
      return value + 1;

   } else if (value < 992) {
      return value + 0;

   } else if (value < 993) {
      return value + 1;

   } else if (value < 994) {
      return value + 0;

   } else if (value < 995) {
      return value + 1;

   } else if (value < 996) {
      return value + 0;

   } else if (value < 997) {
      return value + 1;

   } else if (value < 998) {
      return value + 0;

   } else if (value < 999) {
      return value + 1;

   } else if (value < 1000) {
      return value + 0;

   } else if (value < 1001) {
      return value + 1;

   } else if (value < 1002) {
      return value + 0;

   } else if (value < 1003) {
      return value + 1;

   } else if (value < 1004) {
      return value + 0;

   } else if (value < 1005) {
      return value + 1;

   } else if (value < 1006) {
      return value + 0;

   } else if (value < 1007) {
      return value + 1;

   } else if (value < 1012) {
      return value + 0;

   } else if (value < 1013) {
      return value + -60;

   } else if (value < 1015) {
      return value + 0;

   } else if (value < 1016) {
      return value + 1;

   } else if (value < 1017) {
      return value + 0;

   } else if (value < 1018) {
      return value + -7;

   } else if (value < 1019) {
      return value + 1;

   } else if (value < 1021) {
      return value + 0;

   } else if (value < 1024) {
      return value + -130;

   } else if (value < 1040) {
      return value + 80;

   } else if (value < 1072) {
      return value + 32;

   } else if (value < 1120) {
      return value + 0;

   } else if (value < 1121) {
      return value + 1;

   } else if (value < 1122) {
      return value + 0;

   } else if (value < 1123) {
      return value + 1;

   } else if (value < 1124) {
      return value + 0;

   } else if (value < 1125) {
      return value + 1;

   } else if (value < 1126) {
      return value + 0;

   } else if (value < 1127) {
      return value + 1;

   } else if (value < 1128) {
      return value + 0;

   } else if (value < 1129) {
      return value + 1;

   } else if (value < 1130) {
      return value + 0;

   } else if (value < 1131) {
      return value + 1;

   } else if (value < 1132) {
      return value + 0;

   } else if (value < 1133) {
      return value + 1;

   } else if (value < 1134) {
      return value + 0;

   } else if (value < 1135) {
      return value + 1;

   } else if (value < 1136) {
      return value + 0;

   } else if (value < 1137) {
      return value + 1;

   } else if (value < 1138) {
      return value + 0;

   } else if (value < 1139) {
      return value + 1;

   } else if (value < 1140) {
      return value + 0;

   } else if (value < 1141) {
      return value + 1;

   } else if (value < 1142) {
      return value + 0;

   } else if (value < 1143) {
      return value + 1;

   } else if (value < 1144) {
      return value + 0;

   } else if (value < 1145) {
      return value + 1;

   } else if (value < 1146) {
      return value + 0;

   } else if (value < 1147) {
      return value + 1;

   } else if (value < 1148) {
      return value + 0;

   } else if (value < 1149) {
      return value + 1;

   }

   if (value < 1150) {
      return value + 0;

   } else if (value < 1151) {
      return value + 1;

   } else if (value < 1152) {
      return value + 0;

   } else if (value < 1153) {
      return value + 1;

   } else if (value < 1162) {
      return value + 0;

   } else if (value < 1163) {
      return value + 1;

   } else if (value < 1164) {
      return value + 0;

   } else if (value < 1165) {
      return value + 1;

   } else if (value < 1166) {
      return value + 0;

   } else if (value < 1167) {
      return value + 1;

   } else if (value < 1168) {
      return value + 0;

   } else if (value < 1169) {
      return value + 1;

   } else if (value < 1170) {
      return value + 0;

   } else if (value < 1171) {
      return value + 1;

   } else if (value < 1172) {
      return value + 0;

   } else if (value < 1173) {
      return value + 1;

   } else if (value < 1174) {
      return value + 0;

   } else if (value < 1175) {
      return value + 1;

   } else if (value < 1176) {
      return value + 0;

   } else if (value < 1177) {
      return value + 1;

   } else if (value < 1178) {
      return value + 0;

   } else if (value < 1179) {
      return value + 1;

   } else if (value < 1180) {
      return value + 0;

   } else if (value < 1181) {
      return value + 1;

   } else if (value < 1182) {
      return value + 0;

   } else if (value < 1183) {
      return value + 1;

   } else if (value < 1184) {
      return value + 0;

   } else if (value < 1185) {
      return value + 1;

   } else if (value < 1186) {
      return value + 0;

   } else if (value < 1187) {
      return value + 1;

   } else if (value < 1188) {
      return value + 0;

   } else if (value < 1189) {
      return value + 1;

   } else if (value < 1190) {
      return value + 0;

   } else if (value < 1191) {
      return value + 1;

   } else if (value < 1192) {
      return value + 0;

   } else if (value < 1193) {
      return value + 1;

   } else if (value < 1194) {
      return value + 0;

   } else if (value < 1195) {
      return value + 1;

   } else if (value < 1196) {
      return value + 0;

   } else if (value < 1197) {
      return value + 1;

   } else if (value < 1198) {
      return value + 0;

   } else if (value < 1199) {
      return value + 1;

   } else if (value < 1200) {
      return value + 0;

   } else if (value < 1201) {
      return value + 1;

   } else if (value < 1202) {
      return value + 0;

   } else if (value < 1203) {
      return value + 1;

   } else if (value < 1204) {
      return value + 0;

   } else if (value < 1205) {
      return value + 1;

   } else if (value < 1206) {
      return value + 0;

   } else if (value < 1207) {
      return value + 1;

   } else if (value < 1208) {
      return value + 0;

   } else if (value < 1209) {
      return value + 1;

   } else if (value < 1210) {
      return value + 0;

   } else if (value < 1211) {
      return value + 1;

   } else if (value < 1212) {
      return value + 0;

   } else if (value < 1213) {
      return value + 1;

   } else if (value < 1214) {
      return value + 0;

   } else if (value < 1215) {
      return value + 1;

   } else if (value < 1216) {
      return value + 0;

   } else if (value < 1217) {
      return value + 15;

   } else if (value < 1218) {
      return value + 1;

   } else if (value < 1219) {
      return value + 0;

   } else if (value < 1220) {
      return value + 1;

   } else if (value < 1221) {
      return value + 0;

   } else if (value < 1222) {
      return value + 1;

   } else if (value < 1223) {
      return value + 0;

   } else if (value < 1224) {
      return value + 1;

   } else if (value < 1225) {
      return value + 0;

   } else if (value < 1226) {
      return value + 1;

   } else if (value < 1227) {
      return value + 0;

   } else if (value < 1228) {
      return value + 1;

   } else if (value < 1229) {
      return value + 0;

   } else if (value < 1230) {
      return value + 1;

   } else if (value < 1232) {
      return value + 0;

   } else if (value < 1233) {
      return value + 1;

   } else if (value < 1234) {
      return value + 0;

   } else if (value < 1235) {
      return value + 1;

   } else if (value < 1236) {
      return value + 0;

   } else if (value < 1237) {
      return value + 1;

   } else if (value < 1238) {
      return value + 0;

   } else if (value < 1239) {
      return value + 1;

   } else if (value < 1240) {
      return value + 0;

   } else if (value < 1241) {
      return value + 1;

   } else if (value < 1242) {
      return value + 0;

   } else if (value < 1243) {
      return value + 1;

   } else if (value < 1244) {
      return value + 0;

   } else if (value < 1245) {
      return value + 1;

   } else if (value < 1246) {
      return value + 0;

   } else if (value < 1247) {
      return value + 1;

   } else if (value < 1248) {
      return value + 0;

   } else if (value < 1249) {
      return value + 1;

   } else if (value < 1250) {
      return value + 0;

   } else if (value < 1251) {
      return value + 1;

   } else if (value < 1252) {
      return value + 0;

   } else if (value < 1253) {
      return value + 1;

   } else if (value < 1254) {
      return value + 0;

   } else if (value < 1255) {
      return value + 1;

   } else if (value < 1256) {
      return value + 0;

   } else if (value < 1257) {
      return value + 1;

   } else if (value < 1258) {
      return value + 0;

   }

   if (value < 1259) {
      return value + 1;

   } else if (value < 1260) {
      return value + 0;

   } else if (value < 1261) {
      return value + 1;

   } else if (value < 1262) {
      return value + 0;

   } else if (value < 1263) {
      return value + 1;

   } else if (value < 1264) {
      return value + 0;

   } else if (value < 1265) {
      return value + 1;

   } else if (value < 1266) {
      return value + 0;

   } else if (value < 1267) {
      return value + 1;

   } else if (value < 1268) {
      return value + 0;

   } else if (value < 1269) {
      return value + 1;

   } else if (value < 1270) {
      return value + 0;

   } else if (value < 1271) {
      return value + 1;

   } else if (value < 1272) {
      return value + 0;

   } else if (value < 1273) {
      return value + 1;

   } else if (value < 1274) {
      return value + 0;

   } else if (value < 1275) {
      return value + 1;

   } else if (value < 1276) {
      return value + 0;

   } else if (value < 1277) {
      return value + 1;

   } else if (value < 1278) {
      return value + 0;

   } else if (value < 1279) {
      return value + 1;

   } else if (value < 1280) {
      return value + 0;

   } else if (value < 1281) {
      return value + 1;

   } else if (value < 1282) {
      return value + 0;

   } else if (value < 1283) {
      return value + 1;

   } else if (value < 1284) {
      return value + 0;

   } else if (value < 1285) {
      return value + 1;

   } else if (value < 1286) {
      return value + 0;

   } else if (value < 1287) {
      return value + 1;

   } else if (value < 1288) {
      return value + 0;

   } else if (value < 1289) {
      return value + 1;

   } else if (value < 1290) {
      return value + 0;

   } else if (value < 1291) {
      return value + 1;

   } else if (value < 1292) {
      return value + 0;

   } else if (value < 1293) {
      return value + 1;

   } else if (value < 1294) {
      return value + 0;

   } else if (value < 1295) {
      return value + 1;

   } else if (value < 1296) {
      return value + 0;

   } else if (value < 1297) {
      return value + 1;

   } else if (value < 1298) {
      return value + 0;

   } else if (value < 1299) {
      return value + 1;

   } else if (value < 1300) {
      return value + 0;

   } else if (value < 1301) {
      return value + 1;

   } else if (value < 1302) {
      return value + 0;

   } else if (value < 1303) {
      return value + 1;

   } else if (value < 1304) {
      return value + 0;

   } else if (value < 1305) {
      return value + 1;

   } else if (value < 1306) {
      return value + 0;

   } else if (value < 1307) {
      return value + 1;

   } else if (value < 1308) {
      return value + 0;

   } else if (value < 1309) {
      return value + 1;

   } else if (value < 1310) {
      return value + 0;

   } else if (value < 1311) {
      return value + 1;

   } else if (value < 1312) {
      return value + 0;

   } else if (value < 1313) {
      return value + 1;

   } else if (value < 1314) {
      return value + 0;

   } else if (value < 1315) {
      return value + 1;

   } else if (value < 1316) {
      return value + 0;

   } else if (value < 1317) {
      return value + 1;

   } else if (value < 1318) {
      return value + 0;

   } else if (value < 1319) {
      return value + 1;

   } else if (value < 1320) {
      return value + 0;

   } else if (value < 1321) {
      return value + 1;

   } else if (value < 1322) {
      return value + 0;

   } else if (value < 1323) {
      return value + 1;

   } else if (value < 1324) {
      return value + 0;

   } else if (value < 1325) {
      return value + 1;

   } else if (value < 1326) {
      return value + 0;

   } else if (value < 1327) {
      return value + 1;

   } else if (value < 1329) {
      return value + 0;

   } else if (value < 1367) {
      return value + 48;

   } else if (value < 4256) {
      return value + 0;

   } else if (value < 4294) {
      return value + 7264;

   } else if (value < 4295) {
      return value + 0;

   } else if (value < 4296) {
      return value + 7264;

   } else if (value < 4301) {
      return value + 0;

   } else if (value < 4302) {
      return value + 7264;

   } else if (value < 5024) {
      return value + 0;

   } else if (value < 5104) {
      return value + 38864;

   } else if (value < 5110) {
      return value + 8;

   } else if (value < 7312) {
      return value + 0;

   } else if (value < 7355) {
      return value + -3008;

   } else if (value < 7357) {
      return value + 0;

   } else if (value < 7360) {
      return value + -3008;

   } else if (value < 7680) {
      return value + 0;

   } else if (value < 7681) {
      return value + 1;

   } else if (value < 7682) {
      return value + 0;

   } else if (value < 7683) {
      return value + 1;

   } else if (value < 7684) {
      return value + 0;

   } else if (value < 7685) {
      return value + 1;

   } else if (value < 7686) {
      return value + 0;

   } else if (value < 7687) {
      return value + 1;

   } else if (value < 7688) {
      return value + 0;

   } else if (value < 7689) {
      return value + 1;

   } else if (value < 7690) {
      return value + 0;

   } else if (value < 7691) {
      return value + 1;

   } else if (value < 7692) {
      return value + 0;

   } else if (value < 7693) {
      return value + 1;

   } else if (value < 7694) {
      return value + 0;

   } else if (value < 7695) {
      return value + 1;

   }

   if (value < 7696) {
      return value + 0;

   } else if (value < 7697) {
      return value + 1;

   } else if (value < 7698) {
      return value + 0;

   } else if (value < 7699) {
      return value + 1;

   } else if (value < 7700) {
      return value + 0;

   } else if (value < 7701) {
      return value + 1;

   } else if (value < 7702) {
      return value + 0;

   } else if (value < 7703) {
      return value + 1;

   } else if (value < 7704) {
      return value + 0;

   } else if (value < 7705) {
      return value + 1;

   } else if (value < 7706) {
      return value + 0;

   } else if (value < 7707) {
      return value + 1;

   } else if (value < 7708) {
      return value + 0;

   } else if (value < 7709) {
      return value + 1;

   } else if (value < 7710) {
      return value + 0;

   } else if (value < 7711) {
      return value + 1;

   } else if (value < 7712) {
      return value + 0;

   } else if (value < 7713) {
      return value + 1;

   } else if (value < 7714) {
      return value + 0;

   } else if (value < 7715) {
      return value + 1;

   } else if (value < 7716) {
      return value + 0;

   } else if (value < 7717) {
      return value + 1;

   } else if (value < 7718) {
      return value + 0;

   } else if (value < 7719) {
      return value + 1;

   } else if (value < 7720) {
      return value + 0;

   } else if (value < 7721) {
      return value + 1;

   } else if (value < 7722) {
      return value + 0;

   } else if (value < 7723) {
      return value + 1;

   } else if (value < 7724) {
      return value + 0;

   } else if (value < 7725) {
      return value + 1;

   } else if (value < 7726) {
      return value + 0;

   } else if (value < 7727) {
      return value + 1;

   } else if (value < 7728) {
      return value + 0;

   } else if (value < 7729) {
      return value + 1;

   } else if (value < 7730) {
      return value + 0;

   } else if (value < 7731) {
      return value + 1;

   } else if (value < 7732) {
      return value + 0;

   } else if (value < 7733) {
      return value + 1;

   } else if (value < 7734) {
      return value + 0;

   } else if (value < 7735) {
      return value + 1;

   } else if (value < 7736) {
      return value + 0;

   } else if (value < 7737) {
      return value + 1;

   } else if (value < 7738) {
      return value + 0;

   } else if (value < 7739) {
      return value + 1;

   } else if (value < 7740) {
      return value + 0;

   } else if (value < 7741) {
      return value + 1;

   } else if (value < 7742) {
      return value + 0;

   } else if (value < 7743) {
      return value + 1;

   } else if (value < 7744) {
      return value + 0;

   } else if (value < 7745) {
      return value + 1;

   } else if (value < 7746) {
      return value + 0;

   } else if (value < 7747) {
      return value + 1;

   } else if (value < 7748) {
      return value + 0;

   } else if (value < 7749) {
      return value + 1;

   } else if (value < 7750) {
      return value + 0;

   } else if (value < 7751) {
      return value + 1;

   } else if (value < 7752) {
      return value + 0;

   } else if (value < 7753) {
      return value + 1;

   } else if (value < 7754) {
      return value + 0;

   } else if (value < 7755) {
      return value + 1;

   } else if (value < 7756) {
      return value + 0;

   } else if (value < 7757) {
      return value + 1;

   } else if (value < 7758) {
      return value + 0;

   } else if (value < 7759) {
      return value + 1;

   } else if (value < 7760) {
      return value + 0;

   } else if (value < 7761) {
      return value + 1;

   } else if (value < 7762) {
      return value + 0;

   } else if (value < 7763) {
      return value + 1;

   } else if (value < 7764) {
      return value + 0;

   } else if (value < 7765) {
      return value + 1;

   } else if (value < 7766) {
      return value + 0;

   } else if (value < 7767) {
      return value + 1;

   } else if (value < 7768) {
      return value + 0;

   } else if (value < 7769) {
      return value + 1;

   } else if (value < 7770) {
      return value + 0;

   } else if (value < 7771) {
      return value + 1;

   } else if (value < 7772) {
      return value + 0;

   } else if (value < 7773) {
      return value + 1;

   } else if (value < 7774) {
      return value + 0;

   } else if (value < 7775) {
      return value + 1;

   } else if (value < 7776) {
      return value + 0;

   } else if (value < 7777) {
      return value + 1;

   } else if (value < 7778) {
      return value + 0;

   } else if (value < 7779) {
      return value + 1;

   } else if (value < 7780) {
      return value + 0;

   } else if (value < 7781) {
      return value + 1;

   } else if (value < 7782) {
      return value + 0;

   } else if (value < 7783) {
      return value + 1;

   } else if (value < 7784) {
      return value + 0;

   } else if (value < 7785) {
      return value + 1;

   } else if (value < 7786) {
      return value + 0;

   } else if (value < 7787) {
      return value + 1;

   } else if (value < 7788) {
      return value + 0;

   } else if (value < 7789) {
      return value + 1;

   } else if (value < 7790) {
      return value + 0;

   } else if (value < 7791) {
      return value + 1;

   } else if (value < 7792) {
      return value + 0;

   } else if (value < 7793) {
      return value + 1;

   } else if (value < 7794) {
      return value + 0;

   } else if (value < 7795) {
      return value + 1;

   }

   if (value < 7796) {
      return value + 0;

   } else if (value < 7797) {
      return value + 1;

   } else if (value < 7798) {
      return value + 0;

   } else if (value < 7799) {
      return value + 1;

   } else if (value < 7800) {
      return value + 0;

   } else if (value < 7801) {
      return value + 1;

   } else if (value < 7802) {
      return value + 0;

   } else if (value < 7803) {
      return value + 1;

   } else if (value < 7804) {
      return value + 0;

   } else if (value < 7805) {
      return value + 1;

   } else if (value < 7806) {
      return value + 0;

   } else if (value < 7807) {
      return value + 1;

   } else if (value < 7808) {
      return value + 0;

   } else if (value < 7809) {
      return value + 1;

   } else if (value < 7810) {
      return value + 0;

   } else if (value < 7811) {
      return value + 1;

   } else if (value < 7812) {
      return value + 0;

   } else if (value < 7813) {
      return value + 1;

   } else if (value < 7814) {
      return value + 0;

   } else if (value < 7815) {
      return value + 1;

   } else if (value < 7816) {
      return value + 0;

   } else if (value < 7817) {
      return value + 1;

   } else if (value < 7818) {
      return value + 0;

   } else if (value < 7819) {
      return value + 1;

   } else if (value < 7820) {
      return value + 0;

   } else if (value < 7821) {
      return value + 1;

   } else if (value < 7822) {
      return value + 0;

   } else if (value < 7823) {
      return value + 1;

   } else if (value < 7824) {
      return value + 0;

   } else if (value < 7825) {
      return value + 1;

   } else if (value < 7826) {
      return value + 0;

   } else if (value < 7827) {
      return value + 1;

   } else if (value < 7828) {
      return value + 0;

   } else if (value < 7829) {
      return value + 1;

   } else if (value < 7838) {
      return value + 0;

   } else if (value < 7839) {
      return value + -7615;

   } else if (value < 7840) {
      return value + 0;

   } else if (value < 7841) {
      return value + 1;

   } else if (value < 7842) {
      return value + 0;

   } else if (value < 7843) {
      return value + 1;

   } else if (value < 7844) {
      return value + 0;

   } else if (value < 7845) {
      return value + 1;

   } else if (value < 7846) {
      return value + 0;

   } else if (value < 7847) {
      return value + 1;

   } else if (value < 7848) {
      return value + 0;

   } else if (value < 7849) {
      return value + 1;

   } else if (value < 7850) {
      return value + 0;

   } else if (value < 7851) {
      return value + 1;

   } else if (value < 7852) {
      return value + 0;

   } else if (value < 7853) {
      return value + 1;

   } else if (value < 7854) {
      return value + 0;

   } else if (value < 7855) {
      return value + 1;

   } else if (value < 7856) {
      return value + 0;

   } else if (value < 7857) {
      return value + 1;

   } else if (value < 7858) {
      return value + 0;

   } else if (value < 7859) {
      return value + 1;

   } else if (value < 7860) {
      return value + 0;

   } else if (value < 7861) {
      return value + 1;

   } else if (value < 7862) {
      return value + 0;

   } else if (value < 7863) {
      return value + 1;

   } else if (value < 7864) {
      return value + 0;

   } else if (value < 7865) {
      return value + 1;

   } else if (value < 7866) {
      return value + 0;

   } else if (value < 7867) {
      return value + 1;

   } else if (value < 7868) {
      return value + 0;

   } else if (value < 7869) {
      return value + 1;

   } else if (value < 7870) {
      return value + 0;

   } else if (value < 7871) {
      return value + 1;

   } else if (value < 7872) {
      return value + 0;

   } else if (value < 7873) {
      return value + 1;

   } else if (value < 7874) {
      return value + 0;

   } else if (value < 7875) {
      return value + 1;

   } else if (value < 7876) {
      return value + 0;

   } else if (value < 7877) {
      return value + 1;

   } else if (value < 7878) {
      return value + 0;

   } else if (value < 7879) {
      return value + 1;

   } else if (value < 7880) {
      return value + 0;

   } else if (value < 7881) {
      return value + 1;

   } else if (value < 7882) {
      return value + 0;

   } else if (value < 7883) {
      return value + 1;

   } else if (value < 7884) {
      return value + 0;

   } else if (value < 7885) {
      return value + 1;

   } else if (value < 7886) {
      return value + 0;

   } else if (value < 7887) {
      return value + 1;

   } else if (value < 7888) {
      return value + 0;

   } else if (value < 7889) {
      return value + 1;

   } else if (value < 7890) {
      return value + 0;

   } else if (value < 7891) {
      return value + 1;

   } else if (value < 7892) {
      return value + 0;

   } else if (value < 7893) {
      return value + 1;

   } else if (value < 7894) {
      return value + 0;

   } else if (value < 7895) {
      return value + 1;

   } else if (value < 7896) {
      return value + 0;

   } else if (value < 7897) {
      return value + 1;

   } else if (value < 7898) {
      return value + 0;

   } else if (value < 7899) {
      return value + 1;

   } else if (value < 7900) {
      return value + 0;

   } else if (value < 7901) {
      return value + 1;

   } else if (value < 7902) {
      return value + 0;

   } else if (value < 7903) {
      return value + 1;

   }

   if (value < 7904) {
      return value + 0;

   } else if (value < 7905) {
      return value + 1;

   } else if (value < 7906) {
      return value + 0;

   } else if (value < 7907) {
      return value + 1;

   } else if (value < 7908) {
      return value + 0;

   } else if (value < 7909) {
      return value + 1;

   } else if (value < 7910) {
      return value + 0;

   } else if (value < 7911) {
      return value + 1;

   } else if (value < 7912) {
      return value + 0;

   } else if (value < 7913) {
      return value + 1;

   } else if (value < 7914) {
      return value + 0;

   } else if (value < 7915) {
      return value + 1;

   } else if (value < 7916) {
      return value + 0;

   } else if (value < 7917) {
      return value + 1;

   } else if (value < 7918) {
      return value + 0;

   } else if (value < 7919) {
      return value + 1;

   } else if (value < 7920) {
      return value + 0;

   } else if (value < 7921) {
      return value + 1;

   } else if (value < 7922) {
      return value + 0;

   } else if (value < 7923) {
      return value + 1;

   } else if (value < 7924) {
      return value + 0;

   } else if (value < 7925) {
      return value + 1;

   } else if (value < 7926) {
      return value + 0;

   } else if (value < 7927) {
      return value + 1;

   } else if (value < 7928) {
      return value + 0;

   } else if (value < 7929) {
      return value + 1;

   } else if (value < 7930) {
      return value + 0;

   } else if (value < 7931) {
      return value + 1;

   } else if (value < 7932) {
      return value + 0;

   } else if (value < 7933) {
      return value + 1;

   } else if (value < 7934) {
      return value + 0;

   } else if (value < 7935) {
      return value + 1;

   } else if (value < 7944) {
      return value + 0;

   } else if (value < 7952) {
      return value + -8;

   } else if (value < 7960) {
      return value + 0;

   } else if (value < 7966) {
      return value + -8;

   } else if (value < 7976) {
      return value + 0;

   } else if (value < 7984) {
      return value + -8;

   } else if (value < 7992) {
      return value + 0;

   } else if (value < 8000) {
      return value + -8;

   } else if (value < 8008) {
      return value + 0;

   } else if (value < 8014) {
      return value + -8;

   } else if (value < 8025) {
      return value + 0;

   } else if (value < 8026) {
      return value + -8;

   } else if (value < 8027) {
      return value + 0;

   } else if (value < 8028) {
      return value + -8;

   } else if (value < 8029) {
      return value + 0;

   } else if (value < 8030) {
      return value + -8;

   } else if (value < 8031) {
      return value + 0;

   } else if (value < 8032) {
      return value + -8;

   } else if (value < 8040) {
      return value + 0;

   } else if (value < 8048) {
      return value + -8;

   } else if (value < 8072) {
      return value + 0;

   } else if (value < 8080) {
      return value + -8;

   } else if (value < 8088) {
      return value + 0;

   } else if (value < 8096) {
      return value + -8;

   } else if (value < 8104) {
      return value + 0;

   } else if (value < 8112) {
      return value + -8;

   } else if (value < 8120) {
      return value + 0;

   } else if (value < 8122) {
      return value + -8;

   } else if (value < 8124) {
      return value + -74;

   } else if (value < 8125) {
      return value + -9;

   } else if (value < 8136) {
      return value + 0;

   } else if (value < 8140) {
      return value + -86;

   } else if (value < 8141) {
      return value + -9;

   } else if (value < 8152) {
      return value + 0;

   } else if (value < 8154) {
      return value + -8;

   } else if (value < 8156) {
      return value + -100;

   } else if (value < 8168) {
      return value + 0;

   } else if (value < 8170) {
      return value + -8;

   } else if (value < 8172) {
      return value + -112;

   } else if (value < 8173) {
      return value + -7;

   } else if (value < 8184) {
      return value + 0;

   } else if (value < 8186) {
      return value + -128;

   } else if (value < 8188) {
      return value + -126;

   } else if (value < 8189) {
      return value + -9;

   } else if (value < 8486) {
      return value + 0;

   } else if (value < 8487) {
      return value + -7517;

   } else if (value < 8490) {
      return value + 0;

   } else if (value < 8491) {
      return value + -8383;

   } else if (value < 8492) {
      return value + -8262;

   } else if (value < 8498) {
      return value + 0;

   } else if (value < 8499) {
      return value + 28;

   } else if (value < 8544) {
      return value + 0;

   } else if (value < 8560) {
      return value + 16;

   } else if (value < 8579) {
      return value + 0;

   } else if (value < 8580) {
      return value + 1;

   } else if (value < 9398) {
      return value + 0;

   } else if (value < 9424) {
      return value + 26;

   } else if (value < 11264) {
      return value + 0;

   } else if (value < 11312) {
      return value + 48;

   } else if (value < 11360) {
      return value + 0;

   } else if (value < 11361) {
      return value + 1;

   } else if (value < 11362) {
      return value + 0;

   } else if (value < 11363) {
      return value + -10743;

   } else if (value < 11364) {
      return value + -3814;

   } else if (value < 11365) {
      return value + -10727;

   } else if (value < 11367) {
      return value + 0;

   } else if (value < 11368) {
      return value + 1;

   } else if (value < 11369) {
      return value + 0;

   }

   if (value < 11370) {
      return value + 1;

   } else if (value < 11371) {
      return value + 0;

   } else if (value < 11372) {
      return value + 1;

   } else if (value < 11373) {
      return value + 0;

   } else if (value < 11374) {
      return value + -10780;

   } else if (value < 11375) {
      return value + -10749;

   } else if (value < 11376) {
      return value + -10783;

   } else if (value < 11377) {
      return value + -10782;

   } else if (value < 11378) {
      return value + 0;

   } else if (value < 11379) {
      return value + 1;

   } else if (value < 11381) {
      return value + 0;

   } else if (value < 11382) {
      return value + 1;

   } else if (value < 11390) {
      return value + 0;

   } else if (value < 11392) {
      return value + -10815;

   } else if (value < 11393) {
      return value + 1;

   } else if (value < 11394) {
      return value + 0;

   } else if (value < 11395) {
      return value + 1;

   } else if (value < 11396) {
      return value + 0;

   } else if (value < 11397) {
      return value + 1;

   } else if (value < 11398) {
      return value + 0;

   } else if (value < 11399) {
      return value + 1;

   } else if (value < 11400) {
      return value + 0;

   } else if (value < 11401) {
      return value + 1;

   } else if (value < 11402) {
      return value + 0;

   } else if (value < 11403) {
      return value + 1;

   } else if (value < 11404) {
      return value + 0;

   } else if (value < 11405) {
      return value + 1;

   } else if (value < 11406) {
      return value + 0;

   } else if (value < 11407) {
      return value + 1;

   } else if (value < 11408) {
      return value + 0;

   } else if (value < 11409) {
      return value + 1;

   } else if (value < 11410) {
      return value + 0;

   } else if (value < 11411) {
      return value + 1;

   } else if (value < 11412) {
      return value + 0;

   } else if (value < 11413) {
      return value + 1;

   } else if (value < 11414) {
      return value + 0;

   } else if (value < 11415) {
      return value + 1;

   } else if (value < 11416) {
      return value + 0;

   } else if (value < 11417) {
      return value + 1;

   } else if (value < 11418) {
      return value + 0;

   } else if (value < 11419) {
      return value + 1;

   } else if (value < 11420) {
      return value + 0;

   } else if (value < 11421) {
      return value + 1;

   } else if (value < 11422) {
      return value + 0;

   } else if (value < 11423) {
      return value + 1;

   } else if (value < 11424) {
      return value + 0;

   } else if (value < 11425) {
      return value + 1;

   } else if (value < 11426) {
      return value + 0;

   } else if (value < 11427) {
      return value + 1;

   } else if (value < 11428) {
      return value + 0;

   } else if (value < 11429) {
      return value + 1;

   } else if (value < 11430) {
      return value + 0;

   } else if (value < 11431) {
      return value + 1;

   } else if (value < 11432) {
      return value + 0;

   } else if (value < 11433) {
      return value + 1;

   } else if (value < 11434) {
      return value + 0;

   } else if (value < 11435) {
      return value + 1;

   } else if (value < 11436) {
      return value + 0;

   } else if (value < 11437) {
      return value + 1;

   } else if (value < 11438) {
      return value + 0;

   } else if (value < 11439) {
      return value + 1;

   } else if (value < 11440) {
      return value + 0;

   } else if (value < 11441) {
      return value + 1;

   } else if (value < 11442) {
      return value + 0;

   } else if (value < 11443) {
      return value + 1;

   } else if (value < 11444) {
      return value + 0;

   } else if (value < 11445) {
      return value + 1;

   } else if (value < 11446) {
      return value + 0;

   } else if (value < 11447) {
      return value + 1;

   } else if (value < 11448) {
      return value + 0;

   } else if (value < 11449) {
      return value + 1;

   } else if (value < 11450) {
      return value + 0;

   } else if (value < 11451) {
      return value + 1;

   } else if (value < 11452) {
      return value + 0;

   } else if (value < 11453) {
      return value + 1;

   } else if (value < 11454) {
      return value + 0;

   } else if (value < 11455) {
      return value + 1;

   } else if (value < 11456) {
      return value + 0;

   } else if (value < 11457) {
      return value + 1;

   } else if (value < 11458) {
      return value + 0;

   } else if (value < 11459) {
      return value + 1;

   } else if (value < 11460) {
      return value + 0;

   } else if (value < 11461) {
      return value + 1;

   } else if (value < 11462) {
      return value + 0;

   } else if (value < 11463) {
      return value + 1;

   } else if (value < 11464) {
      return value + 0;

   } else if (value < 11465) {
      return value + 1;

   } else if (value < 11466) {
      return value + 0;

   } else if (value < 11467) {
      return value + 1;

   } else if (value < 11468) {
      return value + 0;

   } else if (value < 11469) {
      return value + 1;

   } else if (value < 11470) {
      return value + 0;

   } else if (value < 11471) {
      return value + 1;

   } else if (value < 11472) {
      return value + 0;

   } else if (value < 11473) {
      return value + 1;

   } else if (value < 11474) {
      return value + 0;

   } else if (value < 11475) {
      return value + 1;

   } else if (value < 11476) {
      return value + 0;

   } else if (value < 11477) {
      return value + 1;

   } else if (value < 11478) {
      return value + 0;

   }

   if (value < 11479) {
      return value + 1;

   } else if (value < 11480) {
      return value + 0;

   } else if (value < 11481) {
      return value + 1;

   } else if (value < 11482) {
      return value + 0;

   } else if (value < 11483) {
      return value + 1;

   } else if (value < 11484) {
      return value + 0;

   } else if (value < 11485) {
      return value + 1;

   } else if (value < 11486) {
      return value + 0;

   } else if (value < 11487) {
      return value + 1;

   } else if (value < 11488) {
      return value + 0;

   } else if (value < 11489) {
      return value + 1;

   } else if (value < 11490) {
      return value + 0;

   } else if (value < 11491) {
      return value + 1;

   } else if (value < 11499) {
      return value + 0;

   } else if (value < 11500) {
      return value + 1;

   } else if (value < 11501) {
      return value + 0;

   } else if (value < 11502) {
      return value + 1;

   } else if (value < 11506) {
      return value + 0;

   } else if (value < 11507) {
      return value + 1;

   } else if (value < 42560) {
      return value + 0;

   } else if (value < 42561) {
      return value + 1;

   } else if (value < 42562) {
      return value + 0;

   } else if (value < 42563) {
      return value + 1;

   } else if (value < 42564) {
      return value + 0;

   } else if (value < 42565) {
      return value + 1;

   } else if (value < 42566) {
      return value + 0;

   } else if (value < 42567) {
      return value + 1;

   } else if (value < 42568) {
      return value + 0;

   } else if (value < 42569) {
      return value + 1;

   } else if (value < 42570) {
      return value + 0;

   } else if (value < 42571) {
      return value + 1;

   } else if (value < 42572) {
      return value + 0;

   } else if (value < 42573) {
      return value + 1;

   } else if (value < 42574) {
      return value + 0;

   } else if (value < 42575) {
      return value + 1;

   } else if (value < 42576) {
      return value + 0;

   } else if (value < 42577) {
      return value + 1;

   } else if (value < 42578) {
      return value + 0;

   } else if (value < 42579) {
      return value + 1;

   } else if (value < 42580) {
      return value + 0;

   } else if (value < 42581) {
      return value + 1;

   } else if (value < 42582) {
      return value + 0;

   } else if (value < 42583) {
      return value + 1;

   } else if (value < 42584) {
      return value + 0;

   } else if (value < 42585) {
      return value + 1;

   } else if (value < 42586) {
      return value + 0;

   } else if (value < 42587) {
      return value + 1;

   } else if (value < 42588) {
      return value + 0;

   } else if (value < 42589) {
      return value + 1;

   } else if (value < 42590) {
      return value + 0;

   } else if (value < 42591) {
      return value + 1;

   } else if (value < 42592) {
      return value + 0;

   } else if (value < 42593) {
      return value + 1;

   } else if (value < 42594) {
      return value + 0;

   } else if (value < 42595) {
      return value + 1;

   } else if (value < 42596) {
      return value + 0;

   } else if (value < 42597) {
      return value + 1;

   } else if (value < 42598) {
      return value + 0;

   } else if (value < 42599) {
      return value + 1;

   } else if (value < 42600) {
      return value + 0;

   } else if (value < 42601) {
      return value + 1;

   } else if (value < 42602) {
      return value + 0;

   } else if (value < 42603) {
      return value + 1;

   } else if (value < 42604) {
      return value + 0;

   } else if (value < 42605) {
      return value + 1;

   } else if (value < 42624) {
      return value + 0;

   } else if (value < 42625) {
      return value + 1;

   } else if (value < 42626) {
      return value + 0;

   } else if (value < 42627) {
      return value + 1;

   } else if (value < 42628) {
      return value + 0;

   } else if (value < 42629) {
      return value + 1;

   } else if (value < 42630) {
      return value + 0;

   } else if (value < 42631) {
      return value + 1;

   } else if (value < 42632) {
      return value + 0;

   } else if (value < 42633) {
      return value + 1;

   } else if (value < 42634) {
      return value + 0;

   } else if (value < 42635) {
      return value + 1;

   } else if (value < 42636) {
      return value + 0;

   } else if (value < 42637) {
      return value + 1;

   } else if (value < 42638) {
      return value + 0;

   } else if (value < 42639) {
      return value + 1;

   } else if (value < 42640) {
      return value + 0;

   } else if (value < 42641) {
      return value + 1;

   } else if (value < 42642) {
      return value + 0;

   } else if (value < 42643) {
      return value + 1;

   } else if (value < 42644) {
      return value + 0;

   } else if (value < 42645) {
      return value + 1;

   } else if (value < 42646) {
      return value + 0;

   } else if (value < 42647) {
      return value + 1;

   } else if (value < 42648) {
      return value + 0;

   } else if (value < 42649) {
      return value + 1;

   } else if (value < 42650) {
      return value + 0;

   } else if (value < 42651) {
      return value + 1;

   } else if (value < 42786) {
      return value + 0;

   } else if (value < 42787) {
      return value + 1;

   } else if (value < 42788) {
      return value + 0;

   } else if (value < 42789) {
      return value + 1;

   } else if (value < 42790) {
      return value + 0;

   } else if (value < 42791) {
      return value + 1;

   } else if (value < 42792) {
      return value + 0;

   }

   if (value < 42793) {
      return value + 1;

   } else if (value < 42794) {
      return value + 0;

   } else if (value < 42795) {
      return value + 1;

   } else if (value < 42796) {
      return value + 0;

   } else if (value < 42797) {
      return value + 1;

   } else if (value < 42798) {
      return value + 0;

   } else if (value < 42799) {
      return value + 1;

   } else if (value < 42802) {
      return value + 0;

   } else if (value < 42803) {
      return value + 1;

   } else if (value < 42804) {
      return value + 0;

   } else if (value < 42805) {
      return value + 1;

   } else if (value < 42806) {
      return value + 0;

   } else if (value < 42807) {
      return value + 1;

   } else if (value < 42808) {
      return value + 0;

   } else if (value < 42809) {
      return value + 1;

   } else if (value < 42810) {
      return value + 0;

   } else if (value < 42811) {
      return value + 1;

   } else if (value < 42812) {
      return value + 0;

   } else if (value < 42813) {
      return value + 1;

   } else if (value < 42814) {
      return value + 0;

   } else if (value < 42815) {
      return value + 1;

   } else if (value < 42816) {
      return value + 0;

   } else if (value < 42817) {
      return value + 1;

   } else if (value < 42818) {
      return value + 0;

   } else if (value < 42819) {
      return value + 1;

   } else if (value < 42820) {
      return value + 0;

   } else if (value < 42821) {
      return value + 1;

   } else if (value < 42822) {
      return value + 0;

   } else if (value < 42823) {
      return value + 1;

   } else if (value < 42824) {
      return value + 0;

   } else if (value < 42825) {
      return value + 1;

   } else if (value < 42826) {
      return value + 0;

   } else if (value < 42827) {
      return value + 1;

   } else if (value < 42828) {
      return value + 0;

   } else if (value < 42829) {
      return value + 1;

   } else if (value < 42830) {
      return value + 0;

   } else if (value < 42831) {
      return value + 1;

   } else if (value < 42832) {
      return value + 0;

   } else if (value < 42833) {
      return value + 1;

   } else if (value < 42834) {
      return value + 0;

   } else if (value < 42835) {
      return value + 1;

   } else if (value < 42836) {
      return value + 0;

   } else if (value < 42837) {
      return value + 1;

   } else if (value < 42838) {
      return value + 0;

   } else if (value < 42839) {
      return value + 1;

   } else if (value < 42840) {
      return value + 0;

   } else if (value < 42841) {
      return value + 1;

   } else if (value < 42842) {
      return value + 0;

   } else if (value < 42843) {
      return value + 1;

   } else if (value < 42844) {
      return value + 0;

   } else if (value < 42845) {
      return value + 1;

   } else if (value < 42846) {
      return value + 0;

   } else if (value < 42847) {
      return value + 1;

   } else if (value < 42848) {
      return value + 0;

   } else if (value < 42849) {
      return value + 1;

   } else if (value < 42850) {
      return value + 0;

   } else if (value < 42851) {
      return value + 1;

   } else if (value < 42852) {
      return value + 0;

   } else if (value < 42853) {
      return value + 1;

   } else if (value < 42854) {
      return value + 0;

   } else if (value < 42855) {
      return value + 1;

   } else if (value < 42856) {
      return value + 0;

   } else if (value < 42857) {
      return value + 1;

   } else if (value < 42858) {
      return value + 0;

   } else if (value < 42859) {
      return value + 1;

   } else if (value < 42860) {
      return value + 0;

   } else if (value < 42861) {
      return value + 1;

   } else if (value < 42862) {
      return value + 0;

   } else if (value < 42863) {
      return value + 1;

   } else if (value < 42873) {
      return value + 0;

   } else if (value < 42874) {
      return value + 1;

   } else if (value < 42875) {
      return value + 0;

   } else if (value < 42876) {
      return value + 1;

   } else if (value < 42877) {
      return value + 0;

   } else if (value < 42878) {
      return value + -35332;

   } else if (value < 42879) {
      return value + 1;

   } else if (value < 42880) {
      return value + 0;

   } else if (value < 42881) {
      return value + 1;

   } else if (value < 42882) {
      return value + 0;

   } else if (value < 42883) {
      return value + 1;

   } else if (value < 42884) {
      return value + 0;

   } else if (value < 42885) {
      return value + 1;

   } else if (value < 42886) {
      return value + 0;

   } else if (value < 42887) {
      return value + 1;

   } else if (value < 42891) {
      return value + 0;

   } else if (value < 42892) {
      return value + 1;

   } else if (value < 42893) {
      return value + 0;

   } else if (value < 42894) {
      return value + -42280;

   } else if (value < 42896) {
      return value + 0;

   } else if (value < 42897) {
      return value + 1;

   } else if (value < 42898) {
      return value + 0;

   } else if (value < 42899) {
      return value + 1;

   } else if (value < 42902) {
      return value + 0;

   } else if (value < 42903) {
      return value + 1;

   } else if (value < 42904) {
      return value + 0;

   } else if (value < 42905) {
      return value + 1;

   } else if (value < 42906) {
      return value + 0;

   } else if (value < 42907) {
      return value + 1;

   } else if (value < 42908) {
      return value + 0;

   } else if (value < 42909) {
      return value + 1;

   }

   if (value < 42910) {
      return value + 0;

   } else if (value < 42911) {
      return value + 1;

   } else if (value < 42912) {
      return value + 0;

   } else if (value < 42913) {
      return value + 1;

   } else if (value < 42914) {
      return value + 0;

   } else if (value < 42915) {
      return value + 1;

   } else if (value < 42916) {
      return value + 0;

   } else if (value < 42917) {
      return value + 1;

   } else if (value < 42918) {
      return value + 0;

   } else if (value < 42919) {
      return value + 1;

   } else if (value < 42920) {
      return value + 0;

   } else if (value < 42921) {
      return value + 1;

   } else if (value < 42922) {
      return value + 0;

   } else if (value < 42923) {
      return value + -42308;

   } else if (value < 42924) {
      return value + -42319;

   } else if (value < 42925) {
      return value + -42315;

   } else if (value < 42926) {
      return value + -42305;

   } else if (value < 42927) {
      return value + -42308;

   } else if (value < 42928) {
      return value + 0;

   } else if (value < 42929) {
      return value + -42258;

   } else if (value < 42930) {
      return value + -42282;

   } else if (value < 42931) {
      return value + -42261;

   } else if (value < 42932) {
      return value + 928;

   } else if (value < 42933) {
      return value + 1;

   } else if (value < 42934) {
      return value + 0;

   } else if (value < 42935) {
      return value + 1;

   } else if (value < 42936) {
      return value + 0;

   } else if (value < 42937) {
      return value + 1;

   } else if (value < 42938) {
      return value + 0;

   } else if (value < 42939) {
      return value + 1;

   } else if (value < 42940) {
      return value + 0;

   } else if (value < 42941) {
      return value + 1;

   } else if (value < 42942) {
      return value + 0;

   } else if (value < 42943) {
      return value + 1;

   } else if (value < 42944) {
      return value + 0;

   } else if (value < 42945) {
      return value + 1;

   } else if (value < 42946) {
      return value + 0;

   } else if (value < 42947) {
      return value + 1;

   } else if (value < 42948) {
      return value + 0;

   } else if (value < 42949) {
      return value + -48;

   } else if (value < 42950) {
      return value + -42307;

   } else if (value < 42951) {
      return value + -35384;

   } else if (value < 42952) {
      return value + 1;

   } else if (value < 42953) {
      return value + 0;

   } else if (value < 42954) {
      return value + 1;

   } else if (value < 42960) {
      return value + 0;

   } else if (value < 42961) {
      return value + 1;

   } else if (value < 42966) {
      return value + 0;

   } else if (value < 42967) {
      return value + 1;

   } else if (value < 42968) {
      return value + 0;

   } else if (value < 42969) {
      return value + 1;

   } else if (value < 42997) {
      return value + 0;

   } else if (value < 42998) {
      return value + 1;

   } else if (value < 65313) {
      return value + 0;

   } else if (value < 65339) {
      return value + 32;

   } else if (value < 66560) {
      return value + 0;

   } else if (value < 66600) {
      return value + 40;

   } else if (value < 66736) {
      return value + 0;

   } else if (value < 66772) {
      return value + 40;

   } else if (value < 66928) {
      return value + 0;

   } else if (value < 66939) {
      return value + 39;

   } else if (value < 66940) {
      return value + 0;

   } else if (value < 66955) {
      return value + 39;

   } else if (value < 66956) {
      return value + 0;

   } else if (value < 66963) {
      return value + 39;

   } else if (value < 66964) {
      return value + 0;

   } else if (value < 66966) {
      return value + 39;

   } else if (value < 68736) {
      return value + 0;

   } else if (value < 68787) {
      return value + 64;

   } else if (value < 71840) {
      return value + 0;

   } else if (value < 71872) {
      return value + 32;

   } else if (value < 93760) {
      return value + 0;

   } else if (value < 93792) {
      return value + 32;

   } else if (value < 125184) {
      return value + 0;

   } else if (value < 125218) {
      return value + 34;

   } else {
      return value;
   }
}

char32_t uc_titleCase(char32_t value)
{
   if (value < 97) {
      return value + 0;

   } else if (value < 123) {
      return value + -32;

   } else if (value < 181) {
      return value + 0;

   } else if (value < 182) {
      return value + 743;

   } else if (value == 223) {
      // special char
      return 0;

   } else if (value < 224) {
      return value + 0;

   } else if (value < 247) {
      return value + -32;

   } else if (value < 248) {
      return value + 0;

   } else if (value < 255) {
      return value + -32;

   } else if (value < 256) {
      return value + 121;

   } else if (value < 257) {
      return value + 0;

   } else if (value < 258) {
      return value + -1;

   } else if (value < 259) {
      return value + 0;

   } else if (value < 260) {
      return value + -1;

   } else if (value < 261) {
      return value + 0;

   } else if (value < 262) {
      return value + -1;

   } else if (value < 263) {
      return value + 0;

   } else if (value < 264) {
      return value + -1;

   } else if (value < 265) {
      return value + 0;

   } else if (value < 266) {
      return value + -1;

   } else if (value < 267) {
      return value + 0;

   } else if (value < 268) {
      return value + -1;

   } else if (value < 269) {
      return value + 0;

   } else if (value < 270) {
      return value + -1;

   } else if (value < 271) {
      return value + 0;

   } else if (value < 272) {
      return value + -1;

   } else if (value < 273) {
      return value + 0;

   } else if (value < 274) {
      return value + -1;

   } else if (value < 275) {
      return value + 0;

   } else if (value < 276) {
      return value + -1;

   } else if (value < 277) {
      return value + 0;

   } else if (value < 278) {
      return value + -1;

   } else if (value < 279) {
      return value + 0;

   } else if (value < 280) {
      return value + -1;

   } else if (value < 281) {
      return value + 0;

   } else if (value < 282) {
      return value + -1;

   } else if (value < 283) {
      return value + 0;

   } else if (value < 284) {
      return value + -1;

   } else if (value < 285) {
      return value + 0;

   } else if (value < 286) {
      return value + -1;

   } else if (value < 287) {
      return value + 0;

   } else if (value < 288) {
      return value + -1;

   } else if (value < 289) {
      return value + 0;

   } else if (value < 290) {
      return value + -1;

   } else if (value < 291) {
      return value + 0;

   } else if (value < 292) {
      return value + -1;

   } else if (value < 293) {
      return value + 0;

   } else if (value < 294) {
      return value + -1;

   } else if (value < 295) {
      return value + 0;

   } else if (value < 296) {
      return value + -1;

   } else if (value < 297) {
      return value + 0;

   } else if (value < 298) {
      return value + -1;

   } else if (value < 299) {
      return value + 0;

   } else if (value < 300) {
      return value + -1;

   } else if (value < 301) {
      return value + 0;

   } else if (value < 302) {
      return value + -1;

   } else if (value < 303) {
      return value + 0;

   } else if (value < 304) {
      return value + -1;

   } else if (value < 305) {
      return value + 0;

   } else if (value < 306) {
      return value + -232;

   } else if (value < 307) {
      return value + 0;

   } else if (value < 308) {
      return value + -1;

   } else if (value < 309) {
      return value + 0;

   } else if (value < 310) {
      return value + -1;

   } else if (value < 311) {
      return value + 0;

   } else if (value < 312) {
      return value + -1;

   } else if (value < 314) {
      return value + 0;

   } else if (value < 315) {
      return value + -1;

   } else if (value < 316) {
      return value + 0;

   } else if (value < 317) {
      return value + -1;

   } else if (value < 318) {
      return value + 0;

   } else if (value < 319) {
      return value + -1;

   } else if (value < 320) {
      return value + 0;

   } else if (value < 321) {
      return value + -1;

   } else if (value < 322) {
      return value + 0;

   } else if (value < 323) {
      return value + -1;

   } else if (value < 324) {
      return value + 0;

   } else if (value < 325) {
      return value + -1;

   } else if (value < 326) {
      return value + 0;

   } else if (value < 327) {
      return value + -1;

   } else if (value < 328) {
      return value + 0;

   } else if (value == 329) {
      // special char
      return 0;

   } else if (value < 330) {
      return value + -1;

   } else if (value < 331) {
      return value + 0;

   } else if (value < 332) {
      return value + -1;

   } else if (value < 333) {
      return value + 0;

   } else if (value < 334) {
      return value + -1;

   } else if (value < 335) {
      return value + 0;

   } else if (value < 336) {
      return value + -1;

   } else if (value < 337) {
      return value + 0;

   } else if (value < 338) {
      return value + -1;

   } else if (value < 339) {
      return value + 0;

   } else if (value < 340) {
      return value + -1;

   } else if (value < 341) {
      return value + 0;

   } else if (value < 342) {
      return value + -1;

   } else if (value < 343) {
      return value + 0;

   } else if (value < 344) {
      return value + -1;

   } else if (value < 345) {
      return value + 0;

   } else if (value < 346) {
      return value + -1;

   } else if (value < 347) {
      return value + 0;

   } else if (value < 348) {
      return value + -1;

   } else if (value < 349) {
      return value + 0;

   }

   if (value < 350) {
      return value + -1;

   } else if (value < 351) {
      return value + 0;

   } else if (value < 352) {
      return value + -1;

   } else if (value < 353) {
      return value + 0;

   } else if (value < 354) {
      return value + -1;

   } else if (value < 355) {
      return value + 0;

   } else if (value < 356) {
      return value + -1;

   } else if (value < 357) {
      return value + 0;

   } else if (value < 358) {
      return value + -1;

   } else if (value < 359) {
      return value + 0;

   } else if (value < 360) {
      return value + -1;

   } else if (value < 361) {
      return value + 0;

   } else if (value < 362) {
      return value + -1;

   } else if (value < 363) {
      return value + 0;

   } else if (value < 364) {
      return value + -1;

   } else if (value < 365) {
      return value + 0;

   } else if (value < 366) {
      return value + -1;

   } else if (value < 367) {
      return value + 0;

   } else if (value < 368) {
      return value + -1;

   } else if (value < 369) {
      return value + 0;

   } else if (value < 370) {
      return value + -1;

   } else if (value < 371) {
      return value + 0;

   } else if (value < 372) {
      return value + -1;

   } else if (value < 373) {
      return value + 0;

   } else if (value < 374) {
      return value + -1;

   } else if (value < 375) {
      return value + 0;

   } else if (value < 376) {
      return value + -1;

   } else if (value < 378) {
      return value + 0;

   } else if (value < 379) {
      return value + -1;

   } else if (value < 380) {
      return value + 0;

   } else if (value < 381) {
      return value + -1;

   } else if (value < 382) {
      return value + 0;

   } else if (value < 383) {
      return value + -1;

   } else if (value < 384) {
      return value + -300;

   } else if (value < 385) {
      return value + 195;

   } else if (value < 387) {
      return value + 0;

   } else if (value < 388) {
      return value + -1;

   } else if (value < 389) {
      return value + 0;

   } else if (value < 390) {
      return value + -1;

   } else if (value < 392) {
      return value + 0;

   } else if (value < 393) {
      return value + -1;

   } else if (value < 396) {
      return value + 0;

   } else if (value < 397) {
      return value + -1;

   } else if (value < 402) {
      return value + 0;

   } else if (value < 403) {
      return value + -1;

   } else if (value < 405) {
      return value + 0;

   } else if (value < 406) {
      return value + 97;

   } else if (value < 409) {
      return value + 0;

   } else if (value < 410) {
      return value + -1;

   } else if (value < 411) {
      return value + 163;

   } else if (value < 414) {
      return value + 0;

   } else if (value < 415) {
      return value + 130;

   } else if (value < 417) {
      return value + 0;

   } else if (value < 418) {
      return value + -1;

   } else if (value < 419) {
      return value + 0;

   } else if (value < 420) {
      return value + -1;

   } else if (value < 421) {
      return value + 0;

   } else if (value < 422) {
      return value + -1;

   } else if (value < 424) {
      return value + 0;

   } else if (value < 425) {
      return value + -1;

   } else if (value < 429) {
      return value + 0;

   } else if (value < 430) {
      return value + -1;

   } else if (value < 432) {
      return value + 0;

   } else if (value < 433) {
      return value + -1;

   } else if (value < 436) {
      return value + 0;

   } else if (value < 437) {
      return value + -1;

   } else if (value < 438) {
      return value + 0;

   } else if (value < 439) {
      return value + -1;

   } else if (value < 441) {
      return value + 0;

   } else if (value < 442) {
      return value + -1;

   } else if (value < 445) {
      return value + 0;

   } else if (value < 446) {
      return value + -1;

   } else if (value < 447) {
      return value + 0;

   } else if (value < 448) {
      return value + 56;

   } else if (value < 452) {
      return value + 0;

   } else if (value < 453) {
      return value + 1;

   } else if (value < 454) {
      return value + 0;

   } else if (value < 455) {
      return value + -1;

   } else if (value < 456) {
      return value + 1;

   } else if (value < 457) {
      return value + 0;

   } else if (value < 458) {
      return value + -1;

   } else if (value < 459) {
      return value + 1;

   } else if (value < 460) {
      return value + 0;

   } else if (value < 461) {
      return value + -1;

   } else if (value < 462) {
      return value + 0;

   } else if (value < 463) {
      return value + -1;

   } else if (value < 464) {
      return value + 0;

   } else if (value < 465) {
      return value + -1;

   } else if (value < 466) {
      return value + 0;

   } else if (value < 467) {
      return value + -1;

   } else if (value < 468) {
      return value + 0;

   } else if (value < 469) {
      return value + -1;

   } else if (value < 470) {
      return value + 0;

   } else if (value < 471) {
      return value + -1;

   } else if (value < 472) {
      return value + 0;

   } else if (value < 473) {
      return value + -1;

   } else if (value < 474) {
      return value + 0;

   } else if (value < 475) {
      return value + -1;

   } else if (value < 476) {
      return value + 0;

   } else if (value < 477) {
      return value + -1;

   }

   if (value < 478) {
      return value + -79;

   } else if (value < 479) {
      return value + 0;

   } else if (value < 480) {
      return value + -1;

   } else if (value < 481) {
      return value + 0;

   } else if (value < 482) {
      return value + -1;

   } else if (value < 483) {
      return value + 0;

   } else if (value < 484) {
      return value + -1;

   } else if (value < 485) {
      return value + 0;

   } else if (value < 486) {
      return value + -1;

   } else if (value < 487) {
      return value + 0;

   } else if (value < 488) {
      return value + -1;

   } else if (value < 489) {
      return value + 0;

   } else if (value < 490) {
      return value + -1;

   } else if (value < 491) {
      return value + 0;

   } else if (value < 492) {
      return value + -1;

   } else if (value < 493) {
      return value + 0;

   } else if (value < 494) {
      return value + -1;

   } else if (value < 495) {
      return value + 0;

   } else if (value == 496) {
      // special char
      return 0;

   } else if (value < 497) {
      return value + -1;

   } else if (value < 498) {
      return value + 1;

   } else if (value < 499) {
      return value + 0;

   } else if (value < 500) {
      return value + -1;

   } else if (value < 501) {
      return value + 0;

   } else if (value < 502) {
      return value + -1;

   } else if (value < 505) {
      return value + 0;

   } else if (value < 506) {
      return value + -1;

   } else if (value < 507) {
      return value + 0;

   } else if (value < 508) {
      return value + -1;

   } else if (value < 509) {
      return value + 0;

   } else if (value < 510) {
      return value + -1;

   } else if (value < 511) {
      return value + 0;

   } else if (value < 512) {
      return value + -1;

   } else if (value < 513) {
      return value + 0;

   } else if (value < 514) {
      return value + -1;

   } else if (value < 515) {
      return value + 0;

   } else if (value < 516) {
      return value + -1;

   } else if (value < 517) {
      return value + 0;

   } else if (value < 518) {
      return value + -1;

   } else if (value < 519) {
      return value + 0;

   } else if (value < 520) {
      return value + -1;

   } else if (value < 521) {
      return value + 0;

   } else if (value < 522) {
      return value + -1;

   } else if (value < 523) {
      return value + 0;

   } else if (value < 524) {
      return value + -1;

   } else if (value < 525) {
      return value + 0;

   } else if (value < 526) {
      return value + -1;

   } else if (value < 527) {
      return value + 0;

   } else if (value < 528) {
      return value + -1;

   } else if (value < 529) {
      return value + 0;

   } else if (value < 530) {
      return value + -1;

   } else if (value < 531) {
      return value + 0;

   } else if (value < 532) {
      return value + -1;

   } else if (value < 533) {
      return value + 0;

   } else if (value < 534) {
      return value + -1;

   } else if (value < 535) {
      return value + 0;

   } else if (value < 536) {
      return value + -1;

   } else if (value < 537) {
      return value + 0;

   } else if (value < 538) {
      return value + -1;

   } else if (value < 539) {
      return value + 0;

   } else if (value < 540) {
      return value + -1;

   } else if (value < 541) {
      return value + 0;

   } else if (value < 542) {
      return value + -1;

   } else if (value < 543) {
      return value + 0;

   } else if (value < 544) {
      return value + -1;

   } else if (value < 547) {
      return value + 0;

   } else if (value < 548) {
      return value + -1;

   } else if (value < 549) {
      return value + 0;

   } else if (value < 550) {
      return value + -1;

   } else if (value < 551) {
      return value + 0;

   } else if (value < 552) {
      return value + -1;

   } else if (value < 553) {
      return value + 0;

   } else if (value < 554) {
      return value + -1;

   } else if (value < 555) {
      return value + 0;

   } else if (value < 556) {
      return value + -1;

   } else if (value < 557) {
      return value + 0;

   } else if (value < 558) {
      return value + -1;

   } else if (value < 559) {
      return value + 0;

   } else if (value < 560) {
      return value + -1;

   } else if (value < 561) {
      return value + 0;

   } else if (value < 562) {
      return value + -1;

   } else if (value < 563) {
      return value + 0;

   } else if (value < 564) {
      return value + -1;

   } else if (value < 572) {
      return value + 0;

   } else if (value < 573) {
      return value + -1;

   } else if (value < 575) {
      return value + 0;

   } else if (value < 577) {
      return value + 10815;

   } else if (value < 578) {
      return value + 0;

   } else if (value < 579) {
      return value + -1;

   } else if (value < 583) {
      return value + 0;

   } else if (value < 584) {
      return value + -1;

   } else if (value < 585) {
      return value + 0;

   } else if (value < 586) {
      return value + -1;

   } else if (value < 587) {
      return value + 0;

   } else if (value < 588) {
      return value + -1;

   } else if (value < 589) {
      return value + 0;

   } else if (value < 590) {
      return value + -1;

   } else if (value < 591) {
      return value + 0;

   } else if (value < 592) {
      return value + -1;

   } else if (value < 593) {
      return value + 10783;

   } else if (value < 594) {
      return value + 10780;

   }

   if (value < 595) {
      return value + 10782;

   } else if (value < 596) {
      return value + -210;

   } else if (value < 597) {
      return value + -206;

   } else if (value < 598) {
      return value + 0;

   } else if (value < 600) {
      return value + -205;

   } else if (value < 601) {
      return value + 0;

   } else if (value < 602) {
      return value + -202;

   } else if (value < 603) {
      return value + 0;

   } else if (value < 604) {
      return value + -203;

   } else if (value < 605) {
      return value + 42319;

   } else if (value < 608) {
      return value + 0;

   } else if (value < 609) {
      return value + -205;

   } else if (value < 610) {
      return value + 42315;

   } else if (value < 611) {
      return value + 0;

   } else if (value < 612) {
      return value + -207;

   } else if (value < 613) {
      return value + 0;

   } else if (value < 614) {
      return value + 42280;

   } else if (value < 615) {
      return value + 42308;

   } else if (value < 616) {
      return value + 0;

   } else if (value < 617) {
      return value + -209;

   } else if (value < 618) {
      return value + -211;

   } else if (value < 619) {
      return value + 42308;

   } else if (value < 620) {
      return value + 10743;

   } else if (value < 621) {
      return value + 42305;

   } else if (value < 623) {
      return value + 0;

   } else if (value < 624) {
      return value + -211;

   } else if (value < 625) {
      return value + 0;

   } else if (value < 626) {
      return value + 10749;

   } else if (value < 627) {
      return value + -213;

   } else if (value < 629) {
      return value + 0;

   } else if (value < 630) {
      return value + -214;

   } else if (value < 637) {
      return value + 0;

   } else if (value < 638) {
      return value + 10727;

   } else if (value < 640) {
      return value + 0;

   } else if (value < 641) {
      return value + -218;

   } else if (value < 642) {
      return value + 0;

   } else if (value < 643) {
      return value + 42307;

   } else if (value < 644) {
      return value + -218;

   } else if (value < 647) {
      return value + 0;

   } else if (value < 648) {
      return value + 42282;

   } else if (value < 649) {
      return value + -218;

   } else if (value < 650) {
      return value + -69;

   } else if (value < 652) {
      return value + -217;

   } else if (value < 653) {
      return value + -71;

   } else if (value < 658) {
      return value + 0;

   } else if (value < 659) {
      return value + -219;

   } else if (value < 669) {
      return value + 0;

   } else if (value < 670) {
      return value + 42261;

   } else if (value < 671) {
      return value + 42258;

   } else if (value < 837) {
      return value + 0;

   } else if (value < 838) {
      return value + 84;

   } else if (value < 881) {
      return value + 0;

   } else if (value < 882) {
      return value + -1;

   } else if (value < 883) {
      return value + 0;

   } else if (value < 884) {
      return value + -1;

   } else if (value < 887) {
      return value + 0;

   } else if (value < 888) {
      return value + -1;

   } else if (value < 891) {
      return value + 0;

   } else if (value < 894) {
      return value + 130;

   } else if (value == 912) {
      // special char
      return 0;

   } else if (value < 940) {
      return value + 0;

   } else if (value < 941) {
      return value + -38;

   } else if (value == 944) {
      // special char
      return 0;

   } else if (value < 945) {
      return value + -37;

   } else if (value < 962) {
      return value + -32;

   } else if (value < 963) {
      return value + -31;

   } else if (value < 972) {
      return value + -32;

   } else if (value < 973) {
      return value + -64;

   } else if (value < 975) {
      return value + -63;

   } else if (value < 976) {
      return value + 0;

   } else if (value < 977) {
      return value + -62;

   } else if (value < 978) {
      return value + -57;

   } else if (value < 981) {
      return value + 0;

   } else if (value < 982) {
      return value + -47;

   } else if (value < 983) {
      return value + -54;

   } else if (value < 984) {
      return value + -8;

   } else if (value < 985) {
      return value + 0;

   } else if (value < 986) {
      return value + -1;

   } else if (value < 987) {
      return value + 0;

   } else if (value < 988) {
      return value + -1;

   } else if (value < 989) {
      return value + 0;

   } else if (value < 990) {
      return value + -1;

   } else if (value < 991) {
      return value + 0;

   } else if (value < 992) {
      return value + -1;

   } else if (value < 993) {
      return value + 0;

   } else if (value < 994) {
      return value + -1;

   } else if (value < 995) {
      return value + 0;

   } else if (value < 996) {
      return value + -1;

   } else if (value < 997) {
      return value + 0;

   } else if (value < 998) {
      return value + -1;

   } else if (value < 999) {
      return value + 0;

   } else if (value < 1000) {
      return value + -1;

   } else if (value < 1001) {
      return value + 0;

   } else if (value < 1002) {
      return value + -1;

   } else if (value < 1003) {
      return value + 0;

   } else if (value < 1004) {
      return value + -1;

   } else if (value < 1005) {
      return value + 0;

   } else if (value < 1006) {
      return value + -1;

   } else if (value < 1007) {
      return value + 0;

   } else if (value < 1008) {
      return value + -1;

   } else if (value < 1009) {
      return value + -86;

   } else if (value < 1010) {
      return value + -80;

   }

   if (value < 1011) {
      return value + 7;

   } else if (value < 1012) {
      return value + -116;

   } else if (value < 1013) {
      return value + 0;

   } else if (value < 1014) {
      return value + -96;

   } else if (value < 1016) {
      return value + 0;

   } else if (value < 1017) {
      return value + -1;

   } else if (value < 1019) {
      return value + 0;

   } else if (value < 1020) {
      return value + -1;

   } else if (value < 1072) {
      return value + 0;

   } else if (value < 1104) {
      return value + -32;

   } else if (value < 1120) {
      return value + -80;

   } else if (value < 1121) {
      return value + 0;

   } else if (value < 1122) {
      return value + -1;

   } else if (value < 1123) {
      return value + 0;

   } else if (value < 1124) {
      return value + -1;

   } else if (value < 1125) {
      return value + 0;

   } else if (value < 1126) {
      return value + -1;

   } else if (value < 1127) {
      return value + 0;

   } else if (value < 1128) {
      return value + -1;

   } else if (value < 1129) {
      return value + 0;

   } else if (value < 1130) {
      return value + -1;

   } else if (value < 1131) {
      return value + 0;

   } else if (value < 1132) {
      return value + -1;

   } else if (value < 1133) {
      return value + 0;

   } else if (value < 1134) {
      return value + -1;

   } else if (value < 1135) {
      return value + 0;

   } else if (value < 1136) {
      return value + -1;

   } else if (value < 1137) {
      return value + 0;

   } else if (value < 1138) {
      return value + -1;

   } else if (value < 1139) {
      return value + 0;

   } else if (value < 1140) {
      return value + -1;

   } else if (value < 1141) {
      return value + 0;

   } else if (value < 1142) {
      return value + -1;

   } else if (value < 1143) {
      return value + 0;

   } else if (value < 1144) {
      return value + -1;

   } else if (value < 1145) {
      return value + 0;

   } else if (value < 1146) {
      return value + -1;

   } else if (value < 1147) {
      return value + 0;

   } else if (value < 1148) {
      return value + -1;

   } else if (value < 1149) {
      return value + 0;

   } else if (value < 1150) {
      return value + -1;

   } else if (value < 1151) {
      return value + 0;

   } else if (value < 1152) {
      return value + -1;

   } else if (value < 1153) {
      return value + 0;

   } else if (value < 1154) {
      return value + -1;

   } else if (value < 1163) {
      return value + 0;

   } else if (value < 1164) {
      return value + -1;

   } else if (value < 1165) {
      return value + 0;

   } else if (value < 1166) {
      return value + -1;

   } else if (value < 1167) {
      return value + 0;

   } else if (value < 1168) {
      return value + -1;

   } else if (value < 1169) {
      return value + 0;

   } else if (value < 1170) {
      return value + -1;

   } else if (value < 1171) {
      return value + 0;

   } else if (value < 1172) {
      return value + -1;

   } else if (value < 1173) {
      return value + 0;

   } else if (value < 1174) {
      return value + -1;

   } else if (value < 1175) {
      return value + 0;

   } else if (value < 1176) {
      return value + -1;

   } else if (value < 1177) {
      return value + 0;

   } else if (value < 1178) {
      return value + -1;

   } else if (value < 1179) {
      return value + 0;

   } else if (value < 1180) {
      return value + -1;

   } else if (value < 1181) {
      return value + 0;

   } else if (value < 1182) {
      return value + -1;

   } else if (value < 1183) {
      return value + 0;

   } else if (value < 1184) {
      return value + -1;

   } else if (value < 1185) {
      return value + 0;

   } else if (value < 1186) {
      return value + -1;

   } else if (value < 1187) {
      return value + 0;

   } else if (value < 1188) {
      return value + -1;

   } else if (value < 1189) {
      return value + 0;

   } else if (value < 1190) {
      return value + -1;

   } else if (value < 1191) {
      return value + 0;

   } else if (value < 1192) {
      return value + -1;

   } else if (value < 1193) {
      return value + 0;

   } else if (value < 1194) {
      return value + -1;

   } else if (value < 1195) {
      return value + 0;

   } else if (value < 1196) {
      return value + -1;

   } else if (value < 1197) {
      return value + 0;

   } else if (value < 1198) {
      return value + -1;

   } else if (value < 1199) {
      return value + 0;

   } else if (value < 1200) {
      return value + -1;

   } else if (value < 1201) {
      return value + 0;

   } else if (value < 1202) {
      return value + -1;

   } else if (value < 1203) {
      return value + 0;

   } else if (value < 1204) {
      return value + -1;

   } else if (value < 1205) {
      return value + 0;

   } else if (value < 1206) {
      return value + -1;

   } else if (value < 1207) {
      return value + 0;

   } else if (value < 1208) {
      return value + -1;

   } else if (value < 1209) {
      return value + 0;

   } else if (value < 1210) {
      return value + -1;

   } else if (value < 1211) {
      return value + 0;

   } else if (value < 1212) {
      return value + -1;

   } else if (value < 1213) {
      return value + 0;

   } else if (value < 1214) {
      return value + -1;

   } else if (value < 1215) {
      return value + 0;

   } else if (value < 1216) {
      return value + -1;

   } else if (value < 1218) {
      return value + 0;

   }

   if (value < 1219) {
      return value + -1;

   } else if (value < 1220) {
      return value + 0;

   } else if (value < 1221) {
      return value + -1;

   } else if (value < 1222) {
      return value + 0;

   } else if (value < 1223) {
      return value + -1;

   } else if (value < 1224) {
      return value + 0;

   } else if (value < 1225) {
      return value + -1;

   } else if (value < 1226) {
      return value + 0;

   } else if (value < 1227) {
      return value + -1;

   } else if (value < 1228) {
      return value + 0;

   } else if (value < 1229) {
      return value + -1;

   } else if (value < 1230) {
      return value + 0;

   } else if (value < 1231) {
      return value + -1;

   } else if (value < 1232) {
      return value + -15;

   } else if (value < 1233) {
      return value + 0;

   } else if (value < 1234) {
      return value + -1;

   } else if (value < 1235) {
      return value + 0;

   } else if (value < 1236) {
      return value + -1;

   } else if (value < 1237) {
      return value + 0;

   } else if (value < 1238) {
      return value + -1;

   } else if (value < 1239) {
      return value + 0;

   } else if (value < 1240) {
      return value + -1;

   } else if (value < 1241) {
      return value + 0;

   } else if (value < 1242) {
      return value + -1;

   } else if (value < 1243) {
      return value + 0;

   } else if (value < 1244) {
      return value + -1;

   } else if (value < 1245) {
      return value + 0;

   } else if (value < 1246) {
      return value + -1;

   } else if (value < 1247) {
      return value + 0;

   } else if (value < 1248) {
      return value + -1;

   } else if (value < 1249) {
      return value + 0;

   } else if (value < 1250) {
      return value + -1;

   } else if (value < 1251) {
      return value + 0;

   } else if (value < 1252) {
      return value + -1;

   } else if (value < 1253) {
      return value + 0;

   } else if (value < 1254) {
      return value + -1;

   } else if (value < 1255) {
      return value + 0;

   } else if (value < 1256) {
      return value + -1;

   } else if (value < 1257) {
      return value + 0;

   } else if (value < 1258) {
      return value + -1;

   } else if (value < 1259) {
      return value + 0;

   } else if (value < 1260) {
      return value + -1;

   } else if (value < 1261) {
      return value + 0;

   } else if (value < 1262) {
      return value + -1;

   } else if (value < 1263) {
      return value + 0;

   } else if (value < 1264) {
      return value + -1;

   } else if (value < 1265) {
      return value + 0;

   } else if (value < 1266) {
      return value + -1;

   } else if (value < 1267) {
      return value + 0;

   } else if (value < 1268) {
      return value + -1;

   } else if (value < 1269) {
      return value + 0;

   } else if (value < 1270) {
      return value + -1;

   } else if (value < 1271) {
      return value + 0;

   } else if (value < 1272) {
      return value + -1;

   } else if (value < 1273) {
      return value + 0;

   } else if (value < 1274) {
      return value + -1;

   } else if (value < 1275) {
      return value + 0;

   } else if (value < 1276) {
      return value + -1;

   } else if (value < 1277) {
      return value + 0;

   } else if (value < 1278) {
      return value + -1;

   } else if (value < 1279) {
      return value + 0;

   } else if (value < 1280) {
      return value + -1;

   } else if (value < 1281) {
      return value + 0;

   } else if (value < 1282) {
      return value + -1;

   } else if (value < 1283) {
      return value + 0;

   } else if (value < 1284) {
      return value + -1;

   } else if (value < 1285) {
      return value + 0;

   } else if (value < 1286) {
      return value + -1;

   } else if (value < 1287) {
      return value + 0;

   } else if (value < 1288) {
      return value + -1;

   } else if (value < 1289) {
      return value + 0;

   } else if (value < 1290) {
      return value + -1;

   } else if (value < 1291) {
      return value + 0;

   } else if (value < 1292) {
      return value + -1;

   } else if (value < 1293) {
      return value + 0;

   } else if (value < 1294) {
      return value + -1;

   } else if (value < 1295) {
      return value + 0;

   } else if (value < 1296) {
      return value + -1;

   } else if (value < 1297) {
      return value + 0;

   } else if (value < 1298) {
      return value + -1;

   } else if (value < 1299) {
      return value + 0;

   } else if (value < 1300) {
      return value + -1;

   } else if (value < 1301) {
      return value + 0;

   } else if (value < 1302) {
      return value + -1;

   } else if (value < 1303) {
      return value + 0;

   } else if (value < 1304) {
      return value + -1;

   } else if (value < 1305) {
      return value + 0;

   } else if (value < 1306) {
      return value + -1;

   } else if (value < 1307) {
      return value + 0;

   } else if (value < 1308) {
      return value + -1;

   } else if (value < 1309) {
      return value + 0;

   } else if (value < 1310) {
      return value + -1;

   } else if (value < 1311) {
      return value + 0;

   } else if (value < 1312) {
      return value + -1;

   } else if (value < 1313) {
      return value + 0;

   } else if (value < 1314) {
      return value + -1;

   } else if (value < 1315) {
      return value + 0;

   } else if (value < 1316) {
      return value + -1;

   } else if (value < 1317) {
      return value + 0;

   } else if (value < 1318) {
      return value + -1;

   }

   if (value < 1319) {
      return value + 0;

   } else if (value < 1320) {
      return value + -1;

   } else if (value < 1321) {
      return value + 0;

   } else if (value < 1322) {
      return value + -1;

   } else if (value < 1323) {
      return value + 0;

   } else if (value < 1324) {
      return value + -1;

   } else if (value < 1325) {
      return value + 0;

   } else if (value < 1326) {
      return value + -1;

   } else if (value < 1327) {
      return value + 0;

   } else if (value < 1328) {
      return value + -1;

   } else if (value < 1377) {
      return value + 0;

   } else if (value == 1415) {
      // special char
      return 0;

   } else if (value < 1416) {
      return value + -48;

   } else if (value < 5112) {
      return value + 0;

   } else if (value < 5118) {
      return value + -8;

   } else if (value < 7296) {
      return value + 0;

   } else if (value < 7297) {
      return value + -6254;

   } else if (value < 7298) {
      return value + -6253;

   } else if (value < 7299) {
      return value + -6244;

   } else if (value < 7301) {
      return value + -6242;

   } else if (value < 7302) {
      return value + -6243;

   } else if (value < 7303) {
      return value + -6236;

   } else if (value < 7304) {
      return value + -6181;

   } else if (value < 7305) {
      return value + 35266;

   } else if (value < 7545) {
      return value + 0;

   } else if (value < 7546) {
      return value + 35332;

   } else if (value < 7549) {
      return value + 0;

   } else if (value < 7550) {
      return value + 3814;

   } else if (value < 7566) {
      return value + 0;

   } else if (value < 7567) {
      return value + 35384;

   } else if (value < 7681) {
      return value + 0;

   } else if (value < 7682) {
      return value + -1;

   } else if (value < 7683) {
      return value + 0;

   } else if (value < 7684) {
      return value + -1;

   } else if (value < 7685) {
      return value + 0;

   } else if (value < 7686) {
      return value + -1;

   } else if (value < 7687) {
      return value + 0;

   } else if (value < 7688) {
      return value + -1;

   } else if (value < 7689) {
      return value + 0;

   } else if (value < 7690) {
      return value + -1;

   } else if (value < 7691) {
      return value + 0;

   } else if (value < 7692) {
      return value + -1;

   } else if (value < 7693) {
      return value + 0;

   } else if (value < 7694) {
      return value + -1;

   } else if (value < 7695) {
      return value + 0;

   } else if (value < 7696) {
      return value + -1;

   } else if (value < 7697) {
      return value + 0;

   } else if (value < 7698) {
      return value + -1;

   } else if (value < 7699) {
      return value + 0;

   } else if (value < 7700) {
      return value + -1;

   } else if (value < 7701) {
      return value + 0;

   } else if (value < 7702) {
      return value + -1;

   } else if (value < 7703) {
      return value + 0;

   } else if (value < 7704) {
      return value + -1;

   } else if (value < 7705) {
      return value + 0;

   } else if (value < 7706) {
      return value + -1;

   } else if (value < 7707) {
      return value + 0;

   } else if (value < 7708) {
      return value + -1;

   } else if (value < 7709) {
      return value + 0;

   } else if (value < 7710) {
      return value + -1;

   } else if (value < 7711) {
      return value + 0;

   } else if (value < 7712) {
      return value + -1;

   } else if (value < 7713) {
      return value + 0;

   } else if (value < 7714) {
      return value + -1;

   } else if (value < 7715) {
      return value + 0;

   } else if (value < 7716) {
      return value + -1;

   } else if (value < 7717) {
      return value + 0;

   } else if (value < 7718) {
      return value + -1;

   } else if (value < 7719) {
      return value + 0;

   } else if (value < 7720) {
      return value + -1;

   } else if (value < 7721) {
      return value + 0;

   } else if (value < 7722) {
      return value + -1;

   } else if (value < 7723) {
      return value + 0;

   } else if (value < 7724) {
      return value + -1;

   } else if (value < 7725) {
      return value + 0;

   } else if (value < 7726) {
      return value + -1;

   } else if (value < 7727) {
      return value + 0;

   } else if (value < 7728) {
      return value + -1;

   } else if (value < 7729) {
      return value + 0;

   } else if (value < 7730) {
      return value + -1;

   } else if (value < 7731) {
      return value + 0;

   } else if (value < 7732) {
      return value + -1;

   } else if (value < 7733) {
      return value + 0;

   } else if (value < 7734) {
      return value + -1;

   } else if (value < 7735) {
      return value + 0;

   } else if (value < 7736) {
      return value + -1;

   } else if (value < 7737) {
      return value + 0;

   } else if (value < 7738) {
      return value + -1;

   } else if (value < 7739) {
      return value + 0;

   } else if (value < 7740) {
      return value + -1;

   } else if (value < 7741) {
      return value + 0;

   } else if (value < 7742) {
      return value + -1;

   } else if (value < 7743) {
      return value + 0;

   } else if (value < 7744) {
      return value + -1;

   } else if (value < 7745) {
      return value + 0;

   } else if (value < 7746) {
      return value + -1;

   } else if (value < 7747) {
      return value + 0;

   } else if (value < 7748) {
      return value + -1;

   } else if (value < 7749) {
      return value + 0;

   } else if (value < 7750) {
      return value + -1;

   } else if (value < 7751) {
      return value + 0;

   }

   if (value < 7752) {
      return value + -1;

   } else if (value < 7753) {
      return value + 0;

   } else if (value < 7754) {
      return value + -1;

   } else if (value < 7755) {
      return value + 0;

   } else if (value < 7756) {
      return value + -1;

   } else if (value < 7757) {
      return value + 0;

   } else if (value < 7758) {
      return value + -1;

   } else if (value < 7759) {
      return value + 0;

   } else if (value < 7760) {
      return value + -1;

   } else if (value < 7761) {
      return value + 0;

   } else if (value < 7762) {
      return value + -1;

   } else if (value < 7763) {
      return value + 0;

   } else if (value < 7764) {
      return value + -1;

   } else if (value < 7765) {
      return value + 0;

   } else if (value < 7766) {
      return value + -1;

   } else if (value < 7767) {
      return value + 0;

   } else if (value < 7768) {
      return value + -1;

   } else if (value < 7769) {
      return value + 0;

   } else if (value < 7770) {
      return value + -1;

   } else if (value < 7771) {
      return value + 0;

   } else if (value < 7772) {
      return value + -1;

   } else if (value < 7773) {
      return value + 0;

   } else if (value < 7774) {
      return value + -1;

   } else if (value < 7775) {
      return value + 0;

   } else if (value < 7776) {
      return value + -1;

   } else if (value < 7777) {
      return value + 0;

   } else if (value < 7778) {
      return value + -1;

   } else if (value < 7779) {
      return value + 0;

   } else if (value < 7780) {
      return value + -1;

   } else if (value < 7781) {
      return value + 0;

   } else if (value < 7782) {
      return value + -1;

   } else if (value < 7783) {
      return value + 0;

   } else if (value < 7784) {
      return value + -1;

   } else if (value < 7785) {
      return value + 0;

   } else if (value < 7786) {
      return value + -1;

   } else if (value < 7787) {
      return value + 0;

   } else if (value < 7788) {
      return value + -1;

   } else if (value < 7789) {
      return value + 0;

   } else if (value < 7790) {
      return value + -1;

   } else if (value < 7791) {
      return value + 0;

   } else if (value < 7792) {
      return value + -1;

   } else if (value < 7793) {
      return value + 0;

   } else if (value < 7794) {
      return value + -1;

   } else if (value < 7795) {
      return value + 0;

   } else if (value < 7796) {
      return value + -1;

   } else if (value < 7797) {
      return value + 0;

   } else if (value < 7798) {
      return value + -1;

   } else if (value < 7799) {
      return value + 0;

   } else if (value < 7800) {
      return value + -1;

   } else if (value < 7801) {
      return value + 0;

   } else if (value < 7802) {
      return value + -1;

   } else if (value < 7803) {
      return value + 0;

   } else if (value < 7804) {
      return value + -1;

   } else if (value < 7805) {
      return value + 0;

   } else if (value < 7806) {
      return value + -1;

   } else if (value < 7807) {
      return value + 0;

   } else if (value < 7808) {
      return value + -1;

   } else if (value < 7809) {
      return value + 0;

   } else if (value < 7810) {
      return value + -1;

   } else if (value < 7811) {
      return value + 0;

   } else if (value < 7812) {
      return value + -1;

   } else if (value < 7813) {
      return value + 0;

   } else if (value < 7814) {
      return value + -1;

   } else if (value < 7815) {
      return value + 0;

   } else if (value < 7816) {
      return value + -1;

   } else if (value < 7817) {
      return value + 0;

   } else if (value < 7818) {
      return value + -1;

   } else if (value < 7819) {
      return value + 0;

   } else if (value < 7820) {
      return value + -1;

   } else if (value < 7821) {
      return value + 0;

   } else if (value < 7822) {
      return value + -1;

   } else if (value < 7823) {
      return value + 0;

   } else if (value < 7824) {
      return value + -1;

   } else if (value < 7825) {
      return value + 0;

   } else if (value < 7826) {
      return value + -1;

   } else if (value < 7827) {
      return value + 0;

   } else if (value < 7828) {
      return value + -1;

   } else if (value < 7829) {
      return value + 0;

   } else if (value == 7830) {
      // special char
      return 0;

   } else if (value == 7831) {
      // special char
      return 0;

   } else if (value == 7832) {
      // special char
      return 0;

   } else if (value == 7833) {
      // special char
      return 0;

   } else if (value == 7834) {
      // special char
      return 0;

   } else if (value < 7835) {
      return value + -1;

   } else if (value < 7836) {
      return value + -59;

   } else if (value < 7841) {
      return value + 0;

   } else if (value < 7842) {
      return value + -1;

   } else if (value < 7843) {
      return value + 0;

   } else if (value < 7844) {
      return value + -1;

   } else if (value < 7845) {
      return value + 0;

   } else if (value < 7846) {
      return value + -1;

   } else if (value < 7847) {
      return value + 0;

   } else if (value < 7848) {
      return value + -1;

   } else if (value < 7849) {
      return value + 0;

   } else if (value < 7850) {
      return value + -1;

   } else if (value < 7851) {
      return value + 0;

   } else if (value < 7852) {
      return value + -1;

   } else if (value < 7853) {
      return value + 0;

   } else if (value < 7854) {
      return value + -1;

   } else if (value < 7855) {
      return value + 0;

   } else if (value < 7856) {
      return value + -1;

   } else if (value < 7857) {
      return value + 0;

   } else if (value < 7858) {
      return value + -1;

   } else if (value < 7859) {
      return value + 0;

   } else if (value < 7860) {
      return value + -1;

   }

   if (value < 7861) {
      return value + 0;

   } else if (value < 7862) {
      return value + -1;

   } else if (value < 7863) {
      return value + 0;

   } else if (value < 7864) {
      return value + -1;

   } else if (value < 7865) {
      return value + 0;

   } else if (value < 7866) {
      return value + -1;

   } else if (value < 7867) {
      return value + 0;

   } else if (value < 7868) {
      return value + -1;

   } else if (value < 7869) {
      return value + 0;

   } else if (value < 7870) {
      return value + -1;

   } else if (value < 7871) {
      return value + 0;

   } else if (value < 7872) {
      return value + -1;

   } else if (value < 7873) {
      return value + 0;

   } else if (value < 7874) {
      return value + -1;

   } else if (value < 7875) {
      return value + 0;

   } else if (value < 7876) {
      return value + -1;

   } else if (value < 7877) {
      return value + 0;

   } else if (value < 7878) {
      return value + -1;

   } else if (value < 7879) {
      return value + 0;

   } else if (value < 7880) {
      return value + -1;

   } else if (value < 7881) {
      return value + 0;

   } else if (value < 7882) {
      return value + -1;

   } else if (value < 7883) {
      return value + 0;

   } else if (value < 7884) {
      return value + -1;

   } else if (value < 7885) {
      return value + 0;

   } else if (value < 7886) {
      return value + -1;

   } else if (value < 7887) {
      return value + 0;

   } else if (value < 7888) {
      return value + -1;

   } else if (value < 7889) {
      return value + 0;

   } else if (value < 7890) {
      return value + -1;

   } else if (value < 7891) {
      return value + 0;

   } else if (value < 7892) {
      return value + -1;

   } else if (value < 7893) {
      return value + 0;

   } else if (value < 7894) {
      return value + -1;

   } else if (value < 7895) {
      return value + 0;

   } else if (value < 7896) {
      return value + -1;

   } else if (value < 7897) {
      return value + 0;

   } else if (value < 7898) {
      return value + -1;

   } else if (value < 7899) {
      return value + 0;

   } else if (value < 7900) {
      return value + -1;

   } else if (value < 7901) {
      return value + 0;

   } else if (value < 7902) {
      return value + -1;

   } else if (value < 7903) {
      return value + 0;

   } else if (value < 7904) {
      return value + -1;

   } else if (value < 7905) {
      return value + 0;

   } else if (value < 7906) {
      return value + -1;

   } else if (value < 7907) {
      return value + 0;

   } else if (value < 7908) {
      return value + -1;

   } else if (value < 7909) {
      return value + 0;

   } else if (value < 7910) {
      return value + -1;

   } else if (value < 7911) {
      return value + 0;

   } else if (value < 7912) {
      return value + -1;

   } else if (value < 7913) {
      return value + 0;

   } else if (value < 7914) {
      return value + -1;

   } else if (value < 7915) {
      return value + 0;

   } else if (value < 7916) {
      return value + -1;

   } else if (value < 7917) {
      return value + 0;

   } else if (value < 7918) {
      return value + -1;

   } else if (value < 7919) {
      return value + 0;

   } else if (value < 7920) {
      return value + -1;

   } else if (value < 7921) {
      return value + 0;

   } else if (value < 7922) {
      return value + -1;

   } else if (value < 7923) {
      return value + 0;

   } else if (value < 7924) {
      return value + -1;

   } else if (value < 7925) {
      return value + 0;

   } else if (value < 7926) {
      return value + -1;

   } else if (value < 7927) {
      return value + 0;

   } else if (value < 7928) {
      return value + -1;

   } else if (value < 7929) {
      return value + 0;

   } else if (value < 7930) {
      return value + -1;

   } else if (value < 7931) {
      return value + 0;

   } else if (value < 7932) {
      return value + -1;

   } else if (value < 7933) {
      return value + 0;

   } else if (value < 7934) {
      return value + -1;

   } else if (value < 7935) {
      return value + 0;

   } else if (value < 7936) {
      return value + -1;

   } else if (value < 7944) {
      return value + 8;

   } else if (value < 7952) {
      return value + 0;

   } else if (value < 7958) {
      return value + 8;

   } else if (value < 7968) {
      return value + 0;

   } else if (value < 7976) {
      return value + 8;

   } else if (value < 7984) {
      return value + 0;

   } else if (value < 7992) {
      return value + 8;

   } else if (value < 8000) {
      return value + 0;

   } else if (value < 8006) {
      return value + 8;

   } else if (value == 8016) {
      // special char
      return 0;

   } else if (value < 8017) {
      return value + 0;

   } else if (value == 8018) {
      // special char
      return 0;

   } else if (value == 8020) {
      // special char
      return 0;

   } else if (value == 8022) {
      // special char
      return 0;

   } else if (value < 8024) {
      return value + 8;

   } else if (value < 8032) {
      return value + 0;

   } else if (value < 8040) {
      return value + 8;

   } else if (value < 8048) {
      return value + 0;

   } else if (value < 8050) {
      return value + 74;

   } else if (value < 8054) {
      return value + 86;

   } else if (value < 8056) {
      return value + 100;

   } else if (value < 8058) {
      return value + 128;

   } else if (value < 8060) {
      return value + 112;

   } else if (value < 8062) {
      return value + 126;

   } else if (value < 8064) {
      return value + 0;

   } else if (value < 8072) {
      return value + 8;

   } else if (value < 8080) {
      return value + 0;

   } else if (value < 8088) {
      return value + 8;

   }

   if (value < 8096) {
      return value + 0;

   } else if (value < 8104) {
      return value + 8;

   } else if (value < 8112) {
      return value + 0;

   } else if (value == 8114) {
      // special char
      return 0;

   } else if (value < 8115) {
      return value + 8;

   } else if (value == 8116) {
      // special char
      return 0;

   } else if (value < 8117) {
      return value + 9;

   } else if (value == 8118) {
      // special char
      return 0;

   } else if (value == 8119) {
      // special char
      return 0;

   } else if (value < 8126) {
      return value + 0;

   } else if (value < 8127) {
      return value + -7205;

   } else if (value == 8130) {
      // special char
      return 0;

   } else if (value < 8131) {
      return value + 0;

   } else if (value == 8132) {
      // special char
      return 0;

   } else if (value < 8133) {
      return value + 9;

   } else if (value == 8134) {
      // special char
      return 0;

   } else if (value == 8135) {
      // special char
      return 0;

   } else if (value < 8144) {
      return value + 0;

   } else if (value == 8146) {
      // special char
      return 0;

   } else if (value == 8147) {
      // special char
      return 0;

   } else if (value < 8148) {
      return value + 8;

   } else if (value == 8150) {
      // special char
      return 0;

   } else if (value == 8151) {
      // special char
      return 0;

   } else if (value < 8160) {
      return value + 0;

   } else if (value == 8162) {
      // special char
      return 0;

   } else if (value == 8163) {
      // special char
      return 0;

   } else if (value == 8164) {
      // special char
      return 0;

   } else if (value < 8165) {
      return value + 8;

   } else if (value == 8166) {
      // special char
      return 0;

   } else if (value == 8167) {
      // special char
      return 0;

   } else if (value < 8168) {
      return value + 7;

   } else if (value == 8178) {
      // special char
      return 0;

   } else if (value < 8179) {
      return value + 0;

   } else if (value == 8180) {
      // special char
      return 0;

   } else if (value < 8181) {
      return value + 9;

   } else if (value == 8182) {
      // special char
      return 0;

   } else if (value == 8183) {
      // special char
      return 0;

   } else if (value < 8526) {
      return value + 0;

   } else if (value < 8527) {
      return value + -28;

   } else if (value < 8560) {
      return value + 0;

   } else if (value < 8576) {
      return value + -16;

   } else if (value < 8580) {
      return value + 0;

   } else if (value < 8581) {
      return value + -1;

   } else if (value < 9424) {
      return value + 0;

   } else if (value < 9450) {
      return value + -26;

   } else if (value < 11312) {
      return value + 0;

   } else if (value < 11360) {
      return value + -48;

   } else if (value < 11361) {
      return value + 0;

   } else if (value < 11362) {
      return value + -1;

   } else if (value < 11365) {
      return value + 0;

   } else if (value < 11366) {
      return value + -10795;

   } else if (value < 11367) {
      return value + -10792;

   } else if (value < 11368) {
      return value + 0;

   } else if (value < 11369) {
      return value + -1;

   } else if (value < 11370) {
      return value + 0;

   } else if (value < 11371) {
      return value + -1;

   } else if (value < 11372) {
      return value + 0;

   } else if (value < 11373) {
      return value + -1;

   } else if (value < 11379) {
      return value + 0;

   } else if (value < 11380) {
      return value + -1;

   } else if (value < 11382) {
      return value + 0;

   } else if (value < 11383) {
      return value + -1;

   } else if (value < 11393) {
      return value + 0;

   } else if (value < 11394) {
      return value + -1;

   } else if (value < 11395) {
      return value + 0;

   } else if (value < 11396) {
      return value + -1;

   } else if (value < 11397) {
      return value + 0;

   } else if (value < 11398) {
      return value + -1;

   } else if (value < 11399) {
      return value + 0;

   } else if (value < 11400) {
      return value + -1;

   } else if (value < 11401) {
      return value + 0;

   } else if (value < 11402) {
      return value + -1;

   } else if (value < 11403) {
      return value + 0;

   } else if (value < 11404) {
      return value + -1;

   } else if (value < 11405) {
      return value + 0;

   } else if (value < 11406) {
      return value + -1;

   } else if (value < 11407) {
      return value + 0;

   } else if (value < 11408) {
      return value + -1;

   } else if (value < 11409) {
      return value + 0;

   } else if (value < 11410) {
      return value + -1;

   } else if (value < 11411) {
      return value + 0;

   } else if (value < 11412) {
      return value + -1;

   } else if (value < 11413) {
      return value + 0;

   } else if (value < 11414) {
      return value + -1;

   } else if (value < 11415) {
      return value + 0;

   } else if (value < 11416) {
      return value + -1;

   } else if (value < 11417) {
      return value + 0;

   } else if (value < 11418) {
      return value + -1;

   } else if (value < 11419) {
      return value + 0;

   } else if (value < 11420) {
      return value + -1;

   } else if (value < 11421) {
      return value + 0;

   } else if (value < 11422) {
      return value + -1;

   } else if (value < 11423) {
      return value + 0;

   } else if (value < 11424) {
      return value + -1;

   } else if (value < 11425) {
      return value + 0;

   } else if (value < 11426) {
      return value + -1;

   } else if (value < 11427) {
      return value + 0;

   } else if (value < 11428) {
      return value + -1;

   } else if (value < 11429) {
      return value + 0;

   } else if (value < 11430) {
      return value + -1;

   } else if (value < 11431) {
      return value + 0;

   } else if (value < 11432) {
      return value + -1;

   } else if (value < 11433) {
      return value + 0;

   } else if (value < 11434) {
      return value + -1;

   } else if (value < 11435) {
      return value + 0;

   } else if (value < 11436) {
      return value + -1;

   } else if (value < 11437) {
      return value + 0;

   } else if (value < 11438) {
      return value + -1;

   } else if (value < 11439) {
      return value + 0;

   } else if (value < 11440) {
      return value + -1;

   } else if (value < 11441) {
      return value + 0;

   } else if (value < 11442) {
      return value + -1;

   } else if (value < 11443) {
      return value + 0;

   } else if (value < 11444) {
      return value + -1;

   } else if (value < 11445) {
      return value + 0;

   } else if (value < 11446) {
      return value + -1;

   } else if (value < 11447) {
      return value + 0;

   } else if (value < 11448) {
      return value + -1;

   } else if (value < 11449) {
      return value + 0;

   } else if (value < 11450) {
      return value + -1;

   } else if (value < 11451) {
      return value + 0;

   }

   if (value < 11452) {
      return value + -1;

   } else if (value < 11453) {
      return value + 0;

   } else if (value < 11454) {
      return value + -1;

   } else if (value < 11455) {
      return value + 0;

   } else if (value < 11456) {
      return value + -1;

   } else if (value < 11457) {
      return value + 0;

   } else if (value < 11458) {
      return value + -1;

   } else if (value < 11459) {
      return value + 0;

   } else if (value < 11460) {
      return value + -1;

   } else if (value < 11461) {
      return value + 0;

   } else if (value < 11462) {
      return value + -1;

   } else if (value < 11463) {
      return value + 0;

   } else if (value < 11464) {
      return value + -1;

   } else if (value < 11465) {
      return value + 0;

   } else if (value < 11466) {
      return value + -1;

   } else if (value < 11467) {
      return value + 0;

   } else if (value < 11468) {
      return value + -1;

   } else if (value < 11469) {
      return value + 0;

   } else if (value < 11470) {
      return value + -1;

   } else if (value < 11471) {
      return value + 0;

   } else if (value < 11472) {
      return value + -1;

   } else if (value < 11473) {
      return value + 0;

   } else if (value < 11474) {
      return value + -1;

   } else if (value < 11475) {
      return value + 0;

   } else if (value < 11476) {
      return value + -1;

   } else if (value < 11477) {
      return value + 0;

   } else if (value < 11478) {
      return value + -1;

   } else if (value < 11479) {
      return value + 0;

   } else if (value < 11480) {
      return value + -1;

   } else if (value < 11481) {
      return value + 0;

   } else if (value < 11482) {
      return value + -1;

   } else if (value < 11483) {
      return value + 0;

   } else if (value < 11484) {
      return value + -1;

   } else if (value < 11485) {
      return value + 0;

   } else if (value < 11486) {
      return value + -1;

   } else if (value < 11487) {
      return value + 0;

   } else if (value < 11488) {
      return value + -1;

   } else if (value < 11489) {
      return value + 0;

   } else if (value < 11490) {
      return value + -1;

   } else if (value < 11491) {
      return value + 0;

   } else if (value < 11492) {
      return value + -1;

   } else if (value < 11500) {
      return value + 0;

   } else if (value < 11501) {
      return value + -1;

   } else if (value < 11502) {
      return value + 0;

   } else if (value < 11503) {
      return value + -1;

   } else if (value < 11507) {
      return value + 0;

   } else if (value < 11508) {
      return value + -1;

   } else if (value < 11520) {
      return value + 0;

   } else if (value < 11558) {
      return value + -7264;

   } else if (value < 11559) {
      return value + 0;

   } else if (value < 11560) {
      return value + -7264;

   } else if (value < 11565) {
      return value + 0;

   } else if (value < 11566) {
      return value + -7264;

   } else if (value < 42561) {
      return value + 0;

   } else if (value < 42562) {
      return value + -1;

   } else if (value < 42563) {
      return value + 0;

   } else if (value < 42564) {
      return value + -1;

   } else if (value < 42565) {
      return value + 0;

   } else if (value < 42566) {
      return value + -1;

   } else if (value < 42567) {
      return value + 0;

   } else if (value < 42568) {
      return value + -1;

   } else if (value < 42569) {
      return value + 0;

   } else if (value < 42570) {
      return value + -1;

   } else if (value < 42571) {
      return value + 0;

   } else if (value < 42572) {
      return value + -1;

   } else if (value < 42573) {
      return value + 0;

   } else if (value < 42574) {
      return value + -1;

   } else if (value < 42575) {
      return value + 0;

   } else if (value < 42576) {
      return value + -1;

   } else if (value < 42577) {
      return value + 0;

   } else if (value < 42578) {
      return value + -1;

   } else if (value < 42579) {
      return value + 0;

   } else if (value < 42580) {
      return value + -1;

   } else if (value < 42581) {
      return value + 0;

   } else if (value < 42582) {
      return value + -1;

   } else if (value < 42583) {
      return value + 0;

   } else if (value < 42584) {
      return value + -1;

   } else if (value < 42585) {
      return value + 0;

   } else if (value < 42586) {
      return value + -1;

   } else if (value < 42587) {
      return value + 0;

   } else if (value < 42588) {
      return value + -1;

   } else if (value < 42589) {
      return value + 0;

   } else if (value < 42590) {
      return value + -1;

   } else if (value < 42591) {
      return value + 0;

   } else if (value < 42592) {
      return value + -1;

   } else if (value < 42593) {
      return value + 0;

   } else if (value < 42594) {
      return value + -1;

   } else if (value < 42595) {
      return value + 0;

   } else if (value < 42596) {
      return value + -1;

   } else if (value < 42597) {
      return value + 0;

   } else if (value < 42598) {
      return value + -1;

   } else if (value < 42599) {
      return value + 0;

   } else if (value < 42600) {
      return value + -1;

   } else if (value < 42601) {
      return value + 0;

   } else if (value < 42602) {
      return value + -1;

   } else if (value < 42603) {
      return value + 0;

   } else if (value < 42604) {
      return value + -1;

   } else if (value < 42605) {
      return value + 0;

   } else if (value < 42606) {
      return value + -1;

   } else if (value < 42625) {
      return value + 0;

   }

   if (value < 42626) {
      return value + -1;

   } else if (value < 42627) {
      return value + 0;

   } else if (value < 42628) {
      return value + -1;

   } else if (value < 42629) {
      return value + 0;

   } else if (value < 42630) {
      return value + -1;

   } else if (value < 42631) {
      return value + 0;

   } else if (value < 42632) {
      return value + -1;

   } else if (value < 42633) {
      return value + 0;

   } else if (value < 42634) {
      return value + -1;

   } else if (value < 42635) {
      return value + 0;

   } else if (value < 42636) {
      return value + -1;

   } else if (value < 42637) {
      return value + 0;

   } else if (value < 42638) {
      return value + -1;

   } else if (value < 42639) {
      return value + 0;

   } else if (value < 42640) {
      return value + -1;

   } else if (value < 42641) {
      return value + 0;

   } else if (value < 42642) {
      return value + -1;

   } else if (value < 42643) {
      return value + 0;

   } else if (value < 42644) {
      return value + -1;

   } else if (value < 42645) {
      return value + 0;

   } else if (value < 42646) {
      return value + -1;

   } else if (value < 42647) {
      return value + 0;

   } else if (value < 42648) {
      return value + -1;

   } else if (value < 42649) {
      return value + 0;

   } else if (value < 42650) {
      return value + -1;

   } else if (value < 42651) {
      return value + 0;

   } else if (value < 42652) {
      return value + -1;

   } else if (value < 42787) {
      return value + 0;

   } else if (value < 42788) {
      return value + -1;

   } else if (value < 42789) {
      return value + 0;

   } else if (value < 42790) {
      return value + -1;

   } else if (value < 42791) {
      return value + 0;

   } else if (value < 42792) {
      return value + -1;

   } else if (value < 42793) {
      return value + 0;

   } else if (value < 42794) {
      return value + -1;

   } else if (value < 42795) {
      return value + 0;

   } else if (value < 42796) {
      return value + -1;

   } else if (value < 42797) {
      return value + 0;

   } else if (value < 42798) {
      return value + -1;

   } else if (value < 42799) {
      return value + 0;

   } else if (value < 42800) {
      return value + -1;

   } else if (value < 42803) {
      return value + 0;

   } else if (value < 42804) {
      return value + -1;

   } else if (value < 42805) {
      return value + 0;

   } else if (value < 42806) {
      return value + -1;

   } else if (value < 42807) {
      return value + 0;

   } else if (value < 42808) {
      return value + -1;

   } else if (value < 42809) {
      return value + 0;

   } else if (value < 42810) {
      return value + -1;

   } else if (value < 42811) {
      return value + 0;

   } else if (value < 42812) {
      return value + -1;

   } else if (value < 42813) {
      return value + 0;

   } else if (value < 42814) {
      return value + -1;

   } else if (value < 42815) {
      return value + 0;

   } else if (value < 42816) {
      return value + -1;

   } else if (value < 42817) {
      return value + 0;

   } else if (value < 42818) {
      return value + -1;

   } else if (value < 42819) {
      return value + 0;

   } else if (value < 42820) {
      return value + -1;

   } else if (value < 42821) {
      return value + 0;

   } else if (value < 42822) {
      return value + -1;

   } else if (value < 42823) {
      return value + 0;

   } else if (value < 42824) {
      return value + -1;

   } else if (value < 42825) {
      return value + 0;

   } else if (value < 42826) {
      return value + -1;

   } else if (value < 42827) {
      return value + 0;

   } else if (value < 42828) {
      return value + -1;

   } else if (value < 42829) {
      return value + 0;

   } else if (value < 42830) {
      return value + -1;

   } else if (value < 42831) {
      return value + 0;

   } else if (value < 42832) {
      return value + -1;

   } else if (value < 42833) {
      return value + 0;

   } else if (value < 42834) {
      return value + -1;

   } else if (value < 42835) {
      return value + 0;

   } else if (value < 42836) {
      return value + -1;

   } else if (value < 42837) {
      return value + 0;

   } else if (value < 42838) {
      return value + -1;

   } else if (value < 42839) {
      return value + 0;

   } else if (value < 42840) {
      return value + -1;

   } else if (value < 42841) {
      return value + 0;

   } else if (value < 42842) {
      return value + -1;

   } else if (value < 42843) {
      return value + 0;

   } else if (value < 42844) {
      return value + -1;

   } else if (value < 42845) {
      return value + 0;

   } else if (value < 42846) {
      return value + -1;

   } else if (value < 42847) {
      return value + 0;

   } else if (value < 42848) {
      return value + -1;

   } else if (value < 42849) {
      return value + 0;

   } else if (value < 42850) {
      return value + -1;

   } else if (value < 42851) {
      return value + 0;

   } else if (value < 42852) {
      return value + -1;

   } else if (value < 42853) {
      return value + 0;

   } else if (value < 42854) {
      return value + -1;

   } else if (value < 42855) {
      return value + 0;

   } else if (value < 42856) {
      return value + -1;

   } else if (value < 42857) {
      return value + 0;

   } else if (value < 42858) {
      return value + -1;

   } else if (value < 42859) {
      return value + 0;

   } else if (value < 42860) {
      return value + -1;

   } else if (value < 42861) {
      return value + 0;

   }

   if (value < 42862) {
      return value + -1;

   } else if (value < 42863) {
      return value + 0;

   } else if (value < 42864) {
      return value + -1;

   } else if (value < 42874) {
      return value + 0;

   } else if (value < 42875) {
      return value + -1;

   } else if (value < 42876) {
      return value + 0;

   } else if (value < 42877) {
      return value + -1;

   } else if (value < 42879) {
      return value + 0;

   } else if (value < 42880) {
      return value + -1;

   } else if (value < 42881) {
      return value + 0;

   } else if (value < 42882) {
      return value + -1;

   } else if (value < 42883) {
      return value + 0;

   } else if (value < 42884) {
      return value + -1;

   } else if (value < 42885) {
      return value + 0;

   } else if (value < 42886) {
      return value + -1;

   } else if (value < 42887) {
      return value + 0;

   } else if (value < 42888) {
      return value + -1;

   } else if (value < 42892) {
      return value + 0;

   } else if (value < 42893) {
      return value + -1;

   } else if (value < 42897) {
      return value + 0;

   } else if (value < 42898) {
      return value + -1;

   } else if (value < 42899) {
      return value + 0;

   } else if (value < 42900) {
      return value + -1;

   } else if (value < 42901) {
      return value + 48;

   } else if (value < 42903) {
      return value + 0;

   } else if (value < 42904) {
      return value + -1;

   } else if (value < 42905) {
      return value + 0;

   } else if (value < 42906) {
      return value + -1;

   } else if (value < 42907) {
      return value + 0;

   } else if (value < 42908) {
      return value + -1;

   } else if (value < 42909) {
      return value + 0;

   } else if (value < 42910) {
      return value + -1;

   } else if (value < 42911) {
      return value + 0;

   } else if (value < 42912) {
      return value + -1;

   } else if (value < 42913) {
      return value + 0;

   } else if (value < 42914) {
      return value + -1;

   } else if (value < 42915) {
      return value + 0;

   } else if (value < 42916) {
      return value + -1;

   } else if (value < 42917) {
      return value + 0;

   } else if (value < 42918) {
      return value + -1;

   } else if (value < 42919) {
      return value + 0;

   } else if (value < 42920) {
      return value + -1;

   } else if (value < 42921) {
      return value + 0;

   } else if (value < 42922) {
      return value + -1;

   } else if (value < 42933) {
      return value + 0;

   } else if (value < 42934) {
      return value + -1;

   } else if (value < 42935) {
      return value + 0;

   } else if (value < 42936) {
      return value + -1;

   } else if (value < 42937) {
      return value + 0;

   } else if (value < 42938) {
      return value + -1;

   } else if (value < 42939) {
      return value + 0;

   } else if (value < 42940) {
      return value + -1;

   } else if (value < 42941) {
      return value + 0;

   } else if (value < 42942) {
      return value + -1;

   } else if (value < 42943) {
      return value + 0;

   } else if (value < 42944) {
      return value + -1;

   } else if (value < 42945) {
      return value + 0;

   } else if (value < 42946) {
      return value + -1;

   } else if (value < 42947) {
      return value + 0;

   } else if (value < 42948) {
      return value + -1;

   } else if (value < 42952) {
      return value + 0;

   } else if (value < 42953) {
      return value + -1;

   } else if (value < 42954) {
      return value + 0;

   } else if (value < 42955) {
      return value + -1;

   } else if (value < 42961) {
      return value + 0;

   } else if (value < 42962) {
      return value + -1;

   } else if (value < 42967) {
      return value + 0;

   } else if (value < 42968) {
      return value + -1;

   } else if (value < 42969) {
      return value + 0;

   } else if (value < 42970) {
      return value + -1;

   } else if (value < 42998) {
      return value + 0;

   } else if (value < 42999) {
      return value + -1;

   } else if (value < 43859) {
      return value + 0;

   } else if (value < 43860) {
      return value + -928;

   } else if (value < 43888) {
      return value + 0;

   } else if (value < 43968) {
      return value + -38864;

   } else if (value == 64256) {
      // special char
      return 0;

   } else if (value == 64257) {
      // special char
      return 0;

   } else if (value == 64258) {
      // special char
      return 0;

   } else if (value == 64259) {
      // special char
      return 0;

   } else if (value == 64260) {
      // special char
      return 0;

   } else if (value == 64261) {
      // special char
      return 0;

   } else if (value == 64262) {
      // special char
      return 0;

   } else if (value == 64275) {
      // special char
      return 0;

   } else if (value == 64276) {
      // special char
      return 0;

   } else if (value == 64277) {
      // special char
      return 0;

   } else if (value == 64278) {
      // special char
      return 0;

   } else if (value == 64279) {
      // special char
      return 0;

   } else if (value < 65345) {
      return value + 0;

   } else if (value < 65371) {
      return value + -32;

   } else if (value < 66600) {
      return value + 0;

   } else if (value < 66640) {
      return value + -40;

   } else if (value < 66776) {
      return value + 0;

   } else if (value < 66812) {
      return value + -40;

   } else if (value < 66967) {
      return value + 0;

   } else if (value < 66978) {
      return value + -39;

   } else if (value < 66979) {
      return value + 0;

   } else if (value < 66994) {
      return value + -39;

   } else if (value < 66995) {
      return value + 0;

   } else if (value < 67002) {
      return value + -39;

   } else if (value < 67003) {
      return value + 0;

   } else if (value < 67005) {
      return value + -39;

   } else if (value < 68800) {
      return value + 0;

   } else if (value < 68851) {
      return value + -64;

   } else if (value < 71872) {
      return value + 0;

   } else if (value < 71904) {
      return value + -32;

   } else if (value < 93792) {
      return value + 0;

   } else if (value < 93824) {
      return value + -32;

   } else if (value < 125218) {
      return value + 0;

   } else if (value < 125252) {
      return value + -34;

   } else {
      return value;
   }
}

char32_t uc_upperCase(char32_t value)
{
    if (value < 97) {
      return value + 0;

   } else if (value < 123) {
      return value + -32;

   } else if (value < 181) {
      return value + 0;

   } else if (value < 182) {
      return value + 743;

   } else if (value == 223) {
      // special char
      return 0;

   } else if (value < 224) {
      return value + 0;

   } else if (value < 247) {
      return value + -32;

   } else if (value < 248) {
      return value + 0;

   } else if (value < 255) {
      return value + -32;

   } else if (value < 256) {
      return value + 121;

   } else if (value < 257) {
      return value + 0;

   } else if (value < 258) {
      return value + -1;

   } else if (value < 259) {
      return value + 0;

   } else if (value < 260) {
      return value + -1;

   } else if (value < 261) {
      return value + 0;

   } else if (value < 262) {
      return value + -1;

   } else if (value < 263) {
      return value + 0;

   } else if (value < 264) {
      return value + -1;

   } else if (value < 265) {
      return value + 0;

   } else if (value < 266) {
      return value + -1;

   } else if (value < 267) {
      return value + 0;

   } else if (value < 268) {
      return value + -1;

   } else if (value < 269) {
      return value + 0;

   } else if (value < 270) {
      return value + -1;

   } else if (value < 271) {
      return value + 0;

   } else if (value < 272) {
      return value + -1;

   } else if (value < 273) {
      return value + 0;

   } else if (value < 274) {
      return value + -1;

   } else if (value < 275) {
      return value + 0;

   } else if (value < 276) {
      return value + -1;

   } else if (value < 277) {
      return value + 0;

   } else if (value < 278) {
      return value + -1;

   } else if (value < 279) {
      return value + 0;

   } else if (value < 280) {
      return value + -1;

   } else if (value < 281) {
      return value + 0;

   } else if (value < 282) {
      return value + -1;

   } else if (value < 283) {
      return value + 0;

   } else if (value < 284) {
      return value + -1;

   } else if (value < 285) {
      return value + 0;

   } else if (value < 286) {
      return value + -1;

   } else if (value < 287) {
      return value + 0;

   } else if (value < 288) {
      return value + -1;

   } else if (value < 289) {
      return value + 0;

   } else if (value < 290) {
      return value + -1;

   } else if (value < 291) {
      return value + 0;

   } else if (value < 292) {
      return value + -1;

   } else if (value < 293) {
      return value + 0;

   } else if (value < 294) {
      return value + -1;

   } else if (value < 295) {
      return value + 0;

   } else if (value < 296) {
      return value + -1;

   } else if (value < 297) {
      return value + 0;

   } else if (value < 298) {
      return value + -1;

   } else if (value < 299) {
      return value + 0;

   } else if (value < 300) {
      return value + -1;

   } else if (value < 301) {
      return value + 0;

   } else if (value < 302) {
      return value + -1;

   } else if (value < 303) {
      return value + 0;

   } else if (value < 304) {
      return value + -1;

   } else if (value < 305) {
      return value + 0;

   } else if (value < 306) {
      return value + -232;

   } else if (value < 307) {
      return value + 0;

   } else if (value < 308) {
      return value + -1;

   } else if (value < 309) {
      return value + 0;

   } else if (value < 310) {
      return value + -1;

   } else if (value < 311) {
      return value + 0;

   } else if (value < 312) {
      return value + -1;

   } else if (value < 314) {
      return value + 0;

   } else if (value < 315) {
      return value + -1;

   } else if (value < 316) {
      return value + 0;

   } else if (value < 317) {
      return value + -1;

   } else if (value < 318) {
      return value + 0;

   } else if (value < 319) {
      return value + -1;

   } else if (value < 320) {
      return value + 0;

   } else if (value < 321) {
      return value + -1;

   } else if (value < 322) {
      return value + 0;

   } else if (value < 323) {
      return value + -1;

   } else if (value < 324) {
      return value + 0;

   } else if (value < 325) {
      return value + -1;

   } else if (value < 326) {
      return value + 0;

   } else if (value < 327) {
      return value + -1;

   } else if (value < 328) {
      return value + 0;

   } else if (value == 329) {
      // special char
      return 0;

   } else if (value < 330) {
      return value + -1;

   } else if (value < 331) {
      return value + 0;

   } else if (value < 332) {
      return value + -1;

   } else if (value < 333) {
      return value + 0;

   } else if (value < 334) {
      return value + -1;

   } else if (value < 335) {
      return value + 0;

   } else if (value < 336) {
      return value + -1;

   } else if (value < 337) {
      return value + 0;

   } else if (value < 338) {
      return value + -1;

   } else if (value < 339) {
      return value + 0;

   } else if (value < 340) {
      return value + -1;

   } else if (value < 341) {
      return value + 0;

   } else if (value < 342) {
      return value + -1;

   } else if (value < 343) {
      return value + 0;

   } else if (value < 344) {
      return value + -1;

   } else if (value < 345) {
      return value + 0;

   } else if (value < 346) {
      return value + -1;

   } else if (value < 347) {
      return value + 0;

   }

   if (value < 348) {
      return value + -1;

   } else if (value < 349) {
      return value + 0;

   } else if (value < 350) {
      return value + -1;

   } else if (value < 351) {
      return value + 0;

   } else if (value < 352) {
      return value + -1;

   } else if (value < 353) {
      return value + 0;

   } else if (value < 354) {
      return value + -1;

   } else if (value < 355) {
      return value + 0;

   } else if (value < 356) {
      return value + -1;

   } else if (value < 357) {
      return value + 0;

   } else if (value < 358) {
      return value + -1;

   } else if (value < 359) {
      return value + 0;

   } else if (value < 360) {
      return value + -1;

   } else if (value < 361) {
      return value + 0;

   } else if (value < 362) {
      return value + -1;

   } else if (value < 363) {
      return value + 0;

   } else if (value < 364) {
      return value + -1;

   } else if (value < 365) {
      return value + 0;

   } else if (value < 366) {
      return value + -1;

   } else if (value < 367) {
      return value + 0;

   } else if (value < 368) {
      return value + -1;

   } else if (value < 369) {
      return value + 0;

   } else if (value < 370) {
      return value + -1;

   } else if (value < 371) {
      return value + 0;

   } else if (value < 372) {
      return value + -1;

   } else if (value < 373) {
      return value + 0;

   } else if (value < 374) {
      return value + -1;

   } else if (value < 375) {
      return value + 0;

   } else if (value < 376) {
      return value + -1;

   } else if (value < 378) {
      return value + 0;

   } else if (value < 379) {
      return value + -1;

   } else if (value < 380) {
      return value + 0;

   } else if (value < 381) {
      return value + -1;

   } else if (value < 382) {
      return value + 0;

   } else if (value < 383) {
      return value + -1;

   } else if (value < 384) {
      return value + -300;

   } else if (value < 385) {
      return value + 195;

   } else if (value < 387) {
      return value + 0;

   } else if (value < 388) {
      return value + -1;

   } else if (value < 389) {
      return value + 0;

   } else if (value < 390) {
      return value + -1;

   } else if (value < 392) {
      return value + 0;

   } else if (value < 393) {
      return value + -1;

   } else if (value < 396) {
      return value + 0;

   } else if (value < 397) {
      return value + -1;

   } else if (value < 402) {
      return value + 0;

   } else if (value < 403) {
      return value + -1;

   } else if (value < 405) {
      return value + 0;

   } else if (value < 406) {
      return value + 97;

   } else if (value < 409) {
      return value + 0;

   } else if (value < 410) {
      return value + -1;

   } else if (value < 411) {
      return value + 163;

   } else if (value < 414) {
      return value + 0;

   } else if (value < 415) {
      return value + 130;

   } else if (value < 417) {
      return value + 0;

   } else if (value < 418) {
      return value + -1;

   } else if (value < 419) {
      return value + 0;

   } else if (value < 420) {
      return value + -1;

   } else if (value < 421) {
      return value + 0;

   } else if (value < 422) {
      return value + -1;

   } else if (value < 424) {
      return value + 0;

   } else if (value < 425) {
      return value + -1;

   } else if (value < 429) {
      return value + 0;

   } else if (value < 430) {
      return value + -1;

   } else if (value < 432) {
      return value + 0;

   } else if (value < 433) {
      return value + -1;

   } else if (value < 436) {
      return value + 0;

   } else if (value < 437) {
      return value + -1;

   } else if (value < 438) {
      return value + 0;

   } else if (value < 439) {
      return value + -1;

   } else if (value < 441) {
      return value + 0;

   } else if (value < 442) {
      return value + -1;

   } else if (value < 445) {
      return value + 0;

   } else if (value < 446) {
      return value + -1;

   } else if (value < 447) {
      return value + 0;

   } else if (value < 448) {
      return value + 56;

   } else if (value < 453) {
      return value + 0;

   } else if (value < 454) {
      return value + -1;

   } else if (value < 455) {
      return value + -2;

   } else if (value < 456) {
      return value + 0;

   } else if (value < 457) {
      return value + -1;

   } else if (value < 458) {
      return value + -2;

   } else if (value < 459) {
      return value + 0;

   } else if (value < 460) {
      return value + -1;

   } else if (value < 461) {
      return value + -2;

   } else if (value < 462) {
      return value + 0;

   } else if (value < 463) {
      return value + -1;

   } else if (value < 464) {
      return value + 0;

   } else if (value < 465) {
      return value + -1;

   } else if (value < 466) {
      return value + 0;

   } else if (value < 467) {
      return value + -1;

   } else if (value < 468) {
      return value + 0;

   } else if (value < 469) {
      return value + -1;

   } else if (value < 470) {
      return value + 0;

   } else if (value < 471) {
      return value + -1;

   } else if (value < 472) {
      return value + 0;

   } else if (value < 473) {
      return value + -1;

   } else if (value < 474) {
      return value + 0;

   } else if (value < 475) {
      return value + -1;

   } else if (value < 476) {
      return value + 0;

   }

   if (value < 477) {
      return value + -1;

   } else if (value < 478) {
      return value + -79;

   } else if (value < 479) {
      return value + 0;

   } else if (value < 480) {
      return value + -1;

   } else if (value < 481) {
      return value + 0;

   } else if (value < 482) {
      return value + -1;

   } else if (value < 483) {
      return value + 0;

   } else if (value < 484) {
      return value + -1;

   } else if (value < 485) {
      return value + 0;

   } else if (value < 486) {
      return value + -1;

   } else if (value < 487) {
      return value + 0;

   } else if (value < 488) {
      return value + -1;

   } else if (value < 489) {
      return value + 0;

   } else if (value < 490) {
      return value + -1;

   } else if (value < 491) {
      return value + 0;

   } else if (value < 492) {
      return value + -1;

   } else if (value < 493) {
      return value + 0;

   } else if (value < 494) {
      return value + -1;

   } else if (value < 495) {
      return value + 0;

   } else if (value == 496) {
      // special char
      return 0;

   } else if (value < 497) {
      return value + -1;

   } else if (value < 498) {
      return value + 0;

   } else if (value < 499) {
      return value + -1;

   } else if (value < 500) {
      return value + -2;

   } else if (value < 501) {
      return value + 0;

   } else if (value < 502) {
      return value + -1;

   } else if (value < 505) {
      return value + 0;

   } else if (value < 506) {
      return value + -1;

   } else if (value < 507) {
      return value + 0;

   } else if (value < 508) {
      return value + -1;

   } else if (value < 509) {
      return value + 0;

   } else if (value < 510) {
      return value + -1;

   } else if (value < 511) {
      return value + 0;

   } else if (value < 512) {
      return value + -1;

   } else if (value < 513) {
      return value + 0;

   } else if (value < 514) {
      return value + -1;

   } else if (value < 515) {
      return value + 0;

   } else if (value < 516) {
      return value + -1;

   } else if (value < 517) {
      return value + 0;

   } else if (value < 518) {
      return value + -1;

   } else if (value < 519) {
      return value + 0;

   } else if (value < 520) {
      return value + -1;

   } else if (value < 521) {
      return value + 0;

   } else if (value < 522) {
      return value + -1;

   } else if (value < 523) {
      return value + 0;

   } else if (value < 524) {
      return value + -1;

   } else if (value < 525) {
      return value + 0;

   } else if (value < 526) {
      return value + -1;

   } else if (value < 527) {
      return value + 0;

   } else if (value < 528) {
      return value + -1;

   } else if (value < 529) {
      return value + 0;

   } else if (value < 530) {
      return value + -1;

   } else if (value < 531) {
      return value + 0;

   } else if (value < 532) {
      return value + -1;

   } else if (value < 533) {
      return value + 0;

   } else if (value < 534) {
      return value + -1;

   } else if (value < 535) {
      return value + 0;

   } else if (value < 536) {
      return value + -1;

   } else if (value < 537) {
      return value + 0;

   } else if (value < 538) {
      return value + -1;

   } else if (value < 539) {
      return value + 0;

   } else if (value < 540) {
      return value + -1;

   } else if (value < 541) {
      return value + 0;

   } else if (value < 542) {
      return value + -1;

   } else if (value < 543) {
      return value + 0;

   } else if (value < 544) {
      return value + -1;

   } else if (value < 547) {
      return value + 0;

   } else if (value < 548) {
      return value + -1;

   } else if (value < 549) {
      return value + 0;

   } else if (value < 550) {
      return value + -1;

   } else if (value < 551) {
      return value + 0;

   } else if (value < 552) {
      return value + -1;

   } else if (value < 553) {
      return value + 0;

   } else if (value < 554) {
      return value + -1;

   } else if (value < 555) {
      return value + 0;

   } else if (value < 556) {
      return value + -1;

   } else if (value < 557) {
      return value + 0;

   } else if (value < 558) {
      return value + -1;

   } else if (value < 559) {
      return value + 0;

   } else if (value < 560) {
      return value + -1;

   } else if (value < 561) {
      return value + 0;

   } else if (value < 562) {
      return value + -1;

   } else if (value < 563) {
      return value + 0;

   } else if (value < 564) {
      return value + -1;

   } else if (value < 572) {
      return value + 0;

   } else if (value < 573) {
      return value + -1;

   } else if (value < 575) {
      return value + 0;

   } else if (value < 577) {
      return value + 10815;

   } else if (value < 578) {
      return value + 0;

   } else if (value < 579) {
      return value + -1;

   } else if (value < 583) {
      return value + 0;

   } else if (value < 584) {
      return value + -1;

   } else if (value < 585) {
      return value + 0;

   } else if (value < 586) {
      return value + -1;

   } else if (value < 587) {
      return value + 0;

   } else if (value < 588) {
      return value + -1;

   } else if (value < 589) {
      return value + 0;

   } else if (value < 590) {
      return value + -1;

   } else if (value < 591) {
      return value + 0;

   } else if (value < 592) {
      return value + -1;

   }

   if (value < 593) {
      return value + 10783;

   } else if (value < 594) {
      return value + 10780;

   } else if (value < 595) {
      return value + 10782;

   } else if (value < 596) {
      return value + -210;

   } else if (value < 597) {
      return value + -206;

   } else if (value < 598) {
      return value + 0;

   } else if (value < 600) {
      return value + -205;

   } else if (value < 601) {
      return value + 0;

   } else if (value < 602) {
      return value + -202;

   } else if (value < 603) {
      return value + 0;

   } else if (value < 604) {
      return value + -203;

   } else if (value < 605) {
      return value + 42319;

   } else if (value < 608) {
      return value + 0;

   } else if (value < 609) {
      return value + -205;

   } else if (value < 610) {
      return value + 42315;

   } else if (value < 611) {
      return value + 0;

   } else if (value < 612) {
      return value + -207;

   } else if (value < 613) {
      return value + 0;

   } else if (value < 614) {
      return value + 42280;

   } else if (value < 615) {
      return value + 42308;

   } else if (value < 616) {
      return value + 0;

   } else if (value < 617) {
      return value + -209;

   } else if (value < 618) {
      return value + -211;

   } else if (value < 619) {
      return value + 42308;

   } else if (value < 620) {
      return value + 10743;

   } else if (value < 621) {
      return value + 42305;

   } else if (value < 623) {
      return value + 0;

   } else if (value < 624) {
      return value + -211;

   } else if (value < 625) {
      return value + 0;

   } else if (value < 626) {
      return value + 10749;

   } else if (value < 627) {
      return value + -213;

   } else if (value < 629) {
      return value + 0;

   } else if (value < 630) {
      return value + -214;

   } else if (value < 637) {
      return value + 0;

   } else if (value < 638) {
      return value + 10727;

   } else if (value < 640) {
      return value + 0;

   } else if (value < 641) {
      return value + -218;

   } else if (value < 642) {
      return value + 0;

   } else if (value < 643) {
      return value + 42307;

   } else if (value < 644) {
      return value + -218;

   } else if (value < 647) {
      return value + 0;

   } else if (value < 648) {
      return value + 42282;

   } else if (value < 649) {
      return value + -218;

   } else if (value < 650) {
      return value + -69;

   } else if (value < 652) {
      return value + -217;

   } else if (value < 653) {
      return value + -71;

   } else if (value < 658) {
      return value + 0;

   } else if (value < 659) {
      return value + -219;

   } else if (value < 669) {
      return value + 0;

   } else if (value < 670) {
      return value + 42261;

   } else if (value < 671) {
      return value + 42258;

   } else if (value < 837) {
      return value + 0;

   } else if (value < 838) {
      return value + 84;

   } else if (value < 881) {
      return value + 0;

   } else if (value < 882) {
      return value + -1;

   } else if (value < 883) {
      return value + 0;

   } else if (value < 884) {
      return value + -1;

   } else if (value < 887) {
      return value + 0;

   } else if (value < 888) {
      return value + -1;

   } else if (value < 891) {
      return value + 0;

   } else if (value < 894) {
      return value + 130;

   } else if (value == 912) {
      // special char
      return 0;

   } else if (value < 940) {
      return value + 0;

   } else if (value < 941) {
      return value + -38;

   } else if (value == 944) {
      // special char
      return 0;

   } else if (value < 945) {
      return value + -37;

   } else if (value < 962) {
      return value + -32;

   } else if (value < 963) {
      return value + -31;

   } else if (value < 972) {
      return value + -32;

   } else if (value < 973) {
      return value + -64;

   } else if (value < 975) {
      return value + -63;

   } else if (value < 976) {
      return value + 0;

   } else if (value < 977) {
      return value + -62;

   } else if (value < 978) {
      return value + -57;

   } else if (value < 981) {
      return value + 0;

   } else if (value < 982) {
      return value + -47;

   } else if (value < 983) {
      return value + -54;

   } else if (value < 984) {
      return value + -8;

   } else if (value < 985) {
      return value + 0;

   } else if (value < 986) {
      return value + -1;

   } else if (value < 987) {
      return value + 0;

   } else if (value < 988) {
      return value + -1;

   } else if (value < 989) {
      return value + 0;

   } else if (value < 990) {
      return value + -1;

   } else if (value < 991) {
      return value + 0;

   } else if (value < 992) {
      return value + -1;

   } else if (value < 993) {
      return value + 0;

   } else if (value < 994) {
      return value + -1;

   } else if (value < 995) {
      return value + 0;

   } else if (value < 996) {
      return value + -1;

   } else if (value < 997) {
      return value + 0;

   } else if (value < 998) {
      return value + -1;

   } else if (value < 999) {
      return value + 0;

   } else if (value < 1000) {
      return value + -1;

   } else if (value < 1001) {
      return value + 0;

   } else if (value < 1002) {
      return value + -1;

   } else if (value < 1003) {
      return value + 0;

   } else if (value < 1004) {
      return value + -1;

   } else if (value < 1005) {
      return value + 0;

   } else if (value < 1006) {
      return value + -1;

   }

   if (value < 1007) {
      return value + 0;

   } else if (value < 1008) {
      return value + -1;

   } else if (value < 1009) {
      return value + -86;

   } else if (value < 1010) {
      return value + -80;

   } else if (value < 1011) {
      return value + 7;

   } else if (value < 1012) {
      return value + -116;

   } else if (value < 1013) {
      return value + 0;

   } else if (value < 1014) {
      return value + -96;

   } else if (value < 1016) {
      return value + 0;

   } else if (value < 1017) {
      return value + -1;

   } else if (value < 1019) {
      return value + 0;

   } else if (value < 1020) {
      return value + -1;

   } else if (value < 1072) {
      return value + 0;

   } else if (value < 1104) {
      return value + -32;

   } else if (value < 1120) {
      return value + -80;

   } else if (value < 1121) {
      return value + 0;

   } else if (value < 1122) {
      return value + -1;

   } else if (value < 1123) {
      return value + 0;

   } else if (value < 1124) {
      return value + -1;

   } else if (value < 1125) {
      return value + 0;

   } else if (value < 1126) {
      return value + -1;

   } else if (value < 1127) {
      return value + 0;

   } else if (value < 1128) {
      return value + -1;

   } else if (value < 1129) {
      return value + 0;

   } else if (value < 1130) {
      return value + -1;

   } else if (value < 1131) {
      return value + 0;

   } else if (value < 1132) {
      return value + -1;

   } else if (value < 1133) {
      return value + 0;

   } else if (value < 1134) {
      return value + -1;

   } else if (value < 1135) {
      return value + 0;

   } else if (value < 1136) {
      return value + -1;

   } else if (value < 1137) {
      return value + 0;

   } else if (value < 1138) {
      return value + -1;

   } else if (value < 1139) {
      return value + 0;

   } else if (value < 1140) {
      return value + -1;

   } else if (value < 1141) {
      return value + 0;

   } else if (value < 1142) {
      return value + -1;

   } else if (value < 1143) {
      return value + 0;

   } else if (value < 1144) {
      return value + -1;

   } else if (value < 1145) {
      return value + 0;

   } else if (value < 1146) {
      return value + -1;

   } else if (value < 1147) {
      return value + 0;

   } else if (value < 1148) {
      return value + -1;

   } else if (value < 1149) {
      return value + 0;

   } else if (value < 1150) {
      return value + -1;

   } else if (value < 1151) {
      return value + 0;

   } else if (value < 1152) {
      return value + -1;

   } else if (value < 1153) {
      return value + 0;

   } else if (value < 1154) {
      return value + -1;

   } else if (value < 1163) {
      return value + 0;

   } else if (value < 1164) {
      return value + -1;

   } else if (value < 1165) {
      return value + 0;

   } else if (value < 1166) {
      return value + -1;

   } else if (value < 1167) {
      return value + 0;

   } else if (value < 1168) {
      return value + -1;

   } else if (value < 1169) {
      return value + 0;

   } else if (value < 1170) {
      return value + -1;

   } else if (value < 1171) {
      return value + 0;

   } else if (value < 1172) {
      return value + -1;

   } else if (value < 1173) {
      return value + 0;

   } else if (value < 1174) {
      return value + -1;

   } else if (value < 1175) {
      return value + 0;

   } else if (value < 1176) {
      return value + -1;

   } else if (value < 1177) {
      return value + 0;

   } else if (value < 1178) {
      return value + -1;

   } else if (value < 1179) {
      return value + 0;

   } else if (value < 1180) {
      return value + -1;

   } else if (value < 1181) {
      return value + 0;

   } else if (value < 1182) {
      return value + -1;

   } else if (value < 1183) {
      return value + 0;

   } else if (value < 1184) {
      return value + -1;

   } else if (value < 1185) {
      return value + 0;

   } else if (value < 1186) {
      return value + -1;

   } else if (value < 1187) {
      return value + 0;

   } else if (value < 1188) {
      return value + -1;

   } else if (value < 1189) {
      return value + 0;

   } else if (value < 1190) {
      return value + -1;

   } else if (value < 1191) {
      return value + 0;

   } else if (value < 1192) {
      return value + -1;

   } else if (value < 1193) {
      return value + 0;

   } else if (value < 1194) {
      return value + -1;

   } else if (value < 1195) {
      return value + 0;

   } else if (value < 1196) {
      return value + -1;

   } else if (value < 1197) {
      return value + 0;

   } else if (value < 1198) {
      return value + -1;

   } else if (value < 1199) {
      return value + 0;

   } else if (value < 1200) {
      return value + -1;

   } else if (value < 1201) {
      return value + 0;

   } else if (value < 1202) {
      return value + -1;

   } else if (value < 1203) {
      return value + 0;

   } else if (value < 1204) {
      return value + -1;

   } else if (value < 1205) {
      return value + 0;

   } else if (value < 1206) {
      return value + -1;

   } else if (value < 1207) {
      return value + 0;

   } else if (value < 1208) {
      return value + -1;

   } else if (value < 1209) {
      return value + 0;

   } else if (value < 1210) {
      return value + -1;

   } else if (value < 1211) {
      return value + 0;

   } else if (value < 1212) {
      return value + -1;

   } else if (value < 1213) {
      return value + 0;

   }

   if (value < 1214) {
      return value + -1;

   } else if (value < 1215) {
      return value + 0;

   } else if (value < 1216) {
      return value + -1;

   } else if (value < 1218) {
      return value + 0;

   } else if (value < 1219) {
      return value + -1;

   } else if (value < 1220) {
      return value + 0;

   } else if (value < 1221) {
      return value + -1;

   } else if (value < 1222) {
      return value + 0;

   } else if (value < 1223) {
      return value + -1;

   } else if (value < 1224) {
      return value + 0;

   } else if (value < 1225) {
      return value + -1;

   } else if (value < 1226) {
      return value + 0;

   } else if (value < 1227) {
      return value + -1;

   } else if (value < 1228) {
      return value + 0;

   } else if (value < 1229) {
      return value + -1;

   } else if (value < 1230) {
      return value + 0;

   } else if (value < 1231) {
      return value + -1;

   } else if (value < 1232) {
      return value + -15;

   } else if (value < 1233) {
      return value + 0;

   } else if (value < 1234) {
      return value + -1;

   } else if (value < 1235) {
      return value + 0;

   } else if (value < 1236) {
      return value + -1;

   } else if (value < 1237) {
      return value + 0;

   } else if (value < 1238) {
      return value + -1;

   } else if (value < 1239) {
      return value + 0;

   } else if (value < 1240) {
      return value + -1;

   } else if (value < 1241) {
      return value + 0;

   } else if (value < 1242) {
      return value + -1;

   } else if (value < 1243) {
      return value + 0;

   } else if (value < 1244) {
      return value + -1;

   } else if (value < 1245) {
      return value + 0;

   } else if (value < 1246) {
      return value + -1;

   } else if (value < 1247) {
      return value + 0;

   } else if (value < 1248) {
      return value + -1;

   } else if (value < 1249) {
      return value + 0;

   } else if (value < 1250) {
      return value + -1;

   } else if (value < 1251) {
      return value + 0;

   } else if (value < 1252) {
      return value + -1;

   } else if (value < 1253) {
      return value + 0;

   } else if (value < 1254) {
      return value + -1;

   } else if (value < 1255) {
      return value + 0;

   } else if (value < 1256) {
      return value + -1;

   } else if (value < 1257) {
      return value + 0;

   } else if (value < 1258) {
      return value + -1;

   } else if (value < 1259) {
      return value + 0;

   } else if (value < 1260) {
      return value + -1;

   } else if (value < 1261) {
      return value + 0;

   } else if (value < 1262) {
      return value + -1;

   } else if (value < 1263) {
      return value + 0;

   } else if (value < 1264) {
      return value + -1;

   } else if (value < 1265) {
      return value + 0;

   } else if (value < 1266) {
      return value + -1;

   } else if (value < 1267) {
      return value + 0;

   } else if (value < 1268) {
      return value + -1;

   } else if (value < 1269) {
      return value + 0;

   } else if (value < 1270) {
      return value + -1;

   } else if (value < 1271) {
      return value + 0;

   } else if (value < 1272) {
      return value + -1;

   } else if (value < 1273) {
      return value + 0;

   } else if (value < 1274) {
      return value + -1;

   } else if (value < 1275) {
      return value + 0;

   } else if (value < 1276) {
      return value + -1;

   } else if (value < 1277) {
      return value + 0;

   } else if (value < 1278) {
      return value + -1;

   } else if (value < 1279) {
      return value + 0;

   } else if (value < 1280) {
      return value + -1;

   } else if (value < 1281) {
      return value + 0;

   } else if (value < 1282) {
      return value + -1;

   } else if (value < 1283) {
      return value + 0;

   } else if (value < 1284) {
      return value + -1;

   } else if (value < 1285) {
      return value + 0;

   } else if (value < 1286) {
      return value + -1;

   } else if (value < 1287) {
      return value + 0;

   } else if (value < 1288) {
      return value + -1;

   } else if (value < 1289) {
      return value + 0;

   } else if (value < 1290) {
      return value + -1;

   } else if (value < 1291) {
      return value + 0;

   } else if (value < 1292) {
      return value + -1;

   } else if (value < 1293) {
      return value + 0;

   } else if (value < 1294) {
      return value + -1;

   } else if (value < 1295) {
      return value + 0;

   } else if (value < 1296) {
      return value + -1;

   } else if (value < 1297) {
      return value + 0;

   } else if (value < 1298) {
      return value + -1;

   } else if (value < 1299) {
      return value + 0;

   } else if (value < 1300) {
      return value + -1;

   } else if (value < 1301) {
      return value + 0;

   } else if (value < 1302) {
      return value + -1;

   } else if (value < 1303) {
      return value + 0;

   } else if (value < 1304) {
      return value + -1;

   } else if (value < 1305) {
      return value + 0;

   } else if (value < 1306) {
      return value + -1;

   } else if (value < 1307) {
      return value + 0;

   } else if (value < 1308) {
      return value + -1;

   } else if (value < 1309) {
      return value + 0;

   } else if (value < 1310) {
      return value + -1;

   } else if (value < 1311) {
      return value + 0;

   } else if (value < 1312) {
      return value + -1;

   } else if (value < 1313) {
      return value + 0;

   } else if (value < 1314) {
      return value + -1;

   }

   if (value < 1315) {
      return value + 0;

   } else if (value < 1316) {
      return value + -1;

   } else if (value < 1317) {
      return value + 0;

   } else if (value < 1318) {
      return value + -1;

   } else if (value < 1319) {
      return value + 0;

   } else if (value < 1320) {
      return value + -1;

   } else if (value < 1321) {
      return value + 0;

   } else if (value < 1322) {
      return value + -1;

   } else if (value < 1323) {
      return value + 0;

   } else if (value < 1324) {
      return value + -1;

   } else if (value < 1325) {
      return value + 0;

   } else if (value < 1326) {
      return value + -1;

   } else if (value < 1327) {
      return value + 0;

   } else if (value < 1328) {
      return value + -1;

   } else if (value < 1377) {
      return value + 0;

   } else if (value == 1415) {
      // special char
      return 0;

   } else if (value < 1416) {
      return value + -48;

   } else if (value < 4304) {
      return value + 0;

   } else if (value < 4347) {
      return value + 3008;

   } else if (value < 4349) {
      return value + 0;

   } else if (value < 4352) {
      return value + 3008;

   } else if (value < 5112) {
      return value + 0;

   } else if (value < 5118) {
      return value + -8;

   } else if (value < 7296) {
      return value + 0;

   } else if (value < 7297) {
      return value + -6254;

   } else if (value < 7298) {
      return value + -6253;

   } else if (value < 7299) {
      return value + -6244;

   } else if (value < 7301) {
      return value + -6242;

   } else if (value < 7302) {
      return value + -6243;

   } else if (value < 7303) {
      return value + -6236;

   } else if (value < 7304) {
      return value + -6181;

   } else if (value < 7305) {
      return value + 35266;

   } else if (value < 7545) {
      return value + 0;

   } else if (value < 7546) {
      return value + 35332;

   } else if (value < 7549) {
      return value + 0;

   } else if (value < 7550) {
      return value + 3814;

   } else if (value < 7566) {
      return value + 0;

   } else if (value < 7567) {
      return value + 35384;

   } else if (value < 7681) {
      return value + 0;

   } else if (value < 7682) {
      return value + -1;

   } else if (value < 7683) {
      return value + 0;

   } else if (value < 7684) {
      return value + -1;

   } else if (value < 7685) {
      return value + 0;

   } else if (value < 7686) {
      return value + -1;

   } else if (value < 7687) {
      return value + 0;

   } else if (value < 7688) {
      return value + -1;

   } else if (value < 7689) {
      return value + 0;

   } else if (value < 7690) {
      return value + -1;

   } else if (value < 7691) {
      return value + 0;

   } else if (value < 7692) {
      return value + -1;

   } else if (value < 7693) {
      return value + 0;

   } else if (value < 7694) {
      return value + -1;

   } else if (value < 7695) {
      return value + 0;

   } else if (value < 7696) {
      return value + -1;

   } else if (value < 7697) {
      return value + 0;

   } else if (value < 7698) {
      return value + -1;

   } else if (value < 7699) {
      return value + 0;

   } else if (value < 7700) {
      return value + -1;

   } else if (value < 7701) {
      return value + 0;

   } else if (value < 7702) {
      return value + -1;

   } else if (value < 7703) {
      return value + 0;

   } else if (value < 7704) {
      return value + -1;

   } else if (value < 7705) {
      return value + 0;

   } else if (value < 7706) {
      return value + -1;

   } else if (value < 7707) {
      return value + 0;

   } else if (value < 7708) {
      return value + -1;

   } else if (value < 7709) {
      return value + 0;

   } else if (value < 7710) {
      return value + -1;

   } else if (value < 7711) {
      return value + 0;

   } else if (value < 7712) {
      return value + -1;

   } else if (value < 7713) {
      return value + 0;

   } else if (value < 7714) {
      return value + -1;

   } else if (value < 7715) {
      return value + 0;

   } else if (value < 7716) {
      return value + -1;

   } else if (value < 7717) {
      return value + 0;

   } else if (value < 7718) {
      return value + -1;

   } else if (value < 7719) {
      return value + 0;

   } else if (value < 7720) {
      return value + -1;

   } else if (value < 7721) {
      return value + 0;

   } else if (value < 7722) {
      return value + -1;

   } else if (value < 7723) {
      return value + 0;

   } else if (value < 7724) {
      return value + -1;

   } else if (value < 7725) {
      return value + 0;

   } else if (value < 7726) {
      return value + -1;

   } else if (value < 7727) {
      return value + 0;

   } else if (value < 7728) {
      return value + -1;

   } else if (value < 7729) {
      return value + 0;

   } else if (value < 7730) {
      return value + -1;

   } else if (value < 7731) {
      return value + 0;

   } else if (value < 7732) {
      return value + -1;

   } else if (value < 7733) {
      return value + 0;

   } else if (value < 7734) {
      return value + -1;

   } else if (value < 7735) {
      return value + 0;

   } else if (value < 7736) {
      return value + -1;

   } else if (value < 7737) {
      return value + 0;

   } else if (value < 7738) {
      return value + -1;

   } else if (value < 7739) {
      return value + 0;

   } else if (value < 7740) {
      return value + -1;

   } else if (value < 7741) {
      return value + 0;

   } else if (value < 7742) {
      return value + -1;

   }

   if (value < 7743) {
      return value + 0;

   } else if (value < 7744) {
      return value + -1;

   } else if (value < 7745) {
      return value + 0;

   } else if (value < 7746) {
      return value + -1;

   } else if (value < 7747) {
      return value + 0;

   } else if (value < 7748) {
      return value + -1;

   } else if (value < 7749) {
      return value + 0;

   } else if (value < 7750) {
      return value + -1;

   } else if (value < 7751) {
      return value + 0;

   } else if (value < 7752) {
      return value + -1;

   } else if (value < 7753) {
      return value + 0;

   } else if (value < 7754) {
      return value + -1;

   } else if (value < 7755) {
      return value + 0;

   } else if (value < 7756) {
      return value + -1;

   } else if (value < 7757) {
      return value + 0;

   } else if (value < 7758) {
      return value + -1;

   } else if (value < 7759) {
      return value + 0;

   } else if (value < 7760) {
      return value + -1;

   } else if (value < 7761) {
      return value + 0;

   } else if (value < 7762) {
      return value + -1;

   } else if (value < 7763) {
      return value + 0;

   } else if (value < 7764) {
      return value + -1;

   } else if (value < 7765) {
      return value + 0;

   } else if (value < 7766) {
      return value + -1;

   } else if (value < 7767) {
      return value + 0;

   } else if (value < 7768) {
      return value + -1;

   } else if (value < 7769) {
      return value + 0;

   } else if (value < 7770) {
      return value + -1;

   } else if (value < 7771) {
      return value + 0;

   } else if (value < 7772) {
      return value + -1;

   } else if (value < 7773) {
      return value + 0;

   } else if (value < 7774) {
      return value + -1;

   } else if (value < 7775) {
      return value + 0;

   } else if (value < 7776) {
      return value + -1;

   } else if (value < 7777) {
      return value + 0;

   } else if (value < 7778) {
      return value + -1;

   } else if (value < 7779) {
      return value + 0;

   } else if (value < 7780) {
      return value + -1;

   } else if (value < 7781) {
      return value + 0;

   } else if (value < 7782) {
      return value + -1;

   } else if (value < 7783) {
      return value + 0;

   } else if (value < 7784) {
      return value + -1;

   } else if (value < 7785) {
      return value + 0;

   } else if (value < 7786) {
      return value + -1;

   } else if (value < 7787) {
      return value + 0;

   } else if (value < 7788) {
      return value + -1;

   } else if (value < 7789) {
      return value + 0;

   } else if (value < 7790) {
      return value + -1;

   } else if (value < 7791) {
      return value + 0;

   } else if (value < 7792) {
      return value + -1;

   } else if (value < 7793) {
      return value + 0;

   } else if (value < 7794) {
      return value + -1;

   } else if (value < 7795) {
      return value + 0;

   } else if (value < 7796) {
      return value + -1;

   } else if (value < 7797) {
      return value + 0;

   } else if (value < 7798) {
      return value + -1;

   } else if (value < 7799) {
      return value + 0;

   } else if (value < 7800) {
      return value + -1;

   } else if (value < 7801) {
      return value + 0;

   } else if (value < 7802) {
      return value + -1;

   } else if (value < 7803) {
      return value + 0;

   } else if (value < 7804) {
      return value + -1;

   } else if (value < 7805) {
      return value + 0;

   } else if (value < 7806) {
      return value + -1;

   } else if (value < 7807) {
      return value + 0;

   } else if (value < 7808) {
      return value + -1;

   } else if (value < 7809) {
      return value + 0;

   } else if (value < 7810) {
      return value + -1;

   } else if (value < 7811) {
      return value + 0;

   } else if (value < 7812) {
      return value + -1;

   } else if (value < 7813) {
      return value + 0;

   } else if (value < 7814) {
      return value + -1;

   } else if (value < 7815) {
      return value + 0;

   } else if (value < 7816) {
      return value + -1;

   } else if (value < 7817) {
      return value + 0;

   } else if (value < 7818) {
      return value + -1;

   } else if (value < 7819) {
      return value + 0;

   } else if (value < 7820) {
      return value + -1;

   } else if (value < 7821) {
      return value + 0;

   } else if (value < 7822) {
      return value + -1;

   } else if (value < 7823) {
      return value + 0;

   } else if (value < 7824) {
      return value + -1;

   } else if (value < 7825) {
      return value + 0;

   } else if (value < 7826) {
      return value + -1;

   } else if (value < 7827) {
      return value + 0;

   } else if (value < 7828) {
      return value + -1;

   } else if (value < 7829) {
      return value + 0;

   } else if (value == 7830) {
      // special char
      return 0;

   } else if (value == 7831) {
      // special char
      return 0;

   } else if (value == 7832) {
      // special char
      return 0;

   } else if (value == 7833) {
      // special char
      return 0;

   } else if (value == 7834) {
      // special char
      return 0;

   } else if (value < 7835) {
      return value + -1;

   } else if (value < 7836) {
      return value + -59;

   } else if (value < 7841) {
      return value + 0;

   } else if (value < 7842) {
      return value + -1;

   } else if (value < 7843) {
      return value + 0;

   } else if (value < 7844) {
      return value + -1;

   } else if (value < 7845) {
      return value + 0;

   } else if (value < 7846) {
      return value + -1;

   }

   if (value < 7847) {
      return value + 0;

   } else if (value < 7848) {
      return value + -1;

   } else if (value < 7849) {
      return value + 0;

   } else if (value < 7850) {
      return value + -1;

   } else if (value < 7851) {
      return value + 0;

   } else if (value < 7852) {
      return value + -1;

   } else if (value < 7853) {
      return value + 0;

   } else if (value < 7854) {
      return value + -1;

   } else if (value < 7855) {
      return value + 0;

   } else if (value < 7856) {
      return value + -1;

   } else if (value < 7857) {
      return value + 0;

   } else if (value < 7858) {
      return value + -1;

   } else if (value < 7859) {
      return value + 0;

   } else if (value < 7860) {
      return value + -1;

   } else if (value < 7861) {
      return value + 0;

   } else if (value < 7862) {
      return value + -1;

   } else if (value < 7863) {
      return value + 0;

   } else if (value < 7864) {
      return value + -1;

   } else if (value < 7865) {
      return value + 0;

   } else if (value < 7866) {
      return value + -1;

   } else if (value < 7867) {
      return value + 0;

   } else if (value < 7868) {
      return value + -1;

   } else if (value < 7869) {
      return value + 0;

   } else if (value < 7870) {
      return value + -1;

   } else if (value < 7871) {
      return value + 0;

   } else if (value < 7872) {
      return value + -1;

   } else if (value < 7873) {
      return value + 0;

   } else if (value < 7874) {
      return value + -1;

   } else if (value < 7875) {
      return value + 0;

   } else if (value < 7876) {
      return value + -1;

   } else if (value < 7877) {
      return value + 0;

   } else if (value < 7878) {
      return value + -1;

   } else if (value < 7879) {
      return value + 0;

   } else if (value < 7880) {
      return value + -1;

   } else if (value < 7881) {
      return value + 0;

   } else if (value < 7882) {
      return value + -1;

   } else if (value < 7883) {
      return value + 0;

   } else if (value < 7884) {
      return value + -1;

   } else if (value < 7885) {
      return value + 0;

   } else if (value < 7886) {
      return value + -1;

   } else if (value < 7887) {
      return value + 0;

   } else if (value < 7888) {
      return value + -1;

   } else if (value < 7889) {
      return value + 0;

   } else if (value < 7890) {
      return value + -1;

   } else if (value < 7891) {
      return value + 0;

   } else if (value < 7892) {
      return value + -1;

   } else if (value < 7893) {
      return value + 0;

   } else if (value < 7894) {
      return value + -1;

   } else if (value < 7895) {
      return value + 0;

   } else if (value < 7896) {
      return value + -1;

   } else if (value < 7897) {
      return value + 0;

   } else if (value < 7898) {
      return value + -1;

   } else if (value < 7899) {
      return value + 0;

   } else if (value < 7900) {
      return value + -1;

   } else if (value < 7901) {
      return value + 0;

   } else if (value < 7902) {
      return value + -1;

   } else if (value < 7903) {
      return value + 0;

   } else if (value < 7904) {
      return value + -1;

   } else if (value < 7905) {
      return value + 0;

   } else if (value < 7906) {
      return value + -1;

   } else if (value < 7907) {
      return value + 0;

   } else if (value < 7908) {
      return value + -1;

   } else if (value < 7909) {
      return value + 0;

   } else if (value < 7910) {
      return value + -1;

   } else if (value < 7911) {
      return value + 0;

   } else if (value < 7912) {
      return value + -1;

   } else if (value < 7913) {
      return value + 0;

   } else if (value < 7914) {
      return value + -1;

   } else if (value < 7915) {
      return value + 0;

   } else if (value < 7916) {
      return value + -1;

   } else if (value < 7917) {
      return value + 0;

   } else if (value < 7918) {
      return value + -1;

   } else if (value < 7919) {
      return value + 0;

   } else if (value < 7920) {
      return value + -1;

   } else if (value < 7921) {
      return value + 0;

   } else if (value < 7922) {
      return value + -1;

   } else if (value < 7923) {
      return value + 0;

   } else if (value < 7924) {
      return value + -1;

   } else if (value < 7925) {
      return value + 0;

   } else if (value < 7926) {
      return value + -1;

   } else if (value < 7927) {
      return value + 0;

   } else if (value < 7928) {
      return value + -1;

   } else if (value < 7929) {
      return value + 0;

   } else if (value < 7930) {
      return value + -1;

   } else if (value < 7931) {
      return value + 0;

   } else if (value < 7932) {
      return value + -1;

   } else if (value < 7933) {
      return value + 0;

   } else if (value < 7934) {
      return value + -1;

   } else if (value < 7935) {
      return value + 0;

   } else if (value < 7936) {
      return value + -1;

   } else if (value < 7944) {
      return value + 8;

   } else if (value < 7952) {
      return value + 0;

   } else if (value < 7958) {
      return value + 8;

   } else if (value < 7968) {
      return value + 0;

   } else if (value < 7976) {
      return value + 8;

   } else if (value < 7984) {
      return value + 0;

   } else if (value < 7992) {
      return value + 8;

   } else if (value < 8000) {
      return value + 0;

   } else if (value < 8006) {
      return value + 8;

   } else if (value == 8016) {
      // special char
      return 0;

   }

   if (value < 8017) {
      return value + 0;

   } else if (value == 8018) {
      // special char
      return 0;

   } else if (value == 8020) {
      // special char
      return 0;

   } else if (value == 8022) {
      // special char
      return 0;

   } else if (value < 8024) {
      return value + 8;

   } else if (value < 8032) {
      return value + 0;

   } else if (value < 8040) {
      return value + 8;

   } else if (value < 8048) {
      return value + 0;

   } else if (value < 8050) {
      return value + 74;

   } else if (value < 8054) {
      return value + 86;

   } else if (value < 8056) {
      return value + 100;

   } else if (value < 8058) {
      return value + 128;

   } else if (value < 8060) {
      return value + 112;

   } else if (value < 8062) {
      return value + 126;

   } else if (value == 8064) {
      // special char
      return 0;

   } else if (value == 8065) {
      // special char
      return 0;

   } else if (value == 8066) {
      // special char
      return 0;

   } else if (value == 8067) {
      // special char
      return 0;

   } else if (value == 8068) {
      // special char
      return 0;

   } else if (value == 8069) {
      // special char
      return 0;

   } else if (value == 8070) {
      // special char
      return 0;

   } else if (value == 8071) {
      // special char
      return 0;

   } else if (value == 8072) {
      // special char
      return 0;

   } else if (value == 8073) {
      // special char
      return 0;

   } else if (value == 8074) {
      // special char
      return 0;

   } else if (value == 8075) {
      // special char
      return 0;

   } else if (value == 8076) {
      // special char
      return 0;

   } else if (value == 8077) {
      // special char
      return 0;

   } else if (value == 8078) {
      // special char
      return 0;

   } else if (value == 8079) {
      // special char
      return 0;

   } else if (value == 8080) {
      // special char
      return 0;

   } else if (value == 8081) {
      // special char
      return 0;

   } else if (value == 8082) {
      // special char
      return 0;

   } else if (value == 8083) {
      // special char
      return 0;

   } else if (value == 8084) {
      // special char
      return 0;

   } else if (value == 8085) {
      // special char
      return 0;

   } else if (value == 8086) {
      // special char
      return 0;

   } else if (value == 8087) {
      // special char
      return 0;

   } else if (value == 8088) {
      // special char
      return 0;

   } else if (value == 8089) {
      // special char
      return 0;

   } else if (value == 8090) {
      // special char
      return 0;

   } else if (value == 8091) {
      // special char
      return 0;

   } else if (value == 8092) {
      // special char
      return 0;

   } else if (value == 8093) {
      // special char
      return 0;

   } else if (value == 8094) {
      // special char
      return 0;

   } else if (value == 8095) {
      // special char
      return 0;

   } else if (value == 8096) {
      // special char
      return 0;

   } else if (value == 8097) {
      // special char
      return 0;

   } else if (value == 8098) {
      // special char
      return 0;

   } else if (value == 8099) {
      // special char
      return 0;

   } else if (value == 8100) {
      // special char
      return 0;

   } else if (value == 8101) {
      // special char
      return 0;

   } else if (value == 8102) {
      // special char
      return 0;

   } else if (value == 8103) {
      // special char
      return 0;

   } else if (value == 8104) {
      // special char
      return 0;

   } else if (value == 8105) {
      // special char
      return 0;

   } else if (value == 8106) {
      // special char
      return 0;

   } else if (value == 8107) {
      // special char
      return 0;

   } else if (value == 8108) {
      // special char
      return 0;

   } else if (value == 8109) {
      // special char
      return 0;

   } else if (value == 8110) {
      // special char
      return 0;

   } else if (value == 8111) {
      // special char
      return 0;

   } else if (value < 8112) {
      return value + 0;

   } else if (value == 8114) {
      // special char
      return 0;

   } else if (value == 8115) {
      // special char
      return 0;

   } else if (value == 8116) {
      // special char
      return 0;

   } else if (value < 8117) {
      return value + 8;

   } else if (value == 8118) {
      // special char
      return 0;

   } else if (value == 8119) {
      // special char
      return 0;

   } else if (value == 8124) {
      // special char
      return 0;

   } else if (value < 8126) {
      return value + 0;

   } else if (value < 8127) {
      return value + -7205;

   } else if (value == 8130) {
      // special char
      return 0;

   } else if (value == 8131) {
      // special char
      return 0;

   } else if (value == 8132) {
      // special char
      return 0;

   } else if (value == 8134) {
      // special char
      return 0;

   } else if (value == 8135) {
      // special char
      return 0;

   } else if (value == 8140) {
      // special char
      return 0;

   } else if (value < 8144) {
      return value + 0;

   } else if (value == 8146) {
      // special char
      return 0;

   } else if (value == 8147) {
      // special char
      return 0;

   } else if (value < 8148) {
      return value + 8;

   } else if (value == 8150) {
      // special char
      return 0;

   } else if (value == 8151) {
      // special char
      return 0;

   } else if (value < 8160) {
      return value + 0;

   } else if (value == 8162) {
      // special char
      return 0;

   } else if (value == 8163) {
      // special char
      return 0;

   } else if (value == 8164) {
      // special char
      return 0;

   } else if (value < 8165) {
      return value + 8;

   } else if (value == 8166) {
      // special char
      return 0;

   } else if (value == 8167) {
      // special char
      return 0;

   } else if (value < 8168) {
      return value + 7;

   } else if (value == 8178) {
      // special char
      return 0;

   } else if (value == 8179) {
      // special char
      return 0;

   } else if (value == 8180) {
      // special char
      return 0;

   } else if (value == 8182) {
      // special char
      return 0;

   } else if (value == 8183) {
      // special char
      return 0;

   } else if (value == 8188) {
      // special char
      return 0;

   } else if (value < 8526) {
      return value + 0;

   } else if (value < 8527) {
      return value + -28;

   }

   if (value < 8560) {
      return value + 0;

   } else if (value < 8576) {
      return value + -16;

   } else if (value < 8580) {
      return value + 0;

   } else if (value < 8581) {
      return value + -1;

   } else if (value < 9424) {
      return value + 0;

   } else if (value < 9450) {
      return value + -26;

   } else if (value < 11312) {
      return value + 0;

   } else if (value < 11360) {
      return value + -48;

   } else if (value < 11361) {
      return value + 0;

   } else if (value < 11362) {
      return value + -1;

   } else if (value < 11365) {
      return value + 0;

   } else if (value < 11366) {
      return value + -10795;

   } else if (value < 11367) {
      return value + -10792;

   } else if (value < 11368) {
      return value + 0;

   } else if (value < 11369) {
      return value + -1;

   } else if (value < 11370) {
      return value + 0;

   } else if (value < 11371) {
      return value + -1;

   } else if (value < 11372) {
      return value + 0;

   } else if (value < 11373) {
      return value + -1;

   } else if (value < 11379) {
      return value + 0;

   } else if (value < 11380) {
      return value + -1;

   } else if (value < 11382) {
      return value + 0;

   } else if (value < 11383) {
      return value + -1;

   } else if (value < 11393) {
      return value + 0;

   } else if (value < 11394) {
      return value + -1;

   } else if (value < 11395) {
      return value + 0;

   } else if (value < 11396) {
      return value + -1;

   } else if (value < 11397) {
      return value + 0;

   } else if (value < 11398) {
      return value + -1;

   } else if (value < 11399) {
      return value + 0;

   } else if (value < 11400) {
      return value + -1;

   } else if (value < 11401) {
      return value + 0;

   } else if (value < 11402) {
      return value + -1;

   } else if (value < 11403) {
      return value + 0;

   } else if (value < 11404) {
      return value + -1;

   } else if (value < 11405) {
      return value + 0;

   } else if (value < 11406) {
      return value + -1;

   } else if (value < 11407) {
      return value + 0;

   } else if (value < 11408) {
      return value + -1;

   } else if (value < 11409) {
      return value + 0;

   } else if (value < 11410) {
      return value + -1;

   } else if (value < 11411) {
      return value + 0;

   } else if (value < 11412) {
      return value + -1;

   } else if (value < 11413) {
      return value + 0;

   } else if (value < 11414) {
      return value + -1;

   } else if (value < 11415) {
      return value + 0;

   } else if (value < 11416) {
      return value + -1;

   } else if (value < 11417) {
      return value + 0;

   } else if (value < 11418) {
      return value + -1;

   } else if (value < 11419) {
      return value + 0;

   } else if (value < 11420) {
      return value + -1;

   } else if (value < 11421) {
      return value + 0;

   } else if (value < 11422) {
      return value + -1;

   } else if (value < 11423) {
      return value + 0;

   } else if (value < 11424) {
      return value + -1;

   } else if (value < 11425) {
      return value + 0;

   } else if (value < 11426) {
      return value + -1;

   } else if (value < 11427) {
      return value + 0;

   } else if (value < 11428) {
      return value + -1;

   } else if (value < 11429) {
      return value + 0;

   } else if (value < 11430) {
      return value + -1;

   } else if (value < 11431) {
      return value + 0;

   } else if (value < 11432) {
      return value + -1;

   } else if (value < 11433) {
      return value + 0;

   } else if (value < 11434) {
      return value + -1;

   } else if (value < 11435) {
      return value + 0;

   } else if (value < 11436) {
      return value + -1;

   } else if (value < 11437) {
      return value + 0;

   } else if (value < 11438) {
      return value + -1;

   } else if (value < 11439) {
      return value + 0;

   } else if (value < 11440) {
      return value + -1;

   } else if (value < 11441) {
      return value + 0;

   } else if (value < 11442) {
      return value + -1;

   } else if (value < 11443) {
      return value + 0;

   } else if (value < 11444) {
      return value + -1;

   } else if (value < 11445) {
      return value + 0;

   } else if (value < 11446) {
      return value + -1;

   } else if (value < 11447) {
      return value + 0;

   } else if (value < 11448) {
      return value + -1;

   } else if (value < 11449) {
      return value + 0;

   } else if (value < 11450) {
      return value + -1;

   } else if (value < 11451) {
      return value + 0;

   } else if (value < 11452) {
      return value + -1;

   } else if (value < 11453) {
      return value + 0;

   } else if (value < 11454) {
      return value + -1;

   } else if (value < 11455) {
      return value + 0;

   } else if (value < 11456) {
      return value + -1;

   } else if (value < 11457) {
      return value + 0;

   } else if (value < 11458) {
      return value + -1;

   } else if (value < 11459) {
      return value + 0;

   } else if (value < 11460) {
      return value + -1;

   } else if (value < 11461) {
      return value + 0;

   } else if (value < 11462) {
      return value + -1;

   } else if (value < 11463) {
      return value + 0;

   } else if (value < 11464) {
      return value + -1;

   } else if (value < 11465) {
      return value + 0;

   } else if (value < 11466) {
      return value + -1;

   } else if (value < 11467) {
      return value + 0;

   } else if (value < 11468) {
      return value + -1;

   } else if (value < 11469) {
      return value + 0;

   }

   if (value < 11470) {
      return value + -1;

   } else if (value < 11471) {
      return value + 0;

   } else if (value < 11472) {
      return value + -1;

   } else if (value < 11473) {
      return value + 0;

   } else if (value < 11474) {
      return value + -1;

   } else if (value < 11475) {
      return value + 0;

   } else if (value < 11476) {
      return value + -1;

   } else if (value < 11477) {
      return value + 0;

   } else if (value < 11478) {
      return value + -1;

   } else if (value < 11479) {
      return value + 0;

   } else if (value < 11480) {
      return value + -1;

   } else if (value < 11481) {
      return value + 0;

   } else if (value < 11482) {
      return value + -1;

   } else if (value < 11483) {
      return value + 0;

   } else if (value < 11484) {
      return value + -1;

   } else if (value < 11485) {
      return value + 0;

   } else if (value < 11486) {
      return value + -1;

   } else if (value < 11487) {
      return value + 0;

   } else if (value < 11488) {
      return value + -1;

   } else if (value < 11489) {
      return value + 0;

   } else if (value < 11490) {
      return value + -1;

   } else if (value < 11491) {
      return value + 0;

   } else if (value < 11492) {
      return value + -1;

   } else if (value < 11500) {
      return value + 0;

   } else if (value < 11501) {
      return value + -1;

   } else if (value < 11502) {
      return value + 0;

   } else if (value < 11503) {
      return value + -1;

   } else if (value < 11507) {
      return value + 0;

   } else if (value < 11508) {
      return value + -1;

   } else if (value < 11520) {
      return value + 0;

   } else if (value < 11558) {
      return value + -7264;

   } else if (value < 11559) {
      return value + 0;

   } else if (value < 11560) {
      return value + -7264;

   } else if (value < 11565) {
      return value + 0;

   } else if (value < 11566) {
      return value + -7264;

   } else if (value < 42561) {
      return value + 0;

   } else if (value < 42562) {
      return value + -1;

   } else if (value < 42563) {
      return value + 0;

   } else if (value < 42564) {
      return value + -1;

   } else if (value < 42565) {
      return value + 0;

   } else if (value < 42566) {
      return value + -1;

   } else if (value < 42567) {
      return value + 0;

   } else if (value < 42568) {
      return value + -1;

   } else if (value < 42569) {
      return value + 0;

   } else if (value < 42570) {
      return value + -1;

   } else if (value < 42571) {
      return value + 0;

   } else if (value < 42572) {
      return value + -1;

   } else if (value < 42573) {
      return value + 0;

   } else if (value < 42574) {
      return value + -1;

   } else if (value < 42575) {
      return value + 0;

   } else if (value < 42576) {
      return value + -1;

   } else if (value < 42577) {
      return value + 0;

   } else if (value < 42578) {
      return value + -1;

   } else if (value < 42579) {
      return value + 0;

   } else if (value < 42580) {
      return value + -1;

   } else if (value < 42581) {
      return value + 0;

   } else if (value < 42582) {
      return value + -1;

   } else if (value < 42583) {
      return value + 0;

   } else if (value < 42584) {
      return value + -1;

   } else if (value < 42585) {
      return value + 0;

   } else if (value < 42586) {
      return value + -1;

   } else if (value < 42587) {
      return value + 0;

   } else if (value < 42588) {
      return value + -1;

   } else if (value < 42589) {
      return value + 0;

   } else if (value < 42590) {
      return value + -1;

   } else if (value < 42591) {
      return value + 0;

   } else if (value < 42592) {
      return value + -1;

   } else if (value < 42593) {
      return value + 0;

   } else if (value < 42594) {
      return value + -1;

   } else if (value < 42595) {
      return value + 0;

   } else if (value < 42596) {
      return value + -1;

   } else if (value < 42597) {
      return value + 0;

   } else if (value < 42598) {
      return value + -1;

   } else if (value < 42599) {
      return value + 0;

   } else if (value < 42600) {
      return value + -1;

   } else if (value < 42601) {
      return value + 0;

   } else if (value < 42602) {
      return value + -1;

   } else if (value < 42603) {
      return value + 0;

   } else if (value < 42604) {
      return value + -1;

   } else if (value < 42605) {
      return value + 0;

   } else if (value < 42606) {
      return value + -1;

   } else if (value < 42625) {
      return value + 0;

   } else if (value < 42626) {
      return value + -1;

   } else if (value < 42627) {
      return value + 0;

   } else if (value < 42628) {
      return value + -1;

   } else if (value < 42629) {
      return value + 0;

   } else if (value < 42630) {
      return value + -1;

   } else if (value < 42631) {
      return value + 0;

   } else if (value < 42632) {
      return value + -1;

   } else if (value < 42633) {
      return value + 0;

   } else if (value < 42634) {
      return value + -1;

   } else if (value < 42635) {
      return value + 0;

   } else if (value < 42636) {
      return value + -1;

   } else if (value < 42637) {
      return value + 0;

   } else if (value < 42638) {
      return value + -1;

   } else if (value < 42639) {
      return value + 0;

   } else if (value < 42640) {
      return value + -1;

   } else if (value < 42641) {
      return value + 0;

   } else if (value < 42642) {
      return value + -1;

   } else if (value < 42643) {
      return value + 0;

   }

   if (value < 42644) {
      return value + -1;

   } else if (value < 42645) {
      return value + 0;

   } else if (value < 42646) {
      return value + -1;

   } else if (value < 42647) {
      return value + 0;

   } else if (value < 42648) {
      return value + -1;

   } else if (value < 42649) {
      return value + 0;

   } else if (value < 42650) {
      return value + -1;

   } else if (value < 42651) {
      return value + 0;

   } else if (value < 42652) {
      return value + -1;

   } else if (value < 42787) {
      return value + 0;

   } else if (value < 42788) {
      return value + -1;

   } else if (value < 42789) {
      return value + 0;

   } else if (value < 42790) {
      return value + -1;

   } else if (value < 42791) {
      return value + 0;

   } else if (value < 42792) {
      return value + -1;

   } else if (value < 42793) {
      return value + 0;

   } else if (value < 42794) {
      return value + -1;

   } else if (value < 42795) {
      return value + 0;

   } else if (value < 42796) {
      return value + -1;

   } else if (value < 42797) {
      return value + 0;

   } else if (value < 42798) {
      return value + -1;

   } else if (value < 42799) {
      return value + 0;

   } else if (value < 42800) {
      return value + -1;

   } else if (value < 42803) {
      return value + 0;

   } else if (value < 42804) {
      return value + -1;

   } else if (value < 42805) {
      return value + 0;

   } else if (value < 42806) {
      return value + -1;

   } else if (value < 42807) {
      return value + 0;

   } else if (value < 42808) {
      return value + -1;

   } else if (value < 42809) {
      return value + 0;

   } else if (value < 42810) {
      return value + -1;

   } else if (value < 42811) {
      return value + 0;

   } else if (value < 42812) {
      return value + -1;

   } else if (value < 42813) {
      return value + 0;

   } else if (value < 42814) {
      return value + -1;

   } else if (value < 42815) {
      return value + 0;

   } else if (value < 42816) {
      return value + -1;

   } else if (value < 42817) {
      return value + 0;

   } else if (value < 42818) {
      return value + -1;

   } else if (value < 42819) {
      return value + 0;

   } else if (value < 42820) {
      return value + -1;

   } else if (value < 42821) {
      return value + 0;

   } else if (value < 42822) {
      return value + -1;

   } else if (value < 42823) {
      return value + 0;

   } else if (value < 42824) {
      return value + -1;

   } else if (value < 42825) {
      return value + 0;

   } else if (value < 42826) {
      return value + -1;

   } else if (value < 42827) {
      return value + 0;

   } else if (value < 42828) {
      return value + -1;

   } else if (value < 42829) {
      return value + 0;

   } else if (value < 42830) {
      return value + -1;

   } else if (value < 42831) {
      return value + 0;

   } else if (value < 42832) {
      return value + -1;

   } else if (value < 42833) {
      return value + 0;

   } else if (value < 42834) {
      return value + -1;

   } else if (value < 42835) {
      return value + 0;

   } else if (value < 42836) {
      return value + -1;

   } else if (value < 42837) {
      return value + 0;

   } else if (value < 42838) {
      return value + -1;

   } else if (value < 42839) {
      return value + 0;

   } else if (value < 42840) {
      return value + -1;

   } else if (value < 42841) {
      return value + 0;

   } else if (value < 42842) {
      return value + -1;

   } else if (value < 42843) {
      return value + 0;

   } else if (value < 42844) {
      return value + -1;

   } else if (value < 42845) {
      return value + 0;

   } else if (value < 42846) {
      return value + -1;

   } else if (value < 42847) {
      return value + 0;

   } else if (value < 42848) {
      return value + -1;

   } else if (value < 42849) {
      return value + 0;

   } else if (value < 42850) {
      return value + -1;

   } else if (value < 42851) {
      return value + 0;

   } else if (value < 42852) {
      return value + -1;

   } else if (value < 42853) {
      return value + 0;

   } else if (value < 42854) {
      return value + -1;

   } else if (value < 42855) {
      return value + 0;

   } else if (value < 42856) {
      return value + -1;

   } else if (value < 42857) {
      return value + 0;

   } else if (value < 42858) {
      return value + -1;

   } else if (value < 42859) {
      return value + 0;

   } else if (value < 42860) {
      return value + -1;

   } else if (value < 42861) {
      return value + 0;

   } else if (value < 42862) {
      return value + -1;

   } else if (value < 42863) {
      return value + 0;

   } else if (value < 42864) {
      return value + -1;

   } else if (value < 42874) {
      return value + 0;

   } else if (value < 42875) {
      return value + -1;

   } else if (value < 42876) {
      return value + 0;

   } else if (value < 42877) {
      return value + -1;

   } else if (value < 42879) {
      return value + 0;

   } else if (value < 42880) {
      return value + -1;

   } else if (value < 42881) {
      return value + 0;

   } else if (value < 42882) {
      return value + -1;

   } else if (value < 42883) {
      return value + 0;

   } else if (value < 42884) {
      return value + -1;

   } else if (value < 42885) {
      return value + 0;

   } else if (value < 42886) {
      return value + -1;

   } else if (value < 42887) {
      return value + 0;

   } else if (value < 42888) {
      return value + -1;

   } else if (value < 42892) {
      return value + 0;

   }

   if (value < 42893) {
      return value + -1;

   } else if (value < 42897) {
      return value + 0;

   } else if (value < 42898) {
      return value + -1;

   } else if (value < 42899) {
      return value + 0;

   } else if (value < 42900) {
      return value + -1;

   } else if (value < 42901) {
      return value + 48;

   } else if (value < 42903) {
      return value + 0;

   } else if (value < 42904) {
      return value + -1;

   } else if (value < 42905) {
      return value + 0;

   } else if (value < 42906) {
      return value + -1;

   } else if (value < 42907) {
      return value + 0;

   } else if (value < 42908) {
      return value + -1;

   } else if (value < 42909) {
      return value + 0;

   } else if (value < 42910) {
      return value + -1;

   } else if (value < 42911) {
      return value + 0;

   } else if (value < 42912) {
      return value + -1;

   } else if (value < 42913) {
      return value + 0;

   } else if (value < 42914) {
      return value + -1;

   } else if (value < 42915) {
      return value + 0;

   } else if (value < 42916) {
      return value + -1;

   } else if (value < 42917) {
      return value + 0;

   } else if (value < 42918) {
      return value + -1;

   } else if (value < 42919) {
      return value + 0;

   } else if (value < 42920) {
      return value + -1;

   } else if (value < 42921) {
      return value + 0;

   } else if (value < 42922) {
      return value + -1;

   } else if (value < 42933) {
      return value + 0;

   } else if (value < 42934) {
      return value + -1;

   } else if (value < 42935) {
      return value + 0;

   } else if (value < 42936) {
      return value + -1;

   } else if (value < 42937) {
      return value + 0;

   } else if (value < 42938) {
      return value + -1;

   } else if (value < 42939) {
      return value + 0;

   } else if (value < 42940) {
      return value + -1;

   } else if (value < 42941) {
      return value + 0;

   } else if (value < 42942) {
      return value + -1;

   } else if (value < 42943) {
      return value + 0;

   } else if (value < 42944) {
      return value + -1;

   } else if (value < 42945) {
      return value + 0;

   } else if (value < 42946) {
      return value + -1;

   } else if (value < 42947) {
      return value + 0;

   } else if (value < 42948) {
      return value + -1;

   } else if (value < 42952) {
      return value + 0;

   } else if (value < 42953) {
      return value + -1;

   } else if (value < 42954) {
      return value + 0;

   } else if (value < 42955) {
      return value + -1;

   } else if (value < 42961) {
      return value + 0;

   } else if (value < 42962) {
      return value + -1;

   } else if (value < 42967) {
      return value + 0;

   } else if (value < 42968) {
      return value + -1;

   } else if (value < 42969) {
      return value + 0;

   } else if (value < 42970) {
      return value + -1;

   } else if (value < 42998) {
      return value + 0;

   } else if (value < 42999) {
      return value + -1;

   } else if (value < 43859) {
      return value + 0;

   } else if (value < 43860) {
      return value + -928;

   } else if (value < 43888) {
      return value + 0;

   } else if (value < 43968) {
      return value + -38864;

   } else if (value == 64256) {
      // special char
      return 0;

   } else if (value == 64257) {
      // special char
      return 0;

   } else if (value == 64258) {
      // special char
      return 0;

   } else if (value == 64259) {
      // special char
      return 0;

   } else if (value == 64260) {
      // special char
      return 0;

   } else if (value == 64261) {
      // special char
      return 0;

   } else if (value == 64262) {
      // special char
      return 0;

   } else if (value == 64275) {
      // special char
      return 0;

   } else if (value == 64276) {
      // special char
      return 0;

   } else if (value == 64277) {
      // special char
      return 0;

   } else if (value == 64278) {
      // special char
      return 0;

   } else if (value == 64279) {
      // special char
      return 0;

   } else if (value < 65345) {
      return value + 0;

   } else if (value < 65371) {
      return value + -32;

   } else if (value < 66600) {
      return value + 0;

   } else if (value < 66640) {
      return value + -40;

   } else if (value < 66776) {
      return value + 0;

   } else if (value < 66812) {
      return value + -40;

   } else if (value < 66967) {
      return value + 0;

   } else if (value < 66978) {
      return value + -39;

   } else if (value < 66979) {
      return value + 0;

   } else if (value < 66994) {
      return value + -39;

   } else if (value < 66995) {
      return value + 0;

   } else if (value < 67002) {
      return value + -39;

   } else if (value < 67003) {
      return value + 0;

   } else if (value < 67005) {
      return value + -39;

   } else if (value < 68800) {
      return value + 0;

   } else if (value < 68851) {
      return value + -64;

   } else if (value < 71872) {
      return value + 0;

   } else if (value < 71904) {
      return value + -32;

   } else if (value < 93792) {
      return value + 0;

   } else if (value < 93824) {
      return value + -32;

   } else if (value < 125218) {
      return value + 0;

   } else if (value < 125252) {
      return value + -34;

   } else {
      return value;
   }
}

static inline const Properties *qGetProp(uint ucs4) 
{
    return uc_properties + GET_PROP_INDEX(ucs4);
}

static inline const Properties *qGetProp(ushort ucs2) 
{
    return uc_properties + GET_PROP_INDEX_UCS2(ucs2);
}

Q_CORE_EXPORT const Properties * properties(uint ucs4) 
{
    return qGetProp(ucs4);
}

Q_CORE_EXPORT const Properties * properties(ushort ucs2) 
{
    return qGetProp(ucs2);
}

Q_CORE_EXPORT GraphemeBreakClass graphemeBreakClass(uint ucs4) 
{
    return static_cast<GraphemeBreakClass>(qGetProp(ucs4)->graphemeBreakClass);
}

Q_CORE_EXPORT WordBreakClass wordBreakClass(uint ucs4) 
{
    return static_cast<WordBreakClass>(qGetProp(ucs4)->wordBreakClass);
}

Q_CORE_EXPORT SentenceBreakClass sentenceBreakClass(uint ucs4) 
{
    return static_cast<SentenceBreakClass>(qGetProp(ucs4)->sentenceBreakClass);
}

Q_CORE_EXPORT LineBreakClass lineBreakClass(uint ucs4) 
{
    return static_cast<LineBreakClass>(qGetProp(ucs4)->lineBreakClass);
}


const char32_t *uc_caseFoldSpecial(char32_t value)
{
    if (value == 223) {
      return U"\U00000073\U00000073";

    } else if (value == 304) {
      return U"\U00000069\U00000307";

    } else if (value == 329) {
      return U"\U000002bc\U0000006e";

    } else if (value == 496) {
      return U"\U0000006a\U0000030c";

    } else if (value == 912) {
      return U"\U000003b9\U00000308\U00000301";

    } else if (value == 944) {
      return U"\U000003c5\U00000308\U00000301";

    } else if (value == 1415) {
      return U"\U00000565\U00000582";

    } else if (value == 7830) {
      return U"\U00000068\U00000331";

    } else if (value == 7831) {
      return U"\U00000074\U00000308";

    } else if (value == 7832) {
      return U"\U00000077\U0000030a";

    } else if (value == 7833) {
      return U"\U00000079\U0000030a";

    } else if (value == 7834) {
      return U"\U00000061\U000002be";

    } else if (value == 7838) {
      return U"\U00000073\U00000073";

    } else if (value == 8016) {
      return U"\U000003c5\U00000313";

    } else if (value == 8018) {
      return U"\U000003c5\U00000313\U00000300";

    } else if (value == 8020) {
      return U"\U000003c5\U00000313\U00000301";

    } else if (value == 8022) {
      return U"\U000003c5\U00000313\U00000342";

    } else if (value == 8064) {
      return U"\U00001f00\U000003b9";

    } else if (value == 8065) {
      return U"\U00001f01\U000003b9";

    } else if (value == 8066) {
      return U"\U00001f02\U000003b9";

    } else if (value == 8067) {
      return U"\U00001f03\U000003b9";

    } else if (value == 8068) {
      return U"\U00001f04\U000003b9";

    } else if (value == 8069) {
      return U"\U00001f05\U000003b9";

    } else if (value == 8070) {
      return U"\U00001f06\U000003b9";

    } else if (value == 8071) {
      return U"\U00001f07\U000003b9";

    } else if (value == 8072) {
      return U"\U00001f00\U000003b9";

    } else if (value == 8073) {
      return U"\U00001f01\U000003b9";

    } else if (value == 8074) {
      return U"\U00001f02\U000003b9";

    } else if (value == 8075) {
      return U"\U00001f03\U000003b9";

    } else if (value == 8076) {
      return U"\U00001f04\U000003b9";

    } else if (value == 8077) {
      return U"\U00001f05\U000003b9";

    } else if (value == 8078) {
      return U"\U00001f06\U000003b9";

    } else if (value == 8079) {
      return U"\U00001f07\U000003b9";

    } else if (value == 8080) {
      return U"\U00001f20\U000003b9";

    } else if (value == 8081) {
      return U"\U00001f21\U000003b9";

    } else if (value == 8082) {
      return U"\U00001f22\U000003b9";

    } else if (value == 8083) {
      return U"\U00001f23\U000003b9";

    } else if (value == 8084) {
      return U"\U00001f24\U000003b9";

    } else if (value == 8085) {
      return U"\U00001f25\U000003b9";

    } else if (value == 8086) {
      return U"\U00001f26\U000003b9";

    } else if (value == 8087) {
      return U"\U00001f27\U000003b9";

    } else if (value == 8088) {
      return U"\U00001f20\U000003b9";

    } else if (value == 8089) {
      return U"\U00001f21\U000003b9";

    } else if (value == 8090) {
      return U"\U00001f22\U000003b9";

    } else if (value == 8091) {
      return U"\U00001f23\U000003b9";

    } else if (value == 8092) {
      return U"\U00001f24\U000003b9";

    } else if (value == 8093) {
      return U"\U00001f25\U000003b9";

    } else if (value == 8094) {
      return U"\U00001f26\U000003b9";

    } else if (value == 8095) {
      return U"\U00001f27\U000003b9";

    } else if (value == 8096) {
      return U"\U00001f60\U000003b9";

    } else if (value == 8097) {
      return U"\U00001f61\U000003b9";

    } else if (value == 8098) {
      return U"\U00001f62\U000003b9";

    } else if (value == 8099) {
      return U"\U00001f63\U000003b9";

    } else if (value == 8100) {
      return U"\U00001f64\U000003b9";

    } else if (value == 8101) {
      return U"\U00001f65\U000003b9";

    } else if (value == 8102) {
      return U"\U00001f66\U000003b9";

    } else if (value == 8103) {
      return U"\U00001f67\U000003b9";

    } else if (value == 8104) {
      return U"\U00001f60\U000003b9";

    } else if (value == 8105) {
      return U"\U00001f61\U000003b9";

    } else if (value == 8106) {
      return U"\U00001f62\U000003b9";

    } else if (value == 8107) {
      return U"\U00001f63\U000003b9";

    } else if (value == 8108) {
      return U"\U00001f64\U000003b9";

    } else if (value == 8109) {
      return U"\U00001f65\U000003b9";

    } else if (value == 8110) {
      return U"\U00001f66\U000003b9";

    } else if (value == 8111) {
      return U"\U00001f67\U000003b9";

    } else if (value == 8114) {
      return U"\U00001f70\U000003b9";

    } else if (value == 8115) {
      return U"\U000003b1\U000003b9";

    } else if (value == 8116) {
      return U"\U000003ac\U000003b9";

    } else if (value == 8118) {
      return U"\U000003b1\U00000342";

    } else if (value == 8119) {
      return U"\U000003b1\U00000342\U000003b9";

    } else if (value == 8124) {
      return U"\U000003b1\U000003b9";

    } else if (value == 8130) {
      return U"\U00001f74\U000003b9";

    } else if (value == 8131) {
      return U"\U000003b7\U000003b9";

    } else if (value == 8132) {
      return U"\U000003ae\U000003b9";

    } else if (value == 8134) {
      return U"\U000003b7\U00000342";

    } else if (value == 8135) {
      return U"\U000003b7\U00000342\U000003b9";

    } else if (value == 8140) {
      return U"\U000003b7\U000003b9";

    } else if (value == 8146) {
      return U"\U000003b9\U00000308\U00000300";

    } else if (value == 8147) {
      return U"\U000003b9\U00000308\U00000301";

    } else if (value == 8150) {
      return U"\U000003b9\U00000342";

    } else if (value == 8151) {
      return U"\U000003b9\U00000308\U00000342";

    } else if (value == 8162) {
      return U"\U000003c5\U00000308\U00000300";

    } else if (value == 8163) {
      return U"\U000003c5\U00000308\U00000301";

    } else if (value == 8164) {
      return U"\U000003c1\U00000313";

    } else if (value == 8166) {
      return U"\U000003c5\U00000342";

    } else if (value == 8167) {
      return U"\U000003c5\U00000308\U00000342";

    } else if (value == 8178) {
      return U"\U00001f7c\U000003b9";

    } else if (value == 8179) {
      return U"\U000003c9\U000003b9";

    } else if (value == 8180) {
      return U"\U000003ce\U000003b9";

    } else if (value == 8182) {
      return U"\U000003c9\U00000342";

    } else if (value == 8183) {
      return U"\U000003c9\U00000342\U000003b9";

    } else if (value == 8188) {
      return U"\U000003c9\U000003b9";

    } else if (value == 64256) {
      return U"\U00000066\U00000066";

    } else if (value == 64257) {
      return U"\U00000066\U00000069";

    } else if (value == 64258) {
      return U"\U00000066\U0000006c";

    } else if (value == 64259) {
      return U"\U00000066\U00000066\U00000069";

    } else if (value == 64260) {
      return U"\U00000066\U00000066\U0000006c";

    } else if (value == 64261) {
      return U"\U00000073\U00000074";

    } else if (value == 64262) {
      return U"\U00000073\U00000074";

    } else if (value == 64275) {
      return U"\U00000574\U00000576";

    } else if (value == 64276) {
      return U"\U00000574\U00000565";

    } else if (value == 64277) {
      return U"\U00000574\U0000056b";

    } else if (value == 64278) {
      return U"\U0000057e\U00000576";

    } else if (value == 64279) {
      return U"\U00000574\U0000056d";

    } else {
      return nullptr;
   }
}

const char32_t *uc_lowerCaseSpecial(char32_t value)
{
    if (value == 304) {
      return U"\U00000069\U00000307";

    } else {
      return nullptr;
   }
}

const char32_t *uc_titleCaseSpecial(char32_t value)
{
    if (value == 223) {
      return U"\U00000053\U00000073";

    } else if (value == 329) {
      return U"\U000002bc\U0000004e";

    } else if (value == 496) {
      return U"\U0000004a\U0000030c";

    } else if (value == 912) {
      return U"\U00000399\U00000308\U00000301";

    } else if (value == 944) {
      return U"\U000003a5\U00000308\U00000301";

    } else if (value == 1415) {
      return U"\U00000535\U00000582";

    } else if (value == 7830) {
      return U"\U00000048\U00000331";

    } else if (value == 7831) {
      return U"\U00000054\U00000308";

    } else if (value == 7832) {
      return U"\U00000057\U0000030a";

    } else if (value == 7833) {
      return U"\U00000059\U0000030a";

    } else if (value == 7834) {
      return U"\U00000041\U000002be";

    } else if (value == 8016) {
      return U"\U000003a5\U00000313";

    } else if (value == 8018) {
      return U"\U000003a5\U00000313\U00000300";

    } else if (value == 8020) {
      return U"\U000003a5\U00000313\U00000301";

    } else if (value == 8022) {
      return U"\U000003a5\U00000313\U00000342";

    } else if (value == 8114) {
      return U"\U00001fba\U00000345";

    } else if (value == 8116) {
      return U"\U00000386\U00000345";

    } else if (value == 8118) {
      return U"\U00000391\U00000342";

    } else if (value == 8119) {
      return U"\U00000391\U00000342\U00000345";

    } else if (value == 8130) {
      return U"\U00001fca\U00000345";

    } else if (value == 8132) {
      return U"\U00000389\U00000345";

    } else if (value == 8134) {
      return U"\U00000397\U00000342";

    } else if (value == 8135) {
      return U"\U00000397\U00000342\U00000345";

    } else if (value == 8146) {
      return U"\U00000399\U00000308\U00000300";

    } else if (value == 8147) {
      return U"\U00000399\U00000308\U00000301";

    } else if (value == 8150) {
      return U"\U00000399\U00000342";

    } else if (value == 8151) {
      return U"\U00000399\U00000308\U00000342";

    } else if (value == 8162) {
      return U"\U000003a5\U00000308\U00000300";

    } else if (value == 8163) {
      return U"\U000003a5\U00000308\U00000301";

    } else if (value == 8164) {
      return U"\U000003a1\U00000313";

    } else if (value == 8166) {
      return U"\U000003a5\U00000342";

    } else if (value == 8167) {
      return U"\U000003a5\U00000308\U00000342";

    } else if (value == 8178) {
      return U"\U00001ffa\U00000345";

    } else if (value == 8180) {
      return U"\U0000038f\U00000345";

    } else if (value == 8182) {
      return U"\U000003a9\U00000342";

    } else if (value == 8183) {
      return U"\U000003a9\U00000342\U00000345";

    } else if (value == 64256) {
      return U"\U00000046\U00000066";

    } else if (value == 64257) {
      return U"\U00000046\U00000069";

    } else if (value == 64258) {
      return U"\U00000046\U0000006c";

    } else if (value == 64259) {
      return U"\U00000046\U00000066\U00000069";

    } else if (value == 64260) {
      return U"\U00000046\U00000066\U0000006c";

    } else if (value == 64261) {
      return U"\U00000053\U00000074";

    } else if (value == 64262) {
      return U"\U00000053\U00000074";

    } else if (value == 64275) {
      return U"\U00000544\U00000576";

    } else if (value == 64276) {
      return U"\U00000544\U00000565";

    } else if (value == 64277) {
      return U"\U00000544\U0000056b";

    } else if (value == 64278) {
      return U"\U0000054e\U00000576";

    } else if (value == 64279) {
      return U"\U00000544\U0000056d";

    } else {
      return nullptr;
   }
}

const char32_t *uc_upperCaseSpecial(char32_t value)
{
    if (value == 223) {
      return U"\U00000053\U00000053";

    } else if (value == 329) {
      return U"\U000002bc\U0000004e";

    } else if (value == 496) {
      return U"\U0000004a\U0000030c";

    } else if (value == 912) {
      return U"\U00000399\U00000308\U00000301";

    } else if (value == 944) {
      return U"\U000003a5\U00000308\U00000301";

    } else if (value == 1415) {
      return U"\U00000535\U00000552";

    } else if (value == 7830) {
      return U"\U00000048\U00000331";

    } else if (value == 7831) {
      return U"\U00000054\U00000308";

    } else if (value == 7832) {
      return U"\U00000057\U0000030a";

    } else if (value == 7833) {
      return U"\U00000059\U0000030a";

    } else if (value == 7834) {
      return U"\U00000041\U000002be";

    } else if (value == 8016) {
      return U"\U000003a5\U00000313";

    } else if (value == 8018) {
      return U"\U000003a5\U00000313\U00000300";

    } else if (value == 8020) {
      return U"\U000003a5\U00000313\U00000301";

    } else if (value == 8022) {
      return U"\U000003a5\U00000313\U00000342";

    } else if (value == 8064) {
      return U"\U00001f08\U00000399";

    } else if (value == 8065) {
      return U"\U00001f09\U00000399";

    } else if (value == 8066) {
      return U"\U00001f0a\U00000399";

    } else if (value == 8067) {
      return U"\U00001f0b\U00000399";

    } else if (value == 8068) {
      return U"\U00001f0c\U00000399";

    } else if (value == 8069) {
      return U"\U00001f0d\U00000399";

    } else if (value == 8070) {
      return U"\U00001f0e\U00000399";

    } else if (value == 8071) {
      return U"\U00001f0f\U00000399";

    } else if (value == 8072) {
      return U"\U00001f08\U00000399";

    } else if (value == 8073) {
      return U"\U00001f09\U00000399";

    } else if (value == 8074) {
      return U"\U00001f0a\U00000399";

    } else if (value == 8075) {
      return U"\U00001f0b\U00000399";

    } else if (value == 8076) {
      return U"\U00001f0c\U00000399";

    } else if (value == 8077) {
      return U"\U00001f0d\U00000399";

    } else if (value == 8078) {
      return U"\U00001f0e\U00000399";

    } else if (value == 8079) {
      return U"\U00001f0f\U00000399";

    } else if (value == 8080) {
      return U"\U00001f28\U00000399";

    } else if (value == 8081) {
      return U"\U00001f29\U00000399";

    } else if (value == 8082) {
      return U"\U00001f2a\U00000399";

    } else if (value == 8083) {
      return U"\U00001f2b\U00000399";

    } else if (value == 8084) {
      return U"\U00001f2c\U00000399";

    } else if (value == 8085) {
      return U"\U00001f2d\U00000399";

    } else if (value == 8086) {
      return U"\U00001f2e\U00000399";

    } else if (value == 8087) {
      return U"\U00001f2f\U00000399";

    } else if (value == 8088) {
      return U"\U00001f28\U00000399";

    } else if (value == 8089) {
      return U"\U00001f29\U00000399";

    } else if (value == 8090) {
      return U"\U00001f2a\U00000399";

    } else if (value == 8091) {
      return U"\U00001f2b\U00000399";

    } else if (value == 8092) {
      return U"\U00001f2c\U00000399";

    } else if (value == 8093) {
      return U"\U00001f2d\U00000399";

    } else if (value == 8094) {
      return U"\U00001f2e\U00000399";

    } else if (value == 8095) {
      return U"\U00001f2f\U00000399";

    } else if (value == 8096) {
      return U"\U00001f68\U00000399";

    } else if (value == 8097) {
      return U"\U00001f69\U00000399";

    } else if (value == 8098) {
      return U"\U00001f6a\U00000399";

    } else if (value == 8099) {
      return U"\U00001f6b\U00000399";

    } else if (value == 8100) {
      return U"\U00001f6c\U00000399";

    } else if (value == 8101) {
      return U"\U00001f6d\U00000399";

    } else if (value == 8102) {
      return U"\U00001f6e\U00000399";

    } else if (value == 8103) {
      return U"\U00001f6f\U00000399";

    } else if (value == 8104) {
      return U"\U00001f68\U00000399";

    } else if (value == 8105) {
      return U"\U00001f69\U00000399";

    } else if (value == 8106) {
      return U"\U00001f6a\U00000399";

    } else if (value == 8107) {
      return U"\U00001f6b\U00000399";

    } else if (value == 8108) {
      return U"\U00001f6c\U00000399";

    } else if (value == 8109) {
      return U"\U00001f6d\U00000399";

    } else if (value == 8110) {
      return U"\U00001f6e\U00000399";

    } else if (value == 8111) {
      return U"\U00001f6f\U00000399";

    } else if (value == 8114) {
      return U"\U00001fba\U00000399";

    } else if (value == 8115) {
      return U"\U00000391\U00000399";

    } else if (value == 8116) {
      return U"\U00000386\U00000399";

    } else if (value == 8118) {
      return U"\U00000391\U00000342";

    } else if (value == 8119) {
      return U"\U00000391\U00000342\U00000399";

    } else if (value == 8124) {
      return U"\U00000391\U00000399";

    } else if (value == 8130) {
      return U"\U00001fca\U00000399";

    } else if (value == 8131) {
      return U"\U00000397\U00000399";

    } else if (value == 8132) {
      return U"\U00000389\U00000399";

    } else if (value == 8134) {
      return U"\U00000397\U00000342";

    } else if (value == 8135) {
      return U"\U00000397\U00000342\U00000399";

    } else if (value == 8140) {
      return U"\U00000397\U00000399";

    } else if (value == 8146) {
      return U"\U00000399\U00000308\U00000300";

    } else if (value == 8147) {
      return U"\U00000399\U00000308\U00000301";

    } else if (value == 8150) {
      return U"\U00000399\U00000342";

    } else if (value == 8151) {
      return U"\U00000399\U00000308\U00000342";

    } else if (value == 8162) {
      return U"\U000003a5\U00000308\U00000300";

    } else if (value == 8163) {
      return U"\U000003a5\U00000308\U00000301";

    } else if (value == 8164) {
      return U"\U000003a1\U00000313";

    } else if (value == 8166) {
      return U"\U000003a5\U00000342";

    } else if (value == 8167) {
      return U"\U000003a5\U00000308\U00000342";

    } else if (value == 8178) {
      return U"\U00001ffa\U00000399";

    } else if (value == 8179) {
      return U"\U000003a9\U00000399";

    } else if (value == 8180) {
      return U"\U0000038f\U00000399";

    } else if (value == 8182) {
      return U"\U000003a9\U00000342";

    } else if (value == 8183) {
      return U"\U000003a9\U00000342\U00000399";

    } else if (value == 8188) {
      return U"\U000003a9\U00000399";

    } else if (value == 64256) {
      return U"\U00000046\U00000046";

    } else if (value == 64257) {
      return U"\U00000046\U00000049";

    } else if (value == 64258) {
      return U"\U00000046\U0000004c";

    } else if (value == 64259) {
      return U"\U00000046\U00000046\U00000049";

    } else if (value == 64260) {
      return U"\U00000046\U00000046\U0000004c";

    } else if (value == 64261) {
      return U"\U00000053\U00000054";

    } else if (value == 64262) {
      return U"\U00000053\U00000054";

    } else if (value == 64275) {
      return U"\U00000544\U00000546";

    } else if (value == 64276) {
      return U"\U00000544\U00000535";

    } else if (value == 64277) {
      return U"\U00000544\U0000053b";

    } else if (value == 64278) {
      return U"\U0000054e\U00000546";

    } else if (value == 64279) {
      return U"\U00000544\U0000053d";

    } else {
      return nullptr;
   }
}


const unsigned short uc_decomposition_trie[] = {
    // 0 - 0x3400

    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1564, 1580, 1596, 1612, 1628, 1644,
    1660, 1676, 1692, 1708, 1724, 1740, 1756, 1772,
    1548, 1548, 1788, 1804, 1820, 1836, 1852, 1868,
    1884, 1900, 1916, 1932, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1948, 1548, 1964, 1980, 1548,
    1548, 1548, 1548, 1548, 1996, 1548, 1548, 2012,
    2028, 2044, 2060, 2076, 2092, 2108, 1548, 2124,
    2140, 2156, 1548, 2172, 1548, 2188, 1548, 2204,
    1548, 1548, 1548, 1548, 2220, 2236, 2252, 2268,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    2284, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 2300, 1548, 1548, 1548, 1548, 2316,
    1548, 1548, 1548, 1548, 2332, 2348, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 2364, 2380, 1548, 2396, 1548, 1548,
    1548, 1548, 1548, 1548, 2412, 2428, 1548, 1548,
    1548, 1548, 1548, 2444, 1548, 2460, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 2476, 2492, 1548, 1548,
    1548, 2508, 1548, 1548, 2524, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 2540, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 2556, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 2572, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 2588, 1548, 1548,
    1548, 1548, 1548, 2604, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 2620, 1548, 2636, 1548, 1548,
    2652, 1548, 1548, 1548, 2668, 2684, 2700, 2716,
    2732, 2748, 2764, 2780, 1548, 1548, 1548, 1548,

    1548, 1548, 2796, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 2812,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    2828, 2844, 1548, 2860, 2876, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 2892, 2908, 2924, 2940, 2956, 2972,
    1548, 2988, 3004, 3020, 1548, 1548, 1548, 1548,
    3036, 3052, 3068, 3084, 3100, 3116, 3132, 3148,
    3164, 3180, 3196, 3212, 3228, 3244, 3260, 3276,
    3292, 3308, 3324, 3340, 3356, 3372, 3388, 3404,
    3420, 3436, 3452, 3468, 3484, 3500, 3516, 3532,

    3548, 3564, 3580, 3596, 3612, 3628, 1548, 3644,
    3660, 3676, 3692, 1548, 1548, 1548, 1548, 1548,
    3708, 3724, 3740, 3756, 3772, 3788, 3804, 3820,
    3836, 3852, 3868, 1548, 3884, 1548, 1548, 1548,
    3900, 1548, 3916, 3932, 3948, 1548, 3964, 3980,
    3996, 1548, 4012, 1548, 1548, 1548, 4028, 1548,
    1548, 1548, 4044, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 4060, 4076,
    4092, 4108, 4124, 4140, 4156, 4172, 4188, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    4204, 1548, 1548, 1548, 1548, 1548, 1548, 4220,
    1548, 1548, 1548, 1548, 1548, 4236, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 4252,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 4268, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 4284, 1548, 1548, 1548, 1548, 1548, 4300,
    4316, 4332, 4348, 4364, 4380, 4396, 4412, 4428,
    4444, 4460, 4476, 4492, 4508, 4524, 1548, 1548,

    4540, 1548, 1548, 4556, 4572, 4588, 4604, 4620,
    1548, 4636, 4652, 4668, 4684, 4700, 1548, 4716,
    1548, 1548, 1548, 4732, 4748, 4764, 4780, 4796,
    4812, 4828, 1548, 1548, 1548, 1548, 1548, 1548,
    4844, 4860, 4876, 4892, 4908, 4924, 4940, 4956,
    4972, 4988, 5004, 5020, 5036, 5052, 5068, 5084,
    5100, 5116, 5132, 5148, 5164, 5180, 5196, 5212,
    5228, 5244, 5260, 5276, 5292, 5308, 5324, 5340,

    // 0x3400 - 0x30000

    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5612, 5868, 5356, 5356, 5356, 6124,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,

    5356, 5356, 5356, 5356, 5356, 6380, 6636, 6892,
    7148, 7404, 7660, 7916, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 8172, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 8428, 8684, 5356, 8940,
    9196, 9452, 5356, 5356, 5356, 9708, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 9964, 5356, 5356,
    10220, 10476, 10732, 10988, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 11244, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 11500, 5356, 5356, 11756, 12012, 5356,

    5356, 5356, 5356, 5356, 5356, 5356, 5356, 12268,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,

    5356, 5356, 5356, 5356, 12524, 12780, 13036, 5356,
    5356, 5356, 5356, 5356,


    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x2, 0xffff, 0x5, 0xffff, 0xffff, 0xffff, 0xffff, 0x7,

    0xffff, 0xffff, 0xa, 0xc, 0xe, 0x11, 0xffff, 0xffff,
    0x13, 0x16, 0x18, 0xffff, 0x1a, 0x1e, 0x22, 0xffff,

    0x26, 0x29, 0x2c, 0x2f, 0x32, 0x35, 0xffff, 0x38,
    0x3b, 0x3e, 0x41, 0x44, 0x47, 0x4a, 0x4d, 0x50,

    0xffff, 0x53, 0x56, 0x59, 0x5c, 0x5f, 0x62, 0xffff,
    0xffff, 0x65, 0x68, 0x6b, 0x6e, 0x71, 0xffff, 0xffff,

    0x74, 0x77, 0x7a, 0x7d, 0x80, 0x83, 0xffff, 0x86,
    0x89, 0x8c, 0x8f, 0x92, 0x95, 0x98, 0x9b, 0x9e,

    0xffff, 0xa1, 0xa4, 0xa7, 0xaa, 0xad, 0xb0, 0xffff,
    0xffff, 0xb3, 0xb6, 0xb9, 0xbc, 0xbf, 0xffff, 0xc2,

    0xc5, 0xc8, 0xcb, 0xce, 0xd1, 0xd4, 0xd7, 0xda,
    0xdd, 0xe0, 0xe3, 0xe6, 0xe9, 0xec, 0xef, 0xf2,

    0xffff, 0xffff, 0xf5, 0xf8, 0xfb, 0xfe, 0x101, 0x104,
    0x107, 0x10a, 0x10d, 0x110, 0x113, 0x116, 0x119, 0x11c,

    0x11f, 0x122, 0x125, 0x128, 0x12b, 0x12e, 0xffff, 0xffff,
    0x131, 0x134, 0x137, 0x13a, 0x13d, 0x140, 0x143, 0x146,

    0x149, 0xffff, 0x14c, 0x14f, 0x152, 0x155, 0x158, 0x15b,
    0xffff, 0x15e, 0x161, 0x164, 0x167, 0x16a, 0x16d, 0x170,

    0x173, 0xffff, 0xffff, 0x176, 0x179, 0x17c, 0x17f, 0x182,
    0x185, 0x188, 0xffff, 0xffff, 0x18b, 0x18e, 0x191, 0x194,

    0x197, 0x19a, 0xffff, 0xffff, 0x19d, 0x1a0, 0x1a3, 0x1a6,
    0x1a9, 0x1ac, 0x1af, 0x1b2, 0x1b5, 0x1b8, 0x1bb, 0x1be,

    0x1c1, 0x1c4, 0x1c7, 0x1ca, 0x1cd, 0x1d0, 0xffff, 0xffff,
    0x1d3, 0x1d6, 0x1d9, 0x1dc, 0x1df, 0x1e2, 0x1e5, 0x1e8,

    0x1eb, 0x1ee, 0x1f1, 0x1f4, 0x1f7, 0x1fa, 0x1fd, 0x200,
    0x203, 0x206, 0x209, 0x20c, 0x20f, 0x212, 0x215, 0x218,

    0x21a, 0x21d, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x220,

    0x223, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x226, 0x229, 0x22c, 0x22f,
    0x232, 0x235, 0x238, 0x23b, 0x23e, 0x241, 0x244, 0x247,

    0x24a, 0x24d, 0x250, 0x253, 0x256, 0x259, 0x25c, 0x25f,
    0x262, 0x265, 0x268, 0x26b, 0x26e, 0xffff, 0x271, 0x274,

    0x277, 0x27a, 0x27d, 0x280, 0xffff, 0xffff, 0x283, 0x286,
    0x289, 0x28c, 0x28f, 0x292, 0x295, 0x298, 0x29b, 0x29e,

    0x2a1, 0x2a4, 0x2a7, 0x2aa, 0x2ad, 0x2b0, 0xffff, 0xffff,
    0x2b3, 0x2b6, 0x2b9, 0x2bc, 0x2bf, 0x2c2, 0x2c5, 0x2c8,

    0x2cb, 0x2ce, 0x2d1, 0x2d4, 0x2d7, 0x2da, 0x2dd, 0x2e0,
    0x2e3, 0x2e6, 0x2e9, 0x2ec, 0x2ef, 0x2f2, 0x2f5, 0x2f8,

    0x2fb, 0x2fe, 0x301, 0x304, 0x307, 0x30a, 0x30d, 0x310,
    0x313, 0x316, 0x319, 0x31c, 0xffff, 0xffff, 0x31f, 0x322,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x325, 0x328,
    0x32b, 0x32e, 0x331, 0x334, 0x337, 0x33a, 0x33d, 0x340,

    0x343, 0x346, 0x349, 0x34c, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x34f, 0x351, 0x353, 0x355, 0x357, 0x359, 0x35b, 0x35d,
    0x35f, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x361, 0x364, 0x367, 0x36a, 0x36d, 0x370, 0xffff, 0xffff,

    0x373, 0x375, 0x377, 0x379, 0x37b, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x37d, 0x37f, 0xffff, 0x381, 0x383, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x386, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x388, 0xffff, 0xffff, 0xffff, 0x38b, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x38d, 0x390, 0x393, 0x396,
    0x398, 0x39b, 0x39e, 0xffff, 0x3a1, 0xffff, 0x3a4, 0x3a7,

    0x3aa, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x3ad, 0x3b0, 0x3b3, 0x3b6, 0x3b9, 0x3bc,

    0x3bf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x3c2, 0x3c5, 0x3c8, 0x3cb, 0x3ce, 0xffff,

    0x3d1, 0x3d3, 0x3d5, 0x3d7, 0x3da, 0x3dd, 0x3df, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x3e1, 0x3e3, 0x3e5, 0xffff, 0x3e7, 0x3e9, 0xffff, 0xffff,
    0xffff, 0x3eb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x3ed, 0x3f0, 0xffff, 0x3f3, 0xffff, 0xffff, 0xffff, 0x3f6,
    0xffff, 0xffff, 0xffff, 0xffff, 0x3f9, 0x3fc, 0x3ff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x402, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x405, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x408, 0x40b, 0xffff, 0x40e, 0xffff, 0xffff, 0xffff, 0x411,
    0xffff, 0xffff, 0xffff, 0xffff, 0x414, 0x417, 0x41a, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x41d, 0x420,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0x423, 0x426, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x429, 0x42c, 0x42f, 0x432, 0xffff, 0xffff, 0x435, 0x438,
    0xffff, 0xffff, 0x43b, 0x43e, 0x441, 0x444, 0x447, 0x44a,

    0xffff, 0xffff, 0x44d, 0x450, 0x453, 0x456, 0x459, 0x45c,
    0xffff, 0xffff, 0x45f, 0x462, 0x465, 0x468, 0x46b, 0x46e,

    0x471, 0x474, 0x477, 0x47a, 0x47d, 0x480, 0xffff, 0xffff,
    0x483, 0x486, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x489,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0x48c, 0x48f, 0x492, 0x495, 0x498, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x49b, 0x49e, 0x4a1,
    0x4a4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x4a7, 0xffff, 0x4aa, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x4ad, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x4b0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0x4b3, 0xffff, 0xffff, 0x4b6, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x4b9, 0x4bc, 0x4bf, 0x4c2, 0x4c5, 0x4c8, 0x4cb, 0x4ce,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x4d1, 0x4d4, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x4d7, 0x4da, 0xffff, 0x4dd,

    0xffff, 0xffff, 0xffff, 0x4e0, 0xffff, 0xffff, 0x4e3, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x4e6, 0x4e9, 0x4ec, 0xffff, 0xffff, 0x4ef, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x4f2, 0xffff, 0xffff, 0x4f5, 0x4f8, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x4fb, 0x4fe, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x501, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x504, 0x507, 0x50a, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x50d, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x510, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x513,
    0x516, 0xffff, 0x519, 0x51c, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x51f, 0x522, 0x525, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x528, 0xffff, 0x52b, 0x52e, 0x531, 0xffff,

    0xffff, 0xffff, 0xffff, 0x534, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x537, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x53a, 0x53d, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x540, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x542, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x545, 0xffff, 0xffff,

    0xffff, 0xffff, 0x548, 0xffff, 0xffff, 0xffff, 0xffff, 0x54b,
    0xffff, 0xffff, 0xffff, 0xffff, 0x54e, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x551, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x554, 0xffff, 0x557, 0x55a, 0x55d,
    0x560, 0x563, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0x566, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x569, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x56c, 0xffff, 0xffff,

    0xffff, 0xffff, 0x56f, 0xffff, 0xffff, 0xffff, 0xffff, 0x572,
    0xffff, 0xffff, 0xffff, 0xffff, 0x575, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x578, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x57b, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x57e, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x580, 0xffff,
    0x583, 0xffff, 0x586, 0xffff, 0x589, 0xffff, 0x58c, 0xffff,

    0xffff, 0xffff, 0x58f, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x592, 0xffff, 0x595, 0xffff, 0xffff,

    0x598, 0x59b, 0xffff, 0x59e, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x5a1, 0x5a3, 0x5a5, 0xffff,

    0x5a7, 0x5a9, 0x5ab, 0x5ad, 0x5af, 0x5b1, 0x5b3, 0x5b5,
    0x5b7, 0x5b9, 0x5bb, 0xffff, 0x5bd, 0x5bf, 0x5c1, 0x5c3,

    0x5c5, 0x5c7, 0x5c9, 0x5cb, 0x5cd, 0x5cf, 0x5d1, 0x5d3,
    0x5d5, 0x5d7, 0x5d9, 0x5db, 0x5dd, 0x5df, 0xffff, 0x5e1,

    0x5e3, 0x5e5, 0x5e7, 0x5e9, 0x5eb, 0x5ed, 0x5ef, 0x5f1,
    0x5f3, 0x5f5, 0x5f7, 0x5f9, 0x5fb, 0x5fd, 0x5ff, 0x601,

    0x603, 0x605, 0x607, 0x609, 0x60b, 0x60d, 0x60f, 0x611,
    0x613, 0x615, 0x617, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x619, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x61b, 0x61d, 0x61f, 0x621, 0x623,

    0x625, 0x627, 0x629, 0x62b, 0x62d, 0x62f, 0x631, 0x633,
    0x635, 0x637, 0x639, 0x63b, 0x63d, 0x63f, 0x641, 0x643,

    0x645, 0x647, 0x649, 0x64b, 0x64d, 0x64f, 0x651, 0x653,
    0x655, 0x657, 0x659, 0x65b, 0x65d, 0x65f, 0x661, 0x663,

    0x665, 0x668, 0x66b, 0x66e, 0x671, 0x674, 0x677, 0x67a,
    0x67d, 0x680, 0x683, 0x686, 0x689, 0x68c, 0x68f, 0x692,

    0x695, 0x698, 0x69b, 0x69e, 0x6a1, 0x6a4, 0x6a7, 0x6aa,
    0x6ad, 0x6b0, 0x6b3, 0x6b6, 0x6b9, 0x6bc, 0x6bf, 0x6c2,

    0x6c5, 0x6c8, 0x6cb, 0x6ce, 0x6d1, 0x6d4, 0x6d7, 0x6da,
    0x6dd, 0x6e0, 0x6e3, 0x6e6, 0x6e9, 0x6ec, 0x6ef, 0x6f2,

    0x6f5, 0x6f8, 0x6fb, 0x6fe, 0x701, 0x704, 0x707, 0x70a,
    0x70d, 0x710, 0x713, 0x716, 0x719, 0x71c, 0x71f, 0x722,

    0x725, 0x728, 0x72b, 0x72e, 0x731, 0x734, 0x737, 0x73a,
    0x73d, 0x740, 0x743, 0x746, 0x749, 0x74c, 0x74f, 0x752,

    0x755, 0x758, 0x75b, 0x75e, 0x761, 0x764, 0x767, 0x76a,
    0x76d, 0x770, 0x773, 0x776, 0x779, 0x77c, 0x77f, 0x782,

    0x785, 0x788, 0x78b, 0x78e, 0x791, 0x794, 0x797, 0x79a,
    0x79d, 0x7a0, 0x7a3, 0x7a6, 0x7a9, 0x7ac, 0x7af, 0x7b2,

    0x7b5, 0x7b8, 0x7bb, 0x7be, 0x7c1, 0x7c4, 0x7c7, 0x7ca,
    0x7cd, 0x7d0, 0x7d3, 0x7d6, 0x7d9, 0x7dc, 0x7df, 0x7e2,

    0x7e5, 0x7e8, 0x7eb, 0x7ee, 0x7f1, 0x7f4, 0x7f7, 0x7fa,
    0x7fd, 0x800, 0x803, 0x806, 0x809, 0x80c, 0x80f, 0x812,

    0x815, 0x818, 0x81b, 0x81e, 0x821, 0x824, 0x827, 0x82a,
    0x82d, 0x830, 0x833, 0x836, 0xffff, 0xffff, 0xffff, 0xffff,

    0x839, 0x83c, 0x83f, 0x842, 0x845, 0x848, 0x84b, 0x84e,
    0x851, 0x854, 0x857, 0x85a, 0x85d, 0x860, 0x863, 0x866,

    0x869, 0x86c, 0x86f, 0x872, 0x875, 0x878, 0x87b, 0x87e,
    0x881, 0x884, 0x887, 0x88a, 0x88d, 0x890, 0x893, 0x896,

    0x899, 0x89c, 0x89f, 0x8a2, 0x8a5, 0x8a8, 0x8ab, 0x8ae,
    0x8b1, 0x8b4, 0x8b7, 0x8ba, 0x8bd, 0x8c0, 0x8c3, 0x8c6,

    0x8c9, 0x8cc, 0x8cf, 0x8d2, 0x8d5, 0x8d8, 0x8db, 0x8de,
    0x8e1, 0x8e4, 0x8e7, 0x8ea, 0x8ed, 0x8f0, 0x8f3, 0x8f6,

    0x8f9, 0x8fc, 0x8ff, 0x902, 0x905, 0x908, 0x90b, 0x90e,
    0x911, 0x914, 0x917, 0x91a, 0x91d, 0x920, 0x923, 0x926,

    0x929, 0x92c, 0x92f, 0x932, 0x935, 0x938, 0x93b, 0x93e,
    0x941, 0x944, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x947, 0x94a, 0x94d, 0x950, 0x953, 0x956, 0x959, 0x95c,
    0x95f, 0x962, 0x965, 0x968, 0x96b, 0x96e, 0x971, 0x974,

    0x977, 0x97a, 0x97d, 0x980, 0x983, 0x986, 0xffff, 0xffff,
    0x989, 0x98c, 0x98f, 0x992, 0x995, 0x998, 0xffff, 0xffff,

    0x99b, 0x99e, 0x9a1, 0x9a4, 0x9a7, 0x9aa, 0x9ad, 0x9b0,
    0x9b3, 0x9b6, 0x9b9, 0x9bc, 0x9bf, 0x9c2, 0x9c5, 0x9c8,

    0x9cb, 0x9ce, 0x9d1, 0x9d4, 0x9d7, 0x9da, 0x9dd, 0x9e0,
    0x9e3, 0x9e6, 0x9e9, 0x9ec, 0x9ef, 0x9f2, 0x9f5, 0x9f8,

    0x9fb, 0x9fe, 0xa01, 0xa04, 0xa07, 0xa0a, 0xffff, 0xffff,
    0xa0d, 0xa10, 0xa13, 0xa16, 0xa19, 0xa1c, 0xffff, 0xffff,

    0xa1f, 0xa22, 0xa25, 0xa28, 0xa2b, 0xa2e, 0xa31, 0xa34,
    0xffff, 0xa37, 0xffff, 0xa3a, 0xffff, 0xa3d, 0xffff, 0xa40,

    0xa43, 0xa46, 0xa49, 0xa4c, 0xa4f, 0xa52, 0xa55, 0xa58,
    0xa5b, 0xa5e, 0xa61, 0xa64, 0xa67, 0xa6a, 0xa6d, 0xa70,

    0xa73, 0xa76, 0xa78, 0xa7b, 0xa7d, 0xa80, 0xa82, 0xa85,
    0xa87, 0xa8a, 0xa8c, 0xa8f, 0xa91, 0xa94, 0xffff, 0xffff,

    0xa96, 0xa99, 0xa9c, 0xa9f, 0xaa2, 0xaa5, 0xaa8, 0xaab,
    0xaae, 0xab1, 0xab4, 0xab7, 0xaba, 0xabd, 0xac0, 0xac3,

    0xac6, 0xac9, 0xacc, 0xacf, 0xad2, 0xad5, 0xad8, 0xadb,
    0xade, 0xae1, 0xae4, 0xae7, 0xaea, 0xaed, 0xaf0, 0xaf3,

    0xaf6, 0xaf9, 0xafc, 0xaff, 0xb02, 0xb05, 0xb08, 0xb0b,
    0xb0e, 0xb11, 0xb14, 0xb17, 0xb1a, 0xb1d, 0xb20, 0xb23,

    0xb26, 0xb29, 0xb2c, 0xb2f, 0xb32, 0xffff, 0xb35, 0xb38,
    0xb3b, 0xb3e, 0xb41, 0xb44, 0xb46, 0xb49, 0xb4c, 0xb4e,

    0xb51, 0xb54, 0xb57, 0xb5a, 0xb5d, 0xffff, 0xb60, 0xb63,
    0xb66, 0xb69, 0xb6b, 0xb6e, 0xb70, 0xb73, 0xb76, 0xb79,

    0xb7c, 0xb7f, 0xb82, 0xb85, 0xffff, 0xffff, 0xb87, 0xb8a,
    0xb8d, 0xb90, 0xb93, 0xb96, 0xffff, 0xb98, 0xb9b, 0xb9e,

    0xba1, 0xba4, 0xba7, 0xbaa, 0xbac, 0xbaf, 0xbb2, 0xbb5,
    0xbb8, 0xbbb, 0xbbe, 0xbc1, 0xbc3, 0xbc6, 0xbc9, 0xbcb,

    0xffff, 0xffff, 0xbcd, 0xbd0, 0xbd3, 0xffff, 0xbd6, 0xbd9,
    0xbdc, 0xbdf, 0xbe1, 0xbe4, 0xbe6, 0xbe9, 0xbeb, 0xffff,

    0xbee, 0xbf0, 0xbf2, 0xbf4, 0xbf6, 0xbf8, 0xbfa, 0xbfc,
    0xbfe, 0xc00, 0xc02, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xc04, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc06,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xc09, 0xc0b, 0xc0e, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc12,

    0xffff, 0xffff, 0xffff, 0xc14, 0xc17, 0xffff, 0xc1b, 0xc1e,
    0xffff, 0xffff, 0xffff, 0xffff, 0xc22, 0xffff, 0xc25, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc28,
    0xc2b, 0xc2e, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc31,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc36,

    0xc38, 0xc3a, 0xffff, 0xffff, 0xc3c, 0xc3e, 0xc40, 0xc42,
    0xc44, 0xc46, 0xc48, 0xc4a, 0xc4c, 0xc4e, 0xc50, 0xc52,

    0xc54, 0xc56, 0xc58, 0xc5a, 0xc5c, 0xc5e, 0xc60, 0xc62,
    0xc64, 0xc66, 0xc68, 0xc6a, 0xc6c, 0xc6e, 0xc70, 0xffff,

    0xc72, 0xc74, 0xc76, 0xc78, 0xc7a, 0xc7c, 0xc7e, 0xc80,
    0xc82, 0xc84, 0xc86, 0xc88, 0xc8a, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xc8c, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xc8f, 0xc93, 0xc97, 0xc99, 0xffff, 0xc9c, 0xca0, 0xca4,
    0xffff, 0xca6, 0xca9, 0xcab, 0xcad, 0xcaf, 0xcb1, 0xcb3,

    0xcb5, 0xcb7, 0xcb9, 0xcbb, 0xffff, 0xcbd, 0xcbf, 0xffff,
    0xffff, 0xcc2, 0xcc4, 0xcc6, 0xcc8, 0xcca, 0xffff, 0xffff,

    0xccc, 0xccf, 0xcd3, 0xffff, 0xcd6, 0xffff, 0xcd8, 0xffff,
    0xcda, 0xffff, 0xcdc, 0xcde, 0xce0, 0xce2, 0xffff, 0xce4,

    0xce6, 0xce8, 0xffff, 0xcea, 0xcec, 0xcee, 0xcf0, 0xcf2,
    0xcf4, 0xcf6, 0xffff, 0xcf8, 0xcfc, 0xcfe, 0xd00, 0xd02,

    0xd04, 0xffff, 0xffff, 0xffff, 0xffff, 0xd06, 0xd08, 0xd0a,
    0xd0c, 0xd0e, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xd10, 0xd14, 0xd18, 0xd1d, 0xd21, 0xd25, 0xd29, 0xd2d,
    0xd31, 0xd35, 0xd39, 0xd3d, 0xd41, 0xd45, 0xd49, 0xd4d,

    0xd50, 0xd52, 0xd55, 0xd59, 0xd5c, 0xd5e, 0xd61, 0xd65,
    0xd6a, 0xd6d, 0xd6f, 0xd72, 0xd76, 0xd78, 0xd7a, 0xd7c,

    0xd7e, 0xd80, 0xd83, 0xd87, 0xd8a, 0xd8c, 0xd8f, 0xd93,
    0xd98, 0xd9b, 0xd9d, 0xda0, 0xda4, 0xda6, 0xda8, 0xdaa,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xdac, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xdb0, 0xdb3, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdb6, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdb9, 0xdbc, 0xdbf,

    0xffff, 0xffff, 0xffff, 0xffff, 0xdc2, 0xffff, 0xffff, 0xffff,
    0xffff, 0xdc5, 0xffff, 0xffff, 0xdc8, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xdcb, 0xffff, 0xdce, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xdd1, 0xdd4, 0xffff, 0xdd8,

    0xddb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xddf, 0xffff, 0xffff, 0xde2, 0xffff, 0xffff, 0xde5,
    0xffff, 0xde8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xdeb, 0xffff, 0xdee, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdf1, 0xdf4, 0xdf7,

    0xdfa, 0xdfd, 0xffff, 0xffff, 0xe00, 0xe03, 0xffff, 0xffff,
    0xe06, 0xe09, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xe0c, 0xe0f, 0xffff, 0xffff, 0xe12, 0xe15, 0xffff, 0xffff,
    0xe18, 0xe1b, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xe1e, 0xe21, 0xe24, 0xe27,

    0xe2a, 0xe2d, 0xe30, 0xe33, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xe36, 0xe39, 0xe3c, 0xe3f, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xe42, 0xe44, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xe46, 0xe48, 0xe4a, 0xe4c, 0xe4e, 0xe50, 0xe52, 0xe54,
    0xe56, 0xe58, 0xe5b, 0xe5e, 0xe61, 0xe64, 0xe67, 0xe6a,

    0xe6d, 0xe70, 0xe73, 0xe76, 0xe79, 0xe7d, 0xe81, 0xe85,
    0xe89, 0xe8d, 0xe91, 0xe95, 0xe99, 0xe9d, 0xea2, 0xea7,

    0xeac, 0xeb1, 0xeb6, 0xebb, 0xec0, 0xec5, 0xeca, 0xecf,
    0xed4, 0xed7, 0xeda, 0xedd, 0xee0, 0xee3, 0xee6, 0xee9,

    0xeec, 0xeef, 0xef3, 0xef7, 0xefb, 0xeff, 0xf03, 0xf07,
    0xf0b, 0xf0f, 0xf13, 0xf17, 0xf1b, 0xf1f, 0xf23, 0xf27,

    0xf2b, 0xf2f, 0xf33, 0xf37, 0xf3b, 0xf3f, 0xf43, 0xf47,
    0xf4b, 0xf4f, 0xf53, 0xf57, 0xf5b, 0xf5f, 0xf63, 0xf67,

    0xf6b, 0xf6f, 0xf73, 0xf77, 0xf7b, 0xf7f, 0xf83, 0xf85,
    0xf87, 0xf89, 0xf8b, 0xf8d, 0xf8f, 0xf91, 0xf93, 0xf95,

    0xf97, 0xf99, 0xf9b, 0xf9d, 0xf9f, 0xfa1, 0xfa3, 0xfa5,
    0xfa7, 0xfa9, 0xfab, 0xfad, 0xfaf, 0xfb1, 0xfb3, 0xfb5,

    0xfb7, 0xfb9, 0xfbb, 0xfbd, 0xfbf, 0xfc1, 0xfc3, 0xfc5,
    0xfc7, 0xfc9, 0xfcb, 0xfcd, 0xfcf, 0xfd1, 0xfd3, 0xfd5,

    0xfd7, 0xfd9, 0xfdb, 0xfdd, 0xfdf, 0xfe1, 0xfe3, 0xfe5,
    0xfe7, 0xfe9, 0xfeb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xfed, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xff2, 0xff6, 0xff9, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffd, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x1000, 0x1002, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x1004,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x1006,

    0xffff, 0xffff, 0xffff, 0x1008, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x100a, 0x100c, 0x100e, 0x1010, 0x1012, 0x1014, 0x1016, 0x1018,
    0x101a, 0x101c, 0x101e, 0x1020, 0x1022, 0x1024, 0x1026, 0x1028,

    0x102a, 0x102c, 0x102e, 0x1030, 0x1032, 0x1034, 0x1036, 0x1038,
    0x103a, 0x103c, 0x103e, 0x1040, 0x1042, 0x1044, 0x1046, 0x1048,

    0x104a, 0x104c, 0x104e, 0x1050, 0x1052, 0x1054, 0x1056, 0x1058,
    0x105a, 0x105c, 0x105e, 0x1060, 0x1062, 0x1064, 0x1066, 0x1068,

    0x106a, 0x106c, 0x106e, 0x1070, 0x1072, 0x1074, 0x1076, 0x1078,
    0x107a, 0x107c, 0x107e, 0x1080, 0x1082, 0x1084, 0x1086, 0x1088,

    0x108a, 0x108c, 0x108e, 0x1090, 0x1092, 0x1094, 0x1096, 0x1098,
    0x109a, 0x109c, 0x109e, 0x10a0, 0x10a2, 0x10a4, 0x10a6, 0x10a8,

    0x10aa, 0x10ac, 0x10ae, 0x10b0, 0x10b2, 0x10b4, 0x10b6, 0x10b8,
    0x10ba, 0x10bc, 0x10be, 0x10c0, 0x10c2, 0x10c4, 0x10c6, 0x10c8,

    0x10ca, 0x10cc, 0x10ce, 0x10d0, 0x10d2, 0x10d4, 0x10d6, 0x10d8,
    0x10da, 0x10dc, 0x10de, 0x10e0, 0x10e2, 0x10e4, 0x10e6, 0x10e8,

    0x10ea, 0x10ec, 0x10ee, 0x10f0, 0x10f2, 0x10f4, 0x10f6, 0x10f8,
    0x10fa, 0x10fc, 0x10fe, 0x1100, 0x1102, 0x1104, 0x1106, 0x1108,

    0x110a, 0x110c, 0x110e, 0x1110, 0x1112, 0x1114, 0x1116, 0x1118,
    0x111a, 0x111c, 0x111e, 0x1120, 0x1122, 0x1124, 0x1126, 0x1128,

    0x112a, 0x112c, 0x112e, 0x1130, 0x1132, 0x1134, 0x1136, 0x1138,
    0x113a, 0x113c, 0x113e, 0x1140, 0x1142, 0x1144, 0x1146, 0x1148,

    0x114a, 0x114c, 0x114e, 0x1150, 0x1152, 0x1154, 0x1156, 0x1158,
    0x115a, 0x115c, 0x115e, 0x1160, 0x1162, 0x1164, 0x1166, 0x1168,

    0x116a, 0x116c, 0x116e, 0x1170, 0x1172, 0x1174, 0x1176, 0x1178,
    0x117a, 0x117c, 0x117e, 0x1180, 0x1182, 0x1184, 0x1186, 0x1188,

    0x118a, 0x118c, 0x118e, 0x1190, 0x1192, 0x1194, 0x1196, 0x1198,
    0x119a, 0x119c, 0x119e, 0x11a0, 0x11a2, 0x11a4, 0x11a6, 0x11a8,

    0x11aa, 0x11ac, 0x11ae, 0x11b0, 0x11b2, 0x11b4, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x11b6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x11b8, 0xffff,
    0x11ba, 0x11bc, 0x11be, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x11c0, 0xffff, 0x11c3, 0xffff,

    0x11c6, 0xffff, 0x11c9, 0xffff, 0x11cc, 0xffff, 0x11cf, 0xffff,
    0x11d2, 0xffff, 0x11d5, 0xffff, 0x11d8, 0xffff, 0x11db, 0xffff,

    0x11de, 0xffff, 0x11e1, 0xffff, 0xffff, 0x11e4, 0xffff, 0x11e7,
    0xffff, 0x11ea, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x11ed, 0x11f0, 0xffff, 0x11f3, 0x11f6, 0xffff, 0x11f9, 0x11fc,
    0xffff, 0x11ff, 0x1202, 0xffff, 0x1205, 0x1208, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x120b, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x120e, 0x1211, 0xffff, 0x1214, 0x1217,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x121a, 0xffff, 0x121d, 0xffff,

    0x1220, 0xffff, 0x1223, 0xffff, 0x1226, 0xffff, 0x1229, 0xffff,
    0x122c, 0xffff, 0x122f, 0xffff, 0x1232, 0xffff, 0x1235, 0xffff,

    0x1238, 0xffff, 0x123b, 0xffff, 0xffff, 0x123e, 0xffff, 0x1241,
    0xffff, 0x1244, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x1247, 0x124a, 0xffff, 0x124d, 0x1250, 0xffff, 0x1253, 0x1256,
    0xffff, 0x1259, 0x125c, 0xffff, 0x125f, 0x1262, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x1265, 0xffff, 0xffff, 0x1268,
    0x126b, 0x126e, 0x1271, 0xffff, 0xffff, 0xffff, 0x1274, 0x1277,

    0xffff, 0x127a, 0x127c, 0x127e, 0x1280, 0x1282, 0x1284, 0x1286,
    0x1288, 0x128a, 0x128c, 0x128e, 0x1290, 0x1292, 0x1294, 0x1296,

    0x1298, 0x129a, 0x129c, 0x129e, 0x12a0, 0x12a2, 0x12a4, 0x12a6,
    0x12a8, 0x12aa, 0x12ac, 0x12ae, 0x12b0, 0x12b2, 0x12b4, 0x12b6,

    0x12b8, 0x12ba, 0x12bc, 0x12be, 0x12c0, 0x12c2, 0x12c4, 0x12c6,
    0x12c8, 0x12ca, 0x12cc, 0x12ce, 0x12d0, 0x12d2, 0x12d4, 0x12d6,

    0x12d8, 0x12da, 0x12dc, 0x12de, 0x12e0, 0x12e2, 0x12e4, 0x12e6,
    0x12e8, 0x12ea, 0x12ec, 0x12ee, 0x12f0, 0x12f2, 0x12f4, 0x12f6,

    0x12f8, 0x12fa, 0x12fc, 0x12fe, 0x1300, 0x1302, 0x1304, 0x1306,
    0x1308, 0x130a, 0x130c, 0x130e, 0x1310, 0x1312, 0x1314, 0x1316,

    0x1318, 0x131a, 0x131c, 0x131e, 0x1320, 0x1322, 0x1324, 0x1326,
    0x1328, 0x132a, 0x132c, 0x132e, 0x1330, 0x1332, 0x1334, 0xffff,

    0xffff, 0xffff, 0x1336, 0x1338, 0x133a, 0x133c, 0x133e, 0x1340,
    0x1342, 0x1344, 0x1346, 0x1348, 0x134a, 0x134c, 0x134e, 0x1350,

    0x1352, 0x1356, 0x135a, 0x135e, 0x1362, 0x1366, 0x136a, 0x136e,
    0x1372, 0x1376, 0x137a, 0x137e, 0x1382, 0x1386, 0x138a, 0x138f,

    0x1394, 0x1399, 0x139e, 0x13a3, 0x13a8, 0x13ad, 0x13b2, 0x13b7,
    0x13bc, 0x13c1, 0x13c6, 0x13cb, 0x13d0, 0x13d5, 0x13dd, 0xffff,

    0x13e4, 0x13e8, 0x13ec, 0x13f0, 0x13f4, 0x13f8, 0x13fc, 0x1400,
    0x1404, 0x1408, 0x140c, 0x1410, 0x1414, 0x1418, 0x141c, 0x1420,

    0x1424, 0x1428, 0x142c, 0x1430, 0x1434, 0x1438, 0x143c, 0x1440,
    0x1444, 0x1448, 0x144c, 0x1450, 0x1454, 0x1458, 0x145c, 0x1460,

    0x1464, 0x1468, 0x146c, 0x1470, 0x1474, 0x1476, 0x1478, 0x147a,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x147c, 0x1480, 0x1483, 0x1486, 0x1489, 0x148c, 0x148f, 0x1492,
    0x1495, 0x1498, 0x149b, 0x149e, 0x14a1, 0x14a4, 0x14a7, 0x14aa,

    0x14ad, 0x14af, 0x14b1, 0x14b3, 0x14b5, 0x14b7, 0x14b9, 0x14bb,
    0x14bd, 0x14bf, 0x14c1, 0x14c3, 0x14c5, 0x14c7, 0x14c9, 0x14cc,

    0x14cf, 0x14d2, 0x14d5, 0x14d8, 0x14db, 0x14de, 0x14e1, 0x14e4,
    0x14e7, 0x14ea, 0x14ed, 0x14f0, 0x14f3, 0x14f9, 0x14fe, 0xffff,

    0x1501, 0x1503, 0x1505, 0x1507, 0x1509, 0x150b, 0x150d, 0x150f,
    0x1511, 0x1513, 0x1515, 0x1517, 0x1519, 0x151b, 0x151d, 0x151f,

    0x1521, 0x1523, 0x1525, 0x1527, 0x1529, 0x152b, 0x152d, 0x152f,
    0x1531, 0x1533, 0x1535, 0x1537, 0x1539, 0x153b, 0x153d, 0x153f,

    0x1541, 0x1543, 0x1545, 0x1547, 0x1549, 0x154b, 0x154d, 0x154f,
    0x1551, 0x1553, 0x1555, 0x1557, 0x1559, 0x155b, 0x155d, 0x155f,

    0x1561, 0x1563, 0x1566, 0x1569, 0x156c, 0x156f, 0x1572, 0x1575,
    0x1578, 0x157b, 0x157e, 0x1581, 0x1584, 0x1587, 0x158a, 0x158d,

    0x1590, 0x1593, 0x1596, 0x1599, 0x159c, 0x159f, 0x15a2, 0x15a5,
    0x15a8, 0x15ab, 0x15af, 0x15b3, 0x15b7, 0x15ba, 0x15be, 0x15c1,

    0x15c5, 0x15c7, 0x15c9, 0x15cb, 0x15cd, 0x15cf, 0x15d1, 0x15d3,
    0x15d5, 0x15d7, 0x15d9, 0x15db, 0x15dd, 0x15df, 0x15e1, 0x15e3,

    0x15e5, 0x15e7, 0x15e9, 0x15eb, 0x15ed, 0x15ef, 0x15f1, 0x15f3,
    0x15f5, 0x15f7, 0x15f9, 0x15fb, 0x15fd, 0x15ff, 0x1601, 0x1603,

    0x1605, 0x1607, 0x1609, 0x160b, 0x160d, 0x160f, 0x1611, 0x1613,
    0x1615, 0x1617, 0x1619, 0x161b, 0x161d, 0x161f, 0x1621, 0x1623,

    0x1626, 0x162b, 0x1630, 0x1635, 0x1639, 0x163e, 0x1642, 0x1646,
    0x164c, 0x1651, 0x1655, 0x1659, 0x165d, 0x1662, 0x1667, 0x166b,

    0x166f, 0x1672, 0x1676, 0x167b, 0x1680, 0x1683, 0x1689, 0x1690,
    0x1696, 0x169a, 0x16a0, 0x16a6, 0x16ab, 0x16af, 0x16b3, 0x16b7,

    0x16bc, 0x16c2, 0x16c7, 0x16cb, 0x16cf, 0x16d3, 0x16d6, 0x16d9,
    0x16dc, 0x16df, 0x16e3, 0x16e7, 0x16ed, 0x16f1, 0x16f6, 0x16fc,

    0x1700, 0x1703, 0x1706, 0x170c, 0x1711, 0x1717, 0x171b, 0x1721,
    0x1724, 0x1728, 0x172c, 0x1730, 0x1734, 0x1738, 0x173d, 0x1741,

    0x1744, 0x1748, 0x174c, 0x1750, 0x1755, 0x1759, 0x175d, 0x1761,
    0x1767, 0x176c, 0x176f, 0x1775, 0x1778, 0x177d, 0x1782, 0x1786,

    0x178a, 0x178e, 0x1793, 0x1796, 0x179a, 0x179f, 0x17a2, 0x17a8,
    0x17ac, 0x17af, 0x17b2, 0x17b5, 0x17b8, 0x17bb, 0x17be, 0x17c1,

    0x17c4, 0x17c7, 0x17ca, 0x17ce, 0x17d2, 0x17d6, 0x17da, 0x17de,
    0x17e2, 0x17e6, 0x17ea, 0x17ee, 0x17f2, 0x17f6, 0x17fa, 0x17fe,

    0x1802, 0x1806, 0x180a, 0x180d, 0x1810, 0x1814, 0x1817, 0x181a,
    0x181d, 0x1821, 0x1825, 0x1828, 0x182b, 0x182e, 0x1831, 0x1834,

    0x1839, 0x183c, 0x183f, 0x1842, 0x1845, 0x1848, 0x184b, 0x184e,
    0x1851, 0x1855, 0x185a, 0x185d, 0x1860, 0x1863, 0x1866, 0x1869,

    0x186c, 0x186f, 0x1873, 0x1877, 0x187b, 0x187f, 0x1882, 0x1885,
    0x1888, 0x188b, 0x188e, 0x1891, 0x1894, 0x1897, 0x189a, 0x189d,

    0x18a1, 0x18a5, 0x18a8, 0x18ac, 0x18b0, 0x18b4, 0x18b7, 0x18bb,
    0x18bf, 0x18c4, 0x18c7, 0x18cb, 0x18cf, 0x18d3, 0x18d7, 0x18dd,

    0x18e4, 0x18e7, 0x18ea, 0x18ed, 0x18f0, 0x18f3, 0x18f6, 0x18f9,
    0x18fc, 0x18ff, 0x1902, 0x1905, 0x1908, 0x190b, 0x190e, 0x1911,

    0x1914, 0x1917, 0x191a, 0x191f, 0x1922, 0x1925, 0x1928, 0x192d,
    0x1931, 0x1934, 0x1937, 0x193a, 0x193d, 0x1940, 0x1943, 0x1946,

    0x1949, 0x194c, 0x194f, 0x1953, 0x1956, 0x1959, 0x195d, 0x1961,
    0x1964, 0x1969, 0x196d, 0x1970, 0x1973, 0x1976, 0x1979, 0x197d,

    0x1981, 0x1984, 0x1987, 0x198a, 0x198d, 0x1990, 0x1993, 0x1996,
    0x1999, 0x199c, 0x19a0, 0x19a4, 0x19a8, 0x19ac, 0x19b0, 0x19b4,

    0x19b8, 0x19bc, 0x19c0, 0x19c4, 0x19c8, 0x19cc, 0x19d0, 0x19d4,
    0x19d8, 0x19dc, 0x19e0, 0x19e4, 0x19e8, 0x19ec, 0x19f0, 0x19f4,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x19f8, 0x19fa, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x19fc, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x19fe, 0x1a00, 0x1a02, 0xffff, 0xffff, 0xffff,
    0x1a04, 0x1a06, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x1a08, 0x1a0a, 0x1a0c, 0x1a0e,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x1a10, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x1a12, 0x1a14, 0x1a16, 0x1a18, 0x1a1a, 0x1a1c, 0x1a1e, 0x1a20,
    0x1a22, 0x1a24, 0x1a26, 0x1a28, 0x1a2a, 0x1a2c, 0x1a2e, 0x1a30,
    0x1a32, 0x1a34, 0x1a36, 0x1a38, 0x1a3a, 0x1a3c, 0x1a3e, 0x1a40,
    0x1a42, 0x1a44, 0x1a46, 0x1a48, 0x1a4a, 0x1a4c, 0x1a4e, 0x1a50,
    0x1a52, 0x1a54, 0x1a56, 0x1a58, 0x1a5a, 0x1a5c, 0x1a5e, 0x1a60,
    0x1a62, 0x1a64, 0x1a66, 0x1a68, 0x1a6a, 0x1a6c, 0x1a6e, 0x1a70,
    0x1a72, 0x1a74, 0x1a76, 0x1a78, 0x1a7a, 0x1a7c, 0x1a7e, 0x1a80,
    0x1a82, 0x1a84, 0x1a86, 0x1a88, 0x1a8a, 0x1a8c, 0x1a8e, 0x1a90,
    0x1a92, 0x1a94, 0x1a96, 0x1a98, 0x1a9a, 0x1a9c, 0x1a9e, 0x1aa0,
    0x1aa2, 0x1aa4, 0x1aa6, 0x1aa8, 0x1aaa, 0x1aac, 0x1aae, 0x1ab0,
    0x1ab2, 0x1ab4, 0x1ab6, 0x1ab8, 0x1aba, 0x1abc, 0x1abe, 0x1ac0,
    0x1ac2, 0x1ac4, 0x1ac6, 0x1ac8, 0x1aca, 0x1acc, 0x1ace, 0x1ad0,
    0x1ad2, 0x1ad4, 0x1ad6, 0x1ad8, 0x1ada, 0x1adc, 0x1ade, 0x1ae0,
    0x1ae2, 0x1ae4, 0x1ae6, 0x1ae8, 0x1aea, 0x1aec, 0x1aee, 0x1af0,
    0x1af2, 0x1af4, 0x1af6, 0x1af8, 0x1afa, 0x1afc, 0x1afe, 0x1b00,
    0x1b02, 0x1b04, 0x1b06, 0x1b08, 0x1b0a, 0x1b0c, 0x1b0e, 0x1b10,
    0x1b12, 0x1b14, 0x1b16, 0x1b18, 0x1b1a, 0x1b1c, 0x1b1e, 0x1b20,
    0x1b22, 0x1b24, 0x1b26, 0x1b28, 0x1b2a, 0x1b2c, 0x1b2e, 0x1b30,
    0x1b32, 0x1b34, 0x1b36, 0x1b38, 0x1b3a, 0x1b3c, 0x1b3e, 0x1b40,
    0x1b42, 0x1b44, 0x1b46, 0x1b48, 0x1b4a, 0x1b4c, 0x1b4e, 0x1b50,
    0x1b52, 0x1b54, 0x1b56, 0x1b58, 0x1b5a, 0x1b5c, 0x1b5e, 0x1b60,
    0x1b62, 0x1b64, 0x1b66, 0x1b68, 0x1b6a, 0x1b6c, 0x1b6e, 0x1b70,
    0x1b72, 0x1b74, 0x1b76, 0x1b78, 0x1b7a, 0x1b7c, 0x1b7e, 0x1b80,
    0x1b82, 0x1b84, 0x1b86, 0x1b88, 0x1b8a, 0x1b8c, 0x1b8e, 0x1b90,
    0x1b92, 0x1b94, 0x1b96, 0x1b98, 0x1b9a, 0x1b9c, 0x1b9e, 0x1ba0,
    0x1ba2, 0x1ba4, 0x1ba6, 0x1ba8, 0x1baa, 0x1bac, 0x1bae, 0x1bb0,
    0x1bb2, 0x1bb4, 0x1bb6, 0x1bb8, 0x1bba, 0x1bbc, 0x1bbe, 0x1bc0,
    0x1bc2, 0x1bc4, 0x1bc6, 0x1bc8, 0x1bca, 0x1bcc, 0x1bce, 0x1bd0,
    0x1bd2, 0x1bd4, 0x1bd6, 0x1bd8, 0x1bda, 0x1bdc, 0x1bde, 0x1be0,
    0x1be2, 0x1be4, 0x1be6, 0x1be8, 0x1bea, 0x1bec, 0x1bee, 0x1bf0,
    0x1bf2, 0x1bf4, 0x1bf6, 0x1bf8, 0x1bfa, 0x1bfc, 0x1bfe, 0x1c00,
    0x1c02, 0x1c04, 0x1c06, 0x1c08, 0x1c0a, 0x1c0c, 0x1c0e, 0x1c10,

    0x1c12, 0x1c14, 0x1c16, 0x1c18, 0x1c1a, 0x1c1c, 0x1c1e, 0x1c20,
    0x1c22, 0x1c24, 0x1c26, 0x1c28, 0x1c2a, 0x1c2c, 0xffff, 0xffff,
    0x1c2e, 0xffff, 0x1c30, 0xffff, 0xffff, 0x1c32, 0x1c34, 0x1c36,
    0x1c38, 0x1c3a, 0x1c3c, 0x1c3e, 0x1c40, 0x1c42, 0x1c44, 0xffff,
    0x1c46, 0xffff, 0x1c48, 0xffff, 0xffff, 0x1c4a, 0x1c4c, 0xffff,
    0xffff, 0xffff, 0x1c4e, 0x1c50, 0x1c52, 0x1c54, 0x1c56, 0x1c58,
    0x1c5a, 0x1c5c, 0x1c5e, 0x1c60, 0x1c62, 0x1c64, 0x1c66, 0x1c68,
    0x1c6a, 0x1c6c, 0x1c6e, 0x1c70, 0x1c72, 0x1c74, 0x1c76, 0x1c78,
    0x1c7a, 0x1c7c, 0x1c7e, 0x1c80, 0x1c82, 0x1c84, 0x1c86, 0x1c88,
    0x1c8a, 0x1c8c, 0x1c8e, 0x1c90, 0x1c92, 0x1c94, 0x1c96, 0x1c98,
    0x1c9a, 0x1c9c, 0x1c9e, 0x1ca0, 0x1ca2, 0x1ca4, 0x1ca6, 0x1ca8,
    0x1caa, 0x1cac, 0x1cae, 0x1cb0, 0x1cb2, 0x1cb4, 0x1cb6, 0x1cb8,
    0x1cba, 0x1cbc, 0x1cbe, 0x1cc0, 0x1cc2, 0x1cc4, 0x1cc6, 0x1cc8,
    0x1cca, 0x1ccc, 0x1cce, 0x1cd0, 0x1cd2, 0x1cd4, 0xffff, 0xffff,
    0x1cd6, 0x1cd8, 0x1cda, 0x1cdc, 0x1cde, 0x1ce0, 0x1ce2, 0x1ce4,
    0x1ce6, 0x1ce8, 0x1cea, 0x1cec, 0x1cee, 0x1cf0, 0x1cf2, 0x1cf4,
    0x1cf6, 0x1cf8, 0x1cfa, 0x1cfc, 0x1cfe, 0x1d00, 0x1d02, 0x1d04,
    0x1d06, 0x1d08, 0x1d0a, 0x1d0c, 0x1d0e, 0x1d10, 0x1d12, 0x1d14,
    0x1d16, 0x1d18, 0x1d1a, 0x1d1c, 0x1d1e, 0x1d20, 0x1d22, 0x1d24,
    0x1d26, 0x1d28, 0x1d2a, 0x1d2c, 0x1d2e, 0x1d30, 0x1d32, 0x1d34,
    0x1d36, 0x1d38, 0x1d3a, 0x1d3c, 0x1d3e, 0x1d40, 0x1d42, 0x1d44,
    0x1d46, 0x1d48, 0x1d4a, 0x1d4c, 0x1d4e, 0x1d50, 0x1d52, 0x1d54,
    0x1d56, 0x1d58, 0x1d5a, 0x1d5c, 0x1d5e, 0x1d60, 0x1d62, 0x1d64,
    0x1d66, 0x1d68, 0x1d6a, 0x1d6c, 0x1d6e, 0x1d70, 0x1d72, 0x1d74,
    0x1d76, 0x1d78, 0x1d7a, 0x1d7c, 0x1d7e, 0x1d80, 0x1d82, 0x1d84,
    0x1d86, 0x1d88, 0x1d8a, 0x1d8c, 0x1d8e, 0x1d90, 0x1d92, 0x1d94,
    0x1d96, 0x1d98, 0x1d9a, 0x1d9c, 0x1d9e, 0x1da0, 0x1da2, 0x1da4,
    0x1da6, 0x1da8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x1daa, 0x1dad, 0x1db0, 0x1db3, 0x1db7, 0x1dbb, 0x1dbe, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x1dc1, 0x1dc4, 0x1dc7, 0x1dca, 0x1dcd,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x1dd0, 0xffff, 0x1dd3,
    0x1dd6, 0x1dd8, 0x1dda, 0x1ddc, 0x1dde, 0x1de0, 0x1de2, 0x1de4,
    0x1de6, 0x1de8, 0x1dea, 0x1ded, 0x1df0, 0x1df3, 0x1df6, 0x1df9,
    0x1dfc, 0x1dff, 0x1e02, 0x1e05, 0x1e08, 0x1e0b, 0x1e0e, 0xffff,
    0x1e11, 0x1e14, 0x1e17, 0x1e1a, 0x1e1d, 0xffff, 0x1e20, 0xffff,
    0x1e23, 0x1e26, 0xffff, 0x1e29, 0x1e2c, 0xffff, 0x1e2f, 0x1e32,
    0x1e35, 0x1e38, 0x1e3b, 0x1e3e, 0x1e41, 0x1e44, 0x1e47, 0x1e4a,
    0x1e4d, 0x1e4f, 0x1e51, 0x1e53, 0x1e55, 0x1e57, 0x1e59, 0x1e5b,
    0x1e5d, 0x1e5f, 0x1e61, 0x1e63, 0x1e65, 0x1e67, 0x1e69, 0x1e6b,
    0x1e6d, 0x1e6f, 0x1e71, 0x1e73, 0x1e75, 0x1e77, 0x1e79, 0x1e7b,
    0x1e7d, 0x1e7f, 0x1e81, 0x1e83, 0x1e85, 0x1e87, 0x1e89, 0x1e8b,
    0x1e8d, 0x1e8f, 0x1e91, 0x1e93, 0x1e95, 0x1e97, 0x1e99, 0x1e9b,
    0x1e9d, 0x1e9f, 0x1ea1, 0x1ea3, 0x1ea5, 0x1ea7, 0x1ea9, 0x1eab,
    0x1ead, 0x1eaf, 0x1eb1, 0x1eb3, 0x1eb5, 0x1eb7, 0x1eb9, 0x1ebb,
    0x1ebd, 0x1ebf, 0x1ec1, 0x1ec3, 0x1ec5, 0x1ec7, 0x1ec9, 0x1ecb,
    0x1ecd, 0x1ecf, 0x1ed1, 0x1ed3, 0x1ed5, 0x1ed7, 0x1ed9, 0x1edb,
    0x1edd, 0x1edf, 0x1ee1, 0x1ee3, 0x1ee5, 0x1ee7, 0x1ee9, 0x1eeb,
    0x1eed, 0x1eef, 0x1ef1, 0x1ef3, 0x1ef5, 0x1ef7, 0x1ef9, 0x1efb,
    0x1efd, 0x1eff, 0x1f01, 0x1f03, 0x1f05, 0x1f07, 0x1f09, 0x1f0b,
    0x1f0d, 0x1f0f, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x1f11, 0x1f13, 0x1f15, 0x1f17, 0x1f19,
    0x1f1b, 0x1f1d, 0x1f1f, 0x1f21, 0x1f23, 0x1f25, 0x1f27, 0x1f29,
    0x1f2b, 0x1f2d, 0x1f2f, 0x1f31, 0x1f33, 0x1f35, 0x1f37, 0x1f39,
    0x1f3b, 0x1f3d, 0x1f3f, 0x1f42, 0x1f45, 0x1f48, 0x1f4b, 0x1f4e,
    0x1f51, 0x1f54, 0x1f57, 0x1f5a, 0x1f5d, 0x1f60, 0x1f63, 0x1f66,
    0x1f69, 0x1f6c, 0x1f6f, 0x1f72, 0x1f75, 0x1f77, 0x1f79, 0x1f7b,

    0x1f7d, 0x1f80, 0x1f83, 0x1f86, 0x1f89, 0x1f8c, 0x1f8f, 0x1f92,
    0x1f95, 0x1f98, 0x1f9b, 0x1f9e, 0x1fa1, 0x1fa4, 0x1fa7, 0x1faa,
    0x1fad, 0x1fb0, 0x1fb3, 0x1fb6, 0x1fb9, 0x1fbc, 0x1fbf, 0x1fc2,
    0x1fc5, 0x1fc8, 0x1fcb, 0x1fce, 0x1fd1, 0x1fd4, 0x1fd7, 0x1fda,
    0x1fdd, 0x1fe0, 0x1fe3, 0x1fe6, 0x1fe9, 0x1fec, 0x1fef, 0x1ff2,
    0x1ff5, 0x1ff8, 0x1ffb, 0x1ffe, 0x2001, 0x2004, 0x2007, 0x200a,
    0x200d, 0x2010, 0x2013, 0x2016, 0x2019, 0x201c, 0x201f, 0x2022,
    0x2025, 0x2028, 0x202b, 0x202e, 0x2031, 0x2034, 0x2037, 0x203a,
    0x203d, 0x2040, 0x2043, 0x2046, 0x2049, 0x204c, 0x204f, 0x2052,
    0x2055, 0x2058, 0x205b, 0x205e, 0x2061, 0x2064, 0x2067, 0x206a,
    0x206d, 0x2070, 0x2073, 0x2076, 0x2079, 0x207c, 0x207f, 0x2082,
    0x2085, 0x2088, 0x208b, 0x208e, 0x2091, 0x2094, 0x2097, 0x209b,
    0x209f, 0x20a3, 0x20a7, 0x20ab, 0x20af, 0x20b2, 0x20b5, 0x20b8,
    0x20bb, 0x20be, 0x20c1, 0x20c4, 0x20c7, 0x20ca, 0x20cd, 0x20d0,
    0x20d3, 0x20d6, 0x20d9, 0x20dc, 0x20df, 0x20e2, 0x20e5, 0x20e8,
    0x20eb, 0x20ee, 0x20f1, 0x20f4, 0x20f7, 0x20fa, 0x20fd, 0x2100,
    0x2103, 0x2106, 0x2109, 0x210c, 0x210f, 0x2112, 0x2115, 0x2118,
    0x211b, 0x211e, 0x2121, 0x2124, 0x2127, 0x212a, 0x212d, 0x2130,
    0x2133, 0x2136, 0x2139, 0x213c, 0x213f, 0x2142, 0x2145, 0x2148,
    0x214b, 0x214e, 0x2151, 0x2154, 0x2157, 0x215a, 0x215d, 0x2160,
    0x2163, 0x2166, 0x2169, 0x216c, 0x216f, 0x2172, 0x2175, 0x2178,
    0x217b, 0x217e, 0x2181, 0x2184, 0x2187, 0x218a, 0x218d, 0x2190,
    0x2193, 0x2196, 0x2199, 0x219c, 0x219f, 0x21a2, 0x21a5, 0x21a8,
    0x21ab, 0x21ae, 0x21b1, 0x21b4, 0x21b7, 0x21ba, 0x21bd, 0x21c0,
    0x21c3, 0x21c6, 0x21c9, 0x21cc, 0x21cf, 0x21d2, 0x21d5, 0x21d8,
    0x21db, 0x21de, 0x21e1, 0x21e4, 0x21e7, 0x21ea, 0x21ed, 0x21f0,
    0x21f3, 0x21f6, 0x21f9, 0x21fc, 0x21ff, 0x2202, 0x2205, 0x2208,
    0x220b, 0x220e, 0x2211, 0x2214, 0x2217, 0x221a, 0x221d, 0x2220,
    0x2223, 0x2226, 0x2229, 0x222c, 0x222f, 0x2232, 0x2235, 0x2238,
    0x223b, 0x223e, 0x2241, 0x2244, 0x2247, 0x224a, 0x224d, 0x2250,
    0x2253, 0x2256, 0x2259, 0x225d, 0x2261, 0x2265, 0x2268, 0x226b,
    0x226e, 0x2271, 0x2274, 0x2277, 0x227a, 0x227d, 0x2280, 0x2283,

    0x2286, 0x2289, 0x228c, 0x228f, 0x2292, 0x2295, 0x2298, 0x229b,
    0x229e, 0x22a1, 0x22a4, 0x22a7, 0x22aa, 0x22ad, 0x22b0, 0x22b3,
    0x22b6, 0x22b9, 0x22bc, 0x22bf, 0x22c2, 0x22c5, 0x22c8, 0x22cb,
    0x22ce, 0x22d1, 0x22d4, 0x22d7, 0x22da, 0x22dd, 0x22e0, 0x22e3,
    0x22e6, 0x22e9, 0x22ec, 0x22ef, 0x22f2, 0x22f5, 0x22f8, 0x22fb,
    0x22fe, 0x2301, 0x2304, 0x2307, 0x230a, 0x230d, 0x2310, 0x2313,
    0x2316, 0x2319, 0x231c, 0x231f, 0x2322, 0x2325, 0x2328, 0x232b,
    0x232e, 0x2331, 0x2334, 0x2337, 0x233a, 0x233d, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x2340, 0x2344, 0x2348, 0x234c, 0x2350, 0x2354, 0x2358, 0x235c,
    0x2360, 0x2364, 0x2368, 0x236c, 0x2370, 0x2374, 0x2378, 0x237c,
    0x2380, 0x2384, 0x2388, 0x238c, 0x2390, 0x2394, 0x2398, 0x239c,
    0x23a0, 0x23a4, 0x23a8, 0x23ac, 0x23b0, 0x23b4, 0x23b8, 0x23bc,
    0x23c0, 0x23c4, 0x23c8, 0x23cc, 0x23d0, 0x23d4, 0x23d8, 0x23dc,
    0x23e0, 0x23e4, 0x23e8, 0x23ec, 0x23f0, 0x23f4, 0x23f8, 0x23fc,
    0x2400, 0x2404, 0x2408, 0x240c, 0x2410, 0x2414, 0x2418, 0x241c,
    0x2420, 0x2424, 0x2428, 0x242c, 0x2430, 0x2434, 0x2438, 0x243c,
    0xffff, 0xffff, 0x2440, 0x2444, 0x2448, 0x244c, 0x2450, 0x2454,
    0x2458, 0x245c, 0x2460, 0x2464, 0x2468, 0x246c, 0x2470, 0x2474,
    0x2478, 0x247c, 0x2480, 0x2484, 0x2488, 0x248c, 0x2490, 0x2494,
    0x2498, 0x249c, 0x24a0, 0x24a4, 0x24a8, 0x24ac, 0x24b0, 0x24b4,
    0x24b8, 0x24bc, 0x24c0, 0x24c4, 0x24c8, 0x24cc, 0x24d0, 0x24d4,
    0x24d8, 0x24dc, 0x24e0, 0x24e4, 0x24e8, 0x24ec, 0x24f0, 0x24f4,
    0x24f8, 0x24fc, 0x2500, 0x2504, 0x2508, 0x250c, 0x2510, 0x2514,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x2518, 0x251c, 0x2520, 0x2525, 0x252a, 0x252f, 0x2534, 0x2539,
    0x253e, 0x2543, 0x2547, 0x255a, 0x2563, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x2568, 0x256a, 0x256c, 0x256e, 0x2570, 0x2572, 0x2574, 0x2576,
    0x2578, 0x257a, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x257c, 0x257e, 0x2580, 0x2582, 0x2584, 0x2586, 0x2588, 0x258a,
    0x258c, 0x258e, 0x2590, 0x2592, 0x2594, 0x2596, 0x2598, 0x259a,
    0x259c, 0x259e, 0x25a0, 0x25a2, 0x25a4, 0xffff, 0xffff, 0x25a6,
    0x25a8, 0x25aa, 0x25ac, 0x25ae, 0x25b0, 0x25b2, 0x25b4, 0x25b6,
    0x25b8, 0x25ba, 0x25bc, 0xffff, 0x25be, 0x25c0, 0x25c2, 0x25c4,
    0x25c6, 0x25c8, 0x25ca, 0x25cc, 0x25ce, 0x25d0, 0x25d2, 0x25d4,
    0x25d6, 0x25d8, 0x25da, 0x25dc, 0x25de, 0x25e0, 0x25e2, 0xffff,
    0x25e4, 0x25e6, 0x25e8, 0x25ea, 0xffff, 0xffff, 0xffff, 0xffff,
    0x25ec, 0x25ef, 0x25f2, 0xffff, 0x25f5, 0xffff, 0x25f8, 0x25fb,
    0x25fe, 0x2601, 0x2604, 0x2607, 0x260a, 0x260d, 0x2610, 0x2613,
    0x2616, 0x2618, 0x261a, 0x261c, 0x261e, 0x2620, 0x2622, 0x2624,
    0x2626, 0x2628, 0x262a, 0x262c, 0x262e, 0x2630, 0x2632, 0x2634,
    0x2636, 0x2638, 0x263a, 0x263c, 0x263e, 0x2640, 0x2642, 0x2644,
    0x2646, 0x2648, 0x264a, 0x264c, 0x264e, 0x2650, 0x2652, 0x2654,
    0x2656, 0x2658, 0x265a, 0x265c, 0x265e, 0x2660, 0x2662, 0x2664,
    0x2666, 0x2668, 0x266a, 0x266c, 0x266e, 0x2670, 0x2672, 0x2674,
    0x2676, 0x2678, 0x267a, 0x267c, 0x267e, 0x2680, 0x2682, 0x2684,
    0x2686, 0x2688, 0x268a, 0x268c, 0x268e, 0x2690, 0x2692, 0x2694,
    0x2696, 0x2698, 0x269a, 0x269c, 0x269e, 0x26a0, 0x26a2, 0x26a4,
    0x26a6, 0x26a8, 0x26aa, 0x26ac, 0x26ae, 0x26b0, 0x26b2, 0x26b4,
    0x26b6, 0x26b8, 0x26ba, 0x26bc, 0x26be, 0x26c0, 0x26c2, 0x26c4,
    0x26c6, 0x26c8, 0x26ca, 0x26cc, 0x26ce, 0x26d0, 0x26d2, 0x26d4,
    0x26d6, 0x26d8, 0x26da, 0x26dc, 0x26de, 0x26e0, 0x26e2, 0x26e4,
    0x26e6, 0x26e8, 0x26ea, 0x26ec, 0x26ee, 0x26f0, 0x26f2, 0x26f4,
    0x26f6, 0x26f8, 0x26fa, 0x26fc, 0x26fe, 0x2700, 0x2703, 0x2706,
    0x2709, 0x270c, 0x270f, 0x2712, 0x2715, 0xffff, 0xffff, 0xffff,

    0xffff, 0x2718, 0x271a, 0x271c, 0x271e, 0x2720, 0x2722, 0x2724,
    0x2726, 0x2728, 0x272a, 0x272c, 0x272e, 0x2730, 0x2732, 0x2734,
    0x2736, 0x2738, 0x273a, 0x273c, 0x273e, 0x2740, 0x2742, 0x2744,
    0x2746, 0x2748, 0x274a, 0x274c, 0x274e, 0x2750, 0x2752, 0x2754,
    0x2756, 0x2758, 0x275a, 0x275c, 0x275e, 0x2760, 0x2762, 0x2764,
    0x2766, 0x2768, 0x276a, 0x276c, 0x276e, 0x2770, 0x2772, 0x2774,
    0x2776, 0x2778, 0x277a, 0x277c, 0x277e, 0x2780, 0x2782, 0x2784,
    0x2786, 0x2788, 0x278a, 0x278c, 0x278e, 0x2790, 0x2792, 0x2794,
    0x2796, 0x2798, 0x279a, 0x279c, 0x279e, 0x27a0, 0x27a2, 0x27a4,
    0x27a6, 0x27a8, 0x27aa, 0x27ac, 0x27ae, 0x27b0, 0x27b2, 0x27b4,
    0x27b6, 0x27b8, 0x27ba, 0x27bc, 0x27be, 0x27c0, 0x27c2, 0x27c4,
    0x27c6, 0x27c8, 0x27ca, 0x27cc, 0x27ce, 0x27d0, 0x27d2, 0x27d4,
    0x27d6, 0x27d8, 0x27da, 0x27dc, 0x27de, 0x27e0, 0x27e2, 0x27e4,
    0x27e6, 0x27e8, 0x27ea, 0x27ec, 0x27ee, 0x27f0, 0x27f2, 0x27f4,
    0x27f6, 0x27f8, 0x27fa, 0x27fc, 0x27fe, 0x2800, 0x2802, 0x2804,
    0x2806, 0x2808, 0x280a, 0x280c, 0x280e, 0x2810, 0x2812, 0x2814,
    0x2816, 0x2818, 0x281a, 0x281c, 0x281e, 0x2820, 0x2822, 0x2824,
    0x2826, 0x2828, 0x282a, 0x282c, 0x282e, 0x2830, 0x2832, 0x2834,
    0x2836, 0x2838, 0x283a, 0x283c, 0x283e, 0x2840, 0x2842, 0x2844,
    0x2846, 0x2848, 0x284a, 0x284c, 0x284e, 0x2850, 0x2852, 0x2854,
    0x2856, 0x2858, 0x285a, 0x285c, 0x285e, 0x2860, 0x2862, 0x2864,
    0x2866, 0x2868, 0x286a, 0x286c, 0x286e, 0x2870, 0x2872, 0x2874,
    0x2876, 0x2878, 0x287a, 0x287c, 0x287e, 0x2880, 0x2882, 0x2884,
    0x2886, 0x2888, 0x288a, 0x288c, 0x288e, 0x2890, 0x2892, 0xffff,
    0xffff, 0xffff, 0x2894, 0x2896, 0x2898, 0x289a, 0x289c, 0x289e,
    0xffff, 0xffff, 0x28a0, 0x28a2, 0x28a4, 0x28a6, 0x28a8, 0x28aa,
    0xffff, 0xffff, 0x28ac, 0x28ae, 0x28b0, 0x28b2, 0x28b4, 0x28b6,
    0xffff, 0xffff, 0x28b8, 0x28ba, 0x28bc, 0xffff, 0xffff, 0xffff,
    0x28be, 0x28c0, 0x28c2, 0x28c4, 0x28c6, 0x28c8, 0x28ca, 0xffff,
    0x28cc, 0x28ce, 0x28d0, 0x28d2, 0x28d4, 0x28d6, 0x28d8, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x28da, 0x28dc, 0x28de, 0x28e0, 0x28e2, 0xffff, 0x28e4,
    0x28e6, 0x28e8, 0x28ea, 0x28ec, 0x28ee, 0x28f0, 0x28f2, 0x28f4,
    0x28f6, 0x28f8, 0x28fa, 0x28fc, 0x28fe, 0x2900, 0x2902, 0x2904,
    0x2906, 0x2908, 0x290a, 0x290c, 0x290e, 0x2910, 0x2912, 0x2914,
    0x2916, 0x2918, 0x291a, 0x291c, 0x291e, 0x2920, 0x2922, 0x2924,
    0x2926, 0x2928, 0x292a, 0x292c, 0x292e, 0x2930, 0x2932, 0x2934,
    0x2936, 0xffff, 0x2938, 0x293a, 0x293c, 0x293e, 0x2940, 0x2942,
    0x2944, 0x2946, 0x2948, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x294a, 0xffff, 0x294d, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x2950, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x2953, 0x2956,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x2959, 0x295c, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x295f, 0x2962, 0xffff, 0x2965, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x2968, 0x296b, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x296e, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x2971, 0x2974,
    0x2977, 0x297a, 0x297d, 0x2980, 0x2983, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x2986, 0x2989, 0x298c, 0x298f, 0x2992,
    0x2995, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x2998, 0x299a, 0x299c, 0x299e, 0x29a0, 0x29a2, 0x29a4, 0x29a6,
    0x29a8, 0x29aa, 0x29ac, 0x29ae, 0x29b0, 0x29b2, 0x29b4, 0x29b6,
    0x29b8, 0x29ba, 0x29bc, 0x29be, 0x29c0, 0x29c2, 0x29c4, 0x29c6,
    0x29c8, 0x29ca, 0x29cc, 0x29ce, 0x29d0, 0x29d2, 0x29d4, 0x29d6,
    0x29d8, 0x29da, 0x29dc, 0x29de, 0x29e0, 0x29e2, 0x29e4, 0x29e6,
    0x29e8, 0x29ea, 0x29ec, 0x29ee, 0x29f0, 0x29f2, 0x29f4, 0x29f6,
    0x29f8, 0x29fa, 0x29fc, 0x29fe, 0x2a00, 0x2a02, 0x2a04, 0x2a06,
    0x2a08, 0x2a0a, 0x2a0c, 0x2a0e, 0x2a10, 0x2a12, 0x2a14, 0x2a16,
    0x2a18, 0x2a1a, 0x2a1c, 0x2a1e, 0x2a20, 0x2a22, 0x2a24, 0x2a26,
    0x2a28, 0x2a2a, 0x2a2c, 0x2a2e, 0x2a30, 0x2a32, 0x2a34, 0x2a36,
    0x2a38, 0x2a3a, 0x2a3c, 0x2a3e, 0x2a40, 0xffff, 0x2a42, 0x2a44,
    0x2a46, 0x2a48, 0x2a4a, 0x2a4c, 0x2a4e, 0x2a50, 0x2a52, 0x2a54,
    0x2a56, 0x2a58, 0x2a5a, 0x2a5c, 0x2a5e, 0x2a60, 0x2a62, 0x2a64,
    0x2a66, 0x2a68, 0x2a6a, 0x2a6c, 0x2a6e, 0x2a70, 0x2a72, 0x2a74,
    0x2a76, 0x2a78, 0x2a7a, 0x2a7c, 0x2a7e, 0x2a80, 0x2a82, 0x2a84,
    0x2a86, 0x2a88, 0x2a8a, 0x2a8c, 0x2a8e, 0x2a90, 0x2a92, 0x2a94,
    0x2a96, 0x2a98, 0x2a9a, 0x2a9c, 0x2a9e, 0x2aa0, 0x2aa2, 0x2aa4,
    0x2aa6, 0x2aa8, 0x2aaa, 0x2aac, 0x2aae, 0x2ab0, 0x2ab2, 0x2ab4,
    0x2ab6, 0x2ab8, 0x2aba, 0x2abc, 0x2abe, 0x2ac0, 0x2ac2, 0x2ac4,
    0x2ac6, 0x2ac8, 0x2aca, 0x2acc, 0x2ace, 0xffff, 0x2ad0, 0x2ad2,
    0xffff, 0xffff, 0x2ad4, 0xffff, 0xffff, 0x2ad6, 0x2ad8, 0xffff,
    0xffff, 0x2ada, 0x2adc, 0x2ade, 0x2ae0, 0xffff, 0x2ae2, 0x2ae4,
    0x2ae6, 0x2ae8, 0x2aea, 0x2aec, 0x2aee, 0x2af0, 0x2af2, 0x2af4,
    0x2af6, 0x2af8, 0xffff, 0x2afa, 0xffff, 0x2afc, 0x2afe, 0x2b00,
    0x2b02, 0x2b04, 0x2b06, 0x2b08, 0xffff, 0x2b0a, 0x2b0c, 0x2b0e,
    0x2b10, 0x2b12, 0x2b14, 0x2b16, 0x2b18, 0x2b1a, 0x2b1c, 0x2b1e,
    0x2b20, 0x2b22, 0x2b24, 0x2b26, 0x2b28, 0x2b2a, 0x2b2c, 0x2b2e,
    0x2b30, 0x2b32, 0x2b34, 0x2b36, 0x2b38, 0x2b3a, 0x2b3c, 0x2b3e,
    0x2b40, 0x2b42, 0x2b44, 0x2b46, 0x2b48, 0x2b4a, 0x2b4c, 0x2b4e,
    0x2b50, 0x2b52, 0x2b54, 0x2b56, 0x2b58, 0x2b5a, 0x2b5c, 0x2b5e,
    0x2b60, 0x2b62, 0x2b64, 0x2b66, 0x2b68, 0x2b6a, 0x2b6c, 0x2b6e,
    0x2b70, 0x2b72, 0x2b74, 0x2b76, 0x2b78, 0x2b7a, 0x2b7c, 0x2b7e,

    0x2b80, 0x2b82, 0x2b84, 0x2b86, 0x2b88, 0x2b8a, 0xffff, 0x2b8c,
    0x2b8e, 0x2b90, 0x2b92, 0xffff, 0xffff, 0x2b94, 0x2b96, 0x2b98,
    0x2b9a, 0x2b9c, 0x2b9e, 0x2ba0, 0x2ba2, 0xffff, 0x2ba4, 0x2ba6,
    0x2ba8, 0x2baa, 0x2bac, 0x2bae, 0x2bb0, 0xffff, 0x2bb2, 0x2bb4,
    0x2bb6, 0x2bb8, 0x2bba, 0x2bbc, 0x2bbe, 0x2bc0, 0x2bc2, 0x2bc4,
    0x2bc6, 0x2bc8, 0x2bca, 0x2bcc, 0x2bce, 0x2bd0, 0x2bd2, 0x2bd4,
    0x2bd6, 0x2bd8, 0x2bda, 0x2bdc, 0x2bde, 0x2be0, 0x2be2, 0x2be4,
    0x2be6, 0x2be8, 0xffff, 0x2bea, 0x2bec, 0x2bee, 0x2bf0, 0xffff,
    0x2bf2, 0x2bf4, 0x2bf6, 0x2bf8, 0x2bfa, 0xffff, 0x2bfc, 0xffff,
    0xffff, 0xffff, 0x2bfe, 0x2c00, 0x2c02, 0x2c04, 0x2c06, 0x2c08,
    0x2c0a, 0xffff, 0x2c0c, 0x2c0e, 0x2c10, 0x2c12, 0x2c14, 0x2c16,
    0x2c18, 0x2c1a, 0x2c1c, 0x2c1e, 0x2c20, 0x2c22, 0x2c24, 0x2c26,
    0x2c28, 0x2c2a, 0x2c2c, 0x2c2e, 0x2c30, 0x2c32, 0x2c34, 0x2c36,
    0x2c38, 0x2c3a, 0x2c3c, 0x2c3e, 0x2c40, 0x2c42, 0x2c44, 0x2c46,
    0x2c48, 0x2c4a, 0x2c4c, 0x2c4e, 0x2c50, 0x2c52, 0x2c54, 0x2c56,
    0x2c58, 0x2c5a, 0x2c5c, 0x2c5e, 0x2c60, 0x2c62, 0x2c64, 0x2c66,
    0x2c68, 0x2c6a, 0x2c6c, 0x2c6e, 0x2c70, 0x2c72, 0x2c74, 0x2c76,
    0x2c78, 0x2c7a, 0x2c7c, 0x2c7e, 0x2c80, 0x2c82, 0x2c84, 0x2c86,
    0x2c88, 0x2c8a, 0x2c8c, 0x2c8e, 0x2c90, 0x2c92, 0x2c94, 0x2c96,
    0x2c98, 0x2c9a, 0x2c9c, 0x2c9e, 0x2ca0, 0x2ca2, 0x2ca4, 0x2ca6,
    0x2ca8, 0x2caa, 0x2cac, 0x2cae, 0x2cb0, 0x2cb2, 0x2cb4, 0x2cb6,
    0x2cb8, 0x2cba, 0x2cbc, 0x2cbe, 0x2cc0, 0x2cc2, 0x2cc4, 0x2cc6,
    0x2cc8, 0x2cca, 0x2ccc, 0x2cce, 0x2cd0, 0x2cd2, 0x2cd4, 0x2cd6,
    0x2cd8, 0x2cda, 0x2cdc, 0x2cde, 0x2ce0, 0x2ce2, 0x2ce4, 0x2ce6,
    0x2ce8, 0x2cea, 0x2cec, 0x2cee, 0x2cf0, 0x2cf2, 0x2cf4, 0x2cf6,
    0x2cf8, 0x2cfa, 0x2cfc, 0x2cfe, 0x2d00, 0x2d02, 0x2d04, 0x2d06,
    0x2d08, 0x2d0a, 0x2d0c, 0x2d0e, 0x2d10, 0x2d12, 0x2d14, 0x2d16,
    0x2d18, 0x2d1a, 0x2d1c, 0x2d1e, 0x2d20, 0x2d22, 0x2d24, 0x2d26,
    0x2d28, 0x2d2a, 0x2d2c, 0x2d2e, 0x2d30, 0x2d32, 0x2d34, 0x2d36,
    0x2d38, 0x2d3a, 0x2d3c, 0x2d3e, 0x2d40, 0x2d42, 0x2d44, 0x2d46,
    0x2d48, 0x2d4a, 0x2d4c, 0x2d4e, 0x2d50, 0x2d52, 0x2d54, 0x2d56,
    0x2d58, 0x2d5a, 0x2d5c, 0x2d5e, 0x2d60, 0x2d62, 0x2d64, 0x2d66,

    0x2d68, 0x2d6a, 0x2d6c, 0x2d6e, 0x2d70, 0x2d72, 0x2d74, 0x2d76,
    0x2d78, 0x2d7a, 0x2d7c, 0x2d7e, 0x2d80, 0x2d82, 0x2d84, 0x2d86,
    0x2d88, 0x2d8a, 0x2d8c, 0x2d8e, 0x2d90, 0x2d92, 0x2d94, 0x2d96,
    0x2d98, 0x2d9a, 0x2d9c, 0x2d9e, 0x2da0, 0x2da2, 0x2da4, 0x2da6,
    0x2da8, 0x2daa, 0x2dac, 0x2dae, 0x2db0, 0x2db2, 0x2db4, 0x2db6,
    0x2db8, 0x2dba, 0x2dbc, 0x2dbe, 0x2dc0, 0x2dc2, 0x2dc4, 0x2dc6,
    0x2dc8, 0x2dca, 0x2dcc, 0x2dce, 0x2dd0, 0x2dd2, 0x2dd4, 0x2dd6,
    0x2dd8, 0x2dda, 0x2ddc, 0x2dde, 0x2de0, 0x2de2, 0x2de4, 0x2de6,
    0x2de8, 0x2dea, 0x2dec, 0x2dee, 0x2df0, 0x2df2, 0x2df4, 0x2df6,
    0x2df8, 0x2dfa, 0x2dfc, 0x2dfe, 0x2e00, 0x2e02, 0x2e04, 0x2e06,
    0x2e08, 0x2e0a, 0x2e0c, 0x2e0e, 0x2e10, 0x2e12, 0x2e14, 0x2e16,
    0x2e18, 0x2e1a, 0x2e1c, 0x2e1e, 0x2e20, 0x2e22, 0x2e24, 0x2e26,
    0x2e28, 0x2e2a, 0x2e2c, 0x2e2e, 0x2e30, 0x2e32, 0x2e34, 0x2e36,
    0x2e38, 0x2e3a, 0x2e3c, 0x2e3e, 0x2e40, 0x2e42, 0x2e44, 0x2e46,
    0x2e48, 0x2e4a, 0x2e4c, 0x2e4e, 0x2e50, 0x2e52, 0x2e54, 0x2e56,
    0x2e58, 0x2e5a, 0x2e5c, 0x2e5e, 0x2e60, 0x2e62, 0x2e64, 0x2e66,
    0x2e68, 0x2e6a, 0x2e6c, 0x2e6e, 0x2e70, 0x2e72, 0x2e74, 0x2e76,
    0x2e78, 0x2e7a, 0x2e7c, 0x2e7e, 0x2e80, 0x2e82, 0x2e84, 0x2e86,
    0x2e88, 0x2e8a, 0x2e8c, 0x2e8e, 0x2e90, 0x2e92, 0x2e94, 0x2e96,
    0x2e98, 0x2e9a, 0x2e9c, 0x2e9e, 0x2ea0, 0x2ea2, 0x2ea4, 0x2ea6,
    0x2ea8, 0x2eaa, 0x2eac, 0x2eae, 0x2eb0, 0x2eb2, 0xffff, 0xffff,
    0x2eb4, 0x2eb6, 0x2eb8, 0x2eba, 0x2ebc, 0x2ebe, 0x2ec0, 0x2ec2,
    0x2ec4, 0x2ec6, 0x2ec8, 0x2eca, 0x2ecc, 0x2ece, 0x2ed0, 0x2ed2,
    0x2ed4, 0x2ed6, 0x2ed8, 0x2eda, 0x2edc, 0x2ede, 0x2ee0, 0x2ee2,
    0x2ee4, 0x2ee6, 0x2ee8, 0x2eea, 0x2eec, 0x2eee, 0x2ef0, 0x2ef2,
    0x2ef4, 0x2ef6, 0x2ef8, 0x2efa, 0x2efc, 0x2efe, 0x2f00, 0x2f02,
    0x2f04, 0x2f06, 0x2f08, 0x2f0a, 0x2f0c, 0x2f0e, 0x2f10, 0x2f12,
    0x2f14, 0x2f16, 0x2f18, 0x2f1a, 0x2f1c, 0x2f1e, 0x2f20, 0x2f22,
    0x2f24, 0x2f26, 0x2f28, 0x2f2a, 0x2f2c, 0x2f2e, 0x2f30, 0x2f32,
    0x2f34, 0x2f36, 0x2f38, 0x2f3a, 0x2f3c, 0x2f3e, 0x2f40, 0x2f42,
    0x2f44, 0x2f46, 0x2f48, 0x2f4a, 0x2f4c, 0x2f4e, 0x2f50, 0x2f52,
    0x2f54, 0x2f56, 0x2f58, 0x2f5a, 0x2f5c, 0x2f5e, 0x2f60, 0x2f62,

    0x2f64, 0x2f66, 0x2f68, 0x2f6a, 0x2f6c, 0x2f6e, 0x2f70, 0x2f72,
    0x2f74, 0x2f76, 0x2f78, 0x2f7a, 0x2f7c, 0x2f7e, 0x2f80, 0x2f82,
    0x2f84, 0x2f86, 0x2f88, 0x2f8a, 0x2f8c, 0x2f8e, 0x2f90, 0x2f92,
    0x2f94, 0x2f96, 0x2f98, 0x2f9a, 0x2f9c, 0x2f9e, 0x2fa0, 0x2fa2,
    0x2fa4, 0x2fa6, 0x2fa8, 0x2faa, 0x2fac, 0x2fae, 0x2fb0, 0x2fb2,
    0x2fb4, 0x2fb6, 0x2fb8, 0x2fba, 0x2fbc, 0x2fbe, 0x2fc0, 0x2fc2,
    0x2fc4, 0x2fc6, 0x2fc8, 0x2fca, 0x2fcc, 0x2fce, 0x2fd0, 0x2fd2,
    0x2fd4, 0x2fd6, 0x2fd8, 0x2fda, 0x2fdc, 0x2fde, 0x2fe0, 0x2fe2,
    0x2fe4, 0x2fe6, 0x2fe8, 0x2fea, 0x2fec, 0x2fee, 0x2ff0, 0x2ff2,
    0x2ff4, 0x2ff6, 0x2ff8, 0x2ffa, 0x2ffc, 0x2ffe, 0x3000, 0x3002,
    0x3004, 0x3006, 0x3008, 0x300a, 0x300c, 0x300e, 0x3010, 0x3012,
    0x3014, 0x3016, 0x3018, 0x301a, 0x301c, 0x301e, 0x3020, 0x3022,
    0x3024, 0x3026, 0x3028, 0x302a, 0x302c, 0x302e, 0x3030, 0x3032,
    0x3034, 0x3036, 0x3038, 0x303a, 0x303c, 0x303e, 0x3040, 0x3042,
    0x3044, 0x3046, 0x3048, 0x304a, 0x304c, 0x304e, 0x3050, 0x3052,
    0x3054, 0x3056, 0x3058, 0x305a, 0x305c, 0x305e, 0x3060, 0x3062,
    0x3064, 0x3066, 0x3068, 0x306a, 0x306c, 0x306e, 0x3070, 0x3072,
    0x3074, 0x3076, 0x3078, 0x307a, 0x307c, 0x307e, 0x3080, 0x3082,
    0x3084, 0x3086, 0x3088, 0x308a, 0x308c, 0x308e, 0x3090, 0x3092,
    0x3094, 0x3096, 0x3098, 0x309a, 0x309c, 0x309e, 0x30a0, 0x30a2,
    0x30a4, 0x30a6, 0x30a8, 0x30aa, 0x30ac, 0x30ae, 0x30b0, 0x30b2,
    0x30b4, 0x30b6, 0x30b8, 0x30ba, 0x30bc, 0x30be, 0x30c0, 0x30c2,
    0x30c4, 0x30c6, 0x30c8, 0x30ca, 0x30cc, 0x30ce, 0x30d0, 0x30d2,
    0x30d4, 0x30d6, 0x30d8, 0x30da, 0x30dc, 0x30de, 0x30e0, 0x30e2,
    0x30e4, 0x30e6, 0x30e8, 0x30ea, 0x30ec, 0x30ee, 0x30f0, 0x30f2,
    0x30f4, 0x30f6, 0x30f8, 0x30fa, 0xffff, 0xffff, 0x30fc, 0x30fe,
    0x3100, 0x3102, 0x3104, 0x3106, 0x3108, 0x310a, 0x310c, 0x310e,
    0x3110, 0x3112, 0x3114, 0x3116, 0x3118, 0x311a, 0x311c, 0x311e,
    0x3120, 0x3122, 0x3124, 0x3126, 0x3128, 0x312a, 0x312c, 0x312e,
    0x3130, 0x3132, 0x3134, 0x3136, 0x3138, 0x313a, 0x313c, 0x313e,
    0x3140, 0x3142, 0x3144, 0x3146, 0x3148, 0x314a, 0x314c, 0x314e,
    0x3150, 0x3152, 0x3154, 0x3156, 0x3158, 0x315a, 0x315c, 0x315e,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x3160, 0x3162, 0x3164, 0x3166, 0x3168, 0x316a, 0x316c, 0x316e,
    0x3170, 0x3172, 0x3174, 0x3176, 0x3178, 0x317a, 0x317c, 0x317e,
    0x3180, 0x3182, 0x3184, 0x3186, 0x3188, 0x318a, 0x318c, 0x318e,
    0x3190, 0x3192, 0x3194, 0x3196, 0x3198, 0x319a, 0x319c, 0x319e,
    0x31a0, 0x31a2, 0x31a4, 0x31a6, 0x31a8, 0x31aa, 0x31ac, 0x31ae,
    0x31b0, 0x31b2, 0x31b4, 0x31b6, 0x31b8, 0x31ba, 0x31bc, 0x31be,
    0x31c0, 0x31c2, 0x31c4, 0x31c6, 0x31c8, 0x31ca, 0x31cc, 0x31ce,
    0x31d0, 0x31d2, 0x31d4, 0x31d6, 0x31d8, 0x31da, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x31dc, 0x31de, 0x31e0, 0x31e2, 0xffff, 0x31e4, 0x31e6, 0x31e8,
    0x31ea, 0x31ec, 0x31ee, 0x31f0, 0x31f2, 0x31f4, 0x31f6, 0x31f8,
    0x31fa, 0x31fc, 0x31fe, 0x3200, 0x3202, 0x3204, 0x3206, 0x3208,
    0x320a, 0x320c, 0x320e, 0x3210, 0x3212, 0x3214, 0x3216, 0x3218,
    0xffff, 0x321a, 0x321c, 0xffff, 0x321e, 0xffff, 0xffff, 0x3220,
    0xffff, 0x3222, 0x3224, 0x3226, 0x3228, 0x322a, 0x322c, 0x322e,
    0x3230, 0x3232, 0x3234, 0xffff, 0x3236, 0x3238, 0x323a, 0x323c,
    0xffff, 0x323e, 0xffff, 0x3240, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x3242, 0xffff, 0xffff, 0xffff, 0xffff, 0x3244,
    0xffff, 0x3246, 0xffff, 0x3248, 0xffff, 0x324a, 0x324c, 0x324e,
    0xffff, 0x3250, 0x3252, 0xffff, 0x3254, 0xffff, 0xffff, 0x3256,
    0xffff, 0x3258, 0xffff, 0x325a, 0xffff, 0x325c, 0xffff, 0x325e,
    0xffff, 0x3260, 0x3262, 0xffff, 0x3264, 0xffff, 0xffff, 0x3266,
    0x3268, 0x326a, 0x326c, 0xffff, 0x326e, 0x3270, 0x3272, 0x3274,
    0x3276, 0x3278, 0x327a, 0xffff, 0x327c, 0x327e, 0x3280, 0x3282,
    0xffff, 0x3284, 0x3286, 0x3288, 0x328a, 0xffff, 0x328c, 0xffff,
    0x328e, 0x3290, 0x3292, 0x3294, 0x3296, 0x3298, 0x329a, 0x329c,
    0x329e, 0x32a0, 0xffff, 0x32a2, 0x32a4, 0x32a6, 0x32a8, 0x32aa,
    0x32ac, 0x32ae, 0x32b0, 0x32b2, 0x32b4, 0x32b6, 0x32b8, 0x32ba,
    0x32bc, 0x32be, 0x32c0, 0x32c2, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x32c4, 0x32c6, 0x32c8, 0xffff, 0x32ca, 0x32cc, 0x32ce,
    0x32d0, 0x32d2, 0xffff, 0x32d4, 0x32d6, 0x32d8, 0x32da, 0x32dc,
    0x32de, 0x32e0, 0x32e2, 0x32e4, 0x32e6, 0x32e8, 0x32ea, 0x32ec,
    0x32ee, 0x32f0, 0x32f2, 0x32f4, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x32f6, 0x32f9, 0x32fc, 0x32ff, 0x3302, 0x3305, 0x3308, 0x330b,
    0x330e, 0x3311, 0x3314, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x3317, 0x331b, 0x331f, 0x3323, 0x3327, 0x332b, 0x332f, 0x3333,
    0x3337, 0x333b, 0x333f, 0x3343, 0x3347, 0x334b, 0x334f, 0x3353,
    0x3357, 0x335b, 0x335f, 0x3363, 0x3367, 0x336b, 0x336f, 0x3373,
    0x3377, 0x337b, 0x337f, 0x3383, 0x3385, 0x3387, 0x338a, 0xffff,
    0x338d, 0x338f, 0x3391, 0x3393, 0x3395, 0x3397, 0x3399, 0x339b,
    0x339d, 0x339f, 0x33a1, 0x33a3, 0x33a5, 0x33a7, 0x33a9, 0x33ab,
    0x33ad, 0x33af, 0x33b1, 0x33b3, 0x33b5, 0x33b7, 0x33b9, 0x33bb,
    0x33bd, 0x33bf, 0x33c1, 0x33c4, 0x33c7, 0x33ca, 0x33cd, 0x33d1,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x33d4, 0x33d7, 0x33da, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x33dd, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x33e0, 0x33e3, 0x33e6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x33e8, 0x33ea, 0x33ec, 0x33ee, 0x33f0, 0x33f2, 0x33f4, 0x33f6,
    0x33f8, 0x33fa, 0x33fc, 0x33fe, 0x3400, 0x3402, 0x3404, 0x3406,
    0x3408, 0x340a, 0x340c, 0x340e, 0x3410, 0x3412, 0x3414, 0x3416,
    0x3418, 0x341a, 0x341c, 0x341e, 0x3420, 0x3422, 0x3424, 0x3426,
    0x3428, 0x342a, 0x342c, 0x342e, 0x3430, 0x3432, 0x3434, 0x3436,
    0x3438, 0x343a, 0x343c, 0x343e, 0xffff, 0xffff, 0xffff, 0xffff,
    0x3440, 0x3444, 0x3448, 0x344c, 0x3450, 0x3454, 0x3458, 0x345c,
    0x3460, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x3464, 0x3466, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x3468, 0x346a, 0x346c, 0x346e, 0x3470, 0x3472, 0x3474, 0x3476,
    0x3478, 0x347a, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x347c, 0x347e, 0x3480, 0x3482, 0x3484, 0x3486, 0x3488, 0x348a,
    0x348c, 0x348e, 0x3490, 0x3492, 0x3494, 0x3496, 0x3498, 0x349a,
    0x349c, 0x349e, 0x34a0, 0x34a2, 0x34a4, 0x34a6, 0x34a8, 0x34aa,
    0x34ac, 0x34ae, 0x34b0, 0x34b2, 0x34b4, 0x34b6, 0x34b8, 0x34ba,
    0x34bc, 0x34be, 0x34c0, 0x34c2, 0x34c4, 0x34c6, 0x34c8, 0x34ca,
    0x34cc, 0x34ce, 0x34d0, 0x34d2, 0x34d4, 0x34d6, 0x34d8, 0x34da,
    0x34dc, 0x34de, 0x34e0, 0x34e2, 0x34e4, 0x34e6, 0x34e8, 0x34ea,
    0x34ec, 0x34ee, 0x34f0, 0x34f2, 0x34f4, 0x34f6, 0x34f8, 0x34fa,
    0x34fc, 0x34fe, 0x3500, 0x3502, 0x3504, 0x3506, 0x3508, 0x350a,
    0x350c, 0x350e, 0x3510, 0x3512, 0x3514, 0x3516, 0x3518, 0x351a,
    0x351c, 0x351e, 0x3520, 0x3522, 0x3524, 0x3526, 0x3528, 0x352a,
    0x352c, 0x352e, 0x3530, 0x3532, 0x3534, 0x3536, 0x3538, 0x353a,
    0x353c, 0x353e, 0x3540, 0x3542, 0x3544, 0x3546, 0x3548, 0x354a,
    0x354c, 0x354e, 0x3550, 0x3552, 0x3554, 0x3556, 0x3558, 0x355a,
    0x355c, 0x355e, 0x3560, 0x3562, 0x3564, 0x3566, 0x3568, 0x356a,
    0x356c, 0x356e, 0x3570, 0x3572, 0x3574, 0x3576, 0x3578, 0x357a,
    0x357c, 0x357e, 0x3580, 0x3582, 0x3584, 0x3586, 0x3588, 0x358a,
    0x358c, 0x358e, 0x3590, 0x3592, 0x3594, 0x3596, 0x3598, 0x359a,
    0x359c, 0x359e, 0x35a0, 0x35a2, 0x35a4, 0x35a6, 0x35a8, 0x35aa,
    0x35ac, 0x35ae, 0x35b0, 0x35b2, 0x35b4, 0x35b6, 0x35b8, 0x35ba,
    0x35bc, 0x35be, 0x35c0, 0x35c2, 0x35c4, 0x35c6, 0x35c8, 0x35ca,
    0x35cc, 0x35ce, 0x35d0, 0x35d2, 0x35d4, 0x35d6, 0x35d8, 0x35da,
    0x35dc, 0x35de, 0x35e0, 0x35e2, 0x35e4, 0x35e6, 0x35e8, 0x35ea,
    0x35ec, 0x35ee, 0x35f0, 0x35f2, 0x35f4, 0x35f6, 0x35f8, 0x35fa,
    0x35fc, 0x35fe, 0x3600, 0x3602, 0x3604, 0x3606, 0x3608, 0x360a,
    0x360c, 0x360e, 0x3610, 0x3612, 0x3614, 0x3616, 0x3618, 0x361a,
    0x361c, 0x361e, 0x3620, 0x3622, 0x3624, 0x3626, 0x3628, 0x362a,
    0x362c, 0x362e, 0x3630, 0x3632, 0x3634, 0x3636, 0x3638, 0x363a,
    0x363c, 0x363e, 0x3640, 0x3642, 0x3644, 0x3646, 0x3648, 0x364a,
    0x364c, 0x364e, 0x3650, 0x3652, 0x3654, 0x3656, 0x3658, 0x365a,
    0x365c, 0x365e, 0x3660, 0x3662, 0x3664, 0x3666, 0x3668, 0x366a,
    0x366c, 0x366e, 0x3670, 0x3672, 0x3674, 0x3676, 0x3678, 0x367a,

    0x367c, 0x367e, 0x3680, 0x3682, 0x3684, 0x3686, 0x3688, 0x368a,
    0x368c, 0x368e, 0x3690, 0x3692, 0x3694, 0x3696, 0x3698, 0x369a,
    0x369c, 0x369e, 0x36a0, 0x36a2, 0x36a4, 0x36a6, 0x36a8, 0x36aa,
    0x36ac, 0x36ae, 0x36b0, 0x36b2, 0x36b4, 0x36b6, 0x36b8, 0x36ba,
    0x36bc, 0x36be, 0x36c0, 0x36c2, 0x36c4, 0x36c6, 0x36c8, 0x36ca,
    0x36cc, 0x36ce, 0x36d0, 0x36d2, 0x36d4, 0x36d6, 0x36d8, 0x36da,
    0x36dc, 0x36de, 0x36e0, 0x36e2, 0x36e4, 0x36e6, 0x36e8, 0x36ea,
    0x36ec, 0x36ee, 0x36f0, 0x36f2, 0x36f4, 0x36f6, 0x36f8, 0x36fa,
    0x36fc, 0x36fe, 0x3700, 0x3702, 0x3704, 0x3706, 0x3708, 0x370a,
    0x370c, 0x370e, 0x3710, 0x3712, 0x3714, 0x3716, 0x3718, 0x371a,
    0x371c, 0x371e, 0x3720, 0x3722, 0x3724, 0x3726, 0x3728, 0x372a,
    0x372c, 0x372e, 0x3730, 0x3732, 0x3734, 0x3736, 0x3738, 0x373a,
    0x373c, 0x373e, 0x3740, 0x3742, 0x3744, 0x3746, 0x3748, 0x374a,
    0x374c, 0x374e, 0x3750, 0x3752, 0x3754, 0x3756, 0x3758, 0x375a,
    0x375c, 0x375e, 0x3760, 0x3762, 0x3764, 0x3766, 0x3768, 0x376a,
    0x376c, 0x376e, 0x3770, 0x3772, 0x3774, 0x3776, 0x3778, 0x377a,
    0x377c, 0x377e, 0x3780, 0x3782, 0x3784, 0x3786, 0x3788, 0x378a,
    0x378c, 0x378e, 0x3790, 0x3792, 0x3794, 0x3796, 0x3798, 0x379a,
    0x379c, 0x379e, 0x37a0, 0x37a2, 0x37a4, 0x37a6, 0x37a8, 0x37aa,
    0x37ac, 0x37ae, 0x37b0, 0x37b2, 0x37b4, 0x37b6, 0x37b8, 0x37ba,
    0x37bc, 0x37be, 0x37c0, 0x37c2, 0x37c4, 0x37c6, 0x37c8, 0x37ca,
    0x37cc, 0x37ce, 0x37d0, 0x37d2, 0x37d4, 0x37d6, 0x37d8, 0x37da,
    0x37dc, 0x37de, 0x37e0, 0x37e2, 0x37e4, 0x37e6, 0x37e8, 0x37ea,
    0x37ec, 0x37ee, 0x37f0, 0x37f2, 0x37f4, 0x37f6, 0x37f8, 0x37fa,
    0x37fc, 0x37fe, 0x3800, 0x3802, 0x3804, 0x3806, 0x3808, 0x380a,
    0x380c, 0x380e, 0x3810, 0x3812, 0x3814, 0x3816, 0x3818, 0x381a,
    0x381c, 0x381e, 0x3820, 0x3822, 0x3824, 0x3826, 0x3828, 0x382a,
    0x382c, 0x382e, 0x3830, 0x3832, 0x3834, 0x3836, 0x3838, 0x383a,
    0x383c, 0x383e, 0x3840, 0x3842, 0x3844, 0x3846, 0x3848, 0x384a,
    0x384c, 0x384e, 0x3850, 0x3852, 0x3854, 0x3856, 0x3858, 0x385a,
    0x385c, 0x385e, 0x3860, 0x3862, 0x3864, 0x3866, 0x3868, 0x386a,
    0x386c, 0x386e, 0x3870, 0x3872, 0x3874, 0x3876, 0x3878, 0x387a,

    0x387c, 0x387e, 0x3880, 0x3882, 0x3884, 0x3886, 0x3888, 0x388a,
    0x388c, 0x388e, 0x3890, 0x3892, 0x3894, 0x3896, 0x3898, 0x389a,
    0x389c, 0x389e, 0x38a0, 0x38a2, 0x38a4, 0x38a6, 0x38a8, 0x38aa,
    0x38ac, 0x38ae, 0x38b0, 0x38b2, 0x38b4, 0x38b6, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
};

const char32_t uc_decomposition_map[] = {
    0x103, 0x20, 0x210, 0x20, 0x308, 0x109, 0x61, 0x210,
    0x20, 0x304, 0x109, 0x32, 0x109, 0x33, 0x210, 0x20,
    0x301, 0x110, 0x3bc, 0x210, 0x20, 0x327, 0x109, 0x31,
    0x109, 0x6f, 0x311, 0x31, 0x2044, 0x34, 0x311, 0x31,
    0x2044, 0x32, 0x311, 0x33, 0x2044, 0x34, 0x201, 0x41,
    0x300, 0x201, 0x41, 0x301, 0x201, 0x41, 0x302, 0x201,
    0x41, 0x303, 0x201, 0x41, 0x308, 0x201, 0x41, 0x30a,
    0x201, 0x43, 0x327, 0x201, 0x45, 0x300, 0x201, 0x45,
    0x301, 0x201, 0x45, 0x302, 0x201, 0x45, 0x308, 0x201,
    0x49, 0x300, 0x201, 0x49, 0x301, 0x201, 0x49, 0x302,
    0x201, 0x49, 0x308, 0x201, 0x4e, 0x303, 0x201, 0x4f,
    0x300, 0x201, 0x4f, 0x301, 0x201, 0x4f, 0x302, 0x201,
    0x4f, 0x303, 0x201, 0x4f, 0x308, 0x201, 0x55, 0x300,
    0x201, 0x55, 0x301, 0x201, 0x55, 0x302, 0x201, 0x55,
    0x308, 0x201, 0x59, 0x301, 0x201, 0x61, 0x300, 0x201,
    0x61, 0x301, 0x201, 0x61, 0x302, 0x201, 0x61, 0x303,
    0x201, 0x61, 0x308, 0x201, 0x61, 0x30a, 0x201, 0x63,
    0x327, 0x201, 0x65, 0x300, 0x201, 0x65, 0x301, 0x201,
    0x65, 0x302, 0x201, 0x65, 0x308, 0x201, 0x69, 0x300,
    0x201, 0x69, 0x301, 0x201, 0x69, 0x302, 0x201, 0x69,
    0x308, 0x201, 0x6e, 0x303, 0x201, 0x6f, 0x300, 0x201,
    0x6f, 0x301, 0x201, 0x6f, 0x302, 0x201, 0x6f, 0x303,
    0x201, 0x6f, 0x308, 0x201, 0x75, 0x300, 0x201, 0x75,
    0x301, 0x201, 0x75, 0x302, 0x201, 0x75, 0x308, 0x201,
    0x79, 0x301, 0x201, 0x79, 0x308, 0x201, 0x41, 0x304,
    0x201, 0x61, 0x304, 0x201, 0x41, 0x306, 0x201, 0x61,
    0x306, 0x201, 0x41, 0x328, 0x201, 0x61, 0x328, 0x201,
    0x43, 0x301, 0x201, 0x63, 0x301, 0x201, 0x43, 0x302,
    0x201, 0x63, 0x302, 0x201, 0x43, 0x307, 0x201, 0x63,
    0x307, 0x201, 0x43, 0x30c, 0x201, 0x63, 0x30c, 0x201,
    0x44, 0x30c, 0x201, 0x64, 0x30c, 0x201, 0x45, 0x304,
    0x201, 0x65, 0x304, 0x201, 0x45, 0x306, 0x201, 0x65,
    0x306, 0x201, 0x45, 0x307, 0x201, 0x65, 0x307, 0x201,
    0x45, 0x328, 0x201, 0x65, 0x328, 0x201, 0x45, 0x30c,
    0x201, 0x65, 0x30c, 0x201, 0x47, 0x302, 0x201, 0x67,
    0x302, 0x201, 0x47, 0x306, 0x201, 0x67, 0x306, 0x201,
    0x47, 0x307, 0x201, 0x67, 0x307, 0x201, 0x47, 0x327,
    0x201, 0x67, 0x327, 0x201, 0x48, 0x302, 0x201, 0x68,
    0x302, 0x201, 0x49, 0x303, 0x201, 0x69, 0x303, 0x201,
    0x49, 0x304, 0x201, 0x69, 0x304, 0x201, 0x49, 0x306,
    0x201, 0x69, 0x306, 0x201, 0x49, 0x328, 0x201, 0x69,
    0x328, 0x201, 0x49, 0x307, 0x210, 0x49, 0x4a, 0x210,
    0x69, 0x6a, 0x201, 0x4a, 0x302, 0x201, 0x6a, 0x302,
    0x201, 0x4b, 0x327, 0x201, 0x6b, 0x327, 0x201, 0x4c,
    0x301, 0x201, 0x6c, 0x301, 0x201, 0x4c, 0x327, 0x201,
    0x6c, 0x327, 0x201, 0x4c, 0x30c, 0x201, 0x6c, 0x30c,
    0x210, 0x4c, 0xb7, 0x210, 0x6c, 0xb7, 0x201, 0x4e,
    0x301, 0x201, 0x6e, 0x301, 0x201, 0x4e, 0x327, 0x201,
    0x6e, 0x327, 0x201, 0x4e, 0x30c, 0x201, 0x6e, 0x30c,
    0x210, 0x2bc, 0x6e, 0x201, 0x4f, 0x304, 0x201, 0x6f,
    0x304, 0x201, 0x4f, 0x306, 0x201, 0x6f, 0x306, 0x201,
    0x4f, 0x30b, 0x201, 0x6f, 0x30b, 0x201, 0x52, 0x301,
    0x201, 0x72, 0x301, 0x201, 0x52, 0x327, 0x201, 0x72,
    0x327, 0x201, 0x52, 0x30c, 0x201, 0x72, 0x30c, 0x201,
    0x53, 0x301, 0x201, 0x73, 0x301, 0x201, 0x53, 0x302,
    0x201, 0x73, 0x302, 0x201, 0x53, 0x327, 0x201, 0x73,
    0x327, 0x201, 0x53, 0x30c, 0x201, 0x73, 0x30c, 0x201,
    0x54, 0x327, 0x201, 0x74, 0x327, 0x201, 0x54, 0x30c,
    0x201, 0x74, 0x30c, 0x201, 0x55, 0x303, 0x201, 0x75,
    0x303, 0x201, 0x55, 0x304, 0x201, 0x75, 0x304, 0x201,
    0x55, 0x306, 0x201, 0x75, 0x306, 0x201, 0x55, 0x30a,
    0x201, 0x75, 0x30a, 0x201, 0x55, 0x30b, 0x201, 0x75,
    0x30b, 0x201, 0x55, 0x328, 0x201, 0x75, 0x328, 0x201,
    0x57, 0x302, 0x201, 0x77, 0x302, 0x201, 0x59, 0x302,
    0x201, 0x79, 0x302, 0x201, 0x59, 0x308, 0x201, 0x5a,
    0x301, 0x201, 0x7a, 0x301, 0x201, 0x5a, 0x307, 0x201,
    0x7a, 0x307, 0x201, 0x5a, 0x30c, 0x201, 0x7a, 0x30c,
    0x110, 0x73, 0x201, 0x4f, 0x31b, 0x201, 0x6f, 0x31b,
    0x201, 0x55, 0x31b, 0x201, 0x75, 0x31b, 0x210, 0x44,
    0x17d, 0x210, 0x44, 0x17e, 0x210, 0x64, 0x17e, 0x210,
    0x4c, 0x4a, 0x210, 0x4c, 0x6a, 0x210, 0x6c, 0x6a,
    0x210, 0x4e, 0x4a, 0x210, 0x4e, 0x6a, 0x210, 0x6e,
    0x6a, 0x201, 0x41, 0x30c, 0x201, 0x61, 0x30c, 0x201,
    0x49, 0x30c, 0x201, 0x69, 0x30c, 0x201, 0x4f, 0x30c,
    0x201, 0x6f, 0x30c, 0x201, 0x55, 0x30c, 0x201, 0x75,
    0x30c, 0x201, 0xdc, 0x304, 0x201, 0xfc, 0x304, 0x201,
    0xdc, 0x301, 0x201, 0xfc, 0x301, 0x201, 0xdc, 0x30c,
    0x201, 0xfc, 0x30c, 0x201, 0xdc, 0x300, 0x201, 0xfc,
    0x300, 0x201, 0xc4, 0x304, 0x201, 0xe4, 0x304, 0x201,
    0x226, 0x304, 0x201, 0x227, 0x304, 0x201, 0xc6, 0x304,
    0x201, 0xe6, 0x304, 0x201, 0x47, 0x30c, 0x201, 0x67,
    0x30c, 0x201, 0x4b, 0x30c, 0x201, 0x6b, 0x30c, 0x201,
    0x4f, 0x328, 0x201, 0x6f, 0x328, 0x201, 0x1ea, 0x304,
    0x201, 0x1eb, 0x304, 0x201, 0x1b7, 0x30c, 0x201, 0x292,
    0x30c, 0x201, 0x6a, 0x30c, 0x210, 0x44, 0x5a, 0x210,
    0x44, 0x7a, 0x210, 0x64, 0x7a, 0x201, 0x47, 0x301,
    0x201, 0x67, 0x301, 0x201, 0x4e, 0x300, 0x201, 0x6e,
    0x300, 0x201, 0xc5, 0x301, 0x201, 0xe5, 0x301, 0x201,
    0xc6, 0x301, 0x201, 0xe6, 0x301, 0x201, 0xd8, 0x301,
    0x201, 0xf8, 0x301, 0x201, 0x41, 0x30f, 0x201, 0x61,
    0x30f, 0x201, 0x41, 0x311, 0x201, 0x61, 0x311, 0x201,
    0x45, 0x30f, 0x201, 0x65, 0x30f, 0x201, 0x45, 0x311,
    0x201, 0x65, 0x311, 0x201, 0x49, 0x30f, 0x201, 0x69,
    0x30f, 0x201, 0x49, 0x311, 0x201, 0x69, 0x311, 0x201,
    0x4f, 0x30f, 0x201, 0x6f, 0x30f, 0x201, 0x4f, 0x311,
    0x201, 0x6f, 0x311, 0x201, 0x52, 0x30f, 0x201, 0x72,
    0x30f, 0x201, 0x52, 0x311, 0x201, 0x72, 0x311, 0x201,
    0x55, 0x30f, 0x201, 0x75, 0x30f, 0x201, 0x55, 0x311,
    0x201, 0x75, 0x311, 0x201, 0x53, 0x326, 0x201, 0x73,
    0x326, 0x201, 0x54, 0x326, 0x201, 0x74, 0x326, 0x201,
    0x48, 0x30c, 0x201, 0x68, 0x30c, 0x201, 0x41, 0x307,
    0x201, 0x61, 0x307, 0x201, 0x45, 0x327, 0x201, 0x65,
    0x327, 0x201, 0xd6, 0x304, 0x201, 0xf6, 0x304, 0x201,
    0xd5, 0x304, 0x201, 0xf5, 0x304, 0x201, 0x4f, 0x307,
    0x201, 0x6f, 0x307, 0x201, 0x22e, 0x304, 0x201, 0x22f,
    0x304, 0x201, 0x59, 0x304, 0x201, 0x79, 0x304, 0x109,
    0x68, 0x109, 0x266, 0x109, 0x6a, 0x109, 0x72, 0x109,
    0x279, 0x109, 0x27b, 0x109, 0x281, 0x109, 0x77, 0x109,
    0x79, 0x210, 0x20, 0x306, 0x210, 0x20, 0x307, 0x210,
    0x20, 0x30a, 0x210, 0x20, 0x328, 0x210, 0x20, 0x303,
    0x210, 0x20, 0x30b, 0x109, 0x263, 0x109, 0x6c, 0x109,
    0x73, 0x109, 0x78, 0x109, 0x295, 0x101, 0x300, 0x101,
    0x301, 0x101, 0x313, 0x201, 0x308, 0x301, 0x101, 0x2b9,
    0x210, 0x20, 0x345, 0x101, 0x3b, 0x210, 0x20, 0x301,
    0x201, 0xa8, 0x301, 0x201, 0x391, 0x301, 0x101, 0xb7,
    0x201, 0x395, 0x301, 0x201, 0x397, 0x301, 0x201, 0x399,
    0x301, 0x201, 0x39f, 0x301, 0x201, 0x3a5, 0x301, 0x201,
    0x3a9, 0x301, 0x201, 0x3ca, 0x301, 0x201, 0x399, 0x308,
    0x201, 0x3a5, 0x308, 0x201, 0x3b1, 0x301, 0x201, 0x3b5,
    0x301, 0x201, 0x3b7, 0x301, 0x201, 0x3b9, 0x301, 0x201,
    0x3cb, 0x301, 0x201, 0x3b9, 0x308, 0x201, 0x3c5, 0x308,
    0x201, 0x3bf, 0x301, 0x201, 0x3c5, 0x301, 0x201, 0x3c9,
    0x301, 0x110, 0x3b2, 0x110, 0x3b8, 0x110, 0x3a5, 0x201,
    0x3d2, 0x301, 0x201, 0x3d2, 0x308, 0x110, 0x3c6, 0x110,
    0x3c0, 0x110, 0x3ba, 0x110, 0x3c1, 0x110, 0x3c2, 0x110,
    0x398, 0x110, 0x3b5, 0x110, 0x3a3, 0x201, 0x415, 0x300,
    0x201, 0x415, 0x308, 0x201, 0x413, 0x301, 0x201, 0x406,
    0x308, 0x201, 0x41a, 0x301, 0x201, 0x418, 0x300, 0x201,
    0x423, 0x306, 0x201, 0x418, 0x306, 0x201, 0x438, 0x306,
    0x201, 0x435, 0x300, 0x201, 0x435, 0x308, 0x201, 0x433,
    0x301, 0x201, 0x456, 0x308, 0x201, 0x43a, 0x301, 0x201,
    0x438, 0x300, 0x201, 0x443, 0x306, 0x201, 0x474, 0x30f,
    0x201, 0x475, 0x30f, 0x201, 0x416, 0x306, 0x201, 0x436,
    0x306, 0x201, 0x410, 0x306, 0x201, 0x430, 0x306, 0x201,
    0x410, 0x308, 0x201, 0x430, 0x308, 0x201, 0x415, 0x306,
    0x201, 0x435, 0x306, 0x201, 0x4d8, 0x308, 0x201, 0x4d9,
    0x308, 0x201, 0x416, 0x308, 0x201, 0x436, 0x308, 0x201,
    0x417, 0x308, 0x201, 0x437, 0x308, 0x201, 0x418, 0x304,
    0x201, 0x438, 0x304, 0x201, 0x418, 0x308, 0x201, 0x438,
    0x308, 0x201, 0x41e, 0x308, 0x201, 0x43e, 0x308, 0x201,
    0x4e8, 0x308, 0x201, 0x4e9, 0x308, 0x201, 0x42d, 0x308,
    0x201, 0x44d, 0x308, 0x201, 0x423, 0x304, 0x201, 0x443,
    0x304, 0x201, 0x423, 0x308, 0x201, 0x443, 0x308, 0x201,
    0x423, 0x30b, 0x201, 0x443, 0x30b, 0x201, 0x427, 0x308,
    0x201, 0x447, 0x308, 0x201, 0x42b, 0x308, 0x201, 0x44b,
    0x308, 0x210, 0x565, 0x582, 0x201, 0x627, 0x653, 0x201,
    0x627, 0x654, 0x201, 0x648, 0x654, 0x201, 0x627, 0x655,
    0x201, 0x64a, 0x654, 0x210, 0x627, 0x674, 0x210, 0x648,
    0x674, 0x210, 0x6c7, 0x674, 0x210, 0x64a, 0x674, 0x201,
    0x6d5, 0x654, 0x201, 0x6c1, 0x654, 0x201, 0x6d2, 0x654,
    0x201, 0x928, 0x93c, 0x201, 0x930, 0x93c, 0x201, 0x933,
    0x93c, 0x201, 0x915, 0x93c, 0x201, 0x916, 0x93c, 0x201,
    0x917, 0x93c, 0x201, 0x91c, 0x93c, 0x201, 0x921, 0x93c,
    0x201, 0x922, 0x93c, 0x201, 0x92b, 0x93c, 0x201, 0x92f,
    0x93c, 0x201, 0x9c7, 0x9be, 0x201, 0x9c7, 0x9d7, 0x201,
    0x9a1, 0x9bc, 0x201, 0x9a2, 0x9bc, 0x201, 0x9af, 0x9bc,
    0x201, 0xa32, 0xa3c, 0x201, 0xa38, 0xa3c, 0x201, 0xa16,
    0xa3c, 0x201, 0xa17, 0xa3c, 0x201, 0xa1c, 0xa3c, 0x201,
    0xa2b, 0xa3c, 0x201, 0xb47, 0xb56, 0x201, 0xb47, 0xb3e,
    0x201, 0xb47, 0xb57, 0x201, 0xb21, 0xb3c, 0x201, 0xb22,
    0xb3c, 0x201, 0xb92, 0xbd7, 0x201, 0xbc6, 0xbbe, 0x201,
    0xbc7, 0xbbe, 0x201, 0xbc6, 0xbd7, 0x201, 0xc46, 0xc56,
    0x201, 0xcbf, 0xcd5, 0x201, 0xcc6, 0xcd5, 0x201, 0xcc6,
    0xcd6, 0x201, 0xcc6, 0xcc2, 0x201, 0xcca, 0xcd5, 0x201,
    0xd46, 0xd3e, 0x201, 0xd47, 0xd3e, 0x201, 0xd46, 0xd57,
    0x201, 0xdd9, 0xdca, 0x201, 0xdd9, 0xdcf, 0x201, 0xddc,
    0xdca, 0x201, 0xdd9, 0xddf, 0x210, 0xe4d, 0xe32, 0x210,
    0xecd, 0xeb2, 0x210, 0xeab, 0xe99, 0x210, 0xeab, 0xea1,
    0x103, 0xf0b, 0x201, 0xf42, 0xfb7, 0x201, 0xf4c, 0xfb7,
    0x201, 0xf51, 0xfb7, 0x201, 0xf56, 0xfb7, 0x201, 0xf5b,
    0xfb7, 0x201, 0xf40, 0xfb5, 0x201, 0xf71, 0xf72, 0x201,
    0xf71, 0xf74, 0x201, 0xfb2, 0xf80, 0x210, 0xfb2, 0xf81,
    0x201, 0xfb3, 0xf80, 0x210, 0xfb3, 0xf81, 0x201, 0xf71,
    0xf80, 0x201, 0xf92, 0xfb7, 0x201, 0xf9c, 0xfb7, 0x201,
    0xfa1, 0xfb7, 0x201, 0xfa6, 0xfb7, 0x201, 0xfab, 0xfb7,
    0x201, 0xf90, 0xfb5, 0x201, 0x1025, 0x102e, 0x109, 0x10dc,
    0x201, 0x1b05, 0x1b35, 0x201, 0x1b07, 0x1b35, 0x201, 0x1b09,
    0x1b35, 0x201, 0x1b0b, 0x1b35, 0x201, 0x1b0d, 0x1b35, 0x201,
    0x1b11, 0x1b35, 0x201, 0x1b3a, 0x1b35, 0x201, 0x1b3c, 0x1b35,
    0x201, 0x1b3e, 0x1b35, 0x201, 0x1b3f, 0x1b35, 0x201, 0x1b42,
    0x1b35, 0x109, 0x41, 0x109, 0xc6, 0x109, 0x42, 0x109,
    0x44, 0x109, 0x45, 0x109, 0x18e, 0x109, 0x47, 0x109,
    0x48, 0x109, 0x49, 0x109, 0x4a, 0x109, 0x4b, 0x109,
    0x4c, 0x109, 0x4d, 0x109, 0x4e, 0x109, 0x4f, 0x109,
    0x222, 0x109, 0x50, 0x109, 0x52, 0x109, 0x54, 0x109,
    0x55, 0x109, 0x57, 0x109, 0x61, 0x109, 0x250, 0x109,
    0x251, 0x109, 0x1d02, 0x109, 0x62, 0x109, 0x64, 0x109,
    0x65, 0x109, 0x259, 0x109, 0x25b, 0x109, 0x25c, 0x109,
    0x67, 0x109, 0x6b, 0x109, 0x6d, 0x109, 0x14b, 0x109,
    0x6f, 0x109, 0x254, 0x109, 0x1d16, 0x109, 0x1d17, 0x109,
    0x70, 0x109, 0x74, 0x109, 0x75, 0x109, 0x1d1d, 0x109,
    0x26f, 0x109, 0x76, 0x109, 0x1d25, 0x109, 0x3b2, 0x109,
    0x3b3, 0x109, 0x3b4, 0x109, 0x3c6, 0x109, 0x3c7, 0x10a,
    0x69, 0x10a, 0x72, 0x10a, 0x75, 0x10a, 0x76, 0x10a,
    0x3b2, 0x10a, 0x3b3, 0x10a, 0x3c1, 0x10a, 0x3c6, 0x10a,
    0x3c7, 0x109, 0x43d, 0x109, 0x252, 0x109, 0x63, 0x109,
    0x255, 0x109, 0xf0, 0x109, 0x25c, 0x109, 0x66, 0x109,
    0x25f, 0x109, 0x261, 0x109, 0x265, 0x109, 0x268, 0x109,
    0x269, 0x109, 0x26a, 0x109, 0x1d7b, 0x109, 0x29d, 0x109,
    0x26d, 0x109, 0x1d85, 0x109, 0x29f, 0x109, 0x271, 0x109,
    0x270, 0x109, 0x272, 0x109, 0x273, 0x109, 0x274, 0x109,
    0x275, 0x109, 0x278, 0x109, 0x282, 0x109, 0x283, 0x109,
    0x1ab, 0x109, 0x289, 0x109, 0x28a, 0x109, 0x1d1c, 0x109,
    0x28b, 0x109, 0x28c, 0x109, 0x7a, 0x109, 0x290, 0x109,
    0x291, 0x109, 0x292, 0x109, 0x3b8, 0x201, 0x41, 0x325,
    0x201, 0x61, 0x325, 0x201, 0x42, 0x307, 0x201, 0x62,
    0x307, 0x201, 0x42, 0x323, 0x201, 0x62, 0x323, 0x201,
    0x42, 0x331, 0x201, 0x62, 0x331, 0x201, 0xc7, 0x301,
    0x201, 0xe7, 0x301, 0x201, 0x44, 0x307, 0x201, 0x64,
    0x307, 0x201, 0x44, 0x323, 0x201, 0x64, 0x323, 0x201,
    0x44, 0x331, 0x201, 0x64, 0x331, 0x201, 0x44, 0x327,
    0x201, 0x64, 0x327, 0x201, 0x44, 0x32d, 0x201, 0x64,
    0x32d, 0x201, 0x112, 0x300, 0x201, 0x113, 0x300, 0x201,
    0x112, 0x301, 0x201, 0x113, 0x301, 0x201, 0x45, 0x32d,
    0x201, 0x65, 0x32d, 0x201, 0x45, 0x330, 0x201, 0x65,
    0x330, 0x201, 0x228, 0x306, 0x201, 0x229, 0x306, 0x201,
    0x46, 0x307, 0x201, 0x66, 0x307, 0x201, 0x47, 0x304,
    0x201, 0x67, 0x304, 0x201, 0x48, 0x307, 0x201, 0x68,
    0x307, 0x201, 0x48, 0x323, 0x201, 0x68, 0x323, 0x201,
    0x48, 0x308, 0x201, 0x68, 0x308, 0x201, 0x48, 0x327,
    0x201, 0x68, 0x327, 0x201, 0x48, 0x32e, 0x201, 0x68,
    0x32e, 0x201, 0x49, 0x330, 0x201, 0x69, 0x330, 0x201,
    0xcf, 0x301, 0x201, 0xef, 0x301, 0x201, 0x4b, 0x301,
    0x201, 0x6b, 0x301, 0x201, 0x4b, 0x323, 0x201, 0x6b,
    0x323, 0x201, 0x4b, 0x331, 0x201, 0x6b, 0x331, 0x201,
    0x4c, 0x323, 0x201, 0x6c, 0x323, 0x201, 0x1e36, 0x304,
    0x201, 0x1e37, 0x304, 0x201, 0x4c, 0x331, 0x201, 0x6c,
    0x331, 0x201, 0x4c, 0x32d, 0x201, 0x6c, 0x32d, 0x201,
    0x4d, 0x301, 0x201, 0x6d, 0x301, 0x201, 0x4d, 0x307,
    0x201, 0x6d, 0x307, 0x201, 0x4d, 0x323, 0x201, 0x6d,
    0x323, 0x201, 0x4e, 0x307, 0x201, 0x6e, 0x307, 0x201,
    0x4e, 0x323, 0x201, 0x6e, 0x323, 0x201, 0x4e, 0x331,
    0x201, 0x6e, 0x331, 0x201, 0x4e, 0x32d, 0x201, 0x6e,
    0x32d, 0x201, 0xd5, 0x301, 0x201, 0xf5, 0x301, 0x201,
    0xd5, 0x308, 0x201, 0xf5, 0x308, 0x201, 0x14c, 0x300,
    0x201, 0x14d, 0x300, 0x201, 0x14c, 0x301, 0x201, 0x14d,
    0x301, 0x201, 0x50, 0x301, 0x201, 0x70, 0x301, 0x201,
    0x50, 0x307, 0x201, 0x70, 0x307, 0x201, 0x52, 0x307,
    0x201, 0x72, 0x307, 0x201, 0x52, 0x323, 0x201, 0x72,
    0x323, 0x201, 0x1e5a, 0x304, 0x201, 0x1e5b, 0x304, 0x201,
    0x52, 0x331, 0x201, 0x72, 0x331, 0x201, 0x53, 0x307,
    0x201, 0x73, 0x307, 0x201, 0x53, 0x323, 0x201, 0x73,
    0x323, 0x201, 0x15a, 0x307, 0x201, 0x15b, 0x307, 0x201,
    0x160, 0x307, 0x201, 0x161, 0x307, 0x201, 0x1e62, 0x307,
    0x201, 0x1e63, 0x307, 0x201, 0x54, 0x307, 0x201, 0x74,
    0x307, 0x201, 0x54, 0x323, 0x201, 0x74, 0x323, 0x201,
    0x54, 0x331, 0x201, 0x74, 0x331, 0x201, 0x54, 0x32d,
    0x201, 0x74, 0x32d, 0x201, 0x55, 0x324, 0x201, 0x75,
    0x324, 0x201, 0x55, 0x330, 0x201, 0x75, 0x330, 0x201,
    0x55, 0x32d, 0x201, 0x75, 0x32d, 0x201, 0x168, 0x301,
    0x201, 0x169, 0x301, 0x201, 0x16a, 0x308, 0x201, 0x16b,
    0x308, 0x201, 0x56, 0x303, 0x201, 0x76, 0x303, 0x201,
    0x56, 0x323, 0x201, 0x76, 0x323, 0x201, 0x57, 0x300,
    0x201, 0x77, 0x300, 0x201, 0x57, 0x301, 0x201, 0x77,
    0x301, 0x201, 0x57, 0x308, 0x201, 0x77, 0x308, 0x201,
    0x57, 0x307, 0x201, 0x77, 0x307, 0x201, 0x57, 0x323,
    0x201, 0x77, 0x323, 0x201, 0x58, 0x307, 0x201, 0x78,
    0x307, 0x201, 0x58, 0x308, 0x201, 0x78, 0x308, 0x201,
    0x59, 0x307, 0x201, 0x79, 0x307, 0x201, 0x5a, 0x302,
    0x201, 0x7a, 0x302, 0x201, 0x5a, 0x323, 0x201, 0x7a,
    0x323, 0x201, 0x5a, 0x331, 0x201, 0x7a, 0x331, 0x201,
    0x68, 0x331, 0x201, 0x74, 0x308, 0x201, 0x77, 0x30a,
    0x201, 0x79, 0x30a, 0x210, 0x61, 0x2be, 0x201, 0x17f,
    0x307, 0x201, 0x41, 0x323, 0x201, 0x61, 0x323, 0x201,
    0x41, 0x309, 0x201, 0x61, 0x309, 0x201, 0xc2, 0x301,
    0x201, 0xe2, 0x301, 0x201, 0xc2, 0x300, 0x201, 0xe2,
    0x300, 0x201, 0xc2, 0x309, 0x201, 0xe2, 0x309, 0x201,
    0xc2, 0x303, 0x201, 0xe2, 0x303, 0x201, 0x1ea0, 0x302,
    0x201, 0x1ea1, 0x302, 0x201, 0x102, 0x301, 0x201, 0x103,
    0x301, 0x201, 0x102, 0x300, 0x201, 0x103, 0x300, 0x201,
    0x102, 0x309, 0x201, 0x103, 0x309, 0x201, 0x102, 0x303,
    0x201, 0x103, 0x303, 0x201, 0x1ea0, 0x306, 0x201, 0x1ea1,
    0x306, 0x201, 0x45, 0x323, 0x201, 0x65, 0x323, 0x201,
    0x45, 0x309, 0x201, 0x65, 0x309, 0x201, 0x45, 0x303,
    0x201, 0x65, 0x303, 0x201, 0xca, 0x301, 0x201, 0xea,
    0x301, 0x201, 0xca, 0x300, 0x201, 0xea, 0x300, 0x201,
    0xca, 0x309, 0x201, 0xea, 0x309, 0x201, 0xca, 0x303,
    0x201, 0xea, 0x303, 0x201, 0x1eb8, 0x302, 0x201, 0x1eb9,
    0x302, 0x201, 0x49, 0x309, 0x201, 0x69, 0x309, 0x201,
    0x49, 0x323, 0x201, 0x69, 0x323, 0x201, 0x4f, 0x323,
    0x201, 0x6f, 0x323, 0x201, 0x4f, 0x309, 0x201, 0x6f,
    0x309, 0x201, 0xd4, 0x301, 0x201, 0xf4, 0x301, 0x201,
    0xd4, 0x300, 0x201, 0xf4, 0x300, 0x201, 0xd4, 0x309,
    0x201, 0xf4, 0x309, 0x201, 0xd4, 0x303, 0x201, 0xf4,
    0x303, 0x201, 0x1ecc, 0x302, 0x201, 0x1ecd, 0x302, 0x201,
    0x1a0, 0x301, 0x201, 0x1a1, 0x301, 0x201, 0x1a0, 0x300,
    0x201, 0x1a1, 0x300, 0x201, 0x1a0, 0x309, 0x201, 0x1a1,
    0x309, 0x201, 0x1a0, 0x303, 0x201, 0x1a1, 0x303, 0x201,
    0x1a0, 0x323, 0x201, 0x1a1, 0x323, 0x201, 0x55, 0x323,
    0x201, 0x75, 0x323, 0x201, 0x55, 0x309, 0x201, 0x75,
    0x309, 0x201, 0x1af, 0x301, 0x201, 0x1b0, 0x301, 0x201,
    0x1af, 0x300, 0x201, 0x1b0, 0x300, 0x201, 0x1af, 0x309,
    0x201, 0x1b0, 0x309, 0x201, 0x1af, 0x303, 0x201, 0x1b0,
    0x303, 0x201, 0x1af, 0x323, 0x201, 0x1b0, 0x323, 0x201,
    0x59, 0x300, 0x201, 0x79, 0x300, 0x201, 0x59, 0x323,
    0x201, 0x79, 0x323, 0x201, 0x59, 0x309, 0x201, 0x79,
    0x309, 0x201, 0x59, 0x303, 0x201, 0x79, 0x303, 0x201,
    0x3b1, 0x313, 0x201, 0x3b1, 0x314, 0x201, 0x1f00, 0x300,
    0x201, 0x1f01, 0x300, 0x201, 0x1f00, 0x301, 0x201, 0x1f01,
    0x301, 0x201, 0x1f00, 0x342, 0x201, 0x1f01, 0x342, 0x201,
    0x391, 0x313, 0x201, 0x391, 0x314, 0x201, 0x1f08, 0x300,
    0x201, 0x1f09, 0x300, 0x201, 0x1f08, 0x301, 0x201, 0x1f09,
    0x301, 0x201, 0x1f08, 0x342, 0x201, 0x1f09, 0x342, 0x201,
    0x3b5, 0x313, 0x201, 0x3b5, 0x314, 0x201, 0x1f10, 0x300,
    0x201, 0x1f11, 0x300, 0x201, 0x1f10, 0x301, 0x201, 0x1f11,
    0x301, 0x201, 0x395, 0x313, 0x201, 0x395, 0x314, 0x201,
    0x1f18, 0x300, 0x201, 0x1f19, 0x300, 0x201, 0x1f18, 0x301,
    0x201, 0x1f19, 0x301, 0x201, 0x3b7, 0x313, 0x201, 0x3b7,
    0x314, 0x201, 0x1f20, 0x300, 0x201, 0x1f21, 0x300, 0x201,
    0x1f20, 0x301, 0x201, 0x1f21, 0x301, 0x201, 0x1f20, 0x342,
    0x201, 0x1f21, 0x342, 0x201, 0x397, 0x313, 0x201, 0x397,
    0x314, 0x201, 0x1f28, 0x300, 0x201, 0x1f29, 0x300, 0x201,
    0x1f28, 0x301, 0x201, 0x1f29, 0x301, 0x201, 0x1f28, 0x342,
    0x201, 0x1f29, 0x342, 0x201, 0x3b9, 0x313, 0x201, 0x3b9,
    0x314, 0x201, 0x1f30, 0x300, 0x201, 0x1f31, 0x300, 0x201,
    0x1f30, 0x301, 0x201, 0x1f31, 0x301, 0x201, 0x1f30, 0x342,
    0x201, 0x1f31, 0x342, 0x201, 0x399, 0x313, 0x201, 0x399,
    0x314, 0x201, 0x1f38, 0x300, 0x201, 0x1f39, 0x300, 0x201,
    0x1f38, 0x301, 0x201, 0x1f39, 0x301, 0x201, 0x1f38, 0x342,
    0x201, 0x1f39, 0x342, 0x201, 0x3bf, 0x313, 0x201, 0x3bf,
    0x314, 0x201, 0x1f40, 0x300, 0x201, 0x1f41, 0x300, 0x201,
    0x1f40, 0x301, 0x201, 0x1f41, 0x301, 0x201, 0x39f, 0x313,
    0x201, 0x39f, 0x314, 0x201, 0x1f48, 0x300, 0x201, 0x1f49,
    0x300, 0x201, 0x1f48, 0x301, 0x201, 0x1f49, 0x301, 0x201,
    0x3c5, 0x313, 0x201, 0x3c5, 0x314, 0x201, 0x1f50, 0x300,
    0x201, 0x1f51, 0x300, 0x201, 0x1f50, 0x301, 0x201, 0x1f51,
    0x301, 0x201, 0x1f50, 0x342, 0x201, 0x1f51, 0x342, 0x201,
    0x3a5, 0x314, 0x201, 0x1f59, 0x300, 0x201, 0x1f59, 0x301,
    0x201, 0x1f59, 0x342, 0x201, 0x3c9, 0x313, 0x201, 0x3c9,
    0x314, 0x201, 0x1f60, 0x300, 0x201, 0x1f61, 0x300, 0x201,
    0x1f60, 0x301, 0x201, 0x1f61, 0x301, 0x201, 0x1f60, 0x342,
    0x201, 0x1f61, 0x342, 0x201, 0x3a9, 0x313, 0x201, 0x3a9,
    0x314, 0x201, 0x1f68, 0x300, 0x201, 0x1f69, 0x300, 0x201,
    0x1f68, 0x301, 0x201, 0x1f69, 0x301, 0x201, 0x1f68, 0x342,
    0x201, 0x1f69, 0x342, 0x201, 0x3b1, 0x300, 0x101, 0x3ac,
    0x201, 0x3b5, 0x300, 0x101, 0x3ad, 0x201, 0x3b7, 0x300,
    0x101, 0x3ae, 0x201, 0x3b9, 0x300, 0x101, 0x3af, 0x201,
    0x3bf, 0x300, 0x101, 0x3cc, 0x201, 0x3c5, 0x300, 0x101,
    0x3cd, 0x201, 0x3c9, 0x300, 0x101, 0x3ce, 0x201, 0x1f00,
    0x345, 0x201, 0x1f01, 0x345, 0x201, 0x1f02, 0x345, 0x201,
    0x1f03, 0x345, 0x201, 0x1f04, 0x345, 0x201, 0x1f05, 0x345,
    0x201, 0x1f06, 0x345, 0x201, 0x1f07, 0x345, 0x201, 0x1f08,
    0x345, 0x201, 0x1f09, 0x345, 0x201, 0x1f0a, 0x345, 0x201,
    0x1f0b, 0x345, 0x201, 0x1f0c, 0x345, 0x201, 0x1f0d, 0x345,
    0x201, 0x1f0e, 0x345, 0x201, 0x1f0f, 0x345, 0x201, 0x1f20,
    0x345, 0x201, 0x1f21, 0x345, 0x201, 0x1f22, 0x345, 0x201,
    0x1f23, 0x345, 0x201, 0x1f24, 0x345, 0x201, 0x1f25, 0x345,
    0x201, 0x1f26, 0x345, 0x201, 0x1f27, 0x345, 0x201, 0x1f28,
    0x345, 0x201, 0x1f29, 0x345, 0x201, 0x1f2a, 0x345, 0x201,
    0x1f2b, 0x345, 0x201, 0x1f2c, 0x345, 0x201, 0x1f2d, 0x345,
    0x201, 0x1f2e, 0x345, 0x201, 0x1f2f, 0x345, 0x201, 0x1f60,
    0x345, 0x201, 0x1f61, 0x345, 0x201, 0x1f62, 0x345, 0x201,
    0x1f63, 0x345, 0x201, 0x1f64, 0x345, 0x201, 0x1f65, 0x345,
    0x201, 0x1f66, 0x345, 0x201, 0x1f67, 0x345, 0x201, 0x1f68,
    0x345, 0x201, 0x1f69, 0x345, 0x201, 0x1f6a, 0x345, 0x201,
    0x1f6b, 0x345, 0x201, 0x1f6c, 0x345, 0x201, 0x1f6d, 0x345,
    0x201, 0x1f6e, 0x345, 0x201, 0x1f6f, 0x345, 0x201, 0x3b1,
    0x306, 0x201, 0x3b1, 0x304, 0x201, 0x1f70, 0x345, 0x201,
    0x3b1, 0x345, 0x201, 0x3ac, 0x345, 0x201, 0x3b1, 0x342,
    0x201, 0x1fb6, 0x345, 0x201, 0x391, 0x306, 0x201, 0x391,
    0x304, 0x201, 0x391, 0x300, 0x101, 0x386, 0x201, 0x391,
    0x345, 0x210, 0x20, 0x313, 0x101, 0x3b9, 0x210, 0x20,
    0x313, 0x210, 0x20, 0x342, 0x201, 0xa8, 0x342, 0x201,
    0x1f74, 0x345, 0x201, 0x3b7, 0x345, 0x201, 0x3ae, 0x345,
    0x201, 0x3b7, 0x342, 0x201, 0x1fc6, 0x345, 0x201, 0x395,
    0x300, 0x101, 0x388, 0x201, 0x397, 0x300, 0x101, 0x389,
    0x201, 0x397, 0x345, 0x201, 0x1fbf, 0x300, 0x201, 0x1fbf,
    0x301, 0x201, 0x1fbf, 0x342, 0x201, 0x3b9, 0x306, 0x201,
    0x3b9, 0x304, 0x201, 0x3ca, 0x300, 0x101, 0x390, 0x201,
    0x3b9, 0x342, 0x201, 0x3ca, 0x342, 0x201, 0x399, 0x306,
    0x201, 0x399, 0x304, 0x201, 0x399, 0x300, 0x101, 0x38a,
    0x201, 0x1ffe, 0x300, 0x201, 0x1ffe, 0x301, 0x201, 0x1ffe,
    0x342, 0x201, 0x3c5, 0x306, 0x201, 0x3c5, 0x304, 0x201,
    0x3cb, 0x300, 0x101, 0x3b0, 0x201, 0x3c1, 0x313, 0x201,
    0x3c1, 0x314, 0x201, 0x3c5, 0x342, 0x201, 0x3cb, 0x342,
    0x201, 0x3a5, 0x306, 0x201, 0x3a5, 0x304, 0x201, 0x3a5,
    0x300, 0x101, 0x38e, 0x201, 0x3a1, 0x314, 0x201, 0xa8,
    0x300, 0x101, 0x385, 0x101, 0x60, 0x201, 0x1f7c, 0x345,
    0x201, 0x3c9, 0x345, 0x201, 0x3ce, 0x345, 0x201, 0x3c9,
    0x342, 0x201, 0x1ff6, 0x345, 0x201, 0x39f, 0x300, 0x101,
    0x38c, 0x201, 0x3a9, 0x300, 0x101, 0x38f, 0x201, 0x3a9,
    0x345, 0x101, 0xb4, 0x210, 0x20, 0x314, 0x101, 0x2002,
    0x101, 0x2003, 0x110, 0x20, 0x110, 0x20, 0x110, 0x20,
    0x110, 0x20, 0x110, 0x20, 0x103, 0x20, 0x110, 0x20,
    0x110, 0x20, 0x110, 0x20, 0x103, 0x2010, 0x210, 0x20,
    0x333, 0x110, 0x2e, 0x210, 0x2e, 0x2e, 0x310, 0x2e,
    0x2e, 0x2e, 0x103, 0x20, 0x210, 0x2032, 0x2032, 0x310,
    0x2032, 0x2032, 0x2032, 0x210, 0x2035, 0x2035, 0x310, 0x2035,
    0x2035, 0x2035, 0x210, 0x21, 0x21, 0x210, 0x20, 0x305,
    0x210, 0x3f, 0x3f, 0x210, 0x3f, 0x21, 0x210, 0x21,
    0x3f, 0x410, 0x2032, 0x2032, 0x2032, 0x2032, 0x110, 0x20,
    0x109, 0x30, 0x109, 0x69, 0x109, 0x34, 0x109, 0x35,
    0x109, 0x36, 0x109, 0x37, 0x109, 0x38, 0x109, 0x39,
    0x109, 0x2b, 0x109, 0x2212, 0x109, 0x3d, 0x109, 0x28,
    0x109, 0x29, 0x109, 0x6e, 0x10a, 0x30, 0x10a, 0x31,
    0x10a, 0x32, 0x10a, 0x33, 0x10a, 0x34, 0x10a, 0x35,
    0x10a, 0x36, 0x10a, 0x37, 0x10a, 0x38, 0x10a, 0x39,
    0x10a, 0x2b, 0x10a, 0x2212, 0x10a, 0x3d, 0x10a, 0x28,
    0x10a, 0x29, 0x10a, 0x61, 0x10a, 0x65, 0x10a, 0x6f,
    0x10a, 0x78, 0x10a, 0x259, 0x10a, 0x68, 0x10a, 0x6b,
    0x10a, 0x6c, 0x10a, 0x6d, 0x10a, 0x6e, 0x10a, 0x70,
    0x10a, 0x73, 0x10a, 0x74, 0x210, 0x52, 0x73, 0x310,
    0x61, 0x2f, 0x63, 0x310, 0x61, 0x2f, 0x73, 0x102,
    0x43, 0x210, 0xb0, 0x43, 0x310, 0x63, 0x2f, 0x6f,
    0x310, 0x63, 0x2f, 0x75, 0x110, 0x190, 0x210, 0xb0,
    0x46, 0x102, 0x67, 0x102, 0x48, 0x102, 0x48, 0x102,
    0x48, 0x102, 0x68, 0x102, 0x127, 0x102, 0x49, 0x102,
    0x49, 0x102, 0x4c, 0x102, 0x6c, 0x102, 0x4e, 0x210,
    0x4e, 0x6f, 0x102, 0x50, 0x102, 0x51, 0x102, 0x52,
    0x102, 0x52, 0x102, 0x52, 0x209, 0x53, 0x4d, 0x310,
    0x54, 0x45, 0x4c, 0x209, 0x54, 0x4d, 0x102, 0x5a,
    0x101, 0x3a9, 0x102, 0x5a, 0x101, 0x4b, 0x101, 0xc5,
    0x102, 0x42, 0x102, 0x43, 0x102, 0x65, 0x102, 0x45,
    0x102, 0x46, 0x102, 0x4d, 0x102, 0x6f, 0x110, 0x5d0,
    0x110, 0x5d1, 0x110, 0x5d2, 0x110, 0x5d3, 0x102, 0x69,
    0x310, 0x46, 0x41, 0x58, 0x102, 0x3c0, 0x102, 0x3b3,
    0x102, 0x393, 0x102, 0x3a0, 0x102, 0x2211, 0x102, 0x44,
    0x102, 0x64, 0x102, 0x65, 0x102, 0x69, 0x102, 0x6a,
    0x311, 0x31, 0x2044, 0x37, 0x311, 0x31, 0x2044, 0x39,
    0x411, 0x31, 0x2044, 0x31, 0x30, 0x311, 0x31, 0x2044,
    0x33, 0x311, 0x32, 0x2044, 0x33, 0x311, 0x31, 0x2044,
    0x35, 0x311, 0x32, 0x2044, 0x35, 0x311, 0x33, 0x2044,
    0x35, 0x311, 0x34, 0x2044, 0x35, 0x311, 0x31, 0x2044,
    0x36, 0x311, 0x35, 0x2044, 0x36, 0x311, 0x31, 0x2044,
    0x38, 0x311, 0x33, 0x2044, 0x38, 0x311, 0x35, 0x2044,
    0x38, 0x311, 0x37, 0x2044, 0x38, 0x211, 0x31, 0x2044,
    0x110, 0x49, 0x210, 0x49, 0x49, 0x310, 0x49, 0x49,
    0x49, 0x210, 0x49, 0x56, 0x110, 0x56, 0x210, 0x56,
    0x49, 0x310, 0x56, 0x49, 0x49, 0x410, 0x56, 0x49,
    0x49, 0x49, 0x210, 0x49, 0x58, 0x110, 0x58, 0x210,
    0x58, 0x49, 0x310, 0x58, 0x49, 0x49, 0x110, 0x4c,
    0x110, 0x43, 0x110, 0x44, 0x110, 0x4d, 0x110, 0x69,
    0x210, 0x69, 0x69, 0x310, 0x69, 0x69, 0x69, 0x210,
    0x69, 0x76, 0x110, 0x76, 0x210, 0x76, 0x69, 0x310,
    0x76, 0x69, 0x69, 0x410, 0x76, 0x69, 0x69, 0x69,
    0x210, 0x69, 0x78, 0x110, 0x78, 0x210, 0x78, 0x69,
    0x310, 0x78, 0x69, 0x69, 0x110, 0x6c, 0x110, 0x63,
    0x110, 0x64, 0x110, 0x6d, 0x311, 0x30, 0x2044, 0x33,
    0x201, 0x2190, 0x338, 0x201, 0x2192, 0x338, 0x201, 0x2194,
    0x338, 0x201, 0x21d0, 0x338, 0x201, 0x21d4, 0x338, 0x201,
    0x21d2, 0x338, 0x201, 0x2203, 0x338, 0x201, 0x2208, 0x338,
    0x201, 0x220b, 0x338, 0x201, 0x2223, 0x338, 0x201, 0x2225,
    0x338, 0x210, 0x222b, 0x222b, 0x310, 0x222b, 0x222b, 0x222b,
    0x210, 0x222e, 0x222e, 0x310, 0x222e, 0x222e, 0x222e, 0x201,
    0x223c, 0x338, 0x201, 0x2243, 0x338, 0x201, 0x2245, 0x338,
    0x201, 0x2248, 0x338, 0x201, 0x3d, 0x338, 0x201, 0x2261,
    0x338, 0x201, 0x224d, 0x338, 0x201, 0x3c, 0x338, 0x201,
    0x3e, 0x338, 0x201, 0x2264, 0x338, 0x201, 0x2265, 0x338,
    0x201, 0x2272, 0x338, 0x201, 0x2273, 0x338, 0x201, 0x2276,
    0x338, 0x201, 0x2277, 0x338, 0x201, 0x227a, 0x338, 0x201,
    0x227b, 0x338, 0x201, 0x2282, 0x338, 0x201, 0x2283, 0x338,
    0x201, 0x2286, 0x338, 0x201, 0x2287, 0x338, 0x201, 0x22a2,
    0x338, 0x201, 0x22a8, 0x338, 0x201, 0x22a9, 0x338, 0x201,
    0x22ab, 0x338, 0x201, 0x227c, 0x338, 0x201, 0x227d, 0x338,
    0x201, 0x2291, 0x338, 0x201, 0x2292, 0x338, 0x201, 0x22b2,
    0x338, 0x201, 0x22b3, 0x338, 0x201, 0x22b4, 0x338, 0x201,
    0x22b5, 0x338, 0x101, 0x3008, 0x101, 0x3009, 0x108, 0x31,
    0x108, 0x32, 0x108, 0x33, 0x108, 0x34, 0x108, 0x35,
    0x108, 0x36, 0x108, 0x37, 0x108, 0x38, 0x108, 0x39,
    0x208, 0x31, 0x30, 0x208, 0x31, 0x31, 0x208, 0x31,
    0x32, 0x208, 0x31, 0x33, 0x208, 0x31, 0x34, 0x208,
    0x31, 0x35, 0x208, 0x31, 0x36, 0x208, 0x31, 0x37,
    0x208, 0x31, 0x38, 0x208, 0x31, 0x39, 0x208, 0x32,
    0x30, 0x310, 0x28, 0x31, 0x29, 0x310, 0x28, 0x32,
    0x29, 0x310, 0x28, 0x33, 0x29, 0x310, 0x28, 0x34,
    0x29, 0x310, 0x28, 0x35, 0x29, 0x310, 0x28, 0x36,
    0x29, 0x310, 0x28, 0x37, 0x29, 0x310, 0x28, 0x38,
    0x29, 0x310, 0x28, 0x39, 0x29, 0x410, 0x28, 0x31,
    0x30, 0x29, 0x410, 0x28, 0x31, 0x31, 0x29, 0x410,
    0x28, 0x31, 0x32, 0x29, 0x410, 0x28, 0x31, 0x33,
    0x29, 0x410, 0x28, 0x31, 0x34, 0x29, 0x410, 0x28,
    0x31, 0x35, 0x29, 0x410, 0x28, 0x31, 0x36, 0x29,
    0x410, 0x28, 0x31, 0x37, 0x29, 0x410, 0x28, 0x31,
    0x38, 0x29, 0x410, 0x28, 0x31, 0x39, 0x29, 0x410,
    0x28, 0x32, 0x30, 0x29, 0x210, 0x31, 0x2e, 0x210,
    0x32, 0x2e, 0x210, 0x33, 0x2e, 0x210, 0x34, 0x2e,
    0x210, 0x35, 0x2e, 0x210, 0x36, 0x2e, 0x210, 0x37,
    0x2e, 0x210, 0x38, 0x2e, 0x210, 0x39, 0x2e, 0x310,
    0x31, 0x30, 0x2e, 0x310, 0x31, 0x31, 0x2e, 0x310,
    0x31, 0x32, 0x2e, 0x310, 0x31, 0x33, 0x2e, 0x310,
    0x31, 0x34, 0x2e, 0x310, 0x31, 0x35, 0x2e, 0x310,
    0x31, 0x36, 0x2e, 0x310, 0x31, 0x37, 0x2e, 0x310,
    0x31, 0x38, 0x2e, 0x310, 0x31, 0x39, 0x2e, 0x310,
    0x32, 0x30, 0x2e, 0x310, 0x28, 0x61, 0x29, 0x310,
    0x28, 0x62, 0x29, 0x310, 0x28, 0x63, 0x29, 0x310,
    0x28, 0x64, 0x29, 0x310, 0x28, 0x65, 0x29, 0x310,
    0x28, 0x66, 0x29, 0x310, 0x28, 0x67, 0x29, 0x310,
    0x28, 0x68, 0x29, 0x310, 0x28, 0x69, 0x29, 0x310,
    0x28, 0x6a, 0x29, 0x310, 0x28, 0x6b, 0x29, 0x310,
    0x28, 0x6c, 0x29, 0x310, 0x28, 0x6d, 0x29, 0x310,
    0x28, 0x6e, 0x29, 0x310, 0x28, 0x6f, 0x29, 0x310,
    0x28, 0x70, 0x29, 0x310, 0x28, 0x71, 0x29, 0x310,
    0x28, 0x72, 0x29, 0x310, 0x28, 0x73, 0x29, 0x310,
    0x28, 0x74, 0x29, 0x310, 0x28, 0x75, 0x29, 0x310,
    0x28, 0x76, 0x29, 0x310, 0x28, 0x77, 0x29, 0x310,
    0x28, 0x78, 0x29, 0x310, 0x28, 0x79, 0x29, 0x310,
    0x28, 0x7a, 0x29, 0x108, 0x41, 0x108, 0x42, 0x108,
    0x43, 0x108, 0x44, 0x108, 0x45, 0x108, 0x46, 0x108,
    0x47, 0x108, 0x48, 0x108, 0x49, 0x108, 0x4a, 0x108,
    0x4b, 0x108, 0x4c, 0x108, 0x4d, 0x108, 0x4e, 0x108,
    0x4f, 0x108, 0x50, 0x108, 0x51, 0x108, 0x52, 0x108,
    0x53, 0x108, 0x54, 0x108, 0x55, 0x108, 0x56, 0x108,
    0x57, 0x108, 0x58, 0x108, 0x59, 0x108, 0x5a, 0x108,
    0x61, 0x108, 0x62, 0x108, 0x63, 0x108, 0x64, 0x108,
    0x65, 0x108, 0x66, 0x108, 0x67, 0x108, 0x68, 0x108,
    0x69, 0x108, 0x6a, 0x108, 0x6b, 0x108, 0x6c, 0x108,
    0x6d, 0x108, 0x6e, 0x108, 0x6f, 0x108, 0x70, 0x108,
    0x71, 0x108, 0x72, 0x108, 0x73, 0x108, 0x74, 0x108,
    0x75, 0x108, 0x76, 0x108, 0x77, 0x108, 0x78, 0x108,
    0x79, 0x108, 0x7a, 0x108, 0x30, 0x410, 0x222b, 0x222b,
    0x222b, 0x222b, 0x310, 0x3a, 0x3a, 0x3d, 0x210, 0x3d,
    0x3d, 0x310, 0x3d, 0x3d, 0x3d, 0x201, 0x2add, 0x338,
    0x10a, 0x6a, 0x109, 0x56, 0x109, 0x2d61, 0x110, 0x6bcd,
    0x110, 0x9f9f, 0x110, 0x4e00, 0x110, 0x4e28, 0x110, 0x4e36,
    0x110, 0x4e3f, 0x110, 0x4e59, 0x110, 0x4e85, 0x110, 0x4e8c,
    0x110, 0x4ea0, 0x110, 0x4eba, 0x110, 0x513f, 0x110, 0x5165,
    0x110, 0x516b, 0x110, 0x5182, 0x110, 0x5196, 0x110, 0x51ab,
    0x110, 0x51e0, 0x110, 0x51f5, 0x110, 0x5200, 0x110, 0x529b,
    0x110, 0x52f9, 0x110, 0x5315, 0x110, 0x531a, 0x110, 0x5338,
    0x110, 0x5341, 0x110, 0x535c, 0x110, 0x5369, 0x110, 0x5382,
    0x110, 0x53b6, 0x110, 0x53c8, 0x110, 0x53e3, 0x110, 0x56d7,
    0x110, 0x571f, 0x110, 0x58eb, 0x110, 0x5902, 0x110, 0x590a,
    0x110, 0x5915, 0x110, 0x5927, 0x110, 0x5973, 0x110, 0x5b50,
    0x110, 0x5b80, 0x110, 0x5bf8, 0x110, 0x5c0f, 0x110, 0x5c22,
    0x110, 0x5c38, 0x110, 0x5c6e, 0x110, 0x5c71, 0x110, 0x5ddb,
    0x110, 0x5de5, 0x110, 0x5df1, 0x110, 0x5dfe, 0x110, 0x5e72,
    0x110, 0x5e7a, 0x110, 0x5e7f, 0x110, 0x5ef4, 0x110, 0x5efe,
    0x110, 0x5f0b, 0x110, 0x5f13, 0x110, 0x5f50, 0x110, 0x5f61,
    0x110, 0x5f73, 0x110, 0x5fc3, 0x110, 0x6208, 0x110, 0x6236,
    0x110, 0x624b, 0x110, 0x652f, 0x110, 0x6534, 0x110, 0x6587,
    0x110, 0x6597, 0x110, 0x65a4, 0x110, 0x65b9, 0x110, 0x65e0,
    0x110, 0x65e5, 0x110, 0x66f0, 0x110, 0x6708, 0x110, 0x6728,
    0x110, 0x6b20, 0x110, 0x6b62, 0x110, 0x6b79, 0x110, 0x6bb3,
    0x110, 0x6bcb, 0x110, 0x6bd4, 0x110, 0x6bdb, 0x110, 0x6c0f,
    0x110, 0x6c14, 0x110, 0x6c34, 0x110, 0x706b, 0x110, 0x722a,
    0x110, 0x7236, 0x110, 0x723b, 0x110, 0x723f, 0x110, 0x7247,
    0x110, 0x7259, 0x110, 0x725b, 0x110, 0x72ac, 0x110, 0x7384,
    0x110, 0x7389, 0x110, 0x74dc, 0x110, 0x74e6, 0x110, 0x7518,
    0x110, 0x751f, 0x110, 0x7528, 0x110, 0x7530, 0x110, 0x758b,
    0x110, 0x7592, 0x110, 0x7676, 0x110, 0x767d, 0x110, 0x76ae,
    0x110, 0x76bf, 0x110, 0x76ee, 0x110, 0x77db, 0x110, 0x77e2,
    0x110, 0x77f3, 0x110, 0x793a, 0x110, 0x79b8, 0x110, 0x79be,
    0x110, 0x7a74, 0x110, 0x7acb, 0x110, 0x7af9, 0x110, 0x7c73,
    0x110, 0x7cf8, 0x110, 0x7f36, 0x110, 0x7f51, 0x110, 0x7f8a,
    0x110, 0x7fbd, 0x110, 0x8001, 0x110, 0x800c, 0x110, 0x8012,
    0x110, 0x8033, 0x110, 0x807f, 0x110, 0x8089, 0x110, 0x81e3,
    0x110, 0x81ea, 0x110, 0x81f3, 0x110, 0x81fc, 0x110, 0x820c,
    0x110, 0x821b, 0x110, 0x821f, 0x110, 0x826e, 0x110, 0x8272,
    0x110, 0x8278, 0x110, 0x864d, 0x110, 0x866b, 0x110, 0x8840,
    0x110, 0x884c, 0x110, 0x8863, 0x110, 0x897e, 0x110, 0x898b,
    0x110, 0x89d2, 0x110, 0x8a00, 0x110, 0x8c37, 0x110, 0x8c46,
    0x110, 0x8c55, 0x110, 0x8c78, 0x110, 0x8c9d, 0x110, 0x8d64,
    0x110, 0x8d70, 0x110, 0x8db3, 0x110, 0x8eab, 0x110, 0x8eca,
    0x110, 0x8f9b, 0x110, 0x8fb0, 0x110, 0x8fb5, 0x110, 0x9091,
    0x110, 0x9149, 0x110, 0x91c6, 0x110, 0x91cc, 0x110, 0x91d1,
    0x110, 0x9577, 0x110, 0x9580, 0x110, 0x961c, 0x110, 0x96b6,
    0x110, 0x96b9, 0x110, 0x96e8, 0x110, 0x9751, 0x110, 0x975e,
    0x110, 0x9762, 0x110, 0x9769, 0x110, 0x97cb, 0x110, 0x97ed,
    0x110, 0x97f3, 0x110, 0x9801, 0x110, 0x98a8, 0x110, 0x98db,
    0x110, 0x98df, 0x110, 0x9996, 0x110, 0x9999, 0x110, 0x99ac,
    0x110, 0x9aa8, 0x110, 0x9ad8, 0x110, 0x9adf, 0x110, 0x9b25,
    0x110, 0x9b2f, 0x110, 0x9b32, 0x110, 0x9b3c, 0x110, 0x9b5a,
    0x110, 0x9ce5, 0x110, 0x9e75, 0x110, 0x9e7f, 0x110, 0x9ea5,
    0x110, 0x9ebb, 0x110, 0x9ec3, 0x110, 0x9ecd, 0x110, 0x9ed1,
    0x110, 0x9ef9, 0x110, 0x9efd, 0x110, 0x9f0e, 0x110, 0x9f13,
    0x110, 0x9f20, 0x110, 0x9f3b, 0x110, 0x9f4a, 0x110, 0x9f52,
    0x110, 0x9f8d, 0x110, 0x9f9c, 0x110, 0x9fa0, 0x10c, 0x20,
    0x110, 0x3012, 0x110, 0x5341, 0x110, 0x5344, 0x110, 0x5345,
    0x201, 0x304b, 0x3099, 0x201, 0x304d, 0x3099, 0x201, 0x304f,
    0x3099, 0x201, 0x3051, 0x3099, 0x201, 0x3053, 0x3099, 0x201,
    0x3055, 0x3099, 0x201, 0x3057, 0x3099, 0x201, 0x3059, 0x3099,
    0x201, 0x305b, 0x3099, 0x201, 0x305d, 0x3099, 0x201, 0x305f,
    0x3099, 0x201, 0x3061, 0x3099, 0x201, 0x3064, 0x3099, 0x201,
    0x3066, 0x3099, 0x201, 0x3068, 0x3099, 0x201, 0x306f, 0x3099,
    0x201, 0x306f, 0x309a, 0x201, 0x3072, 0x3099, 0x201, 0x3072,
    0x309a, 0x201, 0x3075, 0x3099, 0x201, 0x3075, 0x309a, 0x201,
    0x3078, 0x3099, 0x201, 0x3078, 0x309a, 0x201, 0x307b, 0x3099,
    0x201, 0x307b, 0x309a, 0x201, 0x3046, 0x3099, 0x210, 0x20,
    0x3099, 0x210, 0x20, 0x309a, 0x201, 0x309d, 0x3099, 0x20b,
    0x3088, 0x308a, 0x201, 0x30ab, 0x3099, 0x201, 0x30ad, 0x3099,
    0x201, 0x30af, 0x3099, 0x201, 0x30b1, 0x3099, 0x201, 0x30b3,
    0x3099, 0x201, 0x30b5, 0x3099, 0x201, 0x30b7, 0x3099, 0x201,
    0x30b9, 0x3099, 0x201, 0x30bb, 0x3099, 0x201, 0x30bd, 0x3099,
    0x201, 0x30bf, 0x3099, 0x201, 0x30c1, 0x3099, 0x201, 0x30c4,
    0x3099, 0x201, 0x30c6, 0x3099, 0x201, 0x30c8, 0x3099, 0x201,
    0x30cf, 0x3099, 0x201, 0x30cf, 0x309a, 0x201, 0x30d2, 0x3099,
    0x201, 0x30d2, 0x309a, 0x201, 0x30d5, 0x3099, 0x201, 0x30d5,
    0x309a, 0x201, 0x30d8, 0x3099, 0x201, 0x30d8, 0x309a, 0x201,
    0x30db, 0x3099, 0x201, 0x30db, 0x309a, 0x201, 0x30a6, 0x3099,
    0x201, 0x30ef, 0x3099, 0x201, 0x30f0, 0x3099, 0x201, 0x30f1,
    0x3099, 0x201, 0x30f2, 0x3099, 0x201, 0x30fd, 0x3099, 0x20b,
    0x30b3, 0x30c8, 0x110, 0x1100, 0x110, 0x1101, 0x110, 0x11aa,
    0x110, 0x1102, 0x110, 0x11ac, 0x110, 0x11ad, 0x110, 0x1103,
    0x110, 0x1104, 0x110, 0x1105, 0x110, 0x11b0, 0x110, 0x11b1,
    0x110, 0x11b2, 0x110, 0x11b3, 0x110, 0x11b4, 0x110, 0x11b5,
    0x110, 0x111a, 0x110, 0x1106, 0x110, 0x1107, 0x110, 0x1108,
    0x110, 0x1121, 0x110, 0x1109, 0x110, 0x110a, 0x110, 0x110b,
    0x110, 0x110c, 0x110, 0x110d, 0x110, 0x110e, 0x110, 0x110f,
    0x110, 0x1110, 0x110, 0x1111, 0x110, 0x1112, 0x110, 0x1161,
    0x110, 0x1162, 0x110, 0x1163, 0x110, 0x1164, 0x110, 0x1165,
    0x110, 0x1166, 0x110, 0x1167, 0x110, 0x1168, 0x110, 0x1169,
    0x110, 0x116a, 0x110, 0x116b, 0x110, 0x116c, 0x110, 0x116d,
    0x110, 0x116e, 0x110, 0x116f, 0x110, 0x1170, 0x110, 0x1171,
    0x110, 0x1172, 0x110, 0x1173, 0x110, 0x1174, 0x110, 0x1175,
    0x110, 0x1160, 0x110, 0x1114, 0x110, 0x1115, 0x110, 0x11c7,
    0x110, 0x11c8, 0x110, 0x11cc, 0x110, 0x11ce, 0x110, 0x11d3,
    0x110, 0x11d7, 0x110, 0x11d9, 0x110, 0x111c, 0x110, 0x11dd,
    0x110, 0x11df, 0x110, 0x111d, 0x110, 0x111e, 0x110, 0x1120,
    0x110, 0x1122, 0x110, 0x1123, 0x110, 0x1127, 0x110, 0x1129,
    0x110, 0x112b, 0x110, 0x112c, 0x110, 0x112d, 0x110, 0x112e,
    0x110, 0x112f, 0x110, 0x1132, 0x110, 0x1136, 0x110, 0x1140,
    0x110, 0x1147, 0x110, 0x114c, 0x110, 0x11f1, 0x110, 0x11f2,
    0x110, 0x1157, 0x110, 0x1158, 0x110, 0x1159, 0x110, 0x1184,
    0x110, 0x1185, 0x110, 0x1188, 0x110, 0x1191, 0x110, 0x1192,
    0x110, 0x1194, 0x110, 0x119e, 0x110, 0x11a1, 0x109, 0x4e00,
    0x109, 0x4e8c, 0x109, 0x4e09, 0x109, 0x56db, 0x109, 0x4e0a,
    0x109, 0x4e2d, 0x109, 0x4e0b, 0x109, 0x7532, 0x109, 0x4e59,
    0x109, 0x4e19, 0x109, 0x4e01, 0x109, 0x5929, 0x109, 0x5730,
    0x109, 0x4eba, 0x310, 0x28, 0x1100, 0x29, 0x310, 0x28,
    0x1102, 0x29, 0x310, 0x28, 0x1103, 0x29, 0x310, 0x28,
    0x1105, 0x29, 0x310, 0x28, 0x1106, 0x29, 0x310, 0x28,
    0x1107, 0x29, 0x310, 0x28, 0x1109, 0x29, 0x310, 0x28,
    0x110b, 0x29, 0x310, 0x28, 0x110c, 0x29, 0x310, 0x28,
    0x110e, 0x29, 0x310, 0x28, 0x110f, 0x29, 0x310, 0x28,
    0x1110, 0x29, 0x310, 0x28, 0x1111, 0x29, 0x310, 0x28,
    0x1112, 0x29, 0x410, 0x28, 0x1100, 0x1161, 0x29, 0x410,
    0x28, 0x1102, 0x1161, 0x29, 0x410, 0x28, 0x1103, 0x1161,
    0x29, 0x410, 0x28, 0x1105, 0x1161, 0x29, 0x410, 0x28,
    0x1106, 0x1161, 0x29, 0x410, 0x28, 0x1107, 0x1161, 0x29,
    0x410, 0x28, 0x1109, 0x1161, 0x29, 0x410, 0x28, 0x110b,
    0x1161, 0x29, 0x410, 0x28, 0x110c, 0x1161, 0x29, 0x410,
    0x28, 0x110e, 0x1161, 0x29, 0x410, 0x28, 0x110f, 0x1161,
    0x29, 0x410, 0x28, 0x1110, 0x1161, 0x29, 0x410, 0x28,
    0x1111, 0x1161, 0x29, 0x410, 0x28, 0x1112, 0x1161, 0x29,
    0x410, 0x28, 0x110c, 0x116e, 0x29, 0x710, 0x28, 0x110b,
    0x1169, 0x110c, 0x1165, 0x11ab, 0x29, 0x610, 0x28, 0x110b,
    0x1169, 0x1112, 0x116e, 0x29, 0x310, 0x28, 0x4e00, 0x29,
    0x310, 0x28, 0x4e8c, 0x29, 0x310, 0x28, 0x4e09, 0x29,
    0x310, 0x28, 0x56db, 0x29, 0x310, 0x28, 0x4e94, 0x29,
    0x310, 0x28, 0x516d, 0x29, 0x310, 0x28, 0x4e03, 0x29,
    0x310, 0x28, 0x516b, 0x29, 0x310, 0x28, 0x4e5d, 0x29,
    0x310, 0x28, 0x5341, 0x29, 0x310, 0x28, 0x6708, 0x29,
    0x310, 0x28, 0x706b, 0x29, 0x310, 0x28, 0x6c34, 0x29,
    0x310, 0x28, 0x6728, 0x29, 0x310, 0x28, 0x91d1, 0x29,
    0x310, 0x28, 0x571f, 0x29, 0x310, 0x28, 0x65e5, 0x29,
    0x310, 0x28, 0x682a, 0x29, 0x310, 0x28, 0x6709, 0x29,
    0x310, 0x28, 0x793e, 0x29, 0x310, 0x28, 0x540d, 0x29,
    0x310, 0x28, 0x7279, 0x29, 0x310, 0x28, 0x8ca1, 0x29,
    0x310, 0x28, 0x795d, 0x29, 0x310, 0x28, 0x52b4, 0x29,
    0x310, 0x28, 0x4ee3, 0x29, 0x310, 0x28, 0x547c, 0x29,
    0x310, 0x28, 0x5b66, 0x29, 0x310, 0x28, 0x76e3, 0x29,
    0x310, 0x28, 0x4f01, 0x29, 0x310, 0x28, 0x8cc7, 0x29,
    0x310, 0x28, 0x5354, 0x29, 0x310, 0x28, 0x796d, 0x29,
    0x310, 0x28, 0x4f11, 0x29, 0x310, 0x28, 0x81ea, 0x29,
    0x310, 0x28, 0x81f3, 0x29, 0x108, 0x554f, 0x108, 0x5e7c,
    0x108, 0x6587, 0x108, 0x7b8f, 0x30f, 0x50, 0x54, 0x45,
    0x208, 0x32, 0x31, 0x208, 0x32, 0x32, 0x208, 0x32,
    0x33, 0x208, 0x32, 0x34, 0x208, 0x32, 0x35, 0x208,
    0x32, 0x36, 0x208, 0x32, 0x37, 0x208, 0x32, 0x38,
    0x208, 0x32, 0x39, 0x208, 0x33, 0x30, 0x208, 0x33,
    0x31, 0x208, 0x33, 0x32, 0x208, 0x33, 0x33, 0x208,
    0x33, 0x34, 0x208, 0x33, 0x35, 0x108, 0x1100, 0x108,
    0x1102, 0x108, 0x1103, 0x108, 0x1105, 0x108, 0x1106, 0x108,
    0x1107, 0x108, 0x1109, 0x108, 0x110b, 0x108, 0x110c, 0x108,
    0x110e, 0x108, 0x110f, 0x108, 0x1110, 0x108, 0x1111, 0x108,
    0x1112, 0x208, 0x1100, 0x1161, 0x208, 0x1102, 0x1161, 0x208,
    0x1103, 0x1161, 0x208, 0x1105, 0x1161, 0x208, 0x1106, 0x1161,
    0x208, 0x1107, 0x1161, 0x208, 0x1109, 0x1161, 0x208, 0x110b,
    0x1161, 0x208, 0x110c, 0x1161, 0x208, 0x110e, 0x1161, 0x208,
    0x110f, 0x1161, 0x208, 0x1110, 0x1161, 0x208, 0x1111, 0x1161,
    0x208, 0x1112, 0x1161, 0x508, 0x110e, 0x1161, 0x11b7, 0x1100,
    0x1169, 0x408, 0x110c, 0x116e, 0x110b, 0x1174, 0x208, 0x110b,
    0x116e, 0x108, 0x4e00, 0x108, 0x4e8c, 0x108, 0x4e09, 0x108,
    0x56db, 0x108, 0x4e94, 0x108, 0x516d, 0x108, 0x4e03, 0x108,
    0x516b, 0x108, 0x4e5d, 0x108, 0x5341, 0x108, 0x6708, 0x108,
    0x706b, 0x108, 0x6c34, 0x108, 0x6728, 0x108, 0x91d1, 0x108,
    0x571f, 0x108, 0x65e5, 0x108, 0x682a, 0x108, 0x6709, 0x108,
    0x793e, 0x108, 0x540d, 0x108, 0x7279, 0x108, 0x8ca1, 0x108,
    0x795d, 0x108, 0x52b4, 0x108, 0x79d8, 0x108, 0x7537, 0x108,
    0x5973, 0x108, 0x9069, 0x108, 0x512a, 0x108, 0x5370, 0x108,
    0x6ce8, 0x108, 0x9805, 0x108, 0x4f11, 0x108, 0x5199, 0x108,
    0x6b63, 0x108, 0x4e0a, 0x108, 0x4e2d, 0x108, 0x4e0b, 0x108,
    0x5de6, 0x108, 0x53f3, 0x108, 0x533b, 0x108, 0x5b97, 0x108,
    0x5b66, 0x108, 0x76e3, 0x108, 0x4f01, 0x108, 0x8cc7, 0x108,
    0x5354, 0x108, 0x591c, 0x208, 0x33, 0x36, 0x208, 0x33,
    0x37, 0x208, 0x33, 0x38, 0x208, 0x33, 0x39, 0x208,
    0x34, 0x30, 0x208, 0x34, 0x31, 0x208, 0x34, 0x32,
    0x208, 0x34, 0x33, 0x208, 0x34, 0x34, 0x208, 0x34,
    0x35, 0x208, 0x34, 0x36, 0x208, 0x34, 0x37, 0x208,
    0x34, 0x38, 0x208, 0x34, 0x39, 0x208, 0x35, 0x30,
    0x210, 0x31, 0x6708, 0x210, 0x32, 0x6708, 0x210, 0x33,
    0x6708, 0x210, 0x34, 0x6708, 0x210, 0x35, 0x6708, 0x210,
    0x36, 0x6708, 0x210, 0x37, 0x6708, 0x210, 0x38, 0x6708,
    0x210, 0x39, 0x6708, 0x310, 0x31, 0x30, 0x6708, 0x310,
    0x31, 0x31, 0x6708, 0x310, 0x31, 0x32, 0x6708, 0x20f,
    0x48, 0x67, 0x30f, 0x65, 0x72, 0x67, 0x20f, 0x65,
    0x56, 0x30f, 0x4c, 0x54, 0x44, 0x108, 0x30a2, 0x108,
    0x30a4, 0x108, 0x30a6, 0x108, 0x30a8, 0x108, 0x30aa, 0x108,
    0x30ab, 0x108, 0x30ad, 0x108, 0x30af, 0x108, 0x30b1, 0x108,
    0x30b3, 0x108, 0x30b5, 0x108, 0x30b7, 0x108, 0x30b9, 0x108,
    0x30bb, 0x108, 0x30bd, 0x108, 0x30bf, 0x108, 0x30c1, 0x108,
    0x30c4, 0x108, 0x30c6, 0x108, 0x30c8, 0x108, 0x30ca, 0x108,
    0x30cb, 0x108, 0x30cc, 0x108, 0x30cd, 0x108, 0x30ce, 0x108,
    0x30cf, 0x108, 0x30d2, 0x108, 0x30d5, 0x108, 0x30d8, 0x108,
    0x30db, 0x108, 0x30de, 0x108, 0x30df, 0x108, 0x30e0, 0x108,
    0x30e1, 0x108, 0x30e2, 0x108, 0x30e4, 0x108, 0x30e6, 0x108,
    0x30e8, 0x108, 0x30e9, 0x108, 0x30ea, 0x108, 0x30eb, 0x108,
    0x30ec, 0x108, 0x30ed, 0x108, 0x30ef, 0x108, 0x30f0, 0x108,
    0x30f1, 0x108, 0x30f2, 0x20f, 0x4ee4, 0x548c, 0x40f, 0x30a2,
    0x30d1, 0x30fc, 0x30c8, 0x40f, 0x30a2, 0x30eb, 0x30d5, 0x30a1,
    0x40f, 0x30a2, 0x30f3, 0x30da, 0x30a2, 0x30f, 0x30a2, 0x30fc,
    0x30eb, 0x40f, 0x30a4, 0x30cb, 0x30f3, 0x30b0, 0x30f, 0x30a4,
    0x30f3, 0x30c1, 0x30f, 0x30a6, 0x30a9, 0x30f3, 0x50f, 0x30a8,
    0x30b9, 0x30af, 0x30fc, 0x30c9, 0x40f, 0x30a8, 0x30fc, 0x30ab,
    0x30fc, 0x30f, 0x30aa, 0x30f3, 0x30b9, 0x30f, 0x30aa, 0x30fc,
    0x30e0, 0x30f, 0x30ab, 0x30a4, 0x30ea, 0x40f, 0x30ab, 0x30e9,
    0x30c3, 0x30c8, 0x40f, 0x30ab, 0x30ed, 0x30ea, 0x30fc, 0x30f,
    0x30ac, 0x30ed, 0x30f3, 0x30f, 0x30ac, 0x30f3, 0x30de, 0x20f,
    0x30ae, 0x30ac, 0x30f, 0x30ae, 0x30cb, 0x30fc, 0x40f, 0x30ad,
    0x30e5, 0x30ea, 0x30fc, 0x40f, 0x30ae, 0x30eb, 0x30c0, 0x30fc,
    0x20f, 0x30ad, 0x30ed, 0x50f, 0x30ad, 0x30ed, 0x30b0, 0x30e9,
    0x30e0, 0x60f, 0x30ad, 0x30ed, 0x30e1, 0x30fc, 0x30c8, 0x30eb,
    0x50f, 0x30ad, 0x30ed, 0x30ef, 0x30c3, 0x30c8, 0x30f, 0x30b0,
    0x30e9, 0x30e0, 0x50f, 0x30b0, 0x30e9, 0x30e0, 0x30c8, 0x30f3,
    0x50f, 0x30af, 0x30eb, 0x30bc, 0x30a4, 0x30ed, 0x40f, 0x30af,
    0x30ed, 0x30fc, 0x30cd, 0x30f, 0x30b1, 0x30fc, 0x30b9, 0x30f,
    0x30b3, 0x30eb, 0x30ca, 0x30f, 0x30b3, 0x30fc, 0x30dd, 0x40f,
    0x30b5, 0x30a4, 0x30af, 0x30eb, 0x50f, 0x30b5, 0x30f3, 0x30c1,
    0x30fc, 0x30e0, 0x40f, 0x30b7, 0x30ea, 0x30f3, 0x30b0, 0x30f,
    0x30bb, 0x30f3, 0x30c1, 0x30f, 0x30bb, 0x30f3, 0x30c8, 0x30f,
    0x30c0, 0x30fc, 0x30b9, 0x20f, 0x30c7, 0x30b7, 0x20f, 0x30c9,
    0x30eb, 0x20f, 0x30c8, 0x30f3, 0x20f, 0x30ca, 0x30ce, 0x30f,
    0x30ce, 0x30c3, 0x30c8, 0x30f, 0x30cf, 0x30a4, 0x30c4, 0x50f,
    0x30d1, 0x30fc, 0x30bb, 0x30f3, 0x30c8, 0x30f, 0x30d1, 0x30fc,
    0x30c4, 0x40f, 0x30d0, 0x30fc, 0x30ec, 0x30eb, 0x50f, 0x30d4,
    0x30a2, 0x30b9, 0x30c8, 0x30eb, 0x30f, 0x30d4, 0x30af, 0x30eb,
    0x20f, 0x30d4, 0x30b3, 0x20f, 0x30d3, 0x30eb, 0x50f, 0x30d5,
    0x30a1, 0x30e9, 0x30c3, 0x30c9, 0x40f, 0x30d5, 0x30a3, 0x30fc,
    0x30c8, 0x50f, 0x30d6, 0x30c3, 0x30b7, 0x30a7, 0x30eb, 0x30f,
    0x30d5, 0x30e9, 0x30f3, 0x50f, 0x30d8, 0x30af, 0x30bf, 0x30fc,
    0x30eb, 0x20f, 0x30da, 0x30bd, 0x30f, 0x30da, 0x30cb, 0x30d2,
    0x30f, 0x30d8, 0x30eb, 0x30c4, 0x30f, 0x30da, 0x30f3, 0x30b9,
    0x30f, 0x30da, 0x30fc, 0x30b8, 0x30f, 0x30d9, 0x30fc, 0x30bf,
    0x40f, 0x30dd, 0x30a4, 0x30f3, 0x30c8, 0x30f, 0x30dc, 0x30eb,
    0x30c8, 0x20f, 0x30db, 0x30f3, 0x30f, 0x30dd, 0x30f3, 0x30c9,
    0x30f, 0x30db, 0x30fc, 0x30eb, 0x30f, 0x30db, 0x30fc, 0x30f3,
    0x40f, 0x30de, 0x30a4, 0x30af, 0x30ed, 0x30f, 0x30de, 0x30a4,
    0x30eb, 0x30f, 0x30de, 0x30c3, 0x30cf, 0x30f, 0x30de, 0x30eb,
    0x30af, 0x50f, 0x30de, 0x30f3, 0x30b7, 0x30e7, 0x30f3, 0x40f,
    0x30df, 0x30af, 0x30ed, 0x30f3, 0x20f, 0x30df, 0x30ea, 0x50f,
    0x30df, 0x30ea, 0x30d0, 0x30fc, 0x30eb, 0x20f, 0x30e1, 0x30ac,
    0x40f, 0x30e1, 0x30ac, 0x30c8, 0x30f3, 0x40f, 0x30e1, 0x30fc,
    0x30c8, 0x30eb, 0x30f, 0x30e4, 0x30fc, 0x30c9, 0x30f, 0x30e4,
    0x30fc, 0x30eb, 0x30f, 0x30e6, 0x30a2, 0x30f3, 0x40f, 0x30ea,
    0x30c3, 0x30c8, 0x30eb, 0x20f, 0x30ea, 0x30e9, 0x30f, 0x30eb,
    0x30d4, 0x30fc, 0x40f, 0x30eb, 0x30fc, 0x30d6, 0x30eb, 0x20f,
    0x30ec, 0x30e0, 0x50f, 0x30ec, 0x30f3, 0x30c8, 0x30b2, 0x30f3,
    0x30f, 0x30ef, 0x30c3, 0x30c8, 0x210, 0x30, 0x70b9, 0x210,
    0x31, 0x70b9, 0x210, 0x32, 0x70b9, 0x210, 0x33, 0x70b9,
    0x210, 0x34, 0x70b9, 0x210, 0x35, 0x70b9, 0x210, 0x36,
    0x70b9, 0x210, 0x37, 0x70b9, 0x210, 0x38, 0x70b9, 0x210,
    0x39, 0x70b9, 0x310, 0x31, 0x30, 0x70b9, 0x310, 0x31,
    0x31, 0x70b9, 0x310, 0x31, 0x32, 0x70b9, 0x310, 0x31,
    0x33, 0x70b9, 0x310, 0x31, 0x34, 0x70b9, 0x310, 0x31,
    0x35, 0x70b9, 0x310, 0x31, 0x36, 0x70b9, 0x310, 0x31,
    0x37, 0x70b9, 0x310, 0x31, 0x38, 0x70b9, 0x310, 0x31,
    0x39, 0x70b9, 0x310, 0x32, 0x30, 0x70b9, 0x310, 0x32,
    0x31, 0x70b9, 0x310, 0x32, 0x32, 0x70b9, 0x310, 0x32,
    0x33, 0x70b9, 0x310, 0x32, 0x34, 0x70b9, 0x30f, 0x68,
    0x50, 0x61, 0x20f, 0x64, 0x61, 0x20f, 0x41, 0x55,
    0x30f, 0x62, 0x61, 0x72, 0x20f, 0x6f, 0x56, 0x20f,
    0x70, 0x63, 0x20f, 0x64, 0x6d, 0x30f, 0x64, 0x6d,
    0xb2, 0x30f, 0x64, 0x6d, 0xb3, 0x20f, 0x49, 0x55,
    0x20f, 0x5e73, 0x6210, 0x20f, 0x662d, 0x548c, 0x20f, 0x5927,
    0x6b63, 0x20f, 0x660e, 0x6cbb, 0x40f, 0x682a, 0x5f0f, 0x4f1a,
    0x793e, 0x20f, 0x70, 0x41, 0x20f, 0x6e, 0x41, 0x20f,
    0x3bc, 0x41, 0x20f, 0x6d, 0x41, 0x20f, 0x6b, 0x41,
    0x20f, 0x4b, 0x42, 0x20f, 0x4d, 0x42, 0x20f, 0x47,
    0x42, 0x30f, 0x63, 0x61, 0x6c, 0x40f, 0x6b, 0x63,
    0x61, 0x6c, 0x20f, 0x70, 0x46, 0x20f, 0x6e, 0x46,
    0x20f, 0x3bc, 0x46, 0x20f, 0x3bc, 0x67, 0x20f, 0x6d,
    0x67, 0x20f, 0x6b, 0x67, 0x20f, 0x48, 0x7a, 0x30f,
    0x6b, 0x48, 0x7a, 0x30f, 0x4d, 0x48, 0x7a, 0x30f,
    0x47, 0x48, 0x7a, 0x30f, 0x54, 0x48, 0x7a, 0x20f,
    0x3bc, 0x2113, 0x20f, 0x6d, 0x2113, 0x20f, 0x64, 0x2113,
    0x20f, 0x6b, 0x2113, 0x20f, 0x66, 0x6d, 0x20f, 0x6e,
    0x6d, 0x20f, 0x3bc, 0x6d, 0x20f, 0x6d, 0x6d, 0x20f,
    0x63, 0x6d, 0x20f, 0x6b, 0x6d, 0x30f, 0x6d, 0x6d,
    0xb2, 0x30f, 0x63, 0x6d, 0xb2, 0x20f, 0x6d, 0xb2,
    0x30f, 0x6b, 0x6d, 0xb2, 0x30f, 0x6d, 0x6d, 0xb3,
    0x30f, 0x63, 0x6d, 0xb3, 0x20f, 0x6d, 0xb3, 0x30f,
    0x6b, 0x6d, 0xb3, 0x30f, 0x6d, 0x2215, 0x73, 0x40f,
    0x6d, 0x2215, 0x73, 0xb2, 0x20f, 0x50, 0x61, 0x30f,
    0x6b, 0x50, 0x61, 0x30f, 0x4d, 0x50, 0x61, 0x30f,
    0x47, 0x50, 0x61, 0x30f, 0x72, 0x61, 0x64, 0x50f,
    0x72, 0x61, 0x64, 0x2215, 0x73, 0x60f, 0x72, 0x61,
    0x64, 0x2215, 0x73, 0xb2, 0x20f, 0x70, 0x73, 0x20f,
    0x6e, 0x73, 0x20f, 0x3bc, 0x73, 0x20f, 0x6d, 0x73,
    0x20f, 0x70, 0x56, 0x20f, 0x6e, 0x56, 0x20f, 0x3bc,
    0x56, 0x20f, 0x6d, 0x56, 0x20f, 0x6b, 0x56, 0x20f,
    0x4d, 0x56, 0x20f, 0x70, 0x57, 0x20f, 0x6e, 0x57,
    0x20f, 0x3bc, 0x57, 0x20f, 0x6d, 0x57, 0x20f, 0x6b,
    0x57, 0x20f, 0x4d, 0x57, 0x20f, 0x6b, 0x3a9, 0x20f,
    0x4d, 0x3a9, 0x40f, 0x61, 0x2e, 0x6d, 0x2e, 0x20f,
    0x42, 0x71, 0x20f, 0x63, 0x63, 0x20f, 0x63, 0x64,
    0x40f, 0x43, 0x2215, 0x6b, 0x67, 0x30f, 0x43, 0x6f,
    0x2e, 0x20f, 0x64, 0x42, 0x20f, 0x47, 0x79, 0x20f,
    0x68, 0x61, 0x20f, 0x48, 0x50, 0x20f, 0x69, 0x6e,
    0x20f, 0x4b, 0x4b, 0x20f, 0x4b, 0x4d, 0x20f, 0x6b,
    0x74, 0x20f, 0x6c, 0x6d, 0x20f, 0x6c, 0x6e, 0x30f,
    0x6c, 0x6f, 0x67, 0x20f, 0x6c, 0x78, 0x20f, 0x6d,
    0x62, 0x30f, 0x6d, 0x69, 0x6c, 0x30f, 0x6d, 0x6f,
    0x6c, 0x20f, 0x50, 0x48, 0x40f, 0x70, 0x2e, 0x6d,
    0x2e, 0x30f, 0x50, 0x50, 0x4d, 0x20f, 0x50, 0x52,
    0x20f, 0x73, 0x72, 0x20f, 0x53, 0x76, 0x20f, 0x57,
    0x62, 0x30f, 0x56, 0x2215, 0x6d, 0x30f, 0x41, 0x2215,
    0x6d, 0x210, 0x31, 0x65e5, 0x210, 0x32, 0x65e5, 0x210,
    0x33, 0x65e5, 0x210, 0x34, 0x65e5, 0x210, 0x35, 0x65e5,
    0x210, 0x36, 0x65e5, 0x210, 0x37, 0x65e5, 0x210, 0x38,
    0x65e5, 0x210, 0x39, 0x65e5, 0x310, 0x31, 0x30, 0x65e5,
    0x310, 0x31, 0x31, 0x65e5, 0x310, 0x31, 0x32, 0x65e5,
    0x310, 0x31, 0x33, 0x65e5, 0x310, 0x31, 0x34, 0x65e5,
    0x310, 0x31, 0x35, 0x65e5, 0x310, 0x31, 0x36, 0x65e5,
    0x310, 0x31, 0x37, 0x65e5, 0x310, 0x31, 0x38, 0x65e5,
    0x310, 0x31, 0x39, 0x65e5, 0x310, 0x32, 0x30, 0x65e5,
    0x310, 0x32, 0x31, 0x65e5, 0x310, 0x32, 0x32, 0x65e5,
    0x310, 0x32, 0x33, 0x65e5, 0x310, 0x32, 0x34, 0x65e5,
    0x310, 0x32, 0x35, 0x65e5, 0x310, 0x32, 0x36, 0x65e5,
    0x310, 0x32, 0x37, 0x65e5, 0x310, 0x32, 0x38, 0x65e5,
    0x310, 0x32, 0x39, 0x65e5, 0x310, 0x33, 0x30, 0x65e5,
    0x310, 0x33, 0x31, 0x65e5, 0x30f, 0x67, 0x61, 0x6c,
    0x109, 0x44a, 0x109, 0x44c, 0x109, 0xa76f, 0x109, 0x43,
    0x109, 0x46, 0x109, 0x51, 0x109, 0x126, 0x109, 0x153,
    0x109, 0xa727, 0x109, 0xab37, 0x109, 0x26b, 0x109, 0xab52,
    0x109, 0x28d, 0x101, 0x8c48, 0x101, 0x66f4, 0x101, 0x8eca,
    0x101, 0x8cc8, 0x101, 0x6ed1, 0x101, 0x4e32, 0x101, 0x53e5,
    0x101, 0x9f9c, 0x101, 0x9f9c, 0x101, 0x5951, 0x101, 0x91d1,
    0x101, 0x5587, 0x101, 0x5948, 0x101, 0x61f6, 0x101, 0x7669,
    0x101, 0x7f85, 0x101, 0x863f, 0x101, 0x87ba, 0x101, 0x88f8,
    0x101, 0x908f, 0x101, 0x6a02, 0x101, 0x6d1b, 0x101, 0x70d9,
    0x101, 0x73de, 0x101, 0x843d, 0x101, 0x916a, 0x101, 0x99f1,
    0x101, 0x4e82, 0x101, 0x5375, 0x101, 0x6b04, 0x101, 0x721b,
    0x101, 0x862d, 0x101, 0x9e1e, 0x101, 0x5d50, 0x101, 0x6feb,
    0x101, 0x85cd, 0x101, 0x8964, 0x101, 0x62c9, 0x101, 0x81d8,
    0x101, 0x881f, 0x101, 0x5eca, 0x101, 0x6717, 0x101, 0x6d6a,
    0x101, 0x72fc, 0x101, 0x90ce, 0x101, 0x4f86, 0x101, 0x51b7,
    0x101, 0x52de, 0x101, 0x64c4, 0x101, 0x6ad3, 0x101, 0x7210,
    0x101, 0x76e7, 0x101, 0x8001, 0x101, 0x8606, 0x101, 0x865c,
    0x101, 0x8def, 0x101, 0x9732, 0x101, 0x9b6f, 0x101, 0x9dfa,
    0x101, 0x788c, 0x101, 0x797f, 0x101, 0x7da0, 0x101, 0x83c9,
    0x101, 0x9304, 0x101, 0x9e7f, 0x101, 0x8ad6, 0x101, 0x58df,
    0x101, 0x5f04, 0x101, 0x7c60, 0x101, 0x807e, 0x101, 0x7262,
    0x101, 0x78ca, 0x101, 0x8cc2, 0x101, 0x96f7, 0x101, 0x58d8,
    0x101, 0x5c62, 0x101, 0x6a13, 0x101, 0x6dda, 0x101, 0x6f0f,
    0x101, 0x7d2f, 0x101, 0x7e37, 0x101, 0x964b, 0x101, 0x52d2,
    0x101, 0x808b, 0x101, 0x51dc, 0x101, 0x51cc, 0x101, 0x7a1c,
    0x101, 0x7dbe, 0x101, 0x83f1, 0x101, 0x9675, 0x101, 0x8b80,
    0x101, 0x62cf, 0x101, 0x6a02, 0x101, 0x8afe, 0x101, 0x4e39,
    0x101, 0x5be7, 0x101, 0x6012, 0x101, 0x7387, 0x101, 0x7570,
    0x101, 0x5317, 0x101, 0x78fb, 0x101, 0x4fbf, 0x101, 0x5fa9,
    0x101, 0x4e0d, 0x101, 0x6ccc, 0x101, 0x6578, 0x101, 0x7d22,
    0x101, 0x53c3, 0x101, 0x585e, 0x101, 0x7701, 0x101, 0x8449,
    0x101, 0x8aaa, 0x101, 0x6bba, 0x101, 0x8fb0, 0x101, 0x6c88,
    0x101, 0x62fe, 0x101, 0x82e5, 0x101, 0x63a0, 0x101, 0x7565,
    0x101, 0x4eae, 0x101, 0x5169, 0x101, 0x51c9, 0x101, 0x6881,
    0x101, 0x7ce7, 0x101, 0x826f, 0x101, 0x8ad2, 0x101, 0x91cf,
    0x101, 0x52f5, 0x101, 0x5442, 0x101, 0x5973, 0x101, 0x5eec,
    0x101, 0x65c5, 0x101, 0x6ffe, 0x101, 0x792a, 0x101, 0x95ad,
    0x101, 0x9a6a, 0x101, 0x9e97, 0x101, 0x9ece, 0x101, 0x529b,
    0x101, 0x66c6, 0x101, 0x6b77, 0x101, 0x8f62, 0x101, 0x5e74,
    0x101, 0x6190, 0x101, 0x6200, 0x101, 0x649a, 0x101, 0x6f23,
    0x101, 0x7149, 0x101, 0x7489, 0x101, 0x79ca, 0x101, 0x7df4,
    0x101, 0x806f, 0x101, 0x8f26, 0x101, 0x84ee, 0x101, 0x9023,
    0x101, 0x934a, 0x101, 0x5217, 0x101, 0x52a3, 0x101, 0x54bd,
    0x101, 0x70c8, 0x101, 0x88c2, 0x101, 0x8aaa, 0x101, 0x5ec9,
    0x101, 0x5ff5, 0x101, 0x637b, 0x101, 0x6bae, 0x101, 0x7c3e,
    0x101, 0x7375, 0x101, 0x4ee4, 0x101, 0x56f9, 0x101, 0x5be7,
    0x101, 0x5dba, 0x101, 0x601c, 0x101, 0x73b2, 0x101, 0x7469,
    0x101, 0x7f9a, 0x101, 0x8046, 0x101, 0x9234, 0x101, 0x96f6,
    0x101, 0x9748, 0x101, 0x9818, 0x101, 0x4f8b, 0x101, 0x79ae,
    0x101, 0x91b4, 0x101, 0x96b8, 0x101, 0x60e1, 0x101, 0x4e86,
    0x101, 0x50da, 0x101, 0x5bee, 0x101, 0x5c3f, 0x101, 0x6599,
    0x101, 0x6a02, 0x101, 0x71ce, 0x101, 0x7642, 0x101, 0x84fc,
    0x101, 0x907c, 0x101, 0x9f8d, 0x101, 0x6688, 0x101, 0x962e,
    0x101, 0x5289, 0x101, 0x677b, 0x101, 0x67f3, 0x101, 0x6d41,
    0x101, 0x6e9c, 0x101, 0x7409, 0x101, 0x7559, 0x101, 0x786b,
    0x101, 0x7d10, 0x101, 0x985e, 0x101, 0x516d, 0x101, 0x622e,
    0x101, 0x9678, 0x101, 0x502b, 0x101, 0x5d19, 0x101, 0x6dea,
    0x101, 0x8f2a, 0x101, 0x5f8b, 0x101, 0x6144, 0x101, 0x6817,
    0x101, 0x7387, 0x101, 0x9686, 0x101, 0x5229, 0x101, 0x540f,
    0x101, 0x5c65, 0x101, 0x6613, 0x101, 0x674e, 0x101, 0x68a8,
    0x101, 0x6ce5, 0x101, 0x7406, 0x101, 0x75e2, 0x101, 0x7f79,
    0x101, 0x88cf, 0x101, 0x88e1, 0x101, 0x91cc, 0x101, 0x96e2,
    0x101, 0x533f, 0x101, 0x6eba, 0x101, 0x541d, 0x101, 0x71d0,
    0x101, 0x7498, 0x101, 0x85fa, 0x101, 0x96a3, 0x101, 0x9c57,
    0x101, 0x9e9f, 0x101, 0x6797, 0x101, 0x6dcb, 0x101, 0x81e8,
    0x101, 0x7acb, 0x101, 0x7b20, 0x101, 0x7c92, 0x101, 0x72c0,
    0x101, 0x7099, 0x101, 0x8b58, 0x101, 0x4ec0, 0x101, 0x8336,
    0x101, 0x523a, 0x101, 0x5207, 0x101, 0x5ea6, 0x101, 0x62d3,
    0x101, 0x7cd6, 0x101, 0x5b85, 0x101, 0x6d1e, 0x101, 0x66b4,
    0x101, 0x8f3b, 0x101, 0x884c, 0x101, 0x964d, 0x101, 0x898b,
    0x101, 0x5ed3, 0x101, 0x5140, 0x101, 0x55c0, 0x101, 0x585a,
    0x101, 0x6674, 0x101, 0x51de, 0x101, 0x732a, 0x101, 0x76ca,
    0x101, 0x793c, 0x101, 0x795e, 0x101, 0x7965, 0x101, 0x798f,
    0x101, 0x9756, 0x101, 0x7cbe, 0x101, 0x7fbd, 0x101, 0x8612,
    0x101, 0x8af8, 0x101, 0x9038, 0x101, 0x90fd, 0x101, 0x98ef,
    0x101, 0x98fc, 0x101, 0x9928, 0x101, 0x9db4, 0x101, 0x90de,
    0x101, 0x96b7, 0x101, 0x4fae, 0x101, 0x50e7, 0x101, 0x514d,
    0x101, 0x52c9, 0x101, 0x52e4, 0x101, 0x5351, 0x101, 0x559d,
    0x101, 0x5606, 0x101, 0x5668, 0x101, 0x5840, 0x101, 0x58a8,
    0x101, 0x5c64, 0x101, 0x5c6e, 0x101, 0x6094, 0x101, 0x6168,
    0x101, 0x618e, 0x101, 0x61f2, 0x101, 0x654f, 0x101, 0x65e2,
    0x101, 0x6691, 0x101, 0x6885, 0x101, 0x6d77, 0x101, 0x6e1a,
    0x101, 0x6f22, 0x101, 0x716e, 0x101, 0x722b, 0x101, 0x7422,
    0x101, 0x7891, 0x101, 0x793e, 0x101, 0x7949, 0x101, 0x7948,
    0x101, 0x7950, 0x101, 0x7956, 0x101, 0x795d, 0x101, 0x798d,
    0x101, 0x798e, 0x101, 0x7a40, 0x101, 0x7a81, 0x101, 0x7bc0,
    0x101, 0x7df4, 0x101, 0x7e09, 0x101, 0x7e41, 0x101, 0x7f72,
    0x101, 0x8005, 0x101, 0x81ed, 0x101, 0x8279, 0x101, 0x8279,
    0x101, 0x8457, 0x101, 0x8910, 0x101, 0x8996, 0x101, 0x8b01,
    0x101, 0x8b39, 0x101, 0x8cd3, 0x101, 0x8d08, 0x101, 0x8fb6,
    0x101, 0x9038, 0x101, 0x96e3, 0x101, 0x97ff, 0x101, 0x983b,
    0x101, 0x6075, 0x101, 0x242ee, 0x101, 0x8218, 0x101, 0x4e26,
    0x101, 0x51b5, 0x101, 0x5168, 0x101, 0x4f80, 0x101, 0x5145,
    0x101, 0x5180, 0x101, 0x52c7, 0x101, 0x52fa, 0x101, 0x559d,
    0x101, 0x5555, 0x101, 0x5599, 0x101, 0x55e2, 0x101, 0x585a,
    0x101, 0x58b3, 0x101, 0x5944, 0x101, 0x5954, 0x101, 0x5a62,
    0x101, 0x5b28, 0x101, 0x5ed2, 0x101, 0x5ed9, 0x101, 0x5f69,
    0x101, 0x5fad, 0x101, 0x60d8, 0x101, 0x614e, 0x101, 0x6108,
    0x101, 0x618e, 0x101, 0x6160, 0x101, 0x61f2, 0x101, 0x6234,
    0x101, 0x63c4, 0x101, 0x641c, 0x101, 0x6452, 0x101, 0x6556,
    0x101, 0x6674, 0x101, 0x6717, 0x101, 0x671b, 0x101, 0x6756,
    0x101, 0x6b79, 0x101, 0x6bba, 0x101, 0x6d41, 0x101, 0x6edb,
    0x101, 0x6ecb, 0x101, 0x6f22, 0x101, 0x701e, 0x101, 0x716e,
    0x101, 0x77a7, 0x101, 0x7235, 0x101, 0x72af, 0x101, 0x732a,
    0x101, 0x7471, 0x101, 0x7506, 0x101, 0x753b, 0x101, 0x761d,
    0x101, 0x761f, 0x101, 0x76ca, 0x101, 0x76db, 0x101, 0x76f4,
    0x101, 0x774a, 0x101, 0x7740, 0x101, 0x78cc, 0x101, 0x7ab1,
    0x101, 0x7bc0, 0x101, 0x7c7b, 0x101, 0x7d5b, 0x101, 0x7df4,
    0x101, 0x7f3e, 0x101, 0x8005, 0x101, 0x8352, 0x101, 0x83ef,
    0x101, 0x8779, 0x101, 0x8941, 0x101, 0x8986, 0x101, 0x8996,
    0x101, 0x8abf, 0x101, 0x8af8, 0x101, 0x8acb, 0x101, 0x8b01,
    0x101, 0x8afe, 0x101, 0x8aed, 0x101, 0x8b39, 0x101, 0x8b8a,
    0x101, 0x8d08, 0x101, 0x8f38, 0x101, 0x9072, 0x101, 0x9199,
    0x101, 0x9276, 0x101, 0x967c, 0x101, 0x96e3, 0x101, 0x9756,
    0x101, 0x97db, 0x101, 0x97ff, 0x101, 0x980b, 0x101, 0x983b,
    0x101, 0x9b12, 0x101, 0x9f9c, 0x101, 0x2284a, 0x101, 0x22844,
    0x101, 0x233d5, 0x101, 0x3b9d, 0x101, 0x4018, 0x101, 0x4039,
    0x101, 0x25249, 0x101, 0x25cd0, 0x101, 0x27ed3, 0x101, 0x9f43,
    0x101, 0x9f8e, 0x210, 0x66, 0x66, 0x210, 0x66, 0x69,
    0x210, 0x66, 0x6c, 0x310, 0x66, 0x66, 0x69, 0x310,
    0x66, 0x66, 0x6c, 0x210, 0x17f, 0x74, 0x210, 0x73,
    0x74, 0x210, 0x574, 0x576, 0x210, 0x574, 0x565, 0x210,
    0x574, 0x56b, 0x210, 0x57e, 0x576, 0x210, 0x574, 0x56d,
    0x201, 0x5d9, 0x5b4, 0x201, 0x5f2, 0x5b7, 0x102, 0x5e2,
    0x102, 0x5d0, 0x102, 0x5d3, 0x102, 0x5d4, 0x102, 0x5db,
    0x102, 0x5dc, 0x102, 0x5dd, 0x102, 0x5e8, 0x102, 0x5ea,
    0x102, 0x2b, 0x201, 0x5e9, 0x5c1, 0x201, 0x5e9, 0x5c2,
    0x201, 0xfb49, 0x5c1, 0x201, 0xfb49, 0x5c2, 0x201, 0x5d0,
    0x5b7, 0x201, 0x5d0, 0x5b8, 0x201, 0x5d0, 0x5bc, 0x201,
    0x5d1, 0x5bc, 0x201, 0x5d2, 0x5bc, 0x201, 0x5d3, 0x5bc,
    0x201, 0x5d4, 0x5bc, 0x201, 0x5d5, 0x5bc, 0x201, 0x5d6,
    0x5bc, 0x201, 0x5d8, 0x5bc, 0x201, 0x5d9, 0x5bc, 0x201,
    0x5da, 0x5bc, 0x201, 0x5db, 0x5bc, 0x201, 0x5dc, 0x5bc,
    0x201, 0x5de, 0x5bc, 0x201, 0x5e0, 0x5bc, 0x201, 0x5e1,
    0x5bc, 0x201, 0x5e3, 0x5bc, 0x201, 0x5e4, 0x5bc, 0x201,
    0x5e6, 0x5bc, 0x201, 0x5e7, 0x5bc, 0x201, 0x5e8, 0x5bc,
    0x201, 0x5e9, 0x5bc, 0x201, 0x5ea, 0x5bc, 0x201, 0x5d5,
    0x5b9, 0x201, 0x5d1, 0x5bf, 0x201, 0x5db, 0x5bf, 0x201,
    0x5e4, 0x5bf, 0x210, 0x5d0, 0x5dc, 0x107, 0x671, 0x106,
    0x671, 0x107, 0x67b, 0x106, 0x67b, 0x104, 0x67b, 0x105,
    0x67b, 0x107, 0x67e, 0x106, 0x67e, 0x104, 0x67e, 0x105,
    0x67e, 0x107, 0x680, 0x106, 0x680, 0x104, 0x680, 0x105,
    0x680, 0x107, 0x67a, 0x106, 0x67a, 0x104, 0x67a, 0x105,
    0x67a, 0x107, 0x67f, 0x106, 0x67f, 0x104, 0x67f, 0x105,
    0x67f, 0x107, 0x679, 0x106, 0x679, 0x104, 0x679, 0x105,
    0x679, 0x107, 0x6a4, 0x106, 0x6a4, 0x104, 0x6a4, 0x105,
    0x6a4, 0x107, 0x6a6, 0x106, 0x6a6, 0x104, 0x6a6, 0x105,
    0x6a6, 0x107, 0x684, 0x106, 0x684, 0x104, 0x684, 0x105,
    0x684, 0x107, 0x683, 0x106, 0x683, 0x104, 0x683, 0x105,
    0x683, 0x107, 0x686, 0x106, 0x686, 0x104, 0x686, 0x105,
    0x686, 0x107, 0x687, 0x106, 0x687, 0x104, 0x687, 0x105,
    0x687, 0x107, 0x68d, 0x106, 0x68d, 0x107, 0x68c, 0x106,
    0x68c, 0x107, 0x68e, 0x106, 0x68e, 0x107, 0x688, 0x106,
    0x688, 0x107, 0x698, 0x106, 0x698, 0x107, 0x691, 0x106,
    0x691, 0x107, 0x6a9, 0x106, 0x6a9, 0x104, 0x6a9, 0x105,
    0x6a9, 0x107, 0x6af, 0x106, 0x6af, 0x104, 0x6af, 0x105,
    0x6af, 0x107, 0x6b3, 0x106, 0x6b3, 0x104, 0x6b3, 0x105,
    0x6b3, 0x107, 0x6b1, 0x106, 0x6b1, 0x104, 0x6b1, 0x105,
    0x6b1, 0x107, 0x6ba, 0x106, 0x6ba, 0x107, 0x6bb, 0x106,
    0x6bb, 0x104, 0x6bb, 0x105, 0x6bb, 0x107, 0x6c0, 0x106,
    0x6c0, 0x107, 0x6c1, 0x106, 0x6c1, 0x104, 0x6c1, 0x105,
    0x6c1, 0x107, 0x6be, 0x106, 0x6be, 0x104, 0x6be, 0x105,
    0x6be, 0x107, 0x6d2, 0x106, 0x6d2, 0x107, 0x6d3, 0x106,
    0x6d3, 0x107, 0x6ad, 0x106, 0x6ad, 0x104, 0x6ad, 0x105,
    0x6ad, 0x107, 0x6c7, 0x106, 0x6c7, 0x107, 0x6c6, 0x106,
    0x6c6, 0x107, 0x6c8, 0x106, 0x6c8, 0x107, 0x677, 0x107,
    0x6cb, 0x106, 0x6cb, 0x107, 0x6c5, 0x106, 0x6c5, 0x107,
    0x6c9, 0x106, 0x6c9, 0x107, 0x6d0, 0x106, 0x6d0, 0x104,
    0x6d0, 0x105, 0x6d0, 0x104, 0x649, 0x105, 0x649, 0x207,
    0x626, 0x627, 0x206, 0x626, 0x627, 0x207, 0x626, 0x6d5,
    0x206, 0x626, 0x6d5, 0x207, 0x626, 0x648, 0x206, 0x626,
    0x648, 0x207, 0x626, 0x6c7, 0x206, 0x626, 0x6c7, 0x207,
    0x626, 0x6c6, 0x206, 0x626, 0x6c6, 0x207, 0x626, 0x6c8,
    0x206, 0x626, 0x6c8, 0x207, 0x626, 0x6d0, 0x206, 0x626,
    0x6d0, 0x204, 0x626, 0x6d0, 0x207, 0x626, 0x649, 0x206,
    0x626, 0x649, 0x204, 0x626, 0x649, 0x107, 0x6cc, 0x106,
    0x6cc, 0x104, 0x6cc, 0x105, 0x6cc, 0x207, 0x626, 0x62c,
    0x207, 0x626, 0x62d, 0x207, 0x626, 0x645, 0x207, 0x626,
    0x649, 0x207, 0x626, 0x64a, 0x207, 0x628, 0x62c, 0x207,
    0x628, 0x62d, 0x207, 0x628, 0x62e, 0x207, 0x628, 0x645,
    0x207, 0x628, 0x649, 0x207, 0x628, 0x64a, 0x207, 0x62a,
    0x62c, 0x207, 0x62a, 0x62d, 0x207, 0x62a, 0x62e, 0x207,
    0x62a, 0x645, 0x207, 0x62a, 0x649, 0x207, 0x62a, 0x64a,
    0x207, 0x62b, 0x62c, 0x207, 0x62b, 0x645, 0x207, 0x62b,
    0x649, 0x207, 0x62b, 0x64a, 0x207, 0x62c, 0x62d, 0x207,
    0x62c, 0x645, 0x207, 0x62d, 0x62c, 0x207, 0x62d, 0x645,
    0x207, 0x62e, 0x62c, 0x207, 0x62e, 0x62d, 0x207, 0x62e,
    0x645, 0x207, 0x633, 0x62c, 0x207, 0x633, 0x62d, 0x207,
    0x633, 0x62e, 0x207, 0x633, 0x645, 0x207, 0x635, 0x62d,
    0x207, 0x635, 0x645, 0x207, 0x636, 0x62c, 0x207, 0x636,
    0x62d, 0x207, 0x636, 0x62e, 0x207, 0x636, 0x645, 0x207,
    0x637, 0x62d, 0x207, 0x637, 0x645, 0x207, 0x638, 0x645,
    0x207, 0x639, 0x62c, 0x207, 0x639, 0x645, 0x207, 0x63a,
    0x62c, 0x207, 0x63a, 0x645, 0x207, 0x641, 0x62c, 0x207,
    0x641, 0x62d, 0x207, 0x641, 0x62e, 0x207, 0x641, 0x645,
    0x207, 0x641, 0x649, 0x207, 0x641, 0x64a, 0x207, 0x642,
    0x62d, 0x207, 0x642, 0x645, 0x207, 0x642, 0x649, 0x207,
    0x642, 0x64a, 0x207, 0x643, 0x627, 0x207, 0x643, 0x62c,
    0x207, 0x643, 0x62d, 0x207, 0x643, 0x62e, 0x207, 0x643,
    0x644, 0x207, 0x643, 0x645, 0x207, 0x643, 0x649, 0x207,
    0x643, 0x64a, 0x207, 0x644, 0x62c, 0x207, 0x644, 0x62d,
    0x207, 0x644, 0x62e, 0x207, 0x644, 0x645, 0x207, 0x644,
    0x649, 0x207, 0x644, 0x64a, 0x207, 0x645, 0x62c, 0x207,
    0x645, 0x62d, 0x207, 0x645, 0x62e, 0x207, 0x645, 0x645,
    0x207, 0x645, 0x649, 0x207, 0x645, 0x64a, 0x207, 0x646,
    0x62c, 0x207, 0x646, 0x62d, 0x207, 0x646, 0x62e, 0x207,
    0x646, 0x645, 0x207, 0x646, 0x649, 0x207, 0x646, 0x64a,
    0x207, 0x647, 0x62c, 0x207, 0x647, 0x645, 0x207, 0x647,
    0x649, 0x207, 0x647, 0x64a, 0x207, 0x64a, 0x62c, 0x207,
    0x64a, 0x62d, 0x207, 0x64a, 0x62e, 0x207, 0x64a, 0x645,
    0x207, 0x64a, 0x649, 0x207, 0x64a, 0x64a, 0x207, 0x630,
    0x670, 0x207, 0x631, 0x670, 0x207, 0x649, 0x670, 0x307,
    0x20, 0x64c, 0x651, 0x307, 0x20, 0x64d, 0x651, 0x307,
    0x20, 0x64e, 0x651, 0x307, 0x20, 0x64f, 0x651, 0x307,
    0x20, 0x650, 0x651, 0x307, 0x20, 0x651, 0x670, 0x206,
    0x626, 0x631, 0x206, 0x626, 0x632, 0x206, 0x626, 0x645,
    0x206, 0x626, 0x646, 0x206, 0x626, 0x649, 0x206, 0x626,
    0x64a, 0x206, 0x628, 0x631, 0x206, 0x628, 0x632, 0x206,
    0x628, 0x645, 0x206, 0x628, 0x646, 0x206, 0x628, 0x649,
    0x206, 0x628, 0x64a, 0x206, 0x62a, 0x631, 0x206, 0x62a,
    0x632, 0x206, 0x62a, 0x645, 0x206, 0x62a, 0x646, 0x206,
    0x62a, 0x649, 0x206, 0x62a, 0x64a, 0x206, 0x62b, 0x631,
    0x206, 0x62b, 0x632, 0x206, 0x62b, 0x645, 0x206, 0x62b,
    0x646, 0x206, 0x62b, 0x649, 0x206, 0x62b, 0x64a, 0x206,
    0x641, 0x649, 0x206, 0x641, 0x64a, 0x206, 0x642, 0x649,
    0x206, 0x642, 0x64a, 0x206, 0x643, 0x627, 0x206, 0x643,
    0x644, 0x206, 0x643, 0x645, 0x206, 0x643, 0x649, 0x206,
    0x643, 0x64a, 0x206, 0x644, 0x645, 0x206, 0x644, 0x649,
    0x206, 0x644, 0x64a, 0x206, 0x645, 0x627, 0x206, 0x645,
    0x645, 0x206, 0x646, 0x631, 0x206, 0x646, 0x632, 0x206,
    0x646, 0x645, 0x206, 0x646, 0x646, 0x206, 0x646, 0x649,
    0x206, 0x646, 0x64a, 0x206, 0x649, 0x670, 0x206, 0x64a,
    0x631, 0x206, 0x64a, 0x632, 0x206, 0x64a, 0x645, 0x206,
    0x64a, 0x646, 0x206, 0x64a, 0x649, 0x206, 0x64a, 0x64a,
    0x204, 0x626, 0x62c, 0x204, 0x626, 0x62d, 0x204, 0x626,
    0x62e, 0x204, 0x626, 0x645, 0x204, 0x626, 0x647, 0x204,
    0x628, 0x62c, 0x204, 0x628, 0x62d, 0x204, 0x628, 0x62e,
    0x204, 0x628, 0x645, 0x204, 0x628, 0x647, 0x204, 0x62a,
    0x62c, 0x204, 0x62a, 0x62d, 0x204, 0x62a, 0x62e, 0x204,
    0x62a, 0x645, 0x204, 0x62a, 0x647, 0x204, 0x62b, 0x645,
    0x204, 0x62c, 0x62d, 0x204, 0x62c, 0x645, 0x204, 0x62d,
    0x62c, 0x204, 0x62d, 0x645, 0x204, 0x62e, 0x62c, 0x204,
    0x62e, 0x645, 0x204, 0x633, 0x62c, 0x204, 0x633, 0x62d,
    0x204, 0x633, 0x62e, 0x204, 0x633, 0x645, 0x204, 0x635,
    0x62d, 0x204, 0x635, 0x62e, 0x204, 0x635, 0x645, 0x204,
    0x636, 0x62c, 0x204, 0x636, 0x62d, 0x204, 0x636, 0x62e,
    0x204, 0x636, 0x645, 0x204, 0x637, 0x62d, 0x204, 0x638,
    0x645, 0x204, 0x639, 0x62c, 0x204, 0x639, 0x645, 0x204,
    0x63a, 0x62c, 0x204, 0x63a, 0x645, 0x204, 0x641, 0x62c,
    0x204, 0x641, 0x62d, 0x204, 0x641, 0x62e, 0x204, 0x641,
    0x645, 0x204, 0x642, 0x62d, 0x204, 0x642, 0x645, 0x204,
    0x643, 0x62c, 0x204, 0x643, 0x62d, 0x204, 0x643, 0x62e,
    0x204, 0x643, 0x644, 0x204, 0x643, 0x645, 0x204, 0x644,
    0x62c, 0x204, 0x644, 0x62d, 0x204, 0x644, 0x62e, 0x204,
    0x644, 0x645, 0x204, 0x644, 0x647, 0x204, 0x645, 0x62c,
    0x204, 0x645, 0x62d, 0x204, 0x645, 0x62e, 0x204, 0x645,
    0x645, 0x204, 0x646, 0x62c, 0x204, 0x646, 0x62d, 0x204,
    0x646, 0x62e, 0x204, 0x646, 0x645, 0x204, 0x646, 0x647,
    0x204, 0x647, 0x62c, 0x204, 0x647, 0x645, 0x204, 0x647,
    0x670, 0x204, 0x64a, 0x62c, 0x204, 0x64a, 0x62d, 0x204,
    0x64a, 0x62e, 0x204, 0x64a, 0x645, 0x204, 0x64a, 0x647,
    0x205, 0x626, 0x645, 0x205, 0x626, 0x647, 0x205, 0x628,
    0x645, 0x205, 0x628, 0x647, 0x205, 0x62a, 0x645, 0x205,
    0x62a, 0x647, 0x205, 0x62b, 0x645, 0x205, 0x62b, 0x647,
    0x205, 0x633, 0x645, 0x205, 0x633, 0x647, 0x205, 0x634,
    0x645, 0x205, 0x634, 0x647, 0x205, 0x643, 0x644, 0x205,
    0x643, 0x645, 0x205, 0x644, 0x645, 0x205, 0x646, 0x645,
    0x205, 0x646, 0x647, 0x205, 0x64a, 0x645, 0x205, 0x64a,
    0x647, 0x305, 0x640, 0x64e, 0x651, 0x305, 0x640, 0x64f,
    0x651, 0x305, 0x640, 0x650, 0x651, 0x207, 0x637, 0x649,
    0x207, 0x637, 0x64a, 0x207, 0x639, 0x649, 0x207, 0x639,
    0x64a, 0x207, 0x63a, 0x649, 0x207, 0x63a, 0x64a, 0x207,
    0x633, 0x649, 0x207, 0x633, 0x64a, 0x207, 0x634, 0x649,
    0x207, 0x634, 0x64a, 0x207, 0x62d, 0x649, 0x207, 0x62d,
    0x64a, 0x207, 0x62c, 0x649, 0x207, 0x62c, 0x64a, 0x207,
    0x62e, 0x649, 0x207, 0x62e, 0x64a, 0x207, 0x635, 0x649,
    0x207, 0x635, 0x64a, 0x207, 0x636, 0x649, 0x207, 0x636,
    0x64a, 0x207, 0x634, 0x62c, 0x207, 0x634, 0x62d, 0x207,
    0x634, 0x62e, 0x207, 0x634, 0x645, 0x207, 0x634, 0x631,
    0x207, 0x633, 0x631, 0x207, 0x635, 0x631, 0x207, 0x636,
    0x631, 0x206, 0x637, 0x649, 0x206, 0x637, 0x64a, 0x206,
    0x639, 0x649, 0x206, 0x639, 0x64a, 0x206, 0x63a, 0x649,
    0x206, 0x63a, 0x64a, 0x206, 0x633, 0x649, 0x206, 0x633,
    0x64a, 0x206, 0x634, 0x649, 0x206, 0x634, 0x64a, 0x206,
    0x62d, 0x649, 0x206, 0x62d, 0x64a, 0x206, 0x62c, 0x649,
    0x206, 0x62c, 0x64a, 0x206, 0x62e, 0x649, 0x206, 0x62e,
    0x64a, 0x206, 0x635, 0x649, 0x206, 0x635, 0x64a, 0x206,
    0x636, 0x649, 0x206, 0x636, 0x64a, 0x206, 0x634, 0x62c,
    0x206, 0x634, 0x62d, 0x206, 0x634, 0x62e, 0x206, 0x634,
    0x645, 0x206, 0x634, 0x631, 0x206, 0x633, 0x631, 0x206,
    0x635, 0x631, 0x206, 0x636, 0x631, 0x204, 0x634, 0x62c,
    0x204, 0x634, 0x62d, 0x204, 0x634, 0x62e, 0x204, 0x634,
    0x645, 0x204, 0x633, 0x647, 0x204, 0x634, 0x647, 0x204,
    0x637, 0x645, 0x205, 0x633, 0x62c, 0x205, 0x633, 0x62d,
    0x205, 0x633, 0x62e, 0x205, 0x634, 0x62c, 0x205, 0x634,
    0x62d, 0x205, 0x634, 0x62e, 0x205, 0x637, 0x645, 0x205,
    0x638, 0x645, 0x206, 0x627, 0x64b, 0x207, 0x627, 0x64b,
    0x304, 0x62a, 0x62c, 0x645, 0x306, 0x62a, 0x62d, 0x62c,
    0x304, 0x62a, 0x62d, 0x62c, 0x304, 0x62a, 0x62d, 0x645,
    0x304, 0x62a, 0x62e, 0x645, 0x304, 0x62a, 0x645, 0x62c,
    0x304, 0x62a, 0x645, 0x62d, 0x304, 0x62a, 0x645, 0x62e,
    0x306, 0x62c, 0x645, 0x62d, 0x304, 0x62c, 0x645, 0x62d,
    0x306, 0x62d, 0x645, 0x64a, 0x306, 0x62d, 0x645, 0x649,
    0x304, 0x633, 0x62d, 0x62c, 0x304, 0x633, 0x62c, 0x62d,
    0x306, 0x633, 0x62c, 0x649, 0x306, 0x633, 0x645, 0x62d,
    0x304, 0x633, 0x645, 0x62d, 0x304, 0x633, 0x645, 0x62c,
    0x306, 0x633, 0x645, 0x645, 0x304, 0x633, 0x645, 0x645,
    0x306, 0x635, 0x62d, 0x62d, 0x304, 0x635, 0x62d, 0x62d,
    0x306, 0x635, 0x645, 0x645, 0x306, 0x634, 0x62d, 0x645,
    0x304, 0x634, 0x62d, 0x645, 0x306, 0x634, 0x62c, 0x64a,
    0x306, 0x634, 0x645, 0x62e, 0x304, 0x634, 0x645, 0x62e,
    0x306, 0x634, 0x645, 0x645, 0x304, 0x634, 0x645, 0x645,
    0x306, 0x636, 0x62d, 0x649, 0x306, 0x636, 0x62e, 0x645,
    0x304, 0x636, 0x62e, 0x645, 0x306, 0x637, 0x645, 0x62d,
    0x304, 0x637, 0x645, 0x62d, 0x304, 0x637, 0x645, 0x645,
    0x306, 0x637, 0x645, 0x64a, 0x306, 0x639, 0x62c, 0x645,
    0x306, 0x639, 0x645, 0x645, 0x304, 0x639, 0x645, 0x645,
    0x306, 0x639, 0x645, 0x649, 0x306, 0x63a, 0x645, 0x645,
    0x306, 0x63a, 0x645, 0x64a, 0x306, 0x63a, 0x645, 0x649,
    0x306, 0x641, 0x62e, 0x645, 0x304, 0x641, 0x62e, 0x645,
    0x306, 0x642, 0x645, 0x62d, 0x306, 0x642, 0x645, 0x645,
    0x306, 0x644, 0x62d, 0x645, 0x306, 0x644, 0x62d, 0x64a,
    0x306, 0x644, 0x62d, 0x649, 0x304, 0x644, 0x62c, 0x62c,
    0x306, 0x644, 0x62c, 0x62c, 0x306, 0x644, 0x62e, 0x645,
    0x304, 0x644, 0x62e, 0x645, 0x306, 0x644, 0x645, 0x62d,
    0x304, 0x644, 0x645, 0x62d, 0x304, 0x645, 0x62d, 0x62c,
    0x304, 0x645, 0x62d, 0x645, 0x306, 0x645, 0x62d, 0x64a,
    0x304, 0x645, 0x62c, 0x62d, 0x304, 0x645, 0x62c, 0x645,
    0x304, 0x645, 0x62e, 0x62c, 0x304, 0x645, 0x62e, 0x645,
    0x304, 0x645, 0x62c, 0x62e, 0x304, 0x647, 0x645, 0x62c,
    0x304, 0x647, 0x645, 0x645, 0x304, 0x646, 0x62d, 0x645,
    0x306, 0x646, 0x62d, 0x649, 0x306, 0x646, 0x62c, 0x645,
    0x304, 0x646, 0x62c, 0x645, 0x306, 0x646, 0x62c, 0x649,
    0x306, 0x646, 0x645, 0x64a, 0x306, 0x646, 0x645, 0x649,
    0x306, 0x64a, 0x645, 0x645, 0x304, 0x64a, 0x645, 0x645,
    0x306, 0x628, 0x62e, 0x64a, 0x306, 0x62a, 0x62c, 0x64a,
    0x306, 0x62a, 0x62c, 0x649, 0x306, 0x62a, 0x62e, 0x64a,
    0x306, 0x62a, 0x62e, 0x649, 0x306, 0x62a, 0x645, 0x64a,
    0x306, 0x62a, 0x645, 0x649, 0x306, 0x62c, 0x645, 0x64a,
    0x306, 0x62c, 0x62d, 0x649, 0x306, 0x62c, 0x645, 0x649,
    0x306, 0x633, 0x62e, 0x649, 0x306, 0x635, 0x62d, 0x64a,
    0x306, 0x634, 0x62d, 0x64a, 0x306, 0x636, 0x62d, 0x64a,
    0x306, 0x644, 0x62c, 0x64a, 0x306, 0x644, 0x645, 0x64a,
    0x306, 0x64a, 0x62d, 0x64a, 0x306, 0x64a, 0x62c, 0x64a,
    0x306, 0x64a, 0x645, 0x64a, 0x306, 0x645, 0x645, 0x64a,
    0x306, 0x642, 0x645, 0x64a, 0x306, 0x646, 0x62d, 0x64a,
    0x304, 0x642, 0x645, 0x62d, 0x304, 0x644, 0x62d, 0x645,
    0x306, 0x639, 0x645, 0x64a, 0x306, 0x643, 0x645, 0x64a,
    0x304, 0x646, 0x62c, 0x62d, 0x306, 0x645, 0x62e, 0x64a,
    0x304, 0x644, 0x62c, 0x645, 0x306, 0x643, 0x645, 0x645,
    0x306, 0x644, 0x62c, 0x645, 0x306, 0x646, 0x62c, 0x62d,
    0x306, 0x62c, 0x62d, 0x64a, 0x306, 0x62d, 0x62c, 0x64a,
    0x306, 0x645, 0x62c, 0x64a, 0x306, 0x641, 0x645, 0x64a,
    0x306, 0x628, 0x62d, 0x64a, 0x304, 0x643, 0x645, 0x645,
    0x304, 0x639, 0x62c, 0x645, 0x304, 0x635, 0x645, 0x645,
    0x306, 0x633, 0x62e, 0x64a, 0x306, 0x646, 0x62c, 0x64a,
    0x307, 0x635, 0x644, 0x6d2, 0x307, 0x642, 0x644, 0x6d2,
    0x407, 0x627, 0x644, 0x644, 0x647, 0x407, 0x627, 0x643,
    0x628, 0x631, 0x407, 0x645, 0x62d, 0x645, 0x62f, 0x407,
    0x635, 0x644, 0x639, 0x645, 0x407, 0x631, 0x633, 0x648,
    0x644, 0x407, 0x639, 0x644, 0x64a, 0x647, 0x407, 0x648,
    0x633, 0x644, 0x645, 0x307, 0x635, 0x644, 0x649, 0x1207,
    0x635, 0x644, 0x649, 0x20, 0x627, 0x644, 0x644, 0x647,
    0x20, 0x639, 0x644, 0x64a, 0x647, 0x20, 0x648, 0x633,
    0x644, 0x645, 0x807, 0x62c, 0x644, 0x20, 0x62c, 0x644,
    0x627, 0x644, 0x647, 0x407, 0x631, 0x6cc, 0x627, 0x644,
    0x10b, 0x2c, 0x10b, 0x3001, 0x10b, 0x3002, 0x10b, 0x3a,
    0x10b, 0x3b, 0x10b, 0x21, 0x10b, 0x3f, 0x10b, 0x3016,
    0x10b, 0x3017, 0x10b, 0x2026, 0x10b, 0x2025, 0x10b, 0x2014,
    0x10b, 0x2013, 0x10b, 0x5f, 0x10b, 0x5f, 0x10b, 0x28,
    0x10b, 0x29, 0x10b, 0x7b, 0x10b, 0x7d, 0x10b, 0x3014,
    0x10b, 0x3015, 0x10b, 0x3010, 0x10b, 0x3011, 0x10b, 0x300a,
    0x10b, 0x300b, 0x10b, 0x3008, 0x10b, 0x3009, 0x10b, 0x300c,
    0x10b, 0x300d, 0x10b, 0x300e, 0x10b, 0x300f, 0x10b, 0x5b,
    0x10b, 0x5d, 0x110, 0x203e, 0x110, 0x203e, 0x110, 0x203e,
    0x110, 0x203e, 0x110, 0x5f, 0x110, 0x5f, 0x110, 0x5f,
    0x10e, 0x2c, 0x10e, 0x3001, 0x10e, 0x2e, 0x10e, 0x3b,
    0x10e, 0x3a, 0x10e, 0x3f, 0x10e, 0x21, 0x10e, 0x2014,
    0x10e, 0x28, 0x10e, 0x29, 0x10e, 0x7b, 0x10e, 0x7d,
    0x10e, 0x3014, 0x10e, 0x3015, 0x10e, 0x23, 0x10e, 0x26,
    0x10e, 0x2a, 0x10e, 0x2b, 0x10e, 0x2d, 0x10e, 0x3c,
    0x10e, 0x3e, 0x10e, 0x3d, 0x10e, 0x5c, 0x10e, 0x24,
    0x10e, 0x25, 0x10e, 0x40, 0x207, 0x20, 0x64b, 0x205,
    0x640, 0x64b, 0x207, 0x20, 0x64c, 0x207, 0x20, 0x64d,
    0x207, 0x20, 0x64e, 0x205, 0x640, 0x64e, 0x207, 0x20,
    0x64f, 0x205, 0x640, 0x64f, 0x207, 0x20, 0x650, 0x205,
    0x640, 0x650, 0x207, 0x20, 0x651, 0x205, 0x640, 0x651,
    0x207, 0x20, 0x652, 0x205, 0x640, 0x652, 0x107, 0x621,
    0x107, 0x622, 0x106, 0x622, 0x107, 0x623, 0x106, 0x623,
    0x107, 0x624, 0x106, 0x624, 0x107, 0x625, 0x106, 0x625,
    0x107, 0x626, 0x106, 0x626, 0x104, 0x626, 0x105, 0x626,
    0x107, 0x627, 0x106, 0x627, 0x107, 0x628, 0x106, 0x628,
    0x104, 0x628, 0x105, 0x628, 0x107, 0x629, 0x106, 0x629,
    0x107, 0x62a, 0x106, 0x62a, 0x104, 0x62a, 0x105, 0x62a,
    0x107, 0x62b, 0x106, 0x62b, 0x104, 0x62b, 0x105, 0x62b,
    0x107, 0x62c, 0x106, 0x62c, 0x104, 0x62c, 0x105, 0x62c,
    0x107, 0x62d, 0x106, 0x62d, 0x104, 0x62d, 0x105, 0x62d,
    0x107, 0x62e, 0x106, 0x62e, 0x104, 0x62e, 0x105, 0x62e,
    0x107, 0x62f, 0x106, 0x62f, 0x107, 0x630, 0x106, 0x630,
    0x107, 0x631, 0x106, 0x631, 0x107, 0x632, 0x106, 0x632,
    0x107, 0x633, 0x106, 0x633, 0x104, 0x633, 0x105, 0x633,
    0x107, 0x634, 0x106, 0x634, 0x104, 0x634, 0x105, 0x634,
    0x107, 0x635, 0x106, 0x635, 0x104, 0x635, 0x105, 0x635,
    0x107, 0x636, 0x106, 0x636, 0x104, 0x636, 0x105, 0x636,
    0x107, 0x637, 0x106, 0x637, 0x104, 0x637, 0x105, 0x637,
    0x107, 0x638, 0x106, 0x638, 0x104, 0x638, 0x105, 0x638,
    0x107, 0x639, 0x106, 0x639, 0x104, 0x639, 0x105, 0x639,
    0x107, 0x63a, 0x106, 0x63a, 0x104, 0x63a, 0x105, 0x63a,
    0x107, 0x641, 0x106, 0x641, 0x104, 0x641, 0x105, 0x641,
    0x107, 0x642, 0x106, 0x642, 0x104, 0x642, 0x105, 0x642,
    0x107, 0x643, 0x106, 0x643, 0x104, 0x643, 0x105, 0x643,
    0x107, 0x644, 0x106, 0x644, 0x104, 0x644, 0x105, 0x644,
    0x107, 0x645, 0x106, 0x645, 0x104, 0x645, 0x105, 0x645,
    0x107, 0x646, 0x106, 0x646, 0x104, 0x646, 0x105, 0x646,
    0x107, 0x647, 0x106, 0x647, 0x104, 0x647, 0x105, 0x647,
    0x107, 0x648, 0x106, 0x648, 0x107, 0x649, 0x106, 0x649,
    0x107, 0x64a, 0x106, 0x64a, 0x104, 0x64a, 0x105, 0x64a,
    0x207, 0x644, 0x622, 0x206, 0x644, 0x622, 0x207, 0x644,
    0x623, 0x206, 0x644, 0x623, 0x207, 0x644, 0x625, 0x206,
    0x644, 0x625, 0x207, 0x644, 0x627, 0x206, 0x644, 0x627,
    0x10c, 0x21, 0x10c, 0x22, 0x10c, 0x23, 0x10c, 0x24,
    0x10c, 0x25, 0x10c, 0x26, 0x10c, 0x27, 0x10c, 0x28,
    0x10c, 0x29, 0x10c, 0x2a, 0x10c, 0x2b, 0x10c, 0x2c,
    0x10c, 0x2d, 0x10c, 0x2e, 0x10c, 0x2f, 0x10c, 0x30,
    0x10c, 0x31, 0x10c, 0x32, 0x10c, 0x33, 0x10c, 0x34,
    0x10c, 0x35, 0x10c, 0x36, 0x10c, 0x37, 0x10c, 0x38,
    0x10c, 0x39, 0x10c, 0x3a, 0x10c, 0x3b, 0x10c, 0x3c,
    0x10c, 0x3d, 0x10c, 0x3e, 0x10c, 0x3f, 0x10c, 0x40,
    0x10c, 0x41, 0x10c, 0x42, 0x10c, 0x43, 0x10c, 0x44,
    0x10c, 0x45, 0x10c, 0x46, 0x10c, 0x47, 0x10c, 0x48,
    0x10c, 0x49, 0x10c, 0x4a, 0x10c, 0x4b, 0x10c, 0x4c,
    0x10c, 0x4d, 0x10c, 0x4e, 0x10c, 0x4f, 0x10c, 0x50,
    0x10c, 0x51, 0x10c, 0x52, 0x10c, 0x53, 0x10c, 0x54,
    0x10c, 0x55, 0x10c, 0x56, 0x10c, 0x57, 0x10c, 0x58,
    0x10c, 0x59, 0x10c, 0x5a, 0x10c, 0x5b, 0x10c, 0x5c,
    0x10c, 0x5d, 0x10c, 0x5e, 0x10c, 0x5f, 0x10c, 0x60,
    0x10c, 0x61, 0x10c, 0x62, 0x10c, 0x63, 0x10c, 0x64,
    0x10c, 0x65, 0x10c, 0x66, 0x10c, 0x67, 0x10c, 0x68,
    0x10c, 0x69, 0x10c, 0x6a, 0x10c, 0x6b, 0x10c, 0x6c,
    0x10c, 0x6d, 0x10c, 0x6e, 0x10c, 0x6f, 0x10c, 0x70,
    0x10c, 0x71, 0x10c, 0x72, 0x10c, 0x73, 0x10c, 0x74,
    0x10c, 0x75, 0x10c, 0x76, 0x10c, 0x77, 0x10c, 0x78,
    0x10c, 0x79, 0x10c, 0x7a, 0x10c, 0x7b, 0x10c, 0x7c,
    0x10c, 0x7d, 0x10c, 0x7e, 0x10c, 0x2985, 0x10c, 0x2986,
    0x10d, 0x3002, 0x10d, 0x300c, 0x10d, 0x300d, 0x10d, 0x3001,
    0x10d, 0x30fb, 0x10d, 0x30f2, 0x10d, 0x30a1, 0x10d, 0x30a3,
    0x10d, 0x30a5, 0x10d, 0x30a7, 0x10d, 0x30a9, 0x10d, 0x30e3,
    0x10d, 0x30e5, 0x10d, 0x30e7, 0x10d, 0x30c3, 0x10d, 0x30fc,
    0x10d, 0x30a2, 0x10d, 0x30a4, 0x10d, 0x30a6, 0x10d, 0x30a8,
    0x10d, 0x30aa, 0x10d, 0x30ab, 0x10d, 0x30ad, 0x10d, 0x30af,
    0x10d, 0x30b1, 0x10d, 0x30b3, 0x10d, 0x30b5, 0x10d, 0x30b7,
    0x10d, 0x30b9, 0x10d, 0x30bb, 0x10d, 0x30bd, 0x10d, 0x30bf,
    0x10d, 0x30c1, 0x10d, 0x30c4, 0x10d, 0x30c6, 0x10d, 0x30c8,
    0x10d, 0x30ca, 0x10d, 0x30cb, 0x10d, 0x30cc, 0x10d, 0x30cd,
    0x10d, 0x30ce, 0x10d, 0x30cf, 0x10d, 0x30d2, 0x10d, 0x30d5,
    0x10d, 0x30d8, 0x10d, 0x30db, 0x10d, 0x30de, 0x10d, 0x30df,
    0x10d, 0x30e0, 0x10d, 0x30e1, 0x10d, 0x30e2, 0x10d, 0x30e4,
    0x10d, 0x30e6, 0x10d, 0x30e8, 0x10d, 0x30e9, 0x10d, 0x30ea,
    0x10d, 0x30eb, 0x10d, 0x30ec, 0x10d, 0x30ed, 0x10d, 0x30ef,
    0x10d, 0x30f3, 0x10d, 0x3099, 0x10d, 0x309a, 0x10d, 0x3164,
    0x10d, 0x3131, 0x10d, 0x3132, 0x10d, 0x3133, 0x10d, 0x3134,
    0x10d, 0x3135, 0x10d, 0x3136, 0x10d, 0x3137, 0x10d, 0x3138,
    0x10d, 0x3139, 0x10d, 0x313a, 0x10d, 0x313b, 0x10d, 0x313c,
    0x10d, 0x313d, 0x10d, 0x313e, 0x10d, 0x313f, 0x10d, 0x3140,
    0x10d, 0x3141, 0x10d, 0x3142, 0x10d, 0x3143, 0x10d, 0x3144,
    0x10d, 0x3145, 0x10d, 0x3146, 0x10d, 0x3147, 0x10d, 0x3148,
    0x10d, 0x3149, 0x10d, 0x314a, 0x10d, 0x314b, 0x10d, 0x314c,
    0x10d, 0x314d, 0x10d, 0x314e, 0x10d, 0x314f, 0x10d, 0x3150,
    0x10d, 0x3151, 0x10d, 0x3152, 0x10d, 0x3153, 0x10d, 0x3154,
    0x10d, 0x3155, 0x10d, 0x3156, 0x10d, 0x3157, 0x10d, 0x3158,
    0x10d, 0x3159, 0x10d, 0x315a, 0x10d, 0x315b, 0x10d, 0x315c,
    0x10d, 0x315d, 0x10d, 0x315e, 0x10d, 0x315f, 0x10d, 0x3160,
    0x10d, 0x3161, 0x10d, 0x3162, 0x10d, 0x3163, 0x10c, 0xa2,
    0x10c, 0xa3, 0x10c, 0xac, 0x10c, 0xaf, 0x10c, 0xa6,
    0x10c, 0xa5, 0x10c, 0x20a9, 0x10d, 0x2502, 0x10d, 0x2190,
    0x10d, 0x2191, 0x10d, 0x2192, 0x10d, 0x2193, 0x10d, 0x25a0,
    0x10d, 0x25cb, 0x109, 0x2d0, 0x109, 0x2d1, 0x109, 0xe6,
    0x109, 0x299, 0x109, 0x253, 0x109, 0x2a3, 0x109, 0xab66,
    0x109, 0x2a5, 0x109, 0x2a4, 0x109, 0x256, 0x109, 0x257,
    0x109, 0x1d91, 0x109, 0x258, 0x109, 0x25e, 0x109, 0x2a9,
    0x109, 0x264, 0x109, 0x262, 0x109, 0x260, 0x109, 0x29b,
    0x109, 0x127, 0x109, 0x29c, 0x109, 0x267, 0x109, 0x284,
    0x109, 0x2aa, 0x109, 0x2ab, 0x109, 0x26c, 0x109, 0x1df04,
    0x109, 0xa78e, 0x109, 0x26e, 0x109, 0x1df05, 0x109, 0x28e,
    0x109, 0x1df06, 0x109, 0xf8, 0x109, 0x276, 0x109, 0x277,
    0x109, 0x71, 0x109, 0x27a, 0x109, 0x1df08, 0x109, 0x27d,
    0x109, 0x27e, 0x109, 0x280, 0x109, 0x2a8, 0x109, 0x2a6,
    0x109, 0xab67, 0x109, 0x2a7, 0x109, 0x288, 0x109, 0x2c71,
    0x109, 0x28f, 0x109, 0x2a1, 0x109, 0x2a2, 0x109, 0x298,
    0x109, 0x1c0, 0x109, 0x1c1, 0x109, 0x1c2, 0x109, 0x1df0a,
    0x109, 0x1df1e, 0x201, 0x11099, 0x110ba, 0x201, 0x1109b, 0x110ba,
    0x201, 0x110a5, 0x110ba, 0x201, 0x11131, 0x11127, 0x201, 0x11132,
    0x11127, 0x201, 0x11347, 0x1133e, 0x201, 0x11347, 0x11357, 0x201,
    0x114b9, 0x114ba, 0x201, 0x114b9, 0x114b0, 0x201, 0x114b9, 0x114bd,
    0x201, 0x115b8, 0x115af, 0x201, 0x115b9, 0x115af, 0x201, 0x11935,
    0x11930, 0x201, 0x1d157, 0x1d165, 0x201, 0x1d158, 0x1d165, 0x201,
    0x1d15f, 0x1d16e, 0x201, 0x1d15f, 0x1d16f, 0x201, 0x1d15f, 0x1d170,
    0x201, 0x1d15f, 0x1d171, 0x201, 0x1d15f, 0x1d172, 0x201, 0x1d1b9,
    0x1d165, 0x201, 0x1d1ba, 0x1d165, 0x201, 0x1d1bb, 0x1d16e, 0x201,
    0x1d1bc, 0x1d16e, 0x201, 0x1d1bb, 0x1d16f, 0x201, 0x1d1bc, 0x1d16f,
    0x102, 0x41, 0x102, 0x42, 0x102, 0x43, 0x102, 0x44,
    0x102, 0x45, 0x102, 0x46, 0x102, 0x47, 0x102, 0x48,
    0x102, 0x49, 0x102, 0x4a, 0x102, 0x4b, 0x102, 0x4c,
    0x102, 0x4d, 0x102, 0x4e, 0x102, 0x4f, 0x102, 0x50,
    0x102, 0x51, 0x102, 0x52, 0x102, 0x53, 0x102, 0x54,
    0x102, 0x55, 0x102, 0x56, 0x102, 0x57, 0x102, 0x58,
    0x102, 0x59, 0x102, 0x5a, 0x102, 0x61, 0x102, 0x62,
    0x102, 0x63, 0x102, 0x64, 0x102, 0x65, 0x102, 0x66,
    0x102, 0x67, 0x102, 0x68, 0x102, 0x69, 0x102, 0x6a,
    0x102, 0x6b, 0x102, 0x6c, 0x102, 0x6d, 0x102, 0x6e,
    0x102, 0x6f, 0x102, 0x70, 0x102, 0x71, 0x102, 0x72,
    0x102, 0x73, 0x102, 0x74, 0x102, 0x75, 0x102, 0x76,
    0x102, 0x77, 0x102, 0x78, 0x102, 0x79, 0x102, 0x7a,
    0x102, 0x41, 0x102, 0x42, 0x102, 0x43, 0x102, 0x44,
    0x102, 0x45, 0x102, 0x46, 0x102, 0x47, 0x102, 0x48,
    0x102, 0x49, 0x102, 0x4a, 0x102, 0x4b, 0x102, 0x4c,
    0x102, 0x4d, 0x102, 0x4e, 0x102, 0x4f, 0x102, 0x50,
    0x102, 0x51, 0x102, 0x52, 0x102, 0x53, 0x102, 0x54,
    0x102, 0x55, 0x102, 0x56, 0x102, 0x57, 0x102, 0x58,
    0x102, 0x59, 0x102, 0x5a, 0x102, 0x61, 0x102, 0x62,
    0x102, 0x63, 0x102, 0x64, 0x102, 0x65, 0x102, 0x66,
    0x102, 0x67, 0x102, 0x69, 0x102, 0x6a, 0x102, 0x6b,
    0x102, 0x6c, 0x102, 0x6d, 0x102, 0x6e, 0x102, 0x6f,
    0x102, 0x70, 0x102, 0x71, 0x102, 0x72, 0x102, 0x73,
    0x102, 0x74, 0x102, 0x75, 0x102, 0x76, 0x102, 0x77,
    0x102, 0x78, 0x102, 0x79, 0x102, 0x7a, 0x102, 0x41,
    0x102, 0x42, 0x102, 0x43, 0x102, 0x44, 0x102, 0x45,
    0x102, 0x46, 0x102, 0x47, 0x102, 0x48, 0x102, 0x49,
    0x102, 0x4a, 0x102, 0x4b, 0x102, 0x4c, 0x102, 0x4d,
    0x102, 0x4e, 0x102, 0x4f, 0x102, 0x50, 0x102, 0x51,
    0x102, 0x52, 0x102, 0x53, 0x102, 0x54, 0x102, 0x55,
    0x102, 0x56, 0x102, 0x57, 0x102, 0x58, 0x102, 0x59,
    0x102, 0x5a, 0x102, 0x61, 0x102, 0x62, 0x102, 0x63,
    0x102, 0x64, 0x102, 0x65, 0x102, 0x66, 0x102, 0x67,
    0x102, 0x68, 0x102, 0x69, 0x102, 0x6a, 0x102, 0x6b,
    0x102, 0x6c, 0x102, 0x6d, 0x102, 0x6e, 0x102, 0x6f,
    0x102, 0x70, 0x102, 0x71, 0x102, 0x72, 0x102, 0x73,
    0x102, 0x74, 0x102, 0x75, 0x102, 0x76, 0x102, 0x77,
    0x102, 0x78, 0x102, 0x79, 0x102, 0x7a, 0x102, 0x41,
    0x102, 0x43, 0x102, 0x44, 0x102, 0x47, 0x102, 0x4a,
    0x102, 0x4b, 0x102, 0x4e, 0x102, 0x4f, 0x102, 0x50,
    0x102, 0x51, 0x102, 0x53, 0x102, 0x54, 0x102, 0x55,
    0x102, 0x56, 0x102, 0x57, 0x102, 0x58, 0x102, 0x59,
    0x102, 0x5a, 0x102, 0x61, 0x102, 0x62, 0x102, 0x63,
    0x102, 0x64, 0x102, 0x66, 0x102, 0x68, 0x102, 0x69,
    0x102, 0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102, 0x6d,
    0x102, 0x6e, 0x102, 0x70, 0x102, 0x71, 0x102, 0x72,
    0x102, 0x73, 0x102, 0x74, 0x102, 0x75, 0x102, 0x76,
    0x102, 0x77, 0x102, 0x78, 0x102, 0x79, 0x102, 0x7a,
    0x102, 0x41, 0x102, 0x42, 0x102, 0x43, 0x102, 0x44,
    0x102, 0x45, 0x102, 0x46, 0x102, 0x47, 0x102, 0x48,
    0x102, 0x49, 0x102, 0x4a, 0x102, 0x4b, 0x102, 0x4c,
    0x102, 0x4d, 0x102, 0x4e, 0x102, 0x4f, 0x102, 0x50,
    0x102, 0x51, 0x102, 0x52, 0x102, 0x53, 0x102, 0x54,
    0x102, 0x55, 0x102, 0x56, 0x102, 0x57, 0x102, 0x58,
    0x102, 0x59, 0x102, 0x5a, 0x102, 0x61, 0x102, 0x62,
    0x102, 0x63, 0x102, 0x64, 0x102, 0x65, 0x102, 0x66,
    0x102, 0x67, 0x102, 0x68, 0x102, 0x69, 0x102, 0x6a,
    0x102, 0x6b, 0x102, 0x6c, 0x102, 0x6d, 0x102, 0x6e,
    0x102, 0x6f, 0x102, 0x70, 0x102, 0x71, 0x102, 0x72,
    0x102, 0x73, 0x102, 0x74, 0x102, 0x75, 0x102, 0x76,
    0x102, 0x77, 0x102, 0x78, 0x102, 0x79, 0x102, 0x7a,
    0x102, 0x41, 0x102, 0x42, 0x102, 0x44, 0x102, 0x45,
    0x102, 0x46, 0x102, 0x47, 0x102, 0x4a, 0x102, 0x4b,
    0x102, 0x4c, 0x102, 0x4d, 0x102, 0x4e, 0x102, 0x4f,
    0x102, 0x50, 0x102, 0x51, 0x102, 0x53, 0x102, 0x54,
    0x102, 0x55, 0x102, 0x56, 0x102, 0x57, 0x102, 0x58,
    0x102, 0x59, 0x102, 0x61, 0x102, 0x62, 0x102, 0x63,
    0x102, 0x64, 0x102, 0x65, 0x102, 0x66, 0x102, 0x67,
    0x102, 0x68, 0x102, 0x69, 0x102, 0x6a, 0x102, 0x6b,
    0x102, 0x6c, 0x102, 0x6d, 0x102, 0x6e, 0x102, 0x6f,
    0x102, 0x70, 0x102, 0x71, 0x102, 0x72, 0x102, 0x73,
    0x102, 0x74, 0x102, 0x75, 0x102, 0x76, 0x102, 0x77,
    0x102, 0x78, 0x102, 0x79, 0x102, 0x7a, 0x102, 0x41,
    0x102, 0x42, 0x102, 0x44, 0x102, 0x45, 0x102, 0x46,
    0x102, 0x47, 0x102, 0x49, 0x102, 0x4a, 0x102, 0x4b,
    0x102, 0x4c, 0x102, 0x4d, 0x102, 0x4f, 0x102, 0x53,
    0x102, 0x54, 0x102, 0x55, 0x102, 0x56, 0x102, 0x57,
    0x102, 0x58, 0x102, 0x59, 0x102, 0x61, 0x102, 0x62,
    0x102, 0x63, 0x102, 0x64, 0x102, 0x65, 0x102, 0x66,
    0x102, 0x67, 0x102, 0x68, 0x102, 0x69, 0x102, 0x6a,
    0x102, 0x6b, 0x102, 0x6c, 0x102, 0x6d, 0x102, 0x6e,
    0x102, 0x6f, 0x102, 0x70, 0x102, 0x71, 0x102, 0x72,
    0x102, 0x73, 0x102, 0x74, 0x102, 0x75, 0x102, 0x76,
    0x102, 0x77, 0x102, 0x78, 0x102, 0x79, 0x102, 0x7a,
    0x102, 0x41, 0x102, 0x42, 0x102, 0x43, 0x102, 0x44,
    0x102, 0x45, 0x102, 0x46, 0x102, 0x47, 0x102, 0x48,
    0x102, 0x49, 0x102, 0x4a, 0x102, 0x4b, 0x102, 0x4c,
    0x102, 0x4d, 0x102, 0x4e, 0x102, 0x4f, 0x102, 0x50,
    0x102, 0x51, 0x102, 0x52, 0x102, 0x53, 0x102, 0x54,
    0x102, 0x55, 0x102, 0x56, 0x102, 0x57, 0x102, 0x58,
    0x102, 0x59, 0x102, 0x5a, 0x102, 0x61, 0x102, 0x62,
    0x102, 0x63, 0x102, 0x64, 0x102, 0x65, 0x102, 0x66,
    0x102, 0x67, 0x102, 0x68, 0x102, 0x69, 0x102, 0x6a,
    0x102, 0x6b, 0x102, 0x6c, 0x102, 0x6d, 0x102, 0x6e,
    0x102, 0x6f, 0x102, 0x70, 0x102, 0x71, 0x102, 0x72,
    0x102, 0x73, 0x102, 0x74, 0x102, 0x75, 0x102, 0x76,
    0x102, 0x77, 0x102, 0x78, 0x102, 0x79, 0x102, 0x7a,
    0x102, 0x41, 0x102, 0x42, 0x102, 0x43, 0x102, 0x44,
    0x102, 0x45, 0x102, 0x46, 0x102, 0x47, 0x102, 0x48,
    0x102, 0x49, 0x102, 0x4a, 0x102, 0x4b, 0x102, 0x4c,
    0x102, 0x4d, 0x102, 0x4e, 0x102, 0x4f, 0x102, 0x50,
    0x102, 0x51, 0x102, 0x52, 0x102, 0x53, 0x102, 0x54,
    0x102, 0x55, 0x102, 0x56, 0x102, 0x57, 0x102, 0x58,
    0x102, 0x59, 0x102, 0x5a, 0x102, 0x61, 0x102, 0x62,
    0x102, 0x63, 0x102, 0x64, 0x102, 0x65, 0x102, 0x66,
    0x102, 0x67, 0x102, 0x68, 0x102, 0x69, 0x102, 0x6a,
    0x102, 0x6b, 0x102, 0x6c, 0x102, 0x6d, 0x102, 0x6e,
    0x102, 0x6f, 0x102, 0x70, 0x102, 0x71, 0x102, 0x72,
    0x102, 0x73, 0x102, 0x74, 0x102, 0x75, 0x102, 0x76,
    0x102, 0x77, 0x102, 0x78, 0x102, 0x79, 0x102, 0x7a,
    0x102, 0x41, 0x102, 0x42, 0x102, 0x43, 0x102, 0x44,
    0x102, 0x45, 0x102, 0x46, 0x102, 0x47, 0x102, 0x48,
    0x102, 0x49, 0x102, 0x4a, 0x102, 0x4b, 0x102, 0x4c,
    0x102, 0x4d, 0x102, 0x4e, 0x102, 0x4f, 0x102, 0x50,
    0x102, 0x51, 0x102, 0x52, 0x102, 0x53, 0x102, 0x54,
    0x102, 0x55, 0x102, 0x56, 0x102, 0x57, 0x102, 0x58,
    0x102, 0x59, 0x102, 0x5a, 0x102, 0x61, 0x102, 0x62,
    0x102, 0x63, 0x102, 0x64, 0x102, 0x65, 0x102, 0x66,
    0x102, 0x67, 0x102, 0x68, 0x102, 0x69, 0x102, 0x6a,
    0x102, 0x6b, 0x102, 0x6c, 0x102, 0x6d, 0x102, 0x6e,
    0x102, 0x6f, 0x102, 0x70, 0x102, 0x71, 0x102, 0x72,
    0x102, 0x73, 0x102, 0x74, 0x102, 0x75, 0x102, 0x76,
    0x102, 0x77, 0x102, 0x78, 0x102, 0x79, 0x102, 0x7a,
    0x102, 0x41, 0x102, 0x42, 0x102, 0x43, 0x102, 0x44,
    0x102, 0x45, 0x102, 0x46, 0x102, 0x47, 0x102, 0x48,
    0x102, 0x49, 0x102, 0x4a, 0x102, 0x4b, 0x102, 0x4c,
    0x102, 0x4d, 0x102, 0x4e, 0x102, 0x4f, 0x102, 0x50,
    0x102, 0x51, 0x102, 0x52, 0x102, 0x53, 0x102, 0x54,
    0x102, 0x55, 0x102, 0x56, 0x102, 0x57, 0x102, 0x58,
    0x102, 0x59, 0x102, 0x5a, 0x102, 0x61, 0x102, 0x62,
    0x102, 0x63, 0x102, 0x64, 0x102, 0x65, 0x102, 0x66,
    0x102, 0x67, 0x102, 0x68, 0x102, 0x69, 0x102, 0x6a,
    0x102, 0x6b, 0x102, 0x6c, 0x102, 0x6d, 0x102, 0x6e,
    0x102, 0x6f, 0x102, 0x70, 0x102, 0x71, 0x102, 0x72,
    0x102, 0x73, 0x102, 0x74, 0x102, 0x75, 0x102, 0x76,
    0x102, 0x77, 0x102, 0x78, 0x102, 0x79, 0x102, 0x7a,
    0x102, 0x41, 0x102, 0x42, 0x102, 0x43, 0x102, 0x44,
    0x102, 0x45, 0x102, 0x46, 0x102, 0x47, 0x102, 0x48,
    0x102, 0x49, 0x102, 0x4a, 0x102, 0x4b, 0x102, 0x4c,
    0x102, 0x4d, 0x102, 0x4e, 0x102, 0x4f, 0x102, 0x50,
    0x102, 0x51, 0x102, 0x52, 0x102, 0x53, 0x102, 0x54,
    0x102, 0x55, 0x102, 0x56, 0x102, 0x57, 0x102, 0x58,
    0x102, 0x59, 0x102, 0x5a, 0x102, 0x61, 0x102, 0x62,
    0x102, 0x63, 0x102, 0x64, 0x102, 0x65, 0x102, 0x66,
    0x102, 0x67, 0x102, 0x68, 0x102, 0x69, 0x102, 0x6a,
    0x102, 0x6b, 0x102, 0x6c, 0x102, 0x6d, 0x102, 0x6e,
    0x102, 0x6f, 0x102, 0x70, 0x102, 0x71, 0x102, 0x72,
    0x102, 0x73, 0x102, 0x74, 0x102, 0x75, 0x102, 0x76,
    0x102, 0x77, 0x102, 0x78, 0x102, 0x79, 0x102, 0x7a,
    0x102, 0x41, 0x102, 0x42, 0x102, 0x43, 0x102, 0x44,
    0x102, 0x45, 0x102, 0x46, 0x102, 0x47, 0x102, 0x48,
    0x102, 0x49, 0x102, 0x4a, 0x102, 0x4b, 0x102, 0x4c,
    0x102, 0x4d, 0x102, 0x4e, 0x102, 0x4f, 0x102, 0x50,
    0x102, 0x51, 0x102, 0x52, 0x102, 0x53, 0x102, 0x54,
    0x102, 0x55, 0x102, 0x56, 0x102, 0x57, 0x102, 0x58,
    0x102, 0x59, 0x102, 0x5a, 0x102, 0x61, 0x102, 0x62,
    0x102, 0x63, 0x102, 0x64, 0x102, 0x65, 0x102, 0x66,
    0x102, 0x67, 0x102, 0x68, 0x102, 0x69, 0x102, 0x6a,
    0x102, 0x6b, 0x102, 0x6c, 0x102, 0x6d, 0x102, 0x6e,
    0x102, 0x6f, 0x102, 0x70, 0x102, 0x71, 0x102, 0x72,
    0x102, 0x73, 0x102, 0x74, 0x102, 0x75, 0x102, 0x76,
    0x102, 0x77, 0x102, 0x78, 0x102, 0x79, 0x102, 0x7a,
    0x102, 0x131, 0x102, 0x237, 0x102, 0x391, 0x102, 0x392,
    0x102, 0x393, 0x102, 0x394, 0x102, 0x395, 0x102, 0x396,
    0x102, 0x397, 0x102, 0x398, 0x102, 0x399, 0x102, 0x39a,
    0x102, 0x39b, 0x102, 0x39c, 0x102, 0x39d, 0x102, 0x39e,
    0x102, 0x39f, 0x102, 0x3a0, 0x102, 0x3a1, 0x102, 0x3f4,
    0x102, 0x3a3, 0x102, 0x3a4, 0x102, 0x3a5, 0x102, 0x3a6,
    0x102, 0x3a7, 0x102, 0x3a8, 0x102, 0x3a9, 0x102, 0x2207,
    0x102, 0x3b1, 0x102, 0x3b2, 0x102, 0x3b3, 0x102, 0x3b4,
    0x102, 0x3b5, 0x102, 0x3b6, 0x102, 0x3b7, 0x102, 0x3b8,
    0x102, 0x3b9, 0x102, 0x3ba, 0x102, 0x3bb, 0x102, 0x3bc,
    0x102, 0x3bd, 0x102, 0x3be, 0x102, 0x3bf, 0x102, 0x3c0,
    0x102, 0x3c1, 0x102, 0x3c2, 0x102, 0x3c3, 0x102, 0x3c4,
    0x102, 0x3c5, 0x102, 0x3c6, 0x102, 0x3c7, 0x102, 0x3c8,
    0x102, 0x3c9, 0x102, 0x2202, 0x102, 0x3f5, 0x102, 0x3d1,
    0x102, 0x3f0, 0x102, 0x3d5, 0x102, 0x3f1, 0x102, 0x3d6,
    0x102, 0x391, 0x102, 0x392, 0x102, 0x393, 0x102, 0x394,
    0x102, 0x395, 0x102, 0x396, 0x102, 0x397, 0x102, 0x398,
    0x102, 0x399, 0x102, 0x39a, 0x102, 0x39b, 0x102, 0x39c,
    0x102, 0x39d, 0x102, 0x39e, 0x102, 0x39f, 0x102, 0x3a0,
    0x102, 0x3a1, 0x102, 0x3f4, 0x102, 0x3a3, 0x102, 0x3a4,
    0x102, 0x3a5, 0x102, 0x3a6, 0x102, 0x3a7, 0x102, 0x3a8,
    0x102, 0x3a9, 0x102, 0x2207, 0x102, 0x3b1, 0x102, 0x3b2,
    0x102, 0x3b3, 0x102, 0x3b4, 0x102, 0x3b5, 0x102, 0x3b6,
    0x102, 0x3b7, 0x102, 0x3b8, 0x102, 0x3b9, 0x102, 0x3ba,
    0x102, 0x3bb, 0x102, 0x3bc, 0x102, 0x3bd, 0x102, 0x3be,
    0x102, 0x3bf, 0x102, 0x3c0, 0x102, 0x3c1, 0x102, 0x3c2,
    0x102, 0x3c3, 0x102, 0x3c4, 0x102, 0x3c5, 0x102, 0x3c6,
    0x102, 0x3c7, 0x102, 0x3c8, 0x102, 0x3c9, 0x102, 0x2202,
    0x102, 0x3f5, 0x102, 0x3d1, 0x102, 0x3f0, 0x102, 0x3d5,
    0x102, 0x3f1, 0x102, 0x3d6, 0x102, 0x391, 0x102, 0x392,
    0x102, 0x393, 0x102, 0x394, 0x102, 0x395, 0x102, 0x396,
    0x102, 0x397, 0x102, 0x398, 0x102, 0x399, 0x102, 0x39a,
    0x102, 0x39b, 0x102, 0x39c, 0x102, 0x39d, 0x102, 0x39e,
    0x102, 0x39f, 0x102, 0x3a0, 0x102, 0x3a1, 0x102, 0x3f4,
    0x102, 0x3a3, 0x102, 0x3a4, 0x102, 0x3a5, 0x102, 0x3a6,
    0x102, 0x3a7, 0x102, 0x3a8, 0x102, 0x3a9, 0x102, 0x2207,
    0x102, 0x3b1, 0x102, 0x3b2, 0x102, 0x3b3, 0x102, 0x3b4,
    0x102, 0x3b5, 0x102, 0x3b6, 0x102, 0x3b7, 0x102, 0x3b8,
    0x102, 0x3b9, 0x102, 0x3ba, 0x102, 0x3bb, 0x102, 0x3bc,
    0x102, 0x3bd, 0x102, 0x3be, 0x102, 0x3bf, 0x102, 0x3c0,
    0x102, 0x3c1, 0x102, 0x3c2, 0x102, 0x3c3, 0x102, 0x3c4,
    0x102, 0x3c5, 0x102, 0x3c6, 0x102, 0x3c7, 0x102, 0x3c8,
    0x102, 0x3c9, 0x102, 0x2202, 0x102, 0x3f5, 0x102, 0x3d1,
    0x102, 0x3f0, 0x102, 0x3d5, 0x102, 0x3f1, 0x102, 0x3d6,
    0x102, 0x391, 0x102, 0x392, 0x102, 0x393, 0x102, 0x394,
    0x102, 0x395, 0x102, 0x396, 0x102, 0x397, 0x102, 0x398,
    0x102, 0x399, 0x102, 0x39a, 0x102, 0x39b, 0x102, 0x39c,
    0x102, 0x39d, 0x102, 0x39e, 0x102, 0x39f, 0x102, 0x3a0,
    0x102, 0x3a1, 0x102, 0x3f4, 0x102, 0x3a3, 0x102, 0x3a4,
    0x102, 0x3a5, 0x102, 0x3a6, 0x102, 0x3a7, 0x102, 0x3a8,
    0x102, 0x3a9, 0x102, 0x2207, 0x102, 0x3b1, 0x102, 0x3b2,
    0x102, 0x3b3, 0x102, 0x3b4, 0x102, 0x3b5, 0x102, 0x3b6,
    0x102, 0x3b7, 0x102, 0x3b8, 0x102, 0x3b9, 0x102, 0x3ba,
    0x102, 0x3bb, 0x102, 0x3bc, 0x102, 0x3bd, 0x102, 0x3be,
    0x102, 0x3bf, 0x102, 0x3c0, 0x102, 0x3c1, 0x102, 0x3c2,
    0x102, 0x3c3, 0x102, 0x3c4, 0x102, 0x3c5, 0x102, 0x3c6,
    0x102, 0x3c7, 0x102, 0x3c8, 0x102, 0x3c9, 0x102, 0x2202,
    0x102, 0x3f5, 0x102, 0x3d1, 0x102, 0x3f0, 0x102, 0x3d5,
    0x102, 0x3f1, 0x102, 0x3d6, 0x102, 0x391, 0x102, 0x392,
    0x102, 0x393, 0x102, 0x394, 0x102, 0x395, 0x102, 0x396,
    0x102, 0x397, 0x102, 0x398, 0x102, 0x399, 0x102, 0x39a,
    0x102, 0x39b, 0x102, 0x39c, 0x102, 0x39d, 0x102, 0x39e,
    0x102, 0x39f, 0x102, 0x3a0, 0x102, 0x3a1, 0x102, 0x3f4,
    0x102, 0x3a3, 0x102, 0x3a4, 0x102, 0x3a5, 0x102, 0x3a6,
    0x102, 0x3a7, 0x102, 0x3a8, 0x102, 0x3a9, 0x102, 0x2207,
    0x102, 0x3b1, 0x102, 0x3b2, 0x102, 0x3b3, 0x102, 0x3b4,
    0x102, 0x3b5, 0x102, 0x3b6, 0x102, 0x3b7, 0x102, 0x3b8,
    0x102, 0x3b9, 0x102, 0x3ba, 0x102, 0x3bb, 0x102, 0x3bc,
    0x102, 0x3bd, 0x102, 0x3be, 0x102, 0x3bf, 0x102, 0x3c0,
    0x102, 0x3c1, 0x102, 0x3c2, 0x102, 0x3c3, 0x102, 0x3c4,
    0x102, 0x3c5, 0x102, 0x3c6, 0x102, 0x3c7, 0x102, 0x3c8,
    0x102, 0x3c9, 0x102, 0x2202, 0x102, 0x3f5, 0x102, 0x3d1,
    0x102, 0x3f0, 0x102, 0x3d5, 0x102, 0x3f1, 0x102, 0x3d6,
    0x102, 0x3dc, 0x102, 0x3dd, 0x102, 0x30, 0x102, 0x31,
    0x102, 0x32, 0x102, 0x33, 0x102, 0x34, 0x102, 0x35,
    0x102, 0x36, 0x102, 0x37, 0x102, 0x38, 0x102, 0x39,
    0x102, 0x30, 0x102, 0x31, 0x102, 0x32, 0x102, 0x33,
    0x102, 0x34, 0x102, 0x35, 0x102, 0x36, 0x102, 0x37,
    0x102, 0x38, 0x102, 0x39, 0x102, 0x30, 0x102, 0x31,
    0x102, 0x32, 0x102, 0x33, 0x102, 0x34, 0x102, 0x35,
    0x102, 0x36, 0x102, 0x37, 0x102, 0x38, 0x102, 0x39,
    0x102, 0x30, 0x102, 0x31, 0x102, 0x32, 0x102, 0x33,
    0x102, 0x34, 0x102, 0x35, 0x102, 0x36, 0x102, 0x37,
    0x102, 0x38, 0x102, 0x39, 0x102, 0x30, 0x102, 0x31,
    0x102, 0x32, 0x102, 0x33, 0x102, 0x34, 0x102, 0x35,
    0x102, 0x36, 0x102, 0x37, 0x102, 0x38, 0x102, 0x39,
    0x109, 0x430, 0x109, 0x431, 0x109, 0x432, 0x109, 0x433,
    0x109, 0x434, 0x109, 0x435, 0x109, 0x436, 0x109, 0x437,
    0x109, 0x438, 0x109, 0x43a, 0x109, 0x43b, 0x109, 0x43c,
    0x109, 0x43e, 0x109, 0x43f, 0x109, 0x440, 0x109, 0x441,
    0x109, 0x442, 0x109, 0x443, 0x109, 0x444, 0x109, 0x445,
    0x109, 0x446, 0x109, 0x447, 0x109, 0x448, 0x109, 0x44b,
    0x109, 0x44d, 0x109, 0x44e, 0x109, 0xa689, 0x109, 0x4d9,
    0x109, 0x456, 0x109, 0x458, 0x109, 0x4e9, 0x109, 0x4af,
    0x109, 0x4cf, 0x10a, 0x430, 0x10a, 0x431, 0x10a, 0x432,
    0x10a, 0x433, 0x10a, 0x434, 0x10a, 0x435, 0x10a, 0x436,
    0x10a, 0x437, 0x10a, 0x438, 0x10a, 0x43a, 0x10a, 0x43b,
    0x10a, 0x43e, 0x10a, 0x43f, 0x10a, 0x441, 0x10a, 0x443,
    0x10a, 0x444, 0x10a, 0x445, 0x10a, 0x446, 0x10a, 0x447,
    0x10a, 0x448, 0x10a, 0x44a, 0x10a, 0x44b, 0x10a, 0x491,
    0x10a, 0x456, 0x10a, 0x455, 0x10a, 0x45f, 0x109, 0x4ab,
    0x109, 0xa651, 0x109, 0x4b1, 0x102, 0x627, 0x102, 0x628,
    0x102, 0x62c, 0x102, 0x62f, 0x102, 0x648, 0x102, 0x632,
    0x102, 0x62d, 0x102, 0x637, 0x102, 0x64a, 0x102, 0x643,
    0x102, 0x644, 0x102, 0x645, 0x102, 0x646, 0x102, 0x633,
    0x102, 0x639, 0x102, 0x641, 0x102, 0x635, 0x102, 0x642,
    0x102, 0x631, 0x102, 0x634, 0x102, 0x62a, 0x102, 0x62b,
    0x102, 0x62e, 0x102, 0x630, 0x102, 0x636, 0x102, 0x638,
    0x102, 0x63a, 0x102, 0x66e, 0x102, 0x6ba, 0x102, 0x6a1,
    0x102, 0x66f, 0x102, 0x628, 0x102, 0x62c, 0x102, 0x647,
    0x102, 0x62d, 0x102, 0x64a, 0x102, 0x643, 0x102, 0x644,
    0x102, 0x645, 0x102, 0x646, 0x102, 0x633, 0x102, 0x639,
    0x102, 0x641, 0x102, 0x635, 0x102, 0x642, 0x102, 0x634,
    0x102, 0x62a, 0x102, 0x62b, 0x102, 0x62e, 0x102, 0x636,
    0x102, 0x63a, 0x102, 0x62c, 0x102, 0x62d, 0x102, 0x64a,
    0x102, 0x644, 0x102, 0x646, 0x102, 0x633, 0x102, 0x639,
    0x102, 0x635, 0x102, 0x642, 0x102, 0x634, 0x102, 0x62e,
    0x102, 0x636, 0x102, 0x63a, 0x102, 0x6ba, 0x102, 0x66f,
    0x102, 0x628, 0x102, 0x62c, 0x102, 0x647, 0x102, 0x62d,
    0x102, 0x637, 0x102, 0x64a, 0x102, 0x643, 0x102, 0x645,
    0x102, 0x646, 0x102, 0x633, 0x102, 0x639, 0x102, 0x641,
    0x102, 0x635, 0x102, 0x642, 0x102, 0x634, 0x102, 0x62a,
    0x102, 0x62b, 0x102, 0x62e, 0x102, 0x636, 0x102, 0x638,
    0x102, 0x63a, 0x102, 0x66e, 0x102, 0x6a1, 0x102, 0x627,
    0x102, 0x628, 0x102, 0x62c, 0x102, 0x62f, 0x102, 0x647,
    0x102, 0x648, 0x102, 0x632, 0x102, 0x62d, 0x102, 0x637,
    0x102, 0x64a, 0x102, 0x644, 0x102, 0x645, 0x102, 0x646,
    0x102, 0x633, 0x102, 0x639, 0x102, 0x641, 0x102, 0x635,
    0x102, 0x642, 0x102, 0x631, 0x102, 0x634, 0x102, 0x62a,
    0x102, 0x62b, 0x102, 0x62e, 0x102, 0x630, 0x102, 0x636,
    0x102, 0x638, 0x102, 0x63a, 0x102, 0x628, 0x102, 0x62c,
    0x102, 0x62f, 0x102, 0x648, 0x102, 0x632, 0x102, 0x62d,
    0x102, 0x637, 0x102, 0x64a, 0x102, 0x644, 0x102, 0x645,
    0x102, 0x646, 0x102, 0x633, 0x102, 0x639, 0x102, 0x641,
    0x102, 0x635, 0x102, 0x642, 0x102, 0x631, 0x102, 0x634,
    0x102, 0x62a, 0x102, 0x62b, 0x102, 0x62e, 0x102, 0x630,
    0x102, 0x636, 0x102, 0x638, 0x102, 0x63a, 0x210, 0x30,
    0x2e, 0x210, 0x30, 0x2c, 0x210, 0x31, 0x2c, 0x210,
    0x32, 0x2c, 0x210, 0x33, 0x2c, 0x210, 0x34, 0x2c,
    0x210, 0x35, 0x2c, 0x210, 0x36, 0x2c, 0x210, 0x37,
    0x2c, 0x210, 0x38, 0x2c, 0x210, 0x39, 0x2c, 0x310,
    0x28, 0x41, 0x29, 0x310, 0x28, 0x42, 0x29, 0x310,
    0x28, 0x43, 0x29, 0x310, 0x28, 0x44, 0x29, 0x310,
    0x28, 0x45, 0x29, 0x310, 0x28, 0x46, 0x29, 0x310,
    0x28, 0x47, 0x29, 0x310, 0x28, 0x48, 0x29, 0x310,
    0x28, 0x49, 0x29, 0x310, 0x28, 0x4a, 0x29, 0x310,
    0x28, 0x4b, 0x29, 0x310, 0x28, 0x4c, 0x29, 0x310,
    0x28, 0x4d, 0x29, 0x310, 0x28, 0x4e, 0x29, 0x310,
    0x28, 0x4f, 0x29, 0x310, 0x28, 0x50, 0x29, 0x310,
    0x28, 0x51, 0x29, 0x310, 0x28, 0x52, 0x29, 0x310,
    0x28, 0x53, 0x29, 0x310, 0x28, 0x54, 0x29, 0x310,
    0x28, 0x55, 0x29, 0x310, 0x28, 0x56, 0x29, 0x310,
    0x28, 0x57, 0x29, 0x310, 0x28, 0x58, 0x29, 0x310,
    0x28, 0x59, 0x29, 0x310, 0x28, 0x5a, 0x29, 0x310,
    0x3014, 0x53, 0x3015, 0x108, 0x43, 0x108, 0x52, 0x208,
    0x43, 0x44, 0x208, 0x57, 0x5a, 0x10f, 0x41, 0x10f,
    0x42, 0x10f, 0x43, 0x10f, 0x44, 0x10f, 0x45, 0x10f,
    0x46, 0x10f, 0x47, 0x10f, 0x48, 0x10f, 0x49, 0x10f,
    0x4a, 0x10f, 0x4b, 0x10f, 0x4c, 0x10f, 0x4d, 0x10f,
    0x4e, 0x10f, 0x4f, 0x10f, 0x50, 0x10f, 0x51, 0x10f,
    0x52, 0x10f, 0x53, 0x10f, 0x54, 0x10f, 0x55, 0x10f,
    0x56, 0x10f, 0x57, 0x10f, 0x58, 0x10f, 0x59, 0x10f,
    0x5a, 0x20f, 0x48, 0x56, 0x20f, 0x4d, 0x56, 0x20f,
    0x53, 0x44, 0x20f, 0x53, 0x53, 0x30f, 0x50, 0x50,
    0x56, 0x20f, 0x57, 0x43, 0x209, 0x4d, 0x43, 0x209,
    0x4d, 0x44, 0x209, 0x4d, 0x52, 0x20f, 0x44, 0x4a,
    0x20f, 0x307b, 0x304b, 0x20f, 0x30b3, 0x30b3, 0x10f, 0x30b5,
    0x10f, 0x624b, 0x10f, 0x5b57, 0x10f, 0x53cc, 0x10f, 0x30c7,
    0x10f, 0x4e8c, 0x10f, 0x591a, 0x10f, 0x89e3, 0x10f, 0x5929,
    0x10f, 0x4ea4, 0x10f, 0x6620, 0x10f, 0x7121, 0x10f, 0x6599,
    0x10f, 0x524d, 0x10f, 0x5f8c, 0x10f, 0x518d, 0x10f, 0x65b0,
    0x10f, 0x521d, 0x10f, 0x7d42, 0x10f, 0x751f, 0x10f, 0x8ca9,
    0x10f, 0x58f0, 0x10f, 0x5439, 0x10f, 0x6f14, 0x10f, 0x6295,
    0x10f, 0x6355, 0x10f, 0x4e00, 0x10f, 0x4e09, 0x10f, 0x904a,
    0x10f, 0x5de6, 0x10f, 0x4e2d, 0x10f, 0x53f3, 0x10f, 0x6307,
    0x10f, 0x8d70, 0x10f, 0x6253, 0x10f, 0x7981, 0x10f, 0x7a7a,
    0x10f, 0x5408, 0x10f, 0x6e80, 0x10f, 0x6709, 0x10f, 0x6708,
    0x10f, 0x7533, 0x10f, 0x5272, 0x10f, 0x55b6, 0x10f, 0x914d,
    0x310, 0x3014, 0x672c, 0x3015, 0x310, 0x3014, 0x4e09, 0x3015,
    0x310, 0x3014, 0x4e8c, 0x3015, 0x310, 0x3014, 0x5b89, 0x3015,
    0x310, 0x3014, 0x70b9, 0x3015, 0x310, 0x3014, 0x6253, 0x3015,
    0x310, 0x3014, 0x76d7, 0x3015, 0x310, 0x3014, 0x52dd, 0x3015,
    0x310, 0x3014, 0x6557, 0x3015, 0x108, 0x5f97, 0x108, 0x53ef,
    0x102, 0x30, 0x102, 0x31, 0x102, 0x32, 0x102, 0x33,
    0x102, 0x34, 0x102, 0x35, 0x102, 0x36, 0x102, 0x37,
    0x102, 0x38, 0x102, 0x39, 0x101, 0x4e3d, 0x101, 0x4e38,
    0x101, 0x4e41, 0x101, 0x20122, 0x101, 0x4f60, 0x101, 0x4fae,
    0x101, 0x4fbb, 0x101, 0x5002, 0x101, 0x507a, 0x101, 0x5099,
    0x101, 0x50e7, 0x101, 0x50cf, 0x101, 0x349e, 0x101, 0x2063a,
    0x101, 0x514d, 0x101, 0x5154, 0x101, 0x5164, 0x101, 0x5177,
    0x101, 0x2051c, 0x101, 0x34b9, 0x101, 0x5167, 0x101, 0x518d,
    0x101, 0x2054b, 0x101, 0x5197, 0x101, 0x51a4, 0x101, 0x4ecc,
    0x101, 0x51ac, 0x101, 0x51b5, 0x101, 0x291df, 0x101, 0x51f5,
    0x101, 0x5203, 0x101, 0x34df, 0x101, 0x523b, 0x101, 0x5246,
    0x101, 0x5272, 0x101, 0x5277, 0x101, 0x3515, 0x101, 0x52c7,
    0x101, 0x52c9, 0x1