/***********************************************************************
*
* Copyright (c) 2012-2026 Barbara Geller
* Copyright (c) 2012-2026 Ansel Sermersheim
*
* Copyright (c) 2015 The Qt Company Ltd.
* Copyright (c) 2012-2016 Digia Plc and/or its subsidiary(-ies).
* Copyright (c) 2008-2012 Nokia Corporation and/or its subsidiary(-ies).
*
* This file is part of CopperSpice.
*
* CopperSpice is free software. You can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* version 2.1 as published by the Free Software Foundation.
*
* CopperSpice is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://www.gnu.org/licenses/
*
***********************************************************************/

/* File autogenerated from the Unicode 15.1 database. Do not edit */

#ifndef QUNICODETABLES_P_H
#define QUNICODETABLES_P_H

#include <qchar.h>

#define UNICODE_DATA_VERSION QChar::Unicode_15_1

namespace QUnicodeTables {

extern bool cs_isTurkishLocale;

struct NormalizationCorrection {
    char32_t ucs4;
    char32_t old_mapping;
    int      version;
};

extern const NormalizationCorrection uc_normalization_corrections[];

static constexpr const int NumNormalizationCorrections        = 6;
static constexpr const int NormalizationCorrectionsVersionMax = 7;

struct Properties {
    ushort category            : 8;       /* 5 used */
    ushort direction           : 8;       /* 5 used */
    ushort combiningClass      : 8;
    ushort joining             : 3;
    signed short digitValue    : 5;
    signed short mirrorDiff    : 16;
    ushort unicodeVersion      : 8;       /* 5 used */
    ushort nfQuickCheck        : 8;
    ushort graphemeBreakClass  : 5;       /* 5 used */
    ushort wordBreakClass      : 5;       /* 5 used */
    ushort sentenceBreakClass  : 8;       /* 4 used */
    ushort lineBreakClass      : 6;       /* 6 used */
    ushort script              : 8;
};

Q_CORE_EXPORT const Properties * properties(uint ucs4);
Q_CORE_EXPORT const Properties * properties(ushort ucs2);

extern const unsigned short uc_decomposition_trie[];
extern const char32_t       uc_decomposition_map[];
extern const unsigned short uc_ligature_trie[];
extern const char32_t       uc_ligature_map[];

char32_t uc_caseFold(char32_t value);
char32_t uc_lowerCase(char32_t value);
char32_t uc_titleCase(char32_t value);
char32_t uc_upperCase(char32_t value);

const char32_t *uc_caseFoldSpecial(char32_t value);
const char32_t *uc_lowerCaseSpecial(char32_t value);
const char32_t *uc_titleCaseSpecial(char32_t value);
const char32_t *uc_upperCaseSpecial(char32_t value);

struct CaseFoldTraits
   {
      static inline char32_t caseValue(char32_t ch)
      {
         if (ch >= QChar::SpecialCharacter::LastValidCodePoint) {
            return ch;

         } else {
            return QUnicodeTables::uc_caseFold(ch);
         }
      }

      static inline const char32_t *caseSpecial(char32_t ch)
      {
         return QUnicodeTables::uc_caseFoldSpecial(ch);
      }
   };

   struct LowerCaseTraits
   {
      static inline char32_t caseValue(char32_t ch)
      {
         if (ch >= QChar::SpecialCharacter::LastValidCodePoint) {
            return ch;

         } else {
            return QUnicodeTables::uc_lowerCase(ch);
         }
      }

      static inline const char32_t *caseSpecial(char32_t ch)
      {
         return QUnicodeTables::uc_lowerCaseSpecial(ch);
      }
   };

   struct TitleCaseTraits
   {
      static inline char32_t caseValue(char32_t ch)
      {
         if (ch >= QChar::SpecialCharacter::LastValidCodePoint) {
            return ch;

         } else {
            return QUnicodeTables::uc_titleCase(ch);
         }
      }

      static inline const char32_t *caseSpecial(char32_t ch)
      {
         return QUnicodeTables::uc_titleCaseSpecial(ch);
      }
   };

   struct UpperCaseTraits
   {
      static inline char32_t caseValue(char32_t ch)
      {
         if (ch >= QChar::SpecialCharacter::LastValidCodePoint) {
            return ch;

         } else {
            return QUnicodeTables::uc_upperCase(ch);
         }
      }

      static inline const char32_t *caseSpecial(char32_t ch)
      {
         return QUnicodeTables::uc_upperCaseSpecial(ch);
      }
   };

   #define GET_DECOMPOSITION_INDEX(ucs4) \
       (ucs4 < 0x3400 \
        ? (QUnicodeTables::uc_decomposition_trie[QUnicodeTables::uc_decomposition_trie[ucs4 >> 4] + (ucs4 & 0xf)]) \
        : (ucs4 < 0x30000 \
        ? QUnicodeTables::uc_decomposition_trie[QUnicodeTables::uc_decomposition_trie[((ucs4 - 0x3400) >> 8) + 0x340] + \
        (ucs4 & 0xff)] : 0xffff))

   #define GET_LIGATURE_INDEX(ucs4) \
       (ucs4 < 0x3100 \
        ? (QUnicodeTables::uc_ligature_trie[QUnicodeTables::uc_ligature_trie[ucs4 >> 5] + (ucs4 & 0x1f)]) \
        : (ucs4 < 0x12000 \
        ? QUnicodeTables::uc_ligature_trie[QUnicodeTables::uc_ligature_trie[((ucs4 - 0x3100) >> 8) + 0x188] + \
        (ucs4 & 0xff)] : 0xffff))

enum GraphemeBreakClass {
    GraphemeBreak_Any,
    GraphemeBreak_CR,
    GraphemeBreak_LF,
    GraphemeBreak_Control,
    GraphemeBreak_Extend,
    GraphemeBreak_ZWJ,
    GraphemeBreak_RegionalIndicator,
    GraphemeBreak_Prepend,
    GraphemeBreak_SpacingMark,
    GraphemeBreak_L,
    GraphemeBreak_V,
    GraphemeBreak_T,
    GraphemeBreak_LV,
    GraphemeBreak_LVT,
    Graphemebreak_E_Base,
    Graphemebreak_E_Modifier,
    Graphemebreak_Glue_After_Zwj,
    Graphemebreak_E_Base_GAZ,
    NumGraphemeBreakClasses,
};

enum WordBreakClass {
    WordBreak_Any,
    WordBreak_CR,
    WordBreak_LF,
    WordBreak_Newline,
    WordBreak_Extend,
    WordBreak_ZWJ,
    WordBreak_Format,
    WordBreak_RegionalIndicator,
    WordBreak_Katakana,
    WordBreak_HebrewLetter,
    WordBreak_ALetter,
    WordBreak_SingleQuote,
    WordBreak_DoubleQuote,
    WordBreak_MidNumLet,
    WordBreak_MidLetter,
    WordBreak_MidNum,
    WordBreak_Numeric,
    WordBreak_ExtendNumLet,
    WordBreak_E_Base,
    WordBreak_E_Modifier,
    WordBreak_Glue_After_Zwj,
    WordBreak_E_Base_GAZ,
    WordBreak_WSegSpace,
    NumWordBreakClasses,
};

enum SentenceBreakClass {
    SentenceBreak_Any,
    SentenceBreak_CR,
    SentenceBreak_LF,
    SentenceBreak_Extend,
    SentenceBreak_Sep,
    SentenceBreak_Format,
    SentenceBreak_Sp,
    SentenceBreak_Lower,
    SentenceBreak_Upper,
    SentenceBreak_OLetter,
    SentenceBreak_Numeric,
    SentenceBreak_ATerm,
    SentenceBreak_SContinue,
    SentenceBreak_STerm,
    SentenceBreak_Close,
    NumSentenceBreakClasses
};

// see http://www.unicode.org/reports/tr14/tr14-30.html
// XX, AI, and AK classes are  mapped to AL
enum LineBreakClass {
    LineBreak_OP, LineBreak_CL, LineBreak_CP, LineBreak_QU, LineBreak_GL,
    LineBreak_NS, LineBreak_EX, LineBreak_SY, LineBreak_IS, LineBreak_PR,
    LineBreak_PO, LineBreak_NU, LineBreak_AL, LineBreak_HL, LineBreak_ID,
    LineBreak_IN, LineBreak_HY, LineBreak_BA, LineBreak_BB, LineBreak_B2,
    LineBreak_ZW, LineBreak_CM, LineBreak_WJ, LineBreak_H2, LineBreak_H3,
    LineBreak_JL, LineBreak_JV, LineBreak_JT, LineBreak_RI, LineBreak_CB,
    LineBreak_EB, LineBreak_EM, LineBreak_ZWJ,
    LineBreak_SA, LineBreak_SG, LineBreak_SP,
    LineBreak_CR, LineBreak_LF, LineBreak_BK,
    NumLineBreakClasses
};

Q_CORE_EXPORT QUnicodeTables::GraphemeBreakClass graphemeBreakClass(uint ucs4);
Q_CORE_EXPORT QUnicodeTables::WordBreakClass wordBreakClass(uint ucs4);
Q_CORE_EXPORT QUnicodeTables::SentenceBreakClass sentenceBreakClass(uint ucs4);
Q_CORE_EXPORT QUnicodeTables::LineBreakClass lineBreakClass(uint ucs4);

inline GraphemeBreakClass graphemeBreakClass(QChar ch)
{
   return graphemeBreakClass(ch.unicode());
}

inline WordBreakClass wordBreakClass(QChar ch)
{
   return wordBreakClass(ch.unicode());
}

inline SentenceBreakClass sentenceBreakClass(QChar ch)
{
   return sentenceBreakClass(ch.unicode());
}

inline LineBreakClass lineBreakClass(QChar ch)
{
   return lineBreakClass(ch.unicode());
}

}  // namespace 

// constants for Hangul (de)composition, see UAX #15
enum Hangul_Constants {
   Hangul_SBase  = 0xac00,
   Hangul_LBase  = 0x1100,
   Hangul_VBase  = 0x1161,
   Hangul_TBase  = 0x11a7,
   Hangul_LCount = 19,
   Hangul_VCount = 21,
   Hangul_TCount = 28,
   Hangul_NCount = Hangul_VCount * Hangul_TCount,
   Hangul_SCount = Hangul_LCount * Hangul_NCount
};

#endif
