/***********************************************************************
*
* Copyright (c) 2012-2026 Barbara Geller
* Copyright (c) 2012-2026 Ansel Sermersheim
*
* Copyright (c) 2015 The Qt Company Ltd.
* Copyright (c) 2012-2016 Digia Plc and/or its subsidiary(-ies).
* Copyright (c) 2008-2012 Nokia Corporation and/or its subsidiary(-ies).
*
* This file is part of CopperSpice.
*
* CopperSpice is free software. You can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* version 2.1 as published by the Free Software Foundation.
*
* CopperSpice is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://www.gnu.org/licenses/
*
***********************************************************************/

#include <qbytearray.h>

#import <Foundation/Foundation.h>

QByteArray QByteArray::fromCFData(CFDataRef data)
{
   if (! data) {
      return QByteArray();
   }

   return QByteArray(reinterpret_cast<const char *>(CFDataGetBytePtr(data)), CFDataGetLength(data));
}

QByteArray QByteArray::fromRawCFData(CFDataRef data)
{
   if (! data) {
      return QByteArray();
   }

   return QByteArray::fromRawData(reinterpret_cast<const char *>(CFDataGetBytePtr(data)), CFDataGetLength(data));
}

CFDataRef QByteArray::toCFData() const
{
   return CFDataCreate(kCFAllocatorDefault, reinterpret_cast<const UInt8 *>(data()), length());
}

CFDataRef QByteArray::toRawCFData() const
{
   return CFDataCreateWithBytesNoCopy(kCFAllocatorDefault, reinterpret_cast<const UInt8 *>(data()),
               length(), kCFAllocatorNull);
}

QByteArray QByteArray::fromNSData(const NSData *data)
{
   if (! data) {
      return QByteArray();
   }

   return QByteArray(reinterpret_cast<const char *>([data bytes]), [data length]);
}

QByteArray QByteArray::fromRawNSData(const NSData *data)
{
   if (! data) {
      return QByteArray();
   }

   return QByteArray::fromRawData(reinterpret_cast<const char *>([data bytes]), [data length]);
}

NSData *QByteArray::toNSData() const
{
   return [NSData dataWithBytes:constData() length:size()];
}

NSData *QByteArray::toRawNSData() const
{
   // const_cast is fine here because NSData is immutable thus will never modify bytes we're giving it
   return [NSData dataWithBytesNoCopy:const_cast<char *>(constData()) length:size() freeWhenDone:NO];
}
