list(APPEND GUI_PUBLIC_INCLUDES
   QBackingStore
   QBrush
   QBrushData
   QColor
   QColormap
   QConicalGradient
   QGradient
   QLinearGradient
   QMatrix
   QPaintDevice
   QPaintEngine
   QPaintEngineState
   QPainter
   QPainterPath
   QPainterPathStroker
   QPen
   QPolygon
   QPolygonF
   QRadialGradient
   QRegion
   QRgb
   QRgba64
   QStylePainter
   QTextItem
   QTileRules
   QTransform
)

list(APPEND GUI_INCLUDES
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qbackingstore.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qbrush.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qbrushdata.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qcolor.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qcolormap.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qconicalgradient.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qdrawutil.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qgradient.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qlineargradient.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qmatrix.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintdevice.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintengine.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintenginestate.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpainter.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpainterpath.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpainterpathstroker.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpen.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpolygon.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpolygonf.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qradialgradient.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qregion.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qrgb.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qstylepainter.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qtextitem.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qtilerules.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qtransform.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qrgba64.h
)

list(APPEND GUI_PRIVATE_INCLUDES
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qbezier_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qblendfunctions_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qblittable_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qcolor_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qcosmeticstroker_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qcssutil_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qdrawhelper_neon_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qdrawhelper_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qdrawhelper_x86_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qdrawingprimitive_sse2_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qemulationpaintengine_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qfixed_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qgrayraster_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qimagescale_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qmath_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qmemrotate_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qoutlinemapper_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintengine_alpha_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintengine_blitter_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintengine_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintengine_preview_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintengine_raster_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintengineex_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpainter_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpainterpath_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpathclipper_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpen_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpolygonclipper_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qrasterdefs_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qrasterizer_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qstroker_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qtextureglyphcache_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qvectorpath_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qrgba64_p.h
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qwidgetbackingstore_p.h
)

target_sources(CsGui
   PRIVATE
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qbezier.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qblendfunctions.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qbrush.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qcolor.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qcolor_p.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qcolormap.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qcompositionfunctions.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qcosmeticstroker.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qcssutil.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qdrawutil.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qdrawhelper.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qdrawhelper_sse2.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qdrawhelper_sse4.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qdrawhelper_ssse3.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qemulationpaintengine.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qgammatables.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qmatrix.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qmemrotate.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qoutlinemapper.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintdevice.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintengine.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintengine_alpha.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintengine_preview.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintengineex.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpainter.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpainterpath.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpathclipper.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpen.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpolygon.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qrasterizer.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qregion.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qstroker.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qstylepainter.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qtextureglyphcache.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qtransform.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintengine_raster.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qimagescale.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qgrayraster.c
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qpaintengine_blitter.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qblittable.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qbackingstore.cpp
   ${CMAKE_CURRENT_SOURCE_DIR}/painting/qwidgetbackingstore.cpp
)

if(CMAKE_SYSTEM_PROCESSOR MATCHES "arm")
   target_sources(CsGui
      PRIVATE
      ${CMAKE_CURRENT_SOURCE_DIR}/painting/qdrawhelper_neon.cpp
      ${CMAKE_CURRENT_SOURCE_DIR}/painting/qdrawhelper_neon_asm.S
   )
endif()

if(CMAKE_SYSTEM_NAME MATCHES "Windows")
   list(APPEND EXTRA_GUI_LIBS
      PRIVATE
      msimg32
   )
endif()
