/***********************************************************************
*
* Copyright (c) 2012-2026 Barbara Geller
* Copyright (c) 2012-2026 Ansel Sermersheim
*
* Copyright (c) 2015 The Qt Company Ltd.
* Copyright (c) 2012-2016 Digia Plc and/or its subsidiary(-ies).
* Copyright (c) 2008-2012 Nokia Corporation and/or its subsidiary(-ies).
*
* This file is part of CopperSpice.
*
* CopperSpice is free software. You can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* version 2.1 as published by the Free Software Foundation.
*
* CopperSpice is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://www.gnu.org/licenses/
*
***********************************************************************/

#ifndef QCommonStylePixmaps_P_H
#define QCommonStylePixmaps_P_H

#ifndef QT_NO_IMAGEFORMAT_XPM

static const char *const check_list_controller_xpm[] = {
   "16 16 4 1",
   "        c None",
   ".        c #000000000000",
   "X        c #FFFFFFFF0000",
   "o        c #C71BC30BC71B",
   "                ",
   "                ",
   " ..........     ",
   " .XXXXXXXX.     ",
   " .XXXXXXXX.oo   ",
   " .XXXXXXXX.oo   ",
   " .XXXXXXXX.oo   ",
   " .XXXXXXXX.oo   ",
   " .XXXXXXXX.oo   ",
   " .XXXXXXXX.oo   ",
   " .XXXXXXXX.oo   ",
   " ..........oo   ",
   "   oooooooooo   ",
   "   oooooooooo   ",
   "                ",
   "                "
};

static const char *const tb_extension_arrow_v_xpm[] = {
   "5 8 3 1",
   "            c None",
   ".            c #000000",
   "+            c none",
   ".+++.",
   "..+..",
   "+...+",
   "++.++",
   ".+++.",
   "..+..",
   "+...+",
   "++.++"
};

static const char *const tb_extension_arrow_h_xpm[] = {
   "8 5 3 1",
   "            c None",
   ".            c #000000",
   "+            c none",
   "..++..++",
   "+..++..+",
   "++..++..",
   "+..++..+",
   "..++..++",
};

static const char *const filedialog_start_xpm[] = {
   "16 15 8 1",
   "a c #cec6bd",
   "# c #000000",
   "e c #ffff00",
   "b c #999999",
   "f c #cccccc",
   "d c #dcdcdc",
   "c c #ffffff",
   ". c None",
   ".....######aaaaa",
   "...bb#cccc##aaaa",
   "..bcc#cccc#d#aaa",
   ".bcef#cccc#dd#aa",
   ".bcfe#cccc#####a",
   ".bcef#ccccccccc#",
   "bbbbbbbbbbbbccc#",
   "bccccccccccbbcc#",
   "bcefefefefee#bc#",
   ".bcefefefefef#c#",
   ".bcfefefefefe#c#",
   "..bcfefefefeeb##",
   "..bbbbbbbbbbbbb#",
   "...#############",
   "................"
};

static const char *const filedialog_end_xpm[] = {
   "16 15 9 1",
   "d c #a0a0a0",
   "c c #c3c3c3",
   "# c #cec6bd",
   ". c #000000",
   "f c #ffff00",
   "e c #999999",
   "g c #cccccc",
   "b c #ffffff",
   "a c None",
   "......####aaaaaa",
   ".bbbb..###aaaaaa",
   ".bbbb.c.##aaaaaa",
   ".bbbb....ddeeeea",
   ".bbbbbbb.bbbbbe.",
   ".bbbbbbb.bcfgfe.",
   "eeeeeeeeeeeeefe.",
   "ebbbbbbbbbbeege.",
   "ebfgfgfgfgff.ee.",
   "aebfgfgfgfgfg.e.",
   "aebgfgfgfgfgf.e.",
   "aaebgfgfgfgffe..",
   "aaeeeeeeeeeeeee.",
   "aaa.............",
   "aaaaaaaaaaaaaaaa"
};

/* XPM */
static const char *const cs_menu_xpm[] = {
   "16 16 145 2 ",
   "   c #754B00",
   ".  c #744D00",
   "X  c #774C00",
   "o  c #715301",
   "O  c #7C5000",
   "+  c #7F5200",
   "@  c #7C5700",
   "#  c #745E01",
   "$  c #7F5901",
   "%  c #7E6B02",
   "&  c #805300",
   "*  c #855B00",
   "=  c #885900",
   "-  c #895900",
   ";  c #895E00",
   ":  c #8E5D00",
   ">  c #826401",
   ",  c #826602",
   "<  c #876901",
   "1  c #836D02",
   "2  c #876C02",
   "3  c #896801",
   "4  c #8E6F01",
   "5  c #906801",
   "6  c #966800",
   "7  c #877402",
   "8  c #877802",
   "9  c #897A02",
   "0  c #8A7A02",
   "q  c #8F7B02",
   "w  c #8E7F02",
   "e  c #9D7401",
   "r  c #9B7D02",
   "t  c #AF7300",
   "y  c #B17400",
   "u  c #B57600",
   "i  c #B87900",
   "p  c #BA7A00",
   "a  c #AE8502",
   "s  c #B28402",
   "d  c #B48602",
   "f  c #BB8100",
   "g  c #B98D02",
   "h  c #C68200",
   "j  c #C88400",
   "k  c #C98400",
   "l  c #CA8500",
   "z  c #CB8500",
   "x  c #C88600",
   "c  c #CB8800",
   "v  c #CF8800",
   "b  c #CF8B00",
   "n  c #CC8E01",
   "m  c #D18900",
   "M  c #D18A00",
   "N  c #D28A00",
   "B  c #D48B00",
   "V  c #D58C00",
   "C  c #D68D00",
   "Z  c #D78D00",
   "A  c #D78E00",
   "S  c #D78F00",
   "D  c #D88E00",
   "F  c #D88F00",
   "G  c #C69702",
   "H  c #CD9201",
   "J  c #C49902",
   "K  c #D79000",
   "L  c #D99200",
   "P  c #DA9400",
   "I  c #DA9500",
   "U  c #DA9401",
   "Y  c #D99601",
   "T  c #D99701",
   "R  c #DA9601",
   "E  c #DB9601",
   "W  c #DB9701",
   "Q  c #D49E02",
   "!  c #DA9901",
   "~  c #DC9A01",
   "^  c #DD9D01",
   "/  c #DC9E01",
   "(  c #DD9E01",
   ")  c #DE9F01",
   "_  c #C2A203",
   "`  c #D6A102",
   "'  c #D8A002",
   "]  c #DEA001",
   "[  c #DFA202",
   "{  c #DFA302",
   "}  c #DEA402",
   "|  c #DFA502",
   " . c #DDB103",
   ".. c #DFB403",
   "X. c #DAB604",
   "o. c #DFB704",
   "O. c #DBBD05",
   "+. c #DDBF05",
   "@. c #E0A602",
   "#. c #E0A702",
   "$. c #E1A902",
   "%. c #E1AA02",
   "&. c #E1AB02",
   "*. c #E2AB02",
   "=. c #E2AC03",
   "-. c #E1AF03",
   ";. c #E1B003",
   ":. c #E3B003",
   ">. c #E3B203",
   ",. c #E4B203",
   "<. c #E4B303",
   "1. c #E5B303",
   "2. c #E1B503",
   "3. c #E1BA04",
   "4. c #E5B804",
   "5. c #E4B904",
   "6. c #E6B804",
   "7. c #E7B804",
   "8. c #E7BA04",
   "9. c #E6BD04",
   "0. c #E8BC04",
   "q. c #E8BD04",
   "w. c #DFC505",
   "e. c #DFC705",
   "r. c #E5C004",
   "t. c #E5C105",
   "y. c #E7C105",
   "u. c #E1C605",
   "i. c #E8C004",
   "p. c #E9C004",
   "a. c #EBC405",
   "s. c #EAC505",
   "d. c #EBC505",
   "f. c #EBC605",
   "g. c #ECC605",
   "h. c #ECC705",
   "j. c #E9C905",
   "k. c #E9CD06",
   "l. c #E8CF06",
   "z. c #EDCD05",
   "x. c #EECD05",
   "c. c #EECD06",
   "v. c #EECF06",
   "b. c #EFCF06",
   "n. c None",
   /* pixels */
   "n.n.n.n.n.j.y.8.>.&.} n.n.n.n.n.",
   "n.n.n.z.l.e.f.y.6.>.&.^ Y n.n.n.",
   "n.n.z.k.w.w.j.f.0.1.&.^ ! C n.n.",
   "n.f.+.8 a 8 q 9.0.1.&.^ W F C n.",
   "n.y.% 9 l.u.7 _ q.:.&.^ W F Z n.",
   "4.o.% X.v.z.y.9.7.:.@.^ Y F F F ",
   ">. .% X.h.f.3.2.:.G 5 6 m F C V ",
   "=.=.% e 4.o.2 J a o @ ; = m F F ",
   "@.&.g > 4 3 3 Q e @ n x y m F C ",
   "^ @.@.Q s d ' @.H * . & p C F C ",
   "Y ! ^ ) } ^ ^ ! f x x y   z C C ",
   "n.L L W W Y L F : : h p X x F n.",
   "n.F F F F F F F k - O + u V V n.",
   "n.n.C V C F F V F V z m F Z n.n.",
   "n.n.n.C F Z F F Z Z F F C n.n.n.",
   "n.n.n.n.n.V V Z Z Z C n.n.n.n.n."
};

static const char *const qt_close_xpm[] = {
   "10 10 2 1",
   "# c #000000",
   ". c None",
   "..........",
   ".##....##.",
   "..##..##..",
   "...####...",
   "....##....",
   "...####...",
   "..##..##..",
   ".##....##.",
   "..........",
   ".........."
};

static const char *const qt_maximize_xpm[] = {
   "10 10 2 1",
   "# c #000000",
   ". c None",
   "#########.",
   "#########.",
   "#.......#.",
   "#.......#.",
   "#.......#.",
   "#.......#.",
   "#.......#.",
   "#.......#.",
   "#########.",
   ".........."
};

static const char *const qt_minimize_xpm[] = {
   "10 10 2 1",
   "# c #000000",
   ". c None",
   "..........",
   "..........",
   "..........",
   "..........",
   "..........",
   "..........",
   "..........",
   ".#######..",
   ".#######..",
   ".........."
};

static const char *const qt_normalizeup_xpm[] = {
   "10 10 2 1",
   "# c #000000",
   ". c None",
   "...######.",
   "...######.",
   "...#....#.",
   ".######.#.",
   ".######.#.",
   ".#....###.",
   ".#....#...",
   ".#....#...",
   ".######...",
   ".........."
};

static const char *const qt_help_xpm[] = {
   "10 10 2 1",
   ". c None",
   "# c #000000",
   "..........",
   "..######..",
   ".##....##.",
   "......##..",
   ".....##...",
   "....##....",
   "....##....",
   "..........",
   "....##....",
   ".........."
};

static const char *const qt_shade_xpm[] = {
   "10 10 2 1",
   "# c #000000",
   ". c None",
   "..........",
   "..........",
   "..........",
   "..........",
   "....#.....",
   "...###....",
   "..#####...",
   ".#######..",
   "..........",
   ".........."
};

static const char *const qt_unshade_xpm[] = {
   "10 10 2 1",
   "# c #000000",
   ". c None",
   "..........",
   "..........",
   "..........",
   ".#######..",
   "..#####...",
   "...###....",
   "....#.....",
   "..........",
   "..........",
   ".........."
};

static const char *const dock_widget_close_xpm[] = {
   "8 8 2 1",
   "# c #000000",
   ". c None",
   "........",
   ".##..##.",
   "..####..",
   "...##...",
   "..####..",
   ".##..##.",
   "........",
   "........"
};

/* XPM */
static const char *const information_xpm[] = {
   "32 32 5 1",
   ". c None",
   "c c #000000",
   "* c #999999",
   "a c #ffffff",
   "b c #0000ff",
   "...........********.............",
   "........***aaaaaaaa***..........",
   "......**aaaaaaaaaaaaaa**........",
   ".....*aaaaaaaaaaaaaaaaaa*.......",
   "....*aaaaaaaabbbbaaaaaaaac......",
   "...*aaaaaaaabbbbbbaaaaaaaac.....",
   "..*aaaaaaaaabbbbbbaaaaaaaaac....",
   ".*aaaaaaaaaaabbbbaaaaaaaaaaac...",
   ".*aaaaaaaaaaaaaaaaaaaaaaaaaac*..",
   "*aaaaaaaaaaaaaaaaaaaaaaaaaaaac*.",
   "*aaaaaaaaaabbbbbbbaaaaaaaaaaac*.",
   "*aaaaaaaaaaaabbbbbaaaaaaaaaaac**",
   "*aaaaaaaaaaaabbbbbaaaaaaaaaaac**",
   "*aaaaaaaaaaaabbbbbaaaaaaaaaaac**",
   "*aaaaaaaaaaaabbbbbaaaaaaaaaaac**",
   "*aaaaaaaaaaaabbbbbaaaaaaaaaaac**",
   ".*aaaaaaaaaaabbbbbaaaaaaaaaac***",
   ".*aaaaaaaaaaabbbbbaaaaaaaaaac***",
   "..*aaaaaaaaaabbbbbaaaaaaaaac***.",
   "...caaaaaaabbbbbbbbbaaaaaac****.",
   "....caaaaaaaaaaaaaaaaaaaac****..",
   ".....caaaaaaaaaaaaaaaaaac****...",
   "......ccaaaaaaaaaaaaaacc****....",
   ".......*cccaaaaaaaaccc*****.....",
   "........***cccaaaac*******......",
   "..........****caaac*****........",
   ".............*caaac**...........",
   "...............caac**...........",
   "................cac**...........",
   ".................cc**...........",
   "..................***...........",
   "...................**..........."
};

/* XPM */
static const char *const warning_xpm[] = {
   "32 32 4 1",
   ". c None",
   "a c #ffff00",
   "* c #000000",
   "b c #999999",
   ".............***................",
   "............*aaa*...............",
   "...........*aaaaa*b.............",
   "...........*aaaaa*bb............",
   "..........*aaaaaaa*bb...........",
   "..........*aaaaaaa*bb...........",
   ".........*aaaaaaaaa*bb..........",
   ".........*aaaaaaaaa*bb..........",
   "........*aaaaaaaaaaa*bb.........",
   "........*aaaa***aaaa*bb.........",
   ".......*aaaa*****aaaa*bb........",
   ".......*aaaa*****aaaa*bb........",
   "......*aaaaa*****aaaaa*bb.......",
   "......*aaaaa*****aaaaa*bb.......",
   ".....*aaaaaa*****aaaaaa*bb......",
   ".....*aaaaaa*****aaaaaa*bb......",
   "....*aaaaaaaa***aaaaaaaa*bb.....",
   "....*aaaaaaaa***aaaaaaaa*bb.....",
   "...*aaaaaaaaa***aaaaaaaaa*bb....",
   "...*aaaaaaaaaa*aaaaaaaaaa*bb....",
   "..*aaaaaaaaaaa*aaaaaaaaaaa*bb...",
   "..*aaaaaaaaaaaaaaaaaaaaaaa*bb...",
   ".*aaaaaaaaaaaa**aaaaaaaaaaa*bb..",
   ".*aaaaaaaaaaa****aaaaaaaaaa*bb..",
   "*aaaaaaaaaaaa****aaaaaaaaaaa*bb.",
   "*aaaaaaaaaaaaa**aaaaaaaaaaaa*bb.",
   "*aaaaaaaaaaaaaaaaaaaaaaaaaaa*bbb",
   "*aaaaaaaaaaaaaaaaaaaaaaaaaaa*bbb",
   ".*aaaaaaaaaaaaaaaaaaaaaaaaa*bbbb",
   "..*************************bbbbb",
   "....bbbbbbbbbbbbbbbbbbbbbbbbbbb.",
   ".....bbbbbbbbbbbbbbbbbbbbbbbbb.."
};

/* XPM */
static const char *const critical_xpm[] = {
   "32 32 4 1",
   ". c None",
   "a c #999999",
   "* c #ff0000",
   "b c #ffffff",
   "...........********.............",
   ".........************...........",
   ".......****************.........",
   "......******************........",
   ".....********************a......",
   "....**********************a.....",
   "...************************a....",
   "..*******b**********b*******a...",
   "..******bbb********bbb******a...",
   ".******bbbbb******bbbbb******a..",
   ".*******bbbbb****bbbbb*******a..",
   "*********bbbbb**bbbbb*********a.",
   "**********bbbbbbbbbb**********a.",
   "***********bbbbbbbb***********aa",
   "************bbbbbb************aa",
   "************bbbbbb************aa",
   "***********bbbbbbbb***********aa",
   "**********bbbbbbbbbb**********aa",
   "*********bbbbb**bbbbb*********aa",
   ".*******bbbbb****bbbbb*******aa.",
   ".******bbbbb******bbbbb******aa.",
   "..******bbb********bbb******aaa.",
   "..*******b**********b*******aa..",
   "...************************aaa..",
   "....**********************aaa...",
   "....a********************aaa....",
   ".....a******************aaa.....",
   "......a****************aaa......",
   ".......aa************aaaa.......",
   ".........aa********aaaaa........",
   "...........aaaaaaaaaaa..........",
   ".............aaaaaaa............"
};

/* XPM */
static const char *const question_xpm[] = {
   "32 32 5 1",
   ". c None",
   "c c #000000",
   "* c #999999",
   "a c #ffffff",
   "b c #0000ff",
   "...........********.............",
   "........***aaaaaaaa***..........",
   "......**aaaaaaaaaaaaaa**........",
   ".....*aaaaaaaaaaaaaaaaaa*.......",
   "....*aaaaaaaaaaaaaaaaaaaac......",
   "...*aaaaaaaabbbbbbaaaaaaaac.....",
   "..*aaaaaaaabaaabbbbaaaaaaaac....",
   ".*aaaaaaaabbaaaabbbbaaaaaaaac...",
   ".*aaaaaaaabbbbaabbbbaaaaaaaac*..",
   "*aaaaaaaaabbbbaabbbbaaaaaaaaac*.",
   "*aaaaaaaaaabbaabbbbaaaaaaaaaac*.",
   "*aaaaaaaaaaaaabbbbaaaaaaaaaaac**",
   "*aaaaaaaaaaaaabbbaaaaaaaaaaaac**",
   "*aaaaaaaaaaaaabbaaaaaaaaaaaaac**",
   "*aaaaaaaaaaaaabbaaaaaaaaaaaaac**",
   "*aaaaaaaaaaaaaaaaaaaaaaaaaaaac**",
   ".*aaaaaaaaaaaabbaaaaaaaaaaaac***",
   ".*aaaaaaaaaaabbbbaaaaaaaaaaac***",
   "..*aaaaaaaaaabbbbaaaaaaaaaac***.",
   "...caaaaaaaaaabbaaaaaaaaaac****.",
   "....caaaaaaaaaaaaaaaaaaaac****..",
   ".....caaaaaaaaaaaaaaaaaac****...",
   "......ccaaaaaaaaaaaaaacc****....",
   ".......*cccaaaaaaaaccc*****.....",
   "........***cccaaaac*******......",
   "..........****caaac*****........",
   ".............*caaac**...........",
   "...............caac**...........",
   "................cac**...........",
   ".................cc**...........",
   "..................***...........",
   "...................**..........."
};

#endif //QT_NO_IMAGEFORMAT_XPM

#endif