/***********************************************************************
*
* Copyright (c) 2012-2026 Barbara Geller
* Copyright (c) 2012-2026 Ansel Sermersheim
*
* Copyright (c) 2015 The Qt Company Ltd.
* Copyright (c) 2012-2016 Digia Plc and/or its subsidiary(-ies).
* Copyright (c) 2008-2012 Nokia Corporation and/or its subsidiary(-ies).
*
* This file is part of CopperSpice.
*
* CopperSpice is free software. You can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* version 2.1 as published by the Free Software Foundation.
*
* CopperSpice is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://www.gnu.org/licenses/
*
***********************************************************************/

#include <avfcamerametadatacontrol.h>

#include <avfcameraservice.h>
#include <avfcamerasession.h>

// metadata support is not implemented yet

AVFCameraMetaDataControl::AVFCameraMetaDataControl(AVFCameraService *service, QObject *parent)
    :QMetaDataWriterControl(parent)
{
    (void) service;
}

AVFCameraMetaDataControl::~AVFCameraMetaDataControl()
{
}

bool AVFCameraMetaDataControl::isMetaDataAvailable() const
{
    return !m_tags.isEmpty();
}

bool AVFCameraMetaDataControl::isWritable() const
{
    return false;
}

QVariant AVFCameraMetaDataControl::metaData(const QString &key) const
{
    return m_tags.value(key);
}

void AVFCameraMetaDataControl::setMetaData(const QString &key, const QVariant &value)
{
    m_tags.insert(key, value);
}

QStringList AVFCameraMetaDataControl::availableMetaData() const
{
    return m_tags.keys();
}

