/***********************************************************************
*
* Copyright (c) 2012-2026 Barbara Geller
* Copyright (c) 2012-2026 Ansel Sermersheim
*
* Copyright (c) 2015 The Qt Company Ltd.
* Copyright (c) 2012-2016 Digia Plc and/or its subsidiary(-ies).
* Copyright (c) 2008-2012 Nokia Corporation and/or its subsidiary(-ies).
*
* This file is part of CopperSpice.
*
* CopperSpice is free software. You can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* version 2.1 as published by the Free Software Foundation.
*
* CopperSpice is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://www.gnu.org/licenses/
*
***********************************************************************/

#ifndef CAMERABINCAPTUREDESTINATION_H
#define CAMERABINCAPTUREDESTINATION_H

#include <qcameracapturedestinationcontrol.h>
#include <qcameraimagecapture.h>

class CameraBinSession;

class Q_MULTIMEDIA_EXPORT CameraBinCaptureDestination : public QCameraCaptureDestinationControl
{
   CS_OBJECT(CameraBinCaptureDestination)

 public:
   CameraBinCaptureDestination(CameraBinSession *session);
   virtual ~CameraBinCaptureDestination();

   bool isCaptureDestinationSupported(QCameraImageCapture::CaptureDestinations destination) const override;
   QCameraImageCapture::CaptureDestinations captureDestination() const override;
   void setCaptureDestination(QCameraImageCapture::CaptureDestinations destination) override;

 private:
   CameraBinSession *m_session;
   QCameraImageCapture::CaptureDestinations m_destination;
};

#endif
