/***********************************************************************
*
* Copyright (c) 2012-2026 Barbara Geller
* Copyright (c) 2012-2026 Ansel Sermersheim
*
* Copyright (c) 2015 The Qt Company Ltd.
* Copyright (c) 2012-2016 Digia Plc and/or its subsidiary(-ies).
* Copyright (c) 2008-2012 Nokia Corporation and/or its subsidiary(-ies).
*
* This file is part of CopperSpice.
*
* CopperSpice is free software. You can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* version 2.1 as published by the Free Software Foundation.
*
* CopperSpice is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://www.gnu.org/licenses/
*
***********************************************************************/

#include <qunix_eventdispatcher_p.h>

#include <qatomicint.h>
#include <qcoreapplication.h>
#include <qelapsedtimer.h>
#include <qsemaphore.h>
#include <qwindowsysteminterface.h>

#include <qapplication_p.h>

#include <errno.h>

QUnixEventDispatcher::QUnixEventDispatcher(QObject *parent)
    : QEventDispatcherUNIX(parent)
{ }

QUnixEventDispatcher::~QUnixEventDispatcher()
{ }

bool QUnixEventDispatcher::processEvents(QEventLoop::ProcessEventsFlags flags)
{
    const bool didSendEvents = QEventDispatcherUNIX::processEvents(flags);
    return QWindowSystemInterface::sendWindowSystemEvents(flags) || didSendEvents;
}

bool QUnixEventDispatcher::hasPendingEvents()
{
    extern uint qGlobalPostedEventsCount(); // from qapplication.cpp
    return qGlobalPostedEventsCount() || QWindowSystemInterface::windowSystemEventsQueued();
}

void QUnixEventDispatcher::flush()
{
    if(qApp) {
        qApp->sendPostedEvents();
    }
}
