/***********************************************************************
*
* Copyright (c) 2012-2026 Barbara Geller
* Copyright (c) 2012-2026 Ansel Sermersheim
*
* Copyright (c) 2015 The Qt Company Ltd.
* Copyright (c) 2012-2016 Digia Plc and/or its subsidiary(-ies).
* Copyright (c) 2008-2012 Nokia Corporation and/or its subsidiary(-ies).
*
* This file is part of CopperSpice.
*
* CopperSpice is free software. You can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* version 2.1 as published by the Free Software Foundation.
*
* CopperSpice is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://www.gnu.org/licenses/
*
***********************************************************************/

#ifndef QCachingIterator_P_H
#define QCachingIterator_P_H

#include <qlist.h>
#include <qvector.h>

#include <qdynamiccontext_p.h>
#include <qitem_p.h>

namespace QPatternist {

class CachingIterator : public Item::Iterator
{
 public:
   CachingIterator(ItemSequenceCacheCell::Vector &cacheCells, const VariableSlotID slot, const DynamicContext::Ptr &context);

   Item next() override;
   Item current() const override;
   xsInteger position() const override;
   Item::Iterator::Ptr copy() const override;

 private:
   Item      m_current;
   xsInteger m_position;

   const VariableSlotID m_varSlot;
   const DynamicContext::Ptr   m_context;

   ItemSequenceCacheCell::Vector &m_cacheCells;

   bool m_usingCache;
};

}

#endif
