/***********************************************************************
*
* Copyright (c) 2012-2026 Barbara Geller
* Copyright (c) 2012-2026 Ansel Sermersheim
*
* This file is part of CopperSpice.
*
* CopperSpice is free software. You can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* version 2.1 as published by the Free Software Foundation.
*
* CopperSpice is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://www.gnu.org/licenses/
*
***********************************************************************/

#include <qqueue.h>

#include <cs_catch2.h>

TEST_CASE("QQueue traits", "[qqueue]")
{
   REQUIRE(std::is_copy_constructible_v<QQueue<int>> == true);
   REQUIRE(std::is_move_constructible_v<QQueue<int>> == true);

   REQUIRE(std::is_copy_assignable_v<QQueue<int>> == true);
   REQUIRE(std::is_move_assignable_v<QQueue<int>> == true);

   REQUIRE(std::has_virtual_destructor_v<QQueue<int>> == false);
}

TEST_CASE("QQueue copy_assign", "[qqueue]")
{
   QQueue<int> list1;
   list1.enqueue(1);
   list1.enqueue(2);

   {
      QQueue<int> list2(list1);

       REQUIRE(list2.count()   == 2);
       REQUIRE(list2.dequeue() == 1);
       REQUIRE(list2.dequeue() == 2);
   }

   {
      QQueue<int> list2;
      list2 = list1;

      REQUIRE(list2.count()   == 2);
      REQUIRE(list2.dequeue() == 1);
      REQUIRE(list2.dequeue() == 2);
   }
}

TEST_CASE("QQueue clear", "[qqueue]")
{
   QQueue<QString> list;

   list.enqueue("watermelon");
   list.enqueue("apple");
   list.enqueue("pear");
   list.enqueue("grapefruit");

   list.clear();

   REQUIRE(list.size() == 0);
   REQUIRE(list.count() == 0);
}

TEST_CASE("QQueue contains", "[qqueue]")
{
   QQueue<QString> list;

   list.enqueue("watermelon");
   list.enqueue("apple");
   list.enqueue("pear");
   list.enqueue("grapefruit");

   REQUIRE(list.contains("pear") == true);
   REQUIRE(list.contains("orange") == false);
}

TEST_CASE("QQueue empty", "[qqueue]")
{
   QQueue<QString> list;

   REQUIRE(list.isEmpty() == true);
   REQUIRE(list.count() == 0);
}

TEST_CASE("QQueue erase", "[qqueue]")
{
   QQueue<QString> list;

   list.enqueue("watermelon");
   list.enqueue("apple");
   list.enqueue("pear");
   list.enqueue("grapefruit");

   list.erase(list.begin() + 1);

   REQUIRE(list.contains("apple") == false);

   REQUIRE(list.contains("watermelon") == true);
   REQUIRE(list.contains("pear") == true);
   REQUIRE(list.contains("grapefruit") == true);

   REQUIRE(list.length() == 3);
}

TEST_CASE("QQueue insert", "[qqueue]")
{
   QQueue<QString> list;

   list.enqueue("watermelon");
   list.enqueue("apple");
   list.enqueue("pear");
   list.enqueue("grapefruit");

   list.insert(1, "mango");

   REQUIRE(list.contains("mango") == true);
   REQUIRE(list[1] == "mango");
   REQUIRE(list.length() == 5);
}

TEST_CASE("QQueue length", "[qqueue]")
{
   QQueue<QString> list;

   list.enqueue("watermelon");
   list.enqueue("apple");
   list.enqueue("pear");
   list.enqueue("grapefruit");

   REQUIRE(list.head() == "watermelon");

   REQUIRE(list.length() == 4);
   REQUIRE(list.size() == 4);
}

TEST_CASE("QQueue remove", "[qqueue]")
{
   QQueue<QString> list;

   list.enqueue("watermelon");
   list.enqueue("apple");
   list.enqueue("pear");
   list.enqueue("grapefruit");

   list.removeOne("apple");
   list.remove(0);

   REQUIRE(list.contains("apple") == false);
   REQUIRE(list.contains("watermelon") == false);

   REQUIRE(list.contains("pear") == true);
   REQUIRE(list.contains("grapefruit") == true);

   REQUIRE(list.length() == 2);
}

TEST_CASE("QQueue position", "[qqueue]")
{
   QQueue<QString> list;

   list.enqueue("watermelon");
   list.enqueue("apple");
   list.enqueue("pear");
   list.enqueue("grapefruit");

   REQUIRE(list.first() == "watermelon");
   REQUIRE(list.last()  == "grapefruit");

   REQUIRE(list.front() == "watermelon");
   REQUIRE(list.back()  == "grapefruit");
}
