## CsCrypto

### Introduction

CsCrypto is a standalone C++ library which provides a common interface to call existing cryptography libraries. It is
designed to detect common errors at compile time by using C++ type checking with the intention of preventing security
vulnerabilities.


### System Requirements

Building CsCrypto requires a C++20 compiler and a C++20 standard library. You will also need either Botan or
OpenSSL libraries.

CMake build files are provided with the source distribution to build this library. The unit test binary executable is
an optional part of the build process.

This library has been tested with clang sanitizer and an extensive industry code review.


### Documentation

Class level documentation for CsCrypto is available on the CopperSpice website.

https://www.copperspice.com/docs/cs_crypto/index.html


### Presentations

Our YouTube channel contains over 75 videos about C++, programming fundamentals, Unicode/Strings, multithreading,
graphics, CopperSpice, DoxyPress, and other software development topics.

https://www.youtube.com/copperspice

Links to additional videos can be found on our website.

https://www.copperspice.com/presentations.html


### Authors / Contributors

* **Tim van Deurzen**
* **Jan Wilmans**
* **Ansel Sermersheim**
* **Barbara Geller**


### License

This library is released under the BSD 2-clause license. For more information refer to the LICENSE file provided with
this project.


### References

 * Website:  https://www.copperspice.com
 * Twitter:  https://twitter.com/copperspice_cpp
 * Email:    info@copperspice.com

<!-- -->
 * Github:   https://github.com/copperspice

<!-- -->
 * Forum:    https://forum.copperspice.com
 * Journal:  https://journal.copperspice.com

