## Diamond

### Introduction

Diamond is a cross platform editor designed for programmers. It was developed using the CopperSpice libraries and is
written in C++.

The Diamond project began as a replacement for the Crimson and Emerald Editors, both of these were Windows only
programs and are no longer supported. Diamond has evolved to become a programmers editor with a focus on developing
C++ applications.


###### Key Features

* View multiple documents in movable tabs
* Auto Load previously open Files
* Configuration saved as a JSON format
* Define preset Folders
* Insert Date, Time, and Symbols
* Search and Replace
* Advanced Find
* Syntax Highlighting based on File Type
* Horizontal or Vertical split Window
* Spell Check
* Customize printed Header and Footer
* Show Spaces and Tabs
* User definable standard and custom Keyboard Shortcuts
* Record, Save, and Play back Macros


### Binary Files

Diamond prebuilt binaries are available for all supported platforms.

https://download.copperspice.com/diamond/binary/

CopperSpice prebuilt binaries are available for all supported platforms.

https://github.com/copperspice/copperspice/releases/
https://download.copperspice.com/copperspice/binary/


### System Requirements

Building Diamond requires a C++20 compiler and a C++20 standard library. You will also need a current copy
of the CopperSpice libraries. Diamond links with CsCore, CsGui, and CsNetwork.

CMake build files are provided with the source distribution to build this application.


##### Additional Build Requirement

The Diamond program uses the Hunspell library for spell checking. When building Diamond from source you most have
Hunspell installed on your computer.

For Windows developers the full source code for Hunspell is available on our download page.

https://download.copperspice.com/diamond/source/

For other platforms install the Hunspell package as indicated.

* Debian, Ubuntu
   * `apt-get install libhunspell-dev`


* Fedora, Centos
   * `dnf install hunspell-devel`


* Mac OSX
   * `brew install hunspell`


### Documentation

Full documentation for Diamond is available on the website or from our download page.


|URL      |Description|
|---------|-----------|
|https://www.copperspice.com/docs/diamond/index.html| Online
|https://download.copperspice.com/diamond/documentation| Download (tar and zip formats)|


### Presentations

Our YouTube channel contains over 75 videos about C++, programming fundamentals, Unicode/Strings, multithreading,
graphics, CopperSpice, DoxyPress, and other software development topics.

https://www.youtube.com/copperspice

Links to additional videos can be found on our website.

https://www.copperspice.com/presentations.html


### Authors

* **Barbara Geller**
* **Ansel Sermersheim**


### License

This application is released under the GPL 2 license. For more information refer to the LICENSE file provided with this
project.


### References

 * Website:  https://www.copperspice.com
 * Twitter:  https://twitter.com/copperspice_cpp
 * Email:    info@copperspice.com

<!-- -->
 * Github:   https://github.com/copperspice

<!-- -->
 * Forum:    https://forum.copperspice.com
 * Journal:  https://journal.copperspice.com
