## KitchenSink

### Introduction

KitchenSink is a standalone program which combines multiple demos in one executable. The purpose of KitchenSink is to
demonstrate the capabilities and functionality of the CopperSpice libraries. These demos are basic examples and the
code is intentionally simplistic and not optimized.


### Binary Files

KitchenSink prebuilt binaries are available for all supported platforms.

https://download.copperspice.com/kitchensink/binary/

CopperSpice prebuilt binaries are available for all supported platforms.

https://github.com/copperspice/copperspice/releases/
https://download.copperspice.com/copperspice/binary/


### System Requirements

Building KitchenSink requires a C++20 compiler and a C++20 standard library. You will also need a current copy of the
CopperSpice libraries. KitchenSink links with CsCore, CsGui, CsMultimedia, CsNetwork, CsOpenGl, CsSql, CsSvg, CsXml,
and CsXmlPatterns.

CMake build files are provided with the source distribution to build this application.


###### OpenSSL

If you are using a version of CopperSpice which has OpenSSL enabled the OpenSSL library files must be copied to your
KitchenSink deployment folder or available in your path.


### Documentation

Information about KitchenSink can be found on our web site.

https://www.copperspice.com/documentation-kitchensink.html


### Presentations

Our YouTube channel contains over 75 videos about C++, programming fundamentals, Unicode/Strings, multithreading,
graphics, CopperSpice, DoxyPress, and other software development topics.

https://www.youtube.com/copperspice

Links to additional videos can be found on our website.

https://www.copperspice.com/presentations.html


### Authors / Contributors

* **Barbara Geller**
* **Ansel Sermersheim**
* **Zbigniew Skowron**
* **Daniel Pfeifer**
* **Jan Wilmans**
* **Tim van Deurzen**


### License

This program is released under the 2-Clause BSD license. For more information refer to the LICENSE file provided with
this project.


### References

 * Website:  https://www.copperspice.com
 * Twitter:  https://twitter.com/copperspice_cpp
 * Email:    info@copperspice.com

<!-- -->
 * Github:   https://github.com/copperspice

<!-- -->
 * Forum:    https://forum.copperspice.com
 * Journal:  https://journal.copperspice.com
