/***********************************************************************
*
* Copyright (c) 2012-2026 Barbara Geller
* Copyright (c) 2012-2026 Ansel Sermersheim
*
* Copyright (c) 2015 The Qt Company Ltd.
*
* This file is part of KitchenSink.
*
* KitchenSink is free software which is released under the BSD 2-Clause license.
* For license details refer to the LICENSE provided with this project.
*
* KitchenSink is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://opensource.org/licenses/BSD-2-Clause
*
***********************************************************************/

#include "volumebutton.h"

#include <QAbstractSlider>
#include <QBoxLayout>
#include <QHBoxLayout>
#include <QStyle>
#include <QStyleFactory>
#include <QWidgetAction>

VolumeButton::VolumeButton(QWidget *parent)
   : QToolButton(parent)
{
   setIcon(style()->standardIcon(QStyle::SP_MediaVolume));
   setPopupMode(QToolButton::InstantPopup);

   QWidget *popup = new QWidget(this);

   slider = new QSlider(Qt::Horizontal, popup);
   slider->setRange(0, 100);
   slider->setStyle(QStyleFactory::create("Fusion"));
   connect(slider, &QAbstractSlider::valueChanged, this, &VolumeButton::volumeChanged);

   label = new QLabel(popup);
   label->setAlignment(Qt::AlignCenter);
   label->setNum(100);
   label->setMinimumWidth(label->sizeHint().width());

   // cs_mp_cast is required since this slot is overloaded
   connect(slider, &QAbstractSlider::valueChanged, label, cs_mp_cast<int>(&QLabel::setNum));

   QBoxLayout *popupLayout = new QHBoxLayout(popup);
   popupLayout->setMargin(2);
   popupLayout->addWidget(slider);
   popupLayout->addWidget(label);

   QWidgetAction *action = new QWidgetAction(this);
   action->setDefaultWidget(popup);

   menu = new QMenu(this);
   menu->addAction(action);
   setMenu(menu);
}

void VolumeButton::increaseVolume()
{
   slider->triggerAction(QSlider::SliderPageStepAdd);
}

void VolumeButton::descreaseVolume()
{
   slider->triggerAction(QSlider::SliderPageStepSub);
}

int VolumeButton::volume() const
{
   return slider->value();
}

void VolumeButton::setVolume(int volume)
{
   slider->setValue(volume);
}
