/***********************************************************************
*
* Copyright (c) 2012-2026 Barbara Geller
* Copyright (c) 2012-2026 Ansel Sermersheim
*
* Copyright (c) 2015 The Qt Company Ltd.
*
* This file is part of KitchenSink.
*
* KitchenSink is free software which is released under the BSD 2-Clause license.
* For license details refer to the LICENSE provided with this project.
*
* KitchenSink is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://opensource.org/licenses/BSD-2-Clause
*
***********************************************************************/

#include "draglabel.h"

#include <QFont>
#include <QLinearGradient>
#include <QPainter>

DragLabel::DragLabel(const QString &text, QWidget *parent)
   : QLabel(parent)
{
   QFontMetrics metric(font());
   QSize size = metric.size(Qt::TextSingleLine, text);

   QImage image(size.width() + 12, size.height() + 12, QImage::Format_ARGB32_Premultiplied);
   image.fill(qRgba(0, 0, 0, 0));

   QFont font;
   font.setStyleStrategy(QFont::ForceOutline);

   QLinearGradient gradient(0, 0, 0, image.height() - 1);
   gradient.setColorAt(0.0, Qt::white);
   gradient.setColorAt(0.2, QColor(200, 200, 255));
   gradient.setColorAt(0.8, QColor(200, 200, 255));
   gradient.setColorAt(1.0, QColor(127, 127, 200));

   QPainter painter;
   painter.begin(&image);
   painter.setRenderHint(QPainter::Antialiasing);
   painter.setBrush(gradient);
   painter.drawRoundedRect(QRectF(0.5, 0.5, image.width() - 1, image.height() - 1),
               25, 25, Qt::RelativeSize);

   painter.setFont(font);
   painter.setBrush(Qt::black);
   painter.drawText(QRect(QPoint(6, 6), size), Qt::AlignCenter, text);
   painter.end();

   setPixmap(QPixmap::fromImage(image));
   m_labelText = text;
}

QString DragLabel::labelText() const
{
   return m_labelText;
}
