/***********************************************************************
*
* Copyright (c) 2012-2026 Barbara Geller
* Copyright (c) 2012-2026 Ansel Sermersheim
*
* Copyright (c) 2015 The Qt Company Ltd.
*
* This file is part of KitchenSink.
*
* KitchenSink is free software which is released under the BSD 2-Clause license.
* For license details refer to the LICENSE provided with this project.
*
* KitchenSink is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* https://opensource.org/licenses/BSD-2-Clause
*
***********************************************************************/

#include "connection.h"
#include "server.h"

Server::Server(QObject *parent)
   : QTcpServer(parent)
{
   listen(QHostAddress::Any);
}

void Server::incomingConnection(qintptr socketDescriptor)
{
   Connection *connection = new Connection(this);
   connection->setSocketDescriptor(socketDescriptor);

   emit newConnection(connection);
}
